/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.telemetry;

import java.util.Objects;
import java.util.Optional;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.telemetry.SpanCategory;

public class InfinispanSpanAttributes {
    private final String cacheName;
    private final Configuration cacheConfiguration;
    private final SpanCategory category;

    private InfinispanSpanAttributes(String cacheName, Configuration cacheConfiguration, SpanCategory category) {
        this.cacheName = cacheName;
        this.cacheConfiguration = cacheConfiguration;
        this.category = category;
    }

    public Optional<String> cacheName() {
        return Optional.ofNullable(this.cacheName);
    }

    public SpanCategory category() {
        return this.category;
    }

    public boolean isCategoryDisabled() {
        if (this.cacheConfiguration == null) {
            return false;
        }
        return !this.cacheConfiguration.tracing().enabled(this.category);
    }

    public static class Builder {
        private String cacheName;
        private Configuration cacheConfiguration;
        private SpanCategory category;

        public Builder(SpanCategory category) {
            this.category = Objects.requireNonNull(category);
        }

        public Builder withCache(String cacheName, Configuration cacheConfiguration) {
            this.cacheName = cacheName;
            this.cacheConfiguration = cacheConfiguration;
            return this;
        }

        public Builder withCacheName(String cacheName) {
            this.cacheName = cacheName;
            return this;
        }

        public InfinispanSpanAttributes build() {
            return new InfinispanSpanAttributes(this.cacheName, this.cacheConfiguration, this.category);
        }
    }
}

