/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.trogdor.coordinator.Coordinator;
import org.apache.kafka.trogdor.rest.CoordinatorShutdownRequest;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateTaskRequest;
import org.apache.kafka.trogdor.rest.DestroyTaskRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.StopTaskRequest;
import org.apache.kafka.trogdor.rest.TaskRequest;
import org.apache.kafka.trogdor.rest.TaskState;
import org.apache.kafka.trogdor.rest.TaskStateType;
import org.apache.kafka.trogdor.rest.TasksRequest;
import org.apache.kafka.trogdor.rest.TasksResponse;
import org.apache.kafka.trogdor.rest.UptimeResponse;

@Path(value="/coordinator")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CoordinatorRestResource {
    private final AtomicReference<Coordinator> coordinator = new AtomicReference();
    @Context
    private ServletContext context;

    public void setCoordinator(Coordinator myCoordinator) {
        this.coordinator.set(myCoordinator);
    }

    @GET
    @Path(value="/status")
    public CoordinatorStatusResponse status() throws Throwable {
        return this.coordinator().status();
    }

    @GET
    @Path(value="/uptime")
    public UptimeResponse uptime() {
        return this.coordinator().uptime();
    }

    @POST
    @Path(value="/task/create")
    public Empty createTask(CreateTaskRequest request) throws Throwable {
        this.coordinator().createTask(request);
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/task/stop")
    public Empty stopTask(StopTaskRequest request) throws Throwable {
        this.coordinator().stopTask(request);
        return Empty.INSTANCE;
    }

    @DELETE
    @Path(value="/tasks")
    public Empty destroyTask(@DefaultValue(value="") @QueryParam(value="taskId") String taskId) throws Throwable {
        this.coordinator().destroyTask(new DestroyTaskRequest(taskId));
        return Empty.INSTANCE;
    }

    @GET
    @Path(value="/tasks/")
    public Response tasks(@QueryParam(value="taskId") List<String> taskId, @DefaultValue(value="0") @QueryParam(value="firstStartMs") long firstStartMs, @DefaultValue(value="0") @QueryParam(value="lastStartMs") long lastStartMs, @DefaultValue(value="0") @QueryParam(value="firstEndMs") long firstEndMs, @DefaultValue(value="0") @QueryParam(value="lastEndMs") long lastEndMs, @DefaultValue(value="") @QueryParam(value="state") String state) throws Throwable {
        boolean isEmptyState = state.isEmpty();
        if (!isEmptyState && !TaskStateType.Constants.VALUES.contains(state)) {
            return Response.status((int)400).entity((Object)String.format("State %s is invalid. Must be one of %s", state, TaskStateType.Constants.VALUES)).build();
        }
        Optional<TaskStateType> givenState = Optional.ofNullable(isEmptyState ? null : TaskStateType.valueOf(state));
        TasksResponse resp = this.coordinator().tasks(new TasksRequest(taskId, firstStartMs, lastStartMs, firstEndMs, lastEndMs, givenState));
        return Response.status((int)200).entity((Object)resp).build();
    }

    @GET
    @Path(value="/tasks/{taskId}")
    public TaskState tasks(@PathParam(value="taskId") String taskId) throws Throwable {
        TaskState response = this.coordinator().task(new TaskRequest(taskId));
        if (response == null) {
            throw new NotFoundException(String.format("No task with ID \"%s\" exists.", taskId));
        }
        return response;
    }

    @PUT
    @Path(value="/shutdown")
    public Empty beginShutdown(CoordinatorShutdownRequest request) throws Throwable {
        this.coordinator().beginShutdown(request.stopAgents());
        return Empty.INSTANCE;
    }

    private Coordinator coordinator() {
        Coordinator myCoordinator = this.coordinator.get();
        if (myCoordinator == null) {
            throw new RuntimeException("CoordinatorRestResource has not been initialized yet.");
        }
        return myCoordinator;
    }
}

