/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Base class for SimpleITK classes based on ProcessObject.

C++ includes: sitkProcessObject.h
*/
public class ProcessObject {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected ProcessObject(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ProcessObject obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ProcessObject obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ProcessObject::~ProcessObject()

Default Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ProcessObject(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
virtual std::string itk::simple::ProcessObject::ToString() const
*/
public  String toString() {
    return SimpleITKJNI.ProcessObject_toString(swigCPtr, this);
  }

  /**
virtual std::string itk::simple::ProcessObject::GetName() const =0

return user readable name for the filter

*/
public  String getName() {
    return SimpleITKJNI.ProcessObject_getName(swigCPtr, this);
  }

  public void debugOn() {
    SimpleITKJNI.ProcessObject_debugOn(swigCPtr, this);
  }

  public void debugOff() {
    SimpleITKJNI.ProcessObject_debugOff(swigCPtr, this);
  }

  public boolean getDebug() {
    return SimpleITKJNI.ProcessObject_getDebug(swigCPtr, this);
  }

  public void setDebug(boolean debugFlag) {
    SimpleITKJNI.ProcessObject_setDebug(swigCPtr, this, debugFlag);
  }

  public static void globalDefaultDebugOn() {
    SimpleITKJNI.ProcessObject_globalDefaultDebugOn();
  }

  public static void globalDefaultDebugOff() {
    SimpleITKJNI.ProcessObject_globalDefaultDebugOff();
  }

  public static boolean getGlobalDefaultDebug() {
    return SimpleITKJNI.ProcessObject_getGlobalDefaultDebug();
  }

  public static void setGlobalDefaultDebug(boolean debugFlag) {
    SimpleITKJNI.ProcessObject_setGlobalDefaultDebug(debugFlag);
  }

  public static void globalWarningDisplayOn() {
    SimpleITKJNI.ProcessObject_globalWarningDisplayOn();
  }

  public static void globalWarningDisplayOff() {
    SimpleITKJNI.ProcessObject_globalWarningDisplayOff();
  }

  public static void setGlobalWarningDisplay(boolean flag) {
    SimpleITKJNI.ProcessObject_setGlobalWarningDisplay(flag);
  }

  public static boolean getGlobalWarningDisplay() {
    return SimpleITKJNI.ProcessObject_getGlobalWarningDisplay();
  }

  public static double getGlobalDefaultCoordinateTolerance() {
    return SimpleITKJNI.ProcessObject_getGlobalDefaultCoordinateTolerance();
  }

  public static void setGlobalDefaultCoordinateTolerance(double arg0) {
    SimpleITKJNI.ProcessObject_setGlobalDefaultCoordinateTolerance(arg0);
  }

  public static double getGlobalDefaultDirectionTolerance() {
    return SimpleITKJNI.ProcessObject_getGlobalDefaultDirectionTolerance();
  }

  public static void setGlobalDefaultDirectionTolerance(double arg0) {
    SimpleITKJNI.ProcessObject_setGlobalDefaultDirectionTolerance(arg0);
  }

  public static boolean setGlobalDefaultThreader(String threader) {
    return SimpleITKJNI.ProcessObject_setGlobalDefaultThreader(threader);
  }

  public static String getGlobalDefaultThreader() {
    return SimpleITKJNI.ProcessObject_getGlobalDefaultThreader();
  }

  public static void setGlobalDefaultNumberOfThreads(long n) {
    SimpleITKJNI.ProcessObject_setGlobalDefaultNumberOfThreads(n);
  }

  public static long getGlobalDefaultNumberOfThreads() {
    return SimpleITKJNI.ProcessObject_getGlobalDefaultNumberOfThreads();
  }

  public void setNumberOfThreads(long n) {
    SimpleITKJNI.ProcessObject_setNumberOfThreads(swigCPtr, this, n);
  }

  public long getNumberOfThreads() {
    return SimpleITKJNI.ProcessObject_getNumberOfThreads(swigCPtr, this);
  }

  public void setNumberOfWorkUnits(long n) {
    SimpleITKJNI.ProcessObject_setNumberOfWorkUnits(swigCPtr, this, n);
  }

  public long getNumberOfWorkUnits() {
    return SimpleITKJNI.ProcessObject_getNumberOfWorkUnits(swigCPtr, this);
  }

  /**
virtual int itk::simple::ProcessObject::AddCommand(itk::simple::EventEnum event, itk::simple::Command &amp;cmd)

Add a Command Object to observer the event.


The Command object's Execute method will be invoked when the internal ITK Object has the event. These events only occur during this ProcessObject's Execute method when the ITK filter is running. The command occurs
in the same thread as this objects Execute methods was called in.

An internal reference is made between the Command and this ProcessObject which enable automatic removal of the command when deleted. This
enables both object to exist as stack based object and be
automatically cleaned up.

Unless specified otherwise, it's safe to get any value during
execution. "Measurements" will have valid values only after the
Execute method has returned. "Active Measurements" will have valid
values during events, and access the underlying ITK object.

Deleting a command this object has during a command call-back will
produce undefined behavior.

For more information see the page CommandPage.


The return value is reserved for latter usage.


*/
public  int addCommand(EventEnum event, Command cmd) {
    return SimpleITKJNI.ProcessObject_addCommand(swigCPtr, this, event.swigValue(), Command.getCPtr(cmd), cmd);
  }

  /**
virtual void itk::simple::ProcessObject::RemoveAllCommands()

Remove all registered commands.


Calling when this object is invoking anther command will produce
undefined behavior.

*/
public  void removeAllCommands() {
    SimpleITKJNI.ProcessObject_removeAllCommands(swigCPtr, this);
  }

  /**
virtual bool itk::simple::ProcessObject::HasCommand(itk::simple::EventEnum event) const

Query of this object has any registered commands for event.

*/
public  boolean hasCommand(EventEnum event) {
    return SimpleITKJNI.ProcessObject_hasCommand(swigCPtr, this, event.swigValue());
  }

  /**
virtual float itk::simple::ProcessObject::GetProgress() const

An Active Measurement of the progress of execution.


Get the execution progress of the current process object. The progress
is a floating number in [0,1] with 0 meaning no progress and 1 meaning
the filter has completed execution (or aborted).

This is an Active Measurement so it can be accessed during Events
during the execution.

*/
public  float getProgress() {
    return SimpleITKJNI.ProcessObject_getProgress(swigCPtr, this);
  }

  /**
virtual void itk::simple::ProcessObject::Abort()

Sets an abort flag on the active process.

Requests the current active process to abort. Additional, progress or
iteration event may occur. If aborted then, an AbortEvent should
occur. The Progress should be set to 1.0 after aborting.

The expected behavior is that not exception should be throw out of
this processes Execute method. Additionally, the results returned are
valid but undefined content. The content may be only partially
updated, uninitialized or the a of size zero.

If there is no active process the method has no effect.

*/
public  void abort() {
    SimpleITKJNI.ProcessObject_abort(swigCPtr, this);
  }

}
