/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.lucene103.blocktree.TrieBuilder;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

class TrieReader {
    private static final long NO_OUTPUT = -1L;
    private static final long NO_FLOOR_DATA = -1L;
    private static final long[] BYTES_MINUS_1_MASK = new long[]{255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    final RandomAccessInput access;
    final IndexInput input;
    final Node root;

    TrieReader(IndexInput input, long rootFP) throws IOException {
        this.access = input.randomAccessSlice(0L, input.length());
        this.input = input;
        this.root = new Node();
        this.load(this.root, rootFP);
    }

    private void load(Node node, long fp) throws IOException {
        node.fp = fp;
        long termFlagsLong = this.access.readLong(fp);
        int termFlags = (int)termFlagsLong;
        node.sign = termFlags & 3;
        int sign = node.sign;
        if (sign == 0) {
            this.loadLeafNode(fp, termFlags, termFlagsLong, node);
        } else if (sign == 3) {
            this.loadMultiChildrenNode(fp, termFlags, termFlagsLong, node);
        } else {
            this.loadSingleChildNode(fp, sign, termFlags, termFlagsLong, node);
        }
    }

    private void loadLeafNode(long fp, int term, long termLong, Node node) throws IOException {
        int fpBytesMinus1 = term >>> 2 & 7;
        node.outputFp = fpBytesMinus1 <= 6 ? termLong >>> 8 & BYTES_MINUS_1_MASK[fpBytesMinus1] : this.access.readLong(fp + 1L);
        node.hasTerms = (term & 0x20) != 0;
        node.floorDataFp = (term & 0x40) != 0 ? fp + 2L + (long)fpBytesMinus1 : -1L;
    }

    private void loadSingleChildNode(long fp, int sign, int term, long termLong, Node node) throws IOException {
        int childDeltaFpBytesMinus1 = term >>> 2 & 7;
        long l = childDeltaFpBytesMinus1 <= 5 ? termLong >>> 16 : this.access.readLong(fp + 2L);
        node.childDeltaFp = l & BYTES_MINUS_1_MASK[childDeltaFpBytesMinus1];
        node.minChildrenLabel = term >>> 8 & 0xFF;
        if (sign == 2) {
            node.outputFp = -1L;
        } else {
            assert (sign == 1);
            int encodedOutputFpBytesMinus1 = term >>> 5 & 7;
            long offset = fp + (long)childDeltaFpBytesMinus1 + 3L;
            long encodedFp = this.access.readLong(offset) & BYTES_MINUS_1_MASK[encodedOutputFpBytesMinus1];
            node.outputFp = encodedFp >>> 2;
            node.hasTerms = (encodedFp & 2L) != 0L;
            node.floorDataFp = (encodedFp & 1L) != 0L ? offset + (long)encodedOutputFpBytesMinus1 + 1L : -1L;
        }
    }

    private void loadMultiChildrenNode(long fp, int term, long termLong, Node node) throws IOException {
        node.childrenDeltaFpBytes = (term >>> 2 & 7) + 1;
        node.childSaveStrategy = term >>> 9 & 3;
        node.strategyBytes = (term >>> 11 & 0x1F) + 1;
        node.minChildrenLabel = term >>> 16 & 0xFF;
        if ((term & 0x20) != 0) {
            int encodedOutputFpBytesMinus1 = term >>> 6 & 7;
            long l = encodedOutputFpBytesMinus1 <= 4 ? termLong >>> 24 : this.access.readLong(fp + 3L);
            long encodedFp = l & BYTES_MINUS_1_MASK[encodedOutputFpBytesMinus1];
            node.outputFp = encodedFp >>> 2;
            boolean bl = node.hasTerms = (encodedFp & 2L) != 0L;
            if ((encodedFp & 1L) != 0L) {
                long offset = fp + 4L + (long)encodedOutputFpBytesMinus1;
                long childrenNum = ((long)this.access.readByte(offset) & 0xFFL) + 1L;
                node.strategyFp = offset + 1L;
                node.floorDataFp = node.strategyFp + (long)node.strategyBytes + childrenNum * (long)node.childrenDeltaFpBytes;
            } else {
                node.floorDataFp = -1L;
                node.strategyFp = fp + 4L + (long)encodedOutputFpBytesMinus1;
            }
        } else {
            node.outputFp = -1L;
            node.strategyFp = fp + 3L;
        }
    }

    Node lookupChild(int targetLabel, Node parent, Node child) throws IOException {
        int sign = parent.sign;
        if (sign == 0) {
            return null;
        }
        if (sign != 3) {
            if (targetLabel != parent.minChildrenLabel) {
                return null;
            }
            child.label = targetLabel;
            this.load(child, parent.fp - parent.childDeltaFp);
            return child;
        }
        long strategyBytesStartFp = parent.strategyFp;
        int minLabel = parent.minChildrenLabel;
        int strategyBytes = parent.strategyBytes;
        int position = -1;
        if (targetLabel == minLabel) {
            position = 0;
        } else if (targetLabel > minLabel) {
            position = TrieBuilder.ChildSaveStrategy.byCode(parent.childSaveStrategy).lookup(targetLabel, this.access, strategyBytesStartFp, strategyBytes, minLabel);
        }
        if (position < 0) {
            return null;
        }
        int bytesPerEntry = parent.childrenDeltaFpBytes;
        long pos = strategyBytesStartFp + (long)strategyBytes + (long)bytesPerEntry * (long)position;
        long fp = parent.fp - (this.access.readLong(pos) & BYTES_MINUS_1_MASK[bytesPerEntry - 1]);
        child.label = targetLabel;
        this.load(child, fp);
        return child;
    }

    static class Node {
        private long childDeltaFp;
        private long strategyFp;
        private int childSaveStrategy;
        private int strategyBytes;
        private int childrenDeltaFpBytes;
        private int sign;
        private long fp;
        private int minChildrenLabel;
        int label;
        long outputFp;
        boolean hasTerms;
        long floorDataFp;

        Node() {
        }

        boolean hasOutput() {
            return this.outputFp != -1L;
        }

        boolean isFloor() {
            return this.floorDataFp != -1L;
        }

        IndexInput floorData(TrieReader r) throws IOException {
            assert (this.isFloor());
            r.input.seek(this.floorDataFp);
            return r.input;
        }
    }
}

