/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public final class BuildingTargetProgressMessage
extends BuildMessage {
    private final Collection<? extends BuildTarget<?>> myTargets;
    @NotNull
    private final Event myEventType;

    public BuildingTargetProgressMessage(@NotNull Collection<? extends BuildTarget<?>> targets, @NotNull Event event) {
        if (targets == null) {
            BuildingTargetProgressMessage.$$$reportNull$$$0(0);
        }
        if (event == null) {
            BuildingTargetProgressMessage.$$$reportNull$$$0(1);
        }
        super(BuildingTargetProgressMessage.composeMessageText(targets, event), BuildMessage.Kind.PROGRESS);
        this.myTargets = targets;
        this.myEventType = event;
    }

    private static String composeMessageText(Collection<? extends BuildTarget<?>> targets, Event event) {
        String targetsString = StringUtil.join(targets, dom -> dom.getPresentableName(), (String)", ");
        return (event == Event.STARTED ? "Started" : "Finished") + " building " + targetsString;
    }

    @NotNull
    public Collection<? extends BuildTarget<?>> getTargets() {
        Collection<? extends BuildTarget<?>> collection = this.myTargets;
        if (collection == null) {
            BuildingTargetProgressMessage.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Event getEventType() {
        Event event = this.myEventType;
        if (event == null) {
            BuildingTargetProgressMessage.$$$reportNull$$$0(3);
        }
        return event;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/messages/BuildingTargetProgressMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/messages/BuildingTargetProgressMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Event {
        STARTED,
        FINISHED;

    }
}

