/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;

class CompatDeclarationSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, StyleValue> overrideMap = new HashMap();
    private final HashMap<String, Boolean> overridePrio = new HashMap();
    private final HashMap<String, StyleValue> nonOverrideMap = new HashMap();
    private final HashMap<String, ShorthandValue> compatShorthandMap = new HashMap();
    private final HashMap<String, ShorthandValue> nonOvShorthandMap = new HashMap();

    CompatDeclarationSet() {
    }

    CompatDeclarationSet(CompatDeclarationSet copiedObject) {
        this.overrideMap.putAll(copiedObject.overrideMap);
        this.overridePrio.putAll(copiedObject.overridePrio);
        this.nonOverrideMap.putAll(copiedObject.nonOverrideMap);
        this.compatShorthandMap.putAll(copiedObject.compatShorthandMap);
        this.nonOvShorthandMap.putAll(copiedObject.nonOvShorthandMap);
    }

    void setCompatLonghand(String propertyName, StyleValue override, boolean priorityImportant, boolean isOverride) {
        if (isOverride) {
            this.overrideMap.put(propertyName, override);
            this.overridePrio.put(propertyName, priorityImportant);
            this.nonOverrideMap.remove(propertyName);
        } else if (CompatDeclarationSet.isPriorityCompat(override)) {
            this.nonOverrideMap.put(propertyName, override);
        }
    }

    boolean setCompatShorthand(String propertyName, LexicalUnit value, boolean important, LinkedList<String> shadowedShorthands) {
        if (CompatDeclarationSet.containsIdentCompat(value)) {
            String cssText = value.toString();
            ShorthandValue shorthand = new ShorthandValue(value, important);
            shorthand.setShorthandText(cssText, LexicalValue.serializeMinifiedSequence(value));
            if (shadowedShorthands != null && shadowedShorthands.contains(propertyName)) {
                this.compatShorthandMap.put(propertyName, shorthand);
                this.nonOvShorthandMap.remove(propertyName);
            } else if (shorthand.isPriorityCompat()) {
                this.nonOvShorthandMap.put(propertyName, shorthand);
            }
            return true;
        }
        return false;
    }

    private static boolean containsIdentCompat(LexicalUnit value) {
        while (value != null) {
            LexicalUnit.LexicalType type = value.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.COMPAT_IDENT || type == LexicalUnit.LexicalType.COMPAT_PRIO) {
                return true;
            }
            if (type == LexicalUnit.LexicalType.FUNCTION) {
                return CompatDeclarationSet.containsIdentCompat(value.getParameters());
            }
            if (type == LexicalUnit.LexicalType.SUB_EXPRESSION) {
                return CompatDeclarationSet.containsIdentCompat(value.getSubValues());
            }
            value = value.getNextLexicalUnit();
        }
        return false;
    }

    static boolean isPriorityCompat(StyleValue compatvalue) {
        return compatvalue.getPrimitiveType() == CSSValue.Type.UNKNOWN && ((UnknownValue)compatvalue).isPriorityCompat();
    }

    static void appendIEPrioCharShorthandMinifiedCssText(StringBuilder sb, String shorthandName, ShorthandValue compatvalue) {
        sb.append(shorthandName).append(':').append(compatvalue.getMinifiedCssText(shorthandName));
        sb.append("!important!;");
    }

    static void writeIEPrioCharShorthandCssText(SimpleWriter wri, StyleFormattingContext context, String shorthandName, ShorthandValue compatvalue) throws IOException {
        wri.write((CharSequence)shorthandName);
        context.writeColon(wri);
        wri.write((CharSequence)compatvalue.getCssText());
        wri.write((CharSequence)"!important!");
        context.writeSemiColon(wri);
    }

    static void writeIEPrioCharLonghandCssText(SimpleWriter wri, StyleFormattingContext context, String ptyname, StyleValue compatvalue) throws IOException {
        wri.write((CharSequence)ptyname);
        context.writeColon(wri);
        compatvalue.writeCssText(wri);
        wri.write((CharSequence)"!important!");
        context.writeSemiColon(wri);
    }

    ShorthandValue getCompatShorthand(String shorthandName) {
        return this.compatShorthandMap.get(shorthandName);
    }

    boolean isCompatShorthand(String shorthandName) {
        return this.compatShorthandMap.containsKey(shorthandName);
    }

    boolean isCompatLonghand(String ptyname) {
        return this.overrideMap.containsKey(ptyname);
    }

    StyleValue getCompatLonghand(String ptyname) {
        return this.overrideMap.get(ptyname);
    }

    boolean isImportantCompatLonghand(String ptyname) {
        return this.overridePrio.get(ptyname);
    }

    ShorthandValue getNonOvCompatShorthand(String shorthandName) {
        return this.nonOvShorthandMap.get(shorthandName);
    }

    StyleValue getNonOvCompatLonghand(String ptyname) {
        return this.nonOverrideMap.get(ptyname);
    }

    public void clear() {
        this.overrideMap.clear();
        this.overridePrio.clear();
        this.nonOverrideMap.clear();
        this.compatShorthandMap.clear();
        this.nonOvShorthandMap.clear();
    }

    public CompatDeclarationSet clone() {
        return new CompatDeclarationSet(this);
    }
}

