##  <#GAPDoc Label="QuickstartZ">
##  <Section Label="QuickstartZ">
##  <Heading>Localization of &ZZ;</Heading>
##  The following example is taken from Section 2 of <Cite Key="BREACA"/>. <Br/><Br/>
##  The computation takes place over the local ring <M>R=&ZZ;_{\langle 2\rangle}</M>
##  (i.e. &ZZ; localized at the maximal ideal generated by <M>2</M>). <P/>
##  Here we compute the (infinite) long exact homology sequence of the
##  covariant functor <M>Hom(Hom(-,R/2^7R),R/2^4R)</M> (and its left derived functors)
##  applied to the short exact sequence<Br/><Br/>
##  <Alt Not="Text,HTML"><Math>0 \longrightarrow M\_=R/2^2R \stackrel{\alpha_1}{\longrightarrow}
##  M=R/2^5R \stackrel{\alpha_2}{\longrightarrow} \_M=R/2^3R \longrightarrow 0</Math></Alt>
##  <Alt Only="Text,HTML"><M>0 -> M_=R/2^2R --alpha_1--> M=R/2^5R --alpha_2--> \_M=R/2^3R -> 0</M></Alt>.
##  <P/>We want to lead your attention to the commands <K>LocalizeAt</K> and <K>HomalgLocalMatrix</K>. The first one creates a localized ring from a global one and generators of a maximal ideal and the second one creates a local matrix from a global matrix. The other commands used here are well known from &homalg;.
##  <Example>
##    <![CDATA[
##  gap> LoadPackage( "LocalizeRingForHomalg" );;
##  gap> zz := HomalgRingOfIntegers(  );
##  Z
##  gap> R := LocalizeAt( zz , [ 2 ] );
##  Z_< 2 >
##  gap> Display( R );
##  <A local ring>
##  gap> LoadPackage( "Modules" );
##  true
##  gap> M := LeftPresentation( HomalgMatrix( [ 2^5 ], R ) );
##  <A cyclic left module presented by 1 relation for a cyclic generator>
##  gap> _M := LeftPresentation( HomalgMatrix( [ 2^3 ], R ) );
##  <A cyclic left module presented by 1 relation for a cyclic generator>
##  gap> alpha2 := HomalgMap( HomalgMatrix( [ 1 ], R ), M, _M );
##  <A "homomorphism" of left modules>
##  gap> M_ := Kernel( alpha2 );
##  <A cyclic left module presented by yet unknown relations for a cyclic generato\
##  r>
##  gap> alpha1 := KernelEmb( alpha2 );
##  <A monomorphism of left modules>
##  gap> Display( M_ );
##  Z_< 2 >/< -4/1 >
##  gap> Display( alpha1 );
##  [ [  8 ] ]
##  / 1
##  
##  the map is currently represented by the above 1 x 1 matrix
##  gap> ByASmallerPresentation( M_ );
##  <A cyclic left module presented by 1 relation for a cyclic generator>
##  gap> Display( M_ );
##  Z_< 2 >/< 4/1 >
##  ]]></Example>
##  </Section>
##  <#/GAPDoc>

LoadPackage( "LocalizeRingForHomalg" );;
zz := HomalgRingOfIntegers(  );;
R := LocalizeAt( zz , [ 2 ] );

LoadPackage( "Modules" );
M := LeftPresentation( HomalgMatrix( [ 2^5 ], R ) );
_M := LeftPresentation( HomalgMatrix( [ 2^3 ], R ) );
alpha2 := HomalgMap( HomalgMatrix( [ 1 ], R ), M, _M );
M_ := Kernel( alpha2 );
alpha1 := KernelEmb( alpha2 );
Display( M_ );
Display( alpha1 );
ByASmallerPresentation( M_ );
Display( M_ );
