﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotevents-data/IoTEventsDataRequest.h>
#include <aws/iotevents-data/IoTEventsData_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoTEventsData {
namespace Model {

/**
 */
class DescribeAlarmRequest : public IoTEventsDataRequest {
 public:
  AWS_IOTEVENTSDATA_API DescribeAlarmRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeAlarm"; }

  AWS_IOTEVENTSDATA_API Aws::String SerializePayload() const override;

  AWS_IOTEVENTSDATA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the alarm model.</p>
   */
  inline const Aws::String& GetAlarmModelName() const { return m_alarmModelName; }
  inline bool AlarmModelNameHasBeenSet() const { return m_alarmModelNameHasBeenSet; }
  template <typename AlarmModelNameT = Aws::String>
  void SetAlarmModelName(AlarmModelNameT&& value) {
    m_alarmModelNameHasBeenSet = true;
    m_alarmModelName = std::forward<AlarmModelNameT>(value);
  }
  template <typename AlarmModelNameT = Aws::String>
  DescribeAlarmRequest& WithAlarmModelName(AlarmModelNameT&& value) {
    SetAlarmModelName(std::forward<AlarmModelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The value of the key used as a filter to select only the alarms associated
   * with the <a
   * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key">key</a>.</p>
   */
  inline const Aws::String& GetKeyValue() const { return m_keyValue; }
  inline bool KeyValueHasBeenSet() const { return m_keyValueHasBeenSet; }
  template <typename KeyValueT = Aws::String>
  void SetKeyValue(KeyValueT&& value) {
    m_keyValueHasBeenSet = true;
    m_keyValue = std::forward<KeyValueT>(value);
  }
  template <typename KeyValueT = Aws::String>
  DescribeAlarmRequest& WithKeyValue(KeyValueT&& value) {
    SetKeyValue(std::forward<KeyValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_alarmModelName;

  Aws::String m_keyValue;
  bool m_alarmModelNameHasBeenSet = false;
  bool m_keyValueHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTEventsData
}  // namespace Aws
