﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/acm-pca/ACMPCA_EXPORTS.h>
#include <aws/acm-pca/model/AuditReportStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ACMPCA {
namespace Model {
class DescribeCertificateAuthorityAuditReportResult {
 public:
  AWS_ACMPCA_API DescribeCertificateAuthorityAuditReportResult() = default;
  AWS_ACMPCA_API DescribeCertificateAuthorityAuditReportResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ACMPCA_API DescribeCertificateAuthorityAuditReportResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Specifies whether report creation is in progress, has succeeded, or has
   * failed.</p>
   */
  inline AuditReportStatus GetAuditReportStatus() const { return m_auditReportStatus; }
  inline void SetAuditReportStatus(AuditReportStatus value) {
    m_auditReportStatusHasBeenSet = true;
    m_auditReportStatus = value;
  }
  inline DescribeCertificateAuthorityAuditReportResult& WithAuditReportStatus(AuditReportStatus value) {
    SetAuditReportStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Name of the S3 bucket that contains the report.</p>
   */
  inline const Aws::String& GetS3BucketName() const { return m_s3BucketName; }
  template <typename S3BucketNameT = Aws::String>
  void SetS3BucketName(S3BucketNameT&& value) {
    m_s3BucketNameHasBeenSet = true;
    m_s3BucketName = std::forward<S3BucketNameT>(value);
  }
  template <typename S3BucketNameT = Aws::String>
  DescribeCertificateAuthorityAuditReportResult& WithS3BucketName(S3BucketNameT&& value) {
    SetS3BucketName(std::forward<S3BucketNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>S3 <b>key</b> that uniquely identifies the report file in your S3 bucket.</p>
   */
  inline const Aws::String& GetS3Key() const { return m_s3Key; }
  template <typename S3KeyT = Aws::String>
  void SetS3Key(S3KeyT&& value) {
    m_s3KeyHasBeenSet = true;
    m_s3Key = std::forward<S3KeyT>(value);
  }
  template <typename S3KeyT = Aws::String>
  DescribeCertificateAuthorityAuditReportResult& WithS3Key(S3KeyT&& value) {
    SetS3Key(std::forward<S3KeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time at which the report was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  DescribeCertificateAuthorityAuditReportResult& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeCertificateAuthorityAuditReportResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  AuditReportStatus m_auditReportStatus{AuditReportStatus::NOT_SET};

  Aws::String m_s3BucketName;

  Aws::String m_s3Key;

  Aws::Utils::DateTime m_createdAt{};

  Aws::String m_requestId;
  bool m_auditReportStatusHasBeenSet = false;
  bool m_s3BucketNameHasBeenSet = false;
  bool m_s3KeyHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ACMPCA
}  // namespace Aws
