<?xml version='1.0' encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:m="http://www.w3.org/1998/Math/MathML"
                version='1.0'>
                
<!-- ====================================================================== -->
<!-- $Id: entities.xsl,v 1.14 2005/02/28 18:50:45 shade33 Exp $
     This file is part of the XSLT MathML Library distribution.
     See ./README or http://xsltml.sf.net for
     copyright and other information                                        -->
<!-- ====================================================================== -->
<xsl:variable name="apos">'</xsl:variable>

<xsl:template name="replaceEntities">
	<xsl:param name="content"/>
	<xsl:if test="string-length($content)>0">
	<xsl:choose>
		<xsl:when test="starts-with($content,' ')"><xsl:value-of select="'\; '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, ' ')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02009;&#x0200A;&#x0200A;')"><xsl:value-of select="'\; '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02009;&#x0200A;&#x0200A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00023;')"><xsl:value-of select="'\# '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00023;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00024;')"><xsl:value-of select="'\$ '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00024;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00025;')"><xsl:value-of select="'\% '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00025;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00026;')"><xsl:value-of select="'\&amp; '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00026;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0002A;')"><xsl:value-of select="'\ast '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0002A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0003A;')"><xsl:value-of select="'\colon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0003A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0003C;')"><xsl:value-of select="'\less '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0003C;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0003E;')"><xsl:value-of select="'\greater'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0003E;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0005B;')"><xsl:value-of select="'\lbrack '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0005B;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0005C;')"><xsl:value-of select="'\backslash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0005C;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0005D;')"><xsl:value-of select="'\rbrack '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0005D;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0005E;')"><xsl:value-of select="'\textasciicircumflex '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0005E;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0005F;')"><xsl:value-of select="'\_ '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0005F;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00060;')"><xsl:value-of select="'\textasciigrave '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00060;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0007B;')"><xsl:value-of select="'\lbrace '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0007B;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0007C;')"><xsl:value-of select="'\vert '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0007C;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0007D;')"><xsl:value-of select="'\rbrace '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0007D;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0007E;')"><xsl:value-of select="'\textasciitilde '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0007E;')"/></xsl:call-template></xsl:when>

		<xsl:when test="starts-with($content,'&#x0025B;')"><xsl:value-of select="'\varepsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0025B;')"/></xsl:call-template></xsl:when>	<!--/varepsilon -->
		<xsl:when test="starts-with($content,'&#x002D9;')"><xsl:value-of select="'\dot{}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D9;')"/></xsl:call-template></xsl:when>		<!--/DiacriticalDot -->
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	C1 Controls and Latin-1 Supplement
	Range: 0080-00FF
	http://www.unicode.org/charts/PDF/U0080.pdf	                    -->
<!-- ====================================================================== -->
		<xsl:when test="starts-with($content,'&#x000A1;')"><xsl:value-of select="'\textexclamdown '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A1;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000A2;')"><xsl:value-of select="'\mbox{\textcent}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000A3;')"><xsl:value-of select="'\pounds '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A3;')"/></xsl:call-template></xsl:when>	<!--pound sign -->
		<xsl:when test="starts-with($content,'&#x000A4;')"><xsl:value-of select="'\mbox{\textcurrency}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000A5;')"><xsl:value-of select="'\yen '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A5;')"/></xsl:call-template></xsl:when>	<!--/yen =yen sign --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x000A7;')"><xsl:value-of select="'\S '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A7;')"/></xsl:call-template></xsl:when>	<!--section sign -->
		<xsl:when test="starts-with($content,'&#x000A8;')"><xsl:value-of select="'\textasciidieresis '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000A9;')"><xsl:value-of select="'\copyright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000A9;')"/></xsl:call-template></xsl:when>	<!--copyright sign -->
		<xsl:when test="starts-with($content,'&#x000AA;')"><xsl:value-of select="'\textordfeminine '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000AA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000AB;')"><xsl:value-of select="'\mbox{\guillemotleft}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000AB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000AC;')"><xsl:value-of select="'\neg '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000AC;')"/></xsl:call-template></xsl:when>	<!--/neg /lnot =not sign -->
		<xsl:when test="starts-with($content,'&#x000AD;')"><xsl:value-of select="'\- '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000AD;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000AE;')"><xsl:value-of select="'\circledR '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000AE;')"/></xsl:call-template></xsl:when>	<!--/circledR =registered sign --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x000AF;')"><xsl:value-of select="'\textasciimacron '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000AF;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000B0;')"><xsl:value-of select="'\degree '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000B1;')"><xsl:value-of select="'\pm '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B1;')"/></xsl:call-template></xsl:when>	<!--/pm B: =plus-or-minus sign -->
		<xsl:when test="starts-with($content,'&#x000B2;')"><xsl:value-of select="'{^2}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000B3;')"><xsl:value-of select="'{^3}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000B4;')"><xsl:value-of select="'\textasciiacute '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000B5;')"><xsl:value-of select="'\mathrm{\mu}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B5;')"/></xsl:call-template></xsl:when>	<!--=micro sign -->
		<xsl:when test="starts-with($content,'&#x000B6;')"><xsl:value-of select="'\P '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B6;')"/></xsl:call-template></xsl:when>	<!--pilcrow (paragraph sign) -->
		<xsl:when test="starts-with($content,'&#x000B7;')"><xsl:value-of select="'\cdotp '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000B8;')"><xsl:value-of select="'\mbox{\c{}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000B9;')"><xsl:value-of select="'{^1}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000B9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000BA;')"><xsl:value-of select="'\textordmasculine '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000BA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000BB;')"><xsl:value-of select="'\mbox{\guillemotright}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000BB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C0;')"><xsl:value-of select="'\grave{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C1;')"><xsl:value-of select="'\acute{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C1;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C2;')"><xsl:value-of select="'\hat{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C3;')"><xsl:value-of select="'\tilde{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C4;')"><xsl:value-of select="'\ddot{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C5;')"><xsl:value-of select="'\AA '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C5;')"/></xsl:call-template></xsl:when>	<!--capital A, ring --> <!-- invalid in math mode -->
		<xsl:when test="starts-with($content,'&#x000C6;')"><xsl:value-of select="'\AE '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C6;')"/></xsl:call-template></xsl:when>	<!--capital AE diphthong (ligature) --> <!-- invalid in math mode -->
		<xsl:when test="starts-with($content,'&#x000C7;')"><xsl:value-of select="'\mbox{\c{C}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C8;')"><xsl:value-of select="'\grave{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000C9;')"><xsl:value-of select="'\acute{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000C9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000CA;')"><xsl:value-of select="'\hat{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000CA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000CB;')"><xsl:value-of select="'\ddot{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000CB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000CC;')"><xsl:value-of select="'\grave{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000CC;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000CD;')"><xsl:value-of select="'\acute{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000CD;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000CE;')"><xsl:value-of select="'\hat{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000CE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000CF;')"><xsl:value-of select="'\ddot{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000CF;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D0;')"><xsl:value-of select="'\DH '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D1;')"><xsl:value-of select="'\tilde{N}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D1;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D2;')"><xsl:value-of select="'\grave{O}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D3;')"><xsl:value-of select="'\acute{O}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D4;')"><xsl:value-of select="'\hat{O}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D5;')"><xsl:value-of select="'\tilde{O}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D5;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D6;')"><xsl:value-of select="'\ddot{O}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D6;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D7;')"><xsl:value-of select="'\times '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D7;')"/></xsl:call-template></xsl:when>	<!--/times B: =multiply sign -->
		<xsl:when test="starts-with($content,'&#x000D8;')"><xsl:value-of select="'\O '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000D9;')"><xsl:value-of select="'\grave{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000D9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000DA;')"><xsl:value-of select="'\acute{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000DA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000DB;')"><xsl:value-of select="'\hat{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000DB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000DC;')"><xsl:value-of select="'\ddot{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000DC;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000DD;')"><xsl:value-of select="'\acute{Y}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000DD;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000DE;')"><xsl:value-of select="'\TH '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000DE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000DF;')"><xsl:value-of select="'\ss '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000DF;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E0;')"><xsl:value-of select="'\grave{a}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E1;')"><xsl:value-of select="'\acute{a}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E1;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E2;')"><xsl:value-of select="'\hat{a}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E3;')"><xsl:value-of select="'\tilde{a}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E4;')"><xsl:value-of select="'\ddot{a}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E5;')"><xsl:value-of select="'\aa '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E5;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E6;')"><xsl:value-of select="'\ae '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E6;')"/></xsl:call-template></xsl:when>	<!--small ae diphthong (ligature) --> <!-- invalid in math mode -->
		<xsl:when test="starts-with($content,'&#x000E7;')"><xsl:value-of select="'\mbox{\c{c}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E8;')"><xsl:value-of select="'\grave{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000E9;')"><xsl:value-of select="'\acute{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000E9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000EA;')"><xsl:value-of select="'\hat{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000EA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000EB;')"><xsl:value-of select="'\ddot{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000EB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000EC;')"><xsl:value-of select="'\grave{\imath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000EC;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000ED;')"><xsl:value-of select="'\acute{\imath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000ED;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000EE;')"><xsl:value-of select="'\hat{\imath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000EE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000EF;')"><xsl:value-of select="'\ddot{\imath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000EF;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F0;')"><xsl:value-of select="'\eth '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F1;')"><xsl:value-of select="'\tilde{n}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F1;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F2;')"><xsl:value-of select="'\grave{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F3;')"><xsl:value-of select="'\acute{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F4;')"><xsl:value-of select="'\hat{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F5;')"><xsl:value-of select="'\tilde{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F5;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F6;')"><xsl:value-of select="'\ddot{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F6;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F7;')"><xsl:value-of select="'\div '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F8;')"><xsl:value-of select="'\o '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000F9;')"><xsl:value-of select="'\grave{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000F9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000FA;')"><xsl:value-of select="'\acute{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000FA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000FB;')"><xsl:value-of select="'\hat{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000FB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000FC;')"><xsl:value-of select="'\ddot{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000FC;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000FD;')"><xsl:value-of select="'\acute{y}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000FD;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000FE;')"><xsl:value-of select="'\th '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000FE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x000FF;')"><xsl:value-of select="'\ddot{y}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x000FF;')"/></xsl:call-template></xsl:when>
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
                  -->
<!-- ====================================================================== -->
<xsl:when test="starts-with($content,'&#x00100;')"><xsl:value-of select="'\bar{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00100;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00101;')"><xsl:value-of select="'\bar{a}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00101;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00102;')"><xsl:value-of select="'\breve{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00102;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00103;')"><xsl:value-of select="'\u{a}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00103;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00106;')"><xsl:value-of select="'\acute{C}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00106;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00107;')"><xsl:value-of select="'\acute{c}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00107;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00108;')"><xsl:value-of select="'\hat{C}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00108;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00109;')"><xsl:value-of select="'\hat{c}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00109;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0010A;')"><xsl:value-of select="'\dot{C}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0010A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0010B;')"><xsl:value-of select="'\dot{c}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0010B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0010C;')"><xsl:value-of select="'\check{C}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0010C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0010D;')"><xsl:value-of select="'\check{c}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0010D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0010E;')"><xsl:value-of select="'\check{D}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0010E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0010F;')"><xsl:value-of select="'\check{d}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0010F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00112;')"><xsl:value-of select="'\bar{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00112;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00113;')"><xsl:value-of select="'\bar{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00113;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00114;')"><xsl:value-of select="'\breve{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00114;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00115;')"><xsl:value-of select="'\breve{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00115;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00116;')"><xsl:value-of select="'\dot{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00116;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00117;')"><xsl:value-of select="'\dot{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00117;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00118;')"><xsl:value-of select="'\k{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00118;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0011A;')"><xsl:value-of select="'\check{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0011A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0011B;')"><xsl:value-of select="'\check{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0011B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0011C;')"><xsl:value-of select="'\hat{G}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0011C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0011D;')"><xsl:value-of select="'\hat{g}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0011D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0011E;')"><xsl:value-of select="'\breve{G}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0011E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0011F;')"><xsl:value-of select="'\breve{g}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0011F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00120;')"><xsl:value-of select="'\dot{G}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00120;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00121;')"><xsl:value-of select="'\dot{g}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00121;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00122;')"><xsl:value-of select="'\mbox{\c{G}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00122;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00123;')"><xsl:value-of select="'\mbox{\c{g}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00123;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00124;')"><xsl:value-of select="'\hat{H}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00124;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00125;')"><xsl:value-of select="'\hat{h}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00125;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00127;')"><xsl:value-of select="'\Elzxh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00127;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00128;')"><xsl:value-of select="'\tilde{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00128;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00129;')"><xsl:value-of select="'\tilde{\imath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00129;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0012A;')"><xsl:value-of select="'\bar{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0012A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0012B;')"><xsl:value-of select="'\bar{\imath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0012B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0012C;')"><xsl:value-of select="'\breve{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0012C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0012D;')"><xsl:value-of select="'\breve{\imath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0012D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00130;')"><xsl:value-of select="'\dot{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00130;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00131;')"><xsl:value-of select="'\imath '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00131;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00134;')"><xsl:value-of select="'\hat{J}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00134;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00135;')"><xsl:value-of select="'\hat{\jmath}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00135;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00136;')"><xsl:value-of select="'\mbox{\c{K}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00136;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00137;')"><xsl:value-of select="'\mbox{\c{k}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00137;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00139;')"><xsl:value-of select="'\acute{L}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00139;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0013A;')"><xsl:value-of select="'\acute{l}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0013A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0013B;')"><xsl:value-of select="'\mbox{\c{L}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0013B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0013C;')"><xsl:value-of select="'\mbox{\c{l}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0013C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0013D;')"><xsl:value-of select="'\check{L}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0013D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0013E;')"><xsl:value-of select="'\check{l}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0013E;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00141;')"><xsl:value-of select="'\L '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00141;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00142;')"><xsl:value-of select="'\l '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00142;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00143;')"><xsl:value-of select="'\acute{N}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00143;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00144;')"><xsl:value-of select="'\acute{n}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00144;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00145;')"><xsl:value-of select="'\mbox{\c{N}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00145;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00146;')"><xsl:value-of select="'\mbox{\c{n}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00146;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00147;')"><xsl:value-of select="'\check{N}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00147;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00148;')"><xsl:value-of select="'\check{n}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00148;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0014C;')"><xsl:value-of select="'\bar{O}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0014C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0014D;')"><xsl:value-of select="'\bar{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0014D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0014E;')"><xsl:value-of select="'\breve{O}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0014E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0014F;')"><xsl:value-of select="'\breve{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0014F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00150;')"><xsl:value-of select="'\mbox{\H{O}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00150;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00151;')"><xsl:value-of select="'\mbox{\H{o}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00151;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00152;')"><xsl:value-of select="'\OE '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00152;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x00153;')"><xsl:value-of select="'\oe '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00153;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00154;')"><xsl:value-of select="'\acute{R}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00154;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00155;')"><xsl:value-of select="'\acute{r}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00155;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00156;')"><xsl:value-of select="'\mbox{\c{R}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00156;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00157;')"><xsl:value-of select="'\mbox{\c{r}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00157;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00158;')"><xsl:value-of select="'\check{R}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00158;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00159;')"><xsl:value-of select="'\check{r}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00159;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0015A;')"><xsl:value-of select="'\acute{S}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0015A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0015B;')"><xsl:value-of select="'\acute{s}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0015B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0015C;')"><xsl:value-of select="'\hat{S}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0015C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0015D;')"><xsl:value-of select="'\hat{s}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0015D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0015E;')"><xsl:value-of select="'\mbox{\c{S}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0015E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0015F;')"><xsl:value-of select="'\mbox{\c{s}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0015F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00160;')"><xsl:value-of select="'\check{S}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00160;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00161;')"><xsl:value-of select="'\check{s}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00161;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00162;')"><xsl:value-of select="'\mbox{\c{T}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00162;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00163;')"><xsl:value-of select="'\mbox{\c{t}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00163;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00164;')"><xsl:value-of select="'\check{T}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00164;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00165;')"><xsl:value-of select="'\check{t}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00165;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00168;')"><xsl:value-of select="'\tilde{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00168;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00169;')"><xsl:value-of select="'\tilde{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00169;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0016A;')"><xsl:value-of select="'\bar{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0016A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0016B;')"><xsl:value-of select="'\bar{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0016B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0016C;')"><xsl:value-of select="'\breve{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0016C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0016D;')"><xsl:value-of select="'\breve{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0016D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0016E;')"><xsl:value-of select="'\mathring{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0016E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0016F;')"><xsl:value-of select="'\mathring{u}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0016F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00170;')"><xsl:value-of select="'\mbox{\H{U}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00170;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00171;')"><xsl:value-of select="'\mbox{\H{u}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00171;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00172;')"><xsl:value-of select="'\k{U}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00172;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00174;')"><xsl:value-of select="'\hat{W}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00174;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00175;')"><xsl:value-of select="'\hat{w}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00175;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00176;')"><xsl:value-of select="'\hat{Y}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00176;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00177;')"><xsl:value-of select="'\hat{y}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00177;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00178;')"><xsl:value-of select="'\ddot{Y}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00178;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00179;')"><xsl:value-of select="'\acute{Z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00179;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0017A;')"><xsl:value-of select="'\acute{z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0017A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0017B;')"><xsl:value-of select="'\dot{Z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0017B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0017C;')"><xsl:value-of select="'\dot{z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0017C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0017D;')"><xsl:value-of select="'\check{Z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0017D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0017E;')"><xsl:value-of select="'\check{z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0017E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00192;')"><xsl:value-of select="'f'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00192;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x001AA;')"><xsl:value-of select="'\eth '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x001AA;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x001F5;')"><xsl:value-of select="'\acute{g}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x001F5;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00250;')"><xsl:value-of select="'\Elztrna '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00250;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00252;')"><xsl:value-of select="'\Elztrnsa '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00252;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00254;')"><xsl:value-of select="'\Elzopeno '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00254;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00256;')"><xsl:value-of select="'\Elzrtld '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00256;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00259;')"><xsl:value-of select="'\Elzschwa '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00259;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0025B;')"><xsl:value-of select="'\varepsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0025B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00263;')"><xsl:value-of select="'\Elzpgamma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00263;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00264;')"><xsl:value-of select="'\Elzpbgam '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00264;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00265;')"><xsl:value-of select="'\Elztrnh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00265;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0026C;')"><xsl:value-of select="'\Elzbtdl '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0026C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0026D;')"><xsl:value-of select="'\Elzrtll '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0026D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0026F;')"><xsl:value-of select="'\Elztrnm '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0026F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00270;')"><xsl:value-of select="'\Elztrnmlr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00270;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00271;')"><xsl:value-of select="'\Elzltlmr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00271;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00273;')"><xsl:value-of select="'\Elzrtln '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00273;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00277;')"><xsl:value-of select="'\Elzclomeg '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00277;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00279;')"><xsl:value-of select="'\Elztrnr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00279;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0027A;')"><xsl:value-of select="'\Elztrnrl '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0027A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0027B;')"><xsl:value-of select="'\Elzrttrnr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0027B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0027C;')"><xsl:value-of select="'\Elzrl '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0027C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0027D;')"><xsl:value-of select="'\Elzrtlr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0027D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0027E;')"><xsl:value-of select="'\Elzfhr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0027E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00282;')"><xsl:value-of select="'\Elzrtls '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00282;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00283;')"><xsl:value-of select="'\Elzesh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00283;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00287;')"><xsl:value-of select="'\Elztrnt '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00287;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00288;')"><xsl:value-of select="'\Elzrtlt '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00288;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0028A;')"><xsl:value-of select="'\Elzpupsil '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0028A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0028B;')"><xsl:value-of select="'\Elzpscrv '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0028B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0028C;')"><xsl:value-of select="'\Elzinvv '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0028C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0028D;')"><xsl:value-of select="'\Elzinvw '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0028D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0028E;')"><xsl:value-of select="'\Elztrny '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0028E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00290;')"><xsl:value-of select="'\Elzrtlz '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00290;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00292;')"><xsl:value-of select="'\Elzyogh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00292;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00294;')"><xsl:value-of select="'\Elzglst '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00294;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00295;')"><xsl:value-of select="'\Elzreglst '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00295;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00296;')"><xsl:value-of select="'\Elzinglst '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00296;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002A4;')"><xsl:value-of select="'\Elzdyogh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002A4;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002A7;')"><xsl:value-of select="'\Elztesh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002A7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x002BC;')"><xsl:value-of select="'\rasp '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002BC;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002C8;')"><xsl:value-of select="'\Elzverts '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002C8;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002CC;')"><xsl:value-of select="'\Elzverti '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002CC;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D0;')"><xsl:value-of select="'\Elzlmrk '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D0;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D1;')"><xsl:value-of select="'\Elzhlmrk '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D1;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D2;')"><xsl:value-of select="'\Elzsbrhr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D2;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D3;')"><xsl:value-of select="'\Elzsblhr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D3;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D4;')"><xsl:value-of select="'\Elzrais '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D4;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D5;')"><xsl:value-of select="'\Elzlow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D5;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D8;')"><xsl:value-of select="'\u '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D8;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002D9;')"><xsl:value-of select="'\dot{}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002D9;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002DA;')"><xsl:value-of select="'\mathring{}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002DA;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002DB;')"><xsl:value-of select="'\mbox{\k{}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002DB;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x002DD;')"><xsl:value-of select="'\mbox{\H{}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x002DD;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00300;')"><xsl:value-of select="'\grave '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00300;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00301;')"><xsl:value-of select="'\acute '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00301;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00302;')"><xsl:value-of select="'\hat '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00302;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00303;')"><xsl:value-of select="'\tilde '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00303;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00304;')"><xsl:value-of select="'\bar '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00304;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00306;')"><xsl:value-of select="'\breve '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00306;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00307;')"><xsl:value-of select="'\dot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00307;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00308;')"><xsl:value-of select="'\ddot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00308;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0030A;')"><xsl:value-of select="'\ocirc '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0030A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0030B;')"><xsl:value-of select="'\H '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0030B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0030C;')"><xsl:value-of select="'\check '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0030C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00321;')"><xsl:value-of select="'\Elzpalh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00321;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0032A;')"><xsl:value-of select="'\Elzsbbrg '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0032A;')"/></xsl:call-template></xsl:when>
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	Greek
	Range: 0370-03FF
	http://www.unicode.org/charts/PDF/U0370.pdf	                    -->
<!-- ====================================================================== -->
<xsl:when test="starts-with($content,'&#x00386;')"><xsl:value-of select="'\acute{A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00386;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00388;')"><xsl:value-of select="'\acute{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00388;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00389;')"><xsl:value-of select="'\grave{H}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00389;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0038A;')"><xsl:value-of select="concat('\mathrm{',$apos,'I}')" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0038A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0038C;')"><xsl:value-of select="concat('\mathrm{',$apos,'O}')" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0038C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0038E;')"><xsl:value-of select="concat('\mathrm{',$apos,'Y}')" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0038E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0038F;')"><xsl:value-of select="concat('\mathrm{',$apos,'\Omega}')" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0038F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00390;')"><xsl:value-of select="'\acute{\ddot{\iota}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00390;')"/></xsl:call-template></xsl:when>
	
<xsl:when test="starts-with($content,'&#x00391;')"><xsl:value-of select="'\Alpha '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00391;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00392;')"><xsl:value-of select="'\Beta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00392;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00393;')"><xsl:value-of select="'\Gamma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00393;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00394;')"><xsl:value-of select="'\Delta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00394;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00395;')"><xsl:value-of select="'\Epsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00395;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00396;')"><xsl:value-of select="'\Zeta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00396;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00397;')"><xsl:value-of select="'\Eta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00397;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00398;')"><xsl:value-of select="'\Theta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00398;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x00399;')"><xsl:value-of select="'\Iota '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x00399;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0039A;')"><xsl:value-of select="'\Kappa '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0039A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0039B;')"><xsl:value-of select="'\Lambda '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0039B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0039C;')"><xsl:value-of select="'M'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0039C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0039D;')"><xsl:value-of select="'N'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0039D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0039E;')"><xsl:value-of select="'\Xi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0039E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0039F;')"><xsl:value-of select="'O'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0039F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A0;')"><xsl:value-of select="'\Pi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A0;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A1;')"><xsl:value-of select="'\Rho '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A1;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A3;')"><xsl:value-of select="'\Sigma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A3;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A4;')"><xsl:value-of select="'\Tau '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A4;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A5;')"><xsl:value-of select="'\Upsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A5;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A6;')"><xsl:value-of select="'\Phi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A6;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A7;')"><xsl:value-of select="'\Chi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A7;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A8;')"><xsl:value-of select="'\Psi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A8;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003A9;')"><xsl:value-of select="'\Omega '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003A9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x003AA;')"><xsl:value-of select="'\mathrm{\ddot{I}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003AA;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003AB;')"><xsl:value-of select="'\mathrm{\ddot{Y}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003AB;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003AC;')"><xsl:value-of select="'\acute{\alpha}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003AC;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003AD;')"><xsl:value-of select="'\acute{\epsilon}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003AD;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003AE;')"><xsl:value-of select="'\acute{\eta}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003AE;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003AF;')"><xsl:value-of select="'\acute{\iota}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003AF;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003B0;')"><xsl:value-of select="'\acute{\ddot{\upsilon}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x003B1;')"><xsl:value-of select="'\alpha '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B1;')"/></xsl:call-template></xsl:when>	<!--/alpha small alpha, Greek -->
		<xsl:when test="starts-with($content,'&#x003B2;')"><xsl:value-of select="'\beta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B2;')"/></xsl:call-template></xsl:when>	<!--/beta small beta, Greek -->
		<xsl:when test="starts-with($content,'&#x003B3;')"><xsl:value-of select="'\gamma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B3;')"/></xsl:call-template></xsl:when>	<!--/gamma small gamma, Greek -->
		<xsl:when test="starts-with($content,'&#x003B4;')"><xsl:value-of select="'\delta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B4;')"/></xsl:call-template></xsl:when>	<!--/delta small delta, Greek -->
		<xsl:when test="starts-with($content,'&#x003B5;')"><xsl:value-of select="'\epsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B5;')"/></xsl:call-template></xsl:when>	<!--/straightepsilon, small epsilon, Greek -->
		<xsl:when test="starts-with($content,'&#x003B6;')"><xsl:value-of select="'\zeta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B6;')"/></xsl:call-template></xsl:when>	<!--/zeta small zeta, Greek -->
		<xsl:when test="starts-with($content,'&#x003B7;')"><xsl:value-of select="'\eta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B7;')"/></xsl:call-template></xsl:when>	<!--/eta small eta, Greek -->
		<xsl:when test="starts-with($content,'&#x003B8;')"><xsl:value-of select="'\theta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B8;')"/></xsl:call-template></xsl:when>	<!--/theta straight theta, small theta, Greek -->
		<xsl:when test="starts-with($content,'&#x003B9;')"><xsl:value-of select="'\iota '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003B9;')"/></xsl:call-template></xsl:when>	<!--/iota small iota, Greek -->
		<xsl:when test="starts-with($content,'&#x003BA;')"><xsl:value-of select="'\kappa '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003BA;')"/></xsl:call-template></xsl:when>	<!--/kappa small kappa, Greek -->
		<xsl:when test="starts-with($content,'&#x003BB;')"><xsl:value-of select="'\lambda '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003BB;')"/></xsl:call-template></xsl:when>	<!--/lambda small lambda, Greek -->
		<xsl:when test="starts-with($content,'&#x003BC;')"><xsl:value-of select="'\mu '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003BC;')"/></xsl:call-template></xsl:when>	<!--/mu small mu, Greek -->
		<xsl:when test="starts-with($content,'&#x003BD;')"><xsl:value-of select="'\nu '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003BD;')"/></xsl:call-template></xsl:when>	<!--/nu small nu, Greek -->
		<xsl:when test="starts-with($content,'&#x003BE;')"><xsl:value-of select="'\xi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003BE;')"/></xsl:call-template></xsl:when>	<!--/xi small xi, Greek -->
		<xsl:when test="starts-with($content,'&#x003BF;')"><xsl:value-of select="'o'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003BF;')"/></xsl:call-template></xsl:when>	<!--small omicron, Greek -->
		<xsl:when test="starts-with($content,'&#x003C0;')"><xsl:value-of select="'\pi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C0;')"/></xsl:call-template></xsl:when>	<!--/pi small pi, Greek -->
		<xsl:when test="starts-with($content,'&#x003C1;')"><xsl:value-of select="'\rho '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C1;')"/></xsl:call-template></xsl:when>	<!--/rho small rho, Greek -->
		<xsl:when test="starts-with($content,'&#x003C2;')"><xsl:value-of select="'\varsigma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C2;')"/></xsl:call-template></xsl:when>	<!--/varsigma -->
		<xsl:when test="starts-with($content,'&#x003C3;')"><xsl:value-of select="'\sigma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C3;')"/></xsl:call-template></xsl:when>	<!--/sigma small sigma, Greek -->
		<xsl:when test="starts-with($content,'&#x003C4;')"><xsl:value-of select="'\tau '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C4;')"/></xsl:call-template></xsl:when>	<!--/tau small tau, Greek -->
		<xsl:when test="starts-with($content,'&#x003C5;')"><xsl:value-of select="'\upsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C5;')"/></xsl:call-template></xsl:when>	<!--/upsilon small upsilon, Greek -->
		<xsl:when test="starts-with($content,'&#x003C6;')"><xsl:value-of select="'\phi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C6;')"/></xsl:call-template></xsl:when>	<!--/straightphi - small phi, Greek -->
		<xsl:when test="starts-with($content,'&#x003C7;')"><xsl:value-of select="'\chi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C7;')"/></xsl:call-template></xsl:when>	<!--/chi small chi, Greek -->
		<xsl:when test="starts-with($content,'&#x003C8;')"><xsl:value-of select="'\psi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C8;')"/></xsl:call-template></xsl:when>	<!--/psi small psi, Greek -->
		<xsl:when test="starts-with($content,'&#x003C9;')"><xsl:value-of select="'\omega '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003C9;')"/></xsl:call-template></xsl:when>	<!--/omega small omega, Greek -->
		<xsl:when test="starts-with($content,'&#x003CA;')"><xsl:value-of select="'\ddot{\iota}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003CA;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003CB;')"><xsl:value-of select="'\ddot{\upsilon}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003CB;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003CC;')"><xsl:value-of select="'\acute{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003CC;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003CD;')"><xsl:value-of select="'\acute{\upsilon}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003CD;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003CE;')"><xsl:value-of select="'\acute{\omega}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003CE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x003D1;')"><xsl:value-of select="'\vartheta '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003D1;')"/></xsl:call-template></xsl:when>	<!--/vartheta - curly or open theta -->
		<xsl:when test="starts-with($content,'&#x003D2;')"><xsl:value-of select="'\Upsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003D2;')"/></xsl:call-template></xsl:when>	<!--/Upsilon capital Upsilon, Greek -->
		<xsl:when test="starts-with($content,'&#x003D5;')"><xsl:value-of select="'\phi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003D5;')"/></xsl:call-template></xsl:when>	<!--/varphi - curly or open phi -->
		<xsl:when test="starts-with($content,'&#x003D6;')"><xsl:value-of select="'\varpi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003D6;')"/></xsl:call-template></xsl:when>	<!--/varpi -->
<xsl:when test="starts-with($content,'&#x003DA;')"><xsl:value-of select="'\Stigma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003DA;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003DC;')"><xsl:value-of select="'\Digamma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003DC;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003DD;')"><xsl:value-of select="'\digamma '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003DD;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003DE;')"><xsl:value-of select="'\Koppa '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003DE;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003E0;')"><xsl:value-of select="'\Sampi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003E0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x003F0;')"><xsl:value-of select="'\varkappa '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003F0;')"/></xsl:call-template></xsl:when>	<!--/varkappa -->
		<xsl:when test="starts-with($content,'&#x003F1;')"><xsl:value-of select="'\varrho '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003F1;')"/></xsl:call-template></xsl:when>	<!--/varrho -->
<xsl:when test="starts-with($content,'&#x003F5;')"><xsl:value-of select="'\epsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003F5;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x003F6;')"><xsl:value-of select="'\backepsilon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x003F6;')"/></xsl:call-template></xsl:when>
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	General Punctuation
	Range: 2000-206F
	http://www.unicode.org/charts/PDF/U2000.pdf	                    -->
<!-- ====================================================================== -->
		<xsl:when test="starts-with($content,'&#x02002;')"><xsl:value-of select='"\enspace "' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02002;')"/></xsl:call-template></xsl:when> 	<!-- en space (1/2-em) -->
		<xsl:when test="starts-with($content,'&#x02003;')"><xsl:value-of select='"\quad "' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02003;')"/></xsl:call-template></xsl:when>		<!-- emsp - space of width 1em -->
		<xsl:when test="starts-with($content,'&#x02004;')"><xsl:value-of select='"\hspace{0.33em}"' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02004;')"/></xsl:call-template></xsl:when>	<!-- emsp13 - space of width 1/3 em -->
		<xsl:when test="starts-with($content,'&#x02005;')"><xsl:value-of select='"\thickspace "' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02005;')"/></xsl:call-template></xsl:when>	<!-- ThickSpace - space of width 1/4 em -->
		<xsl:when test="starts-with($content,'&#x02006;')"><xsl:value-of select='"\hspace{0.166em}"' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02006;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02007;')"><xsl:value-of select='"\hphantom{0}"' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02007;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02008;')"><xsl:value-of select='"\hphantom{,}"' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02008;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02009;')"><xsl:value-of select='"\thinspace "' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02009;')"/></xsl:call-template></xsl:when>	<!-- ThinSpace - space of width 3/18 em -->
		<xsl:when test="starts-with($content,'&#x0200A;')"><xsl:value-of select="'\hspace '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0200A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0200B;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0200B;')"/></xsl:call-template></xsl:when>	<!--zero width space -->
		<xsl:when test="starts-with($content,'&#x02010;')"><xsl:value-of select="'-'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02010;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02013;')"><xsl:value-of select="'\endash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02013;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02014;')"><xsl:value-of select="'\emdash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02014;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02016;')"><xsl:value-of select="'\Vert '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02016;')"/></xsl:call-template></xsl:when>	<!--/Vert dbl vertical bar -->
		<xsl:when test="starts-with($content,'&#x02018;')"><xsl:value-of select="'\lq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02018;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02019;')"><xsl:value-of select="'\rq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02019;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0201B;')"><xsl:value-of select="'\Elzreapos '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0201B;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0201C;')"><xsl:value-of select="'\textquotedblleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0201C;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0201D;')"><xsl:value-of select="'\textquotedblright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0201D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02020;')"><xsl:value-of select="'\dagger '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02020;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02021;')"><xsl:value-of select="'\ddager '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02021;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02022;')"><xsl:value-of select="'\bullet '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02022;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02026;')"><xsl:value-of select="'\dots '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02026;')"/></xsl:call-template></xsl:when>	<!--horizontal ellipsis = three dot leader -->
		<xsl:when test="starts-with($content,'&#x02032;')"><xsl:value-of select="'\prime '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02032;')"/></xsl:call-template></xsl:when>	<!--/prime prime or minute -->
<xsl:when test="starts-with($content,'&#x02033;')"><xsl:value-of select="concat('{',$apos,$apos,'}')" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02033;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02034;')"><xsl:value-of select="concat('{',$apos,$apos,$apos,'}')" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02034;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02035;')"><xsl:value-of select="'\backprime '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02035;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02041;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02041;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02044;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02044;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0204E;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0204E;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02057;')"><xsl:value-of select="concat($apos,$apos,$apos,$apos)" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02057;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0205F;')"><xsl:value-of select="'\mkern4mu '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0205F;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02061;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02061;')"/></xsl:call-template></xsl:when>	<!-- ApplyFunction -->
		<xsl:when test="starts-with($content,'&#x02062;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02062;')"/></xsl:call-template></xsl:when>	<!-- InvisibleTimes -->
		<xsl:when test="starts-with($content,'&#x02063;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02063;')"/></xsl:call-template></xsl:when>	<!-- InvisibleComma, used as a separator, e.g., in indices -->
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	                    -->
<!-- ====================================================================== -->
<xsl:when test="starts-with($content,'&#x020A7;')"><xsl:value-of select="'\Elzpes'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x020A7;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x020AC;')"><xsl:value-of select="'\mbox{\texteuro}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x020AC;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x020DB;')"><xsl:value-of select="'\dddot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x020DB;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x020DC;')"><xsl:value-of select="'\ddddot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x020DC;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x020E7;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x020E7;')"/></xsl:call-template></xsl:when>
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	Letterlike Symbols
	Range: 2100-214F
	http://www.unicode.org/charts/PDF/U2100.pdf	                    -->
<!-- ====================================================================== -->
<xsl:when test="starts-with($content,'&#x02102;')"><xsl:value-of select="'\mathbb{C}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02102;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0210A;')"><xsl:value-of select="'\mathscr{g}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0210A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0210B;')"><xsl:value-of select="'\mathscr{H}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0210B;')"/></xsl:call-template></xsl:when>	<!--H Hamiltonian -->
		<xsl:when test="starts-with($content,'&#x0210C;')"><xsl:value-of select="'\mathfrak{H}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0210C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0210D;')"><xsl:value-of select="'\mathbb{H}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0210D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0210E;')"><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0210E;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0210F;&#x0FE00;')"><xsl:value-of select="'\hbar '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0210F;&#x0FE00;')"/></xsl:call-template></xsl:when>	<!--/hbar - Planck's over 2pi -->
		<xsl:when test="starts-with($content,'&#x0210F;')"><xsl:value-of select="'\hslash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0210F;')"/></xsl:call-template></xsl:when>	<!--/hslash - variant Planck's over 2pi --> <!-- Required amssymb -->
<xsl:when test="starts-with($content,'&#x02110;')"><xsl:value-of select="'\mathscr{I}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02110;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02111;')"><xsl:value-of select="'\Im '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02111;')"/></xsl:call-template></xsl:when>		<!--/Im - imaginary   -->
<xsl:when test="starts-with($content,'&#x02112;')"><xsl:value-of select="'\mathscr{L}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02112;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02113;')"><xsl:value-of select="'\ell '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02113;')"/></xsl:call-template></xsl:when>		<!--/ell - cursive small l -->
		<xsl:when test="starts-with($content,'&#x02115;')"><xsl:value-of select="'\mathbb{N}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02115;')"/></xsl:call-template></xsl:when>	<!--the semi-ring of natural numbers --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02116;')"><xsl:value-of select="'\textnumero '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02116;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02118;')"><xsl:value-of select="'\wp '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02118;')"/></xsl:call-template></xsl:when>		<!--/wp - Weierstrass p -->
		<xsl:when test="starts-with($content,'&#x02119;')"><xsl:value-of select="'\mathbb{P}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02119;')"/></xsl:call-template></xsl:when>	<!--the prime natural numbers --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0211A;')"><xsl:value-of select="'\mathbb{Q}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0211A;')"/></xsl:call-template></xsl:when>	<!--the field of rational numbers --> <!-- Required amssymb -->
<xsl:when test="starts-with($content,'&#x0211B;')"><xsl:value-of select="'\mathscr{R}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0211B;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0211C;')"><xsl:value-of select="'\Re '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0211C;')"/></xsl:call-template></xsl:when>		<!--/Re - real -->
		<xsl:when test="starts-with($content,'&#x0211D;')"><xsl:value-of select="'\mathbb{R}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0211D;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0211E;')"><xsl:value-of select="'\Elzxrat '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0211E;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02124;')"><xsl:value-of select="'\mathbb{Z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02124;')"/></xsl:call-template></xsl:when>	<!--the ring of integers --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02126;')"><xsl:value-of select="'\Omega '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02126;')"/></xsl:call-template></xsl:when>		<!--ohm sign -->
		<xsl:when test="starts-with($content,'&#x02127;')"><xsl:value-of select="'\mho '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02127;')"/></xsl:call-template></xsl:when>		<!--/mho - conductance -->
<xsl:when test="starts-with($content,'&#x02128;')"><xsl:value-of select="'\mathfrak{Z}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02128;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02129;')"><xsl:value-of select="'\ElsevierGlyph{2129}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02129;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0212B;')"><xsl:value-of select="'\AA'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0212B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0212C;')"><xsl:value-of select="'\mathscr{B}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0212C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0212D;')"><xsl:value-of select="'\mathfrak{C}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0212D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0212F;')"><xsl:value-of select="'\mathscr{e}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0212F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02130;')"><xsl:value-of select="'\mathscr{E}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02130;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02131;')"><xsl:value-of select="'\mathscr{F}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02131;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02133;')"><xsl:value-of select="'\mathscr{M}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02133;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02134;')"><xsl:value-of select="'\mathscr{o}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02134;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02135;')"><xsl:value-of select="'\aleph '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02135;')"/></xsl:call-template></xsl:when>		<!--/aleph aleph, Hebrew -->
		<xsl:when test="starts-with($content,'&#x02136;')"><xsl:value-of select="'\beth '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02136;')"/></xsl:call-template></xsl:when>		<!--/beth - beth, Hebrew --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02137;')"><xsl:value-of select="'\gimel '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02137;')"/></xsl:call-template></xsl:when>		<!--/gimel - gimel, Hebrew --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02138;')"><xsl:value-of select="'\daleth '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02138;')"/></xsl:call-template></xsl:when>	<!--/daleth - daleth, Hebrew --> <!-- Required amssymb -->
<xsl:when test="starts-with($content,'&#x0213F;')"><xsl:value-of select="'\BbbPi '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0213F;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02140;')"><xsl:value-of select="'\bbsum '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02140;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02141;')"><xsl:value-of select="'\Game '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02141;')"/></xsl:call-template></xsl:when>
		
		<xsl:when test="starts-with($content,'&#x02145;')"><xsl:value-of select="'D'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02145;')"/></xsl:call-template></xsl:when>		<!--D for use in differentials, e.g., within integrals -->
		<xsl:when test="starts-with($content,'&#x02146;')"><xsl:value-of select="'d'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02146;')"/></xsl:call-template></xsl:when>		<!--d for use in differentials, e.g., within integrals -->
		<xsl:when test="starts-with($content,'&#x02147;')"><xsl:value-of select="'e'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02147;')"/></xsl:call-template></xsl:when>		<!--e use for the exponential base of the natural logarithms -->
		<xsl:when test="starts-with($content,'&#x02148;')"><xsl:value-of select="'i'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02148;')"/></xsl:call-template></xsl:when>		<!--i for use as a square root of -1 -->
		<xsl:when test="starts-with($content,'&#x02149;')"><xsl:value-of select="'j'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02149;')"/></xsl:call-template></xsl:when>		
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
		                    -->
<!-- ====================================================================== -->
<xsl:when test="starts-with($content,'&#x02153;')"><xsl:value-of select="'\textfrac{1}{3}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02153;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02154;')"><xsl:value-of select="'\textfrac{2}{3}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02154;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02155;')"><xsl:value-of select="'\textfrac{1}{5}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02155;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02156;')"><xsl:value-of select="'\textfrac{2}{5}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02156;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02157;')"><xsl:value-of select="'\textfrac{3}{5}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02157;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02158;')"><xsl:value-of select="'\textfrac{4}{5}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02158;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x02159;')"><xsl:value-of select="'\textfrac{1}{6}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02159;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0215A;')"><xsl:value-of select="'\textfrac{5}{6}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0215A;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0215B;')"><xsl:value-of select="'\textfrac{1}{8}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0215B;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0215C;')"><xsl:value-of select="'\textfrac{3}{8}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0215C;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0215D;')"><xsl:value-of select="'\textfrac{5}{8}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0215D;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x0215E;')"><xsl:value-of select="'\textfrac{7}{8}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0215E;')"/></xsl:call-template></xsl:when>
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	Arrows
	Range: 2190-21FF
	http://www.unicode.org/charts/PDF/U2190.pdf	                    -->
<!-- ====================================================================== -->
		<xsl:when test="starts-with($content,'&#x02190;')"><xsl:value-of select="'\leftarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02190;')"/></xsl:call-template></xsl:when>	<!--/leftarrow /gets A: =leftward arrow -->
		<xsl:when test="starts-with($content,'&#x02191;')"><xsl:value-of select="'\uparrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02191;')"/></xsl:call-template></xsl:when>	<!--/uparrow A: =upward arrow -->
  		<xsl:when test="starts-with($content,'&#x02192;')"><xsl:value-of select="'\rightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02192;')"/></xsl:call-template></xsl:when>		<!--/rightarrow /to A: =rightward arrow -->
		<xsl:when test="starts-with($content,'&#x02193;')"><xsl:value-of select="'\downarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02193;')"/></xsl:call-template></xsl:when>	<!--/downarrow A: =downward arrow -->
		<xsl:when test="starts-with($content,'&#x02194;')"><xsl:value-of select="'\leftrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02194;')"/></xsl:call-template></xsl:when>	<!--/leftrightarrow A: l&r arrow -->
		<xsl:when test="starts-with($content,'&#x02195;')"><xsl:value-of select="'\updownarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02195;')"/></xsl:call-template></xsl:when>	<!--/updownarrow A: up&down arrow -->
		<xsl:when test="starts-with($content,'&#x02196;')"><xsl:value-of select="'\nwarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02196;')"/></xsl:call-template></xsl:when>	<!--/nwarrow A: NW pointing arrow -->
		<xsl:when test="starts-with($content,'&#x02197;')"><xsl:value-of select="'\nearrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02197;')"/></xsl:call-template></xsl:when>	<!--/nearrow A: NE pointing arrow -->
		<xsl:when test="starts-with($content,'&#x02198;')"><xsl:value-of select="'\searrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02198;')"/></xsl:call-template></xsl:when>	<!--/searrow A: SE pointing arrow -->
		<xsl:when test="starts-with($content,'&#x02199;')"><xsl:value-of select="'\swarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02199;')"/></xsl:call-template></xsl:when>	<!--/swarrow A: SW pointing arrow -->
		<xsl:when test="starts-with($content,'&#x0219A;')"><xsl:value-of select="'\nleftarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0219A;')"/></xsl:call-template></xsl:when>	<!--/nleftarrow A: not left arrow --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0219B;')"><xsl:value-of select="'\nrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0219B;')"/></xsl:call-template></xsl:when>	<!--/nrightarrow A: not right arrow --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0219C;')"><xsl:value-of select="'\leftsquigarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0219C;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0219D;')"><xsl:value-of select="'\rightsquigarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0219D;')"/></xsl:call-template></xsl:when>	<!--/rightsquigarrow A: rt arrow-wavy --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0219E;')"><xsl:value-of select="'\twoheadleftarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0219E;')"/></xsl:call-template></xsl:when>	<!--/twoheadleftarrow A: --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021A0;')"><xsl:value-of select="'\twoheadrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021A0;')"/></xsl:call-template></xsl:when>	<!--/twoheadrightarrow A: --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021A2;')"><xsl:value-of select="'\leftarrowtail '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021A2;')"/></xsl:call-template></xsl:when>	<!--/leftarrowtail A: left arrow-tailed --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021A3;')"><xsl:value-of select="'\rightarrowtail '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021A3;')"/></xsl:call-template></xsl:when>	<!--/rightarrowtail A: rt arrow-tailed --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021A6;')"><xsl:value-of select="'\mapsto '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021A6;')"/></xsl:call-template></xsl:when>	<!--/mapsto A: -->
		<xsl:when test="starts-with($content,'&#x021A9;')"><xsl:value-of select="'\hookleftarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021A9;')"/></xsl:call-template></xsl:when>	<!--/hookleftarrow A: left arrow-hooked -->
		<xsl:when test="starts-with($content,'&#x021AA;')"><xsl:value-of select="'\hookrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021AA;')"/></xsl:call-template></xsl:when>	<!--/hookrightarrow A: rt arrow-hooked -->
		<xsl:when test="starts-with($content,'&#x021AB;')"><xsl:value-of select="'\looparrowleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021AB;')"/></xsl:call-template></xsl:when>	<!--/looparrowleft A: left arrow-looped --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021AC;')"><xsl:value-of select="'\looparrowright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021AC;')"/></xsl:call-template></xsl:when>	<!--/looparrowright A: rt arrow-looped --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021AD;')"><xsl:value-of select="'\leftrightsquigarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021AD;')"/></xsl:call-template></xsl:when>	<!--/leftrightsquigarrow A: l&r arr-wavy --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021AE;')"><xsl:value-of select="'\nleftrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021AE;')"/></xsl:call-template></xsl:when>	<!--/nleftrightarrow A: not l&r arrow --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021B0;')"><xsl:value-of select="'\Lsh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021B0;')"/></xsl:call-template></xsl:when>	<!--/Lsh A: --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021B1;')"><xsl:value-of select="'\Rsh '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021B1;')"/></xsl:call-template></xsl:when>	<!--/Rsh A: --> <!-- Required amssymb -->
<xsl:when test="starts-with($content,'&#x021B3;')"><xsl:value-of select="'\ElsevierGlyph{21B3}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021B3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x021B6;')"><xsl:value-of select="'\curvearrowleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021B6;')"/></xsl:call-template></xsl:when>	<!--/curvearrowleft A: left curved arrow --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021B7;')"><xsl:value-of select="'\curvearrowright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021B7;')"/></xsl:call-template></xsl:when>	<!--/curvearrowright A: rt curved arrow --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021BA;')"><xsl:value-of select="'\circlearrowleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021BA;')"/></xsl:call-template></xsl:when>	<!--/circlearrowleft A: l arr in circle --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021BB;')"><xsl:value-of select="'\circlearrowright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021BB;')"/></xsl:call-template></xsl:when>	<!--/circlearrowright A: r arr in circle --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021BC;')"><xsl:value-of select="'\leftharpoonup '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021BC;')"/></xsl:call-template></xsl:when>	<!--/leftharpoonup A: left harpoon-up -->
		<xsl:when test="starts-with($content,'&#x021BD;')"><xsl:value-of select="'\leftharpoondown '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021BD;')"/></xsl:call-template></xsl:when>	<!--/leftharpoondown A: l harpoon-down -->
		<xsl:when test="starts-with($content,'&#x021BE;')"><xsl:value-of select="'\upharpoonright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021BE;')"/></xsl:call-template></xsl:when>	<!--/upharpoonright /restriction A: up harp-r --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021BF;')"><xsl:value-of select="'\upharpoonleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021BF;')"/></xsl:call-template></xsl:when>	<!--/upharpoonleft A: up harpoon-left --> <!-- Required amssymb -->
 		<xsl:when test="starts-with($content,'&#x021C0;')"><xsl:value-of select="'\rightharpoonup '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C0;')"/></xsl:call-template></xsl:when>		<!--/rightharpoonup A: rt harpoon-up -->
		<xsl:when test="starts-with($content,'&#x021C1;')"><xsl:value-of select="'\rightharpoondown '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C1;')"/></xsl:call-template></xsl:when>	<!--/rightharpoondown A: rt harpoon-down -->
		<xsl:when test="starts-with($content,'&#x021C2;')"><xsl:value-of select="'\downharpoonright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C2;')"/></xsl:call-template></xsl:when>	<!--/downharpoonright A: down harpoon-rt --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021C3;')"><xsl:value-of select="'\downharpoonleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C3;')"/></xsl:call-template></xsl:when>	<!--/downharpoonleft A: dn harpoon-left --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021C4;')"><xsl:value-of select="'\rightleftarrows '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C4;')"/></xsl:call-template></xsl:when>	<!--/rightleftarrows A: r arr over l arr --> <!-- Required amssymb -->
<xsl:when test="starts-with($content,'&#x021C5;')"><xsl:value-of select="'\dblarrowupdown '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C5;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x021C6;')"><xsl:value-of select="'\leftrightarrows '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C6;')"/></xsl:call-template></xsl:when>	<!--/leftrightarrows A: l arr over r arr --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021C7;')"><xsl:value-of select="'\leftleftarrows '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C7;')"/></xsl:call-template></xsl:when>	<!--/leftleftarrows A: two left arrows --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021C8;')"><xsl:value-of select="'\upuparrows '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C8;')"/></xsl:call-template></xsl:when>	<!--/upuparrows A: two up arrows --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021C9;')"><xsl:value-of select="'\rightrightarrows '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021C9;')"/></xsl:call-template></xsl:when>	<!--/rightrightarrows A: two rt arrows --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021CA;')"><xsl:value-of select="'\downdownarrows '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021CA;')"/></xsl:call-template></xsl:when>	<!--/downdownarrows A: two down arrows --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021CB;')"><xsl:value-of select="'\leftrightharpoons '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021CB;')"/></xsl:call-template></xsl:when>	<!--/leftrightharpoons A: l harp over r -->
		<xsl:when test="starts-with($content,'&#x021CC;')"><xsl:value-of select="'\rightleftharpoons '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021CC;')"/></xsl:call-template></xsl:when>	<!--/rightleftharpoons A: r harp over l -->
		<xsl:when test="starts-with($content,'&#x021CD;')"><xsl:value-of select="'\nLeftarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021CD;')"/></xsl:call-template></xsl:when>	<!--/nLeftarrow A: not implied by --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021CE;')"><xsl:value-of select="'\nLeftrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021CE;')"/></xsl:call-template></xsl:when>	<!--/nLeftrightarrow A: not l&r dbl arr --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021CF;')"><xsl:value-of select="'\nRightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021CF;')"/></xsl:call-template></xsl:when>	<!--/nRightarrow A: not implies --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021D0;')"><xsl:value-of select="'\Leftarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021D0;')"/></xsl:call-template></xsl:when>	<!--/Leftarrow A: is implied by -->
		<xsl:when test="starts-with($content,'&#x021D1;')"><xsl:value-of select="'\Uparrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021D1;')"/></xsl:call-template></xsl:when>	<!--/Uparrow A: up dbl arrow -->
		<xsl:when test="starts-with($content,'&#x021D2;')"><xsl:value-of select="'\Rightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021D2;')"/></xsl:call-template></xsl:when>	<!--/Rightarrow A: implies -->
		<xsl:when test="starts-with($content,'&#x021D3;')"><xsl:value-of select="'\Downarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021D3;')"/></xsl:call-template></xsl:when>	<!--/Downarrow A: down dbl arrow -->
		<xsl:when test="starts-with($content,'&#x021D4;')"><xsl:value-of select="'\Leftrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021D4;')"/></xsl:call-template></xsl:when>	<!--/Leftrightarrow A: l&r dbl arrow -->
<!--		<xsl:when test="starts-with($content,'&#x021D4;')"><xsl:value-of select="'\iff '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021D4;')"/></xsl:call-template></xsl:when>	/iff if and only if	-->
		<xsl:when test="starts-with($content,'&#x021D5;')"><xsl:value-of select="'\Updownarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021D5;')"/></xsl:call-template></xsl:when>	<!--/Updownarrow A: up&down dbl arrow -->
		<xsl:when test="starts-with($content,'&#x021DA;')"><xsl:value-of select="'\Lleftarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021DA;')"/></xsl:call-template></xsl:when>	<!--/Lleftarrow A: left triple arrow --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x021DB;')"><xsl:value-of select="'\Rrightarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021DB;')"/></xsl:call-template></xsl:when>	<!--/Rrightarrow A: right triple arrow --> <!-- Required amssymb -->
<xsl:when test="starts-with($content,'&#x021DD;')"><xsl:value-of select="'\rightsquigarrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021DD;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x021F5;')"><xsl:value-of select="'\DownArrowUpArrow '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021F5;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x021FD;')"><xsl:value-of select="'\leftarrowtriangle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021FD;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x021FE;')"><xsl:value-of select="'\rightarrowtriangle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021FE;')"/></xsl:call-template></xsl:when>
<xsl:when test="starts-with($content,'&#x021FF;')"><xsl:value-of select="'\leftrightarrowtria* '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x021FF;')"/></xsl:call-template></xsl:when>
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	Mathematical Operators
	Range: 2200-22FF
	http://www.unicode.org/charts/PDF/U2200.pdf                         -->
<!-- ====================================================================== -->	
		<xsl:when test="starts-with($content,'&#x02200;')"><xsl:value-of select="'\forall '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02200;')"/></xsl:call-template></xsl:when>	<!--/forall for all -->
		<xsl:when test="starts-with($content,'&#x02201;')"><xsl:value-of select="'\complement '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02201;')"/></xsl:call-template></xsl:when>	<!--/complement - complement sign --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02202;')"><xsl:value-of select="'\partial '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02202;')"/></xsl:call-template></xsl:when>	<!--/partial partial differential -->
		<xsl:when test="starts-with($content,'&#x02203;')"><xsl:value-of select="'\exists '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02203;')"/></xsl:call-template></xsl:when>	<!--/exists at least one exists -->
		<xsl:when test="starts-with($content,'&#x02204;')"><xsl:value-of select="'\nexists '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02204;')"/></xsl:call-template></xsl:when>	<!--/nexists - negated exists --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02205;&#x0FE00;')"><xsl:value-of select="'\emptyset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02205;&#x0FE00;')"/></xsl:call-template></xsl:when>	<!--/emptyset - zero, slash -->
		<xsl:when test="starts-with($content,'&#x02205;')"><xsl:value-of select="'\varnothing '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02205;')"/></xsl:call-template></xsl:when>	<!--/varnothing - circle, slash --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02207;')"><xsl:value-of select="'\nabla '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02207;')"/></xsl:call-template></xsl:when>		<!--/nabla del, Hamilton operator -->
		<xsl:when test="starts-with($content,'&#x02208;')"><xsl:value-of select="'\in '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02208;')"/></xsl:call-template></xsl:when>		<!--/in R: set membership  -->
		<xsl:when test="starts-with($content,'&#x02209;')"><xsl:value-of select="'\notin '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02209;')"/></xsl:call-template></xsl:when>		<!--/notin N: negated set membership -->
		<xsl:when test="starts-with($content,'&#x0220B;')"><xsl:value-of select="'\ni '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0220B;')"/></xsl:call-template></xsl:when>		<!--/ni /owns R: contains -->
		<xsl:when test="starts-with($content,'&#x0220C;')"><xsl:value-of select="'\not\ni '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0220C;')"/></xsl:call-template></xsl:when>	<!--negated contains -->
		<xsl:when test="starts-with($content,'&#x0220F;')"><xsl:value-of select="'\prod '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0220F;')"/></xsl:call-template></xsl:when>		<!--/prod L: product operator -->
		<xsl:when test="starts-with($content,'&#x02210;')"><xsl:value-of select="'\coprod '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02210;')"/></xsl:call-template></xsl:when>	<!--/coprod L: coproduct operator -->
		<xsl:when test="starts-with($content,'&#x02211;')"><xsl:value-of select="'\sum '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02211;')"/></xsl:call-template></xsl:when>		<!--/sum L: summation operator -->
		<xsl:when test="starts-with($content,'&#x02212;')"><xsl:value-of select="'\minus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02212;')"/></xsl:call-template></xsl:when>		<!--B: minus sign -->		
		<xsl:when test="starts-with($content,'&#x02213;')"><xsl:value-of select="'\mp '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02213;')"/></xsl:call-template></xsl:when>		<!--/mp B: minus-or-plus sign -->
		<xsl:when test="starts-with($content,'&#x02214;')"><xsl:value-of select="'\dotplus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02214;')"/></xsl:call-template></xsl:when>	<!--/dotplus B: plus sign, dot above --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02216;')"><xsl:value-of select="'\setminus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02216;')"/></xsl:call-template></xsl:when>	<!--/setminus B: reverse solidus -->
		<xsl:when test="starts-with($content,'&#x02217;')"><xsl:value-of select="'\ast '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02217;')"/></xsl:call-template></xsl:when>		<!--low asterisk -->
		<xsl:when test="starts-with($content,'&#x02218;')"><xsl:value-of select="'\circ '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02218;')"/></xsl:call-template></xsl:when>		<!--/circ B: composite function (small circle) -->
		<xsl:when test="starts-with($content,'&#x02219;')"><xsl:value-of select="'\bullet '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02219;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0221A;')"><xsl:value-of select="'\surd '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0221A;')"/></xsl:call-template></xsl:when>		<!--/surd radical -->
		<xsl:when test="starts-with($content,'&#x0221D;')"><xsl:value-of select="'\propto '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0221D;')"/></xsl:call-template></xsl:when>	<!--/propto R: is proportional to -->
		<xsl:when test="starts-with($content,'&#x0221E;')"><xsl:value-of select="'\infty '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0221E;')"/></xsl:call-template></xsl:when>		<!--/infty infinity -->
		<xsl:when test="starts-with($content,'&#x0221F;')"><xsl:value-of select="'\rightangle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0221F;')"/></xsl:call-template></xsl:when>		<!--/right (90 degree) angle -->
		<xsl:when test="starts-with($content,'&#x02220;')"><xsl:value-of select="'\angle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02220;')"/></xsl:call-template></xsl:when>		<!--/angle - angle -->
		<xsl:when test="starts-with($content,'&#x02221;')"><xsl:value-of select="'\measuredangle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02221;')"/></xsl:call-template></xsl:when>	<!--/measuredangle - angle-measured -->	<!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02222;')"><xsl:value-of select="'\sphericalangle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02222;')"/></xsl:call-template></xsl:when><!--/sphericalangle angle-spherical -->	<!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02223;')"><xsl:value-of select="'\mid '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02223;')"/></xsl:call-template></xsl:when>		<!--/mid R: -->
		<xsl:when test="starts-with($content,'&#x02224;&#x0FE00;')"><xsl:value-of select="'\nshortmid '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02224;&#x0FE00;')"/></xsl:call-template></xsl:when>	<!--/nshortmid --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02224;')"><xsl:value-of select="'\nmid '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02224;')"/></xsl:call-template></xsl:when>		<!--/nmid --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02225;')"><xsl:value-of select="'\parallel '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02225;')"/></xsl:call-template></xsl:when>	<!--/parallel R: parallel -->
		<xsl:when test="starts-with($content,'&#x02226;&#x0FE00;')"><xsl:value-of select="'\nshortparallel '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02226;&#x0FE00;')"/></xsl:call-template></xsl:when>	<!--/nshortparallel N: not short par --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02226;')"><xsl:value-of select="'\nparallel '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02226;')"/></xsl:call-template></xsl:when>	<!--/nparallel N: not parallel --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02227;')"><xsl:value-of select="'\wedge '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02227;')"/></xsl:call-template></xsl:when>		<!--/wedge /land B: logical and -->
		<xsl:when test="starts-with($content,'&#x02228;')"><xsl:value-of select="'\vee '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02228;')"/></xsl:call-template></xsl:when>		<!--/vee /lor B: logical or -->
		<xsl:when test="starts-with($content,'&#x02229;')"><xsl:value-of select="'\cap '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02229;')"/></xsl:call-template></xsl:when>		<!--/cap B: intersection -->
		<xsl:when test="starts-with($content,'&#x0222A;')"><xsl:value-of select="'\cup '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0222A;')"/></xsl:call-template></xsl:when>		<!--/cup B: union or logical sum -->		
		<xsl:when test="starts-with($content,'&#x0222B;')"><xsl:value-of select="'\int '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0222B;')"/></xsl:call-template></xsl:when>		<!--/int L: integral operator -->
		<xsl:when test="starts-with($content,'&#x0222C;')"><xsl:value-of select="'\iint '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0222C;')"/></xsl:call-template></xsl:when>		<!--double integral operator --> <!-- Required amsmath -->
		<xsl:when test="starts-with($content,'&#x0222D;')"><xsl:value-of select="'\iiint '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0222D;')"/></xsl:call-template></xsl:when>		<!--/iiint triple integral operator -->	<!-- Required amsmath -->
		<xsl:when test="starts-with($content,'&#x0222E;')"><xsl:value-of select="'\oint '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0222E;')"/></xsl:call-template></xsl:when>		<!--/oint L: contour integral operator -->
		<xsl:when test="starts-with($content,'&#x0222F;')"><xsl:value-of select="'\oiint '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0222F;')"/></xsl:call-template></xsl:when>        <!-- \surfintegral -->
		<xsl:when test="starts-with($content,'&#x02230;')"><xsl:value-of select="'\oiiint '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02230;')"/></xsl:call-template></xsl:when>			<!-- \volintegral -->
		<xsl:when test="starts-with($content,'&#x02231;')"><xsl:value-of select="'\clwintegral '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02231;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02232;')"><xsl:value-of select="'\ElsevierGlyph{2232}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02232;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02233;')"><xsl:value-of select="'\ElsevierGlyph{2233}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02233;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02234;')"><xsl:value-of select="'\therefore '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02234;')"/></xsl:call-template></xsl:when>	<!--/therefore R: therefore --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02235;')"><xsl:value-of select="'\because '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02235;')"/></xsl:call-template></xsl:when>	<!--/because R: because --> <!-- Required amssymb -->
<!-- ? -->	<xsl:when test="starts-with($content,'&#x02236;')"><xsl:value-of select="':'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02236;')"/></xsl:call-template></xsl:when>		<!--/ratio -->
		<xsl:when test="starts-with($content,'&#x02237;')"><xsl:value-of select="'\Colon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02237;')"/></xsl:call-template></xsl:when>	<!--/Colon, two colons -->
		<xsl:when test="starts-with($content,'&#x02238;')"><xsl:value-of select="'\dotminus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02238;')"/></xsl:call-template></xsl:when>		<!--/dotminus B: minus sign, dot above -->
<!--		<xsl:when test="starts-with($content,'&#x02239;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02239;')"/></xsl:call-template></xsl:when>		-->
		<xsl:when test="starts-with($content,'&#x0223A;')"><xsl:value-of select="'\mathbin{{:}\!\!{-}\!\!{:}}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0223A;')"/></xsl:call-template></xsl:when> <!-- minus with four dots, geometric properties -->		
		<xsl:when test="starts-with($content,'&#x0223B;')"><xsl:value-of select="'\kernelcontraction '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0223B;')"/></xsl:call-template></xsl:when>			<!-- homothetic -->
		<xsl:when test="starts-with($content,'&#x0223C;')"><xsl:value-of select="'\sim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0223C;')"/></xsl:call-template></xsl:when>		<!--/sim R: similar -->
		<xsl:when test="starts-with($content,'&#x0223D;')"><xsl:value-of select="'\backsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0223D;')"/></xsl:call-template></xsl:when>	<!--/backsim R: reverse similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0223E;')"><xsl:value-of select="'\lazysinv '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0223E;')"/></xsl:call-template></xsl:when>			<!-- most positive -->
<!--		<xsl:when test="starts-with($content,'&#x0223F;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0223F;')"/></xsl:call-template></xsl:when>		ac current -->
		<xsl:when test="starts-with($content,'&#x02240;')"><xsl:value-of select="'\wr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02240;')"/></xsl:call-template></xsl:when>		<!--/wr B: wreath product -->
		<xsl:when test="starts-with($content,'&#x02241;')"><xsl:value-of select="'\nsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02241;')"/></xsl:call-template></xsl:when>		<!--/nsim N: not similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02242;&#x00338;')"><xsl:value-of select="'\neqsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02242;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02242;')"><xsl:value-of select="'\eqsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02242;')"/></xsl:call-template></xsl:when>		<!--/esim R: equals, similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02243;')"><xsl:value-of select="'\simeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02243;')"/></xsl:call-template></xsl:when>		<!--/simeq R: similar, equals -->
		<xsl:when test="starts-with($content,'&#x02244;')"><xsl:value-of select="'\nsime '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02244;')"/></xsl:call-template></xsl:when>		<!--/nsimeq N: not similar, equals -->
		<xsl:when test="starts-with($content,'&#x02245;')"><xsl:value-of select="'\cong '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02245;')"/></xsl:call-template></xsl:when>		<!--/cong R: congruent with -->
		<xsl:when test="starts-with($content,'&#x02246;')"><xsl:value-of select="'\approxnotequal '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02246;')"/></xsl:call-template></xsl:when><!--	similar, not equals -->
		<xsl:when test="starts-with($content,'&#x02247;')"><xsl:value-of select="'\ncong '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02247;')"/></xsl:call-template></xsl:when>		<!--/ncong N: not congruent with --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02248;')"><xsl:value-of select="'\approx '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02248;')"/></xsl:call-template></xsl:when>		<!--/approx R: approximate -->
<!--		<xsl:when test="starts-with($content,'&#x02249;&#x00338;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02249;&#x00338;')"/></xsl:call-template></xsl:when>	not, vert, approximate -->
		<xsl:when test="starts-with($content,'&#x02249;')"><xsl:value-of select="'\napprox '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02249;')"/></xsl:call-template></xsl:when>	<!--/napprox N: not approximate -->
		<xsl:when test="starts-with($content,'&#x0224A;')"><xsl:value-of select="'\approxeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224A;')"/></xsl:call-template></xsl:when>	<!--/approxeq R: approximate, equals --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0224B;&#x00338;')"><xsl:value-of select="'\not\apid '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224B;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0224B;')"><xsl:value-of select="'\tildetrpl '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224B;')"/></xsl:call-template></xsl:when>	<!--	approximately identical to -->
		<xsl:when test="starts-with($content,'&#x0224C;')"><xsl:value-of select="'\allequal '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224C;')"/></xsl:call-template></xsl:when>	<!-- /backcong R: reverse congruent -->
		<xsl:when test="starts-with($content,'&#x0224D;')"><xsl:value-of select="'\asymp '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224D;')"/></xsl:call-template></xsl:when>		<!--/asymp R: asymptotically equal to -->
		<xsl:when test="starts-with($content,'&#x0224E;&#x00338;')"><xsl:value-of select="'\nBumpeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224E;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0224E;')"><xsl:value-of select="'\Bumpeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224E;')"/></xsl:call-template></xsl:when>		<!--/Bumpeq R: bumpy equals --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0224F;&#x00338;')"><xsl:value-of select="'\nbumpeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224F;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0224F;')"><xsl:value-of select="'\bumpeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0224F;')"/></xsl:call-template></xsl:when>		<!--/bumpeq R: bumpy equals, equals --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02250;&#x00338;')"><xsl:value-of select="'\not\doteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02250;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02250;')"><xsl:value-of select="'\doteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02250;')"/></xsl:call-template></xsl:when>		<!--/doteq R: equals, single dot above -->
		<xsl:when test="starts-with($content,'&#x02251;')"><xsl:value-of select="'\Doteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02251;')"/></xsl:call-template></xsl:when>	<!--/doteqdot /Doteq R: eq, even dots --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02252;')"><xsl:value-of select="'\fallingdotseq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02252;')"/></xsl:call-template></xsl:when><!--/fallingdotseq R: eq, falling dots --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02253;')"><xsl:value-of select="'\risingdotseq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02253;')"/></xsl:call-template></xsl:when>	<!--/risingdotseq R: eq, rising dots --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02254;')"><xsl:value-of select="'\coloneq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02254;')"/></xsl:call-template></xsl:when>	<!--/coloneq R: colon, equals -->
		<xsl:when test="starts-with($content,'&#x02255;')"><xsl:value-of select="'\eqcolon '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02255;')"/></xsl:call-template></xsl:when>	<!--/eqcolon R: equals, colon -->
		<xsl:when test="starts-with($content,'&#x02256;')"><xsl:value-of select="'\eqcirc '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02256;')"/></xsl:call-template></xsl:when>		<!--/eqcirc R: circle on equals sign --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02257;')"><xsl:value-of select="'\circeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02257;')"/></xsl:call-template></xsl:when>		<!--/circeq R: circle, equals --> <!-- Required amssymb -->
<!-- ? -->	<xsl:when test="starts-with($content,'&#x02258;')"><xsl:value-of select="'\stackrel{\frown}{=}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02258;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02259;')"><xsl:value-of select="'\wedgeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02259;')"/></xsl:call-template></xsl:when>	<!--/wedgeq R: corresponds to (wedge, equals) -->
		<xsl:when test="starts-with($content,'&#x0225A;')"><xsl:value-of select="'\ElsevierGlyph{225A}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0225A;')"/></xsl:call-template></xsl:when>	<!--logical or, equals -->
		<xsl:when test="starts-with($content,'&#x0225B;')"><xsl:value-of select="'\starequal '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0225B;')"/></xsl:call-template></xsl:when>	<!--equal, asterisk above -->
		<xsl:when test="starts-with($content,'&#x0225C;')"><xsl:value-of select="'\triangleq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0225C;')"/></xsl:call-template></xsl:when>	<!--/triangleq R: triangle, equals --> <!-- Required amssymb -->
<!-- ? -->	<xsl:when test="starts-with($content,'&#x0225D;')"><xsl:value-of select="'\stackrel{\scriptscriptstyle\mathrm{def}}{=}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0225D;')"/></xsl:call-template></xsl:when>
<!-- ? -->	<xsl:when test="starts-with($content,'&#x0225E;')"><xsl:value-of select="'\stackrel{\scriptscriptstyle\mathrm{m}}{=}'" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0225E;')"/></xsl:call-template></xsl:when>	
		<xsl:when test="starts-with($content,'&#x0225F;')"><xsl:value-of select="'\questeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0225F;')"/></xsl:call-template></xsl:when>	<!--/questeq R: equal with questionmark -->
<!--		<xsl:when test="starts-with($content,'&#x02260;&#x0FE00;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02260;&#x0FE00;')"/></xsl:call-template></xsl:when>	not equal, dot -->
		<xsl:when test="starts-with($content,'&#x02260;')"><xsl:value-of select="'\ne '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02260;')"/></xsl:call-template></xsl:when>		<!--/ne /neq R: not equal -->
<!--		<xsl:when test="starts-with($content,'&#x02261;&#x020E5;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02261;&#x020E5;')"/></xsl:call-template></xsl:when>	reverse not equivalent -->
		<xsl:when test="starts-with($content,'&#x02261;')"><xsl:value-of select="'\equiv '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02261;')"/></xsl:call-template></xsl:when>		<!--/equiv R: identical with -->
		<xsl:when test="starts-with($content,'&#x02262;')"><xsl:value-of select="'\nequiv '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02262;')"/></xsl:call-template></xsl:when>	<!--/nequiv N: not identical with -->
<!--		<xsl:when test="starts-with($content,'&#x02263;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02263;')"/></xsl:call-template></xsl:when>		-->
		<xsl:when test="starts-with($content,'&#x02264;')"><xsl:value-of select="'\le '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02264;')"/></xsl:call-template></xsl:when>		<!--/leq /le R: less-than-or-equal -->
		<xsl:when test="starts-with($content,'&#x02265;')"><xsl:value-of select="'\ge '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02265;')"/></xsl:call-template></xsl:when>		<!--/geq /ge R: greater-than-or-equal -->
		<xsl:when test="starts-with($content,'&#x02266;')"><xsl:value-of select="'\leqq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02266;')"/></xsl:call-template></xsl:when>		<!--/leqq R: less, double equals --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02267;')"><xsl:value-of select="'\geqq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02267;')"/></xsl:call-template></xsl:when>		<!--/geqq R: greater, double equals --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02268;&#x0FE00;')"><xsl:value-of select="'\lvertneqq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02268;&#x0FE00;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02268;')"><xsl:value-of select="'\lneqq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02268;')"/></xsl:call-template></xsl:when>		<!--/lneqq N: less, not double equals --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02269;&#x0FE00;')"><xsl:value-of select="'\gvertneqq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02269;&#x0FE00;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02269;')"><xsl:value-of select="'\gneqq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02269;')"/></xsl:call-template></xsl:when>		<!--/gneqq N: greater, not dbl equals --> <!-- Required amssymb -->
<!--		<xsl:when test="starts-with($content,'&#x0226A;&#x00338;&#x0FE00;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226A;&#x00338;&#x0FE00;')"/></xsl:call-template></xsl:when>	not much less than, variant -->
		<xsl:when test="starts-with($content,'&#x0226A;&#x00338;')"><xsl:value-of select="'\NotLessLess '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226A;&#x00338;')"/></xsl:call-template></xsl:when>	<!-- not, vert, much less than -->
		<xsl:when test="starts-with($content,'&#x0226A;')"><xsl:value-of select="'\ll '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226A;')"/></xsl:call-template></xsl:when>		<!--/ll R: double less-than sign -->
<!--		<xsl:when test="starts-with($content,'&#x0226B;&#x00338;&#x0FE00;')"><xsl:value-of select="' '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226B;&#x00338;&#x0FE00;')"/></xsl:call-template></xsl:when>	not much greater than, variant -->
		<xsl:when test="starts-with($content,'&#x0226B;&#x00338;')"><xsl:value-of select="'\NotGreaterGreater '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226B;&#x00338;')"/></xsl:call-template></xsl:when>	<!-- not, vert, much greater than -->
		<xsl:when test="starts-with($content,'&#x0226B;')"><xsl:value-of select="'\gg '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226B;')"/></xsl:call-template></xsl:when>		<!--/gg R: dbl greater-than sign -->
		<xsl:when test="starts-with($content,'&#x0226C;')"><xsl:value-of select="'\between '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226C;')"/></xsl:call-template></xsl:when>	<!--/between R: between --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0226D;')"><xsl:value-of select="'\not\kern-0.3em\times '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226D;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0226E;')"><xsl:value-of select="'\nless '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226E;')"/></xsl:call-template></xsl:when>		<!--/nless N: not less-than --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0226F;')"><xsl:value-of select="'\ngtr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0226F;')"/></xsl:call-template></xsl:when>		<!--/ngtr N: not greater-than --> <!-- Required amssymb -->
<!--		<xsl:when test="starts-with($content,'&#x02270;&#x020E5;')"><xsl:value-of select="'\nleq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02270;&#x020E5;')"/></xsl:call-template></xsl:when>	/nleq N: not less-than-or-equal --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02270;')"><xsl:value-of select="'\nleq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02270;')"/></xsl:call-template></xsl:when>		<!--/nleqq N: not less, dbl equals --> <!-- Required amssymb -->
<!--		<xsl:when test="starts-with($content,'&#x02271;&#x020E5;')"><xsl:value-of select="'\ngeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02271;&#x020E5;')"/></xsl:call-template></xsl:when> /ngeq N: not greater-than-or-equal --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02271;')"><xsl:value-of select="'\ngeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02271;')"/></xsl:call-template></xsl:when>		<!--/ngeqq N: not greater, dbl equals --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02272;')"><xsl:value-of select="'\lesssim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02272;')"/></xsl:call-template></xsl:when>	<!--/lesssim R: less, similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02273;')"><xsl:value-of select="'\gtrsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02273;')"/></xsl:call-template></xsl:when>	<!--/gtrsim R: greater, similar --> <!-- Required amssymb -->		
		<xsl:when test="starts-with($content,'&#x02274;')"><xsl:value-of select="'\ElsevierGlyph{2274} '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02274;')"/></xsl:call-template></xsl:when>	<!--not less, similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02275;')"><xsl:value-of select="'\ElsevierGlyph{2275} '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02275;')"/></xsl:call-template></xsl:when>	<!--not greater, similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02276;')"><xsl:value-of select="'\lessgtr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02276;')"/></xsl:call-template></xsl:when>	<!--/lessgtr R: less, greater --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02277;')"><xsl:value-of select="'\gtrless '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02277;')"/></xsl:call-template></xsl:when>	<!--/gtrless R: greater, less --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02278;')"><xsl:value-of select="'\notlessgreater '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02278;')"/></xsl:call-template></xsl:when>	<!--not less, greater --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02279;')"><xsl:value-of select="'\notgreaterless '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02279;')"/></xsl:call-template></xsl:when>	<!--not greater, less --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0227A;')"><xsl:value-of select="'\prec '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227A;')"/></xsl:call-template></xsl:when>		<!--/prec R: precedes -->
		<xsl:when test="starts-with($content,'&#x0227B;')"><xsl:value-of select="'\succ '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227B;')"/></xsl:call-template></xsl:when>		<!--/succ R: succeeds -->
		<xsl:when test="starts-with($content,'&#x0227C;')"><xsl:value-of select="'\preccurlyeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227C;')"/></xsl:call-template></xsl:when>	<!--/preccurlyeq R: precedes, curly eq --> <!-- Required amssymb -->		
		<xsl:when test="starts-with($content,'&#x0227D;')"><xsl:value-of select="'\succcurlyeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227D;')"/></xsl:call-template></xsl:when>	<!--/succcurlyeq R: succeeds, curly eq --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0227E;&#x00338;')"><xsl:value-of select="'\nprecsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227E;&#x00338;')"/></xsl:call-template></xsl:when>	
		<xsl:when test="starts-with($content,'&#x0227E;')"><xsl:value-of select="'\precsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227E;')"/></xsl:call-template></xsl:when>	<!--/precsim R: precedes, similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x0227F;&#x00338;')"><xsl:value-of select="'\nsuccsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227F;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0227F;')"><xsl:value-of select="'\succsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0227F;')"/></xsl:call-template></xsl:when>	<!--/succsim R: succeeds, similar --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02280;')"><xsl:value-of select="'\nprec '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02280;')"/></xsl:call-template></xsl:when>		<!--/nprec N: not precedes --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02281;')"><xsl:value-of select="'\nsucc '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02281;')"/></xsl:call-template></xsl:when>		<!--/nsucc N: not succeeds --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x02282;')"><xsl:value-of select="'\subset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02282;')"/></xsl:call-template></xsl:when>	<!--/subset R: subset or is implied by -->
		<xsl:when test="starts-with($content,'&#x02283;')"><xsl:value-of select="'\supset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02283;')"/></xsl:call-template></xsl:when>	<!--/supset R: superset or implies -->
		<xsl:when test="starts-with($content,'&#x02284;')"><xsl:value-of select="'\nsubset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02284;')"/></xsl:call-template></xsl:when>	<!--not subset -->
		<xsl:when test="starts-with($content,'&#x02285;')"><xsl:value-of select="'\nsupset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02285;')"/></xsl:call-template></xsl:when>	<!--not superset -->
		<xsl:when test="starts-with($content,'&#x02286;')"><xsl:value-of select="'\subseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02286;')"/></xsl:call-template></xsl:when>	<!--/subseteq R: subset, equals -->
		<xsl:when test="starts-with($content,'&#x02287;')"><xsl:value-of select="'\supseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02287;')"/></xsl:call-template></xsl:when>	<!--/supseteq R: superset, equals -->
		<xsl:when test="starts-with($content,'&#x02288;')"><xsl:value-of select="'\nsubseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02288;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02289;')"><xsl:value-of select="'\nsupseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02289;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0228A;&#x0FE00;')"><xsl:value-of select="'\varsubsetneqq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228A;&#x0FE00;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0228A;')"><xsl:value-of select="'\subsetneq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0228B;&#x0FE00;')"><xsl:value-of select="'\varsupsetneq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228B;&#x0FE00;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0228B;')"><xsl:value-of select="'\supsetneq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228B;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0228D;')"><xsl:value-of select="'\cupdot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228D;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0228E;')"><xsl:value-of select="'\uplus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228E;')"/></xsl:call-template></xsl:when>		<!--/uplus B: plus sign in union -->
		<xsl:when test="starts-with($content,'&#x0228F;&#x00338;')"><xsl:value-of select="'\NotSquareSubset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228F;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0228F;')"><xsl:value-of select="'\sqsubset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0228F;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02290;&#x00338;')"><xsl:value-of select="'\NotSquareSuperset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02290;&#x00338;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02290;')"><xsl:value-of select="'\sqsupset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02290;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02291;')"><xsl:value-of select="'\sqsubseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02291;')"/></xsl:call-template></xsl:when>		
		<xsl:when test="starts-with($content,'&#x02292;')"><xsl:value-of select="'\sqsupseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02292;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x02293;')"><xsl:value-of select="'\sqcap '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02293;')"/></xsl:call-template></xsl:when>		<!--/sqcap B: square intersection -->
		<xsl:when test="starts-with($content,'&#x02294;')"><xsl:value-of select="'\sqcup '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02294;')"/></xsl:call-template></xsl:when>		<!--/sqcup B: square union -->
		<xsl:when test="starts-with($content,'&#x02295;')"><xsl:value-of select="'\oplus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02295;')"/></xsl:call-template></xsl:when>		<!--/oplus B: plus sign in circle -->
		<xsl:when test="starts-with($content,'&#x02296;')"><xsl:value-of select="'\ominus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02296;')"/></xsl:call-template></xsl:when>	<!--/ominus B: minus sign in circle -->
		<xsl:when test="starts-with($content,'&#x02297;')"><xsl:value-of select="'\otimes '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02297;')"/></xsl:call-template></xsl:when>	<!--/otimes B: multiply sign in circle -->
		<xsl:when test="starts-with($content,'&#x02298;')"><xsl:value-of select="'\oslash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02298;')"/></xsl:call-template></xsl:when>	<!--/oslash B: solidus in circle -->
		<xsl:when test="starts-with($content,'&#x02299;')"><xsl:value-of select="'\odot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02299;')"/></xsl:call-template></xsl:when>		<!--/odot B: middle dot in circle --> <!--/bigodot L: circle dot operator -->
		<xsl:when test="starts-with($content,'&#x0229A;')"><xsl:value-of select="'\circledcirc '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0229A;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0229B;')"><xsl:value-of select="'\circledast '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0229B;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0229D;')"><xsl:value-of select="'\circleddash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0229D;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0229E;')"><xsl:value-of select="'\boxplus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0229E;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x0229F;')"><xsl:value-of select="'\boxminus '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0229F;')"/></xsl:call-template></xsl:when>	<!--/boxminus B: minus sign in box --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x022A0;')"><xsl:value-of select="'\boxtimes '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022A1;')"><xsl:value-of select="'\boxdot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A1;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022A2;')"><xsl:value-of select="'\vdash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022A3;')"><xsl:value-of select="'\dashv '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022A4;')"><xsl:value-of select="'\top '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A4;')"/></xsl:call-template></xsl:when>		<!--/top top -->
		<xsl:when test="starts-with($content,'&#x022A5;')"><xsl:value-of select="'\perp '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A5;')"/></xsl:call-template></xsl:when>		<!--/perp R: perpendicular --><!--/bot bottom -->
<!--		<xsl:when test="starts-with($content,'&#x022A6;')"><xsl:value-of select="'\vdash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A6;')"/></xsl:call-template></xsl:when> /vdash R: vertical, dash -->
		<xsl:when test="starts-with($content,'&#x022A7;')"><xsl:value-of select="'\models '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A7;')"/></xsl:call-template></xsl:when>		<!--/vDash R: vertical, dbl dash --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x022A8;')"><xsl:value-of select="'\vDash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A8;')"/></xsl:call-template></xsl:when>	<!--/models R: -->
		<xsl:when test="starts-with($content,'&#x022A9;')"><xsl:value-of select="'\Vdash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022A9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022AA;')"><xsl:value-of select="'\Vvdash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022AA;')"/></xsl:call-template></xsl:when>	<!--/Vvdash R: triple vertical, dash --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x022AB;')"><xsl:value-of select="'\VDash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022AB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022AC;')"><xsl:value-of select="'\nvdash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022AC;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022AD;')"><xsl:value-of select="'\nvDash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022AD;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022AE;')"><xsl:value-of select="'\nVdash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022AE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022AF;')"><xsl:value-of select="'\nVDash '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022AF;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B2;')"><xsl:value-of select="'\vartriangleleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B3;')"><xsl:value-of select="'\vartriangleright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B4;')"><xsl:value-of select="'\trianglelefteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B5;')"><xsl:value-of select="'\trianglerighteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B5;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B6;')"><xsl:value-of select="'\original '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B6;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B7;')"><xsl:value-of select="'\image '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B8;')"><xsl:value-of select="'\multimap '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022B9;')"><xsl:value-of select="'\hermitconjmatrix '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022B9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022BA;')"><xsl:value-of select="'\intercal '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022BA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022BB;')"><xsl:value-of select="'\veebar '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022BB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022BE;')"><xsl:value-of select="'\rightanglearc '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022BE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022C0;')"><xsl:value-of select="'\bigwedge '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C0;')"/></xsl:call-template></xsl:when>	<!--/bigwedge L: logical or operator -->
		<xsl:when test="starts-with($content,'&#x022C1;')"><xsl:value-of select="'\bigvee '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C1;')"/></xsl:call-template></xsl:when>	<!--/bigcap L: intersection operator -->
		<xsl:when test="starts-with($content,'&#x022C2;')"><xsl:value-of select="'\bigcap '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C2;')"/></xsl:call-template></xsl:when>	<!--/bigvee L: logical and operator -->
		<xsl:when test="starts-with($content,'&#x022C3;')"><xsl:value-of select="'\bigcup '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C3;')"/></xsl:call-template></xsl:when>	<!--/bigcup L: union operator -->
		<xsl:when test="starts-with($content,'&#x022C4;')"><xsl:value-of select="'\diamond '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C4;')"/></xsl:call-template></xsl:when>	<!--/diamond B: open diamond -->
		<xsl:when test="starts-with($content,'&#x022C5;')"><xsl:value-of select="'\cdot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C5;')"/></xsl:call-template></xsl:when>		<!--/cdot B: small middle dot -->
		<xsl:when test="starts-with($content,'&#x022C6;')"><xsl:value-of select="'\star '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C6;')"/></xsl:call-template></xsl:when>		<!--/star B: small star, filled -->
		<xsl:when test="starts-with($content,'&#x022C7;')"><xsl:value-of select="'\divideontimes '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C7;')"/></xsl:call-template></xsl:when>	<!--/divideontimes B: division on times --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x022C8;')"><xsl:value-of select="'\bowtie '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C8;')"/></xsl:call-template></xsl:when>	<!--/bowtie R: -->
		<xsl:when test="starts-with($content,'&#x022C9;')"><xsl:value-of select="'\ltimes '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022C9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022CA;')"><xsl:value-of select="'\rtimes '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022CA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022CB;')"><xsl:value-of select="'\leftthreetimes '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022CB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022CC;')"><xsl:value-of select="'\rightthreetimes '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022CC;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022CD;')"><xsl:value-of select="'\backsimeq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022CD;')"/></xsl:call-template></xsl:when>	<!--/backsimeq R: reverse similar, eq --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x022CE;')"><xsl:value-of select="'\curlyvee '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022CE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022CF;')"><xsl:value-of select="'\curlywedge '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022CF;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D0;')"><xsl:value-of select="'\Subset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D0;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D1;')"><xsl:value-of select="'\Supset '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D1;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D2;')"><xsl:value-of select="'\Cap '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D3;')"><xsl:value-of select="'\Cup '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D4;')"><xsl:value-of select="'\pitchfork '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D4;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D6;')"><xsl:value-of select="'\lessdot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D6;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D7;')"><xsl:value-of select="'\gtrdot '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D8;')"><xsl:value-of select="'\verymuchless '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022D9;')"><xsl:value-of select="'\ggg '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022D9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022DA;')"><xsl:value-of select="'\lesseqgtr '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022DA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022DB;')"><xsl:value-of select="'\gtreqless '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022DB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022DE;')"><xsl:value-of select="'\curlyeqprec '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022DE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022DF;')"><xsl:value-of select="'\curlyeqsucc '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022DF;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022E2;')"><xsl:value-of select="'\not\sqsubseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022E2;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022E3;')"><xsl:value-of select="'\not\sqsupseteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022E3;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022E5;')"><xsl:value-of select="'\Elzsqspne '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022E5;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022E6;')"><xsl:value-of select="'\lnsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022E6;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022E7;')"><xsl:value-of select="'\gnsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022E7;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022E8;')"><xsl:value-of select="'\precnsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022E8;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022E9;')"><xsl:value-of select="'\succnsim '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022E9;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022EA;')"><xsl:value-of select="'\ntriangleleft '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022EA;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022EB;')"><xsl:value-of select="'\ntriangleright '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022EB;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022EC;')"><xsl:value-of select="'\ntrianglelefteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022EC;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022ED;')"><xsl:value-of select="'\ntrianglerighteq '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022ED;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022EE;')"><xsl:value-of select="'\vdots '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022EE;')"/></xsl:call-template></xsl:when>
		<xsl:when test="starts-with($content,'&#x022EF;')"><xsl:value-of select="'\cdots '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022EF;')"/></xsl:call-template></xsl:when>	<!--/cdots, three dots, centered -->
		<xsl:when test="starts-with($content,'&#x022F0;')"><xsl:value-of select="'\adots '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022F0;')"/></xsl:call-template></xsl:when>	<!-- three dots, ascending -->
		<xsl:when test="starts-with($content,'&#x022F1;')"><xsl:value-of select="'\ddots '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x022F1;')"/></xsl:call-template></xsl:when>	<!--/ddots, three dots, descending -->
<!-- ====================================================================== -->
<!-- 	Unicode 3.2
	Miscellaneous Technical
	Range: 2300-23FF
	http://www.unicode.org/charts/PDF/U2300.pdf                         -->
<!-- ====================================================================== -->	
		<xsl:when test="starts-with($content,'&#x02308;')"><xsl:value-of select="'\lceil '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02308;')"/></xsl:call-template></xsl:when>	<!--/lceil O: left ceiling -->
		<xsl:when test="starts-with($content,'&#x02309;')"><xsl:value-of select="'\rceil '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02309;')"/></xsl:call-template></xsl:when>	<!--/rceil C: right ceiling -->
		<xsl:when test="starts-with($content,'&#x0230A;')"><xsl:value-of select="'\lfloor '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0230A;')"/></xsl:call-template></xsl:when>	<!--/lfloor O: left floor -->
		<xsl:when test="starts-with($content,'&#x0230B;')"><xsl:value-of select="'\rfloor '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0230B;')"/></xsl:call-template></xsl:when>	<!--/rfloor C: right floor -->
		<xsl:when test="starts-with($content,'&#x02329;')"><xsl:value-of select="'\langle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02329;')"/></xsl:call-template></xsl:when>	<!--/langle O: left angle bracket -->
		<xsl:when test="starts-with($content,'&#x0232A;')"><xsl:value-of select="'\rangle '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0232A;')"/></xsl:call-template></xsl:when>	<!--/rangle O: right angle bracket -->
<!-- ====================================================================== -->		
		<xsl:when test="starts-with($content,'&#x025A1;')"><xsl:value-of select="'\square '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x025A1;')"/></xsl:call-template></xsl:when>	<!--/square, square --> <!-- Required amssymb -->
		<xsl:when test="starts-with($content,'&#x025AA;')"><xsl:value-of select="'\blacksquare '" /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '&#x025AA;')"/></xsl:call-template></xsl:when>	<!--/blacksquare, square, filled  --> <!-- Required amssymb -->
		
		<xsl:when test='starts-with($content,"&apos;")'><xsl:value-of select='"\text{&apos;}"' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select='substring-after($content, "&apos;")'/></xsl:call-template></xsl:when><!-- \text required amslatex -->

		<xsl:when test='starts-with($content,"{")'><xsl:value-of select='"\{"' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '{')"/></xsl:call-template></xsl:when>
		<xsl:when test='starts-with($content,"}")'><xsl:value-of select='"\}"' /><xsl:call-template name="replaceEntities"><xsl:with-param name="content" select="substring-after($content, '}')"/></xsl:call-template></xsl:when>

		<xsl:otherwise>
			<xsl:value-of select="substring($content,1,1)"/>
			<xsl:call-template name="replaceEntities">
				<xsl:with-param name="content" select="substring($content, 2)"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose></xsl:if>
</xsl:template>

<xsl:template name="replaceMtextEntities">
	<xsl:param name="content"/>
	<xsl:if test="string-length($content)>0">
		<xsl:choose>
			<xsl:when test="starts-with($content,'&#x02009;&#x0200A;&#x0200A;')"><xsl:value-of select='"\hspace{0.28em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02009;&#x0200A;&#x0200A;')"/></xsl:call-template></xsl:when> <!-- ThickSpace - space of width 5/18 em -->
			<xsl:when test="starts-with($content,'&#x02002;')"><xsl:value-of select='"\hspace{0.5em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02002;')"/></xsl:call-template></xsl:when> <!-- en space (1/2-em) -->
			<xsl:when test="starts-with($content,'&#x02003;')"><xsl:value-of select='"\hspace{1em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02003;')"/></xsl:call-template></xsl:when> <!-- emsp - space of width 1em -->
			<xsl:when test="starts-with($content,'&#x02004;')"><xsl:value-of select='"\hspace{0.33em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02004;')"/></xsl:call-template></xsl:when> <!-- emsp13 - space of width 1/3 em -->
			<xsl:when test="starts-with($content,'&#x02005;')"><xsl:value-of select='"\hspace{0.25em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02005;')"/></xsl:call-template></xsl:when> <!-- ThickSpace - space of width 1/4 em -->
			<xsl:when test="starts-with($content,'&#x02009;')"><xsl:value-of select='"\hspace{0.17em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x02009;')"/></xsl:call-template></xsl:when> <!-- ThinSpace - space of width 3/18 em -->
			<xsl:when test="starts-with($content,'&#x0200A;')"><xsl:value-of select='"\hspace{0.05em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0200A;')"/></xsl:call-template></xsl:when>
			<xsl:when test="starts-with($content,'&#x0200B;')"><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0200B;')"/></xsl:call-template></xsl:when>	<!--zero width space -->
			<xsl:when test="starts-with($content,'&#x0205F;')"><xsl:value-of select='"\hspace{0.22em}"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&#x0205F;')"/></xsl:call-template></xsl:when>
			<xsl:when test='starts-with($content,"$")'><xsl:value-of select='"\$"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '$')"/></xsl:call-template></xsl:when>
			<xsl:when test='starts-with($content,"#")'><xsl:value-of select='"\#"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '#')"/></xsl:call-template></xsl:when>
			<xsl:when test='starts-with($content,"&amp;")'><xsl:value-of select='"\&amp;"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '&amp;')"/></xsl:call-template></xsl:when>
			<xsl:when test='starts-with($content,"%")'><xsl:value-of select='"\%"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '%')"/></xsl:call-template></xsl:when>
			<xsl:when test='starts-with($content,"_")'><xsl:value-of select='"\_"' /><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '_')"/></xsl:call-template></xsl:when>
			<xsl:when test='starts-with($content,"\")'><xsl:call-template name="replaceMtextEntities"><xsl:with-param name="content" select="substring-after($content, '\')"/></xsl:call-template></xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring($content,1,1)"/>
				<xsl:call-template name="replaceMtextEntities">
					<xsl:with-param name="content" select="substring($content, 2)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>