/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.RedisException;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.ObjectOutput;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueOutput;
import io.lettuce.core.output.ValueStreamingChannel;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.nio.ByteBuffer;

public class BaseRedisCommandBuilder<K, V> {
    protected static final String MUST_NOT_CONTAIN_NULL_ELEMENTS = "must not contain null elements";
    protected static final String MUST_NOT_BE_EMPTY = "must not be empty";
    protected static final String MUST_NOT_BE_NULL = "must not be null";
    protected static final byte[] MINUS_BYTES = new byte[]{45};
    protected static final byte[] PLUS_BYTES = new byte[]{43};
    protected final RedisCodec<K, V> codec;

    public BaseRedisCommandBuilder(RedisCodec<K, V> codec) {
        this.codec = codec;
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output) {
        return this.createCommand(type, output, (CommandArgs)null);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key);
        return this.createCommand(type, output, args);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key, V value) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addValue(value);
        return this.createCommand(type, output, args);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, K key, V[] values) {
        CommandArgs<K, V> args = new CommandArgs<K, V>(this.codec).addKey(key).addValues(values);
        return this.createCommand(type, output, args);
    }

    protected <T> Command<K, V, T> createCommand(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        return new Command<K, V, T>(type, output, args);
    }

    protected <T> CommandOutput<K, V, T> newScriptOutput(RedisCodec<K, V> codec, ScriptOutputType type) {
        switch (type) {
            case BOOLEAN: {
                return new BooleanOutput<K, V>(codec);
            }
            case INTEGER: {
                return new IntegerOutput<K, V>(codec);
            }
            case STATUS: {
                return new StatusOutput<K, V>(codec);
            }
            case MULTI: {
                return new NestedMultiOutput<K, V>(codec);
            }
            case VALUE: {
                return new ValueOutput<K, V>(codec);
            }
            case OBJECT: {
                return new ObjectOutput<K, V>(codec);
            }
        }
        throw new RedisException("Unsupported script output type");
    }

    protected boolean allElementsInstanceOf(Object[] objects, Class<?> expectedAssignableType) {
        for (Object object : objects) {
            if (expectedAssignableType.isAssignableFrom(object.getClass())) continue;
            return false;
        }
        return true;
    }

    protected byte[] maxValue(Range<? extends V> range) {
        Range.Boundary<V> upper = range.getUpper();
        if (upper.getValue() == null) {
            return PLUS_BYTES;
        }
        ByteBuffer encoded = this.codec.encodeValue(upper.getValue());
        ByteBuffer allocated = ByteBuffer.allocate(encoded.remaining() + 1);
        allocated.put(upper.isIncluding() ? (byte)91 : 40).put(encoded);
        return allocated.array();
    }

    protected byte[] minValue(Range<? extends V> range) {
        Range.Boundary<V> lower = range.getLower();
        if (lower.getValue() == null) {
            return MINUS_BYTES;
        }
        ByteBuffer encoded = this.codec.encodeValue(lower.getValue());
        ByteBuffer allocated = ByteBuffer.allocate(encoded.remaining() + 1);
        allocated.put(lower.isIncluding() ? (byte)91 : 40).put(encoded);
        return allocated.array();
    }

    protected static void notNull(ScoredValueStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, "ScoredValueStreamingChannel must not be null");
    }

    protected static void notNull(KeyStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, "KeyValueStreamingChannel must not be null");
    }

    protected static void notNull(ValueStreamingChannel<?> channel) {
        LettuceAssert.notNull(channel, "ValueStreamingChannel must not be null");
    }

    protected static void notNull(KeyValueStreamingChannel<?, ?> channel) {
        LettuceAssert.notNull(channel, "KeyValueStreamingChannel must not be null");
    }

    protected static void notNullMinMax(String min, String max) {
        LettuceAssert.notNull((Object)min, "Min must not be null");
        LettuceAssert.notNull((Object)max, "Max must not be null");
    }

    protected static void addLimit(CommandArgs<?, ?> args, Limit limit) {
        if (limit.isLimited()) {
            args.add(CommandKeyword.LIMIT).add(limit.getOffset()).add(limit.getCount());
        }
    }

    protected static void assertNodeId(String nodeId) {
        LettuceAssert.notNull((Object)nodeId, "NodeId must not be null");
        LettuceAssert.notEmpty((CharSequence)nodeId, "NodeId must not be empty");
    }

    protected static String max(Range<? extends Number> range) {
        Range.Boundary<? extends Number> upper = range.getUpper();
        if (upper.getValue() == null || upper.getValue() instanceof Double && upper.getValue().doubleValue() == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (!upper.isIncluding()) {
            return "(" + upper.getValue();
        }
        return upper.getValue().toString();
    }

    protected static String min(Range<? extends Number> range) {
        Range.Boundary<? extends Number> lower = range.getLower();
        if (lower.getValue() == null || lower.getValue() instanceof Double && lower.getValue().doubleValue() == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (!lower.isIncluding()) {
            return "(" + lower.getValue();
        }
        return lower.getValue().toString();
    }

    protected static void notEmpty(Object[] keys) {
        LettuceAssert.notNull((Object)keys, "Keys must not be null");
        LettuceAssert.notEmpty(keys, "Keys must not be empty");
    }

    protected static void notEmptySlots(int[] slots) {
        LettuceAssert.notNull((Object)slots, "Slots must not be null");
        LettuceAssert.notEmpty(slots, "Slots must not be empty");
    }

    protected static void notEmptyValues(Object[] values) {
        LettuceAssert.notNull((Object)values, "Values must not be null");
        LettuceAssert.notEmpty(values, "Values must not be empty");
    }

    protected static void notNullKey(Object key) {
        LettuceAssert.notNull(key, "Key must not be null");
    }

    protected static void keyAndFieldsProvided(Object key, Object[] fields) {
        LettuceAssert.notNull(key, "Key must not be null");
        LettuceAssert.notEmpty(fields, "Fields must not be empty");
    }

    protected static void notNullLimit(Limit limit) {
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
    }

    protected static void notNullRange(Range<?> range) {
        LettuceAssert.notNull(range, "Range must not be null");
    }

    protected static void notEmptyRanges(Range<?>[] ranges) {
        LettuceAssert.notEmpty((Object[])ranges, "Ranges must not be null");
    }
}

