/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.lettuce.core.json.DelegateJsonValue;
import io.lettuce.core.json.JsonObject;
import io.lettuce.core.json.JsonValue;

class DelegateJsonObject
extends DelegateJsonValue
implements JsonObject {
    DelegateJsonObject() {
        super((JsonNode)new ObjectNode(JsonNodeFactory.instance));
    }

    DelegateJsonObject(JsonNode node) {
        super(node);
    }

    @Override
    public JsonObject put(String key, JsonValue element) {
        JsonNode newNode = ((DelegateJsonValue)element).getNode();
        ((ObjectNode)this.node).replace(key, newNode);
        return this;
    }

    @Override
    public JsonValue get(String key) {
        JsonNode value = this.node.get(key);
        return value == null ? null : DelegateJsonObject.wrap(value);
    }

    @Override
    public JsonValue remove(String key) {
        JsonNode value = ((ObjectNode)this.node).remove(key);
        return DelegateJsonObject.wrap(value);
    }

    @Override
    public int size() {
        return this.node.size();
    }

    @Override
    public JsonObject asJsonObject() {
        return this;
    }
}

