/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openstreetmap.josm.tools.Utils;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> reversedStream(List<T> list) {
        Objects.requireNonNull(list, "list");
        int size = list.size();
        return IntStream.range(0, size).mapToObj(i -> list.get(size - i - 1));
    }

    public static Collector<String, ?, String> toHtmlList() {
        return Collector.of(() -> new StringJoiner("</li><li>", "<ul><li>", "</li></ul>").setEmptyValue("<ul></ul>"), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Utils::toUnmodifiableList);
    }
}

