/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;

public class AppletDesc
implements LaunchDesc {
    private final String name;
    private final String mainClass;
    private final URL documentBase;
    private final int width;
    private final int height;
    private final Map<String, String> parameters;

    public AppletDesc(String name, String mainClass, URL documentBase, int width, int height, Map<String, String> parameters) {
        this.name = name;
        this.mainClass = mainClass;
        this.documentBase = documentBase;
        this.width = width;
        this.height = height;
        this.parameters = new HashMap<String, String>(parameters);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public int getWidth() {
        Integer nww;
        if (this.width < Integer.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.small.size.treshold")) && (nww = this.fixWidth()) != null) {
            return nww;
        }
        return this.width;
    }

    public int getHeight() {
        Integer nwh;
        if (this.height < Integer.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.small.size.treshold")) && (nwh = this.fixHeight()) != null) {
            return nwh;
        }
        return this.height;
    }

    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    private Integer fixHeight() {
        return this.fixSize("deployment.small.size.override.height", "Height", "height", "HEIGHT");
    }

    private Integer fixWidth() {
        return this.fixSize("deployment.small.size.override.width", "Width", "width", "WIDTH");
    }

    private Integer fixSize(String depKey, String ... keys) {
        OutputController.getLogger().log("Found to small applet!");
        try {
            Integer depVal = Integer.valueOf(JNLPRuntime.getConfiguration().getProperty(depKey));
            if (depVal == 0) {
                OutputController.getLogger().log("using its size");
                return null;
            }
            if (depVal < 0) {
                OutputController.getLogger().log("enforcing " + depVal);
                return Math.abs(depVal);
            }
            for (String key : keys) {
                String sizeFromParam = this.parameters.get(key);
                if (sizeFromParam == null) continue;
                try {
                    OutputController.getLogger().log("using its " + key + "=" + sizeFromParam);
                    return Integer.valueOf(sizeFromParam);
                }
                catch (NumberFormatException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
            OutputController.getLogger().log("defaulting to " + depVal);
            return depVal;
        }
        catch (NullPointerException | NumberFormatException ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            return null;
        }
    }
}

