/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.PropertiesAssociations;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterGraphML
implements FileImporter,
LongTask {
    private static final String GRAPHML = "graphml";
    private static final String GRAPH = "graph";
    private static final String GRAPH_DEFAULT_EDGETYPE = "edgedefault";
    private static final String GRAPH_ID = "id";
    private static final String NODE = "node";
    private static final String NODE_ID = "id";
    private static final String EDGE = "edge";
    private static final String EDGE_ID = "id";
    private static final String EDGE_SOURCE = "source";
    private static final String EDGE_TARGET = "target";
    private static final String EDGE_DIRECTED = "directed";
    private static final String EDGE_TYPE = "label";
    private static final String ATTRIBUTE = "key";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_TITLE = "attr.name";
    private static final String ATTRIBUTE_TYPE = "attr.type";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTE_FOR = "for";
    private static final String ATTVALUE = "data";
    private static final String ATTVALUE_FOR = "key";
    private static final String DESC = "desc";
    private final PropertiesAssociations properties = new PropertiesAssociations();
    private final HashMap<String, PropertiesAssociations.NodeProperties> nodePropertiesAttributes = new HashMap();
    private final HashMap<String, PropertiesAssociations.EdgeProperties> edgePropertiesAttributes = new HashMap();
    private Reader reader;
    private ContainerLoader container;
    private EdgeDirection edgeDefault;
    private boolean cancel;
    private Report report;
    private ProgressTicket progress;
    private XMLStreamReader xmlReader;

    public ImporterGraphML() {
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.LABEL, EDGE_TYPE);
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.LABEL, "nodelabel");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.X, "x");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.Y, "y");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.Z, "z");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.X, "xpos");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.Y, "ypos");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.Z, "zpos");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.SIZE, "size");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.R, "r");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.G, "g");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.B, "b");
        this.properties.addNodePropertyAssociation(PropertiesAssociations.NodeProperties.COLOR, "color");
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.LABEL, EDGE_TYPE);
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.LABEL, "edgelabel");
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.WEIGHT, "weight");
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.WEIGHT, "Edge Weight");
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.R, "r");
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.G, "g");
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.B, "b");
        this.properties.addEdgePropertyAssociation(PropertiesAssociations.EdgeProperties.COLOR, "color");
    }

    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        Progress.start((ProgressTicket)this.progress);
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            }
            inputFactory.setXMLReporter(new XMLReporter(){

                @Override
                public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                }
            });
            this.xmlReader = inputFactory.createXMLStreamReader(this.reader);
            while (this.xmlReader.hasNext()) {
                String name;
                Integer eventType = this.xmlReader.next();
                if (eventType.equals(1)) {
                    name = this.xmlReader.getLocalName();
                    if (GRAPHML.equalsIgnoreCase(name)) continue;
                    if (GRAPH.equalsIgnoreCase(name)) {
                        this.readGraph(this.xmlReader);
                        continue;
                    }
                    if (NODE.equalsIgnoreCase(name)) {
                        this.readNode(this.xmlReader, null);
                        continue;
                    }
                    if (EDGE.equalsIgnoreCase(name)) {
                        this.readEdge(this.xmlReader);
                        continue;
                    }
                    if (!"key".equalsIgnoreCase(name)) continue;
                    this.readAttribute(this.xmlReader);
                    continue;
                }
                if (eventType.equals(2) && !NODE.equalsIgnoreCase(name = this.xmlReader.getLocalName())) continue;
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.xmlReader.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        Progress.finish((ProgressTicket)this.progress);
        return !this.cancel;
    }

    private void readGraph(XMLStreamReader reader) throws Exception {
        String id = "";
        String defaultEdgeType = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (GRAPH_DEFAULT_EDGETYPE.equalsIgnoreCase(attName)) {
                defaultEdgeType = reader.getAttributeValue(i).trim();
                continue;
            }
            if (!"id".equalsIgnoreCase(attName)) continue;
            id = reader.getAttributeValue(i);
        }
        this.container.setEdgeDefault(EdgeDirectionDefault.MIXED);
        this.edgeDefault = EdgeDirection.DIRECTED;
        if (!defaultEdgeType.isEmpty()) {
            if (defaultEdgeType.equalsIgnoreCase("undirected")) {
                this.edgeDefault = EdgeDirection.UNDIRECTED;
            } else if (defaultEdgeType.equalsIgnoreCase(EDGE_DIRECTED)) {
                this.edgeDefault = EdgeDirection.DIRECTED;
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_defaultedgetype", (Object)defaultEdgeType), Issue.Level.SEVERE));
            }
        }
    }

    private void readNode(XMLStreamReader reader, NodeDraft parent) throws Exception {
        String id = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (!"id".equalsIgnoreCase(attName)) continue;
            id = reader.getAttributeValue(i);
        }
        if (id.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_nodeid"), Issue.Level.SEVERE));
            return;
        }
        NodeDraft node = null;
        node = this.container.nodeExists(id) ? this.container.getNode(id) : this.container.factory().newNodeDraft(id);
        if (!this.container.nodeExists(id)) {
            this.container.addNode(node);
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = this.xmlReader.getLocalName();
                    if (ATTVALUE.equalsIgnoreCase(this.xmlReader.getLocalName())) {
                        this.readNodeAttValue(reader, node);
                        break;
                    }
                    if (NODE.equalsIgnoreCase(name)) {
                        this.readNode(reader, node);
                        break;
                    }
                    if (!DESC.equals(name)) break;
                    this.readDesc(reader, (ElementDraft)node);
                    break;
                }
                case 2: {
                    if (!NODE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    private void readNodeAttValue(XMLStreamReader reader, NodeDraft node) throws Exception {
        String fore = "";
        Object value = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (!"key".equalsIgnoreCase(attName)) continue;
            fore = reader.getAttributeValue(i).trim();
        }
        if (fore.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_datakey", (Object)node), Issue.Level.SEVERE));
            return;
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            int xmltype = reader.next();
            switch (xmltype) {
                case 4: 
                case 12: {
                    if (this.xmlReader.isWhiteSpace()) break;
                    value = (String)value + this.xmlReader.getText();
                    break;
                }
                case 2: {
                    if (!ATTVALUE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (!((String)value).isEmpty()) {
            ColumnDraft column;
            PropertiesAssociations.NodeProperties prop = this.nodePropertiesAttributes.get(fore);
            if (prop != null) {
                try {
                    switch (prop) {
                        case X: {
                            node.setX(this.parseFloat((String)value));
                            break;
                        }
                        case Y: {
                            node.setY(this.parseFloat((String)value));
                            break;
                        }
                        case Z: {
                            node.setZ(this.parseFloat((String)value));
                            break;
                        }
                        case SIZE: {
                            node.setSize(this.parseFloat((String)value));
                            break;
                        }
                        case LABEL: {
                            node.setLabel((String)value);
                            break;
                        }
                        case COLOR: {
                            node.setColor((String)value);
                            break;
                        }
                        case R: {
                            if (node.getColor() == null) {
                                node.setColor(Integer.parseInt((String)value), 0, 0);
                                break;
                            }
                            node.setColor(Integer.parseInt((String)value), node.getColor().getGreen(), node.getColor().getBlue());
                            break;
                        }
                        case G: {
                            if (node.getColor() == null) {
                                node.setColor(0, Integer.parseInt((String)value), 0);
                                break;
                            }
                            node.setColor(node.getColor().getRed(), Integer.parseInt((String)value), node.getColor().getBlue());
                            break;
                        }
                        case B: {
                            if (node.getColor() == null) {
                                node.setColor(0, 0, Integer.parseInt((String)value));
                                break;
                            }
                            node.setColor(node.getColor().getRed(), node.getColor().getGreen(), Integer.parseInt((String)value));
                        }
                    }
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_datavalue", (Object)fore, (Object)node, (Object)prop.toString()), Issue.Level.SEVERE));
                }
            }
            if ((column = this.container.getNodeColumn(fore)) != null) {
                try {
                    node.parseAndSetValue(column.getId(), (String)value);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_datavalue", (Object)fore, (Object)node, (Object)column.getTitle()), Issue.Level.SEVERE));
                }
            }
        }
    }

    private void readDesc(XMLStreamReader reader, ElementDraft element) throws Exception {
        StringBuilder value = new StringBuilder();
        boolean end = false;
        while (reader.hasNext() && !end) {
            int xmltype = reader.next();
            switch (xmltype) {
                case 4: 
                case 12: {
                    if (this.xmlReader.isWhiteSpace()) break;
                    value.append(this.xmlReader.getText());
                    break;
                }
                case 2: {
                    if (!DESC.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (!value.toString().isEmpty()) {
            element.setLabel(value.toString());
        }
    }

    private void readEdge(XMLStreamReader reader) throws Exception {
        String id = "";
        String source = "";
        String target = "";
        String directed = "";
        String type = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (EDGE_SOURCE.equalsIgnoreCase(attName)) {
                source = reader.getAttributeValue(i);
                continue;
            }
            if (EDGE_TARGET.equalsIgnoreCase(attName)) {
                target = reader.getAttributeValue(i);
                continue;
            }
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i);
                continue;
            }
            if (EDGE_DIRECTED.equalsIgnoreCase(attName)) {
                directed = reader.getAttributeValue(i);
                continue;
            }
            if (!EDGE_TYPE.equalsIgnoreCase(attName)) continue;
            type = reader.getAttributeValue(i).trim();
        }
        EdgeDraft edge = !id.isEmpty() ? this.container.factory().newEdgeDraft(id) : this.container.factory().newEdgeDraft();
        NodeDraft nodeSource = this.container.getNode(source);
        NodeDraft nodeTarget = this.container.getNode(target);
        edge.setSource(nodeSource);
        edge.setTarget(nodeTarget);
        if (type != null && !type.isEmpty()) {
            edge.setType((Object)type);
        }
        if (!directed.isEmpty()) {
            if (directed.equalsIgnoreCase("true")) {
                edge.setDirection(EdgeDirection.DIRECTED);
            } else if (directed.equalsIgnoreCase("false")) {
                edge.setDirection(EdgeDirection.UNDIRECTED);
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_edgetype", (Object)directed, (Object)edge), Issue.Level.SEVERE));
                edge.setDirection(this.edgeDefault);
            }
        } else {
            edge.setDirection(this.edgeDefault);
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            int elemType = reader.next();
            switch (elemType) {
                case 1: {
                    String name = this.xmlReader.getLocalName();
                    if (ATTVALUE.equalsIgnoreCase(name)) {
                        this.readEdgeAttValue(reader, edge);
                        break;
                    }
                    if (!DESC.equals(name)) break;
                    this.readDesc(reader, (ElementDraft)edge);
                    break;
                }
                case 2: {
                    if (!EDGE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        this.container.addEdge(edge);
    }

    private void readEdgeAttValue(XMLStreamReader reader, EdgeDraft edge) throws Exception {
        String fore = "";
        Object value = "";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if (!"key".equalsIgnoreCase(attName)) continue;
            fore = reader.getAttributeValue(i).trim();
        }
        if (fore.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_datakey", (Object)edge), Issue.Level.SEVERE));
            return;
        }
        boolean end = false;
        while (reader.hasNext() && !end) {
            int xmltype = reader.next();
            switch (xmltype) {
                case 4: 
                case 12: {
                    if (this.xmlReader.isWhiteSpace()) break;
                    value = (String)value + this.xmlReader.getText();
                    break;
                }
                case 2: {
                    if (!ATTVALUE.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (!((String)value).isEmpty()) {
            ColumnDraft column;
            PropertiesAssociations.EdgeProperties prop = this.edgePropertiesAttributes.get(fore);
            if (prop != null) {
                try {
                    switch (prop) {
                        case WEIGHT: {
                            edge.setWeight((double)this.parseFloat((String)value));
                            break;
                        }
                        case LABEL: {
                            edge.setLabel((String)value);
                            break;
                        }
                        case COLOR: {
                            edge.setColor((String)value);
                            break;
                        }
                        case R: {
                            if (edge.getColor() == null) {
                                edge.setColor(Integer.parseInt((String)value), 0, 0);
                                break;
                            }
                            edge.setColor(Integer.parseInt((String)value), edge.getColor().getGreen(), edge.getColor().getBlue());
                            break;
                        }
                        case G: {
                            if (edge.getColor() == null) {
                                edge.setColor(0, Integer.parseInt((String)value), 0);
                                break;
                            }
                            edge.setColor(edge.getColor().getRed(), Integer.parseInt((String)value), edge.getColor().getBlue());
                            break;
                        }
                        case B: {
                            if (edge.getColor() == null) {
                                edge.setColor(0, 0, Integer.parseInt((String)value));
                                break;
                            }
                            edge.setColor(edge.getColor().getRed(), edge.getColor().getGreen(), Integer.parseInt((String)value));
                        }
                    }
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_datavalue", (Object)fore, (Object)edge, (Object)prop.toString()), Issue.Level.SEVERE));
                }
            }
            if ((column = this.container.getEdgeColumn(fore)) != null) {
                try {
                    edge.parseAndSetValue(column.getId(), (String)value);
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_datavalue", (Object)fore, (Object)edge, (Object)column.getTitle()), Issue.Level.SEVERE));
                }
            }
        }
    }

    private void readAttribute(XMLStreamReader reader) throws Exception {
        String id = "";
        String type = "";
        String title = "";
        String defaultStr = "";
        String forStr = "all";
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attName = reader.getAttributeName(i).getLocalPart();
            if ("id".equalsIgnoreCase(attName)) {
                id = reader.getAttributeValue(i).trim();
                continue;
            }
            if (ATTRIBUTE_TYPE.equalsIgnoreCase(attName)) {
                type = reader.getAttributeValue(i).trim();
                continue;
            }
            if (ATTRIBUTE_TITLE.equalsIgnoreCase(attName)) {
                title = reader.getAttributeValue(i).trim();
                continue;
            }
            if (!ATTRIBUTE_FOR.equalsIgnoreCase(attName)) continue;
            forStr = reader.getAttributeValue(i).trim();
        }
        if (title.isEmpty()) {
            title = id;
        }
        boolean property = false;
        if (!id.isEmpty()) {
            PropertiesAssociations.NodeProperties prop;
            if (forStr.equalsIgnoreCase(NODE)) {
                PropertiesAssociations.NodeProperties nodeProperties = prop = this.properties.getNodeProperty(id) == null ? this.properties.getNodeProperty(title) : this.properties.getNodeProperty(id);
                if (prop != null) {
                    this.nodePropertiesAttributes.put(id, prop);
                    this.report.log(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_log_nodeproperty", (Object)title));
                    property = true;
                }
            } else if (forStr.equalsIgnoreCase(EDGE)) {
                PropertiesAssociations.EdgeProperties edgeProperties = prop = this.properties.getEdgeProperty(id) == null ? this.properties.getEdgeProperty(title) : this.properties.getEdgeProperty(id);
                if (prop != null) {
                    this.edgePropertiesAttributes.put(id, (PropertiesAssociations.EdgeProperties)prop);
                    this.report.log(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_log_edgeproperty", (Object)title));
                    property = true;
                }
            }
            if (property) {
                return;
            }
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributeempty", (Object)title), Issue.Level.SEVERE));
            return;
        }
        if (!property && type.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributetype1", (Object)title), Issue.Level.SEVERE));
            type = "string";
        }
        if (!property) {
            if (forStr.equalsIgnoreCase(GRAPH)) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_graphattributes", (Object)title), Issue.Level.WARNING));
            } else if (forStr.isEmpty() || !forStr.equalsIgnoreCase(NODE) && !forStr.equalsIgnoreCase(EDGE) && !forStr.equalsIgnoreCase("all")) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributeclass", (Object)title), Issue.Level.SEVERE));
                return;
            }
            boolean end = false;
            boolean defaultFlag = false;
            while (reader.hasNext() && !end) {
                int xmltype = reader.next();
                switch (xmltype) {
                    case 1: {
                        if (!ATTRIBUTE_DEFAULT.equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                        defaultFlag = true;
                        break;
                    }
                    case 4: {
                        if (!defaultFlag || this.xmlReader.isWhiteSpace()) break;
                        defaultStr = this.xmlReader.getText();
                        break;
                    }
                    case 2: {
                        if (!"key".equalsIgnoreCase(this.xmlReader.getLocalName())) break;
                        end = true;
                    }
                }
            }
            Class attributeType = String.class;
            if (type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("bool")) {
                attributeType = Boolean.TYPE;
            } else if (type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("int")) {
                attributeType = Integer.TYPE;
            } else if (type.equalsIgnoreCase("long")) {
                attributeType = Long.class;
            } else if (type.equalsIgnoreCase("float")) {
                attributeType = Float.class;
            } else if (type.equalsIgnoreCase("double")) {
                attributeType = Double.class;
            } else if (type.equalsIgnoreCase("string")) {
                attributeType = String.class;
            } else if (type.equalsIgnoreCase("bigdecimal")) {
                attributeType = BigDecimal.class;
            } else if (type.equalsIgnoreCase("biginteger")) {
                attributeType = BigInteger.class;
            } else if (type.equalsIgnoreCase("byte")) {
                attributeType = Byte.class;
            } else if (type.equalsIgnoreCase("char")) {
                attributeType = Character.class;
            } else if (type.equalsIgnoreCase("short")) {
                attributeType = Short.class;
            } else if (type.equalsIgnoreCase("listboolean")) {
                attributeType = boolean[].class;
            } else if (type.equalsIgnoreCase("listint")) {
                attributeType = int[].class;
            } else if (type.equalsIgnoreCase("listlong")) {
                attributeType = long[].class;
            } else if (type.equalsIgnoreCase("listfloat")) {
                attributeType = float[].class;
            } else if (type.equalsIgnoreCase("listdouble")) {
                attributeType = double[].class;
            } else if (type.equalsIgnoreCase("liststring")) {
                attributeType = String[].class;
            } else if (type.equalsIgnoreCase("listbigdecimal")) {
                attributeType = BigDecimal[].class;
            } else if (type.equalsIgnoreCase("listbiginteger")) {
                attributeType = BigInteger[].class;
            } else if (type.equalsIgnoreCase("listbyte")) {
                attributeType = byte[].class;
            } else if (type.equalsIgnoreCase("listchar")) {
                attributeType = char[].class;
            } else if (type.equalsIgnoreCase("listshort")) {
                attributeType = short[].class;
            } else {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributetype2", (Object)type), Issue.Level.SEVERE));
                return;
            }
            ColumnDraft column = null;
            if (NODE.equalsIgnoreCase(forStr) || "all".equalsIgnoreCase(forStr)) {
                if (this.container.getNodeColumn(id) != null) {
                    this.report.log(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributecolumn_exist", (Object)id));
                    return;
                }
                column = this.container.addNodeColumn(id, attributeType);
                column.setTitle(title);
                this.report.log(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_log_nodeattribute", (Object)title, (Object)attributeType.getCanonicalName()));
            }
            if (EDGE.equalsIgnoreCase(forStr) || "all".equalsIgnoreCase(forStr)) {
                if (this.container.getEdgeColumn(id) != null) {
                    this.report.log(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributecolumn_exist", (Object)id));
                    return;
                }
                column = this.container.addEdgeColumn(id, attributeType);
                column.setTitle(title);
                this.report.log(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_log_edgeattribute", (Object)title, (Object)attributeType.getCanonicalName()));
            }
            if (column != null && !defaultStr.isEmpty()) {
                try {
                    column.setDefaultValueString(defaultStr);
                    this.report.log(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_log_default", (Object)defaultStr, (Object)title));
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributedefault", (Object)title, (Object)attributeType.getCanonicalName()), Issue.Level.SEVERE));
                }
            }
        } else {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterGraphML.class, (String)"importerGraphML_error_attributeempty", (Object)title), Issue.Level.SEVERE));
        }
    }

    private float parseFloat(String str) {
        str = str.replace(',', '.');
        return Float.parseFloat(str);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

