/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.MatchImagesTask;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.track.TrackStore;

public class MatchTracksMenu
extends JMenu
implements MenuConstants,
ActionListener {
    private JMenuItem matchTrackToOneImageItem;
    private JMenuItem matchTrackToSelectedImagesItem;
    private JMenuItem matchTrackToAllImagesItem;
    private ImagesTable imagesTable;
    private ImagesTableModel tableModel;
    int[] selectedRows;
    ImageInfo currentImage;

    public MatchTracksMenu(boolean backgroundTask, ImagesTable imagesTable, ImageInfo currentImage, TrackStore trackStore) {
        super(MATCH_TRACKS);
        this.imagesTable = imagesTable;
        this.tableModel = (ImagesTableModel)imagesTable.getModel();
        this.currentImage = currentImage;
        this.selectedRows = imagesTable.getSelectedRows();
        boolean menuEnabled = false;
        this.matchTrackToOneImageItem = new JMenuItem(MATCH_TRACK_THIS);
        boolean itemEnabled = !backgroundTask && trackStore.hasTracks();
        menuEnabled |= itemEnabled;
        this.matchTrackToOneImageItem.setEnabled(itemEnabled);
        this.matchTrackToOneImageItem.addActionListener(this);
        this.add(this.matchTrackToOneImageItem);
        this.matchTrackToSelectedImagesItem = new JMenuItem(MATCH_TRACK_SELECTED);
        itemEnabled = !backgroundTask && trackStore.hasTracks() && this.selectedRows.length > 0;
        menuEnabled |= itemEnabled;
        this.matchTrackToSelectedImagesItem.setEnabled(itemEnabled);
        this.matchTrackToSelectedImagesItem.addActionListener(this);
        this.add(this.matchTrackToSelectedImagesItem);
        this.matchTrackToAllImagesItem = new JMenuItem(MATCH_TRACK_ALL);
        itemEnabled = !backgroundTask && trackStore.hasTracks();
        menuEnabled |= itemEnabled;
        this.matchTrackToAllImagesItem.setEnabled(itemEnabled);
        this.matchTrackToAllImagesItem.addActionListener(this);
        this.add(this.matchTrackToAllImagesItem);
    }

    private void matchTracksToOneImage() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.currentImage);
        TaskExecutor.execute(new MatchImagesTask(MATCH_TRACKS, MATCH_TRACK_SELECTED, this.imagesTable, images));
    }

    private void matchTracksToSelectedImages() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            images.add(this.tableModel.getImageInfo(this.selectedRows[index]));
            ++index;
        }
        TaskExecutor.execute(new MatchImagesTask(MATCH_TRACKS, MATCH_TRACK_SELECTED, this.imagesTable, images));
    }

    private void matchTracksToAllImages() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            images.add(this.tableModel.getImageInfo(index));
            ++index;
        }
        TaskExecutor.execute(new MatchImagesTask(MATCH_TRACKS, MATCH_TRACK_ALL, this.imagesTable, images));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.matchTrackToOneImageItem) {
            this.matchTracksToOneImage();
        } else if (event.getSource() == this.matchTrackToSelectedImagesItem) {
            this.matchTracksToSelectedImages();
        } else if (event.getSource() == this.matchTrackToAllImagesItem) {
            this.matchTracksToAllImages();
        }
    }
}

