/*
 * Decompiled with CFR 0.152.
 */
package infovis.panel.dqinter;

import infovis.panel.DefaultDoubleBoundedRangeModel;
import infovis.panel.DoubleBoundedRangeModel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleRangeSlider
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ChangeListener {
    private static int PICK_WIDTH = 6;
    static int SZ = 6;
    private DoubleBoundedRangeModel model;
    private boolean enabled = false;
    int[] xPts = new int[7];
    int[] yPts = new int[7];
    int pick;
    double pickOffset;
    double mouseX;
    double scaleRatio = 1.0;
    Insets insets;
    boolean inside;
    int preferredHeight = 50;

    public DoubleRangeSlider(double minimum, double maximum, double lowValue, double highValue) {
        this(new DefaultDoubleBoundedRangeModel(lowValue, highValue - lowValue, minimum, maximum));
    }

    public DoubleRangeSlider(DoubleBoundedRangeModel model) {
        this.model = model;
        model.addChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public double getLowValue() {
        return this.model.getValueDouble();
    }

    public double getHighValue() {
        return this.model.getValueDouble() + this.model.getExtentDouble();
    }

    public double getMinimum() {
        return this.model.getMinimumDouble();
    }

    public double getMaximum() {
        return this.model.getMaximumDouble();
    }

    public void setLowValue(double lowValue) {
        double high = lowValue + this.model.getExtentDouble() > this.getMaximum() ? this.getMaximum() : this.getHighValue();
        double extent = high - lowValue;
        this.model.setRangeProperties(lowValue, extent, this.getMinimum(), this.getMaximum(), true);
    }

    public void setHighValue(double highValue) {
        this.model.setExtent(highValue - this.getLowValue());
    }

    public void setMinimum(double min) {
        this.model.setMinimum(min);
    }

    public void setMaximum(double max) {
        this.model.setMaximum(max);
    }

    Rectangle getInBounds() {
        Dimension sz = this.getSize();
        this.insets = this.getInsets();
        return new Rectangle(this.insets.left, this.insets.top, sz.width - this.insets.left - this.insets.right, sz.height - this.insets.top - this.insets.bottom);
    }

    protected void paintComponent(Graphics g) {
        g.setColor(Color.lightGray);
        Rectangle rect = this.getInBounds();
        int minX = this.toScreenX(this.getLowValue());
        int maxX = this.toScreenX(this.getHighValue());
        if (maxX - minX > 10) {
            this.xPts[0] = minX;
            this.yPts[0] = rect.y + SZ;
            this.xPts[1] = minX + SZ;
            this.yPts[1] = rect.y;
            this.xPts[2] = maxX;
            this.yPts[2] = rect.y;
            this.xPts[3] = maxX;
            this.yPts[3] = rect.y + rect.height - SZ;
            this.xPts[4] = maxX - SZ;
            this.yPts[4] = rect.y + rect.height;
            this.xPts[5] = minX;
            this.yPts[5] = rect.y + rect.height;
            this.xPts[6] = minX;
            this.yPts[6] = rect.y + SZ;
            g.setColor(Color.darkGray);
            g.drawPolygon(this.xPts, this.yPts, 7);
            g.setColor(Color.white);
            g.drawLine(this.xPts[0], this.yPts[0], this.xPts[1], this.yPts[1]);
            g.drawLine(this.xPts[1], this.yPts[1], this.xPts[2], this.yPts[2]);
            g.drawLine(this.xPts[5], this.yPts[5], this.xPts[6], this.yPts[6]);
            if (maxX - minX > 12) {
                for (int y = rect.y + 3; y < rect.y + rect.height - 3; y += 3) {
                    g.setColor(Color.lightGray);
                    g.fillRect(minX + 2, y + 2, 1, 1);
                    g.fillRect(minX + 5, y, 1, 1);
                    g.fillRect(minX + 8, y - 2, 1, 1);
                    g.fillRect(maxX - 3, y, 1, 1);
                    g.fillRect(maxX - 6, y + 2, 1, 1);
                    g.fillRect(maxX - 9, y + 4, 1, 1);
                    g.setColor(Color.darkGray);
                    g.fillRect(minX + 2, y + 3, 1, 1);
                    g.fillRect(minX + 5, y + 1, 1, 1);
                    g.fillRect(minX + 8, y - 1, 1, 1);
                    g.fillRect(maxX - 3, y + 1, 1, 1);
                    g.fillRect(maxX - 6, y + 3, 1, 1);
                    g.fillRect(maxX - 9, y + 5, 1, 1);
                }
                g.setColor(Color.gray);
                g.drawLine(minX + 10, rect.y + 2, minX + 10, rect.y + rect.height - 2);
                g.drawLine(maxX - 11, rect.y + 2, maxX - 11, rect.y + rect.height - 2);
            } else {
                g.setColor(Color.gray);
                g.drawLine((minX + maxX) / 3, rect.y + 2, (minX + maxX) / 3, rect.y + rect.height - 2);
                g.drawLine(2 * (minX + maxX) / 3, rect.y + 2, 2 * (minX + maxX) / 3, rect.y + rect.height - 2);
            }
        } else {
            if (this.enabled) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(Color.darkGray);
            }
            int w = maxX - minX;
            if (w < 10) {
                w = 10;
            }
            g.fill3DRect(minX, rect.y, w, rect.y + rect.height, true);
            g.setColor(Color.gray);
            g.drawLine((minX + maxX) / 3, rect.y + 2, (minX + maxX) / 3, rect.y + rect.height - 2);
            g.drawLine(2 * (minX + maxX) / 3, rect.y + 2, 2 * (minX + maxX) / 3, rect.y + rect.height - 2);
        }
        if (this.model.getValueIsAdjusting() || this.inside) {
            g.setColor(Color.BLACK);
            FontMetrics fm = g.getFontMetrics();
            String s = this.format(this.getLowValue());
            float w = fm.stringWidth(s);
            g.clearRect(this.insets.left, this.insets.top, (int)w, fm.getHeight());
            g.drawString(s, this.insets.left, fm.getAscent() + this.insets.top);
            s = this.format(this.getHighValue());
            w = fm.stringWidth(s);
            g.clearRect(rect.x + rect.width - (int)w, this.insets.top, (int)w, fm.getHeight());
            g.drawString(s, rect.x + rect.width - (int)w, fm.getAscent() + this.insets.top);
        }
    }

    private double getScaleX() {
        int width = this.getWidth();
        double xScale = (double)(width - this.insets.left - this.insets.right) / (this.getMaximum() - this.getMinimum());
        return xScale;
    }

    private double toLocalX(double x) {
        double xScale = this.getScaleX();
        return (x - (double)this.insets.left) / xScale + this.getMinimum();
    }

    private int toScreenX(double x) {
        double xScale = this.getScaleX();
        return (int)((x - this.getMinimum()) * xScale) + this.insets.left;
    }

    private int pickHandle(double x) {
        double minX = this.toScreenX(this.getLowValue());
        int maxX = this.toScreenX(this.getHighValue());
        int pick = 0;
        if (Math.abs(x - minX) < (double)PICK_WIDTH) {
            pick |= 1;
        }
        if (Math.abs(x - (double)maxX) < (double)PICK_WIDTH) {
            pick |= 2;
        }
        if (pick == 0 && x > minX && x < (double)maxX) {
            pick = 4;
        }
        return pick;
    }

    private void offset(double dx) {
        this.model.setValue(this.getLowValue() + dx);
    }

    public void mousePressed(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        this.pick = this.pickHandle(e.getX());
        this.pickOffset = e.getX() - this.toScreenX(this.getLowValue());
        this.mouseX = e.getX();
        this.model.setValueIsAdjusting(true);
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        double xpos = e.getX();
        double x = this.toLocalX(xpos);
        if (x < this.getMinimum()) {
            x = this.getMinimum();
        }
        if (x > this.getMaximum()) {
            x = this.getMaximum();
        }
        if (this.pick == 3) {
            if (xpos - this.mouseX > 2.0) {
                this.pick = 2;
            } else if (xpos - this.mouseX < -2.0) {
                this.pick = 1;
            } else {
                return;
            }
        }
        this.mouseX = xpos;
        switch (this.pick) {
            case 1: {
                if (!(x < this.getHighValue())) break;
                this.setLowValue(x);
                break;
            }
            case 2: {
                if (!(x > this.getLowValue())) break;
                this.setHighValue(x);
                break;
            }
            case 4: {
                double dx = this.toLocalX(xpos - this.pickOffset) - this.getLowValue();
                if (dx < 0.0 && this.getLowValue() + dx < this.getMinimum()) {
                    dx = this.getMinimum() - this.getLowValue();
                }
                if (dx > 0.0 && this.getHighValue() + dx > this.getMaximum()) {
                    dx = this.getMaximum() - this.getHighValue();
                }
                if (dx == 0.0) break;
                this.offset(dx);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.model.setValueIsAdjusting(false);
    }

    private void setCurs(int c) {
        Cursor cursor = Cursor.getPredefinedCursor(c);
        this.setCursor(cursor);
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        switch (this.pickHandle(e.getX())) {
            case 1: 
            case 3: {
                this.setCurs(10);
                break;
            }
            case 2: {
                this.setCurs(11);
                break;
            }
            case 4: {
                this.setCurs(13);
                break;
            }
            case 0: {
                this.setCurs(0);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.model.setRangeProperties(this.model.getMinimum(), this.model.getMaximum() - this.model.getMinimum(), this.model.getMinimum(), this.model.getMaximum(), false);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.inside) {
            return;
        }
        this.setToolTipText("inside");
        this.inside = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.setCurs(0);
        if (!this.inside) {
            return;
        }
        this.inside = false;
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, this.preferredHeight);
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredHeight(int preferredHeight) {
        if (this.preferredHeight == preferredHeight) {
            return;
        }
        this.preferredHeight = preferredHeight;
        this.invalidate();
    }

    public void setEnabled(boolean v) {
        this.enabled = v;
        this.repaint();
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public DoubleBoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(DoubleBoundedRangeModel model) {
        this.model = model;
        this.repaint();
    }

    public String format(double x) {
        return Double.toString(x);
    }

    public String getToolTipText(MouseEvent event) {
        return this.format(this.getMinimum()) + " [" + this.format(this.getLowValue()) + ".." + this.format(this.getHighValue()) + "] " + this.format(this.getMaximum());
    }
}

