/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.util.MathUtil;
import info.monitorenter.util.Range;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public abstract class AAxisTransformation
extends AAxis {
    protected long m_outputErrorTstamp = 0L;

    public AAxisTransformation() {
    }

    public AAxisTransformation(IAxisLabelFormatter formatter) {
        super(formatter);
    }

    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart, int dimension, int position) {
        AAxis.AChart2DDataAccessor result;
        if (dimension == 1) {
            if ((position & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(position);
            result = new XDataAccessor(chart);
        } else if (dimension == 2) {
            if ((position & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(position);
            result = new YDataAccessor(chart);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return result;
    }

    public double getMax() {
        double result = 1.0;
        try {
            result = this.transform(super.getMax());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public double getMin() {
        double result = 0.0;
        try {
            result = this.transform(super.getMin());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    @Deprecated
    public final double getScaledValue(double absolute) {
        double result;
        Range range = this.getRange();
        try {
            result = this.transform(absolute) - range.getMin();
            double scaler = range.getExtent();
            if (!MathUtil.isDouble(result /= scaler)) {
                result = 0.0;
            }
        }
        catch (IllegalArgumentException e) {
            long tstamp = System.currentTimeMillis();
            if (tstamp - this.m_outputErrorTstamp > 30000L) {
                System.out.println(e.getLocalizedMessage());
                this.m_outputErrorTstamp = tstamp;
            }
            result = 0.0;
        }
        return result;
    }

    protected abstract double transform(double var1) throws IllegalArgumentException;

    public final double translateMousePosition(MouseEvent mouseEvent) throws IllegalArgumentException {
        return this.untransform(this.getAccessor().translateMousePosition(mouseEvent));
    }

    public double translatePxToValue(int pixel) {
        return this.untransform(this.m_accessor.translatePxToValue(pixel));
    }

    protected abstract double untransform(double var1);

    protected final class YDataAccessor
    extends AAxis.YDataAccessor {
        public YDataAccessor(Chart2D chart) {
            super(chart);
        }

        protected void scaleTrace(ITrace2D trace, Range range) {
            if (trace.isVisible()) {
                double scaler = range.getExtent();
                Iterator<TracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    double result;
                    TracePoint2D point = itPoints.next();
                    double absolute = point.getY();
                    try {
                        result = AAxisTransformation.this.transform(absolute) - range.getMin();
                        if (!MathUtil.isDouble(result /= scaler)) {
                            result = 0.0;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        long tstamp = System.currentTimeMillis();
                        if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                            System.out.println(e.getLocalizedMessage());
                            AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                        }
                        result = 0.0;
                    }
                    point.setScaledY(result);
                }
            }
        }

        public final int translateValueToPx(double value) {
            double normalizedValue;
            int result = 0;
            Range range = AAxisTransformation.this.getRange();
            double scaler = range.getExtent();
            double absolute = value;
            try {
                normalizedValue = AAxisTransformation.this.transform(absolute) - range.getMin();
                if (!MathUtil.isDouble(normalizedValue /= scaler)) {
                    normalizedValue = 0.0;
                }
            }
            catch (IllegalArgumentException e) {
                long tstamp = System.currentTimeMillis();
                if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                    System.out.println(e.getLocalizedMessage());
                    AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                }
                normalizedValue = 0.0;
            }
            Chart2D chart = this.getChart();
            int pixelRange = this.getPixelRange();
            result = (int)Math.round((double)chart.getYChartStart() - normalizedValue * (double)pixelRange);
            return result;
        }
    }

    public final class XDataAccessor
    extends AAxis.XDataAccessor {
        public XDataAccessor(Chart2D chart) {
            super(chart);
        }

        protected void scaleTrace(ITrace2D trace, Range range) {
            if (trace.isVisible()) {
                Iterator<TracePoint2D> itPoints = trace.iterator();
                double scaler = range.getExtent();
                itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    double result;
                    TracePoint2D point = itPoints.next();
                    double absolute = point.getX();
                    try {
                        result = AAxisTransformation.this.transform(absolute) - range.getMin();
                        if (!MathUtil.isDouble(result /= scaler)) {
                            result = 0.0;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        long tstamp = System.currentTimeMillis();
                        if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                            System.out.println(e.getLocalizedMessage());
                            AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                        }
                        result = 0.0;
                    }
                    point.setScaledX(result);
                }
            }
        }

        public final int translateValueToPx(double value) {
            double normalizedValue;
            Range range = AAxisTransformation.this.getRange();
            double scaler = range.getExtent();
            double absolute = value;
            try {
                normalizedValue = AAxisTransformation.this.transform(absolute) - range.getMin();
                if (!MathUtil.isDouble(normalizedValue /= scaler)) {
                    normalizedValue = 0.0;
                }
            }
            catch (IllegalArgumentException e) {
                long tstamp = System.currentTimeMillis();
                if (tstamp - AAxisTransformation.this.m_outputErrorTstamp > 30000L) {
                    System.out.println(e.getLocalizedMessage());
                    AAxisTransformation.this.m_outputErrorTstamp = tstamp;
                }
                normalizedValue = 0.0;
            }
            Chart2D chart = this.getChart();
            int pixelRange = this.getPixelRange();
            int result = (int)Math.round((double)chart.getXChartStart() + normalizedValue * (double)pixelRange);
            return result;
        }
    }
}

