/** @file
 * @brief MatchDecider subclass for filtering results by value.
 */
/* Copyright 2008 Lemur Consulting Ltd
 * Copyright 2009 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 */

#include <config.h>

#include "xapian/valuesetmatchdecider.h"

#include "xapian/document.h"

using namespace std;

namespace Xapian {

bool
ValueSetMatchDecider::operator()(const Xapian::Document& doc) const
{
    return (testset.find(doc.get_value(valuenum)) == testset.end()) ^ inclusive;
}

}
