(********************************************************************)
(*                                                                  *)
(*  The Why3 Verification Platform   /   The Why3 Development Team  *)
(*  Copyright 2010-2020   --   Inria - CNRS - Paris-Sud University  *)
(*                                                                  *)
(*  This software is distributed under the terms of the GNU Lesser  *)
(*  General Public License version 2.1, with the special exception  *)
(*  on linking described in file LICENSE.                           *)
(*                                                                  *)
(********************************************************************)

open Wstdlib

(* This allows registering a transformation of counterexamples terms. It allows
   to convert Apply(s, t) into appropriate counterexample datatypes. For
   example, an unconstrained array that was translated from an high-level
   language to a why3 record can be recognized in this function and be
   translated back to an array (based on the name of its fields.
   This function has the information of the records that were saved.
*)
val register_apply_to_records:
    ((string list) Mstr.t -> string list ->
     Smt2_model_defs.term -> Smt2_model_defs.term) ->
      unit

(* From the table generated by the parser, build a list of model_element *)
val create_list:
  Ident.ident Mstr.t ->
    Ident.ident Mstr.t -> ((string * string) list) Mstr.t -> string list ->
    Ident.Sattr.t Mstr.t ->
      Smt2_model_defs.definition Mstr.t -> Model_parser.model_element list
