/*
    The WebDruid - a web server log analysis program

    Copyright (C) 2003-2004  Fabien Chevalier (fabien@juliana-multimedia.com)

    Original webalizer copyright:
    Copyright (C) 1997-2001  Bradford L. Barrett (brad@mrunix.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

    This software uses the gd graphics library, which is copyright by
    Quest Protein Database Center, Cold Spring Harbor Labs.  Please
    see the documentation supplied with the library for additional
    information and license terms, or visit www.boutell.com/gd/ for the
    most recent version of the library and supporting documentation.
*/

#ifndef _LINKLIST_H
#define _LINKLIST_H

struct nlist {  char string[80];           /* list struct for HIDE items   */
              struct nlist *next; };
typedef struct nlist *NLISTPTR;

struct glist {  char string[80];           /* list struct for GROUP items  */
                char name[80];
              struct glist *next; };
typedef struct glist *GLISTPTR;

struct list {   char * item;                /* generic list */
         struct list * next; };
typedef struct list *LISTPTR;

extern GLISTPTR group_sites   ;               /* "group" lists            */
extern GLISTPTR group_urls    ;
extern GLISTPTR group_refs    ;
extern GLISTPTR group_agents  ;
extern GLISTPTR group_users   ;
extern NLISTPTR hidden_sites  ;               /* "hidden" lists           */
extern NLISTPTR hidden_urls   ;       
extern NLISTPTR hidden_refs   ;       
extern NLISTPTR hidden_agents ;       
extern NLISTPTR hidden_users  ;
extern NLISTPTR ignored_sites ;               /* "Ignored" lists          */
extern NLISTPTR ignored_urls  ;       
extern NLISTPTR ignored_refs  ;
extern NLISTPTR ignored_agents;       
extern NLISTPTR ignored_users ;       
extern NLISTPTR include_sites ;               /* "Include" lists          */
extern NLISTPTR include_urls  ;
extern NLISTPTR include_refs  ;       
extern NLISTPTR include_agents;       
extern NLISTPTR include_users ;
extern NLISTPTR index_alias   ;               /* index. aliases            */
extern NLISTPTR html_pre      ;               /* before anything else :)   */
extern NLISTPTR html_head     ;               /* top HTML code             */
extern NLISTPTR html_body     ;               /* body HTML code            */
extern NLISTPTR html_post     ;               /* middle HTML code          */
extern NLISTPTR html_tail     ;               /* tail HTML code            */
extern NLISTPTR html_end      ;               /* after everything else     */
extern NLISTPTR page_type     ;               /* page view types           */

extern char     *isinlist(NLISTPTR, char *);        /* scan list for str   */
extern char     *isinglist(GLISTPTR, char *);       /* scan glist for str  */
extern int      add_nlist(char *, NLISTPTR *);      /* add list item       */
extern int      add_glist(char *, GLISTPTR *);      /* add group list item */

extern void     del_lists();                        /* free shared lists   */

typedef void LIST_TYPE;                      /* can be changed to debug    */

extern LISTPTR  new_list(LIST_TYPE *, int);              /* new generic list    */
extern void     del_list(LISTPTR *, int);           /* del generic list    */
extern int      add_list(LISTPTR *, LIST_TYPE *, int);   /* add gen. list item  */

#endif  /* _LINKLIST_H */
