/*---------------------------------------------------------------------------*\

    FILE....: v4logagc.h
    TYPE....: C Header File
    AUTHOR..: Ian Roberts
    DATE....: 18/4/02

    Automatic Gain Control (AGC) functions for V4LOG card

\*---------------------------------------------------------------------------*/

#ifndef __AGC__
#define __AGC__

#include <sys/types.h>

// JK: 18/7/02 allows USHORT to translate to unsigned short for Visual Studio
// BK: 06/02/03 ditto FreeBSD, so to make it easy I have defined USHOR and ULONG
// through out the hole thing !
#ifndef USHORT
#define USHORT unsigned short
#endif

/*--------------------------------------------------------------------------*\

				FUNCTIONS

\*--------------------------------------------------------------------------*/

void v4log_agc_open(void **states);
void v4log_agc_close(void *states);
void v4log_agc_apply(void *states, short Y[], short X[], USHORT n);

#endif	/* #ifndef __AGC__	*/










































