/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

 
#ifndef VDKFONT_H
#define VDKFONT_H
#include <gdk/gdk.h>
#include <vdk/rawobj.h>
class VDKForm;
/*!
  \class VDKFont
  \brief Provides a raw font.
 */
class VDKFont: public VDKRawObject
{
  
  char* fontName;
  // STUB
  PangoFontDescription *pangoDes;
 public:
  /*!
    Constructor
    \param fname font name
   */
  VDKFont(char* fname);
  /*!
    Constructor
    \param obj owner object
    \param fname font name
   */
  VDKFont(VDKObject* obj, char* name);
  /*!
    Destructor
   */
  virtual ~VDKFont();
  /*!
    Return font height, 0 on failure
   */
  int Height(const char* s);
  /*!
    Return font width, 0 on failure
   */
  int Width(const char* s);
  /*!
    Equality operator
   */
  bool operator==(VDKFont& f);
  /*!
    Return font name
   */
  operator char*();
  /*!
    GdkFont* conversion,
    user should gdk_font_unref() after use
   */
  operator GdkFont*();
  /*!
    GdkFont* conversion,
    user should gdk_font_unref() after use
   */
  GdkFont* AsGdkFont();
  /*!
    Return font id   (not more used)
   */
  int FontId();
  /*!
    Returns pango font description
   */
  PangoFontDescription * AsPangoFontDescription();
};

#endif
