/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * february 2001
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
// yet another address program !
#include "bookcompo.h"
#define MAX_ADDR 6 
#define MAX_COL 5

extern char *book_open_xpm[];
extern char *book_closed_xpm[];
extern char *mini_bball_xpm[]; 
 
typedef struct {  
  char *items[MAX_COL];  
} ynad;

ynad friends[MAX_ADDR]=
{
  {{"Motta","Mario","via delle fonti 1","Montecolombo","98564"}},
  {{"Guerra","Tonino","via Arcangelo 6","Morciano","34567"}},
  {{"Plum","Adam","Strawberry street 678","Los Angeles","CA4567"}},
  {{"Jim","Uncle","Sky boulevard 34", "Paris", "FR5676"}},
  {{"Adelante", "Speedo","fast plaza", "Madrid","SP98767"}},
  {{"Streisand","Barbara","Star hill 567","Hollywood", "XX5676"}}
};

/*
 */
DEFINE_SIGNAL_MAP(NotebookComponent,VDKBox)
  ON_SIGNAL(next,clicked_signal,NextTab),
  ON_SIGNAL(prev,clicked_signal,PrevTab),
  ON_SIGNAL(rotate,clicked_signal,RotateTab),
  ON_SIGNAL(enable,clicked_signal,EnableTab),
  ON_SIGNAL(list,select_row_signal,ListSelection),
  ON_SIGNAL(list,unselect_row_signal,ListUnselection)
END_SIGNAL_MAP
/*
 */
void NotebookComponent::Setup()
{ 
  VDKBox *box = new VDKBox(Owner(),v_box);
  book = new VDKNotebook(Owner());
  box->Add(book);
  box->Add(new VDKSeparator(Owner()));
  VDKBox* buttonbox = new VDKBox(Owner(),h_box);
  next = new VDKCustomButton(Owner(),"next page");
  prev = new VDKCustomButton(Owner(),"prev page");
  rotate = new VDKCustomButton(Owner(),"rotate tabs");
  enable  = new VDKCustomButton(Owner(),"enable 2nd page");
  buttonbox->Add(next); 
  buttonbox->Add(prev);
  buttonbox->Add(rotate);
  buttonbox->Add(enable); 
  box->Add(buttonbox);
  Add(box,l_justify,false,false);
  // since we plan to add pixmaps better make pages after realizing 
  // all stuff 
  MakePage1();
  MakePage2();
  // disables last page
  book->Pages[1]->TabLabel->Enabled = false;
} 
/*
 */
void NotebookComponent::MakePage1() 
{ 
  char* prompts[] =
  {
    "First name",  
    "Address",
    "City", 
    "Phone number",
    0 
  };     
  char* title = "Last name";
  VDKBox *box = new VDKBox(Owner(),h_box);
  // a panel for the list
  VDKBox *panel = new VDKBox(Owner(),v_box);
  list = new VDKCustomList(Owner(),1,&title);
  list->ActiveTitle(0,false);
  list->Titles[0]->NormalBackground = clLightBlue;
   // load address
  int t = 0;   
  for(;t < MAX_ADDR;t++) 
     list->AddRow(friends[t].items);
  list->SetSize(100,130); 
  panel->Add(list);
  box->Add(panel);  
  box->Add(new VDKSeparator(Owner(),v_separator));
  // a table 
  VDKTable *table = new VDKTable(Owner(),4,2,true); 
  for(t=0; t < 4; t++)
    {
      VDKLabel* label = (new VDKLabel(Owner(),prompts[t]));
      table->Add(label,0,1,t,t+1);
    } 
  table->Add(firstname   = new VDKEntry(Owner(),0),1,2,0,1);
  table->Add(address     = new VDKEntry(Owner(),0),1,2,1,2);
  table->Add(city        = new VDKEntry(Owner(),0),1,2,2,3);
  table->Add(phonenumber = new VDKNumericEntry(Owner(),0),1,2,3,4);
  box->Add(table);
  book->AddPage(box,"yet another..",book_closed_xpm,book_open_xpm); 
  list->SelectRow(0,0);
}  
/*
 */
void NotebookComponent::MakePage2() 
{ 
  VDKBox *box = new VDKBox(Owner(),h_box);
  box->Add(new VDKImage(Owner(),"linuxGirl.png",
			 "By courtesy of B.Bellamy"));
  box->Add(new VDKImage(Owner(),"monet.png","Claude Monet"));
  book->AddPage(box,"Nice pictures",book_closed_xpm,book_open_xpm);
}
/*
 */
bool NotebookComponent::ListSelection(VDKObject*)
{
int ndx = list->Selected.Row();
if(ndx >= 0)
  {
    list->UpdateRow(ndx,list->Tuples[ndx],mini_bball_xpm,0);
    firstname->Text = friends[ndx].items[1];
    address->Text = friends[ndx].items[2];
    city->Text = friends[ndx].items[3];
    phonenumber->Text = friends[ndx].items[4];
  }
return true;
}
/*
 */
bool NotebookComponent::ListUnselection(VDKObject*)
{
  int ndx = list->Unselected.Row();
  if(ndx >= 0)
    list->UpdateRow(ndx,list->Tuples[ndx]);
  return true;
}
/*
 */
bool NotebookComponent::NextTab(VDKObject* ) 
{ 
  book->ActivePage++; 
  return true;
}
/*
 */
bool NotebookComponent::PrevTab(VDKObject* ) 
{ 
  book->ActivePage--; 
  return true;
}
/*
 */
bool NotebookComponent::EnableTab(VDKObject*) 
{  
  book->Pages[1]->TabLabel->Enabled = true;
  book->ActivePage++;
  return true;
}
/*
 */
bool NotebookComponent::RotateTab(VDKObject*) 
{  
  static int pos = 0;
  book->TabPosition = ++pos;
  return true;
}
 
