// X86 registers
#[repr(C)]
#[derive(PartialEq, Debug, Clone, Copy)]
#[allow(clippy::upper_case_acronyms, non_camel_case_types)]
pub enum RegisterX86 {
    INVALID = 0,
    AH = 1,
    AL = 2,
    AX = 3,
    BH = 4,
    BL = 5,
    BP = 6,
    BPL = 7,
    BX = 8,
    CH = 9,
    CL = 10,
    CS = 11,
    CX = 12,
    DH = 13,
    DI = 14,
    DIL = 15,
    DL = 16,
    DS = 17,
    DX = 18,
    EAX = 19,
    EBP = 20,
    EBX = 21,
    ECX = 22,
    EDI = 23,
    EDX = 24,
    EFLAGS = 25,
    EIP = 26,
    ES = 28,
    ESI = 29,
    ESP = 30,
    FPSW = 31,
    FS = 32,
    GS = 33,
    IP = 34,
    RAX = 35,
    RBP = 36,
    RBX = 37,
    RCX = 38,
    RDI = 39,
    RDX = 40,
    RIP = 41,
    RSI = 43,
    RSP = 44,
    SI = 45,
    SIL = 46,
    SP = 47,
    SPL = 48,
    SS = 49,
    CR0 = 50,
    CR1 = 51,
    CR2 = 52,
    CR3 = 53,
    CR4 = 54,
    CR8 = 58,
    DR0 = 66,
    DR1 = 67,
    DR2 = 68,
    DR3 = 69,
    DR4 = 70,
    DR5 = 71,
    DR6 = 72,
    DR7 = 73,
    FP0 = 82,
    FP1 = 83,
    FP2 = 84,
    FP3 = 85,
    FP4 = 86,
    FP5 = 87,
    FP6 = 88,
    FP7 = 89,
    K0 = 90,
    K1 = 91,
    K2 = 92,
    K3 = 93,
    K4 = 94,
    K5 = 95,
    K6 = 96,
    K7 = 97,
    MM0 = 98,
    MM1 = 99,
    MM2 = 100,
    MM3 = 101,
    MM4 = 102,
    MM5 = 103,
    MM6 = 104,
    MM7 = 105,
    R8 = 106,
    R9 = 107,
    R10 = 108,
    R11 = 109,
    R12 = 110,
    R13 = 111,
    R14 = 112,
    R15 = 113,
    ST0 = 114,
    ST1 = 115,
    ST2 = 116,
    ST3 = 117,
    ST4 = 118,
    ST5 = 119,
    ST6 = 120,
    ST7 = 121,
    XMM0 = 122,
    XMM1 = 123,
    XMM2 = 124,
    XMM3 = 125,
    XMM4 = 126,
    XMM5 = 127,
    XMM6 = 128,
    XMM7 = 129,
    XMM8 = 130,
    XMM9 = 131,
    XMM10 = 132,
    XMM11 = 133,
    XMM12 = 134,
    XMM13 = 135,
    XMM14 = 136,
    XMM15 = 137,
    XMM16 = 138,
    XMM17 = 139,
    XMM18 = 140,
    XMM19 = 141,
    XMM20 = 142,
    XMM21 = 143,
    XMM22 = 144,
    XMM23 = 145,
    XMM24 = 146,
    XMM25 = 147,
    XMM26 = 148,
    XMM27 = 149,
    XMM28 = 150,
    XMM29 = 151,
    XMM30 = 152,
    XMM31 = 153,
    YMM0 = 154,
    YMM1 = 155,
    YMM2 = 156,
    YMM3 = 157,
    YMM4 = 158,
    YMM5 = 159,
    YMM6 = 160,
    YMM7 = 161,
    YMM8 = 162,
    YMM9 = 163,
    YMM10 = 164,
    YMM11 = 165,
    YMM12 = 166,
    YMM13 = 167,
    YMM14 = 168,
    YMM15 = 169,
    YMM16 = 170,
    YMM17 = 171,
    YMM18 = 172,
    YMM19 = 173,
    YMM20 = 174,
    YMM21 = 175,
    YMM22 = 176,
    YMM23 = 177,
    YMM24 = 178,
    YMM25 = 179,
    YMM26 = 180,
    YMM27 = 181,
    YMM28 = 182,
    YMM29 = 183,
    YMM30 = 184,
    YMM31 = 185,
    ZMM0 = 186,
    ZMM1 = 187,
    ZMM2 = 188,
    ZMM3 = 189,
    ZMM4 = 190,
    ZMM5 = 191,
    ZMM6 = 192,
    ZMM7 = 193,
    ZMM8 = 194,
    ZMM9 = 195,
    ZMM10 = 196,
    ZMM11 = 197,
    ZMM12 = 198,
    ZMM13 = 199,
    ZMM14 = 200,
    ZMM15 = 201,
    ZMM16 = 202,
    ZMM17 = 203,
    ZMM18 = 204,
    ZMM19 = 205,
    ZMM20 = 206,
    ZMM21 = 207,
    ZMM22 = 208,
    ZMM23 = 209,
    ZMM24 = 210,
    ZMM25 = 211,
    ZMM26 = 212,
    ZMM27 = 213,
    ZMM28 = 214,
    ZMM29 = 215,
    ZMM30 = 216,
    ZMM31 = 217,
    R8B = 218,
    R9B = 219,
    R10B = 220,
    R11B = 221,
    R12B = 222,
    R13B = 223,
    R14B = 224,
    R15B = 225,
    R8D = 226,
    R9D = 227,
    R10D = 228,
    R11D = 229,
    R12D = 230,
    R13D = 231,
    R14D = 232,
    R15D = 233,
    R8W = 234,
    R9W = 235,
    R10W = 236,
    R11W = 237,
    R12W = 238,
    R13W = 239,
    R14W = 240,
    R15W = 241,
    IDTR = 242,
    GDTR = 243,
    LDTR = 244,
    TR = 245,
    FPCW = 246,
    FPTAG = 247,
    MSR = 248,
    MXCSR = 249,
    FS_BASE = 250,
    GS_BASE = 251,
    FLAGS = 252,
    RFLAGS = 253,
    FIP = 254,
    FCS = 255,
    FDP = 256,
    FDS = 257,
    FOP = 258,
    ENDING = 259,
}

impl From<RegisterX86> for i32 {
    fn from(r: RegisterX86) -> Self {
        r as i32
    }
}

#[repr(C)]
#[derive(PartialEq, Debug, Clone, Copy)]
#[allow(clippy::upper_case_acronyms)]
pub enum InsnX86 {
    IN = 218,
    OUT = 500,
    SYSCALL = 699,
    SYSENTER = 700,
    RET = 151,
}

#[repr(C)]
#[derive(PartialEq, Debug, Clone, Copy)]
#[allow(clippy::upper_case_acronyms)]
pub enum InsnSysX86 {
    SYSCALL = InsnX86::SYSCALL as isize,
    SYSENTER = InsnX86::SYSENTER as isize,
}

#[repr(C)]
#[derive(PartialEq, Debug, Clone, Copy)]
pub struct X86Mmr {
    pub selector: u64,
    pub base: u64,
    pub limit: u32,
    pub flags: u32,
}
