from _typeshed import Incomplete, SupportsItems
from abc import ABC
from re import Pattern
from typing import Any, ClassVar
from typing_extensions import Literal

def clear_empty_fields(d): ...
def create_dictionary_string(
    dict_,
    open_dict: str = ...,
    close_dict: str = ...,
    field_join: str = ...,
    key_value_join: str = ...,
    has_empty_fields: bool = ...,
): ...
def create_list_string(list_): ...
def iobj_ref(n): ...
def create_stream(stream): ...

class PDFObject:
    def __init__(self, id: Any | None = ...) -> None: ...
    @property
    def id(self): ...
    @id.setter
    def id(self, n) -> None: ...
    @property
    def ref(self): ...
    def serialize(self, fpdf: Any | None = ..., obj_dict: Any | None = ...): ...

def build_obj_dict(key_values: SupportsItems[str, Incomplete]) -> dict[str, str]: ...
def camel_case(snake_case: str) -> str: ...

class PDFString(str):
    USE_HEX_ENCODING: ClassVar[bool]
    def serialize(self): ...

class PDFArray(list[Any]):
    def serialize(self): ...

class Destination(ABC):
    def as_str(self, pdf: Any | None = ...) -> None: ...

class DestinationXYZ(Destination):
    page: int
    x: float
    y: float
    zoom: float | Literal["null"]
    page_as_obj_id: bool
    def __init__(
        self, page: int, x: float = ..., y: float = ..., zoom: float | Literal["null"] = ..., page_as_obj_id: bool = ...
    ) -> None: ...
    def as_str(self, pdf: Any | None = ...): ...

class Raw(str): ...

class Name(str):
    NAME_ESC: ClassVar[Pattern[bytes]]
    def pdf_repr(self) -> str: ...
