/*
 * Copyright 2020-2024 Dillinger
 * Copyright 2024-2025 Dylan Van Assche
 * SPDX-License-Identifier: GPL-3.0
 */

var opened = false;

/* Call API when button is clicked */
browser.browserAction.onClicked.addListener(() => {
  opened = true;
  browser.mobileConfigApi.toggleFolderPane();
});

/* Toggle folder pane when displayed folder was selected by user */
messenger.mailTabs.onDisplayedFolderChanged.addListener(async (tab, folder) => {
  console.log(`Folder selected: ${JSON.stringify(folder, null, 2)}`);

  if (opened) {
    browser.mobileConfigApi.toggleFolderPane();
  }
});
