/*
 * Collection of filters to modify streams of tagged items
 *
 * Copyright (C) 2003--2008  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/stream/expression.h>
#include <tagcoll/coll/simple.h>

namespace tut {
using namespace std;
using namespace tagcoll;
using namespace tagcoll::stream;
using namespace tagcoll::tests;

struct tagcoll_stream_expression_shar {
};
TESTGRP(tagcoll_stream_expression);

template<> template<>
void to::test<1>()
{
	std::string input_coll(
			"a: b, c\n"
			"b:\n"
			"c: a\n"
			"d:  c::D, e::F,    f::g\n"
			);
	std::string output_coll(
			"a: b, c\n"
			"d:  c::D, e::F,    f::g\n"
			);
	coll::Simple<string, string> result;
	parseCollection(input_coll, filterItemsByExpression(
				"(*::D && e::F) || c", inserter(result)));

	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));

	ensure_coll_equals(reference, result);
}

template<> template<>
void to::test<2>()
{
	std::string input_coll(
			"a: b, c, a::D\n"
			"b: D, *::D\n"
			"c: a\n"
			"d: c::D, e::F, f::g\n"
			);
	std::string output_coll(
			"a: c, a::D\n"
			"b: *::D\n"
			"d: c::D, e::F\n"
			);
	coll::Simple<string, string> result;
	parseCollection(input_coll, filterTagsByExpression(
				"*::D || e::F || c", ExpressionFilter::PLAIN, inserter(result))); 

	coll::Simple<string, string> reference;
	parseCollection(output_coll, inserter(reference));

	ensure_coll_equals(reference, result);
}

}

#include <tagcoll/TextFormat.tcc>
#include <tagcoll/coll/simple.tcc>

// vim:set ts=4 sw=4:
