/*
 * Embed a tag expression in a class with proper copy semantics
 * Plus some filters based on tag expressions
 *
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <tagcoll/expression.h>

namespace tut {
using namespace std;
using namespace tagcoll;
using namespace tagcoll::tests;

struct tagcoll_expression_shar {
};
TESTGRP(tagcoll_expression);

template<> template<>
void to::test<1>()
{
	std::set<string> test;
	test.insert("coffee");
	test.insert("tea");
	test.insert("sugar");
	
	Expression e1("coffee");
	ensure(e1(test));

	Expression e2("coffee && tea");
	ensure(e2(test));

	e1 = Expression("!coffee");
	ensure(!e1(test));

	e1 = Expression("coffee || milk");
	ensure(e1(test));

	e1 = Expression("coffee && !milk");
	ensure(e1(test));

	e1 = Expression("coffee && !tea");
	ensure(!e1(test));

	e1 = Expression("(coffee || milk) && (tea && sugar)");
	ensure(e1(test));

	e1 = Expression("!(coffee && milk) && (tea && sugar)");
	ensure(e1(test));

	std::set<string> test1;
	test1.insert("coffee");
	test1.insert("milk");
	Expression e3("coffee && milk && !sugar");
	ensure(e3(test1));
}

}

// vim:set ts=4 sw=4:
