/* SPDX-License-Identifier: LGPL-2.1-or-later */
#pragma once

#include <linux/if_link.h>

#include "in-addr-util.h"
#include "netdev.h"
#include "shared-forward.h"

#define GENEVE_VID_MAX (1u << 24) - 1

typedef enum GeneveDF {
        NETDEV_GENEVE_DF_NO = GENEVE_DF_UNSET,
        NETDEV_GENEVE_DF_YES = GENEVE_DF_SET,
        NETDEV_GENEVE_DF_INHERIT = GENEVE_DF_INHERIT,
        _NETDEV_GENEVE_DF_MAX,
        _NETDEV_GENEVE_DF_INVALID = -EINVAL,
} GeneveDF;

typedef struct Geneve {
        NetDev meta;

        uint32_t id;
        uint32_t flow_label;

        int remote_family;

        uint8_t tos;
        uint8_t ttl;

        uint16_t dest_port;

        bool udpcsum;
        bool udp6zerocsumtx;
        bool udp6zerocsumrx;
        bool inherit;

        GeneveDF geneve_df;
        union in_addr_union remote;

        bool inherit_inner_protocol;
} Geneve;

DEFINE_NETDEV_CAST(GENEVE, Geneve);
extern const NetDevVTable geneve_vtable;

DECLARE_STRING_TABLE_LOOKUP(geneve_df, GeneveDF);

CONFIG_PARSER_PROTOTYPE(config_parse_geneve_vni);
CONFIG_PARSER_PROTOTYPE(config_parse_geneve_address);
CONFIG_PARSER_PROTOTYPE(config_parse_geneve_flow_label);
CONFIG_PARSER_PROTOTYPE(config_parse_geneve_df);
CONFIG_PARSER_PROTOTYPE(config_parse_geneve_ttl);
