; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs --mtriple powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefix=P8LE
; RUN: llc -verify-machineinstrs --mtriple powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefix=P9LE
; RUN: llc -verify-machineinstrs --mtriple powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefix=P10LE
; RUN: llc -verify-machineinstrs --mtriple powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefix=P8BE
; RUN: llc -verify-machineinstrs --mtriple powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefix=P9BE
; RUN: llc -verify-machineinstrs --mtriple powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names < %s | FileCheck %s --check-prefix=P10BE

define signext i8 @caller_1(ptr nocapture readonly byval([1 x i8]) %data) #0 {
; P8LE-LABEL: caller_1:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mflr r0
; P8LE-NEXT:    stdu r1, -64(r1)
; P8LE-NEXT:    std r0, 80(r1)
; P8LE-NEXT:    stb r3, 48(r1)
; P8LE-NEXT:    lbz r3, 48(r1)
; P8LE-NEXT:    stb r3, 63(r1)
; P8LE-NEXT:    addi r3, r1, 63
; P8LE-NEXT:    bl callee
; P8LE-NEXT:    nop
; P8LE-NEXT:    li r3, 0
; P8LE-NEXT:    addi r1, r1, 64
; P8LE-NEXT:    ld r0, 16(r1)
; P8LE-NEXT:    mtlr r0
; P8LE-NEXT:    blr
;
; P9LE-LABEL: caller_1:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mflr r0
; P9LE-NEXT:    stdu r1, -64(r1)
; P9LE-NEXT:    std r0, 80(r1)
; P9LE-NEXT:    stb r3, 48(r1)
; P9LE-NEXT:    lbz r3, 48(r1)
; P9LE-NEXT:    stb r3, 63(r1)
; P9LE-NEXT:    addi r3, r1, 63
; P9LE-NEXT:    bl callee
; P9LE-NEXT:    nop
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    addi r1, r1, 64
; P9LE-NEXT:    ld r0, 16(r1)
; P9LE-NEXT:    mtlr r0
; P9LE-NEXT:    blr
;
; P10LE-LABEL: caller_1:
; P10LE:       # %bb.0: # %entry
; P10LE-NEXT:    mflr r0
; P10LE-NEXT:    std r0, 16(r1)
; P10LE-NEXT:    stdu r1, -64(r1)
; P10LE-NEXT:    stb r3, 48(r1)
; P10LE-NEXT:    lbz r3, 48(r1)
; P10LE-NEXT:    stb r3, 63(r1)
; P10LE-NEXT:    addi r3, r1, 63
; P10LE-NEXT:    bl callee@notoc
; P10LE-NEXT:    li r3, 0
; P10LE-NEXT:    addi r1, r1, 64
; P10LE-NEXT:    ld r0, 16(r1)
; P10LE-NEXT:    mtlr r0
; P10LE-NEXT:    blr
;
; P8BE-LABEL: caller_1:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mflr r0
; P8BE-NEXT:    stdu r1, -128(r1)
; P8BE-NEXT:    std r0, 144(r1)
; P8BE-NEXT:    stb r3, 183(r1)
; P8BE-NEXT:    lbz r3, 183(r1)
; P8BE-NEXT:    stb r3, 127(r1)
; P8BE-NEXT:    addi r3, r1, 127
; P8BE-NEXT:    bl callee
; P8BE-NEXT:    nop
; P8BE-NEXT:    li r3, 0
; P8BE-NEXT:    addi r1, r1, 128
; P8BE-NEXT:    ld r0, 16(r1)
; P8BE-NEXT:    mtlr r0
; P8BE-NEXT:    blr
;
; P9BE-LABEL: caller_1:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mflr r0
; P9BE-NEXT:    stdu r1, -128(r1)
; P9BE-NEXT:    std r0, 144(r1)
; P9BE-NEXT:    stb r3, 183(r1)
; P9BE-NEXT:    lbz r3, 183(r1)
; P9BE-NEXT:    stb r3, 127(r1)
; P9BE-NEXT:    addi r3, r1, 127
; P9BE-NEXT:    bl callee
; P9BE-NEXT:    nop
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    addi r1, r1, 128
; P9BE-NEXT:    ld r0, 16(r1)
; P9BE-NEXT:    mtlr r0
; P9BE-NEXT:    blr
;
; P10BE-LABEL: caller_1:
; P10BE:       # %bb.0: # %entry
; P10BE-NEXT:    mflr r0
; P10BE-NEXT:    std r0, 16(r1)
; P10BE-NEXT:    stdu r1, -128(r1)
; P10BE-NEXT:    stb r3, 183(r1)
; P10BE-NEXT:    lbz r3, 183(r1)
; P10BE-NEXT:    stb r3, 127(r1)
; P10BE-NEXT:    addi r3, r1, 127
; P10BE-NEXT:    bl callee
; P10BE-NEXT:    nop
; P10BE-NEXT:    li r3, 0
; P10BE-NEXT:    addi r1, r1, 128
; P10BE-NEXT:    ld r0, 16(r1)
; P10BE-NEXT:    mtlr r0
; P10BE-NEXT:    blr
entry:
  %_param_data = alloca [1 x i8], align 1
  %.unpack = load i8, ptr %data, align 1
  store i8 %.unpack, ptr %_param_data, align 1
  call void @callee(ptr nonnull %_param_data)
  ret i8 0
}

define signext i8 @caller_2(ptr nocapture readonly byval([2 x i8]) %data) #0 {
; P8LE-LABEL: caller_2:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mflr r0
; P8LE-NEXT:    stdu r1, -64(r1)
; P8LE-NEXT:    std r0, 80(r1)
; P8LE-NEXT:    sth r3, 48(r1)
; P8LE-NEXT:    lhz r3, 48(r1)
; P8LE-NEXT:    sth r3, 62(r1)
; P8LE-NEXT:    addi r3, r1, 62
; P8LE-NEXT:    bl callee
; P8LE-NEXT:    nop
; P8LE-NEXT:    li r3, 0
; P8LE-NEXT:    addi r1, r1, 64
; P8LE-NEXT:    ld r0, 16(r1)
; P8LE-NEXT:    mtlr r0
; P8LE-NEXT:    blr
;
; P9LE-LABEL: caller_2:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mflr r0
; P9LE-NEXT:    stdu r1, -64(r1)
; P9LE-NEXT:    std r0, 80(r1)
; P9LE-NEXT:    sth r3, 48(r1)
; P9LE-NEXT:    lhz r3, 48(r1)
; P9LE-NEXT:    sth r3, 62(r1)
; P9LE-NEXT:    addi r3, r1, 62
; P9LE-NEXT:    bl callee
; P9LE-NEXT:    nop
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    addi r1, r1, 64
; P9LE-NEXT:    ld r0, 16(r1)
; P9LE-NEXT:    mtlr r0
; P9LE-NEXT:    blr
;
; P10LE-LABEL: caller_2:
; P10LE:       # %bb.0: # %entry
; P10LE-NEXT:    mflr r0
; P10LE-NEXT:    std r0, 16(r1)
; P10LE-NEXT:    stdu r1, -64(r1)
; P10LE-NEXT:    sth r3, 48(r1)
; P10LE-NEXT:    lhz r3, 48(r1)
; P10LE-NEXT:    sth r3, 62(r1)
; P10LE-NEXT:    addi r3, r1, 62
; P10LE-NEXT:    bl callee@notoc
; P10LE-NEXT:    li r3, 0
; P10LE-NEXT:    addi r1, r1, 64
; P10LE-NEXT:    ld r0, 16(r1)
; P10LE-NEXT:    mtlr r0
; P10LE-NEXT:    blr
;
; P8BE-LABEL: caller_2:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mflr r0
; P8BE-NEXT:    stdu r1, -128(r1)
; P8BE-NEXT:    std r0, 144(r1)
; P8BE-NEXT:    sth r3, 182(r1)
; P8BE-NEXT:    lhz r3, 182(r1)
; P8BE-NEXT:    sth r3, 126(r1)
; P8BE-NEXT:    addi r3, r1, 126
; P8BE-NEXT:    bl callee
; P8BE-NEXT:    nop
; P8BE-NEXT:    li r3, 0
; P8BE-NEXT:    addi r1, r1, 128
; P8BE-NEXT:    ld r0, 16(r1)
; P8BE-NEXT:    mtlr r0
; P8BE-NEXT:    blr
;
; P9BE-LABEL: caller_2:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mflr r0
; P9BE-NEXT:    stdu r1, -128(r1)
; P9BE-NEXT:    std r0, 144(r1)
; P9BE-NEXT:    sth r3, 182(r1)
; P9BE-NEXT:    lhz r3, 182(r1)
; P9BE-NEXT:    sth r3, 126(r1)
; P9BE-NEXT:    addi r3, r1, 126
; P9BE-NEXT:    bl callee
; P9BE-NEXT:    nop
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    addi r1, r1, 128
; P9BE-NEXT:    ld r0, 16(r1)
; P9BE-NEXT:    mtlr r0
; P9BE-NEXT:    blr
;
; P10BE-LABEL: caller_2:
; P10BE:       # %bb.0: # %entry
; P10BE-NEXT:    mflr r0
; P10BE-NEXT:    std r0, 16(r1)
; P10BE-NEXT:    stdu r1, -128(r1)
; P10BE-NEXT:    sth r3, 182(r1)
; P10BE-NEXT:    lhz r3, 182(r1)
; P10BE-NEXT:    sth r3, 126(r1)
; P10BE-NEXT:    addi r3, r1, 126
; P10BE-NEXT:    bl callee
; P10BE-NEXT:    nop
; P10BE-NEXT:    li r3, 0
; P10BE-NEXT:    addi r1, r1, 128
; P10BE-NEXT:    ld r0, 16(r1)
; P10BE-NEXT:    mtlr r0
; P10BE-NEXT:    blr
entry:
  %_param_data = alloca [2 x i8], align 1
  %.unpack = load i8, ptr %data, align 1
  %.elt1 = getelementptr inbounds [2 x i8], ptr %data, i64 0, i64 1
  %.unpack2 = load i8, ptr %.elt1, align 1
  store i8 %.unpack, ptr %_param_data, align 1
  %.temp.1.gep = getelementptr inbounds [2 x i8], ptr %_param_data, i64 0, i64 1
  store i8 %.unpack2, ptr %.temp.1.gep, align 1
  call void @callee(ptr nonnull %_param_data)
  ret i8 0
}

define signext i8 @caller_3(ptr nocapture readonly byval([3 x i8]) %data) #0 {
; P8LE-LABEL: caller_3:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mflr r0
; P8LE-NEXT:    stdu r1, -64(r1)
; P8LE-NEXT:    std r0, 80(r1)
; P8LE-NEXT:    rldicl r4, r3, 48, 16
; P8LE-NEXT:    sth r3, 48(r1)
; P8LE-NEXT:    stb r4, 50(r1)
; P8LE-NEXT:    lhz r3, 48(r1)
; P8LE-NEXT:    lbz r4, 50(r1)
; P8LE-NEXT:    sth r3, 61(r1)
; P8LE-NEXT:    addi r3, r1, 61
; P8LE-NEXT:    stb r4, 63(r1)
; P8LE-NEXT:    bl callee
; P8LE-NEXT:    nop
; P8LE-NEXT:    li r3, 0
; P8LE-NEXT:    addi r1, r1, 64
; P8LE-NEXT:    ld r0, 16(r1)
; P8LE-NEXT:    mtlr r0
; P8LE-NEXT:    blr
;
; P9LE-LABEL: caller_3:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mflr r0
; P9LE-NEXT:    stdu r1, -64(r1)
; P9LE-NEXT:    std r0, 80(r1)
; P9LE-NEXT:    sth r3, 48(r1)
; P9LE-NEXT:    rldicl r3, r3, 48, 16
; P9LE-NEXT:    stb r3, 50(r1)
; P9LE-NEXT:    lhz r3, 48(r1)
; P9LE-NEXT:    lbz r4, 50(r1)
; P9LE-NEXT:    sth r3, 61(r1)
; P9LE-NEXT:    addi r3, r1, 61
; P9LE-NEXT:    stb r4, 63(r1)
; P9LE-NEXT:    bl callee
; P9LE-NEXT:    nop
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    addi r1, r1, 64
; P9LE-NEXT:    ld r0, 16(r1)
; P9LE-NEXT:    mtlr r0
; P9LE-NEXT:    blr
;
; P10LE-LABEL: caller_3:
; P10LE:       # %bb.0: # %entry
; P10LE-NEXT:    mflr r0
; P10LE-NEXT:    std r0, 16(r1)
; P10LE-NEXT:    stdu r1, -64(r1)
; P10LE-NEXT:    sth r3, 48(r1)
; P10LE-NEXT:    rldicl r3, r3, 48, 16
; P10LE-NEXT:    stb r3, 50(r1)
; P10LE-NEXT:    lhz r3, 48(r1)
; P10LE-NEXT:    lbz r4, 50(r1)
; P10LE-NEXT:    sth r3, 61(r1)
; P10LE-NEXT:    addi r3, r1, 61
; P10LE-NEXT:    stb r4, 63(r1)
; P10LE-NEXT:    bl callee@notoc
; P10LE-NEXT:    li r3, 0
; P10LE-NEXT:    addi r1, r1, 64
; P10LE-NEXT:    ld r0, 16(r1)
; P10LE-NEXT:    mtlr r0
; P10LE-NEXT:    blr
;
; P8BE-LABEL: caller_3:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mflr r0
; P8BE-NEXT:    stdu r1, -128(r1)
; P8BE-NEXT:    rldicl r4, r3, 56, 8
; P8BE-NEXT:    std r0, 144(r1)
; P8BE-NEXT:    stb r3, 183(r1)
; P8BE-NEXT:    sth r4, 181(r1)
; P8BE-NEXT:    lbz r4, 183(r1)
; P8BE-NEXT:    lhz r3, 181(r1)
; P8BE-NEXT:    stb r4, 127(r1)
; P8BE-NEXT:    sth r3, 125(r1)
; P8BE-NEXT:    addi r3, r1, 125
; P8BE-NEXT:    bl callee
; P8BE-NEXT:    nop
; P8BE-NEXT:    li r3, 0
; P8BE-NEXT:    addi r1, r1, 128
; P8BE-NEXT:    ld r0, 16(r1)
; P8BE-NEXT:    mtlr r0
; P8BE-NEXT:    blr
;
; P9BE-LABEL: caller_3:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mflr r0
; P9BE-NEXT:    stdu r1, -128(r1)
; P9BE-NEXT:    rldicl r4, r3, 56, 8
; P9BE-NEXT:    std r0, 144(r1)
; P9BE-NEXT:    stb r3, 183(r1)
; P9BE-NEXT:    sth r4, 181(r1)
; P9BE-NEXT:    lbz r4, 183(r1)
; P9BE-NEXT:    lhz r3, 181(r1)
; P9BE-NEXT:    stb r4, 127(r1)
; P9BE-NEXT:    sth r3, 125(r1)
; P9BE-NEXT:    addi r3, r1, 125
; P9BE-NEXT:    bl callee
; P9BE-NEXT:    nop
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    addi r1, r1, 128
; P9BE-NEXT:    ld r0, 16(r1)
; P9BE-NEXT:    mtlr r0
; P9BE-NEXT:    blr
;
; P10BE-LABEL: caller_3:
; P10BE:       # %bb.0: # %entry
; P10BE-NEXT:    mflr r0
; P10BE-NEXT:    std r0, 16(r1)
; P10BE-NEXT:    stdu r1, -128(r1)
; P10BE-NEXT:    rldicl r4, r3, 56, 8
; P10BE-NEXT:    stb r3, 183(r1)
; P10BE-NEXT:    sth r4, 181(r1)
; P10BE-NEXT:    lbz r4, 183(r1)
; P10BE-NEXT:    lhz r3, 181(r1)
; P10BE-NEXT:    stb r4, 127(r1)
; P10BE-NEXT:    sth r3, 125(r1)
; P10BE-NEXT:    addi r3, r1, 125
; P10BE-NEXT:    bl callee
; P10BE-NEXT:    nop
; P10BE-NEXT:    li r3, 0
; P10BE-NEXT:    addi r1, r1, 128
; P10BE-NEXT:    ld r0, 16(r1)
; P10BE-NEXT:    mtlr r0
; P10BE-NEXT:    blr
entry:
  %_param_data = alloca [3 x i8], align 1
  %.unpack = load i8, ptr %data, align 1
  %.elt1 = getelementptr inbounds [3 x i8], ptr %data, i64 0, i64 1
  %.unpack2 = load i8, ptr %.elt1, align 1
  %.elt3 = getelementptr inbounds [3 x i8], ptr %data, i64 0, i64 2
  %.unpack4 = load i8, ptr %.elt3, align 1
  store i8 %.unpack, ptr %_param_data, align 1
  %.temp.1.gep = getelementptr inbounds [3 x i8], ptr %_param_data, i64 0, i64 1
  store i8 %.unpack2, ptr %.temp.1.gep, align 1
  %.temp.2.gep = getelementptr inbounds [3 x i8], ptr %_param_data, i64 0, i64 2
  store i8 %.unpack4, ptr %.temp.2.gep, align 1
  call void @callee(ptr nonnull %_param_data)
  ret i8 0
}

define signext i8 @caller_4(ptr nocapture readonly byval([4 x i8]) %data) #0 {
; P8LE-LABEL: caller_4:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mflr r0
; P8LE-NEXT:    stdu r1, -64(r1)
; P8LE-NEXT:    std r0, 80(r1)
; P8LE-NEXT:    stw r3, 48(r1)
; P8LE-NEXT:    lwz r3, 48(r1)
; P8LE-NEXT:    stw r3, 60(r1)
; P8LE-NEXT:    addi r3, r1, 60
; P8LE-NEXT:    bl callee
; P8LE-NEXT:    nop
; P8LE-NEXT:    li r3, 0
; P8LE-NEXT:    addi r1, r1, 64
; P8LE-NEXT:    ld r0, 16(r1)
; P8LE-NEXT:    mtlr r0
; P8LE-NEXT:    blr
;
; P9LE-LABEL: caller_4:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mflr r0
; P9LE-NEXT:    stdu r1, -64(r1)
; P9LE-NEXT:    std r0, 80(r1)
; P9LE-NEXT:    stw r3, 48(r1)
; P9LE-NEXT:    lwz r3, 48(r1)
; P9LE-NEXT:    stw r3, 60(r1)
; P9LE-NEXT:    addi r3, r1, 60
; P9LE-NEXT:    bl callee
; P9LE-NEXT:    nop
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    addi r1, r1, 64
; P9LE-NEXT:    ld r0, 16(r1)
; P9LE-NEXT:    mtlr r0
; P9LE-NEXT:    blr
;
; P10LE-LABEL: caller_4:
; P10LE:       # %bb.0: # %entry
; P10LE-NEXT:    mflr r0
; P10LE-NEXT:    std r0, 16(r1)
; P10LE-NEXT:    stdu r1, -64(r1)
; P10LE-NEXT:    stw r3, 48(r1)
; P10LE-NEXT:    lwz r3, 48(r1)
; P10LE-NEXT:    stw r3, 60(r1)
; P10LE-NEXT:    addi r3, r1, 60
; P10LE-NEXT:    bl callee@notoc
; P10LE-NEXT:    li r3, 0
; P10LE-NEXT:    addi r1, r1, 64
; P10LE-NEXT:    ld r0, 16(r1)
; P10LE-NEXT:    mtlr r0
; P10LE-NEXT:    blr
;
; P8BE-LABEL: caller_4:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mflr r0
; P8BE-NEXT:    stdu r1, -128(r1)
; P8BE-NEXT:    std r0, 144(r1)
; P8BE-NEXT:    stw r3, 180(r1)
; P8BE-NEXT:    lwz r3, 180(r1)
; P8BE-NEXT:    stw r3, 124(r1)
; P8BE-NEXT:    addi r3, r1, 124
; P8BE-NEXT:    bl callee
; P8BE-NEXT:    nop
; P8BE-NEXT:    li r3, 0
; P8BE-NEXT:    addi r1, r1, 128
; P8BE-NEXT:    ld r0, 16(r1)
; P8BE-NEXT:    mtlr r0
; P8BE-NEXT:    blr
;
; P9BE-LABEL: caller_4:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mflr r0
; P9BE-NEXT:    stdu r1, -128(r1)
; P9BE-NEXT:    std r0, 144(r1)
; P9BE-NEXT:    stw r3, 180(r1)
; P9BE-NEXT:    lwz r3, 180(r1)
; P9BE-NEXT:    stw r3, 124(r1)
; P9BE-NEXT:    addi r3, r1, 124
; P9BE-NEXT:    bl callee
; P9BE-NEXT:    nop
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    addi r1, r1, 128
; P9BE-NEXT:    ld r0, 16(r1)
; P9BE-NEXT:    mtlr r0
; P9BE-NEXT:    blr
;
; P10BE-LABEL: caller_4:
; P10BE:       # %bb.0: # %entry
; P10BE-NEXT:    mflr r0
; P10BE-NEXT:    std r0, 16(r1)
; P10BE-NEXT:    stdu r1, -128(r1)
; P10BE-NEXT:    stw r3, 180(r1)
; P10BE-NEXT:    lwz r3, 180(r1)
; P10BE-NEXT:    stw r3, 124(r1)
; P10BE-NEXT:    addi r3, r1, 124
; P10BE-NEXT:    bl callee
; P10BE-NEXT:    nop
; P10BE-NEXT:    li r3, 0
; P10BE-NEXT:    addi r1, r1, 128
; P10BE-NEXT:    ld r0, 16(r1)
; P10BE-NEXT:    mtlr r0
; P10BE-NEXT:    blr
entry:
  %_param_data = alloca [4 x i8], align 1
  %.unpack = load i8, ptr %data, align 1
  %.elt1 = getelementptr inbounds [4 x i8], ptr %data, i64 0, i64 1
  %.unpack2 = load i8, ptr %.elt1, align 1
  %.elt3 = getelementptr inbounds [4 x i8], ptr %data, i64 0, i64 2
  %.unpack4 = load i8, ptr %.elt3, align 1
  %.elt5 = getelementptr inbounds [4 x i8], ptr %data, i64 0, i64 3
  %.unpack6 = load i8, ptr %.elt5, align 1
  store i8 %.unpack, ptr %_param_data, align 1
  %.temp.1.gep = getelementptr inbounds [4 x i8], ptr %_param_data, i64 0, i64 1
  store i8 %.unpack2, ptr %.temp.1.gep, align 1
  %.temp.2.gep = getelementptr inbounds [4 x i8], ptr %_param_data, i64 0, i64 2
  store i8 %.unpack4, ptr %.temp.2.gep, align 1
  %.temp.3.gep = getelementptr inbounds [4 x i8], ptr %_param_data, i64 0, i64 3
  store i8 %.unpack6, ptr %.temp.3.gep, align 1
  call void @callee(ptr nonnull %_param_data)
  ret i8 0
}

define signext i8 @caller_5(ptr nocapture readonly byval([5 x i8]) %data) #0 {
; P8LE-LABEL: caller_5:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mflr r0
; P8LE-NEXT:    stdu r1, -64(r1)
; P8LE-NEXT:    rldicl r4, r3, 32, 32
; P8LE-NEXT:    std r0, 80(r1)
; P8LE-NEXT:    stw r3, 48(r1)
; P8LE-NEXT:    stb r4, 52(r1)
; P8LE-NEXT:    lbz r4, 52(r1)
; P8LE-NEXT:    stw r3, 59(r1)
; P8LE-NEXT:    addi r3, r1, 59
; P8LE-NEXT:    stb r4, 63(r1)
; P8LE-NEXT:    bl callee
; P8LE-NEXT:    nop
; P8LE-NEXT:    li r3, 0
; P8LE-NEXT:    addi r1, r1, 64
; P8LE-NEXT:    ld r0, 16(r1)
; P8LE-NEXT:    mtlr r0
; P8LE-NEXT:    blr
;
; P9LE-LABEL: caller_5:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mflr r0
; P9LE-NEXT:    stdu r1, -64(r1)
; P9LE-NEXT:    rldicl r4, r3, 32, 32
; P9LE-NEXT:    std r0, 80(r1)
; P9LE-NEXT:    stw r3, 48(r1)
; P9LE-NEXT:    stw r3, 59(r1)
; P9LE-NEXT:    addi r3, r1, 59
; P9LE-NEXT:    stb r4, 52(r1)
; P9LE-NEXT:    lbz r4, 52(r1)
; P9LE-NEXT:    stb r4, 63(r1)
; P9LE-NEXT:    bl callee
; P9LE-NEXT:    nop
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    addi r1, r1, 64
; P9LE-NEXT:    ld r0, 16(r1)
; P9LE-NEXT:    mtlr r0
; P9LE-NEXT:    blr
;
; P10LE-LABEL: caller_5:
; P10LE:       # %bb.0: # %entry
; P10LE-NEXT:    mflr r0
; P10LE-NEXT:    std r0, 16(r1)
; P10LE-NEXT:    stdu r1, -64(r1)
; P10LE-NEXT:    rldicl r4, r3, 32, 32
; P10LE-NEXT:    stw r3, 48(r1)
; P10LE-NEXT:    stw r3, 59(r1)
; P10LE-NEXT:    addi r3, r1, 59
; P10LE-NEXT:    stb r4, 52(r1)
; P10LE-NEXT:    lbz r4, 52(r1)
; P10LE-NEXT:    stb r4, 63(r1)
; P10LE-NEXT:    bl callee@notoc
; P10LE-NEXT:    li r3, 0
; P10LE-NEXT:    addi r1, r1, 64
; P10LE-NEXT:    ld r0, 16(r1)
; P10LE-NEXT:    mtlr r0
; P10LE-NEXT:    blr
;
; P8BE-LABEL: caller_5:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mflr r0
; P8BE-NEXT:    stdu r1, -128(r1)
; P8BE-NEXT:    std r0, 144(r1)
; P8BE-NEXT:    stb r3, 183(r1)
; P8BE-NEXT:    rldicl r3, r3, 56, 8
; P8BE-NEXT:    lbz r4, 183(r1)
; P8BE-NEXT:    stw r3, 179(r1)
; P8BE-NEXT:    stw r3, 123(r1)
; P8BE-NEXT:    addi r3, r1, 123
; P8BE-NEXT:    stb r4, 127(r1)
; P8BE-NEXT:    bl callee
; P8BE-NEXT:    nop
; P8BE-NEXT:    li r3, 0
; P8BE-NEXT:    addi r1, r1, 128
; P8BE-NEXT:    ld r0, 16(r1)
; P8BE-NEXT:    mtlr r0
; P8BE-NEXT:    blr
;
; P9BE-LABEL: caller_5:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mflr r0
; P9BE-NEXT:    stdu r1, -128(r1)
; P9BE-NEXT:    std r0, 144(r1)
; P9BE-NEXT:    stb r3, 183(r1)
; P9BE-NEXT:    lbz r4, 183(r1)
; P9BE-NEXT:    rldicl r3, r3, 56, 8
; P9BE-NEXT:    stw r3, 179(r1)
; P9BE-NEXT:    stw r3, 123(r1)
; P9BE-NEXT:    addi r3, r1, 123
; P9BE-NEXT:    stb r4, 127(r1)
; P9BE-NEXT:    bl callee
; P9BE-NEXT:    nop
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    addi r1, r1, 128
; P9BE-NEXT:    ld r0, 16(r1)
; P9BE-NEXT:    mtlr r0
; P9BE-NEXT:    blr
;
; P10BE-LABEL: caller_5:
; P10BE:       # %bb.0: # %entry
; P10BE-NEXT:    mflr r0
; P10BE-NEXT:    std r0, 16(r1)
; P10BE-NEXT:    stdu r1, -128(r1)
; P10BE-NEXT:    stb r3, 183(r1)
; P10BE-NEXT:    rldicl r3, r3, 56, 8
; P10BE-NEXT:    lbz r4, 183(r1)
; P10BE-NEXT:    stw r3, 179(r1)
; P10BE-NEXT:    stw r3, 123(r1)
; P10BE-NEXT:    addi r3, r1, 123
; P10BE-NEXT:    stb r4, 127(r1)
; P10BE-NEXT:    bl callee
; P10BE-NEXT:    nop
; P10BE-NEXT:    li r3, 0
; P10BE-NEXT:    addi r1, r1, 128
; P10BE-NEXT:    ld r0, 16(r1)
; P10BE-NEXT:    mtlr r0
; P10BE-NEXT:    blr
entry:
  %_param_data = alloca [5 x i8], align 1
  %.unpack = load i8, ptr %data, align 1
  %.elt1 = getelementptr inbounds [5 x i8], ptr %data, i64 0, i64 1
  %.unpack2 = load i8, ptr %.elt1, align 1
  %.elt3 = getelementptr inbounds [5 x i8], ptr %data, i64 0, i64 2
  %.unpack4 = load i8, ptr %.elt3, align 1
  %.elt5 = getelementptr inbounds [5 x i8], ptr %data, i64 0, i64 3
  %.unpack6 = load i8, ptr %.elt5, align 1
  %.elt7 = getelementptr inbounds [5 x i8], ptr %data, i64 0, i64 4
  %.unpack8 = load i8, ptr %.elt7, align 1
  store i8 %.unpack, ptr %_param_data, align 1
  %.temp.1.gep = getelementptr inbounds [5 x i8], ptr %_param_data, i64 0, i64 1
  store i8 %.unpack2, ptr %.temp.1.gep, align 1
  %.temp.2.gep = getelementptr inbounds [5 x i8], ptr %_param_data, i64 0, i64 2
  store i8 %.unpack4, ptr %.temp.2.gep, align 1
  %.temp.3.gep = getelementptr inbounds [5 x i8], ptr %_param_data, i64 0, i64 3
  store i8 %.unpack6, ptr %.temp.3.gep, align 1
  %.temp.4.gep = getelementptr inbounds [5 x i8], ptr %_param_data, i64 0, i64 4
  store i8 %.unpack8, ptr %.temp.4.gep, align 1
  call void @callee(ptr nonnull %_param_data)
  ret i8 0
}

define signext i8 @caller_6(ptr nocapture readonly byval([6 x i8]) %data) #0 {
; P8LE-LABEL: caller_6:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mflr r0
; P8LE-NEXT:    stdu r1, -64(r1)
; P8LE-NEXT:    std r0, 80(r1)
; P8LE-NEXT:    rldicl r4, r3, 32, 32
; P8LE-NEXT:    stw r3, 48(r1)
; P8LE-NEXT:    sth r4, 52(r1)
; P8LE-NEXT:    lwz r3, 48(r1)
; P8LE-NEXT:    lhz r4, 52(r1)
; P8LE-NEXT:    stw r3, 58(r1)
; P8LE-NEXT:    addi r3, r1, 58
; P8LE-NEXT:    sth r4, 62(r1)
; P8LE-NEXT:    bl callee
; P8LE-NEXT:    nop
; P8LE-NEXT:    li r3, 0
; P8LE-NEXT:    addi r1, r1, 64
; P8LE-NEXT:    ld r0, 16(r1)
; P8LE-NEXT:    mtlr r0
; P8LE-NEXT:    blr
;
; P9LE-LABEL: caller_6:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mflr r0
; P9LE-NEXT:    stdu r1, -64(r1)
; P9LE-NEXT:    std r0, 80(r1)
; P9LE-NEXT:    stw r3, 48(r1)
; P9LE-NEXT:    rldicl r3, r3, 32, 32
; P9LE-NEXT:    sth r3, 52(r1)
; P9LE-NEXT:    lwz r3, 48(r1)
; P9LE-NEXT:    lhz r4, 52(r1)
; P9LE-NEXT:    stw r3, 58(r1)
; P9LE-NEXT:    addi r3, r1, 58
; P9LE-NEXT:    sth r4, 62(r1)
; P9LE-NEXT:    bl callee
; P9LE-NEXT:    nop
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    addi r1, r1, 64
; P9LE-NEXT:    ld r0, 16(r1)
; P9LE-NEXT:    mtlr r0
; P9LE-NEXT:    blr
;
; P10LE-LABEL: caller_6:
; P10LE:       # %bb.0: # %entry
; P10LE-NEXT:    mflr r0
; P10LE-NEXT:    std r0, 16(r1)
; P10LE-NEXT:    stdu r1, -64(r1)
; P10LE-NEXT:    stw r3, 48(r1)
; P10LE-NEXT:    rldicl r3, r3, 32, 32
; P10LE-NEXT:    sth r3, 52(r1)
; P10LE-NEXT:    lwz r3, 48(r1)
; P10LE-NEXT:    lhz r4, 52(r1)
; P10LE-NEXT:    stw r3, 58(r1)
; P10LE-NEXT:    addi r3, r1, 58
; P10LE-NEXT:    sth r4, 62(r1)
; P10LE-NEXT:    bl callee@notoc
; P10LE-NEXT:    li r3, 0
; P10LE-NEXT:    addi r1, r1, 64
; P10LE-NEXT:    ld r0, 16(r1)
; P10LE-NEXT:    mtlr r0
; P10LE-NEXT:    blr
;
; P8BE-LABEL: caller_6:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mflr r0
; P8BE-NEXT:    stdu r1, -128(r1)
; P8BE-NEXT:    rldicl r4, r3, 48, 16
; P8BE-NEXT:    std r0, 144(r1)
; P8BE-NEXT:    sth r3, 182(r1)
; P8BE-NEXT:    stw r4, 178(r1)
; P8BE-NEXT:    lhz r4, 182(r1)
; P8BE-NEXT:    lwz r3, 178(r1)
; P8BE-NEXT:    sth r4, 126(r1)
; P8BE-NEXT:    stw r3, 122(r1)
; P8BE-NEXT:    addi r3, r1, 122
; P8BE-NEXT:    bl callee
; P8BE-NEXT:    nop
; P8BE-NEXT:    li r3, 0
; P8BE-NEXT:    addi r1, r1, 128
; P8BE-NEXT:    ld r0, 16(r1)
; P8BE-NEXT:    mtlr r0
; P8BE-NEXT:    blr
;
; P9BE-LABEL: caller_6:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mflr r0
; P9BE-NEXT:    stdu r1, -128(r1)
; P9BE-NEXT:    rldicl r4, r3, 48, 16
; P9BE-NEXT:    std r0, 144(r1)
; P9BE-NEXT:    sth r3, 182(r1)
; P9BE-NEXT:    stw r4, 178(r1)
; P9BE-NEXT:    lhz r4, 182(r1)
; P9BE-NEXT:    lwz r3, 178(r1)
; P9BE-NEXT:    sth r4, 126(r1)
; P9BE-NEXT:    stw r3, 122(r1)
; P9BE-NEXT:    addi r3, r1, 122
; P9BE-NEXT:    bl callee
; P9BE-NEXT:    nop
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    addi r1, r1, 128
; P9BE-NEXT:    ld r0, 16(r1)
; P9BE-NEXT:    mtlr r0
; P9BE-NEXT:    blr
;
; P10BE-LABEL: caller_6:
; P10BE:       # %bb.0: # %entry
; P10BE-NEXT:    mflr r0
; P10BE-NEXT:    std r0, 16(r1)
; P10BE-NEXT:    stdu r1, -128(r1)
; P10BE-NEXT:    rldicl r4, r3, 48, 16
; P10BE-NEXT:    sth r3, 182(r1)
; P10BE-NEXT:    stw r4, 178(r1)
; P10BE-NEXT:    lhz r4, 182(r1)
; P10BE-NEXT:    lwz r3, 178(r1)
; P10BE-NEXT:    sth r4, 126(r1)
; P10BE-NEXT:    stw r3, 122(r1)
; P10BE-NEXT:    addi r3, r1, 122
; P10BE-NEXT:    bl callee
; P10BE-NEXT:    nop
; P10BE-NEXT:    li r3, 0
; P10BE-NEXT:    addi r1, r1, 128
; P10BE-NEXT:    ld r0, 16(r1)
; P10BE-NEXT:    mtlr r0
; P10BE-NEXT:    blr
entry:
  %_param_data = alloca [6 x i8], align 1
  %.unpack = load i8, ptr %data, align 1
  %.elt1 = getelementptr inbounds [6 x i8], ptr %data, i64 0, i64 1
  %.unpack2 = load i8, ptr %.elt1, align 1
  %.elt3 = getelementptr inbounds [6 x i8], ptr %data, i64 0, i64 2
  %.unpack4 = load i8, ptr %.elt3, align 1
  %.elt5 = getelementptr inbounds [6 x i8], ptr %data, i64 0, i64 3
  %.unpack6 = load i8, ptr %.elt5, align 1
  %.elt7 = getelementptr inbounds [6 x i8], ptr %data, i64 0, i64 4
  %.unpack8 = load i8, ptr %.elt7, align 1
  %.elt9 = getelementptr inbounds [6 x i8], ptr %data, i64 0, i64 5
  %.unpack10 = load i8, ptr %.elt9, align 1
  store i8 %.unpack, ptr %_param_data, align 1
  %.temp.1.gep = getelementptr inbounds [6 x i8], ptr %_param_data, i64 0, i64 1
  store i8 %.unpack2, ptr %.temp.1.gep, align 1
  %.temp.2.gep = getelementptr inbounds [6 x i8], ptr %_param_data, i64 0, i64 2
  store i8 %.unpack4, ptr %.temp.2.gep, align 1
  %.temp.3.gep = getelementptr inbounds [6 x i8], ptr %_param_data, i64 0, i64 3
  store i8 %.unpack6, ptr %.temp.3.gep, align 1
  %.temp.4.gep = getelementptr inbounds [6 x i8], ptr %_param_data, i64 0, i64 4
  store i8 %.unpack8, ptr %.temp.4.gep, align 1
  %.temp.5.gep = getelementptr inbounds [6 x i8], ptr %_param_data, i64 0, i64 5
  store i8 %.unpack10, ptr %.temp.5.gep, align 1
  call void @callee(ptr nonnull %_param_data)
  ret i8 0
}

define signext i8 @caller_7(ptr nocapture readonly byval([7 x i8]) %data) #0 {
; P8LE-LABEL: caller_7:
; P8LE:       # %bb.0: # %entry
; P8LE-NEXT:    mflr r0
; P8LE-NEXT:    stdu r1, -64(r1)
; P8LE-NEXT:    rldicl r4, r3, 32, 32
; P8LE-NEXT:    rldicl r5, r3, 16, 48
; P8LE-NEXT:    std r0, 80(r1)
; P8LE-NEXT:    stw r3, 48(r1)
; P8LE-NEXT:    sth r4, 52(r1)
; P8LE-NEXT:    stb r5, 54(r1)
; P8LE-NEXT:    lhz r4, 52(r1)
; P8LE-NEXT:    lbz r5, 54(r1)
; P8LE-NEXT:    stw r3, 57(r1)
; P8LE-NEXT:    addi r3, r1, 57
; P8LE-NEXT:    sth r4, 61(r1)
; P8LE-NEXT:    stb r5, 63(r1)
; P8LE-NEXT:    bl callee
; P8LE-NEXT:    nop
; P8LE-NEXT:    li r3, 0
; P8LE-NEXT:    addi r1, r1, 64
; P8LE-NEXT:    ld r0, 16(r1)
; P8LE-NEXT:    mtlr r0
; P8LE-NEXT:    blr
;
; P9LE-LABEL: caller_7:
; P9LE:       # %bb.0: # %entry
; P9LE-NEXT:    mflr r0
; P9LE-NEXT:    stdu r1, -64(r1)
; P9LE-NEXT:    rldicl r4, r3, 32, 32
; P9LE-NEXT:    std r0, 80(r1)
; P9LE-NEXT:    stw r3, 48(r1)
; P9LE-NEXT:    stw r3, 57(r1)
; P9LE-NEXT:    sth r4, 52(r1)
; P9LE-NEXT:    rldicl r4, r3, 16, 48
; P9LE-NEXT:    addi r3, r1, 57
; P9LE-NEXT:    stb r4, 54(r1)
; P9LE-NEXT:    lhz r4, 52(r1)
; P9LE-NEXT:    lbz r5, 54(r1)
; P9LE-NEXT:    sth r4, 61(r1)
; P9LE-NEXT:    stb r5, 63(r1)
; P9LE-NEXT:    bl callee
; P9LE-NEXT:    nop
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    addi r1, r1, 64
; P9LE-NEXT:    ld r0, 16(r1)
; P9LE-NEXT:    mtlr r0
; P9LE-NEXT:    blr
;
; P10LE-LABEL: caller_7:
; P10LE:       # %bb.0: # %entry
; P10LE-NEXT:    mflr r0
; P10LE-NEXT:    std r0, 16(r1)
; P10LE-NEXT:    stdu r1, -64(r1)
; P10LE-NEXT:    rldicl r4, r3, 32, 32
; P10LE-NEXT:    stw r3, 48(r1)
; P10LE-NEXT:    stw r3, 57(r1)
; P10LE-NEXT:    sth r4, 52(r1)
; P10LE-NEXT:    rldicl r4, r3, 16, 48
; P10LE-NEXT:    addi r3, r1, 57
; P10LE-NEXT:    stb r4, 54(r1)
; P10LE-NEXT:    lhz r4, 52(r1)
; P10LE-NEXT:    lbz r5, 54(r1)
; P10LE-NEXT:    sth r4, 61(r1)
; P10LE-NEXT:    stb r5, 63(r1)
; P10LE-NEXT:    bl callee@notoc
; P10LE-NEXT:    li r3, 0
; P10LE-NEXT:    addi r1, r1, 64
; P10LE-NEXT:    ld r0, 16(r1)
; P10LE-NEXT:    mtlr r0
; P10LE-NEXT:    blr
;
; P8BE-LABEL: caller_7:
; P8BE:       # %bb.0: # %entry
; P8BE-NEXT:    mflr r0
; P8BE-NEXT:    stdu r1, -128(r1)
; P8BE-NEXT:    rldicl r4, r3, 56, 8
; P8BE-NEXT:    std r0, 144(r1)
; P8BE-NEXT:    stb r3, 183(r1)
; P8BE-NEXT:    rldicl r3, r3, 40, 24
; P8BE-NEXT:    sth r4, 181(r1)
; P8BE-NEXT:    lbz r5, 183(r1)
; P8BE-NEXT:    lhz r4, 181(r1)
; P8BE-NEXT:    stw r3, 177(r1)
; P8BE-NEXT:    stw r3, 121(r1)
; P8BE-NEXT:    addi r3, r1, 121
; P8BE-NEXT:    sth r4, 125(r1)
; P8BE-NEXT:    stb r5, 127(r1)
; P8BE-NEXT:    bl callee
; P8BE-NEXT:    nop
; P8BE-NEXT:    li r3, 0
; P8BE-NEXT:    addi r1, r1, 128
; P8BE-NEXT:    ld r0, 16(r1)
; P8BE-NEXT:    mtlr r0
; P8BE-NEXT:    blr
;
; P9BE-LABEL: caller_7:
; P9BE:       # %bb.0: # %entry
; P9BE-NEXT:    mflr r0
; P9BE-NEXT:    stdu r1, -128(r1)
; P9BE-NEXT:    rldicl r4, r3, 56, 8
; P9BE-NEXT:    std r0, 144(r1)
; P9BE-NEXT:    stb r3, 183(r1)
; P9BE-NEXT:    lbz r5, 183(r1)
; P9BE-NEXT:    rldicl r3, r3, 40, 24
; P9BE-NEXT:    sth r4, 181(r1)
; P9BE-NEXT:    stw r3, 177(r1)
; P9BE-NEXT:    lhz r4, 181(r1)
; P9BE-NEXT:    stw r3, 121(r1)
; P9BE-NEXT:    addi r3, r1, 121
; P9BE-NEXT:    stb r5, 127(r1)
; P9BE-NEXT:    sth r4, 125(r1)
; P9BE-NEXT:    bl callee
; P9BE-NEXT:    nop
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    addi r1, r1, 128
; P9BE-NEXT:    ld r0, 16(r1)
; P9BE-NEXT:    mtlr r0
; P9BE-NEXT:    blr
;
; P10BE-LABEL: caller_7:
; P10BE:       # %bb.0: # %entry
; P10BE-NEXT:    mflr r0
; P10BE-NEXT:    std r0, 16(r1)
; P10BE-NEXT:    stdu r1, -128(r1)
; P10BE-NEXT:    rldicl r4, r3, 56, 8
; P10BE-NEXT:    stb r3, 183(r1)
; P10BE-NEXT:    rldicl r3, r3, 40, 24
; P10BE-NEXT:    lbz r5, 183(r1)
; P10BE-NEXT:    sth r4, 181(r1)
; P10BE-NEXT:    stw r3, 177(r1)
; P10BE-NEXT:    stw r3, 121(r1)
; P10BE-NEXT:    addi r3, r1, 121
; P10BE-NEXT:    lhz r4, 181(r1)
; P10BE-NEXT:    stb r5, 127(r1)
; P10BE-NEXT:    sth r4, 125(r1)
; P10BE-NEXT:    bl callee
; P10BE-NEXT:    nop
; P10BE-NEXT:    li r3, 0
; P10BE-NEXT:    addi r1, r1, 128
; P10BE-NEXT:    ld r0, 16(r1)
; P10BE-NEXT:    mtlr r0
; P10BE-NEXT:    blr
entry:
  %_param_data = alloca [7 x i8], align 1
  %.unpack = load i8, ptr %data, align 1
  %.elt1 = getelementptr inbounds [7 x i8], ptr %data, i64 0, i64 1
  %.unpack2 = load i8, ptr %.elt1, align 1
  %.elt3 = getelementptr inbounds [7 x i8], ptr %data, i64 0, i64 2
  %.unpack4 = load i8, ptr %.elt3, align 1
  %.elt5 = getelementptr inbounds [7 x i8], ptr %data, i64 0, i64 3
  %.unpack6 = load i8, ptr %.elt5, align 1
  %.elt7 = getelementptr inbounds [7 x i8], ptr %data, i64 0, i64 4
  %.unpack8 = load i8, ptr %.elt7, align 1
  %.elt9 = getelementptr inbounds [7 x i8], ptr %data, i64 0, i64 5
  %.unpack10 = load i8, ptr %.elt9, align 1
  %.elt11 = getelementptr inbounds [7 x i8], ptr %data, i64 0, i64 6
  %.unpack12 = load i8, ptr %.elt11, align 1
  store i8 %.unpack, ptr %_param_data, align 1
  %.temp.1.gep = getelementptr inbounds [7 x i8], ptr %_param_data, i64 0, i64 1
  store i8 %.unpack2, ptr %.temp.1.gep, align 1
  %.temp.2.gep = getelementptr inbounds [7 x i8], ptr %_param_data, i64 0, i64 2
  store i8 %.unpack4, ptr %.temp.2.gep, align 1
  %.temp.3.gep = getelementptr inbounds [7 x i8], ptr %_param_data, i64 0, i64 3
  store i8 %.unpack6, ptr %.temp.3.gep, align 1
  %.temp.4.gep = getelementptr inbounds [7 x i8], ptr %_param_data, i64 0, i64 4
  store i8 %.unpack8, ptr %.temp.4.gep, align 1
  %.temp.5.gep = getelementptr inbounds [7 x i8], ptr %_param_data, i64 0, i64 5
  store i8 %.unpack10, ptr %.temp.5.gep, align 1
  %.temp.6.gep = getelementptr inbounds [7 x i8], ptr %_param_data, i64 0, i64 6
  store i8 %.unpack12, ptr %.temp.6.gep, align 1
  call void @callee(ptr nonnull %_param_data)
  ret i8 0
}

declare void @callee(ptr) local_unnamed_addr #0

attributes #0 = { nounwind }
