/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _SWAC_REPOSITORY_H
#define _SWAC_REPOSITORY_H

#include <libxml/uri.h>

#include "parser_dom.hh"
#include "swac_db.hh"

struct Tswac_package : virtual Tdom_parser, virtual Tswac_db {
protected:
	bool load(std::string table, std::string path, xmlXPathContextPtr xpath_ctxt, std::string xpath);
	bool load(std::string table, std::string path);
};


struct Tswac_repository_http : virtual Tdom_parser, virtual Tswac_package {
private:
	bool read_dom(std::string root);
	bool create_dom(std::string url);
public:
	bool load(std::string url);
};



struct Tswac_repository_local : virtual Tswac_package {
public:
	bool load(std::string path);
};

#endif

