#include <math.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>

/* Table of 8 bit logs.
 *
 * Can be calculated by:
 *
 *    #! /usr/bin/perl
 *    
 *    for ($i = 0; $i < 256; $i++) {
 *        print int(log(1 + $i/256) * 256 / log(2)), ",\n";
 *    }
 */
unsigned char table[256] = {
  0,				/* int(log2(1 + 0/256) * 256) */
  1,				/* int(log2(1 + 1/256) * 256) */
  2,				/* int(log2(1 + 2/256) * 256) */
  4,
  5,
  7,
  8,
  9,
  11,
  12,
  14,
  15,
  16,
  18,
  19,
  21,
  22,
  23,
  25,
  26,
  27,
  29,
  30,
  31,
  33,
  34,
  35,
  37,
  38,
  39,
  40,
  42,
  43,
  44,
  46,
  47,
  48,
  49,
  51,
  52,
  53,
  54,
  56,
  57,
  58,
  59,
  61,
  62,
  63,
  64,
  65,
  67,
  68,
  69,
  70,
  71,
  73,
  74,
  75,
  76,
  77,
  78,
  80,
  81,
  82,
  83,
  84,
  85,
  87,
  88,
  89,
  90,
  91,
  92,
  93,
  94,
  96,
  97,
  98,
  99,
  100,
  101,
  102,
  103,
  104,
  105,
  106,
  108,
  109,
  110,
  111,
  112,
  113,
  114,
  115,
  116,
  117,
  118,
  119,
  120,
  121,
  122,
  123,
  124,
  125,
  126,
  127,
  128,
  129,
  131,
  132,
  133,
  134,
  135,
  136,
  137,
  138,
  139,
  140,
  140,
  141,
  142,
  143,
  144,
  145,
  146,
  147,
  148,
  149,
  150,
  151,
  152,
  153,
  154,
  155,
  156,
  157,
  158,
  159,
  160,
  161,
  162,
  162,
  163,
  164,
  165,
  166,
  167,
  168,
  169,
  170,
  171,
  172,
  173,
  173,
  174,
  175,
  176,
  177,
  178,
  179,
  180,
  181,
  181,
  182,
  183,
  184,
  185,
  186,
  187,
  188,
  188,
  189,
  190,
  191,
  192,
  193,
  194,
  194,
  195,
  196,
  197,
  198,
  199,
  200,
  200,
  201,
  202,
  203,
  204,
  205,
  205,
  206,
  207,
  208,
  209,
  209,
  210,
  211,
  212,
  213,
  214,
  214,
  215,
  216,
  217,
  218,
  218,
  219,
  220,
  221,
  222,
  222,
  223,
  224,
  225,
  225,
  226,
  227,
  228,
  229,
  229,
  230,
  231,
  232,
  232,
  233,
  234,
  235,
  235,
  236,
  237,
  238,
  239,
  239,
  240,
  241,
  242,
  242,
  243,
  244,
  245,
  245,
  246,
  247,
  247,
  248,
  249,
  250,
  250,
  251,
  252,
  253,
  253,
  254,
  255,
};

void t() {
  int i;
  int log;

  i = rand() & 0xFFFF;
  /* Ensure i > 0. */
  if (i == 0) {
     i = 1;
  }
  /* Calculate 256 * log2(i) in 'log'. */
  log = 0;
  /* Get the integer part of log2(i) by looking for the first
   * non-zero bit in i. */
  while ((i & 0x10000) == 0) {
    i = i << 1;
    log = log - 256;
  }
  /* Get the fraction part by table lookup. */
  log += table[(i & 0xFF00) >> 8];
  /* Pretend to be calculating a score with weight 10. */
  log = - log / 10;
}

main() {
  int limit = 100000000;
  int j;
  time_t t1, t2;

  t1 = time(NULL);
  for (j = 0; j < limit; j++) {
    t();
  }
  t2 = time(NULL);
  printf("%d %d\n", (int) t1, (int) t2);
  printf("%e\n", ((float) (t2 - t1)) / limit);
}
