# SingularityCE Support

SingularityCE is a community focused open source project. We maintain
[documentation](#documentation), which everyone is welcomed and encouraged to
contribute to. We have a number of spaces, maintained by the project, in which
questions can be asked and problems reported.

- [GitHub Discussions](#github-discussions) - Usage questions, discussions, and announcements.
- [Google Group / Mailing List](#google-group--mailing-list)  - Usage questions,
  discussions, and announcements.
- [Slack](#slack) - Real time chat.
- [GitHub Issues](#github-issues) - Bug reports & feature requests.
- [Community Calls](#community-calls) - Development updates and discussion.

## Documentation

If you haven't already, please read our
[documentation](https://www.sylabs.io/docs/). The user and admin focused docs
cover common use cases, and are often helpful to browse before submitting an
issue or asking a question to the community.

The documentation is released under an open source license, and we encourage
contributions via the GitHub repositories:

- [singularity-admindocs](https://github.com/sylabs/singularity-admindocs)
- [singularity-userdocs](https://github.com/sylabs/singularity-userdocs)

## GitHub Discussions

[GitHub Discussions](https://github.com/sylabs/singularity/discussions) on the
SingularityCE repository provides a convenient place to reach the user and
developer community, and:

- Ask usage questions.
- Suggest, discuss, and develop ideas for new features.
- Provide input into the SingularityCE development roadmap.
- Keep up-to-date with releases and community calls.

As a searchable and permanent archive of questions and discussion, we encourage
you to use GitHub discussions to reach the broadest audience of SingularityCE
users and developers.

## Google Group / Mailing List

If you prefer a more traditional mailing list for announcements and discussions,
you can subscribe to the low volume [Google
Group](https://groups.google.com/g/singularity-ce).

## Slack

For real time conversation with the community, you can join our Slack -
[singularityce.slack.com](https://singularityce.slack.com/). An up-to-date
direct invite link can be found at the [Sylabs
website](https://sylabs.io/singularity/).

Note that the Slack is hosted under a free plan, with limited retention of
conversation history. Please use [GitHub
Discussions](https://github.com/sylabs/singularity/discussions) when a
searchable permanent archive would be beneficial.

## Github Issues

For bugs, feature requests, and other technical issues we recommend opening a
new issue on the Github issues boards.

- [SingularityCE Issues](https://github.com/sylabs/singularity/issues): is
  recommended for most issues with the SingularityCE software itself.
- [User Documentation](https://github.com/sylabs/singularity-userdocs/issues)
  questions, feedback, and suggestions should go here.
- [Admin Documentation](https://github.com/sylabs/singularity-admindocs/issues)
  questions, feedback, and suggestions should go here.

Note that usage questions, or problems related to running a specific piece of
software in a container, are best asked on GitHub Discussions, the Google Group,
or in the Slack channel. Questions in these venues will be seen by a greater
number of users, who may already know the answer!

### How should I create an issue?

After you identify a bug, or have an idea for a new feature, you should search
the issue board for similar problems reported by other users. Another user may
be facing the same issue, and you can add a +1 (in message or icon) to indicate
to the maintainers that the issue is pressing for you as well. The squeaky wheel
gets the grease!

### How is time allocated to addressing issues?

Like many open source projects, the majority of development work on
SingularityCE is carried out by maintainers and a small number of key
contributors. While we wish we could address every issue, there are only so many
hours in the day. We rank issues based on the following questions:

1. How many users are affected?
1. Is there a proposed work-around?
1. In how many instances does the proposed work-around fail?

With these simple questions, we can ensure that work is directed and has the
maximum impact! However, if your issue doesn't seem to be getting attention you
can still move it along using some of the strategies discussed below.

### What if my issue goes stale?

Issues can go stale for a number of reasons. In the bullets below, we will
review some of these reasons, along with strategies for managing them:

1. *The issue needs a gentle reminder*. Try targeting a few people with a
   "`ping @username any thoughts about this?`" in the case that it was
   forgotten.
1. *Was your issue properly explained*? You are much more likely to get help
   when you give clear instructions for reproducing the issue, and show effort
   on your part to think about what the problem might be. If possible, try to
   come up with a way to reproduce the issue that does not involve a special
   environment or exotic hardware.
1. *Is there broad need*? It could be that your issue isn't having a big enough
   impact for other users to warrant the time for the small development team. In
   this case, you might try implementing a suggested fix, and then asking for
   help with the details.
1. *Is your issue scattered?* When many issues pile up on boards, it sometimes
   is the case that issues are duplicated. It's important to find these
   duplicates and merge them into one, because in finding the duplicate you find
   another user to talk to about the issue.
1. *Does your issue need to have scope?* The idea of scoping an issue means
   framing it with respect to other components of the software. For example, if
   you have a feature request to see metadata about an object, you might frame
   that in the context of container introspection, and suggest an addition to
   the software that fits with the "inspect" command. This kind of contribution
   is much more powerful than simply asking for something.
1. *Consider contributing code* If you are able, opening a PR, even if it is
   imperfect or incomplete, can often provided the momentum needed to get a fix
   or enhancement rolling.

## Community Calls

Regular community calls are held for the project, on the first Thursday of each
month, via Zoom. These calls are an excellent place to raise feature suggestions
or kick-off discussion about something you'd like to see in SingularityCE.
Meeting details are posted in [GitHub
Discussions](https://github.com/sylabs/singularity/discussions/categories/community-call),
and recordings at the [Sylabs YouTube
Channel](https://www.youtube.com/channel/UCsxpqAJKGJBMEFHFr-5VL2w).
