# Reverse proxy

If Shaarli is hosted on a server behind a [reverse proxy](https://en.wikipedia.org/wiki/Reverse_proxy) (i.e. there is a proxy server between clients and the web server hosting Shaarli), configure it accordingly. See [Reverse proxy](Reverse-proxy.md) configuration. In this example:

- The Shaarli application server exposes port `10080` to the proxy (for example docker container started with `--publish 127.0.0.1:10080:80`).
- The Shaarli application server runs at `127.0.0.1` (container). Replace with the server's IP address if running on a different machine.
- Shaarli's Fully Qualified Domain Name (FQDN) is `shaarli.mydomain.org`.
- No HTTPS is setup on the application server, SSL termination is done at the reverse proxy.

In your [Shaarli configuration](Shaarli-configuration) `data/config.json.php`, add the public IP of your proxy under `security.trusted_proxies`.

See also [proxy-related](https://github.com/shaarli/Shaarli/issues?utf8=%E2%9C%93&q=label%3Aproxy+) issues.


## Apache

```apache
<VirtualHost *:80>
    ServerName shaarli.mydomain.org

    # For SSL/TLS certificates acquired with certbot or self-signed certificates
    # Redirect HTTP requests to HTTPS, except Let's Encrypt ACME challenge requests
    RewriteEngine on
    RewriteRule ^.well-known/acme-challenge/ - [L]
    RewriteCond %{HTTP_HOST} =shaarli.mydomain.org
    RewriteRule  ^ https://shaarli.mydomain.org%{REQUEST_URI} [END,NE,R=permanent]
</VirtualHost>

# SSL/TLS configuration for Let's Encrypt certificates managed with mod_md
#MDomain shaarli.mydomain.org
#MDCertificateAgreement accepted
#MDContactEmail admin@shaarli.mydomain.org
#MDPrivateKeys RSA 4096

<VirtualHost *:443>
    ServerName shaarli.mydomain.org

    # SSL/TLS configuration for Let's Encrypt certificates acquired with certbot standalone
    SSLEngine             on
    SSLCertificateFile    /etc/letsencrypt/live/shaarli.mydomain.org/fullchain.pem
    SSLCertificateKeyFile /etc/letsencrypt/live/shaarli.mydomain.org/privkey.pem
    # Let's Encrypt settings from https://github.com/certbot/certbot/blob/master/certbot-apache/certbot_apache/_internal/tls_configs/current-options-ssl-apache.conf
    SSLProtocol             all -SSLv2 -SSLv3 -TLSv1 -TLSv1.1
    SSLCipherSuite          ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384
    SSLHonorCipherOrder     off
    SSLSessionTickets       off
    SSLOptions +StrictRequire

    # SSL/TLS configuration for self-signed certificates
    #SSLEngine             on
    #SSLCertificateFile    /etc/ssl/certs/ssl-cert-snakeoil.pem
    #SSLCertificateKeyFile /etc/ssl/private/ssl-cert-snakeoil.key

    # let the proxied shaarli server/container know HTTPS URLs should be served
    RequestHeader set X-Forwarded-Proto "https"

    # send the original SERVER_NAME to the proxied host
    ProxyPreserveHost On
    
    # pass requests to the proxied host
    # sets X-Forwarded-For, X-Forwarded-Host and X-Forwarded-Server headers
    ProxyPass        / http://127.0.0.1:10080/
    ProxyPassReverse / http://127.0.0.1:10080/
</VirtualHost>
```


## HAProxy


```conf
global
    [...]

defaults
    [...]

frontend http-in
    bind :80
    redirect scheme https code 301 if !{ ssl_fc }
    bind :443 ssl crt /path/to/cert.pem
    default_backend shaarli

backend shaarli
    mode http
    option http-server-close
    option forwardfor
    reqadd X-Forwarded-Proto: https
    server shaarli1 127.0.0.1:10080
```

- [HAProxy documentation](https://cbonte.github.io/haproxy-dconv/)

## Nginx


```nginx
http {
    [...]

    index index.html index.php;

    root        /home/john/web;
    access_log  /var/log/nginx/access.log combined;
    error_log   /var/log/nginx/error.log;

    server {
        listen       80;
        server_name  shaarli.mydomain.org;
        # redirect HTTP to HTTPS
        return       301 https://shaarli.mydomain.org$request_uri;
    }

    server {
        listen       443 ssl http2;
        server_name  shaarli.mydomain.org;

        ssl_certificate       /path/to/certificate
        ssl_certificate_key   /path/to/private/key

        location / {
            proxy_set_header  X-Real-IP         $remote_addr;
            proxy_set_header  X-Forwarded-For   $proxy_add_x_forwarded_for;
            proxy_set_header  X-Forwarded-Proto $scheme;
            proxy_set_header  X-Forwarded-Host  $host;

            # pass requests to the proxied host
            proxy_pass             http://localhost:10080/;
            proxy_set_header Host  $host;
            proxy_connect_timeout  30s;
            proxy_read_timeout     120s;
        }
    }
}
```

## References

- [`X-Forwarded-Proto`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Proto)
- [`X-Forwarded-Host`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host)
- [`X-Forwarded-For`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For)
