/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef NUVIE_VIEWS_INVENTORY_FONT_H
#define NUVIE_VIEWS_INVENTORY_FONT_H

namespace Ultima {
namespace Nuvie {

static const int NUVIE_MICRO_FONT_COUNT = 26;

const unsigned char inventory_font[NUVIE_MICRO_FONT_COUNT][15] = {
	{
		1, 1, 1,
		1, 0, 1,
		1, 0, 1,
		1, 0, 1,
		1, 1, 1
	}
	,
	{
		0, 0, 1,
		0, 0, 1,
		0, 0, 1,
		0, 0, 1,
		0, 0, 1
	}
	,
	{
		1, 1, 1,
		0, 0, 1,
		1, 1, 1,
		1, 0, 0,
		1, 1, 1
	}
	,
	{
		1, 1, 1,
		0, 0, 1,
		1, 1, 1,
		0, 0, 1,
		1, 1, 1
	}
	,
	{
		1, 0, 1,
		1, 0, 1,
		1, 1, 1,
		0, 0, 1,
		0, 0, 1
	}
	,
	{
		1, 1, 1,
		1, 0, 0,
		1, 1, 1,
		0, 0, 1,
		1, 1, 1
	}
	,
	{
		1, 1, 1,
		1, 0, 0,
		1, 1, 1,
		1, 0, 1,
		1, 1, 1
	}
	,
	{
		1, 1, 1,
		0, 0, 1,
		0, 0, 1,
		0, 0, 1,
		0, 0, 1
	}
	,
	{
		1, 1, 1,
		1, 0, 1,
		1, 1, 1,
		1, 0, 1,
		1, 1, 1
	}
	,
	{
		1, 1, 1,
		1, 0, 1,
		1, 1, 1,
		0, 0, 1,
		0, 0, 1
	}
	, // A
	{
		1, 1, 1,
		1, 0, 1,
		1, 1, 1,
		1, 0, 1,
		1, 0, 1
	}
	, // B
	{
		1, 1, 0,
		1, 0, 1,
		1, 1, 0,
		1, 0, 1,
		1, 1, 0
	}
	, // C
	{
		1, 1, 1,
		1, 0, 0,
		1, 0, 0,
		1, 0, 0,
		1, 1, 1
	}
	, // D
	{
		1, 1, 0,
		1, 0, 1,
		1, 0, 1,
		1, 0, 1,
		1, 1, 0
	}
	, // E
	{
		1, 1, 1,
		1, 0, 0,
		1, 1, 1,
		1, 0, 0,
		1, 1, 1
	}
	, // F
	{
		1, 1, 1,
		1, 0, 0,
		1, 1, 0,
		1, 0, 0,
		1, 0, 0
	}
	, // G
	{
		1, 1, 1,
		1, 0, 0,
		1, 0, 1,
		1, 0, 1,
		1, 1, 1
	}
	, // H
	{
		1, 0, 1,
		1, 0, 1,
		1, 1, 1,
		1, 0, 1,
		1, 0, 1
	}
	, // I
	{
		1, 1, 1,
		0, 1, 0,
		0, 1, 0,
		0, 1, 0,
		1, 1, 1
	}
	, // J
	{
		0, 0, 1,
		0, 0, 1,
		0, 0, 1,
		1, 0, 1,
		1, 1, 1
	}
	, // K
	{
		1, 0, 1,
		1, 0, 1,
		1, 1, 0,
		1, 0, 1,
		1, 0, 1
	}
	, // L
	{
		1, 0, 0,
		1, 0, 0,
		1, 0, 0,
		1, 0, 0,
		1, 1, 1
	}
	, // M
	{
		1, 0, 1,
		1, 1, 1,
		1, 0, 1,
		1, 0, 1,
		1, 0, 1
	}
	, // n
	{
		0, 0, 0,
		0, 0, 0,
		1, 1, 1,
		1, 0, 1,
		1, 0, 1
	}
	, // o
	{
		0, 0, 0,
		0, 0, 0,
		1, 1, 1,
		1, 0, 1,
		1, 1, 1
	}
	, // P
	{
		1, 1, 1,
		1, 0, 1,
		1, 1, 1,
		1, 0, 0,
		1, 0, 0
	}

};

} // End of namespace Nuvie
} // End of namespace Ultima

#endif
