# Enhancements and Additions

## Dotless identifiers

Previously, objects generated by the library were given id properties with values that contained dots (e.g. "OpenLayers.Control.Navigation_2").  These same identifiers are also used for DOM elements in some case.  Though uncommon, a developer may want to access these elements with a CSS selector.  To facilitate this, we now always generate ids with underscore instead of dot.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/416

## Better support for analog scroll wheel

Removed rounding of zoom level for maps with fractionalZoom == true. So users with an OS and interface device with analog scroll support will now get smooth zooming.

Corresponding issues/pull requests:

 * https://github.com/openlayers/openlayers/pull/483
 
## Google v3 Layer

This release changes the way Google layers are integrated with OpenLayers. With this change, OpenLayers should be less fragile to changes of the GMaps API version, because no DOM elements inside the Google container need to be modified by OpenLayers any more.

Application developers should be aware that the Google Map of an `OpenLayers.Layer.Google.v3` instance is no longer added to the map's `viewPortDiv`. Instead, the `viewPortDiv` is added as Google Maps control to the Google map. This means that when switching base layers, the whole DOM structure below the map's `div` changes.

Corresponding issues/pull requests:

* https://github.com/openlayers/openlayers/pull/484

## Bing Layer

All requests to the Bing Maps service are now sent using the same protocol as the OpenLayers application using the Bing layer. For file:/// URIs, the http
protocol is used. A new config option `protocol` has been introduced to set the protocol to use for requests to the Bing Maps service. 'https:' should work fine, but the availability of tiles and attribution logo with the https protocol is not guaranteed. If in doubt, set `protocol` to 'http:'.

Corresponding issues/pull requests:

* http://github.com/openlayers/openlayers/pull/700

## New Map and Vector Layer Events for Feature Interaction

The featureclick events extension (`lib/Events/featureclick.js`) provides four new events ("featureclick", "nofeatureclick", "featureover", "featureout") that can be used as an alternative to the Feature handler or the
SelectFeature control. It works with multiple layers out of the box and can detect hits on multiple features (except when using the Canvas renderer). See `examples/feature-events.html` for an implementation example.

# Behavior Changes from Past Releases

## Control.DragPan: Kinetic by default

The `enableKinetic` property for the DragPan control has been changed to true by default.  This will enable kinetic panning only if the `OpenLayers/Kinetic.js` file is included in your build.

## Control.ModifyFeature: no more built-in SelectFeature control

The ModifyFeature control is now much leaner, making it more reliable when combined with other controls. The most noticable change is that it has no
`selectControl` member any more. Users who previously relied on this built-in SelectFeature control will now have to create both a SelectFeature and a ModifyFeature control and configure the ModifyFeature control with `standalone: true`. To get features selected, call the `selectFeature` method e.g. from a `featureselected` listener on the vector layer. Note that other than in the old implementation, calling `selectFeature` on an already selected feature will not do anything.

## Format.GPX: No more prefixes

No `gpx:` prefix is added in the XML tags anymore when writing GPX from `OpenLayers` features. It seems like it is not supported by most of the tools that are able to read GPX.

## Different return type for OpenLayers.Format.WMSDescribeLayer

The return type of WMSDescribeLayer format's `read` method was different from the one of the VersionedOGC format superclass. So it was changed from an array to an object with a layerDescriptions property that holds the array. For backwards compatibility, the object still has a length property and 0, ..., n properties with the previous array values.

## Moved errorProperty from the base class to the parser in Format.OWSCommon

This was necessary for WCS support because there are no properties in common between versions 1.0.0 and 1.1.0 that were appropriate for checking.  The only existing code that this affected was WFS parsing.

## Layer.Grid: Tile queue and tileLoadingDelay changes

With the introduction of OpenLayers.TileManager, tile queueing has become optional but is enabled by default. To not use a tile queue in 2.13, the map needs to be configured with tileManager: null, e.g.:

    var map = new OpenLayers.Map('map', {
        tileManager: null
    });

The tile queue works differently than before: it no longer loads one tile at a time. Instead, it waits after a zoom or pan, and loads all tiles after a delay. This has the same effect as previously (less burden on the server), but makes use of the browser's request management. The delay can be configured separately for zooming and moving the map, using the `zoomDelay` (default: 200 ms) and `moveDelay` (default: 100 ms) config options of the TileManager. If you want to have the map be associated with a TileManager with non-default options, supply the options instead or create your own TileManager instance and supply it to the Map constructor.

The `moveDelay` is the replacement for the `tileLoadingDelay` layer config option, which has been removed. There is no magic any more to only use the delay when requestAnimationFrame is not natively available.

## Layer.Grid: Resize transitions by default

The `transitionEffect` property for grid layers has been changed to "resize" by default.  This allows smooth transitions with animated zooming (also enabled by default).  If resize transitions are not wanted for individual layers, set `transitionEffect` to `null`.

## Map: Animated zooming and GPU support

OpenLayers now has animated zooming, which is enabled by default. To turn it off, configure the map with `zoomMethod: null`.

To make the zoom animation smooth, GPU support is active by default for rendering tiles. This may interfere with UI widgets that overlay the map. In this case, it may be necessary to turn GPU support off, which is done with the following css declaration:

    img.olTileImage {
        -webkit-transform: inherit;
        -moz-transform: inherit;
        -o-transform: inherit;
        -ms-transform: inherit;
        transform: inherit;
        -webkit-backface-visibility: inherit;
        -moz-backface-visibility: inherit;
        -ms-backface-visibility: inherit;
        backface-visibility: inherit;
        -webkit-perspective: inherit;
        -moz-perspective: inherit;
        -ms-perspective: inherit;
        perspective: inherit;
    }

## Map property fallThrough defaults to false

The behaviour controlled by map property fallThrough wasn't consistent (some events were swallowed even with fallThrough set to true) and changes have been made to fix that. Defaulting fallThrough to false after this change is sensible in most situations and will probably be what most applications expect, but if you previously relied on pointer or keyboard events being passed through you will probably want to set fallThrough to true.

Behavioural change was made in this commit:

* https://github.com/openlayers/openlayers/commit/a6119f6a7528e013b922fd0d997a07df13f6bd6e

## window.$ is no longer an alias for OpenLayers.Util.getElement
 
We do no longer create a global variable `$` when such a symbol isn't already
defined. Previous versions of OpenLayers would define `$` to be an alias for 
`OpenLayers.Util.getElement`. If your application requires `window.$` to be 
defined in such a way you can either
 
* include deprecated.js in your custom build or as additional ressource in your
  HTML-file
* or you do the aliasing in your application code yourself:

    `window.$ = OpenLayers.Util.getElement;`

Corresponding issue/pull requests:

* https://github.com/openlayers/openlayers/pull/423

# New Options for Build Script

* add the contents of a file as a comment at the front of the build, for example, the output of 'git describe --tags' could be saved as a file and then included
* create build file as an AMD module

run 'build.py -h' for more details

Corresponding issue/pull requests:

* https://github.com/openlayers/openlayers/pull/528

## Deprecated Components
A number of properties, methods, and constructors have been marked as
deprecated for multiple releases in the 2.x series.
For the 2.13 release this deprecated functionality has been moved to a
separate deprecated.js file.  If you use any of the constructors or
methods below, you will have to explicitly include the deprecated.js
file in your build (or add it in a separate `<script>` tag after
OpenLayers.js).

 * OpenLayers.Layer.Popup.AnchoredBubble

Because the Rico library is now only used by deprecated components, the
files have been removed from the debug loader in lib/OpenLayers.js;
the files have now to be explicitly loaded in a script tag.

## LayerSwitcher rounded corner removal

The deprecated `roundedCorner` and `roundedCornerColor` options have
been removed from the `OpenLayers.Control.LayerSwitcher` control. Use
CSS3's border-radius instead.
