// Created on: 2015-10-26
// Created by: Nikolai BUKHALOV
// Copyright (c) 2002-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <QABugs.hxx>

#include <gp_Ax2.hxx>
#include <Extrema_GenLocateExtPS.hxx>
#include <Geom_Circle.hxx>
#include <Geom_SurfaceOfLinearExtrusion.hxx>
#include <NCollection_List.hxx>
#include <TColgp_Array2OfPnt.hxx>
#include <TColStd_Array2OfReal.hxx>
#include <TColStd_Array1OfReal.hxx>
#include <TColStd_Array1OfInteger.hxx>
#include <Geom_BezierCurve.hxx>
#include <Geom_BSplineSurface.hxx>
#include <GeomConvert.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom2d_Line.hxx>
#include <GeomFill_BSplineCurves.hxx>
#include <Draw.hxx>
#include <DrawTrSurf.hxx>
#include <ShapeConstruct_ProjectCurveOnSurface.hxx>

#include <TopExp.hxx>
#include <TopoDS_Vertex.hxx>
#include <BRep_Tool.hxx>
#include <TopoDS_Edge.hxx>
#include <BRep_Builder.hxx>
#include <BRepTools.hxx>
#include <BRepAdaptor_Surface.hxx>
#include <TopoDS.hxx>
#include <DBRep.hxx>

#include <BRepGProp.hxx>
#include <DDocStd.hxx>
#include <GProp_GProps.hxx>
#include <TDocStd_Document.hxx>
#include <XCAFDimTolObjects_DatumObject.hxx>
#include <XCAFDimTolObjects_DimensionObject.hxx>
#include <XCAFDimTolObjects_GeomToleranceObject.hxx>
#include <XCAFDoc_Datum.hxx>
#include <XCAFDoc_Dimension.hxx>
#include <XCAFDoc_DimTolTool.hxx>
#include <XCAFDoc_DocumentTool.hxx>
#include <XCAFDoc_GeomTolerance.hxx>
#include <XCAFDoc_ShapeTool.hxx>

#include <HLRAppli_ReflectLines.hxx>
#include <HLRBRep_PolyHLRToShape.hxx>
#include <HLRBRep_PolyAlgo.hxx>

#include <Standard_Failure.hxx>

#include <Bnd_OBB.hxx>
#include <BRepBndLib.hxx>
#include <OSD_Timer.hxx>

#include <limits>

//=======================================================================
//function : SurfaceGenOCC26675_1 
//purpose  : Generates a surface for intersect (in corresponding
//            test case). If we save these surfaces to the disk
//            then bug will not be reproduced. Therefore, this generator
//            is very important (despite its taking many lines of the code).
//=======================================================================
static Standard_Integer SurfaceGenOCC26675_1( Draw_Interpretor& theDI,
                                              Standard_Integer  theNArg,
                                              const char ** theArgVal)
{

  if(theNArg < 2)
  {
    theDI << "Use OCC26675_1 result\n";
    return 1;
  }

  const gp_Pnt aCircCenter(-112.93397037070100000000, +177.52792379072199000000, +10.63374076104853900000);
  const gp_Dir aCircN(+0.00000000000000000000, +1.00000000000000000000, +0.00000000000000000000);
  const gp_Dir aCircX(+0.00000000000000000000, -0.00000000000000000000, +1.00000000000000000000);
  const gp_Dir anExtrDir(-500.00000000000000000000, -866.02540378443609000000, +0.00000000000000000000);
  const gp_Ax2 aCircAxes(aCircCenter, aCircN, aCircX);
  const Handle(Geom_Curve) aCurv = new Geom_Circle(aCircAxes, +50.00000000000000000000);

  const Handle(Geom_Surface) aS2 = new Geom_SurfaceOfLinearExtrusion(aCurv, anExtrDir);

  TColgp_Array2OfPnt aPoles(1, 7, 1, 81);
  TColStd_Array2OfReal aWeights(1, 7, 1, 81);
  TColStd_Array1OfReal aUKnots(1, 2), aVKnots(1, 12);
  TColStd_Array1OfInteger aUMult(1, 2), aVMult(1, 12);
  const Standard_Integer aUDegree = 6, aVDegree = 8;

  aUKnots(1) = +0.00000000000000000000;
  aUKnots(2) = +1.00000000000000000000;
  aVKnots(1) = +0.08911853946147080300;
  aVKnots(2) = +0.11779167587451674000;
  aVKnots(3) = +0.14583467562325506000;
  aVKnots(4) = +0.20255081178503931000;
  aVKnots(5) = +0.25926694794682359000;
  aVKnots(6) = +0.31598308410860781000;
  aVKnots(7) = +0.34262437462234741000;
  aVKnots(8) = +0.37067364397889985000;
  aVKnots(9) = +0.39731552779654306000;
  aVKnots(10) = +0.42536420384919182000;
  aVKnots(11) = +0.45200329235672548000;
  aVKnots(12) = +0.47802918742799144000;

  aUMult(1) = 7;
  aUMult(2) = 7;
  aVMult(1) = 9;
  aVMult(2) = 7;
  aVMult(3) = 7;
  aVMult(4) = 7;
  aVMult(5) = 7;
  aVMult(6) = 7;
  aVMult(7) = 7;
  aVMult(8) = 7;
  aVMult(9) = 7;
  aVMult(10) = 8;
  aVMult(11) = 8;
  aVMult(12) = 9;

  ////
  {
    aWeights.ChangeValue(1, 1) = +1.02986327036737910000;
    aPoles.ChangeValue(1, 1) = gp_Pnt(+131.75315905495660000000, +2.88570510351864900000, -66.24709307590461500000);
    aWeights.ChangeValue(1, 2) = +1.02989244478761060000;
    aPoles.ChangeValue(1, 2) = gp_Pnt(+128.70876344053133000000, +2.88791208181246970000, -67.92914281439198000000);
    aWeights.ChangeValue(1, 3) = +1.02991676091113950000;
    aPoles.ChangeValue(1, 3) = gp_Pnt(+125.64133203841195000000, +2.88975018186799830000, -69.56968825975690200000);
    aWeights.ChangeValue(1, 4) = +1.02993613450133650000;
    aPoles.ChangeValue(1, 4) = gp_Pnt(+122.55164101294532000000, +2.89121448973680460000, -71.16831921321855200000);
    aWeights.ChangeValue(1, 5) = +1.02995970896170810000;
    aPoles.ChangeValue(1, 5) = gp_Pnt(+119.44028474076808000000, +2.89299532863950050000, -72.72471137484106400000);
    aWeights.ChangeValue(1, 6) = +1.02998196300928410000;
    aPoles.ChangeValue(1, 6) = gp_Pnt(+116.30796917345266000000, +2.89467567823625730000, -74.23853925439507900000);
    aWeights.ChangeValue(1, 7) = +1.02999781361772440000;
    aPoles.ChangeValue(1, 7) = gp_Pnt(+113.15537818476763000000, +2.89587201010380560000, -75.70949847615843000000);
    aWeights.ChangeValue(1, 8) = +1.03001626830283270000;
    aPoles.ChangeValue(1, 8) = gp_Pnt(+109.98323502828077000000, +2.89726468512897210000, -77.13723994508107800000);
    aWeights.ChangeValue(1, 9) = +1.03004822145815230000;
    aPoles.ChangeValue(1, 9) = gp_Pnt(+103.60126699909762000000, +2.89967510685080440000, -79.90571269046952800000);
    aWeights.ChangeValue(1, 10) = +1.03006364818936770000;
    aPoles.ChangeValue(1, 10) = gp_Pnt(+100.39144092265354000000, +2.90083845616186050000, -81.24644132200651800000);
    aWeights.ChangeValue(1, 11) = +1.03007725635592000000;
    aPoles.ChangeValue(1, 11) = gp_Pnt(+97.16342330855667300000, +2.90186436688425700000, -82.54338871675531700000);
    aWeights.ChangeValue(1, 12) = +1.03009045031501500000;
    aPoles.ChangeValue(1, 12) = gp_Pnt(+93.91790293022438600000, +2.90285879918974650000, -83.79626764915399000000);
    aWeights.ChangeValue(1, 13) = +1.03010285398183930000;
    aPoles.ChangeValue(1, 13) = gp_Pnt(+90.65560197798836800000, +2.90379346029782100000, -85.00479786905465600000);
    aWeights.ChangeValue(1, 14) = +1.03011393120350900000;
    aPoles.ChangeValue(1, 14) = gp_Pnt(+87.37722618415423900000, +2.90462796925060120000, -86.16871841453435400000);
    aWeights.ChangeValue(1, 15) = +1.03012484065787050000;
    aPoles.ChangeValue(1, 15) = gp_Pnt(+84.08346762829417300000, +2.90544970249433290000, -87.28777941880029800000);
    aWeights.ChangeValue(1, 16) = +1.03015471267321200000;
    aPoles.ChangeValue(1, 16) = gp_Pnt(+74.15848807058078800000, +2.90769927244280210000, -90.50962423575197100000);
    aWeights.ChangeValue(1, 17) = +1.03017194800922400000;
    aPoles.ChangeValue(1, 17) = gp_Pnt(+67.48342008926763900000, +2.90899668032978950000, -92.47701903504494700000);
    aWeights.ChangeValue(1, 18) = +1.03018680682765670000;
    aPoles.ChangeValue(1, 18) = gp_Pnt(+60.75515833606132100000, +2.91011480947056490000, -94.26204121664201800000);
    aWeights.ChangeValue(1, 19) = +1.03019958109549670000;
    aPoles.ChangeValue(1, 19) = gp_Pnt(+53.97928154760177200000, +2.91107580930771360000, -95.86305268935117900000);
    aWeights.ChangeValue(1, 20) = +1.03021050389503350000;
    aPoles.ChangeValue(1, 20) = gp_Pnt(+47.16164692132413400000, +2.91189735380426780000, -97.27865560180262600000);
    aWeights.ChangeValue(1, 21) = +1.03021974942385830000;
    aPoles.ChangeValue(1, 21) = gp_Pnt(+40.30838837608569500000, +2.91259264267907050000, -98.50769317562559000000);
    aWeights.ChangeValue(1, 22) = +1.03022743299486370000;
    aPoles.ChangeValue(1, 22) = gp_Pnt(+33.42591476110869300000, +2.91317040233699530000, -99.54925039136011800000);
    aWeights.ChangeValue(1, 23) = +1.03023979631718900000;
    aPoles.ChangeValue(1, 23) = gp_Pnt(+19.61576136171939000000, +2.91409991934468550000, -101.25602945077115000000);
    aWeights.ChangeValue(1, 24) = +1.03024450452679140000;
    aPoles.ChangeValue(1, 24) = gp_Pnt(+12.68754355991407800000, +2.91445385083459700000, -101.92122234436175000000);
    aWeights.ChangeValue(1, 25) = +1.03024781840890120000;
    aPoles.ChangeValue(1, 25) = gp_Pnt(+5.74236948737514120000, +2.91470294045230770000, -102.39751844510502000000);
    aWeights.ChangeValue(1, 26) = +1.03024979501192000000;
    aPoles.ChangeValue(1, 26) = gp_Pnt(-1.21367831605073050000, +2.91485150371151920000, -102.68442590550356000000);
    aWeights.ChangeValue(1, 27) = +1.03025046568879790000;
    aPoles.ChangeValue(1, 27) = gp_Pnt(-8.17455041611474620000, +2.91490191238154670000, -102.78167594353056000000);
    aWeights.ChangeValue(1, 28) = +1.03024983609703540000;
    aPoles.ChangeValue(1, 28) = gp_Pnt(-15.13423127055194300000, +2.91485459458572780000, -102.68922293042964000000);
    aWeights.ChangeValue(1, 29) = +1.03024788619868260000;
    aPoles.ChangeValue(1, 29) = gp_Pnt(-22.08674002008992700000, +2.91470803482494080000, -102.40724441194320000000);
    aWeights.ChangeValue(1, 30) = +1.03024126030624540000;
    aPoles.ChangeValue(1, 30) = gp_Pnt(-35.96556766132121700000, +2.91420996731856930000, -101.46503408514069000000);
    aWeights.ChangeValue(1, 31) = +1.03023657011944230000;
    aPoles.ChangeValue(1, 31) = gp_Pnt(-42.89191729472150200000, +2.91385737699769360000, -100.80479886745856000000);
    aWeights.ChangeValue(1, 32) = +1.03023047292900880000;
    aPoles.ChangeValue(1, 32) = gp_Pnt(-49.79923779841396900000, +2.91339898565004060000, -99.95583114848535900000);
    aWeights.ChangeValue(1, 33) = +1.03022290017099550000;
    aPoles.ChangeValue(1, 33) = gp_Pnt(-56.68161614207340900000, +2.91282960709223810000, -98.91875138839027700000);
    aWeights.ChangeValue(1, 34) = +1.03021374148842180000;
    aPoles.ChangeValue(1, 34) = gp_Pnt(-63.53316994906088400000, +2.91214088593828220000, -97.69440448679608800000);
    aWeights.ChangeValue(1, 35) = +1.03020284473128080000;
    aPoles.ChangeValue(1, 35) = gp_Pnt(-70.34804877511381000000, +2.91132129711663760000, -96.28385939245710300000);
    aWeights.ChangeValue(1, 36) = +1.03019001595653580000;
    aPoles.ChangeValue(1, 36) = gp_Pnt(-77.12043535415037400000, +2.91035614521427500000, -94.68840860671046800000);
    aWeights.ChangeValue(1, 37) = +1.03016805964614980000;
    aPoles.ChangeValue(1, 37) = gp_Pnt(-86.96652166958519100000, +2.90870378328618400000, -92.08365976972685000000);
    aWeights.ChangeValue(1, 38) = +1.03016062145972500000;
    aPoles.ChangeValue(1, 38) = gp_Pnt(-90.07809790629383400000, +2.90814392820824040000, -91.21821667329717800000);
    aWeights.ChangeValue(1, 39) = +1.03015268516758060000;
    aPoles.ChangeValue(1, 39) = gp_Pnt(-93.17869710255469300000, +2.90754650188789080000, -90.31338955501080100000);
    aWeights.ChangeValue(1, 40) = +1.03014422393874510000;
    aPoles.ChangeValue(1, 40) = gp_Pnt(-96.26774201507643600000, +2.90690946644790090000, -89.36934028436292000000);
    aWeights.ChangeValue(1, 41) = +1.03013520381253840000;
    aPoles.ChangeValue(1, 41) = gp_Pnt(-99.34465666946248100000, +2.90623024256504880000, -88.38624129906430900000);
    aWeights.ChangeValue(1, 42) = +1.03012558369857450000;
    aPoles.ChangeValue(1, 42) = gp_Pnt(-102.40886646020824000000, +2.90550570939860810000, -87.36427556081821400000);
    aWeights.ChangeValue(1, 43) = +1.03011531537676040000;
    aPoles.ChangeValue(1, 43) = gp_Pnt(-105.45979824903711000000, +2.90473220450791560000, -86.30363650725728100000);
    aWeights.ChangeValue(1, 44) = +1.03009266486593140000;
    aPoles.ChangeValue(1, 44) = gp_Pnt(-111.76765655411073000000, +2.90302557752729130000, -84.02084620865503000000);
    aWeights.ChangeValue(1, 45) = +1.03007954250893910000;
    aPoles.ChangeValue(1, 45) = gp_Pnt(-115.02237879255169000000, +2.90203661863772000000, -82.79254553120374300000);
    aWeights.ChangeValue(1, 46) = +1.03006700046846360000;
    aPoles.ChangeValue(1, 46) = gp_Pnt(-118.26033551796380000000, +2.90109123094133370000, -81.51987347500843800000);
    aWeights.ChangeValue(1, 47) = +1.03005153385518430000;
    aPoles.ChangeValue(1, 47) = gp_Pnt(-121.48081153033489000000, +2.89992503429592440000, -80.20310945547186100000);
    aWeights.ChangeValue(1, 48) = +1.03003663316288070000;
    aPoles.ChangeValue(1, 48) = gp_Pnt(-124.68310204708784000000, +2.89880123910694910000, -78.84252385592422700000);
    aWeights.ChangeValue(1, 49) = +1.03002002524051230000;
    aPoles.ChangeValue(1, 49) = gp_Pnt(-127.86649232671233000000, +2.89754829341323060000, -77.43842231968982000000);
    aWeights.ChangeValue(1, 50) = +1.03000192732161230000;
    aPoles.ChangeValue(1, 50) = gp_Pnt(-131.03028254956638000000, +2.89618247462029290000, -75.99111259804850200000);
    aWeights.ChangeValue(1, 51) = +1.02996526567113600000;
    aPoles.ChangeValue(1, 51) = gp_Pnt(-137.09281139094972000000, +2.89341459629042360000, -73.11712223836046600000);
    aWeights.ChangeValue(1, 52) = +1.02994403451589630000;
    aPoles.ChangeValue(1, 52) = gp_Pnt(-139.99435839258939000000, +2.89181101472158900000, -71.69634981883045600000);
    aWeights.ChangeValue(1, 53) = +1.02992866105538440000;
    aPoles.ChangeValue(1, 53) = gp_Pnt(-142.87784656482347000000, +2.89064973421052680000, -70.23882874204873900000);
    aWeights.ChangeValue(1, 54) = +1.02989968743283590000;
    aPoles.ChangeValue(1, 54) = gp_Pnt(-145.74271824362268000000, +2.88845983550875030000, -68.74489127449217600000);
    aWeights.ChangeValue(1, 55) = +1.02988222474524970000;
    aPoles.ChangeValue(1, 55) = gp_Pnt(-148.58838121276386000000, +2.88713941077432070000, -67.21475112846350400000);
    aWeights.ChangeValue(1, 56) = +1.02985386954408620000;
    aPoles.ChangeValue(1, 56) = gp_Pnt(-151.41432118416620000000, +2.88499463682574180000, -65.64875099202183200000);
    aWeights.ChangeValue(1, 57) = +1.02982704006090460000;
    aPoles.ChangeValue(1, 57) = gp_Pnt(-154.21993049579214000000, +2.88296397171855910000, -64.04717955157212800000);
    aWeights.ChangeValue(1, 58) = +1.02976639514278400000;
    aPoles.ChangeValue(1, 58) = gp_Pnt(-160.00375832753414000000, +2.87837140815595260000, -60.64735416015690100000);
    aWeights.ChangeValue(1, 59) = +1.02972545417711370000;
    aPoles.ChangeValue(1, 59) = gp_Pnt(-162.97914403387477000000, +2.87526824819569480000, -58.84445149944087200000);
    aWeights.ChangeValue(1, 60) = +1.02970377642253300000;
    aPoles.ChangeValue(1, 60) = gp_Pnt(-165.92810584856278000000, +2.87362619373759860000, -56.99783055334398100000);
    aWeights.ChangeValue(1, 61) = +1.02963665582001740000;
    aPoles.ChangeValue(1, 61) = gp_Pnt(-168.85438185317770000000, +2.86853152516479340000, -55.11698298198095400000);
    aWeights.ChangeValue(1, 62) = +1.02961756328192160000;
    aPoles.ChangeValue(1, 62) = gp_Pnt(-171.75125340157436000000, +2.86708271055963240000, -53.19057330425229700000);
    aWeights.ChangeValue(1, 63) = +1.02954937293527580000;
    aPoles.ChangeValue(1, 63) = gp_Pnt(-174.62251681022158000000, +2.86190007017706360000, -51.22700225930964300000);
    aWeights.ChangeValue(1, 64) = +1.02950097342691520000;
    aPoles.ChangeValue(1, 64) = gp_Pnt(-177.46620192435449000000, +2.85821732043423180000, -49.22415777229338100000);
    aWeights.ChangeValue(1, 65) = +1.02943612532291810000;
    aPoles.ChangeValue(1, 65) = gp_Pnt(-180.28206426096281000000, +2.85327724467687100000, -47.18300981722491400000);
    aWeights.ChangeValue(1, 66) = +1.02937840445786000000;
    aPoles.ChangeValue(1, 66) = gp_Pnt(-182.89713737694305000000, +2.84888100315162470000, -45.28741010449485300000);
    aWeights.ChangeValue(1, 67) = +1.02929786839840220000;
    aPoles.ChangeValue(1, 67) = gp_Pnt(-185.48808576506855000000, +2.84272935508061810000, -43.35897595091199000000);
    aWeights.ChangeValue(1, 68) = +1.02927785532845030000;
    aPoles.ChangeValue(1, 68) = gp_Pnt(-188.05509745668041000000, +2.84122612975151250000, -41.39706700987362400000);
    aWeights.ChangeValue(1, 69) = +1.02909457173363930000;
    aPoles.ChangeValue(1, 69) = gp_Pnt(-190.59634219852757000000, +2.82717082550985440000, -39.40453806610211300000);
    aWeights.ChangeValue(1, 70) = +1.02915656102508410000;
    aPoles.ChangeValue(1, 70) = gp_Pnt(-193.11296933822229000000, +2.83195841118334000000, -37.37763511391345600000);
    aWeights.ChangeValue(1, 71) = +1.02891246603941110000;
    aPoles.ChangeValue(1, 71) = gp_Pnt(-195.60305999702362000000, +2.81322479805689340000, -35.32107774203857500000);
    aWeights.ChangeValue(1, 72) = +1.02884001996307940000;
    aPoles.ChangeValue(1, 72) = gp_Pnt(-198.06589030811097000000, +2.80764438138268390000, -33.23208121127716900000);
    aWeights.ChangeValue(1, 73) = +1.02870418206103250000;
    aPoles.ChangeValue(1, 73) = gp_Pnt(-200.50111697620073000000, +2.79717360924099090000, -31.11182660391394400000);
    aWeights.ChangeValue(1, 74) = +1.02860417892814660000;
    aPoles.ChangeValue(1, 74) = gp_Pnt(-202.93720652839650000000, +2.78949733525485710000, -28.99085629216911300000);
    aWeights.ChangeValue(1, 75) = +1.02826579045547110000;
    aPoles.ChangeValue(1, 75) = gp_Pnt(-205.34394850673777000000, +2.76315604312090550000, -26.83940109433629200000);
    aWeights.ChangeValue(1, 76) = +1.02871793966742330000;
    aPoles.ChangeValue(1, 76) = gp_Pnt(-207.72575255584553000000, +2.79855565223875710000, -24.65500081264426800000);
    aWeights.ChangeValue(1, 77) = +1.02728787827176630000;
    aPoles.ChangeValue(1, 77) = gp_Pnt(-210.07706367406874000000, +2.68725363743552850000, -22.43634910730148800000);
    aWeights.ChangeValue(1, 78) = +1.02767535385809120000;
    aPoles.ChangeValue(1, 78) = gp_Pnt(-212.39605978578481000000, +2.71705476277515070000, -20.20562112100595800000);
    aWeights.ChangeValue(1, 79) = +1.02745809923169020000;
    aPoles.ChangeValue(1, 79) = gp_Pnt(-214.68098626410506000000, +2.69985190382785320000, -17.91605900374278100000);
    aWeights.ChangeValue(1, 80) = +1.02725110106359850000;
    aPoles.ChangeValue(1, 80) = gp_Pnt(-216.94385389331507000000, +2.68435107488514250000, -15.61289037092123000000);
    aWeights.ChangeValue(1, 81) = +1.02619749797986360000;
    aPoles.ChangeValue(1, 81) = gp_Pnt(-219.16685583874414000000, +2.59983520096898510000, -13.28583956380401400000);
    aWeights.ChangeValue(2, 1) = +1.00955713824395700000;
    aPoles.ChangeValue(2, 1) = gp_Pnt(+131.76756408216349000000, +2.10451717388867540000, -66.27316135719137000000);
    aWeights.ChangeValue(2, 2) = +1.00956608612165600000;
    aPoles.ChangeValue(2, 2) = gp_Pnt(+128.72252404033563000000, +2.10631182699007670000, -67.95492700832653600000);
    aWeights.ChangeValue(2, 3) = +1.00957354292813030000;
    aPoles.ChangeValue(2, 3) = gp_Pnt(+125.65455798821807000000, +2.10780700070896730000, -69.59522708152212500000);
    aWeights.ChangeValue(2, 4) = +1.00957948395970430000;
    aPoles.ChangeValue(2, 4) = gp_Pnt(+122.56436007131990000000, +2.10899819276768510000, -71.19369911011085600000);
    aWeights.ChangeValue(2, 5) = +1.00958671248272140000;
    aPoles.ChangeValue(2, 5) = gp_Pnt(+119.45249930698063000000, +2.11044722765431250000, -72.74983445837314400000);
    aWeights.ChangeValue(2, 6) = +1.00959353559448470000;
    aPoles.ChangeValue(2, 6) = gp_Pnt(+116.31971419268339000000, +2.11181476538007030000, -74.26341133748536500000);
    aWeights.ChangeValue(2, 7) = +1.00959839503054960000;
    aPoles.ChangeValue(2, 7) = gp_Pnt(+113.16673272248508000000, +2.11278857229853930000, -75.73421464457315700000);
    aWeights.ChangeValue(2, 8) = +1.00960405269294800000;
    aPoles.ChangeValue(2, 8) = gp_Pnt(+109.99417142410560000000, +2.11392227976110990000, -77.16175403351917300000);
    aWeights.ChangeValue(2, 9) = +1.00961384794963970000;
    aPoles.ChangeValue(2, 9) = gp_Pnt(+103.61137952541701000000, +2.11588481923337430000, -79.92991318438167500000);
    aWeights.ChangeValue(2, 10) = +1.00961857675621050000;
    aPoles.ChangeValue(2, 10) = gp_Pnt(+100.40113044627800000000, +2.11683214779396200000, -81.27049552555527600000);
    aWeights.ChangeValue(2, 11) = +1.00962274789480260000;
    aPoles.ChangeValue(2, 11) = gp_Pnt(+97.17272090352022900000, +2.11766766635255620000, -82.56731642507010300000);
    aWeights.ChangeValue(2, 12) = +1.00962679188946770000;
    aPoles.ChangeValue(2, 12) = gp_Pnt(+93.92682593436140300000, +2.11847763961438810000, -83.82006598438695700000);
    aWeights.ChangeValue(2, 13) = +1.00963059350869510000;
    aPoles.ChangeValue(2, 13) = gp_Pnt(+90.66416580726762200000, +2.11923900414192050000, -85.02847304317147300000);
    aWeights.ChangeValue(2, 14) = +1.00963398843777610000;
    aPoles.ChangeValue(2, 14) = gp_Pnt(+87.38545325411524800000, +2.11991885797243330000, -86.19228543784532800000);
    aWeights.ChangeValue(2, 15) = +1.00963733185346640000;
    aPoles.ChangeValue(2, 15) = gp_Pnt(+84.09136475788710600000, +2.12058835416503610000, -87.31123582184922300000);
    aWeights.ChangeValue(2, 16) = +1.00964648640037450000;
    aPoles.ChangeValue(2, 16) = gp_Pnt(+74.16530685267888100000, +2.12242134451684360000, -90.53282418399284400000);
    aWeights.ChangeValue(2, 17) = +1.00965176794147850000;
    aPoles.ChangeValue(2, 17) = gp_Pnt(+67.48955141808187400000, +2.12347869023601370000, -92.50007118315201600000);
    aWeights.ChangeValue(2, 18) = +1.00965632094816660000;
    aPoles.ChangeValue(2, 18) = gp_Pnt(+60.76066172731987800000, +2.12439006790716880000, -94.28495774595940300000);
    aWeights.ChangeValue(2, 19) = +1.00966023501695720000;
    aPoles.ChangeValue(2, 19) = gp_Pnt(+53.98420072674593900000, +2.12517346720689600000, -95.88584819516199800000);
    aWeights.ChangeValue(2, 20) = +1.00966358166845400000;
    aPoles.ChangeValue(2, 20) = gp_Pnt(+47.16601123883578600000, +2.12584324589548320000, -97.30134659055448800000);
    aWeights.ChangeValue(2, 21) = +1.00966641434734730000;
    aPoles.ChangeValue(2, 21) = gp_Pnt(+40.31221541713015500000, +2.12641013013135180000, -98.53029698991525700000);
    aWeights.ChangeValue(2, 22) = +1.00966876842241260000;
    aPoles.ChangeValue(2, 22) = gp_Pnt(+33.42921418500849000000, +2.12688121470786750000, -99.57178366381829400000);
    aWeights.ChangeValue(2, 23) = +1.00967255617655650000;
    aPoles.ChangeValue(2, 23) = gp_Pnt(+19.61796125907087400000, +2.12763915883061920000, -101.27845724558523000000);
    aWeights.ChangeValue(2, 24) = +1.00967399859793750000;
    aPoles.ChangeValue(2, 24) = gp_Pnt(+12.68919279606528900000, +2.12792777824197280000, -101.94361028295506000000);
    aWeights.ChangeValue(2, 25) = +1.00967501382968900000;
    aPoles.ChangeValue(2, 25) = gp_Pnt(+5.74348853231593990000, +2.12813091177048630000, -102.41987704106546000000);
    aWeights.ChangeValue(2, 26) = +1.00967561936957820000;
    aPoles.ChangeValue(2, 26) = gp_Pnt(-1.21307744928976070000, +2.12825206894226590000, -102.70676666240287000000);
    aWeights.ChangeValue(2, 27) = +1.00967582483410380000;
    aPoles.ChangeValue(2, 27) = gp_Pnt(-8.17446448579617170000, +2.12829317854427910000, -102.80401081431219000000);
    aWeights.ChangeValue(2, 28) = +1.00967563195849760000;
    aPoles.ChangeValue(2, 28) = gp_Pnt(-15.13466558037753100000, +2.12825458864942170000, -102.71156371647888000000);
    aWeights.ChangeValue(2, 29) = +1.00967503459672270000;
    aPoles.ChangeValue(2, 29) = gp_Pnt(-22.08770764998126900000, +2.12813506662251010000, -102.42960214757312000000);
    aWeights.ChangeValue(2, 30) = +1.00967300468446490000;
    aPoles.ChangeValue(2, 30) = gp_Pnt(-35.96760988752987500000, +2.12772890088942160000, -101.48744752427969000000);
    aWeights.ChangeValue(2, 31) = +1.00967156777535580000;
    aPoles.ChangeValue(2, 31) = gp_Pnt(-42.89448004815705000000, +2.12744138030294440000, -100.82725372327035000000);
    aWeights.ChangeValue(2, 32) = +1.00966969979090780000;
    aPoles.ChangeValue(2, 32) = gp_Pnt(-49.80232400744441900000, +2.12706759457740000000, -99.97834162579670200000);
    aWeights.ChangeValue(2, 33) = +1.00966737970297200000;
    aPoles.ChangeValue(2, 33) = gp_Pnt(-56.68523628384353000000, +2.12660332632729520000, -98.94133225857957800000);
    aWeights.ChangeValue(2, 34) = +1.00966457365849260000;
    aPoles.ChangeValue(2, 34) = gp_Pnt(-63.53734456971785200000, +2.12604178346724470000, -97.71706998895581400000);
    aWeights.ChangeValue(2, 35) = +1.00966123497950600000;
    aPoles.ChangeValue(2, 35) = gp_Pnt(-70.35281013187348300000, +2.12537359908900880000, -96.30662240267085400000);
    aWeights.ChangeValue(2, 36) = +1.00965730416314050000;
    aPoles.ChangeValue(2, 36) = gp_Pnt(-77.12582820180557500000, +2.12458683129447450000, -94.71128014840769500000);
    aWeights.ChangeValue(2, 37) = +1.00965057624220010000;
    aPoles.ChangeValue(2, 37) = gp_Pnt(-86.97287762202962800000, +2.12324005462031540000, -92.10671540000876700000);
    aWeights.ChangeValue(2, 38) = +1.00964829695753690000;
    aPoles.ChangeValue(2, 38) = gp_Pnt(-90.08473551349412400000, +2.12278376932639290000, -91.24134329153459100000);
    aWeights.ChangeValue(2, 39) = +1.00964586498084840000;
    aPoles.ChangeValue(2, 39) = gp_Pnt(-93.18562459494498300000, +2.12229689243319890000, -90.33659169532975900000);
    aWeights.ChangeValue(2, 40) = +1.00964327207694590000;
    aPoles.ChangeValue(2, 40) = gp_Pnt(-96.27496896689456200000, +2.12177776971417840000, -89.39262240039663300000);
    aWeights.ChangeValue(2, 41) = +1.00964050782222770000;
    aPoles.ChangeValue(2, 41) = gp_Pnt(-99.35219429474524600000, +2.12122430736176200000, -88.40960770124299000000);
    aWeights.ChangeValue(2, 42) = +1.00963755960468140000;
    aPoles.ChangeValue(2, 42) = gp_Pnt(-102.41672784011750000000, +2.12063397196916760000, -87.38773038403248000000);
    aWeights.ChangeValue(2, 43) = +1.00963441262388320000;
    aPoles.ChangeValue(2, 43) = gp_Pnt(-105.46799849165807000000, +2.12000379050942020000, -86.32718371153289600000);
    aWeights.ChangeValue(2, 44) = +1.00962747055142050000;
    aPoles.ChangeValue(2, 44) = gp_Pnt(-111.77654530973133000000, +2.11861352771318150000, -84.04460889409097000000);
    aWeights.ChangeValue(2, 45) = +1.00962344856326270000;
    aPoles.ChangeValue(2, 45) = gp_Pnt(-115.03162075269803000000, +2.11780798556167320000, -82.81644583890866300000);
    aWeights.ChangeValue(2, 46) = +1.00961960432211730000;
    aPoles.ChangeValue(2, 46) = gp_Pnt(-118.26993104545312000000, +2.11703799459344700000, -81.54389579486141300000);
    aWeights.ChangeValue(2, 47) = +1.00961486342011010000;
    aPoles.ChangeValue(2, 47) = gp_Pnt(-121.49080060905077000000, +2.11608829135299810000, -80.22729418526657200000);
    aWeights.ChangeValue(2, 48) = +1.00961029578343630000;
    aPoles.ChangeValue(2, 48) = gp_Pnt(-124.69348951442340000000, +2.11517321690879800000, -78.86685283462101400000);
    aWeights.ChangeValue(2, 49) = +1.00960520454014850000;
    aPoles.ChangeValue(2, 49) = gp_Pnt(-127.87731027004676000000, +2.11415312105035590000, -77.46291256687052900000);
    aWeights.ChangeValue(2, 50) = +1.00959965618773250000;
    aPoles.ChangeValue(2, 50) = gp_Pnt(-131.04156234039974000000, +2.11304129636208420000, -76.01577573259778800000);
    aWeights.ChangeValue(2, 51) = +1.00958841592243690000;
    aPoles.ChangeValue(2, 51) = gp_Pnt(-137.10496896782513000000, +2.11078854745601690000, -73.14215015354327000000);
    aWeights.ChangeValue(2, 52) = +1.00958190609540830000;
    aPoles.ChangeValue(2, 52) = gp_Pnt(-140.00695092509352000000, +2.10948365684345340000, -71.72161996530125800000);
    aWeights.ChangeValue(2, 53) = +1.00957719225994170000;
    aPoles.ChangeValue(2, 53) = gp_Pnt(-142.89082065884315000000, +2.10853873486620720000, -70.26423921243410600000);
    aWeights.ChangeValue(2, 54) = +1.00956830737110970000;
    aPoles.ChangeValue(2, 54) = gp_Pnt(-145.75622246387837000000, +2.10675729535240960000, -68.77065477701791000000);
    aWeights.ChangeValue(2, 55) = +1.00956295195561060000;
    aPoles.ChangeValue(2, 55) = gp_Pnt(-148.60233584192389000000, +2.10568335609513650000, -67.24065593702246700000);
    aWeights.ChangeValue(2, 56) = +1.00955425555818930000;
    aPoles.ChangeValue(2, 56) = gp_Pnt(-151.42883073983140000000, +2.10393921590561070000, -65.67497260857376800000);
    aWeights.ChangeValue(2, 57) = +1.00954602613011150000;
    aPoles.ChangeValue(2, 57) = gp_Pnt(-154.23502547473331000000, +2.10228833319884910000, -64.07366145615235100000);
    aWeights.ChangeValue(2, 58) = +1.00952742278729300000;
    aPoles.ChangeValue(2, 58) = gp_Pnt(-160.02004322449872000000, +2.09855561509982950000, -60.67448614970191300000);
    aWeights.ChangeValue(2, 59) = +1.00951486183164940000;
    aPoles.ChangeValue(2, 59) = gp_Pnt(-162.99613088380306000000, +2.09603444654779600000, -58.87207545484513800000);
    aWeights.ChangeValue(2, 60) = +1.00950821186194630000;
    aPoles.ChangeValue(2, 60) = gp_Pnt(-165.94554723216726000000, +2.09470002788322150000, -57.02566663092176900000);
    aWeights.ChangeValue(2, 61) = +1.00948761363819010000;
    aPoles.ChangeValue(2, 61) = gp_Pnt(-168.87287521283019000000, +2.09056345777511910000, -55.14566924440539700000);
    aWeights.ChangeValue(2, 62) = +1.00948175483840210000;
    aPoles.ChangeValue(2, 62) = gp_Pnt(-171.77025983587509000000, +2.08938700649796160000, -53.21936605947655600000);
    aWeights.ChangeValue(2, 63) = +1.00946082358399410000;
    aPoles.ChangeValue(2, 63) = gp_Pnt(-174.64262250370552000000, +2.08518149324171190000, -51.25662423685646700000);
    aWeights.ChangeValue(2, 64) = +1.00944596410269540000;
    aPoles.ChangeValue(2, 64) = gp_Pnt(-177.48726621628353000000, +2.08219461660139650000, -49.25423871740036900000);
    aWeights.ChangeValue(2, 65) = +1.00942605045267530000;
    aPoles.ChangeValue(2, 65) = gp_Pnt(-180.30433731845508000000, +2.07819005191471670000, -47.21374002625280800000);
    aWeights.ChangeValue(2, 66) = +1.00940832657289500000;
    aPoles.ChangeValue(2, 66) = gp_Pnt(-182.92026834009920000000, +2.07462614892136180000, -45.31887901738367200000);
    aWeights.ChangeValue(2, 67) = +1.00938358350026620000;
    aPoles.ChangeValue(2, 67) = gp_Pnt(-185.51252638985017000000, +2.06964535925843180000, -43.39137009339865600000);
    aWeights.ChangeValue(2, 68) = +1.00937745534293180000;
    aPoles.ChangeValue(2, 68) = gp_Pnt(-188.07970214515959000000, +2.06841969296490240000, -41.42984981640538000000);
    aWeights.ChangeValue(2, 69) = +1.00932110415642830000;
    aPoles.ChangeValue(2, 69) = gp_Pnt(-190.62397551723822000000, +2.05705915800362950000, -39.43932945784815300000);
    aWeights.ChangeValue(2, 70) = +1.00934018958961060000;
    aPoles.ChangeValue(2, 70) = gp_Pnt(-193.13969442040633000000, +2.06091733419064350000, -37.41169132931209200000);
    aWeights.ChangeValue(2, 71) = +1.00926513417552190000;
    aPoles.ChangeValue(2, 71) = gp_Pnt(-195.63329272671066000000, +2.04578165519120160000, -35.35822241980492500000);
    aWeights.ChangeValue(2, 72) = +1.00924284324010150000;
    aPoles.ChangeValue(2, 72) = gp_Pnt(-198.09761820165846000000, +2.04128022217386820000, -33.26975126412686700000);
    aWeights.ChangeValue(2, 73) = +1.00920104311988150000;
    aPoles.ChangeValue(2, 73) = gp_Pnt(-200.53514329838038000000, +2.03283693524956680000, -31.15087616958502200000);
    aWeights.ChangeValue(2, 74) = +1.00917029694372660000;
    aPoles.ChangeValue(2, 74) = gp_Pnt(-202.97255799662608000000, +2.02663657044316060000, -29.03126127135719200000);
    aWeights.ChangeValue(2, 75) = +1.00906597799637380000;
    aPoles.ChangeValue(2, 75) = gp_Pnt(-205.38430250588374000000, +2.00548607046822540000, -26.88375382824776200000);
    aWeights.ChangeValue(2, 76) = +1.00920552993214340000;
    aPoles.ChangeValue(2, 76) = gp_Pnt(-207.76049754988114000000, +2.03384304897263670000, -24.69318019977189100000);
    aWeights.ChangeValue(2, 77) = +1.00876475817298510000;
    aPoles.ChangeValue(2, 77) = gp_Pnt(-210.12674832523484000000, +1.94448851661030540000, -22.49703905023471500000);
    aWeights.ChangeValue(2, 78) = +1.00888387250469380000;
    aPoles.ChangeValue(2, 78) = gp_Pnt(-212.44800842772909000000, +1.96852329008748410000, -20.25405344977475500000);
    aWeights.ChangeValue(2, 79) = +1.00881670070680670000;
    aPoles.ChangeValue(2, 79) = gp_Pnt(-214.73260668420895000000, +1.95481624964232450000, -17.97008076073228700000);
    aWeights.ChangeValue(2, 80) = +1.00875338528797620000;
    aPoles.ChangeValue(2, 80) = gp_Pnt(-216.99878954601004000000, +1.94217039944868790000, -15.66960286452947800000);
    aWeights.ChangeValue(2, 81) = +1.00842683370719490000;
    aPoles.ChangeValue(2, 81) = gp_Pnt(-219.23765241170187000000, +1.87520469423183880000, -13.35291936652889800000);
    aWeights.ChangeValue(3, 1) = +0.99802424639217791000;
    aPoles.ChangeValue(3, 1) = gp_Pnt(+131.89876890515018000000, +1.35189067474276530000, -66.51059820355672500000);
    aWeights.ChangeValue(3, 2) = +0.99802234515929278000;
    aPoles.ChangeValue(3, 2) = gp_Pnt(+128.85071311608803000000, +1.35313353595059940000, -68.19368716153405800000);
    aWeights.ChangeValue(3, 3) = +0.99802076064203826000;
    aPoles.ChangeValue(3, 3) = gp_Pnt(+125.77977143028471000000, +1.35416922698475650000, -69.83529373030198400000);
    aWeights.ChangeValue(3, 4) = +0.99801949820651126000;
    aPoles.ChangeValue(3, 4) = gp_Pnt(+122.68659332837821000000, +1.35499438550965670000, -71.43508181423516100000);
    aWeights.ChangeValue(3, 5) = +0.99801796211084914000;
    aPoles.ChangeValue(3, 5) = gp_Pnt(+119.57173533591266000000, +1.35599832254451200000, -72.99244308799212900000);
    aWeights.ChangeValue(3, 6) = +0.99801651211145281000;
    aPoles.ChangeValue(3, 6) = gp_Pnt(+116.43595392098000000000, +1.35694592285710100000, -74.50721127326711700000);
    aWeights.ChangeValue(3, 7) = +0.99801547938002733000;
    aPoles.ChangeValue(3, 7) = gp_Pnt(+113.28000153804584000000, +1.35762078417993900000, -75.97921900496575600000);
    aWeights.ChangeValue(3, 8) = +0.99801427699595313000;
    aPoles.ChangeValue(3, 8) = gp_Pnt(+110.10443724854701000000, +1.35840649430771500000, -77.40790012997213400000);
    aWeights.ChangeValue(3, 9) = +0.99801219521191387000;
    aPoles.ChangeValue(3, 9) = gp_Pnt(+103.71561277285424000000, +1.35976677896647580000, -80.17831514578958300000);
    aWeights.ChangeValue(3, 10) = +0.99801119017200446000;
    aPoles.ChangeValue(3, 10) = gp_Pnt(+100.50232486897988000000, +1.36042346207845170000, -81.51999289835789900000);
    aWeights.ChangeValue(3, 11) = +0.99801030363459775000;
    aPoles.ChangeValue(3, 11) = gp_Pnt(+97.27087733082035500000, +1.36100269005924380000, -82.81788136334564900000);
    aWeights.ChangeValue(3, 12) = +0.99800944410125381000;
    aPoles.ChangeValue(3, 12) = gp_Pnt(+94.02193936655145000000, +1.36156425167614130000, -84.07165794609035500000);
    aWeights.ChangeValue(3, 13) = +0.99800863606857426000;
    aPoles.ChangeValue(3, 13) = gp_Pnt(+90.75622955795523700000, +1.36209214789795310000, -85.28105659074749700000);
    aWeights.ChangeValue(3, 14) = +0.99800791446328430000;
    aPoles.ChangeValue(3, 14) = gp_Pnt(+87.47446474935537700000, +1.36256356235759690000, -86.44582972368263500000);
    aWeights.ChangeValue(3, 15) = +0.99800720379689600000;
    aPoles.ChangeValue(3, 15) = gp_Pnt(+84.17731596959211500000, +1.36302781837419680000, -87.56569962027794000000);
    aWeights.ChangeValue(3, 16) = +0.99800525790220496000;
    aPoles.ChangeValue(3, 16) = gp_Pnt(+74.24198734063921300000, +1.36429897306986340000, -90.78996991844945800000);
    aWeights.ChangeValue(3, 17) = +0.99800413521623321000;
    aPoles.ChangeValue(3, 17) = gp_Pnt(+67.56001809965197000000, +1.36503231983535440000, -92.75885901427626800000);
    aWeights.ChangeValue(3, 18) = +0.99800316736440942000;
    aPoles.ChangeValue(3, 18) = gp_Pnt(+60.82490109578901600000, +1.36566449260567850000, -94.54523441794054900000);
    aWeights.ChangeValue(3, 19) = +0.99800233531441818000;
    aPoles.ChangeValue(3, 19) = gp_Pnt(+54.04219505707111900000, +1.36620793936844790000, -96.14746061467829500000);
    aWeights.ChangeValue(3, 20) = +0.99800162387306934000;
    aPoles.ChangeValue(3, 20) = gp_Pnt(+47.21773986109732800000, +1.36667259642912180000, -97.56414160157402200000);
    aWeights.ChangeValue(3, 21) = +0.99800102168630012000;
    aPoles.ChangeValue(3, 21) = gp_Pnt(+40.35765665228271400000, +1.36706588836418840000, -98.79412083143951400000);
    aWeights.ChangeValue(3, 22) = +0.99800052123917371000;
    aPoles.ChangeValue(3, 22) = gp_Pnt(+33.46834796257081700000, +1.36739272798589770000, -99.83648116661171900000);
    aWeights.ChangeValue(3, 23) = +0.99799971600020576000;
    aPoles.ChangeValue(3, 23) = gp_Pnt(+19.64441706716387900000, +1.36791861440644060000, -101.54459131896159000000);
    aWeights.ChangeValue(3, 24) = +0.99799940935225717000;
    aPoles.ChangeValue(3, 24) = gp_Pnt(+12.70928858254282900000, +1.36811887624638580000, -102.21030492597274000000);
    aWeights.ChangeValue(3, 25) = +0.99799919351964705000;
    aPoles.ChangeValue(3, 25) = gp_Pnt(+5.75722078489831280000, +1.36825982711689180000, -102.68697252648171000000);
    aWeights.ChangeValue(3, 26) = +0.99799906478455291000;
    aPoles.ChangeValue(3, 26) = gp_Pnt(-1.20571159764999210000, +1.36834389755229970000, -102.97410341218257000000);
    aWeights.ChangeValue(3, 27) = +0.99799902110371730000;
    aPoles.ChangeValue(3, 27) = gp_Pnt(-8.17346746041202720000, +1.36837242333404090000, -103.07142929357101000000);
    aWeights.ChangeValue(3, 28) = +0.99799906210844536000;
    aPoles.ChangeValue(3, 28) = gp_Pnt(-15.14003926915473600000, +1.36834564548690430000, -102.97890429403182000000);
    aWeights.ChangeValue(3, 29) = +0.99799918910460783000;
    aPoles.ChangeValue(3, 29) = gp_Pnt(-22.09945300681867100000, +1.36826271027814080000, -102.69670494840925000000);
    aWeights.ChangeValue(3, 30) = +0.99799962065035785000;
    aPoles.ChangeValue(3, 30) = gp_Pnt(-35.99208002634647800000, +1.36798088374117890000, -101.75375562004130000000);
    aWeights.ChangeValue(3, 31) = +0.99799992612548816000;
    aPoles.ChangeValue(3, 31) = gp_Pnt(-42.92529183965938000000, +1.36778138671521220000, -101.09300634269859000000);
    aWeights.ChangeValue(3, 32) = +0.99800032324181509000;
    aPoles.ChangeValue(3, 32) = gp_Pnt(-49.83946240643516700000, +1.36752203923507090000, -100.24338136864999000000);
    aWeights.ChangeValue(3, 33) = +0.99800081646744487000;
    aPoles.ChangeValue(3, 33) = gp_Pnt(-56.72868525600537000000, +1.36719992054037180000, -99.20550257416397200000);
    aWeights.ChangeValue(3, 34) = +0.99800141299480705000;
    aPoles.ChangeValue(3, 34) = gp_Pnt(-63.58708851299418500000, +1.36681032802942060000, -97.98021473616272200000);
    aWeights.ChangeValue(3, 35) = +0.99800212274065336000;
    aPoles.ChangeValue(3, 35) = gp_Pnt(-70.40883481115771800000, +1.36634677727753220000, -96.56858555851044900000);
    aWeights.ChangeValue(3, 36) = +0.99800295834605834000;
    aPoles.ChangeValue(3, 36) = gp_Pnt(-77.18812120943384500000, +1.36580100206191160000, -94.97190570545618000000);
    aWeights.ChangeValue(3, 37) = +0.99800438851666018000;
    aPoles.ChangeValue(3, 37) = gp_Pnt(-87.04430869357409500000, +1.36486684103840930000, -92.36516064771883800000);
    aWeights.ChangeValue(3, 38) = +0.99800487302440710000;
    aPoles.ChangeValue(3, 38) = gp_Pnt(-90.15904180478642600000, +1.36455036334574700000, -91.49906951050012100000);
    aWeights.ChangeValue(3, 39) = +0.99800538998403165000;
    aPoles.ChangeValue(3, 39) = gp_Pnt(-93.26280104894121300000, +1.36421268117563340000, -90.59356682763008500000);
    aWeights.ChangeValue(3, 40) = +0.99800594114472085000;
    aPoles.ChangeValue(3, 40) = gp_Pnt(-96.35501076566437500000, +1.36385265030680070000, -89.64881447076304300000);
    aWeights.ChangeValue(3, 41) = +0.99800652872047668000;
    aPoles.ChangeValue(3, 41) = gp_Pnt(-99.43509702281136200000, +1.36346882243976730000, -88.66498478868943800000);
    aWeights.ChangeValue(3, 42) = +0.99800715539011531000;
    aPoles.ChangeValue(3, 42) = gp_Pnt(-102.50248760972849000000, +1.36305944519955100000, -87.64226061031386900000);
    aWeights.ChangeValue(3, 43) = +0.99800782429726853000;
    aPoles.ChangeValue(3, 43) = gp_Pnt(-105.55661203062589000000, +1.36262246213878830000, -86.58083524789229600000);
    aWeights.ChangeValue(3, 44) = +0.99800929984388531000;
    aPoles.ChangeValue(3, 44) = gp_Pnt(-111.87105232543304000000, +1.36165848631400000000, -84.29637819122412200000);
    aWeights.ChangeValue(3, 45) = +0.99801015470554688000;
    aPoles.ChangeValue(3, 45) = gp_Pnt(-115.12916723990907000000, +1.36109998387148300000, -83.06721412498791300000);
    aWeights.ChangeValue(3, 46) = +0.99801097177629106000;
    aPoles.ChangeValue(3, 46) = gp_Pnt(-118.37050305702043000000, +1.36056615831231790000, -81.79361556056927900000);
    aWeights.ChangeValue(3, 47) = +0.99801197939908182000;
    aPoles.ChangeValue(3, 47) = gp_Pnt(-121.59440429164877000000, +1.35990780214188640000, -80.47594855348815200000);
    aWeights.ChangeValue(3, 48) = +0.99801295017732938000;
    aPoles.ChangeValue(3, 48) = gp_Pnt(-124.80011198391350000000, +1.35927349774917520000, -79.11439339164216700000);
    aWeights.ChangeValue(3, 49) = +0.99801403220993246000;
    aPoles.ChangeValue(3, 49) = gp_Pnt(-127.98695272451793000000, +1.35856646260703170000, -77.70931006235629500000);
    aWeights.ChangeValue(3, 50) = +0.99801521135673477000;
    aPoles.ChangeValue(3, 50) = gp_Pnt(-131.15422466608416000000, +1.35779592883408770000, -76.26099835790641600000);
    aWeights.ChangeValue(3, 51) = +0.99801760008173268000;
    aPoles.ChangeValue(3, 51) = gp_Pnt(-137.22341426940562000000, +1.35623488186342090000, -73.38505097675174200000);
    aWeights.ChangeValue(3, 52) = +0.99801898347031770000;
    aPoles.ChangeValue(3, 52) = gp_Pnt(-140.12817143218851000000, +1.35533077140178190000, -71.96340636458091900000);
    aWeights.ChangeValue(3, 53) = +0.99801998518653323000;
    aPoles.ChangeValue(3, 53) = gp_Pnt(-143.01477271081365000000, +1.35467609324036100000, -70.50482384325539400000);
    aWeights.ChangeValue(3, 54) = +0.99802187318341851000;
    aPoles.ChangeValue(3, 54) = gp_Pnt(-145.88296929650440000000, +1.35344206211285110000, -69.01011970904052400000);
    aWeights.ChangeValue(3, 55) = +0.99802301113749214000;
    aPoles.ChangeValue(3, 55) = gp_Pnt(-148.73181832948791000000, +1.35269822187277230000, -67.47885556090747600000);
    aWeights.ChangeValue(3, 56) = +0.99802485896116799000;
    aPoles.ChangeValue(3, 56) = gp_Pnt(-151.56108889838526000000, +1.35149030610332030000, -65.91196867904423600000);
    aWeights.ChangeValue(3, 57) = +0.99802660746081140000;
    aPoles.ChangeValue(3, 57) = gp_Pnt(-154.37005843077941000000, +1.35034719652907540000, -64.30939181125272300000);
    aWeights.ChangeValue(3, 58) = +0.99803055992501810000;
    aPoles.ChangeValue(3, 58) = gp_Pnt(-160.16078498432634000000, +1.34776300585323040000, -60.90758294114521500000);
    aWeights.ChangeValue(3, 59) = +0.99803322842151521000;
    aPoles.ChangeValue(3, 59) = gp_Pnt(-163.13986451909619000000, +1.34601805132734250000, -59.10384793755353900000);
    aWeights.ChangeValue(3, 60) = +0.99803464125751229000;
    aPoles.ChangeValue(3, 60) = gp_Pnt(-166.09208359425281000000, +1.34509430571165490000, -57.25595351707911400000);
    aWeights.ChangeValue(3, 61) = +0.99803901668572381000;
    aPoles.ChangeValue(3, 61) = gp_Pnt(-169.02259847263389000000, +1.34223252516315280000, -55.37471701865561600000);
    aWeights.ChangeValue(3, 62) = +0.99804026123487555000;
    aPoles.ChangeValue(3, 62) = gp_Pnt(-171.92274649713781000000, +1.34141857200850120000, -53.44681670722970100000);
    aWeights.ChangeValue(3, 63) = +0.99804470691034153000;
    aPoles.ChangeValue(3, 63) = gp_Pnt(-174.79824691248783000000, +1.33851025764084610000, -51.48277226031661500000);
    aWeights.ChangeValue(3, 64) = +0.99804786265209489000;
    aPoles.ChangeValue(3, 64) = gp_Pnt(-177.64589658566118000000, +1.33644541377468110000, -49.47887210970986900000);
    aWeights.ChangeValue(3, 65) = +0.99805209132461004000;
    aPoles.ChangeValue(3, 65) = gp_Pnt(-180.46609411219177000000, +1.33367801102763010000, -47.43691639460438100000);
    aWeights.ChangeValue(3, 66) = +0.99805585511720041000;
    aPoles.ChangeValue(3, 66) = gp_Pnt(-183.08478109176986000000, +1.33121501172845690000, -45.54077967192022000000);
    aWeights.ChangeValue(3, 67) = +0.99806110806405779000;
    aPoles.ChangeValue(3, 67) = gp_Pnt(-185.68001727848417000000, +1.32777577033982250000, -43.61205685047624300000);
    aWeights.ChangeValue(3, 68) = +0.99806241123000117000;
    aPoles.ChangeValue(3, 68) = gp_Pnt(-188.24953622256075000000, +1.32692526187276720000, -41.64902509374122300000);
    aWeights.ChangeValue(3, 69) = +0.99807437025077705000;
    aPoles.ChangeValue(3, 69) = gp_Pnt(-190.79766796840426000000, +1.31909012471800140000, -39.65777616520052400000);
    aWeights.ChangeValue(3, 70) = +0.99807032269259688000;
    aPoles.ChangeValue(3, 70) = gp_Pnt(-193.31511620328166000000, +1.32174544077043810000, -37.62798636408343400000);
    aWeights.ChangeValue(3, 71) = +0.99808625039380772000;
    aPoles.ChangeValue(3, 71) = gp_Pnt(-195.81278252670535000000, +1.31130937814640340000, -35.57429171163009600000);
    aWeights.ChangeValue(3, 72) = +0.99809097922828749000;
    aPoles.ChangeValue(3, 72) = gp_Pnt(-198.28008499427182000000, +1.30820906528388470000, -33.48422839734306700000);
    aWeights.ChangeValue(3, 73) = +0.99809984631895698000;
    aPoles.ChangeValue(3, 73) = gp_Pnt(-200.72099421295775000000, +1.30239515227575060000, -31.36416391357070300000);
    aWeights.ChangeValue(3, 74) = +0.99810637147759285000;
    aPoles.ChangeValue(3, 74) = gp_Pnt(-203.16127009409345000000, +1.29812048781277520000, -29.24337154392900800000);
    aWeights.ChangeValue(3, 75) = +0.99812847998895315000;
    aPoles.ChangeValue(3, 75) = gp_Pnt(-205.57777363915829000000, +1.28359951668439790000, -27.09591401257074100000);
    aWeights.ChangeValue(3, 76) = +0.99809892249848597000;
    aPoles.ChangeValue(3, 76) = gp_Pnt(-207.95321979211485000000, +1.30303533816127510000, -24.90029856221717000000);
    aWeights.ChangeValue(3, 77) = +0.99819234539248169000;
    aPoles.ChangeValue(3, 77) = gp_Pnt(-210.32920376311637000000, +1.24168994973372330000, -22.71372419603407900000);
    aWeights.ChangeValue(3, 78) = +0.99816706733577565000;
    aPoles.ChangeValue(3, 78) = gp_Pnt(-212.65404345030839000000, +1.25824740351837460000, -20.46200135460381000000);
    aWeights.ChangeValue(3, 79) = +0.99818127776964660000;
    aPoles.ChangeValue(3, 79) = gp_Pnt(-214.94032188963598000000, +1.24888524402456480000, -18.17894168737611000000);
    aWeights.ChangeValue(3, 80) = +0.99819475509197664000;
    aPoles.ChangeValue(3, 80) = gp_Pnt(-217.21049138159862000000, +1.24010538580557930000, -15.87773552075580100000);
    aWeights.ChangeValue(3, 81) = +0.99826376750414003000;
    aPoles.ChangeValue(3, 81) = gp_Pnt(-219.45963474898130000000, +1.19454909379966280000, -13.56324778739743800000);
    aWeights.ChangeValue(4, 1) = +0.99424302042862245000;
    aPoles.ChangeValue(4, 1) = gp_Pnt(+132.13618409480023000000, +0.70840889522526063000, -66.94024029007874800000);
    aWeights.ChangeValue(4, 2) = +0.99423758610938695000;
    aPoles.ChangeValue(4, 2) = gp_Pnt(+129.08297406972278000000, +0.70909252303575865000, -68.62615176496952100000);
    aWeights.ChangeValue(4, 3) = +0.99423305718875432000;
    aPoles.ChangeValue(4, 3) = gp_Pnt(+126.00685240811242000000, +0.70966228194967051000, -70.27050713058781600000);
    aWeights.ChangeValue(4, 4) = +0.99422944886444642000;
    aPoles.ChangeValue(4, 4) = gp_Pnt(+122.90845587213282000000, +0.71011623149435366000, -71.87297804945868100000);
    aWeights.ChangeValue(4, 5) = +0.99422505844796127000;
    aPoles.ChangeValue(4, 5) = gp_Pnt(+119.78834767262531000000, +0.71066859395963999000, -73.43294438704307900000);
    aWeights.ChangeValue(4, 6) = +0.99422091417503022000;
    aPoles.ChangeValue(4, 6) = gp_Pnt(+116.64728496160824000000, +0.71119000548737488000, -74.95024473036627900000);
    aWeights.ChangeValue(4, 7) = +0.99421796254996875000;
    aPoles.ChangeValue(4, 7) = gp_Pnt(+113.48602386120655000000, +0.71156137519735096000, -76.42471498016054500000);
    aWeights.ChangeValue(4, 8) = +0.99421452605999638000;
    aPoles.ChangeValue(4, 8) = gp_Pnt(+110.30511547520040000000, +0.71199375553590705000, -77.85578472764748900000);
    aWeights.ChangeValue(4, 9) = +0.99420857626658776000;
    aPoles.ChangeValue(4, 9) = gp_Pnt(+103.90553506044348000000, +0.71274238201017392000, -80.63083668700706100000);
    aWeights.ChangeValue(4, 10) = +0.99420570386914531000;
    aPoles.ChangeValue(4, 10) = gp_Pnt(+100.68683453164211000000, +0.71310380757531833000, -81.97476109354066400000);
    aWeights.ChangeValue(4, 11) = +0.99420317017586146000;
    aPoles.ChangeValue(4, 11) = gp_Pnt(+97.44994659335081600000, +0.71342262156961334000, -83.27482261755635300000);
    aWeights.ChangeValue(4, 12) = +0.99420071368291341000;
    aPoles.ChangeValue(4, 12) = gp_Pnt(+94.19554253170841200000, +0.71373172711717636000, -84.53069694549194000000);
    aWeights.ChangeValue(4, 13) = +0.99419840439350793000;
    aPoles.ChangeValue(4, 13) = gp_Pnt(+90.92433917217061900000, +0.71402231445757036000, -85.74211902365664200000);
    aWeights.ChangeValue(4, 14) = +0.99419634212229768000;
    aPoles.ChangeValue(4, 14) = gp_Pnt(+87.63705473050230000000, +0.71428182289044062000, -86.90884124933938900000);
    aWeights.ChangeValue(4, 15) = +0.99419431112670464000;
    aPoles.ChangeValue(4, 15) = gp_Pnt(+84.33436439436984200000, +0.71453739893908408000, -88.03058362353205300000);
    aWeights.ChangeValue(4, 16) = +0.99418875003915341000;
    aPoles.ChangeValue(4, 16) = gp_Pnt(+74.38231313217285400000, +0.71523720648163680000, -91.26025430410756200000);
    aWeights.ChangeValue(4, 17) = +0.99418554160984429000;
    aPoles.ChangeValue(4, 17) = gp_Pnt(+67.68910051798944500000, +0.71564096751482986000, -93.23244050128337800000);
    aWeights.ChangeValue(4, 18) = +0.99418277570171931000;
    aPoles.ChangeValue(4, 18) = gp_Pnt(+60.94265918181897500000, +0.71598904839509359000, -95.02180567308657500000);
    aWeights.ChangeValue(4, 19) = +0.99418039790864621000;
    aPoles.ChangeValue(4, 19) = gp_Pnt(+54.14855416044807900000, +0.71628829211206946000, -96.62671289123449000000);
    aWeights.ChangeValue(4, 20) = +0.99417836479981814000;
    aPoles.ChangeValue(4, 20) = gp_Pnt(+47.31263275511362600000, +0.71654416141740851000, -98.04576467050098600000);
    aWeights.ChangeValue(4, 21) = +0.99417664391975691000;
    aPoles.ChangeValue(4, 21) = gp_Pnt(+40.44102486854357200000, +0.71676073875086976000, -99.27780280738555500000);
    aWeights.ChangeValue(4, 22) = +0.99417521378830997000;
    aPoles.ChangeValue(4, 22) = gp_Pnt(+33.54014335198198900000, +0.71694072618465221000, -100.32190824729783000000);
    aWeights.ChangeValue(4, 23) = +0.99417291266204433000;
    aPoles.ChangeValue(4, 23) = gp_Pnt(+19.69298272358705000000, +0.71723033475882103000, -102.03287833894613000000);
    aWeights.ChangeValue(4, 24) = +0.99417203636017570000;
    aPoles.ChangeValue(4, 24) = gp_Pnt(+12.74619890889187300000, +0.71734062296661449000, -102.69970663658552000000);
    aWeights.ChangeValue(4, 25) = +0.99417141958182476000;
    aPoles.ChangeValue(4, 25) = gp_Pnt(+5.78245043030823250000, +0.71741824902277995000, -103.17717197796689000000);
    aWeights.ChangeValue(4, 26) = +0.99417105170022846000;
    aPoles.ChangeValue(4, 26) = gp_Pnt(-1.19217909208406270000, +0.71746454980293017000, -103.46478315098152000000);
    aWeights.ChangeValue(4, 27) = +0.99417092687508068000;
    aPoles.ChangeValue(4, 27) = gp_Pnt(-8.17163978203099180000, +0.71748026003105458000, -103.56227159755184000000);
    aWeights.ChangeValue(4, 28) = +0.99417104405253187000;
    aPoles.ChangeValue(4, 28) = gp_Pnt(-15.14991535484593800000, +0.71746551227361877000, -103.46959139663633000000);
    aWeights.ChangeValue(4, 29) = +0.99417140696519068000;
    aPoles.ChangeValue(4, 29) = gp_Pnt(-22.12102296425817400000, +0.71741983693815459000, -103.18691926012113000000);
    aWeights.ChangeValue(4, 30) = +0.99417264018315676000;
    aPoles.ChangeValue(4, 30) = gp_Pnt(-36.03699423807252300000, +0.71726462804712465000, -102.24239043165372000000);
    aWeights.ChangeValue(4, 31) = +0.99417351313460955000;
    aPoles.ChangeValue(4, 31) = gp_Pnt(-42.98185258768797500000, +0.71715476185170723000, -101.58053487832193000000);
    aWeights.ChangeValue(4, 32) = +0.99417464796983568000;
    aPoles.ChangeValue(4, 32) = gp_Pnt(-49.90763755490115700000, +0.71701193671091712000, -100.72948788576410000000);
    aWeights.ChangeValue(4, 33) = +0.99417605745995530000;
    aPoles.ChangeValue(4, 33) = gp_Pnt(-56.80843390632649900000, +0.71683454604177377000, -99.68987236817491700000);
    aWeights.ChangeValue(4, 34) = +0.99417776216385467000;
    aPoles.ChangeValue(4, 34) = gp_Pnt(-63.67836146608049600000, +0.71662000367742562000, -98.46253420440308400000);
    aWeights.ChangeValue(4, 35) = +0.99417979042818705000;
    aPoles.ChangeValue(4, 35) = gp_Pnt(-70.51157486810592400000, +0.71636474389607163000, -97.04854231351581000000);
    aWeights.ChangeValue(4, 36) = +0.99418217838737100000;
    aPoles.ChangeValue(4, 36) = gp_Pnt(-77.30226331485057800000, +0.71606422146024096000, -95.44918875092946600000);
    aWeights.ChangeValue(4, 37) = +0.99418626551507883000;
    aPoles.ChangeValue(4, 37) = gp_Pnt(-87.17503156127875700000, +0.71554987190288122000, -92.83807781738744300000);
    aWeights.ChangeValue(4, 38) = +0.99418765014289556000;
    aPoles.ChangeValue(4, 38) = gp_Pnt(-90.29499963358738100000, +0.71537562386381059000, -91.97053762881716900000);
    aWeights.ChangeValue(4, 39) = +0.99418912751868260000;
    aPoles.ChangeValue(4, 39) = gp_Pnt(-93.40397633478176000000, +0.71518970580821706000, -91.06351986664817800000);
    aWeights.ChangeValue(4, 40) = +0.99419070264287346000;
    aPoles.ChangeValue(4, 40) = gp_Pnt(-96.50138523104767800000, +0.71499148886670094000, -90.11718659777564300000);
    aWeights.ChangeValue(4, 41) = +0.99419238184469383000;
    aPoles.ChangeValue(4, 41) = gp_Pnt(-99.58665166110419900000, +0.71478017704711161000, -89.13171035602891800000);
    aWeights.ChangeValue(4, 42) = +0.99419417278216393000;
    aPoles.ChangeValue(4, 42) = gp_Pnt(-102.65920271683186000000, +0.71455480723882170000, -88.10727415073346000000);
    aWeights.ChangeValue(4, 43) = +0.99419608444209617000;
    aPoles.ChangeValue(4, 43) = gp_Pnt(-105.71846722422283000000, +0.71431424921765596000, -87.04407147601585800000);
    aWeights.ChangeValue(4, 44) = +0.99420030141669824000;
    aPoles.ChangeValue(4, 44) = gp_Pnt(-112.04353021881408000000, +0.71378360593609291000, -84.75579106017932000000);
    aWeights.ChangeValue(4, 45) = +0.99420274455295243000;
    aPoles.ChangeValue(4, 45) = gp_Pnt(-115.30712351688430000000, +0.71347617951477893000, -83.52457168950516600000);
    aWeights.ChangeValue(4, 46) = +0.99420507969516914000;
    aPoles.ChangeValue(4, 46) = gp_Pnt(-118.55391065270935000000, +0.71318234625457844000, -82.24884224143599500000);
    aWeights.ChangeValue(4, 47) = +0.99420795946419460000;
    aPoles.ChangeValue(4, 47) = gp_Pnt(-121.78323693095153000000, +0.71281998990170370000, -80.92897147787398600000);
    aWeights.ChangeValue(4, 48) = +0.99421073394729520000;
    aPoles.ChangeValue(4, 48) = gp_Pnt(-124.99434061394447000000, +0.71247088780699119000, -79.56513754354314500000);
    aWeights.ChangeValue(4, 49) = +0.99421382643715051000;
    aPoles.ChangeValue(4, 49) = gp_Pnt(-128.18654935306802000000, +0.71208178090166396000, -78.15770189412481300000);
    aWeights.ChangeValue(4, 50) = +0.99421719652005114000;
    aPoles.ChangeValue(4, 50) = gp_Pnt(-131.35915951555538000000, +0.71165775668839981000, -76.70696466864815500000);
    aWeights.ChangeValue(4, 51) = +0.99422402375653052000;
    aPoles.ChangeValue(4, 51) = gp_Pnt(-137.43857370930490000000, +0.71079877890710363000, -73.82620311743470200000);
    aWeights.ChangeValue(4, 52) = +0.99422797768691740000;
    aPoles.ChangeValue(4, 52) = gp_Pnt(-140.34822128390073000000, +0.71030132584778982000, -72.40218284379008700000);
    aWeights.ChangeValue(4, 53) = +0.99423084075610579000;
    aPoles.ChangeValue(4, 53) = gp_Pnt(-143.23968120103163000000, +0.70994112075449667000, -70.94115847846593700000);
    aWeights.ChangeValue(4, 54) = +0.99423623706224973000;
    aPoles.ChangeValue(4, 54) = gp_Pnt(-146.11271315064005000000, +0.70926223398833632000, -69.44395856663618400000);
    aWeights.ChangeValue(4, 55) = +0.99423948964319253000;
    aPoles.ChangeValue(4, 55) = gp_Pnt(-148.96636467875118000000, +0.70885305306993507000, -67.91012785943519200000);
    aWeights.ChangeValue(4, 56) = +0.99424477127021760000;
    aPoles.ChangeValue(4, 56) = gp_Pnt(-151.80041102174371000000, +0.70818863107582075000, -66.34061951491401000000);
    aWeights.ChangeValue(4, 57) = +0.99424976912431906000;
    aPoles.ChangeValue(4, 57) = gp_Pnt(-154.61412826195317000000, +0.70755993553172780000, -64.73535576374381200000);
    aWeights.ChangeValue(4, 58) = +0.99426106692542415000;
    aPoles.ChangeValue(4, 58) = gp_Pnt(-160.41462700323274000000, +0.70613881146866808000, -61.32785485541679500000);
    aWeights.ChangeValue(4, 59) = +0.99426869485276259000;
    aPoles.ChangeValue(4, 59) = gp_Pnt(-163.39874797129167000000, +0.70517937516238605000, -59.52109641918814000000);
    aWeights.ChangeValue(4, 60) = +0.99427273335051769000;
    aPoles.ChangeValue(4, 60) = gp_Pnt(-166.35588428707737000000, +0.70467140031138198000, -57.67014968010805400000);
    aWeights.ChangeValue(4, 61) = +0.99428524121150996000;
    aPoles.ChangeValue(4, 61) = gp_Pnt(-169.29147402675417000000, +0.70309833118760823000, -55.78569706052214600000);
    aWeights.ChangeValue(4, 62) = +0.99428879891231192000;
    aPoles.ChangeValue(4, 62) = gp_Pnt(-172.19641321622018000000, +0.70265088960130029000, -53.85463096447261900000);
    aWeights.ChangeValue(4, 63) = +0.99430150819260854000;
    aPoles.ChangeValue(4, 63) = gp_Pnt(-175.07684836851479000000, +0.70105264832187786000, -51.88726956537038900000);
    aWeights.ChangeValue(4, 64) = +0.99431053021705873000;
    aPoles.ChangeValue(4, 64) = gp_Pnt(-177.92932492963632000000, +0.69991818857623234000, -49.88000737868681300000);
    aWeights.ChangeValue(4, 65) = +0.99432262020918794000;
    aPoles.ChangeValue(4, 65) = gp_Pnt(-180.75433885652521000000, +0.69839807993520564000, -47.83460859504128800000);
    aWeights.ChangeValue(4, 66) = +0.99433338093448842000;
    aPoles.ChangeValue(4, 66) = gp_Pnt(-183.37745173242254000000, +0.69704510882650861000, -45.93530736698277700000);
    aWeights.ChangeValue(4, 67) = +0.99434840096468768000;
    aPoles.ChangeValue(4, 67) = gp_Pnt(-185.97711214268182000000, +0.69515696483250133000, -44.00334265992864100000);
    aWeights.ChangeValue(4, 68) = +0.99435212441487342000;
    aPoles.ChangeValue(4, 68) = gp_Pnt(-188.55092060214918000000, +0.69468843290184534000, -42.03706245316480100000);
    aWeights.ChangeValue(4, 69) = +0.99438632495837886000;
    aPoles.ChangeValue(4, 69) = gp_Pnt(-191.10351948864678000000, +0.69039032514405918000, -40.04240176159244400000);
    aWeights.ChangeValue(4, 70) = +0.99437474610357146000;
    aPoles.ChangeValue(4, 70) = gp_Pnt(-193.62512272227769000000, +0.69184483548244469000, -38.00925246210125900000);
    aWeights.ChangeValue(4, 71) = +0.99442029730057158000;
    aPoles.ChangeValue(4, 71) = gp_Pnt(-196.12715745709386000000, +0.68612074693666814000, -35.95207510226987300000);
    aWeights.ChangeValue(4, 72) = +0.99443382321708784000;
    aPoles.ChangeValue(4, 72) = gp_Pnt(-198.59871781224271000000, +0.68442148883790921000, -33.85842837168388500000);
    aWeights.ChangeValue(4, 73) = +0.99445918644353237000;
    aPoles.ChangeValue(4, 73) = gp_Pnt(-201.04387700918369000000, +0.68123533540985159000, -31.73471330438436400000);
    aWeights.ChangeValue(4, 74) = +0.99447784672499884000;
    aPoles.ChangeValue(4, 74) = gp_Pnt(-203.48830197003542000000, +0.67889067518118906000, -29.61036197082074800000);
    aWeights.ChangeValue(4, 75) = +0.99454111417144087000;
    aPoles.ChangeValue(4, 75) = gp_Pnt(-205.90905874701556000000, +0.67094847421818948000, -27.45911353863423800000);
    aWeights.ChangeValue(4, 76) = +0.99445650432969468000;
    aPoles.ChangeValue(4, 76) = gp_Pnt(-208.28851122415659000000, +0.68156618053615436000, -25.25989914496455000000);
    aWeights.ChangeValue(4, 77) = +0.99472383917628937000;
    aPoles.ChangeValue(4, 77) = gp_Pnt(-210.66819860636727000000, +0.64801004101885640000, -23.06997485052475800000);
    aWeights.ChangeValue(4, 78) = +0.99465154011060308000;
    aPoles.ChangeValue(4, 78) = gp_Pnt(-212.99829629837927000000, +0.65709020698928045000, -20.81293704958459000000);
    aWeights.ChangeValue(4, 79) = +0.99469225299704522000;
    aPoles.ChangeValue(4, 79) = gp_Pnt(-215.28778722004142000000, +0.65198647566642243000, -18.52648999480212300000);
    aWeights.ChangeValue(4, 80) = +0.99473072608314816000;
    aPoles.ChangeValue(4, 80) = gp_Pnt(-217.56233176434088000000, +0.64714607636795729000, -16.22125679272672700000);
    aWeights.ChangeValue(4, 81) = +0.99492849872148770000;
    aPoles.ChangeValue(4, 81) = gp_Pnt(-219.81591407133737000000, +0.62237708094437050000, -13.90082269618381800000);
    aWeights.ChangeValue(5, 1) = +0.99802424639217535000;
    aPoles.ChangeValue(5, 1) = gp_Pnt(+132.45622778603641000000, +0.24240580374773624000, -67.51941232824347600000);
    aWeights.ChangeValue(5, 2) = +0.99802234515930366000;
    aPoles.ChangeValue(5, 2) = gp_Pnt(+129.39621499227619000000, +0.24264599956164210000, -69.20932849809996400000);
    aWeights.ChangeValue(5, 3) = +0.99802076064199163000;
    aPoles.ChangeValue(5, 3) = gp_Pnt(+126.31320722587012000000, +0.24284620475411531000, -70.85757023346207000000);
    aWeights.ChangeValue(5, 4) = +0.99801949820656444000;
    aPoles.ChangeValue(5, 4) = gp_Pnt(+123.20785947444472000000, +0.24300571706284735000, -72.46379895615213200000);
    aWeights.ChangeValue(5, 5) = +0.99801796211084626000;
    aPoles.ChangeValue(5, 5) = gp_Pnt(+120.08075545981777000000, +0.24319982314295371000, -74.02745916652884300000);
    aWeights.ChangeValue(5, 6) = +0.99801651211139986000;
    aPoles.ChangeValue(5, 6) = gp_Pnt(+116.93263892914923000000, +0.24338306180645181000, -75.54835063375608700000);
    aWeights.ChangeValue(5, 7) = +0.99801547938007906000;
    aPoles.ChangeValue(5, 7) = gp_Pnt(+113.76425167349765000000, +0.24351357797625062000, -77.02627451676777100000);
    aWeights.ChangeValue(5, 8) = +0.99801427699593348000;
    aPoles.ChangeValue(5, 8) = gp_Pnt(+110.57618061475338000000, +0.24366553774363486000, -78.46071663606139200000);
    aWeights.ChangeValue(5, 9) = +0.99801219521177365000;
    aPoles.ChangeValue(5, 9) = gp_Pnt(+104.16217613984874000000, +0.24392865233284403000, -81.24228081548614000000);
    aWeights.ChangeValue(5, 10) = +0.99801119017243534000;
    aPoles.ChangeValue(5, 10) = gp_Pnt(+100.93622072836907000000, +0.24405568433254640000, -82.58935804874866400000);
    aWeights.ChangeValue(5, 11) = +0.99801030363411136000;
    aPoles.ChangeValue(5, 11) = gp_Pnt(+97.69202612265307600000, +0.24416774311013159000, -83.89246252379766100000);
    aWeights.ChangeValue(5, 12) = +0.99800944410126124000;
    aPoles.ChangeValue(5, 12) = gp_Pnt(+94.43027249107268500000, +0.24427639255629080000, -85.15127753548810600000);
    aWeights.ChangeValue(5, 13) = +0.99800863606905588000;
    aPoles.ChangeValue(5, 13) = gp_Pnt(+91.15167507122404800000, +0.24437853537532742000, -86.36553541507953500000);
    aWeights.ChangeValue(5, 14) = +0.99800791446282866000;
    aPoles.ChangeValue(5, 14) = gp_Pnt(+87.85695090009397700000, +0.24446975628264125000, -87.53498464352057300000);
    aWeights.ChangeValue(5, 15) = +0.99800720379704511000;
    aPoles.ChangeValue(5, 15) = gp_Pnt(+84.54678770958248900000, +0.24455959646371978000, -88.65934979276558200000);
    aWeights.ChangeValue(5, 16) = +0.99800525790220262000;
    aPoles.ChangeValue(5, 16) = gp_Pnt(+74.57222162875666500000, +0.24480559775636487000, -91.89655746079053200000);
    aWeights.ChangeValue(5, 17) = +0.99800413521623044000;
    aPoles.ChangeValue(5, 17) = gp_Pnt(+67.86385477996348900000, +0.24494753702776123000, -93.87334138726605200000);
    aWeights.ChangeValue(5, 18) = +0.99800316736440708000;
    aPoles.ChangeValue(5, 18) = gp_Pnt(+61.10212188651380700000, +0.24506990714535715000, -95.66687639706128700000);
    aWeights.ChangeValue(5, 19) = +0.99800233531441618000;
    aPoles.ChangeValue(5, 19) = gp_Pnt(+54.29260355218377000000, +0.24517511152453569000, -97.27552257290322800000);
    aWeights.ChangeValue(5, 20) = +0.99800162387306812000;
    aPoles.ChangeValue(5, 20) = gp_Pnt(+47.44116356008504500000, +0.24526506890417449000, -98.69787956398771200000);
    aWeights.ChangeValue(5, 21) = +0.99800102168629923000;
    aPoles.ChangeValue(5, 21) = gp_Pnt(+40.55394899036769400000, +0.24534121333759545000, -99.93278652962781900000);
    aWeights.ChangeValue(5, 22) = +0.99800052123917249000;
    aPoles.ChangeValue(5, 22) = gp_Pnt(+33.63739034141031700000, +0.24540449418574758000, -100.97932209286283000000);
    aWeights.ChangeValue(5, 23) = +0.99799971600020576000;
    aPoles.ChangeValue(5, 23) = gp_Pnt(+19.75877904385457000000, +0.24550631764576064000, -102.69427034587730000000);
    aWeights.ChangeValue(5, 24) = +0.99799940935225595000;
    aPoles.ChangeValue(5, 24) = gp_Pnt(+12.79621461719473900000, +0.24554509442498113000, -103.36264862290150000000);
    aWeights.ChangeValue(5, 25) = +0.99799919351964361000;
    aPoles.ChangeValue(5, 25) = gp_Pnt(+5.81664173483571470000, +0.24557238768930081000, -103.84122357926364000000);
    aWeights.ChangeValue(5, 26) = +0.99799906478454914000;
    aPoles.ChangeValue(5, 26) = gp_Pnt(-1.17384006705611750000, +0.24558866712534574000, -104.12950288114470000000);
    aWeights.ChangeValue(5, 27) = +0.99799902110371452000;
    aPoles.ChangeValue(5, 27) = gp_Pnt(-8.16916502467035950000, +0.24559419086566145000, -104.22721740658889000000);
    aWeights.ChangeValue(5, 28) = +0.99799906210844525000;
    aPoles.ChangeValue(5, 28) = gp_Pnt(-15.16330109337111900000, +0.24558900548798951000, -104.13432123956672000000);
    aWeights.ChangeValue(5, 29) = +0.99799918910460916000;
    aPoles.ChangeValue(5, 29) = gp_Pnt(-22.15024989420349800000, +0.24557294601509544000, -103.85099166853988000000);
    aWeights.ChangeValue(5, 30) = +0.99799962065035952000;
    aPoles.ChangeValue(5, 30) = gp_Pnt(-36.09784025928350100000, +0.24551837507724711000, -102.90426687944763000000);
    aWeights.ChangeValue(5, 31) = +0.99799992612548860000;
    aPoles.ChangeValue(5, 31) = gp_Pnt(-43.05848024708384300000, +0.24547974681812620000, -102.24087223758063000000);
    aWeights.ChangeValue(5, 32) = +0.99800032324181287000;
    aPoles.ChangeValue(5, 32) = gp_Pnt(-50.00000136683811300000, +0.24542953068576923000, -101.38784584473753000000);
    aWeights.ChangeValue(5, 33) = +0.99800081646744143000;
    aPoles.ChangeValue(5, 33) = gp_Pnt(-56.91647304260395400000, +0.24536716218422927000, -100.34581179308852000000);
    aWeights.ChangeValue(5, 34) = +0.99800141299480460000;
    aPoles.ChangeValue(5, 34) = gp_Pnt(-63.80199929133657100000, +0.24529173277606747000, -99.11561770524215800000);
    aWeights.ChangeValue(5, 35) = +0.99800212274065292000;
    aPoles.ChangeValue(5, 35) = gp_Pnt(-70.65071863638867500000, +0.24520198988589620000, -97.69833476064030700000);
    aWeights.ChangeValue(5, 36) = +0.99800295834605834000;
    aPoles.ChangeValue(5, 36) = gp_Pnt(-77.45680402323041800000, +0.24509633690518939000, -96.09525772913629300000);
    aWeights.ChangeValue(5, 37) = +0.99800438851665707000;
    aPoles.ChangeValue(5, 37) = gp_Pnt(-87.35194268844766400000, +0.24491551610541196000, -93.47806376363495000000);
    aWeights.ChangeValue(5, 38) = +0.99800487302440644000;
    aPoles.ChangeValue(5, 38) = gp_Pnt(-90.47898339307414500000, +0.24485425955861742000, -92.60850028621504700000);
    aWeights.ChangeValue(5, 39) = +0.99800538998403221000;
    aPoles.ChangeValue(5, 39) = gp_Pnt(-93.59500505694055100000, +0.24478890139349116000, -91.69936647202810300000);
    aWeights.ChangeValue(5, 40) = +0.99800594114472096000;
    aPoles.ChangeValue(5, 40) = gp_Pnt(-96.69942959625443300000, +0.24471922075774133000, -90.75082469114758500000);
    aWeights.ChangeValue(5, 41) = +0.99800652872047502000;
    aPoles.ChangeValue(5, 41) = gp_Pnt(-99.79168063143930600000, +0.24464493811196314000, -89.76304779373697300000);
    aWeights.ChangeValue(5, 42) = +0.99800715539011187000;
    aPoles.ChangeValue(5, 42) = gp_Pnt(-102.87118348036965000000, +0.24456571523016235000, -88.73621911304020700000);
    aWeights.ChangeValue(5, 43) = +0.99800782429726465000;
    aPoles.ChangeValue(5, 43) = gp_Pnt(-105.93736515171811000000, +0.24448115520035879000, -87.67053246863201800000);
    aWeights.ChangeValue(5, 44) = +0.99800929984371112000;
    aPoles.ChangeValue(5, 44) = gp_Pnt(-112.27672847568951000000, +0.24429462970498794000, -85.37690123862388700000);
    aWeights.ChangeValue(5, 45) = +0.99801015470633669000;
    aPoles.ChangeValue(5, 45) = gp_Pnt(-115.54769755356581000000, +0.24418656943131900000, -84.14279592325505100000);
    aWeights.ChangeValue(5, 46) = +0.99801097177455889000;
    aPoles.ChangeValue(5, 46) = gp_Pnt(-118.80182311076892000000, +0.24408328894344730000, -82.86408351153079400000);
    aWeights.ChangeValue(5, 47) = +0.99801197940129383000;
    aPoles.ChangeValue(5, 47) = gp_Pnt(-122.03843417449148000000, +0.24395592759703674000, -81.54111184389478200000);
    aWeights.ChangeValue(5, 48) = +0.99801295017559344000;
    aPoles.ChangeValue(5, 48) = gp_Pnt(-125.25678060282321000000, +0.24383322797751039000, -80.17408187890907800000);
    aWeights.ChangeValue(5, 49) = +0.99801403221073270000;
    aPoles.ChangeValue(5, 49) = gp_Pnt(-128.45617956663568000000, +0.24369647262362162000, -78.76334161483092100000);
    aWeights.ChangeValue(5, 50) = +0.99801521135655380000;
    aPoles.ChangeValue(5, 50) = gp_Pnt(-131.63592529803751000000, +0.24354745092247693000, -77.30919404502431300000);
    aWeights.ChangeValue(5, 51) = +0.99801760008187401000;
    aPoles.ChangeValue(5, 51) = gp_Pnt(-137.72900951211963000000, +0.24324557860805471000, -74.42165429070698200000);
    aWeights.ChangeValue(5, 52) = +0.99801898346970708000;
    aPoles.ChangeValue(5, 52) = gp_Pnt(-140.64518873661288000000, +0.24307076523393223000, -72.99426192178911800000);
    aWeights.ChangeValue(5, 53) = +0.99801998518786039000;
    aPoles.ChangeValue(5, 53) = gp_Pnt(-143.54316005505726000000, +0.24294418386170585000, -71.52981926220020600000);
    aWeights.ChangeValue(5, 54) = +0.99802187318168345000;
    aPoles.ChangeValue(5, 54) = gp_Pnt(-146.42260629144496000000, +0.24270562978064991000, -70.02903356238938700000);
    aWeights.ChangeValue(5, 55) = +0.99802301113888081000;
    aPoles.ChangeValue(5, 55) = gp_Pnt(-149.28266198929455000000, +0.24256185427332766000, -68.49161271016626500000);
    aWeights.ChangeValue(5, 56) = +0.99802485896051119000;
    aPoles.ChangeValue(5, 56) = gp_Pnt(-152.12302992679020000000, +0.24232840183433180000, -66.91836178765569800000);
    aWeights.ChangeValue(5, 57) = +0.99802660746095961000;
    aPoles.ChangeValue(5, 57) = gp_Pnt(-154.94301695331424000000, +0.24210751871096883000, -65.30929034698890200000);
    aWeights.ChangeValue(5, 58) = +0.99803055992501044000;
    aPoles.ChangeValue(5, 58) = gp_Pnt(-160.75642720778953000000, +0.24160825342055195000, -61.89368007550259400000);
    aWeights.ChangeValue(5, 59) = +0.99803322842160846000;
    aPoles.ChangeValue(5, 59) = gp_Pnt(-163.74717060555361000000, +0.24127121961594802000, -60.08255013672670200000);
    aWeights.ChangeValue(5, 60) = +0.99803464125717123000;
    aPoles.ChangeValue(5, 60) = gp_Pnt(-166.71086689375946000000, +0.24109275824918924000, -58.22731479955884700000);
    aWeights.ChangeValue(5, 61) = +0.99803901668628470000;
    aPoles.ChangeValue(5, 61) = gp_Pnt(-169.65297207222594000000, +0.24054025241076704000, -56.33806928337021700000);
    aWeights.ChangeValue(5, 62) = +0.99804026123435818000;
    aPoles.ChangeValue(5, 62) = gp_Pnt(-172.56427255537395000000, +0.24038308942389072000, -54.40260496408483000000);
    aWeights.ChangeValue(5, 63) = +0.99804470691060532000;
    aPoles.ChangeValue(5, 63) = gp_Pnt(-175.45101016300779000000, +0.23982181928534163000, -52.43032166263763100000);
    aWeights.ChangeValue(5, 64) = +0.99804786265202527000;
    aPoles.ChangeValue(5, 64) = gp_Pnt(-178.30970270493245000000, +0.23942347201733374000, -50.41823769283568900000);
    aWeights.ChangeValue(5, 65) = +0.99805209132460959000;
    aPoles.ChangeValue(5, 65) = gp_Pnt(-181.14080917168710000000, +0.23888978094458979000, -48.36782293133622100000);
    aWeights.ChangeValue(5, 66) = +0.99805585511722006000;
    aPoles.ChangeValue(5, 66) = gp_Pnt(-183.76963089028271000000, +0.23841474156011525000, -46.46384963887197700000);
    aWeights.ChangeValue(5, 67) = +0.99806110806389992000;
    aPoles.ChangeValue(5, 67) = gp_Pnt(-186.37480135254410000000, +0.23775204017864099000, -44.52702607060874100000);
    aWeights.ChangeValue(5, 68) = +0.99806241123039841000;
    aPoles.ChangeValue(5, 68) = gp_Pnt(-188.95443339023049000000, +0.23758721013871806000, -42.55611011320790700000);
    aWeights.ChangeValue(5, 69) = +0.99807437025022461000;
    aPoles.ChangeValue(5, 69) = gp_Pnt(-191.51185439080101000000, +0.23607937004601673000, -40.55588840407725800000);
    aWeights.ChangeValue(5, 70) = +0.99807032269304363000;
    aPoles.ChangeValue(5, 70) = gp_Pnt(-194.03956238778505000000, +0.23658914396266717000, -38.51843887702921200000);
    aWeights.ChangeValue(5, 71) = +0.99808625039358922000;
    aPoles.ChangeValue(5, 71) = gp_Pnt(-196.54607703546344000000, +0.23458111537982981000, -36.45513422497234800000);
    aWeights.ChangeValue(5, 72) = +0.99809097922833689000;
    aPoles.ChangeValue(5, 72) = gp_Pnt(-199.02284030117690000000, +0.23398526561785285000, -34.35633603568415100000);
    aWeights.ChangeValue(5, 73) = +0.99809984631895676000;
    aPoles.ChangeValue(5, 73) = gp_Pnt(-201.47284391020807000000, +0.23286808083306546000, -32.22700780168109700000);
    aWeights.ChangeValue(5, 74) = +0.99810637147739267000;
    aPoles.ChangeValue(5, 74) = gp_Pnt(-203.92239692899503000000, +0.23204542949601353000, -30.09717639714928000000);
    aWeights.ChangeValue(5, 75) = +0.99812847998973830000;
    aPoles.ChangeValue(5, 75) = gp_Pnt(-206.34684289021220000000, +0.22926391512904498000, -27.93902362306789300000);
    aWeights.ChangeValue(5, 76) = +0.99809892249694432000;
    aPoles.ChangeValue(5, 76) = gp_Pnt(-208.73420674519565000000, +0.23297935369059405000, -25.73750919512989600000);
    aWeights.ChangeValue(5, 77) = +0.99819234539430379000;
    aPoles.ChangeValue(5, 77) = gp_Pnt(-211.11258262007470000000, +0.22122441504945897000, -23.53328220960779800000);
    aWeights.ChangeValue(5, 78) = +0.99816706733442118000;
    aPoles.ChangeValue(5, 78) = gp_Pnt(-213.44890831521380000000, +0.22441150695403267000, -21.27426418813643800000);
    aWeights.ChangeValue(5, 79) = +0.99818127777024523000;
    aPoles.ChangeValue(5, 79) = gp_Pnt(-215.74298068197336000000, +0.22262736656649654000, -18.98075706196405200000);
    aWeights.ChangeValue(5, 80) = +0.99819475509184485000;
    aPoles.ChangeValue(5, 80) = gp_Pnt(-218.02209738817496000000, +0.22092240555297402000, -16.66880151580776100000);
    aWeights.ChangeValue(5, 81) = +0.99826376750413803000;
    aPoles.ChangeValue(5, 81) = gp_Pnt(-220.27506837008727000000, +0.21227676902692139000, -14.33587171753685400000);
    aWeights.ChangeValue(6, 1) = +1.00955713824395920000;
    aPoles.ChangeValue(6, 1) = gp_Pnt(+132.82497533600920000000, -0.00000000000000355271, -68.18672206105269100000);
    aWeights.ChangeValue(6, 2) = +1.00956608612165510000;
    aPoles.ChangeValue(6, 2) = gp_Pnt(+129.75720107675980000000, -0.00000000000001501048, -69.88134023490506800000);
    aWeights.ChangeValue(6, 3) = +1.00957354292813720000;
    aPoles.ChangeValue(6, 3) = gp_Pnt(+126.66630562875893000000, +0.00000000000001468880, -71.53414324810810900000);
    aWeights.ChangeValue(6, 4) = +1.00957948395969920000;
    aPoles.ChangeValue(6, 4) = gp_Pnt(+123.55299204973852000000, -0.00000000000002420214, -73.14476521965842400000);
    aWeights.ChangeValue(6, 5) = +1.00958671248272540000;
    aPoles.ChangeValue(6, 5) = gp_Pnt(+120.41786571412476000000, +0.00000000000000774289, -74.71276629883676900000);
    aWeights.ChangeValue(6, 6) = +1.00959353559449030000;
    aPoles.ChangeValue(6, 6) = gp_Pnt(+117.26165038381876000000, +0.00000000000002827238, -76.23787924846354300000);
    aWeights.ChangeValue(6, 7) = +1.00959839503053540000;
    aPoles.ChangeValue(6, 7) = gp_Pnt(+114.08506189168672000000, -0.00000000000002567399, -77.71984701658058700000);
    aWeights.ChangeValue(6, 8) = +1.00960405269295440000;
    aPoles.ChangeValue(6, 8) = gp_Pnt(+110.88875430250306000000, +0.00000000000001531652, -79.15824703626482500000);
    aWeights.ChangeValue(6, 9) = +1.00961384794965610000;
    aPoles.ChangeValue(6, 9) = gp_Pnt(+104.45816547225203000000, +0.00000000000002372811, -81.94743615023858800000);
    aWeights.ChangeValue(6, 10) = +1.00961857675613920000;
    aPoles.ChangeValue(6, 10) = gp_Pnt(+101.22387341781818000000, -0.00000000000003253030, -83.29820264563102200000);
    aWeights.ChangeValue(6, 11) = +1.00962274789490230000;
    aPoles.ChangeValue(6, 11) = gp_Pnt(+97.97127406275538400000, +0.00000000000002165813, -84.60486564781918200000);
    aWeights.ChangeValue(6, 12) = +1.00962679188945900000;
    aPoles.ChangeValue(6, 12) = gp_Pnt(+94.70106106239124700000, +0.00000000000003307844, -85.86712155505158300000);
    aWeights.ChangeValue(6, 13) = +1.00963059350859920000;
    aPoles.ChangeValue(6, 13) = gp_Pnt(+91.41394873512904000000, -0.00000000000001002370, -87.08469757155246800000);
    aWeights.ChangeValue(6, 14) = +1.00963398843787310000;
    aPoles.ChangeValue(6, 14) = gp_Pnt(+88.11065082060795800000, -0.00000000000001620026, -88.25733602781997400000);
    aWeights.ChangeValue(6, 15) = +1.00963733185343440000;
    aPoles.ChangeValue(6, 15) = gp_Pnt(+84.79187377942922400000, +0.00000000000001387836, -89.38476986722990600000);
    aWeights.ChangeValue(6, 16) = +1.00964648640037490000;
    aPoles.ChangeValue(6, 16) = gp_Pnt(+74.79138897281484300000, +0.00000000000001147648, -92.63077806554609600000);
    aWeights.ChangeValue(6, 17) = +1.00965176794147980000;
    aPoles.ChangeValue(6, 17) = gp_Pnt(+68.06556894151637500000, +0.00000000000001348105, -94.61292925638954900000);
    aWeights.ChangeValue(6, 18) = +1.00965632094816880000;
    aPoles.ChangeValue(6, 18) = gp_Pnt(+61.28620656548358900000, +0.00000000000001132208, -96.41133393799678700000);
    aWeights.ChangeValue(6, 19) = +1.00966023501695920000;
    aPoles.ChangeValue(6, 19) = gp_Pnt(+54.45890525472331200000, +0.00000000000000779610, -98.02434736777235000000);
    aWeights.ChangeValue(6, 20) = +1.00966358166845540000;
    aPoles.ChangeValue(6, 20) = gp_Pnt(+47.58955228763309700000, +0.00000000000000496426, -99.45056478986435900000);
    aWeights.ChangeValue(6, 21) = +1.00966641434734750000;
    aPoles.ChangeValue(6, 21) = gp_Pnt(+40.68431826182812500000, +0.00000000000000415229, -100.68882169811890000000);
    aWeights.ChangeValue(6, 22) = +1.00966876842241240000;
    aPoles.ChangeValue(6, 22) = gp_Pnt(+33.74965652868991100000, +0.00000000000000595055, -101.73819405254569000000);
    aWeights.ChangeValue(6, 23) = +1.00967255617655690000;
    aPoles.ChangeValue(6, 23) = gp_Pnt(+19.83474481990451800000, +0.00000000000000626687, -103.45778313292877000000);
    aWeights.ChangeValue(6, 24) = +1.00967399859793900000;
    aPoles.ChangeValue(6, 24) = gp_Pnt(+12.85396744583563800000, +0.00000000000000961706, -104.12796934503771000000);
    aWeights.ChangeValue(6, 25) = +1.00967501382969150000;
    aPoles.ChangeValue(6, 25) = gp_Pnt(+5.85612456199985140000, +0.00000000000001451316, -104.60783896197547000000);
    aWeights.ChangeValue(6, 26) = +1.00967561936958040000;
    aPoles.ChangeValue(6, 26) = gp_Pnt(-1.15266320632332260000, +0.00000000000001739414, -104.89689790453474000000);
    aWeights.ChangeValue(6, 27) = +1.00967582483410530000;
    aPoles.ChangeValue(6, 27) = gp_Pnt(-8.16630892272242730000, +0.00000000000001688939, -104.99487618531697000000);
    aWeights.ChangeValue(6, 28) = +1.00967563195849790000;
    aPoles.ChangeValue(6, 28) = gp_Pnt(-15.17875958769639600000, +0.00000000000001381871, -104.90172793642448000000);
    aWeights.ChangeValue(6, 29) = +1.00967503459672230000;
    aPoles.ChangeValue(6, 29) = gp_Pnt(-22.18399638815323600000, +0.00000000000001119232, -104.61763141615558000000);
    aWeights.ChangeValue(6, 30) = +1.00967300468446440000;
    aPoles.ChangeValue(6, 30) = gp_Pnt(-36.16808769247344200000, +0.00000000000001926896, -103.66834538209933000000);
    aWeights.ChangeValue(6, 31) = +1.00967156777535520000;
    aPoles.ChangeValue(6, 31) = gp_Pnt(-43.14695215605046700000, +0.00000000000002086710, -103.00315490229345000000);
    aWeights.ChangeValue(6, 32) = +1.00966969979090850000;
    aPoles.ChangeValue(6, 32) = gp_Pnt(-50.10664482445217500000, +0.00000000000002115378, -102.14781821392242000000);
    aWeights.ChangeValue(6, 33) = +1.00966737970297340000;
    aPoles.ChangeValue(6, 33) = gp_Pnt(-57.04121502398449900000, +0.00000000000002158031, -101.10296070558179000000);
    aWeights.ChangeValue(6, 34) = +1.00966457365849420000;
    aPoles.ChangeValue(6, 34) = gp_Pnt(-63.94474533155499800000, +0.00000000000002290082, -99.86943240681669900000);
    aWeights.ChangeValue(6, 35) = +1.00966123497950670000;
    aPoles.ChangeValue(6, 35) = gp_Pnt(-70.81135197820185600000, +0.00000000000002517228, -98.44830786498150100000);
    aWeights.ChangeValue(6, 36) = +1.00965730416314160000;
    aPoles.ChangeValue(6, 36) = gp_Pnt(-77.63518524225725100000, +0.00000000000002775445, -96.84088598857995600000);
    aWeights.ChangeValue(6, 37) = +1.00965057624219750000;
    aPoles.ChangeValue(6, 37) = gp_Pnt(-87.55609990295042200000, +0.00000000000002423047, -94.21659328767886200000);
    aWeights.ChangeValue(6, 38) = +1.00964829695753600000;
    aPoles.ChangeValue(6, 38) = gp_Pnt(-90.69129861847109500000, +0.00000000000002587407, -93.34466557470412300000);
    aWeights.ChangeValue(6, 39) = +1.00964586498085130000;
    aPoles.ChangeValue(6, 39) = gp_Pnt(-93.81544408055053500000, +0.00000000000003006614, -92.43305897005754400000);
    aWeights.ChangeValue(6, 40) = +1.00964327207695040000;
    aPoles.ChangeValue(6, 40) = gp_Pnt(-96.92795589621758300000, +0.00000000000003388207, -91.48193626907418300000);
    aWeights.ChangeValue(6, 41) = +1.00964050782223150000;
    aPoles.ChangeValue(6, 41) = gp_Pnt(-100.02825520717420000000, +0.00000000000003564727, -90.49147079864104600000);
    aWeights.ChangeValue(6, 42) = +1.00963755960468200000;
    aPoles.ChangeValue(6, 42) = gp_Pnt(-103.11576472135789000000, +0.00000000000003493709, -89.46184640324143800000);
    aWeights.ChangeValue(6, 43) = +1.00963441262388120000;
    aPoles.ChangeValue(6, 43) = gp_Pnt(-106.18990874397944000000, +0.00000000000003257692, -88.39325742978746800000);
    aWeights.ChangeValue(6, 44) = +1.00962747055172470000;
    aPoles.ChangeValue(6, 44) = gp_Pnt(-112.54574015681582000000, +0.00000000000006160655, -86.09336936272072200000);
    aWeights.ChangeValue(6, 45) = +1.00962344856191890000;
    aPoles.ChangeValue(6, 45) = gp_Pnt(-115.82520602454126000000, -0.00000000000003931317, -84.85588414554271700000);
    aWeights.ChangeValue(6, 46) = +1.00961960432502520000;
    aPoles.ChangeValue(6, 46) = gp_Pnt(-119.08778487668772000000, +0.00000000000016494845, -83.57368219250022900000);
    aWeights.ChangeValue(6, 47) = +1.00961486341637220000;
    aPoles.ChangeValue(6, 47) = gp_Pnt(-122.33277704237545000000, -0.00000000000006102663, -82.24707666574315100000);
    aWeights.ChangeValue(6, 48) = +1.00961029578642010000;
    aPoles.ChangeValue(6, 48) = gp_Pnt(-125.55945424028559000000, +0.00000000000005443726, -80.87630621413205700000);
    aWeights.ChangeValue(6, 49) = +1.00960520453872830000;
    aPoles.ChangeValue(6, 49) = gp_Pnt(-128.76711471386264000000, +0.00000000000006731284, -79.46169679871513800000);
    aWeights.ChangeValue(6, 50) = +1.00959965618806670000;
    aPoles.ChangeValue(6, 50) = gp_Pnt(-131.95505034236234000000, +0.00000000000001744703, -78.00355594499717400000);
    aWeights.ChangeValue(6, 51) = +1.00958841592259230000;
    aPoles.ChangeValue(6, 51) = gp_Pnt(-138.06383173526737000000, +0.00000000000005091738, -75.10807262033468100000);
    aWeights.ChangeValue(6, 52) = +1.00958190609477040000;
    aPoles.ChangeValue(6, 52) = gp_Pnt(-140.98751167669514000000, +0.00000000000001249767, -73.67671445695528100000);
    aWeights.ChangeValue(6, 53) = +1.00957719226123470000;
    aPoles.ChangeValue(6, 53) = gp_Pnt(-143.89297197091258000000, +0.00000000000004304958, -72.20827197874005800000);
    aWeights.ChangeValue(6, 54) = +1.00956830736954160000;
    aPoles.ChangeValue(6, 54) = gp_Pnt(-146.77976177895343000000, +0.00000000000014315600, -70.70325097869228200000);
    aWeights.ChangeValue(6, 55) = +1.00956295195680430000;
    aPoles.ChangeValue(6, 55) = gp_Pnt(-149.64716302220674000000, -0.00000000000013374459, -69.16163316263994400000);
    aWeights.ChangeValue(6, 56) = +1.00955425555763600000;
    aPoles.ChangeValue(6, 56) = gp_Pnt(-152.49476001470052000000, +0.00000000000014982315, -67.58397318476696100000);
    aWeights.ChangeValue(6, 57) = +1.00954602613024340000;
    aPoles.ChangeValue(6, 57) = gp_Pnt(-155.32190503332637000000, -0.00000000000000021066, -65.97043121899140800000);
    aWeights.ChangeValue(6, 58) = +1.00952742278739690000;
    aPoles.ChangeValue(6, 58) = gp_Pnt(-161.15007234465017000000, -0.00000000000001992904, -62.54527347940126700000);
    aWeights.ChangeValue(6, 59) = +1.00951486183122910000;
    aPoles.ChangeValue(6, 59) = gp_Pnt(-164.14837014605524000000, +0.00000000000023572067, -60.72896647597298900000);
    aWeights.ChangeValue(6, 60) = +1.00950821186278380000;
    aPoles.ChangeValue(6, 60) = gp_Pnt(-167.11960531963629000000, -0.00000000000028988207, -58.86870049528032900000);
    aWeights.ChangeValue(6, 61) = +1.00948761363721440000;
    aPoles.ChangeValue(6, 61) = gp_Pnt(-170.06906478280905000000, +0.00000000000040689923, -56.97372124744497800000);
    aWeights.ChangeValue(6, 62) = +1.00948175483910860000;
    aPoles.ChangeValue(6, 62) = gp_Pnt(-172.98765254825670000000, -0.00000000000024250881, -55.03312548926784600000);
    aWeights.ChangeValue(6, 63) = +1.00946082358368820000;
    aPoles.ChangeValue(6, 63) = gp_Pnt(-175.88148729884773000000, +0.00000000000015443744, -53.05496328096450000000);
    aWeights.ChangeValue(6, 64) = +1.00944596410276510000;
    aPoles.ChangeValue(6, 64) = gp_Pnt(-178.74719668858941000000, +0.00000000000002184305, -51.03719587787818300000);
    aWeights.ChangeValue(6, 65) = +1.00942605045267690000;
    aPoles.ChangeValue(6, 65) = gp_Pnt(-181.58512029181043000000, +0.00000000000003863576, -48.98084041218928800000);
    aWeights.ChangeValue(6, 66) = +1.00940832657292460000;
    aPoles.ChangeValue(6, 66) = gp_Pnt(-184.22041885135505000000, +0.00000000000012642202, -47.07128183802177500000);
    aWeights.ChangeValue(6, 67) = +1.00938358350016230000;
    aPoles.ChangeValue(6, 67) = gp_Pnt(-186.83172267077580000000, -0.00000000000026075896, -45.12863792869809700000);
    aWeights.ChangeValue(6, 68) = +1.00937745534316470000;
    aPoles.ChangeValue(6, 68) = gp_Pnt(-189.41814135962036000000, +0.00000000000050815389, -43.15221363464823400000);
    aWeights.ChangeValue(6, 69) = +1.00932110415609880000;
    aPoles.ChangeValue(6, 69) = gp_Pnt(-191.98049421722968000000, -0.00000000000036869153, -41.14519558079494000000);
    aWeights.ChangeValue(6, 70) = +1.00934018958992230000;
    aPoles.ChangeValue(6, 70) = gp_Pnt(-194.51554398045388000000, +0.00000000000024701945, -39.10283303403318900000);
    aWeights.ChangeValue(6, 71) = +1.00926513417534820000;
    aPoles.ChangeValue(6, 71) = gp_Pnt(-197.02654362639632000000, +0.00000000000002378284, -37.03182458375535900000);
    aWeights.ChangeValue(6, 72) = +1.00924284324015100000;
    aPoles.ChangeValue(6, 72) = gp_Pnt(-199.50902604112426000000, +0.00000000000001468063, -34.92696457232537500000);
    aWeights.ChangeValue(6, 73) = +1.00920104311988210000;
    aPoles.ChangeValue(6, 73) = gp_Pnt(-201.96417476016930000000, +0.00000000000004485301, -32.79087292323346500000);
    aWeights.ChangeValue(6, 74) = +1.00917029694376930000;
    aPoles.ChangeValue(6, 74) = gp_Pnt(-204.41947086956830000000, +0.00000000000007013856, -30.65436716589900700000);
    aWeights.ChangeValue(6, 75) = +1.00906597799622610000;
    aPoles.ChangeValue(6, 75) = gp_Pnt(-206.84718146821811000000, -0.00000000000006381675, -28.48746943619916600000);
    aWeights.ChangeValue(6, 76) = +1.00920552993238920000;
    aPoles.ChangeValue(6, 76) = gp_Pnt(-209.24487385523256000000, +0.00000000000020688933, -26.28443183778934900000);
    aWeights.ChangeValue(6, 77) = +1.00876475817276390000;
    aPoles.ChangeValue(6, 77) = gp_Pnt(-211.61934752962611000000, -0.00000000000012087895, -24.05869960942788700000);
    aWeights.ChangeValue(6, 78) = +1.00888387250480620000;
    aPoles.ChangeValue(6, 78) = gp_Pnt(-213.96155431166437000000, +0.00000000000019025578, -21.80066237623914200000);
    aWeights.ChangeValue(6, 79) = +1.00881670070678450000;
    aPoles.ChangeValue(6, 79) = gp_Pnt(-216.26151615033589000000, -0.00000000000009572292, -19.49741392382435400000);
    aWeights.ChangeValue(6, 80) = +1.00875338528797620000;
    aPoles.ChangeValue(6, 80) = gp_Pnt(-218.54531424806936000000, +0.00000000000008182630, -17.17704407009146500000);
    aWeights.ChangeValue(6, 81) = +1.00842683370719580000;
    aPoles.ChangeValue(6, 81) = gp_Pnt(-220.79435406720884000000, +0.00000000000004973799, -14.82789528118522200000);
    aWeights.ChangeValue(7, 1) = +1.02986327036737910000;
    aPoles.ChangeValue(7, 1) = gp_Pnt(+133.20307692191452000000, -0.00000000000000177636, -68.87095947031473000000);
    aWeights.ChangeValue(7, 2) = +1.02989244478762340000;
    aPoles.ChangeValue(7, 2) = gp_Pnt(+130.12738123407763000000, -0.00000000000000516390, -70.57040146390383500000);
    aWeights.ChangeValue(7, 3) = +1.02991676091110000000;
    aPoles.ChangeValue(7, 3) = gp_Pnt(+127.02840986317391000000, +0.00000000000000554535, -72.22789464235242500000);
    aWeights.ChangeValue(7, 4) = +1.02993613450137910000;
    aPoles.ChangeValue(7, 4) = gp_Pnt(+123.90694758506712000000, -0.00000000000000702621, -73.84302715009133100000);
    aWeights.ChangeValue(7, 5) = +1.02995970896171030000;
    aPoles.ChangeValue(7, 5) = gp_Pnt(+120.76360256847768000000, -0.00000000000000047370, -75.41549467632542300000);
    aWeights.ChangeValue(7, 6) = +1.02998196300924330000;
    aPoles.ChangeValue(7, 6) = gp_Pnt(+117.59908279457284000000, +0.00000000000000772901, -76.94495426059752700000);
    aWeights.ChangeValue(7, 7) = +1.02999781361776170000;
    aPoles.ChangeValue(7, 7) = gp_Pnt(+114.41407453952652000000, -0.00000000000000327310, -78.43108601253017300000);
    aWeights.ChangeValue(7, 8) = +1.03001626830282000000;
    aPoles.ChangeValue(7, 8) = gp_Pnt(+111.20931631680004000000, +0.00000000000000421483, -79.87356087705671800000);
    aWeights.ChangeValue(7, 9) = +1.03004822145821140000;
    aPoles.ChangeValue(7, 9) = gp_Pnt(+104.76172782897289000000, +0.00000000000000259283, -82.67059011797552200000);
    aWeights.ChangeValue(7, 10) = +1.03006364818919470000;
    aPoles.ChangeValue(7, 10) = gp_Pnt(+101.51889932580750000000, +0.00000000000000793496, -84.02514647707548100000);
    aWeights.ChangeValue(7, 11) = +1.03007725635610380000;
    aPoles.ChangeValue(7, 11) = gp_Pnt(+98.25768758130365700000, +0.00000000000000127608, -85.33546669488836800000);
    aWeights.ChangeValue(7, 12) = +1.03009045031501540000;
    aPoles.ChangeValue(7, 12) = gp_Pnt(+94.97880175952953200000, +0.00000000000000289709, -86.60126064632369500000);
    aWeights.ChangeValue(7, 13) = +1.03010285398165520000;
    aPoles.ChangeValue(7, 13) = gp_Pnt(+91.68295682468645700000, +0.00000000000000548904, -87.82224920548925700000);
    aWeights.ChangeValue(7, 14) = +1.03011393120368040000;
    aPoles.ChangeValue(7, 14) = gp_Pnt(+88.37086140882031800000, -0.00000000000000004450, -88.99816853898946100000);
    aWeights.ChangeValue(7, 15) = +1.03012484065781210000;
    aPoles.ChangeValue(7, 15) = gp_Pnt(+85.04324466385365600000, +0.00000000000000407116, -90.12875955698966400000);
    aWeights.ChangeValue(7, 16) = +1.03015471267321310000;
    aPoles.ChangeValue(7, 16) = gp_Pnt(+75.01621211174902700000, +0.00000000000001208092, -93.38380423550353300000);
    aWeights.ChangeValue(7, 17) = +1.03017194800922480000;
    aPoles.ChangeValue(7, 17) = gp_Pnt(+68.27251352067813200000, +0.00000000000001147779, -95.37146758037383200000);
    aWeights.ChangeValue(7, 18) = +1.03018680682765580000;
    aPoles.ChangeValue(7, 18) = gp_Pnt(+61.47507566136914600000, +0.00000000000000851456, -97.17487791831784700000);
    aWeights.ChangeValue(7, 19) = +1.03019958109549560000;
    aPoles.ChangeValue(7, 19) = gp_Pnt(+54.62953031922813800000, +0.00000000000000645560, -98.79238303220959900000);
    aWeights.ChangeValue(7, 20) = +1.03021050389503310000;
    aPoles.ChangeValue(7, 20) = gp_Pnt(+47.74179355100338300000, +0.00000000000000683493, -100.22257163394704000000);
    aWeights.ChangeValue(7, 21) = +1.03021974942385920000;
    aPoles.ChangeValue(7, 21) = gp_Pnt(+40.81806392732334400000, +0.00000000000000945638, -101.46427420633951000000);
    aWeights.ChangeValue(7, 22) = +1.03022743299486530000;
    aPoles.ChangeValue(7, 22) = gp_Pnt(+33.86482072309787100000, +0.00000000000001239365, -102.51656369616552000000);
    aWeights.ChangeValue(7, 23) = +1.03023979631718960000;
    aPoles.ChangeValue(7, 23) = gp_Pnt(+19.91267581058432200000, +0.00000000000001269021, -104.24092170462040000000);
    aWeights.ChangeValue(7, 24) = +1.03024450452679180000;
    aPoles.ChangeValue(7, 24) = gp_Pnt(+12.91322103073442500000, +0.00000000000001310657, -104.91296575233191000000);
    aWeights.ChangeValue(7, 25) = +1.03024781840890150000;
    aPoles.ChangeValue(7, 25) = gp_Pnt(+5.89663552968925500000, +0.00000000000001362222, -105.39416639705574000000);
    aWeights.ChangeValue(7, 26) = +1.03024979501191980000;
    aPoles.ChangeValue(7, 26) = gp_Pnt(-1.13093554742009240000, +0.00000000000001442955, -105.68402704533355000000);
    aWeights.ChangeValue(7, 27) = +1.03025046568879810000;
    aPoles.ChangeValue(7, 27) = gp_Pnt(-8.16338049757019310000, +0.00000000000001553070, -105.78227646648484000000);
    aWeights.ChangeValue(7, 28) = +1.03024983609703620000;
    aPoles.ChangeValue(7, 28) = gp_Pnt(-15.19462185431612500000, +0.00000000000001673746, -105.68886888131540000000);
    aWeights.ChangeValue(7, 29) = +1.03024788619868390000;
    aPoles.ChangeValue(7, 29) = gp_Pnt(-22.21861718693262200000, +0.00000000000001767135, -105.40398398356824000000);
    aWeights.ChangeValue(7, 30) = +1.03024126030624560000;
    aPoles.ChangeValue(7, 30) = gp_Pnt(-36.24014829916134100000, +0.00000000000002019891, -104.45206611492652000000);
    aWeights.ChangeValue(7, 31) = +1.03023657011944200000;
    aPoles.ChangeValue(7, 31) = gp_Pnt(-43.23771519136024500000, +0.00000000000002161068, -103.78502949380328000000);
    aWeights.ChangeValue(7, 32) = +1.03023047292900840000;
    aPoles.ChangeValue(7, 32) = gp_Pnt(-50.21605719916001900000, +0.00000000000002249329, -102.92731708926736000000);
    aWeights.ChangeValue(7, 33) = +1.03022290017099440000;
    aPoles.ChangeValue(7, 33) = gp_Pnt(-57.16920057960702200000, +0.00000000000002320995, -101.87955571848956000000);
    aWeights.ChangeValue(7, 34) = +1.03021374148842140000;
    aPoles.ChangeValue(7, 34) = gp_Pnt(-64.09120253994868200000, +0.00000000000002399266, -100.64259867222304000000);
    aWeights.ChangeValue(7, 35) = +1.03020284473128120000;
    aPoles.ChangeValue(7, 35) = gp_Pnt(-70.97615252947152000000, +0.00000000000002494226, -99.21752532044712300000);
    aWeights.ChangeValue(7, 36) = +1.03019001595653670000;
    aPoles.ChangeValue(7, 36) = gp_Pnt(-77.81817349811507300000, +0.00000000000002602838, -97.60564061068184600000);
    aWeights.ChangeValue(7, 37) = +1.03016805964614980000;
    aPoles.ChangeValue(7, 37) = gp_Pnt(-87.76549855749630100000, +0.00000000000002703745, -94.97405836608523100000);
    aWeights.ChangeValue(7, 38) = +1.03016062145972500000;
    aPoles.ChangeValue(7, 38) = gp_Pnt(-90.90906843451735100000, +0.00000000000002735353, -94.09969925934423400000);
    aWeights.ChangeValue(7, 39) = +1.03015268516758060000;
    aPoles.ChangeValue(7, 39) = gp_Pnt(-94.04154842308000200000, +0.00000000000002795160, -93.18554984223239000000);
    aWeights.ChangeValue(7, 40) = +1.03014422393874510000;
    aPoles.ChangeValue(7, 40) = gp_Pnt(-97.16235536263198500000, +0.00000000000002873660, -92.23177350871787900000);
    aWeights.ChangeValue(7, 41) = +1.03013520381253840000;
    aPoles.ChangeValue(7, 41) = gp_Pnt(-100.27090735629974000000, +0.00000000000002960449, -91.23854430518403500000);
    aWeights.ChangeValue(7, 42) = +1.03012558369857450000;
    aPoles.ChangeValue(7, 42) = gp_Pnt(-103.36662387191370000000, +0.00000000000003044224, -90.20604688574815100000);
    aWeights.ChangeValue(7, 43) = +1.03011531537676040000;
    aPoles.ChangeValue(7, 43) = gp_Pnt(-106.44892584135401000000, +0.00000000000003112785, -89.13447646370049400000);
    aWeights.ChangeValue(7, 44) = +1.03009266486582220000;
    aPoles.ChangeValue(7, 44) = gp_Pnt(-112.82164316087234000000, +0.00000000000002877514, -86.82815610446842000000);
    aWeights.ChangeValue(7, 45) = +1.03007954250937140000;
    aPoles.ChangeValue(7, 45) = gp_Pnt(-116.10982863064515000000, +0.00000000000005217709, -85.58719260568324200000);
    aWeights.ChangeValue(7, 46) = +1.03006700046765860000;
    aPoles.ChangeValue(7, 46) = gp_Pnt(-119.38108228759732000000, -0.00000000000000364635, -84.30140001571530200000);
    aWeights.ChangeValue(7, 47) = +1.03005153385603830000;
    aPoles.ChangeValue(7, 47) = gp_Pnt(-122.63466837574235000000, +0.00000000000007773224, -82.97105629274108200000);
    aWeights.ChangeValue(7, 48) = +1.03003663316235050000;
    aPoles.ChangeValue(7, 48) = gp_Pnt(-125.86988610286646000000, +0.00000000000000501775, -81.59643931580511400000);
    aWeights.ChangeValue(7, 49) = +1.03002002524069390000;
    aPoles.ChangeValue(7, 49) = gp_Pnt(-129.08600965998806000000, +0.00000000000004872530, -80.17785297868806500000);
    aWeights.ChangeValue(7, 50) = +1.03000192732158440000;
    aPoles.ChangeValue(7, 50) = gp_Pnt(-132.28232849510800000000, +0.00000000000003627431, -78.71561001568775900000);
    aWeights.ChangeValue(7, 51) = +1.02996526567106140000;
    aPoles.ChangeValue(7, 51) = gp_Pnt(-138.40719443250111000000, +0.00000000000004030865, -75.81195871455292900000);
    aWeights.ChangeValue(7, 52) = +1.02994403451619650000;
    aPoles.ChangeValue(7, 52) = gp_Pnt(-141.33856968181306000000, +0.00000000000003444592, -74.37651555974527200000);
    aWeights.ChangeValue(7, 53) = +1.02992866105480000000;
    aPoles.ChangeValue(7, 53) = gp_Pnt(-144.25171811139330000000, +0.00000000000003429445, -72.90395453557894700000);
    aWeights.ChangeValue(7, 54) = +1.02989968743351530000;
    aPoles.ChangeValue(7, 54) = gp_Pnt(-147.14603336223070000000, +0.00000000000004355038, -71.39457006641885100000);
    aWeights.ChangeValue(7, 55) = +1.02988222474475720000;
    aPoles.ChangeValue(7, 55) = gp_Pnt(-150.02095857157173000000, +0.00000000000003217269, -69.84863841933133700000);
    aWeights.ChangeValue(7, 56) = +1.02985386954430420000;
    aPoles.ChangeValue(7, 56) = gp_Pnt(-152.87595706513403000000, +0.00000000000003648661, -68.26644064265008200000);
    aWeights.ChangeValue(7, 57) = +1.02982704006085530000;
    aPoles.ChangeValue(7, 57) = gp_Pnt(-155.71041601974636000000, +0.00000000000003591181, -66.64830754728993200000);
    aWeights.ChangeValue(7, 58) = +1.02976639514271140000;
    aPoles.ChangeValue(7, 58) = gp_Pnt(-161.55369960091491000000, +0.00000000000003646415, -63.21332070345936700000);
    aWeights.ChangeValue(7, 59) = +1.02972545417744080000;
    aPoles.ChangeValue(7, 59) = gp_Pnt(-164.55974256681068000000, +0.00000000000003294676, -61.39167299907511900000);
    aWeights.ChangeValue(7, 60) = +1.02970377642180270000;
    aPoles.ChangeValue(7, 60) = gp_Pnt(-167.53873683551103000000, +0.00000000000002190344, -59.52621075357659900000);
    aWeights.ChangeValue(7, 61) = +1.02963665582099750000;
    aPoles.ChangeValue(7, 61) = gp_Pnt(-170.49570646978711000000, +0.00000000000009010479, -57.62531748377598000000);
    aWeights.ChangeValue(7, 62) = +1.02961756328110620000;
    aPoles.ChangeValue(7, 62) = gp_Pnt(-173.42176702363508000000, -0.00000000000003499440, -55.67944052993496500000);
    aWeights.ChangeValue(7, 63) = +1.02954937293567860000;
    aPoles.ChangeValue(7, 63) = gp_Pnt(-176.32284460610933000000, +0.00000000000007636921, -53.69521656711459900000);
    aWeights.ChangeValue(7, 64) = +1.02950097342681770000;
    aPoles.ChangeValue(7, 64) = gp_Pnt(-179.19569709355173000000, +0.00000000000003273955, -51.67161593723249500000);
    aWeights.ChangeValue(7, 65) = +1.02943612532291810000;
    aPoles.ChangeValue(7, 65) = gp_Pnt(-182.04053139917158000000, +0.00000000000003996803, -49.60917258111981500000);
    aWeights.ChangeValue(7, 66) = +1.02937840445762090000;
    aPoles.ChangeValue(7, 66) = gp_Pnt(-184.68250151172640000000, +0.00000000000004112926, -47.69381589112448700000);
    aWeights.ChangeValue(7, 67) = +1.02929786839945800000;
    aPoles.ChangeValue(7, 67) = gp_Pnt(-187.30004443981446000000, +0.00000000000003629801, -45.74517623046489900000);
    aWeights.ChangeValue(7, 68) = +1.02927785532615720000;
    aPoles.ChangeValue(7, 68) = gp_Pnt(-189.89358418563035000000, +0.00000000000003708012, -43.76295173174737800000);
    aWeights.ChangeValue(7, 69) = +1.02909457173661250000;
    aPoles.ChangeValue(7, 69) = gp_Pnt(-192.46070903458983000000, +0.00000000000005500515, -41.74904085552218200000);
    aWeights.ChangeValue(7, 70) = +1.02915656102268340000;
    aPoles.ChangeValue(7, 70) = gp_Pnt(-195.00353322314638000000, +0.00000000000002645256, -39.70148425813464900000);
    aWeights.ChangeValue(7, 71) = +1.02891246604057510000;
    aPoles.ChangeValue(7, 71) = gp_Pnt(-197.51895024482548000000, +0.00000000000005006422, -37.62251287581096900000);
    aWeights.ChangeValue(7, 72) = +1.02884001996279940000;
    aPoles.ChangeValue(7, 72) = gp_Pnt(-200.00717902020989000000, +0.00000000000003866246, -35.51147139839754600000);
    aWeights.ChangeValue(7, 73) = +1.02870418206103280000;
    aPoles.ChangeValue(7, 73) = gp_Pnt(-202.46745722827831000000, +0.00000000000003996803, -33.36845405838467800000);
    aWeights.ChangeValue(7, 74) = +1.02860417892808040000;
    aPoles.ChangeValue(7, 74) = gp_Pnt(-204.92874075079348000000, +0.00000000000003952569, -31.22492832365916000000);
    aWeights.ChangeValue(7, 75) = +1.02826579045574770000;
    aPoles.ChangeValue(7, 75) = gp_Pnt(-207.35951843182116000000, +0.00000000000002864861, -29.04902036970887700000);
    aWeights.ChangeValue(7, 76) = +1.02871793966685040000;
    aPoles.ChangeValue(7, 76) = gp_Pnt(-209.76815931164757000000, +0.00000000000007786791, -26.84449461829588300000);
    aWeights.ChangeValue(7, 77) = +1.02728787827248790000;
    aPoles.ChangeValue(7, 77) = gp_Pnt(-212.13952611955784000000, -0.00000000000002645359, -24.59453985262025100000);
    aWeights.ChangeValue(7, 78) = +1.02767535385751650000;
    aPoles.ChangeValue(7, 78) = gp_Pnt(-214.48523983715771000000, +0.00000000000011316462, -22.34028621398329100000);
    aWeights.ChangeValue(7, 79) = +1.02745809923196680000;
    aPoles.ChangeValue(7, 79) = gp_Pnt(-216.79261871005519000000, -0.00000000000002978790, -20.02558452892611700000);
    aWeights.ChangeValue(7, 80) = +1.02725110106353260000;
    aPoles.ChangeValue(7, 80) = gp_Pnt(-219.08116944862113000000, +0.00000000000005732296, -17.69632354506026700000);
    aWeights.ChangeValue(7, 81) = +1.02619749797986360000;
    aPoles.ChangeValue(7, 81) = gp_Pnt(-221.32510969435936000000, +0.00000000000004618528, -15.33078661161192400000);
  }
  ////

  const Handle(Geom_Surface) aS1 = new Geom_BSplineSurface(aPoles, aWeights, aUKnots, aVKnots, aUMult, aVMult, aUDegree, aVDegree);

  char buff[1024];

  Sprintf(buff, "%s_1", theArgVal[1]);
  DrawTrSurf::Set(buff, aS1);
  theDI << buff << " ";

  Sprintf(buff, "%s_2", theArgVal[1]);
  DrawTrSurf::Set(buff, aS2);
  theDI << buff << "\n";

  return 0;
}

namespace AllocTest
{
  // The test is based of occupying of all available virtual memory.
  // Obviously it has no sense on 64-bit platforms.

  enum AllocTestStatus
  {
    NotApplicable = 0x1,
    OUMCatchOK    = 0x2,
    OUMCatchFail  = 0x4
  };

  template<int> int test()
  {
    // non-32-bit implementation
    return NotApplicable;
  }
  
  template<> int test<4>()
  {
    // 32-bit implementation
    NCollection_List<Standard_Address> aList;
    const Standard_Integer aBlockSizes[] = {100000, 10000, 10};
    int aStatus = 0;

    // start populate memory with blocks of large size, then
    // smaller ones and so on according to content of the array aBlockSizes
    for (size_t i=0; i < sizeof(aBlockSizes)/sizeof(int); i++)
    {
      try
      {
        for (;;)
          aList.Append(Standard::Allocate(aBlockSizes[i]));
      }
      catch (Standard_Failure const&)
      {
        aStatus |= OUMCatchOK;
      }
      catch (...)
      {
        aStatus |= OUMCatchFail;
        break;
      }
    }
    // release all allocated blocks
    for (NCollection_List<Standard_Address>::Iterator it(aList); it.More(); it.Next())
    {
      Standard::Free(it.Value());
    }
    return aStatus;
  }
}

//=======================================================================
//function : OCC24836
//purpose :
//=======================================================================
static Standard_Integer OCC24836 (Draw_Interpretor& theDI, Standard_Integer n, const char** a)
{
  if (n != 1)
  {
    theDI << "Usage : " << a[0] << "\n";
    return 1;
  }

  int aStatus = AllocTest::test<sizeof(size_t)>();

  if (aStatus & AllocTest::NotApplicable)
    theDI << "This test case is not applicable for 64-bit and higher platforms\n";
  if (aStatus & AllocTest::OUMCatchOK)
    theDI << "out-of-memory has been caught: OK\n";
  if (aStatus & AllocTest::OUMCatchFail)
    theDI << "Error: out-of-memory is not always caught\n";
  return 0;
}


//=======================================================================
//function : OCC27021 
//purpose  : Tests performance of obtaining geometry (points) via topological
//           exploring or fetching the geometry.
//=======================================================================

// Fetch via topology
static std::pair<gp_Pnt, gp_Pnt> getVerticesA(const TopoDS_Edge& theEdge)
{
  std::pair<gp_Pnt, gp_Pnt> result;

  static TopoDS_Vertex aFirst, aLast;
  TopExp::Vertices(theEdge, aFirst, aLast, Standard_True);

  result.first = BRep_Tool::Pnt(aFirst);
  result.second = BRep_Tool::Pnt(aLast);

  return result;
}

//Geometrical way
static std::pair<gp_Pnt, gp_Pnt> getVerticesB(const TopoDS_Edge& theEdge)
{
  Standard_Real first;
  Standard_Real last;

  Handle(Geom_Curve) curve = BRep_Tool::Curve(theEdge, first, last);

  std::pair<gp_Pnt, gp_Pnt> result;

  if (theEdge.Orientation() == TopAbs_REVERSED)
  {
    curve->D0(first, result.second);
    curve->D0(last, result.first);
  }
  else
  {
    curve->D0(first, result.first);
    curve->D0(last, result.second);
  }
  return result;
}



static Standard_Integer OCC27021(Draw_Interpretor& theDI,
                                 Standard_Integer  theNArg,
                                 const char ** theArgVal)
{
  if (theNArg != 2)
  {
    std::cout << "Use: " << theArgVal[0] << " shape" << std::endl;
    return 1;
  }

  TopoDS_Shape shape (DBRep::Get(theArgVal[1]));

  TopTools_IndexedMapOfShape shape_faces;
  TopExp::MapShapes(shape, TopAbs_FACE, shape_faces);

  // Pick a single face which shows the problem.
  TopoDS_Face face = TopoDS::Face(shape_faces(10));
  TopTools_IndexedMapOfShape face_edges;
  TopExp::MapShapes(face, TopAbs_EDGE, face_edges);
  TopoDS_Edge edge = TopoDS::Edge(face_edges(2));

  Standard_Integer iterations = 100000000;

  std::pair<gp_Pnt, gp_Pnt> vertices;
  clock_t t = clock();

  theDI << "\nRetrieving " << iterations << " vertices using approach A)...\n";
  for (int i = 0; i < iterations; ++i)
  {
    vertices = getVerticesA(edge);
  }
  theDI << "COUNTER RetrievingVertA" << ": " << (clock() - t) / (double)CLOCKS_PER_SEC << "\n";
  t = clock();

  theDI << "\nRetrieving " << iterations << " vertices using approach B)...\n";
  for (int i = 0; i < iterations; ++i)
  {
    vertices = getVerticesB(edge);
  }
  theDI << "COUNTER RetrievingVertB" << ": " << (clock() - t) / (double)CLOCKS_PER_SEC << "\n";

  return 0;
}

//=======================================================================
//function : OCC27235
//purpose : check presentation in GDT document
//=======================================================================
static Standard_Integer OCC27235 (Draw_Interpretor& theDI, Standard_Integer n, const char** a)
{
  if (n < 2) {
    theDI<<"Use: OCC27235 Doc";
    return 1;
  }

  Handle(TDocStd_Document) Doc;
  DDocStd::GetDocument(a[1], Doc);
  if ( Doc.IsNull() ) { theDI << a[1] << " is not a document\n"; return 1; }
  Handle(XCAFDoc_DimTolTool) aDimTolTool= XCAFDoc_DocumentTool::DimTolTool(Doc->Main());
  Handle(XCAFDoc_ShapeTool) aShapeTool= XCAFDoc_DocumentTool::ShapeTool(Doc->Main());
  TopoDS_Compound aPresentations;
  BRep_Builder B;
  B.MakeCompound(aPresentations);

  TDF_LabelSequence aLabels;
  aShapeTool->GetShapes(aLabels);
  for ( Standard_Integer i=1; i <= aLabels.Length(); i++ )
  {
    aShapeTool->GetSubShapes(aLabels.Value(i), aLabels);
  }

  TDF_LabelSequence aGDTs;
  aDimTolTool->GetDimensionLabels(aGDTs);
  for (Standard_Integer i = 1; i <= aGDTs.Length(); i++) {
    Handle(XCAFDoc_Dimension) aDimAttr;
    if (!aGDTs.Value(i).FindAttribute(XCAFDoc_Dimension::GetID(),aDimAttr)) 
      continue;
    Handle(XCAFDimTolObjects_DimensionObject) anObject = aDimAttr->GetObject();
    if (anObject.IsNull())
      continue;
    TopoDS_Shape aShape = anObject->GetPresentation();
    if (!aShape.IsNull())
      B.Add(aPresentations, aShape);
  }

  aGDTs.Clear();
  aDimTolTool->GetGeomToleranceLabels(aGDTs);
  for (Standard_Integer i = 1; i <= aGDTs.Length(); i++) {
    Handle(XCAFDoc_GeomTolerance) aGTAttr;
    if (!aGDTs.Value(i).FindAttribute(XCAFDoc_GeomTolerance::GetID(),aGTAttr)) 
      continue;
    Handle(XCAFDimTolObjects_GeomToleranceObject) anObject = aGTAttr->GetObject();
    if (anObject.IsNull())
      continue;
    TopoDS_Shape aShape = anObject->GetPresentation();
    if (!aShape.IsNull())
      B.Add(aPresentations, aShape);
  }

  for ( Standard_Integer i=1; i <= aLabels.Length(); i++ )
  {
    TDF_LabelSequence aDatL;
    if(aDimTolTool->GetRefDatumLabel(aLabels.Value(i), aDatL))
    {
      for(Standard_Integer j = aDatL.Lower(); j <= aDatL.Upper(); j++)
      {
        Handle(XCAFDoc_Datum) aDat;
        if(!aDatL.Value(j).FindAttribute(XCAFDoc_Datum::GetID(), aDat))
          continue;
        Handle(XCAFDimTolObjects_DatumObject) anObject = aDat->GetObject();
        if (anObject.IsNull())
          continue;
        TopoDS_Shape aShape = anObject->GetPresentation();
        if (!aShape.IsNull())
          B.Add(aPresentations, aShape);
      }
    }
  }

  GProp_GProps aG;
  BRepGProp::LinearProperties(aPresentations, aG);
  gp_Pnt aPnt = aG.CentreOfMass();
  theDI << "Centre of mass: " << aPnt.X() << " " << aPnt.Y() << " " << aPnt.Z() << "\n";
  theDI << "Mass: " << aG.Mass() << "\n";

  return 0;
}

//=======================================================================
//function : OCC24836
//purpose :
//=======================================================================
static Standard_Integer OCC26930(Draw_Interpretor& theDI,
                                 Standard_Integer  theNArg,
                                 const char ** theArgVal)
{
  if (theNArg != 5)
  {
    std::cout << "Use: " << theArgVal[0] <<" surface curve start end" << std::endl;
    return 1;
  }





  Handle(Geom_Surface) aSurface = DrawTrSurf::GetSurface(theArgVal[1]);
  Handle(Geom_Curve) aCurve = DrawTrSurf::GetCurve(theArgVal[2]);
  Standard_Real aStart = Draw::Atof(theArgVal[3]);
  Standard_Real anEnd = Draw::Atof(theArgVal[4]);

  //project
  Handle (Geom2d_Curve) aPCurve;

  ShapeConstruct_ProjectCurveOnSurface aProj;
  aProj.Init(aSurface, Precision::Confusion());
  {
    try {
        Handle (Geom_Curve) aTmpCurve = aCurve; //to use reference in Perform()
        aProj.Perform (aTmpCurve, aStart, anEnd, aPCurve);
    } catch (const Standard_Failure&) {
    }
  }

  //check results
  if (aPCurve.IsNull()) {
    theDI << "Error: pcurve is null\n";
  }
  else {
    if (aPCurve->IsKind(STANDARD_TYPE(Geom2d_Line))) {
      theDI << "Pcurve is line: OK\n";
    }
    else {
      theDI << "Error: PCurve is not line\n";
    }
  }

  return 0;
}

//=======================================================================
//function : OCC27466
//purpose :
//=======================================================================
static Standard_Integer OCC27466(Draw_Interpretor& theDI,
  Standard_Integer  theNArg,
  const char ** theArgVal)
{
  if (theNArg != 4)
  {
    std::cout << "Use: " << theArgVal[0] << " face point start_pnt2d" << std::endl;
    return 1;
  }

  TopoDS_Face aFace = TopoDS::Face(DBRep::Get(theArgVal[1], TopAbs_FACE, Standard_True));
  if (aFace.IsNull())
    return 1;
  gp_Pnt aPnt;
  if (!DrawTrSurf::GetPoint(theArgVal[2], aPnt))
    return 1;
  gp_Pnt2d aUV;
  if (!DrawTrSurf::GetPoint2d(theArgVal[3], aUV))
    return 1;
  BRepAdaptor_Surface aSurf(aFace);

  Standard_Real aTolU = Precision::PConfusion();
  Standard_Real aTolV = Precision::PConfusion();

  Extrema_GenLocateExtPS anExtrema(aSurf, aTolU, aTolV);
  anExtrema.Perform(aPnt, aUV.X(), aUV.Y(), Standard_True);

  if (!anExtrema.IsDone())
  {
    theDI << "Error: Extrema is not done";
  }
  else
  {
    Standard_Real aSqDist = anExtrema.SquareDistance();
    gp_Pnt aResPnt = anExtrema.Point().Value();
    Standard_Real u, v;
    anExtrema.Point().Parameter(u, v);
    gp_Pnt2d aResUV(u, v);
    DrawTrSurf::Set((TCollection_AsciiString(theArgVal[2]) + "_res").ToCString(), aResPnt);
    DrawTrSurf::Set((TCollection_AsciiString(theArgVal[3]) + "_res").ToCString(), aResUV);
    theDI << theArgVal[2] << "_res and " << theArgVal[3] << "_res are created, dist=" << sqrt(aSqDist);
  }
  return 0;
}

#include <GCE2d_MakeParabola.hxx>
#include <gp_Ax22d.hxx>
#include <Geom2d_Parabola.hxx>
#include <gp_Parab2d.hxx>

namespace Parab2d_Bug26747
{
  //Directrix and X-axe direction
  gp_Ax2d Axes;

  //Focus
  gp_Pnt2d FocusPoint;

  //Focal length
  Standard_Real FocalLength;

  //Coordinates of the vertex
  Standard_Real VertX, VertY;

  //Parameter
  Standard_Real Parameter;

  //Coefficients
  Standard_Real Coeffs[6];
}

//========================================================================
//function : OCC26747_CheckParabola
//purpose  : Checks if created parabola is correct
//========================================================================
static void OCC26747_CheckParabola(Draw_Interpretor& theDI,
                                   const char *theName,
                                   const Standard_Boolean theSense = Standard_True)
{
  const Standard_Real aCompareTol = 1.0e-12;

  //                      Directrix,                    Focus
  GCE2d_MakeParabola aPrb(Parab2d_Bug26747::Axes, Parab2d_Bug26747::FocusPoint, theSense);

  DrawTrSurf::Set(theName, aPrb.Value());

  gp_Pnt2d aVert(aPrb.Value()->Parab2d().Location());

  theDI << "Focal Length: " << aPrb.Value()->Parab2d().Focal() << "\n";
  theDI << "Vertex (" << aVert.X() << ", " << aVert.Y() << ")\n";
  theDI << "Parameter = " << aPrb.Value()->Parab2d().Parameter() << "\n";

  Standard_Real aF[6] = {RealLast(), RealLast(), RealLast(),
                         RealLast(), RealLast(), RealLast()};  
  aPrb.Value()->Parab2d().Coefficients(aF[0], aF[1], aF[2], aF[3], aF[4], aF[5]);
  theDI << "A = " << aF[0] << ", B = " << aF[1] << ", C = " << aF[2] <<
           ", D = " << aF[3] << ", E = " << aF[4] << ", F = " << aF[5] << "\n";

  if(Abs(aPrb.Value()->Parab2d().Focal() - 
                        Parab2d_Bug26747::FocalLength) > aCompareTol)
    theDI << "Error in focal length computation!\n";

  if( (Abs(aVert.X() - Parab2d_Bug26747::VertX) > aCompareTol) ||
      (Abs(aVert.Y() - Parab2d_Bug26747::VertY) > aCompareTol))
    theDI << "Error in vertex computation!\n";

  if(Abs(aPrb.Value()->Parab2d().Parameter() -
                        Parab2d_Bug26747::Parameter) > aCompareTol)
    theDI << "Error in parameter computation!\n";

  for(int i = 0; i < 6; i++)
  {
    if(Abs(aF[i] - Parab2d_Bug26747::Coeffs[i]) > aCompareTol)
    {
      theDI << "Error in " << i << "-th coefficient computation!\n";
    }
  }
}

//========================================================================
//function : OCC26747_1
//purpose  : Creates a 2D-parabola for testing
//========================================================================
static Standard_Integer OCC26747_1(Draw_Interpretor& theDI, 
                                   Standard_Integer  theNArg, 
                                   const char **     theArgVal)
{
  if(theNArg < 2)
  {
    theDI << "Use: OCC26747_1 result\n";
    return 1;
  }

  //Expected parabola:

  //  ^ Y
  //  |
  //  |
  //  |
  //  |
  //  |                 o
  //  |    A   o   F
  //  |     o     x
  //  |        o
  //  |                 o
  //  |
  //  ---------------------------> X

  //  where
  //  Y-axe is the directrix of the parabola,
  //  A(0.5, 3.0) is a Vertex of the parabola,
  //  F(1.0, 3.0) is the focus of the parabola,
  //  Focal length is 0.5,
  //  Parameter of the parabola is 1.
  //  Equation: (y-3)^2=2*p*(x-0.5), i.e. (y-3)^2=2*(x-0.5)
  //  A * X^2 + B * Y^2 + 2*C*X*Y + 2*D*X    + 2*E*Y    + F = 0.
  //                  OR
  //  0 * X^2 + 1 * Y^2 + 2*0*X*Y + 2*(-1)*X + 2*(-3)*Y + 10 = 0.

  Parab2d_Bug26747::Axes = gp_Ax2d(gp_Pnt2d(0.0, 3.0), gp_Dir2d(0.0, 1.0));
  Parab2d_Bug26747::FocusPoint.SetCoord(1.0, 3.0);

  Parab2d_Bug26747::FocalLength = 0.5;

  Parab2d_Bug26747::VertX = 0.5;
  Parab2d_Bug26747::VertY = 3.0;

  Parab2d_Bug26747::Parameter = 1.0;

  Parab2d_Bug26747::Coeffs[0] = 0.0;
  Parab2d_Bug26747::Coeffs[1] = 1.0;
  Parab2d_Bug26747::Coeffs[2] = 0.0;
  Parab2d_Bug26747::Coeffs[3] = -1.0;
  Parab2d_Bug26747::Coeffs[4] = -3.0;
  Parab2d_Bug26747::Coeffs[5] = 10.0;

  OCC26747_CheckParabola(theDI, theArgVal[1]);

  return 0;
}

//=======================================================================
//function : OCC26747_2
//purpose  : Creates a 2D-parabola for testing
//=======================================================================
static Standard_Integer OCC26747_2(Draw_Interpretor& theDI,
                                   Standard_Integer  theNArg,
                                   const char **     theArgVal)
{
  if(theNArg < 2)
  {
    theDI << "Use: OCC26747_2 result\n";
    return 1;
  }

  //Expected parabola:

  //                          ^ Y
  //                          |
  //        o                 |
  //                 o        |
  //            F x     o A   |
  //                 o        |
  //        o                 |
  //                          |
  //  <------------------------
  //  X

  //  where (in UCS - User Coordinate System, - which
  //  is shown in the picture):
  //    Y-axe is the directrix of the parabola,
  //    A(0.5, 3.0) is a Vertex of the parabola,
  //    F(1.0, 3.0) is the focus of the parabola.
  //
  //  In WCS (World Coordinate System) these points have coordinates:
  //    A(-0.5, 3.0), F(-1.0, 3.0).
  //
  //  Focal length is 0.5,
  //  Parameter of the parabola is 1.
  //  Equation (in WCS): (y-3)^2=2*p*(-x-0.5), i.e. (y-3)^2=2*(-x-0.5)
  //  A * X^2 + B * (Y^2) + 2*C*(X*Y) + 2*D*X + 2*E*Y    + F = 0.
  //  0 * X^2 + 1 * (Y^2) + 2*0*(X*Y) + 2*1*X + 2*(-3)*Y + 10 = 0.


  Parab2d_Bug26747::Axes = gp_Ax2d(gp_Pnt2d(0.0, 0.0), gp_Dir2d(0.0, 1.0));
  Parab2d_Bug26747::FocusPoint.SetCoord(-1.0, 3.0);

  Parab2d_Bug26747::FocalLength = 0.5;

  Parab2d_Bug26747::VertX = -0.5;
  Parab2d_Bug26747::VertY = 3.0;

  Parab2d_Bug26747::Parameter = 1.0;

  Parab2d_Bug26747::Coeffs[0] = 0.0;
  Parab2d_Bug26747::Coeffs[1] = 1.0;
  Parab2d_Bug26747::Coeffs[2] = 0.0;
  Parab2d_Bug26747::Coeffs[3] = 1.0;
  Parab2d_Bug26747::Coeffs[4] = -3.0;
  Parab2d_Bug26747::Coeffs[5] = 10.0;

  OCC26747_CheckParabola(theDI, theArgVal[1], Standard_False);

  return 0;
}

//=======================================================================
//function : OCC26747_3
//purpose  : Creates a 2D-parabola for testing
//=======================================================================
static Standard_Integer OCC26747_3(Draw_Interpretor& theDI,
                                   Standard_Integer  theNArg,
                                   const char **     theArgVal)
{
  if(theNArg < 2)
  {
    theDI << "Use: OCC26747_2 result\n";
    return 1;
  }

  //Expected parabola:

  //                    ^ Y
  //                    |
  //        o           |
  //                 o  |
  //            F x     o A
  //                 o  |
  //        o           |
  //                    |
  //  <------------------
  //  X

  //  where (in UCS - User Coordinate System, - which
  //  is shown in the picture):
  //    Y-axe is the directrix of the parabola,
  //    A(0.0, 3.0) is a Vertex of the parabola,
  //    F(0.0, 3.0) is the focus of the parabola (the Focus
  //                matches with the Apex).
  //
  //  In WCS (World Coordinate System) these points have coordinates:
  //    A(0.0, 3.0), F(0.0, 3.0).
  //
  //  Focal length is 0.0,
  //  Parameter of the parabola is 0.0.
  //  Equation (in WCS): (y-3)^2=2*p*(-x-0.0), i.e. (y-3)^2=0 (looks like a line y=3)
  //  A * X^2 + B * (Y^2) + 2*C*(X*Y) + 2*D*X + 2*E*Y    + F = 0.
  //  0 * X^2 + 1 * (Y^2) + 2*0*(X*Y) + 2*0*X + 2*(-3)*Y + 9 = 0.

  Parab2d_Bug26747::Axes = gp_Ax2d(gp_Pnt2d(0.0, 0.0), gp_Dir2d(0.0, 1.0));
  Parab2d_Bug26747::FocusPoint.SetCoord(0.0, 3.0);

  Parab2d_Bug26747::FocalLength = 0.0;

  Parab2d_Bug26747::VertX = 0.0;
  Parab2d_Bug26747::VertY = 3.0;

  Parab2d_Bug26747::Parameter = 0.0;

  Parab2d_Bug26747::Coeffs[0] = 0.0;
  Parab2d_Bug26747::Coeffs[1] = 1.0;
  Parab2d_Bug26747::Coeffs[2] = 0.0;
  Parab2d_Bug26747::Coeffs[3] = 0.0;
  Parab2d_Bug26747::Coeffs[4] = -3.0;
  Parab2d_Bug26747::Coeffs[5] = 9.0;

  OCC26747_CheckParabola(theDI, theArgVal[1], Standard_False);

  return 0;
}

#include "Geom2d_BezierCurve.hxx"
#include "Geom2dGcc_QualifiedCurve.hxx"
#include "Geom2dAdaptor_Curve.hxx"
#include "Geom2dAPI_ProjectPointOnCurve.hxx"
#include "Geom2dGcc_Circ2d2TanOn.hxx"
//=======================================================================
//function : OCC27357
//purpose :
//=======================================================================
static Standard_Integer OCC27357(Draw_Interpretor& theDI,
                                 Standard_Integer,
                                 const char **)
{
  TColgp_Array1OfPnt2d aPoles(1,3);
  aPoles.SetValue(1, gp_Pnt2d(0.,0.));
  aPoles.SetValue(2, gp_Pnt2d(0.,1.));
  aPoles.SetValue(3, gp_Pnt2d(6.,0.));

  Handle(Geom2d_BezierCurve) aCurve1 = new Geom2d_BezierCurve(aPoles);
  aPoles.SetValue(2, gp_Pnt2d(0.,1.5));
  Handle(Geom2d_BezierCurve) aCurve2 = new Geom2d_BezierCurve(aPoles);
  NCollection_List<Standard_Integer> aDuumyList;
  int nP = 100;
  for(int i = 0 ; i < nP ; i++){
    Standard_Real u = i / (nP-1.);
    gp_Pnt2d aP1;
    gp_Vec2d aTangent;
    aCurve1->D1(u,aP1,aTangent);
    gp_Vec2d aNormal(-aTangent.Y(),aTangent.X());
    Handle(Geom2d_Line) normalLine=new Geom2d_Line(aP1, gp_Dir2d(aNormal));
    Geom2dGcc_QualifiedCurve qualifiedC1(Geom2dAdaptor_Curve(aCurve1),GccEnt_unqualified);
    Geom2dGcc_QualifiedCurve qualifiedC2(Geom2dAdaptor_Curve(aCurve2),GccEnt_unqualified);

    try
    {
      Geom2dAPI_ProjectPointOnCurve projPc1(aP1, aCurve1);
      double g1 = projPc1.LowerDistanceParameter();
      Geom2dAPI_ProjectPointOnCurve projPc3(aP1, normalLine);
      double g3 = projPc3.LowerDistanceParameter();
      Geom2dGcc_Circ2d2TanOn aCircleBuilder(qualifiedC1,qualifiedC2,
        Geom2dAdaptor_Curve(normalLine),1e-9,g1,g1,g3);
      aDuumyList.Append(aCircleBuilder.NbSolutions());
    }
    catch(Standard_Failure const&)
    {
      theDI << "Exception was caught\n";
    }
  }
  return 0;
}
#include <Standard_ErrorHandler.hxx>
#include <TColGeom_SequenceOfCurve.hxx>
#include <GeomFill_NSections.hxx>
#include <Geom_TrimmedCurve.hxx>
#include <TopExp_Explorer.hxx>
#include <BRepBuilderAPI_MakeFace.hxx>
//=======================================================================
//function : OCC26270
//purpose :
//=======================================================================
static Standard_Integer OCC26270(Draw_Interpretor& theDI,
                                 Standard_Integer theNArg,
                                 const char **theArgVal)
{
  if (theNArg != 3)
  {
    theDI << "Usage :" << theArgVal[0] << " shape result\n";
    return 0;
  }
  TopoDS_Shape aShape = DBRep::Get(theArgVal[1]);
  TopExp_Explorer anExp(aShape, TopAbs_EDGE);
  TColGeom_SequenceOfCurve aCurveSeq;
  for (; anExp.More(); anExp.Next())
  {
    Standard_Real f, l;
    Handle(Geom_Curve) aCurve = BRep_Tool::Curve(TopoDS::Edge(anExp.Current()), f, l);
    if (!aCurve.IsNull())
    {
      aCurve = new Geom_TrimmedCurve(aCurve, f, l);
      aCurveSeq.Append(aCurve);
    }
  }
  if (aCurveSeq.Length() > 1)
  {
    try
    {
      OCC_CATCH_SIGNALS
        GeomFill_NSections aBSurface(aCurveSeq);
      Handle(Geom_BSplineSurface) aRes = aBSurface.BSplineSurface();
      if (!aRes.IsNull())
      {
        BRepBuilderAPI_MakeFace b_face1(aRes, Precision::Confusion());
        TopoDS_Face bsp_face1 = b_face1.Face();
        DBRep::Set(theArgVal[2], bsp_face1);
      }
    }
    catch (Standard_Failure const&)
    {
      theDI << "ERROR: Exception in GeomFill_NSections\n";
    }
  }
  return 0;
}

#include "BRepBuilderAPI_MakeWire.hxx"
#include "BRepBuilderAPI_MakeEdge.hxx"
static Standard_Integer OCC27552(Draw_Interpretor&,
                                   Standard_Integer,
                                   const char **  )
{
  BRep_Builder BB;
  TopoDS_Vertex V1, V2, V3;
  TopoDS_Edge E1, E2;
  BB.MakeVertex(V1, gp_Pnt(0,0,0), 0.1);
  BB.MakeVertex(V2, gp_Pnt(5,0,0), 0.1);
  BB.MakeVertex(V3, gp_Pnt(10,0,0), 0.1);
  E1 = BRepBuilderAPI_MakeEdge(V1, V2).Edge();
  E2 = BRepBuilderAPI_MakeEdge(V2, V3).Edge();
  BRepBuilderAPI_MakeWire MW;
  MW.Add(E1);
  MW.Add(E2);
  TopoDS_Vertex V4, V5, V6, V7;
  TopoDS_Edge E3, E4;
  BB.MakeVertex(V4, gp_Pnt(10,0+0.05,0), 0.07);
  BB.MakeVertex(V5, gp_Pnt(10,0-0.05,0), 0.07);
  BB.MakeVertex(V6, gp_Pnt(10,0+2,0), 0.07);
  BB.MakeVertex(V7, gp_Pnt(10,0-2,0), 0.07);
  E3 = BRepBuilderAPI_MakeEdge(V4, V6).Edge();
  E4 = BRepBuilderAPI_MakeEdge(V5, V7).Edge();
  TopTools_ListOfShape LLE;
  LLE.Append(E3);
  LLE.Append(E4);
  MW.Add(LLE);
  TopoDS_Shape W = MW.Wire();
  DBRep::Set("outw", W);

  return 0;
}

#include <NCollection_IncAllocator.hxx>
static Standard_Integer OCC27875(Draw_Interpretor& theDI,
                                 Standard_Integer theNArg,
                                 const char ** theArgVal)
{
  if (theNArg < 2)
  {
    theDI << "Use: OCC27875 curve\n";
  }

  TColGeom_SequenceOfCurve aNC(new NCollection_IncAllocator());

  const Handle(Geom_Curve) aC = Handle(Geom_Curve)::DownCast(DrawTrSurf::Get(theArgVal[1]));

  aNC.Append(aC);

  GeomFill_NSections aNS(aNC);

  if (aNS.BSplineSurface().IsNull())
  {
    theDI << "GeomFill_NSections is not done.\n";
  }

  return 0;
}

#include <BRepClass_FaceClassifier.hxx>
static Standard_Integer OCC27884(Draw_Interpretor& theDI,
  Standard_Integer  theArgNb,
  const char**      theArgVec)
{
  if (theArgNb != 4) {
    return 0;
  }
  Standard_Real aCheck = Draw::Atof(theArgVec[3]);
  Handle(Geom_Curve) aCur = DrawTrSurf::GetCurve(theArgVec[1]);

  const Handle(Standard_Type)& aType = aCur->DynamicType();

  Standard_Real aF = aCur->FirstParameter();
  Standard_Real aL = aCur->LastParameter();

  Standard_Real number_points = Draw::Atof(theArgVec[2]);
  Standard_Real aSig = (aL - aF) / (number_points - 1);

  TopTools_ListOfShape aLE;

  gp_Pnt aP, aPF, aPL;
  aPF = aCur->Value(aF);
  aP = aPF;

  for (Standard_Integer i = 1; i < number_points; i++)
  {
    TopoDS_Edge anE;
    aL = aF + (i * aSig);
    aPL = aCur->Value(aL);
    if (aCheck == 2)
    {
      if (i % 2 == 1)
      {
        anE = BRepBuilderAPI_MakeEdge(aPF, aPL);
      }
      else
      {
        if (aType == STANDARD_TYPE(Geom_BSplineCurve))
        {
          Handle(Geom_BSplineCurve) aCurCopy = Handle(Geom_BSplineCurve)::DownCast(aCur->Copy());
          aCurCopy->Segment(aL - aSig, aL);
          anE = BRepBuilderAPI_MakeEdge(aCurCopy);
        }
        else
        {
          Handle(Geom_TrimmedCurve) aTCur = new Geom_TrimmedCurve(aCur, aL - aSig, aL);
          anE = BRepBuilderAPI_MakeEdge(aTCur);
        }
      }
      aPF = aPL;
    }
    else
    {
      if (aCheck == 0)
      {
        anE = BRepBuilderAPI_MakeEdge(aPF, aPL);
        aPF = aPL;
      }
      if (aCheck == 1)
      {
        if (aType == STANDARD_TYPE(Geom_BSplineCurve))
        {
          Handle(Geom_BSplineCurve) aCurCopy = Handle(Geom_BSplineCurve)::DownCast(aCur->Copy());
          aCurCopy->Segment(aL - aSig, aL);
          anE = BRepBuilderAPI_MakeEdge(aCurCopy);
        }
        else
        {
          Handle(Geom_TrimmedCurve) aTCur = new Geom_TrimmedCurve(aCur, aL - aSig, aL);
          anE = BRepBuilderAPI_MakeEdge(aTCur);
        }
      }
    }
    aLE.Append(anE);
  }
  if (!aCur->IsClosed())
  {
    TopoDS_Edge anE = BRepBuilderAPI_MakeEdge(aPL, aP);
    aLE.Append(anE);
  }

  BRepBuilderAPI_MakeWire aWire;
  aWire.Add(aLE);
  TopoDS_Face aFace = BRepBuilderAPI_MakeFace(aWire.Wire());
  
  //
  
  Standard_Real anUMin, anUMax, aVMin, aVMax;
  BRepTools::UVBounds(aFace, anUMin, anUMax, aVMin, aVMax);
  gp_Pnt2d aP2d(anUMin - ((anUMax + anUMin) / 2), aVMin - ((aVMax + aVMin) / 2));
  
  const Standard_Real aTol = BRep_Tool::Tolerance(aFace);

  BRepClass_FaceClassifier aClassifier;

  OSD_Timer timer;
  timer.Start();
  for (Standard_Integer i = 1; i <= 100; i++)
  {
    aClassifier.Perform(aFace, aP2d, aTol, Standard_True);
  }
  timer.Stop();
  Standard_Real aTimer1 = timer.UserTimeCPU();
  timer.Reset();
  timer.Start();
  for (Standard_Integer i = 1; i <= 100; i++)
  {
    aClassifier.Perform(aFace, aP2d, aTol, Standard_False);
  }
  timer.Stop();
  Standard_Real aTimer2 = timer.UserTimeCPU();
  theDI << "Improving time: " << (aTimer2 - aTimer1) / aTimer2 * 100 << " %\n";

  return 0;
}


#include <TDF_Tool.hxx>
#include <XCAFDoc_View.hxx>
#include <XCAFDoc_ViewTool.hxx>
#include <XCAFView_Object.hxx>
#include <XCAFView_ProjectionType.hxx>
static Standard_Integer OCC28389(Draw_Interpretor& di, Standard_Integer argc, const char** argv)
{
  if (argc < 20) {
    di << "Use: OCC28389 Doc label nb_shapes nb_GDT nb_planes name type pp_x pp_y pp_z vd_x vd_y vd_z ud_x ud_y ud_z zoom width height";
    return 1;
  }
  Handle(TDocStd_Document) aDoc;
  DDocStd::GetDocument(argv[1], aDoc);
  if (aDoc.IsNull()) {
    di << "Error: Wrong document";
    return 1;
  }
  Handle(XCAFDoc_ViewTool) aViewTool = XCAFDoc_DocumentTool::ViewTool(aDoc->Main());

  TDF_Label aLabel;
  TDF_Tool::Label(aDoc->GetData(), argv[2], aLabel);
  if (aLabel.IsNull()) {
    di << "Error: Wrong label";
    return 1;
  }
  Handle(XCAFDoc_View) aView;
  if (!aLabel.FindAttribute(XCAFDoc_View::GetID(), aView)) {
    di << "Error: Wrong label";
    return 1;
  }
  Handle(XCAFView_Object) anObj = aView->GetObject();
  if (anObj.IsNull()) {
    di << "Error: Wrong label";
    return 1;
  }

  Standard_Boolean isOK = Standard_True;
  // check links
  Standard_Integer nbShapes = Draw::Atoi(argv[3]);
  Standard_Integer nbGDTs = Draw::Atoi(argv[4]);
  Standard_Integer nbPlanes = Draw::Atoi(argv[5]);
  TDF_LabelSequence aSequence;
  aViewTool->GetRefShapeLabel(aLabel, aSequence);
  if (aSequence.Length() != nbShapes)
    isOK = Standard_False;
  aSequence.Clear();
  aViewTool->GetRefGDTLabel(aLabel, aSequence);
  if (aSequence.Length() != nbGDTs)
    isOK = Standard_False;
  aSequence.Clear();
  aViewTool->GetRefClippingPlaneLabel(aLabel, aSequence);
  if (aSequence.Length() != nbPlanes)
    isOK = Standard_False;
  if (!isOK) {
    di << "Error: Wrong references";
    return 1;
  }

  if (anObj->Name()->IsDifferent(new TCollection_HAsciiString(argv[6]))) {
    di << "Error: Wrong name";
    return 1;
  }

  XCAFView_ProjectionType aType = XCAFView_ProjectionType_NoCamera;
  if (argv[7][0] == 'p')
    aType = XCAFView_ProjectionType_Parallel;
  else if (argv[7][0] == 'c')
    aType = XCAFView_ProjectionType_Central;

  if (anObj->Type()!= aType) {
    di << "Error: Wrong type";
    return 1;
  }

  gp_Pnt aPP(Draw::Atof(argv[8]), Draw::Atof(argv[9]), Draw::Atof(argv[10]));
  if (aPP.Distance(anObj->ProjectionPoint()) > Precision::Confusion()) {
    di << "Error: Wrong projection point";
    return 1;
  }

  gp_Dir aVD(Draw::Atof(argv[11]), Draw::Atof(argv[12]), Draw::Atof(argv[13]));
  if (!aVD.IsEqual(anObj->ViewDirection(), Precision::Angular())) {
    di << "Error: Wrong view direction";
    return 1;
  }

  gp_Dir aUD(Draw::Atof(argv[14]), Draw::Atof(argv[15]), Draw::Atof(argv[16]));
  if (!aUD.IsEqual(anObj->UpDirection(), Precision::Angular())) {
    di << "Error: Wrong up direction";
    return 1;
  }

  if (fabs(anObj->ZoomFactor() - Draw::Atof(argv[17])) > Precision::Confusion()) {
    di << "Error: Wrong zoom factor";
    return 1;
  }

  if (fabs(anObj->WindowHorizontalSize() - Draw::Atof(argv[18])) > Precision::Confusion())
    isOK = Standard_False;
  if (fabs(anObj->WindowVerticalSize() - Draw::Atof(argv[19])) > Precision::Confusion())
    isOK = Standard_False;
  if (!isOK) {
    di << "Error: Wrong Window size";
    return 1;
  }

  di << argv[2] << " OK";
  return 0;
}

#include <TColgp_HArray1OfPnt2d.hxx>
#include <TColgp_Array1OfVec2d.hxx>
#include <TColStd_HArray1OfBoolean.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Geom2dAPI_Interpolate.hxx>
#include <GeomAPI.hxx>
#include <BRepBuilderAPI_MakeEdge2d.hxx>

static Standard_Integer OCC28594(Draw_Interpretor& di, Standard_Integer argc, const char** argv)
{
  if (argc != 3)
  {
    di << "Usage :" << argv[0] << " curve_with_scale curve_without_scale\n";
    return 0;
  }
  Handle(TColgp_HArray1OfPnt2d) points_2d = new TColgp_HArray1OfPnt2d(1, 6);
  (*points_2d)(1) = gp_Pnt2d(-30.4, 8);
  (*points_2d)(2) = gp_Pnt2d(-16.689912, 17.498217);
  (*points_2d)(3) = gp_Pnt2d(-23.803064, 24.748543);
  (*points_2d)(4) = gp_Pnt2d(-16.907466, 32.919615);
  (*points_2d)(5) = gp_Pnt2d(-8.543829, 26.549421);
  (*points_2d)(6) = gp_Pnt2d(0, 39.200000);

  TColgp_Array1OfVec2d tangent_2d(1, 6);
  (tangent_2d)(1) = gp_Vec2d(0.3, 0.4);
  (tangent_2d)(2) = gp_Vec2d(0, 0);
  (tangent_2d)(3) = gp_Vec2d(0, 0);
  (tangent_2d)(4) = gp_Vec2d(0, 0);
  (tangent_2d)(5) = gp_Vec2d(0, 0);
  (tangent_2d)(6) = gp_Vec2d(1, 0);

  Handle(TColStd_HArray1OfBoolean) tangent_flags = new TColStd_HArray1OfBoolean(1, 6);
  (*tangent_flags)(1) = true;
  (*tangent_flags)(2) = false;
  (*tangent_flags)(3) = false;
  (*tangent_flags)(4) = false;
  (*tangent_flags)(5) = false;
  (*tangent_flags)(6) = true;

  Geom2dAPI_Interpolate interp_2d_with_scale(points_2d, Standard_False, Precision::Confusion());
  interp_2d_with_scale.Load(tangent_2d, tangent_flags);
  interp_2d_with_scale.Perform();
  Handle(Geom2d_BSplineCurve) curve_2d_with_scale = interp_2d_with_scale.Curve();

  Geom2dAPI_Interpolate interp_2d_without_scale(points_2d, Standard_False, Precision::Confusion());
  interp_2d_without_scale.Load(tangent_2d, tangent_flags, Standard_False);
  interp_2d_without_scale.Perform();
  Handle(Geom2d_BSplineCurve) curve_2d_without_scale = interp_2d_without_scale.Curve();

  DrawTrSurf::Set(argv[1], curve_2d_with_scale);
  DrawTrSurf::Set(argv[2], curve_2d_without_scale);
  return 0;
}

static Standard_Integer OCC28784(Draw_Interpretor&, Standard_Integer argc, const char** argv)
{
  if (argc < 3)
    return 1;

  TopoDS_Shape aShape =  DBRep::Get(argv[2]);
  if (aShape.IsNull())
    return 1;

  gp_Ax2 aPlane (gp::Origin(), gp::DX(), -gp::DZ());
  HLRAlgo_Projector aProjector(aPlane);

  Handle(HLRBRep_PolyAlgo) aHLR = new HLRBRep_PolyAlgo(aShape);
  aHLR->Projector(aProjector);
  aHLR->Update();

  HLRBRep_PolyHLRToShape aHLRtoShape;
  aHLRtoShape.Update(aHLR);

  TopoDS_Shape aHidden = aHLRtoShape.HCompound();
  
  DBRep::Set(argv[1], aHidden);

  return 0;
}

static Standard_Integer OCC28829 (Draw_Interpretor&, Standard_Integer, const char**)
{
  // do something that causes FPE exception
  std::cout << "sqrt(-1) = " << sqrt (-1.) << std::endl;
  return 0;
}

#include <NCollection_Buffer.hxx>
#include <DDocStd_DrawDocument.hxx>
#include <OSD_FileSystem.hxx>
#include <Standard_ArrayStreamBuffer.hxx>
#include <TDataStd_Name.hxx>
#include <TDocStd_Application.hxx>

#ifdef max
  #undef max
#endif

static Standard_Integer OCC28887 (Draw_Interpretor&, Standard_Integer theNbArgs, const char** theArgVec)
{
  if (theNbArgs < 3)
  {
    std::cout << "Syntax error: wrong number of arguments!\n";
    return 1;
  }

  const TCollection_AsciiString aFilePath (theArgVec[1]);
  const TCollection_AsciiString aName     (theArgVec[2]);
  Handle(NCollection_Buffer) aBuffer;
  {
    const Handle(OSD_FileSystem)& aFileSystem = OSD_FileSystem::DefaultFileSystem();
    opencascade::std::shared_ptr<std::istream> aFile = aFileSystem->OpenIStream (aFilePath, std::ios::binary | std::ios::in);
    if (aFile.get() == NULL)
    {
      std::cout << "Error: input file '" << aFilePath << "' cannot be read\n";
      return 1;
    }
    aFile->seekg (0, std::ios_base::end);
    const int64_t aFileLength = int64_t (aFile->tellg());
    if (aFileLength > int64_t (std::numeric_limits<ptrdiff_t>::max())
     || aFileLength < 1)
    {
      std::cout << "Error: input file '" << aFilePath << "' is too large\n";
      return 1;
    }
    aFile->seekg (0, std::ios_base::beg);

    aBuffer = new NCollection_Buffer (NCollection_BaseAllocator::CommonBaseAllocator());
    if (!aBuffer->Allocate (size_t(aFileLength)))
    {
      std::cout << "Error: memory allocation (" << aFileLength << ") has failed\n";
      return 1;
    }

    aFile->read ((char* )aBuffer->ChangeData(), aBuffer->Size());
    if (!aFile->good())
    {
      std::cout << "Error: input file '" << aFilePath << "' reading failure\n";
      return 1;
    }
  }

  Standard_ArrayStreamBuffer aStreamBuffer ((const char* )aBuffer->ChangeData(), aBuffer->Size());
  std::istream aStream (&aStreamBuffer);
  // just play with seeking
  aStream.seekg (0, std::ios_base::end);
  aStream.seekg (0, std::ios_base::beg);
  if (aFilePath.EndsWith (".brep")
   || aFilePath.EndsWith (".rle"))
  {
    TopoDS_Shape aShape;
    BRep_Builder aBuilder;
    BRepTools::Read (aShape, aStream, aBuilder);
    DBRep::Set (aName.ToCString(), aShape);
  }
  else
  {
    Handle(TDocStd_Document) aDoc;
    Handle(TDocStd_Application) anApp = DDocStd::GetApplication();
    Standard_CString aNameVar = aName.ToCString();
    if (DDocStd::GetDocument (aNameVar, aDoc, Standard_False))
    {
      std::cout << "Error: document with name " << aName << " already exists\n";
      return 1;
    }

    if (anApp->Open (aStream, aDoc) != PCDM_RS_OK)
    {
      std::cout << "Error: cannot open XDE document\n";
      return 1;
    }

    Handle(DDocStd_DrawDocument) aDrawDoc = new DDocStd_DrawDocument (aDoc);
    TDataStd_Name::Set (aDoc->GetData()->Root(), aName.ToCString());
    Draw::Set (aName.ToCString(), aDrawDoc);
  }

  return 0;
}

static Standard_Integer OCC28131 (Draw_Interpretor&, Standard_Integer theNbArgs, const char** theArgVec)
{
  if (theNbArgs != 2)
  {
    std::cerr << "Error: wrong number of arguments" << std::endl;
    return 1;
  }

  double height = 8.5;
  gp_Pnt JiZhunXian2_v0 = gp_Pnt(-17.6, 0.0, 0.0);
  gp_Pnt JiZhunXian2_v1 = gp_Pnt(0, 32.8, 0.0);

  // Outline
  TColgp_Array1OfPnt outer_e_bzr_geom_v(1, 4);
  {
    outer_e_bzr_geom_v(1) = JiZhunXian2_v0;
    outer_e_bzr_geom_v(4) = JiZhunXian2_v1;

    Standard_Real ratio1 = 5.4 / 13.2;
    outer_e_bzr_geom_v(2) = gp_Pnt(outer_e_bzr_geom_v(1).X(), ratio1*outer_e_bzr_geom_v(4).Y(), 0);
    Standard_Real ratio2 = 6.0 / 6.8;
    outer_e_bzr_geom_v(3) = gp_Pnt(ratio2*outer_e_bzr_geom_v(1).X(), outer_e_bzr_geom_v(4).Y(), 0);
  }

  Handle(Geom_BezierCurve) outer_e_bzr_geom = new Geom_BezierCurve(outer_e_bzr_geom_v);
  Handle(Geom_BSplineCurve) outer_e_bsp_geom = GeomConvert::CurveToBSplineCurve(outer_e_bzr_geom);
  TopoDS_Edge outer_e = BRepBuilderAPI_MakeEdge(outer_e_bsp_geom);

  Handle(Geom_BSplineCurve) curve1;
  {
    Handle(TColgp_HArray1OfPnt2d) harray = new TColgp_HArray1OfPnt2d(1, 2); // sizing harray
    harray->SetValue(1, gp_Pnt2d(-JiZhunXian2_v1.Y(), 0));
    harray->SetValue(2, gp_Pnt2d(0, height + height / 2));

    Geom2dAPI_Interpolate anInterpolation(harray, Standard_False, 1e-6);

    gp_Vec2d vtangent1(0, 1);
    gp_Vec2d vtangent2(1, 0);
    anInterpolation.Load(vtangent1, vtangent2);
    anInterpolation.Perform();

    Handle(Geom2d_BSplineCurve) c = anInterpolation.Curve();

    gp_Pln pln(gp_Ax3(gp_Pnt(), gp_Dir(1, 0, 0), gp_Dir(0, -1, 0)));

    Handle(Geom_BSplineCurve) c3d = Handle(Geom_BSplineCurve)::DownCast(GeomAPI::To3d(c, pln));
    curve1 = c3d;
  }

  Handle(Geom_BSplineCurve) curve2;
  {
    Handle(TColgp_HArray1OfPnt2d) harray = new TColgp_HArray1OfPnt2d(1, 3); // sizing harray
    harray->SetValue(1, gp_Pnt2d(-JiZhunXian2_v0.X(), 0));
    harray->SetValue(2, gp_Pnt2d(-JiZhunXian2_v0.X() - 2.6, height));
    harray->SetValue(3, gp_Pnt2d(0, height + height / 2));

    Geom2dAPI_Interpolate anInterpolation(harray, Standard_False, 1e-6);
    anInterpolation.Perform();

    Handle(Geom2d_BSplineCurve) c = anInterpolation.Curve();
    gp_Pln pln(gp_Ax3(gp_Pnt(), gp_Dir(0, -1, 0), gp_Dir(-1, 0, 0)));
    Handle(Geom_BSplineCurve) c3d = Handle(Geom_BSplineCurve)::DownCast(GeomAPI::To3d(c, pln));
    curve2 = c3d;
  }

  //////////////////////////////////////
  GeomFill_BSplineCurves fill2;
  fill2.Init(outer_e_bsp_geom, curve1, curve2, GeomFill_CoonsStyle);

  const Handle(Geom_BSplineSurface)& surf_geom = fill2.Surface();

  TopoDS_Shape filled_face = BRepBuilderAPI_MakeFace(surf_geom, 0);

  DBRep::Set (theArgVec[1], filled_face);

/*
  ///////////////////////////////////////////////////////////////////////
  TopoDS_Solid first_solid;
  {
    BRepOffset_MakeOffset myOffsetShape(filled_face, -offset_thick, 1e-4,
      BRepOffset_Skin, //Mode
      Standard_False, //Intersection
      Standard_False, //SelfInter
      GeomAbs_Intersection, //Join
      Standard_True, //Thickening
      Standard_False //RemoveIntEdges
      ); //RemoveInvalidFaces
    first_solid = TopoDS::Solid(myOffsetShape.Shape());
  }
*/
  return 0;
}
#include <math_NewtonFunctionRoot.hxx>
#include <math_TrigonometricFunctionRoots.hxx>
#include <math_TrigonometricEquationFunction.hxx>
#include <gp_Elips2d.hxx>
#include <Geom2d_Ellipse.hxx>
#include <Geom2dAPI_InterCurveCurve.hxx>
static Standard_Integer OCC29289(Draw_Interpretor&, Standard_Integer , const char** )
{
  gp_Elips2d e1(gp_Ax2d(gp_Pnt2d(0., 0.), gp_Dir2d(1., 0)), 2., 1.);
  Handle(Geom2d_Ellipse) Ge1 = new Geom2d_Ellipse(e1);
  gp_Elips2d e2(gp_Ax2d(gp_Pnt2d(0.5, 0.5), gp_Dir2d(1., 1.)), 2., 1.);
  Handle(Geom2d_Ellipse) Ge2 = new Geom2d_Ellipse(e2);

  Standard_Integer err = 0;
  Geom2dAPI_InterCurveCurve Intersector;
  Intersector.Init(Ge1, Ge2, 1.e-7);
  if (Intersector.NbPoints() == 0)
  {
    std::cout << "Error: intersector is not done  \n";
    err = 1;
  }


  Standard_Real A, B, C, D, E;
  A = 1.875;
  B = -.75;
  C = -.5;
  D = -.25;
  E = -.25;
  math_TrigonometricEquationFunction MyF(A, B, C, D, E);
  Standard_Real X, Tol1, Eps, Teta, TetaNewton;
  Tol1 = 1.e-15;
  Eps = 1.5e-12;
  Standard_Integer Nit[] = { 5, 6, 7, 6 };

  Standard_Real TetaPrev = 0.;
  Standard_Integer i;
  for (i = 1; i <= Intersector.NbPoints(); i++) {
    Teta = Intersector.Intersector().Point(i).ParamOnFirst();
    X = Teta - 0.1 * (Teta - TetaPrev);
    TetaPrev = Teta;
    math_NewtonFunctionRoot Resol(MyF, X, Tol1, Eps, Nit[i-1]);
    if (Resol.IsDone()) {
      TetaNewton = Resol.Root();
      if (Abs(Teta - TetaNewton) > 1.e-7)
      {
        std::cout << "Error: Newton root is wrong for " << Teta << " \n";
        err = 1;
      }
    }
    else
    {
      std::cout << "Error: Newton is not done for " << Teta << " \n";
      err = 1;
    }
  }

  return err;
}

//===============================================================================================
Standard_Boolean IsSameGuid (const Standard_GUID& aGuidNull, const Standard_GUID& aGuid2)
{
  Standard_Boolean isSame (Standard_False);
  if(Standard_GUID::IsEqual(aGuidNull, aGuid2)) {
    aGuid2.ShallowDump(std::cout);
    isSame = Standard_True;
  } else {
    aGuid2.ShallowDump(std::cout);
    std::cout <<std::endl;
  }
  return isSame;
}

#include <TDataStd_AsciiString.hxx>
#include <TDataStd_BooleanArray.hxx>
#include <TDataStd_BooleanList.hxx>
#include <TDataStd_ByteArray.hxx>
#include <TDataStd_ExtStringArray.hxx>
#include <TDataStd_ExtStringList.hxx>
#include <TDataStd_Integer.hxx>
#include <TDataStd_IntegerArray.hxx>
#include <TDataStd_IntegerList.hxx>
#include <TDataStd_Name.hxx>
#include <TDataStd_Real.hxx>
#include <TDataStd_RealArray.hxx>
#include <TDataStd_RealList.hxx>
#include <TDataStd_ReferenceArray.hxx>
#include <TDataStd_ReferenceList.hxx>

#define QCOMPARE(val1, val2) \
  di << "Checking " #val1 " == " #val2 << \
        ((val1) == (val2) ? ": OK\n" : ": Error\n")

static Standard_Integer OCC29371 (Draw_Interpretor& di, Standard_Integer n, const char** a)
{
  if (n != 1)
  {
    std::cout << "Usage : " << a[0] << "\n";
    return 1;
  }

  Handle(TDocStd_Application) anApp = DDocStd::GetApplication();
  Handle(TDocStd_Document) aDoc;
  anApp->NewDocument ("BinOcaf", aDoc);
  TDF_Label aLab = aDoc->Main();
  Standard_GUID aNullGuid("00000000-0000-0000-0000-000000000000");
  Standard_Boolean IsNullGuid(Standard_False);

  try {
    //1. Set TDataStd_AsciiString
    Handle(TDataStd_AsciiString) aStrAtt = new TDataStd_AsciiString();
    aLab.AddAttribute(aStrAtt);
    if(!aStrAtt.IsNull()) {
      Standard_GUID aGuid = aStrAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //2. Set TDataStd_BooleanArray
    Handle(TDataStd_BooleanArray) aBArAtt = new TDataStd_BooleanArray();
    aLab.AddAttribute(aBArAtt);
    if(!aBArAtt.IsNull()) {
      Standard_GUID aGuid = aBArAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //3. Set TDataStd_BooleanList
    Handle(TDataStd_BooleanList) aBListAtt = new TDataStd_BooleanList();
    aLab.AddAttribute(aBListAtt);
    if(!aBListAtt.IsNull()) {
      Standard_GUID aGuid = aBListAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //4. Set TDataStd_ByteArray
    Handle(TDataStd_ByteArray) aByteArAtt = new TDataStd_ByteArray();
    aLab.AddAttribute(aByteArAtt);
    if(!aByteArAtt.IsNull()) {
      Standard_GUID aGuid = aByteArAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //5. Set TDataStd_ExtStringArray
    Handle(TDataStd_ExtStringArray) anExtStrArAtt = new TDataStd_ExtStringArray();
    aLab.AddAttribute(anExtStrArAtt);
    if(!anExtStrArAtt.IsNull()) {
      Standard_GUID aGuid = anExtStrArAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //6. Set TDataStd_ExtStringList
    Handle(TDataStd_ExtStringList) anExtStrListAtt = new TDataStd_ExtStringList();
    aLab.AddAttribute(anExtStrListAtt);
    if(!anExtStrListAtt.IsNull()) {
      Standard_GUID aGuid = anExtStrListAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //7. Set TDataStd_Integer
    Handle(TDataStd_Integer) anIntAtt = new TDataStd_Integer();
    aLab.AddAttribute(anIntAtt);
    if(!anIntAtt.IsNull()) {
      Standard_GUID aGuid = anIntAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //8. Set TDataStd_IntegerArray
    Handle(TDataStd_IntegerArray) anIntArrAtt = new TDataStd_IntegerArray();
    aLab.AddAttribute(anIntArrAtt);
    if(!anIntArrAtt.IsNull()) {
      Standard_GUID aGuid = anIntArrAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //9. Set TDataStd_IntegerList
    Handle(TDataStd_IntegerList) anIntListAtt = new TDataStd_IntegerList();
    aLab.AddAttribute(anIntListAtt);
    if(!anIntListAtt.IsNull()) {
      Standard_GUID aGuid = anIntListAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //10. Set TDataStd_Name
    Handle(TDataStd_Name) aNameAtt = new TDataStd_Name();
    aLab.AddAttribute(aNameAtt);
    if(!aNameAtt.IsNull()) {
      Standard_GUID aGuid = aNameAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //11. Set TDataStd_Real
    Handle(TDataStd_Real) aRealAtt = new TDataStd_Real();
    aLab.AddAttribute(aRealAtt);
    if(!aRealAtt.IsNull()) {
      Standard_GUID aGuid = aRealAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //12. Set TDataStd_RealArray
    Handle(TDataStd_RealArray) aRealArrAtt = new TDataStd_RealArray();
    aLab.AddAttribute(aRealArrAtt);
    if(!aRealArrAtt.IsNull()) {
      Standard_GUID aGuid = aRealArrAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //13. Set TDataStd_RealList
    Handle(TDataStd_RealList) aRealListAtt = new TDataStd_RealList();
    aLab.AddAttribute(aRealListAtt);
    if(!aRealListAtt.IsNull()) {
      Standard_GUID aGuid = aRealListAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //14. Set TDataStd_ReferenceArray
    Handle(TDataStd_ReferenceArray) aRefArrAtt = new TDataStd_ReferenceArray();
    aLab.AddAttribute(aRefArrAtt);
    if(!aRefArrAtt.IsNull()) {
      Standard_GUID aGuid = aRefArrAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }

    //15. Set TDataStd_ReferenceList
    Handle(TDataStd_ReferenceList) aRefListAtt = new TDataStd_ReferenceList();
    aLab.AddAttribute(aRefListAtt);
    if(!aRefListAtt.IsNull()) {
      Standard_GUID aGuid = aRefListAtt->ID();
      IsNullGuid = IsSameGuid(aNullGuid, aGuid);
    }
  } catch (...)
  {
    IsNullGuid = Standard_True;
  }
  QCOMPARE (IsNullGuid, Standard_False);
  anApp->Close(aDoc);
  return 0;
}

#include <NCollection_DoubleMap.hxx>
#include <NCollection_IndexedMap.hxx>
#include <NCollection_DataMap.hxx>
#include <NCollection_IndexedDataMap.hxx>
#include <OSD_MemInfo.hxx>

// check that copying of empty maps does not allocate extra memory
template<typename T> void AllocDummyArr (Draw_Interpretor& theDI, int theN1, int theN2)
{
  NCollection_Array1<T> aMapArr1(0, theN1), aMapArr2(0, theN2);

  OSD_MemInfo aMemTool;
  Standard_Size aMem0 = aMemTool.Value (OSD_MemInfo::MemHeapUsage);

  for (int i = 1; i < theN1; i++)
    aMapArr1(i) = aMapArr1(i-1);
  for (int i = 1; i < theN2; i++)
    aMapArr2(i) = aMapArr2(0);

  aMemTool.Update();
  Standard_Size aMem1 = aMemTool.Value (OSD_MemInfo::MemHeapUsage);

  theDI << "Heap usage before copy = " << (int)aMem0 << ", after = " << (int)aMem1 << "\n";
  
  if (aMem1 > aMem0)
    theDI << "Error: memory increased by " << (int)(aMem1 - aMem0) << " bytes\n";
}

static Standard_Integer OCC29064 (Draw_Interpretor& theDI, Standard_Integer theArgc, const char** theArgv)
{
  if (theArgc < 2)
  {
    std::cout << "Error: give argument indicating type of map (map, doublemap, datamap, indexedmap, indexeddatamap)" << std::endl;
    return 1;
  }

  const int nbm1 = 10000, nbm2 = 10000;
  if (strcasecmp (theArgv[1], "map") == 0)
    AllocDummyArr<NCollection_Map<int> > (theDI, nbm1, nbm2);
  else if (strcasecmp (theArgv[1], "doublemap") == 0)
    AllocDummyArr<NCollection_DoubleMap<int, int> > (theDI, nbm1, nbm2);
  else if (strcasecmp (theArgv[1], "datamap") == 0)
    AllocDummyArr<NCollection_DataMap<int, int> > (theDI, nbm1, nbm2);
  else if (strcasecmp (theArgv[1], "indexedmap") == 0)
    AllocDummyArr<NCollection_IndexedMap<int> > (theDI, nbm1, nbm2);
  else if (strcasecmp (theArgv[1], "indexeddatamap") == 0)
    AllocDummyArr<NCollection_IndexedDataMap<int, int> > (theDI, nbm1, nbm2);
  else
  {
    std::cout << "Error: unrecognized argument " << theArgv[1] << std::endl;
    return 1;
  }
  return 0;
}

#include <BRepOffsetAPI_MakePipeShell.hxx>
#include <GC_MakeArcOfCircle.hxx>
#include <BRepAdaptor_CompCurve.hxx>
#include <gp_Circ.hxx>
//=======================================================================
//function : OCC29430
//purpose  : 
//=======================================================================
static Standard_Integer OCC29430(Draw_Interpretor& theDI,
                                 Standard_Integer /*theNArg*/,
                                 const char** theArgVal)
{
  const Standard_Real r45 = M_PI / 4.0, r225 = 3.0*M_PI / 4.0;

  GC_MakeArcOfCircle arcMaker(gp_Circ(gp_Ax2(gp_Pnt(0.0, 0.0, 0.0), gp_Dir(0.0, 0.0, 1.0), gp_Dir(1.0, 0.0, 0.0)), 1.0), r45, r225, Standard_True);
  BRepBuilderAPI_MakeEdge edgeMaker(arcMaker.Value());
  BRepBuilderAPI_MakeWire wireMaker(edgeMaker.Edge());
  const TopoDS_Wire circle = wireMaker.Wire();

  DBRep::Set(theArgVal[1], circle);

  BRepAdaptor_CompCurve curve(circle);
  theDI << "Curve.FirstParameter() = " << curve.FirstParameter() << "\n";
  theDI << "Curve.LastParameter() = " << curve.LastParameter() << "\n";
  theDI << "Curve.Period() = " << (curve.IsPeriodic()? curve.Period() : 0.0) << "\n";
  const gp_Pnt aStartPt = curve.Value(curve.FirstParameter());
  const gp_Pnt anEndPt = curve.Value(curve.LastParameter());

  DrawTrSurf::Set(theArgVal[2], aStartPt);
  DrawTrSurf::Set(theArgVal[3], anEndPt);

  return 0;
}

#include <STEPCAFControl_Reader.hxx>

//=======================================================================
//function : OCC29531
//purpose  : 
//=======================================================================
static Standard_Integer OCC29531(Draw_Interpretor&, Standard_Integer, const char** theArgV)
{
  Handle(TDocStd_Application) anApp = DDocStd::GetApplication();
  Handle(TDocStd_Document) aDoc;
  anApp->NewDocument("BinOcaf", aDoc);
  aDoc->SetUndoLimit(1);

  STEPCAFControl_Reader Reader;
  Reader.ReadFile(theArgV[1]);
  Reader.Transfer(aDoc);
  TDF_Label aShL, aDL;
  TDF_Tool::Label(aDoc->GetData(), "0:1:1:2:672", aShL);
  TDF_Tool::Label(aDoc->GetData(), "0:1:4:10", aDL);

  aDoc->OpenCommand();

  Handle(XCAFDoc_DimTolTool) aDimTolTool = XCAFDoc_DocumentTool::DimTolTool(aDoc->Main());
  aDimTolTool->SetDimension(aShL, aDL);

  aDoc->CommitCommand();

  aDoc->Undo();
  aDoc->Redo();
  return 0;
}

//=======================================================================
//function : OCC29807
//purpose  : 
//=======================================================================
#include <GeomAdaptor_Surface.hxx>
#include <IntPatch_PointLine.hxx>
#include <IntSurf_PntOn2S.hxx>
static Standard_Integer OCC29807(Draw_Interpretor& theDI, Standard_Integer theNArg, const char** theArgV)
{
  if (theNArg != 7)
  {
    theDI << "Use: " << theArgV[0] << "surface1 surface2 u1 v1 u2 v2\n";
    return 1;
  }

  const Handle(Geom_Surface) aS1 = DrawTrSurf::GetSurface(theArgV[1]);
  const Handle(Geom_Surface) aS2 = DrawTrSurf::GetSurface(theArgV[2]);

  if (aS1.IsNull() || aS2.IsNull())
  {
    theDI << "Error. Null surface is not supported.\n";
    return 1;
  }

  const Standard_Real aU1 = Draw::Atof(theArgV[3]);
  const Standard_Real aV1 = Draw::Atof(theArgV[4]);
  const Standard_Real aU2 = Draw::Atof(theArgV[5]);
  const Standard_Real aV2 = Draw::Atof(theArgV[6]);

  const Handle(GeomAdaptor_Surface) anAS1 = new GeomAdaptor_Surface(aS1);
  const Handle(GeomAdaptor_Surface) anAS2 = new GeomAdaptor_Surface(aS2);

  const gp_Pnt aP1 = anAS1->Value(aU1, aV1);
  const gp_Pnt aP2 = anAS2->Value(aU2, aV2);

  if (aP1.SquareDistance(aP2) > Precision::SquareConfusion())
  {
    theDI << "Error. True intersection point must be specified. "
             "Please check parameters: u1 v1 u2 v2.\n";
    return 1;
  }

  IntSurf_PntOn2S aPOn2S;
  aPOn2S.SetValue(0.5*(aP1.XYZ() + aP2.XYZ()), aU1, aV1, aU2, aV2);

  const Standard_Real aCurvatureRadius = IntPatch_PointLine::CurvatureRadiusOfIntersLine(anAS1, anAS2, aPOn2S);
  theDI << "Radius of curvature is " << aCurvatureRadius << "\n";
  return 0;
}

//=======================================================================
//function : OCC29925
//purpose  : check safety of functions like IsSpace(), LowerCase(), etc. for all chars
//=======================================================================
static Standard_Integer OCC29925 (Draw_Interpretor& theDI, Standard_Integer, const char**)
{
  // iterate by all valid ASCII chars (including extended)
  for (int i = 0; i < 256; i++)
  {
    Standard_Character c = (char)(unsigned char)i;
//    if (c != i) theDI << c << " != " << i << "\n";
    const char* anOp = "";
    try {
      anOp = "IsAlphabetic";
      IsAlphabetic (c);
      anOp = "IsDigit";
      IsDigit (c);
      anOp = "IsXDigit";
      IsXDigit (c);
      anOp = "IsAlphanumeric";
      IsAlphanumeric (c);
      anOp = "IsControl";
      IsControl (c);
      anOp = "IsGraphic";
      IsGraphic (c);
      anOp = "IsLowerCase";
      IsLowerCase (c);
      anOp = "IsPrintable";
      IsPrintable (c);
      anOp = "IsPunctuation";
      IsPunctuation (c);
      anOp = "IsSpace";
      IsSpace (c);
      anOp = "IsUpperCase";
      IsUpperCase (c);
      anOp = "LowerCase";
      LowerCase (c);
      anOp = "UpperCase";
      UpperCase (c);
    }
    catch (const Handle(Standard_Failure)& e)
    {
      theDI << anOp << "() fails for " << c << " (" << e->DynamicType()->Name() << ")\n";
    }
  }

  return 0;
}

//=======================================================================
//function : OCC29311
//purpose  : check performance of OBB calculations
//=======================================================================
static Standard_Integer OCC29311 (Draw_Interpretor& theDI, Standard_Integer theArgc, const char** theArgv)
{
  if (theArgc < 4)
  {
    std::cerr << "Use: " << theArgv[0] << " shape counter_name nb_iterations" << std::endl;
    return 1;
  }

  TopoDS_Shape aShape = DBRep::Get (theArgv[1]);
  Standard_Integer aNbIter = Draw::Atoi (theArgv[3]);

  Bnd_OBB anOBB;
  OSD_Timer aTimer;
  aTimer.Start ();
  for (Standard_Integer aN = aNbIter; aN > 0; --aN)
  {
    anOBB.SetVoid ();
    BRepBndLib::AddOBB (aShape, anOBB, Standard_False, Standard_False, Standard_False);
  }
  aTimer.Stop ();

  theDI << "COUNTER " << theArgv[2] << ": " << aTimer.ElapsedTime() << "\n";

  return 0;
}

//=======================================================================
//function : OCC30391
//purpose  : 
//=======================================================================
#include <BRepOffset_Tool.hxx>
static Standard_Integer OCC30391(Draw_Interpretor& theDI,
                                 Standard_Integer theNArg,
                                 const char** theArgV)
{
  if (theNArg < 7)
  {
    theDI << "Use: " << theArgV[0] << "result face LenBeforeUfirst LenAfterUlast LenBeforeVfirst LenAfterVlast\n";
    return 1;
  }

  TopoDS_Shape aShape = DBRep::Get(theArgV[2], TopAbs_FACE);
  if (aShape.IsNull())
    return 1;

  const TopoDS_Face& aFace = TopoDS::Face(aShape);

  Standard_Real aLenBeforeUfirst = atof(theArgV[3]);
  Standard_Real aLenAfterUlast   = atof(theArgV[4]);
  Standard_Real aLenBeforeVfirst = atof(theArgV[5]);
  Standard_Real aLenAfterVlast   = atof(theArgV[6]);

  TopoDS_Face Result;
  BRepOffset_Tool::EnLargeFace(aFace, Result,
                               Standard_True,Standard_True,Standard_True,Standard_True,Standard_True,1,
                               aLenBeforeUfirst, aLenAfterUlast,
                               aLenBeforeVfirst, aLenAfterVlast);

  DBRep::Set(theArgV[1], Result);
  return 0;
}

#include <Standard_Mutex.hxx>
#include <NCollection_Sequence.hxx>
#include <BinLDrivers.hxx>
#include <BinDrivers.hxx>
#include <XmlLDrivers.hxx>
#include <XmlDrivers.hxx>
#include <StdLDrivers.hxx>
#include <StdDrivers.hxx>
#include <TDF_ChildIterator.hxx>
#include <TDocStd_PathParser.hxx>
#include <OSD.hxx>
#include <OSD_Thread.hxx>
#include <OSD_Environment.hxx>
typedef NCollection_Sequence <TCollection_AsciiString> SequenceOfDocNames;

typedef struct
{
  Standard_ThreadId ID;
  int iThread;  
  TCollection_AsciiString inFile[3];
  TCollection_AsciiString outFile[2];
  bool finished;
  int* res;
} Args;

static void printMsg(const char* msg)
{
  printf("%s\n", msg);
}

static Standard_Integer nbREP(50);

void* threadFunction(void* theArgs)
{
  Args* args = (Args*)theArgs;
  try
  {
    if(args->inFile[0].IsEmpty())
    {
      *(args->res) = -1;
      return args->res;
    }

    Handle(TDocStd_Application) anApp = new TDocStd_Application();
    OCC_CATCH_SIGNALS;
    BinLDrivers::DefineFormat(anApp);
    BinDrivers::DefineFormat(anApp);
    XmlLDrivers::DefineFormat(anApp);
    XmlDrivers::DefineFormat(anApp);
    StdLDrivers::DefineFormat(anApp);
    StdDrivers::DefineFormat(anApp);

    for (int aFileIndex = 0; aFileIndex < 3; aFileIndex++)
    {
      TCollection_AsciiString aDocName = args->inFile[aFileIndex];
      Handle(TDocStd_Document) aDoc;
      for (int i = 1; i <= nbREP; i++) {

        PCDM_ReaderStatus aStatus = anApp->Open(aDocName, aDoc);
        if (aStatus != PCDM_RS_OK) {
          args->finished = true;
          *(args->res) = -1;
          return args->res;
        }
        else {
          TDF_Label aLabel = aDoc->Main();
          TDF_ChildIterator anIt(aLabel, Standard_True);
          for (; anIt.More(); anIt.Next()) {
            const TDF_Label& aLab = anIt.Value();
            Handle(TDataStd_AsciiString) anAtt;
            aLab.FindAttribute(TDataStd_AsciiString::GetID(), anAtt);
            if (!anAtt.IsNull()) {
              TCollection_AsciiString aStr = anAtt->Get();
              if (aStr.IsEqual(aDocName)) {
                *(args->res) = (int)aLab.Tag();
                break;
              }
            }
          }

          if (aFileIndex != 2) {
            TCollection_AsciiString anOutDocName = args->outFile[aFileIndex];
            anApp->SaveAs(aDoc, anOutDocName);
          }
          anApp->Close(aDoc);
        }
      }
    }
    args->finished = true;
  }
  catch (...)
  {
    args->finished = true;
    *(args->res) = -1;
    return args->res;
  }
  args->finished = true;
  return args->res;
}

int getNumCores()
{
#ifdef WIN32
  SYSTEM_INFO sysinfo;
  GetSystemInfo(&sysinfo);
  return sysinfo.dwNumberOfProcessors;
#elif MACOS
  int nm[2];
  size_t len = 4;
  uint32_t count;

  nm[0] = CTL_HW; nm[1] = HW_AVAILCPU;
  sysctl(nm, 2, &count, &len, NULL, 0);

  if (count < 1) {
    nm[1] = HW_NCPU;
    sysctl(nm, 2, &count, &len, NULL, 0);
    if (count < 1) { count = 1; }
  }
  return count;
#else
  return sysconf(_SC_NPROCESSORS_ONLN);
#endif
}

//=======================================================================
//function : OCC29195
//purpose  : 
//=======================================================================
static Standard_Integer OCC29195(Draw_Interpretor&, Standard_Integer theArgC, const char** theArgV)
{
  if (theArgC < 2)
  {
    std::cout << "\nOCC29195 [nbRep] doc1.cbf doc1.xml doc1.std outDoc1.cbf outDoc1.xml doc2.cbf doc2.xml doc2.std outDoc2.cbf outDoc2.xml ...], where:";
    std::cout << "\nnbRep - number repetitions of a thread function (by default - 50)";
    std::cout << "\ndocN - names (5 in each group) of OCAF documents names (3 input files, 2 output)\n" << std::endl;
    return 1;
  }
  int iThread(0), nbThreads(0), off(0);
  if (TCollection_AsciiString(theArgV[1]).IsIntegerValue())
  {
    nbREP = TCollection_AsciiString(theArgV[1]).IntegerValue();
    off = 1;
  }
  if (theArgC - off - 1 < 5 || (theArgC - off - 1) % 5 != 0 )
  {
    printMsg("TEST is FAILED: number of arguments is invalid\n");
    return 0;
  }
  Standard_Integer aNbFiles = (theArgC - off - 1) / 5;
  nbThreads = getNumCores();
  if (aNbFiles < nbThreads)
  {
    nbThreads = aNbFiles;
  }
  // Allocate data
  Args* args = new Args[nbThreads];
  OSD_Thread* threads = new OSD_Thread[nbThreads];
  while (iThread < nbThreads)
  {
    if (iThread < aNbFiles)
    {      
      args[iThread].inFile[0] = theArgV[iThread * 5 + off + 1];
      args[iThread].inFile[1] = theArgV[iThread * 5 + off + 2];
      args[iThread].inFile[2] = theArgV[iThread * 5 + off + 3];
      args[iThread].outFile[0] = theArgV[iThread * 5 + off + 4];
      args[iThread].outFile[1] = theArgV[iThread * 5 + off + 5];
    }
    args[iThread].iThread = iThread;
    args[iThread].ID = threads[iThread].GetId();
    args[iThread].finished = false;
    args[iThread].res = new int;
    threads[iThread].SetFunction(&threadFunction);
    iThread++;
  }
  for (iThread = 0; iThread < nbThreads; iThread++)
  {
    args[iThread].finished = false;
    threads[iThread].Run((void*)&(args[iThread]));
  }
  // Sleep while the threads are run.
  bool finished = false;
  while (!finished)
  {
    OSD::MilliSecSleep(100);
    finished = true;
    for (iThread = 0; iThread < nbThreads && finished; iThread++)
    {
      finished = args[iThread].finished;
    }
  }
  OSD_Environment anEnv("Result29195");
  for (iThread = 0; iThread < nbThreads; iThread++)
  {
    if (*(args[iThread].res) == -1)
    {
      printMsg("OCC29195 is FAILED\n");
      anEnv.SetValue("FAILED_ERR");
      break;
    }
  }
  if (iThread == nbThreads)
  {
    printMsg("OCC29195 is finished OK\n");
    anEnv.SetValue("OK");
  }
  anEnv.Build();
  return 0;
}

//=======================================================================
//function : QAStartsWith string startstring
//=======================================================================
static Standard_Integer QAStartsWith(Draw_Interpretor& di, Standard_Integer n, const char** a)
{
  if (n == 3)
  {
    TCollection_ExtendedString str = a[1];
    TCollection_ExtendedString startstr = a[2];
    if (str.StartsWith(startstr))
      di << "Yes";
    else
      di << "No";
    return 0;
  }
  std::cerr << "Syntax error\n";
  return 1;
}

//=======================================================================
//function : QAEndsWith string endstring
//=======================================================================
static Standard_Integer QAEndsWith(Draw_Interpretor& di, Standard_Integer n, const char** a)
{
  if (n == 3)
  {
    TCollection_ExtendedString str = a[1];
    TCollection_ExtendedString endstr = a[2];
    if (str.EndsWith(endstr))
      di << "Yes";
    else
      di << "No";
    return 0;
  }
  std::cerr << "Syntax error\n";
  return 1;
}

//Class is used in OCC30435
#include <AppCont_Function.hxx>
#include <Adaptor3d_Curve.hxx>
class CurveEvaluator : public AppCont_Function

{

public:
  Handle(Adaptor3d_Curve) myCurve;

  CurveEvaluator(const Handle(Adaptor3d_Curve)& C)
    : myCurve(C)
  {
    myNbPnt = 1;
    myNbPnt2d = 0;
  }

  Standard_Real FirstParameter() const
  {
    return myCurve->FirstParameter();
  }

  Standard_Real LastParameter() const
  {
    return myCurve->LastParameter();
  }

  Standard_Boolean Value(const Standard_Real   theT,
    NCollection_Array1<gp_Pnt2d>& /*thePnt2d*/,
    NCollection_Array1<gp_Pnt>&   thePnt) const
  {
    thePnt(1) = myCurve->Value(theT);
    return Standard_True;
  }

  Standard_Boolean D1(const Standard_Real   theT,
    NCollection_Array1<gp_Vec2d>& /*theVec2d*/,
    NCollection_Array1<gp_Vec>&   theVec) const
  {
    gp_Pnt aDummyPnt;
    myCurve->D1(theT, aDummyPnt, theVec(1));
    return Standard_True;
  }
};

#include <GeomAdaptor_Curve.hxx>
#include <Approx_FitAndDivide.hxx>
#include <Convert_CompBezierCurvesToBSplineCurve.hxx>
static Standard_Integer OCC30435(Draw_Interpretor& di, Standard_Integer, const char** a)
{

  Handle(Geom_Curve) GC;
  GC = DrawTrSurf::GetCurve(a[2]);
  if (GC.IsNull())
    return 1;

  Standard_Integer Dmin = 3;
  Standard_Integer Dmax = 12;
  Standard_Real Tol3d = 1.e-7;
  Standard_Boolean inverse = Standard_True;


  Standard_Integer inv = atoi(a[3]);
  if (inv > 0)
  {
    inverse = Standard_True;
  }
  else
  {
    inverse = Standard_False;
  }

  Standard_Integer maxit = atoi(a[4]);

  Handle(GeomAdaptor_Curve) aGAC = new GeomAdaptor_Curve(GC);

  CurveEvaluator aCE(aGAC);

  Approx_FitAndDivide anAppro(Dmin, Dmax, Tol3d, 0., Standard_True);
  anAppro.SetInvOrder(inverse);
  Standard_Integer i;
  for (i = 1; i <= maxit; ++i)
    anAppro.Perform(aCE);

  if (!anAppro.IsAllApproximated())
  {
    di << "Approximation failed \n";
    return 1;
  }
  Standard_Integer NbCurves = anAppro.NbMultiCurves();

  Convert_CompBezierCurvesToBSplineCurve Conv;

  Standard_Real tol3d, tol2d, tolreached = 0.;
  for (i = 1; i <= NbCurves; i++) {
    anAppro.Error(i, tol3d, tol2d);
    tolreached = Max(tolreached, tol3d);
    AppParCurves_MultiCurve MC = anAppro.Value(i);
    TColgp_Array1OfPnt Poles(1, MC.Degree() + 1);
    MC.Curve(1, Poles);
    Conv.AddCurve(Poles);
  }
  Conv.Perform();
  Standard_Integer NbPoles = Conv.NbPoles();
  Standard_Integer NbKnots = Conv.NbKnots();

  TColgp_Array1OfPnt      NewPoles(1, NbPoles);
  TColStd_Array1OfReal    NewKnots(1, NbKnots);
  TColStd_Array1OfInteger NewMults(1, NbKnots);

  Conv.KnotsAndMults(NewKnots, NewMults);
  Conv.Poles(NewPoles);

  BSplCLib::Reparametrize(GC->FirstParameter(),
    GC->LastParameter(),
    NewKnots);
  Handle(Geom_BSplineCurve) TheCurve = new Geom_BSplineCurve(NewPoles, NewKnots, NewMults, Conv.Degree());

  DrawTrSurf::Set(a[1], TheCurve);
  di << a[1] << ": tolreached = " << tolreached << "\n";

  return 0;

}

//=======================================================================
//function : OCC30708_1 
//purpose  : Tests initialization of the TopoDS_Iterator with null shape
//=======================================================================
static Standard_Integer OCC30708_1 (Draw_Interpretor& di, Standard_Integer, const char**)
{
  TopoDS_Iterator it;
  try
  {
    OCC_CATCH_SIGNALS

    TopoDS_Shape empty;
    it.Initialize (empty);

  }
  catch (const Standard_Failure&)
  {
    di << "Cannot initialize TopoDS_Iterator with null shape\n";
    return 0;
  }

  if (it.More())
    di << "Incorrect Iterator initialization: method More() returns true on null shape\n";

  return 0;
}

//=======================================================================
//function : OCC30708_2
//purpose  : Tests initialization of the BRepLib_MakeWire with null wire
//=======================================================================
static Standard_Integer OCC30708_2 (Draw_Interpretor& di, Standard_Integer, const char**)
{
  try
  {
    OCC_CATCH_SIGNALS

    TopoDS_Wire empty;
    BRepLib_MakeWire aWBuilder (empty);
  }
  catch (const Standard_Failure&)
  {
    di << "Cannot initialize BRepLib_MakeWire with null wire\n";
  }

  return 0;
}

//=======================================================================
//function : OCC30747
//purpose  :
//=======================================================================
#include <Geom2d_Circle.hxx>
#include <GCE2d_MakeCircle.hxx>
#include <Geom2d_TrimmedCurve.hxx>
#include <Geom2dConvert_CompCurveToBSplineCurve.hxx>
static Standard_Integer OCC30747(Draw_Interpretor& theDI, Standard_Integer theArgc, const char** theArgV)
{
  if (theArgc < 2)
  {
    return 1;
  }

  const Handle(Geom2d_Circle) aCirc = GCE2d_MakeCircle(gp_Pnt2d(0, 0), 50);

  Standard_Real aF = aCirc->FirstParameter();
  Standard_Real aL = aCirc->LastParameter();
  Standard_Real aNb = 10;
  Standard_Real aDelta = (aF + aL) / aNb;
  Handle(Geom2d_TrimmedCurve) aFTrim = new Geom2d_TrimmedCurve(aCirc, aF, aDelta);
  Geom2dConvert_CompCurveToBSplineCurve aRes(aFTrim);
  for (Standard_Integer anId = 1; anId < aNb; anId++)
  {
    Handle(Geom2d_TrimmedCurve) aLTrim;
    if (anId == (aNb - 1))
    {
      aLTrim = new Geom2d_TrimmedCurve(aCirc, anId * aDelta, aF);
    }
    else
    {
      aLTrim = new Geom2d_TrimmedCurve(aCirc, anId * aDelta, (anId + 1) * aDelta);
    }
    aRes.Add(aLTrim, Precision::PConfusion());
  }

  if (!aRes.BSplineCurve()->IsClosed())
  {
    theDI << "Error: curve isn't closed";
    return 1;
  }

  DrawTrSurf::Set(theArgV[1], aRes.BSplineCurve());
  return 0;
}

//=======================================================================
//function : OCC30869
//purpose  :
//=======================================================================
static Standard_Integer OCC30869 (Draw_Interpretor& theDI, Standard_Integer theArgc, const char** theArgv)
{
  if (theArgc != 2)
  {
    theDI.PrintHelp (theArgv[0]);
    return 1;
  }

  TopoDS_Shape aWire = DBRep::Get (theArgv[1]);
  if (aWire.IsNull() || aWire.ShapeType() != TopAbs_WIRE)
  {
    theDI << theArgv[1] << " is not a wire.\n";
    return 1;
  }

  BRepAdaptor_CompCurve aBACC (TopoDS::Wire (aWire));

  Standard_Real aFirst = aBACC.FirstParameter();
  Standard_Real aLast  = aBACC.LastParameter();

  gp_Pnt aPFirst, aPLast;
  gp_Vec aVFirst, aVLast;

  aBACC.D1 (aFirst, aPFirst, aVFirst);
  aBACC.D1 (aLast,  aPLast,  aVLast);

  if (aVFirst.SquareMagnitude() > gp::Resolution())
    aVFirst.Normalize();
  if (aVLast.SquareMagnitude() > gp::Resolution())
    aVLast.Normalize();

  theDI << aFirst << ": point " << aPFirst.X() << " "
                                << aPFirst.Y() << " "
                                << aPFirst.Z()
                  << ", tangent " << aVFirst.X() << " "
                                  << aVFirst.Y() << " "
                                  << aVFirst.Z() << "\n";

  theDI << aLast << ": point " << aPLast.X() << " "
                              << aPLast.Y() << " "
                              << aPLast.Z()
                 << ", tangent " << aVLast.X() << " "
                                 << aVLast.Y() << " "
                                 << aVLast.Z() << "\n";

  return 0;
}

#include <BRepExtrema_ExtCF.hxx>
//=======================================================================
//function : OCC30880
//purpose  :
//=======================================================================
static Standard_Integer OCC30880 (Draw_Interpretor& theDI, Standard_Integer theArgc, const char** theArgv)
{
  if (theArgc != 3)
  {
    theDI.PrintHelp (theArgv[0]);
    return 1;
  }

  TopoDS_Shape anEdge = DBRep::Get (theArgv[1]);
  if (anEdge.IsNull() || anEdge.ShapeType() != TopAbs_EDGE)
  {
    theDI << theArgv[1] << " is not an edge.\n";
    return 1;
  }

  TopoDS_Shape aFace = DBRep::Get (theArgv[2]);
  if (aFace.IsNull() || aFace.ShapeType() != TopAbs_FACE)
  {
    theDI << theArgv[2] << " is not a face.\n";
    return 1;
  }

  BRepExtrema_ExtCF anExtCF (TopoDS::Edge (anEdge),
                             TopoDS::Face (aFace));
  if (!anExtCF.IsDone())
  {
    theDI << "Not done\n";
    return 0;
  }

  if (!anExtCF.NbExt())
  {
    theDI << "No solutions\n";
    return 0;
  }

  if (anExtCF.IsParallel())
  {
    theDI << "Infinite number of solutions, distance - " << Sqrt (anExtCF.SquareDistance (1)) << "\n";
    return 0;
  }

  Standard_Real aDistMin = RealLast();
  Standard_Integer aSolMin = -1;
  // Look for the minimal solution
  for (int i = 1; i <= anExtCF.NbExt(); ++i)
  {
    Standard_Real aDist = anExtCF.SquareDistance (i);
    if (aDist < aDistMin)
    {
      aDistMin = aDist;
      aSolMin = i;
    }
  }

  if (aSolMin < 0)
  {
    theDI << "Failed\n";
    return 0;
  }

  theDI << "Minimal distance - " << Sqrt (aDistMin) << "\n";
  return 0;
}

#include <BRepPrimAPI_MakeBox.hxx>
static Standard_Integer OCC30704(Draw_Interpretor& di, Standard_Integer, const char**)
{
  // Make a shape somewhere far from (0, 0, 0).
  BRepPrimAPI_MakeBox mkBox(gp_Pnt(100, 100, 100), 100, 100, 100);
  const TopoDS_Shape& box = mkBox.Shape();

  // Add a bounding box of a shape to a void bounding box.
  Bnd_OBB aVoidBox, aBox;
  BRepBndLib::AddOBB(box, aBox, Standard_False, Standard_False, Standard_False);
  aVoidBox.Add(aBox);

  // Print the center point of the bounding box.
  const gp_XYZ& center = aVoidBox.Center();
  di << center.X() << " " << center.Y() << " " << center.Z();
  return 0;
}
static Standard_Integer OCC30704_1(Draw_Interpretor& di, Standard_Integer, const char**)
{
  // A point.
  gp_Pnt aP(100, 200, 300);

  // Add the point to a void bounding box.
  Bnd_OBB aVoidBox;
  aVoidBox.Add(aP);

  // Print the center point of the bounding box.
  const gp_XYZ& center = aVoidBox.Center();
  di << center.X() << " " << center.Y() << " " << center.Z();
  return 0;
}

//=======================================================================
//function : OCC30990
//purpose  : check consistency of implementation of cache in B-Spline surfaces
//           with respect to update of the cache for points located exactly
//           on boundary between bspline spans (i.e. at knots)
//=======================================================================
static Standard_Integer OCC30990 (Draw_Interpretor& theDI, Standard_Integer theNArg, const char** theArgV)
{
  if (theNArg != 2)
  {
    std::cerr << "Use: " << theArgV[0] << "surface\n";
    return 1;
  }

  const Handle(Geom_BSplineSurface) aSurf = 
    Handle(Geom_BSplineSurface)::DownCast (DrawTrSurf::GetSurface(theArgV[1]));
  if (aSurf.IsNull())
  {
    theDI << "Error: " << theArgV[1] << " is not a B-Spline surface";
    return 0;
  }
  GeomAdaptor_Surface aS (aSurf);

  // Evaluate points for U and V located exactly at b-spline knots,
  // after evaluation of points inside the spans before and after the knot,
  // and ensure that result at the knot is exactly the same regardless
  // of previous evaluation (i.e. the cache is updated as necessary).
  // Note: the points (D0) computed on different spans are slightly different
  // due to rounding, which allows us to detect this situation without
  // analysis of higher derivatives (which would show non-negligible difference).
  Standard_Integer aNbErr = 0;

  theDI << "U knots: ";
  for (int i = 1; i <= aSurf->NbUKnots(); i++)
  {
    theDI << aSurf->UKnot(i);
    if (i < aSurf->NbUKnots()) theDI << ",";
  }
  theDI << "\n";
  for (int i = 2; i < aSurf->NbUKnots(); i++)
  {
    Standard_Real aUknot = aSurf->UKnot(i);
    Standard_Real aUprev = 0.5 * (aUknot + aSurf->UKnot(i-1));
    Standard_Real aUnext = 0.5 * (aUknot + aSurf->UKnot(i+1));
    for (int j = 1; j < aSurf->NbVKnots(); j++)
    {
      Standard_Real aV = 0.5 * (aSurf->VKnot(j) + aSurf->VKnot(j + 1));
      aS.Value (aUprev, aV);
      gp_Pnt aValue1 = aS.Value (aUknot, aV);
      aS.Value (aUnext, aV);
      gp_Pnt aValue2 = aS.Value (aUknot, aV);
      for (int k = 1; k <= 3; k++)
      {
        if (aValue1.Coord(k) != aValue2.Coord(k))
        {
          Standard_SStream aStr;
          aStr.precision(20);
          aStr << "Error evaluating point at UV = (" << aUknot << ", " << aV << "):\n";
          aStr << "probe 1: " << (char)('X' + k - 1) << " = " << aValue1.Coord(k) << "\n";
          aStr << "probe 2: " << (char)('X' + k - 1) << " = " << aValue2.Coord(k) << "\n";
          theDI << aStr.str().c_str();
          aNbErr++;
        }
      }
    }
  }

  theDI << "V knots: ";
  for (int j = 1; j <= aSurf->NbVKnots(); j++)
  {
    theDI << aSurf->VKnot(j);
    if (j < aSurf->NbVKnots()) theDI << ",";
  }
  theDI << "\n";
  for (int j = 2; j < aSurf->NbVKnots(); j++)
  {
    Standard_Real aVknot = aSurf->VKnot(j);
    Standard_Real aVprev = 0.5 * (aVknot + aSurf->VKnot(j-1));
    Standard_Real aVnext = 0.5 * (aVknot + aSurf->VKnot(j+1));
    for (int i = 1; i < aSurf->NbUKnots(); i++)
    {
      Standard_Real aU = 0.5 * (aSurf->UKnot(i) + aSurf->UKnot(i + 1));
      aS.Value (aU, aVprev);
      gp_Pnt aValue1 = aS.Value (aU, aVknot);
      aS.Value (aU, aVnext);
      gp_Pnt aValue2 = aS.Value (aU, aVknot);
      for (int k = 1; k <= 3; k++)
      {
        if (aValue1.Coord(k) != aValue2.Coord(k))
        {
          Standard_SStream aStr;
          aStr.precision(20);
          aStr << "Error evaluating point at UV = (" << aU << ", " << aVknot << "):\n";
          aStr << "probe 1: " << (char)('X' + k - 1) << " = " << aValue1.Coord(k) << "\n";
          aStr << "probe 2: " << (char)('X' + k - 1) << " = " << aValue2.Coord(k) << "\n";
          theDI << aStr.str().c_str();
          aNbErr++;
        }
      }
    }
  }

  theDI << "Total " << aNbErr << " deviations detected";
  return 0;
}

//=======================================================================
//function : OCC31294
//purpose  : check list of shapes generated from shape, which is not any subshape
//           of input shape for prism algorithm  
//=======================================================================
#include <BRepPrimAPI_MakePrism.hxx>
#include <BRepBuilderAPI_MakeVertex.hxx>
static Standard_Integer OCC31294(Draw_Interpretor& di, Standard_Integer, const char**)
{
  BRepBuilderAPI_MakeVertex mkVert(gp_Pnt(0., 0., 0.));
  BRepBuilderAPI_MakeVertex mkDummy(gp_Pnt(0., 0., 0.));
  BRepPrimAPI_MakePrism mkPrism(mkVert.Shape(), gp_Vec(0., 0., 1.));

  Standard_Integer nbgen = mkPrism.Generated(mkVert.Shape()).Extent();
  Standard_Integer nbdummy = mkPrism.Generated(mkDummy.Shape()).Extent();

  if (nbgen != 1 || nbdummy != 0)
  {
    di << "Error: wrong generated list \n";
  }

  return 0;
}

#include <ExprIntrp_GenExp.hxx>
#include <Expr_GeneralExpression.hxx>
#include <Expr_NamedUnknown.hxx>
//=======================================================================
//function :  OCC31697
//purpose  : 
//=======================================================================
static Standard_Integer OCC31697(Draw_Interpretor& di, Standard_Integer argc, const char ** argv)
{
  if (argc < 3)
  {
    di << "Usage : " << argv[0] << " expression  variable\n";
    return 1;
  }

  TCollection_AsciiString  anExpStr(argv[1]);
  TCollection_AsciiString  aVarStr(argv[2]);

  Handle(ExprIntrp_GenExp) exprIntrp = ExprIntrp_GenExp::Create();

  //
  // Create the expression
  exprIntrp->Process(anExpStr);

  if (!exprIntrp->IsDone())
  {
    di << "Interpretation of expression " << argv[1] << " failed\n";
    return 1;
  }

  Handle(Expr_GeneralExpression) anExpr = exprIntrp->Expression();
  Handle(Expr_NamedUnknown) aVar = new Expr_NamedUnknown(aVarStr);

  if (!anExpr->Contains(aVar))
  {
    di << "Expression " << argv[1] << " does not contain variable " << argv[2] << "\n";
    return 1;
  }

  Handle(Expr_GeneralExpression) aDer = anExpr->Derivative(aVar);

  TCollection_AsciiString  aDerStr = aDer->String();

  di << "The derivative of the " << argv[1] << " by " << argv[2] << " is equal to " << aDerStr << "\n";

  return 0;
}

#include <TObj_Model.hxx>
#include <TObj_TModel.hxx>
#include <TObj_ObjectIterator.hxx>
//=======================================================================
//function :  OCC31320
//purpose  : 
//=======================================================================
static Standard_Integer OCC31320(Draw_Interpretor& di, Standard_Integer argc, const char ** argv)
{
  if (argc < 3)
  {
    di << "Usage : " << argv[0] << " DocName ObjName\n";
    return 1;
  }
  Handle(TObj_Model) aModel;
  Handle(TDocStd_Document) D;
  if (!DDocStd::GetDocument (argv[1], D)) 
  {
    di << "Error: document " << argv[1] << " not found\n";
    return 1;
  }

  TDF_Label aLabel = D->Main();
  Handle(TObj_TModel) aModelAttr;
  if (!aLabel.IsNull() && aLabel.FindAttribute (TObj_TModel::GetID(), aModelAttr))
    aModel = aModelAttr->Model();

  if (aModel.IsNull())
  {
    di << "Error: TObj model " << argv[1] << " not found\n";
    return 1;
  }

  Handle(TCollection_HExtendedString) aName = new TCollection_HExtendedString (argv[2]);
  Handle(TObj_TNameContainer) aDict;
  Handle(TObj_Object) anObj = aModel->FindObject (aName, aDict);

  if (aModel.IsNull())
  {
    di << "Error: object " << argv[2] << " not found\n";
    return 1;
  }

  // do a test: find the first child of an object, remove object and get the father of this child
  Handle(TObj_ObjectIterator) aChildrenIter = anObj->GetChildren();
  if (!aChildrenIter->More())
  {
    di << "Error: object " << argv[2] << " has no children\n";
    return 1;
  }

  Handle(TObj_Object) aChild = aChildrenIter->Value();
  anObj->Detach();
  Handle(TObj_Object) aFather = aChild->GetFatherObject();
  if (!aFather.IsNull())
  {
    di << "Error: father is not null\n";
    return 1;
  }

  return 0;

}

#include <BinXCAFDrivers.hxx>
#include <Message.hxx>
namespace
{
  class QABugs_XdeLoader : public OSD_Thread
  {
  public:
    QABugs_XdeLoader (const Handle(TDocStd_Application)& theXdeApp,
                      const Handle(TDocStd_Document)&    theXdeDoc,
                      const TCollection_AsciiString&     theFilePath)
    : OSD_Thread (performThread),
      myXdeApp (theXdeApp), myXdeDoc (theXdeDoc), myFilePath (theFilePath) {}

  private:
    void perform()
    {
      Handle(TDocStd_Document) aNewDoc;
      const PCDM_ReaderStatus aReaderStatus = myXdeApp->Open (myFilePath, aNewDoc);
      if (aReaderStatus != PCDM_RS_OK)
      {
        Message::SendFail ("Error occurred while reading the file");
        return;
      }
      myXdeDoc = aNewDoc;
      Message::SendInfo() << "Info: document has been opened";
    }

    static Standard_Address performThread (Standard_Address theData)
    {
      QABugs_XdeLoader* aLoader = (QABugs_XdeLoader* )theData;
      OSD::SetThreadLocalSignal (OSD_SignalMode_Set, false);
      try
      {
        OCC_CATCH_SIGNALS
        aLoader->perform();
      }
      catch (Standard_Failure const& theExcep)
      {
        Message::SendFail() << "Error: unexpected exception " << theExcep;
        return 0;
      }
      return 0;
    }
  private:
    Handle(TDocStd_Application) myXdeApp;
    Handle(TDocStd_Document)    myXdeDoc;
    TCollection_AsciiString     myFilePath;
  };
}

//=======================================================================
//function : OCC31785
//purpose  : Try reading XBF file in background thread
//=======================================================================
static Standard_Integer OCC31785 (Draw_Interpretor& theDI,
                                  Standard_Integer theNbArgs,
                                  const char** theArgVec)
{
  if (theNbArgs != 2)
  {
    theDI << "Syntax error: wrong number of arguments\n";
    return 1;
  }

  TCollection_AsciiString aFileName (theArgVec[1]);

  Handle(TDocStd_Application) anXdeApp = new TDocStd_Application();
  BinXCAFDrivers::DefineFormat (anXdeApp);

  Handle(TDocStd_Document) anXdeDoc;
  anXdeApp->NewDocument (TCollection_ExtendedString ("BinXCAF"), anXdeDoc);
  QABugs_XdeLoader aLoader (anXdeApp, anXdeDoc, aFileName);
  aLoader.Run (&aLoader);
  aLoader.Wait();
  return 0;
}

static Standard_Integer QANullifyShape(Draw_Interpretor& di,
  Standard_Integer n,
  const char** a)
{
  if (n != 2) {
    di << "Wrong usage.\n";
    di << "Usage: QANullifyShape shape\n";
    return 1;
  }
  TopoDS_Shape aShape = DBRep::Get(a[1]);
  aShape.Nullify();
  DBRep::Set(a[1], aShape);
  return 0;
}

static void CheckAx3Dir(gp_Ax3& theAxis, const gp_Dir& theDir)
{
  Standard_Boolean bDirect = theAxis.Direct();
  theAxis.SetDirection (theDir);
  if (bDirect != theAxis.Direct())
  {
    std::cout << "Error: coordinate system is reversed\n";
  }
  if (!theDir.IsEqual(theAxis.Direction(), Precision::Angular()))
  {
    std::cout << "Error: main dir was not set properly\n";
  }
}

static void CheckAx3DirX(gp_Ax3& theAxis, const gp_Dir& theDir)
{
  Standard_Boolean bDirect = theAxis.Direct();
  theAxis.SetXDirection (theDir);
  if (bDirect != theAxis.Direct())
  {
    std::cout << "Error: coordinate system is reversed\n";
  }
  gp_Dir aGoodY = theAxis.Direction().Crossed(theDir);
  if (theAxis.Direct())
  {
    if (!aGoodY.IsEqual(theAxis.YDirection(), Precision::Angular()))
    {
      std::cout << "Error: X dir was not set properly\n";
    }
  }
  else
  {
    if (!aGoodY.IsOpposite(theAxis.YDirection(), Precision::Angular()))
    {
      std::cout << "Error: X dir was not set properly\n";
    }
  }
}

static void CheckAx3DirY(gp_Ax3& theAxis, const gp_Dir& theDir)
{
  Standard_Boolean bDirect = theAxis.Direct();
  theAxis.SetYDirection (theDir);
  if (bDirect != theAxis.Direct())
  {
    std::cout << "Error: coordinate system is reversed\n";
  }
  gp_Dir aGoodX = theAxis.Direction().Crossed(theDir);
  if (theAxis.Direct())
  {
    if (!aGoodX.IsOpposite(theAxis.XDirection(), Precision::Angular()))
    {
      std::cout << "Error: Y dir was not set properly\n";
    }
  }
  else
  {
    if (!aGoodX.IsEqual(theAxis.XDirection(), Precision::Angular()))
    {
      std::cout << "Error: Y dir was not set properly\n";
    }
  }
}

static void CheckAx3Ax1(gp_Ax3& theAx, const gp_Ax1& theAx0)
{
  Standard_Boolean bDirect = theAx.Direct();
  theAx.SetAxis (theAx0);
  if (bDirect != theAx.Direct())
  {
    std::cout << "Error: coordinate system is reversed\n";
  }
  if (!theAx0.Direction().IsEqual(theAx.Direction(), Precision::Angular()))
  {
    std::cout << "Error: main dir was not set properly\n";
  }
}


static Standard_Integer OCC29406 (Draw_Interpretor&, Standard_Integer, const char**)
{
  // Main (Z) direction
  {
   // gp_Ax3::SetDirection() test
    gp_Ax3 anAx1, anAx2, anAx3, anAx4, anAx5, anAx6;
    anAx3.ZReverse();
    anAx4.ZReverse();    
    CheckAx3Dir(anAx1,  gp::DX());
    CheckAx3Dir(anAx2, -gp::DX());
    CheckAx3Dir(anAx3,  gp::DX());
    CheckAx3Dir(anAx4, -gp::DX());
    // gp_Ax3::SetAxis() test
    gp_Ax1 anAx0_1 (gp::Origin(),  gp::DX());
    gp_Ax1 anAx0_2 (gp::Origin(), -gp::DX());
    CheckAx3Ax1(anAx5, anAx0_1);
    CheckAx3Ax1(anAx6, anAx0_2);
  }
  // X direction
  {
    // gp_Ax3::SetXDirection() test
    gp_Ax3 anAx1, anAx2, anAx3, anAx4;
    anAx3.XReverse();
    anAx4.XReverse();
    CheckAx3DirX(anAx1,  gp::DZ());
    CheckAx3DirX(anAx2, -gp::DZ());
    CheckAx3DirX(anAx3,  gp::DZ());
    CheckAx3DirX(anAx4, -gp::DZ());
  }
  // Y direction
  {
    // gp_Ax3::SetYDirection() test
    gp_Ax3 anAx1, anAx2, anAx3, anAx4;
    anAx3.YReverse();
    anAx4.YReverse();
    CheckAx3DirY(anAx1,  gp::DZ());
    CheckAx3DirY(anAx2, -gp::DZ());
    CheckAx3DirY(anAx3,  gp::DZ());
    CheckAx3DirY(anAx4, -gp::DZ());
  }

  return 0;
}

#include <BRepCheck_Analyzer.hxx>
#include <GCPnts_UniformDeflection.hxx>
static Standard_Integer OCC32744(Draw_Interpretor& theDi, Standard_Integer theNbArgs, const char** theArgVec)
{
  if (theNbArgs != 2)
  {
    theDi << "Syntax error: wrong number of arguments!\n";
    return 1;
  }

  const TopoDS_Shape& aShape = DBRep::Get(theArgVec[1]);
  if (aShape.IsNull())
  {
    theDi << " Null Shape is not allowed here\n";
    return 1;
  }
  else if (aShape.ShapeType() != TopAbs_EDGE)
  {
    theDi << " Shape type must be EDGE\n";
    return 1;
  }

  const TopoDS_Edge& anEdge = TopoDS::Edge(aShape);
  BRepCheck_Analyzer analyzer(anEdge);
  if (analyzer.IsValid())
  {
    Standard_Real firstParam = 0., lastParam = 0.;
    Handle(Geom_Curve) pCurve = BRep_Tool::Curve(anEdge, firstParam, lastParam);
    GeomAdaptor_Curve curveAdaptor(pCurve, firstParam, lastParam);
    GCPnts_UniformDeflection uniformAbs(curveAdaptor, 0.001, firstParam, lastParam); 
  }

  return 0;
}


void QABugs::Commands_20(Draw_Interpretor& theCommands) {
  const char *group = "QABugs";

  theCommands.Add ("OCC26675_1", "OCC26675_1 result", __FILE__, SurfaceGenOCC26675_1, group);
  theCommands.Add ("OCC24836", "OCC24836", __FILE__, OCC24836, group);
  theCommands.Add("OCC27021", "OCC27021", __FILE__, OCC27021, group);
  theCommands.Add("OCC27235", "OCC27235", __FILE__, OCC27235, group);
  theCommands.Add("OCC26930", "OCC26930", __FILE__, OCC26930, group);
  theCommands.Add("OCC27466", "OCC27466", __FILE__, OCC27466, group);
  theCommands.Add ("OCC26747_1", "OCC26747_1 result", __FILE__, OCC26747_1, group);
  theCommands.Add ("OCC26747_2", "OCC26747_2 result", __FILE__, OCC26747_2, group);
  theCommands.Add ("OCC26747_3", "OCC26747_3 result", __FILE__, OCC26747_3, group);
  theCommands.Add ("OCC27357", "OCC27357", __FILE__, OCC27357, group);
  theCommands.Add("OCC26270", "OCC26270 shape result", __FILE__, OCC26270, group);
  theCommands.Add ("OCC27552", "OCC27552", __FILE__, OCC27552, group); 
  theCommands.Add("OCC27875", "OCC27875 curve", __FILE__, OCC27875, group);
  theCommands.Add("OCC27884", "OCC27884: Possible improvement for 2d classifier", __FILE__, OCC27884, group);
  theCommands.Add("OCC28389", "OCC28389", __FILE__, OCC28389, group);
  theCommands.Add("OCC28594", "OCC28594", __FILE__, OCC28594, group);
  theCommands.Add("OCC28784", "OCC28784 result shape", __FILE__, OCC28784, group);
  theCommands.Add("OCC28829", "OCC28829: perform invalid FPE operation", __FILE__, OCC28829, group);
  theCommands.Add("OCC28887",
                  "OCC28887 filePath result"
                  "\n\t\t: Check interface for reading BRep from memory.",
                  __FILE__, OCC28887, group);
  theCommands.Add("OCC28131", "OCC28131 name: creates face problematic for offset", __FILE__, OCC28131, group);
  theCommands.Add("OCC29289", "OCC29289 : searching trigonometric root by Newton iterations", __FILE__, OCC29289, group);
  theCommands.Add ("OCC29371", "OCC29371", __FILE__, OCC29371, group);
  theCommands.Add("OCC29430", "OCC29430 <result wire> "
                              "<result first point> <result last point>",
                              __FILE__, OCC29430, group);
  theCommands.Add("OCC29531", "OCC29531 <step file name>", __FILE__, OCC29531, group);

  theCommands.Add ("OCC29064", "OCC29064: test memory usage by copying empty maps", __FILE__, OCC29064, group);
  theCommands.Add ("OCC29925", "OCC29925: check safety of character classification functions", __FILE__, OCC29925, group);
  theCommands.Add("OCC29807", "OCC29807 surface1 surface2 u1 v1 u2 v2", __FILE__, OCC29807, group);
  theCommands.Add("OCC29311", "OCC29311 shape counter nbiter: check performance of OBB calculation", __FILE__, OCC29311, group);
  theCommands.Add("OCC30391", "OCC30391 result face LenBeforeUfirst LenAfterUlast LenBeforeVfirst LenAfterVlast", __FILE__, OCC30391, group);
  theCommands.Add("OCC29195", "OCC29195 [nbRep] doc1 [doc2 [doc3 [doc4]]]", __FILE__, OCC29195, group);
  theCommands.Add("OCC30435", "OCC30435 result curve inverse nbit", __FILE__, OCC30435, group);
  theCommands.Add("OCC30747", "OCC30747: create a closed curve", __FILE__, OCC30747, group);
  theCommands.Add("OCC30990", "OCC30990 surface", __FILE__, OCC30990, group);

  theCommands.Add("QAStartsWith",
                  "QAStartsWith string startstring",
                  __FILE__, QAStartsWith, group);

  theCommands.Add("QAEndsWith",
                  "QAEndsWith string endstring",
                  __FILE__, QAEndsWith, group);

  theCommands.Add ("OCC30708_1", "Tests initialization of the TopoDS_Iterator with null shape",
                   __FILE__, OCC30708_1, group);

  theCommands.Add ("OCC30708_2", "Tests initialization of the BRepLib_MakeWire with null shape",
                   __FILE__, OCC30708_2, group);

  theCommands.Add ("OCC30869", "Prints bounding points of the given wire and tangent vectors at these points.\n"
                               "Usage: OCC30869 wire",
                   __FILE__, OCC30869, group);

  theCommands.Add ("OCC30880", "Looks for extrema between edge and face.\n"
                               "Usage: OCC30880 edge face",
                   __FILE__, OCC30880, group);

  theCommands.Add("OCC30704", "OCC30704", __FILE__, OCC30704, group);
  theCommands.Add("OCC30704_1", "OCC30704_1", __FILE__, OCC30704_1, group);
  theCommands.Add("OCC31294", "OCC31294", __FILE__, OCC31294, group);

  theCommands.Add("OCC31697", "OCC31697 expression variable", __FILE__, OCC31697, group);

  theCommands.Add("OCC31320", "OCC31320 DocName ObjName : tests remove of the children GetFather method if father is removed", __FILE__, OCC31320, group);

  theCommands.Add("OCC31785",
                  "OCC31785 file.xbf : test reading XBF file in another thread",
                  __FILE__, OCC31785, group);


  theCommands.Add("QANullifyShape",
                  "Nullify shape. Usage: QANullifyShape shape",
                  __FILE__, QANullifyShape, group);

  theCommands.Add ("OCC29406", 
                   "Tests the case when newly set axis for gp_Ax3 is parallel to one of current axis", 
                   __FILE__, OCC29406, group);

  theCommands.Add("OCC32744",
                  "Tests avoid Endless loop in GCPnts_UniformDeflection",
                  __FILE__,
                  OCC32744, group);

  return;
}
