/*

Copyright (C) 2020 Olaf Till <i7tiol@t-online.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; If not, see <http://www.gnu.org/licenses/>.

*/

// PKG_ADD: autoload ("__parcellfun_initialize_job__", "__parcellfun_interface__.oct");
// PKG_DEL: autoload ("__parcellfun_initialize_job__", "__parcellfun_interface__.oct", "remove");

#include "parallel-gnutls.h"

namespace octave_parallel
{
  control &get_scheduler (void);
}

DEFUN_DLD (__parcellfun_initialize_job__, args, nargout,
           "-*- texinfo -*-\n\
@deftypefn {Loadable Function} {} __parcellfun_initialize_job__ (@var{fcn}, @var{dir}, @var{nargout}[, @var{eh}])\n\
Undocumented internal function.\n\
\n\
@end deftypefn")
{
  std::string fname ("__parcellfun_initialize_job__");

  octave_value retval;

  if (args.length () < 3 || args.length () > 4
      || ! args(0).is_function_handle ()
      || ! args(1).is_string ()
      || ! args(2).OV_ISREAL ()
      || ! args(2).is_scalar_type ()
      || (args.length () == 4 && ! args(3).is_function_handle ())
      )
    {
      print_usage ();

      return retval;
    }

  octave_value eh;

  if (args.length () == 4)
    {
      eh = args(3);
    }

  octave_parallel::control &sched = octave_parallel::get_scheduler ();

  if (sched.initialize_job (args(0), args(1).string_value (), eh,
                            args(2).int_value())
      || ! sched.good ())
    {
      error ("%s: could not initialize job", fname.c_str ());

      return retval;
    }

  return retval;
}
