// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TDF_ClosureTool_HeaderFile
#define _TDF_ClosureTool_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_TDF_DataSet.hxx>
class TDF_DataSet;
class TDF_IDFilter;
class TDF_ClosureMode;
class TDF_Label;
class TDF_LabelMap;
class TDF_AttributeMap;


//! This class provides services to build the closure
//! of an information set.
//! This class gives services around the transitive
//! enclosure of a set of information, starting from a
//! list of label.
//! You can set closure options by using IDFilter
//! (to select or exclude specific attribute IDs) and
//! CopyOption objects and by giving to Closure
//! method.
class TDF_ClosureTool 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Builds the transitive closure of label and
  //! attribute sets into <aDataSet>.
  Standard_EXPORT static   void Closure (const Handle(TDF_DataSet)& aDataSet) ;
  
  //! Builds the transitive closure of label and
  //! attribute sets into <aDataSet>. Uses <aFilter> to
  //! determine if an attribute has to be taken in
  //! account or not. Uses <aMode> for various way of
  //! closing.
  Standard_EXPORT static   void Closure (const Handle(TDF_DataSet)& aDataSet, const TDF_IDFilter& aFilter, const TDF_ClosureMode& aMode) ;
  
  //! Builds the transitive closure of <aLabel>.
  Standard_EXPORT static   void Closure (const TDF_Label& aLabel, TDF_LabelMap& aLabMap, TDF_AttributeMap& anAttMap, const TDF_IDFilter& aFilter, const TDF_ClosureMode& aMode) ;




protected:





private:

  
  //! Adds label attributes and dependences.
  Standard_EXPORT static   void LabelAttributes (const TDF_Label& aLabel, TDF_LabelMap& aLabMap, TDF_AttributeMap& anAttMap, const TDF_IDFilter& aFilter, const TDF_ClosureMode& aMode) ;




};







#endif // _TDF_ClosureTool_HeaderFile
