/*
 * Normaliz
 * Copyright (C) 2007-2022  W. Bruns, B. Ichim, Ch. Soeger, U. v. d. Ohe
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * As an exception, when this program is distributed through (i) the App Store
 * by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or (iii) Google Play
 * by Google Inc., then that store may impose any digital rights management,
 * device limits and/or redistribution restrictions that are required by its
 * terms of service.
 */

#ifndef LIBNORMALIZ_H_
#define LIBNORMALIZ_H_

#include "libnormaliz/automorph.h"
#include "libnormaliz/cone_property.h"
#include "libnormaliz/cone.h"
#include "libnormaliz/descent.h"
#include "libnormaliz/dynamic_bitset.h"
#include "libnormaliz/general.h"
#include "libnormaliz/HilbertSeries.h"
#include "libnormaliz/input_type.h"
#include "libnormaliz/input.h"
#include "libnormaliz/integer.h"
// inserted on purpose: the place of this file source/Makefile.am include_HEADERS
#include "libnormaliz/list_and_map_operations.h"
#include "libnormaliz/matrix.h"
#include "libnormaliz/my_omp.h"
#include "libnormaliz/nmz_config.h"
#include "libnormaliz/nmz_integrate.h" 
#include "libnormaliz/nmz_nauty.h"
#include "libnormaliz/normaliz_exception.h"
#include "libnormaliz/options.h"
#include "libnormaliz/output.h"
#include "libnormaliz/sublattice_representation.h"
#include "libnormaliz/vector_operations.h"
#include "libnormaliz/version.h"

#endif
