---
id: fast-colors.colorlab
title: ColorLAB class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-colors](./fast-colors.md) &gt; [ColorLAB](./fast-colors.colorlab.md)

## ColorLAB class

[CIELAB color space](https://en.wikipedia.org/wiki/CIELAB_color_space) This implementation uses the D65 constants for 2 degrees. That determines the constants used for the pure white point of the XYZ space of 0.95047, 1.0, 1.08883. [https://en.wikipedia.org/wiki/Illuminant\_D65](https://en.wikipedia.org/wiki/Illuminant_D65) These constants determine how the XYZ, LCH and LAB colors convert to/from RGB.

<b>Signature:</b>

```typescript
export declare class ColorLAB 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(l, a, b)](./fast-colors.colorlab._constructor_.md) |  | Constructs a new instance of the <code>ColorLAB</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [a](./fast-colors.colorlab.a.md) |  | number |  |
|  [b](./fast-colors.colorlab.b.md) |  | number |  |
|  [epsilon](./fast-colors.colorlab.epsilon.md) | <code>static</code> | number |  |
|  [kappa](./fast-colors.colorlab.kappa.md) | <code>static</code> | number |  |
|  [l](./fast-colors.colorlab.l.md) |  | number |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [equalValue(rhs)](./fast-colors.colorlab.equalvalue.md) |  | Determines if a color is equal to another |
|  [fromObject(data)](./fast-colors.colorlab.fromobject.md) | <code>static</code> | Construct a [ColorLAB](./fast-colors.colorlab.md) from a config object. |
|  [roundToPrecision(precision)](./fast-colors.colorlab.roundtoprecision.md) |  | Returns a new [ColorLAB](./fast-colors.colorlab.md) rounded to the provided precision |
|  [toObject()](./fast-colors.colorlab.toobject.md) |  | Returns the [ColorLAB](./fast-colors.colorlab.md) formatted as an object. |
