if (typeof T === 'undefined') require('../setup');

T('atanh', function () {

  function t(n, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, new Decimal(n).atanh().valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('-0.63774941', 1, 4, '-0.8');
  t('0.1221481', 9, 0, '0.122761087');
  t('-0.17990274590466674', 7, 1, '-0.1818821');
  t('-0.6', 5, 6, '-0.69315');
  t('-0.6712743', 3, 3, '-0.814');
  t('-0.8', 9, 2, '-1.09861228');
  t('0.034059491123193', 10, 5, '0.03407267052');
  t('0.971383207580654133272', 2, 6, '2.1');
  t('-0.4', 5, 5, '-0.42365');
  t('0.7', 8, 2, '0.86730053');
  t('0.4206840645836230484032786410995', 2, 2, '0.45');
  t('0.11657', 3, 0, '0.118');
  t('-0.06', 1, 4, '-0.06');
  t('0.8679596950069114083213661', 5, 4, '1.3247');
  t('-0.895165912892044', 7, 0, '-1.447342');
  t('-0.24549498277000856006664760772730973', 10, 0, '-0.2506131893');
  t('0.003434934411074', 9, 2, '0.00343494793');
  t('0.8', 10, 2, '1.098612289');
  t('0.9', 6, 5, '1.47222');
  t('-0.35115', 4, 6, '-0.3668');
  t('-0.07006008', 9, 1, '-0.0701750467');
  t('-0.805588217169184404803545', 7, 3, '-1.114332');
  t('0.035042192', 55, 2, '0.0350565459913177073622482641959208402405964262615529299');
  t('-0.27398', 41, 6, '-0.2811617873835199297281322455211358234326');
  t('-0.4860194', 77, 4, '-0.53083537941098533673177663090557161489026982518920257398555815069258399000671');
  t('-0.24023148147547753705876525534786727823', 64, 6, '-0.2450197568943221990022234155266189427014650372890460086779371601');
  t('0.6011860402795', 70, 1, '0.6950024335022886924643340340622320956358285387350047592361304767363335');
  t('-0.29093', 44, 2, '-0.29958195778891861736095524290964866810281107');
  t('0.266818124020332161434635904184413087903', 70, 6, '0.2734349124503902665106317554881156645559479073060421002241446128732386');
  t('-0.432531956714370232077', 6, 4, '-0.463007');
  t('-0.12287097619204275583897636378879', 2, 1, '-0.12');
  t('0.2897036197075545', 60, 6, '0.298242699414791823529878292721126830768439530743706217501737');
  t('-0.2655773613852928593375285', 77, 0, '-0.27209952218398509029158426102152882183064360960300836509805625022650344274319');
  t('0.5735882938793959782751026397687223000311120959777492896023791205', 33, 5, '0.65285425106191064820540169018885');
  t('0.7426414548', 23, 4, '0.95634354421618813937091');
  t('0.79326', 64, 1, '1.080164253158982312196251050504784270125752587840009002471824728');
  t('0.1991301120855576845', 79, 4, '0.2018265847477406706392428533389908448862292415015902102343859228007472489793578');
  t('0.58575026964988311327717364047728706968432384708442439806628335397331041029', 35, 4, '0.67117196259416045496400738728525138');
  t('-0.6382435885085400741', 52, 5, '-0.7552044376964453055912660622103201093353424263040963');
  t('-0.1937766857572633836824102902726660707344', 65, 0, '-0.19625823857879391217692284026627503312320392329436359124182475746');
  t('-0.77329685', 58, 3, '-1.028477133857644453547320325736890284496863994792903106468');
  t('-0.38935628384', 30, 0, '-0.411041070277527417008424457354');
  t('-0.514', 10, 3, '-0.5681509051');
  t('0.958729982986459836771826622473322363124574975404328744', 21, 1, '1.92995765916231006555');
  t('0.46401438080114898349', 52, 1, '0.5024150932833156698557467674808132274481991616651669');
  t('0.5989023538423641713709183', 71, 2, '0.69143386983135895477423195223524769608010916945045113248577167194266556');
  t('-0.03651542020603455193763551331484375543974794103475847308026587749101823431', 59, 6, '-0.036531662796419796028369200191680396653704276902211463476447');
  t('-0.33', 51, 2, '-0.342828254415393852722154089483655258153765543829547');
  t('-0.127827075266907724285915869037463706439', 80, 1, '-0.1285302029045167436793945158211468632668697124786207606960739918130299633916413');
  t('0.7847923398129302653846940761', 14, 2, '1.057726963944');

  /*
  t('0.667', 7, 1, '0.8053191');
  t('0.936', 7, 6, '1.704748');
  t('0.47149890118443789692532558', 3, 3, '0.511');
  t('-0.1', 6, 0, '-0.100336');
  t('0.6', 7, 6, '0.6931472');
  t('0.605863425', 1, 6, '0.7');
  t('0.81212551757', 8, 3, '1.1332408');
  t('0.779', 5, 5, '1.0428');
  t('-0.7', 10, 6, '-0.8673005277');
  t('-0.67', 4, 5, '-0.8107');
  t('-0.21674103', 5, 1, '-0.22023');
  t('-0.6105254316329073', 3, 3, '-0.71');
  t('-0.628', 8, 0, '-0.73810685');
  t('-0.5327294020580735309874106456085667381596973692687789559449624731094173988099912632', 8, 5, '-0.59394841');
  t('0.7655', 2, 6, '1');
  t('-0.4', 5, 6, '-0.42365');
  t('-0.7564', 10, 2, '-0.9877470014');
  t('-0.4467', 2, 0, '-0.49');
  t('0.28', 3, 1, '0.287');
  t('0.4159514913166', 5, 1, '0.44278');
  t('-0.1', 2, 4, '-0.1');
  t('0.018358359', 5, 5, '0.01836');
  t('0.7915226057', 9, 0, '1.07549528');
  t('0.91', 5, 0, '1.5276');
  t('0.505', 8, 1, '0.5559952');
  t('0.45', 9, 1, '0.484700278');
  t('0.304547087968440937352667220565', 8, 4, '0.31452395');
  t('0.5088', 10, 6, '0.5611092675');
  t('-0.736143434975973374166194443911888144456939142878868927883108', 7, 2, '-0.9420079');
  t('0.5', 1, 4, '0.5');
  t('0.6', 8, 3, '0.69314718');
  t('0.17', 7, 2, '0.1716667');
  t('-0.2', 9, 3, '-0.202732555');
  t('0.5', 4, 4, '0.5493');
  t('0.414402', 8, 0, '0.44091428');
  t('-0.37', 8, 6, '-0.3884231');
  t('-0.30952677681', 7, 5, '-0.320022');
  t('-0.1571', 3, 0, '-0.159');
  t('-0.436591486934971', 4, 2, '-0.468');
  t('-0.373720581204009934306', 3, 5, '-0.393');
  t('-0.703023452', 1, 1, '-0.8');
  t('0.44532482829212059907658933489878962504523600674206009885', 5, 1, '0.47885');
  t('-0.3', 8, 4, '-0.3095196');
  t('-0.8151907', 5, 6, '-1.1423');
  t('-0.0506040574634766254', 10, 4, '-0.05064731908');
  t('0.3137286514595660519875111623266469334656648619534858', 7, 5, '0.3246758');
  t('0.308', 5, 3, '0.31833');
  t('0.024844', 7, 2, '0.02484912');
  t('-0.0051463', 9, 6, '-0.00514634543');
  t('0.62583886385084410003917975362969048346', 3, 6, '0.735');
  t('-0.8922809049490948055445561', 6, 2, '-1.433');
  t('0.25', 2, 1, '0.25');
  t('0.845881894023075', 9, 6, '1.2414966');
  t('-0.9232', 1, 2, '-1');
  t('-0.09770161002117', 8, 4, '-0.098014276');
  t('-0.94172456900357737051473577', 8, 5, '-1.7530756');
  t('-0.7', 5, 2, '-0.8673');
  t('0.83605912042354869', 9, 6, '1.20793545');
  t('0.95691157620292247077475709264238521876744725669972324311545492494141414997549193', 7, 0, '1.907935');
  t('-0.7265136773988200738866714695517', 10, 0, '-0.9213039135');
  t('0.43816942342646717', 5, 1, '0.46996');
  t('-0.803163205558127308', 2, 1, '-1.1');
  t('0.3', 4, 0, '0.3096');
  t('0.11234734', 10, 6, '0.1128236322');
  t('-0.09988', 2, 5, '-0.1');
  t('-0.4', 3, 2, '-0.423');
  t('0.201263', 10, 6, '0.2040485261');
  t('-0.9504081499655063', 1, 5, '-2');
  t('0.7139054895318308785538367773802907182829875297617301915372019598154', 3, 6, '0.895');
  t('-0.031', 1, 6, '-0.03');
  t('0.436949176029593720541', 2, 6, '0.47');
  t('-0.5631230417658644703136', 8, 3, '-0.63739473');
  t('-0.1', 7, 3, '-0.1003354');
  t('0.6', 6, 1, '0.693147');
  t('-0.3', 2, 5, '-0.31');
  t('0.99305051707249393045', 1, 0, '3');
  t('0.079', 6, 5, '0.079165');
  t('0.6929', 1, 2, '0.9');
  t('-0.9232321878346', 1, 4, '-2');
  t('0.58', 3, 0, '0.663');
  t('-0.8', 5, 1, '-1.0986');
  t('-0.599', 2, 5, '-0.69');
  t('-0.23', 2, 2, '-0.23');
  t('0.36857421422028857', 7, 6, '0.3867722');
  t('0.07639585826007171826196896248', 8, 3, '0.076545004');
  t('-0.831', 3, 1, '-1.19');
  t('-0.750045295727492670434475657198555003', 7, 3, '-0.9730587');
  t('0.369', 5, 4, '0.38726');
  t('-0.59', 5, 2, '-0.67766');
  t('0.993', 2, 6, '2.8');
  t('-0.708745721974434890368811532680104388679065890768263551206182', 1, 4, '-0.9');
  t('-0.46', 8, 2, '-0.49731128');
  t('0.75296068458138915621616753413298005975601572596449911367217775', 3, 1, '0.979');
  t('-0.2265364737240223293099293708', 5, 3, '-0.23054');
  t('-0.5228496', 3, 3, '-0.581');
  t('0.1', 8, 4, '0.10033535');
  t('-0.1', 4, 0, '-0.1004');
  t('0.5', 10, 5, '0.5493061443');
  t('0.5', 1, 3, '0.5');
  t('-0.5', 9, 6, '-0.549306144');
  t('-0.46911346659016367721970755252573657546657434681524355145751999684421495906529385105443', 6, 2, '-0.508933');
  t('-0.7', 8, 4, '-0.86730053');
  t('0.7', 9, 5, '0.867300528');
  t('0.9752681915112730241556842154616768451', 4, 4, '2.19');
  t('0.135337996427269791020473973432926', 4, 6, '0.1362');
  t('0.854756', 6, 1, '1.27354');
  t('-0.832', 4, 2, '-1.194');
  t('0.04827359496118732', 2, 1, '0.048');
  t('0.22', 10, 4, '0.223656109');
  t('-0.5', 6, 2, '-0.549306');
  t('0.645786', 6, 0, '0.768037');
  t('0.400656', 9, 1, '0.424430126');
  t('0.71', 2, 6, '0.89');
  t('-0.35953433', 2, 1, '-0.37');
  t('-0.1', 4, 5, '-0.1003');
  t('-0.8731971500671615312635877', 3, 3, '-1.35');
  t('0.85', 5, 6, '1.2562');
  t('-0.44654482929591318945160611714378603', 8, 1, '-0.48037617');
  t('0.353610624279164560558647751280832', 1, 0, '0.4');
  t('-0.6', 9, 4, '-0.693147181');
  t('0.436295', 3, 1, '0.467');
  t('-0.04695807087755', 9, 0, '-0.0469926318');
  t('-0.663842544', 7, 5, '-0.7996527');
  t('0.90957390380043', 3, 1, '1.52');
  t('-0.41', 3, 4, '-0.436');
  t('-0.86742', 10, 4, '-1.322563421');
  t('0.8', 4, 4, '1.099');
  t('0.80917318', 1, 4, '1');
  t('-0.31711', 9, 3, '-0.328430715');
  t('-0.1982', 3, 2, '-0.2');
  t('-0.3', 3, 5, '-0.31');
  t('0.4204', 3, 2, '0.449');
  t('0.1581494016111596825336742289512865163637738', 5, 3, '0.15948');
  t('0.486', 8, 2, '0.53080998');
  t('-0.459584397', 9, 2, '-0.496784267');
  t('-0.8', 8, 1, '-1.0986122');
  t('0.2', 1, 1, '0.2');
  t('0.2', 9, 2, '0.202732555');
  t('-0.1402', 10, 5, '-0.1411295803');
  t('-0.16415', 3, 4, '-0.166');
  t('-0.54693', 1, 2, '-0.6');
  t('-0.29', 9, 2, '-0.298566263');
  t('0.751', 10, 1, '0.9752447179');
  t('0.865', 6, 4, '1.31287');
  t('0.6', 2, 2, '0.7');
  t('-0.9012889382343451910135287373', 5, 1, '-1.479');
  t('0.35', 15, 3, '0.365443754271396');
  t('0.9', 18, 3, '1.47221948958322023');
  t('0.3709312935173', 19, 5, '0.3895025410708670336');
  t('0.323352335763573909681', 12, 6, '0.335386371932');
  t('0.8213814663577082342935', 6, 2, '1.16105');
  t('-0.26309', 19, 6, '-0.2694253053379267195');
  t('0.70392797594', 3, 6, '0.875');
  t('0.3370672937169725209701115799771286984205746', 18, 2, '0.350780210747432033');
  t('0.4644683795284', 3, 1, '0.502');
  t('0.95715793548', 20, 2, '1.9108641155814013564');
  t('-0.56321', 7, 6, '-0.6375221');
  t('-0.1', 8, 4, '-0.10033535');
  t('0.2', 17, 5, '0.20273255405408219');
  t('-0.82448', 4, 1, '-1.17');
  t('-0.1576', 4, 2, '-0.1589');
  t('-0.1899676011183615618911071046014', 17, 6, '-0.19230355714905887');
  t('0.46', 20, 2, '0.49731128757203102746');
  t('-0.36053955', 9, 3, '-0.377505928');
  t('0.25661', 8, 5, '0.26247605');
  t('-0.34139939141606082110424188408697764134811452760772519020722928229495515774980436', 19, 0, '-0.3556756879867937273');
  t('0.68416535944447702360552291612016662972641092', 19, 6, '0.8369032985919963384');
  t('0.3903398593217905195858591221958168349906', 13, 6, '0.4122009219367');
  t('0.13577317', 10, 1, '0.1366168179');
  t('-0.144503290245', 8, 3, '-0.14552189');
  t('-0.98215576652846243722243987053875917834245973969884678124578602153381206584203635', 4, 1, '-2.355');
  t('0.6903118833806525793549757609229588812911567', 1, 3, '0.8');
  t('0.1174793381', 9, 6, '0.118024318');
  t('0.52808492414757708818912819789568220604874708163271562464151', 19, 4, '0.5874857507284189343');
  t('-0.4369794936905146274261696964', 18, 4, '-0.46849128249672186');
  t('-0.96', 20, 2, '-1.9459101490553133051');
  t('0.3871', 18, 5, '0.408384362638779177');
  t('0.3258616807173211058700480950523877966587308449358641033254296', 9, 4, '0.33819127');
  t('0.382149884031515755902721101330652988037189102230128822815913005348488', 13, 5, '0.4025747778183');
  t('0.1879', 4, 4, '0.1902');
  t('0.58058471925', 17, 5, '0.66334429022138832');
  t('0.14797705412012', 7, 2, '0.1490716');
  t('0.30774', 10, 1, '0.3180470639');
  t('0.4', 11, 5, '0.42364893019');
  t('-0.5628165110202949', 12, 5, '-0.636945968966');
  t('0.9691721316372057923', 15, 0, '2.07847469890328');
  t('0.36', 11, 4, '0.37688590119');
  t('-0.59105', 14, 0, '-0.67927827771931');
  t('-0.10002810362812096210006358920835159199', 3, 1, '-0.1');
  t('-0.02080244808189345512683076874502011876391494773471554202783733', 7, 3, '-0.02080545');
  t('-0.3', 7, 6, '-0.3095196');
  t('-0.66', 12, 2, '-0.79281363187');
  t('0.97009782713636', 15, 4, '2.09395366508148');
  t('0.3817', 1, 1, '0.4');
  t('0.508446487234112744149767106975475', 15, 0, '0.560632386860571');
  t('-0.34236', 13, 0, '-0.3567634343743');
  t('0.31095985818359372692943889508208462004335947', 9, 6, '0.321607667');
  t('0.108091', 7, 6, '0.1085149');
  t('0.556', 19, 1, '0.6270245711530560785');
  t('0.69', 6, 3, '0.847955');
  t('0.0418', 6, 2, '0.0418244');
  t('0.159784038', 10, 0, '0.1611650682');
  t('-0.8', 3, 1, '-1.09');
  t('0.59', 12, 1, '0.677666067757');
  t('0.6132823015739', 5, 2, '0.71417');
  t('0.648157', 4, 2, '0.7722');
  t('-0.15', 1, 2, '-0.1');
  t('-0.1', 6, 0, '-0.100336');
  t('-0.61830344741', 14, 6, '-0.72225384840149');
  t('-0.2848198840896717787050015815436094798', 17, 5, '-0.29291969907362401');
  t('-0.07674774488645411617585927', 12, 1, '-0.076898966625');
  t('0.98246538457995222865352753748529102188647304674565', 2, 4, '2.4');
  t('0.4', 16, 3, '0.4236489301936018');
  t('-0.68731203904', 16, 5, '-0.8428431344177894');
  t('0.282195338143898', 8, 5, '0.29006576');
  t('0.8295266', 3, 2, '1.19');
  t('0.9', 10, 0, '1.47221949');
  t('0.65632588251', 3, 0, '0.787');
  t('0.570051144996153529435095444932197', 20, 0, '0.64759860724023954079');
  t('-0.4749', 17, 0, '-0.51637837461082153');
  t('-0.8007', 16, 5, '-1.100559764978355');
  t('0.307', 7, 4, '0.3172299');
  t('0.1', 14, 0, '0.10033534773108');
  t('0.394616600575677947', 3, 1, '0.417');
  t('0.5', 17, 3, '0.54930614433405484');
  t('-0.764479585', 8, 2, '-1.0069067');
  t('0.15542046543760802185', 14, 6, '0.15669034238318');
  t('0.16686878374185695676360218', 18, 3, '0.168444017365788612');
  t('0.68', 17, 3, '0.82911403830176618');
  t('-0.049306', 20, 0, '-0.049346014019693863084');
  t('-0.6', 9, 1, '-0.69314718');
  t('-0.4509530906', 12, 3, '-0.485896020158');
  t('0.48260014244039803262613626543658738912960268848', 16, 0, '0.5263683419229002');
  t('0.9326', 3, 1, '1.67');
  t('-0.1', 7, 6, '-0.1003353');
  t('0.2', 13, 6, '0.2027325540541');
  t('-0.91223', 11, 6, '-1.5406528113');
  t('-0.802569665', 2, 2, '-1.1');
  t('0.5179181557', 5, 3, '0.57349');
  t('0.4805998030174334895585824725797754718', 13, 5, '0.5237639392439');
  t('0.1822', 1, 1, '0.1');
  t('0.1', 12, 1, '0.100335347731');
  t('-0.221585558758505431', 1, 0, '-0.3');
  t('0.81421', 11, 3, '1.1393941933');
  t('0.4815576', 14, 2, '0.52501015697748');
  t('-0.76148', 12, 4, '-0.999728239751');
  t('-0.416412959413657213608235423245624397280326712', 17, 6, '-0.44334462966193999');
  t('-0.1', 5, 1, '-0.10033');
  t('0.33923597', 19, 3, '0.3532288859938446944');
  t('-0.3205071317017', 18, 3, '-0.332212197229483168');
  t('0.426802034336309', 20, 5, '0.45597986621289338143');
  t('0.94921', 8, 0, '1.82374');
  t('0.6957781', 2, 1, '0.85');
  t('-0.87202148', 1, 1, '-1');
  t('-0.24571964346302431', 20, 1, '-0.25085227211988180122');
  t('-0.8901558', 5, 3, '-1.4227');
  t('0.82676337629', 6, 3, '1.17782');
  t('0.82972207465698', 12, 2, '1.18724370273');
  t('-0.795288185', 6, 1, '-1.08565');
  t('0.8466435', 20, 2, '1.2441798347545536176');
  t('-0.1', 5, 1, '-0.10033');
  t('-0.5130303501386533255381', 13, 3, '-0.566833986318');
  t('0.1375834781051153', 2, 4, '0.14');
  t('-0.8', 5, 0, '-1.0987');
  t('0.506790564042833407', 3, 4, '0.558');
  t('-0.1', 12, 6, '-0.100335347731');
  t('0.2', 1, 3, '0.2');
  t('0.02738', 1, 2, '0.03');
  t('-0.6', 8, 1, '-0.69314718');
  t('0.6', 8, 6, '0.69314718');
  t('0.4341406242778552858948800705', 12, 3, '0.464987743077');
  t('0.9190774278', 10, 1, '1.583053522');
  t('-0.69579027265066475950258567', 13, 4, '-0.8590933962877');
  t('0.3', 13, 3, '0.3095196042031');
  t('-0.08384', 8, 1, '-0.084037273');
  t('-0.2', 18, 6, '-0.202732554054082191');
  t('0.6105735081549', 15, 3, '0.709835243848278');
  t('0.21487639', 6, 2, '0.218279');
  t('-0.831', 14, 5, '-1.1913594148757');
  t('-0.2', 19, 5, '-0.202732554054082191');
  t('0.0064', 7, 0, '0.006400088');
  t('-0.549210641039', 3, 4, '-0.617');
  t('0.0203', 17, 3, '0.020302789165331437');
  t('0.9190129880066', 2, 4, '1.6');
  t('0.62', 2, 3, '0.72');
  t('-0.98135646112', 4, 6, '-2.333');
  t('-0.5', 14, 2, '-0.54930614433405');
  t('0.3', 6, 2, '0.30952');
  t('-0.75', 28, 3, '-0.9729550745276566525526763718');
  t('-0.3968426472831228980559555', 26, 3, '-0.41989580214355776593053461');
  t('0.1', 21, 3, '0.100335347731075580635');
  t('-0.0469983', 12, 6, '-0.0470329498447');
  t('0.6852915', 14, 2, '0.8390235056503');
  t('0.190804046642149655666564553', 12, 2, '0.193171461452');
  t('0.2', 6, 5, '0.202733');
  t('-0.47423033394424730657451261098429358961200474530211466376390441779048', 16, 4, '-0.5155140527446382');
  t('-0.46976622895905', 16, 2, '-0.5097703262358118');
  t('0.341669217752552509292393977233149371267141602468638349497956307319567394234929', 10, 3, '0.3559811445');
  t('0.62745', 2, 5, '0.74');
  t('-0.493897236', 20, 6, '-0.5412019196396973047');
  t('0.972', 9, 3, '2.12729951');
  t('0.08103018242202616394963017852844', 1, 6, '0.08');
  t('0.01731', 16, 2, '0.01731172921118811');
  t('0.00262', 7, 2, '0.002620006');
  t('0.14648368', 7, 2, '0.1475452');
  t('0.0631119097', 11, 5, '0.063195904487');
  t('0.1825269779317847405796286804567', 19, 6, '0.1845955163628887296');
  t('0.166235840408855445351380955327660173854155421986576993307110624858', 20, 2, '0.1677930154279171713');
  t('-0.383', 4, 6, '-0.4036');
  t('0.137013324436065', 13, 3, '0.1378804806648');
  t('-0.432110416042', 4, 3, '-0.4625');
  t('0.647864', 10, 1, '0.771608859');
  t('-0.806052551448533774855043360933280621009619192', 18, 1, '-1.11565579659810942');
  t('0.21354828777393381652553065675849', 5, 1, '0.21688');
  t('-0.25851', 17, 4, '-0.26451104260042224');
  t('0.1683', 25, 3, '0.1699165904242304360485806');
  t('0.640026082791126', 3, 5, '0.758');
  t('-0.31953496955', 9, 2, '-0.331129112');
  t('0.201754317173258', 35, 4, '0.20456063794501530685972192543509934');
  t('0.149172991137121494', 28, 2, '0.1502944982173343946586599872');
  t('-0.79', 17, 3, '-1.071431684058666');
  t('-0.75075523036110649727630034668534380142427543087095587221957457446', 3, 1, '-0.974');
  t('0.24062', 23, 4, '0.2454321113856786091585');
  t('-0.5717441242302809488173064648784193875271220085628963684', 23, 3, '-0.65011016568244919698574');
  t('-0.381355144654453442040951044', 19, 3, '-0.4016444582536299799');
  t('0.0241540312569542384620600907767741411059761623417869761', 10, 3, '0.02415873019');
  t('0.20639672409678', 27, 4, '0.209404798974299686989600772');
  t('-0.0516820139109131361232344', 12, 0, '-0.0517281025422');
  t('0.11507176235', 26, 5, '0.11558374417806388371196225');
  t('-0.47275668385523894683048', 30, 4, '-0.513614538143372950548395400547');
  t('0.572', 34, 5, '0.6504903887036775311201352155343873');
  t('-0.8188542652959306678785104010503', 25, 1, '-1.153330092934203480470023');
  t('-0.16', 21, 6, '-0.161386696131525515341');
  t('-0.4', 32, 2, '-0.42364893019360180685505375326032');
  t('0.5737085', 10, 4, '0.6530334152');
  t('0.120913507855458', 38, 1, '0.12150798633367103181981306472517092467');
  t('-0.85157119922', 15, 1, '-1.26184223362975');
  t('0.05', 25, 0, '0.05004172927849126824578528');
  t('0.645505208', 35, 1, '0.76755453931190342869525015772976497');
  t('-0.017823893919571732023302796261437231274147413436', 33, 5, '-0.0178257817774880241786419657334225');
  t('-0.332657863', 11, 6, '-0.34581387844');
  t('-0.92929109814346037539', 28, 4, '-1.653168216255514924403370288');
  t('-0.81211383503658953', 16, 1, '-1.133206516786924');
  t('-0.212476314', 16, 0, '-0.2157633200338411');
  t('-0.272039660499444', 12, 4, '-0.279065177524');
  t('0.8', 27, 0, '1.09861228866810969139524524');
  t('-0.8909828785572726123289', 10, 1, '-1.426673533');
  t('-0.2116355', 18, 0, '-0.214882916231361823');
  t('-0.0087', 40, 5, '-0.008700219510968957381150347221294275165923');
  t('0.3', 27, 1, '0.309519604203111715474067349');
  t('-0.3400138048787396583751040159613', 22, 4, '-0.354108138360711896297');
  t('0.2716641399984203690121228216', 2, 5, '0.28');
  t('-0.1', 12, 3, '-0.100335347732');
  t('-0.7', 28, 1, '-0.8673005276940531944271446904');
  t('0.654631440405223436124240107500655652973959034830983144720348487139732570255263413033847985856187', 27, 1, '0.783360716447124495872847091');
  t('-0.588562777446791429515140112535588473583512505078062203713967910807502475229813017217486930006', 24, 6, '-0.675464260994964800500128');
  t('0.76703', 9, 6, '1.01307288');
  t('-0.6699771', 25, 5, '-0.8107015733748302239170375');
  t('-0.508129193467253533', 14, 2, '-0.56020456164844');
  t('0.811849', 37, 4, '1.132429158931768075895320679943279269');
  t('0.72344923640411593', 4, 3, '0.9148');
  t('-0.179', 31, 4, '-0.1809493955424713526624831275864');
  t('0.4145571', 10, 1, '0.4411015513');
  t('0.6', 35, 2, '0.69314718055994530941723212145817657');
  t('0.487111876', 28, 1, '0.5322667200798400295256342267');
  t('-0.49695467410051030887', 22, 5, '-0.545253914483557083485');
  t('-0.0326459279935876596020907', 23, 4, '-0.032657532953228747929299');
  t('0.9768658036685', 7, 4, '2.223978');
  t('-0.6090589814071871334650302917630049852521783', 13, 3, '-0.7074240512427');
  t('-0.61373740477789', 1, 4, '-0.7');
  t('0.0568886077852', 28, 2, '0.05695009702201245387712513666');
  t('-0.68', 12, 5, '-0.829114038302');
  t('0.041312', 10, 3, '0.04133552623');
  t('-0.5843', 35, 1, '-0.66896705106120270477801844819763149');
  t('0.1042807782331370739549370078', 16, 1, '0.1046612636549409');
  t('-0.6786572', 21, 4, '-0.826620500497242968416');
  t('0.29475656962076949', 32, 2, '0.3037674724029533613943052155369');
  t('0.3055577305016131', 9, 4, '0.315638287');
  t('-0.48', 34, 2, '-0.5229842775913438541573041147330642');
  t('-0.097424', 22, 0, '-0.09773399853606828757511');
  t('-0.7472717812009679157448664446374405341541125', 6, 6, '-0.966748');
  t('-0.1287996341370033850801137867123941981965380852', 21, 3, '-0.129519042425098216789');
  t('-0.712', 9, 0, '-0.891228539');
  t('0.35761', 15, 4, '0.374142741973274');
  t('-0.927562', 25, 3, '-1.640640123680011088785777');
  t('0.093132371333', 22, 1, '0.09340304689074850004908');
  t('-0.27791762', 31, 2, '-0.2854239703295013174995258610778');
  t('0.98606810537895', 38, 5, '2.4798656740434884885285792288811863661');
  t('0.2362', 29, 6, '0.24074573121687855377780247961');
  t('0.42409974591741554712975771644423487518332488700970526788', 9, 5, '0.45268033');
  t('0.53162210331089956091891930409', 23, 0, '0.59240360468493639210199');
  t('-0.405960557423525717', 23, 5, '-0.43076515006673885957978');
  t('0.316602214328814593609327319581736724058660202997105908280604035151', 6, 0, '0.327867');
  t('0.76068294197747717473613710853', 27, 4, '0.99783388630203072724667097');
  t('-0.9604958586196465087544198', 6, 2, '-1.95227');
  t('-0.05440974992375574851', 18, 1, '-0.0544635374163384417');
  t('0.7132', 37, 4, '0.8936665685078753099239200498036229368');
  t('0.93314', 30, 1, '1.68215001093705755188734446412');
  t('-0.81269649355332973627105038849092724856314225461', 22, 0, '-1.134920230398192003393');
  t('-0.27', 34, 5, '-0.2768638226551000719776659751388749');
  t('-0.4923', 15, 5, '-0.539091555492037');
  t('-0.262830069094343198056964314304414133770394971', 37, 4, '-0.2691460655639917694267564167076133549');
  t('-0.268737833501109', 23, 5, '-0.2755029085152644685979');
  t('0.517639577731234121977108954323451281244646884826031010174872474233', 21, 4, '0.573109949390999646707');
  t('-0.7741', 24, 1, '-1.03047805379632267849875');
  t('0.99825996253769051848739203817525984582118913873855764', 30, 1, '3.52306270953369161738063775667');
  t('0.95953685627426883', 7, 1, '1.940035');
  t('0.6394823578225027', 29, 5, '0.75729747095708771490311436794');
  t('0.022036394451503888685666666326920144075699300836645779534687703675499950458', 30, 2, '0.0220399624685489460001866502107');
  t('0.97818530161165941114388673479549389744794', 11, 1, '2.2536756042');
  t('0.965389909019', 9, 5, '2.01965032');
  t('0.994065811', 9, 1, '2.90860029');
  t('0.9091674751439544852047229467029851965506474087218109368797416434633', 32, 1, '1.5227025622012804432153439162835');
  t('0.459169897', 28, 4, '0.4962589011495894593373824864');
  t('0.79285897769260652319216746', 2, 4, '1.1');
  t('-0.90661', 16, 6, '-1.508148900931365');
  t('0.09976950134201922', 13, 0, '0.1001025262204');
  t('-0.85266942538263308565679829', 12, 0, '-1.26585197089');
  t('-0.16', 22, 0, '-0.1613866961315255153414');
  t('-0.3658426012779168747682177052740206', 3, 4, '-0.384');
  t('-0.34573255766', 26, 2, '-0.36058879759675953303629898');
  t('-0.84', 15, 0, '-1.22117351768461');
  t('-0.9', 2, 1, '-1.4');
  t('0.116', 6, 0, '0.116525');
  t('-0.351324449018', 36, 5, '-0.366953896792408050643036730971048633');
  t('-0.9', 20, 6, '-1.47221948958322023');
  t('0.93', 27, 4, '1.65839001992478612337478915');
  t('-0.309038476873729157071472800229', 3, 4, '-0.319');
  t('0.5885412744825', 29, 0, '0.67543136205060533483482345372');
  t('-0.190839168489175612883648265869', 20, 1, '-0.1932079105142891151');
  t('0.242578', 29, 1, '0.24751148543784099012532935793');
  t('0.37771', 10, 3, '0.3973858787');
  t('0.63979240146239138410142518455321094', 26, 4, '0.75782220024148198489505494');
  t('-0.332755922286693', 23, 5, '-0.34592414338535353055027');
  t('-0.4988135557197770528968951466459996926771499206772837397515703204217780205833415742', 31, 4, '-0.547725467566196825223536774371');
  t('0.86198274837785511444511860430615195051862556263417776178094724584923146327703166305448938', 21, 0, '1.30100925179616938377');
  t('0.739936', 28, 3, '0.9503379276760625184209922661');
  t('0.61786190918859', 4, 1, '0.7215');
  t('0.5', 36, 2, '0.549306144334054845697622618461262853');
  t('0.800084798042', 34, 2, '1.098847883184587084036561243688504');
  t('0.6358461608985036855519880766', 35, 6, '0.75116953290731863994069317329089958');
  t('0.72448568242179900272', 4, 6, '0.917');
  t('-0.18906615542348603175441781672', 30, 2, '-0.19136852827944594316270151291');
  t('-0.1', 30, 0, '-0.100335347731075580635726552061');
  t('-0.8', 5, 4, '-1.0986');
  t('0.8905', 26, 3, '1.4243360370372160174658973');
  t('0.795', 1, 5, '1');
  t('-0.8616682790519', 33, 3, '-1.29978685661736633377792184597721');
  t('-0.0484892938782', 27, 1, '-0.048527350443817675925222877');
  t('-0.5470151', 25, 3, '-0.6141119098793523282314343');
  t('0.967', 7, 6, '2.043879');
  t('-0.459', 2, 1, '-0.49');
  t('0.0160226586292307408469573135', 28, 0, '0.0160240299826347558501533087');
  t('0.9015444580633576267194867324836921114338', 12, 1, '1.48040830611');
  t('0.46485215', 5, 2, '0.50349');
  t('-0.3030059669923088635716549001', 33, 6, '-0.312826153390616632790233904399065');
  t('0.579', 12, 0, '0.660957090287');
  t('0.56886', 33, 0, '0.645835828299229995520343287983202');
  t('-0.8355601550336755868291330961679279009466385325', 3, 2, '-1.2');
  t('-0.8103085954', 9, 6, '-1.12792702');
  t('-0.39590161605225650716815532746705811731801330848761914386844205497', 36, 4, '-0.418779366615357057962612441303371959');
  t('0.7378466438945828556378', 2, 0, '0.95');
  t('-0.5418482333955516471226087', 18, 3, '-0.606768315000587704');
  t('0.048574876275503848', 13, 3, '0.04861313489472');
  t('0.80956', 3, 3, '1.12');
  t('-0.8', 10, 4, '-1.098612289');
  t('-0.488227', 39, 4, '-0.533729795084827785883939914367960244948');
  t('-0.83874480359994742', 30, 2, '-1.21692513248395765959197177282');
  t('-0.75', 27, 4, '-0.972955074527656652552676372');
  t('0.011778358612390812697', 33, 2, '0.0117789033272420887017361264552219');
  t('0.343852134669', 21, 0, '0.358454664085400394701');
  t('0.8641604912652852615072747344685089', 37, 2, '1.309545992973132637187779053862754192');
  t('0.6083915579', 23, 1, '0.70636372893075834680862');
  t('-0.646049130861', 4, 4, '-0.7685');
  t('0.004559351994', 24, 4, '0.00455938358719358780168491');
  t('-0.43', 27, 4, '-0.459896681212678564355579175');
  t('-0.8897', 17, 6, '-1.4204847195182681');
  t('0.3900488580203762877211637385928592469', 27, 3, '0.411857658158874417506323616');
  t('-0.02295251778', 19, 0, '-0.02295654965490700268');
  t('-0.149894892', 35, 4, '-0.15103291030461569429672643485009616');
  t('0.1815837847026522211', 24, 2, '0.183619990049482843075196');
  t('-0.4', 23, 2, '-0.42364893019360180685505');
  t('0.7197901772341689607476326378065764979609006265015937180851441342', 44, 5, '0.90720944141559116285532299558754460380229588');
  t('0.2741514445353', 56, 3, '0.28134715527631509208814276832585425214177761177039335415');
  t('-0.2753452709', 15, 6, '-0.282638457972114');
  t('-0.2918323408049206721947024426796014020084362192851652323', 23, 1, '-0.30056801815553588217953');
  t('-0.948529', 15, 0, '-1.81690573282107');
  t('-0.054671922829', 16, 3, '-0.05472649253644749');
  t('0.8969', 49, 4, '1.456138431354881485604133384350433358311068929162');
  t('-0.543586958', 16, 2, '-0.6092329935786826');
  t('0.08199312659900772895148', 22, 2, '0.08217761446628901340098');
  t('-0.920337719262853686226129295704250994', 77, 3, '-1.5912300683820810726820365467067432130981845455428679799201287511509075996743');
  t('-0.1945391077686819854', 57, 0, '-0.197050527789868069781358191028628153656520352984141261363');
  t('0.43425757857339', 78, 3, '0.465131869332004489755825258149112086672711048774154797079298901464123730511972');
  t('0.431715393158328576', 56, 4, '0.46200310918081776047447274691583115719970196753005802882');
  t('-0.8941619930116226', 51, 6, '-1.44231105522603877103783361278690140581976735982435');
  t('0.2448117587173111022319293', 56, 0, '0.24988627763759771633717356883047592243520724267853276227');
  t('0.3186551939438137599', 19, 2, '0.3301496013218857368');
  t('-0.213', 48, 6, '-0.216311830263323451802911856922183324256890176042');
  t('-0.3423462373034762556', 34, 1, '-0.3567478444504432290340850257336341');
  t('0.84000595014296', 30, 5, '1.2211937291111645116545632742');
  t('0.919075', 19, 5, '1.583037889143665472');
  t('0.020129308603', 77, 6, '0.020132027989392872301630357374674932313109648560863442437913769621597618767936');
  t('-0.90834719105872687667346218614548148522313706110064254', 2, 1, '-1.5');
  t('0.3307005037478610098154218501821', 26, 4, '0.34361456982534469112050639');
  t('0.548770441940787481375082761810827562213504583811631372863', 26, 2, '0.61662021196415693284251178');
  t('0.25211', 8, 5, '0.25766475');
  t('-0.6147049657696169', 54, 4, '-0.716449085872632124144907572779103727073873858466971361');
  t('0.2972489601948171977456153701008999608063134829588855', 61, 6, '0.3064992136465464696646798527886311748433986248045227433808202');
  t('0.12967649960049735653877698333469371289525811234194225072228083434455118', 42, 6, '0.130410802553474755830537138459419813825387');
  t('0.678688', 47, 6, '0.8266776006085792945303524660160725888912498748');
  t('0.32052805947186339399236075598', 8, 2, '0.33223553');
  t('-0.117931934831477384322073601979', 36, 4, '-0.118483273125645745699622273354699058');
  t('-0.8208703487388', 71, 6, '-1.1594800134891671355617177848411014467592843795018867248065808845236506');
  t('0.571602569395690063898767283789931230562853332587838541742716328161741', 35, 4, '0.6498998908373328802236278909968925');
  t('0.968647713850056374347293867918057', 59, 3, '2.0699074792455535153515699358079722827363137602565948814978');
  t('0.76093685', 66, 0, '0.998436752287579513920326215307712788642370918010094530805293492271');
  t('-0.55856635096', 49, 0, '-0.6307469742270253573510082137728807639239618839538');
  t('0.17707455195823654', 50, 6, '0.17896091747653288334836620672019579070513094916957');
  t('0.052057574755388223199913264606065233250924055482527081763546482435193721191095922', 32, 4, '0.052104676554322321694133459337671');
  t('0.6003', 55, 6, '0.6936160624673333622842233629273448745112696439184684995');
  t('-0.182291797', 32, 0, '-0.18435224087976086907489332008672');
  t('-0.8', 10, 6, '-1.098612289');
  t('-0.17', 57, 2, '-0.17166666350057909768425284605949978053546800187123482485');
  t('-0.72', 45, 2, '-0.907644983319124559183744884951333652961025727');
  t('-0.130715856', 53, 4, '-0.13146808102944132603064801061827433785517657283812598');
  t('0.65', 66, 6, '0.775298706205583465175918035722237637416056341089152719246935946415');
  t('0.3912133291605785836883498', 10, 5, '0.4132318159');
  t('-0.665256571407679909236545527163664848476463996274', 73, 0, '-0.8021850669489786035716302869804643854826801376686604332417231992803520543');
  t('-0.650422351716134494334622454067581452875029', 13, 4, '-0.7760303991271');
  t('0.55518641513008609338623712', 51, 4, '0.625847707273343468504892704670932127148247542646974');
  t('0.522568017218432466811359013', 54, 6, '0.579865983969986270158174364310387257380525513283215139');
  t('0.7975768', 19, 3, '1.091917129670232081');
  t('0.324540551414937299819043741535', 36, 4, '0.336713900371170911082027605650900429');
  t('0.5551127870036', 2, 3, '0.62');
  t('0.95051904160344769608027614894858804721335', 22, 6, '1.837131437305747719024');
  t('-0.1914611902100640354285718424484912145834087940126', 80, 3, '-0.19385352185893850762864798816625055357121533873479399460895388073494493031841274');
  t('-0.96207066423882680911406003972726387679124460358412544382395810084', 22, 4, '-1.973015406294687247157');
  t('-0.4209583505', 9, 2, '-0.448856204');
  t('0.36390226146773645', 7, 2, '0.3813765');
  t('-0.301597966349571585687206898470228292516761583605187101071136359003', 58, 1, '-0.3112765385441759511541496742670042066629083881432174077416');
  t('0.9218006569515402843870102365749', 50, 4, '1.6008783105418764038497359003536959254879231645803');
  t('-0.177025738509', 36, 1, '-0.178910524366877031219152802759378783');
  t('-0.2502895446670710799587140630594110315817875494091717511144', 62, 6, '-0.25572168338625176805765726833904255153041459314367765054029177');
  t('-0.193699045485673225', 80, 0, '-0.19617757048171417463955025238765325211590608681358214573536478005535353244218695');
  t('-0.013124752509302399', 13, 1, '-0.01312550620667');
  t('0.21511899555', 71, 5, '0.21853258504957888614907963455100590026328436539559346706346225504685116');
  t('0.11', 11, 1, '0.11044691579');
  t('0.9', 41, 3, '1.4722194895832202300045137159439267686186');
  t('0.55679', 48, 0, '0.628168794811501572470251904856918970810172065088');
  t('-0.5370311049459665817293609879476412716646717829823779001636', 13, 2, '-0.5999740551267');
  t('-0.383674251872', 55, 0, '-0.4043610528360133686936330472263387178218149473293465771');
  t('0.84370592146605444204782333', 51, 3, '1.23389678067529504348252548500303020833199834090334');
  t('0.2', 15, 6, '0.202732554054082');
  t('-0.8', 13, 0, '-1.098612288669');
  t('-0.3426301', 43, 0, '-0.357069428344752864782447031814403013577457');
  t('-0.338167', 25, 0, '-0.3520213939010124051203979');
  t('0.3980372705066', 39, 2, '0.421314525031318671905571964713375433693');
  t('-0.246154', 21, 1, '-0.251314592050124067879');
  t('0.9444309274001159735593', 78, 2, '1.77754891631941989293872858213421555404010099148500874050510921678504366277195');
  t('0.693528235563', 1, 3, '0.8');
  t('0.122998511231', 18, 4, '0.123624469544831052');
  t('0.4875149964340677993926707078337583808038495495156289724708348817896', 9, 2, '0.532795385');
  t('-0.45038178', 74, 5, '-0.48517910278421089492670635850227459828276412269178349578435790848484632154');
  t('0.58032224923050049617149988542642889265100127976322848847', 67, 1, '0.6629484518620076600215762891479484392521312042895728966646007569472');
  t('0.3749781069213923132259090144703578506732198360929288201243', 74, 6, '0.39420320484312438148069050110637948869916517473335481119629227698761448925');
  t('0.7738769574624547057567588386187671291', 54, 2, '1.02992175726081462848086512239374280901465389035427481');
  t('-0.76792751', 12, 0, '-1.01525673074');
  t('-0.137429641', 54, 2, '-0.13830478680777681556359803982822962172281948256208964');
  t('-0.5569622', 23, 3, '-0.62841840018195574462508');
  t('-0.00493', 64, 0, '-0.004930039941634801415083141037412788277090071445810271836969548875');
  t('0.639', 54, 3, '0.756481810205474382518158494646771356601516551266063342');
  t('-0.2416444186248957633154', 70, 5, '-0.2465197718676921538107989299249810596289301631498315448291286600478893');
  t('0.2', 71, 6, '0.20273255405408219098900655773217456828599521173124709880700716207205034');
  t('-0.4297853277536090460118309372', 42, 2, '-0.459633341815378233611634743721651957123138');
  t('-0.22', 34, 1, '-0.2236561090218324106513282124688852');
  t('0.9615', 80, 1, '1.9654032621779343572159497023387843542666037154708032943398401637425074528299407');
  t('0.348203797844', 25, 5, '0.3633982628520349375406029');
  t('0.7465922136978894216408590244594149522623', 4, 5, '0.9652');
  t('0.2614717445', 20, 0, '0.26768750379596489679');
  t('-0.23890618910608507582909640794951520521296658700484172661371366839496', 79, 6, '-0.243613770153039745823803587812360516432744547932303719547457284422365193393564');
  t('-0.221941081033856642141651838832045', 37, 2, '-0.2256968353730185663565233076754887392');
  t('0.882', 79, 4, '1.38470284783983009209774176388110633366280439138642942311121331191042257048983');
  t('-0.994620262101818525949980995557', 44, 0, '-2.9577846556090827748220408578591918634483117');
  t('0.73', 64, 0, '0.9287273642467249363738823388367071776216906171229129656064258727');
  t('0.8388456542598863731060075182834', 28, 6, '1.217265358483051486990048874');
  t('0.74204293754005', 44, 1, '0.95501032951332484956361048326532782997239849');
  t('-0.8612238249', 55, 4, '-1.298063568256064070117386337419184694142840582416563162');
  t('-0.47319', 80, 1, '-0.51417272218911746291314975096892983649962515390981381320391843062430308396169479');
  t('-0.79256', 55, 0, '-1.078278951743255988829330540573037031198969956799252633');
  t('-0.43', 68, 2, '-0.45989668121267856435557917536003433137105248978787301068247932487362');
  t('-0.63958055806232871387921896881369677974461110689603', 1, 6, '-0.8');
  t('0.479395180346760745233366329530134418528530679753', 6, 5, '0.522199');
  t('0.81333641680093679191329748', 30, 5, '1.13680788763696050716455990273');
  t('-0.14676658', 17, 6, '-0.14783421780571871');
  t('-0.21555219265847582256536152575668593472155952334132936431449', 73, 3, '-0.2189868459816191836575982301489970487110863001510022993544068870416496338');
  t('-0.2946934400419229', 43, 6, '-0.3036983375775988016884892033940753672557247');
  t('0.58620107443214853573724', 24, 0, '0.671858503102172540579287');
  t('0.7499691091470265956705929788', 11, 3, '0.9728844706');
  t('0.211479756136934449', 69, 2, '0.214719875200827485478060869200603161553502150529542260113365792442542');
  t('0.6795', 50, 3, '0.8281845663458113527455399651207728527394833991457');
  t('0.6757941568881181178239110344963025892748101987390789', 43, 2, '0.821331911551871545528658592631596672306017');
  t('-0.6502962282776676988147652', 13, 0, '-0.7758118267324');
  t('0.2286019666824280007828395', 11, 4, '0.2327138466');
  t('0.80407844', 6, 5, '1.11005');
  t('0.68512893716491096', 19, 4, '0.8387170648675247952');
  t('-0.75012305050337283379848', 66, 2, '-0.973236392170689972560271508970710984420281269609939249434184801898');
  t('0.39125038429139549665764472739109401181884', 116, 5, '0.41327556784642315162182817585479922007578242200138495394267683798589781360048916087742940292045090932877569695879843');
  t('0.2958838141985455387213', 136, 3, '0.305002422082257346332355349332166366500154890418651783492187641506728693616325116618545309289230668209233622875702918404046284849467118');
  t('0.7399196582848513289159827669122627067', 153, 3, '0.950301813931745941971403512893809057792284307260154372377897185252334891424529252514422403276236220970313040491163278212048907513761182831534101257142808');
  t('0.807060015435768931264223941276564021488226260187857589831288598729115365', 67, 1, '1.118538661524657687065321132001166967330173059542214868261856077357');
  t('-0.31362', 11, 1, '-0.32455527684');
  t('0.9515534296940309602854361127551968117513464835072593187489', 101, 1, '1.8479597087578485070011856698814170628424378819582285859170800341672353604866671053382171900488848622');
  t('0.286293220300030949675', 23, 4, '0.29452384153527862251135');
  t('-0.5426753404338609080987177942014648', 81, 0, '-0.607939934367664506986364547058800433478760399447072816017208184609332874876454209');
  t('-0.2524096531495388095671733176709514204133', 117, 4, '-0.25798476691517624903260692521498470120791373816493854788197765771607801444540162959230663415005077463570920535218459');
  t('0.4952221', 15, 0, '0.542955753054785');
  t('0.42757447083879866342673015994263412742951408385736191005', 59, 2, '0.45692473099182062499036743105289586886289419348064929319462');
  t('-0.74043549562335429189662833655701723216221679789124958809', 85, 1, '-0.9514427011187392237979871762821952201181151347307888432640525883449518629061979725052');
  t('0.2', 75, 5, '0.202732554054082190989006557732174568285995211731247098807007162072050335624');
  t('0.940688979304841152229327613430468122401487417869375893319124818', 68, 5, '1.7440015988912597000681590314427841899939054144914901377014297594251');
  t('0.5190564050807940755985076048251883408', 114, 3, '0.57504731899623834811849795647108941469523562043556300203148476477027570995252772025530564440047391595128602051872');
  t('-0.364495145850152317259226766042058028594', 106, 0, '-0.3820600268844247149471564190466727415474503101216146678071239651526324230180932611930178233427411063020786');
  t('-0.05457399294985785499337692721410593382678242934538701211086793', 72, 4, '-0.0546282695926178392057141416992513758939890000868269464135978074900081077');
  t('0.854187417', 41, 1, '1.2714398549645573405403445275480405243622');
  t('-0.4561499287736218691040566654555615627638983668494782397817', 80, 6, '-0.49243879600363547579673820603279030995068600671436370837960847474534572300116633');
  t('0.0427', 88, 2, '0.04272597992161996212074274125165291814044559795295859368761634834034871120127134045246329');
  t('-0.6', 29, 0, '-0.69314718055994530941723212146');
  t('0.22551895820419661080449', 97, 6, '0.2294632455266306109609123126497848550397953103506112244774132205238076638959445515206237991492022');
  t('-0.244080001663658263893880892099027354462851734372992972536562326477971217891240923857673360300013825075839475356767170778960505156203', 157, 0, '-0.2491080164884053095439824475976327610323980059664157321613917512425426315770767912235782940622406544481294580581224545934257573439668021302261352840455110407');
  t('-0.69762991540873108955590103870884431815014952492939954767370113829162770308629446775925167976574', 58, 0, '-0.8626683385432143337277064292141481696568140657609192027267');
  t('0.47879765388412435796321999061742212933', 81, 0, '0.521423146973682257514319018361494204685287085402747904771623284911798639569049219');
  t('-0.722093507408833275643332058924207541', 31, 2, '-0.9120056428102683371797568106052');
  t('-0.72414497743634813087853288922896810314616813419888229028672722988117130614222', 154, 2, '-0.9163055470930179377063838065273295445919490699403868751761803809687924646245587405078455122834526369825737299197284287782912176578497551380430646783666133');
  t('-0.632979200139652571276531874855873953159790485462425880922269045706731928690798652487095', 157, 4, '-0.746371416932081864814263604886008436229237006230579993379068271563519424295633178681038106582219962915356625878399104043545760013961686364453291432652854139');
  t('-0.147315037099725', 149, 1, '-0.14839479516344108909495591536452082997493850122288929061116869668431481481827795845492587294951317626605190771774432059966487104560947626956051508328');
  t('0.402269977278975335891032468101486804', 54, 3, '0.426354214944314592862163427968258881552088273542028245');
  t('-0.2499436387690053', 81, 0, '-0.255352694140077901260784349883234099514346127981106582249126094784280706946975659');
  t('-0.1648538', 101, 5, '-0.1663720326089060556062791601958630438311072852067580092906366487571372117866617198008036831928770998');
  t('0.547048072695351', 68, 3, '0.61415896288281252294166436485824851502415240133507941280351931494042');
  t('-0.57037', 74, 4, '-0.64807108310395738210372155641397774189005393174518415595025700775165645848');
  t('0.74', 59, 4, '0.95047938059652349126251491385955935266836776349264320711866');
  t('0.9516473734090723850353833784867454654193496000226668431155187149751310104399645652960261874904490371659373263501961919311656188', 78, 6, '1.84895427841700372427787865047051231607613708574177092154099424382039440362964');
  t('-0.32679587852384', 88, 5, '-0.3392368081127582536147819703850675518069069621162155273759326666565214644685571062272762');
  t('-0.1994505817', 132, 1, '-0.202160308762868985649802218893118888521724325952005160624710451673981618838517449098764581698509444814654015989065113832635001723841');
  t('0.88916731', 108, 2, '1.41793483367599891791666388168749427657657173341568826619540353511919340519236247377564928622222680959417566');
  t('0.81406669120607545668926468104557', 75, 5, '1.13896917008790915421202376801849585893977122400957505275769835120618778908');
  t('-0.320193531940545191988095900071864723790268178503415', 136, 0, '-0.3318627340363140919446454451520846342133100159627350060257677365654868477484669111074293165423183764443770908443299414780742328924776376');
  t('-0.16116959193', 7, 1, '-0.1625872');
  t('-0.7300130209691189551239199340812344232244035067366551499342', 90, 3, '-0.928755241005661979073719620159916835984022766211907447041293653978708625308966937935384361');
  t('0.28450889857199543200963724003286', 78, 6, '0.292581291059623186465924960915926865015032236929281195048506406323046235950551');
  t('0.85371418020000764312033858070705228187731', 158, 0, '1.2696920962732624436074812353114110993319678229945721278093420162962902303053077661439615080712755409831426460836245761430338220030879029233464743773600534424');
  t('-0.5478816261817394', 25, 1, '-0.6153492739135910833602791');
  t('-0.757499221', 75, 6, '-0.990321128848983119592383780102047435479509882169545278474990602867515318815');
  t('0.79430374300276395713964825603889647602526644914891434559626460116069586601365708', 101, 1, '1.0829858693454330113721306118642952667797838382181165628938800274231475125932398972818593758600916686');
  t('0.5204676088608927675', 54, 4, '0.576980879994888938230268872276621626741326385824445954');
  t('-0.0085412146710071783082', 160, 0, '-0.008541422380654165415894945355419951431205178120554238818554997933542082593221635553779786883170947140616318305915010537791048201466869457267905972381719077024763');
  t('-0.950093', 61, 5, '-1.832735534624022727154108330037661471401627668539540760772539');
  t('-0.95864251407857868882663236', 124, 3, '-1.928876737162421657088385961763387886652833942385611641745554630540483124184881840841504093108707838585562389117461663186278');
  t('0.029825662573610400136146613837', 18, 3, '0.0298345113033864434');
  t('0.6024512182189007', 139, 0, '0.6969860496279149984523130150744047919226237986980218264442532876822746059100247855099607758243304141291668786528036706029655996456490945027');
  t('-0.947287513449866849203732725157597465173081996624020487592338530917757838228365802695196969800947982057910059874187485968', 15, 5, '-1.80467015026599');
  t('0.3455313054', 101, 3, '0.36036024172365512325605507182532164699596510050417594733813150237472660970446862207531607181104019393');
  t('-0.2212787', 88, 1, '-0.225000244051337375904210593759543877803788281644664731954417381153705994778829207746911');
  t('-0.94797835', 9, 1, '-1.81144369');
  t('0.633541444765728133830115249644430985407', 24, 4, '0.747310085062359466735922');
  t('0.625', 31, 3, '0.7331685343967135223291211023213');
  t('-0.791', 45, 0, '-1.07409757504795038706482037793030288706350015');
  t('-0.834618346673131532650038914155472412', 42, 0, '-1.20316795000464329054917788438260537316613');
  t('0.749', 23, 6, '0.97067326794340909169154');
  t('-0.9234', 37, 0, '-1.611626327765917897343964101343988625');
  t('0.585468', 28, 1, '0.6707423689120629235684280344');
  t('0.65541785461436053', 19, 1, '0.7847381129496889693');
  t('-0.40275936067624', 7, 1, '-0.4269382');
  t('-0.91846993702465894974778880254415624051483', 14, 0, '-1.5791557082143');
  t('-0.5059', 61, 1, '-0.557204039620534709232882434456153031358109026950215316316116');
  t('0.69002042619448558875912594822221113317417606985851071', 19, 6, '0.8479947449956781488');
  t('-0.85056938872094968221358965058585745686095452043166132519306', 45, 3, '-1.25820825096106221271112206181097536721509939');
  t('-0.6348891553735284536106319843014192169313090875456514250909154158503845811523', 80, 1, '-0.74956464738329651873472953922062500041878782674085685254764644633541565534753258');
  t('-0.1742682765666482715341178385837163071129629529041902197635313950080096442963405962593077610402512699932424892071739649165668839147580797347007846581495231466', 142, 2, '-0.176065279256268810995741771650686353041104149374919231945935321565481194046797204285710764059150636914059352902905119408378800416257954716825');
  t('-0.55020764026044382276487897073788416904851055178454996607184229382249460409753141578476426637569260836', 58, 0, '-0.6186790544622441960337323845468096334372139844947006857539');
  t('0.493485', 154, 3, '0.5406568279143206619790522620147733209850470594550103272204883199102119229397850888815312414785306113070092062826813734093156346122267414612715878415533854');
  t('0.6527629', 120, 4, '0.780097909720045163605134998960081871078556799479053901290221964897783995987994987644307634995529705048233039765396466194');
  t('-0.3264258092561025', 109, 0, '-0.338822547762968275523587621126133988545398433810541734630973734316726220005389336853610103565055436963306495');
  t('0.55073299176871902350654785069556265049487733771573059180335296885059690243799707459562960668100405', 32, 6, '0.61943280596622999782175513301939');
  t('-0.39023271273768759529492591119381982082805086569388236404642996360545', 87, 5, '-0.412074521629802448988773874665306392819558760512206621651701450307120030376660364181211');
  t('0.8245822', 61, 5, '1.170967875592856776077036349851497971482397486461956466555394');
  t('0.217380758245280054293741081670836992572981129268845218957', 1, 4, '0.2');
  t('-0.97170614811235482292585272284', 50, 2, '-2.1220049893423393149688085234493035544015713306564');
  t('0.19239', 81, 5, '0.194817853295859437078845852399122119471169613797887223868068500828680695599571201');
  t('0.7548177156505612754034276253872915600288126908836069698683', 39, 3, '0.984059156562916076842483801426367249329');
  t('-0.18940636651385855135048832511940505395086441324102320924', 65, 0, '-0.19172137494055644994216164394005854676090986475001082351007195972');
  t('-0.468629871219868899668395889016438916', 76, 0, '-0.5083131826504379600515907185115796556710453035352688331762565177572777037235');
  t('-0.6', 135, 1, '-0.69314718055994530941723212145817656807550013436025525412068000949339362196969471560586332699641868754200148102057068573368552023575813');
  t('-0.09850847613463773702480631284100545049676995', 45, 2, '-0.0988289837757844753349992374325237215286432084');
  t('-0.4329752160273902372646236861138140289176507011273159692291075', 10, 1, '-0.4635525595');
  t('-0.5698795', 102, 0, '-0.647344370908252254663533778532080596389216285252384103762424239586833779942157569699740337354118051713');
  t('-0.207459182479', 89, 0, '-0.21051478622094541877204801764595110283557854549618141000951734254601317584409078485858873');
  t('0.607342308752083529125259133571445530315051', 17, 4, '0.7046995682106747');
  t('0.078356680179547227667637371921298615707735484915165873948452502', 151, 0, '0.07851763752204949533263281528862978043940518827193734153145767703552154246051344856881956810794867141380762778324498151132241601484707345369003243332662');
  t('0.83942548', 63, 2, '1.21922521441688890681865978029208003994120127236317575531604525');
  t('-0.2425143310334952060702443', 77, 1, '-0.24744383679339415733299397360696321912306342331749316520611694613381259562562');
  t('-0.7331812826695', 135, 5, '-0.935572212012088063074082411816284612047942391907272726883736515324723312448587056940491720434452561547354663343704603263256107166223298');
  t('-0.1030890768130047105229', 60, 5, '-0.103456611394587395504750035543198355389880486923497840891929');
  t('-0.59284915529545417920535291631214788195483035106', 117, 3, '-0.682047935310074520335599988679905651003200908477628647851505895098726246457976857045865944187124645400286135113999738');
  t('0.447242281613529996533', 155, 3, '0.48124768327660715173215429902425602757160635968939025749688808358299982930556570527233045960644880489234744203102161836898662680484017012060886125674164444');
  t('0.359790278156793393', 82, 2, '0.3766449732731627871516774817161775489123179469835248898122017279366655095699971367');
  t('-0.08220701346608207', 97, 4, '-0.08239295280537699532126908163498905224535807080195992622246394731784423069379359143445214222092482');
  t('-0.0302686634105283742274865407414080546644367808766520037455255', 148, 0, '-0.03027791246434073911668615561635294923738722599399668407439959872111538411277253844742899208576336434826494403598356490260972654840141625929874609553');
  t('-0.6489214903854416557425891135926006097573388225991790885589', 90, 4, '-0.773433419208351101967829325557134474075522978732517484920075552027821667697495084180452761');
  t('-0.3784', 43, 2, '-0.3981909430801410903601622461393575132680817');
  t('-0.0966573003018364', 122, 3, '-0.096960010237597550040676099559043163263102408265586689495010986720495026251600302412580877691246424793520004650348249462567');
  t('0.638746132096488477984347209105182148821974460222682793586686886080899889483666', 104, 6, '0.75605286421485976580162508705155614524890678783983889335469685261853320046834708675977256814898118971633');
  t('0.46355889', 66, 2, '0.501834777718778567022753667397040932206729639461573693282808464891');
  t('-0.74081', 64, 3, '-0.9522722088217244675507933927381728724696016962156300368863659412');
  t('0.080556708975128401196525838556848504928', 131, 5, '0.08073164507402793438747574785746687272139236398746675288591057194193965051555929458905667992976833284568869499852781511779410298567');
  t('0.834890374386070831058165303348681309605162171430466200395268816', 112, 5, '1.204065183139376624138702326407321423496754331558953022282867738524924516342421437579941659206950893438682076982');
  t('0.8114763471613886777393895155086809', 1, 2, '2');
  t('-0.183797', 84, 4, '-0.185909624753444853318764960249965423327753904512723067035481680576752939940141805042');
  t('-0.0172', 154, 0, '-0.01720169645047026032743957373958309499678244770913932342809081889829919431320836009642154471749522145490136836508900197482918133921436109405522859967136035');
  t('-0.721690463891584683865372543059', 145, 5, '-0.9111639907382818699925667747993417266351210670863213197933401665566241408899922007273358638993360155906554380925575338635081910569315633042686127');
  t('0.4958646946082052331109115245154505664842831948714162233393940068', 90, 2, '0.543807507271436434137098742089841558720097206262725219986565496623161884090666884057976372');
  t('-0.79192', 40, 1, '-1.076560164270407407176472937824940874527');
  t('-0.718685558345737897416924514467041400082094235415186355651240437320655717337180456566216984475493343907826451853', 117, 3, '-0.90492100711537411053336945115037143606417190937801926926722935470253326860357994577393140504048292316222024002328008');
  t('-0.991696696278356656998213059764383057046894046985281469342981653423563114891100723', 100, 1, '-2.740044345644441461308160928621216471519650968716177798250248031259467701055321685468858871238747437');
  t('0.42573194473', 87, 4, '0.454672161850764791632831218999710641424169788283837127313323327654580595183975238076845');
  t('-0.2386603494473275968874608271288765004446947212011819074891796867941802137123474303084', 21, 4, '-0.243353065795036168354');
  t('-0.28015079032823498869368065137588827285693378939306222294661161010577651579847', 99, 3, '-0.287845697927106083319045903676475716917650935779447415526947613659895033380487147718240005700321978');
  t('0.784667179613284917', 109, 3, '1.057401194912127699851364229951478015850188067651986983692524537690523705464677552562001945798762939898538386');
  t('0.85257207070641122508361748581782372103677052221290270887535891526128715784829502935', 48, 4, '1.26549540978418846589880126750775879096625684196');
  t('-0.304045203794248612245', 148, 1, '-0.3139708485635925772647580752327876980913990616406010364963727233842148300067522352731904679712020778230244189389498971238596876081389611438205909064');
  t('0.0445951337012070246', 96, 2, '0.0446247315262957621713309806364707524614309711737881470669648333029981851634692272265874527611312');
  t('-0.8381155324391', 105, 0, '-1.21480662051330520365467926291060149504604118182972972125395350826918801654618337350582546124405512841363');
  t('-0.27572851760599069919498', 21, 6, '-0.283053191494449538562');
  t('0.803448566524853460021935667779833282701098', 60, 0, '1.1082659181063399988264327875788772830640205277217742586984');
  t('-0.90725107', 145, 1, '-1.511761044477246468604706131248004379813212859081514356396327933355481130283688363622579223098707031923043707646186351847901926271201371512893322');
  t('0.4538458443589036147556903561992770414391695871992555101', 66, 5, '0.489533179238420227927516771375965616588829649850165303215846294078');
  t('0.27279546878', 86, 4, '0.27988157154096206002961555747891050359273397197574609998928909349745638829261401003833');
  t('0.64832788', 39, 6, '0.77240869138004331947928559180803043214');
  t('-0.2033', 62, 0, '-0.20617243252889825823241726509349281173792178111368515680482641');
  t('0.4169379747354999705940085077604256451279535755029738066', 66, 0, '0.443979947990907548027353889264135021206105461261057324213381429341');
  t('-0.35413740849612678670597476410898220577392461128', 147, 3, '-0.370166578597928631216464222701676502059252779921973471231348096396288348255468564696504162138343404577196966971527160422825507442469948865586481316');
  t('0.418535943790716152', 146, 0, '0.44591571768448824774264037500050578308459711706226783274597365361874225090583649263359984011750784081982879155366353252115838079210627400450598215');
  t('0.0648518300507673829570958168291591319665321077220536607248129518949787661458263502196214744717666297017083772525748641441', 45, 5, '0.0649429772420575912697124390205524578429350851');
  t('-0.1695116368', 130, 3, '-0.1711638095274053563777312361634027923855291381337477929534984678027977706279186581516892107075289206958480809542464961773958829719');
  t('0.059779263474741149892756186972000093925810747392804355683584935887273916436287320219047981166930714332206862577233957837908043082612025377960010632', 126, 0, '0.0598506248141775471727424125487023000139453689229942617267754619514339882361594472010496152909011095153227978213536583117882565');
  t('-0.25198932665107', 127, 5, '-0.2575358897644445486911554712232658659604081502929859952495174162551843554972075824228535021053295814812576687322877790436838948');
  t('-0.9000351215614803776157', 123, 2, '-1.47240437066670258385160984600962619282122196957208250586084063694669306039851180882241597153282241772533618582440095710772');
  t('0.50967034866237962430435889856605218892136645732', 93, 1, '0.562284335547419456156132625313475287430442765302589939721577689307010428274399267018192685101');
  t('0.458392693798618528859394380166939953', 76, 1, '0.4952745010375455549172232709501300209649042157607186777563062369556261335602');
  t('-0.1669244180377053', 24, 4, '-0.168501245727650415601618');
  t('0.08179720469134968467115120086844785994721794593019401752508205638', 55, 5, '0.08198036967302231743205747615192910418692736141304029187');
  t('0.669351796990381', 102, 6, '0.809567852581415786846719325588566940635237489493449552729722788435074678908491217346570198766744316728');
  t('0.57722622922133748127284253043765082667827351580225757816815097158113', 91, 2, '0.6582929084925710279904230616012690160578837517153741046129913758483243655782361114462678824');
  t('-0.68238131977', 18, 2, '-0.833556988257893672');
  t('0.318080975', 120, 1, '0.329510615918503095798940285875014399137633347313153916250665384503208005427313149672038015274429864849577788739235698862');
  t('-0.3103705528804606479922086152908909981384742243315210818050658273659267', 50, 3, '-0.32095541040673874426276501167591878728393607761971');
  t('0.5764924256246543298870545312675931789369188008318', 126, 3, '0.65719313765307357870820308427341507167481040948292266732815936390634576078522303432215729713132539394645065849083137611772987');
  t('0.9849686327', 139, 5, '2.441609609906199527083168004651752588366156887362446167030553492833631044846429835794791742275016458899754889119206245871099961748254437904');
  t('0.914654999804358908580421', 62, 4, '1.5552954305578950684640722836171452687017643873990059559419585');
  t('0.2440950067269800201504715439411', 147, 3, '0.249123972170690440919407886100728815124903705794596220773004187144787869289532851106331870383100612038227422051634064587462185233133463591144794816');
  t('-0.17221698', 101, 5, '-0.17395051130841983422957031516201224569602666265836524939610413915425708159861073866198768534687482313');
  t('-0.6664423419484576702000426720003790040460068875908063118257442477764755418862280020812888327537955584742', 113, 6, '-0.80431528036770658420358337180480609738961163735833812396567179692651686875179148316394032526565195253892057979636');
  t('-0.36197651497', 100, 4, '-0.3791585752273256745651794528263399998154557063011464279468255503120264093121341750928697097656128541');
  t('-0.1084823812615287283669597899207714489181925', 66, 3, '-0.108910967289611097976735001745385711062006228591553517700105204161');
  t('-0.844584397727959', 73, 3, '-1.236953219400664968338882852232002056371133314964066448482463827686406547');
  t('0.422917010658647726695378751612', 128, 2, '0.45123909561105322236261877815649690916764881862041620627232652153057955242150278977780004747882775031566523808260028631527437816');
  t('-0.59531240415765198837574257149726016', 67, 2, '-0.6858547297785829238863536310561803492463689304394696373043719075411');
  t('-0.080954413816258829202330594300021788062812232675765473082613504901218944177', 56, 4, '-0.081131960562296245419465097419447936269866480022867190546');
  t('-0.2738897766307264603777165', 116, 2, '-0.28106424435369039614123861119382568586058550218202449346195517042202053053777548885538945409126921722596622318229288');
  t('0.22759953922061535181712744592156', 104, 0, '0.23165640014308084950038324840690091574664011750833889859625768802863004206487134628975214774506123098891');
  t('0.76240981557712893032359687167061046', 131, 0, '1.0019450448133980578046999112488774462304216175048568018223555729981626336384930302937855237926090246199156891332649427034540344674');
  t('-0.2', 57, 6, '-0.202732554054082190989006557732174568285995211731247098807');
  t('-0.9495902294602832871793310071013723', 45, 4, '-1.82759473726665300929438873145211080303768479');
  t('0.6363', 40, 3, '0.7519317612209532580159293840351388603638');
  t('-0.7097', 123, 5, '-0.886579162239239680158745836866277569922665130364668484030547243008738271536912165612638401646766854915629244916787953901476');
  t('-0.8744834323', 109, 6, '-1.351825317134341494400550594887068972097858540088337062278247911728227693258465066959052359958737656595179692');
  t('-0.8244789745604808975748092947900605191831176503105', 65, 2, '-1.1706454465298949171536504734612026055735516206290423349246787642');
  t('-0.1', 91, 0, '-0.1003353477310755806357265520600389452633628691459591358745895209277925187380093896639115992');
  t('-0.89956550497446021639', 105, 4, '-1.46993736660500074236541682328986455532826600858171791693778510492582589217674100504044805668018630134693');
  t('0.57447311244698', 129, 6, '0.654173913502961141163882598539704431081329269229096440949328958832326443447122644379343585553191564350672593347642460456689639204');
  t('-0.9721021822586150837390141475034', 43, 2, '-2.129153440883888322266954103765655028704499');
  t('-0.211651230948756', 38, 3, '-0.21489938485789257469998213491440297206');
  t('0.59209522185853934760931381000896175167015588', 44, 4, '0.68088620854190870830959348295175651649670573');
  t('0.8335933120396184191697206917', 25, 5, '1.199799079708443456536326');
  t('0.215242', 65, 5, '0.21866156144838990030797458865239466326069408186748684095900898192');
  t('-0.299633799', 111, 4, '-0.309117234076452340680725575844450837460639051129907792566509010508012527525813555724237882827279907234351955625');
  t('-0.517', 50, 1, '-0.57223666284797978046375411594647659977476622716094');
  t('0.353633373411455950908648692649255774049842910986245281887981420160251780388838332690867858342902015723717131921428513126603788772080286698708365148543820849365169296262499214142727230545927415118327005469392304203873087425718076681320213847871924', 278, 5, '0.36959038381543314492509214630660450741366648396894246146733105170071403154619393433894914659153054029076395829747976339403783980330539786885659620080688410438469883848662493544806064848018959956205460648050609326596621124372076108323523113579311024246076081133293362844983169742');
  t('-0.665262420469323834400324883838560246741876728235335755', 290, 1, '-0.80219555986057375594619542906109954200162329907778720850900320594324778839610114544862174230129619743219920057757088522103465811829936549391541026898033217623296846062270271320381050261484410081399652532382918417810859452123329789177331625138098850861865979000077331493455253717855998314625');
  t('0.5350774', 96, 0, '0.597232571041500382338435992912440087409432412049415080338736673850407816789373426404801098146177');
  t('-0.063369723470570989826453499007607', 15, 3, '-0.0634547535000722');
  t('-0.986951464156', 259, 1, '-2.512840441972876234537415663955489741628155072947663264457389158884071934155336934002026418300442089485398611880253998816312486029858329250969348889994958529653894629585971530186426744199112895388548813382893171911968016478231367482220606579211777284244948661');
  t('0.0414912', 150, 1, '0.0415150339289412696957021406420471729293224277383830934679485618163352605374524141874002403147449979510723371996352354177142656378384643669938291785941');
  t('0.82456496412570969', 236, 6, '1.1709140266799501705310801845335396808993506056079808272677956268686200168545341967057954434261715892551471836659907143456656850616554248921913652087378279131005852629899419834242382274130645810752659085701953961457201180527417598934541');
  t('0.4131893327620092115447543508279316162654297600749325669048514728238211677', 252, 4, '0.439451071203118169750489636513637070834046566774774511726381830998589069131221440673251251627820369441438022870148374415562342995526484620560576971243661642470707490123463512249754667686163726814221137766516759152293702501480198984317030019834571093677');
  t('0.6399321047265710216298656077307935784735444434737883329011923878564384551373725041693917253541667596618909329293903124520232382790245597314263279010293963824045526347548442586014958522930907564399208575462597388871481657712722117118468206391631549105172776714935', 304, 6, '0.7580587543773753206095735904461966020570973532187058641260076677083233205236875159965086417176361379327882887406335210697484401804030588515481175227348283311135299062873502978870300547925398421858116932052248503860718161516742990243557088911736076356512221869758727821599787512611267429492118286589468449');
  t('0.2420928261530804490580440242298408934601351086', 285, 0, '0.246996041377177721833557479028769696376096970801407146253096517290973021855280435075247924898969450081171336098688099502396620213576198787503943995842816986855378033864186754682794580260494274126209390171931053872002234729817450500250811378159410806201907695655684341974733534778571709');
  t('0.042', 28, 4, '0.04202472217122584148610893756');
  t('0.17659477200085197015739225738406216849725666068832568926357220964037021315317838634205065145323136148503280678900832691923318353451612663217514282', 76, 5, '0.1784656502559502786600863775379942312013224432407510139765685438309276943537');
  t('0.248404595880894694499434077', 163, 3, '0.2537117695412283746721321058820666081740368344818819117225353473827483138240666287407424739966531585435097548979404257697099779657766044865129624153316024997741609');
  t('0.751125', 253, 1, '0.975531477565958816756775735193737117938110762832753766844098977070634778416302840021512323113172950777176246895463503296996665595851347378497342144775672764290640346994284973671677736439266100018546002085747477537188677301721715095584490876352271629788');
  t('0.9834', 248, 4, '2.391582563694763579543717355967541686953947809469328016850171841737187488288869574948074895928281628934611506083108244431258789353376053557842214380235900545387149386907088022356397644007838634368468849640738228706454362524067331699474087067956021');
  t('-0.7203697018670331060511539045989', 138, 4, '-0.908413061373226460934370304066548079397633496348501679926061797722060334271534246720648421124256396376981643697027052839448039118041607187');
  t('-0.49', 75, 5, '-0.536060336610566684673824210154234123810195600392236454378804012493592482634');
  t('0.693966826344990254393019655978425785387686940993156092691968300628782836691458679006152', 234, 5, '0.855567392637648966154805566860887235952860996368267087233459759322797973719777570013252833718859835966465418300009385239332855616045413099817560185305408212460868082918186924015482004496292843753115960192165831767859971689955084931969');
  t('0.04396841417074748578516644914811296150761431014573547978558560840749867266877839365128582852619469356369606680241143969733962889226371595608184604093252378143120389841736723278612481540652319202179275837815138582205732107', 259, 2, '0.04399678064161414410011839214868946472177874320079520323224702590116605256295045547610526839676144328586605650646636696987320373090052705452875368549846124631954477141389560991130585709309633301323450402390042331148523309108964175194714553267562379553243663789');
  t('-0.4561918269266436459415677555725505926158887694701053104602030343335666507342365918099', 301, 5, '-0.4924917038491793700261051024347640803449926918872958695595975825666344825554297135269940858246939852001630302420459822220007657219027420964513883653644192599452806361815137171981381933027907427137550322866675089288979294088069165998816266434053818173515116398326287166311899156781461940884397248130643');
  t('-0.0385187612', 147, 1, '-0.0385378282073295670066721909334479694483542970997078130006172792568032376780455542216715815342507499291189242091743405390552740185804090927205683846');
  t('0.9779708381738750391737091698144308009001956642030249015', 271, 6, '2.248729827913416237042280946953006123456162430232963198376031184893471296119992627610656933072395156339561042965526685661114993868956298231572294853307633310742006759685153958018896456110727215228638229537472647047550637964787570540123768931698867582447155742170441266262');
  t('-0.925968', 97, 0, '-1.629343272654906983220392843886784753354281830957506738671633499958711529079041109082366787633064');
  t('0.5421613', 183, 6, '0.607211607192770674900896615043173498309320314999037349846477852245076402757639581391324168738065889316656020959687758829533307405598147005939392957912291834094456288739778175986410555');
  t('0.4552402783545692799031657837716070802839922966884', 272, 0, '0.49129074300041494555320332690746247666740750898531407395319900046145801248322337820903373948663295642127502873536023779177836139710576680112420504311971194857171189095984485221026287152020862626788605466150509372908559230090386942918135453741200653054314805105703308745083');
  t('-0.99', 58, 3, '-2.646652412362246197705060645934268600945552640284736249454');
  t('0.23514514194087957700369379903554444172789400375', 152, 5, '0.23962883909842894815634552855455244519159109741533221082158121387920484926797370860531017120239876181686976399527449760202382459509406335941433099497937');
  t('-0.5836929700181928964830252919190372745128740033228221075416503785076528474868489602218776145063701809023906790868051666418557926145813988371595761264050833444608590614676917', 172, 2, '-0.6680458403261016198853962555617713688366448162522728067989831789021399241385857180614582051788794895846929006879208108949976266322290550714876211392126526530960865041766089');
  t('0.2828896124136094987050292309468043141762131605847647540329600861419736285809830613527298064654331014185', 279, 6, '0.290820267966906200545941832767833185323350197865176869987464567411496057112743515188552000796590995451831659761441690667127568795354157731259979790540322073564090726173491819321143641783922309157500442480596692069316700426415003342644205024114313992130513731231961030219142149551');
  t('-0.2960521690854619695', 292, 2, '-0.3051869402141888480048875612388482327510180902754388036370866983621498056388503196785509740057063144636152649514837837141093587610972236782651531522261630473088286413012409615802218927014037266942168235431411467274667272454248372222932624041695284796452898919725663325812291335400878686583804');
  t('-0.41286432057877524959102065823021934210890178795720659771', 48, 5, '-0.439059211153320849547833828562002175169174607831');
  t('-0.5430615423', 238, 4, '-0.6084875102204545186454680147444840960316763534221374278620986781887593639232756423966995919473737194787806057309012300858320612760201919718570864946495907832846019729279155189850567369610190634703187976211176942435968130349984346744407725');
  t('-0.89607335645064334116908', 237, 0, '-1.45192753619994861039223693401879764621683879217663551825195594903736278279059606340079122777835624034878652009349557127739016119207521942000355709620939441862405070011912360310238092466736370858739846366353894193228192516172212036628386');
  t('-0.33288602635126544772854420713', 30, 0, '-0.346070454278775921079172835484');
  t('-0.61503767119784224632684959032467529688419417', 184, 0, '-0.7169840394852531089037127539655495754806475814699653461425764082466394184200371805554335889592582431292778362398897079226333821855750326679826670412479167715946735878347441469871315207');
  t('0.10242', 182, 4, '0.10278039472484269482301199764469185071298438986516481537371246194803947278290379910544273655174418854396483745471467704013857075113963936323746435209602318611374625568961139279614842');
  t('0.95791738191182753002637', 155, 6, '1.9200009218199166831316566192227165703519249288140108851852679239621761485950075363857619122812595423483731663029716597006943711097213798370484551819068795');
  t('-0.4763524', 215, 6, '-0.51825539552811221763218408299951118869618633115281835565398680546998575006428618040014770863279114738037278424905089835343107635415733437508103048069611472674950122609849246585723550990796115923902754402307040368596');
  t('-0.77125022431732667864931414068331', 102, 0, '-1.0234060970577204164318663327043484761451860395366219253949849503894462324470981884843184978971172669');
  t('-0.463820269543737279913513479265723198979180633738469352123305456038969822296150878377821049096449176724130946390868', 45, 3, '-0.502167748700007242159887299568252078197515792');
  t('-0.575501669749016440192472999452959948324374761828782366645829684', 286, 5, '-0.6557104743617790231270593483584133499647927459633230313886571473952352127020311979592286689653274324371765776258996395941787513164422819033039982991045184093384661881469771282216620257097102669420806907287974026077053214252490100484841048037841944171050080773321244433694531061321319374');
  t('0.660841997953392435594825470265936029479768818639439751522756711', 11, 0, '0.79430694946');
  t('-0.5564925179765303231694751357314448622731123452974341018295268035434', 282, 3, '-0.627737755453322045153839868818725941342581083374365847114175637654789771522423337371365222085509581114051552974901242140442158144665425149918573583550747352336927694838021911688632104372598995947590541265215427638964198192411973901748308397783752726906265172813108553810845321473034');
  t('0.799492635408075153820179893773848318631016479884932938799771955954948896655780624853585702983281806945', 234, 0, '1.09720452886503926230810016889667110699346814422697836857276675980929399632799216470079959047948329734324537822551034088670752530094519603439521886002197743149246039095213076854706767812617640124839271737223460642496284606724557814596');
  t('0.224', 185, 1, '0.22786347144452632046165173500710811553713461278623116739519601819855193522998104465852181631534628758366881976536154107429780497012440915726045278849039598202968006902164505183589159896');
  t('0.45', 70, 2, '0.4847002785940517415606642271983911528364030299926634518515513212561036');
  t('0.90456435539', 64, 4, '1.496778217337276147733338664547513755680907350349891554969078375');
  t('-0.167167607734473438967675100524296', 69, 0, '-0.168751416277484092222447034495865541774712299184805485774418373422763');
  t('0.39346396642196313634', 295, 1, '0.415891924656022114411308167484931061252248711726168969717840928041721731103779709393853074420840080513127337938387816637732069845444067243477009926894918364060015778884946699283447160614186111382564475425458640061518584822312961058756076974655392515933882819933687140446748674016134466675430786');
  t('0.5110796952165096935731204873748', 151, 2, '0.5641901019757929113627884069151371616205417915862877766246820892504228772691345201918257817626143024303362324777863087459340457379199314813305844013175');
  t('-0.475143189208', 80, 2, '-0.51669242872449880253356673126617630078734592296927663576719075923086741472963711');
  t('0.0650003863442269001997965624678998509161257660254375671243290756933084622767420959877086125201575954190411861435139590689743642996233756034057693505449107029893596558796547374892451894231071', 24, 5, '0.0650921624108860348022739');
  t('0.2082179820930656', 304, 2, '0.21130784347607275075071280209489049983594509334060846357522984164908003041545137487955224918007505956636906860462948697635027668616300776092687712338802790262368272000468297072988904238496423710278279373420403574393545198178641834370213961830423234722077395942084238001879677485797367716302555547212444');
  t('0.225676000434852126729843744815306847896', 17, 0, '0.22962870888679599');
  t('0.726468166', 243, 1, '0.921207534115449241765581908654031704912901605617646177673416934984124846650090464601046254421930869576274334336790630990432618328896262362969134661361783582371262226472878642702702695217107844471640914409496395461183036171538183322466898619404');
  t('0.9487272', 214, 1, '1.81888566167878767894993179999633067733616687623119632854364742295344229976123935336930609574826821059876023621734241300878512255868280600122674507438366731065392243088134624087947768152601064068678155976863937482');
  t('-0.0504552027137731827754807628995759014123503601097', 215, 0, '-0.05049808329558655893728132326677319324522257589302092769885175547954213761646674635827890931517431148336322496618452249752295407646172902498832043016442402381991601213372405520029303594842727534394403851806884140266');
  t('0.64638495328205701992223400188494316387654249514343', 187, 0, '0.7690641715407690155113652677905878825610904755391980165353772682457556967588692416700584255029254430469175961409044653263492458694641853486364417463501680720058821702799837967438192181894');
  t('0.4363957719530763682010413519572082080477084825722273168925194517611926193311972859206526749628251681365651108907465652122999119265950046065911440658683145857410504188272976184840255120733515721922893836912512133015286633504583748131009809272592343415974268152765763764824344094315152031', 4, 0, '0.4678');
  t('0.78389', 196, 4, '1.055382057365593952737925472919998914964710667623345470127442984594654512064156269471954366008504054813304106849671549263026264894072335307916831647320967926852448362900157151529513611737372975544');
  t('0.538263902756984244939887339713548997218423466887448293029560667', 173, 4, '0.60170810691435236862015184245057965060570525332333050030490169593903713046697351109207982043419873041821959187568177871754246016034956908469872486559162810305983883976908875');
  t('-0.2045259425746837244', 87, 0, '-0.207451562140210664665753497832555950054995234940572864215224656790241349243557170728547');
  t('0.5537', 240, 0, '0.623701545231365622777442131327458584702461990125760309854238527332789357553269353423873362995355745433264654880376520846869013245924946086962014583188582432074901659495126518693317471770693400078442640158010255834509515443056737886151244555');
  t('0.41314242077085316256', 21, 2, '0.439394502611599066569');
  t('-0.6422', 262, 1, '-0.7619089571000348038332489523681974603841401292517733381062592862118937376336776330864658044040472837191400801085350937282969286377543762187312156330734505007262906783703535980724833153839306387519474679846174009253097241643423342113482917329464371514735085897197');
  t('-0.73755052252277949095068698029881187388287', 272, 2, '-0.94508652898651035087224605234047601846591772945560991195789978915582067095079799858742731472618084123855582609100413347499624307275465484406315465594544127256922570961360532525588622630309666700486789941691118324957277949808481803508307937272675860025064422771931330396237');
  t('-0.557576105063759007857364505377378052558057811340526010795990423080634426725797654', 316, 2, '-0.629308826130303566449983587804814357443222245138365111089913510316398673174439637915895915190680184408874896230578526548941429005057179076855491860401271237135618779830553791298401686636646331037687156810440493941515101262937245761920911948427725327219719615247999780821371561917843015098995275924262443505204552296');
  t('-0.397376282755286193632892469851930762749811424801321077566111509755327087039064311728435545675183355372984395937379977900547542469552530272226417379971423501269575434572242552751', 162, 0, '-0.420529344727161283368490297578093655401666884197462919020339661486717817161865331024303002740302054768207009108283459264940851619522949030127347019868222004593149');
  t('-0.551347', 133, 6, '-0.6203145521664465070986904990305957976356393749539797028922429993300324818277943005303027917613111973929004644820979685967305007977015');
  t('0.888', 254, 5, '1.4123872377051757274639648758673472312508810970544242975866632783075069367415264625887723941055904647796918331853022535525065125422999518727010923024170321176866070458440327752066229769192629863159322368386644451798538534822447055170835376483999980549102');
  t('-0.85120460632093613939262421061714583', 33, 6, '-1.26050983963178667639874838062063');
  t('0.84388219226684808790069288794584310158759645745211', 199, 3, '1.23450880749787962918402458727719465258152447209002202470072256813338187954008532004830856301367480031515215688488217607006706287595661950582945801196412515010116973437156781325755369580097757490935');
  t('-0.3001094463532931184956933481945993205665581825857534941007663593953535', 150, 0, '-0.309639879261266467371519740416601782985789422142698173476806974952086755424840124518669986998602994762158389572860279641822610762510485788799893185181');
  t('0.074', 276, 3, '0.0741355202113153067466012428426089693428025868062340965353359626649821255846235748834524006703035226602412353079425211951271654478502940179037568349365093269946072447493894800473619218351822397815549727304402245948199776638508413362160815627499810475477260913796041996292479682');
  t('-0.5459877879202066377140152', 214, 5, '-0.6126471167181840583899677977398656055003923676794447483185964585802761952970436789932343233080127140637676695053683422488311858266141708613576325751961320431492509300826766345095969084746341863280841703841710444846');
  t('-0.77321937916608142499512287405430509593078611484368137223059939522584999712066628139374733686623399341404866541255628430655270308177843673077392198374533005631431314795', 26, 3, '-1.0282844547948804863372644');
  t('-0.330623443102462662135226730904717754622941289915803060302970658275960217867922548438343914223720967', 249, 3, '-0.343528049250293182400191489972084140128361215952688306762356186301903566013306952257967630469892794273365354684469258254336042476373882539854785473445581410046217082413096724320906513313925494914181869779726502273829373624548044277518362628998826487');
  t('-0.6914503442729', 170, 4, '-0.85072942138435912856060574511360632165353169369104027463901758369841782464535453213465286613104811980170508976011164145683750304243359685746569363515721052112265329744492');
  t('0.56891419636911479526936302282020641825853750861065425004277443085398743443828505621548004846221129691482111618728053146800281127952782040760043', 170, 3, '0.645915956885559666791088163071739564093397440299125336365614508697572084241091444594093170412657249823199601236045403440374934908236841890848030854313738985102100028433');
  t('-0.268615432246818170687729266278642405955545553826457221442563396055978288730606917941191757158543457249633', 5, 6, '-0.27537');
  t('0.976423547677484829702389890926621331317767553738953065812571332848120268068139564123999497028200735330502560715451452023319826017878243897155346743887', 53, 0, '2.2143978851795512756319575723774754370876561234785949');
  t('-0.168019292735369394109471434220882869925859785631412758152541458671294086417226718', 165, 0, '-0.169627714418072062732228077089154288359489589629869065676228596357987618806307606983259061452334377841644709506611468138765052736911468882619453949911769092709568717');
  t('-0.68337268521647099201502665632095238054799618705699156173312187704205806', 204, 5, '-0.835414595792291213321007074443117448899971812767154724956188023196188567306237490676425072863495703779701689049119532340589604017880454256442517981204587601900413685399596850661841408286796888313139326996');
  t('-0.71176085229359654064336214899908768439231967513132464095600188359146219646038465271517', 195, 2, '-0.890743674158320800836892481276686460912552758720792561166741935569196624482515333652627974887111402167629141995425358084500959022729256468503240220560416480208546037456617289578809554763291032637');
  t('-0.4293877', 176, 6, '-0.45914572746806078301370189650918022698141442182567852586344799568637136367363072240852060790784561951281864290071683223287891471665640409803931037257296673336606123409549036518');
  t('0.881768492729705208614294967538285114270777', 194, 0, '1.3836613364275191662557155069564889290781066189066180820661139690670691139631491386468241441694991783437327357827025835785179056589732057409772679743102126111681536393249873294685753524042967738');
  t('-0.6510656861955154257580418792238970530699632703114', 104, 2, '-0.77714626846900030758823309952599641242321294394590739570608471900570080614021956654155021024160386079614');
  t('-0.73750148498173384548587606375933467748654753534512', 248, 5, '-0.94497900358096136196213981809251735394038523291902562437209076185916772016831535677978740936138502180766347246059569983614961533314622607987966474844329163294825398763283445505369850009108787816349791031893112036366418924715209862525402500988600276');
  t('-0.7800512169531994058535283731230011063702', 282, 6, '-1.04550135076244552387535445524097724327128691626977542811773568120980716172075828134128428446489339616130195908241205339528429028363277816901798725204294926474646108736744908658231293038901310460565376730964417259361519201991482240492680763125741767222042392130548915059312793128043');
  t('0.0376300302668181625506402520636835695459205137837640588921238363869291975', 66, 5, '0.0376478069874111742629588211996649472589745487830774960526058260198');
  t('0.733417', 176, 2, '0.93608212209863379138610267241493798091766957512485173264857541511679429022218288588875888747226665587645103362216625054148201205198413833648252378393613754150569040017190621409');
  t('0.37468810111179094419111763919736593567579460767166640490650959661707474202080064331858243788173552313208391878136910358020960608732613862058948172688852819227900949500951', 233, 3, '0.39386579266758034895318250902856199663969308026398959844182108801022867061650510638318066064105857460599445674254280041591073538930989370451476140761821025639024835040854225996546717792204928131317430301377998673215297718379125739568');
  t('0.394139464560967509435', 256, 4, '0.416691406293018544733342260278003394308277028283512660880289109250635101995021265646276104314122693296091688416617011150477072854623446886927988132338696963765906298444800415632005405942132500009054604834778401974629218312708424371077266275281390679893917');
  t('0.4549482746386127511589227012936031', 240, 6, '0.490922464908732523431429616943041278388013850575247956511244165000974015557079179218279972483599209897715333427314882887737268568695319010619017299124621100611299063391548818736742131932096344675972983969873246038740896487036103777311584336');
  t('-0.4317672464', 309, 4, '-0.462066842314849866294849870023749017626720744480873604393092418590172630558531646393081159894032367332222554636314930448095719450066160043934099520790501045547684731763253958750687109720447512668987215882019345437399437197838493571984587302368569606808023006538989329770328998839225269408275727675401314111713');
  t('0.48653997', 283, 0, '0.5315171713832122245054086925673204889514730605943308538143846588763783508099432550772514250282028340601177723743056274673478088099320178590830475737424050966984503842470702266934491190128948499267993696036408062719767171968303223969843420999723270019921844364877277282389080758547805');
  t('-0.4', 259, 3, '-0.423648930193601806855053753260327012494797085879555868362347908150042784766730150457021371887069719102545832569946637584677874015873633511048078112198311682652330849460446708101442825082053207254381201694028820123344992784244739840343434350947747459505155343');
  t('0.2539424165955461537658553565381366', 270, 1, '0.259622506791623674569127236702617423862022427224931755756687211897722974478123296210145021859883534370387930936396951377071513540851603291966982461899631143568419074571261878432381321382545015740477908484061066372822567856180800664003323984210532674991631305339807059692');
  t('-0.3317657824', 176, 4, '-0.34481112968404296746414896352487347815580523166370289918686317742717829359087167331178479519340620492151229925014353969979699796793783964679809753503424131439548494681382821538');
  t('-0.8151502533964567716203214600969984903225259842947285784', 265, 3, '-1.142190106476675106675852459693524121125077986732364308974343619035156397443996661193140149218616276259864880470358414616434423129622564391609762593971283199005637149152721989762039943885785095923793732044407540862167453747021682134722373337056259544324122808034254');
  t('0.1372998546429801640869237342151', 229, 0, '0.1381725044041005435596843792823999534698582907195461987715122123117299369481647264809889171702227732006320125373704793409219630307278726070998990690059175094184800150223384803678763469961135146693315773045202660253878744299241323');
  t('0.179312', 223, 4, '0.1812717418538369581213732454130349684924350300489387637421692799527687563346146762416778961036988757331795177472126650183882750751252301090544966091973677031682278024345296921784036791267285752122797420447743952963928193155');
  t('-0.649828408383079', 33, 6, '-0.775001635230188028797094320304228');
  t('0.23819502', 253, 4, '0.2428596889688385315583757835051528166865662174052661224435034256641882674634712925541448578900506330842472522041762016228734254315953244112722997719064517354448909053363510912181979079896877719609292101846969698006037281481486165610579790437324361965146');
  t('-0.624195764512542713800421707029288', 125, 6, '-0.7318498503010666289248352098995469273700426211310091795857798137882961797972485634876870827014757857858551305343510665504105');
  t('0.61535736423040134821558902167323544211407329606331416537072234230873963245988517167106510098531562458945407092319336058734226914', 78, 1, '0.717498402446946452695168288509457420898912491868676272767527390567859871526704');
  t('-0.8895808586749327750012668010437911055629014854522518002565237981413399338471508098950079493824248', 275, 1, '-1.4199134075904524473822213631118376342191054512420432359652658640427944597343400968775771792079189063675785870979990834592504396380038734462105557019455677872889437256771263272723397874923752144619542690663349524324651340478313016875662444194685805672910311275423512637393779');
  t('-0.29983783436372129727810500566813050718910808361725451126006382460897025595231618061376519108559635709033089401236939942680740623002', 144, 1, '-0.309341409731804917455183062521621814443285614683149370247112330096217357536840035126320043175896428054411974089985666048848918624560271238730477');
  t('-0.648041295124025234927111713876675467187815581602518598437458860980719102684720961954084955560381189132614492632309309249', 7, 1, '-0.7719144');
  t('-0.7358804726035659774653219698826142749278068263307194615922996252732705790474586946603535185717230850427981120085919341826162881051476144823305053434291', 60, 4, '-0.941434142344950073325764342420004622240726643008090583210384');
  t('0.65', 122, 5, '0.77529870620558346517591803572223763741605634108915271924693594641524402718988820608050598211424767660481203037412236167645');
  t('0.944943667657', 190, 3, '1.782315703749103747538581000604758166614915458596909401472445492746446952166620549510167388661376973021473663755904790778810363922048159192493019450882747110146267841359507430517239890425242');
  t('0.9182143736656068603', 155, 0, '1.577524253794876620088627405716515393859916067225772418508252775297179666130912384405524157899932864121313677475806402493230859527006192534007243580690151');
  t('-0.1472750385635890515651916130372460300167381296036065082327178822119100633141471305929737553740054238294774873521009702457125357204267478198808180876055826356413', 232, 2, '-0.1483539095807219073929063776886688739539811062727061292685754469912479799523142966461895933422705023931510723137873944278968631964943971616668070227677974976251823336038139016028859199952685810029502531369985708925972935127284151275');
  t('-0.5922422', 313, 2, '-0.6811125599123083813065354933054411478354924316102847795459855862185099824478853694796053359358663550573478694496313614817244396508686618920895775686495504220903773700012676774746350386613581964992726979835102128464371006113164755873312544282587480809836375632619154437448810179907267747404349780085200459092582487');
  t('-0.347821477312804072482726332367091896500755242312', 33, 0, '-0.36296325761172879191833344671405');
  t('0.1309211750227495846971038296129409945453', 184, 4, '0.1316769749558431627502073730865841079742838316311369563050988373924611185394315046558424417731350316299667442915195311871970129205122024838882833471089003305144878172066471840931662665');
  t('-0.996766563794820263508193732288548218418893716590017066353216418843303409237396990595688341161593072790362793189864501020070246638680550825029749484022466382539353410504302880948023940541950459738453998555763674873914652404', 311, 1, '-3.2128695103852060432840010371836377120754262023107034234022392337065362533358439618790180951848138821036576533656411837214706360831689127605224789629273458667512549125821763170122734881934174856233480280354105426750822644504721866138650941606853356011757567275380771297692791654445616148920368524993636867655376');
  t('0.805677871239960052757710732764520174447089032695327969119503078761008957453107292030787955607248225201420133213046144411969126449794849512', 260, 5, '1.1145870563223313456730645194855930303047969033328031366313408147100700289741804948949107016253040681563372610627197787341653436658874233396928991556147209685559108146892458220748416103153856508653769701170647088793964748052497292257838770128921220831717925446');
  t('0.9876985075874790941980693098778262612047502544315627487816', 15, 3, '2.54250606510159');
  t('-0.99', 188, 4, '-2.6466524123622461977050606459342686009455526402847362494532304939720496026904579500629921371491090237370529131058463561407329454212693198283315081387104527957175699326161093958197682341514');
  t('-0.839050509635217011444270360895276942', 228, 6, '-1.21795704936130385631962494542356977067936935399974189438096102749427256397266187916658227349609843365673465722028562699709835096783864653593134242282802505320920517284118244296063864756540940504340850900132913926246353670954852');
  t('0.1466192868010720075349817406966274402677683457511446712802131462267743942318212540053135924201060473518701490421890859006244563601526837941527661256', 287, 6, '0.14768368532564711402494213463037701768191759827803850168186782193604720719015708712743954223752733158524998429426137852458472414766495891880038236534395643254561682940366809599598002916364125620840332914673709216743136572021518680177388027192234191630202329885357220548436336429074140695');
  t('0.7633374806958102030413743715384253532064892029119268282030519395', 206, 1, '1.0041642155179872943403547725421083834055437323943454959156599731416665977609674764526473655994641313895968605200676576407250453182984764160284761288351654323925444102935566025247571802592800202812490331785');
  t('0.87281814778656906038563301116674583687238', 243, 0, '1.34479081843481443741407786766373995381573153874510635485223412414173085352064411929655249326647793754890443512785266756368448226089651944475069887046770674810917469868559393788068633432881155913833789050887712403039367262948644349414529586968');
  t('-0.555429', 129, 4, '-0.626198449288212900520759114325139942913337921697428998949440635449650971361380373375064763452486973668863523470884757595838847037');
  t('0.14', 1, 6, '0.1');
  t('-0.64985605644863155539671287422250124455690800504', 116, 0, '-0.77504949367363640817393024164424989438893672787572092670043395033655295140534281875840833633690046845270303564654699');
  t('-0.76466323785395591765922667770906930985488728394648574267445255232047039910519978105980337041691229487590425362595019955579', 201, 6, '-1.00734881616766375031531233869630350165415813472759520804180626684990853455758099495225530160802948239947799323050526696126843427033829028329285079138437306956140458098730026097497785092814548200371929');
  t('-0.427487775669451096437861925146303810176873717836384459985779775576884096928996261595267679118040931368456875872675713713558818778793708835114783282', 108, 4, '-0.456818645148324031564018632840774980454891177680489171390572878558788652873515709481347301271508045045845829');
  t('-0.1449186558766952021695963330511391095458355385142811778330526484141810881714319771710501032712316624345024952853814497577100844028662551225361429525246849464437625218898388462098128724063164945492631740394269588579070768494031948899169515929218895271036513308621878614041712826642379361252957969386949', 24, 2, '-0.145946133412709795234519');
  t('0.779862475879042039888850851750295017780164503260766928024990716941707347165975', 92, 5, '1.0450194594329108881849800752453175506290408614411164127789995004594809451960070120371381517');
  t('-0.764735727488813238158555632279839911492150515062063521518660041587206676612672318411061908780670276038415821666418033946508832485156287566755494934248', 30, 1, '-1.00752339125773819029429459872');
  t('-0.820503035231161369520726', 206, 2, '-1.1583549182229621878286338766102930312827896179519421818592218409475980224526794559436476451646818133161861493110366621392631397193503361924450060701226312795388557021816180484052961946433619174880092415637');
  t('0.42332', 170, 2, '0.4517299649427408466710905267979672913300610253868037471412579002676780935170497379358317328102221834008985691372623103540530049001008743619766099225362482737964947529822');
  t('-0.7375163817994086591222131015595903817', 67, 6, '-0.9450116662694306114265573074731020386327193321709652051950058480289');
  t('0.8652230873', 245, 1, '1.3137575148706593901304963388391266145336962321475892708335731888878750074081564188302579767622392591362237811016145282883208568731529864792207599373284069758112890325301465795232099114089706313456628968963889201672822024453209465781162001343773');
  t('-0.98836027489467533191700478688', 268, 0, '-2.570320884975012816200775025709368813365394613635051706855610893984432915092801454176830211644317340087864012601513560521999111598145731347378133398144799525539839592222639027553457741459958058106463919953472108053106429068065700603590414775639736385930372899832054524');
  t('0.73845772095536', 85, 6, '0.9470788412512262710341160424156186231784972621364492579356177210560706312343071947251');
  t('-0.7293292866299409883424619086451120312472537388006907917527288152091744741168423992679558', 194, 0, '-0.92729295723621125577319032643333213145820891066148378432607304638719721073195873825258290314472102178780389184644868557611268933868055199316346364162175631871577356534537056752420348437998660756');
  t('-0.7825695594843049451949567108099841991728353774589643025605547344984096600696439931090097397939083540981320411873498098063243917', 136, 0, '-1.051966094712088483885316352627530023040346576726546234923873534993321686558968455669987955323026935563277516065271973846951509793315491');
  t('0.9453', 146, 1, '1.7856538881879179088307024477327789949832814978700375423527585017581381485273369983060172967007346218124201836953061387558647303087652183555544866');
  t('-0.5295637732515735037582543768898198892986517775820618045473690960623237409063607790056748442343992311343808235830037207321222640958759284845978450758280524961215915568661502310372506367493729826637925408203279223209686512809', 51, 6, '-0.589538725973457916061002294839590521825424159079444');
  t('0.62879986225426343421231713154966286208153326174058274909972264817569899981598384682505056916249271019851243559727314158485805416173122666445990250232023803919544632303107624488256013468', 36, 4, '0.739428684896556396617680568499766907');
  t('-0.99994571518980279237', 315, 5, '-5.25719307324314469485612969880101673464771169145455548344986373729320455157727194530039767751269969746612927764363740851600151756668241698971028256245105243266515435494695241955350531783470291286984083210663776119652426879206595698943456841454478078379178073480789966148330480113618479581097370656042464790854613395');
  t('-0.080545447109300540633021189155140834269439605952969677849115331394005681352457368462', 244, 0, '-0.08072030965862720354127629498093121901045349415894218086924986249034960931150782781180761608316758206540796194319997844542410413571498884550988733222344504567591619573378945397347721946341548030538906751041381009318184701202722097743780940423689');
  t('-0.807595871075189', 29, 2, '-1.1200774976111517282216578112');
  t('-0.195128689040577739417805093649105050558384768497085755947685963299574972', 231, 3, '-0.197663372832086402908787580217820963548470529110985548603482311371914133445903124220879413733836274879352890343368861516150209135173383328579710409457605090039441651246184423877919115114161583428800490021154582060214945781547709651');
  t('0.5284003801102602736020726984983472745349121617', 171, 1, '0.587923300804689050428674555814450837920964515637269948977676454629999254425235672207639352366365043440640698562078147641238552251124228844586411605911419242257514148412269');
  t('0.44621957331', 68, 6, '0.47996998674230532343822415602905783515463939292829704565951044924618');
  t('-0.2709992415234693165496466406925361435352645157078738275166200840497289955', 11, 5, '-0.277941951');
  t('0.2151259080971012472474918833523397525360466868171849937426090838987121502751484365419058', 273, 5, '0.218539833015657286402623805109432540008141398197401053630902785355590781053495961933637546286892434368906056965035154965958349566138944731809703413917519920397823392532571452889900147217949425964640625026961752371525398436582510787539011266191139869195715997592922519766326');
  t('0.03833444449113811176822493642246705085242417526466218422461300011593276805903195', 35, 2, '0.038353238932716518643506901849066669');
  t('-0.248214312103589828621157909911917932845711593642117987443226149718448356047086412692489150912739795010660720240335333136927811826314183841524987817686699078760019626113626795536028808319476163747', 307, 4, '-0.2535089823976185582187804199723490902887822910787870392454723480514053721401668519188207476085407188932431397336883977833194469867130891388811304794109769512658917122514255829502000189528145803013718121395684794408146647635758203594491719337180163663815706028246536692074357449208097157287778301549631151891');
  t('0.4833770051411726347', 21, 6, '0.527381568067010908227');
  t('0.174056076488701359634', 104, 0, '0.17584644128249511878622033897963050748708406976957806626646527409247247717064133205096328182338226571197');
  t('-0.45784729315564950951934166871177490300440641557386031104', 235, 5, '-0.4945842305884620795925160277837682015967465333948669328810191732753766254816083108635615597999119403371868649035693128261045516753503443666005769946240834009457383867418354279211593310851737698046604706005399592855560777741771362366264');
  t('-0.872579302251402339806166761626318157367935736189754184939549082264328790406513330715103046402441092476406530843028368467662109333221806760186120461848939833626779310198', 287, 6, '-1.3437889364247025433148979243663750789194317297727807018451608437312075739136818383629515620667369350971034914140375629463601319019166943805935355204936406694972501475639488296016670915206501138020598890567973695828859294016055317494406170505800217456089733192775047237371329013986638659');
  t('0.1815737686665864014987016944388560671014233806', 89, 4, '0.18360963251673617585735514105475084817743414894544789363639051170088456975854393211631838');
  t('-0.37265646233716804722479097121318365014735', 20, 3, '-0.39150443370064754527');
  t('0.0797', 253, 2, '0.07986939995414175208043904996845297385460176169003718353939128767528755481938934497755555209020339850238364350758547886230285042384986659961301325714649732629177151058324339115858308507429728549405136892851728167228522469101443134231829493416267582123405');
  t('-0.1089752190313487560903960981844967611', 252, 5, '-0.109409701076893642220104058960155361324700274686560960807249771106995187215844080992753719826712933129477615536055983708257302997211720560529849083931589160406353980591055978490033770426423393286285330382391246639425123267777577081284158212108941527682');
  */
});
