"use strict";

exports.__esModule = true;
exports.normalizePath = normalizePath;

var _toString2 = _interopRequireDefault(require("lodash/toString"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*----------------------------------------------------------------------------*/

/**
 * Normalizes `pkgPath` by converting path separators to forward slashes.
 *
 * @static
 * @memberOf util
 * @param {string} [pkgPath=''] The package path to normalize.
 * @returns {string} Returns the normalized package path.
 */
function normalizePath(pkgPath) {
  return (0, _toString2.default)(pkgPath).replace(/\\/g, '/');
}