/*******************************************************************************
 * Copyright (c) 2012, 2020 Original authors and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Original authors and others - initial API and implementation
 ******************************************************************************/
package org.eclipse.nebula.widgets.nattable.grid.data;

import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class DummyColumnHeaderDataProvider implements IDataProvider {

    private final IDataProvider bodyDataProvider;

    public DummyColumnHeaderDataProvider(IDataProvider bodyDataProvider) {
        this.bodyDataProvider = bodyDataProvider;
    }

    @Override
    public int getColumnCount() {
        return this.bodyDataProvider.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        return "Column " + (columnIndex + 1); //$NON-NLS-1$
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }

}
