/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation
 * nor does it submit to any jurisdiction.
 */

/// @file   QuitCmd.h
/// @author Manuel Fuentes
/// @date   Jan 1997

#ifndef eckit_cmd_QuitCmd_H
#define eckit_cmd_QuitCmd_H

#include "eckit/cmd/CmdResource.h"

//-----------------------------------------------------------------------------

namespace eckit {

//-----------------------------------------------------------------------------

class QuitCmd : public CmdResource {
public:
    // -- Contructors

    QuitCmd();

    // -- Destructor

    ~QuitCmd();

private:
    // No copy allowed

    QuitCmd(const QuitCmd&);
    QuitCmd& operator=(const QuitCmd&);

    // -- Overridden methods

    // From CmdResource

    virtual void execute(std::istream&, std::ostream& out, CmdArg&) override;
    virtual void help(std::ostream&) const override;
    virtual Arg usage(const std::string& cmd) const override;
};

//-----------------------------------------------------------------------------

}  // namespace eckit

#endif
