
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetgramBarAttributes.h
    \\brief Definition of MetgramBar Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MetgramBarAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MetgramBarAttributes::MetgramBarAttributes():
	keyword_(ParameterManager::getString("metgram_bar_keyword"))
	,
	colour_(MagTranslator<string, Colour>().magics("metgram_bar_colour"))
	 
{
} 


MetgramBarAttributes::~MetgramBarAttributes()
{
	
}

    
void MetgramBarAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "metgram";
	
	setAttribute(prefix, "metgram_bar_keyword", keyword_, params);
	
	setMember(prefix, "metgram_bar_colour", colour_, params);
	
}

void MetgramBarAttributes::copy(const MetgramBarAttributes& other)
{
	keyword_ = other.keyword_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	
} 


bool MetgramBarAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "metgraph")  )
		return true;
	
	return false;
}

void MetgramBarAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "metgraph")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void MetgramBarAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " keyword = " <<  keyword_;
	out << " colour = " <<  *colour_;
	
	out << "]" << "\n";
}

void MetgramBarAttributes::toxml(ostream& out)  const
{
	out <<  "\"metgraph\""; 
	out << ", \"metgram_bar_keyword\":";
	niceprint(out,keyword_);
	out << ", \"metgram_bar_colour\":";
	niceprint(out, *colour_);
	
}

static MagicsParameter<string> metgram_bar_keyword("metgram_bar_keyword", "curve1", "");
static MagicsParameter<string> metgram_bar_colour("metgram_bar_colour", "blue", ""); 
