/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_2d_prhg07.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;

  double t101, t105, t108, t110, t111, t113, t114, t115;
  double t116, t117, t118, t119, t120, t128, t133, t135;
  double t138, t139, t140, t141, t144, t145, t146, t147;
  double t148, t151, t152, t156, tv2rho20, t162, t163, t164;
  double t165, t166, t169, t171, t173, t177, t178, t179;
  double t182, t183, t184, t185, t188, t189, t190, t191;
  double t195, tv2rhosigma0, t200, t201, t204, t206, t209, t210;
  double t213, t214, t217, t218, t222, tv2rholapl0, t227, t228;
  double t232, t234, t237, t238, t241, t242, t245, t246;
  double t250, tv2rhotau0, t253, t255, t258, t260, t262, t263;
  double t264, t267, t270, t274, tv2sigma20, t276, t279, t280;
  double t283, t284, t287, t288, t292, tv2sigmalapl0, t294, t297;
  double t298, t301, t304, t308, tv2sigmatau0, t310, t312, t315;
  double t316, t319, t322, t326, tv2lapl20, t328, t331, t332;
  double t335, t336, t339, t340, t344, tv2lapltau0, t346, t348;
  double t351, t352, t355, t358, t362, tv2tau20;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t101 = t16 / t17 / rho[0];
  t105 = t15 * t45;
  t108 = 0.1e1 / t38;
  t110 = -t108 * t49 + t39;
  t111 = t59 * t59;
  t113 = t36 * t36;
  t114 = t37 * t37;
  t115 = 0.1e1 / t114;
  t116 = t113 * t115;
  t117 = t33 * t33;
  t118 = 0.1e1 / t117;
  t119 = t116 * t118;
  t120 = t110 * t111 * t119;
  t128 = 0.1e1 / t53 / rho[0];
  t133 = my_piecewise3(t32, (0.3e1 * lapl[0] * t54 + 0.3e1 * sigma[0] * t128 - 0.12e2 * tau[0] * t54) * t30, 0);
  t135 = t49 * t133 * t64;
  t138 = t49 * t111;
  t139 = t36 * t115;
  t140 = t139 * t118;
  t141 = t138 * t140;
  t144 = t114 * t37;
  t145 = 0.1e1 / t144;
  t146 = t113 * t145;
  t147 = t146 * t118;
  t148 = t138 * t147;
  t151 = t62 * t118;
  t152 = t138 * t151;
  t156 = my_piecewise3(t3, 0, t15 * t101 * t39 / 0.32e2 - t105 * t65 / 0.16e2 - t48 * t120 / 0.32e2 - t48 * t135 / 0.16e2 - t48 * t141 / 0.16e2 + t48 * t148 / 0.16e2 + t48 * t152 / 0.16e2);
  tv2rho20 = 0.2e1 * rho[0] * t156 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t162 = t15 * t18 * t110;
  t163 = t59 * t113;
  t164 = t115 * t118;
  t165 = t164 * t74;
  t166 = t163 * t165;
  t169 = t54 * t30;
  t171 = my_piecewise3(t32, -0.3e1 / 0.4e1 * t169, 0);
  t173 = t49 * t171 * t64;
  t177 = t15 * t18 * t49;
  t178 = t74 * t59;
  t179 = t178 * t140;
  t182 = t74 * t113;
  t183 = t145 * t118;
  t184 = t183 * t59;
  t185 = t182 * t184;
  t188 = t74 * t36;
  t189 = t61 * t118;
  t190 = t189 * t59;
  t191 = t188 * t190;
  t195 = my_piecewise3(t3, 0, -t105 * t76 / 0.32e2 - t162 * t166 / 0.32e2 - t48 * t173 / 0.16e2 - t177 * t179 / 0.16e2 + t177 * t185 / 0.16e2 + t177 * t191 / 0.16e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t195 + 0.2e1 * t79;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t200 = t164 * t83;
  t201 = t163 * t200;
  t204 = my_piecewise3(t32, -t72, 0);
  t206 = t49 * t204 * t64;
  t209 = t83 * t59;
  t210 = t209 * t140;
  t213 = t83 * t113;
  t214 = t213 * t184;
  t217 = t83 * t36;
  t218 = t217 * t190;
  t222 = my_piecewise3(t3, 0, -t105 * t85 / 0.32e2 - t162 * t201 / 0.32e2 - t48 * t206 / 0.16e2 - t177 * t210 / 0.16e2 + t177 * t214 / 0.16e2 + t177 * t218 / 0.16e2);
  tv2rholapl0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t88;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t227 = t164 * t91;
  t228 = t163 * t227;
  t232 = my_piecewise3(t32, 0.4e1 * t72, 0);
  t234 = t49 * t232 * t64;
  t237 = t91 * t59;
  t238 = t237 * t140;
  t241 = t91 * t113;
  t242 = t241 * t184;
  t245 = t91 * t36;
  t246 = t245 * t190;
  t250 = my_piecewise3(t3, 0, -t105 * t93 / 0.32e2 - t162 * t228 / 0.32e2 - t48 * t234 / 0.16e2 - t177 * t238 / 0.16e2 + t177 * t242 / 0.16e2 + t177 * t246 / 0.16e2);
  tv2rhotau0 = 0.2e1 * rho[0] * t250 + 0.2e1 * t96;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t253 = t74 * t74;
  t255 = t110 * t253 * t119;
  t258 = my_piecewise3(t32, 0, 0);
  t260 = t49 * t258 * t64;
  t262 = t48 * t260 / 0.16e2;
  t263 = t49 * t253;
  t264 = t263 * t140;
  t267 = t263 * t147;
  t270 = t263 * t151;
  t274 = my_piecewise3(t3, 0, -t48 * t255 / 0.32e2 - t262 - t48 * t264 / 0.16e2 + t48 * t267 / 0.16e2 + t48 * t270 / 0.16e2);
  tv2sigma20 = 0.2e1 * rho[0] * t274;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t276 = t182 * t200;
  t279 = t83 * t74;
  t280 = t279 * t140;
  t283 = t183 * t74;
  t284 = t213 * t283;
  t287 = t189 * t74;
  t288 = t217 * t287;
  t292 = my_piecewise3(t3, 0, -t162 * t276 / 0.32e2 - t262 - t177 * t280 / 0.16e2 + t177 * t284 / 0.16e2 + t177 * t288 / 0.16e2);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t292;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t294 = t182 * t227;
  t297 = t91 * t74;
  t298 = t297 * t140;
  t301 = t241 * t283;
  t304 = t245 * t287;
  t308 = my_piecewise3(t3, 0, -t162 * t294 / 0.32e2 - t262 - t177 * t298 / 0.16e2 + t177 * t301 / 0.16e2 + t177 * t304 / 0.16e2);
  tv2sigmatau0 = 0.2e1 * rho[0] * t308;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t310 = t83 * t83;
  t312 = t110 * t310 * t119;
  t315 = t49 * t310;
  t316 = t315 * t140;
  t319 = t315 * t147;
  t322 = t315 * t151;
  t326 = my_piecewise3(t3, 0, -t48 * t312 / 0.32e2 - t262 - t48 * t316 / 0.16e2 + t48 * t319 / 0.16e2 + t48 * t322 / 0.16e2);
  tv2lapl20 = 0.2e1 * rho[0] * t326;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t328 = t213 * t227;
  t331 = t91 * t83;
  t332 = t331 * t140;
  t335 = t183 * t83;
  t336 = t241 * t335;
  t339 = t189 * t83;
  t340 = t245 * t339;
  t344 = my_piecewise3(t3, 0, -t162 * t328 / 0.32e2 - t262 - t177 * t332 / 0.16e2 + t177 * t336 / 0.16e2 + t177 * t340 / 0.16e2);
  tv2lapltau0 = 0.2e1 * rho[0] * t344;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t346 = t91 * t91;
  t348 = t110 * t346 * t119;
  t351 = t49 * t346;
  t352 = t351 * t140;
  t355 = t351 * t147;
  t358 = t351 * t151;
  t362 = my_piecewise3(t3, 0, -t48 * t348 / 0.32e2 - t262 - t48 * t352 / 0.16e2 + t48 * t355 / 0.16e2 + t48 * t358 / 0.16e2);
  tv2tau20 = 0.2e1 * rho[0] * t362;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;

  double t101, t105, t108, t110, t111, t113, t114, t115;
  double t116, t117, t118, t119, t120, t128, t133, t135;
  double t138, t139, t140, t141, t144, t145, t146, t147;
  double t148, t151, t152, t156, tv2rho20, t162, t163, t164;
  double t165, t166, t169, t171, t173, t177, t178, t179;
  double t182, t183, t184, t185, t188, t189, t190, t191;
  double t195, tv2rhosigma0, t200, t201, t204, t206, t209, t210;
  double t213, t214, t217, t218, t222, tv2rholapl0, t227, t228;
  double t232, t234, t237, t238, t241, t242, t245, t246;
  double t250, tv2rhotau0, t253, t255, t258, t260, t262, t263;
  double t264, t267, t270, t274, tv2sigma20, t276, t279, t280;
  double t283, t284, t287, t288, t292, tv2sigmalapl0, t294, t297;
  double t298, t301, t304, t308, tv2sigmatau0, t310, t312, t315;
  double t316, t319, t322, t326, tv2lapl20, t328, t331, t332;
  double t335, t336, t339, t340, t344, tv2lapltau0, t346, t348;
  double t351, t352, t355, t358, t362, tv2tau20;

  double t365, t366, t367, t369, t370, t371, t376, t382;
  double t383, t384, t387, t388, t389, t390, t391, t392;
  double t395, t396, t399, t400, t401, t405, t406, t407;
  double t408, t413, t414, t415, t418, t422, t424, t432;
  double t437, t439, t442, t443, t448, t451, t452, t456;
  double t459, t460, t464, t467, t468, t476, t479, t481;
  double tv3rho30, t487, t489, t491, t497, t500, t501, t504;
  double t505, t508, t509, t510, t513, t514, t515, t518;
  double t519, t520, t521, t526, t527, t528, t529, t532;
  double t535, t536, t537, t538, t539, t542, t543, t546;
  double t547, t553, t557, t560, t563, t564, t567, t568;
  double t572, t578, t581, t584, t586, tv3rho2sigma0, t590, t591;
  double t594, t595, t599, t601, t609, t614, t615, t618;
  double t619, t622, t625, t628, t631, t632, t633, t636;
  double t637, t642, t643, t646, t650, t653, t656, t665;
  double t670, t672, tv3rho2lapl0, t682, t688, t693, t694, t697;
  double t698, t701, t702, t705, t708, t711, t712, t717;
  double t718, t721, t724, t725, t728, t731, t732, t735;
  double t736, t740, t743, t747, t749, t756, t758, tv3rho2tau0;
  double t761, t762, t763, t764, t766, t769, t770, t771;
  double t774, t775, t776, t779, t780, t783, t786, t787;
  double t788, t789, t791, t794, t795, t796, t797, t800;
  double t803, t804, t805, t806, t811, t812, t819, t820;
  double t823, t824, t829, t832, t835, t836, t837, t838;
  double t839, t840, t841, t843, tv3rhosigma20, t846, t857, t858;
  double t861, t862, t865, t868, t871, t874, t879, t882;
  double t883, t884, t885, t886, t891, t892, t893, t894;
  double t897, t898, t901, t902, t905, t906, t909, t910;
  double t913, t914, t917, t918, t921, t923, tv3rhosigmalapl0, t926;
  double t927, t930, t931, t934, t935, t938, t939, t940;
  double t943, t944, t947, t948, t953, t956, t957, t968;
  double t969, t972, t973, t974, t977, t980, t983, t986;
  double t991, t994, t997, t999, tv3rhosigmatau0, t1002, t1003, t1006;
  double t1007, t1010, t1011, t1014, t1017, t1021, t1026, t1029;
  double t1030, t1033, t1036, t1037, t1044, t1045, t1048, t1053;
  double t1056, t1059, t1061, tv3rholapl20, t1064, t1065, t1068, t1069;
  double t1072, t1077, t1078, t1081, t1082, t1085, t1089, t1092;
  double t1095, t1106, t1107, t1108, t1111, t1112, t1115, t1118;
  double t1121, t1124, t1129, t1132, t1134, tv3rholapltau0, t1139, t1142;
  double t1143, t1149, t1152, t1153, t1159, t1162, t1167, t1170;
  double t1173, t1174, t1175, t1180, t1181, t1184, t1187, t1191;
  double t1194, t1196, tv3rhotau20, t1199, t1200, t1201, t1204, t1207;
  double t1210, t1211, t1212, t1213, t1214, t1217, t1218, t1219;
  double t1220, t1221, t1222, t1223, t1224, t1227, t1230, t1233;
  double t1234, t1235, t1236, t1239, t1242, t1244, t1247, t1249;
  double t1252, t1253, tv3sigma30, t1255, t1256, t1257, t1258, t1259;
  double t1260, t1261, t1262, t1264, t1267, t1268, t1269, t1270;
  double t1271, t1272, t1273, t1274, t1275, t1276, t1277, t1278;
  double t1279, t1282, t1285, t1288, t1289, t1292, t1293, t1296;
  double t1297, t1302, t1305, t1308, t1309, tv3sigma2lapl0, t1311, t1312;
  double t1313, t1314, t1315, t1316, t1319, t1320, t1321, t1322;
  double t1323, t1324, t1325, t1326, t1327, t1330, t1333, t1336;
  double t1339, t1344, t1347, t1350, t1353, t1354, tv3sigma2tau0, t1357;
  double t1360, t1361, t1364, t1367, t1370, t1371, t1374, t1375;
  double t1376, t1377, t1378, t1379, t1380, t1381, t1384, t1387;
  double t1390, t1393, t1394, t1397, t1398, t1399, tv3sigmalapl20, t1403;
  double t1404, t1405, t1408, t1409, t1412, t1415, t1416, t1419;
  double t1424, t1427, t1430, t1433, t1435, tv3sigmalapltau0, t1438, t1441;
  double t1444, t1447, t1450, t1453, t1454, t1455, t1456, t1457;
  double t1458, t1461, t1464, t1467, t1472, t1473, tv3sigmatau20, t1475;
  double t1477, t1480, t1482, t1485, t1486, t1487, t1490, t1493;
  double t1496, t1497, t1500, t1501, t1502, t1503, t1504, t1507;
  double t1510, t1513, t1516, t1519, t1520, tv3lapl30, t1523, t1526;
  double t1527, t1530, t1531, t1534, t1537, t1540, t1541, t1546;
  double t1549, t1552, t1553, t1556, t1557, tv3lapl2tau0, t1560, t1564;
  double t1568, t1571, t1574, t1577, t1578, t1583, t1586, t1590;
  double t1593, t1594, tv3lapltau20, t1596, t1597, t1598, t1601, t1602;
  double t1605, t1608, t1611, t1613, t1616, t1618, t1621, t1622;
  double t1623, t1624, t1625, t1628, t1631, t1634, t1637, t1640;
  double t1641, tv3tau30;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t101 = t16 / t17 / rho[0];
  t105 = t15 * t45;
  t108 = 0.1e1 / t38;
  t110 = -t108 * t49 + t39;
  t111 = t59 * t59;
  t113 = t36 * t36;
  t114 = t37 * t37;
  t115 = 0.1e1 / t114;
  t116 = t113 * t115;
  t117 = t33 * t33;
  t118 = 0.1e1 / t117;
  t119 = t116 * t118;
  t120 = t110 * t111 * t119;
  t128 = 0.1e1 / t53 / rho[0];
  t133 = my_piecewise3(t32, (0.3e1 * lapl[0] * t54 + 0.3e1 * sigma[0] * t128 - 0.12e2 * tau[0] * t54) * t30, 0);
  t135 = t49 * t133 * t64;
  t138 = t49 * t111;
  t139 = t36 * t115;
  t140 = t139 * t118;
  t141 = t138 * t140;
  t144 = t114 * t37;
  t145 = 0.1e1 / t144;
  t146 = t113 * t145;
  t147 = t146 * t118;
  t148 = t138 * t147;
  t151 = t62 * t118;
  t152 = t138 * t151;
  t156 = my_piecewise3(t3, 0, t15 * t101 * t39 / 0.32e2 - t105 * t65 / 0.16e2 - t48 * t120 / 0.32e2 - t48 * t135 / 0.16e2 - t48 * t141 / 0.16e2 + t48 * t148 / 0.16e2 + t48 * t152 / 0.16e2);
  tv2rho20 = 0.2e1 * rho[0] * t156 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t162 = t15 * t18 * t110;
  t163 = t59 * t113;
  t164 = t115 * t118;
  t165 = t164 * t74;
  t166 = t163 * t165;
  t169 = t54 * t30;
  t171 = my_piecewise3(t32, -0.3e1 / 0.4e1 * t169, 0);
  t173 = t49 * t171 * t64;
  t177 = t15 * t18 * t49;
  t178 = t74 * t59;
  t179 = t178 * t140;
  t182 = t74 * t113;
  t183 = t145 * t118;
  t184 = t183 * t59;
  t185 = t182 * t184;
  t188 = t74 * t36;
  t189 = t61 * t118;
  t190 = t189 * t59;
  t191 = t188 * t190;
  t195 = my_piecewise3(t3, 0, -t105 * t76 / 0.32e2 - t162 * t166 / 0.32e2 - t48 * t173 / 0.16e2 - t177 * t179 / 0.16e2 + t177 * t185 / 0.16e2 + t177 * t191 / 0.16e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t195 + 0.2e1 * t79;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t200 = t164 * t83;
  t201 = t163 * t200;
  t204 = my_piecewise3(t32, -t72, 0);
  t206 = t49 * t204 * t64;
  t209 = t83 * t59;
  t210 = t209 * t140;
  t213 = t83 * t113;
  t214 = t213 * t184;
  t217 = t83 * t36;
  t218 = t217 * t190;
  t222 = my_piecewise3(t3, 0, -t105 * t85 / 0.32e2 - t162 * t201 / 0.32e2 - t48 * t206 / 0.16e2 - t177 * t210 / 0.16e2 + t177 * t214 / 0.16e2 + t177 * t218 / 0.16e2);
  tv2rholapl0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t88;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t227 = t164 * t91;
  t228 = t163 * t227;
  t232 = my_piecewise3(t32, 0.4e1 * t72, 0);
  t234 = t49 * t232 * t64;
  t237 = t91 * t59;
  t238 = t237 * t140;
  t241 = t91 * t113;
  t242 = t241 * t184;
  t245 = t91 * t36;
  t246 = t245 * t190;
  t250 = my_piecewise3(t3, 0, -t105 * t93 / 0.32e2 - t162 * t228 / 0.32e2 - t48 * t234 / 0.16e2 - t177 * t238 / 0.16e2 + t177 * t242 / 0.16e2 + t177 * t246 / 0.16e2);
  tv2rhotau0 = 0.2e1 * rho[0] * t250 + 0.2e1 * t96;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t253 = t74 * t74;
  t255 = t110 * t253 * t119;
  t258 = my_piecewise3(t32, 0, 0);
  t260 = t49 * t258 * t64;
  t262 = t48 * t260 / 0.16e2;
  t263 = t49 * t253;
  t264 = t263 * t140;
  t267 = t263 * t147;
  t270 = t263 * t151;
  t274 = my_piecewise3(t3, 0, -t48 * t255 / 0.32e2 - t262 - t48 * t264 / 0.16e2 + t48 * t267 / 0.16e2 + t48 * t270 / 0.16e2);
  tv2sigma20 = 0.2e1 * rho[0] * t274;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t276 = t182 * t200;
  t279 = t83 * t74;
  t280 = t279 * t140;
  t283 = t183 * t74;
  t284 = t213 * t283;
  t287 = t189 * t74;
  t288 = t217 * t287;
  t292 = my_piecewise3(t3, 0, -t162 * t276 / 0.32e2 - t262 - t177 * t280 / 0.16e2 + t177 * t284 / 0.16e2 + t177 * t288 / 0.16e2);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t292;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t294 = t182 * t227;
  t297 = t91 * t74;
  t298 = t297 * t140;
  t301 = t241 * t283;
  t304 = t245 * t287;
  t308 = my_piecewise3(t3, 0, -t162 * t294 / 0.32e2 - t262 - t177 * t298 / 0.16e2 + t177 * t301 / 0.16e2 + t177 * t304 / 0.16e2);
  tv2sigmatau0 = 0.2e1 * rho[0] * t308;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t310 = t83 * t83;
  t312 = t110 * t310 * t119;
  t315 = t49 * t310;
  t316 = t315 * t140;
  t319 = t315 * t147;
  t322 = t315 * t151;
  t326 = my_piecewise3(t3, 0, -t48 * t312 / 0.32e2 - t262 - t48 * t316 / 0.16e2 + t48 * t319 / 0.16e2 + t48 * t322 / 0.16e2);
  tv2lapl20 = 0.2e1 * rho[0] * t326;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t328 = t213 * t227;
  t331 = t91 * t83;
  t332 = t331 * t140;
  t335 = t183 * t83;
  t336 = t241 * t335;
  t339 = t189 * t83;
  t340 = t245 * t339;
  t344 = my_piecewise3(t3, 0, -t162 * t328 / 0.32e2 - t262 - t177 * t332 / 0.16e2 + t177 * t336 / 0.16e2 + t177 * t340 / 0.16e2);
  tv2lapltau0 = 0.2e1 * rho[0] * t344;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t346 = t91 * t91;
  t348 = t110 * t346 * t119;
  t351 = t49 * t346;
  t352 = t351 * t140;
  t355 = t351 * t147;
  t358 = t351 * t151;
  t362 = my_piecewise3(t3, 0, -t48 * t348 / 0.32e2 - t262 - t48 * t352 / 0.16e2 + t48 * t355 / 0.16e2 + t48 * t358 / 0.16e2);
  tv2tau20 = 0.2e1 * rho[0] * t362;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t365 = t111 * t59;
  t366 = t49 * t365;
  t367 = t36 * t145;
  t369 = 0.1e1 / t117 / t33;
  t370 = t367 * t369;
  t371 = t366 * t370;
  t376 = t16 / t17 / t19;
  t382 = t110 * t365;
  t383 = t146 * t369;
  t384 = t382 * t383;
  t387 = t113 * t36;
  t388 = t114 * t114;
  t389 = 0.1e1 / t388;
  t390 = t387 * t389;
  t391 = t390 * t369;
  t392 = t382 * t391;
  t395 = t133 * t113;
  t396 = t395 * t184;
  t399 = t113 * t389;
  t400 = t399 * t369;
  t401 = t366 * t400;
  t405 = 0.1e1 / t388 / t37;
  t406 = t387 * t405;
  t407 = t406 * t369;
  t408 = t366 * t407;
  t413 = t38 * t38;
  t414 = 0.1e1 / t413;
  t415 = t414 * t49;
  t418 = t108 * t110;
  t422 = t415 * t59 * t64 / 0.2e1 - t418 * t59 * t64 / 0.2e1 + t65 / 0.2e1;
  t424 = t422 * t111 * t119;
  t432 = 0.1e1 / t53 / t19;
  t437 = my_piecewise3(t32, (-0.12e2 * lapl[0] * t128 + 0.48e2 * tau[0] * t128 - 0.15e2 * sigma[0] * t432) * t30, 0);
  t439 = t49 * t437 * t64;
  t442 = -t48 * t371 / 0.16e2 - 0.3e1 / 0.64e2 * t15 * t376 * t39 + 0.3e1 / 0.32e2 * t105 * t148 - 0.3e1 / 0.32e2 * t48 * t384 + 0.3e1 / 0.32e2 * t48 * t392 + 0.3e1 / 0.16e2 * t177 * t396 + t48 * t401 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t408 - 0.3e1 / 0.64e2 * t105 * t120 - t48 * t424 / 0.32e2 - t48 * t439 / 0.16e2;
  t443 = t15 * t101;
  t448 = t366 * t383;
  t451 = t62 * t369;
  t452 = t366 * t451;
  t456 = t163 * t164 * t133;
  t459 = t116 * t369;
  t460 = t382 * t459;
  t464 = t133 * t36 * t190;
  t467 = t139 * t369;
  t468 = t366 * t467;
  t476 = t133 * t59 * t140;
  t479 = 0.3e1 / 0.64e2 * t443 * t65 - 0.3e1 / 0.32e2 * t105 * t135 - 0.3e1 / 0.16e2 * t48 * t448 - t48 * t452 / 0.8e1 - 0.3e1 / 0.32e2 * t162 * t456 + 0.3e1 / 0.32e2 * t48 * t460 + 0.3e1 / 0.16e2 * t177 * t464 + 0.3e1 / 0.16e2 * t48 * t468 + 0.3e1 / 0.32e2 * t105 * t152 - 0.3e1 / 0.32e2 * t105 * t141 - 0.3e1 / 0.16e2 * t177 * t476;
  t481 = my_piecewise3(t3, 0, t442 + t479);
  tv3rho30 = 0.2e1 * rho[0] * t481 + 0.6e1 * t156;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t487 = t128 * t30;
  t489 = my_piecewise3(t32, 0.3e1 * t487, 0);
  t491 = t49 * t489 * t64;
  t497 = t15 * t45 * t49;
  t500 = t171 * t113;
  t501 = t500 * t184;
  t504 = t74 * t111;
  t505 = t504 * t467;
  t508 = t145 * t369;
  t509 = t508 * t111;
  t510 = t182 * t509;
  t513 = t61 * t369;
  t514 = t513 * t111;
  t515 = t188 * t514;
  t518 = t111 * t113;
  t519 = t115 * t369;
  t520 = t519 * t74;
  t521 = t518 * t520;
  t526 = t111 * t387;
  t527 = t389 * t369;
  t528 = t527 * t74;
  t529 = t526 * t528;
  t532 = t504 * t400;
  t535 = -t105 * t173 / 0.16e2 - t48 * t491 / 0.16e2 + t443 * t76 / 0.64e2 + t497 * t185 / 0.16e2 + t177 * t501 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t505 - 0.3e1 / 0.16e2 * t177 * t510 - t177 * t515 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t521 - 0.3e1 / 0.32e2 * t162 * t510 + 0.3e1 / 0.32e2 * t162 * t529 + t177 * t532 / 0.4e1;
  t536 = t74 * t387;
  t537 = t405 * t369;
  t538 = t537 * t111;
  t539 = t536 * t538;
  t542 = t183 * t133;
  t543 = t182 * t542;
  t546 = t189 * t133;
  t547 = t188 * t546;
  t553 = t15 * t45 * t110;
  t557 = t15 * t18 * t422;
  t560 = t395 * t165;
  t563 = t164 * t171;
  t564 = t163 * t563;
  t567 = t171 * t36;
  t568 = t567 * t190;
  t572 = t74 * t133 * t140;
  t578 = t171 * t59 * t140;
  t581 = t504 * t370;
  t584 = -0.3e1 / 0.16e2 * t177 * t539 + t177 * t543 / 0.16e2 + t177 * t547 / 0.16e2 + t497 * t191 / 0.16e2 - t553 * t166 / 0.32e2 - t557 * t166 / 0.32e2 - t162 * t560 / 0.32e2 - t162 * t564 / 0.16e2 + t177 * t568 / 0.8e1 - t177 * t572 / 0.16e2 - t497 * t179 / 0.16e2 - t177 * t578 / 0.8e1 - t177 * t581 / 0.16e2;
  t586 = my_piecewise3(t3, 0, t535 + t584);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t586 + 0.4e1 * t195;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t590 = t164 * t204;
  t591 = t163 * t590;
  t594 = t204 * t36;
  t595 = t594 * t190;
  t599 = my_piecewise3(t32, 0.3e1 * t169, 0);
  t601 = t49 * t599 * t64;
  t609 = t204 * t59 * t140;
  t614 = t204 * t113;
  t615 = t614 * t184;
  t618 = t83 * t111;
  t619 = t618 * t370;
  t622 = t618 * t467;
  t625 = t213 * t509;
  t628 = t217 * t514;
  t631 = -t162 * t591 / 0.16e2 + t177 * t595 / 0.8e1 - t48 * t601 / 0.16e2 - t105 * t206 / 0.16e2 + t443 * t85 / 0.64e2 - t177 * t609 / 0.8e1 + t497 * t214 / 0.16e2 + t177 * t615 / 0.8e1 - t177 * t619 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t622 - 0.3e1 / 0.16e2 * t177 * t625 - t177 * t628 / 0.8e1;
  t632 = t519 * t83;
  t633 = t518 * t632;
  t636 = t83 * t387;
  t637 = t636 * t538;
  t642 = t527 * t83;
  t643 = t526 * t642;
  t646 = t618 * t400;
  t650 = t83 * t133 * t140;
  t653 = t213 * t542;
  t656 = t217 * t546;
  t665 = t395 * t200;
  t670 = 0.3e1 / 0.32e2 * t162 * t633 - 0.3e1 / 0.16e2 * t177 * t637 - 0.3e1 / 0.32e2 * t162 * t625 + 0.3e1 / 0.32e2 * t162 * t643 + t177 * t646 / 0.4e1 - t177 * t650 / 0.16e2 + t177 * t653 / 0.16e2 + t177 * t656 / 0.16e2 + t497 * t218 / 0.16e2 - t553 * t201 / 0.32e2 - t557 * t201 / 0.32e2 - t162 * t665 / 0.32e2 - t497 * t210 / 0.16e2;
  t672 = my_piecewise3(t3, 0, t631 + t670);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t672 + 0.4e1 * t222;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t682 = t395 * t227;
  t688 = t232 * t59 * t140;
  t693 = t232 * t113;
  t694 = t693 * t184;
  t697 = t91 * t111;
  t698 = t697 * t370;
  t701 = t519 * t91;
  t702 = t518 * t701;
  t705 = t697 * t467;
  t708 = t241 * t509;
  t711 = t497 * t246 / 0.16e2 - t553 * t228 / 0.32e2 - t557 * t228 / 0.32e2 - t162 * t682 / 0.32e2 - t497 * t238 / 0.16e2 - t177 * t688 / 0.8e1 + t497 * t242 / 0.16e2 + t177 * t694 / 0.8e1 - t177 * t698 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t702 + 0.3e1 / 0.16e2 * t177 * t705 - 0.3e1 / 0.16e2 * t177 * t708;
  t712 = t245 * t514;
  t717 = t527 * t91;
  t718 = t526 * t717;
  t721 = t697 * t400;
  t724 = t91 * t387;
  t725 = t724 * t538;
  t728 = t245 * t546;
  t731 = t164 * t232;
  t732 = t163 * t731;
  t735 = t232 * t36;
  t736 = t735 * t190;
  t740 = t91 * t133 * t140;
  t743 = t241 * t542;
  t747 = my_piecewise3(t32, -0.12e2 * t169, 0);
  t749 = t49 * t747 * t64;
  t756 = -t177 * t712 / 0.8e1 - 0.3e1 / 0.32e2 * t162 * t708 + 0.3e1 / 0.32e2 * t162 * t718 + t177 * t721 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t725 + t177 * t728 / 0.16e2 - t162 * t732 / 0.16e2 + t177 * t736 / 0.8e1 - t177 * t740 / 0.16e2 + t177 * t743 / 0.16e2 - t48 * t749 / 0.16e2 - t105 * t234 / 0.16e2 + t443 * t93 / 0.64e2;
  t758 = my_piecewise3(t3, 0, t711 + t756);
  tv3rho2tau0 = 0.2e1 * rho[0] * t758 + 0.4e1 * t250;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t761 = t258 * t59;
  t762 = t761 * t140;
  t763 = t177 * t762;
  t764 = t763 / 0.16e2;
  t766 = t253 * t59 * t370;
  t769 = t253 * t113;
  t770 = t527 * t59;
  t771 = t769 * t770;
  t774 = t253 * t387;
  t775 = t537 * t59;
  t776 = t774 * t775;
  t779 = t508 * t59;
  t780 = t769 * t779;
  t783 = t774 * t770;
  t786 = t258 * t113;
  t787 = t786 * t184;
  t788 = t177 * t787;
  t789 = t788 / 0.16e2;
  t791 = t422 * t253 * t119;
  t794 = t164 * t258;
  t795 = t163 * t794;
  t796 = t162 * t795;
  t797 = t796 / 0.32e2;
  t800 = t188 * t563;
  t803 = -t764 - t177 * t766 / 0.16e2 + t177 * t771 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t776 - 0.3e1 / 0.32e2 * t162 * t780 + 0.3e1 / 0.32e2 * t162 * t783 + t789 - t48 * t791 / 0.32e2 - t262 - t797 - t105 * t264 / 0.32e2 - t177 * t800 / 0.8e1;
  t804 = t253 * t36;
  t805 = t519 * t59;
  t806 = t804 * t805;
  t811 = t183 * t171;
  t812 = t182 * t811;
  t819 = t189 * t171;
  t820 = t188 * t819;
  t823 = t513 * t59;
  t824 = t804 * t823;
  t829 = t182 * t563;
  t832 = t769 * t805;
  t835 = t105 * t260;
  t836 = t835 / 0.32e2;
  t837 = t258 * t36;
  t838 = t837 * t190;
  t839 = t177 * t838;
  t840 = t839 / 0.16e2;
  t841 = 0.3e1 / 0.16e2 * t177 * t806 + t105 * t267 / 0.32e2 + t177 * t812 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t780 + t105 * t270 / 0.32e2 + t177 * t820 / 0.8e1 - t177 * t824 / 0.8e1 - t105 * t255 / 0.64e2 - t162 * t829 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t832 - t836 + t840;
  t843 = my_piecewise3(t3, 0, t803 + t841);
  tv3rhosigma20 = 0.2e1 * rho[0] * t843 + 0.2e1 * t274;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t846 = t182 * t590;
  t857 = t204 * t74;
  t858 = t857 * t140;
  t861 = t83 * t171;
  t862 = t861 * t140;
  t865 = t614 * t283;
  t868 = t213 * t811;
  t871 = t594 * t287;
  t874 = t217 * t819;
  t879 = t500 * t200;
  t882 = -t162 * t846 / 0.32e2 + t840 + t497 * t288 / 0.32e2 - t553 * t276 / 0.64e2 - t497 * t280 / 0.32e2 + t497 * t284 / 0.32e2 - t177 * t858 / 0.16e2 - t177 * t862 / 0.16e2 + t177 * t865 / 0.16e2 + t177 * t868 / 0.16e2 + t177 * t871 / 0.16e2 + t177 * t874 / 0.16e2 - t557 * t276 / 0.32e2 - t162 * t879 / 0.32e2;
  t883 = t213 * t145;
  t884 = t369 * t74;
  t885 = t884 * t59;
  t886 = t883 * t885;
  t891 = t536 * t389;
  t892 = t369 * t83;
  t893 = t892 * t59;
  t894 = t891 * t893;
  t897 = t279 * t113;
  t898 = t897 * t770;
  t901 = t636 * t405;
  t902 = t901 * t885;
  t905 = t279 * t59;
  t906 = t905 * t370;
  t909 = t217 * t61;
  t910 = t909 * t885;
  t913 = t182 * t115;
  t914 = t913 * t893;
  t917 = t279 * t36;
  t918 = t917 * t805;
  t921 = -t764 + t789 - t797 - t836 - t262 - 0.3e1 / 0.16e2 * t177 * t886 - 0.3e1 / 0.32e2 * t162 * t886 + 0.3e1 / 0.32e2 * t162 * t894 + t177 * t898 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t902 - t177 * t906 / 0.16e2 - t177 * t910 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t914 + 0.3e1 / 0.16e2 * t177 * t918;
  t923 = my_piecewise3(t3, 0, t882 + t921);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t923 + 0.2e1 * t292;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t926 = t297 * t59;
  t927 = t926 * t370;
  t930 = t241 * t145;
  t931 = t930 * t885;
  t934 = t245 * t61;
  t935 = t934 * t885;
  t938 = t369 * t91;
  t939 = t938 * t59;
  t940 = t913 * t939;
  t943 = t297 * t36;
  t944 = t943 * t805;
  t947 = t724 * t405;
  t948 = t947 * t885;
  t953 = t891 * t939;
  t956 = t297 * t113;
  t957 = t956 * t770;
  t968 = t232 * t74;
  t969 = t968 * t140;
  t972 = -t177 * t927 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t931 - t177 * t935 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t940 + 0.3e1 / 0.16e2 * t177 * t944 - 0.3e1 / 0.16e2 * t177 * t948 - 0.3e1 / 0.32e2 * t162 * t931 + 0.3e1 / 0.32e2 * t162 * t953 + t177 * t957 / 0.4e1 + t497 * t301 / 0.32e2 + t497 * t304 / 0.32e2 - t553 * t294 / 0.64e2 - t497 * t298 / 0.32e2 - t177 * t969 / 0.16e2;
  t973 = t91 * t171;
  t974 = t973 * t140;
  t977 = t693 * t283;
  t980 = t241 * t811;
  t983 = t735 * t287;
  t986 = t245 * t819;
  t991 = t500 * t227;
  t994 = t182 * t731;
  t997 = -t177 * t974 / 0.16e2 + t177 * t977 / 0.16e2 + t177 * t980 / 0.16e2 + t177 * t983 / 0.16e2 + t177 * t986 / 0.16e2 - t557 * t294 / 0.32e2 - t162 * t991 / 0.32e2 - t162 * t994 / 0.32e2 + t840 - t764 + t789 - t797 - t836 - t262;
  t999 = my_piecewise3(t3, 0, t972 + t997);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t999 + 0.2e1 * t308;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1002 = t310 * t59;
  t1003 = t1002 * t370;
  t1006 = t310 * t113;
  t1007 = t1006 * t770;
  t1010 = t310 * t387;
  t1011 = t1010 * t775;
  t1014 = t1006 * t779;
  t1017 = t1010 * t770;
  t1021 = t422 * t310 * t119;
  t1026 = t217 * t590;
  t1029 = t310 * t36;
  t1030 = t1029 * t805;
  t1033 = -t177 * t1003 / 0.16e2 - t764 + t177 * t1007 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1011 - 0.3e1 / 0.32e2 * t162 * t1014 + 0.3e1 / 0.32e2 * t162 * t1017 + t789 - t48 * t1021 / 0.32e2 - t262 - t105 * t316 / 0.32e2 - t177 * t1026 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1030;
  t1036 = t183 * t204;
  t1037 = t213 * t1036;
  t1044 = t189 * t204;
  t1045 = t217 * t1044;
  t1048 = t1029 * t823;
  t1053 = t213 * t590;
  t1056 = t1006 * t805;
  t1059 = t105 * t319 / 0.32e2 + t177 * t1037 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1014 + t105 * t322 / 0.32e2 + t177 * t1045 / 0.8e1 - t177 * t1048 / 0.8e1 - t105 * t312 / 0.64e2 - t162 * t1053 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1056 - t797 - t836 + t840;
  t1061 = my_piecewise3(t3, 0, t1033 + t1059);
  tv3rholapl20 = 0.2e1 * rho[0] * t1061 + 0.2e1 * t326;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  t1064 = t213 * t115;
  t1065 = t1064 * t939;
  t1068 = t331 * t36;
  t1069 = t1068 * t805;
  t1072 = t930 * t893;
  t1077 = t636 * t389;
  t1078 = t1077 * t939;
  t1081 = t331 * t113;
  t1082 = t1081 * t770;
  t1085 = t947 * t893;
  t1089 = t331 * t59 * t370;
  t1092 = t934 * t893;
  t1095 = t213 * t731;
  t1106 = 0.3e1 / 0.32e2 * t162 * t1065 + 0.3e1 / 0.16e2 * t177 * t1069 - 0.3e1 / 0.16e2 * t177 * t1072 - 0.3e1 / 0.32e2 * t162 * t1072 + 0.3e1 / 0.32e2 * t162 * t1078 + t177 * t1082 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1085 - t177 * t1089 / 0.16e2 - t177 * t1092 / 0.8e1 - t162 * t1095 / 0.32e2 - t553 * t328 / 0.64e2 - t497 * t332 / 0.32e2 + t497 * t336 / 0.32e2 + t497 * t340 / 0.32e2;
  t1107 = t232 * t83;
  t1108 = t1107 * t140;
  t1111 = t91 * t204;
  t1112 = t1111 * t140;
  t1115 = t693 * t335;
  t1118 = t241 * t1036;
  t1121 = t735 * t339;
  t1124 = t245 * t1044;
  t1129 = t614 * t227;
  t1132 = -t177 * t1108 / 0.16e2 - t177 * t1112 / 0.16e2 + t177 * t1115 / 0.16e2 + t177 * t1118 / 0.16e2 + t177 * t1121 / 0.16e2 + t177 * t1124 / 0.16e2 - t557 * t328 / 0.32e2 - t162 * t1129 / 0.32e2 + t840 - t764 + t789 - t797 - t836 - t262;
  t1134 = my_piecewise3(t3, 0, t1106 + t1132);
  tv3rholapltau0 = 0.2e1 * rho[0] * t1134 + 0.2e1 * t344;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1139 = t245 * t731;
  t1142 = t346 * t36;
  t1143 = t1142 * t805;
  t1149 = t241 * t183 * t232;
  t1152 = t346 * t113;
  t1153 = t1152 * t779;
  t1159 = t245 * t189 * t232;
  t1162 = t1142 * t823;
  t1167 = t241 * t731;
  t1170 = t1152 * t805;
  t1173 = -t105 * t352 / 0.32e2 - t177 * t1139 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1143 + t105 * t355 / 0.32e2 + t177 * t1149 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1153 + t105 * t358 / 0.32e2 + t177 * t1159 / 0.8e1 - t177 * t1162 / 0.8e1 - t105 * t348 / 0.64e2 - t162 * t1167 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1170;
  t1174 = t346 * t59;
  t1175 = t1174 * t370;
  t1180 = t346 * t387;
  t1181 = t1180 * t770;
  t1184 = t1152 * t770;
  t1187 = t1180 * t775;
  t1191 = t422 * t346 * t119;
  t1194 = -t177 * t1175 / 0.16e2 - t764 - 0.3e1 / 0.32e2 * t162 * t1153 + 0.3e1 / 0.32e2 * t162 * t1181 + t177 * t1184 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1187 + t789 - t48 * t1191 / 0.32e2 - t262 - t797 - t836 + t840;
  t1196 = my_piecewise3(t3, 0, t1173 + t1194);
  tv3rhotau20 = 0.2e1 * rho[0] * t1196 + 0.2e1 * t362;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1199 = t253 * t74;
  t1200 = t49 * t1199;
  t1201 = t1200 * t467;
  t1204 = t1200 * t383;
  t1207 = t1200 * t451;
  t1210 = t182 * t794;
  t1211 = t162 * t1210;
  t1212 = 0.3e1 / 0.32e2 * t1211;
  t1213 = t110 * t1199;
  t1214 = t1213 * t459;
  t1217 = t837 * t287;
  t1218 = t177 * t1217;
  t1219 = 0.3e1 / 0.16e2 * t1218;
  t1220 = t258 * t74;
  t1221 = t1220 * t140;
  t1222 = t177 * t1221;
  t1223 = 0.3e1 / 0.16e2 * t1222;
  t1224 = t1200 * t370;
  t1227 = t1213 * t383;
  t1230 = t1213 * t391;
  t1233 = t786 * t283;
  t1234 = t177 * t1233;
  t1235 = 0.3e1 / 0.16e2 * t1234;
  t1236 = t1200 * t400;
  t1239 = t1200 * t407;
  t1242 = t415 * t74;
  t1244 = t418 * t74;
  t1247 = t1242 * t64 / 0.2e1 - t1244 * t64 / 0.2e1 + t76 / 0.2e1;
  t1249 = t1247 * t253 * t119;
  t1252 = 0.3e1 / 0.16e2 * t48 * t1201 - 0.3e1 / 0.16e2 * t48 * t1204 - t48 * t1207 / 0.8e1 - t1212 + 0.3e1 / 0.32e2 * t48 * t1214 + t1219 - t1223 - t48 * t1224 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1227 + 0.3e1 / 0.32e2 * t48 * t1230 + t1235 + t48 * t1236 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1239 - t48 * t1249 / 0.32e2 - t262;
  t1253 = my_piecewise3(t3, 0, t1252);
  tv3sigma30 = 0.2e1 * rho[0] * t1253;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1255 = t183 * t258;
  t1256 = t213 * t1255;
  t1257 = t177 * t1256;
  t1258 = t1257 / 0.16e2;
  t1259 = t189 * t258;
  t1260 = t217 * t1259;
  t1261 = t177 * t1260;
  t1262 = t1261 / 0.16e2;
  t1264 = t15 * t18 * t1247;
  t1267 = t786 * t200;
  t1268 = t162 * t1267;
  t1269 = t1268 / 0.32e2;
  t1270 = t83 * t258;
  t1271 = t1270 * t140;
  t1272 = t177 * t1271;
  t1273 = t1272 / 0.16e2;
  t1274 = t1211 / 0.16e2;
  t1275 = t1218 / 0.8e1;
  t1276 = t1222 / 0.8e1;
  t1277 = t1234 / 0.8e1;
  t1278 = t83 * t253;
  t1279 = t1278 * t370;
  t1282 = t769 * t632;
  t1285 = t1278 * t467;
  t1288 = t508 * t253;
  t1289 = t213 * t1288;
  t1292 = t513 * t253;
  t1293 = t217 * t1292;
  t1296 = t537 * t253;
  t1297 = t636 * t1296;
  t1302 = t774 * t642;
  t1305 = t1278 * t400;
  t1308 = t1258 + t1262 - t1264 * t276 / 0.32e2 - t1269 - t1273 - t1274 + t1275 - t1276 + t1277 - t177 * t1279 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1282 + 0.3e1 / 0.16e2 * t177 * t1285 - 0.3e1 / 0.16e2 * t177 * t1289 - t177 * t1293 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1297 - 0.3e1 / 0.32e2 * t162 * t1289 + 0.3e1 / 0.32e2 * t162 * t1302 + t177 * t1305 / 0.4e1 - t262;
  t1309 = my_piecewise3(t3, 0, t1308);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1309;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1311 = t241 * t1255;
  t1312 = t177 * t1311;
  t1313 = t1312 / 0.16e2;
  t1314 = t245 * t1259;
  t1315 = t177 * t1314;
  t1316 = t1315 / 0.16e2;
  t1319 = t786 * t227;
  t1320 = t162 * t1319;
  t1321 = t1320 / 0.32e2;
  t1322 = t91 * t258;
  t1323 = t1322 * t140;
  t1324 = t177 * t1323;
  t1325 = t1324 / 0.16e2;
  t1326 = t91 * t253;
  t1327 = t1326 * t370;
  t1330 = t769 * t701;
  t1333 = t1326 * t467;
  t1336 = t241 * t1288;
  t1339 = t245 * t1292;
  t1344 = t774 * t717;
  t1347 = t1326 * t400;
  t1350 = t724 * t1296;
  t1353 = t1313 + t1316 - t1264 * t294 / 0.32e2 - t1321 - t1325 - t1274 + t1275 - t1276 + t1277 - t177 * t1327 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1330 + 0.3e1 / 0.16e2 * t177 * t1333 - 0.3e1 / 0.16e2 * t177 * t1336 - t177 * t1339 / 0.8e1 - 0.3e1 / 0.32e2 * t162 * t1336 + 0.3e1 / 0.32e2 * t162 * t1344 + t177 * t1347 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1350 - t262;
  t1354 = my_piecewise3(t3, 0, t1353);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1354;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1357 = t1247 * t310 * t119;
  t1360 = t513 * t74;
  t1361 = t1029 * t1360;
  t1364 = t1006 * t520;
  t1367 = t1029 * t520;
  t1370 = t508 * t74;
  t1371 = t1006 * t1370;
  t1374 = t1257 / 0.8e1;
  t1375 = t1261 / 0.8e1;
  t1376 = t1268 / 0.16e2;
  t1377 = t1272 / 0.8e1;
  t1378 = t1211 / 0.32e2;
  t1379 = t1218 / 0.16e2;
  t1380 = t310 * t74;
  t1381 = t1380 * t370;
  t1384 = t1222 / 0.16e2;
  t1387 = t1010 * t528;
  t1390 = t1006 * t528;
  t1393 = t537 * t74;
  t1394 = t1010 * t1393;
  t1397 = t1234 / 0.16e2;
  t1398 = -t48 * t1357 / 0.32e2 - t177 * t1361 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1364 + 0.3e1 / 0.16e2 * t177 * t1367 - 0.3e1 / 0.16e2 * t177 * t1371 + t1374 + t1375 - t1376 - t1377 - t1378 + t1379 - t177 * t1381 / 0.16e2 - t1384 - 0.3e1 / 0.32e2 * t162 * t1371 + 0.3e1 / 0.32e2 * t162 * t1387 + t177 * t1390 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1394 + t1397 - t262;
  t1399 = my_piecewise3(t3, 0, t1398);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1399;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  t1403 = -t1264 * t328 / 0.32e2 + t1313 + t1316 - t1321 - t1325 + t1258 + t1262 - t1269 - t1273 - t1378 + t1379;
  t1404 = t331 * t74;
  t1405 = t1404 * t370;
  t1408 = t892 * t74;
  t1409 = t930 * t1408;
  t1412 = t934 * t1408;
  t1415 = t938 * t74;
  t1416 = t1064 * t1415;
  t1419 = t1068 * t520;
  t1424 = t1077 * t1415;
  t1427 = t1081 * t528;
  t1430 = t947 * t1408;
  t1433 = -t1384 - t177 * t1405 / 0.16e2 + t1397 - 0.3e1 / 0.16e2 * t177 * t1409 - t177 * t1412 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1416 + 0.3e1 / 0.16e2 * t177 * t1419 - 0.3e1 / 0.32e2 * t162 * t1409 + 0.3e1 / 0.32e2 * t162 * t1424 + t177 * t1427 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1430 - t262;
  t1435 = my_piecewise3(t3, 0, t1403 + t1433);
  tv3sigmalapltau0 = 0.2e1 * rho[0] * t1435;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1438 = t1247 * t346 * t119;
  t1441 = t1142 * t520;
  t1444 = t1152 * t1370;
  t1447 = t1142 * t1360;
  t1450 = t1152 * t520;
  t1453 = t1312 / 0.8e1;
  t1454 = t1315 / 0.8e1;
  t1455 = t1320 / 0.16e2;
  t1456 = t1324 / 0.8e1;
  t1457 = t346 * t74;
  t1458 = t1457 * t370;
  t1461 = t1180 * t528;
  t1464 = t1152 * t528;
  t1467 = t1180 * t1393;
  t1472 = -t48 * t1438 / 0.32e2 + 0.3e1 / 0.16e2 * t177 * t1441 - 0.3e1 / 0.16e2 * t177 * t1444 - t177 * t1447 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1450 + t1453 + t1454 - t1455 - t1456 - t1378 + t1379 - t177 * t1458 / 0.16e2 - t1384 + 0.3e1 / 0.32e2 * t162 * t1461 + t177 * t1464 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1467 - 0.3e1 / 0.32e2 * t162 * t1444 + t1397 - t262;
  t1473 = my_piecewise3(t3, 0, t1472);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1473;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1475 = t415 * t83;
  t1477 = t418 * t83;
  t1480 = t1475 * t64 / 0.2e1 - t1477 * t64 / 0.2e1 + t85 / 0.2e1;
  t1482 = t1480 * t310 * t119;
  t1485 = t310 * t83;
  t1486 = t49 * t1485;
  t1487 = t1486 * t467;
  t1490 = t1486 * t383;
  t1493 = t1486 * t451;
  t1496 = t110 * t1485;
  t1497 = t1496 * t459;
  t1500 = 0.3e1 / 0.16e2 * t1257;
  t1501 = 0.3e1 / 0.16e2 * t1261;
  t1502 = 0.3e1 / 0.32e2 * t1268;
  t1503 = 0.3e1 / 0.16e2 * t1272;
  t1504 = t1486 * t370;
  t1507 = t1496 * t383;
  t1510 = t1496 * t391;
  t1513 = t1486 * t400;
  t1516 = t1486 * t407;
  t1519 = -t48 * t1482 / 0.32e2 + 0.3e1 / 0.16e2 * t48 * t1487 - 0.3e1 / 0.16e2 * t48 * t1490 - t48 * t1493 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1497 + t1500 + t1501 - t1502 - t1503 - t48 * t1504 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1507 + 0.3e1 / 0.32e2 * t48 * t1510 + t48 * t1513 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1516 - t262;
  t1520 = my_piecewise3(t3, 0, t1519);
  tv3lapl30 = 0.2e1 * rho[0] * t1520;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  t1523 = t15 * t18 * t1480;
  t1526 = t91 * t310;
  t1527 = t1526 * t370;
  t1530 = t513 * t310;
  t1531 = t245 * t1530;
  t1534 = t1006 * t701;
  t1537 = t1526 * t467;
  t1540 = t508 * t310;
  t1541 = t241 * t1540;
  t1546 = t1010 * t717;
  t1549 = t1526 * t400;
  t1552 = t537 * t310;
  t1553 = t724 * t1552;
  t1556 = -t1523 * t328 / 0.32e2 + t1313 + t1316 - t1321 - t1325 + t1374 + t1375 - t1376 - t1377 - t177 * t1527 / 0.16e2 - t177 * t1531 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1534 + 0.3e1 / 0.16e2 * t177 * t1537 - 0.3e1 / 0.16e2 * t177 * t1541 - 0.3e1 / 0.32e2 * t162 * t1541 + 0.3e1 / 0.32e2 * t162 * t1546 + t177 * t1549 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1553 - t262;
  t1557 = my_piecewise3(t3, 0, t1556);
  tv3lapl2tau0 = 0.2e1 * rho[0] * t1557;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  t1560 = t1152 * t508 * t83;
  t1564 = t1142 * t513 * t83;
  t1568 = t1480 * t346 * t119;
  t1571 = t1152 * t632;
  t1574 = t1142 * t632;
  t1577 = t346 * t83;
  t1578 = t1577 * t370;
  t1583 = t1180 * t642;
  t1586 = t1152 * t642;
  t1590 = t1180 * t537 * t83;
  t1593 = -0.3e1 / 0.16e2 * t177 * t1560 - t177 * t1564 / 0.8e1 - t48 * t1568 / 0.32e2 + 0.3e1 / 0.32e2 * t162 * t1571 + 0.3e1 / 0.16e2 * t177 * t1574 + t1453 + t1454 - t1455 - t1456 + t1258 + t1262 - t1269 - t1273 - t177 * t1578 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t1560 + 0.3e1 / 0.32e2 * t162 * t1583 + t177 * t1586 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1590 - t262;
  t1594 = my_piecewise3(t3, 0, t1593);
  tv3lapltau20 = 0.2e1 * rho[0] * t1594;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1596 = t346 * t91;
  t1597 = t49 * t1596;
  t1598 = t1597 * t451;
  t1601 = t110 * t1596;
  t1602 = t1601 * t459;
  t1605 = t1597 * t467;
  t1608 = t1597 * t383;
  t1611 = t415 * t91;
  t1613 = t418 * t91;
  t1616 = t1611 * t64 / 0.2e1 - t1613 * t64 / 0.2e1 + t93 / 0.2e1;
  t1618 = t1616 * t346 * t119;
  t1621 = 0.3e1 / 0.16e2 * t1312;
  t1622 = 0.3e1 / 0.16e2 * t1315;
  t1623 = 0.3e1 / 0.32e2 * t1320;
  t1624 = 0.3e1 / 0.16e2 * t1324;
  t1625 = t1597 * t370;
  t1628 = t1601 * t383;
  t1631 = t1601 * t391;
  t1634 = t1597 * t400;
  t1637 = t1597 * t407;
  t1640 = -t48 * t1598 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1602 + 0.3e1 / 0.16e2 * t48 * t1605 - 0.3e1 / 0.16e2 * t48 * t1608 - t48 * t1618 / 0.32e2 + t1621 + t1622 - t1623 - t1624 - t48 * t1625 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1628 + 0.3e1 / 0.32e2 * t48 * t1631 + t48 * t1634 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1637 - t262;
  t1641 = my_piecewise3(t3, 0, t1640);
  tv3tau30 = 0.2e1 * rho[0] * t1641;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t10, t12, t14;
  double t15, t16, t17, t18, t19, t20, t25, t26;
  double t30, t31, t32, t33, t34, t36, t37, t38;
  double t39, t43, tzk0;

  double t45, t48, t49, t53, t54, t59, t61, t62;
  double t64, t65, t69, tvrho0, t72, t74, t75, t76;
  double t79, tvsigma0, t81, t83, t84, t85, t88, tvlapl0;
  double t91, t92, t93, t96, tvtau0;

  double t101, t105, t108, t110, t111, t113, t114, t115;
  double t116, t117, t118, t119, t120, t128, t133, t135;
  double t138, t139, t140, t141, t144, t145, t146, t147;
  double t148, t151, t152, t156, tv2rho20, t162, t163, t164;
  double t165, t166, t169, t171, t173, t177, t178, t179;
  double t182, t183, t184, t185, t188, t189, t190, t191;
  double t195, tv2rhosigma0, t200, t201, t204, t206, t209, t210;
  double t213, t214, t217, t218, t222, tv2rholapl0, t227, t228;
  double t232, t234, t237, t238, t241, t242, t245, t246;
  double t250, tv2rhotau0, t253, t255, t258, t260, t262, t263;
  double t264, t267, t270, t274, tv2sigma20, t276, t279, t280;
  double t283, t284, t287, t288, t292, tv2sigmalapl0, t294, t297;
  double t298, t301, t304, t308, tv2sigmatau0, t310, t312, t315;
  double t316, t319, t322, t326, tv2lapl20, t328, t331, t332;
  double t335, t336, t339, t340, t344, tv2lapltau0, t346, t348;
  double t351, t352, t355, t358, t362, tv2tau20;

  double t365, t366, t367, t369, t370, t371, t376, t382;
  double t383, t384, t387, t388, t389, t390, t391, t392;
  double t395, t396, t399, t400, t401, t405, t406, t407;
  double t408, t413, t414, t415, t418, t422, t424, t432;
  double t437, t439, t442, t443, t448, t451, t452, t456;
  double t459, t460, t464, t467, t468, t476, t479, t481;
  double tv3rho30, t487, t489, t491, t497, t500, t501, t504;
  double t505, t508, t509, t510, t513, t514, t515, t518;
  double t519, t520, t521, t526, t527, t528, t529, t532;
  double t535, t536, t537, t538, t539, t542, t543, t546;
  double t547, t553, t557, t560, t563, t564, t567, t568;
  double t572, t578, t581, t584, t586, tv3rho2sigma0, t590, t591;
  double t594, t595, t599, t601, t609, t614, t615, t618;
  double t619, t622, t625, t628, t631, t632, t633, t636;
  double t637, t642, t643, t646, t650, t653, t656, t665;
  double t670, t672, tv3rho2lapl0, t682, t688, t693, t694, t697;
  double t698, t701, t702, t705, t708, t711, t712, t717;
  double t718, t721, t724, t725, t728, t731, t732, t735;
  double t736, t740, t743, t747, t749, t756, t758, tv3rho2tau0;
  double t761, t762, t763, t764, t766, t769, t770, t771;
  double t774, t775, t776, t779, t780, t783, t786, t787;
  double t788, t789, t791, t794, t795, t796, t797, t800;
  double t803, t804, t805, t806, t811, t812, t819, t820;
  double t823, t824, t829, t832, t835, t836, t837, t838;
  double t839, t840, t841, t843, tv3rhosigma20, t846, t857, t858;
  double t861, t862, t865, t868, t871, t874, t879, t882;
  double t883, t884, t885, t886, t891, t892, t893, t894;
  double t897, t898, t901, t902, t905, t906, t909, t910;
  double t913, t914, t917, t918, t921, t923, tv3rhosigmalapl0, t926;
  double t927, t930, t931, t934, t935, t938, t939, t940;
  double t943, t944, t947, t948, t953, t956, t957, t968;
  double t969, t972, t973, t974, t977, t980, t983, t986;
  double t991, t994, t997, t999, tv3rhosigmatau0, t1002, t1003, t1006;
  double t1007, t1010, t1011, t1014, t1017, t1021, t1026, t1029;
  double t1030, t1033, t1036, t1037, t1044, t1045, t1048, t1053;
  double t1056, t1059, t1061, tv3rholapl20, t1064, t1065, t1068, t1069;
  double t1072, t1077, t1078, t1081, t1082, t1085, t1089, t1092;
  double t1095, t1106, t1107, t1108, t1111, t1112, t1115, t1118;
  double t1121, t1124, t1129, t1132, t1134, tv3rholapltau0, t1139, t1142;
  double t1143, t1149, t1152, t1153, t1159, t1162, t1167, t1170;
  double t1173, t1174, t1175, t1180, t1181, t1184, t1187, t1191;
  double t1194, t1196, tv3rhotau20, t1199, t1200, t1201, t1204, t1207;
  double t1210, t1211, t1212, t1213, t1214, t1217, t1218, t1219;
  double t1220, t1221, t1222, t1223, t1224, t1227, t1230, t1233;
  double t1234, t1235, t1236, t1239, t1242, t1244, t1247, t1249;
  double t1252, t1253, tv3sigma30, t1255, t1256, t1257, t1258, t1259;
  double t1260, t1261, t1262, t1264, t1267, t1268, t1269, t1270;
  double t1271, t1272, t1273, t1274, t1275, t1276, t1277, t1278;
  double t1279, t1282, t1285, t1288, t1289, t1292, t1293, t1296;
  double t1297, t1302, t1305, t1308, t1309, tv3sigma2lapl0, t1311, t1312;
  double t1313, t1314, t1315, t1316, t1319, t1320, t1321, t1322;
  double t1323, t1324, t1325, t1326, t1327, t1330, t1333, t1336;
  double t1339, t1344, t1347, t1350, t1353, t1354, tv3sigma2tau0, t1357;
  double t1360, t1361, t1364, t1367, t1370, t1371, t1374, t1375;
  double t1376, t1377, t1378, t1379, t1380, t1381, t1384, t1387;
  double t1390, t1393, t1394, t1397, t1398, t1399, tv3sigmalapl20, t1403;
  double t1404, t1405, t1408, t1409, t1412, t1415, t1416, t1419;
  double t1424, t1427, t1430, t1433, t1435, tv3sigmalapltau0, t1438, t1441;
  double t1444, t1447, t1450, t1453, t1454, t1455, t1456, t1457;
  double t1458, t1461, t1464, t1467, t1472, t1473, tv3sigmatau20, t1475;
  double t1477, t1480, t1482, t1485, t1486, t1487, t1490, t1493;
  double t1496, t1497, t1500, t1501, t1502, t1503, t1504, t1507;
  double t1510, t1513, t1516, t1519, t1520, tv3lapl30, t1523, t1526;
  double t1527, t1530, t1531, t1534, t1537, t1540, t1541, t1546;
  double t1549, t1552, t1553, t1556, t1557, tv3lapl2tau0, t1560, t1564;
  double t1568, t1571, t1574, t1577, t1578, t1583, t1586, t1590;
  double t1593, t1594, tv3lapltau20, t1596, t1597, t1598, t1601, t1602;
  double t1605, t1608, t1611, t1613, t1616, t1618, t1621, t1622;
  double t1623, t1624, t1625, t1628, t1631, t1634, t1637, t1640;
  double t1641, tv3tau30;

  double t1656, t1660, t1675, t1679, t1680, t1690, t1696, t1705;
  double t1711, t1712, t1713, t1714, t1715, t1719, t1724, t1728;
  double t1730, t1736, t1741, t1749, t1753, t1755, t1757, t1759;
  double t1764, t1769, t1771, t1775, t1789, t1801, t1809, t1812;
  double t1816, t1832, t1839, t1855, t1859, t1866, t1873, t1880;
  double t1887, t1905, t1909, t1912, tv4rho40, t1916, t1923, t1924;
  double t1925, t1926, t1929, t1933, t1934, t1941, t1946, t1950;
  double t1951, t1952, t1953, t1956, t1957, t1958, t1962, t1966;
  double t1967, t1968, t1982, t1986, t1989, t2006, t2007, t2008;
  double t2013, t2014, t2027, t2033, t2039, t2045, t2049, t2056;
  double t2062, t2063, t2070, t2071, t2072, t2105, t2110, t2120;
  double t2125, t2131, t2142, t2146, t2147, t2155, t2167, t2172;
  double t2175, tv4rho3sigma0, t2182, t2186, t2197, t2198, t2209, t2213;
  double t2217, t2220, t2221, t2228, t2241, t2242, t2256, t2273;
  double t2287, t2291, t2295, t2305, t2312, t2332, t2339, t2349;
  double t2371, t2375, t2398, t2405, t2408, tv4rho3lapl0, t2412, t2423;
  double t2431, t2441, t2445, t2451, t2457, t2471, t2476, t2487;
  double t2493, t2500, t2501, t2504, t2508, t2511, t2522, t2529;
  double t2531, t2556, t2560, t2581, t2588, t2627, t2636, t2639;
  double tv4rho3tau0, t2643, t2647, t2657, t2660, t2673, t2677, t2678;
  double t2682, t2685, t2686, t2691, t2692, t2697, t2698, t2702;
  double t2703, t2706, t2711, t2712, t2716, t2718, t2721, t2724;
  double t2728, t2731, t2747, t2751, t2752, t2753, t2759, t2765;
  double t2766, t2767, t2769, t2776, t2778, t2780, t2781, t2784;
  double t2788, t2791, t2798, t2811, t2818, t2821, t2822, t2837;
  double t2840, t2843, t2847, t2853, t2854, t2863, t2870, t2871;
  double t2872, t2873, t2874, t2879, t2881, t2884, t2906, t2907;
  double t2911, tv4rho2sigma20, t2916, t2917, t2925, t2926, t2927, t2931;
  double t2935, t2943, t2946, t2959, t2965, t2966, t2985, t2989;
  double t2990, t2993, t2998, t3008, t3042, t3049, t3089, t3128;
  double t3161, t3168, t3169, t3173, tv4rho2sigmalapl0, t3177, t3181, t3182;
  double t3183, t3186, t3190, t3191, t3196, t3219, t3225, t3233;
  double t3252, t3253, t3256, t3259, t3262, t3291, t3292, t3301;
  double t3329, t3346, t3349, t3385, t3421, t3427, t3431, tv4rho2sigmatau0;
  double t3441, t3445, t3449, t3455, t3459, t3464, t3468, t3469;
  double t3472, t3476, t3483, t3498, t3504, t3506, t3518, t3519;
  double t3525, t3539, t3546, t3563, t3572, t3597, t3598, t3602;
  double t3603, t3610, t3630, t3634, tv4rho2lapl20, t3646, t3651, t3655;
  double t3662, t3666, t3674, t3679, t3680, t3684, t3688, t3691;
  double t3716, t3720, t3722, t3738, t3744, t3760, t3770, t3785;
  double t3799, t3837, t3872, t3879, t3883, tv4rho2lapltau0, t3887, t3899;
  double t3903, t3907, t3915, t3921, t3931, t3934, t3952, t3954;
  double t3966, t3969, t3979, t3987, t4005, t4019, t4046, t4048;
  double t4049, t4060, t4078, t4082, tv4rho2tau20, t4087, t4091, t4093;
  double t4094, t4096, t4100, t4102, t4103, t4106, t4108, t4112;
  double t4116, t4122, t4123, t4124, t4127, t4128, t4129, t4137;
  double t4138, t4145, t4146, t4150, t4151, t4154, t4163, t4167;
  double t4168, t4176, t4179, t4184, t4188, t4190, t4198, t4203;
  double t4209, t4213, t4218, t4225, t4227, t4229, t4251, t4254;
  double t4259, t4273, t4274, t4277, t4278, t4279, t4285, t4286;
  double t4289, t4292, t4307, t4324, t4327, tv4rhosigma30, t4331, t4332;
  double t4335, t4336, t4338, t4339, t4342, t4352, t4353, t4355;
  double t4356, t4361, t4362, t4363, t4364, t4365, t4369, t4370;
  double t4371, t4372, t4375, t4379, t4384, t4385, t4386, t4388;
  double t4389, t4390, t4405, t4406, t4412, t4414, t4418, t4429;
  double t4430, t4432, t4433, t4434, t4435, t4442, t4454, t4457;
  double t4458, t4459, t4460, t4461, t4462, t4463, t4465, t4466;
  double t4475, t4478, t4486, t4504, t4511, t4512, t4514, t4515;
  double t4516, t4519, t4520, t4522, t4523, t4543, t4546, t4547;
  double t4548, t4550, t4551, t4552, t4553, t4554, t4555, t4556;
  double t4557, t4558, t4559, t4560, t4561, t4562, t4563, t4564;
  double t4565, t4566, t4570, tv4rhosigma2lapl0, t4576, t4577, t4591, t4592;
  double t4593, t4594, t4598, t4604, t4610, t4611, t4612, t4614;
  double t4615, t4618, t4619, t4620, t4622, t4623, t4625, t4626;
  double t4628, t4629, t4630, t4640, t4646, t4652, t4662, t4663;
  double t4666, t4667, t4689, t4691, t4692, t4697, t4702, t4708;
  double t4735, t4736, t4738, t4739, t4740, t4743, t4744, t4746;
  double t4747, t4766, t4767, t4768, t4769, t4770, t4772, t4773;
  double t4774, t4775, t4778, t4779, t4783, tv4rhosigma2tau0, t4787, t4788;
  double t4793, t4798, t4802, t4811, t4823, t4830, t4835, t4850;
  double t4865, t4866, t4870, t4874, t4876, t4877, t4878, t4879;
  double t4880, t4881, t4882, t4883, t4884, t4885, t4886, t4887;
  double t4888, t4889, t4890, t4891, t4892, t4893, t4894, t4910;
  double t4915, t4945, t4958, t4959, t4960, t4961, t4962, t4963;
  double t4964, t4965, t4966, t4968, t4969, t4970, t4971, t4972;
  double t4973, t4974, t4975, t4976, t4977, t4984, t4985, t4989;
  double tv4rhosigmalapl20, t5029, t5032, t5047, t5052, t5061, t5081, t5110;
  double t5111, t5114, t5115, t5117, t5126, t5149, t5166, t5181;
  double t5183, t5184, t5188, tv4rhosigmalapltau0, t5195, t5196, t5199, t5203;
  double t5207, t5211, t5212, t5220, t5224, t5225, t5229, t5236;
  double t5241, t5244, t5252, t5273, t5277, t5279, t5280, t5281;
  double t5282, t5283, t5284, t5285, t5286, t5287, t5288, t5305;
  double t5323, t5340, t5352, t5353, t5354, t5355, t5356, t5357;
  double t5358, t5359, t5360, t5362, t5369, t5370, t5374, tv4rhosigmatau20;
  double t5386, t5390, t5401, t5402, t5405, t5408, t5412, t5416;
  double t5420, t5424, t5446, t5455, t5464, t5465, t5468, t5474;
  double t5493, t5496, t5499, t5502, t5503, t5527, t5542, t5553;
  double t5563, t5566, tv4rholapl30, t5578, t5587, t5594, t5607, t5608;
  double t5612, t5613, t5619, t5635, t5639, t5647, t5651, t5656;
  double t5657, t5671, t5705, t5717, t5724, t5726, t5727, t5731;
  double tv4rholapl2tau0, t5737, t5740, t5741, t5744, t5760, t5765, t5766;
  double t5788, t5797, t5823, t5831, t5838, t5847, t5848, t5864;
  double t5878, t5886, t5890, tv4rholapltau20, t5902, t5915, t5918, t5922;
  double t5926, t5927, t5930, t5936, t5939, t5943, t5981, t5983;
  double t5987, t6015, t6024, t6040, t6043, t6046, t6050, t6074;
  double t6079, t6082, tv4rhotau30, t6085, t6087, t6090, t6092, t6095;
  double t6097, t6098, t6100, t6102, t6105, t6108, t6110, t6113;
  double t6115, t6116, t6119, t6122, t6124, t6136, t6137, t6144;
  double t6150, t6151, t6158, t6163, t6164, t6168, t6184, t6188;
  double t6195, t6198, t6236, t6238, tv4sigma40, t6242, t6246, t6249;
  double t6268, t6272, t6273, t6281, t6287, t6292, t6293, t6299;
  double t6300, t6302, t6305, t6306, t6307, t6308, t6310, t6311;
  double t6312, t6313, t6314, t6315, t6316, t6317, t6318, t6319;
  double t6320, t6321, t6323, t6324, t6326, t6327, t6329, t6330;
  double t6333, t6334, t6336, t6337, t6339, t6340, t6342, t6343;
  double t6344, t6347, tv4sigma3lapl0, t6351, t6355, t6380, t6384, t6387;
  double t6405, t6406, t6407, t6409, t6410, t6411, t6412, t6414;
  double t6415, t6418, t6419, t6420, t6421, t6423, t6424, t6426;
  double t6427, t6429, t6430, t6432, t6433, t6435, t6436, t6437;
  double t6440, tv4sigma3tau0, t6446, t6456, t6457, t6466, t6471, t6476;
  double t6480, t6488, t6489, t6490, t6491, t6493, t6494, t6495;
  double t6499, t6500, t6504, t6505, t6510, t6511, t6513, t6514;
  double t6516, t6517, t6518, t6520, t6521, t6524, t6525, t6528;
  double t6529, t6531, t6533, t6534, t6535, t6536, t6537, t6538;
  double t6539, t6540, t6545, t6554, t6557, tv4sigma2lapl20, t6561, t6562;
  double t6572, t6576, t6579, t6582, t6587, t6608, t6610, t6611;
  double t6614, t6617, t6620, t6626, t6629, t6633, t6640, t6642;
  double t6645, t6646, t6647, t6648, t6649, t6650, t6651, t6652;
  double t6653, t6654, t6655, t6656, t6657, t6658, t6659, t6660;
  double t6661, t6662, t6663, t6666, tv4sigma2lapltau0, t6668, t6672, t6684;
  double t6701, t6702, t6703, t6708, t6709, t6710, t6715, t6716;
  double t6720, t6721, t6723, t6735, t6736, t6738, t6739, t6741;
  double t6742, t6743, t6744, t6747, t6748, t6750, t6756, t6765;
  double t6768, tv4sigma2tau20, t6770, t6784, t6792, t6797, t6803, t6810;
  double t6811, t6820, t6827, t6828, t6829, t6830, t6831, t6832;
  double t6833, t6834, t6835, t6837, t6839, t6850, t6862, t6865;
  double t6868, t6871, t6883, t6888, t6889, t6892, tv4sigmalapl30, t6904;
  double t6906, t6908, t6932, t6940, t6943, t6961, t6963, t6964;
  double t6965, t6966, t6967, t6968, t6969, t6970, t6971, t6972;
  double t6982, t6985, tv4sigmalapl2tau0, t6999, t7005, t7006, t7016, t7025;
  double t7030, t7053, t7055, t7065, t7068, tv4sigmalapltau20, t7076, t7084;
  double t7087, t7092, t7108, t7109, t7110, t7125, t7126, t7127;
  double t7128, t7129, t7130, t7131, t7132, t7133, t7135, t7137;
  double t7172, t7180, t7181, t7184, tv4sigmatau30, t7196, t7197, t7210;
  double t7217, t7227, t7262, t7269, t7273, t7280, t7295, t7297;
  double tv4lapl40, t7303, t7310, t7327, t7337, t7339, t7360, t7362;
  double t7363, t7364, t7365, t7366, t7367, t7368, t7369, t7370;
  double t7371, t7372, t7375, tv4lapl3tau0, t7378, t7381, t7384, t7397;
  double t7420, t7434, t7440, t7449, t7452, tv4lapl2tau20, t7454, t7461;
  double t7469, t7494, t7500, t7511, t7513, t7536, t7539, t7542;
  double t7554, t7562, t7563, t7566, tv4lapltau30, t7578, t7579, t7583;
  double t7590, t7604, t7615, t7622, t7639, t7677, t7679, tv4tau40;


  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = 0.1e1 <= p->zeta_threshold;
  t5 = p->zeta_threshold - 0.1e1;
  t7 = my_piecewise5(t4, t5, t4, -t5, 0);
  t8 = 0.1e1 + t7;
  t10 = sqrt(p->zeta_threshold);
  t12 = sqrt(t8);
  t14 = my_piecewise3(t8 <= p->zeta_threshold, t10 * p->zeta_threshold, t12 * t8);
  t15 = M_PI * t14;
  t16 = M_SQRT2;
  t17 = sqrt(rho[0]);
  t18 = t16 * t17;
  t19 = rho[0] * rho[0];
  t20 = 0.1e1 / t19;
  t25 = t19 * rho[0];
  t26 = 0.1e1 / t25;
  t30 = 0.1e1 / M_PI;
  t31 = (lapl[0] * t20 / 0.2e1 - 0.2e1 * tau[0] * t20 + sigma[0] * t26 / 0.4e1) * t30;
  t32 = -0.9999999999e0 < t31;
  t33 = my_piecewise3(t32, t31, -0.9999999999e0);
  t34 = exp(-0.1e1);
  t36 = LambertW(t33 * t34);
  t37 = t36 + 0.1e1;
  t38 = t37 / 0.2e1;
  t39 = xc_bessel_I0(t38);
  t43 = my_piecewise3(t3, 0, -t15 * t18 * t39 / 0.8e1);
  tzk0 = 0.2e1 * t43;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t45 = t16 / t17;
  t48 = t15 * t18;
  t49 = xc_bessel_I1(t38);
  t53 = t19 * t19;
  t54 = 0.1e1 / t53;
  t59 = my_piecewise3(t32, (-lapl[0] * t26 + 0.4e1 * tau[0] * t26 - 0.3e1 / 0.4e1 * sigma[0] * t54) * t30, 0);
  t61 = 0.1e1 / t37;
  t62 = t36 * t61;
  t64 = t62 / t33;
  t65 = t49 * t59 * t64;
  t69 = my_piecewise3(t3, 0, -t15 * t45 * t39 / 0.16e2 - t48 * t65 / 0.16e2);
  tvrho0 = 0.2e1 * rho[0] * t69 + 0.2e1 * t43;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t72 = t26 * t30;
  t74 = my_piecewise3(t32, t72 / 0.4e1, 0);
  t75 = t49 * t74;
  t76 = t75 * t64;
  t79 = my_piecewise3(t3, 0, -t48 * t76 / 0.16e2);
  tvsigma0 = 0.2e1 * rho[0] * t79;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t81 = t20 * t30;
  t83 = my_piecewise3(t32, t81 / 0.2e1, 0);
  t84 = t49 * t83;
  t85 = t84 * t64;
  t88 = my_piecewise3(t3, 0, -t48 * t85 / 0.16e2);
  tvlapl0 = 0.2e1 * rho[0] * t88;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t91 = my_piecewise3(t32, -0.2e1 * t81, 0);
  t92 = t49 * t91;
  t93 = t92 * t64;
  t96 = my_piecewise3(t3, 0, -t48 * t93 / 0.16e2);
  tvtau0 = 0.2e1 * rho[0] * t96;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t101 = t16 / t17 / rho[0];
  t105 = t15 * t45;
  t108 = 0.1e1 / t38;
  t110 = -t108 * t49 + t39;
  t111 = t59 * t59;
  t113 = t36 * t36;
  t114 = t37 * t37;
  t115 = 0.1e1 / t114;
  t116 = t113 * t115;
  t117 = t33 * t33;
  t118 = 0.1e1 / t117;
  t119 = t116 * t118;
  t120 = t110 * t111 * t119;
  t128 = 0.1e1 / t53 / rho[0];
  t133 = my_piecewise3(t32, (0.3e1 * lapl[0] * t54 + 0.3e1 * sigma[0] * t128 - 0.12e2 * tau[0] * t54) * t30, 0);
  t135 = t49 * t133 * t64;
  t138 = t49 * t111;
  t139 = t36 * t115;
  t140 = t139 * t118;
  t141 = t138 * t140;
  t144 = t114 * t37;
  t145 = 0.1e1 / t144;
  t146 = t113 * t145;
  t147 = t146 * t118;
  t148 = t138 * t147;
  t151 = t62 * t118;
  t152 = t138 * t151;
  t156 = my_piecewise3(t3, 0, t15 * t101 * t39 / 0.32e2 - t105 * t65 / 0.16e2 - t48 * t120 / 0.32e2 - t48 * t135 / 0.16e2 - t48 * t141 / 0.16e2 + t48 * t148 / 0.16e2 + t48 * t152 / 0.16e2);
  tv2rho20 = 0.2e1 * rho[0] * t156 + 0.4e1 * t69;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t162 = t15 * t18 * t110;
  t163 = t59 * t113;
  t164 = t115 * t118;
  t165 = t164 * t74;
  t166 = t163 * t165;
  t169 = t54 * t30;
  t171 = my_piecewise3(t32, -0.3e1 / 0.4e1 * t169, 0);
  t173 = t49 * t171 * t64;
  t177 = t15 * t18 * t49;
  t178 = t74 * t59;
  t179 = t178 * t140;
  t182 = t74 * t113;
  t183 = t145 * t118;
  t184 = t183 * t59;
  t185 = t182 * t184;
  t188 = t74 * t36;
  t189 = t61 * t118;
  t190 = t189 * t59;
  t191 = t188 * t190;
  t195 = my_piecewise3(t3, 0, -t105 * t76 / 0.32e2 - t162 * t166 / 0.32e2 - t48 * t173 / 0.16e2 - t177 * t179 / 0.16e2 + t177 * t185 / 0.16e2 + t177 * t191 / 0.16e2);
  tv2rhosigma0 = 0.2e1 * rho[0] * t195 + 0.2e1 * t79;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t200 = t164 * t83;
  t201 = t163 * t200;
  t204 = my_piecewise3(t32, -t72, 0);
  t206 = t49 * t204 * t64;
  t209 = t83 * t59;
  t210 = t209 * t140;
  t213 = t83 * t113;
  t214 = t213 * t184;
  t217 = t83 * t36;
  t218 = t217 * t190;
  t222 = my_piecewise3(t3, 0, -t105 * t85 / 0.32e2 - t162 * t201 / 0.32e2 - t48 * t206 / 0.16e2 - t177 * t210 / 0.16e2 + t177 * t214 / 0.16e2 + t177 * t218 / 0.16e2);
  tv2rholapl0 = 0.2e1 * rho[0] * t222 + 0.2e1 * t88;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t227 = t164 * t91;
  t228 = t163 * t227;
  t232 = my_piecewise3(t32, 0.4e1 * t72, 0);
  t234 = t49 * t232 * t64;
  t237 = t91 * t59;
  t238 = t237 * t140;
  t241 = t91 * t113;
  t242 = t241 * t184;
  t245 = t91 * t36;
  t246 = t245 * t190;
  t250 = my_piecewise3(t3, 0, -t105 * t93 / 0.32e2 - t162 * t228 / 0.32e2 - t48 * t234 / 0.16e2 - t177 * t238 / 0.16e2 + t177 * t242 / 0.16e2 + t177 * t246 / 0.16e2);
  tv2rhotau0 = 0.2e1 * rho[0] * t250 + 0.2e1 * t96;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t253 = t74 * t74;
  t255 = t110 * t253 * t119;
  t258 = my_piecewise3(t32, 0, 0);
  t260 = t49 * t258 * t64;
  t262 = t48 * t260 / 0.16e2;
  t263 = t49 * t253;
  t264 = t263 * t140;
  t267 = t263 * t147;
  t270 = t263 * t151;
  t274 = my_piecewise3(t3, 0, -t48 * t255 / 0.32e2 - t262 - t48 * t264 / 0.16e2 + t48 * t267 / 0.16e2 + t48 * t270 / 0.16e2);
  tv2sigma20 = 0.2e1 * rho[0] * t274;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t276 = t182 * t200;
  t279 = t83 * t74;
  t280 = t279 * t140;
  t283 = t183 * t74;
  t284 = t213 * t283;
  t287 = t189 * t74;
  t288 = t217 * t287;
  t292 = my_piecewise3(t3, 0, -t162 * t276 / 0.32e2 - t262 - t177 * t280 / 0.16e2 + t177 * t284 / 0.16e2 + t177 * t288 / 0.16e2);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t292;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t294 = t182 * t227;
  t297 = t91 * t74;
  t298 = t297 * t140;
  t301 = t241 * t283;
  t304 = t245 * t287;
  t308 = my_piecewise3(t3, 0, -t162 * t294 / 0.32e2 - t262 - t177 * t298 / 0.16e2 + t177 * t301 / 0.16e2 + t177 * t304 / 0.16e2);
  tv2sigmatau0 = 0.2e1 * rho[0] * t308;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t310 = t83 * t83;
  t312 = t110 * t310 * t119;
  t315 = t49 * t310;
  t316 = t315 * t140;
  t319 = t315 * t147;
  t322 = t315 * t151;
  t326 = my_piecewise3(t3, 0, -t48 * t312 / 0.32e2 - t262 - t48 * t316 / 0.16e2 + t48 * t319 / 0.16e2 + t48 * t322 / 0.16e2);
  tv2lapl20 = 0.2e1 * rho[0] * t326;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  t328 = t213 * t227;
  t331 = t91 * t83;
  t332 = t331 * t140;
  t335 = t183 * t83;
  t336 = t241 * t335;
  t339 = t189 * t83;
  t340 = t245 * t339;
  t344 = my_piecewise3(t3, 0, -t162 * t328 / 0.32e2 - t262 - t177 * t332 / 0.16e2 + t177 * t336 / 0.16e2 + t177 * t340 / 0.16e2);
  tv2lapltau0 = 0.2e1 * rho[0] * t344;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t346 = t91 * t91;
  t348 = t110 * t346 * t119;
  t351 = t49 * t346;
  t352 = t351 * t140;
  t355 = t351 * t147;
  t358 = t351 * t151;
  t362 = my_piecewise3(t3, 0, -t48 * t348 / 0.32e2 - t262 - t48 * t352 / 0.16e2 + t48 * t355 / 0.16e2 + t48 * t358 / 0.16e2);
  tv2tau20 = 0.2e1 * rho[0] * t362;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t365 = t111 * t59;
  t366 = t49 * t365;
  t367 = t36 * t145;
  t369 = 0.1e1 / t117 / t33;
  t370 = t367 * t369;
  t371 = t366 * t370;
  t376 = t16 / t17 / t19;
  t382 = t110 * t365;
  t383 = t146 * t369;
  t384 = t382 * t383;
  t387 = t113 * t36;
  t388 = t114 * t114;
  t389 = 0.1e1 / t388;
  t390 = t387 * t389;
  t391 = t390 * t369;
  t392 = t382 * t391;
  t395 = t133 * t113;
  t396 = t395 * t184;
  t399 = t113 * t389;
  t400 = t399 * t369;
  t401 = t366 * t400;
  t405 = 0.1e1 / t388 / t37;
  t406 = t387 * t405;
  t407 = t406 * t369;
  t408 = t366 * t407;
  t413 = t38 * t38;
  t414 = 0.1e1 / t413;
  t415 = t414 * t49;
  t418 = t108 * t110;
  t422 = t415 * t59 * t64 / 0.2e1 - t418 * t59 * t64 / 0.2e1 + t65 / 0.2e1;
  t424 = t422 * t111 * t119;
  t432 = 0.1e1 / t53 / t19;
  t437 = my_piecewise3(t32, (-0.12e2 * lapl[0] * t128 + 0.48e2 * tau[0] * t128 - 0.15e2 * sigma[0] * t432) * t30, 0);
  t439 = t49 * t437 * t64;
  t442 = -t48 * t371 / 0.16e2 - 0.3e1 / 0.64e2 * t15 * t376 * t39 + 0.3e1 / 0.32e2 * t105 * t148 - 0.3e1 / 0.32e2 * t48 * t384 + 0.3e1 / 0.32e2 * t48 * t392 + 0.3e1 / 0.16e2 * t177 * t396 + t48 * t401 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t408 - 0.3e1 / 0.64e2 * t105 * t120 - t48 * t424 / 0.32e2 - t48 * t439 / 0.16e2;
  t443 = t15 * t101;
  t448 = t366 * t383;
  t451 = t62 * t369;
  t452 = t366 * t451;
  t456 = t163 * t164 * t133;
  t459 = t116 * t369;
  t460 = t382 * t459;
  t464 = t133 * t36 * t190;
  t467 = t139 * t369;
  t468 = t366 * t467;
  t476 = t133 * t59 * t140;
  t479 = 0.3e1 / 0.64e2 * t443 * t65 - 0.3e1 / 0.32e2 * t105 * t135 - 0.3e1 / 0.16e2 * t48 * t448 - t48 * t452 / 0.8e1 - 0.3e1 / 0.32e2 * t162 * t456 + 0.3e1 / 0.32e2 * t48 * t460 + 0.3e1 / 0.16e2 * t177 * t464 + 0.3e1 / 0.16e2 * t48 * t468 + 0.3e1 / 0.32e2 * t105 * t152 - 0.3e1 / 0.32e2 * t105 * t141 - 0.3e1 / 0.16e2 * t177 * t476;
  t481 = my_piecewise3(t3, 0, t442 + t479);
  tv3rho30 = 0.2e1 * rho[0] * t481 + 0.6e1 * t156;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t487 = t128 * t30;
  t489 = my_piecewise3(t32, 0.3e1 * t487, 0);
  t491 = t49 * t489 * t64;
  t497 = t15 * t45 * t49;
  t500 = t171 * t113;
  t501 = t500 * t184;
  t504 = t74 * t111;
  t505 = t504 * t467;
  t508 = t145 * t369;
  t509 = t508 * t111;
  t510 = t182 * t509;
  t513 = t61 * t369;
  t514 = t513 * t111;
  t515 = t188 * t514;
  t518 = t111 * t113;
  t519 = t115 * t369;
  t520 = t519 * t74;
  t521 = t518 * t520;
  t526 = t111 * t387;
  t527 = t389 * t369;
  t528 = t527 * t74;
  t529 = t526 * t528;
  t532 = t504 * t400;
  t535 = -t105 * t173 / 0.16e2 - t48 * t491 / 0.16e2 + t443 * t76 / 0.64e2 + t497 * t185 / 0.16e2 + t177 * t501 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t505 - 0.3e1 / 0.16e2 * t177 * t510 - t177 * t515 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t521 - 0.3e1 / 0.32e2 * t162 * t510 + 0.3e1 / 0.32e2 * t162 * t529 + t177 * t532 / 0.4e1;
  t536 = t74 * t387;
  t537 = t405 * t369;
  t538 = t537 * t111;
  t539 = t536 * t538;
  t542 = t183 * t133;
  t543 = t182 * t542;
  t546 = t189 * t133;
  t547 = t188 * t546;
  t553 = t15 * t45 * t110;
  t557 = t15 * t18 * t422;
  t560 = t395 * t165;
  t563 = t164 * t171;
  t564 = t163 * t563;
  t567 = t171 * t36;
  t568 = t567 * t190;
  t572 = t74 * t133 * t140;
  t578 = t171 * t59 * t140;
  t581 = t504 * t370;
  t584 = -0.3e1 / 0.16e2 * t177 * t539 + t177 * t543 / 0.16e2 + t177 * t547 / 0.16e2 + t497 * t191 / 0.16e2 - t553 * t166 / 0.32e2 - t557 * t166 / 0.32e2 - t162 * t560 / 0.32e2 - t162 * t564 / 0.16e2 + t177 * t568 / 0.8e1 - t177 * t572 / 0.16e2 - t497 * t179 / 0.16e2 - t177 * t578 / 0.8e1 - t177 * t581 / 0.16e2;
  t586 = my_piecewise3(t3, 0, t535 + t584);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t586 + 0.4e1 * t195;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t590 = t164 * t204;
  t591 = t163 * t590;
  t594 = t204 * t36;
  t595 = t594 * t190;
  t599 = my_piecewise3(t32, 0.3e1 * t169, 0);
  t601 = t49 * t599 * t64;
  t609 = t204 * t59 * t140;
  t614 = t204 * t113;
  t615 = t614 * t184;
  t618 = t83 * t111;
  t619 = t618 * t370;
  t622 = t618 * t467;
  t625 = t213 * t509;
  t628 = t217 * t514;
  t631 = -t162 * t591 / 0.16e2 + t177 * t595 / 0.8e1 - t48 * t601 / 0.16e2 - t105 * t206 / 0.16e2 + t443 * t85 / 0.64e2 - t177 * t609 / 0.8e1 + t497 * t214 / 0.16e2 + t177 * t615 / 0.8e1 - t177 * t619 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t622 - 0.3e1 / 0.16e2 * t177 * t625 - t177 * t628 / 0.8e1;
  t632 = t519 * t83;
  t633 = t518 * t632;
  t636 = t83 * t387;
  t637 = t636 * t538;
  t642 = t527 * t83;
  t643 = t526 * t642;
  t646 = t618 * t400;
  t650 = t83 * t133 * t140;
  t653 = t213 * t542;
  t656 = t217 * t546;
  t665 = t395 * t200;
  t670 = 0.3e1 / 0.32e2 * t162 * t633 - 0.3e1 / 0.16e2 * t177 * t637 - 0.3e1 / 0.32e2 * t162 * t625 + 0.3e1 / 0.32e2 * t162 * t643 + t177 * t646 / 0.4e1 - t177 * t650 / 0.16e2 + t177 * t653 / 0.16e2 + t177 * t656 / 0.16e2 + t497 * t218 / 0.16e2 - t553 * t201 / 0.32e2 - t557 * t201 / 0.32e2 - t162 * t665 / 0.32e2 - t497 * t210 / 0.16e2;
  t672 = my_piecewise3(t3, 0, t631 + t670);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t672 + 0.4e1 * t222;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t682 = t395 * t227;
  t688 = t232 * t59 * t140;
  t693 = t232 * t113;
  t694 = t693 * t184;
  t697 = t91 * t111;
  t698 = t697 * t370;
  t701 = t519 * t91;
  t702 = t518 * t701;
  t705 = t697 * t467;
  t708 = t241 * t509;
  t711 = t497 * t246 / 0.16e2 - t553 * t228 / 0.32e2 - t557 * t228 / 0.32e2 - t162 * t682 / 0.32e2 - t497 * t238 / 0.16e2 - t177 * t688 / 0.8e1 + t497 * t242 / 0.16e2 + t177 * t694 / 0.8e1 - t177 * t698 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t702 + 0.3e1 / 0.16e2 * t177 * t705 - 0.3e1 / 0.16e2 * t177 * t708;
  t712 = t245 * t514;
  t717 = t527 * t91;
  t718 = t526 * t717;
  t721 = t697 * t400;
  t724 = t91 * t387;
  t725 = t724 * t538;
  t728 = t245 * t546;
  t731 = t164 * t232;
  t732 = t163 * t731;
  t735 = t232 * t36;
  t736 = t735 * t190;
  t740 = t91 * t133 * t140;
  t743 = t241 * t542;
  t747 = my_piecewise3(t32, -0.12e2 * t169, 0);
  t749 = t49 * t747 * t64;
  t756 = -t177 * t712 / 0.8e1 - 0.3e1 / 0.32e2 * t162 * t708 + 0.3e1 / 0.32e2 * t162 * t718 + t177 * t721 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t725 + t177 * t728 / 0.16e2 - t162 * t732 / 0.16e2 + t177 * t736 / 0.8e1 - t177 * t740 / 0.16e2 + t177 * t743 / 0.16e2 - t48 * t749 / 0.16e2 - t105 * t234 / 0.16e2 + t443 * t93 / 0.64e2;
  t758 = my_piecewise3(t3, 0, t711 + t756);
  tv3rho2tau0 = 0.2e1 * rho[0] * t758 + 0.4e1 * t250;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t761 = t258 * t59;
  t762 = t761 * t140;
  t763 = t177 * t762;
  t764 = t763 / 0.16e2;
  t766 = t253 * t59 * t370;
  t769 = t253 * t113;
  t770 = t527 * t59;
  t771 = t769 * t770;
  t774 = t253 * t387;
  t775 = t537 * t59;
  t776 = t774 * t775;
  t779 = t508 * t59;
  t780 = t769 * t779;
  t783 = t774 * t770;
  t786 = t258 * t113;
  t787 = t786 * t184;
  t788 = t177 * t787;
  t789 = t788 / 0.16e2;
  t791 = t422 * t253 * t119;
  t794 = t164 * t258;
  t795 = t163 * t794;
  t796 = t162 * t795;
  t797 = t796 / 0.32e2;
  t800 = t188 * t563;
  t803 = -t764 - t177 * t766 / 0.16e2 + t177 * t771 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t776 - 0.3e1 / 0.32e2 * t162 * t780 + 0.3e1 / 0.32e2 * t162 * t783 + t789 - t48 * t791 / 0.32e2 - t262 - t797 - t105 * t264 / 0.32e2 - t177 * t800 / 0.8e1;
  t804 = t253 * t36;
  t805 = t519 * t59;
  t806 = t804 * t805;
  t811 = t183 * t171;
  t812 = t182 * t811;
  t819 = t189 * t171;
  t820 = t188 * t819;
  t823 = t513 * t59;
  t824 = t804 * t823;
  t829 = t182 * t563;
  t832 = t769 * t805;
  t835 = t105 * t260;
  t836 = t835 / 0.32e2;
  t837 = t258 * t36;
  t838 = t837 * t190;
  t839 = t177 * t838;
  t840 = t839 / 0.16e2;
  t841 = 0.3e1 / 0.16e2 * t177 * t806 + t105 * t267 / 0.32e2 + t177 * t812 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t780 + t105 * t270 / 0.32e2 + t177 * t820 / 0.8e1 - t177 * t824 / 0.8e1 - t105 * t255 / 0.64e2 - t162 * t829 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t832 - t836 + t840;
  t843 = my_piecewise3(t3, 0, t803 + t841);
  tv3rhosigma20 = 0.2e1 * rho[0] * t843 + 0.2e1 * t274;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t846 = t182 * t590;
  t857 = t204 * t74;
  t858 = t857 * t140;
  t861 = t83 * t171;
  t862 = t861 * t140;
  t865 = t614 * t283;
  t868 = t213 * t811;
  t871 = t594 * t287;
  t874 = t217 * t819;
  t879 = t500 * t200;
  t882 = -t162 * t846 / 0.32e2 + t840 + t497 * t288 / 0.32e2 - t553 * t276 / 0.64e2 - t497 * t280 / 0.32e2 + t497 * t284 / 0.32e2 - t177 * t858 / 0.16e2 - t177 * t862 / 0.16e2 + t177 * t865 / 0.16e2 + t177 * t868 / 0.16e2 + t177 * t871 / 0.16e2 + t177 * t874 / 0.16e2 - t557 * t276 / 0.32e2 - t162 * t879 / 0.32e2;
  t883 = t213 * t145;
  t884 = t369 * t74;
  t885 = t884 * t59;
  t886 = t883 * t885;
  t891 = t536 * t389;
  t892 = t369 * t83;
  t893 = t892 * t59;
  t894 = t891 * t893;
  t897 = t279 * t113;
  t898 = t897 * t770;
  t901 = t636 * t405;
  t902 = t901 * t885;
  t905 = t279 * t59;
  t906 = t905 * t370;
  t909 = t217 * t61;
  t910 = t909 * t885;
  t913 = t182 * t115;
  t914 = t913 * t893;
  t917 = t279 * t36;
  t918 = t917 * t805;
  t921 = -t764 + t789 - t797 - t836 - t262 - 0.3e1 / 0.16e2 * t177 * t886 - 0.3e1 / 0.32e2 * t162 * t886 + 0.3e1 / 0.32e2 * t162 * t894 + t177 * t898 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t902 - t177 * t906 / 0.16e2 - t177 * t910 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t914 + 0.3e1 / 0.16e2 * t177 * t918;
  t923 = my_piecewise3(t3, 0, t882 + t921);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t923 + 0.2e1 * t292;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t926 = t297 * t59;
  t927 = t926 * t370;
  t930 = t241 * t145;
  t931 = t930 * t885;
  t934 = t245 * t61;
  t935 = t934 * t885;
  t938 = t369 * t91;
  t939 = t938 * t59;
  t940 = t913 * t939;
  t943 = t297 * t36;
  t944 = t943 * t805;
  t947 = t724 * t405;
  t948 = t947 * t885;
  t953 = t891 * t939;
  t956 = t297 * t113;
  t957 = t956 * t770;
  t968 = t232 * t74;
  t969 = t968 * t140;
  t972 = -t177 * t927 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t931 - t177 * t935 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t940 + 0.3e1 / 0.16e2 * t177 * t944 - 0.3e1 / 0.16e2 * t177 * t948 - 0.3e1 / 0.32e2 * t162 * t931 + 0.3e1 / 0.32e2 * t162 * t953 + t177 * t957 / 0.4e1 + t497 * t301 / 0.32e2 + t497 * t304 / 0.32e2 - t553 * t294 / 0.64e2 - t497 * t298 / 0.32e2 - t177 * t969 / 0.16e2;
  t973 = t91 * t171;
  t974 = t973 * t140;
  t977 = t693 * t283;
  t980 = t241 * t811;
  t983 = t735 * t287;
  t986 = t245 * t819;
  t991 = t500 * t227;
  t994 = t182 * t731;
  t997 = -t177 * t974 / 0.16e2 + t177 * t977 / 0.16e2 + t177 * t980 / 0.16e2 + t177 * t983 / 0.16e2 + t177 * t986 / 0.16e2 - t557 * t294 / 0.32e2 - t162 * t991 / 0.32e2 - t162 * t994 / 0.32e2 + t840 - t764 + t789 - t797 - t836 - t262;
  t999 = my_piecewise3(t3, 0, t972 + t997);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t999 + 0.2e1 * t308;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1002 = t310 * t59;
  t1003 = t1002 * t370;
  t1006 = t310 * t113;
  t1007 = t1006 * t770;
  t1010 = t310 * t387;
  t1011 = t1010 * t775;
  t1014 = t1006 * t779;
  t1017 = t1010 * t770;
  t1021 = t422 * t310 * t119;
  t1026 = t217 * t590;
  t1029 = t310 * t36;
  t1030 = t1029 * t805;
  t1033 = -t177 * t1003 / 0.16e2 - t764 + t177 * t1007 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1011 - 0.3e1 / 0.32e2 * t162 * t1014 + 0.3e1 / 0.32e2 * t162 * t1017 + t789 - t48 * t1021 / 0.32e2 - t262 - t105 * t316 / 0.32e2 - t177 * t1026 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1030;
  t1036 = t183 * t204;
  t1037 = t213 * t1036;
  t1044 = t189 * t204;
  t1045 = t217 * t1044;
  t1048 = t1029 * t823;
  t1053 = t213 * t590;
  t1056 = t1006 * t805;
  t1059 = t105 * t319 / 0.32e2 + t177 * t1037 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1014 + t105 * t322 / 0.32e2 + t177 * t1045 / 0.8e1 - t177 * t1048 / 0.8e1 - t105 * t312 / 0.64e2 - t162 * t1053 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1056 - t797 - t836 + t840;
  t1061 = my_piecewise3(t3, 0, t1033 + t1059);
  tv3rholapl20 = 0.2e1 * rho[0] * t1061 + 0.2e1 * t326;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  t1064 = t213 * t115;
  t1065 = t1064 * t939;
  t1068 = t331 * t36;
  t1069 = t1068 * t805;
  t1072 = t930 * t893;
  t1077 = t636 * t389;
  t1078 = t1077 * t939;
  t1081 = t331 * t113;
  t1082 = t1081 * t770;
  t1085 = t947 * t893;
  t1089 = t331 * t59 * t370;
  t1092 = t934 * t893;
  t1095 = t213 * t731;
  t1106 = 0.3e1 / 0.32e2 * t162 * t1065 + 0.3e1 / 0.16e2 * t177 * t1069 - 0.3e1 / 0.16e2 * t177 * t1072 - 0.3e1 / 0.32e2 * t162 * t1072 + 0.3e1 / 0.32e2 * t162 * t1078 + t177 * t1082 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1085 - t177 * t1089 / 0.16e2 - t177 * t1092 / 0.8e1 - t162 * t1095 / 0.32e2 - t553 * t328 / 0.64e2 - t497 * t332 / 0.32e2 + t497 * t336 / 0.32e2 + t497 * t340 / 0.32e2;
  t1107 = t232 * t83;
  t1108 = t1107 * t140;
  t1111 = t91 * t204;
  t1112 = t1111 * t140;
  t1115 = t693 * t335;
  t1118 = t241 * t1036;
  t1121 = t735 * t339;
  t1124 = t245 * t1044;
  t1129 = t614 * t227;
  t1132 = -t177 * t1108 / 0.16e2 - t177 * t1112 / 0.16e2 + t177 * t1115 / 0.16e2 + t177 * t1118 / 0.16e2 + t177 * t1121 / 0.16e2 + t177 * t1124 / 0.16e2 - t557 * t328 / 0.32e2 - t162 * t1129 / 0.32e2 + t840 - t764 + t789 - t797 - t836 - t262;
  t1134 = my_piecewise3(t3, 0, t1106 + t1132);
  tv3rholapltau0 = 0.2e1 * rho[0] * t1134 + 0.2e1 * t344;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1139 = t245 * t731;
  t1142 = t346 * t36;
  t1143 = t1142 * t805;
  t1149 = t241 * t183 * t232;
  t1152 = t346 * t113;
  t1153 = t1152 * t779;
  t1159 = t245 * t189 * t232;
  t1162 = t1142 * t823;
  t1167 = t241 * t731;
  t1170 = t1152 * t805;
  t1173 = -t105 * t352 / 0.32e2 - t177 * t1139 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1143 + t105 * t355 / 0.32e2 + t177 * t1149 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1153 + t105 * t358 / 0.32e2 + t177 * t1159 / 0.8e1 - t177 * t1162 / 0.8e1 - t105 * t348 / 0.64e2 - t162 * t1167 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1170;
  t1174 = t346 * t59;
  t1175 = t1174 * t370;
  t1180 = t346 * t387;
  t1181 = t1180 * t770;
  t1184 = t1152 * t770;
  t1187 = t1180 * t775;
  t1191 = t422 * t346 * t119;
  t1194 = -t177 * t1175 / 0.16e2 - t764 - 0.3e1 / 0.32e2 * t162 * t1153 + 0.3e1 / 0.32e2 * t162 * t1181 + t177 * t1184 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1187 + t789 - t48 * t1191 / 0.32e2 - t262 - t797 - t836 + t840;
  t1196 = my_piecewise3(t3, 0, t1173 + t1194);
  tv3rhotau20 = 0.2e1 * rho[0] * t1196 + 0.2e1 * t362;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1199 = t253 * t74;
  t1200 = t49 * t1199;
  t1201 = t1200 * t467;
  t1204 = t1200 * t383;
  t1207 = t1200 * t451;
  t1210 = t182 * t794;
  t1211 = t162 * t1210;
  t1212 = 0.3e1 / 0.32e2 * t1211;
  t1213 = t110 * t1199;
  t1214 = t1213 * t459;
  t1217 = t837 * t287;
  t1218 = t177 * t1217;
  t1219 = 0.3e1 / 0.16e2 * t1218;
  t1220 = t258 * t74;
  t1221 = t1220 * t140;
  t1222 = t177 * t1221;
  t1223 = 0.3e1 / 0.16e2 * t1222;
  t1224 = t1200 * t370;
  t1227 = t1213 * t383;
  t1230 = t1213 * t391;
  t1233 = t786 * t283;
  t1234 = t177 * t1233;
  t1235 = 0.3e1 / 0.16e2 * t1234;
  t1236 = t1200 * t400;
  t1239 = t1200 * t407;
  t1242 = t415 * t74;
  t1244 = t418 * t74;
  t1247 = t1242 * t64 / 0.2e1 - t1244 * t64 / 0.2e1 + t76 / 0.2e1;
  t1249 = t1247 * t253 * t119;
  t1252 = 0.3e1 / 0.16e2 * t48 * t1201 - 0.3e1 / 0.16e2 * t48 * t1204 - t48 * t1207 / 0.8e1 - t1212 + 0.3e1 / 0.32e2 * t48 * t1214 + t1219 - t1223 - t48 * t1224 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1227 + 0.3e1 / 0.32e2 * t48 * t1230 + t1235 + t48 * t1236 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1239 - t48 * t1249 / 0.32e2 - t262;
  t1253 = my_piecewise3(t3, 0, t1252);
  tv3sigma30 = 0.2e1 * rho[0] * t1253;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1255 = t183 * t258;
  t1256 = t213 * t1255;
  t1257 = t177 * t1256;
  t1258 = t1257 / 0.16e2;
  t1259 = t189 * t258;
  t1260 = t217 * t1259;
  t1261 = t177 * t1260;
  t1262 = t1261 / 0.16e2;
  t1264 = t15 * t18 * t1247;
  t1267 = t786 * t200;
  t1268 = t162 * t1267;
  t1269 = t1268 / 0.32e2;
  t1270 = t83 * t258;
  t1271 = t1270 * t140;
  t1272 = t177 * t1271;
  t1273 = t1272 / 0.16e2;
  t1274 = t1211 / 0.16e2;
  t1275 = t1218 / 0.8e1;
  t1276 = t1222 / 0.8e1;
  t1277 = t1234 / 0.8e1;
  t1278 = t83 * t253;
  t1279 = t1278 * t370;
  t1282 = t769 * t632;
  t1285 = t1278 * t467;
  t1288 = t508 * t253;
  t1289 = t213 * t1288;
  t1292 = t513 * t253;
  t1293 = t217 * t1292;
  t1296 = t537 * t253;
  t1297 = t636 * t1296;
  t1302 = t774 * t642;
  t1305 = t1278 * t400;
  t1308 = t1258 + t1262 - t1264 * t276 / 0.32e2 - t1269 - t1273 - t1274 + t1275 - t1276 + t1277 - t177 * t1279 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1282 + 0.3e1 / 0.16e2 * t177 * t1285 - 0.3e1 / 0.16e2 * t177 * t1289 - t177 * t1293 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t1297 - 0.3e1 / 0.32e2 * t162 * t1289 + 0.3e1 / 0.32e2 * t162 * t1302 + t177 * t1305 / 0.4e1 - t262;
  t1309 = my_piecewise3(t3, 0, t1308);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1309;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1311 = t241 * t1255;
  t1312 = t177 * t1311;
  t1313 = t1312 / 0.16e2;
  t1314 = t245 * t1259;
  t1315 = t177 * t1314;
  t1316 = t1315 / 0.16e2;
  t1319 = t786 * t227;
  t1320 = t162 * t1319;
  t1321 = t1320 / 0.32e2;
  t1322 = t91 * t258;
  t1323 = t1322 * t140;
  t1324 = t177 * t1323;
  t1325 = t1324 / 0.16e2;
  t1326 = t91 * t253;
  t1327 = t1326 * t370;
  t1330 = t769 * t701;
  t1333 = t1326 * t467;
  t1336 = t241 * t1288;
  t1339 = t245 * t1292;
  t1344 = t774 * t717;
  t1347 = t1326 * t400;
  t1350 = t724 * t1296;
  t1353 = t1313 + t1316 - t1264 * t294 / 0.32e2 - t1321 - t1325 - t1274 + t1275 - t1276 + t1277 - t177 * t1327 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1330 + 0.3e1 / 0.16e2 * t177 * t1333 - 0.3e1 / 0.16e2 * t177 * t1336 - t177 * t1339 / 0.8e1 - 0.3e1 / 0.32e2 * t162 * t1336 + 0.3e1 / 0.32e2 * t162 * t1344 + t177 * t1347 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1350 - t262;
  t1354 = my_piecewise3(t3, 0, t1353);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1354;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1357 = t1247 * t310 * t119;
  t1360 = t513 * t74;
  t1361 = t1029 * t1360;
  t1364 = t1006 * t520;
  t1367 = t1029 * t520;
  t1370 = t508 * t74;
  t1371 = t1006 * t1370;
  t1374 = t1257 / 0.8e1;
  t1375 = t1261 / 0.8e1;
  t1376 = t1268 / 0.16e2;
  t1377 = t1272 / 0.8e1;
  t1378 = t1211 / 0.32e2;
  t1379 = t1218 / 0.16e2;
  t1380 = t310 * t74;
  t1381 = t1380 * t370;
  t1384 = t1222 / 0.16e2;
  t1387 = t1010 * t528;
  t1390 = t1006 * t528;
  t1393 = t537 * t74;
  t1394 = t1010 * t1393;
  t1397 = t1234 / 0.16e2;
  t1398 = -t48 * t1357 / 0.32e2 - t177 * t1361 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1364 + 0.3e1 / 0.16e2 * t177 * t1367 - 0.3e1 / 0.16e2 * t177 * t1371 + t1374 + t1375 - t1376 - t1377 - t1378 + t1379 - t177 * t1381 / 0.16e2 - t1384 - 0.3e1 / 0.32e2 * t162 * t1371 + 0.3e1 / 0.32e2 * t162 * t1387 + t177 * t1390 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1394 + t1397 - t262;
  t1399 = my_piecewise3(t3, 0, t1398);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1399;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  t1403 = -t1264 * t328 / 0.32e2 + t1313 + t1316 - t1321 - t1325 + t1258 + t1262 - t1269 - t1273 - t1378 + t1379;
  t1404 = t331 * t74;
  t1405 = t1404 * t370;
  t1408 = t892 * t74;
  t1409 = t930 * t1408;
  t1412 = t934 * t1408;
  t1415 = t938 * t74;
  t1416 = t1064 * t1415;
  t1419 = t1068 * t520;
  t1424 = t1077 * t1415;
  t1427 = t1081 * t528;
  t1430 = t947 * t1408;
  t1433 = -t1384 - t177 * t1405 / 0.16e2 + t1397 - 0.3e1 / 0.16e2 * t177 * t1409 - t177 * t1412 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1416 + 0.3e1 / 0.16e2 * t177 * t1419 - 0.3e1 / 0.32e2 * t162 * t1409 + 0.3e1 / 0.32e2 * t162 * t1424 + t177 * t1427 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1430 - t262;
  t1435 = my_piecewise3(t3, 0, t1403 + t1433);
  tv3sigmalapltau0 = 0.2e1 * rho[0] * t1435;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1438 = t1247 * t346 * t119;
  t1441 = t1142 * t520;
  t1444 = t1152 * t1370;
  t1447 = t1142 * t1360;
  t1450 = t1152 * t520;
  t1453 = t1312 / 0.8e1;
  t1454 = t1315 / 0.8e1;
  t1455 = t1320 / 0.16e2;
  t1456 = t1324 / 0.8e1;
  t1457 = t346 * t74;
  t1458 = t1457 * t370;
  t1461 = t1180 * t528;
  t1464 = t1152 * t528;
  t1467 = t1180 * t1393;
  t1472 = -t48 * t1438 / 0.32e2 + 0.3e1 / 0.16e2 * t177 * t1441 - 0.3e1 / 0.16e2 * t177 * t1444 - t177 * t1447 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1450 + t1453 + t1454 - t1455 - t1456 - t1378 + t1379 - t177 * t1458 / 0.16e2 - t1384 + 0.3e1 / 0.32e2 * t162 * t1461 + t177 * t1464 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1467 - 0.3e1 / 0.32e2 * t162 * t1444 + t1397 - t262;
  t1473 = my_piecewise3(t3, 0, t1472);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1473;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1475 = t415 * t83;
  t1477 = t418 * t83;
  t1480 = t1475 * t64 / 0.2e1 - t1477 * t64 / 0.2e1 + t85 / 0.2e1;
  t1482 = t1480 * t310 * t119;
  t1485 = t310 * t83;
  t1486 = t49 * t1485;
  t1487 = t1486 * t467;
  t1490 = t1486 * t383;
  t1493 = t1486 * t451;
  t1496 = t110 * t1485;
  t1497 = t1496 * t459;
  t1500 = 0.3e1 / 0.16e2 * t1257;
  t1501 = 0.3e1 / 0.16e2 * t1261;
  t1502 = 0.3e1 / 0.32e2 * t1268;
  t1503 = 0.3e1 / 0.16e2 * t1272;
  t1504 = t1486 * t370;
  t1507 = t1496 * t383;
  t1510 = t1496 * t391;
  t1513 = t1486 * t400;
  t1516 = t1486 * t407;
  t1519 = -t48 * t1482 / 0.32e2 + 0.3e1 / 0.16e2 * t48 * t1487 - 0.3e1 / 0.16e2 * t48 * t1490 - t48 * t1493 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1497 + t1500 + t1501 - t1502 - t1503 - t48 * t1504 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1507 + 0.3e1 / 0.32e2 * t48 * t1510 + t48 * t1513 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1516 - t262;
  t1520 = my_piecewise3(t3, 0, t1519);
  tv3lapl30 = 0.2e1 * rho[0] * t1520;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  t1523 = t15 * t18 * t1480;
  t1526 = t91 * t310;
  t1527 = t1526 * t370;
  t1530 = t513 * t310;
  t1531 = t245 * t1530;
  t1534 = t1006 * t701;
  t1537 = t1526 * t467;
  t1540 = t508 * t310;
  t1541 = t241 * t1540;
  t1546 = t1010 * t717;
  t1549 = t1526 * t400;
  t1552 = t537 * t310;
  t1553 = t724 * t1552;
  t1556 = -t1523 * t328 / 0.32e2 + t1313 + t1316 - t1321 - t1325 + t1374 + t1375 - t1376 - t1377 - t177 * t1527 / 0.16e2 - t177 * t1531 / 0.8e1 + 0.3e1 / 0.32e2 * t162 * t1534 + 0.3e1 / 0.16e2 * t177 * t1537 - 0.3e1 / 0.16e2 * t177 * t1541 - 0.3e1 / 0.32e2 * t162 * t1541 + 0.3e1 / 0.32e2 * t162 * t1546 + t177 * t1549 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1553 - t262;
  t1557 = my_piecewise3(t3, 0, t1556);
  tv3lapl2tau0 = 0.2e1 * rho[0] * t1557;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  t1560 = t1152 * t508 * t83;
  t1564 = t1142 * t513 * t83;
  t1568 = t1480 * t346 * t119;
  t1571 = t1152 * t632;
  t1574 = t1142 * t632;
  t1577 = t346 * t83;
  t1578 = t1577 * t370;
  t1583 = t1180 * t642;
  t1586 = t1152 * t642;
  t1590 = t1180 * t537 * t83;
  t1593 = -0.3e1 / 0.16e2 * t177 * t1560 - t177 * t1564 / 0.8e1 - t48 * t1568 / 0.32e2 + 0.3e1 / 0.32e2 * t162 * t1571 + 0.3e1 / 0.16e2 * t177 * t1574 + t1453 + t1454 - t1455 - t1456 + t1258 + t1262 - t1269 - t1273 - t177 * t1578 / 0.16e2 - 0.3e1 / 0.32e2 * t162 * t1560 + 0.3e1 / 0.32e2 * t162 * t1583 + t177 * t1586 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1590 - t262;
  t1594 = my_piecewise3(t3, 0, t1593);
  tv3lapltau20 = 0.2e1 * rho[0] * t1594;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1596 = t346 * t91;
  t1597 = t49 * t1596;
  t1598 = t1597 * t451;
  t1601 = t110 * t1596;
  t1602 = t1601 * t459;
  t1605 = t1597 * t467;
  t1608 = t1597 * t383;
  t1611 = t415 * t91;
  t1613 = t418 * t91;
  t1616 = t1611 * t64 / 0.2e1 - t1613 * t64 / 0.2e1 + t93 / 0.2e1;
  t1618 = t1616 * t346 * t119;
  t1621 = 0.3e1 / 0.16e2 * t1312;
  t1622 = 0.3e1 / 0.16e2 * t1315;
  t1623 = 0.3e1 / 0.32e2 * t1320;
  t1624 = 0.3e1 / 0.16e2 * t1324;
  t1625 = t1597 * t370;
  t1628 = t1601 * t383;
  t1631 = t1601 * t391;
  t1634 = t1597 * t400;
  t1637 = t1597 * t407;
  t1640 = -t48 * t1598 / 0.8e1 + 0.3e1 / 0.32e2 * t48 * t1602 + 0.3e1 / 0.16e2 * t48 * t1605 - 0.3e1 / 0.16e2 * t48 * t1608 - t48 * t1618 / 0.32e2 + t1621 + t1622 - t1623 - t1624 - t48 * t1625 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t1628 + 0.3e1 / 0.32e2 * t48 * t1631 + t48 * t1634 / 0.4e1 - 0.3e1 / 0.16e2 * t48 * t1637 - t262;
  t1641 = my_piecewise3(t3, 0, t1640);
  tv3tau30 = 0.2e1 * rho[0] * t1641;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1656 = t519 * t133;
  t1660 = t395 * t509;
  t1675 = t527 * t133;
  t1679 = t111 * t36;
  t1680 = t508 * t133;
  t1690 = t513 * t133;
  t1696 = 0.15e2 / 0.128e3 * t15 * t16 / t17 / t25 * t39 - 0.3e1 / 0.8e1 * t497 * t476 + 0.9e1 / 0.8e1 * t177 * t133 * t111 * t467 + 0.9e1 / 0.16e2 * t162 * t518 * t1656 - 0.9e1 / 0.8e1 * t177 * t1660 + 0.3e1 / 0.2e1 * t177 * t395 * t527 * t111 - 0.9e1 / 0.8e1 * t177 * t133 * t387 * t538 + 0.3e1 / 0.8e1 * t497 * t396 - 0.9e1 / 0.16e2 * t162 * t1660 + 0.9e1 / 0.16e2 * t162 * t526 * t1675 - 0.3e1 / 0.8e1 * t177 * t1679 * t1680 - t177 * t437 * t59 * t140 / 0.4e1 + 0.3e1 / 0.8e1 * t497 * t464 - 0.3e1 / 0.4e1 * t177 * t1679 * t1690 - 0.5e1 / 0.32e2 * t557 * t456;
  t1705 = t437 * t113;
  t1711 = t111 * t111;
  t1712 = t110 * t1711;
  t1713 = t117 * t117;
  t1714 = 0.1e1 / t1713;
  t1715 = t399 * t1714;
  t1719 = t15 * t376;
  t1724 = t422 * t365;
  t1728 = t49 * t1711;
  t1730 = t36 * t389 * t1714;
  t1736 = t139 * t1714;
  t1741 = t113 * t405 * t1714;
  t1749 = t406 * t1714;
  t1753 = t177 * t437 * t36 * t190 / 0.4e1 - t162 * t163 * t164 * t437 / 0.8e1 + t177 * t1705 * t184 / 0.4e1 - 0.3e1 / 0.16e2 * t553 * t456 - 0.7e1 / 0.32e2 * t48 * t1712 * t1715 - 0.3e1 / 0.32e2 * t1719 * t65 + 0.3e1 / 0.16e2 * t105 * t392 - 0.5e1 / 0.32e2 * t48 * t1724 * t383 - t48 * t1728 * t1730 / 0.16e2 + 0.3e1 / 0.32e2 * t443 * t141 - 0.11e2 / 0.16e2 * t48 * t1728 * t1736 + 0.11e2 / 0.16e2 * t48 * t1728 * t1741 + t105 * t401 / 0.2e1 - 0.3e1 / 0.8e1 * t105 * t408 + 0.11e2 / 0.16e2 * t48 * t1712 * t1749;
  t1755 = t113 * t113;
  t1757 = 0.1e1 / t388 / t114;
  t1759 = t1755 * t1757 * t1714;
  t1764 = t387 * t1757 * t1714;
  t1769 = 0.1e1 / t388 / t144;
  t1771 = t1755 * t1769 * t1714;
  t1775 = t133 * t133;
  t1789 = t49 * t1775;
  t1801 = t367 * t1714;
  t1809 = -0.15e2 / 0.32e2 * t48 * t1712 * t1759 - 0.25e2 / 0.16e2 * t48 * t1728 * t1764 + 0.15e2 / 0.16e2 * t48 * t1728 * t1771 - 0.3e1 / 0.32e2 * t48 * t110 * t1775 * t119 + 0.3e1 / 0.16e2 * t105 * t460 + 0.5e1 / 0.32e2 * t48 * t1724 * t459 - t105 * t439 / 0.8e1 - 0.3e1 / 0.32e2 * t443 * t152 + 0.3e1 / 0.16e2 * t48 * t1789 * t147 - 0.3e1 / 0.2e1 * t48 * t1728 * t1715 + 0.9e1 / 0.8e1 * t48 * t1728 * t1749 + 0.3e1 / 0.64e2 * t443 * t120 + 0.3e1 / 0.8e1 * t48 * t1728 * t1801 - 0.3e1 / 0.32e2 * t443 * t148 - 0.3e1 / 0.8e1 * t105 * t448;
  t1812 = t146 * t1714;
  t1816 = t390 * t1714;
  t1832 = my_piecewise3(t32, (0.6e2 * lapl[0] * t432 - 0.24e3 * tau[0] * t432 + 0.9e2 * sigma[0] / t53 / t25) * t30, 0);
  t1839 = t116 * t1714;
  t1855 = 0.1e1 / t413 / t38 * t49;
  t1859 = t414 * t110;
  t1866 = t415 * t111;
  t1873 = t108 * t422;
  t1880 = t418 * t111;
  t1887 = t120 / 0.4e1 + t135 / 0.2e1 + t141 / 0.2e1 - t148 / 0.2e1 - t152 / 0.2e1 - t1855 * t111 * t119 / 0.2e1 + t1859 * t111 * t119 / 0.2e1 + t415 * t133 * t64 / 0.2e1 + t1866 * t140 / 0.2e1 - t1866 * t147 / 0.2e1 - t1866 * t151 / 0.2e1 - t1873 * t59 * t64 / 0.2e1 - t418 * t133 * t64 / 0.2e1 - t1880 * t140 / 0.2e1 + t1880 * t147 / 0.2e1 + t1880 * t151 / 0.2e1;
  t1905 = t62 * t1714;
  t1909 = -0.3e1 / 0.16e2 * t105 * t384 + 0.9e1 / 0.16e2 * t48 * t1712 * t1812 - 0.9e1 / 0.16e2 * t48 * t1712 * t1816 - t105 * t371 / 0.8e1 - t48 * t49 * t1832 * t64 / 0.16e2 + 0.3e1 / 0.32e2 * t443 * t135 - 0.11e2 / 0.32e2 * t48 * t1712 * t1839 + 0.5e1 / 0.32e2 * t48 * t1724 * t391 - t105 * t424 / 0.16e2 - t48 * t1887 * t111 * t119 / 0.32e2 - 0.3e1 / 0.16e2 * t48 * t1789 * t140 + 0.3e1 / 0.16e2 * t48 * t1789 * t151 + 0.3e1 / 0.8e1 * t105 * t468 + 0.11e2 / 0.16e2 * t48 * t1728 * t1812 - t105 * t452 / 0.4e1 + 0.3e1 / 0.8e1 * t48 * t1728 * t1905;
  t1912 = my_piecewise3(t3, 0, t1696 + t1753 + t1809 + t1909);
  tv4rho40 = 0.2e1 * rho[0] * t1912 + 0.8e1 * t481;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1916 = t178 * t36;
  t1923 = t182 * t145;
  t1924 = t369 * t59;
  t1925 = t1924 * t133;
  t1926 = t1923 * t1925;
  t1929 = t188 * t61;
  t1933 = t163 * t115;
  t1934 = t884 * t133;
  t1941 = t15 * t101 * t49;
  t1946 = t171 * t111;
  t1950 = t365 * t387;
  t1951 = t405 * t1714;
  t1952 = t1951 * t74;
  t1953 = t1950 * t1952;
  t1956 = t365 * t1755;
  t1957 = t1757 * t1714;
  t1958 = t1957 * t74;
  t1962 = t74 * t365;
  t1966 = t74 * t1755;
  t1967 = t1769 * t1714;
  t1968 = t1967 * t365;
  t1982 = t171 * t387;
  t1986 = t1962 * t1715;
  t1989 = -0.3e1 / 0.16e2 * t177 * t1916 * t1680 + 0.9e1 / 0.16e2 * t177 * t1916 * t1656 - 0.9e1 / 0.16e2 * t177 * t1926 - 0.3e1 / 0.8e1 * t177 * t1929 * t1925 + 0.9e1 / 0.32e2 * t162 * t1933 * t1934 - 0.9e1 / 0.32e2 * t162 * t1926 + 0.3e1 / 0.64e2 * t1941 * t179 + 0.9e1 / 0.32e2 * t497 * t505 + 0.9e1 / 0.16e2 * t177 * t1946 * t467 + 0.11e2 / 0.16e2 * t162 * t1953 - 0.15e2 / 0.32e2 * t162 * t1956 * t1958 - 0.25e2 / 0.16e2 * t177 * t1962 * t1764 + 0.15e2 / 0.16e2 * t177 * t1966 * t1968 + 0.3e1 / 0.8e1 * t497 * t532 + 0.3e1 / 0.4e1 * t177 * t1946 * t400 + 0.11e2 / 0.16e2 * t177 * t1962 * t1741 - 0.9e1 / 0.32e2 * t497 * t539 - 0.9e1 / 0.16e2 * t177 * t1982 * t538 - 0.3e1 / 0.2e1 * t177 * t1986;
  t2006 = t145 * t1714;
  t2007 = t2006 * t365;
  t2008 = t182 * t2007;
  t2013 = t61 * t1714;
  t2014 = t2013 * t365;
  t2027 = t500 * t509;
  t2033 = t183 * t437;
  t2039 = t519 * t171;
  t2045 = 0.9e1 / 0.8e1 * t177 * t1953 - 0.3e1 / 0.16e2 * t497 * t578 - 0.3e1 / 0.32e2 * t497 * t572 - 0.9e1 / 0.64e2 * t553 * t510 - 0.3e1 / 0.32e2 * t497 * t581 - 0.3e1 / 0.16e2 * t177 * t1946 * t370 - t177 * t1962 * t1730 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t2008 - 0.3e1 / 0.16e2 * t497 * t515 + 0.3e1 / 0.8e1 * t177 * t188 * t2014 + 0.9e1 / 0.64e2 * t553 * t521 + 0.3e1 / 0.8e1 * t177 * t1962 * t1801 - 0.3e1 / 0.64e2 * t1941 * t185 - 0.9e1 / 0.32e2 * t497 * t510 - 0.9e1 / 0.16e2 * t177 * t2027 - 0.11e2 / 0.16e2 * t177 * t1962 * t1736 + t177 * t182 * t2033 / 0.16e2 + 0.5e1 / 0.32e2 * t557 * t521 + 0.9e1 / 0.32e2 * t162 * t518 * t2039 - 0.5e1 / 0.32e2 * t557 * t510;
  t2049 = t489 * t113;
  t2056 = t527 * t171;
  t2062 = t389 * t1714;
  t2063 = t2062 * t74;
  t2070 = t365 * t113;
  t2071 = t115 * t1714;
  t2072 = t2071 * t74;
  t2105 = 0.5e1 / 0.32e2 * t557 * t529 + 0.3e1 / 0.16e2 * t177 * t2049 * t184 + 0.3e1 / 0.16e2 * t177 * t500 * t542 + 0.9e1 / 0.32e2 * t162 * t526 * t2056 + 0.9e1 / 0.16e2 * t162 * t2008 - 0.9e1 / 0.16e2 * t162 * t1950 * t2063 - 0.3e1 / 0.8e1 * t177 * t567 * t514 - 0.11e2 / 0.32e2 * t162 * t2070 * t2072 - 0.3e1 / 0.16e2 * t177 * t489 * t59 * t140 - 0.3e1 / 0.16e2 * t177 * t171 * t133 * t140 - 0.9e1 / 0.32e2 * t162 * t2027 - 0.7e1 / 0.32e2 * t162 * t1986 + 0.3e1 / 0.16e2 * t497 * t501 + 0.3e1 / 0.32e2 * t497 * t543 + 0.9e1 / 0.64e2 * t553 * t529 - t177 * t74 * t437 * t140 / 0.16e2 - t557 * t560 / 0.16e2 - 0.3e1 / 0.32e2 * t557 * t564 - t162 * t1705 * t165 / 0.32e2;
  t2110 = t15 * t101 * t110;
  t2120 = t189 * t437;
  t2125 = t15 * t45 * t422;
  t2131 = t15 * t18 * t1887;
  t2142 = t164 * t489;
  t2146 = t59 * t387;
  t2147 = t2146 * t389;
  t2155 = t536 * t405;
  t2167 = my_piecewise3(t32, -0.15e2 * t432 * t30, 0);
  t2172 = -0.3e1 / 0.32e2 * t162 * t395 * t563 + 0.3e1 / 0.128e3 * t2110 * t166 + 0.3e1 / 0.32e2 * t497 * t547 - 0.3e1 / 0.64e2 * t1941 * t191 + 0.3e1 / 0.16e2 * t177 * t567 * t546 + t177 * t188 * t2120 / 0.16e2 - 0.3e1 / 0.64e2 * t2125 * t166 - 0.3e1 / 0.64e2 * t553 * t560 - t2131 * t166 / 0.32e2 + 0.3e1 / 0.16e2 * t497 * t568 - 0.3e1 / 0.32e2 * t553 * t564 + 0.3e1 / 0.16e2 * t177 * t489 * t36 * t190 - 0.3e1 / 0.32e2 * t162 * t163 * t2142 + 0.9e1 / 0.32e2 * t162 * t2147 * t1934 + 0.3e1 / 0.4e1 * t177 * t178 * t113 * t1675 - 0.9e1 / 0.16e2 * t177 * t2155 * t1925 - 0.3e1 / 0.128e3 * t1719 * t76 + 0.3e1 / 0.64e2 * t443 * t173 - 0.3e1 / 0.32e2 * t105 * t491 - t48 * t49 * t2167 * t64 / 0.16e2;
  t2175 = my_piecewise3(t3, 0, t1989 + t2045 + t2105 + t2172);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2175 + 0.6e1 * t586;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2182 = t892 * t133;
  t2186 = t209 * t36;
  t2197 = t163 * t145;
  t2198 = t2197 * t2182;
  t2209 = t204 * t111;
  t2213 = t83 * t365;
  t2217 = t2213 * t1715;
  t2220 = t1951 * t365;
  t2221 = t636 * t2220;
  t2228 = t83 * t1755;
  t2241 = -0.3e1 / 0.8e1 * t177 * t909 * t1925 + 0.9e1 / 0.32e2 * t162 * t1933 * t2182 - 0.3e1 / 0.16e2 * t177 * t2186 * t1680 + 0.3e1 / 0.4e1 * t177 * t209 * t113 * t1675 - 0.9e1 / 0.16e2 * t177 * t901 * t1925 - 0.9e1 / 0.32e2 * t162 * t2198 + 0.9e1 / 0.32e2 * t162 * t2147 * t2182 + 0.9e1 / 0.16e2 * t177 * t2186 * t1656 - 0.9e1 / 0.16e2 * t177 * t2198 - 0.3e1 / 0.16e2 * t177 * t2209 * t370 - t177 * t2213 * t1730 / 0.16e2 - 0.3e1 / 0.2e1 * t177 * t2217 + 0.9e1 / 0.8e1 * t177 * t2221 - 0.25e2 / 0.16e2 * t177 * t636 * t1957 * t365 + 0.15e2 / 0.16e2 * t177 * t2228 * t1968 + 0.11e2 / 0.16e2 * t162 * t2221 + 0.3e1 / 0.8e1 * t497 * t646 + 0.3e1 / 0.4e1 * t177 * t2209 * t400 - 0.9e1 / 0.32e2 * t497 * t637;
  t2242 = t204 * t387;
  t2256 = t213 * t2007;
  t2273 = t614 * t509;
  t2287 = t519 * t204;
  t2291 = t1957 * t83;
  t2295 = -0.9e1 / 0.16e2 * t177 * t2242 * t538 + 0.11e2 / 0.16e2 * t177 * t2213 * t1741 - 0.9e1 / 0.64e2 * t553 * t625 + 0.3e1 / 0.32e2 * t497 * t656 - 0.11e2 / 0.16e2 * t177 * t2213 * t1736 + 0.11e2 / 0.16e2 * t177 * t2256 - 0.3e1 / 0.16e2 * t497 * t628 + 0.3e1 / 0.8e1 * t177 * t217 * t2014 + 0.9e1 / 0.64e2 * t553 * t633 + 0.9e1 / 0.16e2 * t177 * t2209 * t467 - 0.3e1 / 0.64e2 * t1941 * t214 - 0.9e1 / 0.32e2 * t497 * t625 - 0.9e1 / 0.16e2 * t177 * t2273 + 0.3e1 / 0.8e1 * t177 * t2213 * t1801 + 0.3e1 / 0.64e2 * t1941 * t210 + 0.9e1 / 0.32e2 * t497 * t622 - 0.3e1 / 0.32e2 * t497 * t619 + 0.5e1 / 0.32e2 * t557 * t633 + 0.9e1 / 0.32e2 * t162 * t518 * t2287 - 0.15e2 / 0.32e2 * t162 * t1956 * t2291;
  t2305 = t2062 * t83;
  t2312 = t2071 * t83;
  t2332 = t599 * t113;
  t2339 = t527 * t204;
  t2349 = -0.5e1 / 0.32e2 * t557 * t625 + 0.5e1 / 0.32e2 * t557 * t643 - 0.7e1 / 0.32e2 * t162 * t2217 + 0.9e1 / 0.16e2 * t162 * t2256 - 0.9e1 / 0.16e2 * t162 * t1950 * t2305 - 0.3e1 / 0.8e1 * t177 * t594 * t514 - 0.11e2 / 0.32e2 * t162 * t2070 * t2312 - 0.3e1 / 0.16e2 * t177 * t599 * t59 * t140 - 0.3e1 / 0.16e2 * t177 * t204 * t133 * t140 - 0.9e1 / 0.32e2 * t162 * t2273 + 0.3e1 / 0.16e2 * t497 * t615 + 0.3e1 / 0.32e2 * t497 * t653 + 0.9e1 / 0.64e2 * t553 * t643 + 0.3e1 / 0.16e2 * t177 * t2332 * t184 + 0.3e1 / 0.16e2 * t177 * t614 * t542 + 0.9e1 / 0.32e2 * t162 * t526 * t2339 - 0.3e1 / 0.16e2 * t497 * t609 - 0.3e1 / 0.32e2 * t497 * t650 - t557 * t665 / 0.16e2;
  t2371 = t599 * t36;
  t2375 = t164 * t599;
  t2398 = my_piecewise3(t32, -0.12e2 * t487, 0);
  t2405 = -0.3e1 / 0.32e2 * t557 * t591 - t162 * t1705 * t200 / 0.32e2 - 0.3e1 / 0.32e2 * t162 * t395 * t590 + t177 * t213 * t2033 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t594 * t546 + t177 * t217 * t2120 / 0.16e2 - 0.3e1 / 0.64e2 * t1941 * t218 + 0.3e1 / 0.128e3 * t2110 * t201 + 0.3e1 / 0.16e2 * t177 * t2371 * t190 - 0.3e1 / 0.32e2 * t162 * t163 * t2375 + 0.3e1 / 0.16e2 * t497 * t595 - 0.3e1 / 0.32e2 * t553 * t591 - t177 * t83 * t437 * t140 / 0.16e2 - 0.3e1 / 0.64e2 * t2125 * t201 - 0.3e1 / 0.64e2 * t553 * t665 - t2131 * t201 / 0.32e2 - 0.3e1 / 0.32e2 * t105 * t601 + 0.3e1 / 0.64e2 * t443 * t206 - t48 * t49 * t2398 * t64 / 0.16e2 - 0.3e1 / 0.128e3 * t1719 * t85;
  t2408 = my_piecewise3(t3, 0, t2241 + t2295 + t2349 + t2405);
  tv4rho3lapl0 = 0.2e1 * rho[0] * t2408 + 0.6e1 * t672;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t2412 = t237 * t36;
  t2423 = t930 * t1925;
  t2431 = t938 * t133;
  t2441 = t1957 * t91;
  t2445 = t91 * t365;
  t2451 = t232 * t111;
  t2457 = t2071 * t91;
  t2471 = 0.9e1 / 0.16e2 * t177 * t2412 * t1656 + 0.3e1 / 0.4e1 * t177 * t237 * t113 * t1675 - 0.9e1 / 0.16e2 * t177 * t947 * t1925 - 0.9e1 / 0.16e2 * t177 * t2423 - 0.3e1 / 0.8e1 * t177 * t934 * t1925 - 0.9e1 / 0.32e2 * t162 * t2423 + 0.9e1 / 0.32e2 * t162 * t2147 * t2431 - 0.3e1 / 0.16e2 * t177 * t2412 * t1680 + 0.9e1 / 0.32e2 * t162 * t1933 * t2431 - 0.15e2 / 0.32e2 * t162 * t1956 * t2441 - 0.25e2 / 0.16e2 * t177 * t2445 * t1764 + 0.3e1 / 0.8e1 * t497 * t721 + 0.3e1 / 0.4e1 * t177 * t2451 * t400 + 0.9e1 / 0.64e2 * t553 * t702 - 0.11e2 / 0.32e2 * t162 * t2070 * t2457 - 0.11e2 / 0.16e2 * t177 * t2445 * t1736 + 0.3e1 / 0.64e2 * t1941 * t238 + 0.9e1 / 0.32e2 * t497 * t705 + 0.9e1 / 0.16e2 * t177 * t2451 * t467;
  t2476 = t693 * t509;
  t2487 = t91 * t1755;
  t2493 = t232 * t387;
  t2500 = t2006 * t91;
  t2501 = t2070 * t2500;
  t2504 = t2062 * t91;
  t2508 = t2445 * t1715;
  t2511 = t724 * t2220;
  t2522 = t747 * t113;
  t2529 = -0.3e1 / 0.64e2 * t1941 * t242 - 0.9e1 / 0.32e2 * t497 * t708 - 0.9e1 / 0.16e2 * t177 * t2476 - 0.3e1 / 0.32e2 * t497 * t698 - 0.3e1 / 0.16e2 * t177 * t2451 * t370 - t177 * t2445 * t1730 / 0.16e2 + 0.15e2 / 0.16e2 * t177 * t2487 * t1968 - 0.9e1 / 0.32e2 * t497 * t725 - 0.9e1 / 0.16e2 * t177 * t2493 * t538 + 0.11e2 / 0.16e2 * t177 * t2445 * t1741 + 0.9e1 / 0.16e2 * t162 * t2501 - 0.9e1 / 0.16e2 * t162 * t1950 * t2504 - 0.3e1 / 0.2e1 * t177 * t2508 + 0.9e1 / 0.8e1 * t177 * t2511 + 0.11e2 / 0.16e2 * t162 * t2511 + 0.3e1 / 0.16e2 * t497 * t694 + 0.3e1 / 0.32e2 * t497 * t743 + 0.9e1 / 0.64e2 * t553 * t718 + 0.3e1 / 0.16e2 * t177 * t2522 * t184 + 0.3e1 / 0.16e2 * t177 * t693 * t542;
  t2531 = t527 * t232;
  t2556 = t747 * t36;
  t2560 = t164 * t747;
  t2581 = 0.9e1 / 0.32e2 * t162 * t526 * t2531 - 0.3e1 / 0.16e2 * t497 * t688 - 0.3e1 / 0.32e2 * t497 * t740 - 0.9e1 / 0.64e2 * t553 * t708 + 0.3e1 / 0.32e2 * t497 * t728 + 0.11e2 / 0.16e2 * t177 * t2501 - 0.3e1 / 0.16e2 * t497 * t712 + 0.3e1 / 0.8e1 * t177 * t245 * t2014 + 0.3e1 / 0.8e1 * t177 * t2445 * t1801 + t177 * t241 * t2033 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t2556 * t190 - 0.3e1 / 0.32e2 * t162 * t163 * t2560 + 0.3e1 / 0.16e2 * t497 * t736 - 0.3e1 / 0.32e2 * t553 * t732 + 0.3e1 / 0.16e2 * t177 * t735 * t546 + t177 * t245 * t2120 / 0.16e2 - 0.3e1 / 0.32e2 * t557 * t732 - 0.3e1 / 0.32e2 * t162 * t395 * t731 - 0.5e1 / 0.32e2 * t557 * t708;
  t2588 = t519 * t232;
  t2627 = my_piecewise3(t32, 0.48e2 * t487, 0);
  t2636 = 0.5e1 / 0.32e2 * t557 * t718 - 0.7e1 / 0.32e2 * t162 * t2508 + 0.5e1 / 0.32e2 * t557 * t702 + 0.9e1 / 0.32e2 * t162 * t518 * t2588 - 0.3e1 / 0.8e1 * t177 * t735 * t514 - 0.3e1 / 0.16e2 * t177 * t747 * t59 * t140 - 0.3e1 / 0.16e2 * t177 * t232 * t133 * t140 - 0.9e1 / 0.32e2 * t162 * t2476 - t557 * t682 / 0.16e2 - t162 * t1705 * t227 / 0.32e2 - 0.3e1 / 0.64e2 * t1941 * t246 + 0.3e1 / 0.128e3 * t2110 * t228 - 0.3e1 / 0.64e2 * t2125 * t228 - 0.3e1 / 0.64e2 * t553 * t682 - t2131 * t228 / 0.32e2 - t177 * t91 * t437 * t140 / 0.16e2 - 0.3e1 / 0.128e3 * t1719 * t93 - t48 * t49 * t2627 * t64 / 0.16e2 - 0.3e1 / 0.32e2 * t105 * t749 + 0.3e1 / 0.64e2 * t443 * t234;
  t2639 = my_piecewise3(t3, 0, t2471 + t2529 + t2581 + t2636);
  tv4rho3tau0 = 0.2e1 * rho[0] * t2639 + 0.6e1 * t758;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2643 = t508 * t171;
  t2647 = t1924 * t171;
  t2657 = t1923 * t2647;
  t2660 = t884 * t171;
  t2673 = t1957 * t111;
  t2677 = t253 * t1755;
  t2678 = t1967 * t111;
  t2682 = -t177 * t1916 * t2643 / 0.4e1 + 0.3e1 / 0.8e1 * t162 * t891 * t2647 + t177 * t182 * t389 * t2647 - 0.3e1 / 0.4e1 * t177 * t2155 * t2647 - 0.3e1 / 0.8e1 * t162 * t2657 + 0.3e1 / 0.8e1 * t162 * t1933 * t2660 + 0.3e1 / 0.4e1 * t177 * t188 * t115 * t2647 - 0.3e1 / 0.4e1 * t177 * t2657 - t177 * t1929 * t2647 / 0.2e1 - 0.25e2 / 0.16e2 * t177 * t774 * t2673 + 0.15e2 / 0.16e2 * t177 * t2677 * t2678;
  t2685 = t2062 * t111;
  t2686 = t769 * t2685;
  t2691 = t1951 * t111;
  t2692 = t774 * t2691;
  t2697 = t2006 * t111;
  t2698 = t769 * t2697;
  t2702 = t497 * t762 / 0.16e2;
  t2703 = t258 * t111;
  t2706 = 0.3e1 / 0.16e2 * t177 * t2703 * t467;
  t2711 = t177 * t2703 * t370 / 0.16e2;
  t2712 = t253 * t111;
  t2716 = t497 * t771 / 0.4e1 - 0.3e1 / 0.2e1 * t177 * t2686 - 0.3e1 / 0.16e2 * t497 * t776 + 0.9e1 / 0.8e1 * t177 * t2692 - 0.3e1 / 0.32e2 * t553 * t780 + 0.9e1 / 0.16e2 * t162 * t2698 - t2702 + t2706 - t497 * t766 / 0.16e2 - t2711 - t177 * t2712 * t1730 / 0.16e2;
  t2718 = t258 * t387;
  t2721 = 0.3e1 / 0.16e2 * t177 * t2718 * t538;
  t2724 = t177 * t2703 * t400 / 0.4e1;
  t2728 = t527 * t258;
  t2731 = 0.3e1 / 0.32e2 * t162 * t526 * t2728;
  t2747 = t537 * t133;
  t2751 = -t2721 + t2724 + 0.11e2 / 0.16e2 * t177 * t2712 * t1741 + t2731 - t557 * t829 / 0.8e1 + 0.5e1 / 0.32e2 * t557 * t832 - t177 * t253 * t133 * t370 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t2686 + t177 * t769 * t1675 / 0.4e1 + 0.11e2 / 0.16e2 * t162 * t2692 - 0.3e1 / 0.16e2 * t177 * t774 * t2747;
  t2752 = t111 * t1755;
  t2753 = t1957 * t253;
  t2759 = t769 * t1680;
  t2765 = t177 * t258 * t133 * t140 / 0.16e2;
  t2766 = t508 * t258;
  t2767 = t518 * t2766;
  t2769 = 0.3e1 / 0.32e2 * t162 * t2767;
  t2776 = t497 * t787 / 0.16e2;
  t2778 = 0.3e1 / 0.16e2 * t177 * t2767;
  t2780 = t553 * t795 / 0.32e2;
  t2781 = t519 * t258;
  t2784 = 0.3e1 / 0.32e2 * t162 * t518 * t2781;
  t2788 = -0.15e2 / 0.32e2 * t162 * t2752 * t2753 - 0.5e1 / 0.32e2 * t557 * t780 - 0.3e1 / 0.32e2 * t162 * t2759 - t2765 - t2769 + 0.3e1 / 0.32e2 * t553 * t783 - 0.9e1 / 0.16e2 * t162 * t774 * t2685 + t2776 - t2778 - t2780 + t2784 + 0.3e1 / 0.8e1 * t177 * t2712 * t1801;
  t2791 = t189 * t489;
  t2798 = t2071 * t253;
  t2811 = t183 * t489;
  t2818 = t557 * t795 / 0.32e2;
  t2821 = t162 * t395 * t794 / 0.32e2;
  t2822 = t177 * t188 * t2791 / 0.8e1 - t177 * t804 * t1690 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t518 * t2798 - t553 * t829 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t804 * t1656 + t497 * t812 / 0.8e1 - 0.3e1 / 0.16e2 * t497 * t780 + t177 * t182 * t2811 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t2759 - t2818 - t2821;
  t2837 = t177 * t786 * t542 / 0.16e2;
  t2840 = t177 * t837 * t514 / 0.8e1;
  t2843 = t2013 * t111;
  t2847 = t2071 * t111;
  t2853 = t177 * t837 * t546 / 0.16e2;
  t2854 = -t497 * t800 / 0.8e1 + 0.3e1 / 0.16e2 * t497 * t806 - t177 * t188 * t2142 / 0.8e1 + 0.5e1 / 0.32e2 * t557 * t783 + 0.3e1 / 0.32e2 * t162 * t774 * t1675 + t2837 - t2840 + 0.11e2 / 0.16e2 * t177 * t2698 + 0.3e1 / 0.8e1 * t177 * t804 * t2843 - 0.11e2 / 0.16e2 * t177 * t804 * t2847 + t2853;
  t2863 = t497 * t838 / 0.16e2;
  t2870 = t839 / 0.8e1;
  t2871 = t763 / 0.8e1;
  t2872 = t788 / 0.8e1;
  t2873 = t796 / 0.16e2;
  t2874 = t171 * t171;
  t2879 = -t162 * t182 * t2142 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t769 * t1656 + t2863 + t497 * t820 / 0.8e1 - t497 * t824 / 0.8e1 + 0.3e1 / 0.32e2 * t553 * t832 + t2870 - t2871 + t2872 - t2873 - t48 * t110 * t2874 * t119 / 0.16e2;
  t2881 = t443 * t260 / 0.64e2;
  t2884 = t49 * t2874;
  t2906 = t835 / 0.16e2;
  t2907 = t2881 - t443 * t270 / 0.64e2 + t48 * t2884 * t151 / 0.8e1 + t443 * t255 / 0.128e3 - t443 * t267 / 0.64e2 + t48 * t2884 * t147 / 0.8e1 + t443 * t264 / 0.64e2 - t48 * t2884 * t140 / 0.8e1 - t105 * t791 / 0.32e2 - t48 * t1887 * t253 * t119 / 0.32e2 - t2906 - t262;
  t2911 = my_piecewise3(t3, 0, t2682 + t2716 + t2751 + t2788 + t2822 + t2854 + t2879 + t2907);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2911 + 0.4e1 * t843;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2916 = t1714 * t83;
  t2917 = t2916 * t111;
  t2925 = t2228 * t1769;
  t2926 = t1714 * t74;
  t2927 = t2926 * t111;
  t2931 = t279 * t111;
  t2935 = t883 * t2927;
  t2943 = t897 * t2685;
  t2946 = t901 * t2927;
  t2959 = -0.15e2 / 0.32e2 * t162 * t1966 * t1757 * t2917 - 0.25e2 / 0.16e2 * t177 * t279 * t387 * t2673 + 0.15e2 / 0.16e2 * t177 * t2925 * t2927 + 0.11e2 / 0.16e2 * t177 * t2931 * t1741 + 0.11e2 / 0.16e2 * t177 * t2935 + 0.9e1 / 0.16e2 * t162 * t2935 - 0.9e1 / 0.16e2 * t162 * t891 * t2917 - 0.3e1 / 0.2e1 * t177 * t2943 + 0.9e1 / 0.8e1 * t177 * t2946 + 0.3e1 / 0.8e1 * t177 * t2931 * t1801 + 0.3e1 / 0.8e1 * t177 * t909 * t2927 - t497 * t906 / 0.16e2 + 0.3e1 / 0.16e2 * t497 * t918;
  t2965 = t518 * t115;
  t2966 = t2916 * t74;
  t2985 = t500 * t145 * t893;
  t2989 = t369 * t204 * t59;
  t2990 = t1923 * t2989;
  t2993 = t1923 * t2182;
  t2998 = t500 * t115;
  t3008 = 0.11e2 / 0.16e2 * t162 * t2946 - t177 * t909 * t1934 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t2965 * t2966 - t177 * t857 * t59 * t370 / 0.8e1 - t177 * t861 * t59 * t370 / 0.8e1 - t177 * t279 * t133 * t370 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t2943 - 0.3e1 / 0.16e2 * t162 * t2985 - 0.3e1 / 0.16e2 * t162 * t2990 - 0.3e1 / 0.32e2 * t162 * t2993 + 0.5e1 / 0.32e2 * t557 * t914 + 0.3e1 / 0.16e2 * t162 * t2998 * t893 + 0.3e1 / 0.16e2 * t162 * t913 * t2989 + 0.3e1 / 0.32e2 * t162 * t913 * t2182;
  t3042 = t1982 * t389;
  t3049 = 0.3e1 / 0.8e1 * t177 * t857 * t36 * t805 + 0.3e1 / 0.8e1 * t177 * t861 * t36 * t805 + 0.3e1 / 0.16e2 * t177 * t917 * t1656 - t497 * t910 / 0.8e1 + 0.3e1 / 0.32e2 * t553 * t914 - t177 * t594 * t61 * t885 / 0.4e1 - t177 * t909 * t2647 / 0.4e1 - 0.11e2 / 0.16e2 * t177 * t618 * t36 * t2072 - 0.3e1 / 0.32e2 * t553 * t886 + 0.3e1 / 0.32e2 * t553 * t894 + 0.5e1 / 0.32e2 * t557 * t894 + 0.3e1 / 0.16e2 * t162 * t3042 * t893 + 0.3e1 / 0.16e2 * t162 * t891 * t2989;
  t3089 = 0.3e1 / 0.32e2 * t162 * t891 * t2182 + t177 * t857 * t113 * t770 / 0.2e1 + t177 * t861 * t113 * t770 / 0.2e1 + t177 * t897 * t1675 / 0.4e1 - 0.3e1 / 0.8e1 * t177 * t2242 * t405 * t885 - 0.3e1 / 0.8e1 * t177 * t901 * t2647 - 0.3e1 / 0.16e2 * t177 * t901 * t1934 - 0.3e1 / 0.8e1 * t177 * t2990 - 0.3e1 / 0.8e1 * t177 * t2985 - 0.3e1 / 0.16e2 * t177 * t2993 - 0.5e1 / 0.32e2 * t557 * t886 + t497 * t898 / 0.4e1 - 0.3e1 / 0.16e2 * t497 * t902 - t177 * t2931 * t1730 / 0.16e2;
  t3128 = -0.3e1 / 0.16e2 * t497 * t886 - t497 * t858 / 0.16e2 - t162 * t500 * t590 / 0.16e2 - t177 * t83 * t489 * t140 / 0.16e2 + t177 * t2332 * t283 / 0.16e2 + t177 * t614 * t811 / 0.8e1 + t177 * t213 * t2811 / 0.16e2 + t177 * t2371 * t287 / 0.16e2 + t177 * t594 * t819 / 0.8e1 - t497 * t862 / 0.16e2 + t497 * t865 / 0.16e2 + t497 * t868 / 0.16e2 - t177 * t599 * t74 * t140 / 0.16e2;
  t3161 = -t177 * t204 * t171 * t140 / 0.8e1 + t497 * t871 / 0.16e2 + t497 * t874 / 0.16e2 - t2125 * t276 / 0.32e2 - t553 * t879 / 0.32e2 - t553 * t846 / 0.32e2 + t1941 * t280 / 0.64e2 - t1941 * t284 / 0.64e2 - t1941 * t288 / 0.64e2 + t2110 * t276 / 0.128e3 - t162 * t182 * t2375 / 0.32e2 + t177 * t217 * t2791 / 0.16e2 - t2131 * t276 / 0.32e2 - t557 * t879 / 0.16e2;
  t3168 = -t557 * t846 / 0.16e2 - t162 * t2049 * t200 / 0.32e2 - t2702 + t2706 - t2711 - t2721 + t2724 + t2731 - t2765 - t2769 + t2776 - t2778 - t2780;
  t3169 = t2784 - t2818 - t2821 + t2837 - t2840 + t2853 + t2863 + t2870 - t2871 + t2872 - t2873 + t2881 - t2906 - t262;
  t3173 = my_piecewise3(t3, 0, t2959 + t3008 + t3049 + t3089 + t3128 + t3161 + t3168 + t3169);
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t3173 + 0.4e1 * t923;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t3177 = t2487 * t1769;
  t3181 = t1714 * t91;
  t3182 = t3181 * t111;
  t3183 = t2155 * t3182;
  t3186 = t297 * t111;
  t3190 = t241 * t389;
  t3191 = t3190 * t2927;
  t3196 = t1923 * t3182;
  t3219 = 0.15e2 / 0.16e2 * t177 * t3177 * t2927 + 0.11e2 / 0.16e2 * t162 * t3183 + 0.11e2 / 0.16e2 * t177 * t3186 * t1741 - 0.3e1 / 0.2e1 * t177 * t3191 + 0.9e1 / 0.8e1 * t177 * t3183 + 0.9e1 / 0.16e2 * t162 * t3196 + 0.3e1 / 0.8e1 * t177 * t3186 * t1801 + 0.11e2 / 0.16e2 * t177 * t3196 + 0.3e1 / 0.8e1 * t177 * t934 * t2927 - t497 * t927 / 0.16e2 + 0.3e1 / 0.16e2 * t497 * t944 - t177 * t973 * t59 * t370 / 0.8e1 - t177 * t297 * t133 * t370 / 0.16e2;
  t3225 = t3181 * t74;
  t3233 = t735 * t61;
  t3252 = t693 * t145;
  t3253 = t3252 * t885;
  t3256 = t930 * t2647;
  t3259 = t930 * t1934;
  t3262 = -0.25e2 / 0.16e2 * t177 * t724 * t1757 * t2927 - 0.9e1 / 0.16e2 * t162 * t526 * t389 * t3225 - t497 * t935 / 0.8e1 + 0.3e1 / 0.32e2 * t553 * t940 - t177 * t3233 * t885 / 0.4e1 - t177 * t934 * t2647 / 0.4e1 - t177 * t934 * t1934 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t2965 * t3225 - 0.7e1 / 0.32e2 * t162 * t3191 - 0.3e1 / 0.16e2 * t497 * t931 + 0.3e1 / 0.32e2 * t553 * t953 - 0.3e1 / 0.8e1 * t177 * t3253 - 0.3e1 / 0.8e1 * t177 * t3256 - 0.3e1 / 0.16e2 * t177 * t3259;
  t3291 = t369 * t232;
  t3292 = t3291 * t59;
  t3301 = -t177 * t968 * t59 * t370 / 0.8e1 - 0.3e1 / 0.8e1 * t177 * t947 * t2647 - 0.3e1 / 0.16e2 * t177 * t947 * t1934 - 0.15e2 / 0.32e2 * t162 * t2752 * t1757 * t3225 - 0.5e1 / 0.32e2 * t557 * t931 - 0.3e1 / 0.16e2 * t162 * t3256 - 0.3e1 / 0.16e2 * t162 * t3253 - 0.3e1 / 0.32e2 * t162 * t3259 + 0.5e1 / 0.32e2 * t557 * t953 + 0.3e1 / 0.16e2 * t162 * t3042 * t939 + 0.3e1 / 0.16e2 * t162 * t891 * t3292 + 0.3e1 / 0.32e2 * t162 * t891 * t2431 + 0.5e1 / 0.32e2 * t557 * t940;
  t3329 = t697 * t36;
  t3346 = 0.3e1 / 0.16e2 * t162 * t2998 * t939 + 0.3e1 / 0.16e2 * t162 * t913 * t3292 + 0.3e1 / 0.32e2 * t162 * t913 * t2431 + 0.3e1 / 0.8e1 * t177 * t968 * t36 * t805 + 0.3e1 / 0.8e1 * t177 * t973 * t36 * t805 + 0.3e1 / 0.16e2 * t177 * t943 * t1656 - t177 * t3186 * t1730 / 0.16e2 + t497 * t957 / 0.4e1 - 0.3e1 / 0.16e2 * t497 * t948 - 0.11e2 / 0.16e2 * t177 * t3329 * t2072 - 0.3e1 / 0.32e2 * t553 * t931 + t177 * t968 * t113 * t770 / 0.2e1 + t177 * t973 * t113 * t770 / 0.2e1 + t177 * t956 * t1675 / 0.4e1;
  t3349 = t2493 * t405;
  t3385 = -0.3e1 / 0.8e1 * t177 * t3349 * t885 - t1941 * t304 / 0.64e2 + t2110 * t294 / 0.128e3 - t1941 * t301 / 0.64e2 - t162 * t2049 * t227 / 0.32e2 - t162 * t500 * t731 / 0.16e2 - t177 * t91 * t489 * t140 / 0.16e2 + t177 * t2522 * t283 / 0.16e2 + t177 * t693 * t811 / 0.8e1 + t177 * t241 * t2811 / 0.16e2 + t177 * t2556 * t287 / 0.16e2 - t2125 * t294 / 0.32e2 - t553 * t991 / 0.32e2;
  t3421 = -t553 * t994 / 0.32e2 - t497 * t969 / 0.16e2 - t497 * t974 / 0.16e2 - t177 * t747 * t74 * t140 / 0.16e2 - t177 * t232 * t171 * t140 / 0.8e1 + t497 * t977 / 0.16e2 + t497 * t980 / 0.16e2 + t497 * t983 / 0.16e2 + t497 * t986 / 0.16e2 + t1941 * t298 / 0.64e2 - t162 * t182 * t2560 / 0.32e2 + t177 * t735 * t819 / 0.8e1 + t177 * t245 * t2791 / 0.16e2 - t2131 * t294 / 0.32e2;
  t3427 = -t557 * t991 / 0.16e2 - t557 * t994 / 0.16e2 - t2702 + t2706 - t2711 - t2721 + t2724 + t2731 - t2765 - t2769 + t2776 - t2778 - t2780;
  t3431 = my_piecewise3(t3, 0, t3219 + t3262 + t3301 + t3346 + t3385 + t3421 + t3427 + t3169);
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t3431 + 0.4e1 * t999;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t3441 = t892 * t204;
  t3445 = t217 * t115;
  t3449 = t883 * t2989;
  t3455 = t508 * t204;
  t3459 = t213 * t389;
  t3464 = t310 * t111;
  t3468 = t1951 * t310;
  t3469 = t526 * t3468;
  t3472 = -0.3e1 / 0.4e1 * t177 * t901 * t2989 - t177 * t909 * t2989 / 0.2e1 + 0.3e1 / 0.8e1 * t162 * t1933 * t3441 + 0.3e1 / 0.4e1 * t177 * t3445 * t2989 - 0.3e1 / 0.8e1 * t162 * t3449 + 0.3e1 / 0.8e1 * t162 * t1077 * t2989 - t177 * t2186 * t3455 / 0.4e1 + t177 * t3459 * t2989 - 0.3e1 / 0.4e1 * t177 * t3449 - t177 * t3464 * t1730 / 0.16e2 + 0.11e2 / 0.16e2 * t162 * t3469;
  t3476 = t310 * t1755;
  t3483 = t183 * t599;
  t3498 = t1957 * t310;
  t3504 = -0.25e2 / 0.16e2 * t177 * t1010 * t2673 + 0.15e2 / 0.16e2 * t177 * t3476 * t2678 + 0.11e2 / 0.16e2 * t177 * t3464 * t1741 + t177 * t213 * t3483 / 0.8e1 - t557 * t1053 / 0.8e1 + 0.5e1 / 0.32e2 * t557 * t1056 - t497 * t1026 / 0.8e1 + 0.3e1 / 0.16e2 * t497 * t1030 - 0.3e1 / 0.16e2 * t177 * t1010 * t2747 - 0.15e2 / 0.32e2 * t162 * t2752 * t3498 - 0.5e1 / 0.32e2 * t557 * t1014;
  t3506 = t1006 * t1680;
  t3518 = t2062 * t310;
  t3519 = t518 * t3518;
  t3525 = t2071 * t310;
  t3539 = -0.3e1 / 0.32e2 * t162 * t3506 + 0.5e1 / 0.32e2 * t557 * t1017 + 0.3e1 / 0.32e2 * t162 * t1010 * t1675 - t177 * t310 * t133 * t370 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t3519 + t177 * t1006 * t1675 / 0.4e1 - 0.11e2 / 0.32e2 * t162 * t518 * t3525 - t553 * t1053 / 0.16e2 - t162 * t213 * t2375 / 0.16e2 + 0.3e1 / 0.32e2 * t162 * t1006 * t1656 - 0.3e1 / 0.16e2 * t177 * t3506;
  t3546 = t189 * t599;
  t3563 = t1006 * t2697;
  t3572 = t497 * t1045 / 0.8e1 - t497 * t1048 / 0.8e1 + 0.3e1 / 0.32e2 * t553 * t1056 + t177 * t217 * t3546 / 0.8e1 - t177 * t1029 * t1690 / 0.8e1 - t177 * t217 * t2375 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1029 * t1656 + t497 * t1037 / 0.8e1 - 0.3e1 / 0.16e2 * t497 * t1014 + 0.11e2 / 0.16e2 * t177 * t3563 + 0.3e1 / 0.8e1 * t177 * t1029 * t2843 - 0.11e2 / 0.16e2 * t177 * t1029 * t2847;
  t3597 = 0.9e1 / 0.8e1 * t177 * t3469 - 0.3e1 / 0.32e2 * t553 * t1014 + 0.9e1 / 0.16e2 * t162 * t3563 + 0.3e1 / 0.32e2 * t553 * t1017 - 0.9e1 / 0.16e2 * t162 * t1010 * t2685 - t497 * t1003 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t3464 * t1801 + t497 * t1007 / 0.4e1 - 0.3e1 / 0.2e1 * t177 * t3519 - 0.3e1 / 0.16e2 * t497 * t1011 - t2702;
  t3598 = t2706 - t2711 - t2721 + t2724 + t2731 - t2765 - t2769 + t2776 - t2778 - t2780 + t2784;
  t3602 = -t2818 - t2821 + t2837 - t2840 + t2853 + t2863 + t2870 - t2871 + t2872 - t2873 + t443 * t312 / 0.128e3;
  t3603 = t204 * t204;
  t3610 = t49 * t3603;
  t3630 = -t48 * t110 * t3603 * t119 / 0.16e2 - t443 * t322 / 0.64e2 + t48 * t3610 * t151 / 0.8e1 - t443 * t319 / 0.64e2 + t48 * t3610 * t147 / 0.8e1 + t443 * t316 / 0.64e2 - t48 * t3610 * t140 / 0.8e1 - t105 * t1021 / 0.32e2 - t48 * t1887 * t310 * t119 / 0.32e2 + t2881 - t2906 - t262;
  t3634 = my_piecewise3(t3, 0, t3472 + t3504 + t3539 + t3572 + t3597 + t3598 + t3602 + t3630);
  tv4rho2lapl20 = 0.2e1 * rho[0] * t3634 + 0.4e1 * t1061;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  t3646 = t947 * t2917;
  t3651 = t2228 * t1757;
  t3655 = t331 * t387;
  t3662 = t331 * t111;
  t3666 = t930 * t2917;
  t3674 = t1081 * t2685;
  t3679 = -t177 * t1107 * t59 * t370 / 0.8e1 - t177 * t1111 * t59 * t370 / 0.8e1 + 0.9e1 / 0.8e1 * t177 * t3646 + 0.11e2 / 0.16e2 * t162 * t3646 - 0.15e2 / 0.32e2 * t162 * t3651 * t3182 - 0.25e2 / 0.16e2 * t177 * t3655 * t2673 + 0.15e2 / 0.16e2 * t177 * t3177 * t2917 + 0.11e2 / 0.16e2 * t177 * t3662 * t1741 + 0.11e2 / 0.16e2 * t177 * t3666 + 0.9e1 / 0.16e2 * t162 * t3666 - 0.9e1 / 0.16e2 * t162 * t1077 * t3182 - 0.3e1 / 0.2e1 * t177 * t3674 - t497 * t1089 / 0.16e2;
  t3680 = t3291 * t83;
  t3684 = t1107 * t36;
  t3688 = t2197 * t3680;
  t3691 = t1111 * t36;
  t3716 = t1107 * t113;
  t3720 = 0.3e1 / 0.16e2 * t162 * t1933 * t3680 + 0.3e1 / 0.8e1 * t177 * t3684 * t805 - 0.3e1 / 0.16e2 * t162 * t3688 + 0.3e1 / 0.8e1 * t177 * t3691 * t805 - 0.3e1 / 0.16e2 * t497 * t1085 - 0.3e1 / 0.8e1 * t177 * t947 * t2989 - 0.5e1 / 0.32e2 * t557 * t1072 + 0.5e1 / 0.32e2 * t557 * t1078 - t177 * t3662 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t3329 * t2312 - 0.3e1 / 0.32e2 * t553 * t1072 + 0.3e1 / 0.32e2 * t553 * t1078 + t497 * t1082 / 0.4e1 + t177 * t3716 * t770 / 0.2e1;
  t3722 = t1111 * t113;
  t3738 = t938 * t204;
  t3744 = t2197 * t3738;
  t3760 = t177 * t3722 * t770 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t3349 * t893 - t177 * t331 * t133 * t370 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t3674 - t177 * t934 * t2989 / 0.4e1 + 0.3e1 / 0.16e2 * t162 * t1933 * t3738 + 0.5e1 / 0.32e2 * t557 * t1065 - 0.3e1 / 0.16e2 * t162 * t3744 - 0.3e1 / 0.8e1 * t177 * t3688 + 0.3e1 / 0.16e2 * t162 * t2147 * t3680 - 0.3e1 / 0.8e1 * t177 * t3744 + 0.3e1 / 0.16e2 * t162 * t2147 * t3738 - t177 * t3233 * t893 / 0.4e1;
  t3770 = t930 * t2182;
  t3785 = t3181 * t83;
  t3799 = 0.3e1 / 0.32e2 * t162 * t1077 * t2431 + t177 * t1081 * t1675 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t947 * t2182 - 0.3e1 / 0.16e2 * t177 * t3770 - 0.3e1 / 0.32e2 * t162 * t3770 + 0.3e1 / 0.16e2 * t497 * t1069 + 0.3e1 / 0.16e2 * t177 * t1068 * t1656 - 0.3e1 / 0.16e2 * t497 * t1072 - t177 * t934 * t2182 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t2965 * t3785 + 0.3e1 / 0.32e2 * t553 * t1065 + 0.3e1 / 0.32e2 * t162 * t1064 * t2431 + 0.3e1 / 0.8e1 * t177 * t3662 * t1801 - t497 * t1092 / 0.8e1;
  t3837 = 0.3e1 / 0.8e1 * t177 * t934 * t2917 - t177 * t747 * t83 * t140 / 0.16e2 - t177 * t232 * t204 * t140 / 0.8e1 - t177 * t91 * t599 * t140 / 0.16e2 + t177 * t2522 * t335 / 0.16e2 + t177 * t693 * t1036 / 0.8e1 - t1941 * t340 / 0.64e2 - t1941 * t336 / 0.64e2 + t2110 * t328 / 0.128e3 + t1941 * t332 / 0.64e2 + t497 * t1124 / 0.16e2 - t2125 * t328 / 0.32e2 - t553 * t1129 / 0.32e2;
  t3872 = -t553 * t1095 / 0.32e2 + t497 * t1115 / 0.16e2 + t497 * t1118 / 0.16e2 + t497 * t1121 / 0.16e2 - t497 * t1108 / 0.16e2 - t497 * t1112 / 0.16e2 - t557 * t1129 / 0.16e2 - t557 * t1095 / 0.16e2 - t162 * t2332 * t227 / 0.32e2 - t162 * t614 * t731 / 0.16e2 - t162 * t213 * t2560 / 0.32e2 + t177 * t241 * t3483 / 0.16e2 + t177 * t2556 * t339 / 0.16e2 + t177 * t735 * t1044 / 0.8e1;
  t3879 = t177 * t245 * t3546 / 0.16e2 - t2131 * t328 / 0.32e2 - t2702 + t2706 - t2711 - t2721 + t2724 + t2731 - t2765 - t2769 + t2776 - t2778 - t2780;
  t3883 = my_piecewise3(t3, 0, t3679 + t3720 + t3760 + t3799 + t3837 + t3872 + t3879 + t3169);
  tv4rho2lapltau0 = 0.2e1 * rho[0] * t3883 + 0.4e1 * t1134;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t3887 = t508 * t232;
  t3899 = t938 * t232;
  t3903 = t245 * t115;
  t3907 = t2197 * t3899;
  t3915 = t346 * t111;
  t3921 = -t177 * t2412 * t3887 / 0.4e1 + t177 * t3190 * t3292 - 0.3e1 / 0.4e1 * t177 * t947 * t3292 - t177 * t934 * t3292 / 0.2e1 + 0.3e1 / 0.8e1 * t162 * t1933 * t3899 + 0.3e1 / 0.4e1 * t177 * t3903 * t3292 - 0.3e1 / 0.8e1 * t162 * t3907 - 0.3e1 / 0.4e1 * t177 * t3907 + 0.3e1 / 0.8e1 * t162 * t2147 * t3899 - t177 * t3915 * t1730 / 0.16e2 + t497 * t1184 / 0.4e1;
  t3931 = t1152 * t1680;
  t3934 = t2062 * t346;
  t3952 = 0.3e1 / 0.8e1 * t177 * t3915 * t1801 - 0.3e1 / 0.16e2 * t497 * t1187 + t177 * t241 * t183 * t747 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t3931 - 0.9e1 / 0.16e2 * t162 * t526 * t3934 + t497 * t1159 / 0.8e1 - t497 * t1139 / 0.8e1 + 0.3e1 / 0.16e2 * t497 * t1143 - 0.3e1 / 0.32e2 * t553 * t1153 - t177 * t245 * t2560 / 0.8e1 + 0.3e1 / 0.16e2 * t177 * t1142 * t1656;
  t3954 = t1152 * t2697;
  t3966 = t1180 * t2691;
  t3969 = t346 * t1755;
  t3979 = t1152 * t2685;
  t3987 = 0.11e2 / 0.16e2 * t177 * t3954 + 0.3e1 / 0.8e1 * t177 * t1142 * t2843 - 0.11e2 / 0.16e2 * t177 * t1142 * t2847 + 0.11e2 / 0.16e2 * t177 * t3915 * t1741 + 0.11e2 / 0.16e2 * t162 * t3966 - 0.15e2 / 0.32e2 * t162 * t3969 * t2673 - 0.25e2 / 0.16e2 * t177 * t1180 * t2673 + 0.15e2 / 0.16e2 * t177 * t3969 * t2678 - 0.3e1 / 0.2e1 * t177 * t3979 + 0.9e1 / 0.8e1 * t177 * t3966 + 0.3e1 / 0.32e2 * t162 * t1152 * t1656;
  t4005 = t2071 * t346;
  t4019 = -t177 * t346 * t133 * t370 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t3979 - t497 * t1162 / 0.8e1 + 0.3e1 / 0.32e2 * t553 * t1170 + t177 * t245 * t189 * t747 / 0.8e1 - t177 * t1142 * t1690 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t518 * t4005 - t553 * t1167 / 0.16e2 + 0.9e1 / 0.16e2 * t162 * t3954 + t497 * t1149 / 0.8e1 - 0.3e1 / 0.16e2 * t497 * t1153 + 0.3e1 / 0.32e2 * t553 * t1181;
  t4046 = -t497 * t1175 / 0.16e2 - 0.5e1 / 0.32e2 * t557 * t1153 - 0.3e1 / 0.32e2 * t162 * t3931 + 0.5e1 / 0.32e2 * t557 * t1181 + 0.3e1 / 0.32e2 * t162 * t1180 * t1675 + t177 * t1152 * t1675 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1180 * t2747 - t557 * t1167 / 0.8e1 - t162 * t241 * t2560 / 0.16e2 + 0.5e1 / 0.32e2 * t557 * t1170 - t2702;
  t4048 = t232 * t232;
  t4049 = t49 * t4048;
  t4060 = -t2818 - t2821 + t2837 - t2840 + t2853 + t2863 + t48 * t4049 * t147 / 0.8e1 - t443 * t358 / 0.64e2 + t443 * t352 / 0.64e2 - t48 * t4049 * t140 / 0.8e1 + t2870;
  t4078 = -t2871 + t2872 - t2873 - t105 * t1191 / 0.32e2 - t48 * t1887 * t346 * t119 / 0.32e2 - t48 * t110 * t4048 * t119 / 0.16e2 + t48 * t4049 * t151 / 0.8e1 + t443 * t348 / 0.128e3 - t443 * t355 / 0.64e2 + t2881 - t2906 - t262;
  t4082 = my_piecewise3(t3, 0, t3921 + t3952 + t3987 + t4019 + t4046 + t3598 + t4060 + t4078);
  tv4rho2tau20 = 0.2e1 * rho[0] * t4082 + 0.4e1 * t1196;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t4087 = t177 * t761 * t36 * t520;
  t4091 = t177 * t1220 * t59 * t370;
  t4093 = t369 * t258;
  t4094 = t4093 * t59;
  t4096 = t162 * t913 * t4094;
  t4100 = t177 * t2718 * t405 * t885;
  t4102 = t1923 * t4094;
  t4103 = t162 * t4102;
  t4106 = t162 * t891 * t4094;
  t4108 = t177 * t4102;
  t4112 = t177 * t1220 * t113 * t770;
  t4116 = t177 * t837 * t61 * t885;
  t4122 = t1199 * t113;
  t4123 = t2062 * t59;
  t4124 = t4122 * t4123;
  t4127 = t1199 * t387;
  t4128 = t1951 * t59;
  t4129 = t4127 * t4128;
  t4137 = t1199 * t1755;
  t4138 = t1957 * t59;
  t4145 = 0.9e1 / 0.16e2 * t4087 - 0.3e1 / 0.16e2 * t4091 + 0.9e1 / 0.32e2 * t4096 - 0.9e1 / 0.16e2 * t4100 - 0.9e1 / 0.32e2 * t4103 + 0.9e1 / 0.32e2 * t4106 - 0.9e1 / 0.16e2 * t4108 + 0.3e1 / 0.4e1 * t4112 - 0.3e1 / 0.8e1 * t4116 - t1264 * t780 / 0.16e2 + t1264 * t783 / 0.16e2 - 0.3e1 / 0.2e1 * t177 * t4124 + 0.9e1 / 0.8e1 * t177 * t4129 + 0.11e2 / 0.16e2 * t177 * t4122 * t4128 + 0.11e2 / 0.16e2 * t162 * t4129 - 0.15e2 / 0.32e2 * t162 * t4137 * t4138 - 0.25e2 / 0.16e2 * t177 * t4127 * t4138;
  t4146 = t1967 * t59;
  t4150 = t2006 * t1199;
  t4151 = t163 * t4150;
  t4154 = t769 * t2643;
  t4163 = t513 * t171;
  t4167 = t1199 * t36;
  t4168 = t2013 * t59;
  t4176 = t557 * t1210;
  t4179 = t162 * t500 * t794;
  t4184 = t2071 * t59;
  t4188 = t553 * t1210;
  t4190 = t497 * t1217;
  t4198 = t177 * t786 * t811;
  t4203 = 0.15e2 / 0.16e2 * t177 * t4137 * t4146 + 0.9e1 / 0.16e2 * t162 * t4151 - 0.9e1 / 0.16e2 * t177 * t4154 + 0.11e2 / 0.16e2 * t177 * t4151 - 0.9e1 / 0.16e2 * t162 * t2146 * t2062 * t1199 - 0.3e1 / 0.8e1 * t177 * t804 * t4163 + 0.3e1 / 0.8e1 * t177 * t4167 * t4168 - 0.11e2 / 0.32e2 * t162 * t163 * t2071 * t1199 - 0.3e1 / 0.32e2 * t4176 - 0.3e1 / 0.32e2 * t4179 + 0.9e1 / 0.16e2 * t177 * t804 * t2039 - 0.11e2 / 0.16e2 * t177 * t4167 * t4184 - 0.3e1 / 0.64e2 * t4188 + 0.3e1 / 0.32e2 * t4190 - 0.9e1 / 0.32e2 * t162 * t4154 + 0.9e1 / 0.32e2 * t162 * t774 * t2056 + 0.3e1 / 0.16e2 * t4198 + 0.3e1 / 0.4e1 * t177 * t769 * t2056;
  t4209 = t177 * t837 * t819;
  t4213 = t177 * t258 * t171 * t140;
  t4218 = t1199 * t59;
  t4225 = t497 * t1221;
  t4227 = t497 * t1233;
  t4229 = t537 * t171;
  t4251 = 0.9e1 / 0.32e2 * t162 * t769 * t2039 + 0.3e1 / 0.16e2 * t4209 - 0.3e1 / 0.16e2 * t4213 - 0.3e1 / 0.16e2 * t177 * t804 * t2643 + 0.3e1 / 0.8e1 * t177 * t4218 * t1801 - t177 * t4218 * t1730 / 0.16e2 - 0.3e1 / 0.32e2 * t4225 + 0.3e1 / 0.32e2 * t4227 - 0.9e1 / 0.16e2 * t177 * t774 * t4229 - t1264 * t829 / 0.16e2 + t1264 * t832 / 0.16e2 - 0.7e1 / 0.32e2 * t162 * t4124 - 0.3e1 / 0.32e2 * t105 * t1239 - t105 * t1249 / 0.64e2 - 0.3e1 / 0.64e2 * t105 * t1227 + 0.3e1 / 0.64e2 * t105 * t1230 + t105 * t1236 / 0.8e1 + 0.3e1 / 0.64e2 * t105 * t1214;
  t4254 = t422 * t1199;
  t4259 = t110 * t59 * t113;
  t4273 = t118 * t59;
  t4274 = t116 * t4273;
  t4277 = t1859 * t59;
  t4278 = t118 * t74;
  t4279 = t116 * t4278;
  t4285 = t59 * t36;
  t4286 = t4285 * t164;
  t4289 = t146 * t4273;
  t4292 = t62 * t4273;
  t4307 = t4259 * t165 / 0.4e1 + t173 / 0.2e1 + t75 * t59 * t140 / 0.2e1 - t75 * t113 * t184 / 0.2e1 - t75 * t36 * t190 / 0.2e1 - t1855 * t74 * t4274 / 0.2e1 + t4277 * t4279 / 0.2e1 + t415 * t171 * t64 / 0.2e1 + t1242 * t4286 / 0.2e1 - t1242 * t4289 / 0.2e1 - t1242 * t4292 / 0.2e1 - t1873 * t74 * t64 / 0.2e1 - t418 * t171 * t64 / 0.2e1 - t1244 * t4286 / 0.2e1 + t1244 * t4289 / 0.2e1 + t1244 * t4292 / 0.2e1;
  t4324 = -t105 * t1224 / 0.32e2 + 0.3e1 / 0.32e2 * t48 * t4254 * t391 - t48 * t4307 * t253 * t119 / 0.32e2 + 0.3e1 / 0.32e2 * t48 * t4254 * t459 - 0.3e1 / 0.32e2 * t48 * t4254 * t383 - 0.3e1 / 0.32e2 * t105 * t1204 - t105 * t1207 / 0.16e2 + 0.3e1 / 0.32e2 * t105 * t1201 - t1212 + t1219 - t1223 + t1235 + t840 - t764 + t789 - t797 - t836 - t262;
  t4327 = my_piecewise3(t3, 0, t4145 + t4203 + t4251 + t4324);
  tv4rhosigma30 = 0.2e1 * rho[0] * t4327 + 0.2e1 * t1253;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t4331 = t177 * t2186 * t2781;
  t4332 = 0.3e1 / 0.16e2 * t4331;
  t4335 = t177 * t1270 * t59 * t370;
  t4336 = t4335 / 0.16e2;
  t4338 = t1714 * t253 * t59;
  t4339 = t901 * t4338;
  t4342 = t636 * t1757;
  t4352 = t177 * t3459 * t4094;
  t4353 = t4352 / 0.4e1;
  t4355 = t177 * t901 * t4094;
  t4356 = 0.3e1 / 0.16e2 * t4355;
  t4361 = t786 * t145;
  t4362 = t4361 * t893;
  t4363 = t162 * t4362;
  t4364 = 0.3e1 / 0.32e2 * t4363;
  t4365 = t1278 * t113;
  t4369 = t4332 - t4336 + 0.9e1 / 0.8e1 * t177 * t4339 - 0.25e2 / 0.16e2 * t177 * t4342 * t4338 + 0.15e2 / 0.16e2 * t177 * t2925 * t4338 + 0.11e2 / 0.16e2 * t162 * t4339 + t4353 - t4356 - t1264 * t886 / 0.16e2 + t1264 * t894 / 0.16e2 - t4364 + 0.11e2 / 0.16e2 * t177 * t4365 * t4128;
  t4370 = t769 * t145;
  t4371 = t2916 * t59;
  t4372 = t4370 * t4371;
  t4375 = t774 * t389;
  t4379 = t4365 * t4123;
  t4384 = t177 * t4362;
  t4385 = 0.3e1 / 0.16e2 * t4384;
  t4386 = t892 * t258;
  t4388 = t162 * t2147 * t4386;
  t4389 = 0.3e1 / 0.32e2 * t4388;
  t4390 = t883 * t2660;
  t4405 = t1278 * t36;
  t4406 = t2006 * t59;
  t4412 = 0.9e1 / 0.16e2 * t162 * t4372 - 0.9e1 / 0.16e2 * t162 * t4375 * t4371 - 0.3e1 / 0.2e1 * t177 * t4379 + t1264 * t914 / 0.16e2 - t4385 + t4389 - 0.3e1 / 0.8e1 * t177 * t4390 + 0.3e1 / 0.8e1 * t177 * t909 * t4338 - t177 * t909 * t2660 / 0.4e1 - 0.3e1 / 0.8e1 * t177 * t901 * t2660 - t177 * t917 * t2643 / 0.8e1 + 0.3e1 / 0.8e1 * t177 * t4405 * t4406 - 0.7e1 / 0.32e2 * t162 * t4379;
  t4414 = t892 * t171;
  t4418 = t769 * t115;
  t4429 = t177 * t909 * t4094;
  t4430 = t4429 / 0.8e1;
  t4432 = t162 * t1933 * t4386;
  t4433 = 0.3e1 / 0.32e2 * t4432;
  t4434 = 0.3e1 / 0.8e1 * t4087;
  t4435 = t4091 / 0.8e1;
  t4442 = t2916 * t253;
  t4454 = 0.3e1 / 0.16e2 * t162 * t913 * t4414 - 0.11e2 / 0.32e2 * t162 * t4418 * t4371 + 0.3e1 / 0.8e1 * t177 * t917 * t2039 - 0.11e2 / 0.16e2 * t177 * t4405 * t4184 - t4430 + t4433 + t4434 - t4435 - t177 * t1278 * t59 * t1730 / 0.16e2 - 0.15e2 / 0.32e2 * t162 * t59 * t1755 * t1757 * t4442 - 0.3e1 / 0.16e2 * t162 * t4390 + 0.3e1 / 0.16e2 * t162 * t891 * t4414 + t177 * t897 * t2056 / 0.2e1;
  t4457 = 0.3e1 / 0.16e2 * t4096;
  t4458 = 0.3e1 / 0.8e1 * t4100;
  t4459 = 0.3e1 / 0.16e2 * t4103;
  t4460 = 0.3e1 / 0.16e2 * t4106;
  t4461 = 0.3e1 / 0.8e1 * t4108;
  t4462 = t4112 / 0.2e1;
  t4463 = t4116 / 0.4e1;
  t4465 = t177 * t594 * t1259;
  t4466 = t4465 / 0.16e2;
  t4475 = t769 * t3455;
  t4478 = 0.11e2 / 0.16e2 * t177 * t4372 + t4457 - t4458 - t4459 + t4460 - t4461 + t4462 - t4463 + t4466 - t177 * t594 * t1292 / 0.8e1 - 0.3e1 / 0.16e2 * t177 * t2242 * t1296 - 0.3e1 / 0.32e2 * t557 * t1289 - 0.3e1 / 0.32e2 * t162 * t4475;
  t4486 = t204 * t253;
  t4504 = t15 * t18 * t4307;
  t4511 = t557 * t1267;
  t4512 = t4511 / 0.32e2;
  t4514 = t162 * t786 * t590;
  t4515 = t4514 / 0.32e2;
  t4516 = 0.3e1 / 0.32e2 * t557 * t1302 + 0.3e1 / 0.32e2 * t162 * t774 * t2339 + t177 * t4486 * t400 / 0.4e1 - t177 * t4486 * t370 / 0.16e2 + 0.3e1 / 0.32e2 * t557 * t1282 + 0.3e1 / 0.32e2 * t162 * t769 * t2287 + 0.3e1 / 0.16e2 * t177 * t4486 * t467 - 0.3e1 / 0.16e2 * t177 * t4475 - t4504 * t276 / 0.32e2 - t1264 * t879 / 0.32e2 - t1264 * t846 / 0.32e2 - t4512 - t4515;
  t4519 = t177 * t204 * t258 * t140;
  t4520 = t4519 / 0.16e2;
  t4522 = t177 * t614 * t1255;
  t4523 = t4522 / 0.16e2;
  t4543 = t15 * t45 * t1247;
  t4546 = t553 * t1267;
  t4547 = t4546 / 0.64e2;
  t4548 = -t4520 + t4523 - 0.3e1 / 0.64e2 * t553 * t1289 + 0.3e1 / 0.64e2 * t553 * t1302 + t497 * t1305 / 0.8e1 - 0.3e1 / 0.32e2 * t497 * t1289 - t497 * t1293 / 0.16e2 - 0.3e1 / 0.32e2 * t497 * t1297 - t497 * t1279 / 0.32e2 + 0.3e1 / 0.64e2 * t553 * t1282 + 0.3e1 / 0.32e2 * t497 * t1285 - t4543 * t276 / 0.64e2 - t4547;
  t4550 = t497 * t1271;
  t4551 = t4550 / 0.32e2;
  t4552 = t497 * t1256;
  t4553 = t4552 / 0.32e2;
  t4554 = t497 * t1260;
  t4555 = t4554 / 0.32e2;
  t4556 = t4176 / 0.16e2;
  t4557 = t4179 / 0.16e2;
  t4558 = t4188 / 0.32e2;
  t4559 = t4190 / 0.16e2;
  t4560 = t4198 / 0.8e1;
  t4561 = t4209 / 0.8e1;
  t4562 = t4213 / 0.8e1;
  t4563 = t4225 / 0.16e2;
  t4564 = t4227 / 0.16e2;
  t4565 = -t4551 + t4553 + t4555 - t4556 - t4557 - t4558 + t4559 + t4560 + t4561 - t4562 - t4563 + t4564 - t1274;
  t4566 = t1275 - t1276 + t1277 + t1258 + t1262 - t1269 - t1273 + t840 - t764 + t789 - t797 - t836 - t262;
  t4570 = my_piecewise3(t3, 0, t4369 + t4412 + t4454 + t4478 + t4516 + t4548 + t4565 + t4566);
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t4570 + 0.2e1 * t1309;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t4576 = t3181 * t59;
  t4577 = t774 * t405 * t4576;
  t4591 = t4361 * t939;
  t4592 = t162 * t4591;
  t4593 = 0.3e1 / 0.32e2 * t4592;
  t4594 = t1326 * t113;
  t4598 = t4370 * t4576;
  t4604 = t4594 * t4123;
  t4610 = t177 * t3190 * t4094;
  t4611 = t4610 / 0.4e1;
  t4612 = t1264 * t953 / 0.16e2 + 0.11e2 / 0.16e2 * t162 * t4577 - 0.15e2 / 0.32e2 * t162 * t2677 * t1757 * t4576 - 0.25e2 / 0.16e2 * t177 * t1326 * t387 * t4138 + 0.15e2 / 0.16e2 * t177 * t3177 * t4338 - t4593 + 0.11e2 / 0.16e2 * t177 * t4594 * t4128 + 0.9e1 / 0.16e2 * t162 * t4598 - 0.9e1 / 0.16e2 * t162 * t4375 * t4576 - 0.3e1 / 0.2e1 * t177 * t4604 + 0.9e1 / 0.8e1 * t177 * t4577 + t4611;
  t4614 = t177 * t947 * t4094;
  t4615 = 0.3e1 / 0.16e2 * t4614;
  t4618 = t177 * t4591;
  t4619 = 0.3e1 / 0.16e2 * t4618;
  t4620 = t938 * t258;
  t4622 = t162 * t2147 * t4620;
  t4623 = 0.3e1 / 0.32e2 * t4622;
  t4625 = t177 * t934 * t4094;
  t4626 = t4625 / 0.8e1;
  t4628 = t162 * t1933 * t4620;
  t4629 = 0.3e1 / 0.32e2 * t4628;
  t4630 = t938 * t171;
  t4640 = t1326 * t36;
  t4646 = t930 * t2660;
  t4652 = -t4615 - t1264 * t931 / 0.16e2 - t4619 + t4623 - t4626 + t4629 + 0.3e1 / 0.16e2 * t162 * t913 * t4630 - 0.11e2 / 0.32e2 * t162 * t4418 * t4576 + 0.3e1 / 0.8e1 * t177 * t943 * t2039 - 0.11e2 / 0.16e2 * t177 * t4640 * t4184 + 0.11e2 / 0.16e2 * t177 * t4598 - 0.3e1 / 0.8e1 * t177 * t4646 - t177 * t943 * t2643 / 0.8e1;
  t4662 = t177 * t2412 * t2781;
  t4663 = 0.3e1 / 0.16e2 * t4662;
  t4666 = t177 * t1322 * t59 * t370;
  t4667 = t4666 / 0.16e2;
  t4689 = 0.3e1 / 0.8e1 * t177 * t4640 * t4406 - 0.7e1 / 0.32e2 * t162 * t4604 + t1264 * t940 / 0.16e2 + t4663 - t4667 - t177 * t1326 * t59 * t1730 / 0.16e2 - 0.3e1 / 0.8e1 * t177 * t947 * t2660 + 0.3e1 / 0.8e1 * t177 * t934 * t4338 - t177 * t934 * t2660 / 0.4e1 - 0.3e1 / 0.16e2 * t162 * t4646 + 0.3e1 / 0.16e2 * t162 * t891 * t4630 + t177 * t956 * t2056 / 0.2e1 + t4434;
  t4691 = t177 * t735 * t1259;
  t4692 = t4691 / 0.16e2;
  t4697 = t769 * t3887;
  t4702 = -t4435 + t4457 - t4458 - t4459 + t4460 - t4461 + t4462 - t4463 + t4692 - t4504 * t294 / 0.32e2 - t1264 * t991 / 0.32e2 - 0.3e1 / 0.32e2 * t162 * t4697 + 0.3e1 / 0.32e2 * t557 * t1344;
  t4708 = t232 * t253;
  t4735 = t557 * t1319;
  t4736 = t4735 / 0.32e2;
  t4738 = t162 * t786 * t731;
  t4739 = t4738 / 0.32e2;
  t4740 = 0.3e1 / 0.32e2 * t162 * t774 * t2531 + t177 * t4708 * t400 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t2493 * t1296 + 0.3e1 / 0.32e2 * t557 * t1330 + 0.3e1 / 0.32e2 * t162 * t769 * t2588 + 0.3e1 / 0.16e2 * t177 * t4708 * t467 - 0.3e1 / 0.16e2 * t177 * t4697 - t177 * t735 * t1292 / 0.8e1 - 0.3e1 / 0.32e2 * t557 * t1336 - t177 * t4708 * t370 / 0.16e2 - t1264 * t994 / 0.32e2 - t4736 - t4739;
  t4743 = t177 * t232 * t258 * t140;
  t4744 = t4743 / 0.16e2;
  t4746 = t177 * t693 * t1255;
  t4747 = t4746 / 0.16e2;
  t4766 = t553 * t1319;
  t4767 = t4766 / 0.64e2;
  t4768 = t497 * t1323;
  t4769 = t4768 / 0.32e2;
  t4770 = -t4744 + t4747 - 0.3e1 / 0.32e2 * t497 * t1350 - 0.3e1 / 0.64e2 * t553 * t1336 + 0.3e1 / 0.64e2 * t553 * t1344 + t497 * t1347 / 0.8e1 + 0.3e1 / 0.64e2 * t553 * t1330 + 0.3e1 / 0.32e2 * t497 * t1333 - 0.3e1 / 0.32e2 * t497 * t1336 - t497 * t1339 / 0.16e2 - t497 * t1327 / 0.32e2 - t4767 - t4769;
  t4772 = t497 * t1311;
  t4773 = t4772 / 0.32e2;
  t4774 = t497 * t1314;
  t4775 = t4774 / 0.32e2;
  t4778 = t4773 + t4775 - t4543 * t294 / 0.64e2 - t4556 - t4557 - t4558 + t4559 + t4560 + t4561 - t4562 - t4563 + t4564 + t1313;
  t4779 = t1316 - t1321 - t1325 - t1274 + t1275 - t1276 + t1277 + t840 - t764 + t789 - t797 - t836 - t262;
  t4783 = my_piecewise3(t3, 0, t4612 + t4652 + t4689 + t4702 + t4740 + t4770 + t4778 + t4779);
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t4783 + 0.2e1 * t1354;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t4787 = t2926 * t59;
  t4788 = t1006 * t145 * t4787;
  t4793 = t1010 * t389;
  t4798 = t1006 * t389 * t4787;
  t4802 = t1010 * t405 * t4787;
  t4811 = t3476 * t1757;
  t4823 = t884 * t204;
  t4830 = 0.11e2 / 0.16e2 * t177 * t4788 + 0.9e1 / 0.16e2 * t162 * t4788 - 0.9e1 / 0.16e2 * t162 * t4793 * t4787 - 0.3e1 / 0.2e1 * t177 * t4798 + 0.9e1 / 0.8e1 * t177 * t4802 + 0.11e2 / 0.16e2 * t177 * t1380 * t113 * t4128 + 0.11e2 / 0.16e2 * t162 * t4802 - 0.15e2 / 0.32e2 * t162 * t4811 * t4787 - 0.25e2 / 0.16e2 * t177 * t1010 * t1757 * t4787 + 0.15e2 / 0.16e2 * t177 * t3476 * t1769 * t4787 + 0.3e1 / 0.16e2 * t162 * t1064 * t4823 + 0.3e1 / 0.8e1 * t177 * t3445 * t4823;
  t4835 = t1002 * t36;
  t4850 = t883 * t4823;
  t4865 = t1714 * t310;
  t4866 = t4865 * t74;
  t4870 = t2006 * t74;
  t4874 = -t177 * t1380 * t59 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t4835 * t2072 + t177 * t3459 * t4823 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t901 * t4823 - t177 * t917 * t3455 / 0.8e1 - 0.7e1 / 0.32e2 * t162 * t4798 - 0.3e1 / 0.16e2 * t162 * t4850 + 0.3e1 / 0.16e2 * t162 * t1077 * t4823 - 0.3e1 / 0.8e1 * t177 * t4850 - t177 * t909 * t4823 / 0.4e1 + 0.3e1 / 0.8e1 * t177 * t1029 * t61 * t4787 - 0.11e2 / 0.32e2 * t162 * t1933 * t4866 + 0.3e1 / 0.8e1 * t177 * t4835 * t4870;
  t4876 = 0.3e1 / 0.8e1 * t4331;
  t4877 = t4335 / 0.8e1;
  t4878 = t4352 / 0.2e1;
  t4879 = 0.3e1 / 0.8e1 * t4355;
  t4880 = 0.3e1 / 0.16e2 * t4363;
  t4881 = 0.3e1 / 0.8e1 * t4384;
  t4882 = 0.3e1 / 0.16e2 * t4388;
  t4883 = t4429 / 0.4e1;
  t4884 = 0.3e1 / 0.16e2 * t4432;
  t4885 = 0.3e1 / 0.16e2 * t4087;
  t4886 = t4091 / 0.16e2;
  t4887 = 0.3e1 / 0.32e2 * t4096;
  t4888 = 0.3e1 / 0.16e2 * t4100;
  t4889 = t4876 - t4877 + t4878 - t4879 - t4880 - t4881 + t4882 - t4883 + t4884 + t4885 - t4886 + t4887 - t4888;
  t4890 = 0.3e1 / 0.32e2 * t4103;
  t4891 = 0.3e1 / 0.32e2 * t4106;
  t4892 = 0.3e1 / 0.16e2 * t4108;
  t4893 = t4112 / 0.4e1;
  t4894 = t4116 / 0.8e1;
  t4910 = t1006 * t2643;
  t4915 = -t4890 + t4891 - t4892 + t4893 - t4894 - 0.3e1 / 0.32e2 * t497 * t1371 - t497 * t1361 / 0.16e2 + 0.3e1 / 0.64e2 * t553 * t1364 + 0.3e1 / 0.32e2 * t497 * t1367 + t177 * t1006 * t2056 / 0.4e1 - t177 * t310 * t171 * t370 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t4910 + t1264 * t1056 / 0.16e2;
  t4945 = -t177 * t1029 * t4163 / 0.8e1 + 0.3e1 / 0.32e2 * t557 * t1364 + 0.3e1 / 0.32e2 * t162 * t1006 * t2039 + 0.3e1 / 0.16e2 * t177 * t1029 * t2039 - t1264 * t1053 / 0.16e2 - t1264 * t1014 / 0.16e2 + t1264 * t1017 / 0.16e2 + t497 * t1390 / 0.8e1 - 0.3e1 / 0.32e2 * t497 * t1394 - 0.3e1 / 0.64e2 * t553 * t1371 + 0.3e1 / 0.64e2 * t553 * t1387 - t497 * t1381 / 0.32e2;
  t4958 = t4465 / 0.8e1;
  t4959 = t4511 / 0.16e2;
  t4960 = t4514 / 0.16e2;
  t4961 = t4519 / 0.8e1;
  t4962 = t4522 / 0.8e1;
  t4963 = t4546 / 0.32e2;
  t4964 = t4550 / 0.16e2;
  t4965 = t4552 / 0.16e2;
  t4966 = -0.3e1 / 0.16e2 * t177 * t1010 * t4229 - 0.3e1 / 0.32e2 * t557 * t1371 - 0.3e1 / 0.32e2 * t162 * t4910 + 0.3e1 / 0.32e2 * t557 * t1387 + 0.3e1 / 0.32e2 * t162 * t1010 * t2056 + t4958 - t4959 - t4960 - t4961 + t4962 - t4963 - t4964 + t4965;
  t4968 = t4554 / 0.16e2;
  t4969 = t4176 / 0.32e2;
  t4970 = t4179 / 0.32e2;
  t4971 = t4188 / 0.64e2;
  t4972 = t4190 / 0.32e2;
  t4973 = t4198 / 0.16e2;
  t4974 = t4209 / 0.16e2;
  t4975 = t4213 / 0.16e2;
  t4976 = t4225 / 0.32e2;
  t4977 = t4227 / 0.32e2;
  t4984 = t4968 - t4969 - t4970 - t4971 + t4972 + t4973 + t4974 - t4975 - t4976 + t4977 - t105 * t1357 / 0.64e2 - t48 * t4307 * t310 * t119 / 0.32e2 - t1378;
  t4985 = t1379 - t1384 + t1397 + t1374 + t1375 - t1376 - t1377 + t840 - t764 + t789 - t797 - t836 - t262;
  t4989 = my_piecewise3(t3, 0, t4830 + t4874 + t4889 + t4915 + t4945 + t4966 + t4984 + t4985);
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t4989 + 0.2e1 * t1399;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  t5029 = t3252 * t1408;
  t5032 = -t1264 * t1072 / 0.16e2 + t1264 * t1078 / 0.16e2 - 0.3e1 / 0.32e2 * t497 * t1430 - 0.3e1 / 0.64e2 * t553 * t1409 + 0.3e1 / 0.64e2 * t553 * t1424 + t497 * t1427 / 0.8e1 - 0.3e1 / 0.32e2 * t497 * t1409 - t497 * t1412 / 0.16e2 + 0.3e1 / 0.64e2 * t553 * t1416 + 0.3e1 / 0.32e2 * t497 * t1419 - t497 * t1405 / 0.32e2 + 0.3e1 / 0.16e2 * t177 * t3684 * t520 - t177 * t1107 * t74 * t370 / 0.16e2 - t177 * t1111 * t74 * t370 / 0.16e2 - t177 * t331 * t171 * t370 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t5029;
  t5047 = t614 * t145 * t1415;
  t5052 = t883 * t4630;
  t5061 = t3291 * t74;
  t5081 = t1264 * t1065 / 0.16e2 - 0.3e1 / 0.16e2 * t177 * t947 * t4414 + 0.3e1 / 0.16e2 * t177 * t3691 * t520 + 0.3e1 / 0.16e2 * t177 * t1068 * t2039 - 0.3e1 / 0.32e2 * t557 * t1409 - 0.3e1 / 0.32e2 * t162 * t5047 - 0.3e1 / 0.32e2 * t162 * t5029 - 0.3e1 / 0.32e2 * t162 * t5052 + 0.3e1 / 0.32e2 * t557 * t1424 + 0.3e1 / 0.32e2 * t162 * t2242 * t389 * t1415 + 0.3e1 / 0.32e2 * t162 * t1077 * t5061 + 0.3e1 / 0.32e2 * t162 * t1077 * t4630 + t177 * t3716 * t528 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t5047 - 0.3e1 / 0.16e2 * t177 * t5052 - t177 * t3233 * t1408 / 0.8e1 - t177 * t934 * t4823 / 0.8e1;
  t5110 = -t177 * t934 * t4414 / 0.8e1 + 0.3e1 / 0.32e2 * t557 * t1416 + 0.3e1 / 0.32e2 * t162 * t614 * t115 * t1415 + 0.3e1 / 0.32e2 * t162 * t1064 * t5061 + 0.3e1 / 0.32e2 * t162 * t1064 * t4630 + t177 * t3722 * t528 / 0.4e1 + t177 * t1081 * t2056 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t3349 * t1408 - 0.3e1 / 0.16e2 * t177 * t947 * t4823 - t4593 + t4611 - t4615 - t4619 + t4623 - t4626 + t4629 + t4663;
  t5111 = -t4667 + t4332 - t4336 + t4353 - t4356 - t4364 - t4385 + t4389 - t4430 + t4433 + t4885 - t4886 + t4887 - t4888 - t4890 + t4891 - t4892;
  t5114 = t15 * t16;
  t5115 = t17 * t110;
  t5117 = t5114 * t5115 * t83;
  t5126 = t5114 * t17 * t49 * t91;
  t5149 = t5114 * t5115 * t59;
  t5166 = t4893 - t4894 + 0.11e2 / 0.16e2 * t5117 * t1749 * t926 - 0.15e2 / 0.32e2 * t5117 * t1759 * t926 - 0.25e2 / 0.16e2 * t5126 * t4342 * t4787 + 0.15e2 / 0.16e2 * t5126 * t1771 * t905 + 0.11e2 / 0.16e2 * t5126 * t897 * t4128 - 0.3e1 / 0.2e1 * t5126 * t1715 * t905 + 0.9e1 / 0.8e1 * t5126 * t1749 * t905 + 0.9e1 / 0.16e2 * t5117 * t1812 * t926 + 0.3e1 / 0.8e1 * t5126 * t917 * t4406 - 0.7e1 / 0.32e2 * t5149 * t1715 * t1404 - 0.11e2 / 0.16e2 * t5126 * t4285 * t115 * t2966 - t5126 * t905 * t1730 / 0.16e2 + 0.11e2 / 0.16e2 * t5126 * t1812 * t905 - 0.9e1 / 0.16e2 * t5149 * t1816 * t1404;
  t5181 = 0.3e1 / 0.8e1 * t5126 * t1905 * t905 - 0.11e2 / 0.32e2 * t5149 * t1839 * t1404 - t1264 * t1095 / 0.32e2 - t4504 * t328 / 0.32e2 - t4543 * t328 / 0.64e2 - t1264 * t1129 / 0.32e2 + t4692 - t4736 - t4739 - t4744 + t4747 - t4767 - t4769 + t4773 + t4775 + t4466 - t4512;
  t5183 = -t4515 - t4520 + t4523 - t4547 - t4551 + t4553 + t4555 - t4969 - t4970 - t4971 + t4972 + t4973 + t4974 - t4975 - t4976 + t4977 + t1313;
  t5184 = t1316 - t1321 - t1325 - t1378 + t1379 - t1384 + t1397 + t1258 + t1262 - t1269 - t1273 + t840 - t764 + t789 - t797 - t836 - t262;
  t5188 = my_piecewise3(t3, 0, t5032 + t5081 + t5110 + t5111 + t5166 + t5181 + t5183 + t5184);
  tv4rhosigmalapltau0 = 0.2e1 * rho[0] * t5188 + 0.2e1 * t1435;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t5195 = t1180 * t405;
  t5196 = t5195 * t4787;
  t5199 = t3969 * t1757;
  t5203 = t1180 * t1757;
  t5207 = t3969 * t1769;
  t5211 = t1152 * t389;
  t5212 = t5211 * t4787;
  t5220 = t1142 * t61;
  t5224 = t1714 * t346;
  t5225 = t5224 * t74;
  t5229 = t241 * t115;
  t5236 = 0.11e2 / 0.16e2 * t177 * t1457 * t113 * t4128 + 0.11e2 / 0.16e2 * t162 * t5196 - 0.15e2 / 0.32e2 * t162 * t5199 * t4787 - 0.25e2 / 0.16e2 * t177 * t5203 * t4787 + 0.15e2 / 0.16e2 * t177 * t5207 * t4787 - 0.3e1 / 0.2e1 * t177 * t5212 + 0.9e1 / 0.8e1 * t177 * t5196 - t177 * t934 * t5061 / 0.4e1 + 0.3e1 / 0.8e1 * t177 * t5220 * t4787 - 0.11e2 / 0.32e2 * t162 * t1933 * t5225 + 0.3e1 / 0.16e2 * t162 * t5229 * t5061 + 0.3e1 / 0.8e1 * t177 * t3903 * t5061;
  t5241 = t2197 * t5225;
  t5244 = t930 * t5061;
  t5252 = t1174 * t36;
  t5273 = t724 * t389;
  t5277 = -0.11e2 / 0.16e2 * t177 * t1142 * t115 * t4787 + 0.9e1 / 0.16e2 * t162 * t5241 - 0.3e1 / 0.8e1 * t177 * t5244 + 0.11e2 / 0.16e2 * t177 * t5241 - 0.9e1 / 0.16e2 * t162 * t2147 * t5225 + 0.3e1 / 0.8e1 * t177 * t5252 * t4870 - t177 * t1457 * t59 * t1730 / 0.16e2 + t177 * t3190 * t5061 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t947 * t5061 - 0.3e1 / 0.16e2 * t162 * t5244 - t177 * t943 * t3887 / 0.8e1 - 0.7e1 / 0.32e2 * t162 * t5212 + 0.3e1 / 0.16e2 * t162 * t5273 * t5061;
  t5279 = 0.3e1 / 0.16e2 * t4592;
  t5280 = t4610 / 0.2e1;
  t5281 = 0.3e1 / 0.8e1 * t4614;
  t5282 = 0.3e1 / 0.8e1 * t4618;
  t5283 = 0.3e1 / 0.16e2 * t4622;
  t5284 = t4625 / 0.4e1;
  t5285 = 0.3e1 / 0.16e2 * t4628;
  t5286 = 0.3e1 / 0.8e1 * t4662;
  t5287 = t4666 / 0.8e1;
  t5288 = -t5279 + t5280 - t5281 - t5282 + t5283 - t5284 + t5285 + t5286 - t5287 + t4885 - t4886 + t4887 - t4888;
  t5305 = -t4890 + t4891 - t4892 + t4893 - t4894 + 0.3e1 / 0.64e2 * t553 * t1461 - t497 * t1447 / 0.16e2 + 0.3e1 / 0.64e2 * t553 * t1450 + 0.3e1 / 0.32e2 * t497 * t1441 - 0.3e1 / 0.32e2 * t497 * t1444 - t1264 * t1167 / 0.16e2 + t1264 * t1170 / 0.16e2 - t1264 * t1153 / 0.16e2;
  t5323 = t1152 * t2643;
  t5340 = t1264 * t1181 / 0.16e2 + 0.3e1 / 0.32e2 * t557 * t1461 + 0.3e1 / 0.32e2 * t162 * t1180 * t2056 + t177 * t1152 * t2056 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1180 * t4229 - 0.3e1 / 0.32e2 * t557 * t1444 - 0.3e1 / 0.32e2 * t162 * t5323 - t177 * t346 * t171 * t370 / 0.16e2 + 0.3e1 / 0.16e2 * t177 * t1142 * t2039 - 0.3e1 / 0.16e2 * t177 * t5323 - t177 * t1142 * t4163 / 0.8e1 + 0.3e1 / 0.32e2 * t557 * t1450;
  t5352 = t4691 / 0.8e1;
  t5353 = t4735 / 0.16e2;
  t5354 = t4738 / 0.16e2;
  t5355 = t4743 / 0.8e1;
  t5356 = t4746 / 0.8e1;
  t5357 = t4766 / 0.32e2;
  t5358 = t4768 / 0.16e2;
  t5359 = t4772 / 0.16e2;
  t5360 = 0.3e1 / 0.32e2 * t162 * t1152 * t2039 + t497 * t1464 / 0.8e1 - 0.3e1 / 0.32e2 * t497 * t1467 - 0.3e1 / 0.64e2 * t553 * t1444 - t497 * t1458 / 0.32e2 + t5352 - t5353 - t5354 - t5355 + t5356 - t5357 - t5358 + t5359;
  t5362 = t4774 / 0.16e2;
  t5369 = t5362 - t4969 - t4970 - t4971 + t4972 + t4973 + t4974 - t4975 - t4976 + t4977 - t48 * t4307 * t346 * t119 / 0.32e2 - t105 * t1438 / 0.64e2 + t1453;
  t5370 = t1454 - t1455 - t1456 - t1378 + t1379 - t1384 + t1397 + t840 - t764 + t789 - t797 - t836 - t262;
  t5374 = my_piecewise3(t3, 0, t5236 + t5277 + t5288 + t5305 + t5340 + t5360 + t5369 + t5370);
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t5374 + 0.2e1 * t1473;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t5386 = t1485 * t1755;
  t5390 = t1485 * t387;
  t5401 = t1485 * t113;
  t5402 = t5401 * t4123;
  t5405 = t5390 * t4128;
  t5408 = t1485 * t59;
  t5412 = 0.9e1 / 0.16e2 * t4331 - 0.3e1 / 0.16e2 * t4335 + 0.3e1 / 0.4e1 * t4352 - 0.9e1 / 0.16e2 * t4355 - 0.9e1 / 0.32e2 * t4363 - 0.9e1 / 0.16e2 * t4384 + 0.9e1 / 0.32e2 * t4388 - 0.3e1 / 0.8e1 * t4429 + 0.9e1 / 0.32e2 * t4432 - 0.15e2 / 0.32e2 * t162 * t5386 * t4138 - 0.25e2 / 0.16e2 * t177 * t5390 * t4138 + 0.15e2 / 0.16e2 * t177 * t5386 * t4146 - t1523 * t1014 / 0.16e2 + t1523 * t1017 / 0.16e2 - 0.3e1 / 0.2e1 * t177 * t5402 + 0.9e1 / 0.8e1 * t177 * t5405 + 0.3e1 / 0.8e1 * t177 * t5408 * t1801;
  t5416 = t513 * t204;
  t5420 = t1485 * t36;
  t5424 = t2071 * t1485;
  t5446 = t537 * t204;
  t5455 = t1006 * t3455;
  t5464 = t2006 * t1485;
  t5465 = t163 * t5464;
  t5468 = -t177 * t5408 * t1730 / 0.16e2 - 0.3e1 / 0.8e1 * t177 * t1029 * t5416 + 0.3e1 / 0.8e1 * t177 * t5420 * t4168 - 0.11e2 / 0.32e2 * t162 * t163 * t5424 + 0.9e1 / 0.32e2 * t162 * t1006 * t2287 - t1523 * t1053 / 0.16e2 + t1523 * t1056 / 0.16e2 + 0.9e1 / 0.16e2 * t177 * t1029 * t2287 - 0.11e2 / 0.16e2 * t177 * t5420 * t4184 + 0.11e2 / 0.16e2 * t177 * t5401 * t4128 + 0.11e2 / 0.16e2 * t162 * t5405 - 0.9e1 / 0.16e2 * t177 * t1010 * t5446 - 0.3e1 / 0.16e2 * t177 * t1029 * t3455 - 0.7e1 / 0.32e2 * t162 * t5402 - 0.9e1 / 0.32e2 * t162 * t5455 + 0.9e1 / 0.32e2 * t162 * t1010 * t2339 + 0.3e1 / 0.4e1 * t177 * t1006 * t2339 + 0.9e1 / 0.16e2 * t162 * t5465;
  t5474 = t2062 * t1485;
  t5493 = t84 * t113;
  t5496 = t84 * t36;
  t5499 = t1855 * t83;
  t5502 = t118 * t83;
  t5503 = t116 * t5502;
  t5527 = t4259 * t200 / 0.4e1 + t206 / 0.2e1 + t84 * t59 * t140 / 0.2e1 - t5493 * t184 / 0.2e1 - t5496 * t190 / 0.2e1 - t5499 * t4274 / 0.2e1 + t4277 * t5503 / 0.2e1 + t415 * t204 * t64 / 0.2e1 + t1475 * t4286 / 0.2e1 - t1475 * t4289 / 0.2e1 - t1475 * t4292 / 0.2e1 - t1873 * t83 * t64 / 0.2e1 - t418 * t204 * t64 / 0.2e1 - t1477 * t4286 / 0.2e1 + t1477 * t4289 / 0.2e1 + t1477 * t4292 / 0.2e1;
  t5542 = -0.9e1 / 0.16e2 * t177 * t5455 + 0.11e2 / 0.16e2 * t177 * t5465 - 0.9e1 / 0.16e2 * t162 * t2146 * t5474 + 0.3e1 / 0.16e2 * t4465 - 0.3e1 / 0.32e2 * t4511 - 0.3e1 / 0.32e2 * t4514 - 0.3e1 / 0.16e2 * t4519 + 0.3e1 / 0.16e2 * t4522 - 0.3e1 / 0.64e2 * t4546 - 0.3e1 / 0.32e2 * t4550 + 0.3e1 / 0.32e2 * t4552 + 0.3e1 / 0.32e2 * t4554 - t48 * t5527 * t310 * t119 / 0.32e2 - 0.3e1 / 0.32e2 * t105 * t1516 - t105 * t1504 / 0.32e2 - 0.3e1 / 0.64e2 * t105 * t1507 + 0.3e1 / 0.64e2 * t105 * t1510 + t105 * t1513 / 0.8e1;
  t5553 = t422 * t1485;
  t5563 = -0.3e1 / 0.32e2 * t105 * t1490 - t105 * t1493 / 0.16e2 + 0.3e1 / 0.64e2 * t105 * t1497 - t105 * t1482 / 0.64e2 + 0.3e1 / 0.32e2 * t105 * t1487 + 0.3e1 / 0.32e2 * t48 * t5553 * t459 - 0.3e1 / 0.32e2 * t48 * t5553 * t383 + 0.3e1 / 0.32e2 * t48 * t5553 * t391 + t1500 + t1501 - t1502 - t1503 + t840 - t764 + t789 - t797 - t836 - t262;
  t5566 = my_piecewise3(t3, 0, t5412 + t5468 + t5542 + t5563);
  tv4rholapl30 = 0.2e1 * rho[0] * t5566 + 0.2e1 * t1520;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  t5578 = t883 * t3738;
  t5587 = t4865 * t59;
  t5594 = t3181 * t310;
  t5607 = t1523 * t1065 / 0.16e2 - t177 * t1526 * t59 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t2412 * t3525 - 0.3e1 / 0.16e2 * t162 * t5578 + 0.3e1 / 0.16e2 * t162 * t1077 * t3738 + t177 * t1081 * t2339 / 0.2e1 + 0.3e1 / 0.8e1 * t177 * t934 * t5587 - t177 * t934 * t3441 / 0.4e1 - 0.11e2 / 0.32e2 * t162 * t1933 * t5594 + 0.3e1 / 0.16e2 * t162 * t1064 * t3738 + 0.3e1 / 0.8e1 * t177 * t1068 * t2287 - t177 * t1068 * t3455 / 0.8e1;
  t5608 = t1526 * t36;
  t5612 = t163 * t389;
  t5613 = t5612 * t5594;
  t5619 = t1526 * t387;
  t5635 = t1526 * t113;
  t5639 = t930 * t5587;
  t5647 = 0.3e1 / 0.8e1 * t177 * t5608 * t4406 - 0.7e1 / 0.32e2 * t162 * t5613 - 0.15e2 / 0.32e2 * t162 * t4811 * t4576 - 0.25e2 / 0.16e2 * t177 * t5619 * t4138 + 0.15e2 / 0.16e2 * t177 * t3177 * t5587 - t1523 * t1072 / 0.16e2 + t1523 * t1078 / 0.16e2 - 0.3e1 / 0.8e1 * t177 * t5578 - 0.3e1 / 0.8e1 * t177 * t947 * t3441 + 0.11e2 / 0.16e2 * t177 * t5635 * t4128 + 0.11e2 / 0.16e2 * t177 * t5639 + 0.9e1 / 0.16e2 * t162 * t5639 - 0.9e1 / 0.16e2 * t162 * t4793 * t4576;
  t5651 = t947 * t5587;
  t5656 = -0.3e1 / 0.2e1 * t177 * t5613 + 0.9e1 / 0.8e1 * t177 * t5651 + 0.11e2 / 0.16e2 * t162 * t5651 - t4593 + t4611 - t4615 - t4619 + t4623 - t4626 + t4629 + t4663 - t4667 + t4876;
  t5657 = t232 * t310;
  t5671 = -t4877 + t4878 - t4879 - t4880 - t4881 + t4882 - t4883 + t4884 - t177 * t5657 * t370 / 0.16e2 - t15 * t18 * t5527 * t328 / 0.32e2 - t1523 * t1129 / 0.32e2 - t1523 * t1095 / 0.32e2 - 0.3e1 / 0.64e2 * t553 * t1541;
  t5705 = 0.3e1 / 0.64e2 * t553 * t1546 + t497 * t1549 / 0.8e1 - t497 * t1531 / 0.16e2 + 0.3e1 / 0.64e2 * t553 * t1534 + 0.3e1 / 0.32e2 * t497 * t1537 - 0.3e1 / 0.32e2 * t497 * t1541 - t497 * t1527 / 0.32e2 - t15 * t45 * t1480 * t328 / 0.64e2 - 0.3e1 / 0.32e2 * t497 * t1553 + 0.3e1 / 0.32e2 * t557 * t1546 + 0.3e1 / 0.32e2 * t162 * t1010 * t2531 + t177 * t5657 * t400 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t2493 * t1552;
  t5717 = t693 * t1540;
  t5724 = -t177 * t735 * t1530 / 0.8e1 + 0.3e1 / 0.32e2 * t557 * t1534 + 0.3e1 / 0.32e2 * t162 * t1006 * t2588 + 0.3e1 / 0.16e2 * t177 * t5657 * t467 - 0.3e1 / 0.16e2 * t177 * t5717 - 0.3e1 / 0.32e2 * t557 * t1541 - 0.3e1 / 0.32e2 * t162 * t5717 + t4692 - t4736 - t4739 - t4744 + t4747 - t4767;
  t5726 = -t4769 + t4773 + t4775 + t4958 - t4959 - t4960 - t4961 + t4962 - t4963 - t4964 + t4965 + t4968 + t1313;
  t5727 = t1316 - t1321 - t1325 + t1374 + t1375 - t1376 - t1377 + t840 - t764 + t789 - t797 - t836 - t262;
  t5731 = my_piecewise3(t3, 0, t5607 + t5647 + t5656 + t5671 + t5705 + t5724 + t5726 + t5727);
  tv4rholapl2tau0 = 0.2e1 * rho[0] * t5731 + 0.2e1 * t1557;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  t5737 = t930 * t3680;
  t5740 = t1152 * t145;
  t5741 = t5740 * t4371;
  t5744 = t5224 * t83;
  t5760 = t5612 * t5744;
  t5765 = 0.3e1 / 0.8e1 * t177 * t3903 * t3680 - 0.3e1 / 0.8e1 * t177 * t5737 + 0.11e2 / 0.16e2 * t177 * t5741 - 0.9e1 / 0.16e2 * t162 * t2147 * t5744 + 0.3e1 / 0.16e2 * t162 * t5273 * t3680 + t177 * t3190 * t3680 / 0.2e1 - 0.3e1 / 0.8e1 * t177 * t947 * t3680 - t177 * t1068 * t3887 / 0.8e1 - 0.7e1 / 0.32e2 * t162 * t5760 - 0.3e1 / 0.16e2 * t162 * t5737 - t5279 + t5280;
  t5766 = -t5281 - t5282 + t5283 - t5284 + t5285 + t5286 - t5287 + t4332 - t4336 + t4353 - t4356 - t4364 - t4385;
  t5788 = t4389 - t4430 + t4433 + 0.3e1 / 0.64e2 * t553 * t1583 + t497 * t1586 / 0.8e1 - 0.3e1 / 0.32e2 * t497 * t1590 - t497 * t1578 / 0.32e2 - 0.3e1 / 0.64e2 * t553 * t1560 + 0.3e1 / 0.32e2 * t497 * t1574 - t497 * t1564 / 0.16e2 + 0.3e1 / 0.64e2 * t553 * t1571 - 0.3e1 / 0.32e2 * t497 * t1560 - t1523 * t1153 / 0.16e2;
  t5797 = t1152 * t3455;
  t5823 = t1523 * t1181 / 0.16e2 - t177 * t346 * t204 * t370 / 0.16e2 - 0.3e1 / 0.32e2 * t557 * t1560 - 0.3e1 / 0.32e2 * t162 * t5797 + 0.3e1 / 0.32e2 * t557 * t1583 + 0.3e1 / 0.32e2 * t162 * t1180 * t2339 + t177 * t1152 * t2339 / 0.4e1 - 0.3e1 / 0.16e2 * t177 * t1180 * t5446 - t1523 * t1167 / 0.16e2 + t1523 * t1170 / 0.16e2 + 0.3e1 / 0.32e2 * t557 * t1571 + 0.3e1 / 0.32e2 * t162 * t1152 * t2287 + 0.3e1 / 0.16e2 * t177 * t1142 * t2287;
  t5831 = -0.3e1 / 0.16e2 * t177 * t5797 - t177 * t1142 * t5416 / 0.8e1 + t5352 - t5353 - t5354 - t5355 + t5356 - t5357 - t5358 + t5359 + t5362 + t4466;
  t5838 = -t4512 - t4515 - t4520 + t4523 - t4547 - t4551 + t4553 + t4555 - t105 * t1568 / 0.64e2 - t48 * t5527 * t346 * t119 / 0.32e2 + t1453 + t1454 - t1455;
  t5847 = -t1456 + t1258 + t1262 - t1269 - t1273 + t840 - t764 + t789 - t797 - t836 - t262 - t177 * t1577 * t59 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t5252 * t2312;
  t5848 = t2006 * t83;
  t5864 = t5195 * t4371;
  t5878 = t1577 * t113;
  t5886 = 0.3e1 / 0.8e1 * t177 * t5252 * t5848 - t177 * t934 * t3680 / 0.4e1 + 0.3e1 / 0.8e1 * t177 * t5220 * t4371 - 0.11e2 / 0.32e2 * t162 * t1933 * t5744 + 0.3e1 / 0.16e2 * t162 * t5229 * t3680 + 0.11e2 / 0.16e2 * t162 * t5864 - 0.15e2 / 0.32e2 * t162 * t5199 * t4371 - 0.25e2 / 0.16e2 * t177 * t5203 * t4371 + 0.15e2 / 0.16e2 * t177 * t5207 * t4371 + 0.9e1 / 0.16e2 * t162 * t5741 + 0.11e2 / 0.16e2 * t177 * t5878 * t4128 - 0.3e1 / 0.2e1 * t177 * t5760 + 0.9e1 / 0.8e1 * t177 * t5864;
  t5890 = my_piecewise3(t3, 0, t5765 + t5766 + t5788 + t5823 + t5831 + t5838 + t5847 + t5886);
  tv4rholapltau20 = 0.2e1 * rho[0] * t5890 + 0.2e1 * t1594;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t5902 = t1596 * t59;
  t5915 = t1152 * t3887;
  t5918 = t1596 * t387;
  t5922 = t1596 * t1755;
  t5926 = t1596 * t113;
  t5927 = t5926 * t4406;
  t5930 = -0.9e1 / 0.32e2 * t4592 + 0.3e1 / 0.4e1 * t4610 - 0.9e1 / 0.16e2 * t4614 - 0.9e1 / 0.16e2 * t4618 + 0.9e1 / 0.32e2 * t4622 - 0.3e1 / 0.8e1 * t4625 + 0.9e1 / 0.32e2 * t4628 + 0.9e1 / 0.16e2 * t4662 - 0.3e1 / 0.16e2 * t4666 - 0.11e2 / 0.16e2 * t177 * t5902 * t1736 + 0.3e1 / 0.8e1 * t177 * t5902 * t1801 - t177 * t5902 * t1730 / 0.16e2 + 0.9e1 / 0.16e2 * t177 * t1142 * t2588 - 0.9e1 / 0.16e2 * t177 * t5915 - 0.25e2 / 0.16e2 * t177 * t5918 * t4138 + 0.15e2 / 0.16e2 * t177 * t5922 * t4146 + 0.11e2 / 0.16e2 * t177 * t5927;
  t5936 = t5926 * t4123;
  t5939 = t5918 * t4128;
  t5943 = t15 * t18 * t1616;
  t5981 = 0.9e1 / 0.16e2 * t162 * t5927 - 0.9e1 / 0.16e2 * t162 * t5918 * t4123 - 0.3e1 / 0.2e1 * t177 * t5936 + 0.9e1 / 0.8e1 * t177 * t5939 - t5943 * t1153 / 0.16e2 + t5943 * t1181 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t5926 * t4128 + 0.11e2 / 0.16e2 * t162 * t5939 - 0.15e2 / 0.32e2 * t162 * t5922 * t4138 + 0.9e1 / 0.32e2 * t162 * t1180 * t2531 + 0.3e1 / 0.4e1 * t177 * t1152 * t2531 - 0.9e1 / 0.16e2 * t177 * t1180 * t537 * t232 - 0.3e1 / 0.16e2 * t177 * t1142 * t3887 - 0.7e1 / 0.32e2 * t162 * t5936 - 0.9e1 / 0.32e2 * t162 * t5915 - t5943 * t1167 / 0.16e2 + t5943 * t1170 / 0.16e2 - 0.3e1 / 0.8e1 * t177 * t1142 * t513 * t232;
  t5983 = t1596 * t36;
  t5987 = t2071 * t1596;
  t6015 = 0.3e1 / 0.8e1 * t177 * t5983 * t4168 - 0.11e2 / 0.32e2 * t162 * t163 * t5987 + 0.9e1 / 0.32e2 * t162 * t1152 * t2588 + 0.3e1 / 0.16e2 * t4691 - 0.3e1 / 0.32e2 * t4735 - 0.3e1 / 0.32e2 * t4738 - 0.3e1 / 0.16e2 * t4743 + 0.3e1 / 0.16e2 * t4746 - 0.3e1 / 0.64e2 * t4766 - 0.3e1 / 0.32e2 * t4768 + 0.3e1 / 0.32e2 * t4772 + 0.3e1 / 0.32e2 * t4774 + 0.3e1 / 0.64e2 * t105 * t1631 + t105 * t1634 / 0.8e1 - 0.3e1 / 0.32e2 * t105 * t1637 - t105 * t1625 / 0.32e2 - 0.3e1 / 0.64e2 * t105 * t1628 - t105 * t1618 / 0.64e2;
  t6024 = t422 * t1596;
  t6040 = t92 * t113;
  t6043 = t92 * t36;
  t6046 = t1855 * t91;
  t6050 = t116 * t118 * t91;
  t6074 = t4259 * t227 / 0.4e1 + t234 / 0.2e1 + t92 * t59 * t140 / 0.2e1 - t6040 * t184 / 0.2e1 - t6043 * t190 / 0.2e1 - t6046 * t4274 / 0.2e1 + t4277 * t6050 / 0.2e1 + t415 * t232 * t64 / 0.2e1 + t1611 * t4286 / 0.2e1 - t1611 * t4289 / 0.2e1 - t1611 * t4292 / 0.2e1 - t1873 * t91 * t64 / 0.2e1 - t418 * t232 * t64 / 0.2e1 - t1613 * t4286 / 0.2e1 + t1613 * t4289 / 0.2e1 + t1613 * t4292 / 0.2e1;
  t6079 = 0.3e1 / 0.64e2 * t105 * t1602 + 0.3e1 / 0.32e2 * t105 * t1605 - 0.3e1 / 0.32e2 * t105 * t1608 - t105 * t1598 / 0.16e2 - 0.3e1 / 0.32e2 * t48 * t6024 * t383 + 0.3e1 / 0.32e2 * t48 * t6024 * t391 + 0.3e1 / 0.32e2 * t48 * t6024 * t459 - t48 * t6074 * t346 * t119 / 0.32e2 + t1621 + t1622 - t1623 - t1624 + t840 - t764 + t789 - t797 - t836 - t262;
  t6082 = my_piecewise3(t3, 0, t5930 + t5981 + t6015 + t6079);
  tv4rhotau30 = 0.2e1 * rho[0] * t6082 + 0.2e1 * t1641;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t6085 = t258 * t253;
  t6087 = t177 * t6085 * t400;
  t6090 = t177 * t6085 * t370;
  t6092 = t1264 * t1210;
  t6095 = t177 * t804 * t2781;
  t6097 = t769 * t2766;
  t6098 = t177 * t6097;
  t6100 = t513 * t258;
  t6102 = t177 * t804 * t6100;
  t6105 = t162 * t769 * t2781;
  t6108 = t177 * t2718 * t1296;
  t6110 = t162 * t6097;
  t6113 = t162 * t774 * t2728;
  t6115 = t258 * t258;
  t6116 = t49 * t6115;
  t6119 = 0.3e1 / 0.16e2 * t48 * t6116 * t147;
  t6122 = 0.3e1 / 0.16e2 * t48 * t6116 * t140;
  t6124 = t260 / 0.2e1;
  t6136 = t415 * t258 * t64 / 0.2e1;
  t6137 = t415 * t253;
  t6144 = t108 * t1247;
  t6150 = t418 * t258 * t64 / 0.2e1;
  t6151 = t418 * t253;
  t6158 = t255 / 0.4e1 + t6124 + t264 / 0.2e1 - t267 / 0.2e1 - t270 / 0.2e1 - t1855 * t253 * t119 / 0.2e1 + t1859 * t253 * t119 / 0.2e1 + t6136 + t6137 * t140 / 0.2e1 - t6137 * t147 / 0.2e1 - t6137 * t151 / 0.2e1 - t6144 * t74 * t64 / 0.2e1 - t6150 - t6151 * t140 / 0.2e1 + t6151 * t147 / 0.2e1 + t6151 * t151 / 0.2e1;
  t6163 = t253 * t253;
  t6164 = t110 * t6163;
  t6168 = t1247 * t1199;
  t6184 = 0.3e1 / 0.2e1 * t6087 - 0.3e1 / 0.8e1 * t6090 - 0.5e1 / 0.32e2 * t6092 + 0.9e1 / 0.8e1 * t6095 - 0.9e1 / 0.8e1 * t6098 - 0.3e1 / 0.4e1 * t6102 + 0.9e1 / 0.16e2 * t6105 - 0.9e1 / 0.8e1 * t6108 - 0.9e1 / 0.16e2 * t6110 + 0.9e1 / 0.16e2 * t6113 + t6119 - t6122 - t48 * t6158 * t253 * t119 / 0.32e2 - 0.11e2 / 0.32e2 * t48 * t6164 * t1839 + 0.5e1 / 0.32e2 * t48 * t6168 * t459 - 0.7e1 / 0.32e2 * t48 * t6164 * t1715 - 0.5e1 / 0.32e2 * t48 * t6168 * t383 + 0.5e1 / 0.32e2 * t48 * t6168 * t391 + 0.9e1 / 0.16e2 * t48 * t6164 * t1812;
  t6188 = t49 * t6163;
  t6195 = 0.3e1 / 0.32e2 * t48 * t110 * t6115 * t119;
  t6198 = 0.3e1 / 0.16e2 * t48 * t6116 * t151;
  t6236 = -0.9e1 / 0.16e2 * t48 * t6164 * t1816 + 0.3e1 / 0.8e1 * t48 * t6188 * t1905 - t6195 + t6198 - 0.11e2 / 0.16e2 * t48 * t6188 * t1736 + 0.11e2 / 0.16e2 * t48 * t6188 * t1812 + 0.15e2 / 0.16e2 * t48 * t6188 * t1771 - 0.3e1 / 0.2e1 * t48 * t6188 * t1715 + 0.9e1 / 0.8e1 * t48 * t6188 * t1749 + 0.11e2 / 0.16e2 * t48 * t6188 * t1741 + 0.11e2 / 0.16e2 * t48 * t6164 * t1749 - 0.15e2 / 0.32e2 * t48 * t6164 * t1759 - 0.25e2 / 0.16e2 * t48 * t6188 * t1764 + 0.3e1 / 0.8e1 * t48 * t6188 * t1801 - t48 * t6188 * t1730 / 0.16e2 - t1211 / 0.8e1 + t1218 / 0.4e1 - t1222 / 0.4e1 + t1234 / 0.4e1 - t262;
  t6238 = my_piecewise3(t3, 0, t6184 + t6236);
  tv4sigma40 = 0.2e1 * rho[0] * t6238;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t6242 = t83 * t1199;
  t6246 = t213 * t4150;
  t6249 = t2013 * t1199;
  t6268 = t1967 * t1199;
  t6272 = t1951 * t83;
  t6273 = t4127 * t6272;
  t6281 = -0.5e1 / 0.32e2 * t1264 * t1289 - t177 * t6242 * t1730 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t6246 + 0.3e1 / 0.8e1 * t177 * t217 * t6249 + 0.3e1 / 0.8e1 * t177 * t6242 * t1801 - 0.11e2 / 0.32e2 * t162 * t4122 * t2312 - 0.11e2 / 0.16e2 * t177 * t6242 * t1736 + 0.5e1 / 0.32e2 * t1264 * t1282 - 0.25e2 / 0.16e2 * t177 * t636 * t1957 * t1199 + 0.15e2 / 0.16e2 * t177 * t2228 * t6268 + 0.11e2 / 0.16e2 * t162 * t6273 + 0.5e1 / 0.32e2 * t1264 * t1302 + 0.11e2 / 0.16e2 * t177 * t6242 * t1741;
  t6287 = t6242 * t1715;
  t6292 = 0.3e1 / 0.4e1 * t6087;
  t6293 = 0.3e1 / 0.16e2 * t6090;
  t6299 = t1264 * t1267;
  t6300 = t6299 / 0.16e2;
  t6302 = t15 * t18 * t6158;
  t6305 = 0.3e1 / 0.32e2 * t6092;
  t6306 = 0.9e1 / 0.16e2 * t6095;
  t6307 = 0.9e1 / 0.16e2 * t6098;
  t6308 = 0.9e1 / 0.16e2 * t162 * t6246 - 0.9e1 / 0.16e2 * t162 * t4127 * t2305 - 0.3e1 / 0.2e1 * t177 * t6287 + 0.9e1 / 0.8e1 * t177 * t6273 + t6292 - t6293 - 0.15e2 / 0.32e2 * t162 * t4137 * t2291 - 0.7e1 / 0.32e2 * t162 * t6287 - t6300 - t6302 * t276 / 0.32e2 - t6305 + t6306 - t6307;
  t6310 = 0.3e1 / 0.8e1 * t6102;
  t6311 = 0.9e1 / 0.32e2 * t6105;
  t6312 = 0.9e1 / 0.16e2 * t6108;
  t6313 = 0.9e1 / 0.32e2 * t6110;
  t6314 = 0.9e1 / 0.32e2 * t6113;
  t6315 = -t6310 + t6311 - t6312 - t6313 + t6314 + t6119 - t6122 - t6195 + t6198 - t1212 + t1219 - t1223 + t1235;
  t6316 = t4093 * t74;
  t6317 = t883 * t6316;
  t6318 = t177 * t6317;
  t6319 = 0.9e1 / 0.16e2 * t6318;
  t6320 = t162 * t6317;
  t6321 = 0.9e1 / 0.32e2 * t6320;
  t6323 = t177 * t3459 * t6316;
  t6324 = 0.3e1 / 0.4e1 * t6323;
  t6326 = t177 * t901 * t6316;
  t6327 = 0.9e1 / 0.16e2 * t6326;
  t6329 = t177 * t917 * t2781;
  t6330 = 0.9e1 / 0.16e2 * t6329;
  t6333 = t177 * t1270 * t74 * t370;
  t6334 = 0.3e1 / 0.16e2 * t6333;
  t6336 = t162 * t891 * t4386;
  t6337 = 0.9e1 / 0.32e2 * t6336;
  t6339 = t177 * t909 * t6316;
  t6340 = 0.3e1 / 0.8e1 * t6339;
  t6342 = t162 * t913 * t4386;
  t6343 = 0.9e1 / 0.32e2 * t6342;
  t6344 = t1258 + t1262 - t1269 - t1273 - t262 - t6319 - t6321 + t6324 - t6327 + t6330 - t6334 + t6337 - t6340 + t6343;
  t6347 = my_piecewise3(t3, 0, t6281 + t6308 + t6315 + t6344);
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t6347;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t6351 = t91 * t1199;
  t6355 = t4122 * t2500;
  t6380 = t6351 * t1715;
  t6384 = t724 * t1951 * t1199;
  t6387 = 0.5e1 / 0.32e2 * t1264 * t1344 + 0.11e2 / 0.16e2 * t177 * t6351 * t1741 + 0.9e1 / 0.16e2 * t162 * t6355 - 0.9e1 / 0.16e2 * t162 * t4127 * t2504 - t177 * t6351 * t1730 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t6355 + 0.3e1 / 0.8e1 * t177 * t245 * t6249 + 0.3e1 / 0.8e1 * t177 * t6351 * t1801 - 0.11e2 / 0.32e2 * t162 * t4122 * t2457 - 0.11e2 / 0.16e2 * t177 * t6351 * t1736 + 0.5e1 / 0.32e2 * t1264 * t1330 - 0.3e1 / 0.2e1 * t177 * t6380 + 0.9e1 / 0.8e1 * t177 * t6384;
  t6405 = t1264 * t1319;
  t6406 = t6405 / 0.16e2;
  t6407 = 0.11e2 / 0.16e2 * t162 * t6384 - 0.15e2 / 0.32e2 * t162 * t4137 * t2441 - 0.25e2 / 0.16e2 * t177 * t6351 * t1764 + 0.15e2 / 0.16e2 * t177 * t2487 * t6268 - 0.5e1 / 0.32e2 * t1264 * t1336 - 0.7e1 / 0.32e2 * t162 * t6380 - t6302 * t294 / 0.32e2 - t6406 + t6292 - t6293 - t6305 + t6306 - t6307;
  t6409 = -t6310 + t6311 - t6312 - t6313 + t6314 + t6119 - t6122 - t6195 + t6198 + t1313 + t1316 - t1321 - t1325;
  t6410 = t4361 * t1415;
  t6411 = t162 * t6410;
  t6412 = 0.9e1 / 0.32e2 * t6411;
  t6414 = t177 * t943 * t2781;
  t6415 = 0.9e1 / 0.16e2 * t6414;
  t6418 = t177 * t1322 * t74 * t370;
  t6419 = 0.3e1 / 0.16e2 * t6418;
  t6420 = t177 * t6410;
  t6421 = 0.9e1 / 0.16e2 * t6420;
  t6423 = t162 * t891 * t4620;
  t6424 = 0.9e1 / 0.32e2 * t6423;
  t6426 = t177 * t934 * t6316;
  t6427 = 0.3e1 / 0.8e1 * t6426;
  t6429 = t162 * t913 * t4620;
  t6430 = 0.9e1 / 0.32e2 * t6429;
  t6432 = t177 * t3190 * t6316;
  t6433 = 0.3e1 / 0.4e1 * t6432;
  t6435 = t177 * t947 * t6316;
  t6436 = 0.9e1 / 0.16e2 * t6435;
  t6437 = -t1212 + t1219 - t1223 + t1235 - t262 - t6412 + t6415 - t6419 - t6421 + t6424 - t6427 + t6430 + t6433 - t6436;
  t6440 = my_piecewise3(t3, 0, t6387 + t6407 + t6409 + t6437);
  tv4sigma3tau0 = 0.2e1 * rho[0] * t6440;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t6446 = t310 * t253;
  t6456 = t1951 * t253;
  t6457 = t1010 * t6456;
  t6466 = t1967 * t253;
  t6471 = t1006 * t2006 * t253;
  t6476 = t2062 * t253;
  t6480 = t1006 * t6476;
  t6488 = -0.5e1 / 0.32e2 * t1264 * t1371 + 0.5e1 / 0.32e2 * t1264 * t1387 - 0.11e2 / 0.16e2 * t177 * t6446 * t1736 + 0.3e1 / 0.8e1 * t177 * t6446 * t1801 - t177 * t6446 * t1730 / 0.16e2 + 0.11e2 / 0.16e2 * t162 * t6457 - 0.15e2 / 0.32e2 * t162 * t3476 * t2753 - 0.25e2 / 0.16e2 * t177 * t1010 * t2753 + 0.15e2 / 0.16e2 * t177 * t3476 * t6466 + 0.11e2 / 0.16e2 * t177 * t6471 + 0.9e1 / 0.16e2 * t162 * t6471 - 0.9e1 / 0.16e2 * t162 * t1010 * t6476 - 0.3e1 / 0.2e1 * t177 * t6480 + 0.9e1 / 0.8e1 * t177 * t6457 + 0.11e2 / 0.16e2 * t177 * t6446 * t1741;
  t6489 = t1006 * t2766;
  t6490 = t162 * t6489;
  t6491 = 0.3e1 / 0.32e2 * t6490;
  t6493 = t162 * t1010 * t2728;
  t6494 = 0.3e1 / 0.32e2 * t6493;
  t6495 = t2013 * t253;
  t6499 = t177 * t6489;
  t6500 = 0.3e1 / 0.16e2 * t6499;
  t6504 = t177 * t1029 * t6100;
  t6505 = t6504 / 0.8e1;
  t6510 = t162 * t1006 * t2781;
  t6511 = 0.3e1 / 0.32e2 * t6510;
  t6513 = t177 * t1029 * t2781;
  t6514 = 0.3e1 / 0.16e2 * t6513;
  t6516 = t177 * t1006 * t2728;
  t6517 = t6516 / 0.4e1;
  t6518 = t537 * t258;
  t6520 = t177 * t1010 * t6518;
  t6521 = 0.3e1 / 0.16e2 * t6520;
  t6524 = t177 * t310 * t258 * t370;
  t6525 = t6524 / 0.16e2;
  t6528 = t6087 / 0.4e1;
  t6529 = t6090 / 0.16e2;
  t6531 = -t6491 + t6494 + 0.3e1 / 0.8e1 * t177 * t1029 * t6495 - t6500 + 0.5e1 / 0.32e2 * t1264 * t1364 - t6505 - 0.11e2 / 0.32e2 * t162 * t769 * t3525 + t6511 + t6514 + t6517 - t6521 - t6525 - 0.7e1 / 0.32e2 * t162 * t6480 + t6528 - t6529 - t6299 / 0.8e1;
  t6533 = t6092 / 0.32e2;
  t6534 = 0.3e1 / 0.16e2 * t6095;
  t6535 = 0.3e1 / 0.16e2 * t6098;
  t6536 = t6102 / 0.8e1;
  t6537 = 0.3e1 / 0.32e2 * t6105;
  t6538 = 0.3e1 / 0.16e2 * t6108;
  t6539 = 0.3e1 / 0.32e2 * t6110;
  t6540 = 0.3e1 / 0.32e2 * t6113;
  t6545 = -t6533 + t6534 - t6535 - t6536 + t6537 - t6538 - t6539 + t6540 - t48 * t6158 * t310 * t119 / 0.32e2 + t6119 - t6122 - t6195 + t6198 - t1274 + t1275;
  t6554 = -t1276 + t1277 + t1374 + t1375 - t1376 - t1377 - t262 - 0.3e1 / 0.4e1 * t6318 - 0.3e1 / 0.8e1 * t6320 + t6323 - 0.3e1 / 0.4e1 * t6326 + 0.3e1 / 0.4e1 * t6329 - t6333 / 0.4e1 + 0.3e1 / 0.8e1 * t6336 - t6339 / 0.2e1 + 0.3e1 / 0.8e1 * t6342;
  t6557 = my_piecewise3(t3, 0, t6488 + t6531 + t6545 + t6554);
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t6557;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  t6561 = -t6302 * t328 / 0.32e2 - t6406 + t6528 - t6529 - t6300 - t6533 + t6534 - t6535 - t6536 + t6537 - t6538 - t6539 + t6540 + t6119 - t6122 - t6195 + t6198 + t1313 + t1316;
  t6562 = t3181 * t253;
  t6572 = t331 * t253;
  t6576 = t3190 * t4442;
  t6579 = t947 * t4442;
  t6582 = t883 * t6562;
  t6587 = -t1321 - t1325 - t1274 + t1275 - t1276 + t1277 + t1258 + t1262 - t1269 - t1273 - t262 - 0.15e2 / 0.32e2 * t162 * t3651 * t6562 - 0.25e2 / 0.16e2 * t177 * t3655 * t2753 + 0.15e2 / 0.16e2 * t177 * t3177 * t4442 + 0.11e2 / 0.16e2 * t177 * t6572 * t1741 - 0.3e1 / 0.2e1 * t177 * t6576 + 0.9e1 / 0.8e1 * t177 * t6579 + 0.9e1 / 0.16e2 * t162 * t6582 + 0.11e2 / 0.16e2 * t162 * t6579;
  t6608 = t177 * t947 * t4386;
  t6610 = t883 * t4620;
  t6611 = t162 * t6610;
  t6614 = t162 * t1077 * t4620;
  t6617 = t177 * t1081 * t2728;
  t6620 = t177 * t934 * t4386;
  t6626 = t162 * t1064 * t4620;
  t6629 = t177 * t1068 * t2781;
  t6633 = t177 * t6610;
  t6640 = t177 * t331 * t258 * t370;
  t6642 = -t177 * t6572 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t4640 * t2312 - 0.5e1 / 0.32e2 * t1264 * t1409 + 0.5e1 / 0.32e2 * t1264 * t1424 + 0.3e1 / 0.8e1 * t177 * t934 * t4442 + 0.3e1 / 0.8e1 * t177 * t6572 * t1801 + 0.11e2 / 0.16e2 * t177 * t6582 - 0.3e1 / 0.16e2 * t6608 - 0.3e1 / 0.32e2 * t6611 + 0.3e1 / 0.32e2 * t6614 + t6617 / 0.4e1 - t6620 / 0.8e1 - 0.11e2 / 0.32e2 * t162 * t4418 * t3785 + 0.3e1 / 0.32e2 * t6626 + 0.3e1 / 0.16e2 * t6629 - 0.7e1 / 0.32e2 * t162 * t6576 - 0.3e1 / 0.16e2 * t6633 - 0.9e1 / 0.16e2 * t162 * t4375 * t3785 - t6640 / 0.16e2;
  t6645 = 0.3e1 / 0.16e2 * t6411;
  t6646 = 0.3e1 / 0.8e1 * t6414;
  t6647 = t6418 / 0.8e1;
  t6648 = 0.3e1 / 0.8e1 * t6420;
  t6649 = 0.3e1 / 0.16e2 * t6423;
  t6650 = t6426 / 0.4e1;
  t6651 = 0.3e1 / 0.16e2 * t6429;
  t6652 = t6432 / 0.2e1;
  t6653 = 0.3e1 / 0.8e1 * t6435;
  t6654 = 0.3e1 / 0.8e1 * t6318;
  t6655 = 0.3e1 / 0.16e2 * t6320;
  t6656 = t6323 / 0.2e1;
  t6657 = 0.3e1 / 0.8e1 * t6326;
  t6658 = 0.3e1 / 0.8e1 * t6329;
  t6659 = t6333 / 0.8e1;
  t6660 = 0.3e1 / 0.16e2 * t6336;
  t6661 = t6339 / 0.4e1;
  t6662 = 0.3e1 / 0.16e2 * t6342;
  t6663 = 0.5e1 / 0.32e2 * t1264 * t1416 - t6645 + t6646 - t6647 - t6648 + t6649 - t6650 + t6651 + t6652 - t6653 - t6654 - t6655 + t6656 - t6657 + t6658 - t6659 + t6660 - t6661 + t6662;
  t6666 = my_piecewise3(t3, 0, t6561 + t6587 + t6642 + t6663);
  tv4sigma2lapltau0 = 0.2e1 * rho[0] * t6666;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t6668 = t346 * t253;
  t6672 = t1180 * t6456;
  t6684 = t1152 * t6476;
  t6701 = t1152 * t2766;
  t6702 = t177 * t6701;
  t6703 = 0.3e1 / 0.16e2 * t6702;
  t6708 = t177 * t1142 * t6100;
  t6709 = t6708 / 0.8e1;
  t6710 = 0.11e2 / 0.16e2 * t177 * t6668 * t1741 + 0.11e2 / 0.16e2 * t162 * t6672 - 0.15e2 / 0.32e2 * t162 * t3969 * t2753 - 0.25e2 / 0.16e2 * t177 * t1180 * t2753 + 0.15e2 / 0.16e2 * t177 * t3969 * t6466 - 0.3e1 / 0.2e1 * t177 * t6684 + 0.9e1 / 0.8e1 * t177 * t6672 - t177 * t6668 * t1730 / 0.16e2 - 0.5e1 / 0.32e2 * t1264 * t1444 + 0.5e1 / 0.32e2 * t1264 * t1461 + 0.3e1 / 0.8e1 * t177 * t6668 * t1801 - 0.7e1 / 0.32e2 * t162 * t6684 - t6703 - 0.9e1 / 0.16e2 * t162 * t774 * t3934 - t6709;
  t6715 = t162 * t1152 * t2781;
  t6716 = 0.3e1 / 0.32e2 * t6715;
  t6720 = t177 * t1142 * t2781;
  t6721 = 0.3e1 / 0.16e2 * t6720;
  t6723 = t769 * t2006 * t346;
  t6735 = t162 * t1180 * t2728;
  t6736 = 0.3e1 / 0.32e2 * t6735;
  t6738 = t177 * t1152 * t2728;
  t6739 = t6738 / 0.4e1;
  t6741 = t177 * t1180 * t6518;
  t6742 = 0.3e1 / 0.16e2 * t6741;
  t6743 = t162 * t6701;
  t6744 = 0.3e1 / 0.32e2 * t6743;
  t6747 = t177 * t346 * t258 * t370;
  t6748 = t6747 / 0.16e2;
  t6750 = -0.11e2 / 0.32e2 * t162 * t769 * t4005 + t6716 + 0.5e1 / 0.32e2 * t1264 * t1450 + t6721 + 0.9e1 / 0.16e2 * t162 * t6723 - 0.11e2 / 0.16e2 * t177 * t1142 * t2798 + 0.11e2 / 0.16e2 * t177 * t6723 + 0.3e1 / 0.8e1 * t177 * t1142 * t6495 + t6736 + t6739 - t6742 - t6744 - t6748 - t6405 / 0.8e1 + t6528 - t6529;
  t6756 = -t6533 + t6534 - t6535 - t6536 + t6537 - t6538 - t6539 + t6540 - t48 * t6158 * t346 * t119 / 0.32e2 + t6119 - t6122 - t6195 + t6198 + t1453 + t1454;
  t6765 = -t1455 - t1456 - t1274 + t1275 - t1276 + t1277 - t262 - 0.3e1 / 0.8e1 * t6411 + 0.3e1 / 0.4e1 * t6414 - t6418 / 0.4e1 - 0.3e1 / 0.4e1 * t6420 + 0.3e1 / 0.8e1 * t6423 - t6426 / 0.2e1 + 0.3e1 / 0.8e1 * t6429 + t6432 - 0.3e1 / 0.4e1 * t6435;
  t6768 = my_piecewise3(t3, 0, t6710 + t6750 + t6756 + t6765);
  tv4sigma2tau20 = 0.2e1 * rho[0] * t6768;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t6770 = t5390 * t1952;
  t6784 = t1967 * t74;
  t6792 = t5401 * t2063;
  t6797 = t5401 * t4870;
  t6803 = t2013 * t74;
  t6810 = 0.9e1 / 0.8e1 * t177 * t6770 + 0.11e2 / 0.16e2 * t177 * t5401 * t1952 + 0.11e2 / 0.16e2 * t162 * t6770 - 0.15e2 / 0.32e2 * t162 * t5386 * t1958 - 0.25e2 / 0.16e2 * t177 * t5390 * t1958 + 0.15e2 / 0.16e2 * t177 * t5386 * t6784 - t1523 * t1371 / 0.16e2 + t1523 * t1387 / 0.16e2 - 0.3e1 / 0.2e1 * t177 * t6792 - 0.7e1 / 0.32e2 * t162 * t6792 + 0.11e2 / 0.16e2 * t177 * t6797 - 0.9e1 / 0.16e2 * t162 * t536 * t5474 + 0.3e1 / 0.8e1 * t177 * t5420 * t6803 - 0.11e2 / 0.32e2 * t162 * t182 * t5424;
  t6811 = t1523 * t1267;
  t6820 = t1485 * t74;
  t6827 = 0.9e1 / 0.32e2 * t6490;
  t6828 = 0.9e1 / 0.32e2 * t6493;
  t6829 = 0.9e1 / 0.16e2 * t6499;
  t6830 = 0.3e1 / 0.8e1 * t6504;
  t6831 = 0.9e1 / 0.32e2 * t6510;
  t6832 = 0.9e1 / 0.16e2 * t6513;
  t6833 = 0.3e1 / 0.4e1 * t6516;
  t6834 = 0.9e1 / 0.16e2 * t6520;
  t6835 = -t6811 / 0.16e2 + t1523 * t1364 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t5420 * t2072 + 0.9e1 / 0.16e2 * t162 * t6797 + 0.3e1 / 0.8e1 * t177 * t6820 * t1801 - t177 * t6820 * t1730 / 0.16e2 - t6827 + t6828 - t6829 - t6830 + t6831 + t6832 + t6833 - t6834;
  t6837 = 0.3e1 / 0.16e2 * t6524;
  t6839 = t1247 * t1485;
  t6850 = t110 * t74 * t113;
  t6862 = t1859 * t74;
  t6865 = t188 * t164;
  t6868 = t146 * t4278;
  t6871 = t62 * t4278;
  t6883 = t6850 * t200 / 0.4e1 + t6124 + t84 * t74 * t140 / 0.2e1 - t5493 * t283 / 0.2e1 - t5496 * t287 / 0.2e1 - t5499 * t4279 / 0.2e1 + t6862 * t5503 / 0.2e1 + t6136 + t1475 * t6865 / 0.2e1 - t1475 * t6868 / 0.2e1 - t1475 * t6871 / 0.2e1 - t6144 * t83 * t64 / 0.2e1 - t6150 - t1477 * t6865 / 0.2e1 + t1477 * t6868 / 0.2e1 + t1477 * t6871 / 0.2e1;
  t6888 = -t6837 - 0.3e1 / 0.32e2 * t6299 + 0.3e1 / 0.32e2 * t48 * t6839 * t459 - 0.3e1 / 0.32e2 * t48 * t6839 * t383 + 0.3e1 / 0.32e2 * t48 * t6839 * t391 - t48 * t6883 * t310 * t119 / 0.32e2 + t6119 - t6122 - t6195 + t6198 - t1378 + t1379 - t1384 + t1397;
  t6889 = t1500 + t1501 - t1502 - t1503 - t262 - t6319 - t6321 + t6324 - t6327 + t6330 - t6334 + t6337 - t6340 + t6343;
  t6892 = my_piecewise3(t3, 0, t6810 + t6835 + t6888 + t6889);
  tv4sigmalapl30 = 0.2e1 * rho[0] * t6892;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  t6904 = t1523 * t1319;
  t6906 = t6811 / 0.32e2;
  t6908 = -0.3e1 / 0.32e2 * t1264 * t1541 + 0.3e1 / 0.32e2 * t1264 * t1546 + 0.3e1 / 0.32e2 * t1264 * t1534 - t15 * t18 * t6883 * t328 / 0.32e2 - t6904 / 0.32e2 - t6906 - t6491 + t6494 - t6500 - t6505 + t6511 + t6514 + t6517 - t6521 - t6525 - t6405 / 0.32e2 - t6300 + t6119 - t6122 - t6195;
  t6932 = t930 * t4866;
  t6940 = t5635 * t2063;
  t6943 = t947 * t4866;
  t6961 = t6198 - 0.15e2 / 0.32e2 * t162 * t4811 * t3225 - t1523 * t1409 / 0.16e2 + t1523 * t1424 / 0.16e2 - t177 * t1526 * t74 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t943 * t3525 - 0.25e2 / 0.16e2 * t177 * t5619 * t1958 + 0.15e2 / 0.16e2 * t177 * t3177 * t4866 + 0.11e2 / 0.16e2 * t177 * t5635 * t1952 + 0.11e2 / 0.16e2 * t177 * t6932 + 0.9e1 / 0.16e2 * t162 * t6932 - 0.9e1 / 0.16e2 * t162 * t4793 * t3225 - 0.3e1 / 0.2e1 * t177 * t6940 + 0.9e1 / 0.8e1 * t177 * t6943 + 0.11e2 / 0.16e2 * t162 * t6943 + 0.3e1 / 0.8e1 * t177 * t5608 * t4870 - 0.7e1 / 0.32e2 * t162 * t6940 + 0.3e1 / 0.8e1 * t177 * t934 * t4866 - 0.11e2 / 0.32e2 * t162 * t913 * t5594 + t1523 * t1416 / 0.16e2;
  t6963 = 0.3e1 / 0.8e1 * t6608;
  t6964 = 0.3e1 / 0.16e2 * t6611;
  t6965 = 0.3e1 / 0.16e2 * t6614;
  t6966 = t6617 / 0.2e1;
  t6967 = t6620 / 0.4e1;
  t6968 = 0.3e1 / 0.16e2 * t6626;
  t6969 = 0.3e1 / 0.8e1 * t6629;
  t6970 = t1313 + t1316 - t1321 - t1325 - t1378 + t1379 - t1384 + t1397 + t1374 + t1375 - t1376 - t1377 - t262 - t6963 - t6964 + t6965 + t6966 - t6967 + t6968 + t6969;
  t6971 = 0.3e1 / 0.8e1 * t6633;
  t6972 = t6640 / 0.8e1;
  t6982 = -t6971 - t6972 - 0.3e1 / 0.32e2 * t6411 + 0.3e1 / 0.16e2 * t6414 - t6418 / 0.16e2 - 0.3e1 / 0.16e2 * t6420 + 0.3e1 / 0.32e2 * t6423 - t6426 / 0.8e1 + 0.3e1 / 0.32e2 * t6429 + t6432 / 0.4e1 - 0.3e1 / 0.16e2 * t6435 - t6654 - t6655 + t6656 - t6657 + t6658 - t6659 + t6660 - t6661 + t6662;
  t6985 = my_piecewise3(t3, 0, t6908 + t6961 + t6970 + t6982);
  tv4sigmalapl2tau0 = 0.2e1 * rho[0] * t6985;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  t6999 = t6904 / 0.16e2;
  t7005 = -t1523 * t1444 / 0.16e2 + t1523 * t1461 / 0.16e2 - 0.3e1 / 0.32e2 * t1264 * t1560 + 0.3e1 / 0.32e2 * t1264 * t1583 + t1523 * t1450 / 0.16e2 + 0.3e1 / 0.32e2 * t1264 * t1571 - t6999 - t6703 - t6709 + t6716 + t6721 + t6736 + t6739 - t6742 - t6744 - t6748 - t6406 - t6299 / 0.32e2 - t48 * t6883 * t346 * t119 / 0.32e2;
  t7006 = t1457 * t36;
  t7016 = t5195 * t2966;
  t7025 = t5211 * t2966;
  t7030 = t5740 * t2966;
  t7053 = t6119 - t6122 - t6195 + t6198 + 0.3e1 / 0.8e1 * t177 * t7006 * t5848 + 0.15e2 / 0.16e2 * t177 * t5207 * t2966 + 0.11e2 / 0.16e2 * t177 * t5878 * t1952 + 0.11e2 / 0.16e2 * t162 * t7016 - 0.15e2 / 0.32e2 * t162 * t5199 * t2966 - 0.25e2 / 0.16e2 * t177 * t5203 * t2966 - 0.3e1 / 0.2e1 * t177 * t7025 + 0.9e1 / 0.8e1 * t177 * t7016 + 0.9e1 / 0.16e2 * t162 * t7030 - t177 * t1577 * t74 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t7006 * t2312 - 0.9e1 / 0.16e2 * t162 * t891 * t5744 + 0.3e1 / 0.8e1 * t177 * t5220 * t2966 - 0.11e2 / 0.32e2 * t162 * t913 * t5744 - 0.7e1 / 0.32e2 * t162 * t7025 + 0.11e2 / 0.16e2 * t177 * t7030;
  t7055 = t1453 + t1454 - t1455 - t1456 - t1378 + t1379 - t1384 + t1397 + t1258 + t1262 - t1269 - t1273 - t262 - t6963 - t6964 + t6965 + t6966 - t6967 + t6968 + t6969;
  t7065 = -t6971 - t6972 - t6645 + t6646 - t6647 - t6648 + t6649 - t6650 + t6651 + t6652 - t6653 - 0.3e1 / 0.16e2 * t6318 - 0.3e1 / 0.32e2 * t6320 + t6323 / 0.4e1 - 0.3e1 / 0.16e2 * t6326 + 0.3e1 / 0.16e2 * t6329 - t6333 / 0.16e2 + 0.3e1 / 0.32e2 * t6336 - t6339 / 0.8e1 + 0.3e1 / 0.32e2 * t6342;
  t7068 = my_piecewise3(t3, 0, t7005 + t7053 + t7055 + t7065);
  tv4sigmalapltau20 = 0.2e1 * rho[0] * t7068;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t7076 = t5926 * t4870;
  t7084 = t5926 * t2063;
  t7087 = t5918 * t1952;
  t7092 = t1596 * t74;
  t7108 = -0.25e2 / 0.16e2 * t177 * t5918 * t1958 + 0.15e2 / 0.16e2 * t177 * t5922 * t6784 + 0.11e2 / 0.16e2 * t177 * t7076 + 0.9e1 / 0.16e2 * t162 * t7076 - 0.9e1 / 0.16e2 * t162 * t5918 * t2063 - 0.3e1 / 0.2e1 * t177 * t7084 + 0.9e1 / 0.8e1 * t177 * t7087 - t5943 * t1444 / 0.16e2 - t177 * t7092 * t1730 / 0.16e2 + t5943 * t1461 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t5926 * t1952 + 0.11e2 / 0.16e2 * t162 * t7087 - 0.15e2 / 0.32e2 * t162 * t5922 * t1958 - 0.7e1 / 0.32e2 * t162 * t7084;
  t7109 = t5943 * t1319;
  t7110 = t7109 / 0.16e2;
  t7125 = 0.9e1 / 0.16e2 * t6702;
  t7126 = 0.3e1 / 0.8e1 * t6708;
  t7127 = 0.9e1 / 0.32e2 * t6715;
  t7128 = 0.9e1 / 0.16e2 * t6720;
  t7129 = 0.9e1 / 0.32e2 * t6735;
  t7130 = 0.3e1 / 0.4e1 * t6738;
  t7131 = 0.9e1 / 0.16e2 * t6741;
  t7132 = 0.9e1 / 0.32e2 * t6743;
  t7133 = -t7110 + t5943 * t1450 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t5983 * t6803 - 0.11e2 / 0.32e2 * t162 * t182 * t5987 - 0.11e2 / 0.16e2 * t177 * t7092 * t1736 + 0.3e1 / 0.8e1 * t177 * t7092 * t1801 - t7125 - t7126 + t7127 + t7128 + t7129 + t7130 - t7131 - t7132;
  t7135 = 0.3e1 / 0.16e2 * t6747;
  t7137 = t1247 * t1596;
  t7172 = t6850 * t227 / 0.4e1 + t6124 + t92 * t74 * t140 / 0.2e1 - t6040 * t283 / 0.2e1 - t6043 * t287 / 0.2e1 - t6046 * t4279 / 0.2e1 + t6862 * t6050 / 0.2e1 + t6136 + t1611 * t6865 / 0.2e1 - t1611 * t6868 / 0.2e1 - t1611 * t6871 / 0.2e1 - t6144 * t91 * t64 / 0.2e1 - t6150 - t1613 * t6865 / 0.2e1 + t1613 * t6868 / 0.2e1 + t1613 * t6871 / 0.2e1;
  t7180 = -t7135 - 0.3e1 / 0.32e2 * t6405 + 0.3e1 / 0.32e2 * t48 * t7137 * t391 + 0.3e1 / 0.32e2 * t48 * t7137 * t459 - t48 * t7172 * t346 * t119 / 0.32e2 - 0.3e1 / 0.32e2 * t48 * t7137 * t383 + t6119 - t6122 - t6195 + t6198 + t1621 + t1622 - t1623 - t1624;
  t7181 = -t1378 + t1379 - t1384 + t1397 - t262 - t6412 + t6415 - t6419 - t6421 + t6424 - t6427 + t6430 + t6433 - t6436;
  t7184 = my_piecewise3(t3, 0, t7108 + t7133 + t7180 + t7181);
  tv4sigmatau30 = 0.2e1 * rho[0] * t7184;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t7196 = t310 * t310;
  t7197 = t49 * t7196;
  t7210 = t110 * t7196;
  t7217 = t1480 * t1485;
  t7227 = -0.5e1 / 0.32e2 * t6811 - 0.9e1 / 0.16e2 * t6490 + 0.9e1 / 0.16e2 * t6493 - 0.9e1 / 0.8e1 * t6499 - 0.3e1 / 0.4e1 * t6504 + 0.9e1 / 0.16e2 * t6510 + 0.9e1 / 0.8e1 * t6513 + 0.3e1 / 0.2e1 * t6516 - 0.9e1 / 0.8e1 * t6520 - 0.3e1 / 0.8e1 * t6524 - 0.25e2 / 0.16e2 * t48 * t7197 * t1764 + 0.15e2 / 0.16e2 * t48 * t7197 * t1771 + 0.9e1 / 0.8e1 * t48 * t7197 * t1749 + 0.11e2 / 0.16e2 * t48 * t7197 * t1741 + 0.11e2 / 0.16e2 * t48 * t7210 * t1749 - 0.15e2 / 0.32e2 * t48 * t7210 * t1759 - 0.5e1 / 0.32e2 * t48 * t7217 * t383 + 0.5e1 / 0.32e2 * t48 * t7217 * t391 - 0.3e1 / 0.2e1 * t48 * t7197 * t1715;
  t7262 = t415 * t310;
  t7269 = t108 * t1480;
  t7273 = t418 * t310;
  t7280 = t312 / 0.4e1 + t6124 + t316 / 0.2e1 - t319 / 0.2e1 - t322 / 0.2e1 - t1855 * t310 * t119 / 0.2e1 + t1859 * t310 * t119 / 0.2e1 + t6136 + t7262 * t140 / 0.2e1 - t7262 * t147 / 0.2e1 - t7262 * t151 / 0.2e1 - t7269 * t83 * t64 / 0.2e1 - t6150 - t7273 * t140 / 0.2e1 + t7273 * t147 / 0.2e1 + t7273 * t151 / 0.2e1;
  t7295 = 0.3e1 / 0.8e1 * t48 * t7197 * t1905 + 0.5e1 / 0.32e2 * t48 * t7217 * t459 - 0.11e2 / 0.16e2 * t48 * t7197 * t1736 + 0.11e2 / 0.16e2 * t48 * t7197 * t1812 - 0.7e1 / 0.32e2 * t48 * t7210 * t1715 + 0.9e1 / 0.16e2 * t48 * t7210 * t1812 - 0.9e1 / 0.16e2 * t48 * t7210 * t1816 - 0.11e2 / 0.32e2 * t48 * t7210 * t1839 - t48 * t7280 * t310 * t119 / 0.32e2 + 0.3e1 / 0.8e1 * t48 * t7197 * t1801 - t48 * t7197 * t1730 / 0.16e2 + t6119 - t6122 - t6195 + t6198 + t1257 / 0.4e1 + t1261 / 0.4e1 - t1268 / 0.8e1 - t1272 / 0.4e1 - t262;
  t7297 = my_piecewise3(t3, 0, t7227 + t7295);
  tv4lapl40 = 0.2e1 * rho[0] * t7297;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  t7303 = t91 * t1485;
  t7310 = t5401 * t2504;
  t7327 = t241 * t5464;
  t7337 = 0.15e2 / 0.16e2 * t177 * t2487 * t1967 * t1485 - t177 * t7303 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t177 * t7303 * t1736 - 0.7e1 / 0.32e2 * t162 * t7310 - 0.11e2 / 0.32e2 * t162 * t5401 * t2457 - t15 * t18 * t7280 * t328 / 0.32e2 - 0.5e1 / 0.32e2 * t1523 * t1541 + 0.5e1 / 0.32e2 * t1523 * t1546 + 0.11e2 / 0.16e2 * t177 * t7303 * t1741 + 0.11e2 / 0.16e2 * t177 * t7327 + 0.9e1 / 0.16e2 * t162 * t7327 - 0.9e1 / 0.16e2 * t162 * t5390 * t2504 - 0.3e1 / 0.2e1 * t177 * t7310;
  t7339 = t724 * t1951 * t1485;
  t7360 = 0.9e1 / 0.8e1 * t177 * t7339 + 0.11e2 / 0.16e2 * t162 * t7339 - 0.15e2 / 0.32e2 * t162 * t5386 * t2441 - 0.25e2 / 0.16e2 * t177 * t7303 * t1764 + 0.3e1 / 0.8e1 * t177 * t7303 * t1801 + 0.3e1 / 0.8e1 * t177 * t245 * t2013 * t1485 + 0.5e1 / 0.32e2 * t1523 * t1534 - t6999 - 0.3e1 / 0.32e2 * t6811 - t6827 + t6828 - t6829 - t6830;
  t7362 = t6831 + t6832 + t6833 - t6834 - t6837 + t6119 - t6122 - t6195 + t6198 + t1313 + t1316 - t1321 - t1325;
  t7363 = 0.9e1 / 0.16e2 * t6608;
  t7364 = 0.9e1 / 0.32e2 * t6611;
  t7365 = 0.9e1 / 0.32e2 * t6614;
  t7366 = 0.3e1 / 0.4e1 * t6617;
  t7367 = 0.3e1 / 0.8e1 * t6620;
  t7368 = 0.9e1 / 0.32e2 * t6626;
  t7369 = 0.9e1 / 0.16e2 * t6629;
  t7370 = 0.9e1 / 0.16e2 * t6633;
  t7371 = 0.3e1 / 0.16e2 * t6640;
  t7372 = t1500 + t1501 - t1502 - t1503 - t262 - t7363 - t7364 + t7365 + t7366 - t7367 + t7368 + t7369 - t7370 - t7371;
  t7375 = my_piecewise3(t3, 0, t7337 + t7360 + t7362 + t7372);
  tv4lapl3tau0 = 0.2e1 * rho[0] * t7375;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  t7378 = t1152 * t2006 * t310;
  t7381 = t1152 * t3518;
  t7384 = t1180 * t3468;
  t7397 = t346 * t310;
  t7420 = 0.9e1 / 0.16e2 * t162 * t7378 - 0.3e1 / 0.2e1 * t177 * t7381 + 0.9e1 / 0.8e1 * t177 * t7384 - 0.7e1 / 0.32e2 * t162 * t7381 - 0.11e2 / 0.32e2 * t162 * t1006 * t4005 + 0.5e1 / 0.32e2 * t1523 * t1571 - 0.9e1 / 0.16e2 * t162 * t1010 * t3934 - 0.11e2 / 0.16e2 * t177 * t7397 * t1736 - 0.5e1 / 0.32e2 * t1523 * t1560 + 0.5e1 / 0.32e2 * t1523 * t1583 + 0.3e1 / 0.8e1 * t177 * t7397 * t1801 - t177 * t7397 * t1730 / 0.16e2 + 0.3e1 / 0.8e1 * t177 * t1142 * t2013 * t310 + 0.11e2 / 0.16e2 * t177 * t7378 + 0.11e2 / 0.16e2 * t177 * t7397 * t1741;
  t7434 = 0.11e2 / 0.16e2 * t162 * t7384 - 0.15e2 / 0.32e2 * t162 * t3969 * t3498 - 0.25e2 / 0.16e2 * t177 * t1180 * t3498 + 0.15e2 / 0.16e2 * t177 * t3969 * t1967 * t310 - t6904 / 0.8e1 - t6906 - t6703 - t6709 + t6716 + t6721 + t6736 + t6739 - t6742 - t6744 - t6748 - t6491;
  t7440 = t6494 - t6500 - t6505 + t6511 + t6514 + t6517 - t6521 - t6525 - t48 * t7280 * t346 * t119 / 0.32e2 + t6119 - t6122 - t6195 + t6198 + t1453 + t1454;
  t7449 = -t1455 - t1456 + t1374 + t1375 - t1376 - t1377 - t262 - 0.3e1 / 0.4e1 * t6608 - 0.3e1 / 0.8e1 * t6611 + 0.3e1 / 0.8e1 * t6614 + t6617 - t6620 / 0.2e1 + 0.3e1 / 0.8e1 * t6626 + 0.3e1 / 0.4e1 * t6629 - 0.3e1 / 0.4e1 * t6633 - t6640 / 0.4e1;
  t7452 = my_piecewise3(t3, 0, t7420 + t7434 + t7440 + t7449);
  tv4lapl2tau20 = 0.2e1 * rho[0] * t7452;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  t7454 = t5918 * t6272;
  t7461 = t5926 * t5848;
  t7469 = t213 * t2062 * t1596;
  t7494 = 0.9e1 / 0.8e1 * t177 * t7454 - t5943 * t1560 / 0.16e2 + t5943 * t1583 / 0.16e2 + 0.11e2 / 0.16e2 * t177 * t7461 + 0.3e1 / 0.8e1 * t177 * t5983 * t2013 * t83 - 0.7e1 / 0.32e2 * t162 * t7469 + t5943 * t1571 / 0.16e2 - 0.11e2 / 0.32e2 * t162 * t213 * t5987 + 0.11e2 / 0.16e2 * t177 * t5926 * t6272 + 0.11e2 / 0.16e2 * t162 * t7454 - 0.15e2 / 0.32e2 * t162 * t5922 * t2291 - 0.25e2 / 0.16e2 * t177 * t5918 * t2291 + 0.15e2 / 0.16e2 * t177 * t5922 * t1967 * t83 + 0.9e1 / 0.16e2 * t162 * t7461;
  t7500 = t1596 * t83;
  t7511 = -0.9e1 / 0.16e2 * t162 * t5918 * t2305 - 0.3e1 / 0.2e1 * t177 * t7469 - 0.11e2 / 0.16e2 * t177 * t7500 * t1736 + 0.3e1 / 0.8e1 * t177 * t7500 * t1801 - t177 * t7500 * t1730 / 0.16e2 - t7110 - 0.3e1 / 0.32e2 * t6904 - t7125 - t7126 + t7127 + t7128 + t7129 + t7130 - t7131;
  t7513 = t1480 * t1596;
  t7536 = t217 * t164;
  t7539 = t146 * t5502;
  t7542 = t62 * t5502;
  t7554 = t110 * t83 * t113 * t227 / 0.4e1 + t6124 + t92 * t83 * t140 / 0.2e1 - t6040 * t335 / 0.2e1 - t6043 * t339 / 0.2e1 - t6046 * t5503 / 0.2e1 + t1859 * t83 * t6050 / 0.2e1 + t6136 + t1611 * t7536 / 0.2e1 - t1611 * t7539 / 0.2e1 - t1611 * t7542 / 0.2e1 - t7269 * t91 * t64 / 0.2e1 - t6150 - t1613 * t7536 / 0.2e1 + t1613 * t7539 / 0.2e1 + t1613 * t7542 / 0.2e1;
  t7562 = -t7132 - t7135 - 0.3e1 / 0.32e2 * t48 * t7513 * t383 + 0.3e1 / 0.32e2 * t48 * t7513 * t391 - t48 * t7554 * t346 * t119 / 0.32e2 + 0.3e1 / 0.32e2 * t48 * t7513 * t459 + t6119 - t6122 - t6195 + t6198 + t1621 + t1622 - t1623 - t1624;
  t7563 = t1258 + t1262 - t1269 - t1273 - t262 - t7363 - t7364 + t7365 + t7366 - t7367 + t7368 + t7369 - t7370 - t7371;
  t7566 = my_piecewise3(t3, 0, t7494 + t7511 + t7562 + t7563);
  tv4lapltau30 = 0.2e1 * rho[0] * t7566;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t7578 = t346 * t346;
  t7579 = t49 * t7578;
  t7583 = t110 * t7578;
  t7590 = t1616 * t1596;
  t7604 = t415 * t346;
  t7615 = t418 * t346;
  t7622 = t348 / 0.4e1 + t6124 + t352 / 0.2e1 - t355 / 0.2e1 - t358 / 0.2e1 - t1855 * t346 * t119 / 0.2e1 + t1859 * t346 * t119 / 0.2e1 + t6136 + t7604 * t140 / 0.2e1 - t7604 * t147 / 0.2e1 - t7604 * t151 / 0.2e1 - t108 * t1616 * t91 * t64 / 0.2e1 - t6150 - t7615 * t140 / 0.2e1 + t7615 * t147 / 0.2e1 + t7615 * t151 / 0.2e1;
  t7639 = -0.5e1 / 0.32e2 * t7109 - 0.9e1 / 0.8e1 * t6702 - 0.3e1 / 0.4e1 * t6708 + 0.9e1 / 0.16e2 * t6715 + 0.9e1 / 0.8e1 * t6720 + 0.9e1 / 0.16e2 * t6735 + 0.3e1 / 0.2e1 * t6738 - 0.9e1 / 0.8e1 * t6741 - 0.9e1 / 0.16e2 * t6743 - 0.3e1 / 0.8e1 * t6747 + 0.11e2 / 0.16e2 * t48 * t7579 * t1812 + 0.9e1 / 0.16e2 * t48 * t7583 * t1812 - 0.7e1 / 0.32e2 * t48 * t7583 * t1715 + 0.5e1 / 0.32e2 * t48 * t7590 * t459 - t48 * t7622 * t346 * t119 / 0.32e2 - 0.11e2 / 0.32e2 * t48 * t7583 * t1839 + 0.3e1 / 0.8e1 * t48 * t7579 * t1801 - t48 * t7579 * t1730 / 0.16e2 - 0.11e2 / 0.16e2 * t48 * t7579 * t1736;
  t7677 = 0.3e1 / 0.8e1 * t48 * t7579 * t1905 + 0.15e2 / 0.16e2 * t48 * t7579 * t1771 - 0.9e1 / 0.16e2 * t48 * t7583 * t1816 - 0.3e1 / 0.2e1 * t48 * t7579 * t1715 + 0.9e1 / 0.8e1 * t48 * t7579 * t1749 - 0.5e1 / 0.32e2 * t48 * t7590 * t383 + 0.5e1 / 0.32e2 * t48 * t7590 * t391 + 0.11e2 / 0.16e2 * t48 * t7579 * t1741 + 0.11e2 / 0.16e2 * t48 * t7583 * t1749 - 0.15e2 / 0.32e2 * t48 * t7583 * t1759 - 0.25e2 / 0.16e2 * t48 * t7579 * t1764 + t6119 - t6122 - t6195 + t6198 + t1312 / 0.4e1 + t1315 / 0.4e1 - t1320 / 0.8e1 - t1324 / 0.4e1 - t262;
  t7679 = my_piecewise3(t3, 0, t7639 + t7677);
  tv4tau40 = 0.2e1 * rho[0] * t7679;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;

  double t227, t228, t231, t232, t233, t236, t240, t241;
  double t244, t246, t251, t252, t254, t255, t256, t258;
  double t260, t261, t263, t264, t265, t266, t267, t268;
  double t269, t270, t278, t283, t285, t288, t289, t290;
  double t291, t294, t295, t296, t297, t298, t301, t302;
  double t306, t307, t308, t311, t314, t318, t319, t322;
  double t324, t326, t328, tv2rho20, t331, t335, t339, t340;
  double t343, t345, t351, t352, t356, t360, t361, t364;
  double t367, t370, t371, t374, tv2rho21, t379, t384, t388;
  double t389, t394, t395, t400, t404, t405, t409, t413;
  double t415, t416, t418, t419, t420, t421, t422, t423;
  double t424, t425, t433, t438, t440, t443, t444, t445;
  double t446, t449, t450, t451, t452, t453, t456, t457;
  double t461, tv2rho22, t467, t468, t469, t470, t471, t472;
  double t473, t476, t478, t480, t483, t484, t485, t486;
  double t489, t490, t491, t492, t495, t496, t497, t498;
  double t502, tv2rhosigma0, tv2rhosigma1, t507, t509, tv2rhosigma2, t514, tv2rhosigma3;
  double tv2rhosigma4, t518, t519, t520, t521, t522, t523, t526;
  double t528, t530, t533, t534, t535, t536, t539, t540;
  double t541, t542, t545, t546, t547, t548, t552, tv2rhosigma5;
  double t557, t558, t559, t563, t565, t568, t569, t572;
  double t573, t576, t577, t581, tv2rholapl0, t586, t588, tv2rholapl1;
  double t593, tv2rholapl2, t597, t598, t602, t604, t607, t608;
  double t611, t612, t615, t616, t620, tv2rholapl3, t625, t626;
  double t627, t631, t633, t636, t637, t640, t641, t644;
  double t645, t649, tv2rhotau0, t654, t656, tv2rhotau1, t661, tv2rhotau2;
  double t665, t666, t670, t672, t675, t676, t679, t680;
  double t683, t684, t688, tv2rhotau3, t690, t692, t695, t697;
  double t699, t700, t701, t704, t707, t711, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t712, t714, t717, t719, t721;
  double t722, t723, t726, t729, t733, tv2sigma25, t734, t737;
  double t738, t741, t742, t745, t746, t750, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t751, t754, t755, t758, t759;
  double t762, t763, t767, tv2sigmalapl5, t768, t771, t772, t775;
  double t778, t782, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t783;
  double t786, t787, t790, t793, t797, tv2sigmatau5, t798, t800;
  double t803, t804, t807, t810, t814, tv2lapl20, tv2lapl21, t815;
  double t817, t820, t821, t824, t827, t831, tv2lapl22, t832;
  double t835, t836, t839, t840, t843, t844, t848, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t849, t852, t853, t856, t857, t860;
  double t861, t865, tv2lapltau3, t866, t868, t871, t872, t875;
  double t878, t882, tv2tau20, tv2tau21, t883, t885, t888, t889;
  double t892, t895, t899, tv2tau22;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t227 = 0.1e1 / t20;
  t228 = t87 * t87;
  t231 = t83 * t3;
  t232 = 0.1e1 / t231;
  t233 = t13 * t232;
  t236 = my_piecewise5(t7, 0, t11, 0, -0.2e1 * t84 + 0.2e1 * t233);
  t240 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t228 + 0.3e1 / 0.2e1 * t20 * t236);
  t241 = M_PI * t240;
  t244 = t91 * t96;
  t246 = t91 * t26;
  t251 = t24 / t25 / t3;
  t252 = t251 * t46;
  t254 = t23 * t252 / 0.32e2;
  t255 = t23 * t95;
  t256 = t255 * t117;
  t258 = 0.1e1 / t45;
  t260 = -t100 * t258 + t46;
  t261 = t111 * t111;
  t263 = t43 * t43;
  t264 = t44 * t44;
  t265 = 0.1e1 / t264;
  t266 = t263 * t265;
  t267 = t40 * t40;
  t268 = 0.1e1 / t267;
  t269 = t266 * t268;
  t270 = t260 * t261 * t269;
  t278 = 0.1e1 / t105 / rho[0];
  t283 = my_piecewise3(t39, (0.3e1 / 0.2e1 * lapl[0] * t106 - 0.6e1 * tau[0] * t106 + 0.3e1 / 0.2e1 * sigma[0] * t278) * t37, 0);
  t285 = t100 * t283 * t116;
  t288 = t100 * t261;
  t289 = t43 * t265;
  t290 = t289 * t268;
  t291 = t288 * t290;
  t294 = t264 * t44;
  t295 = 0.1e1 / t294;
  t296 = t263 * t295;
  t297 = t296 * t268;
  t298 = t288 * t297;
  t301 = t114 * t268;
  t302 = t288 * t301;
  t306 = my_piecewise3(t2, 0, -t241 * t47 / 0.8e1 - t244 / 0.8e1 - t246 * t117 / 0.8e1 + t254 - t256 / 0.16e2 - t99 * t270 / 0.32e2 - t99 * t285 / 0.16e2 - t99 * t291 / 0.16e2 + t99 * t298 / 0.16e2 + t99 * t302 / 0.16e2);
  t307 = 0.1e1 / t57;
  t308 = t124 * t124;
  t311 = t52 * t232;
  t314 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t84 + 0.2e1 * t311);
  t318 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t308 + 0.3e1 / 0.2e1 * t57 * t314);
  t319 = M_PI * t318;
  t322 = t128 * t131;
  t324 = t251 * t78;
  t326 = t60 * t324 / 0.32e2;
  t328 = my_piecewise3(t51, 0, -t319 * t79 / 0.8e1 - t322 / 0.8e1 + t326);
  tv2rho20 = 0.2e1 * t121 + 0.2e1 * t135 + t3 * (t306 + t328);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t331 = t227 * t139;
  t335 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t233);
  t339 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t331 * t87 + 0.3e1 / 0.2e1 * t20 * t335);
  t340 = M_PI * t339;
  t343 = t143 * t96;
  t345 = t143 * t26;
  t351 = my_piecewise3(t2, 0, -t340 * t47 / 0.8e1 - t343 / 0.16e2 - t345 * t117 / 0.16e2 - t244 / 0.16e2 + t254 - t256 / 0.32e2);
  t352 = t307 * t149;
  t356 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t311);
  t360 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t352 * t124 + 0.3e1 / 0.2e1 * t57 * t356);
  t361 = M_PI * t360;
  t364 = t153 * t131;
  t367 = t128 * t26;
  t370 = t60 * t95;
  t371 = t370 * t174;
  t374 = my_piecewise3(t51, 0, -t361 * t79 / 0.8e1 - t364 / 0.16e2 - t322 / 0.16e2 + t326 - t367 * t174 / 0.16e2 - t371 / 0.32e2);
  tv2rho21 = t121 + t135 + t147 + t178 + t3 * (t351 + t374);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t379 = t139 * t139;
  t384 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t84 + 0.2e1 * t233);
  t388 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t379 + 0.3e1 / 0.2e1 * t20 * t384);
  t389 = M_PI * t388;
  t394 = my_piecewise3(t2, 0, -t389 * t47 / 0.8e1 - t343 / 0.8e1 + t254);
  t395 = t149 * t149;
  t400 = my_piecewise5(t11, 0, t7, 0, -0.2e1 * t84 + 0.2e1 * t311);
  t404 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t395 + 0.3e1 / 0.2e1 * t57 * t400);
  t405 = M_PI * t404;
  t409 = t153 * t26;
  t413 = 0.1e1 / t77;
  t415 = -t157 * t413 + t78;
  t416 = t168 * t168;
  t418 = t75 * t75;
  t419 = t76 * t76;
  t420 = 0.1e1 / t419;
  t421 = t418 * t420;
  t422 = t73 * t73;
  t423 = 0.1e1 / t422;
  t424 = t421 * t423;
  t425 = t415 * t416 * t424;
  t433 = 0.1e1 / t162 / rho[1];
  t438 = my_piecewise3(t72, (0.3e1 / 0.2e1 * lapl[1] * t163 - 0.6e1 * tau[1] * t163 + 0.3e1 / 0.2e1 * sigma[2] * t433) * t37, 0);
  t440 = t157 * t438 * t173;
  t443 = t157 * t416;
  t444 = t75 * t420;
  t445 = t444 * t423;
  t446 = t443 * t445;
  t449 = t419 * t76;
  t450 = 0.1e1 / t449;
  t451 = t418 * t450;
  t452 = t451 * t423;
  t453 = t443 * t452;
  t456 = t171 * t423;
  t457 = t443 * t456;
  t461 = my_piecewise3(t51, 0, -t405 * t79 / 0.8e1 - t364 / 0.8e1 - t409 * t174 / 0.8e1 + t326 - t371 / 0.16e2 - t156 * t425 / 0.32e2 - t156 * t440 / 0.16e2 - t156 * t446 / 0.16e2 + t156 * t453 / 0.16e2 + t156 * t457 / 0.16e2);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t178 + t3 * (t394 + t461);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t467 = t255 * t185 / 0.32e2;
  t468 = t26 * t260;
  t469 = t23 * t468;
  t470 = t111 * t263;
  t471 = t265 * t268;
  t472 = t471 * t183;
  t473 = t470 * t472;
  t476 = t106 * t37;
  t478 = my_piecewise3(t39, -0.3e1 / 0.8e1 * t476, 0);
  t480 = t100 * t478 * t116;
  t483 = t26 * t100;
  t484 = t23 * t483;
  t485 = t183 * t111;
  t486 = t485 * t290;
  t489 = t183 * t263;
  t490 = t295 * t268;
  t491 = t490 * t111;
  t492 = t489 * t491;
  t495 = t183 * t43;
  t496 = t113 * t268;
  t497 = t496 * t111;
  t498 = t495 * t497;
  t502 = my_piecewise3(t2, 0, -t246 * t185 / 0.16e2 - t467 - t469 * t473 / 0.32e2 - t99 * t480 / 0.16e2 - t484 * t486 / 0.16e2 + t484 * t492 / 0.16e2 + t484 * t498 / 0.16e2);
  tv2rhosigma0 = t3 * t502 + t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t507 = t370 * t193 / 0.32e2;
  t509 = my_piecewise3(t51, 0, -t367 * t193 / 0.16e2 - t507);
  tv2rhosigma2 = t3 * t509 + t196;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t514 = my_piecewise3(t2, 0, -t345 * t185 / 0.16e2 - t467);
  tv2rhosigma3 = t3 * t514 + t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t518 = t26 * t415;
  t519 = t60 * t518;
  t520 = t168 * t418;
  t521 = t420 * t423;
  t522 = t521 * t191;
  t523 = t520 * t522;
  t526 = t163 * t37;
  t528 = my_piecewise3(t72, -0.3e1 / 0.8e1 * t526, 0);
  t530 = t157 * t528 * t173;
  t533 = t26 * t157;
  t534 = t60 * t533;
  t535 = t191 * t168;
  t536 = t535 * t445;
  t539 = t191 * t418;
  t540 = t450 * t423;
  t541 = t540 * t168;
  t542 = t539 * t541;
  t545 = t191 * t75;
  t546 = t170 * t423;
  t547 = t546 * t168;
  t548 = t545 * t547;
  t552 = my_piecewise3(t51, 0, -t409 * t193 / 0.16e2 - t507 - t519 * t523 / 0.32e2 - t156 * t530 / 0.16e2 - t534 * t536 / 0.16e2 + t534 * t542 / 0.16e2 + t534 * t548 / 0.16e2);
  tv2rhosigma5 = t3 * t552 + t196;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t557 = t255 * t201 / 0.32e2;
  t558 = t471 * t199;
  t559 = t470 * t558;
  t563 = my_piecewise3(t39, -t181 / 0.2e1, 0);
  t565 = t100 * t563 * t116;
  t568 = t199 * t111;
  t569 = t568 * t290;
  t572 = t199 * t263;
  t573 = t572 * t491;
  t576 = t199 * t43;
  t577 = t576 * t497;
  t581 = my_piecewise3(t2, 0, -t246 * t201 / 0.16e2 - t557 - t469 * t559 / 0.32e2 - t99 * t565 / 0.16e2 - t484 * t569 / 0.16e2 + t484 * t573 / 0.16e2 + t484 * t577 / 0.16e2);
  tv2rholapl0 = t3 * t581 + t204;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t586 = t370 * t209 / 0.32e2;
  t588 = my_piecewise3(t51, 0, -t367 * t209 / 0.16e2 - t586);
  tv2rholapl1 = t3 * t588 + t212;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t593 = my_piecewise3(t2, 0, -t345 * t201 / 0.16e2 - t557);
  tv2rholapl2 = t3 * t593 + t204;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t597 = t521 * t207;
  t598 = t520 * t597;
  t602 = my_piecewise3(t72, -t189 / 0.2e1, 0);
  t604 = t157 * t602 * t173;
  t607 = t207 * t168;
  t608 = t607 * t445;
  t611 = t207 * t418;
  t612 = t611 * t541;
  t615 = t207 * t75;
  t616 = t615 * t547;
  t620 = my_piecewise3(t51, 0, -t409 * t209 / 0.16e2 - t586 - t519 * t598 / 0.32e2 - t156 * t604 / 0.16e2 - t534 * t608 / 0.16e2 + t534 * t612 / 0.16e2 + t534 * t616 / 0.16e2);
  tv2rholapl3 = t3 * t620 + t212;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t625 = t255 * t215 / 0.32e2;
  t626 = t471 * t213;
  t627 = t470 * t626;
  t631 = my_piecewise3(t39, 0.2e1 * t181, 0);
  t633 = t100 * t631 * t116;
  t636 = t213 * t111;
  t637 = t636 * t290;
  t640 = t213 * t263;
  t641 = t640 * t491;
  t644 = t213 * t43;
  t645 = t644 * t497;
  t649 = my_piecewise3(t2, 0, -t246 * t215 / 0.16e2 - t625 - t469 * t627 / 0.32e2 - t99 * t633 / 0.16e2 - t484 * t637 / 0.16e2 + t484 * t641 / 0.16e2 + t484 * t645 / 0.16e2);
  tv2rhotau0 = t3 * t649 + t218;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t654 = t370 * t221 / 0.32e2;
  t656 = my_piecewise3(t51, 0, -t367 * t221 / 0.16e2 - t654);
  tv2rhotau1 = t3 * t656 + t224;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t661 = my_piecewise3(t2, 0, -t345 * t215 / 0.16e2 - t625);
  tv2rhotau2 = t3 * t661 + t218;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t665 = t521 * t219;
  t666 = t520 * t665;
  t670 = my_piecewise3(t72, 0.2e1 * t189, 0);
  t672 = t157 * t670 * t173;
  t675 = t219 * t168;
  t676 = t675 * t445;
  t679 = t219 * t418;
  t680 = t679 * t541;
  t683 = t219 * t75;
  t684 = t683 * t547;
  t688 = my_piecewise3(t51, 0, -t409 * t221 / 0.16e2 - t654 - t519 * t666 / 0.32e2 - t156 * t672 / 0.16e2 - t534 * t676 / 0.16e2 + t534 * t680 / 0.16e2 + t534 * t684 / 0.16e2);
  tv2rhotau3 = t3 * t688 + t224;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t690 = t183 * t183;
  t692 = t260 * t690 * t269;
  t695 = my_piecewise3(t39, 0, 0);
  t697 = t100 * t695 * t116;
  t699 = t99 * t697 / 0.16e2;
  t700 = t100 * t690;
  t701 = t700 * t290;
  t704 = t700 * t297;
  t707 = t700 * t301;
  t711 = my_piecewise3(t2, 0, -t99 * t692 / 0.32e2 - t699 - t99 * t701 / 0.16e2 + t99 * t704 / 0.16e2 + t99 * t707 / 0.16e2);
  tv2sigma20 = t3 * t711;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t712 = t191 * t191;
  t714 = t415 * t712 * t424;
  t717 = my_piecewise3(t72, 0, 0);
  t719 = t157 * t717 * t173;
  t721 = t156 * t719 / 0.16e2;
  t722 = t157 * t712;
  t723 = t722 * t445;
  t726 = t722 * t452;
  t729 = t722 * t456;
  t733 = my_piecewise3(t51, 0, -t156 * t714 / 0.32e2 - t721 - t156 * t723 / 0.16e2 + t156 * t726 / 0.16e2 + t156 * t729 / 0.16e2);
  tv2sigma25 = t3 * t733;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t734 = t489 * t558;
  t737 = t199 * t183;
  t738 = t737 * t290;
  t741 = t490 * t183;
  t742 = t572 * t741;
  t745 = t496 * t183;
  t746 = t576 * t745;
  t750 = my_piecewise3(t2, 0, -t469 * t734 / 0.32e2 - t699 - t484 * t738 / 0.16e2 + t484 * t742 / 0.16e2 + t484 * t746 / 0.16e2);
  tv2sigmalapl0 = t3 * t750;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t751 = t539 * t597;
  t754 = t207 * t191;
  t755 = t754 * t445;
  t758 = t540 * t191;
  t759 = t611 * t758;
  t762 = t546 * t191;
  t763 = t615 * t762;
  t767 = my_piecewise3(t51, 0, -t519 * t751 / 0.32e2 - t721 - t534 * t755 / 0.16e2 + t534 * t759 / 0.16e2 + t534 * t763 / 0.16e2);
  tv2sigmalapl5 = t3 * t767;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t768 = t489 * t626;
  t771 = t213 * t183;
  t772 = t771 * t290;
  t775 = t640 * t741;
  t778 = t644 * t745;
  t782 = my_piecewise3(t2, 0, -t469 * t768 / 0.32e2 - t699 - t484 * t772 / 0.16e2 + t484 * t775 / 0.16e2 + t484 * t778 / 0.16e2);
  tv2sigmatau0 = t3 * t782;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t783 = t539 * t665;
  t786 = t219 * t191;
  t787 = t786 * t445;
  t790 = t679 * t758;
  t793 = t683 * t762;
  t797 = my_piecewise3(t51, 0, -t519 * t783 / 0.32e2 - t721 - t534 * t787 / 0.16e2 + t534 * t790 / 0.16e2 + t534 * t793 / 0.16e2);
  tv2sigmatau5 = t3 * t797;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t798 = t199 * t199;
  t800 = t260 * t798 * t269;
  t803 = t100 * t798;
  t804 = t803 * t290;
  t807 = t803 * t297;
  t810 = t803 * t301;
  t814 = my_piecewise3(t2, 0, -t99 * t800 / 0.32e2 - t699 - t99 * t804 / 0.16e2 + t99 * t807 / 0.16e2 + t99 * t810 / 0.16e2);
  tv2lapl20 = t3 * t814;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t815 = t207 * t207;
  t817 = t415 * t815 * t424;
  t820 = t157 * t815;
  t821 = t820 * t445;
  t824 = t820 * t452;
  t827 = t820 * t456;
  t831 = my_piecewise3(t51, 0, -t156 * t817 / 0.32e2 - t721 - t156 * t821 / 0.16e2 + t156 * t824 / 0.16e2 + t156 * t827 / 0.16e2);
  tv2lapl22 = t3 * t831;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t832 = t572 * t626;
  t835 = t213 * t199;
  t836 = t835 * t290;
  t839 = t490 * t199;
  t840 = t640 * t839;
  t843 = t496 * t199;
  t844 = t644 * t843;
  t848 = my_piecewise3(t2, 0, -t469 * t832 / 0.32e2 - t699 - t484 * t836 / 0.16e2 + t484 * t840 / 0.16e2 + t484 * t844 / 0.16e2);
  tv2lapltau0 = t3 * t848;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t849 = t611 * t665;
  t852 = t219 * t207;
  t853 = t852 * t445;
  t856 = t540 * t207;
  t857 = t679 * t856;
  t860 = t546 * t207;
  t861 = t683 * t860;
  t865 = my_piecewise3(t51, 0, -t519 * t849 / 0.32e2 - t721 - t534 * t853 / 0.16e2 + t534 * t857 / 0.16e2 + t534 * t861 / 0.16e2);
  tv2lapltau3 = t3 * t865;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t866 = t213 * t213;
  t868 = t260 * t866 * t269;
  t871 = t100 * t866;
  t872 = t871 * t290;
  t875 = t871 * t297;
  t878 = t871 * t301;
  t882 = my_piecewise3(t2, 0, -t99 * t868 / 0.32e2 - t699 - t99 * t872 / 0.16e2 + t99 * t875 / 0.16e2 + t99 * t878 / 0.16e2);
  tv2tau20 = t3 * t882;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t883 = t219 * t219;
  t885 = t415 * t883 * t424;
  t888 = t157 * t883;
  t889 = t888 * t445;
  t892 = t888 * t452;
  t895 = t888 * t456;
  t899 = my_piecewise3(t51, 0, -t156 * t885 / 0.32e2 - t721 - t156 * t889 / 0.16e2 + t156 * t892 / 0.16e2 + t156 * t895 / 0.16e2);
  tv2tau22 = t3 * t899;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;

  double t227, t228, t231, t232, t233, t236, t240, t241;
  double t244, t246, t251, t252, t254, t255, t256, t258;
  double t260, t261, t263, t264, t265, t266, t267, t268;
  double t269, t270, t278, t283, t285, t288, t289, t290;
  double t291, t294, t295, t296, t297, t298, t301, t302;
  double t306, t307, t308, t311, t314, t318, t319, t322;
  double t324, t326, t328, tv2rho20, t331, t335, t339, t340;
  double t343, t345, t351, t352, t356, t360, t361, t364;
  double t367, t370, t371, t374, tv2rho21, t379, t384, t388;
  double t389, t394, t395, t400, t404, t405, t409, t413;
  double t415, t416, t418, t419, t420, t421, t422, t423;
  double t424, t425, t433, t438, t440, t443, t444, t445;
  double t446, t449, t450, t451, t452, t453, t456, t457;
  double t461, tv2rho22, t467, t468, t469, t470, t471, t472;
  double t473, t476, t478, t480, t483, t484, t485, t486;
  double t489, t490, t491, t492, t495, t496, t497, t498;
  double t502, tv2rhosigma0, tv2rhosigma1, t507, t509, tv2rhosigma2, t514, tv2rhosigma3;
  double tv2rhosigma4, t518, t519, t520, t521, t522, t523, t526;
  double t528, t530, t533, t534, t535, t536, t539, t540;
  double t541, t542, t545, t546, t547, t548, t552, tv2rhosigma5;
  double t557, t558, t559, t563, t565, t568, t569, t572;
  double t573, t576, t577, t581, tv2rholapl0, t586, t588, tv2rholapl1;
  double t593, tv2rholapl2, t597, t598, t602, t604, t607, t608;
  double t611, t612, t615, t616, t620, tv2rholapl3, t625, t626;
  double t627, t631, t633, t636, t637, t640, t641, t644;
  double t645, t649, tv2rhotau0, t654, t656, tv2rhotau1, t661, tv2rhotau2;
  double t665, t666, t670, t672, t675, t676, t679, t680;
  double t683, t684, t688, tv2rhotau3, t690, t692, t695, t697;
  double t699, t700, t701, t704, t707, t711, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t712, t714, t717, t719, t721;
  double t722, t723, t726, t729, t733, tv2sigma25, t734, t737;
  double t738, t741, t742, t745, t746, t750, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t751, t754, t755, t758, t759;
  double t762, t763, t767, tv2sigmalapl5, t768, t771, t772, t775;
  double t778, t782, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t783;
  double t786, t787, t790, t793, t797, tv2sigmatau5, t798, t800;
  double t803, t804, t807, t810, t814, tv2lapl20, tv2lapl21, t815;
  double t817, t820, t821, t824, t827, t831, tv2lapl22, t832;
  double t835, t836, t839, t840, t843, t844, t848, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t849, t852, t853, t856, t857, t860;
  double t861, t865, tv2lapltau3, t866, t868, t871, t872, t875;
  double t878, t882, tv2tau20, tv2tau21, t883, t885, t888, t889;
  double t892, t895, t899, tv2tau22;

  double t902, t904, t908, t909, t911, t912, t913, t916;
  double t919, t920, t921, t924, t928, t929, t933, t937;
  double t940, t941, t945, t952, t953, t955, t956, t958;
  double t959, t960, t963, t964, t965, t968, t969, t972;
  double t973, t978, t979, t983, t985, t986, t987, t992;
  double t994, t997, t998, t999, t1000, t1001, t1002, t1005;
  double t1006, t1007, t1011, t1012, t1013, t1014, t1017, t1019;
  double t1021, t1022, t1023, t1026, t1030, t1032, t1040, t1045;
  double t1047, t1050, t1053, t1054, t1056, t1058, t1059, t1060;
  double t1063, t1066, t1069, t1073, t1074, t1077, t1079, t1081;
  double t1083, t1085, tv3rho30, t1088, t1089, t1090, t1093, t1098;
  double t1099, t1101, t1105, t1106, t1113, t1114, t1121, t1124;
  double t1126, t1138, t1139, t1140, t1143, t1148, t1150, t1154;
  double t1155, t1159, t1160, t1164, t1167, t1169, t1170, t1171;
  double t1174, tv3rho31, t1177, t1182, t1186, t1190, t1191, t1194;
  double t1196, t1203, t1204, t1209, t1213, t1217, t1218, t1221;
  double t1224, t1227, t1228, t1234, t1238, t1242, t1246, t1250;
  double t1252, t1253, tv3rho32, t1258, t1265, t1269, t1270, t1276;
  double t1279, t1286, t1290, t1291, t1294, t1295, t1296, t1299;
  double t1303, t1305, t1313, t1318, t1320, t1323, t1332, t1333;
  double t1334, t1336, t1337, t1338, t1343, t1344, t1345, t1348;
  double t1349, t1350, t1351, t1352, t1353, t1356, t1357, t1358;
  double t1362, t1363, t1364, t1365, t1368, t1369, t1370, t1373;
  double t1376, t1377, t1382, t1383, t1386, t1387, t1391, t1395;
  double t1399, t1409, t1411, tv3rho33, t1415, t1417, t1419, t1421;
  double t1428, t1431, t1432, t1433, t1434, t1439, t1440, t1441;
  double t1442, t1445, t1446, t1449, t1450, t1451, t1452, t1455;
  double t1458, t1461, t1462, t1463, t1465, t1466, t1467, t1469;
  double t1470, t1473, t1474, t1477, t1478, t1481, t1482, t1485;
  double t1486, t1489, t1490, t1493, t1494, t1499, t1502, t1505;
  double t1507, t1508, t1511, t1516, t1517, t1518, t1521, t1522;
  double t1523, t1524, t1527, t1530, t1532, tv3rho2sigma0, tv3rho2sigma1, t1537;
  double t1540, t1542, tv3rho2sigma2, t1546, t1548, t1553, t1566, t1567;
  double tv3rho2sigma3, tv3rho2sigma4, t1571, t1574, t1577, t1578, t1579, t1583;
  double t1585, t1588, t1589, t1590, t1594, t1598, t1600, t1601;
  double tv3rho2sigma5, t1608, tv3rho2sigma6, tv3rho2sigma7, t1611, t1612, t1615, t1616;
  double t1619, t1620, t1621, t1622, t1625, t1628, t1629, t1630;
  double t1633, t1634, t1635, t1640, t1641, t1642, t1643, t1646;
  double t1649, t1650, t1651, t1652, t1655, t1656, t1659, t1660;
  double t1663, t1664, t1667, t1670, t1673, t1674, t1677, t1678;
  double t1681, t1682, t1688, t1699, t1701, t1703, t1710, t1711;
  double t1714, t1716, tv3rho2sigma8, t1719, t1720, t1723, t1724, t1727;
  double t1732, t1733, t1736, t1739, t1740, t1745, t1748, t1749;
  double t1752, t1753, t1756, t1757, t1766, t1768, t1770, t1773;
  double t1775, t1776, t1779, t1784, t1787, t1790, t1793, t1795;
  double t1798, t1799, t1805, t1808, t1810, t1813, t1815, tv3rho2lapl0;
  double t1820, t1823, t1825, tv3rho2lapl1, t1829, t1847, t1848, tv3rho2lapl2;
  double t1852, t1857, t1861, t1865, t1869, t1873, t1875, t1876;
  double tv3rho2lapl3, t1883, tv3rho2lapl4, t1886, t1889, t1890, t1893, t1894;
  double t1897, t1898, t1901, t1902, t1912, t1917, t1918, t1921;
  double t1924, t1925, t1928, t1934, t1936, t1939, t1944, t1947;
  double t1948, t1951, t1952, t1955, t1956, t1966, t1968, t1973;
  double t1975, tv3rho2lapl5, t1978, t1981, t1984, t1985, t1988, t1989;
  double t1992, t1993, t1998, t2000, t2004, t2007, t2008, t2011;
  double t2013, t2014, t2019, t2021, t2022, t2025, t2026, t2031;
  double t2032, t2035, t2038, t2041, t2042, t2045, t2046, t2049;
  double t2056, t2059, t2061, t2063, t2070, t2072, t2074, tv3rho2tau0;
  double t2079, t2082, t2084, tv3rho2tau1, t2088, t2106, t2107, tv3rho2tau2;
  double t2111, t2116, t2120, t2124, t2128, t2132, t2134, t2135;
  double tv3rho2tau3, t2142, tv3rho2tau4, t2148, t2153, t2154, t2157, t2158;
  double t2161, t2162, t2165, t2168, t2171, t2174, t2175, t2178;
  double t2181, t2182, t2188, t2189, t2192, t2195, t2196, t2205;
  double t2208, t2209, t2212, t2213, t2223, t2225, t2231, t2233;
  double tv3rho2tau5, t2235, t2238, t2239, t2240, t2243, t2244, t2245;
  double t2246, t2248, t2251, t2252, t2253, t2254, t2255, t2256;
  double t2257, t2260, t2261, t2262, t2265, t2266, t2269, t2272;
  double t2273, t2278, t2279, t2282, t2283, t2286, t2289, t2290;
  double t2293, t2294, t2295, t2296, t2297, t2298, t2299, t2300;
  double t2306, t2310, t2312, t2314, t2315, t2316, t2318, t2319;
  double t2320, t2325, t2327, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2332, t2334, t2335, t2336, t2340, t2344, t2348, t2350;
  double tv3rhosigma25, t2355, t2363, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2365, t2366, t2367, t2370, t2373, t2374, t2375, t2378;
  double t2379, t2382, t2383, t2384, t2387, t2390, t2391, t2392;
  double t2393, t2395, t2400, t2401, t2404, t2405, t2406, t2407;
  double t2408, t2411, t2412, t2415, t2416, t2419, t2420, t2423;
  double t2424, t2425, t2426, t2427, t2428, t2429, t2430, t2440;
  double t2443, t2444, t2445, t2447, tv3rhosigma211, t2449, t2450, t2453;
  double t2454, t2455, t2456, t2459, t2460, t2463, t2464, t2465;
  double t2466, t2469, t2470, t2475, t2476, t2479, t2480, t2483;
  double t2484, t2488, t2490, t2492, t2494, t2497, t2498, t2501;
  double t2502, t2505, t2508, t2511, t2516, t2519, t2526, t2529;
  double t2532, t2534, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2539;
  double t2543, t2547, t2551, t2553, tv3rhosigmalapl5, t2564, tv3rhosigmalapl6, tv3rhosigmalapl7;
  double tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2566, t2567, t2568, t2569, t2572;
  double t2573, t2574, t2575, t2578, t2579, t2582, t2583, t2586;
  double t2587, t2590, t2591, t2594, t2595, t2600, t2601, t2604;
  double t2607, t2612, t2613, t2616, t2617, t2622, t2625, t2626;
  double t2631, t2634, t2641, t2643, tv3rhosigmalapl11, t2645, t2646, t2649;
  double t2650, t2653, t2654, t2657, t2658, t2659, t2662, t2663;
  double t2666, t2667, t2672, t2675, t2676, t2683, t2686, t2691;
  double t2692, t2696, t2697, t2699, t2701, t2703, t2704, t2705;
  double t2710, t2713, t2718, t2721, t2724, t2726, tv3rhosigmatau0, tv3rhosigmatau1;
  double tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t2731, t2735, t2739, t2743, t2745;
  double tv3rhosigmatau5, t2756, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, t2758;
  double t2759, t2762, t2763, t2764, t2767, t2770, t2771, t2774;
  double t2775, t2778, t2779, t2782, t2785, t2786, t2793, t2794;
  double t2797, t2798, t2803, t2806, t2811, t2812, t2815, t2822;
  double t2825, t2828, t2830, tv3rhosigmatau11, t2832, t2833, t2836, t2837;
  double t2840, t2841, t2844, t2847, t2852, t2853, t2856, t2857;
  double t2860, t2863, t2866, t2869, t2872, t2873, t2876, t2878;
  double t2880, t2882, t2884, t2894, t2897, t2899, tv3rholapl20, tv3rholapl21;
  double t2904, t2908, t2912, t2916, t2918, tv3rholapl22, t2929, tv3rholapl23;
  double tv3rholapl24, t2931, t2932, t2935, t2936, t2939, t2940, t2943;
  double t2946, t2949, t2952, t2953, t2956, t2957, t2962, t2963;
  double t2966, t2969, t2972, t2975, t2981, t2988, t2990, tv3rholapl25;
  double t2992, t2993, t2996, t2999, t3003, t3006, t3007, t3012;
  double t3015, t3016, t3019, t3020, t3023, t3026, t3031, t3034;
  double t3041, t3042, t3045, t3050, t3051, t3054, t3055, t3059;
  double t3061, t3063, t3065, t3068, t3070, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2;
  double t3075, t3079, t3083, t3087, t3089, tv3rholapltau3, t3100, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, t3102, t3106, t3109, t3110, t3113, t3114;
  double t3117, t3118, t3123, t3126, t3127, t3130, t3131, t3136;
  double t3139, t3144, t3147, t3152, t3155, t3158, t3163, t3164;
  double t3167, t3168, t3171, t3173, tv3rholapltau7, t3175, t3176, t3179;
  double t3180, t3183, t3184, t3187, t3190, t3193, t3194, t3197;
  double t3200, t3204, t3210, t3213, t3216, t3219, t3229, t3233;
  double t3235, t3237, t3239, t3240, t3242, tv3rhotau20, tv3rhotau21, t3247;
  double t3251, t3255, t3259, t3261, tv3rhotau22, t3272, tv3rhotau23, tv3rhotau24;
  double t3274, t3275, t3278, t3279, t3282, t3283, t3286, t3289;
  double t3293, t3299, t3302, t3303, t3306, t3309, t3312, t3315;
  double t3318, t3320, t3331, t3333, tv3rhotau25, t3335, t3336, t3337;
  double t3340, t3341, t3342, t3343, t3344, t3347, t3348, t3349;
  double t3350, t3353, t3356, t3358, t3361, t3363, t3366, t3367;
  double t3368, t3369, t3370, t3373, t3376, t3379, t3380, t3381;
  double t3382, t3385, t3388, t3389, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t3390, t3391, t3392;
  double t3395, t3398, t3399, t3400, t3401, t3402, t3405, t3406;
  double t3407, t3408, t3411, t3413, t3416, t3418, t3421, t3422;
  double t3423, t3424, t3425, t3428, t3431, t3434, t3435, t3436;
  double t3437, t3440, t3443, t3444, tv3sigma39, t3445, t3446, t3447;
  double t3448, t3449, t3450, t3451, t3452, t3453, t3454, t3455;
  double t3456, t3457, t3458, t3461, t3462, t3463, t3464, t3465;
  double t3466, t3467, t3470, t3471, t3474, t3477, t3478, t3481;
  double t3482, t3485, t3488, t3491, t3494, t3495, t3498, t3499;
  double tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7;
  double tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3500, t3501, t3502, t3503, t3504;
  double t3505, t3506, t3507, t3508, t3509, t3510, t3511, t3512;
  double t3513, t3516, t3517, t3518, t3519, t3520, t3521, t3522;
  double t3525, t3526, t3529, t3532, t3533, t3536, t3537, t3538;
  double t3543, t3546, t3549, t3550, t3553, t3554, tv3sigma2lapl11, t3555;
  double t3556, t3557, t3558, t3559, t3560, t3563, t3564, t3565;
  double t3566, t3567, t3568, t3569, t3570, t3573, t3576, t3579;
  double t3580, t3583, t3588, t3591, t3594, t3597, t3598, tv3sigma2tau0;
  double tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8;
  double tv3sigma2tau9, tv3sigma2tau10, t3599, t3600, t3601, t3602, t3603, t3604;
  double t3605, t3606, t3607, t3608, t3611, t3612, t3613, t3614;
  double t3615, t3618, t3621, t3624, t3627, t3632, t3635, t3638;
  double t3641, t3642, tv3sigma2tau11, t3643, t3646, t3647, t3650, t3651;
  double t3654, t3657, t3658, t3659, t3660, t3661, t3662, t3664;
  double t3667, t3668, t3671, t3674, t3677, t3680, t3681, t3684;
  double t3685, t3686, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25;
  double tv3sigmalapl26, tv3sigmalapl27, t3687, t3688, t3691, t3692, t3695, t3698;
  double t3701, t3702, t3703, t3704, t3705, t3706, t3708, t3711;
  double t3712, t3715, t3718, t3721, t3724, t3725, t3728, t3729;
  double t3730, tv3sigmalapl28, t3733, t3734, t3735, t3738, t3741, t3742;
  double t3745, t3748, t3749, t3754, t3757, t3760, t3763, t3765;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, t3768, t3769, t3772, t3773, t3774;
  double t3777, t3780, t3781, t3784, t3785, t3790, t3793, t3796;
  double t3799, t3801, tv3sigmalapltau11, t3803, t3806, t3809, t3812, t3815;
  double t3818, t3819, t3820, t3821, t3822, t3823, t3828, t3831;
  double t3834, t3837, t3838, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24;
  double tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t3840, t3843, t3846, t3849, t3852;
  double t3855, t3856, t3857, t3858, t3859, t3860, t3865, t3868;
  double t3871, t3874, t3875, tv3sigmatau28, t3876, t3878, t3881, t3883;
  double t3886, t3887, t3888, t3891, t3894, t3895, t3898, t3901;
  double t3902, t3903, t3904, t3905, t3908, t3911, t3914, t3917;
  double t3920, t3921, tv3lapl30, tv3lapl31, tv3lapl32, t3922, t3924, t3927;
  double t3929, t3932, t3933, t3934, t3937, t3938, t3941, t3944;
  double t3947, t3948, t3949, t3950, t3951, t3954, t3957, t3960;
  double t3963, t3966, t3967, tv3lapl33, t3968, t3969, t3972, t3973;
  double t3976, t3979, t3980, t3984, t3987, t3992, t3995, t3998;
  double t3999, t4002, t4003, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double t4004, t4005, t4009, t4012, t4013, t4016, t4019, t4020;
  double t4023, t4028, t4031, t4034, t4035, t4038, t4039, tv3lapl2tau5;
  double t4041, t4044, t4048, t4052, t4055, t4058, t4059, t4064;
  double t4067, t4071, t4074, t4075, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23;
  double tv3lapltau24, t4077, t4080, t4083, t4087, t4090, t4093, t4094;
  double t4099, t4102, t4106, t4109, t4110, tv3lapltau25, t4111, t4113;
  double t4116, t4118, t4121, t4122, t4123, t4126, t4129, t4130;
  double t4133, t4136, t4137, t4138, t4139, t4140, t4143, t4146;
  double t4149, t4152, t4155, t4156, tv3tau30, tv3tau31, tv3tau32, t4157;
  double t4158, t4159, t4162, t4165, t4166, t4169, t4172, t4174;
  double t4177, t4179, t4182, t4183, t4184, t4185, t4186, t4189;
  double t4192, t4195, t4198, t4201, t4202, tv3tau33;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t227 = 0.1e1 / t20;
  t228 = t87 * t87;
  t231 = t83 * t3;
  t232 = 0.1e1 / t231;
  t233 = t13 * t232;
  t236 = my_piecewise5(t7, 0, t11, 0, -0.2e1 * t84 + 0.2e1 * t233);
  t240 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t228 + 0.3e1 / 0.2e1 * t20 * t236);
  t241 = M_PI * t240;
  t244 = t91 * t96;
  t246 = t91 * t26;
  t251 = t24 / t25 / t3;
  t252 = t251 * t46;
  t254 = t23 * t252 / 0.32e2;
  t255 = t23 * t95;
  t256 = t255 * t117;
  t258 = 0.1e1 / t45;
  t260 = -t100 * t258 + t46;
  t261 = t111 * t111;
  t263 = t43 * t43;
  t264 = t44 * t44;
  t265 = 0.1e1 / t264;
  t266 = t263 * t265;
  t267 = t40 * t40;
  t268 = 0.1e1 / t267;
  t269 = t266 * t268;
  t270 = t260 * t261 * t269;
  t278 = 0.1e1 / t105 / rho[0];
  t283 = my_piecewise3(t39, (0.3e1 / 0.2e1 * lapl[0] * t106 - 0.6e1 * tau[0] * t106 + 0.3e1 / 0.2e1 * sigma[0] * t278) * t37, 0);
  t285 = t100 * t283 * t116;
  t288 = t100 * t261;
  t289 = t43 * t265;
  t290 = t289 * t268;
  t291 = t288 * t290;
  t294 = t264 * t44;
  t295 = 0.1e1 / t294;
  t296 = t263 * t295;
  t297 = t296 * t268;
  t298 = t288 * t297;
  t301 = t114 * t268;
  t302 = t288 * t301;
  t306 = my_piecewise3(t2, 0, -t241 * t47 / 0.8e1 - t244 / 0.8e1 - t246 * t117 / 0.8e1 + t254 - t256 / 0.16e2 - t99 * t270 / 0.32e2 - t99 * t285 / 0.16e2 - t99 * t291 / 0.16e2 + t99 * t298 / 0.16e2 + t99 * t302 / 0.16e2);
  t307 = 0.1e1 / t57;
  t308 = t124 * t124;
  t311 = t52 * t232;
  t314 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t84 + 0.2e1 * t311);
  t318 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t308 + 0.3e1 / 0.2e1 * t57 * t314);
  t319 = M_PI * t318;
  t322 = t128 * t131;
  t324 = t251 * t78;
  t326 = t60 * t324 / 0.32e2;
  t328 = my_piecewise3(t51, 0, -t319 * t79 / 0.8e1 - t322 / 0.8e1 + t326);
  tv2rho20 = 0.2e1 * t121 + 0.2e1 * t135 + t3 * (t306 + t328);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t331 = t227 * t139;
  t335 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t233);
  t339 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t331 * t87 + 0.3e1 / 0.2e1 * t20 * t335);
  t340 = M_PI * t339;
  t343 = t143 * t96;
  t345 = t143 * t26;
  t351 = my_piecewise3(t2, 0, -t340 * t47 / 0.8e1 - t343 / 0.16e2 - t345 * t117 / 0.16e2 - t244 / 0.16e2 + t254 - t256 / 0.32e2);
  t352 = t307 * t149;
  t356 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t311);
  t360 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t352 * t124 + 0.3e1 / 0.2e1 * t57 * t356);
  t361 = M_PI * t360;
  t364 = t153 * t131;
  t367 = t128 * t26;
  t370 = t60 * t95;
  t371 = t370 * t174;
  t374 = my_piecewise3(t51, 0, -t361 * t79 / 0.8e1 - t364 / 0.16e2 - t322 / 0.16e2 + t326 - t367 * t174 / 0.16e2 - t371 / 0.32e2);
  tv2rho21 = t121 + t135 + t147 + t178 + t3 * (t351 + t374);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t379 = t139 * t139;
  t384 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t84 + 0.2e1 * t233);
  t388 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t379 + 0.3e1 / 0.2e1 * t20 * t384);
  t389 = M_PI * t388;
  t394 = my_piecewise3(t2, 0, -t389 * t47 / 0.8e1 - t343 / 0.8e1 + t254);
  t395 = t149 * t149;
  t400 = my_piecewise5(t11, 0, t7, 0, -0.2e1 * t84 + 0.2e1 * t311);
  t404 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t395 + 0.3e1 / 0.2e1 * t57 * t400);
  t405 = M_PI * t404;
  t409 = t153 * t26;
  t413 = 0.1e1 / t77;
  t415 = -t157 * t413 + t78;
  t416 = t168 * t168;
  t418 = t75 * t75;
  t419 = t76 * t76;
  t420 = 0.1e1 / t419;
  t421 = t418 * t420;
  t422 = t73 * t73;
  t423 = 0.1e1 / t422;
  t424 = t421 * t423;
  t425 = t415 * t416 * t424;
  t433 = 0.1e1 / t162 / rho[1];
  t438 = my_piecewise3(t72, (0.3e1 / 0.2e1 * lapl[1] * t163 - 0.6e1 * tau[1] * t163 + 0.3e1 / 0.2e1 * sigma[2] * t433) * t37, 0);
  t440 = t157 * t438 * t173;
  t443 = t157 * t416;
  t444 = t75 * t420;
  t445 = t444 * t423;
  t446 = t443 * t445;
  t449 = t419 * t76;
  t450 = 0.1e1 / t449;
  t451 = t418 * t450;
  t452 = t451 * t423;
  t453 = t443 * t452;
  t456 = t171 * t423;
  t457 = t443 * t456;
  t461 = my_piecewise3(t51, 0, -t405 * t79 / 0.8e1 - t364 / 0.8e1 - t409 * t174 / 0.8e1 + t326 - t371 / 0.16e2 - t156 * t425 / 0.32e2 - t156 * t440 / 0.16e2 - t156 * t446 / 0.16e2 + t156 * t453 / 0.16e2 + t156 * t457 / 0.16e2);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t178 + t3 * (t394 + t461);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t467 = t255 * t185 / 0.32e2;
  t468 = t26 * t260;
  t469 = t23 * t468;
  t470 = t111 * t263;
  t471 = t265 * t268;
  t472 = t471 * t183;
  t473 = t470 * t472;
  t476 = t106 * t37;
  t478 = my_piecewise3(t39, -0.3e1 / 0.8e1 * t476, 0);
  t480 = t100 * t478 * t116;
  t483 = t26 * t100;
  t484 = t23 * t483;
  t485 = t183 * t111;
  t486 = t485 * t290;
  t489 = t183 * t263;
  t490 = t295 * t268;
  t491 = t490 * t111;
  t492 = t489 * t491;
  t495 = t183 * t43;
  t496 = t113 * t268;
  t497 = t496 * t111;
  t498 = t495 * t497;
  t502 = my_piecewise3(t2, 0, -t246 * t185 / 0.16e2 - t467 - t469 * t473 / 0.32e2 - t99 * t480 / 0.16e2 - t484 * t486 / 0.16e2 + t484 * t492 / 0.16e2 + t484 * t498 / 0.16e2);
  tv2rhosigma0 = t3 * t502 + t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t507 = t370 * t193 / 0.32e2;
  t509 = my_piecewise3(t51, 0, -t367 * t193 / 0.16e2 - t507);
  tv2rhosigma2 = t3 * t509 + t196;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t514 = my_piecewise3(t2, 0, -t345 * t185 / 0.16e2 - t467);
  tv2rhosigma3 = t3 * t514 + t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t518 = t26 * t415;
  t519 = t60 * t518;
  t520 = t168 * t418;
  t521 = t420 * t423;
  t522 = t521 * t191;
  t523 = t520 * t522;
  t526 = t163 * t37;
  t528 = my_piecewise3(t72, -0.3e1 / 0.8e1 * t526, 0);
  t530 = t157 * t528 * t173;
  t533 = t26 * t157;
  t534 = t60 * t533;
  t535 = t191 * t168;
  t536 = t535 * t445;
  t539 = t191 * t418;
  t540 = t450 * t423;
  t541 = t540 * t168;
  t542 = t539 * t541;
  t545 = t191 * t75;
  t546 = t170 * t423;
  t547 = t546 * t168;
  t548 = t545 * t547;
  t552 = my_piecewise3(t51, 0, -t409 * t193 / 0.16e2 - t507 - t519 * t523 / 0.32e2 - t156 * t530 / 0.16e2 - t534 * t536 / 0.16e2 + t534 * t542 / 0.16e2 + t534 * t548 / 0.16e2);
  tv2rhosigma5 = t3 * t552 + t196;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t557 = t255 * t201 / 0.32e2;
  t558 = t471 * t199;
  t559 = t470 * t558;
  t563 = my_piecewise3(t39, -t181 / 0.2e1, 0);
  t565 = t100 * t563 * t116;
  t568 = t199 * t111;
  t569 = t568 * t290;
  t572 = t199 * t263;
  t573 = t572 * t491;
  t576 = t199 * t43;
  t577 = t576 * t497;
  t581 = my_piecewise3(t2, 0, -t246 * t201 / 0.16e2 - t557 - t469 * t559 / 0.32e2 - t99 * t565 / 0.16e2 - t484 * t569 / 0.16e2 + t484 * t573 / 0.16e2 + t484 * t577 / 0.16e2);
  tv2rholapl0 = t3 * t581 + t204;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t586 = t370 * t209 / 0.32e2;
  t588 = my_piecewise3(t51, 0, -t367 * t209 / 0.16e2 - t586);
  tv2rholapl1 = t3 * t588 + t212;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t593 = my_piecewise3(t2, 0, -t345 * t201 / 0.16e2 - t557);
  tv2rholapl2 = t3 * t593 + t204;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t597 = t521 * t207;
  t598 = t520 * t597;
  t602 = my_piecewise3(t72, -t189 / 0.2e1, 0);
  t604 = t157 * t602 * t173;
  t607 = t207 * t168;
  t608 = t607 * t445;
  t611 = t207 * t418;
  t612 = t611 * t541;
  t615 = t207 * t75;
  t616 = t615 * t547;
  t620 = my_piecewise3(t51, 0, -t409 * t209 / 0.16e2 - t586 - t519 * t598 / 0.32e2 - t156 * t604 / 0.16e2 - t534 * t608 / 0.16e2 + t534 * t612 / 0.16e2 + t534 * t616 / 0.16e2);
  tv2rholapl3 = t3 * t620 + t212;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t625 = t255 * t215 / 0.32e2;
  t626 = t471 * t213;
  t627 = t470 * t626;
  t631 = my_piecewise3(t39, 0.2e1 * t181, 0);
  t633 = t100 * t631 * t116;
  t636 = t213 * t111;
  t637 = t636 * t290;
  t640 = t213 * t263;
  t641 = t640 * t491;
  t644 = t213 * t43;
  t645 = t644 * t497;
  t649 = my_piecewise3(t2, 0, -t246 * t215 / 0.16e2 - t625 - t469 * t627 / 0.32e2 - t99 * t633 / 0.16e2 - t484 * t637 / 0.16e2 + t484 * t641 / 0.16e2 + t484 * t645 / 0.16e2);
  tv2rhotau0 = t3 * t649 + t218;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t654 = t370 * t221 / 0.32e2;
  t656 = my_piecewise3(t51, 0, -t367 * t221 / 0.16e2 - t654);
  tv2rhotau1 = t3 * t656 + t224;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t661 = my_piecewise3(t2, 0, -t345 * t215 / 0.16e2 - t625);
  tv2rhotau2 = t3 * t661 + t218;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t665 = t521 * t219;
  t666 = t520 * t665;
  t670 = my_piecewise3(t72, 0.2e1 * t189, 0);
  t672 = t157 * t670 * t173;
  t675 = t219 * t168;
  t676 = t675 * t445;
  t679 = t219 * t418;
  t680 = t679 * t541;
  t683 = t219 * t75;
  t684 = t683 * t547;
  t688 = my_piecewise3(t51, 0, -t409 * t221 / 0.16e2 - t654 - t519 * t666 / 0.32e2 - t156 * t672 / 0.16e2 - t534 * t676 / 0.16e2 + t534 * t680 / 0.16e2 + t534 * t684 / 0.16e2);
  tv2rhotau3 = t3 * t688 + t224;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t690 = t183 * t183;
  t692 = t260 * t690 * t269;
  t695 = my_piecewise3(t39, 0, 0);
  t697 = t100 * t695 * t116;
  t699 = t99 * t697 / 0.16e2;
  t700 = t100 * t690;
  t701 = t700 * t290;
  t704 = t700 * t297;
  t707 = t700 * t301;
  t711 = my_piecewise3(t2, 0, -t99 * t692 / 0.32e2 - t699 - t99 * t701 / 0.16e2 + t99 * t704 / 0.16e2 + t99 * t707 / 0.16e2);
  tv2sigma20 = t3 * t711;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t712 = t191 * t191;
  t714 = t415 * t712 * t424;
  t717 = my_piecewise3(t72, 0, 0);
  t719 = t157 * t717 * t173;
  t721 = t156 * t719 / 0.16e2;
  t722 = t157 * t712;
  t723 = t722 * t445;
  t726 = t722 * t452;
  t729 = t722 * t456;
  t733 = my_piecewise3(t51, 0, -t156 * t714 / 0.32e2 - t721 - t156 * t723 / 0.16e2 + t156 * t726 / 0.16e2 + t156 * t729 / 0.16e2);
  tv2sigma25 = t3 * t733;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t734 = t489 * t558;
  t737 = t199 * t183;
  t738 = t737 * t290;
  t741 = t490 * t183;
  t742 = t572 * t741;
  t745 = t496 * t183;
  t746 = t576 * t745;
  t750 = my_piecewise3(t2, 0, -t469 * t734 / 0.32e2 - t699 - t484 * t738 / 0.16e2 + t484 * t742 / 0.16e2 + t484 * t746 / 0.16e2);
  tv2sigmalapl0 = t3 * t750;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t751 = t539 * t597;
  t754 = t207 * t191;
  t755 = t754 * t445;
  t758 = t540 * t191;
  t759 = t611 * t758;
  t762 = t546 * t191;
  t763 = t615 * t762;
  t767 = my_piecewise3(t51, 0, -t519 * t751 / 0.32e2 - t721 - t534 * t755 / 0.16e2 + t534 * t759 / 0.16e2 + t534 * t763 / 0.16e2);
  tv2sigmalapl5 = t3 * t767;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t768 = t489 * t626;
  t771 = t213 * t183;
  t772 = t771 * t290;
  t775 = t640 * t741;
  t778 = t644 * t745;
  t782 = my_piecewise3(t2, 0, -t469 * t768 / 0.32e2 - t699 - t484 * t772 / 0.16e2 + t484 * t775 / 0.16e2 + t484 * t778 / 0.16e2);
  tv2sigmatau0 = t3 * t782;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t783 = t539 * t665;
  t786 = t219 * t191;
  t787 = t786 * t445;
  t790 = t679 * t758;
  t793 = t683 * t762;
  t797 = my_piecewise3(t51, 0, -t519 * t783 / 0.32e2 - t721 - t534 * t787 / 0.16e2 + t534 * t790 / 0.16e2 + t534 * t793 / 0.16e2);
  tv2sigmatau5 = t3 * t797;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t798 = t199 * t199;
  t800 = t260 * t798 * t269;
  t803 = t100 * t798;
  t804 = t803 * t290;
  t807 = t803 * t297;
  t810 = t803 * t301;
  t814 = my_piecewise3(t2, 0, -t99 * t800 / 0.32e2 - t699 - t99 * t804 / 0.16e2 + t99 * t807 / 0.16e2 + t99 * t810 / 0.16e2);
  tv2lapl20 = t3 * t814;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t815 = t207 * t207;
  t817 = t415 * t815 * t424;
  t820 = t157 * t815;
  t821 = t820 * t445;
  t824 = t820 * t452;
  t827 = t820 * t456;
  t831 = my_piecewise3(t51, 0, -t156 * t817 / 0.32e2 - t721 - t156 * t821 / 0.16e2 + t156 * t824 / 0.16e2 + t156 * t827 / 0.16e2);
  tv2lapl22 = t3 * t831;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t832 = t572 * t626;
  t835 = t213 * t199;
  t836 = t835 * t290;
  t839 = t490 * t199;
  t840 = t640 * t839;
  t843 = t496 * t199;
  t844 = t644 * t843;
  t848 = my_piecewise3(t2, 0, -t469 * t832 / 0.32e2 - t699 - t484 * t836 / 0.16e2 + t484 * t840 / 0.16e2 + t484 * t844 / 0.16e2);
  tv2lapltau0 = t3 * t848;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t849 = t611 * t665;
  t852 = t219 * t207;
  t853 = t852 * t445;
  t856 = t540 * t207;
  t857 = t679 * t856;
  t860 = t546 * t207;
  t861 = t683 * t860;
  t865 = my_piecewise3(t51, 0, -t519 * t849 / 0.32e2 - t721 - t534 * t853 / 0.16e2 + t534 * t857 / 0.16e2 + t534 * t861 / 0.16e2);
  tv2lapltau3 = t3 * t865;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t866 = t213 * t213;
  t868 = t260 * t866 * t269;
  t871 = t100 * t866;
  t872 = t871 * t290;
  t875 = t871 * t297;
  t878 = t871 * t301;
  t882 = my_piecewise3(t2, 0, -t99 * t868 / 0.32e2 - t699 - t99 * t872 / 0.16e2 + t99 * t875 / 0.16e2 + t99 * t878 / 0.16e2);
  tv2tau20 = t3 * t882;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t883 = t219 * t219;
  t885 = t415 * t883 * t424;
  t888 = t157 * t883;
  t889 = t888 * t445;
  t892 = t888 * t452;
  t895 = t888 * t456;
  t899 = my_piecewise3(t51, 0, -t156 * t885 / 0.32e2 - t721 - t156 * t889 / 0.16e2 + t156 * t892 / 0.16e2 + t156 * t895 / 0.16e2);
  tv2tau22 = t3 * t899;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t902 = t241 * t96;
  t904 = t91 * t252;
  t908 = t24 / t25 / t83;
  t909 = t908 * t46;
  t911 = 0.3e1 / 0.64e2 * t23 * t909;
  t912 = 0.1e1 / t21;
  t913 = t228 * t87;
  t916 = t227 * t87;
  t919 = t83 * t83;
  t920 = 0.1e1 / t919;
  t921 = t13 * t920;
  t924 = my_piecewise5(t7, 0, t11, 0, 0.6e1 * t232 - 0.6e1 * t921);
  t928 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t912 * t913 + 0.9e1 / 0.4e1 * t916 * t236 + 0.3e1 / 0.2e1 * t20 * t924);
  t929 = M_PI * t928;
  t933 = t470 * t471 * t283;
  t937 = t283 * t43 * t497;
  t940 = t283 * t263;
  t941 = t940 * t491;
  t945 = t283 * t111 * t290;
  t952 = t23 * t251;
  t953 = t952 * t117;
  t955 = t261 * t111;
  t956 = t100 * t955;
  t958 = 0.1e1 / t267 / t40;
  t959 = t114 * t958;
  t960 = t956 * t959;
  t963 = t260 * t955;
  t964 = t266 * t958;
  t965 = t963 * t964;
  t968 = t289 * t958;
  t969 = t956 * t968;
  t972 = t296 * t958;
  t973 = t956 * t972;
  t978 = -0.3e1 / 0.16e2 * t902 + 0.3e1 / 0.32e2 * t904 - t911 - t929 * t47 / 0.8e1 - 0.3e1 / 0.32e2 * t469 * t933 + 0.3e1 / 0.16e2 * t484 * t937 + 0.3e1 / 0.16e2 * t484 * t941 - 0.3e1 / 0.16e2 * t484 * t945 - 0.3e1 / 0.16e2 * t246 * t285 - 0.3e1 / 0.32e2 * t246 * t270 + 0.3e1 / 0.64e2 * t953 - t99 * t960 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t965 + 0.3e1 / 0.16e2 * t99 * t969 - 0.3e1 / 0.16e2 * t99 * t973 + 0.3e1 / 0.16e2 * t246 * t302;
  t979 = t255 * t302;
  t983 = t255 * t291;
  t985 = t43 * t295;
  t986 = t985 * t958;
  t987 = t956 * t986;
  t992 = t255 * t298;
  t994 = t963 * t972;
  t997 = t263 * t43;
  t998 = t264 * t264;
  t999 = 0.1e1 / t998;
  t1000 = t997 * t999;
  t1001 = t1000 * t958;
  t1002 = t963 * t1001;
  t1005 = t263 * t999;
  t1006 = t1005 * t958;
  t1007 = t956 * t1006;
  t1011 = 0.1e1 / t998 / t44;
  t1012 = t997 * t1011;
  t1013 = t1012 * t958;
  t1014 = t956 * t1013;
  t1017 = t255 * t285;
  t1019 = t255 * t270;
  t1021 = t45 * t45;
  t1022 = 0.1e1 / t1021;
  t1023 = t1022 * t100;
  t1026 = t258 * t260;
  t1030 = t1023 * t111 * t116 / 0.2e1 - t1026 * t111 * t116 / 0.2e1 + t117 / 0.2e1;
  t1032 = t1030 * t261 * t269;
  t1040 = 0.1e1 / t105 / t27;
  t1045 = my_piecewise3(t39, (-0.6e1 * lapl[0] * t278 + 0.24e2 * tau[0] * t278 - 0.15e2 / 0.2e1 * sigma[0] * t1040) * t37, 0);
  t1047 = t100 * t1045 * t116;
  t1050 = t241 * t26;
  t1053 = t91 * t95;
  t1054 = t1053 * t117;
  t1056 = 0.3e1 / 0.32e2 * t979 - 0.3e1 / 0.16e2 * t246 * t291 - 0.3e1 / 0.32e2 * t983 - t99 * t987 / 0.16e2 + 0.3e1 / 0.16e2 * t246 * t298 + 0.3e1 / 0.32e2 * t992 - 0.3e1 / 0.32e2 * t99 * t994 + 0.3e1 / 0.32e2 * t99 * t1002 + t99 * t1007 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t1014 - 0.3e1 / 0.32e2 * t1017 - 0.3e1 / 0.64e2 * t1019 - t99 * t1032 / 0.32e2 - t99 * t1047 / 0.16e2 - 0.3e1 / 0.16e2 * t1050 * t117 - 0.3e1 / 0.16e2 * t1054;
  t1058 = my_piecewise3(t2, 0, t978 + t1056);
  t1059 = 0.1e1 / t58;
  t1060 = t308 * t124;
  t1063 = t307 * t124;
  t1066 = t52 * t920;
  t1069 = my_piecewise5(t11, 0, t7, 0, -0.6e1 * t232 - 0.6e1 * t1066);
  t1073 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1060 + 0.9e1 / 0.4e1 * t1063 * t314 + 0.3e1 / 0.2e1 * t57 * t1069);
  t1074 = M_PI * t1073;
  t1077 = t319 * t131;
  t1079 = t128 * t324;
  t1081 = t908 * t78;
  t1083 = 0.3e1 / 0.64e2 * t60 * t1081;
  t1085 = my_piecewise3(t51, 0, -t1074 * t79 / 0.8e1 - 0.3e1 / 0.16e2 * t1077 + 0.3e1 / 0.32e2 * t1079 - t1083);
  tv3rho30 = 0.3e1 * t306 + 0.3e1 * t328 + t3 * (t1058 + t1085);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1088 = 0.2e1 * t351;
  t1089 = 0.2e1 * t374;
  t1090 = t912 * t139;
  t1093 = t227 * t335;
  t1098 = 0.2e1 * t232;
  t1099 = 0.6e1 * t921;
  t1101 = my_piecewise5(t7, 0, t11, 0, t1098 - t1099);
  t1105 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1090 * t228 + 0.3e1 / 0.2e1 * t1093 * t87 + 0.3e1 / 0.4e1 * t331 * t236 + 0.3e1 / 0.2e1 * t20 * t1101);
  t1106 = M_PI * t1105;
  t1113 = t340 * t96 / 0.8e1;
  t1114 = t143 * t252;
  t1121 = t340 * t26;
  t1124 = t143 * t95;
  t1126 = t1124 * t117 / 0.16e2;
  t1138 = -t1106 * t47 / 0.8e1 - t983 / 0.32e2 - t345 * t291 / 0.16e2 - t1113 + t1114 / 0.32e2 - t902 / 0.16e2 + t904 / 0.16e2 - t911 + t992 / 0.32e2 + t345 * t298 / 0.16e2 - t1121 * t117 / 0.8e1 - t1126 - t345 * t285 / 0.16e2 - t345 * t270 / 0.32e2 - t1017 / 0.32e2 - t1019 / 0.64e2 - t1054 / 0.16e2 + t953 / 0.32e2 + t345 * t302 / 0.16e2 + t979 / 0.32e2;
  t1139 = my_piecewise3(t2, 0, t1138);
  t1140 = t1059 * t149;
  t1143 = t307 * t356;
  t1148 = 0.6e1 * t1066;
  t1150 = my_piecewise5(t11, 0, t7, 0, -t1098 - t1148);
  t1154 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1140 * t308 + 0.3e1 / 0.2e1 * t1143 * t124 + 0.3e1 / 0.4e1 * t352 * t314 + 0.3e1 / 0.2e1 * t57 * t1150);
  t1155 = M_PI * t1154;
  t1159 = t361 * t131 / 0.8e1;
  t1160 = t153 * t324;
  t1164 = t319 * t26;
  t1167 = t128 * t95;
  t1169 = t1167 * t174 / 0.16e2;
  t1170 = t60 * t251;
  t1171 = t1170 * t174;
  t1174 = my_piecewise3(t51, 0, -t1155 * t79 / 0.8e1 - t1159 + t1160 / 0.32e2 - t1077 / 0.16e2 + t1079 / 0.16e2 - t1083 - t1164 * t174 / 0.16e2 - t1169 + t1171 / 0.64e2);
  tv3rho31 = t306 + t328 + t1088 + t1089 + t3 * (t1139 + t1174);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1177 = t912 * t379;
  t1182 = t227 * t384;
  t1186 = my_piecewise5(t7, 0, t11, 0, -t1098 - t1099);
  t1190 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1177 * t87 + 0.3e1 / 0.2e1 * t331 * t335 + 0.3e1 / 0.4e1 * t1182 * t87 + 0.3e1 / 0.2e1 * t20 * t1186);
  t1191 = M_PI * t1190;
  t1194 = t389 * t96;
  t1196 = t389 * t26;
  t1203 = my_piecewise3(t2, 0, -t1191 * t47 / 0.8e1 - t1194 / 0.16e2 - t1196 * t117 / 0.16e2 - t1113 + t1114 / 0.16e2 - t1126 + t904 / 0.32e2 - t911 + t953 / 0.64e2);
  t1204 = t1059 * t395;
  t1209 = t307 * t400;
  t1213 = my_piecewise5(t11, 0, t7, 0, t1098 - t1148);
  t1217 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1204 * t124 + 0.3e1 / 0.2e1 * t352 * t356 + 0.3e1 / 0.4e1 * t1209 * t124 + 0.3e1 / 0.2e1 * t57 * t1213);
  t1218 = M_PI * t1217;
  t1221 = t405 * t131;
  t1224 = t361 * t26;
  t1227 = t153 * t95;
  t1228 = t1227 * t174;
  t1234 = t370 * t425;
  t1238 = t370 * t440;
  t1242 = t370 * t446;
  t1246 = t370 * t453;
  t1250 = t370 * t457;
  t1252 = -t1218 * t79 / 0.8e1 - t1221 / 0.16e2 - t1159 + t1160 / 0.16e2 - t1224 * t174 / 0.8e1 - t1228 / 0.16e2 + t1079 / 0.32e2 - t1083 - t1169 + t1171 / 0.32e2 - t367 * t425 / 0.32e2 - t1234 / 0.64e2 - t367 * t440 / 0.16e2 - t1238 / 0.32e2 - t367 * t446 / 0.16e2 - t1242 / 0.32e2 + t367 * t453 / 0.16e2 + t1246 / 0.32e2 + t367 * t457 / 0.16e2 + t1250 / 0.32e2;
  t1253 = my_piecewise3(t51, 0, t1252);
  tv3rho32 = t1088 + t1089 + t394 + t461 + t3 * (t1203 + t1253);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1258 = t379 * t139;
  t1265 = my_piecewise5(t7, 0, t11, 0, -0.6e1 * t232 - 0.6e1 * t921);
  t1269 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t912 * t1258 + 0.9e1 / 0.4e1 * t331 * t384 + 0.3e1 / 0.2e1 * t20 * t1265);
  t1270 = M_PI * t1269;
  t1276 = my_piecewise3(t2, 0, -t1270 * t47 / 0.8e1 - 0.3e1 / 0.16e2 * t1194 + 0.3e1 / 0.32e2 * t1114 - t911);
  t1279 = t395 * t149;
  t1286 = my_piecewise5(t11, 0, t7, 0, 0.6e1 * t232 - 0.6e1 * t1066);
  t1290 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1279 + 0.9e1 / 0.4e1 * t352 * t400 + 0.3e1 / 0.2e1 * t57 * t1286);
  t1291 = M_PI * t1290;
  t1294 = t77 * t77;
  t1295 = 0.1e1 / t1294;
  t1296 = t1295 * t157;
  t1299 = t413 * t415;
  t1303 = t1296 * t168 * t173 / 0.2e1 - t1299 * t168 * t173 / 0.2e1 + t174 / 0.2e1;
  t1305 = t1303 * t416 * t424;
  t1313 = 0.1e1 / t162 / t61;
  t1318 = my_piecewise3(t72, (-0.6e1 * lapl[1] * t433 + 0.24e2 * tau[1] * t433 - 0.15e2 / 0.2e1 * sigma[2] * t1313) * t37, 0);
  t1320 = t157 * t1318 * t173;
  t1323 = t405 * t26;
  t1332 = t416 * t168;
  t1333 = t157 * t1332;
  t1334 = t75 * t450;
  t1336 = 0.1e1 / t422 / t73;
  t1337 = t1334 * t1336;
  t1338 = t1333 * t1337;
  t1343 = t415 * t1332;
  t1344 = t451 * t1336;
  t1345 = t1343 * t1344;
  t1348 = t418 * t75;
  t1349 = t419 * t419;
  t1350 = 0.1e1 / t1349;
  t1351 = t1348 * t1350;
  t1352 = t1351 * t1336;
  t1353 = t1343 * t1352;
  t1356 = t418 * t1350;
  t1357 = t1356 * t1336;
  t1358 = t1333 * t1357;
  t1362 = 0.1e1 / t1349 / t76;
  t1363 = t1348 * t1362;
  t1364 = t1363 * t1336;
  t1365 = t1333 * t1364;
  t1368 = 0.3e1 / 0.32e2 * t1160 - 0.3e1 / 0.16e2 * t1221 - t1291 * t79 / 0.8e1 - t1083 - t156 * t1305 / 0.32e2 - t156 * t1320 / 0.16e2 - 0.3e1 / 0.16e2 * t1323 * t174 - 0.3e1 / 0.16e2 * t409 * t440 - 0.3e1 / 0.32e2 * t409 * t425 - 0.3e1 / 0.16e2 * t409 * t446 - t156 * t1338 / 0.16e2 + 0.3e1 / 0.16e2 * t409 * t453 - 0.3e1 / 0.32e2 * t156 * t1345 + 0.3e1 / 0.32e2 * t156 * t1353 + t156 * t1358 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t1365;
  t1369 = t444 * t1336;
  t1370 = t1333 * t1369;
  t1373 = t1333 * t1344;
  t1376 = t171 * t1336;
  t1377 = t1333 * t1376;
  t1382 = t421 * t1336;
  t1383 = t1343 * t1382;
  t1386 = t438 * t418;
  t1387 = t1386 * t541;
  t1391 = t520 * t521 * t438;
  t1395 = t438 * t75 * t547;
  t1399 = t438 * t168 * t445;
  t1409 = 0.3e1 / 0.16e2 * t156 * t1370 - 0.3e1 / 0.16e2 * t156 * t1373 - t156 * t1377 / 0.8e1 + 0.3e1 / 0.16e2 * t409 * t457 + 0.3e1 / 0.32e2 * t156 * t1383 + 0.3e1 / 0.16e2 * t534 * t1387 - 0.3e1 / 0.32e2 * t519 * t1391 + 0.3e1 / 0.16e2 * t534 * t1395 - 0.3e1 / 0.16e2 * t534 * t1399 + 0.3e1 / 0.64e2 * t1171 - 0.3e1 / 0.16e2 * t1228 - 0.3e1 / 0.64e2 * t1234 - 0.3e1 / 0.32e2 * t1238 - 0.3e1 / 0.32e2 * t1242 + 0.3e1 / 0.32e2 * t1246 + 0.3e1 / 0.32e2 * t1250;
  t1411 = my_piecewise3(t51, 0, t1368 + t1409);
  tv3rho33 = 0.3e1 * t394 + 0.3e1 * t461 + t3 * (t1276 + t1411);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1415 = t255 * t480;
  t1417 = t278 * t37;
  t1419 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t1417, 0);
  t1421 = t100 * t1419 * t116;
  t1428 = t1053 * t185;
  t1431 = t952 * t185 / 0.64e2;
  t1432 = t295 * t958;
  t1433 = t1432 * t261;
  t1434 = t489 * t1433;
  t1439 = t261 * t997;
  t1440 = t999 * t958;
  t1441 = t1440 * t183;
  t1442 = t1439 * t1441;
  t1445 = t183 * t261;
  t1446 = t1445 * t1006;
  t1449 = t183 * t997;
  t1450 = t1011 * t958;
  t1451 = t1450 * t261;
  t1452 = t1449 * t1451;
  t1455 = t91 * t483;
  t1458 = t91 * t468;
  t1461 = t95 * t100;
  t1462 = t23 * t1461;
  t1463 = t1462 * t498;
  t1465 = t95 * t260;
  t1466 = t23 * t1465;
  t1467 = t1466 * t473;
  t1469 = t26 * t1030;
  t1470 = t23 * t1469;
  t1473 = -t1415 / 0.16e2 - t99 * t1421 / 0.16e2 - t1050 * t185 / 0.16e2 - t246 * t480 / 0.8e1 - t1428 / 0.16e2 + t1431 - 0.3e1 / 0.16e2 * t484 * t1434 - 0.3e1 / 0.32e2 * t469 * t1434 + 0.3e1 / 0.32e2 * t469 * t1442 + t484 * t1446 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1452 + t1455 * t498 / 0.8e1 - t1458 * t473 / 0.16e2 + t1463 / 0.16e2 - t1467 / 0.32e2 - t1470 * t473 / 0.32e2;
  t1474 = t940 * t472;
  t1477 = t496 * t283;
  t1478 = t495 * t1477;
  t1481 = t471 * t478;
  t1482 = t470 * t1481;
  t1485 = t478 * t43;
  t1486 = t1485 * t497;
  t1489 = t183 * t283;
  t1490 = t1489 * t290;
  t1493 = t490 * t283;
  t1494 = t489 * t1493;
  t1499 = t1462 * t486;
  t1502 = t478 * t111 * t290;
  t1505 = t1462 * t492;
  t1507 = t478 * t263;
  t1508 = t1507 * t491;
  t1511 = t1445 * t986;
  t1516 = t113 * t958;
  t1517 = t1516 * t261;
  t1518 = t495 * t1517;
  t1521 = t261 * t263;
  t1522 = t265 * t958;
  t1523 = t1522 * t183;
  t1524 = t1521 * t1523;
  t1527 = t1445 * t968;
  t1530 = -t469 * t1474 / 0.32e2 + t484 * t1478 / 0.16e2 - t469 * t1482 / 0.16e2 + t484 * t1486 / 0.8e1 - t484 * t1490 / 0.16e2 + t484 * t1494 / 0.16e2 - t1455 * t486 / 0.8e1 - t1499 / 0.16e2 - t484 * t1502 / 0.8e1 + t1505 / 0.16e2 + t484 * t1508 / 0.8e1 - t484 * t1511 / 0.16e2 + t1455 * t492 / 0.8e1 - t484 * t1518 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1524 + 0.3e1 / 0.16e2 * t484 * t1527;
  t1532 = my_piecewise3(t2, 0, t1473 + t1530);
  tv3rho2sigma0 = t1532 * t3 + 0.2e1 * t502;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1537 = t1167 * t193;
  t1540 = t1170 * t193 / 0.64e2;
  t1542 = my_piecewise3(t51, 0, -t1164 * t193 / 0.16e2 - t1537 / 0.16e2 + t1540);
  tv3rho2sigma2 = t1542 * t3 + 0.2e1 * t509;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1546 = t1124 * t185;
  t1548 = t143 * t468;
  t1553 = t143 * t483;
  t1566 = -t1121 * t185 / 0.16e2 - t1546 / 0.32e2 - t1548 * t473 / 0.32e2 - t345 * t480 / 0.16e2 - t1553 * t486 / 0.16e2 + t1553 * t492 / 0.16e2 + t1553 * t498 / 0.16e2 - t1428 / 0.32e2 + t1431 - t1467 / 0.64e2 - t1415 / 0.32e2 - t1499 / 0.32e2 + t1505 / 0.32e2 + t1463 / 0.32e2;
  t1567 = my_piecewise3(t2, 0, t1566);
  tv3rho2sigma3 = t1567 * t3 + t502 + t514;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1571 = t1227 * t193;
  t1574 = t128 * t518;
  t1577 = t95 * t415;
  t1578 = t60 * t1577;
  t1579 = t1578 * t523;
  t1583 = t370 * t530;
  t1585 = t128 * t533;
  t1588 = t95 * t157;
  t1589 = t60 * t1588;
  t1590 = t1589 * t536;
  t1594 = t1589 * t542;
  t1598 = t1589 * t548;
  t1600 = -t1224 * t193 / 0.16e2 - t1571 / 0.32e2 - t1537 / 0.32e2 + t1540 - t1574 * t523 / 0.32e2 - t1579 / 0.64e2 - t367 * t530 / 0.16e2 - t1583 / 0.32e2 - t1585 * t536 / 0.16e2 - t1590 / 0.32e2 + t1585 * t542 / 0.16e2 + t1594 / 0.32e2 + t1585 * t548 / 0.16e2 + t1598 / 0.32e2;
  t1601 = my_piecewise3(t51, 0, t1600);
  tv3rho2sigma5 = t1601 * t3 + t509 + t552;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1608 = my_piecewise3(t2, 0, -t1196 * t185 / 0.16e2 - t1546 / 0.16e2 + t1431);
  tv3rho2sigma6 = t1608 * t3 + 0.2e1 * t514;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1611 = t528 * t418;
  t1612 = t1611 * t541;
  t1615 = t191 * t416;
  t1616 = t1615 * t1337;
  t1619 = t416 * t418;
  t1620 = t420 * t1336;
  t1621 = t1620 * t191;
  t1622 = t1619 * t1621;
  t1625 = t1615 * t1369;
  t1628 = t450 * t1336;
  t1629 = t1628 * t416;
  t1630 = t539 * t1629;
  t1633 = t170 * t1336;
  t1634 = t1633 * t416;
  t1635 = t545 * t1634;
  t1640 = t416 * t1348;
  t1641 = t1350 * t1336;
  t1642 = t1641 * t191;
  t1643 = t1640 * t1642;
  t1646 = t1615 * t1357;
  t1649 = t191 * t1348;
  t1650 = t1362 * t1336;
  t1651 = t1650 * t416;
  t1652 = t1649 * t1651;
  t1655 = t528 * t75;
  t1656 = t1655 * t547;
  t1659 = t191 * t438;
  t1660 = t1659 * t445;
  t1663 = t540 * t438;
  t1664 = t539 * t1663;
  t1667 = t153 * t533;
  t1670 = t153 * t518;
  t1673 = t26 * t1303;
  t1674 = t60 * t1673;
  t1677 = t534 * t1612 / 0.8e1 - t534 * t1616 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t1622 + 0.3e1 / 0.16e2 * t534 * t1625 - 0.3e1 / 0.16e2 * t534 * t1630 - t534 * t1635 / 0.8e1 - 0.3e1 / 0.32e2 * t519 * t1630 + 0.3e1 / 0.32e2 * t519 * t1643 + t534 * t1646 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1652 + t534 * t1656 / 0.8e1 - t534 * t1660 / 0.16e2 + t534 * t1664 / 0.16e2 + t1667 * t548 / 0.8e1 - t1670 * t523 / 0.16e2 - t1674 * t523 / 0.32e2;
  t1678 = t1386 * t522;
  t1681 = t521 * t528;
  t1682 = t520 * t1681;
  t1688 = t528 * t168 * t445;
  t1699 = t433 * t37;
  t1701 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t1699, 0);
  t1703 = t157 * t1701 * t173;
  t1710 = t546 * t438;
  t1711 = t545 * t1710;
  t1714 = -t519 * t1678 / 0.32e2 - t519 * t1682 / 0.16e2 - t1667 * t536 / 0.8e1 - t534 * t1688 / 0.8e1 + t1667 * t542 / 0.8e1 - t1571 / 0.16e2 - t1583 / 0.16e2 - t1323 * t193 / 0.16e2 - t409 * t530 / 0.8e1 - t156 * t1703 / 0.16e2 + t1540 - t1579 / 0.32e2 - t1590 / 0.16e2 + t1594 / 0.16e2 + t1598 / 0.16e2 + t534 * t1711 / 0.16e2;
  t1716 = my_piecewise3(t51, 0, t1677 + t1714);
  tv3rho2sigma8 = t1716 * t3 + 0.2e1 * t552;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1719 = t1522 * t199;
  t1720 = t1521 * t1719;
  t1723 = t199 * t261;
  t1724 = t1723 * t968;
  t1727 = t572 * t1433;
  t1732 = t1440 * t199;
  t1733 = t1439 * t1732;
  t1736 = t1723 * t1006;
  t1739 = t199 * t997;
  t1740 = t1739 * t1451;
  t1745 = t940 * t558;
  t1748 = t471 * t563;
  t1749 = t470 * t1748;
  t1752 = t563 * t43;
  t1753 = t1752 * t497;
  t1756 = t199 * t283;
  t1757 = t1756 * t290;
  t1766 = t1462 * t569;
  t1768 = 0.3e1 / 0.32e2 * t469 * t1720 + 0.3e1 / 0.16e2 * t484 * t1724 - 0.3e1 / 0.16e2 * t484 * t1727 - 0.3e1 / 0.32e2 * t469 * t1727 + 0.3e1 / 0.32e2 * t469 * t1733 + t484 * t1736 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1740 - t1470 * t559 / 0.32e2 - t469 * t1745 / 0.32e2 - t469 * t1749 / 0.16e2 + t484 * t1753 / 0.8e1 - t484 * t1757 / 0.16e2 + t1455 * t577 / 0.8e1 - t1458 * t559 / 0.16e2 - t1455 * t569 / 0.8e1 - t1766 / 0.16e2;
  t1770 = t563 * t111 * t290;
  t1773 = t1462 * t573;
  t1775 = t563 * t263;
  t1776 = t1775 * t491;
  t1779 = t1723 * t986;
  t1784 = t576 * t1517;
  t1787 = t572 * t1493;
  t1790 = t576 * t1477;
  t1793 = t1462 * t577;
  t1795 = t1466 * t559;
  t1798 = t952 * t201 / 0.64e2;
  t1799 = t1053 * t201;
  t1805 = t255 * t565;
  t1808 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t476, 0);
  t1810 = t100 * t1808 * t116;
  t1813 = -t484 * t1770 / 0.8e1 + t1773 / 0.16e2 + t484 * t1776 / 0.8e1 - t484 * t1779 / 0.16e2 + t1455 * t573 / 0.8e1 - t484 * t1784 / 0.8e1 + t484 * t1787 / 0.16e2 + t484 * t1790 / 0.16e2 + t1793 / 0.16e2 - t1795 / 0.32e2 + t1798 - t1799 / 0.16e2 - t1050 * t201 / 0.16e2 - t246 * t565 / 0.8e1 - t1805 / 0.16e2 - t99 * t1810 / 0.16e2;
  t1815 = my_piecewise3(t2, 0, t1768 + t1813);
  tv3rho2lapl0 = t1815 * t3 + 0.2e1 * t581;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1820 = t1167 * t209;
  t1823 = t1170 * t209 / 0.64e2;
  t1825 = my_piecewise3(t51, 0, -t1164 * t209 / 0.16e2 - t1820 / 0.16e2 + t1823);
  tv3rho2lapl1 = t1825 * t3 + 0.2e1 * t588;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1829 = t1124 * t201;
  t1847 = -t1121 * t201 / 0.16e2 - t1829 / 0.32e2 - t1548 * t559 / 0.32e2 - t345 * t565 / 0.16e2 - t1553 * t569 / 0.16e2 + t1553 * t573 / 0.16e2 + t1553 * t577 / 0.16e2 - t1799 / 0.32e2 + t1798 - t1795 / 0.64e2 - t1805 / 0.32e2 - t1766 / 0.32e2 + t1773 / 0.32e2 + t1793 / 0.32e2;
  t1848 = my_piecewise3(t2, 0, t1847);
  tv3rho2lapl2 = t1848 * t3 + t581 + t593;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1852 = t1227 * t209;
  t1857 = t1578 * t598;
  t1861 = t370 * t604;
  t1865 = t1589 * t608;
  t1869 = t1589 * t612;
  t1873 = t1589 * t616;
  t1875 = -t1224 * t209 / 0.16e2 - t1852 / 0.32e2 - t1820 / 0.32e2 + t1823 - t1574 * t598 / 0.32e2 - t1857 / 0.64e2 - t367 * t604 / 0.16e2 - t1861 / 0.32e2 - t1585 * t608 / 0.16e2 - t1865 / 0.32e2 + t1585 * t612 / 0.16e2 + t1869 / 0.32e2 + t1585 * t616 / 0.16e2 + t1873 / 0.32e2;
  t1876 = my_piecewise3(t51, 0, t1875);
  tv3rho2lapl3 = t1876 * t3 + t588 + t620;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1883 = my_piecewise3(t2, 0, -t1196 * t201 / 0.16e2 - t1829 / 0.16e2 + t1798);
  tv3rho2lapl4 = t1883 * t3 + 0.2e1 * t593;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1886 = t615 * t1634;
  t1889 = t1628 * t207;
  t1890 = t1619 * t1889;
  t1893 = t1641 * t207;
  t1894 = t1640 * t1893;
  t1897 = t207 * t416;
  t1898 = t1897 * t1357;
  t1901 = t207 * t1348;
  t1902 = t1901 * t1651;
  t1912 = t602 * t168 * t445;
  t1917 = t602 * t418;
  t1918 = t1917 * t541;
  t1921 = t1897 * t1337;
  t1924 = t1620 * t207;
  t1925 = t1619 * t1924;
  t1928 = t1897 * t1369;
  t1934 = -t534 * t1886 / 0.8e1 - 0.3e1 / 0.32e2 * t519 * t1890 + 0.3e1 / 0.32e2 * t519 * t1894 + t534 * t1898 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1902 + t1667 * t616 / 0.8e1 - t1670 * t598 / 0.16e2 - t1667 * t608 / 0.8e1 - t534 * t1912 / 0.8e1 + t1667 * t612 / 0.8e1 + t534 * t1918 / 0.8e1 - t534 * t1921 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t1925 + 0.3e1 / 0.16e2 * t534 * t1928 - 0.3e1 / 0.16e2 * t534 * t1890 + t1869 / 0.16e2;
  t1936 = t611 * t1663;
  t1939 = t615 * t1710;
  t1944 = t1386 * t597;
  t1947 = t521 * t602;
  t1948 = t520 * t1947;
  t1951 = t602 * t75;
  t1952 = t1951 * t547;
  t1955 = t207 * t438;
  t1956 = t1955 * t445;
  t1966 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t526, 0);
  t1968 = t157 * t1966 * t173;
  t1973 = t1873 / 0.16e2 + t534 * t1936 / 0.16e2 + t534 * t1939 / 0.16e2 - t1674 * t598 / 0.32e2 - t519 * t1944 / 0.32e2 - t519 * t1948 / 0.16e2 + t534 * t1952 / 0.8e1 - t534 * t1956 / 0.16e2 - t1857 / 0.32e2 - t1865 / 0.16e2 - t409 * t604 / 0.8e1 + t1823 - t1852 / 0.16e2 - t1861 / 0.16e2 - t156 * t1968 / 0.16e2 - t1323 * t209 / 0.16e2;
  t1975 = my_piecewise3(t51, 0, t1934 + t1973);
  tv3rho2lapl5 = t1975 * t3 + 0.2e1 * t620;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1978 = t640 * t1433;
  t1981 = t644 * t1517;
  t1984 = t1440 * t213;
  t1985 = t1439 * t1984;
  t1988 = t213 * t261;
  t1989 = t1988 * t1006;
  t1992 = t213 * t997;
  t1993 = t1992 * t1451;
  t1998 = t1462 * t645;
  t2000 = t1466 * t627;
  t2004 = t940 * t626;
  t2007 = t471 * t631;
  t2008 = t470 * t2007;
  t2011 = t1462 * t637;
  t2013 = t631 * t111;
  t2014 = t2013 * t290;
  t2019 = t1462 * t641;
  t2021 = t631 * t263;
  t2022 = t2021 * t491;
  t2025 = -0.3e1 / 0.16e2 * t484 * t1978 - t484 * t1981 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1985 + t484 * t1989 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1993 - 0.3e1 / 0.32e2 * t469 * t1978 + t1998 / 0.16e2 - t2000 / 0.32e2 - t1470 * t627 / 0.32e2 - t469 * t2004 / 0.32e2 - t469 * t2008 / 0.16e2 - t2011 / 0.16e2 - t484 * t2014 / 0.8e1 - t1455 * t637 / 0.8e1 + t2019 / 0.16e2 + t484 * t2022 / 0.8e1;
  t2026 = t1988 * t986;
  t2031 = t1522 * t213;
  t2032 = t1521 * t2031;
  t2035 = t1988 * t968;
  t2038 = t644 * t1477;
  t2041 = t631 * t43;
  t2042 = t2041 * t497;
  t2045 = t213 * t283;
  t2046 = t2045 * t290;
  t2049 = t640 * t1493;
  t2056 = t1053 * t215;
  t2059 = t952 * t215 / 0.64e2;
  t2061 = my_piecewise3(t39, -0.6e1 * t476, 0);
  t2063 = t100 * t2061 * t116;
  t2070 = t255 * t633;
  t2072 = -t484 * t2026 / 0.16e2 + t1455 * t641 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2032 + 0.3e1 / 0.16e2 * t484 * t2035 + t484 * t2038 / 0.16e2 + t484 * t2042 / 0.8e1 - t484 * t2046 / 0.16e2 + t484 * t2049 / 0.16e2 + t1455 * t645 / 0.8e1 - t1458 * t627 / 0.16e2 - t2056 / 0.16e2 + t2059 - t99 * t2063 / 0.16e2 - t1050 * t215 / 0.16e2 - t246 * t633 / 0.8e1 - t2070 / 0.16e2;
  t2074 = my_piecewise3(t2, 0, t2025 + t2072);
  tv3rho2tau0 = t2074 * t3 + 0.2e1 * t649;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2079 = t1167 * t221;
  t2082 = t1170 * t221 / 0.64e2;
  t2084 = my_piecewise3(t51, 0, -t1164 * t221 / 0.16e2 - t2079 / 0.16e2 + t2082);
  tv3rho2tau1 = t2084 * t3 + 0.2e1 * t656;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2088 = t1124 * t215;
  t2106 = -t1121 * t215 / 0.16e2 - t2088 / 0.32e2 - t1548 * t627 / 0.32e2 - t345 * t633 / 0.16e2 - t1553 * t637 / 0.16e2 + t1553 * t641 / 0.16e2 + t1553 * t645 / 0.16e2 - t2056 / 0.32e2 + t2059 - t2000 / 0.64e2 - t2070 / 0.32e2 - t2011 / 0.32e2 + t2019 / 0.32e2 + t1998 / 0.32e2;
  t2107 = my_piecewise3(t2, 0, t2106);
  tv3rho2tau2 = t2107 * t3 + t649 + t661;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2111 = t1227 * t221;
  t2116 = t1578 * t666;
  t2120 = t370 * t672;
  t2124 = t1589 * t676;
  t2128 = t1589 * t680;
  t2132 = t1589 * t684;
  t2134 = -t1224 * t221 / 0.16e2 - t2111 / 0.32e2 - t2079 / 0.32e2 + t2082 - t1574 * t666 / 0.32e2 - t2116 / 0.64e2 - t367 * t672 / 0.16e2 - t2120 / 0.32e2 - t1585 * t676 / 0.16e2 - t2124 / 0.32e2 + t1585 * t680 / 0.16e2 + t2128 / 0.32e2 + t1585 * t684 / 0.16e2 + t2132 / 0.32e2;
  t2135 = my_piecewise3(t51, 0, t2134);
  tv3rho2tau3 = t2135 * t3 + t656 + t688;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2142 = my_piecewise3(t2, 0, -t1196 * t215 / 0.16e2 - t2088 / 0.16e2 + t2059);
  tv3rho2tau4 = t2142 * t3 + 0.2e1 * t661;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2148 = t670 * t168 * t445;
  t2153 = t670 * t418;
  t2154 = t2153 * t541;
  t2157 = t219 * t416;
  t2158 = t2157 * t1337;
  t2161 = t1620 * t219;
  t2162 = t1619 * t2161;
  t2165 = t2157 * t1369;
  t2168 = t679 * t1629;
  t2171 = t683 * t1634;
  t2174 = t1641 * t219;
  t2175 = t1640 * t2174;
  t2178 = t2157 * t1357;
  t2181 = t219 * t1348;
  t2182 = t2181 * t1651;
  t2188 = t219 * t438;
  t2189 = t2188 * t445;
  t2192 = t679 * t1663;
  t2195 = -t1667 * t676 / 0.8e1 - t534 * t2148 / 0.8e1 + t1667 * t680 / 0.8e1 + t534 * t2154 / 0.8e1 - t534 * t2158 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2162 + 0.3e1 / 0.16e2 * t534 * t2165 - 0.3e1 / 0.16e2 * t534 * t2168 - t534 * t2171 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t2175 + t534 * t2178 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2182 - 0.3e1 / 0.32e2 * t519 * t2168 + t2132 / 0.16e2 - t534 * t2189 / 0.16e2 + t534 * t2192 / 0.16e2;
  t2196 = t683 * t1710;
  t2205 = t1386 * t665;
  t2208 = t521 * t670;
  t2209 = t520 * t2208;
  t2212 = t670 * t75;
  t2213 = t2212 * t547;
  t2223 = my_piecewise3(t72, -0.6e1 * t526, 0);
  t2225 = t157 * t2223 * t173;
  t2231 = t534 * t2196 / 0.16e2 + t1667 * t684 / 0.8e1 - t1670 * t666 / 0.16e2 - t1674 * t666 / 0.32e2 - t519 * t2205 / 0.32e2 - t519 * t2209 / 0.16e2 + t534 * t2213 / 0.8e1 - t2116 / 0.32e2 - t2124 / 0.16e2 + t2128 / 0.16e2 - t2120 / 0.16e2 - t409 * t672 / 0.8e1 - t156 * t2225 / 0.16e2 - t1323 * t221 / 0.16e2 + t2082 - t2111 / 0.16e2;
  t2233 = my_piecewise3(t51, 0, t2195 + t2231);
  tv3rho2tau5 = t2233 * t3 + 0.2e1 * t688;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2235 = t495 * t1481;
  t2238 = t690 * t43;
  t2239 = t1522 * t111;
  t2240 = t2238 * t2239;
  t2243 = t695 * t111;
  t2244 = t2243 * t290;
  t2245 = t484 * t2244;
  t2246 = t2245 / 0.16e2;
  t2248 = t690 * t111 * t986;
  t2251 = t695 * t263;
  t2252 = t2251 * t491;
  t2253 = t484 * t2252;
  t2254 = t2253 / 0.16e2;
  t2255 = t690 * t263;
  t2256 = t1440 * t111;
  t2257 = t2255 * t2256;
  t2260 = t690 * t997;
  t2261 = t1450 * t111;
  t2262 = t2260 * t2261;
  t2265 = t1432 * t111;
  t2266 = t2255 * t2265;
  t2269 = t2260 * t2256;
  t2272 = t490 * t478;
  t2273 = t489 * t2272;
  t2278 = t496 * t478;
  t2279 = t495 * t2278;
  t2282 = t1516 * t111;
  t2283 = t2238 * t2282;
  t2286 = t489 * t1481;
  t2289 = -t484 * t2235 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2240 - t2246 - t484 * t2248 / 0.16e2 + t2254 + t484 * t2257 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2262 - 0.3e1 / 0.32e2 * t469 * t2266 + 0.3e1 / 0.32e2 * t469 * t2269 + t484 * t2273 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t2266 + t484 * t2279 / 0.8e1 - t484 * t2283 / 0.8e1 - t469 * t2286 / 0.16e2;
  t2290 = t2255 * t2239;
  t2293 = t695 * t43;
  t2294 = t2293 * t497;
  t2295 = t484 * t2294;
  t2296 = t2295 / 0.16e2;
  t2297 = t471 * t695;
  t2298 = t470 * t2297;
  t2299 = t469 * t2298;
  t2300 = t2299 / 0.32e2;
  t2306 = t1030 * t690 * t269;
  t2310 = t255 * t704 / 0.32e2;
  t2312 = t255 * t707 / 0.32e2;
  t2314 = t255 * t692 / 0.64e2;
  t2315 = t255 * t697;
  t2316 = t2315 / 0.32e2;
  t2318 = t255 * t701 / 0.32e2;
  t2319 = t246 * t697;
  t2320 = t2319 / 0.16e2;
  t2325 = 0.3e1 / 0.32e2 * t469 * t2290 + t2296 - t2300 + t246 * t707 / 0.16e2 - t246 * t692 / 0.32e2 - t99 * t2306 / 0.32e2 + t2310 + t2312 - t2314 - t2316 - t2318 - t2320 - t246 * t701 / 0.16e2 + t246 * t704 / 0.16e2 - t699;
  t2327 = my_piecewise3(t2, 0, t2289 + t2325);
  tv3rhosigma20 = t2327 * t3 + t711;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2332 = t370 * t714 / 0.64e2;
  t2334 = t367 * t719 / 0.16e2;
  t2335 = t370 * t719;
  t2336 = t2335 / 0.32e2;
  t2340 = t370 * t723 / 0.32e2;
  t2344 = t370 * t726 / 0.32e2;
  t2348 = t370 * t729 / 0.32e2;
  t2350 = my_piecewise3(t51, 0, -t367 * t714 / 0.32e2 - t2332 - t2334 - t2336 - t367 * t723 / 0.16e2 - t2340 + t367 * t726 / 0.16e2 + t2344 + t367 * t729 / 0.16e2 + t2348);
  tv3rhosigma25 = t2350 * t3 + t733;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2355 = t345 * t697 / 0.16e2;
  t2363 = my_piecewise3(t2, 0, -t345 * t692 / 0.32e2 - t2314 - t2355 - t2316 - t345 * t701 / 0.16e2 - t2318 + t345 * t704 / 0.16e2 + t2310 + t345 * t707 / 0.16e2 + t2312);
  tv3rhosigma26 = t2363 * t3 + t711;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2365 = t712 * t1348;
  t2366 = t1650 * t168;
  t2367 = t2365 * t2366;
  t2370 = t545 * t1681;
  t2373 = t712 * t75;
  t2374 = t1620 * t168;
  t2375 = t2373 * t2374;
  t2378 = t540 * t528;
  t2379 = t539 * t2378;
  t2382 = t712 * t418;
  t2383 = t1628 * t168;
  t2384 = t2382 * t2383;
  t2387 = t539 * t1681;
  t2390 = t717 * t168;
  t2391 = t2390 * t445;
  t2392 = t534 * t2391;
  t2393 = t2392 / 0.16e2;
  t2395 = t712 * t168 * t1337;
  t2400 = t1641 * t168;
  t2401 = t2365 * t2400;
  t2404 = t717 * t418;
  t2405 = t2404 * t541;
  t2406 = t534 * t2405;
  t2407 = t2406 / 0.16e2;
  t2408 = t2382 * t2400;
  t2411 = t546 * t528;
  t2412 = t545 * t2411;
  t2415 = t1633 * t168;
  t2416 = t2373 * t2415;
  t2419 = -0.3e1 / 0.16e2 * t534 * t2367 - t534 * t2370 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2375 + t534 * t2379 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t2384 - t519 * t2387 / 0.16e2 - t2393 - t534 * t2395 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2384 + 0.3e1 / 0.32e2 * t519 * t2401 + t2407 + t534 * t2408 / 0.4e1 + t534 * t2412 / 0.8e1 - t534 * t2416 / 0.8e1;
  t2420 = t2382 * t2374;
  t2423 = t717 * t75;
  t2424 = t2423 * t547;
  t2425 = t534 * t2424;
  t2426 = t2425 / 0.16e2;
  t2427 = t521 * t717;
  t2428 = t520 * t2427;
  t2429 = t519 * t2428;
  t2430 = t2429 / 0.32e2;
  t2440 = t1303 * t712 * t424;
  t2443 = t409 * t719;
  t2444 = t2443 / 0.16e2;
  t2445 = 0.3e1 / 0.32e2 * t519 * t2420 + t2426 - t2430 - t2340 + t2344 + t2348 - t409 * t723 / 0.16e2 + t409 * t726 / 0.16e2 + t409 * t729 / 0.16e2 - t409 * t714 / 0.32e2 - t156 * t2440 / 0.32e2 - t2444 - t2332 - t2336 - t721;
  t2447 = my_piecewise3(t51, 0, t2419 + t2445);
  tv3rhosigma211 = t2447 * t3 + t733;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2449 = t737 * t111;
  t2450 = t2449 * t986;
  t2453 = t489 * t265;
  t2454 = t958 * t199;
  t2455 = t2454 * t111;
  t2456 = t2453 * t2455;
  t2459 = t737 * t43;
  t2460 = t2459 * t2239;
  t2463 = t572 * t295;
  t2464 = t958 * t183;
  t2465 = t2464 * t111;
  t2466 = t2463 * t2465;
  t2469 = t576 * t113;
  t2470 = t2469 * t2465;
  t2475 = t1449 * t999;
  t2476 = t2475 * t2455;
  t2479 = t737 * t263;
  t2480 = t2479 * t2256;
  t2483 = t1739 * t1011;
  t2484 = t2483 * t2465;
  t2488 = t1466 * t734 / 0.64e2;
  t2490 = t1462 * t738 / 0.32e2;
  t2492 = t1462 * t742 / 0.32e2;
  t2494 = t1462 * t746 / 0.32e2;
  t2497 = t563 * t183;
  t2498 = t2497 * t290;
  t2501 = t199 * t478;
  t2502 = t2501 * t290;
  t2505 = -t484 * t2450 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2456 + 0.3e1 / 0.16e2 * t484 * t2460 - 0.3e1 / 0.16e2 * t484 * t2466 - t484 * t2470 / 0.8e1 - 0.3e1 / 0.32e2 * t469 * t2466 + 0.3e1 / 0.32e2 * t469 * t2476 + t484 * t2480 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2484 - t2488 - t2490 + t2492 + t2494 - t1455 * t738 / 0.16e2 - t484 * t2498 / 0.16e2 - t484 * t2502 / 0.16e2;
  t2508 = t1775 * t741;
  t2511 = t572 * t2272;
  t2516 = t1752 * t745;
  t2519 = t576 * t2278;
  t2526 = t1507 * t558;
  t2529 = t489 * t1748;
  t2532 = t1455 * t742 / 0.16e2 + t484 * t2508 / 0.16e2 + t484 * t2511 / 0.16e2 + t1455 * t746 / 0.16e2 + t484 * t2516 / 0.16e2 + t484 * t2519 / 0.16e2 - t1458 * t734 / 0.32e2 - t1470 * t734 / 0.32e2 - t469 * t2526 / 0.32e2 - t469 * t2529 / 0.32e2 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699;
  t2534 = my_piecewise3(t2, 0, t2505 + t2532);
  tv3rhosigmalapl0 = t2534 * t3 + t750;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2539 = t1578 * t751 / 0.64e2;
  t2543 = t1589 * t755 / 0.32e2;
  t2547 = t1589 * t759 / 0.32e2;
  t2551 = t1589 * t763 / 0.32e2;
  t2553 = my_piecewise3(t51, 0, -t1574 * t751 / 0.32e2 - t2539 - t2334 - t2336 - t1585 * t755 / 0.16e2 - t2543 + t1585 * t759 / 0.16e2 + t2547 + t1585 * t763 / 0.16e2 + t2551);
  tv3rhosigmalapl5 = t2553 * t3 + t767;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2564 = my_piecewise3(t2, 0, -t1548 * t734 / 0.32e2 - t2488 - t2355 - t2316 - t1553 * t738 / 0.16e2 - t2490 + t1553 * t742 / 0.16e2 + t2492 + t1553 * t746 / 0.16e2 + t2494);
  tv3rhosigmalapl6 = t2564 * t3 + t750;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2566 = t1901 * t1362;
  t2567 = t1336 * t191;
  t2568 = t2567 * t168;
  t2569 = t2566 * t2568;
  t2572 = t539 * t450;
  t2573 = t1336 * t207;
  t2574 = t2573 * t168;
  t2575 = t2572 * t2574;
  t2578 = t1649 * t1350;
  t2579 = t2578 * t2574;
  t2582 = t754 * t418;
  t2583 = t2582 * t2400;
  t2586 = t754 * t168;
  t2587 = t2586 * t1337;
  t2590 = t539 * t420;
  t2591 = t2590 * t2574;
  t2594 = t754 * t75;
  t2595 = t2594 * t2374;
  t2600 = t615 * t170;
  t2601 = t2600 * t2568;
  t2604 = t1611 * t597;
  t2607 = t539 * t1947;
  t2612 = t602 * t191;
  t2613 = t2612 * t445;
  t2616 = t207 * t528;
  t2617 = t2616 * t445;
  t2622 = t1917 * t758;
  t2625 = -0.3e1 / 0.16e2 * t534 * t2569 - 0.3e1 / 0.32e2 * t519 * t2575 + 0.3e1 / 0.32e2 * t519 * t2579 + t534 * t2583 / 0.4e1 - t534 * t2587 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2591 + 0.3e1 / 0.16e2 * t534 * t2595 - 0.3e1 / 0.16e2 * t534 * t2575 - t534 * t2601 / 0.8e1 - t519 * t2604 / 0.32e2 - t519 * t2607 / 0.32e2 - t1667 * t755 / 0.16e2 - t534 * t2613 / 0.16e2 - t534 * t2617 / 0.16e2 + t1667 * t759 / 0.16e2 + t534 * t2622 / 0.16e2;
  t2626 = t611 * t2378;
  t2631 = t1951 * t762;
  t2634 = t615 * t2411;
  t2641 = t534 * t2626 / 0.16e2 + t1667 * t763 / 0.16e2 + t534 * t2631 / 0.16e2 + t534 * t2634 / 0.16e2 - t1670 * t751 / 0.32e2 - t1674 * t751 / 0.32e2 - t2539 - t2543 + t2547 + t2551 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t2643 = my_piecewise3(t51, 0, t2625 + t2641);
  tv3rhosigmalapl11 = t2643 * t3 + t767;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2645 = t1992 * t1011;
  t2646 = t2645 * t2465;
  t2649 = t771 * t111;
  t2650 = t2649 * t986;
  t2653 = t644 * t113;
  t2654 = t2653 * t2465;
  t2657 = t958 * t213;
  t2658 = t2657 * t111;
  t2659 = t2453 * t2658;
  t2662 = t771 * t43;
  t2663 = t2662 * t2239;
  t2666 = t640 * t295;
  t2667 = t2666 * t2465;
  t2672 = t2475 * t2658;
  t2675 = t771 * t263;
  t2676 = t2675 * t2256;
  t2683 = t1507 * t626;
  t2686 = t489 * t2007;
  t2691 = t631 * t183;
  t2692 = t2691 * t290;
  t2696 = t1462 * t778 / 0.32e2;
  t2697 = -0.3e1 / 0.16e2 * t484 * t2646 - t484 * t2650 / 0.16e2 - t484 * t2654 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2659 + 0.3e1 / 0.16e2 * t484 * t2663 - 0.3e1 / 0.16e2 * t484 * t2667 - 0.3e1 / 0.32e2 * t469 * t2667 + 0.3e1 / 0.32e2 * t469 * t2672 + t484 * t2676 / 0.4e1 - t1458 * t768 / 0.32e2 - t1470 * t768 / 0.32e2 - t469 * t2683 / 0.32e2 - t469 * t2686 / 0.32e2 - t1455 * t772 / 0.16e2 - t484 * t2692 / 0.16e2 + t2696;
  t2699 = t1466 * t768 / 0.64e2;
  t2701 = t1462 * t772 / 0.32e2;
  t2703 = t1462 * t775 / 0.32e2;
  t2704 = t213 * t478;
  t2705 = t2704 * t290;
  t2710 = t2021 * t741;
  t2713 = t640 * t2272;
  t2718 = t2041 * t745;
  t2721 = t644 * t2278;
  t2724 = -t2699 - t2701 + t2703 - t484 * t2705 / 0.16e2 + t1455 * t775 / 0.16e2 + t484 * t2710 / 0.16e2 + t484 * t2713 / 0.16e2 + t1455 * t778 / 0.16e2 + t484 * t2718 / 0.16e2 + t484 * t2721 / 0.16e2 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699;
  t2726 = my_piecewise3(t2, 0, t2697 + t2724);
  tv3rhosigmatau0 = t2726 * t3 + t782;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2731 = t1578 * t783 / 0.64e2;
  t2735 = t1589 * t787 / 0.32e2;
  t2739 = t1589 * t790 / 0.32e2;
  t2743 = t1589 * t793 / 0.32e2;
  t2745 = my_piecewise3(t51, 0, -t1574 * t783 / 0.32e2 - t2731 - t2334 - t2336 - t1585 * t787 / 0.16e2 - t2735 + t1585 * t790 / 0.16e2 + t2739 + t1585 * t793 / 0.16e2 + t2743);
  tv3rhosigmatau5 = t2745 * t3 + t797;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2756 = my_piecewise3(t2, 0, -t1548 * t768 / 0.32e2 - t2699 - t2355 - t2316 - t1553 * t772 / 0.16e2 - t2701 + t1553 * t775 / 0.16e2 + t2703 + t1553 * t778 / 0.16e2 + t2696);
  tv3rhosigmatau6 = t2756 * t3 + t782;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2758 = t2181 * t1362;
  t2759 = t2758 * t2568;
  t2762 = t1336 * t219;
  t2763 = t2762 * t168;
  t2764 = t2572 * t2763;
  t2767 = t2578 * t2763;
  t2770 = t786 * t418;
  t2771 = t2770 * t2400;
  t2774 = t786 * t168;
  t2775 = t2774 * t1337;
  t2778 = t683 * t170;
  t2779 = t2778 * t2568;
  t2782 = t2590 * t2763;
  t2785 = t786 * t75;
  t2786 = t2785 * t2374;
  t2793 = t670 * t191;
  t2794 = t2793 * t445;
  t2797 = t219 * t528;
  t2798 = t2797 * t445;
  t2803 = t2153 * t758;
  t2806 = t679 * t2378;
  t2811 = -0.3e1 / 0.16e2 * t534 * t2759 - 0.3e1 / 0.32e2 * t519 * t2764 + 0.3e1 / 0.32e2 * t519 * t2767 + t534 * t2771 / 0.4e1 - t534 * t2775 / 0.16e2 - t534 * t2779 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t2782 + 0.3e1 / 0.16e2 * t534 * t2786 - 0.3e1 / 0.16e2 * t534 * t2764 - t1667 * t787 / 0.16e2 - t534 * t2794 / 0.16e2 - t534 * t2798 / 0.16e2 + t1667 * t790 / 0.16e2 + t534 * t2803 / 0.16e2 + t534 * t2806 / 0.16e2 + t1667 * t793 / 0.16e2;
  t2812 = t2212 * t762;
  t2815 = t683 * t2411;
  t2822 = t1611 * t665;
  t2825 = t539 * t2208;
  t2828 = t534 * t2812 / 0.16e2 + t534 * t2815 / 0.16e2 - t1670 * t783 / 0.32e2 - t1674 * t783 / 0.32e2 - t519 * t2822 / 0.32e2 - t519 * t2825 / 0.32e2 - t2735 + t2739 + t2743 - t2731 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t2830 = my_piecewise3(t51, 0, t2811 + t2828);
  tv3rhosigmatau11 = t2830 * t3 + t797;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2832 = t798 * t111;
  t2833 = t2832 * t986;
  t2836 = t798 * t263;
  t2837 = t2836 * t2265;
  t2840 = t798 * t997;
  t2841 = t2840 * t2256;
  t2844 = t2836 * t2256;
  t2847 = t2840 * t2261;
  t2852 = t496 * t563;
  t2853 = t576 * t2852;
  t2856 = t798 * t43;
  t2857 = t2856 * t2282;
  t2860 = t572 * t1748;
  t2863 = t2836 * t2239;
  t2866 = t576 * t1748;
  t2869 = t2856 * t2239;
  t2872 = t490 * t563;
  t2873 = t572 * t2872;
  t2876 = -t484 * t2833 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t2837 + 0.3e1 / 0.32e2 * t469 * t2841 + t484 * t2844 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2847 - 0.3e1 / 0.16e2 * t484 * t2837 + t484 * t2853 / 0.8e1 - t484 * t2857 / 0.8e1 - t469 * t2860 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2863 - t484 * t2866 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2869 + t484 * t2873 / 0.8e1 - t2246;
  t2878 = t255 * t810 / 0.32e2;
  t2880 = t255 * t800 / 0.64e2;
  t2882 = t255 * t804 / 0.32e2;
  t2884 = t255 * t807 / 0.32e2;
  t2894 = t1030 * t798 * t269;
  t2897 = t2254 + t2296 - t2300 + t2878 - t2880 - t2882 + t2884 - t246 * t804 / 0.16e2 + t246 * t807 / 0.16e2 + t246 * t810 / 0.16e2 - t246 * t800 / 0.32e2 - t99 * t2894 / 0.32e2 - t2316 - t2320 - t699;
  t2899 = my_piecewise3(t2, 0, t2876 + t2897);
  tv3rholapl20 = t2899 * t3 + t814;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2904 = t370 * t817 / 0.64e2;
  t2908 = t370 * t821 / 0.32e2;
  t2912 = t370 * t824 / 0.32e2;
  t2916 = t370 * t827 / 0.32e2;
  t2918 = my_piecewise3(t51, 0, -t367 * t817 / 0.32e2 - t2904 - t2334 - t2336 - t367 * t821 / 0.16e2 - t2908 + t367 * t824 / 0.16e2 + t2912 + t367 * t827 / 0.16e2 + t2916);
  tv3rholapl22 = t2918 * t3 + t831;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2929 = my_piecewise3(t2, 0, -t345 * t800 / 0.32e2 - t2880 - t2355 - t2316 - t345 * t804 / 0.16e2 - t2882 + t345 * t807 / 0.16e2 + t2884 + t345 * t810 / 0.16e2 + t2878);
  tv3rholapl23 = t2929 * t3 + t814;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2931 = t815 * t168;
  t2932 = t2931 * t1337;
  t2935 = t815 * t418;
  t2936 = t2935 * t2383;
  t2939 = t815 * t1348;
  t2940 = t2939 * t2400;
  t2943 = t2935 * t2400;
  t2946 = t2939 * t2366;
  t2949 = t615 * t1947;
  t2952 = t815 * t75;
  t2953 = t2952 * t2374;
  t2956 = t540 * t602;
  t2957 = t611 * t2956;
  t2962 = t546 * t602;
  t2963 = t615 * t2962;
  t2966 = t2952 * t2415;
  t2969 = t611 * t1947;
  t2972 = t2935 * t2374;
  t2975 = -t534 * t2932 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2936 + 0.3e1 / 0.32e2 * t519 * t2940 + t534 * t2943 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2946 - t534 * t2949 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2953 + t534 * t2957 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t2936 + t534 * t2963 / 0.8e1 - t534 * t2966 / 0.8e1 - t519 * t2969 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2972 - t2393;
  t2981 = t1303 * t815 * t424;
  t2988 = t2407 + t2426 - t2430 + t409 * t827 / 0.16e2 - t409 * t817 / 0.32e2 - t156 * t2981 / 0.32e2 - t409 * t821 / 0.16e2 + t409 * t824 / 0.16e2 - t2904 - t2908 + t2912 + t2916 - t2444 - t2336 - t721;
  t2990 = my_piecewise3(t51, 0, t2975 + t2988);
  tv3rholapl25 = t2990 * t3 + t831;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  t2992 = t835 * t263;
  t2993 = t2992 * t2256;
  t2996 = t2645 * t2455;
  t2999 = t2463 * t2658;
  t3003 = t835 * t111 * t986;
  t3006 = t1739 * t999;
  t3007 = t3006 * t2658;
  t3012 = t2653 * t2455;
  t3015 = t572 * t265;
  t3016 = t3015 * t2658;
  t3019 = t835 * t43;
  t3020 = t3019 * t2239;
  t3023 = t2021 * t839;
  t3026 = t640 * t2872;
  t3031 = t2041 * t843;
  t3034 = t644 * t2852;
  t3041 = t484 * t2993 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2996 - 0.3e1 / 0.32e2 * t469 * t2999 - t484 * t3003 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t3007 - 0.3e1 / 0.16e2 * t484 * t2999 - t484 * t3012 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3016 + 0.3e1 / 0.16e2 * t484 * t3020 + t484 * t3023 / 0.16e2 + t484 * t3026 / 0.16e2 + t1455 * t844 / 0.16e2 + t484 * t3031 / 0.16e2 + t484 * t3034 / 0.16e2 - t1458 * t832 / 0.32e2 - t1470 * t832 / 0.32e2;
  t3042 = t1775 * t626;
  t3045 = t572 * t2007;
  t3050 = t631 * t199;
  t3051 = t3050 * t290;
  t3054 = t213 * t563;
  t3055 = t3054 * t290;
  t3059 = t1462 * t840 / 0.32e2;
  t3061 = t1462 * t844 / 0.32e2;
  t3063 = t1466 * t832 / 0.64e2;
  t3065 = t1462 * t836 / 0.32e2;
  t3068 = -t469 * t3042 / 0.32e2 - t469 * t3045 / 0.32e2 - t1455 * t836 / 0.16e2 - t484 * t3051 / 0.16e2 - t484 * t3055 / 0.16e2 + t3059 + t3061 - t3063 - t3065 + t1455 * t840 / 0.16e2 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699;
  t3070 = my_piecewise3(t2, 0, t3041 + t3068);
  tv3rholapltau0 = t3 * t3070 + t848;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  t3075 = t1578 * t849 / 0.64e2;
  t3079 = t1589 * t853 / 0.32e2;
  t3083 = t1589 * t857 / 0.32e2;
  t3087 = t1589 * t861 / 0.32e2;
  t3089 = my_piecewise3(t51, 0, -t1574 * t849 / 0.32e2 - t3075 - t2334 - t2336 - t1585 * t853 / 0.16e2 - t3079 + t1585 * t857 / 0.16e2 + t3083 + t1585 * t861 / 0.16e2 + t3087);
  tv3rholapltau3 = t3 * t3089 + t865;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  t3100 = my_piecewise3(t2, 0, -t1548 * t832 / 0.32e2 - t3063 - t2355 - t2316 - t1553 * t836 / 0.16e2 - t3065 + t1553 * t840 / 0.16e2 + t3059 + t1553 * t844 / 0.16e2 + t3061);
  tv3rholapltau4 = t3 * t3100 + t848;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  t3102 = t2758 * t2574;
  t3106 = t852 * t168 * t1337;
  t3109 = t611 * t450;
  t3110 = t3109 * t2763;
  t3113 = t1901 * t1350;
  t3114 = t3113 * t2763;
  t3117 = t852 * t418;
  t3118 = t3117 * t2400;
  t3123 = t2778 * t2574;
  t3126 = t611 * t420;
  t3127 = t3126 * t2763;
  t3130 = t852 * t75;
  t3131 = t3130 * t2374;
  t3136 = t2153 * t856;
  t3139 = t679 * t2956;
  t3144 = t2212 * t860;
  t3147 = t683 * t2962;
  t3152 = -0.3e1 / 0.16e2 * t534 * t3102 - t534 * t3106 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3110 + 0.3e1 / 0.32e2 * t519 * t3114 + t534 * t3118 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3110 - t534 * t3123 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3127 + 0.3e1 / 0.16e2 * t534 * t3131 + t1667 * t857 / 0.16e2 + t534 * t3136 / 0.16e2 + t534 * t3139 / 0.16e2 + t1667 * t861 / 0.16e2 + t534 * t3144 / 0.16e2 + t534 * t3147 / 0.16e2 - t1670 * t849 / 0.32e2;
  t3155 = t1917 * t665;
  t3158 = t611 * t2208;
  t3163 = t670 * t207;
  t3164 = t3163 * t445;
  t3167 = t219 * t602;
  t3168 = t3167 * t445;
  t3171 = -t1674 * t849 / 0.32e2 - t519 * t3155 / 0.32e2 - t519 * t3158 / 0.32e2 - t1667 * t853 / 0.16e2 - t534 * t3164 / 0.16e2 - t534 * t3168 / 0.16e2 - t3079 + t3083 + t3087 - t3075 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t3173 = my_piecewise3(t51, 0, t3152 + t3171);
  tv3rholapltau7 = t3 * t3173 + t865;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3175 = t866 * t111;
  t3176 = t3175 * t986;
  t3179 = t866 * t263;
  t3180 = t3179 * t2265;
  t3183 = t866 * t997;
  t3184 = t3183 * t2256;
  t3187 = t3179 * t2256;
  t3190 = t3183 * t2261;
  t3193 = t866 * t43;
  t3194 = t3193 * t2282;
  t3197 = t644 * t2007;
  t3200 = t3193 * t2239;
  t3204 = t640 * t490 * t631;
  t3210 = t644 * t496 * t631;
  t3213 = t640 * t2007;
  t3216 = t3179 * t2239;
  t3219 = -t484 * t3176 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3180 + 0.3e1 / 0.32e2 * t469 * t3184 + t484 * t3187 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3190 - t484 * t3194 / 0.8e1 - t484 * t3197 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t3200 + t484 * t3204 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t3180 + t484 * t3210 / 0.8e1 - t469 * t3213 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t3216 - t2246;
  t3229 = t1030 * t866 * t269;
  t3233 = t255 * t872 / 0.32e2;
  t3235 = t255 * t875 / 0.32e2;
  t3237 = t255 * t878 / 0.32e2;
  t3239 = t255 * t868 / 0.64e2;
  t3240 = t2254 + t2296 - t2300 - t246 * t872 / 0.16e2 + t246 * t875 / 0.16e2 + t246 * t878 / 0.16e2 - t246 * t868 / 0.32e2 - t99 * t3229 / 0.32e2 - t3233 + t3235 + t3237 - t3239 - t2316 - t2320 - t699;
  t3242 = my_piecewise3(t2, 0, t3219 + t3240);
  tv3rhotau20 = t3 * t3242 + t882;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3247 = t370 * t885 / 0.64e2;
  t3251 = t370 * t889 / 0.32e2;
  t3255 = t370 * t892 / 0.32e2;
  t3259 = t370 * t895 / 0.32e2;
  t3261 = my_piecewise3(t51, 0, -t367 * t885 / 0.32e2 - t3247 - t2334 - t2336 - t367 * t889 / 0.16e2 - t3251 + t367 * t892 / 0.16e2 + t3255 + t367 * t895 / 0.16e2 + t3259);
  tv3rhotau22 = t3 * t3261 + t899;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3272 = my_piecewise3(t2, 0, -t345 * t868 / 0.32e2 - t3239 - t2355 - t2316 - t345 * t872 / 0.16e2 - t3233 + t345 * t875 / 0.16e2 + t3235 + t345 * t878 / 0.16e2 + t3237);
  tv3rhotau23 = t3 * t3272 + t882;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3274 = t883 * t168;
  t3275 = t3274 * t1337;
  t3278 = t883 * t418;
  t3279 = t3278 * t2383;
  t3282 = t883 * t1348;
  t3283 = t3282 * t2400;
  t3286 = t3278 * t2400;
  t3289 = t3282 * t2366;
  t3293 = t679 * t540 * t670;
  t3299 = t683 * t546 * t670;
  t3302 = t883 * t75;
  t3303 = t3302 * t2415;
  t3306 = t679 * t2208;
  t3309 = t3278 * t2374;
  t3312 = t683 * t2208;
  t3315 = t3302 * t2374;
  t3318 = -t534 * t3275 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3279 + 0.3e1 / 0.32e2 * t519 * t3283 + t534 * t3286 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3289 + t534 * t3293 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t3279 + t534 * t3299 / 0.8e1 - t534 * t3303 / 0.8e1 - t519 * t3306 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t3309 - t534 * t3312 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t3315 - t2393;
  t3320 = t1303 * t883 * t424;
  t3331 = t2407 + t2426 - t2430 - t156 * t3320 / 0.32e2 - t409 * t889 / 0.16e2 - t3247 - t3251 + t3255 + t3259 + t409 * t892 / 0.16e2 + t409 * t895 / 0.16e2 - t409 * t885 / 0.32e2 - t2444 - t2336 - t721;
  t3333 = my_piecewise3(t51, 0, t3318 + t3331);
  tv3rhotau25 = t3 * t3333 + t899;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3335 = t690 * t183;
  t3336 = t100 * t3335;
  t3337 = t3336 * t959;
  t3340 = t489 * t2297;
  t3341 = t469 * t3340;
  t3342 = 0.3e1 / 0.32e2 * t3341;
  t3343 = t260 * t3335;
  t3344 = t3343 * t964;
  t3347 = t2293 * t745;
  t3348 = t484 * t3347;
  t3349 = 0.3e1 / 0.16e2 * t3348;
  t3350 = t3336 * t968;
  t3353 = t3336 * t972;
  t3356 = t1023 * t183;
  t3358 = t1026 * t183;
  t3361 = t3356 * t116 / 0.2e1 - t3358 * t116 / 0.2e1 + t185 / 0.2e1;
  t3363 = t3361 * t690 * t269;
  t3366 = t695 * t183;
  t3367 = t3366 * t290;
  t3368 = t484 * t3367;
  t3369 = 0.3e1 / 0.16e2 * t3368;
  t3370 = t3336 * t986;
  t3373 = t3343 * t972;
  t3376 = t3343 * t1001;
  t3379 = t2251 * t741;
  t3380 = t484 * t3379;
  t3381 = 0.3e1 / 0.16e2 * t3380;
  t3382 = t3336 * t1006;
  t3385 = t3336 * t1013;
  t3388 = -t99 * t3337 / 0.8e1 - t3342 + 0.3e1 / 0.32e2 * t99 * t3344 + t3349 + 0.3e1 / 0.16e2 * t99 * t3350 - 0.3e1 / 0.16e2 * t99 * t3353 - t99 * t3363 / 0.32e2 - t3369 - t99 * t3370 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3373 + 0.3e1 / 0.32e2 * t99 * t3376 + t3381 + t99 * t3382 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3385 - t699;
  t3389 = my_piecewise3(t2, 0, t3388);
  tv3sigma30 = t3 * t3389;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3390 = t712 * t191;
  t3391 = t157 * t3390;
  t3392 = t3391 * t1344;
  t3395 = t3391 * t1376;
  t3398 = t539 * t2427;
  t3399 = t519 * t3398;
  t3400 = 0.3e1 / 0.32e2 * t3399;
  t3401 = t415 * t3390;
  t3402 = t3401 * t1382;
  t3405 = t2423 * t762;
  t3406 = t534 * t3405;
  t3407 = 0.3e1 / 0.16e2 * t3406;
  t3408 = t3391 * t1369;
  t3411 = t1296 * t191;
  t3413 = t1299 * t191;
  t3416 = t3411 * t173 / 0.2e1 - t3413 * t173 / 0.2e1 + t193 / 0.2e1;
  t3418 = t3416 * t712 * t424;
  t3421 = t717 * t191;
  t3422 = t3421 * t445;
  t3423 = t534 * t3422;
  t3424 = 0.3e1 / 0.16e2 * t3423;
  t3425 = t3391 * t1337;
  t3428 = t3401 * t1344;
  t3431 = t3401 * t1352;
  t3434 = t2404 * t758;
  t3435 = t534 * t3434;
  t3436 = 0.3e1 / 0.16e2 * t3435;
  t3437 = t3391 * t1357;
  t3440 = t3391 * t1364;
  t3443 = -0.3e1 / 0.16e2 * t156 * t3392 - t156 * t3395 / 0.8e1 - t3400 + 0.3e1 / 0.32e2 * t156 * t3402 + t3407 + 0.3e1 / 0.16e2 * t156 * t3408 - t156 * t3418 / 0.32e2 - t3424 - t156 * t3425 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3428 + 0.3e1 / 0.32e2 * t156 * t3431 + t3436 + t156 * t3437 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3440 - t721;
  t3444 = my_piecewise3(t51, 0, t3443);
  tv3sigma39 = t3 * t3444;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3445 = t496 * t695;
  t3446 = t576 * t3445;
  t3447 = t484 * t3446;
  t3448 = t3447 / 0.16e2;
  t3449 = t199 * t695;
  t3450 = t3449 * t290;
  t3451 = t484 * t3450;
  t3452 = t3451 / 0.16e2;
  t3453 = t490 * t695;
  t3454 = t572 * t3453;
  t3455 = t484 * t3454;
  t3456 = t3455 / 0.16e2;
  t3457 = t26 * t3361;
  t3458 = t23 * t3457;
  t3461 = t2251 * t558;
  t3462 = t469 * t3461;
  t3463 = t3462 / 0.32e2;
  t3464 = t3341 / 0.16e2;
  t3465 = t3348 / 0.8e1;
  t3466 = t1432 * t690;
  t3467 = t572 * t3466;
  t3470 = t1516 * t690;
  t3471 = t576 * t3470;
  t3474 = t2255 * t1719;
  t3477 = t199 * t690;
  t3478 = t3477 * t968;
  t3481 = t3368 / 0.8e1;
  t3482 = t3477 * t986;
  t3485 = t3380 / 0.8e1;
  t3488 = t2260 * t1732;
  t3491 = t3477 * t1006;
  t3494 = t1450 * t690;
  t3495 = t1739 * t3494;
  t3498 = t3448 - t3452 + t3456 - t3458 * t734 / 0.32e2 - t3463 - t3464 + t3465 - 0.3e1 / 0.16e2 * t484 * t3467 - t484 * t3471 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3474 + 0.3e1 / 0.16e2 * t484 * t3478 - t3481 - t484 * t3482 / 0.16e2 + t3485 - 0.3e1 / 0.32e2 * t469 * t3467 + 0.3e1 / 0.32e2 * t469 * t3488 + t484 * t3491 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3495 - t699;
  t3499 = my_piecewise3(t2, 0, t3498);
  tv3sigma2lapl0 = t3 * t3499;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3500 = t207 * t717;
  t3501 = t3500 * t445;
  t3502 = t534 * t3501;
  t3503 = t3502 / 0.16e2;
  t3504 = t540 * t717;
  t3505 = t611 * t3504;
  t3506 = t534 * t3505;
  t3507 = t3506 / 0.16e2;
  t3508 = t546 * t717;
  t3509 = t615 * t3508;
  t3510 = t534 * t3509;
  t3511 = t3510 / 0.16e2;
  t3512 = t26 * t3416;
  t3513 = t60 * t3512;
  t3516 = t2404 * t597;
  t3517 = t519 * t3516;
  t3518 = t3517 / 0.32e2;
  t3519 = t3399 / 0.16e2;
  t3520 = t3406 / 0.8e1;
  t3521 = t1628 * t712;
  t3522 = t611 * t3521;
  t3525 = t1633 * t712;
  t3526 = t615 * t3525;
  t3529 = t2382 * t1924;
  t3532 = t207 * t712;
  t3533 = t3532 * t1369;
  t3536 = t3423 / 0.8e1;
  t3537 = t3435 / 0.8e1;
  t3538 = t3532 * t1337;
  t3543 = t2365 * t1893;
  t3546 = t3532 * t1357;
  t3549 = t1650 * t712;
  t3550 = t1901 * t3549;
  t3553 = -t3503 + t3507 + t3511 - t3513 * t751 / 0.32e2 - t3518 - t3519 + t3520 - 0.3e1 / 0.16e2 * t534 * t3522 - t534 * t3526 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3529 + 0.3e1 / 0.16e2 * t534 * t3533 - t3536 + t3537 - t534 * t3538 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3522 + 0.3e1 / 0.32e2 * t519 * t3543 + t534 * t3546 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3550 - t721;
  t3554 = my_piecewise3(t51, 0, t3553);
  tv3sigma2lapl11 = t3 * t3554;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3555 = t640 * t3453;
  t3556 = t484 * t3555;
  t3557 = t3556 / 0.16e2;
  t3558 = t644 * t3445;
  t3559 = t484 * t3558;
  t3560 = t3559 / 0.16e2;
  t3563 = t2251 * t626;
  t3564 = t469 * t3563;
  t3565 = t3564 / 0.32e2;
  t3566 = t213 * t695;
  t3567 = t3566 * t290;
  t3568 = t484 * t3567;
  t3569 = t3568 / 0.16e2;
  t3570 = t640 * t3466;
  t3573 = t644 * t3470;
  t3576 = t2255 * t2031;
  t3579 = t213 * t690;
  t3580 = t3579 * t968;
  t3583 = t3579 * t986;
  t3588 = t2260 * t1984;
  t3591 = t3579 * t1006;
  t3594 = t1992 * t3494;
  t3597 = t3557 + t3560 - t3458 * t768 / 0.32e2 - t3565 - t3569 - t3464 + t3465 - 0.3e1 / 0.16e2 * t484 * t3570 - t484 * t3573 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3576 + 0.3e1 / 0.16e2 * t484 * t3580 - t3481 - t484 * t3583 / 0.16e2 + t3485 - 0.3e1 / 0.32e2 * t469 * t3570 + 0.3e1 / 0.32e2 * t469 * t3588 + t484 * t3591 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3594 - t699;
  t3598 = my_piecewise3(t2, 0, t3597);
  tv3sigma2tau0 = t3 * t3598;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3599 = t683 * t3508;
  t3600 = t534 * t3599;
  t3601 = t3600 / 0.16e2;
  t3602 = t219 * t717;
  t3603 = t3602 * t445;
  t3604 = t534 * t3603;
  t3605 = t3604 / 0.16e2;
  t3606 = t679 * t3504;
  t3607 = t534 * t3606;
  t3608 = t3607 / 0.16e2;
  t3611 = t2404 * t665;
  t3612 = t519 * t3611;
  t3613 = t3612 / 0.32e2;
  t3614 = t219 * t712;
  t3615 = t3614 * t1369;
  t3618 = t679 * t3521;
  t3621 = t683 * t3525;
  t3624 = t2382 * t2161;
  t3627 = t3614 * t1337;
  t3632 = t2365 * t2174;
  t3635 = t3614 * t1357;
  t3638 = t2181 * t3549;
  t3641 = t3601 - t3605 + t3608 - t3513 * t783 / 0.32e2 - t3613 - t3519 + t3520 + 0.3e1 / 0.16e2 * t534 * t3615 - 0.3e1 / 0.16e2 * t534 * t3618 - t534 * t3621 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3624 - t3536 - t534 * t3627 / 0.16e2 + t3537 - 0.3e1 / 0.32e2 * t519 * t3618 + 0.3e1 / 0.32e2 * t519 * t3632 + t534 * t3635 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3638 - t721;
  t3642 = my_piecewise3(t51, 0, t3641);
  tv3sigma2tau11 = t3 * t3642;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3643 = t2856 * t1523;
  t3646 = t1432 * t183;
  t3647 = t2836 * t3646;
  t3650 = t1516 * t183;
  t3651 = t2856 * t3650;
  t3654 = t2836 * t1523;
  t3657 = t3447 / 0.8e1;
  t3658 = t3451 / 0.8e1;
  t3659 = t3455 / 0.8e1;
  t3660 = t3462 / 0.16e2;
  t3661 = t3341 / 0.32e2;
  t3662 = t3348 / 0.16e2;
  t3664 = t3361 * t798 * t269;
  t3667 = t798 * t183;
  t3668 = t3667 * t986;
  t3671 = t3368 / 0.16e2;
  t3674 = t2840 * t1441;
  t3677 = t2836 * t1441;
  t3680 = t1450 * t183;
  t3681 = t2840 * t3680;
  t3684 = t3380 / 0.16e2;
  t3685 = 0.3e1 / 0.16e2 * t484 * t3643 - 0.3e1 / 0.16e2 * t484 * t3647 - t484 * t3651 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3654 + t3657 - t3658 + t3659 - t3660 - t3661 + t3662 - t99 * t3664 / 0.32e2 - t484 * t3668 / 0.16e2 - t3671 - 0.3e1 / 0.32e2 * t469 * t3647 + 0.3e1 / 0.32e2 * t469 * t3674 + t484 * t3677 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3681 + t3684 - t699;
  t3686 = my_piecewise3(t2, 0, t3685);
  tv3sigmalapl20 = t3 * t3686;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3687 = t1628 * t191;
  t3688 = t2935 * t3687;
  t3691 = t1633 * t191;
  t3692 = t2952 * t3691;
  t3695 = t2935 * t1621;
  t3698 = t2952 * t1621;
  t3701 = t3502 / 0.8e1;
  t3702 = t3506 / 0.8e1;
  t3703 = t3510 / 0.8e1;
  t3704 = t3517 / 0.16e2;
  t3705 = t3399 / 0.32e2;
  t3706 = t3406 / 0.16e2;
  t3708 = t3416 * t815 * t424;
  t3711 = t815 * t191;
  t3712 = t3711 * t1337;
  t3715 = t3423 / 0.16e2;
  t3718 = t2939 * t1642;
  t3721 = t2935 * t1642;
  t3724 = t1650 * t191;
  t3725 = t2939 * t3724;
  t3728 = t3435 / 0.16e2;
  t3729 = -0.3e1 / 0.16e2 * t534 * t3688 - t534 * t3692 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3695 + 0.3e1 / 0.16e2 * t534 * t3698 - t3701 + t3702 + t3703 - t3704 - t3705 + t3706 - t156 * t3708 / 0.32e2 - t534 * t3712 / 0.16e2 - t3715 - 0.3e1 / 0.32e2 * t519 * t3688 + 0.3e1 / 0.32e2 * t519 * t3718 + t534 * t3721 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3725 + t3728 - t721;
  t3730 = my_piecewise3(t51, 0, t3729);
  tv3sigmalapl28 = t3 * t3730;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  t3733 = -t3458 * t832 / 0.32e2 + t3557 + t3560 - t3565 - t3569 + t3448 - t3452 + t3456 - t3463 - t3661 + t3662;
  t3734 = t2454 * t183;
  t3735 = t2666 * t3734;
  t3738 = t2653 * t3734;
  t3741 = t2657 * t183;
  t3742 = t3015 * t3741;
  t3745 = t3019 * t1523;
  t3748 = t835 * t183;
  t3749 = t3748 * t986;
  t3754 = t3006 * t3741;
  t3757 = t2992 * t1441;
  t3760 = t2645 * t3734;
  t3763 = -0.3e1 / 0.16e2 * t484 * t3735 - t484 * t3738 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3742 + 0.3e1 / 0.16e2 * t484 * t3745 - t3671 - t484 * t3749 / 0.16e2 + t3684 - 0.3e1 / 0.32e2 * t469 * t3735 + 0.3e1 / 0.32e2 * t469 * t3754 + t484 * t3757 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3760 - t699;
  t3765 = my_piecewise3(t2, 0, t3733 + t3763);
  tv3sigmalapltau0 = t3 * t3765;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  t3768 = -t3513 * t849 / 0.32e2 + t3601 - t3605 + t3608 - t3613 - t3503 + t3507 + t3511 - t3518 - t3705 + t3706;
  t3769 = t3130 * t1621;
  t3772 = t679 * t450;
  t3773 = t2573 * t191;
  t3774 = t3772 * t3773;
  t3777 = t2778 * t3773;
  t3780 = t2762 * t191;
  t3781 = t3126 * t3780;
  t3784 = t852 * t191;
  t3785 = t3784 * t1337;
  t3790 = t3113 * t3780;
  t3793 = t3117 * t1642;
  t3796 = t2758 * t3773;
  t3799 = 0.3e1 / 0.16e2 * t534 * t3769 - 0.3e1 / 0.16e2 * t534 * t3774 - t534 * t3777 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3781 - t3715 - t534 * t3785 / 0.16e2 + t3728 - 0.3e1 / 0.32e2 * t519 * t3774 + 0.3e1 / 0.32e2 * t519 * t3790 + t534 * t3793 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3796 - t721;
  t3801 = my_piecewise3(t51, 0, t3768 + t3799);
  tv3sigmalapltau11 = t3 * t3801;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3803 = t3361 * t866 * t269;
  t3806 = t3193 * t1523;
  t3809 = t3179 * t3646;
  t3812 = t3193 * t3650;
  t3815 = t3179 * t1523;
  t3818 = t3556 / 0.8e1;
  t3819 = t3559 / 0.8e1;
  t3820 = t3564 / 0.16e2;
  t3821 = t3568 / 0.8e1;
  t3822 = t866 * t183;
  t3823 = t3822 * t986;
  t3828 = t3183 * t1441;
  t3831 = t3179 * t1441;
  t3834 = t3183 * t3680;
  t3837 = -t99 * t3803 / 0.32e2 + 0.3e1 / 0.16e2 * t484 * t3806 - 0.3e1 / 0.16e2 * t484 * t3809 - t484 * t3812 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3815 + t3818 + t3819 - t3820 - t3821 - t3661 + t3662 - t484 * t3823 / 0.16e2 - t3671 - 0.3e1 / 0.32e2 * t469 * t3809 + 0.3e1 / 0.32e2 * t469 * t3828 + t484 * t3831 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3834 + t3684 - t699;
  t3838 = my_piecewise3(t2, 0, t3837);
  tv3sigmatau20 = t3 * t3838;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3840 = t3416 * t883 * t424;
  t3843 = t3302 * t1621;
  t3846 = t3278 * t3687;
  t3849 = t3302 * t3691;
  t3852 = t3278 * t1621;
  t3855 = t3600 / 0.8e1;
  t3856 = t3604 / 0.8e1;
  t3857 = t3607 / 0.8e1;
  t3858 = t3612 / 0.16e2;
  t3859 = t883 * t191;
  t3860 = t3859 * t1337;
  t3865 = t3282 * t1642;
  t3868 = t3278 * t1642;
  t3871 = t3282 * t3724;
  t3874 = -t156 * t3840 / 0.32e2 + 0.3e1 / 0.16e2 * t534 * t3843 - 0.3e1 / 0.16e2 * t534 * t3846 - t534 * t3849 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3852 + t3855 - t3856 + t3857 - t3858 - t3705 + t3706 - t534 * t3860 / 0.16e2 - t3715 - 0.3e1 / 0.32e2 * t519 * t3846 + 0.3e1 / 0.32e2 * t519 * t3865 + t534 * t3868 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3871 + t3728 - t721;
  t3875 = my_piecewise3(t51, 0, t3874);
  tv3sigmatau28 = t3 * t3875;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3876 = t1023 * t199;
  t3878 = t1026 * t199;
  t3881 = t3876 * t116 / 0.2e1 - t3878 * t116 / 0.2e1 + t201 / 0.2e1;
  t3883 = t3881 * t798 * t269;
  t3886 = t798 * t199;
  t3887 = t100 * t3886;
  t3888 = t3887 * t972;
  t3891 = t3887 * t959;
  t3894 = t260 * t3886;
  t3895 = t3894 * t964;
  t3898 = t3887 * t968;
  t3901 = 0.3e1 / 0.16e2 * t3447;
  t3902 = 0.3e1 / 0.16e2 * t3451;
  t3903 = 0.3e1 / 0.16e2 * t3455;
  t3904 = 0.3e1 / 0.32e2 * t3462;
  t3905 = t3887 * t986;
  t3908 = t3894 * t972;
  t3911 = t3894 * t1001;
  t3914 = t3887 * t1006;
  t3917 = t3887 * t1013;
  t3920 = -t99 * t3883 / 0.32e2 - 0.3e1 / 0.16e2 * t99 * t3888 - t99 * t3891 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t3895 + 0.3e1 / 0.16e2 * t99 * t3898 + t3901 - t3902 + t3903 - t3904 - t99 * t3905 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3908 + 0.3e1 / 0.32e2 * t99 * t3911 + t99 * t3914 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3917 - t699;
  t3921 = my_piecewise3(t2, 0, t3920);
  tv3lapl30 = t3 * t3921;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3922 = t1296 * t207;
  t3924 = t1299 * t207;
  t3927 = t3922 * t173 / 0.2e1 - t3924 * t173 / 0.2e1 + t209 / 0.2e1;
  t3929 = t3927 * t815 * t424;
  t3932 = t815 * t207;
  t3933 = t157 * t3932;
  t3934 = t3933 * t1376;
  t3937 = t415 * t3932;
  t3938 = t3937 * t1382;
  t3941 = t3933 * t1369;
  t3944 = t3933 * t1344;
  t3947 = 0.3e1 / 0.16e2 * t3502;
  t3948 = 0.3e1 / 0.16e2 * t3506;
  t3949 = 0.3e1 / 0.16e2 * t3510;
  t3950 = 0.3e1 / 0.32e2 * t3517;
  t3951 = t3933 * t1337;
  t3954 = t3937 * t1344;
  t3957 = t3937 * t1352;
  t3960 = t3933 * t1357;
  t3963 = t3933 * t1364;
  t3966 = -t156 * t3929 / 0.32e2 - t156 * t3934 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t3938 + 0.3e1 / 0.16e2 * t156 * t3941 - 0.3e1 / 0.16e2 * t156 * t3944 - t3947 + t3948 + t3949 - t3950 - t156 * t3951 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3954 + 0.3e1 / 0.32e2 * t156 * t3957 + t156 * t3960 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3963 - t721;
  t3967 = my_piecewise3(t51, 0, t3966);
  tv3lapl33 = t3 * t3967;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  t3968 = t26 * t3881;
  t3969 = t23 * t3968;
  t3972 = t1516 * t798;
  t3973 = t644 * t3972;
  t3976 = t2836 * t2031;
  t3979 = t213 * t798;
  t3980 = t3979 * t968;
  t3984 = t640 * t1432 * t798;
  t3987 = t3979 * t986;
  t3992 = t2840 * t1984;
  t3995 = t3979 * t1006;
  t3998 = t1450 * t798;
  t3999 = t1992 * t3998;
  t4002 = -t3969 * t832 / 0.32e2 + t3557 + t3560 - t3565 - t3569 + t3657 - t3658 + t3659 - t3660 - t484 * t3973 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3976 + 0.3e1 / 0.16e2 * t484 * t3980 - 0.3e1 / 0.16e2 * t484 * t3984 - t484 * t3987 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3984 + 0.3e1 / 0.32e2 * t469 * t3992 + t484 * t3995 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3999 - t699;
  t4003 = my_piecewise3(t2, 0, t4002);
  tv3lapl2tau0 = t3 * t4003;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  t4004 = t26 * t3927;
  t4005 = t60 * t4004;
  t4009 = t679 * t1628 * t815;
  t4012 = t1633 * t815;
  t4013 = t683 * t4012;
  t4016 = t2935 * t2161;
  t4019 = t219 * t815;
  t4020 = t4019 * t1369;
  t4023 = t4019 * t1337;
  t4028 = t2939 * t2174;
  t4031 = t4019 * t1357;
  t4034 = t1650 * t815;
  t4035 = t2181 * t4034;
  t4038 = -t4005 * t849 / 0.32e2 + t3601 - t3605 + t3608 - t3613 - t3701 + t3702 + t3703 - t3704 - 0.3e1 / 0.16e2 * t534 * t4009 - t534 * t4013 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t4016 + 0.3e1 / 0.16e2 * t534 * t4020 - t534 * t4023 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4009 + 0.3e1 / 0.32e2 * t519 * t4028 + t534 * t4031 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4035 - t721;
  t4039 = my_piecewise3(t51, 0, t4038);
  tv3lapl2tau5 = t3 * t4039;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  t4041 = t3881 * t866 * t269;
  t4044 = t3193 * t1719;
  t4048 = t3179 * t1432 * t199;
  t4052 = t3193 * t1516 * t199;
  t4055 = t3179 * t1719;
  t4058 = t866 * t199;
  t4059 = t4058 * t986;
  t4064 = t3183 * t1732;
  t4067 = t3179 * t1732;
  t4071 = t3183 * t1450 * t199;
  t4074 = -t99 * t4041 / 0.32e2 + 0.3e1 / 0.16e2 * t484 * t4044 - 0.3e1 / 0.16e2 * t484 * t4048 - t484 * t4052 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t4055 + t3818 + t3819 - t3820 - t3821 + t3448 - t3452 + t3456 - t3463 - t484 * t4059 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t4048 + 0.3e1 / 0.32e2 * t469 * t4064 + t484 * t4067 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t4071 - t699;
  t4075 = my_piecewise3(t2, 0, t4074);
  tv3lapltau20 = t3 * t4075;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  t4077 = t3927 * t883 * t424;
  t4080 = t3302 * t1924;
  t4083 = t3278 * t1889;
  t4087 = t3302 * t1633 * t207;
  t4090 = t3278 * t1924;
  t4093 = t883 * t207;
  t4094 = t4093 * t1337;
  t4099 = t3282 * t1893;
  t4102 = t3278 * t1893;
  t4106 = t3282 * t1650 * t207;
  t4109 = -t156 * t4077 / 0.32e2 + 0.3e1 / 0.16e2 * t534 * t4080 - 0.3e1 / 0.16e2 * t534 * t4083 - t534 * t4087 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t4090 + t3855 - t3856 + t3857 - t3858 - t3503 + t3507 + t3511 - t3518 - t534 * t4094 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4083 + 0.3e1 / 0.32e2 * t519 * t4099 + t534 * t4102 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4106 - t721;
  t4110 = my_piecewise3(t51, 0, t4109);
  tv3lapltau25 = t3 * t4110;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4111 = t1023 * t213;
  t4113 = t1026 * t213;
  t4116 = t4111 * t116 / 0.2e1 - t4113 * t116 / 0.2e1 + t215 / 0.2e1;
  t4118 = t4116 * t866 * t269;
  t4121 = t866 * t213;
  t4122 = t100 * t4121;
  t4123 = t4122 * t972;
  t4126 = t4122 * t959;
  t4129 = t260 * t4121;
  t4130 = t4129 * t964;
  t4133 = t4122 * t968;
  t4136 = 0.3e1 / 0.16e2 * t3556;
  t4137 = 0.3e1 / 0.16e2 * t3559;
  t4138 = 0.3e1 / 0.32e2 * t3564;
  t4139 = 0.3e1 / 0.16e2 * t3568;
  t4140 = t4122 * t986;
  t4143 = t4129 * t972;
  t4146 = t4129 * t1001;
  t4149 = t4122 * t1006;
  t4152 = t4122 * t1013;
  t4155 = -t99 * t4118 / 0.32e2 - 0.3e1 / 0.16e2 * t99 * t4123 - t99 * t4126 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t4130 + 0.3e1 / 0.16e2 * t99 * t4133 + t4136 + t4137 - t4138 - t4139 - t99 * t4140 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t4143 + 0.3e1 / 0.32e2 * t99 * t4146 + t99 * t4149 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t4152 - t699;
  t4156 = my_piecewise3(t2, 0, t4155);
  tv3tau30 = t3 * t4156;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4157 = t883 * t219;
  t4158 = t157 * t4157;
  t4159 = t4158 * t1344;
  t4162 = t4158 * t1376;
  t4165 = t415 * t4157;
  t4166 = t4165 * t1382;
  t4169 = t4158 * t1369;
  t4172 = t1296 * t219;
  t4174 = t1299 * t219;
  t4177 = t4172 * t173 / 0.2e1 - t4174 * t173 / 0.2e1 + t221 / 0.2e1;
  t4179 = t4177 * t883 * t424;
  t4182 = 0.3e1 / 0.16e2 * t3600;
  t4183 = 0.3e1 / 0.16e2 * t3604;
  t4184 = 0.3e1 / 0.16e2 * t3607;
  t4185 = 0.3e1 / 0.32e2 * t3612;
  t4186 = t4158 * t1337;
  t4189 = t4165 * t1344;
  t4192 = t4165 * t1352;
  t4195 = t4158 * t1357;
  t4198 = t4158 * t1364;
  t4201 = -0.3e1 / 0.16e2 * t156 * t4159 - t156 * t4162 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t4166 + 0.3e1 / 0.16e2 * t156 * t4169 - t156 * t4179 / 0.32e2 + t4182 - t4183 + t4184 - t4185 - t156 * t4186 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t4189 + 0.3e1 / 0.32e2 * t156 * t4192 + t156 * t4195 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t4198 - t721;
  t4202 = my_piecewise3(t51, 0, t4201);
  tv3tau33 = t3 * t4202;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t7, t8, t11, t12, t13;
  double t15, t16, t17, t18, t19, t20, t21, t22;
  double t23, t24, t25, t26, t27, t28, t32, t33;
  double t37, t38, t39, t40, t41, t43, t44, t45;
  double t46, t47, t50, t51, t52, t54, t55, t56;
  double t57, t58, t59, t60, t61, t62, t66, t67;
  double t71, t72, t73, t75, t76, t77, t78, t79;
  double t82, tzk0;

  double t83, t84, t85, t87, t90, t91, t95, t96;
  double t98, t99, t100, t105, t106, t111, t113, t114;
  double t116, t117, t121, t122, t124, t127, t128, t131;
  double t133, t135, tvrho0, t139, t142, t143, t147, t149;
  double t152, t153, t156, t157, t162, t163, t168, t170;
  double t171, t173, t174, t178, tvrho1, t181, t183, t184;
  double t185, t188, tvsigma0, tvsigma1, t189, t191, t192, t193;
  double t196, tvsigma2, t197, t199, t200, t201, t204, tvlapl0;
  double t205, t207, t208, t209, t212, tvlapl1, t213, t214;
  double t215, t218, tvtau0, t219, t220, t221, t224, tvtau1;

  double t227, t228, t231, t232, t233, t236, t240, t241;
  double t244, t246, t251, t252, t254, t255, t256, t258;
  double t260, t261, t263, t264, t265, t266, t267, t268;
  double t269, t270, t278, t283, t285, t288, t289, t290;
  double t291, t294, t295, t296, t297, t298, t301, t302;
  double t306, t307, t308, t311, t314, t318, t319, t322;
  double t324, t326, t328, tv2rho20, t331, t335, t339, t340;
  double t343, t345, t351, t352, t356, t360, t361, t364;
  double t367, t370, t371, t374, tv2rho21, t379, t384, t388;
  double t389, t394, t395, t400, t404, t405, t409, t413;
  double t415, t416, t418, t419, t420, t421, t422, t423;
  double t424, t425, t433, t438, t440, t443, t444, t445;
  double t446, t449, t450, t451, t452, t453, t456, t457;
  double t461, tv2rho22, t467, t468, t469, t470, t471, t472;
  double t473, t476, t478, t480, t483, t484, t485, t486;
  double t489, t490, t491, t492, t495, t496, t497, t498;
  double t502, tv2rhosigma0, tv2rhosigma1, t507, t509, tv2rhosigma2, t514, tv2rhosigma3;
  double tv2rhosigma4, t518, t519, t520, t521, t522, t523, t526;
  double t528, t530, t533, t534, t535, t536, t539, t540;
  double t541, t542, t545, t546, t547, t548, t552, tv2rhosigma5;
  double t557, t558, t559, t563, t565, t568, t569, t572;
  double t573, t576, t577, t581, tv2rholapl0, t586, t588, tv2rholapl1;
  double t593, tv2rholapl2, t597, t598, t602, t604, t607, t608;
  double t611, t612, t615, t616, t620, tv2rholapl3, t625, t626;
  double t627, t631, t633, t636, t637, t640, t641, t644;
  double t645, t649, tv2rhotau0, t654, t656, tv2rhotau1, t661, tv2rhotau2;
  double t665, t666, t670, t672, t675, t676, t679, t680;
  double t683, t684, t688, tv2rhotau3, t690, t692, t695, t697;
  double t699, t700, t701, t704, t707, t711, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t712, t714, t717, t719, t721;
  double t722, t723, t726, t729, t733, tv2sigma25, t734, t737;
  double t738, t741, t742, t745, t746, t750, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t751, t754, t755, t758, t759;
  double t762, t763, t767, tv2sigmalapl5, t768, t771, t772, t775;
  double t778, t782, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t783;
  double t786, t787, t790, t793, t797, tv2sigmatau5, t798, t800;
  double t803, t804, t807, t810, t814, tv2lapl20, tv2lapl21, t815;
  double t817, t820, t821, t824, t827, t831, tv2lapl22, t832;
  double t835, t836, t839, t840, t843, t844, t848, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, t849, t852, t853, t856, t857, t860;
  double t861, t865, tv2lapltau3, t866, t868, t871, t872, t875;
  double t878, t882, tv2tau20, tv2tau21, t883, t885, t888, t889;
  double t892, t895, t899, tv2tau22;

  double t902, t904, t908, t909, t911, t912, t913, t916;
  double t919, t920, t921, t924, t928, t929, t933, t937;
  double t940, t941, t945, t952, t953, t955, t956, t958;
  double t959, t960, t963, t964, t965, t968, t969, t972;
  double t973, t978, t979, t983, t985, t986, t987, t992;
  double t994, t997, t998, t999, t1000, t1001, t1002, t1005;
  double t1006, t1007, t1011, t1012, t1013, t1014, t1017, t1019;
  double t1021, t1022, t1023, t1026, t1030, t1032, t1040, t1045;
  double t1047, t1050, t1053, t1054, t1056, t1058, t1059, t1060;
  double t1063, t1066, t1069, t1073, t1074, t1077, t1079, t1081;
  double t1083, t1085, tv3rho30, t1088, t1089, t1090, t1093, t1098;
  double t1099, t1101, t1105, t1106, t1113, t1114, t1121, t1124;
  double t1126, t1138, t1139, t1140, t1143, t1148, t1150, t1154;
  double t1155, t1159, t1160, t1164, t1167, t1169, t1170, t1171;
  double t1174, tv3rho31, t1177, t1182, t1186, t1190, t1191, t1194;
  double t1196, t1203, t1204, t1209, t1213, t1217, t1218, t1221;
  double t1224, t1227, t1228, t1234, t1238, t1242, t1246, t1250;
  double t1252, t1253, tv3rho32, t1258, t1265, t1269, t1270, t1276;
  double t1279, t1286, t1290, t1291, t1294, t1295, t1296, t1299;
  double t1303, t1305, t1313, t1318, t1320, t1323, t1332, t1333;
  double t1334, t1336, t1337, t1338, t1343, t1344, t1345, t1348;
  double t1349, t1350, t1351, t1352, t1353, t1356, t1357, t1358;
  double t1362, t1363, t1364, t1365, t1368, t1369, t1370, t1373;
  double t1376, t1377, t1382, t1383, t1386, t1387, t1391, t1395;
  double t1399, t1409, t1411, tv3rho33, t1415, t1417, t1419, t1421;
  double t1428, t1431, t1432, t1433, t1434, t1439, t1440, t1441;
  double t1442, t1445, t1446, t1449, t1450, t1451, t1452, t1455;
  double t1458, t1461, t1462, t1463, t1465, t1466, t1467, t1469;
  double t1470, t1473, t1474, t1477, t1478, t1481, t1482, t1485;
  double t1486, t1489, t1490, t1493, t1494, t1499, t1502, t1505;
  double t1507, t1508, t1511, t1516, t1517, t1518, t1521, t1522;
  double t1523, t1524, t1527, t1530, t1532, tv3rho2sigma0, tv3rho2sigma1, t1537;
  double t1540, t1542, tv3rho2sigma2, t1546, t1548, t1553, t1566, t1567;
  double tv3rho2sigma3, tv3rho2sigma4, t1571, t1574, t1577, t1578, t1579, t1583;
  double t1585, t1588, t1589, t1590, t1594, t1598, t1600, t1601;
  double tv3rho2sigma5, t1608, tv3rho2sigma6, tv3rho2sigma7, t1611, t1612, t1615, t1616;
  double t1619, t1620, t1621, t1622, t1625, t1628, t1629, t1630;
  double t1633, t1634, t1635, t1640, t1641, t1642, t1643, t1646;
  double t1649, t1650, t1651, t1652, t1655, t1656, t1659, t1660;
  double t1663, t1664, t1667, t1670, t1673, t1674, t1677, t1678;
  double t1681, t1682, t1688, t1699, t1701, t1703, t1710, t1711;
  double t1714, t1716, tv3rho2sigma8, t1719, t1720, t1723, t1724, t1727;
  double t1732, t1733, t1736, t1739, t1740, t1745, t1748, t1749;
  double t1752, t1753, t1756, t1757, t1766, t1768, t1770, t1773;
  double t1775, t1776, t1779, t1784, t1787, t1790, t1793, t1795;
  double t1798, t1799, t1805, t1808, t1810, t1813, t1815, tv3rho2lapl0;
  double t1820, t1823, t1825, tv3rho2lapl1, t1829, t1847, t1848, tv3rho2lapl2;
  double t1852, t1857, t1861, t1865, t1869, t1873, t1875, t1876;
  double tv3rho2lapl3, t1883, tv3rho2lapl4, t1886, t1889, t1890, t1893, t1894;
  double t1897, t1898, t1901, t1902, t1912, t1917, t1918, t1921;
  double t1924, t1925, t1928, t1934, t1936, t1939, t1944, t1947;
  double t1948, t1951, t1952, t1955, t1956, t1966, t1968, t1973;
  double t1975, tv3rho2lapl5, t1978, t1981, t1984, t1985, t1988, t1989;
  double t1992, t1993, t1998, t2000, t2004, t2007, t2008, t2011;
  double t2013, t2014, t2019, t2021, t2022, t2025, t2026, t2031;
  double t2032, t2035, t2038, t2041, t2042, t2045, t2046, t2049;
  double t2056, t2059, t2061, t2063, t2070, t2072, t2074, tv3rho2tau0;
  double t2079, t2082, t2084, tv3rho2tau1, t2088, t2106, t2107, tv3rho2tau2;
  double t2111, t2116, t2120, t2124, t2128, t2132, t2134, t2135;
  double tv3rho2tau3, t2142, tv3rho2tau4, t2148, t2153, t2154, t2157, t2158;
  double t2161, t2162, t2165, t2168, t2171, t2174, t2175, t2178;
  double t2181, t2182, t2188, t2189, t2192, t2195, t2196, t2205;
  double t2208, t2209, t2212, t2213, t2223, t2225, t2231, t2233;
  double tv3rho2tau5, t2235, t2238, t2239, t2240, t2243, t2244, t2245;
  double t2246, t2248, t2251, t2252, t2253, t2254, t2255, t2256;
  double t2257, t2260, t2261, t2262, t2265, t2266, t2269, t2272;
  double t2273, t2278, t2279, t2282, t2283, t2286, t2289, t2290;
  double t2293, t2294, t2295, t2296, t2297, t2298, t2299, t2300;
  double t2306, t2310, t2312, t2314, t2315, t2316, t2318, t2319;
  double t2320, t2325, t2327, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24;
  double t2332, t2334, t2335, t2336, t2340, t2344, t2348, t2350;
  double tv3rhosigma25, t2355, t2363, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2365, t2366, t2367, t2370, t2373, t2374, t2375, t2378;
  double t2379, t2382, t2383, t2384, t2387, t2390, t2391, t2392;
  double t2393, t2395, t2400, t2401, t2404, t2405, t2406, t2407;
  double t2408, t2411, t2412, t2415, t2416, t2419, t2420, t2423;
  double t2424, t2425, t2426, t2427, t2428, t2429, t2430, t2440;
  double t2443, t2444, t2445, t2447, tv3rhosigma211, t2449, t2450, t2453;
  double t2454, t2455, t2456, t2459, t2460, t2463, t2464, t2465;
  double t2466, t2469, t2470, t2475, t2476, t2479, t2480, t2483;
  double t2484, t2488, t2490, t2492, t2494, t2497, t2498, t2501;
  double t2502, t2505, t2508, t2511, t2516, t2519, t2526, t2529;
  double t2532, t2534, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, t2539;
  double t2543, t2547, t2551, t2553, tv3rhosigmalapl5, t2564, tv3rhosigmalapl6, tv3rhosigmalapl7;
  double tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, t2566, t2567, t2568, t2569, t2572;
  double t2573, t2574, t2575, t2578, t2579, t2582, t2583, t2586;
  double t2587, t2590, t2591, t2594, t2595, t2600, t2601, t2604;
  double t2607, t2612, t2613, t2616, t2617, t2622, t2625, t2626;
  double t2631, t2634, t2641, t2643, tv3rhosigmalapl11, t2645, t2646, t2649;
  double t2650, t2653, t2654, t2657, t2658, t2659, t2662, t2663;
  double t2666, t2667, t2672, t2675, t2676, t2683, t2686, t2691;
  double t2692, t2696, t2697, t2699, t2701, t2703, t2704, t2705;
  double t2710, t2713, t2718, t2721, t2724, t2726, tv3rhosigmatau0, tv3rhosigmatau1;
  double tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, t2731, t2735, t2739, t2743, t2745;
  double tv3rhosigmatau5, t2756, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, t2758;
  double t2759, t2762, t2763, t2764, t2767, t2770, t2771, t2774;
  double t2775, t2778, t2779, t2782, t2785, t2786, t2793, t2794;
  double t2797, t2798, t2803, t2806, t2811, t2812, t2815, t2822;
  double t2825, t2828, t2830, tv3rhosigmatau11, t2832, t2833, t2836, t2837;
  double t2840, t2841, t2844, t2847, t2852, t2853, t2856, t2857;
  double t2860, t2863, t2866, t2869, t2872, t2873, t2876, t2878;
  double t2880, t2882, t2884, t2894, t2897, t2899, tv3rholapl20, tv3rholapl21;
  double t2904, t2908, t2912, t2916, t2918, tv3rholapl22, t2929, tv3rholapl23;
  double tv3rholapl24, t2931, t2932, t2935, t2936, t2939, t2940, t2943;
  double t2946, t2949, t2952, t2953, t2956, t2957, t2962, t2963;
  double t2966, t2969, t2972, t2975, t2981, t2988, t2990, tv3rholapl25;
  double t2992, t2993, t2996, t2999, t3003, t3006, t3007, t3012;
  double t3015, t3016, t3019, t3020, t3023, t3026, t3031, t3034;
  double t3041, t3042, t3045, t3050, t3051, t3054, t3055, t3059;
  double t3061, t3063, t3065, t3068, t3070, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2;
  double t3075, t3079, t3083, t3087, t3089, tv3rholapltau3, t3100, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, t3102, t3106, t3109, t3110, t3113, t3114;
  double t3117, t3118, t3123, t3126, t3127, t3130, t3131, t3136;
  double t3139, t3144, t3147, t3152, t3155, t3158, t3163, t3164;
  double t3167, t3168, t3171, t3173, tv3rholapltau7, t3175, t3176, t3179;
  double t3180, t3183, t3184, t3187, t3190, t3193, t3194, t3197;
  double t3200, t3204, t3210, t3213, t3216, t3219, t3229, t3233;
  double t3235, t3237, t3239, t3240, t3242, tv3rhotau20, tv3rhotau21, t3247;
  double t3251, t3255, t3259, t3261, tv3rhotau22, t3272, tv3rhotau23, tv3rhotau24;
  double t3274, t3275, t3278, t3279, t3282, t3283, t3286, t3289;
  double t3293, t3299, t3302, t3303, t3306, t3309, t3312, t3315;
  double t3318, t3320, t3331, t3333, tv3rhotau25, t3335, t3336, t3337;
  double t3340, t3341, t3342, t3343, t3344, t3347, t3348, t3349;
  double t3350, t3353, t3356, t3358, t3361, t3363, t3366, t3367;
  double t3368, t3369, t3370, t3373, t3376, t3379, t3380, t3381;
  double t3382, t3385, t3388, t3389, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t3390, t3391, t3392;
  double t3395, t3398, t3399, t3400, t3401, t3402, t3405, t3406;
  double t3407, t3408, t3411, t3413, t3416, t3418, t3421, t3422;
  double t3423, t3424, t3425, t3428, t3431, t3434, t3435, t3436;
  double t3437, t3440, t3443, t3444, tv3sigma39, t3445, t3446, t3447;
  double t3448, t3449, t3450, t3451, t3452, t3453, t3454, t3455;
  double t3456, t3457, t3458, t3461, t3462, t3463, t3464, t3465;
  double t3466, t3467, t3470, t3471, t3474, t3477, t3478, t3481;
  double t3482, t3485, t3488, t3491, t3494, t3495, t3498, t3499;
  double tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7;
  double tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, t3500, t3501, t3502, t3503, t3504;
  double t3505, t3506, t3507, t3508, t3509, t3510, t3511, t3512;
  double t3513, t3516, t3517, t3518, t3519, t3520, t3521, t3522;
  double t3525, t3526, t3529, t3532, t3533, t3536, t3537, t3538;
  double t3543, t3546, t3549, t3550, t3553, t3554, tv3sigma2lapl11, t3555;
  double t3556, t3557, t3558, t3559, t3560, t3563, t3564, t3565;
  double t3566, t3567, t3568, t3569, t3570, t3573, t3576, t3579;
  double t3580, t3583, t3588, t3591, t3594, t3597, t3598, tv3sigma2tau0;
  double tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8;
  double tv3sigma2tau9, tv3sigma2tau10, t3599, t3600, t3601, t3602, t3603, t3604;
  double t3605, t3606, t3607, t3608, t3611, t3612, t3613, t3614;
  double t3615, t3618, t3621, t3624, t3627, t3632, t3635, t3638;
  double t3641, t3642, tv3sigma2tau11, t3643, t3646, t3647, t3650, t3651;
  double t3654, t3657, t3658, t3659, t3660, t3661, t3662, t3664;
  double t3667, t3668, t3671, t3674, t3677, t3680, t3681, t3684;
  double t3685, t3686, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24, tv3sigmalapl25;
  double tv3sigmalapl26, tv3sigmalapl27, t3687, t3688, t3691, t3692, t3695, t3698;
  double t3701, t3702, t3703, t3704, t3705, t3706, t3708, t3711;
  double t3712, t3715, t3718, t3721, t3724, t3725, t3728, t3729;
  double t3730, tv3sigmalapl28, t3733, t3734, t3735, t3738, t3741, t3742;
  double t3745, t3748, t3749, t3754, t3757, t3760, t3763, t3765;
  double tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7;
  double tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, t3768, t3769, t3772, t3773, t3774;
  double t3777, t3780, t3781, t3784, t3785, t3790, t3793, t3796;
  double t3799, t3801, tv3sigmalapltau11, t3803, t3806, t3809, t3812, t3815;
  double t3818, t3819, t3820, t3821, t3822, t3823, t3828, t3831;
  double t3834, t3837, t3838, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24;
  double tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t3840, t3843, t3846, t3849, t3852;
  double t3855, t3856, t3857, t3858, t3859, t3860, t3865, t3868;
  double t3871, t3874, t3875, tv3sigmatau28, t3876, t3878, t3881, t3883;
  double t3886, t3887, t3888, t3891, t3894, t3895, t3898, t3901;
  double t3902, t3903, t3904, t3905, t3908, t3911, t3914, t3917;
  double t3920, t3921, tv3lapl30, tv3lapl31, tv3lapl32, t3922, t3924, t3927;
  double t3929, t3932, t3933, t3934, t3937, t3938, t3941, t3944;
  double t3947, t3948, t3949, t3950, t3951, t3954, t3957, t3960;
  double t3963, t3966, t3967, tv3lapl33, t3968, t3969, t3972, t3973;
  double t3976, t3979, t3980, t3984, t3987, t3992, t3995, t3998;
  double t3999, t4002, t4003, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double t4004, t4005, t4009, t4012, t4013, t4016, t4019, t4020;
  double t4023, t4028, t4031, t4034, t4035, t4038, t4039, tv3lapl2tau5;
  double t4041, t4044, t4048, t4052, t4055, t4058, t4059, t4064;
  double t4067, t4071, t4074, t4075, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23;
  double tv3lapltau24, t4077, t4080, t4083, t4087, t4090, t4093, t4094;
  double t4099, t4102, t4106, t4109, t4110, tv3lapltau25, t4111, t4113;
  double t4116, t4118, t4121, t4122, t4123, t4126, t4129, t4130;
  double t4133, t4136, t4137, t4138, t4139, t4140, t4143, t4146;
  double t4149, t4152, t4155, t4156, tv3tau30, tv3tau31, tv3tau32, t4157;
  double t4158, t4159, t4162, t4165, t4166, t4169, t4172, t4174;
  double t4177, t4179, t4182, t4183, t4184, t4185, t4186, t4189;
  double t4192, t4195, t4198, t4201, t4202, tv3tau33;

  double t4205, t4219, t4225, t4227, t4231, t4237, t4238, t4241;
  double t4245, t4261, t4263, t4267, t4273, t4274, t4275, t4277;
  double t4279, t4280, t4281, t4285, t4293, t4295, t4296, t4300;
  double t4301, t4303, t4304, t4306, t4307, t4309, t4315, t4317;
  double t4319, t4323, t4328, t4331, t4337, t4339, t4344, t4346;
  double t4351, t4355, t4359, t4364, t4369, t4371, t4373, t4375;
  double t4377, t4381, t4385, t4395, t4397, t4400, t4402, t4407;
  double t4409, t4414, t4418, t4422, t4428, t4432, t4435, t4437;
  double t4439, t4441, t4452, t4456, t4463, t4470, t4477, t4484;
  double t4501, t4510, t4511, t4524, t4526, t4528, t4530, t4534;
  double t4537, t4538, t4540, t4541, t4547, t4553, t4554, t4557;
  double t4561, t4565, t4567, t4571, t4572, t4574, t4575, t4581;
  double t4586, t4589, t4593, t4597, t4599, t4601, t4605, t4607;
  double tv4rho40, t4624, t4636, t4638, t4640, t4645, t4646, t4648;
  double t4649, t4650, t4659, t4668, t4674, t4676, t4694, t4722;
  double t4723, t4725, t4729, t4733, t4735, t4737, t4738, t4739;
  double t4742, t4759, t4761, t4765, t4769, t4771, t4772, t4773;
  double t4778, t4781, t4782, t4784, t4785, t4786, t4787, t4788;
  double t4790, t4791, tv4rho41, t4802, t4805, t4806, t4822, t4837;
  double t4850, t4854, t4858, t4860, t4867, t4869, t4880, t4883;
  double t4885, t4887, t4889, t4891, t4893, t4895, t4897, t4899;
  double t4901, t4902, t4904, t4905, t4907, t4908, t4924, t4937;
  double t4941, t4945, t4947, t4951, t4953, tv4rho42, t4974, t4978;
  double t4982, t4984, t4993, t4994, t4995, t4997, t4999, t5001;
  double t5011, t5013, t5015, t5017, t5019, t5021, t5023, t5025;
  double t5026, t5028, t5029, t5031, t5033, t5035, t5057, t5062;
  double t5074, t5076, t5078, t5080, t5082, t5090, t5114, t5118;
  double t5122, t5128, t5131, tv4rho43, t5136, t5141, t5148, t5152;
  double t5160, t5161, t5164, t5168, t5178, t5194, t5198, t5216;
  double t5226, t5230, t5231, t5233, t5234, t5235, t5239, t5254;
  double t5262, t5270, t5274, t5281, t5288, t5295, t5302, t5319;
  double t5324, t5333, t5334, t5338, t5342, t5344, t5346, t5351;
  double t5356, t5358, t5362, t5365, t5366, t5370, t5374, t5382;
  double t5389, t5398, t5405, t5411, t5430, t5444, t5453, t5458;
  double t5465, t5469, t5475, t5479, tv4rho44, t5483, t5484, t5488;
  double t5489, t5492, t5494, t5504, t5508, t5509, t5513, t5524;
  double t5526, t5528, t5530, t5531, t5536, t5542, t5546, t5551;
  double t5553, t5557, t5559, t5560, t5564, t5567, t5568, t5570;
  double t5572, t5574, t5580, t5581, t5585, t5587, t5589, t5591;
  double t5595, t5600, t5609, t5610, t5611, t5615, t5616, t5627;
  double t5628, t5629, t5634, t5635, t5636, t5640, t5643, t5644;
  double t5645, t5650, t5651, t5652, t5660, t5662, t5667, t5675;
  double t5700, t5704, t5707, t5717, t5732, t5733, t5734, t5742;
  double t5744, t5746, t5755, t5758, t5759, t5762, t5763, t5765;
  double t5768, t5771, t5773, t5774, t5776, t5781, t5789, t5795;
  double t5797, t5800, t5801, t5803, t5805, t5811, t5816, t5820;
  double tv4rho3sigma0, tv4rho3sigma1, t5825, t5827, t5830, t5832, tv4rho3sigma2, t5834;
  double t5835, t5838, t5840, t5854, t5869, t5874, t5878, t5879;
  double t5881, t5888, t5899, t5917, t5925, t5926, t5933, t5939;
  double t5942, tv4rho3sigma3, tv4rho3sigma4, t5944, t5945, t5947, t5949, t5950;
  double t5953, t5954, t5956, t5958, t5960, t5961, t5964, t5965;
  double t5967, t5973, t5977, t5978, t5983, t5984, t5992, t5994;
  double tv4rho3sigma5, t5998, t6000, t6005, t6020, t6022, tv4rho3sigma6, tv4rho3sigma7;
  double t6025, t6026, t6028, t6030, t6032, t6034, t6036, t6038;
  double t6040, t6042, t6044, t6046, t6048, t6049, t6051, t6053;
  double t6055, t6057, t6059, t6060, t6062, t6064, t6066, t6068;
  double t6070, t6071, t6085, t6092, t6095, t6107, t6124, t6133;
  double t6135, t6137, t6142, t6145, tv4rho3sigma8, t6153, tv4rho3sigma9, tv4rho3sigma10;
  double t6157, t6158, t6165, t6169, t6177, t6181, t6182, t6188;
  double t6189, t6193, t6203, t6207, t6208, t6227, t6228, t6232;
  double t6233, t6234, t6235, t6238, t6239, t6240, t6244, t6247;
  double t6248, t6249, t6254, t6256, t6257, t6258, t6264, t6270;
  double t6287, t6298, t6299, t6300, t6307, t6308, t6329, t6337;
  double t6340, t6343, t6351, t6359, t6369, t6383, t6396, t6408;
  double t6424, t6437, t6447, t6451, tv4rho3sigma11, t6454, t6462, t6469;
  double t6473, t6485, t6489, t6490, t6493, t6499, t6508, t6510;
  double t6514, t6516, t6518, t6520, t6532, t6537, t6541, t6550;
  double t6555, t6559, t6562, t6567, t6571, t6577, t6578, t6580;
  double t6582, t6587, t6595, t6597, t6603, t6611, t6622, t6642;
  double t6646, t6649, t6653, t6655, t6657, t6659, t6661, t6663;
  double t6665, t6667, t6669, t6677, t6679, t6681, t6683, t6685;
  double t6687, t6715, t6720, t6727, t6729, t6738, t6739, t6742;
  double t6747, t6749, t6751, t6755, tv4rho3lapl0, t6760, t6762, t6765;
  double t6767, tv4rho3lapl1, t6769, t6773, t6789, t6802, t6814, t6816;
  double t6829, t6847, t6855, t6856, t6859, t6869, t6872, tv4rho3lapl2;
  double t6874, t6882, t6883, t6888, t6889, t6894, t6896, t6899;
  double t6900, t6903, t6904, t6907, t6908, t6914, t6916, tv4rho3lapl3;
  double t6920, t6940, t6942, tv4rho3lapl4, t6944, t6948, t6950, t6952;
  double t6954, t6956, t6958, t6960, t6962, t6964, t6966, t6968;
  double t6976, t6999, t7001, t7003, t7005, t7007, t7009, t7011;
  double t7013, t7015, t7017, t7019, t7037, t7040, t7042, t7044;
  double t7055, t7058, tv4rho3lapl5, t7066, tv4rho3lapl6, t7069, t7077, t7080;
  double t7090, t7106, t7110, t7117, t7121, t7125, t7126, t7129;
  double t7133, t7136, t7139, t7140, t7143, t7155, t7178, t7184;
  double t7191, t7195, t7231, t7245, t7251, t7268, t7271, t7282;
  double t7296, t7312, t7318, t7334, t7338, tv4rho3lapl7, t7348, t7356;
  double t7361, t7373, t7375, t7379, t7381, t7384, t7386, t7388;
  double t7396, t7398, t7405, t7409, t7417, t7419, t7424, t7426;
  double t7430, t7432, t7434, t7436, t7446, t7448, t7450, t7469;
  double t7473, t7487, t7490, t7499, t7503, t7505, t7506, t7521;
  double t7529, t7530, t7532, t7534, t7536, t7538, t7540, t7557;
  double t7562, t7564, t7572, t7574, t7576, t7584, t7591, t7600;
  double t7601, t7603, t7612, t7615, t7616, t7621, t7630, t7632;
  double t7634, t7636, t7640, tv4rho3tau0, t7645, t7647, t7650, t7652;
  double tv4rho3tau1, t7654, t7658, t7664, t7680, t7682, t7687, t7714;
  double t7732, t7737, t7740, t7751, t7754, t7757, tv4rho3tau2, t7759;
  double t7762, t7771, t7773, t7774, t7781, t7784, t7785, t7788;
  double t7789, t7792, t7793, t7796, t7799, t7801, tv4rho3tau3, t7805;
  double t7825, t7827, tv4rho3tau4, t7829, t7831, t7833, t7835, t7837;
  double t7839, t7841, t7843, t7845, t7847, t7849, t7851, t7853;
  double t7855, t7857, t7859, t7861, t7862, t7864, t7866, t7868;
  double t7870, t7872, t7894, t7922, t7925, t7927, t7929, t7940;
  double t7943, tv4rho3tau5, t7951, tv4rho3tau6, t7968, t7976, t7977, t7985;
  double t7986, t7989, t7997, t8006, t8010, t8016, t8030, t8039;
  double t8043, t8050, t8051, t8054, t8058, t8061, t8076, t8080;
  double t8083, t8090, t8110, t8118, t8145, t8157, t8181, t8197;
  double t8203, t8219, t8223, tv4rho3tau7, t8229, t8233, t8235, t8241;
  double t8242, t8248, t8258, t8261, t8263, t8267, t8269, t8270;
  double t8271, t8272, t8275, t8281, t8286, t8295, t8297, t8299;
  double t8300, t8303, t8305, t8307, t8308, t8310, t8313, t8316;
  double t8320, t8323, t8324, t8328, t8329, t8333, t8334, t8337;
  double t8338, t8341, t8342, t8343, t8355, t8357, t8359, t8366;
  double t8368, t8370, t8376, t8377, t8387, t8389, t8391, t8394;
  double t8396, t8403, t8411, t8422, t8431, t8432, t8435, t8437;
  double t8438, t8441, t8442, t8444, t8452, t8453, t8454, t8455;
  double t8456, t8459, t8468, t8474, t8479, t8483, t8493, t8495;
  double t8497, t8499, t8501, t8502, t8503, t8506, t8512, t8513;
  double t8514, t8519, t8520, t8526, t8528, t8533, t8541, t8542;
  double t8543, t8544, t8545, t8546, t8547, t8551, tv4rho2sigma20, tv4rho2sigma21;
  double tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t8556, t8559, t8561, t8562, t8563;
  double t8565, t8568, t8571, t8574, t8577, t8580, t8583, t8584;
  double t8585, tv4rho2sigma25, t8592, t8598, t8615, t8619, t8621, t8624;
  double t8627, t8634, t8639, t8640, t8641, t8643, t8645, t8647;
  double t8649, t8650, t8659, t8661, t8668, t8670, t8673, tv4rho2sigma26;
  double tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t8675, t8677, t8678, t8679;
  double t8681, t8683, t8685, t8687, t8689, t8691, t8693, t8695;
  double t8696, t8697, t8698, t8699, t8701, t8703, t8704, t8706;
  double t8707, t8708, t8721, t8723, t8731, t8734, t8745, t8756;
  double t8757, t8758, t8760, t8762, t8764, t8765, t8767, t8770;
  double t8773, t8776, t8779, tv4rho2sigma211, t8786, t8787, t8797, t8798;
  double tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t8805, t8806, t8815;
  double t8821, t8831, t8835, t8838, t8839, t8843, t8844, t8849;
  double t8850, t8854, t8856, t8858, t8859, t8862, t8863, t8866;
  double t8867, t8875, t8888, t8889, t8890, t8894, t8898, t8907;
  double t8910, t8914, t8915, t8921, t8923, t8924, t8931, t8940;
  double t8963, t8964, t8972, t8976, t8982, t8992, t9003, t9004;
  double t9007, t9009, t9012, t9017, t9018, t9023, t9024, t9033;
  double t9034, t9038, t9039, t9047, t9054, t9055, t9073, t9076;
  double t9080, t9081, t9082, t9083, t9084, t9085, t9086, t9090;
  double tv4rho2sigma217, t9093, t9094, t9095, t9101, t9104, t9105, t9106;
  double t9111, t9129, t9133, t9141, t9143, t9147, t9165, t9170;
  double t9184, t9189, t9190, t9191, t9198, t9199, t9204, t9226;
  double t9235, t9240, t9248, t9273, t9281, t9297, t9328, t9330;
  double t9332, t9334, t9336, t9338, t9343, t9371, t9373, t9375;
  double t9377, t9378, t9380, t9382, t9384, t9386, t9388, t9390;
  double t9392, t9394, t9395, t9399, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3;
  double tv4rho2sigmalapl4, t9404, t9407, t9410, t9413, t9416, t9419, t9422;
  double t9425, t9426, t9427, tv4rho2sigmalapl5, t9454, t9483, t9485, t9487;
  double t9489, t9491, t9503, t9507, t9510, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8;
  double tv4rho2sigmalapl9, tv4rho2sigmalapl10, t9512, t9514, t9516, t9518, t9520, t9522;
  double t9524, t9526, t9528, t9544, t9553, t9555, t9557, t9559;
  double t9561, t9563, t9565, t9567, t9569, t9571, t9573, t9575;
  double t9577, t9579, t9606, t9608, t9611, tv4rho2sigmalapl11, t9626, t9627;
  double tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, t9640, t9644, t9645;
  double t9646, t9652, t9655, t9656, t9657, t9660, t9664, t9689;
  double t9697, t9714, t9715, t9718, t9719, t9723, t9737, t9738;
  double t9742, t9745, t9769, t9796, t9830, t9875, t9902, t9904;
  double t9905, t9909, tv4rho2sigmalapl17, t9912, t9916, t9920, t9925, t9926;
  double t9930, t9933, t9949, t9953, t9964, t9967, t9969, t9971;
  double t9973, t9974, t9975, t9981, t9983, t9987, t9997, t9998;
  double t10001, t10016, t10022, t10038, t10042, t10064, t10067, t10076;
  double t10081, t10082, t10095, t10117, t10152, t10155, t10156, t10158;
  double t10160, t10162, t10163, t10165, t10167, t10169, t10171, t10173;
  double t10175, t10177, t10179, t10202, t10208, t10210, t10212, t10213;
  double t10217, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, t10222, t10225;
  double t10228, t10231, t10234, t10237, t10240, t10243, t10244, t10245;
  double tv4rho2sigmatau5, t10272, t10275, t10277, t10279, t10305, t10309, t10324;
  double t10325, t10328, tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, t10334;
  double t10336, t10338, t10340, t10356, t10358, t10360, t10362, t10363;
  double t10365, t10385, t10387, t10389, t10391, t10393, t10395, t10397;
  double t10399, t10401, t10403, t10405, t10407, t10409, t10411, t10423;
  double t10426, t10429, tv4rho2sigmatau11, t10444, t10445, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14;
  double tv4rho2sigmatau15, tv4rho2sigmatau16, t10448, t10460, t10461, t10469, t10470, t10473;
  double t10474, t10478, t10482, t10485, t10500, t10529, t10577, t10586;
  double t10587, t10590, t10594, t10614, t10622, t10627, t10639, t10648;
  double t10667, t10674, t10684, t10696, t10697, t10722, t10726, tv4rho2sigmatau17;
  double t10729, t10732, t10735, t10737, t10741, t10757, t10759, t10764;
  double t10765, t10767, t10770, t10774, t10781, t10800, t10803, t10805;
  double t10809, t10811, t10813, t10817, t10821, t10829, t10841, t10843;
  double t10849, t10853, t10883, t10886, t10887, t10907, t10913, t10914;
  double t10928, t10930, t10932, t10934, t10936, t10940, t10941, t10949;
  double t10950, t10952, t10958, t10960, t10964, t10968, tv4rho2lapl20, tv4rho2lapl21;
  double t10973, t10976, t10979, t10982, t10985, t10988, t10991, t10994;
  double t10995, t10996, tv4rho2lapl22, t11025, t11038, t11048, t11050, t11052;
  double t11054, t11058, t11064, t11067, tv4rho2lapl23, tv4rho2lapl24, t11069, t11071;
  double t11073, t11075, t11077, t11079, t11081, t11093, t11095, t11097;
  double t11098, t11100, t11102, t11104, t11122, t11134, t11136, t11138;
  double t11140, t11142, t11143, t11149, t11152, tv4rho2lapl25, t11167, t11168;
  double tv4rho2lapl26, tv4rho2lapl27, t11171, t11180, t11184, t11185, t11190, t11199;
  double t11202, t11214, t11215, t11233, t11251, t11262, t11268, t11271;
  double t11295, t11298, t11307, t11325, t11343, t11344, t11352, t11353;
  double t11379, t11381, t11385, tv4rho2lapl28, t11389, t11391, t11404, t11406;
  double t11408, t11410, t11412, t11414, t11416, t11418, t11420, t11422;
  double t11424, t11425, t11427, t11429, t11432, t11434, t11471, t11496;
  double t11500, t11504, t11507, t11510, t11514, t11518, t11519, t11524;
  double t11530, t11545, t11546, t11550, t11556, t11560, t11575, t11583;
  double t11590, t11595, t11597, t11601, t11602, t11605, t11614, t11616;
  double t11638, t11661, t11663, t11668, t11674, t11676, t11684, t11688;
  double tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, t11693, t11696, t11699, t11702, t11705;
  double t11708, t11711, t11714, t11715, t11716, tv4rho2lapltau3, t11718, t11720;
  double t11722, t11750, t11751, t11766, t11782, t11796, t11799, tv4rho2lapltau4;
  double tv4rho2lapltau5, tv4rho2lapltau6, t11815, t11817, t11819, t11833, t11834, t11836;
  double t11838, t11840, t11842, t11844, t11846, t11848, t11850, t11852;
  double t11858, t11868, t11870, t11872, t11874, t11885, t11887, t11889;
  double t11891, t11893, t11895, t11897, t11900, tv4rho2lapltau7, t11915, t11916;
  double tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, t11961, t11998, t12006, t12016, t12023;
  double t12024, t12027, t12032, t12036, t12048, t12052, t12061, t12062;
  double t12067, t12073, t12083, t12096, t12115, t12123, t12134, t12159;
  double t12163, t12167, t12177, t12186, t12190, tv4rho2lapltau11, t12205, t12214;
  double t12224, t12229, t12231, t12233, t12235, t12243, t12244, t12247;
  double t12263, t12264, t12267, t12275, t12281, t12283, t12285, t12287;
  double t12301, t12303, t12305, t12309, t12321, t12323, t12326, t12348;
  double t12351, t12366, t12371, t12375, t12378, t12383, t12385, t12390;
  double t12391, t12393, t12395, t12397, t12399, t12401, t12407, t12411;
  double t12414, t12421, t12430, t12434, tv4rho2tau20, tv4rho2tau21, t12439, t12442;
  double t12445, t12448, t12451, t12454, t12457, t12460, t12461, t12462;
  double tv4rho2tau22, t12491, t12504, t12514, t12516, t12518, t12520, t12524;
  double t12530, t12533, tv4rho2tau23, tv4rho2tau24, t12541, t12543, t12545, t12547;
  double t12549, t12551, t12563, t12574, t12576, t12578, t12580, t12582;
  double t12584, t12586, t12588, t12596, t12598, t12600, t12602, t12604;
  double t12608, t12615, t12618, tv4rho2tau25, t12633, t12634, tv4rho2tau26, tv4rho2tau27;
  double t12647, t12650, t12677, t12678, t12694, t12717, t12719, t12724;
  double t12729, t12752, t12759, t12778, t12781, t12796, t12801, t12805;
  double t12821, t12822, t12826, t12834, t12846, t12850, tv4rho2tau28, t12852;
  double t12862, t12865, t12870, t12876, t12881, t12886, t12889, t12894;
  double t12897, t12902, t12910, t12914, t12918, t12919, t12923, t12924;
  double t12927, t12928, t12932, t12933, t12934, t12935, t12936, t12937;
  double t12938, t12939, t12941, t12946, t12950, t12954, t12955, t12963;
  double t12967, t12968, t12973, t12983, t12993, t13007, t13008, t13011;
  double t13012, t13013, t13019, t13020, t13023, t13026, t13041, t13050;
  double t13070, t13072, t13074, t13076, t13078, t13080, t13082, t13084;
  double t13085, t13088, t13090, t13093, t13097, t13099, t13100, t13101;
  double t13102, t13105, t13107, t13111, t13113, t13116, t13119, t13123;
  double t13125, t13129, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35;
  double tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t13131, t13133, t13135, t13137, t13139;
  double t13140, t13141, t13142, t13143, t13144, t13145, t13146, t13148;
  double t13150, t13152, t13154, t13156, t13158, t13160, t13161, t13183;
  double t13185, t13187, t13188, t13190, tv4rhosigma39, t13192, t13194, t13196;
  double t13198, t13214, t13221, t13223, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313;
  double tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t13225, t13242, t13246;
  double t13251, t13255, t13260, t13264, t13269, t13277, t13279, t13282;
  double t13284, t13287, t13288, t13289, t13292, t13298, t13302, t13303;
  double t13306, t13307, t13314, t13318, t13319, t13324, t13328, t13330;
  double t13332, t13348, t13353, t13379, t13393, t13394, t13397, t13398;
  double t13399, t13406, t13409, t13412, t13427, t13434, t13436, t13437;
  double t13438, t13440, t13444, t13448, t13450, t13451, t13454, t13456;
  double t13460, t13464, t13468, t13470, t13474, tv4rhosigma319, t13476, t13477;
  double t13479, t13480, t13481, t13485, t13492, t13493, t13495, t13496;
  double t13504, t13512, t13515, t13535, t13536, t13537, t13538, t13540;
  double t13541, t13544, t13545, t13548, t13549, t13551, t13552, t13555;
  double t13557, t13559, t13561, t13563, t13565, t13567, t13568, t13569;
  double t13570, t13571, t13572, t13573, t13574, t13575, t13588, t13590;
  double t13592, t13594, t13595, t13596, t13597, t13598, t13599, t13600;
  double t13601, t13602, t13603, t13604, t13605, t13606, t13607, t13608;
  double t13611, t13612, t13613, t13616, t13625, t13629, t13630, t13631;
  double t13632, t13633, t13634, t13635, t13636, t13637, t13638, t13639;
  double t13646, t13653, t13658, t13661, t13668, t13669, t13673, t13674;
  double t13676, t13677, t13679, t13680, t13683, t13684, t13688, t13700;
  double t13711, t13715, t13716, t13731, t13732, t13733, t13735, t13736;
  double t13737, t13738, t13739, t13740, t13744, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2;
  double tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10;
  double t13764, t13767, t13768, t13769, t13770, t13771, t13772, t13773;
  double t13774, t13776, t13778, t13780, t13782, t13784, t13785, t13787;
  double t13789, t13791, t13793, t13794, t13795, t13796, t13797, t13798;
  double t13799, t13801, t13803, t13804, t13805, t13806, t13807, t13808;
  double t13809, t13810, t13811, t13812, t13813, t13814, t13816, tv4rhosigma2lapl11;
  double t13832, t13833, t13834, t13835, t13836, t13837, t13838, t13841;
  double t13842, t13847, t13848, t13849, t13850, t13851, t13852, t13854;
  double tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19;
  double tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, t13856, t13857, t13859, t13860, t13861;
  double t13882, t13883, t13884, t13885, t13887, t13888, t13891, t13894;
  double t13895, t13896, t13898, t13899, t13900, t13904, t13911, t13912;
  double t13915, t13916, t13932, t13944, t13945, t13946, t13947, t13948;
  double t13949, t13950, t13951, t13952, t13953, t13954, t13957, t13959;
  double t13960, t13962, t13963, t13965, t13966, t13979, t13980, t13981;
  double t13984, t13991, t13992, t14006, t14015, t14017, t14018, t14019;
  double t14020, t14021, t14022, t14023, t14027, t14028, t14032, t14033;
  double t14044, t14045, t14046, t14048, t14049, t14051, t14052, t14055;
  double t14066, t14077, t14078, t14079, t14080, t14081, t14082, t14083;
  double t14084, t14085, t14086, t14087, t14091, tv4rhosigma2lapl23, t14094, t14095;
  double t14096, t14097, t14099, t14100, t14101, t14114, t14115, t14116;
  double t14117, t14119, t14120, t14121, t14122, t14125, t14126, t14127;
  double t14128, t14129, t14132, t14166, t14179, t14181, t14183, t14185;
  double t14187, t14189, t14191, t14193, t14195, t14197, t14198, t14199;
  double t14200, t14201, t14202, t14203, t14204, t14205, t14206, t14207;
  double t14210, t14224, t14225, t14238, t14239, t14240, t14241, t14247;
  double t14251, t14252, t14254, t14255, t14258, t14260, t14261, t14264;
  double t14265, t14269, t14277, t14278, t14279, t14281, t14282, t14285;
  double t14286, t14288, t14289, t14290, t14305, t14325, t14326, t14330;
  double tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7;
  double tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, t14342, t14343, t14344, t14345, t14346;
  double t14347, t14350, t14351, t14353, t14355, t14357, t14359, t14360;
  double t14361, t14363, t14364, t14365, t14366, t14367, t14368, t14369;
  double t14370, t14372, t14382, t14384, t14386, t14388, t14389, t14391;
  double tv4rhosigma2tau11, t14393, t14394, t14395, t14396, t14397, t14398, t14399;
  double t14402, t14403, t14422, t14424, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15;
  double tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, t14426;
  double t14429, t14435, t14442, t14446, t14447, t14456, t14457, t14458;
  double t14459, t14461, t14462, t14463, t14464, t14466, t14467, t14468;
  double t14469, t14472, t14473, t14474, t14475, t14476, t14493, t14515;
  double t14517, t14518, t14520, t14521, t14524, t14525, t14526, t14536;
  double t14538, t14542, t14543, t14557, t14562, t14563, t14564, t14565;
  double t14567, t14568, t14569, t14570, t14575, t14584, t14585, t14587;
  double t14588, t14592, t14593, t14595, t14596, t14597, t14598, t14632;
  double t14636, tv4rhosigma2tau23, t14638, t14639, t14640, t14641, t14642, t14643;
  double t14644, t14645, t14646, t14647, t14648, t14649, t14650, t14651;
  double t14652, t14653, t14654, t14655, t14656, t14657, t14658, t14659;
  double t14660, t14661, t14662, t14663, t14664, t14666, t14675, t14684;
  double t14712, t14721, t14723, t14725, t14727, t14729, t14731, t14733;
  double t14735, t14737, t14745, t14756, t14757, t14758, t14759, t14760;
  double t14761, t14762, t14763, t14764, t14765, t14766, t14767, t14768;
  double t14769, t14771, t14772, t14773, t14774, t14775, t14776, t14778;
  double t14787, t14788, t14791, t14810, t14813, t14815, t14818, t14819;
  double t14857, t14865, t14869, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24;
  double tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, t14871, t14872, t14873, t14874, t14875;
  double t14876, t14877, t14878, t14879, t14880, t14881, t14882, t14883;
  double t14884, t14885, t14886, t14888, t14892, t14893, t14895, t14897;
  double t14899, t14901, t14921, t14923, t14925, t14927, t14928, t14930;
  double tv4rhosigmalapl28, t14932, t14933, t14934, t14935, t14936, t14937, t14938;
  double t14939, t14944, t14961, t14963, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212;
  double tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, t14965, t14966, t14967, t14968;
  double t14969, t14970, t14971, t14972, t14973, t14974, t14975, t14976;
  double t14977, t14978, t14979, t14980, t14981, t14982, t14983, t14993;
  double t14995, t15032, t15046, t15047, t15048, t15049, t15050, t15051;
  double t15058, t15061, t15062, t15063, t15064, t15069, t15077, t15085;
  double t15086, t15089, t15098, t15103, t15106, t15109, t15110, t15130;
  double t15151, t15152, t15153, t15154, t15155, t15156, t15157, t15158;
  double t15159, t15160, t15161, t15165, tv4rhosigmalapl217, t15167, t15168, t15171;
  double t15180, t15186, t15188, t15190, t15192, t15194, t15195, t15199;
  double t15201, t15203, t15205, t15223, t15226, t15229, t15242, t15305;
  double t15319, t15320, t15323, t15325, t15341, t15343, t15364, t15380;
  double t15384, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6;
  double tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, t15386, t15387, t15390, t15394;
  double t15396, t15398, t15400, t15402, t15404, t15406, t15408, t15409;
  double t15411, t15430, t15433, tv4rhosigmalapltau11, t15435, t15438, t15456, t15459;
  double t15462, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18;
  double tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, t15464, t15473, t15475, t15476;
  double t15478, t15487, t15513, t15534, t15573, t15576, t15579, t15590;
  double t15642, t15651, t15653, t15654, t15658, tv4rhosigmalapltau23, t15660, t15661;
  double t15662, t15663, t15664, t15665, t15666, t15667, t15668, t15669;
  double t15670, t15671, t15672, t15673, t15674, t15675, t15676, t15677;
  double t15678, t15680, t15714, t15722, t15726, t15728, t15730, t15732;
  double t15734, t15736, t15738, t15740, t15748, t15761, t15767, t15770;
  double t15778, t15782, t15790, t15791, t15794, t15798, t15801, t15802;
  double t15808, t15812, t15813, t15817, t15824, t15828, t15831, t15844;
  double t15848, t15858, t15859, t15860, t15861, t15862, t15863, t15867;
  double tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27;
  double t15869, t15870, t15871, t15872, t15873, t15874, t15875, t15876;
  double t15878, t15880, t15882, t15883, t15897, t15899, t15901, t15903;
  double t15905, t15907, t15915, t15918, t15920, tv4rhosigmatau28, t15936, t15943;
  double t15944, t15945, t15946, t15947, t15949, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211;
  double tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, t15951, t15952, t15955;
  double t15968, t15969, t15970, t15974, t15983, t15990, t15994, t15998;
  double t16000, t16038, t16044, t16064, t16073, t16081, t16085, t16086;
  double t16089, t16093, t16101, t16110, t16111, t16112, t16113, t16114;
  double t16115, t16116, t16117, t16118, t16119, t16121, t16122, t16123;
  double t16124, t16125, t16126, t16127, t16128, t16129, t16130, t16131;
  double t16135, tv4rhosigmatau217, t16146, t16148, t16149, t16150, t16152, t16154;
  double t16156, t16159, t16169, t16189, t16192, t16195, t16198, t16199;
  double t16223, t16235, t16237, t16238, t16240, t16242, t16244, t16246;
  double t16248, t16249, t16253, t16254, t16257, t16268, t16271, t16276;
  double t16279, t16283, t16297, t16303, t16307, t16314, t16327, t16336;
  double t16343, t16353, t16357, tv4rholapl30, tv4rholapl31, tv4rholapl32, t16363, t16364;
  double t16365, t16366, t16368, t16370, t16372, t16374, t16376, t16378;
  double t16380, t16381, t16403, t16405, t16407, t16408, t16410, tv4rholapl33;
  double t16430, t16437, t16439, tv4rholapl34, tv4rholapl35, tv4rholapl36, t16461, t16465;
  double t16486, t16489, t16492, t16495, t16496, t16520, t16532, t16535;
  double t16538, t16542, t16550, t16551, t16559, t16562, t16574, t16581;
  double t16585, t16589, t16596, t16603, t16608, t16631, t16632, t16636;
  double tv4rholapl37, t16638, t16639, t16641, t16642, t16645, t16654, t16661;
  double t16666, t16670, t16680, t16684, t16691, t16705, t16730, t16745;
  double t16747, t16749, t16751, t16753, t16755, t16757, t16759, t16761;
  double t16763, t16768, t16769, t16781, t16806, t16815, t16816, t16820;
  double tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, t16825, t16827, t16828;
  double t16830, t16834, t16855, t16857, t16859, t16861, t16863, t16865;
  double t16866, t16868, tv4rholapl2tau5, t16884, t16892, t16894, tv4rholapl2tau6, tv4rholapl2tau7;
  double tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, t16896, t16911, t16931, t16940, t16961;
  double t16962, t16965, t16968, t16972, t16991, t16997, t17006, t17014;
  double t17020, t17023, t17036, t17048, t17050, t17051, t17055, tv4rholapl2tau11;
  double t17057, t17058, t17067, t17068, t17080, t17084, t17101, t17104;
  double t17116, t17117, t17136, t17145, t17146, t17150, t17152, t17154;
  double t17156, t17158, t17160, t17162, t17164, t17173, t17181, t17216;
  double t17227, t17228, t17232, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24;
  double t17235, t17239, t17240, t17242, t17244, t17248, t17250, t17252;
  double t17254, t17256, t17258, t17275, t17277, tv4rholapltau25, t17291, t17300;
  double t17302, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, t17304, t17325;
  double t17328, t17345, t17349, t17352, t17353, t17363, t17364, t17382;
  double t17395, t17409, t17449, t17452, t17454, t17455, t17459, tv4rholapltau211;
  double t17470, t17472, t17473, t17474, t17475, t17479, t17480, t17483;
  double t17494, t17499, t17502, t17506, t17511, t17519, t17523, t17537;
  double t17538, t17541, t17569, t17582, t17585, t17588, t17592, t17616;
  double t17627, t17651, t17653, t17655, t17657, t17658, t17661, t17663;
  double t17665, t17667, t17669, t17671, t17678, t17679, t17683, tv4rhotau30;
  double tv4rhotau31, tv4rhotau32, t17689, t17690, t17691, t17692, t17698, t17700;
  double t17702, t17704, t17706, t17707, t17709, t17711, t17713, t17715;
  double t17717, t17734, t17736, tv4rhotau33, t17758, t17763, t17765, tv4rhotau34;
  double tv4rhotau35, tv4rhotau36, t17767, t17771, t17775, t17776, t17779, t17783;
  double t17789, t17816, t17819, t17822, t17826, t17850, t17859, t17861;
  double t17879, t17887, t17892, t17896, t17904, t17928, t17936, t17947;
  double t17951, t17961, t17965, tv4rhotau37, t17967, t17969, t17971, t17974;
  double t17977, t17979, t17980, t17981, t17984, t17986, t17988, t17990;
  double t17993, t17996, t17998, t17999, t18010, t18022, t18023, t18030;
  double t18036, t18037, t18044, t18049, t18056, t18066, t18097, t18098;
  double t18101, t18104, t18107, t18114, t18119, t18121, tv4sigma40, tv4sigma41;
  double tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49;
  double tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t18122, t18123, t18124, t18126;
  double t18128, t18131, t18134, t18137, t18139, t18142, t18145, t18147;
  double t18149, t18151, t18153, t18157, t18158, t18162, t18184, t18192;
  double t18204, t18205, t18212, t18218, t18219, t18226, t18237, t18238;
  double t18241, t18244, t18247, t18257, t18274, t18276, tv4sigma414, t18277;
  double t18279, t18280, t18281, t18282, t18283, t18285, t18286, t18288;
  double t18289, t18292, t18293, t18294, t18298, t18299, t18302, t18305;
  double t18318, t18319, t18331, t18337, t18338, t18339, t18340, t18341;
  double t18342, t18343, t18344, t18346, t18347, t18348, t18349, t18352;
  double t18356, t18357, t18370, t18371, t18373, t18374, t18375, t18376;
  double t18378, t18379, t18380, t18383, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3;
  double tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11;
  double tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, t18394;
  double t18395, t18401, t18402, t18405, t18406, t18409, t18414, t18418;
  double t18422, t18447, t18455, t18458, t18459, t18461, t18462, t18463;
  double t18464, t18465, t18466, t18467, t18469, t18470, t18471, t18473;
  double t18474, t18476, t18477, t18479, t18480, t18482, t18483, t18486;
  double t18487, t18488, t18491, tv4sigma3lapl19, t18492, t18496, t18505, t18509;
  double t18512, t18516, t18543, t18549, t18550, t18554, t18555, t18556;
  double t18557, t18558, t18560, t18561, t18563, t18564, t18565, t18566;
  double t18568, t18569, t18571, t18572, t18574, t18575, t18578, t18579;
  double t18580, t18583, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5;
  double tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13;
  double tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, t18584, t18595, t18597;
  double t18601, t18604, t18630, t18631, t18632, t18645, t18646, t18647;
  double t18648, t18649, t18651, t18652, t18654, t18655, t18656, t18657;
  double t18659, t18660, t18662, t18663, t18665, t18666, t18669, t18670;
  double t18671, t18674, tv4sigma3tau19, t18679, t18680, t18681, t18682, t18683;
  double t18684, t18685, t18686, t18687, t18688, t18689, t18697, t18701;
  double t18702, t18711, t18715, t18723, t18724, t18727, t18731, t18736;
  double t18737, t18738, t18740, t18741, t18743, t18744, t18745, t18747;
  double t18748, t18751, t18752, t18756, t18757, t18764, t18765, t18767;
  double t18768, t18771, t18772, t18773, t18786, t18789, tv4sigma2lapl20, tv4sigma2lapl21;
  double tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29;
  double tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, t18790;
  double t18791, t18792, t18793, t18794, t18795, t18796, t18797, t18798;
  double t18799, t18804, t18806, t18809, t18813, t18817, t18818, t18821;
  double t18828, t18832, t18833, t18840, t18842, t18843, t18846, t18847;
  double t18848, t18850, t18851, t18853, t18854, t18857, t18858, t18859;
  double t18862, t18863, t18870, t18871, t18873, t18874, t18875, t18876;
  double t18893, t18903, t18906, tv4sigma2lapl217, t18907, t18908, t18909, t18910;
  double t18911, t18912, t18918, t18919, t18922, t18925, t18927, t18933;
  double t18936, t18944, t18947, t18950, t18953, t18971, t18974, t18977;
  double t18981, t18990, t19000, t19001, t19002, t19003, t19004, t19005;
  double t19006, t19007, t19008, t19009, t19010, t19011, t19012, t19013;
  double t19016, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6;
  double tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14;
  double tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22;
  double t19019, t19020, t19023, t19026, t19042, t19045, t19046, t19054;
  double t19057, t19060, t19064, t19067, t19070, t19077, t19081, t19084;
  double t19104, t19105, t19106, t19107, t19108, t19109, t19110, t19111;
  double t19112, t19113, t19114, t19115, t19116, t19117, t19118, t19119;
  double t19120, t19121, t19122, t19123, t19126, tv4sigma2lapltau23, t19133, t19140;
  double t19141, t19142, t19146, t19147, t19150, t19151, t19152, t19157;
  double t19158, t19159, t19163, t19175, t19187, t19193, t19194, t19196;
  double t19197, t19200, t19201, t19204, t19205, t19207, t19208, t19213;
  double t19223, t19226, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25;
  double tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213;
  double tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, t19230, t19231, t19233, t19236, t19240;
  double t19243, t19253, t19262, t19263, t19282, t19283, t19284, t19286;
  double t19287, t19288, t19291, t19292, t19294, t19295, t19298, t19299;
  double t19302, t19303, t19308, t19309, t19314, t19324, t19327, tv4sigma2tau217;
  double t19332, t19335, t19336, t19339, t19344, t19350, t19354, t19361;
  double t19382, t19386, t19394, t19406, t19409, t19412, t19415, t19427;
  double t19432, t19437, t19438, t19439, t19440, t19441, t19442, t19443;
  double t19444, t19445, t19446, t19448, t19451, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32;
  double tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310;
  double t19452, t19456, t19463, t19474, t19486, t19489, t19492, t19495;
  double t19507, t19512, t19513, t19514, t19515, t19516, t19517, t19518;
  double t19519, t19520, t19521, t19522, t19526, t19529, t19541, t19551;
  double t19552, t19558, t19567, t19573, t19576, tv4sigmalapl311, t19577, t19581;
  double t19586, t19605, t19606, t19614, t19631, t19633, t19634, t19635;
  double t19636, t19637, t19638, t19639, t19640, t19641, t19643, t19654;
  double t19665, t19668, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5;
  double tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13;
  double tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, t19669, t19676, t19688, t19691, t19710;
  double t19716, t19723, t19725, t19726, t19727, t19728, t19729, t19730;
  double t19731, t19732, t19733, t19735, t19743, t19757, t19760, tv4sigmalapl2tau17;
  double t19770, t19771, t19777, t19793, t19818, t19821, t19834, t19839;
  double t19842, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26;
  double tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214;
  double tv4sigmalapltau215, tv4sigmalapltau216, t19847, t19861, t19882, t19885, t19895, t19908;
  double t19911, t19921, t19924, tv4sigmalapltau217, t19925, t19926, t19927, t19928;
  double t19929, t19930, t19931, t19932, t19933, t19934, t19966, t19977;
  double t19979, t19980, t19981, t19985, t20002, t20005, t20008, t20022;
  double t20036, t20039, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35;
  double tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t20040, t20041, t20042;
  double t20043, t20044, t20045, t20046, t20047, t20048, t20049, t20087;
  double t20092, t20094, t20096, t20099, t20100, t20103, t20112, t20116;
  double t20129, t20151, t20154, tv4sigmatau311, t20156, t20157, t20167, t20180;
  double t20221, t20228, t20232, t20239, t20244, t20264, t20266, tv4lapl40;
  double tv4lapl41, tv4lapl42, tv4lapl43, t20268, t20269, t20273, t20289, t20312;
  double t20319, t20323, t20330, t20356, t20376, t20378, tv4lapl44, t20380;
  double t20381, t20382, t20383, t20384, t20385, t20387, t20388, t20389;
  double t20390, t20391, t20392, t20408, t20412, t20423, t20437, t20453;
  double t20456, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6;
  double t20458, t20459, t20460, t20461, t20462, t20463, t20465, t20466;
  double t20467, t20468, t20469, t20480, t20483, t20490, t20501, t20504;
  double t20530, t20533, tv4lapl3tau7, t20538, t20539, t20550, t20555, t20558;
  double t20569, t20576, t20588, t20607, t20610, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22;
  double tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27, t20615, t20616, t20627;
  double t20636, t20640, t20650, t20656, t20670, t20685, t20688, tv4lapl2tau28;
  double t20689, t20715, t20718, t20721, t20733, t20738, t20739, t20742;
  double t20745, t20758, t20773, t20777, t20788, t20798, t20801, tv4lapltau30;
  double tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36, t20802, t20828;
  double t20831, t20834, t20846, t20851, t20852, t20855, t20858, t20870;
  double t20878, t20885, t20910, t20913, tv4lapltau37, t20923, t20924, t20928;
  double t20953, t20957, t20995, t21006, t21013, t21023, t21025, tv4tau40;
  double tv4tau41, tv4tau42, tv4tau43, t21035, t21036, t21040, t21047, t21061;
  double t21072, t21079, t21099, t21135, t21137, tv4tau44;


  t2 = rho[0] <= p->dens_threshold;
  t3 = rho[0] + rho[1];
  t4 = 0.1e1 / t3;
  t7 = 0.2e1 * rho[0] * t4 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t11 = 0.2e1 * rho[1] * t4 <= p->zeta_threshold;
  t12 = -t8;
  t13 = rho[0] - rho[1];
  t15 = my_piecewise5(t7, t8, t11, t12, t13 * t4);
  t16 = 0.1e1 + t15;
  t17 = t16 <= p->zeta_threshold;
  t18 = sqrt(p->zeta_threshold);
  t19 = t18 * p->zeta_threshold;
  t20 = sqrt(t16);
  t21 = t20 * t16;
  t22 = my_piecewise3(t17, t19, t21);
  t23 = M_PI * t22;
  t24 = M_SQRT2;
  t25 = sqrt(t3);
  t26 = t24 * t25;
  t27 = rho[0] * rho[0];
  t28 = 0.1e1 / t27;
  t32 = t27 * rho[0];
  t33 = 0.1e1 / t32;
  t37 = 0.1e1 / M_PI;
  t38 = (lapl[0] * t28 / 0.4e1 - tau[0] * t28 + sigma[0] * t33 / 0.8e1) * t37;
  t39 = -0.9999999999e0 < t38;
  t40 = my_piecewise3(t39, t38, -0.9999999999e0);
  t41 = exp(-0.1e1);
  t43 = LambertW(t40 * t41);
  t44 = t43 + 0.1e1;
  t45 = t44 / 0.2e1;
  t46 = xc_bessel_I0(t45);
  t47 = t26 * t46;
  t50 = my_piecewise3(t2, 0, -t23 * t47 / 0.8e1);
  t51 = rho[1] <= p->dens_threshold;
  t52 = -t13;
  t54 = my_piecewise5(t11, t8, t7, t12, t52 * t4);
  t55 = 0.1e1 + t54;
  t56 = t55 <= p->zeta_threshold;
  t57 = sqrt(t55);
  t58 = t57 * t55;
  t59 = my_piecewise3(t56, t19, t58);
  t60 = M_PI * t59;
  t61 = rho[1] * rho[1];
  t62 = 0.1e1 / t61;
  t66 = t61 * rho[1];
  t67 = 0.1e1 / t66;
  t71 = (lapl[1] * t62 / 0.4e1 - tau[1] * t62 + sigma[2] * t67 / 0.8e1) * t37;
  t72 = -0.9999999999e0 < t71;
  t73 = my_piecewise3(t72, t71, -0.9999999999e0);
  t75 = LambertW(t73 * t41);
  t76 = t75 + 0.1e1;
  t77 = t76 / 0.2e1;
  t78 = xc_bessel_I0(t77);
  t79 = t26 * t78;
  t82 = my_piecewise3(t51, 0, -t60 * t79 / 0.8e1);
  tzk0 = t50 + t82;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t83 = t3 * t3;
  t84 = 0.1e1 / t83;
  t85 = t13 * t84;
  t87 = my_piecewise5(t7, 0, t11, 0, t4 - t85);
  t90 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t87);
  t91 = M_PI * t90;
  t95 = t24 / t25;
  t96 = t95 * t46;
  t98 = t23 * t96 / 0.16e2;
  t99 = t23 * t26;
  t100 = xc_bessel_I1(t45);
  t105 = t27 * t27;
  t106 = 0.1e1 / t105;
  t111 = my_piecewise3(t39, (-lapl[0] * t33 / 0.2e1 + 0.2e1 * tau[0] * t33 - 0.3e1 / 0.8e1 * sigma[0] * t106) * t37, 0);
  t113 = 0.1e1 / t44;
  t114 = t43 * t113;
  t116 = t114 / t40;
  t117 = t100 * t111 * t116;
  t121 = my_piecewise3(t2, 0, -t91 * t47 / 0.8e1 - t98 - t99 * t117 / 0.16e2);
  t122 = t52 * t84;
  t124 = my_piecewise5(t11, 0, t7, 0, -t4 - t122);
  t127 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t124);
  t128 = M_PI * t127;
  t131 = t95 * t78;
  t133 = t60 * t131 / 0.16e2;
  t135 = my_piecewise3(t51, 0, -t128 * t79 / 0.8e1 - t133);
  tvrho0 = t50 + t82 + t3 * (t121 + t135);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t139 = my_piecewise5(t7, 0, t11, 0, -t4 - t85);
  t142 = my_piecewise3(t17, 0, 0.3e1 / 0.2e1 * t20 * t139);
  t143 = M_PI * t142;
  t147 = my_piecewise3(t2, 0, -t143 * t47 / 0.8e1 - t98);
  t149 = my_piecewise5(t11, 0, t7, 0, t4 - t122);
  t152 = my_piecewise3(t56, 0, 0.3e1 / 0.2e1 * t57 * t149);
  t153 = M_PI * t152;
  t156 = t60 * t26;
  t157 = xc_bessel_I1(t77);
  t162 = t61 * t61;
  t163 = 0.1e1 / t162;
  t168 = my_piecewise3(t72, (-lapl[1] * t67 / 0.2e1 + 0.2e1 * tau[1] * t67 - 0.3e1 / 0.8e1 * sigma[2] * t163) * t37, 0);
  t170 = 0.1e1 / t76;
  t171 = t75 * t170;
  t173 = t171 / t73;
  t174 = t157 * t168 * t173;
  t178 = my_piecewise3(t51, 0, -t153 * t79 / 0.8e1 - t133 - t156 * t174 / 0.16e2);
  tvrho1 = t50 + t82 + t3 * (t147 + t178);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t181 = t33 * t37;
  t183 = my_piecewise3(t39, t181 / 0.8e1, 0);
  t184 = t100 * t183;
  t185 = t184 * t116;
  t188 = my_piecewise3(t2, 0, -t99 * t185 / 0.16e2);
  tvsigma0 = t3 * t188;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t189 = t67 * t37;
  t191 = my_piecewise3(t72, t189 / 0.8e1, 0);
  t192 = t157 * t191;
  t193 = t192 * t173;
  t196 = my_piecewise3(t51, 0, -t156 * t193 / 0.16e2);
  tvsigma2 = t3 * t196;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t197 = t28 * t37;
  t199 = my_piecewise3(t39, t197 / 0.4e1, 0);
  t200 = t100 * t199;
  t201 = t200 * t116;
  t204 = my_piecewise3(t2, 0, -t99 * t201 / 0.16e2);
  tvlapl0 = t3 * t204;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t205 = t62 * t37;
  t207 = my_piecewise3(t72, t205 / 0.4e1, 0);
  t208 = t157 * t207;
  t209 = t208 * t173;
  t212 = my_piecewise3(t51, 0, -t156 * t209 / 0.16e2);
  tvlapl1 = t3 * t212;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t213 = my_piecewise3(t39, -t197, 0);
  t214 = t100 * t213;
  t215 = t214 * t116;
  t218 = my_piecewise3(t2, 0, -t99 * t215 / 0.16e2);
  tvtau0 = t3 * t218;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t219 = my_piecewise3(t72, -t205, 0);
  t220 = t157 * t219;
  t221 = t220 * t173;
  t224 = my_piecewise3(t51, 0, -t156 * t221 / 0.16e2);
  tvtau1 = t3 * t224;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t227 = 0.1e1 / t20;
  t228 = t87 * t87;
  t231 = t83 * t3;
  t232 = 0.1e1 / t231;
  t233 = t13 * t232;
  t236 = my_piecewise5(t7, 0, t11, 0, -0.2e1 * t84 + 0.2e1 * t233);
  t240 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t228 + 0.3e1 / 0.2e1 * t20 * t236);
  t241 = M_PI * t240;
  t244 = t91 * t96;
  t246 = t91 * t26;
  t251 = t24 / t25 / t3;
  t252 = t251 * t46;
  t254 = t23 * t252 / 0.32e2;
  t255 = t23 * t95;
  t256 = t255 * t117;
  t258 = 0.1e1 / t45;
  t260 = -t100 * t258 + t46;
  t261 = t111 * t111;
  t263 = t43 * t43;
  t264 = t44 * t44;
  t265 = 0.1e1 / t264;
  t266 = t263 * t265;
  t267 = t40 * t40;
  t268 = 0.1e1 / t267;
  t269 = t266 * t268;
  t270 = t260 * t261 * t269;
  t278 = 0.1e1 / t105 / rho[0];
  t283 = my_piecewise3(t39, (0.3e1 / 0.2e1 * lapl[0] * t106 - 0.6e1 * tau[0] * t106 + 0.3e1 / 0.2e1 * sigma[0] * t278) * t37, 0);
  t285 = t100 * t283 * t116;
  t288 = t100 * t261;
  t289 = t43 * t265;
  t290 = t289 * t268;
  t291 = t288 * t290;
  t294 = t264 * t44;
  t295 = 0.1e1 / t294;
  t296 = t263 * t295;
  t297 = t296 * t268;
  t298 = t288 * t297;
  t301 = t114 * t268;
  t302 = t288 * t301;
  t306 = my_piecewise3(t2, 0, -t241 * t47 / 0.8e1 - t244 / 0.8e1 - t246 * t117 / 0.8e1 + t254 - t256 / 0.16e2 - t99 * t270 / 0.32e2 - t99 * t285 / 0.16e2 - t99 * t291 / 0.16e2 + t99 * t298 / 0.16e2 + t99 * t302 / 0.16e2);
  t307 = 0.1e1 / t57;
  t308 = t124 * t124;
  t311 = t52 * t232;
  t314 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t84 + 0.2e1 * t311);
  t318 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t308 + 0.3e1 / 0.2e1 * t57 * t314);
  t319 = M_PI * t318;
  t322 = t128 * t131;
  t324 = t251 * t78;
  t326 = t60 * t324 / 0.32e2;
  t328 = my_piecewise3(t51, 0, -t319 * t79 / 0.8e1 - t322 / 0.8e1 + t326);
  tv2rho20 = 0.2e1 * t121 + 0.2e1 * t135 + t3 * (t306 + t328);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t331 = t227 * t139;
  t335 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t233);
  t339 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t331 * t87 + 0.3e1 / 0.2e1 * t20 * t335);
  t340 = M_PI * t339;
  t343 = t143 * t96;
  t345 = t143 * t26;
  t351 = my_piecewise3(t2, 0, -t340 * t47 / 0.8e1 - t343 / 0.16e2 - t345 * t117 / 0.16e2 - t244 / 0.16e2 + t254 - t256 / 0.32e2);
  t352 = t307 * t149;
  t356 = my_piecewise5(t11, 0, t7, 0, 0.2e1 * t311);
  t360 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t352 * t124 + 0.3e1 / 0.2e1 * t57 * t356);
  t361 = M_PI * t360;
  t364 = t153 * t131;
  t367 = t128 * t26;
  t370 = t60 * t95;
  t371 = t370 * t174;
  t374 = my_piecewise3(t51, 0, -t361 * t79 / 0.8e1 - t364 / 0.16e2 - t322 / 0.16e2 + t326 - t367 * t174 / 0.16e2 - t371 / 0.32e2);
  tv2rho21 = t121 + t135 + t147 + t178 + t3 * (t351 + t374);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t379 = t139 * t139;
  t384 = my_piecewise5(t7, 0, t11, 0, 0.2e1 * t84 + 0.2e1 * t233);
  t388 = my_piecewise3(t17, 0, 0.3e1 / 0.4e1 * t227 * t379 + 0.3e1 / 0.2e1 * t20 * t384);
  t389 = M_PI * t388;
  t394 = my_piecewise3(t2, 0, -t389 * t47 / 0.8e1 - t343 / 0.8e1 + t254);
  t395 = t149 * t149;
  t400 = my_piecewise5(t11, 0, t7, 0, -0.2e1 * t84 + 0.2e1 * t311);
  t404 = my_piecewise3(t56, 0, 0.3e1 / 0.4e1 * t307 * t395 + 0.3e1 / 0.2e1 * t57 * t400);
  t405 = M_PI * t404;
  t409 = t153 * t26;
  t413 = 0.1e1 / t77;
  t415 = -t157 * t413 + t78;
  t416 = t168 * t168;
  t418 = t75 * t75;
  t419 = t76 * t76;
  t420 = 0.1e1 / t419;
  t421 = t418 * t420;
  t422 = t73 * t73;
  t423 = 0.1e1 / t422;
  t424 = t421 * t423;
  t425 = t415 * t416 * t424;
  t433 = 0.1e1 / t162 / rho[1];
  t438 = my_piecewise3(t72, (0.3e1 / 0.2e1 * lapl[1] * t163 - 0.6e1 * tau[1] * t163 + 0.3e1 / 0.2e1 * sigma[2] * t433) * t37, 0);
  t440 = t157 * t438 * t173;
  t443 = t157 * t416;
  t444 = t75 * t420;
  t445 = t444 * t423;
  t446 = t443 * t445;
  t449 = t419 * t76;
  t450 = 0.1e1 / t449;
  t451 = t418 * t450;
  t452 = t451 * t423;
  t453 = t443 * t452;
  t456 = t171 * t423;
  t457 = t443 * t456;
  t461 = my_piecewise3(t51, 0, -t405 * t79 / 0.8e1 - t364 / 0.8e1 - t409 * t174 / 0.8e1 + t326 - t371 / 0.16e2 - t156 * t425 / 0.32e2 - t156 * t440 / 0.16e2 - t156 * t446 / 0.16e2 + t156 * t453 / 0.16e2 + t156 * t457 / 0.16e2);
  tv2rho22 = 0.2e1 * t147 + 0.2e1 * t178 + t3 * (t394 + t461);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t467 = t255 * t185 / 0.32e2;
  t468 = t26 * t260;
  t469 = t23 * t468;
  t470 = t111 * t263;
  t471 = t265 * t268;
  t472 = t471 * t183;
  t473 = t470 * t472;
  t476 = t106 * t37;
  t478 = my_piecewise3(t39, -0.3e1 / 0.8e1 * t476, 0);
  t480 = t100 * t478 * t116;
  t483 = t26 * t100;
  t484 = t23 * t483;
  t485 = t183 * t111;
  t486 = t485 * t290;
  t489 = t183 * t263;
  t490 = t295 * t268;
  t491 = t490 * t111;
  t492 = t489 * t491;
  t495 = t183 * t43;
  t496 = t113 * t268;
  t497 = t496 * t111;
  t498 = t495 * t497;
  t502 = my_piecewise3(t2, 0, -t246 * t185 / 0.16e2 - t467 - t469 * t473 / 0.32e2 - t99 * t480 / 0.16e2 - t484 * t486 / 0.16e2 + t484 * t492 / 0.16e2 + t484 * t498 / 0.16e2);
  tv2rhosigma0 = t3 * t502 + t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t507 = t370 * t193 / 0.32e2;
  t509 = my_piecewise3(t51, 0, -t367 * t193 / 0.16e2 - t507);
  tv2rhosigma2 = t3 * t509 + t196;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t514 = my_piecewise3(t2, 0, -t345 * t185 / 0.16e2 - t467);
  tv2rhosigma3 = t3 * t514 + t188;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t518 = t26 * t415;
  t519 = t60 * t518;
  t520 = t168 * t418;
  t521 = t420 * t423;
  t522 = t521 * t191;
  t523 = t520 * t522;
  t526 = t163 * t37;
  t528 = my_piecewise3(t72, -0.3e1 / 0.8e1 * t526, 0);
  t530 = t157 * t528 * t173;
  t533 = t26 * t157;
  t534 = t60 * t533;
  t535 = t191 * t168;
  t536 = t535 * t445;
  t539 = t191 * t418;
  t540 = t450 * t423;
  t541 = t540 * t168;
  t542 = t539 * t541;
  t545 = t191 * t75;
  t546 = t170 * t423;
  t547 = t546 * t168;
  t548 = t545 * t547;
  t552 = my_piecewise3(t51, 0, -t409 * t193 / 0.16e2 - t507 - t519 * t523 / 0.32e2 - t156 * t530 / 0.16e2 - t534 * t536 / 0.16e2 + t534 * t542 / 0.16e2 + t534 * t548 / 0.16e2);
  tv2rhosigma5 = t3 * t552 + t196;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t557 = t255 * t201 / 0.32e2;
  t558 = t471 * t199;
  t559 = t470 * t558;
  t563 = my_piecewise3(t39, -t181 / 0.2e1, 0);
  t565 = t100 * t563 * t116;
  t568 = t199 * t111;
  t569 = t568 * t290;
  t572 = t199 * t263;
  t573 = t572 * t491;
  t576 = t199 * t43;
  t577 = t576 * t497;
  t581 = my_piecewise3(t2, 0, -t246 * t201 / 0.16e2 - t557 - t469 * t559 / 0.32e2 - t99 * t565 / 0.16e2 - t484 * t569 / 0.16e2 + t484 * t573 / 0.16e2 + t484 * t577 / 0.16e2);
  tv2rholapl0 = t3 * t581 + t204;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t586 = t370 * t209 / 0.32e2;
  t588 = my_piecewise3(t51, 0, -t367 * t209 / 0.16e2 - t586);
  tv2rholapl1 = t3 * t588 + t212;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t593 = my_piecewise3(t2, 0, -t345 * t201 / 0.16e2 - t557);
  tv2rholapl2 = t3 * t593 + t204;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t597 = t521 * t207;
  t598 = t520 * t597;
  t602 = my_piecewise3(t72, -t189 / 0.2e1, 0);
  t604 = t157 * t602 * t173;
  t607 = t207 * t168;
  t608 = t607 * t445;
  t611 = t207 * t418;
  t612 = t611 * t541;
  t615 = t207 * t75;
  t616 = t615 * t547;
  t620 = my_piecewise3(t51, 0, -t409 * t209 / 0.16e2 - t586 - t519 * t598 / 0.32e2 - t156 * t604 / 0.16e2 - t534 * t608 / 0.16e2 + t534 * t612 / 0.16e2 + t534 * t616 / 0.16e2);
  tv2rholapl3 = t3 * t620 + t212;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t625 = t255 * t215 / 0.32e2;
  t626 = t471 * t213;
  t627 = t470 * t626;
  t631 = my_piecewise3(t39, 0.2e1 * t181, 0);
  t633 = t100 * t631 * t116;
  t636 = t213 * t111;
  t637 = t636 * t290;
  t640 = t213 * t263;
  t641 = t640 * t491;
  t644 = t213 * t43;
  t645 = t644 * t497;
  t649 = my_piecewise3(t2, 0, -t246 * t215 / 0.16e2 - t625 - t469 * t627 / 0.32e2 - t99 * t633 / 0.16e2 - t484 * t637 / 0.16e2 + t484 * t641 / 0.16e2 + t484 * t645 / 0.16e2);
  tv2rhotau0 = t3 * t649 + t218;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t654 = t370 * t221 / 0.32e2;
  t656 = my_piecewise3(t51, 0, -t367 * t221 / 0.16e2 - t654);
  tv2rhotau1 = t3 * t656 + t224;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t661 = my_piecewise3(t2, 0, -t345 * t215 / 0.16e2 - t625);
  tv2rhotau2 = t3 * t661 + t218;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t665 = t521 * t219;
  t666 = t520 * t665;
  t670 = my_piecewise3(t72, 0.2e1 * t189, 0);
  t672 = t157 * t670 * t173;
  t675 = t219 * t168;
  t676 = t675 * t445;
  t679 = t219 * t418;
  t680 = t679 * t541;
  t683 = t219 * t75;
  t684 = t683 * t547;
  t688 = my_piecewise3(t51, 0, -t409 * t221 / 0.16e2 - t654 - t519 * t666 / 0.32e2 - t156 * t672 / 0.16e2 - t534 * t676 / 0.16e2 + t534 * t680 / 0.16e2 + t534 * t684 / 0.16e2);
  tv2rhotau3 = t3 * t688 + t224;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t690 = t183 * t183;
  t692 = t260 * t690 * t269;
  t695 = my_piecewise3(t39, 0, 0);
  t697 = t100 * t695 * t116;
  t699 = t99 * t697 / 0.16e2;
  t700 = t100 * t690;
  t701 = t700 * t290;
  t704 = t700 * t297;
  t707 = t700 * t301;
  t711 = my_piecewise3(t2, 0, -t99 * t692 / 0.32e2 - t699 - t99 * t701 / 0.16e2 + t99 * t704 / 0.16e2 + t99 * t707 / 0.16e2);
  tv2sigma20 = t3 * t711;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t712 = t191 * t191;
  t714 = t415 * t712 * t424;
  t717 = my_piecewise3(t72, 0, 0);
  t719 = t157 * t717 * t173;
  t721 = t156 * t719 / 0.16e2;
  t722 = t157 * t712;
  t723 = t722 * t445;
  t726 = t722 * t452;
  t729 = t722 * t456;
  t733 = my_piecewise3(t51, 0, -t156 * t714 / 0.32e2 - t721 - t156 * t723 / 0.16e2 + t156 * t726 / 0.16e2 + t156 * t729 / 0.16e2);
  tv2sigma25 = t3 * t733;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t734 = t489 * t558;
  t737 = t199 * t183;
  t738 = t737 * t290;
  t741 = t490 * t183;
  t742 = t572 * t741;
  t745 = t496 * t183;
  t746 = t576 * t745;
  t750 = my_piecewise3(t2, 0, -t469 * t734 / 0.32e2 - t699 - t484 * t738 / 0.16e2 + t484 * t742 / 0.16e2 + t484 * t746 / 0.16e2);
  tv2sigmalapl0 = t3 * t750;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t751 = t539 * t597;
  t754 = t207 * t191;
  t755 = t754 * t445;
  t758 = t540 * t191;
  t759 = t611 * t758;
  t762 = t546 * t191;
  t763 = t615 * t762;
  t767 = my_piecewise3(t51, 0, -t519 * t751 / 0.32e2 - t721 - t534 * t755 / 0.16e2 + t534 * t759 / 0.16e2 + t534 * t763 / 0.16e2);
  tv2sigmalapl5 = t3 * t767;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t768 = t489 * t626;
  t771 = t213 * t183;
  t772 = t771 * t290;
  t775 = t640 * t741;
  t778 = t644 * t745;
  t782 = my_piecewise3(t2, 0, -t469 * t768 / 0.32e2 - t699 - t484 * t772 / 0.16e2 + t484 * t775 / 0.16e2 + t484 * t778 / 0.16e2);
  tv2sigmatau0 = t3 * t782;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t783 = t539 * t665;
  t786 = t219 * t191;
  t787 = t786 * t445;
  t790 = t679 * t758;
  t793 = t683 * t762;
  t797 = my_piecewise3(t51, 0, -t519 * t783 / 0.32e2 - t721 - t534 * t787 / 0.16e2 + t534 * t790 / 0.16e2 + t534 * t793 / 0.16e2);
  tv2sigmatau5 = t3 * t797;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t798 = t199 * t199;
  t800 = t260 * t798 * t269;
  t803 = t100 * t798;
  t804 = t803 * t290;
  t807 = t803 * t297;
  t810 = t803 * t301;
  t814 = my_piecewise3(t2, 0, -t99 * t800 / 0.32e2 - t699 - t99 * t804 / 0.16e2 + t99 * t807 / 0.16e2 + t99 * t810 / 0.16e2);
  tv2lapl20 = t3 * t814;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t815 = t207 * t207;
  t817 = t415 * t815 * t424;
  t820 = t157 * t815;
  t821 = t820 * t445;
  t824 = t820 * t452;
  t827 = t820 * t456;
  t831 = my_piecewise3(t51, 0, -t156 * t817 / 0.32e2 - t721 - t156 * t821 / 0.16e2 + t156 * t824 / 0.16e2 + t156 * t827 / 0.16e2);
  tv2lapl22 = t3 * t831;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  t832 = t572 * t626;
  t835 = t213 * t199;
  t836 = t835 * t290;
  t839 = t490 * t199;
  t840 = t640 * t839;
  t843 = t496 * t199;
  t844 = t644 * t843;
  t848 = my_piecewise3(t2, 0, -t469 * t832 / 0.32e2 - t699 - t484 * t836 / 0.16e2 + t484 * t840 / 0.16e2 + t484 * t844 / 0.16e2);
  tv2lapltau0 = t3 * t848;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  t849 = t611 * t665;
  t852 = t219 * t207;
  t853 = t852 * t445;
  t856 = t540 * t207;
  t857 = t679 * t856;
  t860 = t546 * t207;
  t861 = t683 * t860;
  t865 = my_piecewise3(t51, 0, -t519 * t849 / 0.32e2 - t721 - t534 * t853 / 0.16e2 + t534 * t857 / 0.16e2 + t534 * t861 / 0.16e2);
  tv2lapltau3 = t3 * t865;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t866 = t213 * t213;
  t868 = t260 * t866 * t269;
  t871 = t100 * t866;
  t872 = t871 * t290;
  t875 = t871 * t297;
  t878 = t871 * t301;
  t882 = my_piecewise3(t2, 0, -t99 * t868 / 0.32e2 - t699 - t99 * t872 / 0.16e2 + t99 * t875 / 0.16e2 + t99 * t878 / 0.16e2);
  tv2tau20 = t3 * t882;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t883 = t219 * t219;
  t885 = t415 * t883 * t424;
  t888 = t157 * t883;
  t889 = t888 * t445;
  t892 = t888 * t452;
  t895 = t888 * t456;
  t899 = my_piecewise3(t51, 0, -t156 * t885 / 0.32e2 - t721 - t156 * t889 / 0.16e2 + t156 * t892 / 0.16e2 + t156 * t895 / 0.16e2);
  tv2tau22 = t3 * t899;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t902 = t241 * t96;
  t904 = t91 * t252;
  t908 = t24 / t25 / t83;
  t909 = t908 * t46;
  t911 = 0.3e1 / 0.64e2 * t23 * t909;
  t912 = 0.1e1 / t21;
  t913 = t228 * t87;
  t916 = t227 * t87;
  t919 = t83 * t83;
  t920 = 0.1e1 / t919;
  t921 = t13 * t920;
  t924 = my_piecewise5(t7, 0, t11, 0, 0.6e1 * t232 - 0.6e1 * t921);
  t928 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t912 * t913 + 0.9e1 / 0.4e1 * t916 * t236 + 0.3e1 / 0.2e1 * t20 * t924);
  t929 = M_PI * t928;
  t933 = t470 * t471 * t283;
  t937 = t283 * t43 * t497;
  t940 = t283 * t263;
  t941 = t940 * t491;
  t945 = t283 * t111 * t290;
  t952 = t23 * t251;
  t953 = t952 * t117;
  t955 = t261 * t111;
  t956 = t100 * t955;
  t958 = 0.1e1 / t267 / t40;
  t959 = t114 * t958;
  t960 = t956 * t959;
  t963 = t260 * t955;
  t964 = t266 * t958;
  t965 = t963 * t964;
  t968 = t289 * t958;
  t969 = t956 * t968;
  t972 = t296 * t958;
  t973 = t956 * t972;
  t978 = -0.3e1 / 0.16e2 * t902 + 0.3e1 / 0.32e2 * t904 - t911 - t929 * t47 / 0.8e1 - 0.3e1 / 0.32e2 * t469 * t933 + 0.3e1 / 0.16e2 * t484 * t937 + 0.3e1 / 0.16e2 * t484 * t941 - 0.3e1 / 0.16e2 * t484 * t945 - 0.3e1 / 0.16e2 * t246 * t285 - 0.3e1 / 0.32e2 * t246 * t270 + 0.3e1 / 0.64e2 * t953 - t99 * t960 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t965 + 0.3e1 / 0.16e2 * t99 * t969 - 0.3e1 / 0.16e2 * t99 * t973 + 0.3e1 / 0.16e2 * t246 * t302;
  t979 = t255 * t302;
  t983 = t255 * t291;
  t985 = t43 * t295;
  t986 = t985 * t958;
  t987 = t956 * t986;
  t992 = t255 * t298;
  t994 = t963 * t972;
  t997 = t263 * t43;
  t998 = t264 * t264;
  t999 = 0.1e1 / t998;
  t1000 = t997 * t999;
  t1001 = t1000 * t958;
  t1002 = t963 * t1001;
  t1005 = t263 * t999;
  t1006 = t1005 * t958;
  t1007 = t956 * t1006;
  t1011 = 0.1e1 / t998 / t44;
  t1012 = t997 * t1011;
  t1013 = t1012 * t958;
  t1014 = t956 * t1013;
  t1017 = t255 * t285;
  t1019 = t255 * t270;
  t1021 = t45 * t45;
  t1022 = 0.1e1 / t1021;
  t1023 = t1022 * t100;
  t1026 = t258 * t260;
  t1030 = t1023 * t111 * t116 / 0.2e1 - t1026 * t111 * t116 / 0.2e1 + t117 / 0.2e1;
  t1032 = t1030 * t261 * t269;
  t1040 = 0.1e1 / t105 / t27;
  t1045 = my_piecewise3(t39, (-0.6e1 * lapl[0] * t278 + 0.24e2 * tau[0] * t278 - 0.15e2 / 0.2e1 * sigma[0] * t1040) * t37, 0);
  t1047 = t100 * t1045 * t116;
  t1050 = t241 * t26;
  t1053 = t91 * t95;
  t1054 = t1053 * t117;
  t1056 = 0.3e1 / 0.32e2 * t979 - 0.3e1 / 0.16e2 * t246 * t291 - 0.3e1 / 0.32e2 * t983 - t99 * t987 / 0.16e2 + 0.3e1 / 0.16e2 * t246 * t298 + 0.3e1 / 0.32e2 * t992 - 0.3e1 / 0.32e2 * t99 * t994 + 0.3e1 / 0.32e2 * t99 * t1002 + t99 * t1007 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t1014 - 0.3e1 / 0.32e2 * t1017 - 0.3e1 / 0.64e2 * t1019 - t99 * t1032 / 0.32e2 - t99 * t1047 / 0.16e2 - 0.3e1 / 0.16e2 * t1050 * t117 - 0.3e1 / 0.16e2 * t1054;
  t1058 = my_piecewise3(t2, 0, t978 + t1056);
  t1059 = 0.1e1 / t58;
  t1060 = t308 * t124;
  t1063 = t307 * t124;
  t1066 = t52 * t920;
  t1069 = my_piecewise5(t11, 0, t7, 0, -0.6e1 * t232 - 0.6e1 * t1066);
  t1073 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1060 + 0.9e1 / 0.4e1 * t1063 * t314 + 0.3e1 / 0.2e1 * t57 * t1069);
  t1074 = M_PI * t1073;
  t1077 = t319 * t131;
  t1079 = t128 * t324;
  t1081 = t908 * t78;
  t1083 = 0.3e1 / 0.64e2 * t60 * t1081;
  t1085 = my_piecewise3(t51, 0, -t1074 * t79 / 0.8e1 - 0.3e1 / 0.16e2 * t1077 + 0.3e1 / 0.32e2 * t1079 - t1083);
  tv3rho30 = 0.3e1 * t306 + 0.3e1 * t328 + t3 * (t1058 + t1085);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1088 = 0.2e1 * t351;
  t1089 = 0.2e1 * t374;
  t1090 = t912 * t139;
  t1093 = t227 * t335;
  t1098 = 0.2e1 * t232;
  t1099 = 0.6e1 * t921;
  t1101 = my_piecewise5(t7, 0, t11, 0, t1098 - t1099);
  t1105 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1090 * t228 + 0.3e1 / 0.2e1 * t1093 * t87 + 0.3e1 / 0.4e1 * t331 * t236 + 0.3e1 / 0.2e1 * t20 * t1101);
  t1106 = M_PI * t1105;
  t1113 = t340 * t96 / 0.8e1;
  t1114 = t143 * t252;
  t1121 = t340 * t26;
  t1124 = t143 * t95;
  t1126 = t1124 * t117 / 0.16e2;
  t1138 = -t1106 * t47 / 0.8e1 - t983 / 0.32e2 - t345 * t291 / 0.16e2 - t1113 + t1114 / 0.32e2 - t902 / 0.16e2 + t904 / 0.16e2 - t911 + t992 / 0.32e2 + t345 * t298 / 0.16e2 - t1121 * t117 / 0.8e1 - t1126 - t345 * t285 / 0.16e2 - t345 * t270 / 0.32e2 - t1017 / 0.32e2 - t1019 / 0.64e2 - t1054 / 0.16e2 + t953 / 0.32e2 + t345 * t302 / 0.16e2 + t979 / 0.32e2;
  t1139 = my_piecewise3(t2, 0, t1138);
  t1140 = t1059 * t149;
  t1143 = t307 * t356;
  t1148 = 0.6e1 * t1066;
  t1150 = my_piecewise5(t11, 0, t7, 0, -t1098 - t1148);
  t1154 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1140 * t308 + 0.3e1 / 0.2e1 * t1143 * t124 + 0.3e1 / 0.4e1 * t352 * t314 + 0.3e1 / 0.2e1 * t57 * t1150);
  t1155 = M_PI * t1154;
  t1159 = t361 * t131 / 0.8e1;
  t1160 = t153 * t324;
  t1164 = t319 * t26;
  t1167 = t128 * t95;
  t1169 = t1167 * t174 / 0.16e2;
  t1170 = t60 * t251;
  t1171 = t1170 * t174;
  t1174 = my_piecewise3(t51, 0, -t1155 * t79 / 0.8e1 - t1159 + t1160 / 0.32e2 - t1077 / 0.16e2 + t1079 / 0.16e2 - t1083 - t1164 * t174 / 0.16e2 - t1169 + t1171 / 0.64e2);
  tv3rho31 = t306 + t328 + t1088 + t1089 + t3 * (t1139 + t1174);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1177 = t912 * t379;
  t1182 = t227 * t384;
  t1186 = my_piecewise5(t7, 0, t11, 0, -t1098 - t1099);
  t1190 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t1177 * t87 + 0.3e1 / 0.2e1 * t331 * t335 + 0.3e1 / 0.4e1 * t1182 * t87 + 0.3e1 / 0.2e1 * t20 * t1186);
  t1191 = M_PI * t1190;
  t1194 = t389 * t96;
  t1196 = t389 * t26;
  t1203 = my_piecewise3(t2, 0, -t1191 * t47 / 0.8e1 - t1194 / 0.16e2 - t1196 * t117 / 0.16e2 - t1113 + t1114 / 0.16e2 - t1126 + t904 / 0.32e2 - t911 + t953 / 0.64e2);
  t1204 = t1059 * t395;
  t1209 = t307 * t400;
  t1213 = my_piecewise5(t11, 0, t7, 0, t1098 - t1148);
  t1217 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1204 * t124 + 0.3e1 / 0.2e1 * t352 * t356 + 0.3e1 / 0.4e1 * t1209 * t124 + 0.3e1 / 0.2e1 * t57 * t1213);
  t1218 = M_PI * t1217;
  t1221 = t405 * t131;
  t1224 = t361 * t26;
  t1227 = t153 * t95;
  t1228 = t1227 * t174;
  t1234 = t370 * t425;
  t1238 = t370 * t440;
  t1242 = t370 * t446;
  t1246 = t370 * t453;
  t1250 = t370 * t457;
  t1252 = -t1218 * t79 / 0.8e1 - t1221 / 0.16e2 - t1159 + t1160 / 0.16e2 - t1224 * t174 / 0.8e1 - t1228 / 0.16e2 + t1079 / 0.32e2 - t1083 - t1169 + t1171 / 0.32e2 - t367 * t425 / 0.32e2 - t1234 / 0.64e2 - t367 * t440 / 0.16e2 - t1238 / 0.32e2 - t367 * t446 / 0.16e2 - t1242 / 0.32e2 + t367 * t453 / 0.16e2 + t1246 / 0.32e2 + t367 * t457 / 0.16e2 + t1250 / 0.32e2;
  t1253 = my_piecewise3(t51, 0, t1252);
  tv3rho32 = t1088 + t1089 + t394 + t461 + t3 * (t1203 + t1253);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1258 = t379 * t139;
  t1265 = my_piecewise5(t7, 0, t11, 0, -0.6e1 * t232 - 0.6e1 * t921);
  t1269 = my_piecewise3(t17, 0, -0.3e1 / 0.8e1 * t912 * t1258 + 0.9e1 / 0.4e1 * t331 * t384 + 0.3e1 / 0.2e1 * t20 * t1265);
  t1270 = M_PI * t1269;
  t1276 = my_piecewise3(t2, 0, -t1270 * t47 / 0.8e1 - 0.3e1 / 0.16e2 * t1194 + 0.3e1 / 0.32e2 * t1114 - t911);
  t1279 = t395 * t149;
  t1286 = my_piecewise5(t11, 0, t7, 0, 0.6e1 * t232 - 0.6e1 * t1066);
  t1290 = my_piecewise3(t56, 0, -0.3e1 / 0.8e1 * t1059 * t1279 + 0.9e1 / 0.4e1 * t352 * t400 + 0.3e1 / 0.2e1 * t57 * t1286);
  t1291 = M_PI * t1290;
  t1294 = t77 * t77;
  t1295 = 0.1e1 / t1294;
  t1296 = t1295 * t157;
  t1299 = t413 * t415;
  t1303 = t1296 * t168 * t173 / 0.2e1 - t1299 * t168 * t173 / 0.2e1 + t174 / 0.2e1;
  t1305 = t1303 * t416 * t424;
  t1313 = 0.1e1 / t162 / t61;
  t1318 = my_piecewise3(t72, (-0.6e1 * lapl[1] * t433 + 0.24e2 * tau[1] * t433 - 0.15e2 / 0.2e1 * sigma[2] * t1313) * t37, 0);
  t1320 = t157 * t1318 * t173;
  t1323 = t405 * t26;
  t1332 = t416 * t168;
  t1333 = t157 * t1332;
  t1334 = t75 * t450;
  t1336 = 0.1e1 / t422 / t73;
  t1337 = t1334 * t1336;
  t1338 = t1333 * t1337;
  t1343 = t415 * t1332;
  t1344 = t451 * t1336;
  t1345 = t1343 * t1344;
  t1348 = t418 * t75;
  t1349 = t419 * t419;
  t1350 = 0.1e1 / t1349;
  t1351 = t1348 * t1350;
  t1352 = t1351 * t1336;
  t1353 = t1343 * t1352;
  t1356 = t418 * t1350;
  t1357 = t1356 * t1336;
  t1358 = t1333 * t1357;
  t1362 = 0.1e1 / t1349 / t76;
  t1363 = t1348 * t1362;
  t1364 = t1363 * t1336;
  t1365 = t1333 * t1364;
  t1368 = 0.3e1 / 0.32e2 * t1160 - 0.3e1 / 0.16e2 * t1221 - t1291 * t79 / 0.8e1 - t1083 - t156 * t1305 / 0.32e2 - t156 * t1320 / 0.16e2 - 0.3e1 / 0.16e2 * t1323 * t174 - 0.3e1 / 0.16e2 * t409 * t440 - 0.3e1 / 0.32e2 * t409 * t425 - 0.3e1 / 0.16e2 * t409 * t446 - t156 * t1338 / 0.16e2 + 0.3e1 / 0.16e2 * t409 * t453 - 0.3e1 / 0.32e2 * t156 * t1345 + 0.3e1 / 0.32e2 * t156 * t1353 + t156 * t1358 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t1365;
  t1369 = t444 * t1336;
  t1370 = t1333 * t1369;
  t1373 = t1333 * t1344;
  t1376 = t171 * t1336;
  t1377 = t1333 * t1376;
  t1382 = t421 * t1336;
  t1383 = t1343 * t1382;
  t1386 = t438 * t418;
  t1387 = t1386 * t541;
  t1391 = t520 * t521 * t438;
  t1395 = t438 * t75 * t547;
  t1399 = t438 * t168 * t445;
  t1409 = 0.3e1 / 0.16e2 * t156 * t1370 - 0.3e1 / 0.16e2 * t156 * t1373 - t156 * t1377 / 0.8e1 + 0.3e1 / 0.16e2 * t409 * t457 + 0.3e1 / 0.32e2 * t156 * t1383 + 0.3e1 / 0.16e2 * t534 * t1387 - 0.3e1 / 0.32e2 * t519 * t1391 + 0.3e1 / 0.16e2 * t534 * t1395 - 0.3e1 / 0.16e2 * t534 * t1399 + 0.3e1 / 0.64e2 * t1171 - 0.3e1 / 0.16e2 * t1228 - 0.3e1 / 0.64e2 * t1234 - 0.3e1 / 0.32e2 * t1238 - 0.3e1 / 0.32e2 * t1242 + 0.3e1 / 0.32e2 * t1246 + 0.3e1 / 0.32e2 * t1250;
  t1411 = my_piecewise3(t51, 0, t1368 + t1409);
  tv3rho33 = 0.3e1 * t394 + 0.3e1 * t461 + t3 * (t1276 + t1411);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1415 = t255 * t480;
  t1417 = t278 * t37;
  t1419 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t1417, 0);
  t1421 = t100 * t1419 * t116;
  t1428 = t1053 * t185;
  t1431 = t952 * t185 / 0.64e2;
  t1432 = t295 * t958;
  t1433 = t1432 * t261;
  t1434 = t489 * t1433;
  t1439 = t261 * t997;
  t1440 = t999 * t958;
  t1441 = t1440 * t183;
  t1442 = t1439 * t1441;
  t1445 = t183 * t261;
  t1446 = t1445 * t1006;
  t1449 = t183 * t997;
  t1450 = t1011 * t958;
  t1451 = t1450 * t261;
  t1452 = t1449 * t1451;
  t1455 = t91 * t483;
  t1458 = t91 * t468;
  t1461 = t95 * t100;
  t1462 = t23 * t1461;
  t1463 = t1462 * t498;
  t1465 = t95 * t260;
  t1466 = t23 * t1465;
  t1467 = t1466 * t473;
  t1469 = t26 * t1030;
  t1470 = t23 * t1469;
  t1473 = -t1415 / 0.16e2 - t99 * t1421 / 0.16e2 - t1050 * t185 / 0.16e2 - t246 * t480 / 0.8e1 - t1428 / 0.16e2 + t1431 - 0.3e1 / 0.16e2 * t484 * t1434 - 0.3e1 / 0.32e2 * t469 * t1434 + 0.3e1 / 0.32e2 * t469 * t1442 + t484 * t1446 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1452 + t1455 * t498 / 0.8e1 - t1458 * t473 / 0.16e2 + t1463 / 0.16e2 - t1467 / 0.32e2 - t1470 * t473 / 0.32e2;
  t1474 = t940 * t472;
  t1477 = t496 * t283;
  t1478 = t495 * t1477;
  t1481 = t471 * t478;
  t1482 = t470 * t1481;
  t1485 = t478 * t43;
  t1486 = t1485 * t497;
  t1489 = t183 * t283;
  t1490 = t1489 * t290;
  t1493 = t490 * t283;
  t1494 = t489 * t1493;
  t1499 = t1462 * t486;
  t1502 = t478 * t111 * t290;
  t1505 = t1462 * t492;
  t1507 = t478 * t263;
  t1508 = t1507 * t491;
  t1511 = t1445 * t986;
  t1516 = t113 * t958;
  t1517 = t1516 * t261;
  t1518 = t495 * t1517;
  t1521 = t261 * t263;
  t1522 = t265 * t958;
  t1523 = t1522 * t183;
  t1524 = t1521 * t1523;
  t1527 = t1445 * t968;
  t1530 = -t469 * t1474 / 0.32e2 + t484 * t1478 / 0.16e2 - t469 * t1482 / 0.16e2 + t484 * t1486 / 0.8e1 - t484 * t1490 / 0.16e2 + t484 * t1494 / 0.16e2 - t1455 * t486 / 0.8e1 - t1499 / 0.16e2 - t484 * t1502 / 0.8e1 + t1505 / 0.16e2 + t484 * t1508 / 0.8e1 - t484 * t1511 / 0.16e2 + t1455 * t492 / 0.8e1 - t484 * t1518 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1524 + 0.3e1 / 0.16e2 * t484 * t1527;
  t1532 = my_piecewise3(t2, 0, t1473 + t1530);
  tv3rho2sigma0 = t1532 * t3 + 0.2e1 * t502;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1537 = t1167 * t193;
  t1540 = t1170 * t193 / 0.64e2;
  t1542 = my_piecewise3(t51, 0, -t1164 * t193 / 0.16e2 - t1537 / 0.16e2 + t1540);
  tv3rho2sigma2 = t1542 * t3 + 0.2e1 * t509;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1546 = t1124 * t185;
  t1548 = t143 * t468;
  t1553 = t143 * t483;
  t1566 = -t1121 * t185 / 0.16e2 - t1546 / 0.32e2 - t1548 * t473 / 0.32e2 - t345 * t480 / 0.16e2 - t1553 * t486 / 0.16e2 + t1553 * t492 / 0.16e2 + t1553 * t498 / 0.16e2 - t1428 / 0.32e2 + t1431 - t1467 / 0.64e2 - t1415 / 0.32e2 - t1499 / 0.32e2 + t1505 / 0.32e2 + t1463 / 0.32e2;
  t1567 = my_piecewise3(t2, 0, t1566);
  tv3rho2sigma3 = t1567 * t3 + t502 + t514;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1571 = t1227 * t193;
  t1574 = t128 * t518;
  t1577 = t95 * t415;
  t1578 = t60 * t1577;
  t1579 = t1578 * t523;
  t1583 = t370 * t530;
  t1585 = t128 * t533;
  t1588 = t95 * t157;
  t1589 = t60 * t1588;
  t1590 = t1589 * t536;
  t1594 = t1589 * t542;
  t1598 = t1589 * t548;
  t1600 = -t1224 * t193 / 0.16e2 - t1571 / 0.32e2 - t1537 / 0.32e2 + t1540 - t1574 * t523 / 0.32e2 - t1579 / 0.64e2 - t367 * t530 / 0.16e2 - t1583 / 0.32e2 - t1585 * t536 / 0.16e2 - t1590 / 0.32e2 + t1585 * t542 / 0.16e2 + t1594 / 0.32e2 + t1585 * t548 / 0.16e2 + t1598 / 0.32e2;
  t1601 = my_piecewise3(t51, 0, t1600);
  tv3rho2sigma5 = t1601 * t3 + t509 + t552;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1608 = my_piecewise3(t2, 0, -t1196 * t185 / 0.16e2 - t1546 / 0.16e2 + t1431);
  tv3rho2sigma6 = t1608 * t3 + 0.2e1 * t514;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1611 = t528 * t418;
  t1612 = t1611 * t541;
  t1615 = t191 * t416;
  t1616 = t1615 * t1337;
  t1619 = t416 * t418;
  t1620 = t420 * t1336;
  t1621 = t1620 * t191;
  t1622 = t1619 * t1621;
  t1625 = t1615 * t1369;
  t1628 = t450 * t1336;
  t1629 = t1628 * t416;
  t1630 = t539 * t1629;
  t1633 = t170 * t1336;
  t1634 = t1633 * t416;
  t1635 = t545 * t1634;
  t1640 = t416 * t1348;
  t1641 = t1350 * t1336;
  t1642 = t1641 * t191;
  t1643 = t1640 * t1642;
  t1646 = t1615 * t1357;
  t1649 = t191 * t1348;
  t1650 = t1362 * t1336;
  t1651 = t1650 * t416;
  t1652 = t1649 * t1651;
  t1655 = t528 * t75;
  t1656 = t1655 * t547;
  t1659 = t191 * t438;
  t1660 = t1659 * t445;
  t1663 = t540 * t438;
  t1664 = t539 * t1663;
  t1667 = t153 * t533;
  t1670 = t153 * t518;
  t1673 = t26 * t1303;
  t1674 = t60 * t1673;
  t1677 = t534 * t1612 / 0.8e1 - t534 * t1616 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t1622 + 0.3e1 / 0.16e2 * t534 * t1625 - 0.3e1 / 0.16e2 * t534 * t1630 - t534 * t1635 / 0.8e1 - 0.3e1 / 0.32e2 * t519 * t1630 + 0.3e1 / 0.32e2 * t519 * t1643 + t534 * t1646 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1652 + t534 * t1656 / 0.8e1 - t534 * t1660 / 0.16e2 + t534 * t1664 / 0.16e2 + t1667 * t548 / 0.8e1 - t1670 * t523 / 0.16e2 - t1674 * t523 / 0.32e2;
  t1678 = t1386 * t522;
  t1681 = t521 * t528;
  t1682 = t520 * t1681;
  t1688 = t528 * t168 * t445;
  t1699 = t433 * t37;
  t1701 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t1699, 0);
  t1703 = t157 * t1701 * t173;
  t1710 = t546 * t438;
  t1711 = t545 * t1710;
  t1714 = -t519 * t1678 / 0.32e2 - t519 * t1682 / 0.16e2 - t1667 * t536 / 0.8e1 - t534 * t1688 / 0.8e1 + t1667 * t542 / 0.8e1 - t1571 / 0.16e2 - t1583 / 0.16e2 - t1323 * t193 / 0.16e2 - t409 * t530 / 0.8e1 - t156 * t1703 / 0.16e2 + t1540 - t1579 / 0.32e2 - t1590 / 0.16e2 + t1594 / 0.16e2 + t1598 / 0.16e2 + t534 * t1711 / 0.16e2;
  t1716 = my_piecewise3(t51, 0, t1677 + t1714);
  tv3rho2sigma8 = t1716 * t3 + 0.2e1 * t552;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1719 = t1522 * t199;
  t1720 = t1521 * t1719;
  t1723 = t199 * t261;
  t1724 = t1723 * t968;
  t1727 = t572 * t1433;
  t1732 = t1440 * t199;
  t1733 = t1439 * t1732;
  t1736 = t1723 * t1006;
  t1739 = t199 * t997;
  t1740 = t1739 * t1451;
  t1745 = t940 * t558;
  t1748 = t471 * t563;
  t1749 = t470 * t1748;
  t1752 = t563 * t43;
  t1753 = t1752 * t497;
  t1756 = t199 * t283;
  t1757 = t1756 * t290;
  t1766 = t1462 * t569;
  t1768 = 0.3e1 / 0.32e2 * t469 * t1720 + 0.3e1 / 0.16e2 * t484 * t1724 - 0.3e1 / 0.16e2 * t484 * t1727 - 0.3e1 / 0.32e2 * t469 * t1727 + 0.3e1 / 0.32e2 * t469 * t1733 + t484 * t1736 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1740 - t1470 * t559 / 0.32e2 - t469 * t1745 / 0.32e2 - t469 * t1749 / 0.16e2 + t484 * t1753 / 0.8e1 - t484 * t1757 / 0.16e2 + t1455 * t577 / 0.8e1 - t1458 * t559 / 0.16e2 - t1455 * t569 / 0.8e1 - t1766 / 0.16e2;
  t1770 = t563 * t111 * t290;
  t1773 = t1462 * t573;
  t1775 = t563 * t263;
  t1776 = t1775 * t491;
  t1779 = t1723 * t986;
  t1784 = t576 * t1517;
  t1787 = t572 * t1493;
  t1790 = t576 * t1477;
  t1793 = t1462 * t577;
  t1795 = t1466 * t559;
  t1798 = t952 * t201 / 0.64e2;
  t1799 = t1053 * t201;
  t1805 = t255 * t565;
  t1808 = my_piecewise3(t39, 0.3e1 / 0.2e1 * t476, 0);
  t1810 = t100 * t1808 * t116;
  t1813 = -t484 * t1770 / 0.8e1 + t1773 / 0.16e2 + t484 * t1776 / 0.8e1 - t484 * t1779 / 0.16e2 + t1455 * t573 / 0.8e1 - t484 * t1784 / 0.8e1 + t484 * t1787 / 0.16e2 + t484 * t1790 / 0.16e2 + t1793 / 0.16e2 - t1795 / 0.32e2 + t1798 - t1799 / 0.16e2 - t1050 * t201 / 0.16e2 - t246 * t565 / 0.8e1 - t1805 / 0.16e2 - t99 * t1810 / 0.16e2;
  t1815 = my_piecewise3(t2, 0, t1768 + t1813);
  tv3rho2lapl0 = t1815 * t3 + 0.2e1 * t581;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1820 = t1167 * t209;
  t1823 = t1170 * t209 / 0.64e2;
  t1825 = my_piecewise3(t51, 0, -t1164 * t209 / 0.16e2 - t1820 / 0.16e2 + t1823);
  tv3rho2lapl1 = t1825 * t3 + 0.2e1 * t588;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t1829 = t1124 * t201;
  t1847 = -t1121 * t201 / 0.16e2 - t1829 / 0.32e2 - t1548 * t559 / 0.32e2 - t345 * t565 / 0.16e2 - t1553 * t569 / 0.16e2 + t1553 * t573 / 0.16e2 + t1553 * t577 / 0.16e2 - t1799 / 0.32e2 + t1798 - t1795 / 0.64e2 - t1805 / 0.32e2 - t1766 / 0.32e2 + t1773 / 0.32e2 + t1793 / 0.32e2;
  t1848 = my_piecewise3(t2, 0, t1847);
  tv3rho2lapl2 = t1848 * t3 + t581 + t593;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t1852 = t1227 * t209;
  t1857 = t1578 * t598;
  t1861 = t370 * t604;
  t1865 = t1589 * t608;
  t1869 = t1589 * t612;
  t1873 = t1589 * t616;
  t1875 = -t1224 * t209 / 0.16e2 - t1852 / 0.32e2 - t1820 / 0.32e2 + t1823 - t1574 * t598 / 0.32e2 - t1857 / 0.64e2 - t367 * t604 / 0.16e2 - t1861 / 0.32e2 - t1585 * t608 / 0.16e2 - t1865 / 0.32e2 + t1585 * t612 / 0.16e2 + t1869 / 0.32e2 + t1585 * t616 / 0.16e2 + t1873 / 0.32e2;
  t1876 = my_piecewise3(t51, 0, t1875);
  tv3rho2lapl3 = t1876 * t3 + t588 + t620;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t1883 = my_piecewise3(t2, 0, -t1196 * t201 / 0.16e2 - t1829 / 0.16e2 + t1798);
  tv3rho2lapl4 = t1883 * t3 + 0.2e1 * t593;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t1886 = t615 * t1634;
  t1889 = t1628 * t207;
  t1890 = t1619 * t1889;
  t1893 = t1641 * t207;
  t1894 = t1640 * t1893;
  t1897 = t207 * t416;
  t1898 = t1897 * t1357;
  t1901 = t207 * t1348;
  t1902 = t1901 * t1651;
  t1912 = t602 * t168 * t445;
  t1917 = t602 * t418;
  t1918 = t1917 * t541;
  t1921 = t1897 * t1337;
  t1924 = t1620 * t207;
  t1925 = t1619 * t1924;
  t1928 = t1897 * t1369;
  t1934 = -t534 * t1886 / 0.8e1 - 0.3e1 / 0.32e2 * t519 * t1890 + 0.3e1 / 0.32e2 * t519 * t1894 + t534 * t1898 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t1902 + t1667 * t616 / 0.8e1 - t1670 * t598 / 0.16e2 - t1667 * t608 / 0.8e1 - t534 * t1912 / 0.8e1 + t1667 * t612 / 0.8e1 + t534 * t1918 / 0.8e1 - t534 * t1921 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t1925 + 0.3e1 / 0.16e2 * t534 * t1928 - 0.3e1 / 0.16e2 * t534 * t1890 + t1869 / 0.16e2;
  t1936 = t611 * t1663;
  t1939 = t615 * t1710;
  t1944 = t1386 * t597;
  t1947 = t521 * t602;
  t1948 = t520 * t1947;
  t1951 = t602 * t75;
  t1952 = t1951 * t547;
  t1955 = t207 * t438;
  t1956 = t1955 * t445;
  t1966 = my_piecewise3(t72, 0.3e1 / 0.2e1 * t526, 0);
  t1968 = t157 * t1966 * t173;
  t1973 = t1873 / 0.16e2 + t534 * t1936 / 0.16e2 + t534 * t1939 / 0.16e2 - t1674 * t598 / 0.32e2 - t519 * t1944 / 0.32e2 - t519 * t1948 / 0.16e2 + t534 * t1952 / 0.8e1 - t534 * t1956 / 0.16e2 - t1857 / 0.32e2 - t1865 / 0.16e2 - t409 * t604 / 0.8e1 + t1823 - t1852 / 0.16e2 - t1861 / 0.16e2 - t156 * t1968 / 0.16e2 - t1323 * t209 / 0.16e2;
  t1975 = my_piecewise3(t51, 0, t1934 + t1973);
  tv3rho2lapl5 = t1975 * t3 + 0.2e1 * t620;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t1978 = t640 * t1433;
  t1981 = t644 * t1517;
  t1984 = t1440 * t213;
  t1985 = t1439 * t1984;
  t1988 = t213 * t261;
  t1989 = t1988 * t1006;
  t1992 = t213 * t997;
  t1993 = t1992 * t1451;
  t1998 = t1462 * t645;
  t2000 = t1466 * t627;
  t2004 = t940 * t626;
  t2007 = t471 * t631;
  t2008 = t470 * t2007;
  t2011 = t1462 * t637;
  t2013 = t631 * t111;
  t2014 = t2013 * t290;
  t2019 = t1462 * t641;
  t2021 = t631 * t263;
  t2022 = t2021 * t491;
  t2025 = -0.3e1 / 0.16e2 * t484 * t1978 - t484 * t1981 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t1985 + t484 * t1989 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t1993 - 0.3e1 / 0.32e2 * t469 * t1978 + t1998 / 0.16e2 - t2000 / 0.32e2 - t1470 * t627 / 0.32e2 - t469 * t2004 / 0.32e2 - t469 * t2008 / 0.16e2 - t2011 / 0.16e2 - t484 * t2014 / 0.8e1 - t1455 * t637 / 0.8e1 + t2019 / 0.16e2 + t484 * t2022 / 0.8e1;
  t2026 = t1988 * t986;
  t2031 = t1522 * t213;
  t2032 = t1521 * t2031;
  t2035 = t1988 * t968;
  t2038 = t644 * t1477;
  t2041 = t631 * t43;
  t2042 = t2041 * t497;
  t2045 = t213 * t283;
  t2046 = t2045 * t290;
  t2049 = t640 * t1493;
  t2056 = t1053 * t215;
  t2059 = t952 * t215 / 0.64e2;
  t2061 = my_piecewise3(t39, -0.6e1 * t476, 0);
  t2063 = t100 * t2061 * t116;
  t2070 = t255 * t633;
  t2072 = -t484 * t2026 / 0.16e2 + t1455 * t641 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2032 + 0.3e1 / 0.16e2 * t484 * t2035 + t484 * t2038 / 0.16e2 + t484 * t2042 / 0.8e1 - t484 * t2046 / 0.16e2 + t484 * t2049 / 0.16e2 + t1455 * t645 / 0.8e1 - t1458 * t627 / 0.16e2 - t2056 / 0.16e2 + t2059 - t99 * t2063 / 0.16e2 - t1050 * t215 / 0.16e2 - t246 * t633 / 0.8e1 - t2070 / 0.16e2;
  t2074 = my_piecewise3(t2, 0, t2025 + t2072);
  tv3rho2tau0 = t2074 * t3 + 0.2e1 * t649;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2079 = t1167 * t221;
  t2082 = t1170 * t221 / 0.64e2;
  t2084 = my_piecewise3(t51, 0, -t1164 * t221 / 0.16e2 - t2079 / 0.16e2 + t2082);
  tv3rho2tau1 = t2084 * t3 + 0.2e1 * t656;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2088 = t1124 * t215;
  t2106 = -t1121 * t215 / 0.16e2 - t2088 / 0.32e2 - t1548 * t627 / 0.32e2 - t345 * t633 / 0.16e2 - t1553 * t637 / 0.16e2 + t1553 * t641 / 0.16e2 + t1553 * t645 / 0.16e2 - t2056 / 0.32e2 + t2059 - t2000 / 0.64e2 - t2070 / 0.32e2 - t2011 / 0.32e2 + t2019 / 0.32e2 + t1998 / 0.32e2;
  t2107 = my_piecewise3(t2, 0, t2106);
  tv3rho2tau2 = t2107 * t3 + t649 + t661;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2111 = t1227 * t221;
  t2116 = t1578 * t666;
  t2120 = t370 * t672;
  t2124 = t1589 * t676;
  t2128 = t1589 * t680;
  t2132 = t1589 * t684;
  t2134 = -t1224 * t221 / 0.16e2 - t2111 / 0.32e2 - t2079 / 0.32e2 + t2082 - t1574 * t666 / 0.32e2 - t2116 / 0.64e2 - t367 * t672 / 0.16e2 - t2120 / 0.32e2 - t1585 * t676 / 0.16e2 - t2124 / 0.32e2 + t1585 * t680 / 0.16e2 + t2128 / 0.32e2 + t1585 * t684 / 0.16e2 + t2132 / 0.32e2;
  t2135 = my_piecewise3(t51, 0, t2134);
  tv3rho2tau3 = t2135 * t3 + t656 + t688;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2142 = my_piecewise3(t2, 0, -t1196 * t215 / 0.16e2 - t2088 / 0.16e2 + t2059);
  tv3rho2tau4 = t2142 * t3 + 0.2e1 * t661;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2148 = t670 * t168 * t445;
  t2153 = t670 * t418;
  t2154 = t2153 * t541;
  t2157 = t219 * t416;
  t2158 = t2157 * t1337;
  t2161 = t1620 * t219;
  t2162 = t1619 * t2161;
  t2165 = t2157 * t1369;
  t2168 = t679 * t1629;
  t2171 = t683 * t1634;
  t2174 = t1641 * t219;
  t2175 = t1640 * t2174;
  t2178 = t2157 * t1357;
  t2181 = t219 * t1348;
  t2182 = t2181 * t1651;
  t2188 = t219 * t438;
  t2189 = t2188 * t445;
  t2192 = t679 * t1663;
  t2195 = -t1667 * t676 / 0.8e1 - t534 * t2148 / 0.8e1 + t1667 * t680 / 0.8e1 + t534 * t2154 / 0.8e1 - t534 * t2158 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2162 + 0.3e1 / 0.16e2 * t534 * t2165 - 0.3e1 / 0.16e2 * t534 * t2168 - t534 * t2171 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t2175 + t534 * t2178 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2182 - 0.3e1 / 0.32e2 * t519 * t2168 + t2132 / 0.16e2 - t534 * t2189 / 0.16e2 + t534 * t2192 / 0.16e2;
  t2196 = t683 * t1710;
  t2205 = t1386 * t665;
  t2208 = t521 * t670;
  t2209 = t520 * t2208;
  t2212 = t670 * t75;
  t2213 = t2212 * t547;
  t2223 = my_piecewise3(t72, -0.6e1 * t526, 0);
  t2225 = t157 * t2223 * t173;
  t2231 = t534 * t2196 / 0.16e2 + t1667 * t684 / 0.8e1 - t1670 * t666 / 0.16e2 - t1674 * t666 / 0.32e2 - t519 * t2205 / 0.32e2 - t519 * t2209 / 0.16e2 + t534 * t2213 / 0.8e1 - t2116 / 0.32e2 - t2124 / 0.16e2 + t2128 / 0.16e2 - t2120 / 0.16e2 - t409 * t672 / 0.8e1 - t156 * t2225 / 0.16e2 - t1323 * t221 / 0.16e2 + t2082 - t2111 / 0.16e2;
  t2233 = my_piecewise3(t51, 0, t2195 + t2231);
  tv3rho2tau5 = t2233 * t3 + 0.2e1 * t688;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2235 = t495 * t1481;
  t2238 = t690 * t43;
  t2239 = t1522 * t111;
  t2240 = t2238 * t2239;
  t2243 = t695 * t111;
  t2244 = t2243 * t290;
  t2245 = t484 * t2244;
  t2246 = t2245 / 0.16e2;
  t2248 = t690 * t111 * t986;
  t2251 = t695 * t263;
  t2252 = t2251 * t491;
  t2253 = t484 * t2252;
  t2254 = t2253 / 0.16e2;
  t2255 = t690 * t263;
  t2256 = t1440 * t111;
  t2257 = t2255 * t2256;
  t2260 = t690 * t997;
  t2261 = t1450 * t111;
  t2262 = t2260 * t2261;
  t2265 = t1432 * t111;
  t2266 = t2255 * t2265;
  t2269 = t2260 * t2256;
  t2272 = t490 * t478;
  t2273 = t489 * t2272;
  t2278 = t496 * t478;
  t2279 = t495 * t2278;
  t2282 = t1516 * t111;
  t2283 = t2238 * t2282;
  t2286 = t489 * t1481;
  t2289 = -t484 * t2235 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2240 - t2246 - t484 * t2248 / 0.16e2 + t2254 + t484 * t2257 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2262 - 0.3e1 / 0.32e2 * t469 * t2266 + 0.3e1 / 0.32e2 * t469 * t2269 + t484 * t2273 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t2266 + t484 * t2279 / 0.8e1 - t484 * t2283 / 0.8e1 - t469 * t2286 / 0.16e2;
  t2290 = t2255 * t2239;
  t2293 = t695 * t43;
  t2294 = t2293 * t497;
  t2295 = t484 * t2294;
  t2296 = t2295 / 0.16e2;
  t2297 = t471 * t695;
  t2298 = t470 * t2297;
  t2299 = t469 * t2298;
  t2300 = t2299 / 0.32e2;
  t2306 = t1030 * t690 * t269;
  t2310 = t255 * t704 / 0.32e2;
  t2312 = t255 * t707 / 0.32e2;
  t2314 = t255 * t692 / 0.64e2;
  t2315 = t255 * t697;
  t2316 = t2315 / 0.32e2;
  t2318 = t255 * t701 / 0.32e2;
  t2319 = t246 * t697;
  t2320 = t2319 / 0.16e2;
  t2325 = 0.3e1 / 0.32e2 * t469 * t2290 + t2296 - t2300 + t246 * t707 / 0.16e2 - t246 * t692 / 0.32e2 - t99 * t2306 / 0.32e2 + t2310 + t2312 - t2314 - t2316 - t2318 - t2320 - t246 * t701 / 0.16e2 + t246 * t704 / 0.16e2 - t699;
  t2327 = my_piecewise3(t2, 0, t2289 + t2325);
  tv3rhosigma20 = t2327 * t3 + t711;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2332 = t370 * t714 / 0.64e2;
  t2334 = t367 * t719 / 0.16e2;
  t2335 = t370 * t719;
  t2336 = t2335 / 0.32e2;
  t2340 = t370 * t723 / 0.32e2;
  t2344 = t370 * t726 / 0.32e2;
  t2348 = t370 * t729 / 0.32e2;
  t2350 = my_piecewise3(t51, 0, -t367 * t714 / 0.32e2 - t2332 - t2334 - t2336 - t367 * t723 / 0.16e2 - t2340 + t367 * t726 / 0.16e2 + t2344 + t367 * t729 / 0.16e2 + t2348);
  tv3rhosigma25 = t2350 * t3 + t733;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2355 = t345 * t697 / 0.16e2;
  t2363 = my_piecewise3(t2, 0, -t345 * t692 / 0.32e2 - t2314 - t2355 - t2316 - t345 * t701 / 0.16e2 - t2318 + t345 * t704 / 0.16e2 + t2310 + t345 * t707 / 0.16e2 + t2312);
  tv3rhosigma26 = t2363 * t3 + t711;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2365 = t712 * t1348;
  t2366 = t1650 * t168;
  t2367 = t2365 * t2366;
  t2370 = t545 * t1681;
  t2373 = t712 * t75;
  t2374 = t1620 * t168;
  t2375 = t2373 * t2374;
  t2378 = t540 * t528;
  t2379 = t539 * t2378;
  t2382 = t712 * t418;
  t2383 = t1628 * t168;
  t2384 = t2382 * t2383;
  t2387 = t539 * t1681;
  t2390 = t717 * t168;
  t2391 = t2390 * t445;
  t2392 = t534 * t2391;
  t2393 = t2392 / 0.16e2;
  t2395 = t712 * t168 * t1337;
  t2400 = t1641 * t168;
  t2401 = t2365 * t2400;
  t2404 = t717 * t418;
  t2405 = t2404 * t541;
  t2406 = t534 * t2405;
  t2407 = t2406 / 0.16e2;
  t2408 = t2382 * t2400;
  t2411 = t546 * t528;
  t2412 = t545 * t2411;
  t2415 = t1633 * t168;
  t2416 = t2373 * t2415;
  t2419 = -0.3e1 / 0.16e2 * t534 * t2367 - t534 * t2370 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2375 + t534 * t2379 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t2384 - t519 * t2387 / 0.16e2 - t2393 - t534 * t2395 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2384 + 0.3e1 / 0.32e2 * t519 * t2401 + t2407 + t534 * t2408 / 0.4e1 + t534 * t2412 / 0.8e1 - t534 * t2416 / 0.8e1;
  t2420 = t2382 * t2374;
  t2423 = t717 * t75;
  t2424 = t2423 * t547;
  t2425 = t534 * t2424;
  t2426 = t2425 / 0.16e2;
  t2427 = t521 * t717;
  t2428 = t520 * t2427;
  t2429 = t519 * t2428;
  t2430 = t2429 / 0.32e2;
  t2440 = t1303 * t712 * t424;
  t2443 = t409 * t719;
  t2444 = t2443 / 0.16e2;
  t2445 = 0.3e1 / 0.32e2 * t519 * t2420 + t2426 - t2430 - t2340 + t2344 + t2348 - t409 * t723 / 0.16e2 + t409 * t726 / 0.16e2 + t409 * t729 / 0.16e2 - t409 * t714 / 0.32e2 - t156 * t2440 / 0.32e2 - t2444 - t2332 - t2336 - t721;
  t2447 = my_piecewise3(t51, 0, t2419 + t2445);
  tv3rhosigma211 = t2447 * t3 + t733;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2449 = t737 * t111;
  t2450 = t2449 * t986;
  t2453 = t489 * t265;
  t2454 = t958 * t199;
  t2455 = t2454 * t111;
  t2456 = t2453 * t2455;
  t2459 = t737 * t43;
  t2460 = t2459 * t2239;
  t2463 = t572 * t295;
  t2464 = t958 * t183;
  t2465 = t2464 * t111;
  t2466 = t2463 * t2465;
  t2469 = t576 * t113;
  t2470 = t2469 * t2465;
  t2475 = t1449 * t999;
  t2476 = t2475 * t2455;
  t2479 = t737 * t263;
  t2480 = t2479 * t2256;
  t2483 = t1739 * t1011;
  t2484 = t2483 * t2465;
  t2488 = t1466 * t734 / 0.64e2;
  t2490 = t1462 * t738 / 0.32e2;
  t2492 = t1462 * t742 / 0.32e2;
  t2494 = t1462 * t746 / 0.32e2;
  t2497 = t563 * t183;
  t2498 = t2497 * t290;
  t2501 = t199 * t478;
  t2502 = t2501 * t290;
  t2505 = -t484 * t2450 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2456 + 0.3e1 / 0.16e2 * t484 * t2460 - 0.3e1 / 0.16e2 * t484 * t2466 - t484 * t2470 / 0.8e1 - 0.3e1 / 0.32e2 * t469 * t2466 + 0.3e1 / 0.32e2 * t469 * t2476 + t484 * t2480 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2484 - t2488 - t2490 + t2492 + t2494 - t1455 * t738 / 0.16e2 - t484 * t2498 / 0.16e2 - t484 * t2502 / 0.16e2;
  t2508 = t1775 * t741;
  t2511 = t572 * t2272;
  t2516 = t1752 * t745;
  t2519 = t576 * t2278;
  t2526 = t1507 * t558;
  t2529 = t489 * t1748;
  t2532 = t1455 * t742 / 0.16e2 + t484 * t2508 / 0.16e2 + t484 * t2511 / 0.16e2 + t1455 * t746 / 0.16e2 + t484 * t2516 / 0.16e2 + t484 * t2519 / 0.16e2 - t1458 * t734 / 0.32e2 - t1470 * t734 / 0.32e2 - t469 * t2526 / 0.32e2 - t469 * t2529 / 0.32e2 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699;
  t2534 = my_piecewise3(t2, 0, t2505 + t2532);
  tv3rhosigmalapl0 = t2534 * t3 + t750;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2539 = t1578 * t751 / 0.64e2;
  t2543 = t1589 * t755 / 0.32e2;
  t2547 = t1589 * t759 / 0.32e2;
  t2551 = t1589 * t763 / 0.32e2;
  t2553 = my_piecewise3(t51, 0, -t1574 * t751 / 0.32e2 - t2539 - t2334 - t2336 - t1585 * t755 / 0.16e2 - t2543 + t1585 * t759 / 0.16e2 + t2547 + t1585 * t763 / 0.16e2 + t2551);
  tv3rhosigmalapl5 = t2553 * t3 + t767;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2564 = my_piecewise3(t2, 0, -t1548 * t734 / 0.32e2 - t2488 - t2355 - t2316 - t1553 * t738 / 0.16e2 - t2490 + t1553 * t742 / 0.16e2 + t2492 + t1553 * t746 / 0.16e2 + t2494);
  tv3rhosigmalapl6 = t2564 * t3 + t750;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2566 = t1901 * t1362;
  t2567 = t1336 * t191;
  t2568 = t2567 * t168;
  t2569 = t2566 * t2568;
  t2572 = t539 * t450;
  t2573 = t1336 * t207;
  t2574 = t2573 * t168;
  t2575 = t2572 * t2574;
  t2578 = t1649 * t1350;
  t2579 = t2578 * t2574;
  t2582 = t754 * t418;
  t2583 = t2582 * t2400;
  t2586 = t754 * t168;
  t2587 = t2586 * t1337;
  t2590 = t539 * t420;
  t2591 = t2590 * t2574;
  t2594 = t754 * t75;
  t2595 = t2594 * t2374;
  t2600 = t615 * t170;
  t2601 = t2600 * t2568;
  t2604 = t1611 * t597;
  t2607 = t539 * t1947;
  t2612 = t602 * t191;
  t2613 = t2612 * t445;
  t2616 = t207 * t528;
  t2617 = t2616 * t445;
  t2622 = t1917 * t758;
  t2625 = -0.3e1 / 0.16e2 * t534 * t2569 - 0.3e1 / 0.32e2 * t519 * t2575 + 0.3e1 / 0.32e2 * t519 * t2579 + t534 * t2583 / 0.4e1 - t534 * t2587 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2591 + 0.3e1 / 0.16e2 * t534 * t2595 - 0.3e1 / 0.16e2 * t534 * t2575 - t534 * t2601 / 0.8e1 - t519 * t2604 / 0.32e2 - t519 * t2607 / 0.32e2 - t1667 * t755 / 0.16e2 - t534 * t2613 / 0.16e2 - t534 * t2617 / 0.16e2 + t1667 * t759 / 0.16e2 + t534 * t2622 / 0.16e2;
  t2626 = t611 * t2378;
  t2631 = t1951 * t762;
  t2634 = t615 * t2411;
  t2641 = t534 * t2626 / 0.16e2 + t1667 * t763 / 0.16e2 + t534 * t2631 / 0.16e2 + t534 * t2634 / 0.16e2 - t1670 * t751 / 0.32e2 - t1674 * t751 / 0.32e2 - t2539 - t2543 + t2547 + t2551 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t2643 = my_piecewise3(t51, 0, t2625 + t2641);
  tv3rhosigmalapl11 = t2643 * t3 + t767;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t2645 = t1992 * t1011;
  t2646 = t2645 * t2465;
  t2649 = t771 * t111;
  t2650 = t2649 * t986;
  t2653 = t644 * t113;
  t2654 = t2653 * t2465;
  t2657 = t958 * t213;
  t2658 = t2657 * t111;
  t2659 = t2453 * t2658;
  t2662 = t771 * t43;
  t2663 = t2662 * t2239;
  t2666 = t640 * t295;
  t2667 = t2666 * t2465;
  t2672 = t2475 * t2658;
  t2675 = t771 * t263;
  t2676 = t2675 * t2256;
  t2683 = t1507 * t626;
  t2686 = t489 * t2007;
  t2691 = t631 * t183;
  t2692 = t2691 * t290;
  t2696 = t1462 * t778 / 0.32e2;
  t2697 = -0.3e1 / 0.16e2 * t484 * t2646 - t484 * t2650 / 0.16e2 - t484 * t2654 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t2659 + 0.3e1 / 0.16e2 * t484 * t2663 - 0.3e1 / 0.16e2 * t484 * t2667 - 0.3e1 / 0.32e2 * t469 * t2667 + 0.3e1 / 0.32e2 * t469 * t2672 + t484 * t2676 / 0.4e1 - t1458 * t768 / 0.32e2 - t1470 * t768 / 0.32e2 - t469 * t2683 / 0.32e2 - t469 * t2686 / 0.32e2 - t1455 * t772 / 0.16e2 - t484 * t2692 / 0.16e2 + t2696;
  t2699 = t1466 * t768 / 0.64e2;
  t2701 = t1462 * t772 / 0.32e2;
  t2703 = t1462 * t775 / 0.32e2;
  t2704 = t213 * t478;
  t2705 = t2704 * t290;
  t2710 = t2021 * t741;
  t2713 = t640 * t2272;
  t2718 = t2041 * t745;
  t2721 = t644 * t2278;
  t2724 = -t2699 - t2701 + t2703 - t484 * t2705 / 0.16e2 + t1455 * t775 / 0.16e2 + t484 * t2710 / 0.16e2 + t484 * t2713 / 0.16e2 + t1455 * t778 / 0.16e2 + t484 * t2718 / 0.16e2 + t484 * t2721 / 0.16e2 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699;
  t2726 = my_piecewise3(t2, 0, t2697 + t2724);
  tv3rhosigmatau0 = t2726 * t3 + t782;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t2731 = t1578 * t783 / 0.64e2;
  t2735 = t1589 * t787 / 0.32e2;
  t2739 = t1589 * t790 / 0.32e2;
  t2743 = t1589 * t793 / 0.32e2;
  t2745 = my_piecewise3(t51, 0, -t1574 * t783 / 0.32e2 - t2731 - t2334 - t2336 - t1585 * t787 / 0.16e2 - t2735 + t1585 * t790 / 0.16e2 + t2739 + t1585 * t793 / 0.16e2 + t2743);
  tv3rhosigmatau5 = t2745 * t3 + t797;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t2756 = my_piecewise3(t2, 0, -t1548 * t768 / 0.32e2 - t2699 - t2355 - t2316 - t1553 * t772 / 0.16e2 - t2701 + t1553 * t775 / 0.16e2 + t2703 + t1553 * t778 / 0.16e2 + t2696);
  tv3rhosigmatau6 = t2756 * t3 + t782;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t2758 = t2181 * t1362;
  t2759 = t2758 * t2568;
  t2762 = t1336 * t219;
  t2763 = t2762 * t168;
  t2764 = t2572 * t2763;
  t2767 = t2578 * t2763;
  t2770 = t786 * t418;
  t2771 = t2770 * t2400;
  t2774 = t786 * t168;
  t2775 = t2774 * t1337;
  t2778 = t683 * t170;
  t2779 = t2778 * t2568;
  t2782 = t2590 * t2763;
  t2785 = t786 * t75;
  t2786 = t2785 * t2374;
  t2793 = t670 * t191;
  t2794 = t2793 * t445;
  t2797 = t219 * t528;
  t2798 = t2797 * t445;
  t2803 = t2153 * t758;
  t2806 = t679 * t2378;
  t2811 = -0.3e1 / 0.16e2 * t534 * t2759 - 0.3e1 / 0.32e2 * t519 * t2764 + 0.3e1 / 0.32e2 * t519 * t2767 + t534 * t2771 / 0.4e1 - t534 * t2775 / 0.16e2 - t534 * t2779 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t2782 + 0.3e1 / 0.16e2 * t534 * t2786 - 0.3e1 / 0.16e2 * t534 * t2764 - t1667 * t787 / 0.16e2 - t534 * t2794 / 0.16e2 - t534 * t2798 / 0.16e2 + t1667 * t790 / 0.16e2 + t534 * t2803 / 0.16e2 + t534 * t2806 / 0.16e2 + t1667 * t793 / 0.16e2;
  t2812 = t2212 * t762;
  t2815 = t683 * t2411;
  t2822 = t1611 * t665;
  t2825 = t539 * t2208;
  t2828 = t534 * t2812 / 0.16e2 + t534 * t2815 / 0.16e2 - t1670 * t783 / 0.32e2 - t1674 * t783 / 0.32e2 - t519 * t2822 / 0.32e2 - t519 * t2825 / 0.32e2 - t2735 + t2739 + t2743 - t2731 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t2830 = my_piecewise3(t51, 0, t2811 + t2828);
  tv3rhosigmatau11 = t2830 * t3 + t797;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2832 = t798 * t111;
  t2833 = t2832 * t986;
  t2836 = t798 * t263;
  t2837 = t2836 * t2265;
  t2840 = t798 * t997;
  t2841 = t2840 * t2256;
  t2844 = t2836 * t2256;
  t2847 = t2840 * t2261;
  t2852 = t496 * t563;
  t2853 = t576 * t2852;
  t2856 = t798 * t43;
  t2857 = t2856 * t2282;
  t2860 = t572 * t1748;
  t2863 = t2836 * t2239;
  t2866 = t576 * t1748;
  t2869 = t2856 * t2239;
  t2872 = t490 * t563;
  t2873 = t572 * t2872;
  t2876 = -t484 * t2833 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t2837 + 0.3e1 / 0.32e2 * t469 * t2841 + t484 * t2844 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2847 - 0.3e1 / 0.16e2 * t484 * t2837 + t484 * t2853 / 0.8e1 - t484 * t2857 / 0.8e1 - t469 * t2860 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2863 - t484 * t2866 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2869 + t484 * t2873 / 0.8e1 - t2246;
  t2878 = t255 * t810 / 0.32e2;
  t2880 = t255 * t800 / 0.64e2;
  t2882 = t255 * t804 / 0.32e2;
  t2884 = t255 * t807 / 0.32e2;
  t2894 = t1030 * t798 * t269;
  t2897 = t2254 + t2296 - t2300 + t2878 - t2880 - t2882 + t2884 - t246 * t804 / 0.16e2 + t246 * t807 / 0.16e2 + t246 * t810 / 0.16e2 - t246 * t800 / 0.32e2 - t99 * t2894 / 0.32e2 - t2316 - t2320 - t699;
  t2899 = my_piecewise3(t2, 0, t2876 + t2897);
  tv3rholapl20 = t2899 * t3 + t814;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2904 = t370 * t817 / 0.64e2;
  t2908 = t370 * t821 / 0.32e2;
  t2912 = t370 * t824 / 0.32e2;
  t2916 = t370 * t827 / 0.32e2;
  t2918 = my_piecewise3(t51, 0, -t367 * t817 / 0.32e2 - t2904 - t2334 - t2336 - t367 * t821 / 0.16e2 - t2908 + t367 * t824 / 0.16e2 + t2912 + t367 * t827 / 0.16e2 + t2916);
  tv3rholapl22 = t2918 * t3 + t831;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2929 = my_piecewise3(t2, 0, -t345 * t800 / 0.32e2 - t2880 - t2355 - t2316 - t345 * t804 / 0.16e2 - t2882 + t345 * t807 / 0.16e2 + t2884 + t345 * t810 / 0.16e2 + t2878);
  tv3rholapl23 = t2929 * t3 + t814;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2931 = t815 * t168;
  t2932 = t2931 * t1337;
  t2935 = t815 * t418;
  t2936 = t2935 * t2383;
  t2939 = t815 * t1348;
  t2940 = t2939 * t2400;
  t2943 = t2935 * t2400;
  t2946 = t2939 * t2366;
  t2949 = t615 * t1947;
  t2952 = t815 * t75;
  t2953 = t2952 * t2374;
  t2956 = t540 * t602;
  t2957 = t611 * t2956;
  t2962 = t546 * t602;
  t2963 = t615 * t2962;
  t2966 = t2952 * t2415;
  t2969 = t611 * t1947;
  t2972 = t2935 * t2374;
  t2975 = -t534 * t2932 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t2936 + 0.3e1 / 0.32e2 * t519 * t2940 + t534 * t2943 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2946 - t534 * t2949 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t2953 + t534 * t2957 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t2936 + t534 * t2963 / 0.8e1 - t534 * t2966 / 0.8e1 - t519 * t2969 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t2972 - t2393;
  t2981 = t1303 * t815 * t424;
  t2988 = t2407 + t2426 - t2430 + t409 * t827 / 0.16e2 - t409 * t817 / 0.32e2 - t156 * t2981 / 0.32e2 - t409 * t821 / 0.16e2 + t409 * t824 / 0.16e2 - t2904 - t2908 + t2912 + t2916 - t2444 - t2336 - t721;
  t2990 = my_piecewise3(t51, 0, t2975 + t2988);
  tv3rholapl25 = t2990 * t3 + t831;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  t2992 = t835 * t263;
  t2993 = t2992 * t2256;
  t2996 = t2645 * t2455;
  t2999 = t2463 * t2658;
  t3003 = t835 * t111 * t986;
  t3006 = t1739 * t999;
  t3007 = t3006 * t2658;
  t3012 = t2653 * t2455;
  t3015 = t572 * t265;
  t3016 = t3015 * t2658;
  t3019 = t835 * t43;
  t3020 = t3019 * t2239;
  t3023 = t2021 * t839;
  t3026 = t640 * t2872;
  t3031 = t2041 * t843;
  t3034 = t644 * t2852;
  t3041 = t484 * t2993 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2996 - 0.3e1 / 0.32e2 * t469 * t2999 - t484 * t3003 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t3007 - 0.3e1 / 0.16e2 * t484 * t2999 - t484 * t3012 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3016 + 0.3e1 / 0.16e2 * t484 * t3020 + t484 * t3023 / 0.16e2 + t484 * t3026 / 0.16e2 + t1455 * t844 / 0.16e2 + t484 * t3031 / 0.16e2 + t484 * t3034 / 0.16e2 - t1458 * t832 / 0.32e2 - t1470 * t832 / 0.32e2;
  t3042 = t1775 * t626;
  t3045 = t572 * t2007;
  t3050 = t631 * t199;
  t3051 = t3050 * t290;
  t3054 = t213 * t563;
  t3055 = t3054 * t290;
  t3059 = t1462 * t840 / 0.32e2;
  t3061 = t1462 * t844 / 0.32e2;
  t3063 = t1466 * t832 / 0.64e2;
  t3065 = t1462 * t836 / 0.32e2;
  t3068 = -t469 * t3042 / 0.32e2 - t469 * t3045 / 0.32e2 - t1455 * t836 / 0.16e2 - t484 * t3051 / 0.16e2 - t484 * t3055 / 0.16e2 + t3059 + t3061 - t3063 - t3065 + t1455 * t840 / 0.16e2 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699;
  t3070 = my_piecewise3(t2, 0, t3041 + t3068);
  tv3rholapltau0 = t3 * t3070 + t848;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  t3075 = t1578 * t849 / 0.64e2;
  t3079 = t1589 * t853 / 0.32e2;
  t3083 = t1589 * t857 / 0.32e2;
  t3087 = t1589 * t861 / 0.32e2;
  t3089 = my_piecewise3(t51, 0, -t1574 * t849 / 0.32e2 - t3075 - t2334 - t2336 - t1585 * t853 / 0.16e2 - t3079 + t1585 * t857 / 0.16e2 + t3083 + t1585 * t861 / 0.16e2 + t3087);
  tv3rholapltau3 = t3 * t3089 + t865;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  t3100 = my_piecewise3(t2, 0, -t1548 * t832 / 0.32e2 - t3063 - t2355 - t2316 - t1553 * t836 / 0.16e2 - t3065 + t1553 * t840 / 0.16e2 + t3059 + t1553 * t844 / 0.16e2 + t3061);
  tv3rholapltau4 = t3 * t3100 + t848;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  t3102 = t2758 * t2574;
  t3106 = t852 * t168 * t1337;
  t3109 = t611 * t450;
  t3110 = t3109 * t2763;
  t3113 = t1901 * t1350;
  t3114 = t3113 * t2763;
  t3117 = t852 * t418;
  t3118 = t3117 * t2400;
  t3123 = t2778 * t2574;
  t3126 = t611 * t420;
  t3127 = t3126 * t2763;
  t3130 = t852 * t75;
  t3131 = t3130 * t2374;
  t3136 = t2153 * t856;
  t3139 = t679 * t2956;
  t3144 = t2212 * t860;
  t3147 = t683 * t2962;
  t3152 = -0.3e1 / 0.16e2 * t534 * t3102 - t534 * t3106 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3110 + 0.3e1 / 0.32e2 * t519 * t3114 + t534 * t3118 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3110 - t534 * t3123 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3127 + 0.3e1 / 0.16e2 * t534 * t3131 + t1667 * t857 / 0.16e2 + t534 * t3136 / 0.16e2 + t534 * t3139 / 0.16e2 + t1667 * t861 / 0.16e2 + t534 * t3144 / 0.16e2 + t534 * t3147 / 0.16e2 - t1670 * t849 / 0.32e2;
  t3155 = t1917 * t665;
  t3158 = t611 * t2208;
  t3163 = t670 * t207;
  t3164 = t3163 * t445;
  t3167 = t219 * t602;
  t3168 = t3167 * t445;
  t3171 = -t1674 * t849 / 0.32e2 - t519 * t3155 / 0.32e2 - t519 * t3158 / 0.32e2 - t1667 * t853 / 0.16e2 - t534 * t3164 / 0.16e2 - t534 * t3168 / 0.16e2 - t3079 + t3083 + t3087 - t3075 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t3173 = my_piecewise3(t51, 0, t3152 + t3171);
  tv3rholapltau7 = t3 * t3173 + t865;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3175 = t866 * t111;
  t3176 = t3175 * t986;
  t3179 = t866 * t263;
  t3180 = t3179 * t2265;
  t3183 = t866 * t997;
  t3184 = t3183 * t2256;
  t3187 = t3179 * t2256;
  t3190 = t3183 * t2261;
  t3193 = t866 * t43;
  t3194 = t3193 * t2282;
  t3197 = t644 * t2007;
  t3200 = t3193 * t2239;
  t3204 = t640 * t490 * t631;
  t3210 = t644 * t496 * t631;
  t3213 = t640 * t2007;
  t3216 = t3179 * t2239;
  t3219 = -t484 * t3176 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3180 + 0.3e1 / 0.32e2 * t469 * t3184 + t484 * t3187 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3190 - t484 * t3194 / 0.8e1 - t484 * t3197 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t3200 + t484 * t3204 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t3180 + t484 * t3210 / 0.8e1 - t469 * t3213 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t3216 - t2246;
  t3229 = t1030 * t866 * t269;
  t3233 = t255 * t872 / 0.32e2;
  t3235 = t255 * t875 / 0.32e2;
  t3237 = t255 * t878 / 0.32e2;
  t3239 = t255 * t868 / 0.64e2;
  t3240 = t2254 + t2296 - t2300 - t246 * t872 / 0.16e2 + t246 * t875 / 0.16e2 + t246 * t878 / 0.16e2 - t246 * t868 / 0.32e2 - t99 * t3229 / 0.32e2 - t3233 + t3235 + t3237 - t3239 - t2316 - t2320 - t699;
  t3242 = my_piecewise3(t2, 0, t3219 + t3240);
  tv3rhotau20 = t3 * t3242 + t882;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3247 = t370 * t885 / 0.64e2;
  t3251 = t370 * t889 / 0.32e2;
  t3255 = t370 * t892 / 0.32e2;
  t3259 = t370 * t895 / 0.32e2;
  t3261 = my_piecewise3(t51, 0, -t367 * t885 / 0.32e2 - t3247 - t2334 - t2336 - t367 * t889 / 0.16e2 - t3251 + t367 * t892 / 0.16e2 + t3255 + t367 * t895 / 0.16e2 + t3259);
  tv3rhotau22 = t3 * t3261 + t899;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3272 = my_piecewise3(t2, 0, -t345 * t868 / 0.32e2 - t3239 - t2355 - t2316 - t345 * t872 / 0.16e2 - t3233 + t345 * t875 / 0.16e2 + t3235 + t345 * t878 / 0.16e2 + t3237);
  tv3rhotau23 = t3 * t3272 + t882;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3274 = t883 * t168;
  t3275 = t3274 * t1337;
  t3278 = t883 * t418;
  t3279 = t3278 * t2383;
  t3282 = t883 * t1348;
  t3283 = t3282 * t2400;
  t3286 = t3278 * t2400;
  t3289 = t3282 * t2366;
  t3293 = t679 * t540 * t670;
  t3299 = t683 * t546 * t670;
  t3302 = t883 * t75;
  t3303 = t3302 * t2415;
  t3306 = t679 * t2208;
  t3309 = t3278 * t2374;
  t3312 = t683 * t2208;
  t3315 = t3302 * t2374;
  t3318 = -t534 * t3275 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3279 + 0.3e1 / 0.32e2 * t519 * t3283 + t534 * t3286 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3289 + t534 * t3293 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t3279 + t534 * t3299 / 0.8e1 - t534 * t3303 / 0.8e1 - t519 * t3306 / 0.16e2 + 0.3e1 / 0.32e2 * t519 * t3309 - t534 * t3312 / 0.8e1 + 0.3e1 / 0.16e2 * t534 * t3315 - t2393;
  t3320 = t1303 * t883 * t424;
  t3331 = t2407 + t2426 - t2430 - t156 * t3320 / 0.32e2 - t409 * t889 / 0.16e2 - t3247 - t3251 + t3255 + t3259 + t409 * t892 / 0.16e2 + t409 * t895 / 0.16e2 - t409 * t885 / 0.32e2 - t2444 - t2336 - t721;
  t3333 = my_piecewise3(t51, 0, t3318 + t3331);
  tv3rhotau25 = t3 * t3333 + t899;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t3335 = t690 * t183;
  t3336 = t100 * t3335;
  t3337 = t3336 * t959;
  t3340 = t489 * t2297;
  t3341 = t469 * t3340;
  t3342 = 0.3e1 / 0.32e2 * t3341;
  t3343 = t260 * t3335;
  t3344 = t3343 * t964;
  t3347 = t2293 * t745;
  t3348 = t484 * t3347;
  t3349 = 0.3e1 / 0.16e2 * t3348;
  t3350 = t3336 * t968;
  t3353 = t3336 * t972;
  t3356 = t1023 * t183;
  t3358 = t1026 * t183;
  t3361 = t3356 * t116 / 0.2e1 - t3358 * t116 / 0.2e1 + t185 / 0.2e1;
  t3363 = t3361 * t690 * t269;
  t3366 = t695 * t183;
  t3367 = t3366 * t290;
  t3368 = t484 * t3367;
  t3369 = 0.3e1 / 0.16e2 * t3368;
  t3370 = t3336 * t986;
  t3373 = t3343 * t972;
  t3376 = t3343 * t1001;
  t3379 = t2251 * t741;
  t3380 = t484 * t3379;
  t3381 = 0.3e1 / 0.16e2 * t3380;
  t3382 = t3336 * t1006;
  t3385 = t3336 * t1013;
  t3388 = -t99 * t3337 / 0.8e1 - t3342 + 0.3e1 / 0.32e2 * t99 * t3344 + t3349 + 0.3e1 / 0.16e2 * t99 * t3350 - 0.3e1 / 0.16e2 * t99 * t3353 - t99 * t3363 / 0.32e2 - t3369 - t99 * t3370 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3373 + 0.3e1 / 0.32e2 * t99 * t3376 + t3381 + t99 * t3382 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3385 - t699;
  t3389 = my_piecewise3(t2, 0, t3388);
  tv3sigma30 = t3 * t3389;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t3390 = t712 * t191;
  t3391 = t157 * t3390;
  t3392 = t3391 * t1344;
  t3395 = t3391 * t1376;
  t3398 = t539 * t2427;
  t3399 = t519 * t3398;
  t3400 = 0.3e1 / 0.32e2 * t3399;
  t3401 = t415 * t3390;
  t3402 = t3401 * t1382;
  t3405 = t2423 * t762;
  t3406 = t534 * t3405;
  t3407 = 0.3e1 / 0.16e2 * t3406;
  t3408 = t3391 * t1369;
  t3411 = t1296 * t191;
  t3413 = t1299 * t191;
  t3416 = t3411 * t173 / 0.2e1 - t3413 * t173 / 0.2e1 + t193 / 0.2e1;
  t3418 = t3416 * t712 * t424;
  t3421 = t717 * t191;
  t3422 = t3421 * t445;
  t3423 = t534 * t3422;
  t3424 = 0.3e1 / 0.16e2 * t3423;
  t3425 = t3391 * t1337;
  t3428 = t3401 * t1344;
  t3431 = t3401 * t1352;
  t3434 = t2404 * t758;
  t3435 = t534 * t3434;
  t3436 = 0.3e1 / 0.16e2 * t3435;
  t3437 = t3391 * t1357;
  t3440 = t3391 * t1364;
  t3443 = -0.3e1 / 0.16e2 * t156 * t3392 - t156 * t3395 / 0.8e1 - t3400 + 0.3e1 / 0.32e2 * t156 * t3402 + t3407 + 0.3e1 / 0.16e2 * t156 * t3408 - t156 * t3418 / 0.32e2 - t3424 - t156 * t3425 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3428 + 0.3e1 / 0.32e2 * t156 * t3431 + t3436 + t156 * t3437 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3440 - t721;
  t3444 = my_piecewise3(t51, 0, t3443);
  tv3sigma39 = t3 * t3444;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3445 = t496 * t695;
  t3446 = t576 * t3445;
  t3447 = t484 * t3446;
  t3448 = t3447 / 0.16e2;
  t3449 = t199 * t695;
  t3450 = t3449 * t290;
  t3451 = t484 * t3450;
  t3452 = t3451 / 0.16e2;
  t3453 = t490 * t695;
  t3454 = t572 * t3453;
  t3455 = t484 * t3454;
  t3456 = t3455 / 0.16e2;
  t3457 = t26 * t3361;
  t3458 = t23 * t3457;
  t3461 = t2251 * t558;
  t3462 = t469 * t3461;
  t3463 = t3462 / 0.32e2;
  t3464 = t3341 / 0.16e2;
  t3465 = t3348 / 0.8e1;
  t3466 = t1432 * t690;
  t3467 = t572 * t3466;
  t3470 = t1516 * t690;
  t3471 = t576 * t3470;
  t3474 = t2255 * t1719;
  t3477 = t199 * t690;
  t3478 = t3477 * t968;
  t3481 = t3368 / 0.8e1;
  t3482 = t3477 * t986;
  t3485 = t3380 / 0.8e1;
  t3488 = t2260 * t1732;
  t3491 = t3477 * t1006;
  t3494 = t1450 * t690;
  t3495 = t1739 * t3494;
  t3498 = t3448 - t3452 + t3456 - t3458 * t734 / 0.32e2 - t3463 - t3464 + t3465 - 0.3e1 / 0.16e2 * t484 * t3467 - t484 * t3471 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3474 + 0.3e1 / 0.16e2 * t484 * t3478 - t3481 - t484 * t3482 / 0.16e2 + t3485 - 0.3e1 / 0.32e2 * t469 * t3467 + 0.3e1 / 0.32e2 * t469 * t3488 + t484 * t3491 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3495 - t699;
  t3499 = my_piecewise3(t2, 0, t3498);
  tv3sigma2lapl0 = t3 * t3499;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3500 = t207 * t717;
  t3501 = t3500 * t445;
  t3502 = t534 * t3501;
  t3503 = t3502 / 0.16e2;
  t3504 = t540 * t717;
  t3505 = t611 * t3504;
  t3506 = t534 * t3505;
  t3507 = t3506 / 0.16e2;
  t3508 = t546 * t717;
  t3509 = t615 * t3508;
  t3510 = t534 * t3509;
  t3511 = t3510 / 0.16e2;
  t3512 = t26 * t3416;
  t3513 = t60 * t3512;
  t3516 = t2404 * t597;
  t3517 = t519 * t3516;
  t3518 = t3517 / 0.32e2;
  t3519 = t3399 / 0.16e2;
  t3520 = t3406 / 0.8e1;
  t3521 = t1628 * t712;
  t3522 = t611 * t3521;
  t3525 = t1633 * t712;
  t3526 = t615 * t3525;
  t3529 = t2382 * t1924;
  t3532 = t207 * t712;
  t3533 = t3532 * t1369;
  t3536 = t3423 / 0.8e1;
  t3537 = t3435 / 0.8e1;
  t3538 = t3532 * t1337;
  t3543 = t2365 * t1893;
  t3546 = t3532 * t1357;
  t3549 = t1650 * t712;
  t3550 = t1901 * t3549;
  t3553 = -t3503 + t3507 + t3511 - t3513 * t751 / 0.32e2 - t3518 - t3519 + t3520 - 0.3e1 / 0.16e2 * t534 * t3522 - t534 * t3526 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3529 + 0.3e1 / 0.16e2 * t534 * t3533 - t3536 + t3537 - t534 * t3538 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t3522 + 0.3e1 / 0.32e2 * t519 * t3543 + t534 * t3546 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3550 - t721;
  t3554 = my_piecewise3(t51, 0, t3553);
  tv3sigma2lapl11 = t3 * t3554;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t3555 = t640 * t3453;
  t3556 = t484 * t3555;
  t3557 = t3556 / 0.16e2;
  t3558 = t644 * t3445;
  t3559 = t484 * t3558;
  t3560 = t3559 / 0.16e2;
  t3563 = t2251 * t626;
  t3564 = t469 * t3563;
  t3565 = t3564 / 0.32e2;
  t3566 = t213 * t695;
  t3567 = t3566 * t290;
  t3568 = t484 * t3567;
  t3569 = t3568 / 0.16e2;
  t3570 = t640 * t3466;
  t3573 = t644 * t3470;
  t3576 = t2255 * t2031;
  t3579 = t213 * t690;
  t3580 = t3579 * t968;
  t3583 = t3579 * t986;
  t3588 = t2260 * t1984;
  t3591 = t3579 * t1006;
  t3594 = t1992 * t3494;
  t3597 = t3557 + t3560 - t3458 * t768 / 0.32e2 - t3565 - t3569 - t3464 + t3465 - 0.3e1 / 0.16e2 * t484 * t3570 - t484 * t3573 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3576 + 0.3e1 / 0.16e2 * t484 * t3580 - t3481 - t484 * t3583 / 0.16e2 + t3485 - 0.3e1 / 0.32e2 * t469 * t3570 + 0.3e1 / 0.32e2 * t469 * t3588 + t484 * t3591 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3594 - t699;
  t3598 = my_piecewise3(t2, 0, t3597);
  tv3sigma2tau0 = t3 * t3598;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t3599 = t683 * t3508;
  t3600 = t534 * t3599;
  t3601 = t3600 / 0.16e2;
  t3602 = t219 * t717;
  t3603 = t3602 * t445;
  t3604 = t534 * t3603;
  t3605 = t3604 / 0.16e2;
  t3606 = t679 * t3504;
  t3607 = t534 * t3606;
  t3608 = t3607 / 0.16e2;
  t3611 = t2404 * t665;
  t3612 = t519 * t3611;
  t3613 = t3612 / 0.32e2;
  t3614 = t219 * t712;
  t3615 = t3614 * t1369;
  t3618 = t679 * t3521;
  t3621 = t683 * t3525;
  t3624 = t2382 * t2161;
  t3627 = t3614 * t1337;
  t3632 = t2365 * t2174;
  t3635 = t3614 * t1357;
  t3638 = t2181 * t3549;
  t3641 = t3601 - t3605 + t3608 - t3513 * t783 / 0.32e2 - t3613 - t3519 + t3520 + 0.3e1 / 0.16e2 * t534 * t3615 - 0.3e1 / 0.16e2 * t534 * t3618 - t534 * t3621 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3624 - t3536 - t534 * t3627 / 0.16e2 + t3537 - 0.3e1 / 0.32e2 * t519 * t3618 + 0.3e1 / 0.32e2 * t519 * t3632 + t534 * t3635 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3638 - t721;
  t3642 = my_piecewise3(t51, 0, t3641);
  tv3sigma2tau11 = t3 * t3642;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3643 = t2856 * t1523;
  t3646 = t1432 * t183;
  t3647 = t2836 * t3646;
  t3650 = t1516 * t183;
  t3651 = t2856 * t3650;
  t3654 = t2836 * t1523;
  t3657 = t3447 / 0.8e1;
  t3658 = t3451 / 0.8e1;
  t3659 = t3455 / 0.8e1;
  t3660 = t3462 / 0.16e2;
  t3661 = t3341 / 0.32e2;
  t3662 = t3348 / 0.16e2;
  t3664 = t3361 * t798 * t269;
  t3667 = t798 * t183;
  t3668 = t3667 * t986;
  t3671 = t3368 / 0.16e2;
  t3674 = t2840 * t1441;
  t3677 = t2836 * t1441;
  t3680 = t1450 * t183;
  t3681 = t2840 * t3680;
  t3684 = t3380 / 0.16e2;
  t3685 = 0.3e1 / 0.16e2 * t484 * t3643 - 0.3e1 / 0.16e2 * t484 * t3647 - t484 * t3651 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3654 + t3657 - t3658 + t3659 - t3660 - t3661 + t3662 - t99 * t3664 / 0.32e2 - t484 * t3668 / 0.16e2 - t3671 - 0.3e1 / 0.32e2 * t469 * t3647 + 0.3e1 / 0.32e2 * t469 * t3674 + t484 * t3677 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3681 + t3684 - t699;
  t3686 = my_piecewise3(t2, 0, t3685);
  tv3sigmalapl20 = t3 * t3686;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3687 = t1628 * t191;
  t3688 = t2935 * t3687;
  t3691 = t1633 * t191;
  t3692 = t2952 * t3691;
  t3695 = t2935 * t1621;
  t3698 = t2952 * t1621;
  t3701 = t3502 / 0.8e1;
  t3702 = t3506 / 0.8e1;
  t3703 = t3510 / 0.8e1;
  t3704 = t3517 / 0.16e2;
  t3705 = t3399 / 0.32e2;
  t3706 = t3406 / 0.16e2;
  t3708 = t3416 * t815 * t424;
  t3711 = t815 * t191;
  t3712 = t3711 * t1337;
  t3715 = t3423 / 0.16e2;
  t3718 = t2939 * t1642;
  t3721 = t2935 * t1642;
  t3724 = t1650 * t191;
  t3725 = t2939 * t3724;
  t3728 = t3435 / 0.16e2;
  t3729 = -0.3e1 / 0.16e2 * t534 * t3688 - t534 * t3692 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3695 + 0.3e1 / 0.16e2 * t534 * t3698 - t3701 + t3702 + t3703 - t3704 - t3705 + t3706 - t156 * t3708 / 0.32e2 - t534 * t3712 / 0.16e2 - t3715 - 0.3e1 / 0.32e2 * t519 * t3688 + 0.3e1 / 0.32e2 * t519 * t3718 + t534 * t3721 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3725 + t3728 - t721;
  t3730 = my_piecewise3(t51, 0, t3729);
  tv3sigmalapl28 = t3 * t3730;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  t3733 = -t3458 * t832 / 0.32e2 + t3557 + t3560 - t3565 - t3569 + t3448 - t3452 + t3456 - t3463 - t3661 + t3662;
  t3734 = t2454 * t183;
  t3735 = t2666 * t3734;
  t3738 = t2653 * t3734;
  t3741 = t2657 * t183;
  t3742 = t3015 * t3741;
  t3745 = t3019 * t1523;
  t3748 = t835 * t183;
  t3749 = t3748 * t986;
  t3754 = t3006 * t3741;
  t3757 = t2992 * t1441;
  t3760 = t2645 * t3734;
  t3763 = -0.3e1 / 0.16e2 * t484 * t3735 - t484 * t3738 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3742 + 0.3e1 / 0.16e2 * t484 * t3745 - t3671 - t484 * t3749 / 0.16e2 + t3684 - 0.3e1 / 0.32e2 * t469 * t3735 + 0.3e1 / 0.32e2 * t469 * t3754 + t484 * t3757 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3760 - t699;
  t3765 = my_piecewise3(t2, 0, t3733 + t3763);
  tv3sigmalapltau0 = t3 * t3765;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  t3768 = -t3513 * t849 / 0.32e2 + t3601 - t3605 + t3608 - t3613 - t3503 + t3507 + t3511 - t3518 - t3705 + t3706;
  t3769 = t3130 * t1621;
  t3772 = t679 * t450;
  t3773 = t2573 * t191;
  t3774 = t3772 * t3773;
  t3777 = t2778 * t3773;
  t3780 = t2762 * t191;
  t3781 = t3126 * t3780;
  t3784 = t852 * t191;
  t3785 = t3784 * t1337;
  t3790 = t3113 * t3780;
  t3793 = t3117 * t1642;
  t3796 = t2758 * t3773;
  t3799 = 0.3e1 / 0.16e2 * t534 * t3769 - 0.3e1 / 0.16e2 * t534 * t3774 - t534 * t3777 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3781 - t3715 - t534 * t3785 / 0.16e2 + t3728 - 0.3e1 / 0.32e2 * t519 * t3774 + 0.3e1 / 0.32e2 * t519 * t3790 + t534 * t3793 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3796 - t721;
  t3801 = my_piecewise3(t51, 0, t3768 + t3799);
  tv3sigmalapltau11 = t3 * t3801;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t3803 = t3361 * t866 * t269;
  t3806 = t3193 * t1523;
  t3809 = t3179 * t3646;
  t3812 = t3193 * t3650;
  t3815 = t3179 * t1523;
  t3818 = t3556 / 0.8e1;
  t3819 = t3559 / 0.8e1;
  t3820 = t3564 / 0.16e2;
  t3821 = t3568 / 0.8e1;
  t3822 = t866 * t183;
  t3823 = t3822 * t986;
  t3828 = t3183 * t1441;
  t3831 = t3179 * t1441;
  t3834 = t3183 * t3680;
  t3837 = -t99 * t3803 / 0.32e2 + 0.3e1 / 0.16e2 * t484 * t3806 - 0.3e1 / 0.16e2 * t484 * t3809 - t484 * t3812 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3815 + t3818 + t3819 - t3820 - t3821 - t3661 + t3662 - t484 * t3823 / 0.16e2 - t3671 - 0.3e1 / 0.32e2 * t469 * t3809 + 0.3e1 / 0.32e2 * t469 * t3828 + t484 * t3831 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3834 + t3684 - t699;
  t3838 = my_piecewise3(t2, 0, t3837);
  tv3sigmatau20 = t3 * t3838;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t3840 = t3416 * t883 * t424;
  t3843 = t3302 * t1621;
  t3846 = t3278 * t3687;
  t3849 = t3302 * t3691;
  t3852 = t3278 * t1621;
  t3855 = t3600 / 0.8e1;
  t3856 = t3604 / 0.8e1;
  t3857 = t3607 / 0.8e1;
  t3858 = t3612 / 0.16e2;
  t3859 = t883 * t191;
  t3860 = t3859 * t1337;
  t3865 = t3282 * t1642;
  t3868 = t3278 * t1642;
  t3871 = t3282 * t3724;
  t3874 = -t156 * t3840 / 0.32e2 + 0.3e1 / 0.16e2 * t534 * t3843 - 0.3e1 / 0.16e2 * t534 * t3846 - t534 * t3849 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t3852 + t3855 - t3856 + t3857 - t3858 - t3705 + t3706 - t534 * t3860 / 0.16e2 - t3715 - 0.3e1 / 0.32e2 * t519 * t3846 + 0.3e1 / 0.32e2 * t519 * t3865 + t534 * t3868 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3871 + t3728 - t721;
  t3875 = my_piecewise3(t51, 0, t3874);
  tv3sigmatau28 = t3 * t3875;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3876 = t1023 * t199;
  t3878 = t1026 * t199;
  t3881 = t3876 * t116 / 0.2e1 - t3878 * t116 / 0.2e1 + t201 / 0.2e1;
  t3883 = t3881 * t798 * t269;
  t3886 = t798 * t199;
  t3887 = t100 * t3886;
  t3888 = t3887 * t972;
  t3891 = t3887 * t959;
  t3894 = t260 * t3886;
  t3895 = t3894 * t964;
  t3898 = t3887 * t968;
  t3901 = 0.3e1 / 0.16e2 * t3447;
  t3902 = 0.3e1 / 0.16e2 * t3451;
  t3903 = 0.3e1 / 0.16e2 * t3455;
  t3904 = 0.3e1 / 0.32e2 * t3462;
  t3905 = t3887 * t986;
  t3908 = t3894 * t972;
  t3911 = t3894 * t1001;
  t3914 = t3887 * t1006;
  t3917 = t3887 * t1013;
  t3920 = -t99 * t3883 / 0.32e2 - 0.3e1 / 0.16e2 * t99 * t3888 - t99 * t3891 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t3895 + 0.3e1 / 0.16e2 * t99 * t3898 + t3901 - t3902 + t3903 - t3904 - t99 * t3905 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t3908 + 0.3e1 / 0.32e2 * t99 * t3911 + t99 * t3914 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t3917 - t699;
  t3921 = my_piecewise3(t2, 0, t3920);
  tv3lapl30 = t3 * t3921;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3922 = t1296 * t207;
  t3924 = t1299 * t207;
  t3927 = t3922 * t173 / 0.2e1 - t3924 * t173 / 0.2e1 + t209 / 0.2e1;
  t3929 = t3927 * t815 * t424;
  t3932 = t815 * t207;
  t3933 = t157 * t3932;
  t3934 = t3933 * t1376;
  t3937 = t415 * t3932;
  t3938 = t3937 * t1382;
  t3941 = t3933 * t1369;
  t3944 = t3933 * t1344;
  t3947 = 0.3e1 / 0.16e2 * t3502;
  t3948 = 0.3e1 / 0.16e2 * t3506;
  t3949 = 0.3e1 / 0.16e2 * t3510;
  t3950 = 0.3e1 / 0.32e2 * t3517;
  t3951 = t3933 * t1337;
  t3954 = t3937 * t1344;
  t3957 = t3937 * t1352;
  t3960 = t3933 * t1357;
  t3963 = t3933 * t1364;
  t3966 = -t156 * t3929 / 0.32e2 - t156 * t3934 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t3938 + 0.3e1 / 0.16e2 * t156 * t3941 - 0.3e1 / 0.16e2 * t156 * t3944 - t3947 + t3948 + t3949 - t3950 - t156 * t3951 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t3954 + 0.3e1 / 0.32e2 * t156 * t3957 + t156 * t3960 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t3963 - t721;
  t3967 = my_piecewise3(t51, 0, t3966);
  tv3lapl33 = t3 * t3967;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  t3968 = t26 * t3881;
  t3969 = t23 * t3968;
  t3972 = t1516 * t798;
  t3973 = t644 * t3972;
  t3976 = t2836 * t2031;
  t3979 = t213 * t798;
  t3980 = t3979 * t968;
  t3984 = t640 * t1432 * t798;
  t3987 = t3979 * t986;
  t3992 = t2840 * t1984;
  t3995 = t3979 * t1006;
  t3998 = t1450 * t798;
  t3999 = t1992 * t3998;
  t4002 = -t3969 * t832 / 0.32e2 + t3557 + t3560 - t3565 - t3569 + t3657 - t3658 + t3659 - t3660 - t484 * t3973 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t3976 + 0.3e1 / 0.16e2 * t484 * t3980 - 0.3e1 / 0.16e2 * t484 * t3984 - t484 * t3987 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t3984 + 0.3e1 / 0.32e2 * t469 * t3992 + t484 * t3995 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3999 - t699;
  t4003 = my_piecewise3(t2, 0, t4002);
  tv3lapl2tau0 = t3 * t4003;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  t4004 = t26 * t3927;
  t4005 = t60 * t4004;
  t4009 = t679 * t1628 * t815;
  t4012 = t1633 * t815;
  t4013 = t683 * t4012;
  t4016 = t2935 * t2161;
  t4019 = t219 * t815;
  t4020 = t4019 * t1369;
  t4023 = t4019 * t1337;
  t4028 = t2939 * t2174;
  t4031 = t4019 * t1357;
  t4034 = t1650 * t815;
  t4035 = t2181 * t4034;
  t4038 = -t4005 * t849 / 0.32e2 + t3601 - t3605 + t3608 - t3613 - t3701 + t3702 + t3703 - t3704 - 0.3e1 / 0.16e2 * t534 * t4009 - t534 * t4013 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t4016 + 0.3e1 / 0.16e2 * t534 * t4020 - t534 * t4023 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4009 + 0.3e1 / 0.32e2 * t519 * t4028 + t534 * t4031 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4035 - t721;
  t4039 = my_piecewise3(t51, 0, t4038);
  tv3lapl2tau5 = t3 * t4039;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  t4041 = t3881 * t866 * t269;
  t4044 = t3193 * t1719;
  t4048 = t3179 * t1432 * t199;
  t4052 = t3193 * t1516 * t199;
  t4055 = t3179 * t1719;
  t4058 = t866 * t199;
  t4059 = t4058 * t986;
  t4064 = t3183 * t1732;
  t4067 = t3179 * t1732;
  t4071 = t3183 * t1450 * t199;
  t4074 = -t99 * t4041 / 0.32e2 + 0.3e1 / 0.16e2 * t484 * t4044 - 0.3e1 / 0.16e2 * t484 * t4048 - t484 * t4052 / 0.8e1 + 0.3e1 / 0.32e2 * t469 * t4055 + t3818 + t3819 - t3820 - t3821 + t3448 - t3452 + t3456 - t3463 - t484 * t4059 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t4048 + 0.3e1 / 0.32e2 * t469 * t4064 + t484 * t4067 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t4071 - t699;
  t4075 = my_piecewise3(t2, 0, t4074);
  tv3lapltau20 = t3 * t4075;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  t4077 = t3927 * t883 * t424;
  t4080 = t3302 * t1924;
  t4083 = t3278 * t1889;
  t4087 = t3302 * t1633 * t207;
  t4090 = t3278 * t1924;
  t4093 = t883 * t207;
  t4094 = t4093 * t1337;
  t4099 = t3282 * t1893;
  t4102 = t3278 * t1893;
  t4106 = t3282 * t1650 * t207;
  t4109 = -t156 * t4077 / 0.32e2 + 0.3e1 / 0.16e2 * t534 * t4080 - 0.3e1 / 0.16e2 * t534 * t4083 - t534 * t4087 / 0.8e1 + 0.3e1 / 0.32e2 * t519 * t4090 + t3855 - t3856 + t3857 - t3858 - t3503 + t3507 + t3511 - t3518 - t534 * t4094 / 0.16e2 - 0.3e1 / 0.32e2 * t519 * t4083 + 0.3e1 / 0.32e2 * t519 * t4099 + t534 * t4102 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t4106 - t721;
  t4110 = my_piecewise3(t51, 0, t4109);
  tv3lapltau25 = t3 * t4110;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4111 = t1023 * t213;
  t4113 = t1026 * t213;
  t4116 = t4111 * t116 / 0.2e1 - t4113 * t116 / 0.2e1 + t215 / 0.2e1;
  t4118 = t4116 * t866 * t269;
  t4121 = t866 * t213;
  t4122 = t100 * t4121;
  t4123 = t4122 * t972;
  t4126 = t4122 * t959;
  t4129 = t260 * t4121;
  t4130 = t4129 * t964;
  t4133 = t4122 * t968;
  t4136 = 0.3e1 / 0.16e2 * t3556;
  t4137 = 0.3e1 / 0.16e2 * t3559;
  t4138 = 0.3e1 / 0.32e2 * t3564;
  t4139 = 0.3e1 / 0.16e2 * t3568;
  t4140 = t4122 * t986;
  t4143 = t4129 * t972;
  t4146 = t4129 * t1001;
  t4149 = t4122 * t1006;
  t4152 = t4122 * t1013;
  t4155 = -t99 * t4118 / 0.32e2 - 0.3e1 / 0.16e2 * t99 * t4123 - t99 * t4126 / 0.8e1 + 0.3e1 / 0.32e2 * t99 * t4130 + 0.3e1 / 0.16e2 * t99 * t4133 + t4136 + t4137 - t4138 - t4139 - t99 * t4140 / 0.16e2 - 0.3e1 / 0.32e2 * t99 * t4143 + 0.3e1 / 0.32e2 * t99 * t4146 + t99 * t4149 / 0.4e1 - 0.3e1 / 0.16e2 * t99 * t4152 - t699;
  t4156 = my_piecewise3(t2, 0, t4155);
  tv3tau30 = t3 * t4156;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4157 = t883 * t219;
  t4158 = t157 * t4157;
  t4159 = t4158 * t1344;
  t4162 = t4158 * t1376;
  t4165 = t415 * t4157;
  t4166 = t4165 * t1382;
  t4169 = t4158 * t1369;
  t4172 = t1296 * t219;
  t4174 = t1299 * t219;
  t4177 = t4172 * t173 / 0.2e1 - t4174 * t173 / 0.2e1 + t221 / 0.2e1;
  t4179 = t4177 * t883 * t424;
  t4182 = 0.3e1 / 0.16e2 * t3600;
  t4183 = 0.3e1 / 0.16e2 * t3604;
  t4184 = 0.3e1 / 0.16e2 * t3607;
  t4185 = 0.3e1 / 0.32e2 * t3612;
  t4186 = t4158 * t1337;
  t4189 = t4165 * t1344;
  t4192 = t4165 * t1352;
  t4195 = t4158 * t1357;
  t4198 = t4158 * t1364;
  t4201 = -0.3e1 / 0.16e2 * t156 * t4159 - t156 * t4162 / 0.8e1 + 0.3e1 / 0.32e2 * t156 * t4166 + 0.3e1 / 0.16e2 * t156 * t4169 - t156 * t4179 / 0.32e2 + t4182 - t4183 + t4184 - t4185 - t156 * t4186 / 0.16e2 - 0.3e1 / 0.32e2 * t156 * t4189 + 0.3e1 / 0.32e2 * t156 * t4192 + t156 * t4195 / 0.4e1 - 0.3e1 / 0.16e2 * t156 * t4198 - t721;
  t4202 = my_piecewise3(t51, 0, t4201);
  tv3tau33 = t3 * t4202;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t4205 = t283 * t261;
  t4219 = t1045 * t263;
  t4225 = t1462 * t941;
  t4227 = t1440 * t283;
  t4231 = t1462 * t945;
  t4237 = t1432 * t283;
  t4238 = t1521 * t4237;
  t4241 = 0.3e1 / 0.2e1 * t484 * t4205 * t1006 - 0.9e1 / 0.8e1 * t484 * t283 * t997 * t1451 + 0.9e1 / 0.8e1 * t484 * t4205 * t968 - 0.3e1 / 0.8e1 * t484 * t4205 * t986 + t484 * t4219 * t491 / 0.4e1 + 0.3e1 / 0.4e1 * t1455 * t941 + 0.3e1 / 0.8e1 * t4225 + 0.9e1 / 0.16e2 * t469 * t1439 * t4227 - 0.3e1 / 0.8e1 * t4231 - t484 * t1045 * t111 * t290 / 0.4e1 - 0.9e1 / 0.16e2 * t469 * t4238;
  t4245 = t1516 * t283;
  t4261 = t1462 * t937;
  t4263 = t1466 * t933;
  t4267 = t1522 * t283;
  t4273 = t261 * t261;
  t4274 = t100 * t4273;
  t4275 = t263 * t263;
  t4277 = 0.1e1 / t998 / t294;
  t4279 = t267 * t267;
  t4280 = 0.1e1 / t4279;
  t4281 = t4275 * t4277 * t4280;
  t4285 = -0.3e1 / 0.4e1 * t1455 * t945 - 0.3e1 / 0.4e1 * t484 * t261 * t43 * t4245 + t484 * t1045 * t43 * t497 / 0.4e1 - t469 * t470 * t471 * t1045 / 0.8e1 + 0.3e1 / 0.4e1 * t1455 * t937 - 0.3e1 / 0.8e1 * t1458 * t933 + 0.3e1 / 0.8e1 * t4261 - 0.3e1 / 0.16e2 * t4263 - 0.5e1 / 0.32e2 * t1470 * t933 + 0.9e1 / 0.16e2 * t469 * t1521 * t4267 - 0.9e1 / 0.8e1 * t484 * t4238 + 0.15e2 / 0.16e2 * t99 * t4274 * t4281;
  t4293 = t255 * t994;
  t4295 = t260 * t4273;
  t4296 = t1005 * t4280;
  t4300 = t241 * t95;
  t4301 = t4300 * t117;
  t4303 = t91 * t251;
  t4304 = t4303 * t117;
  t4306 = t23 * t908;
  t4307 = t4306 * t117;
  t4309 = t289 * t4280;
  t4315 = t255 * t987;
  t4317 = 0.3e1 / 0.4e1 * t246 * t969 - 0.3e1 / 0.8e1 * t1050 * t291 - 0.3e1 / 0.8e1 * t246 * t994 - 0.3e1 / 0.16e2 * t4293 - 0.7e1 / 0.32e2 * t99 * t4295 * t4296 - 0.3e1 / 0.8e1 * t4301 + 0.3e1 / 0.16e2 * t4304 - 0.3e1 / 0.32e2 * t4307 - 0.11e2 / 0.16e2 * t99 * t4274 * t4309 - t246 * t987 / 0.4e1 - t4315 / 0.8e1;
  t4319 = t43 * t999 * t4280;
  t4323 = t296 * t4280;
  t4328 = t255 * t1007;
  t4331 = t263 * t1011 * t4280;
  t4337 = t255 * t1014;
  t4339 = t1012 * t4280;
  t4344 = 0.1e1 / t998 / t264;
  t4346 = t4275 * t4344 * t4280;
  t4351 = t997 * t4344 * t4280;
  t4355 = t114 * t4280;
  t4359 = t283 * t283;
  t4364 = -t99 * t4274 * t4319 / 0.16e2 + 0.11e2 / 0.16e2 * t99 * t4274 * t4323 + t246 * t1007 + t4328 / 0.2e1 + 0.11e2 / 0.16e2 * t99 * t4274 * t4331 - 0.3e1 / 0.4e1 * t246 * t1014 - 0.3e1 / 0.8e1 * t4337 + 0.11e2 / 0.16e2 * t99 * t4295 * t4339 - 0.15e2 / 0.32e2 * t99 * t4295 * t4346 - 0.25e2 / 0.16e2 * t99 * t4274 * t4351 + 0.3e1 / 0.8e1 * t99 * t4274 * t4355 - 0.3e1 / 0.32e2 * t99 * t260 * t4359 * t269;
  t4369 = t1053 * t302;
  t4371 = t952 * t285;
  t4373 = t952 * t270;
  t4375 = t255 * t965;
  t4377 = t1030 * t955;
  t4381 = t1000 * t4280;
  t4385 = t100 * t4359;
  t4395 = t1053 * t298;
  t4397 = 0.3e1 / 0.8e1 * t1050 * t302 + 0.3e1 / 0.8e1 * t4369 + 0.3e1 / 0.32e2 * t4371 + 0.3e1 / 0.64e2 * t4373 + 0.3e1 / 0.16e2 * t4375 + 0.5e1 / 0.32e2 * t99 * t4377 * t964 - 0.9e1 / 0.16e2 * t99 * t4295 * t4381 + 0.3e1 / 0.16e2 * t99 * t4385 * t297 - 0.3e1 / 0.2e1 * t99 * t4274 * t4296 + 0.9e1 / 0.8e1 * t99 * t4274 * t4339 + 0.3e1 / 0.8e1 * t4395;
  t4400 = t952 * t298;
  t4402 = t255 * t973;
  t4407 = t952 * t291;
  t4409 = t255 * t969;
  t4414 = t985 * t4280;
  t4418 = t1053 * t291;
  t4422 = t266 * t4280;
  t4428 = -0.3e1 / 0.4e1 * t246 * t973 - 0.3e1 / 0.32e2 * t4400 - 0.3e1 / 0.8e1 * t4402 + 0.9e1 / 0.16e2 * t99 * t4295 * t4323 + 0.3e1 / 0.32e2 * t4407 + 0.3e1 / 0.8e1 * t4409 - 0.3e1 / 0.16e2 * t99 * t4385 * t290 + 0.3e1 / 0.8e1 * t99 * t4274 * t4414 - 0.3e1 / 0.8e1 * t4418 - t246 * t960 / 0.2e1 - 0.11e2 / 0.32e2 * t99 * t4295 * t4422 - 0.3e1 / 0.8e1 * t1050 * t285;
  t4432 = t929 * t26;
  t4435 = t1053 * t285;
  t4437 = t255 * t1047;
  t4439 = t1053 * t270;
  t4441 = t255 * t1032;
  t4452 = 0.1e1 / t1021 / t45 * t100;
  t4456 = t1022 * t260;
  t4463 = t1023 * t261;
  t4470 = t258 * t1030;
  t4477 = t1026 * t261;
  t4484 = t270 / 0.4e1 + t285 / 0.2e1 + t291 / 0.2e1 - t298 / 0.2e1 - t302 / 0.2e1 - t4452 * t261 * t269 / 0.2e1 + t4456 * t261 * t269 / 0.2e1 + t1023 * t283 * t116 / 0.2e1 + t4463 * t290 / 0.2e1 - t4463 * t297 / 0.2e1 - t4463 * t301 / 0.2e1 - t4470 * t111 * t116 / 0.2e1 - t1026 * t283 * t116 / 0.2e1 - t4477 * t290 / 0.2e1 + t4477 * t297 / 0.2e1 + t4477 * t301 / 0.2e1;
  t4501 = my_piecewise3(t39, (0.3e2 * lapl[0] * t1040 - 0.12e3 * tau[0] * t1040 + 0.45e2 * sigma[0] / t105 / t32) * t37, 0);
  t4510 = -0.3e1 / 0.16e2 * t1050 * t270 - t4432 * t117 / 0.4e1 - 0.3e1 / 0.8e1 * t4435 - t4437 / 0.8e1 - 0.3e1 / 0.16e2 * t4439 - t4441 / 0.16e2 - t246 * t1032 / 0.8e1 - t99 * t4484 * t261 * t269 / 0.32e2 - t246 * t1047 / 0.4e1 - t99 * t100 * t4501 * t116 / 0.16e2 + 0.3e1 / 0.8e1 * t1050 * t298 + 0.3e1 / 0.8e1 * t246 * t1002;
  t4511 = t255 * t1002;
  t4524 = t952 * t302;
  t4526 = t255 * t960;
  t4528 = t241 * t252;
  t4530 = t91 * t909;
  t4534 = t24 / t25 / t231;
  t4537 = 0.15e2 / 0.128e3 * t23 * t4534 * t46;
  t4538 = t16 * t16;
  t4540 = 0.1e1 / t20 / t4538;
  t4541 = t228 * t228;
  t4547 = t236 * t236;
  t4553 = 0.1e1 / t919 / t3;
  t4554 = t13 * t4553;
  t4557 = my_piecewise5(t7, 0, t11, 0, -0.24e2 * t920 + 0.24e2 * t4554);
  t4561 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4540 * t4541 - 0.9e1 / 0.4e1 * t912 * t228 * t236 + 0.9e1 / 0.4e1 * t227 * t4547 + 0.3e1 * t916 * t924 + 0.3e1 / 0.2e1 * t20 * t4557);
  t4565 = t929 * t96;
  t4567 = 0.3e1 / 0.16e2 * t4511 - 0.5e1 / 0.32e2 * t99 * t4377 * t972 + 0.5e1 / 0.32e2 * t99 * t4377 * t1001 + 0.3e1 / 0.16e2 * t99 * t4385 * t301 + 0.3e1 / 0.8e1 * t246 * t965 - 0.3e1 / 0.32e2 * t4524 - t4526 / 0.4e1 + 0.3e1 / 0.16e2 * t4528 - 0.3e1 / 0.16e2 * t4530 + t4537 - M_PI * t4561 * t47 / 0.8e1 - t4565 / 0.4e1;
  t4571 = my_piecewise3(t2, 0, t4241 + t4285 + t4317 + t4364 + t4397 + t4428 + t4510 + t4567);
  t4572 = t55 * t55;
  t4574 = 0.1e1 / t57 / t4572;
  t4575 = t308 * t308;
  t4581 = t314 * t314;
  t4586 = t52 * t4553;
  t4589 = my_piecewise5(t11, 0, t7, 0, 0.24e2 * t920 + 0.24e2 * t4586);
  t4593 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t4575 - 0.9e1 / 0.4e1 * t1059 * t308 * t314 + 0.9e1 / 0.4e1 * t307 * t4581 + 0.3e1 * t1063 * t1069 + 0.3e1 / 0.2e1 * t57 * t4589);
  t4597 = t1074 * t131;
  t4599 = t319 * t324;
  t4601 = t128 * t1081;
  t4605 = 0.15e2 / 0.128e3 * t60 * t4534 * t78;
  t4607 = my_piecewise3(t51, 0, -M_PI * t4593 * t79 / 0.8e1 - t4597 / 0.4e1 + 0.3e1 / 0.16e2 * t4599 - 0.3e1 / 0.16e2 * t4601 + t4605);
  tv4rho40 = 0.4e1 * t1058 + 0.4e1 * t1085 + t3 * (t4571 + t4607);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t4624 = t1124 * t291;
  t4636 = t1124 * t285;
  t4638 = t1124 * t270;
  t4640 = 0.3e1 / 0.16e2 * t1553 * t941 + 0.3e1 / 0.16e2 * t1553 * t937 - 0.3e1 / 0.32e2 * t1548 * t933 - 0.3e1 / 0.16e2 * t1553 * t945 + 0.3e1 / 0.32e2 * t4225 - 0.3e1 / 0.32e2 * t4231 + 0.3e1 / 0.32e2 * t4261 - 0.3e1 / 0.64e2 * t4263 - 0.3e1 / 0.32e2 * t4624 + 0.3e1 / 0.16e2 * t345 * t969 - t345 * t987 / 0.16e2 + t345 * t1007 / 0.4e1 - 0.3e1 / 0.16e2 * t345 * t1014 - t345 * t960 / 0.8e1 - 0.3e1 / 0.32e2 * t4636 - 0.3e1 / 0.64e2 * t4638;
  t4645 = t340 * t95;
  t4646 = t4645 * t117;
  t4648 = t143 * t251;
  t4649 = t4648 * t117;
  t4650 = 0.3e1 / 0.64e2 * t4649;
  t4659 = t1106 * t26;
  t4668 = t1124 * t298;
  t4674 = t1124 * t302;
  t4676 = -t345 * t1047 / 0.16e2 - t345 * t1032 / 0.32e2 - 0.3e1 / 0.16e2 * t4646 + t4650 + 0.3e1 / 0.16e2 * t1121 * t298 + 0.3e1 / 0.32e2 * t345 * t1002 - 0.3e1 / 0.16e2 * t1121 * t285 - 0.3e1 / 0.32e2 * t1121 * t270 - 0.3e1 / 0.16e2 * t4659 * t117 - 0.3e1 / 0.16e2 * t1121 * t291 - 0.3e1 / 0.32e2 * t345 * t994 + 0.3e1 / 0.32e2 * t345 * t965 + 0.3e1 / 0.32e2 * t4668 - 0.3e1 / 0.16e2 * t345 * t973 + 0.3e1 / 0.16e2 * t1121 * t302 + 0.3e1 / 0.32e2 * t4674;
  t4694 = -0.3e1 / 0.64e2 * t4293 - 0.3e1 / 0.32e2 * t4301 + 0.3e1 / 0.32e2 * t4304 - 0.9e1 / 0.128e3 * t4307 - t4315 / 0.32e2 + t4328 / 0.8e1 - 0.3e1 / 0.32e2 * t4337 + 0.3e1 / 0.32e2 * t4369 + 0.3e1 / 0.64e2 * t4371 + 0.3e1 / 0.128e3 * t4373 + 0.3e1 / 0.64e2 * t4375 + 0.3e1 / 0.32e2 * t4395 - 0.3e1 / 0.64e2 * t4400 - 0.3e1 / 0.32e2 * t4402 + 0.3e1 / 0.64e2 * t4407 + 0.3e1 / 0.32e2 * t4409;
  t4722 = 0.12e2 * t920;
  t4723 = 0.24e2 * t4554;
  t4725 = my_piecewise5(t7, 0, t11, 0, -t4722 + t4723);
  t4729 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4540 * t139 * t913 - 0.9e1 / 0.8e1 * t912 * t335 * t228 - 0.9e1 / 0.8e1 * t1090 * t87 * t236 + 0.9e1 / 0.4e1 * t227 * t1101 * t87 + 0.9e1 / 0.4e1 * t1093 * t236 + 0.3e1 / 0.4e1 * t331 * t924 + 0.3e1 / 0.2e1 * t20 * t4725);
  t4733 = t143 * t909;
  t4735 = t1106 * t96;
  t4737 = t340 * t252;
  t4738 = 0.3e1 / 0.32e2 * t4737;
  t4739 = -0.3e1 / 0.32e2 * t4418 - 0.3e1 / 0.32e2 * t4435 - t4437 / 0.32e2 - 0.3e1 / 0.64e2 * t4439 - t4441 / 0.64e2 + 0.3e1 / 0.64e2 * t4511 - 0.3e1 / 0.64e2 * t4524 - t4526 / 0.16e2 + 0.3e1 / 0.32e2 * t4528 - 0.9e1 / 0.64e2 * t4530 + t4537 - t4565 / 0.16e2 - M_PI * t4729 * t47 / 0.8e1 - 0.3e1 / 0.64e2 * t4733 - 0.3e1 / 0.16e2 * t4735 + t4738;
  t4742 = my_piecewise3(t2, 0, t4640 + t4676 + t4694 + t4739);
  t4759 = 0.24e2 * t4586;
  t4761 = my_piecewise5(t11, 0, t7, 0, t4722 + t4759);
  t4765 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t149 * t1060 - 0.9e1 / 0.8e1 * t1059 * t356 * t308 - 0.9e1 / 0.8e1 * t1140 * t124 * t314 + 0.9e1 / 0.4e1 * t307 * t1150 * t124 + 0.9e1 / 0.4e1 * t1143 * t314 + 0.3e1 / 0.4e1 * t352 * t1069 + 0.3e1 / 0.2e1 * t57 * t4761);
  t4769 = t1155 * t131;
  t4771 = t361 * t324;
  t4772 = 0.3e1 / 0.32e2 * t4771;
  t4773 = t153 * t1081;
  t4778 = t1074 * t26;
  t4781 = t319 * t95;
  t4782 = t4781 * t174;
  t4784 = t128 * t251;
  t4785 = t4784 * t174;
  t4786 = 0.3e1 / 0.64e2 * t4785;
  t4787 = t60 * t908;
  t4788 = t4787 * t174;
  t4790 = -M_PI * t4765 * t79 / 0.8e1 - 0.3e1 / 0.16e2 * t4769 + t4772 - 0.3e1 / 0.64e2 * t4773 - t4597 / 0.16e2 + 0.3e1 / 0.32e2 * t4599 - 0.9e1 / 0.64e2 * t4601 + t4605 - t4778 * t174 / 0.16e2 - 0.3e1 / 0.32e2 * t4782 + t4786 - 0.3e1 / 0.128e3 * t4788;
  t4791 = my_piecewise3(t51, 0, t4790);
  tv4rho41 = t1058 + t1085 + 0.3e1 * t1139 + 0.3e1 * t1174 + t3 * (t4742 + t4791);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4802 = t1191 * t26;
  t4805 = t389 * t95;
  t4806 = t4805 * t117;
  t4822 = t1196 * t298 / 0.16e2 + t1196 * t302 / 0.16e2 - t4802 * t117 / 0.8e1 - t4806 / 0.16e2 - t1196 * t285 / 0.16e2 - t1196 * t270 / 0.32e2 - t1196 * t291 / 0.16e2 - t4624 / 0.16e2 - t4636 / 0.16e2 - t4638 / 0.32e2 - t4646 / 0.8e1 + t4649 / 0.16e2 + t4668 / 0.16e2 + t4674 / 0.16e2 + t4304 / 0.32e2;
  t4837 = t335 * t335;
  t4850 = my_piecewise5(t7, 0, t11, 0, t4723);
  t4854 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4540 * t379 * t228 - 0.3e1 / 0.2e1 * t1090 * t87 * t335 - 0.3e1 / 0.8e1 * t1177 * t236 + 0.3e1 / 0.2e1 * t227 * t4837 + 0.3e1 / 0.2e1 * t331 * t1101 - 0.3e1 / 0.8e1 * t912 * t384 * t228 + 0.3e1 / 0.2e1 * t227 * t1186 * t87 + 0.3e1 / 0.4e1 * t1182 * t236 + 0.3e1 / 0.2e1 * t20 * t4850);
  t4858 = t389 * t252;
  t4860 = t1191 * t96;
  t4867 = -0.3e1 / 0.64e2 * t4307 + t4371 / 0.64e2 + t4373 / 0.128e3 - t4400 / 0.64e2 + t4407 / 0.64e2 - t4524 / 0.64e2 - M_PI * t4854 * t47 / 0.8e1 + t4858 / 0.32e2 - t4860 / 0.8e1 + t4528 / 0.32e2 - 0.3e1 / 0.32e2 * t4530 + t4537 - 0.3e1 / 0.32e2 * t4733 - t4735 / 0.8e1 + t4737 / 0.8e1;
  t4869 = my_piecewise3(t2, 0, t4822 + t4867);
  t4880 = t1155 * t26;
  t4883 = t1167 * t457;
  t4885 = t1170 * t457;
  t4887 = t1170 * t440;
  t4889 = t1167 * t446;
  t4891 = t1170 * t446;
  t4893 = t1167 * t453;
  t4895 = t1170 * t453;
  t4897 = t1167 * t425;
  t4899 = t1170 * t425;
  t4901 = t1164 * t457 / 0.16e2 - t1164 * t446 / 0.16e2 + t1164 * t453 / 0.16e2 - t1164 * t425 / 0.32e2 - t1164 * t440 / 0.16e2 - t4880 * t174 / 0.8e1 + t4883 / 0.16e2 - t4885 / 0.64e2 + t4887 / 0.64e2 - t4889 / 0.16e2 + t4891 / 0.64e2 + t4893 / 0.16e2 - t4895 / 0.64e2 - t4897 / 0.32e2 + t4899 / 0.128e3;
  t4902 = t1167 * t440;
  t4904 = t361 * t95;
  t4905 = t4904 * t174;
  t4907 = t153 * t251;
  t4908 = t4907 * t174;
  t4924 = t356 * t356;
  t4937 = my_piecewise5(t11, 0, t7, 0, t4759);
  t4941 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t395 * t308 - 0.3e1 / 0.2e1 * t1140 * t124 * t356 - 0.3e1 / 0.8e1 * t1204 * t314 + 0.3e1 / 0.2e1 * t307 * t4924 + 0.3e1 / 0.2e1 * t352 * t1150 - 0.3e1 / 0.8e1 * t1059 * t400 * t308 + 0.3e1 / 0.2e1 * t307 * t1213 * t124 + 0.3e1 / 0.4e1 * t1209 * t314 + 0.3e1 / 0.2e1 * t57 * t4937);
  t4945 = t405 * t324;
  t4947 = t1218 * t131;
  t4951 = -t4902 / 0.16e2 - t4905 / 0.8e1 + t4908 / 0.32e2 - t4782 / 0.16e2 + t4785 / 0.16e2 - 0.3e1 / 0.64e2 * t4788 - t4769 / 0.8e1 + t4771 / 0.8e1 - 0.3e1 / 0.32e2 * t4773 - M_PI * t4941 * t79 / 0.8e1 + t4945 / 0.32e2 - t4947 / 0.8e1 + t4599 / 0.32e2 - 0.3e1 / 0.32e2 * t4601 + t4605;
  t4953 = my_piecewise3(t51, 0, t4901 + t4951);
  tv4rho42 = 0.2e1 * t1139 + 0.2e1 * t1174 + 0.2e1 * t1203 + 0.2e1 * t1253 + t3 * (t4869 + t4953);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4974 = my_piecewise5(t7, 0, t11, 0, t4722 + t4723);
  t4978 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4540 * t1258 * t87 - 0.9e1 / 0.8e1 * t1177 * t335 - 0.9e1 / 0.8e1 * t1090 * t384 * t87 + 0.9e1 / 0.4e1 * t1093 * t384 + 0.9e1 / 0.4e1 * t331 * t1186 + 0.3e1 / 0.4e1 * t227 * t1265 * t87 + 0.3e1 / 0.2e1 * t20 * t4974);
  t4982 = t1270 * t96;
  t4984 = t1270 * t26;
  t4993 = -M_PI * t4978 * t47 / 0.8e1 - t4982 / 0.16e2 - t4984 * t117 / 0.16e2 - 0.3e1 / 0.16e2 * t4860 + 0.3e1 / 0.32e2 * t4858 - 0.3e1 / 0.32e2 * t4806 + t4738 - 0.9e1 / 0.64e2 * t4733 + t4650 - 0.3e1 / 0.64e2 * t4530 + t4537 - 0.3e1 / 0.128e3 * t4307;
  t4994 = my_piecewise3(t2, 0, t4993);
  t4995 = t1589 * t1395;
  t4997 = t1589 * t1399;
  t4999 = t1589 * t1387;
  t5001 = t1578 * t1391;
  t5011 = t370 * t1353;
  t5013 = t370 * t1358;
  t5015 = t370 * t1365;
  t5017 = t370 * t1338;
  t5019 = t1227 * t453;
  t5021 = t370 * t1345;
  t5023 = t370 * t1320;
  t5025 = t405 * t95;
  t5026 = t5025 * t174;
  t5028 = 0.3e1 / 0.32e2 * t4995 - 0.3e1 / 0.32e2 * t4997 + 0.3e1 / 0.32e2 * t4999 - 0.3e1 / 0.64e2 * t5001 + 0.3e1 / 0.16e2 * t1585 * t1387 - 0.3e1 / 0.16e2 * t1585 * t1399 - 0.3e1 / 0.32e2 * t1574 * t1391 + 0.3e1 / 0.16e2 * t1585 * t1395 + 0.3e1 / 0.64e2 * t5011 + t5013 / 0.8e1 - 0.3e1 / 0.32e2 * t5015 - t5017 / 0.32e2 + 0.3e1 / 0.32e2 * t5019 - 0.3e1 / 0.64e2 * t5021 - t5023 / 0.32e2 - 0.3e1 / 0.32e2 * t5026;
  t5029 = t1227 * t440;
  t5031 = t1227 * t425;
  t5033 = t1227 * t446;
  t5035 = t370 * t1305;
  t5057 = t1218 * t26;
  t5062 = -0.3e1 / 0.32e2 * t5029 - 0.3e1 / 0.64e2 * t5031 - 0.3e1 / 0.32e2 * t5033 - t5035 / 0.64e2 - 0.3e1 / 0.16e2 * t367 * t1373 - t367 * t1377 / 0.8e1 + 0.3e1 / 0.16e2 * t1224 * t457 + 0.3e1 / 0.32e2 * t367 * t1383 + 0.3e1 / 0.16e2 * t1224 * t453 - 0.3e1 / 0.32e2 * t367 * t1345 + 0.3e1 / 0.32e2 * t367 * t1353 + t367 * t1358 / 0.4e1 - 0.3e1 / 0.16e2 * t367 * t1365 + 0.3e1 / 0.16e2 * t367 * t1370 - 0.3e1 / 0.16e2 * t5057 * t174 - 0.3e1 / 0.16e2 * t1224 * t440;
  t5074 = t370 * t1383;
  t5076 = t370 * t1370;
  t5078 = t370 * t1373;
  t5080 = t370 * t1377;
  t5082 = t1227 * t457;
  t5090 = -0.3e1 / 0.32e2 * t1224 * t425 - 0.3e1 / 0.16e2 * t1224 * t446 - t367 * t1338 / 0.16e2 - t367 * t1305 / 0.32e2 - t367 * t1320 / 0.16e2 + 0.3e1 / 0.64e2 * t5074 + 0.3e1 / 0.32e2 * t5076 - 0.3e1 / 0.32e2 * t5078 - t5080 / 0.16e2 + 0.3e1 / 0.32e2 * t5082 + 0.3e1 / 0.32e2 * t4883 - 0.3e1 / 0.64e2 * t4885 + 0.3e1 / 0.64e2 * t4887 - 0.3e1 / 0.32e2 * t4889 + 0.3e1 / 0.64e2 * t4891 + 0.3e1 / 0.32e2 * t4893;
  t5114 = my_piecewise5(t11, 0, t7, 0, -t4722 + t4759);
  t5118 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t1279 * t124 - 0.9e1 / 0.8e1 * t1204 * t356 - 0.9e1 / 0.8e1 * t1140 * t400 * t124 + 0.9e1 / 0.4e1 * t1143 * t400 + 0.9e1 / 0.4e1 * t352 * t1213 + 0.3e1 / 0.4e1 * t307 * t1286 * t124 + 0.3e1 / 0.2e1 * t57 * t5114);
  t5122 = t1291 * t131;
  t5128 = -0.3e1 / 0.64e2 * t4895 - 0.3e1 / 0.64e2 * t4897 + 0.3e1 / 0.128e3 * t4899 - 0.3e1 / 0.32e2 * t4902 - 0.3e1 / 0.16e2 * t4905 + 0.3e1 / 0.32e2 * t4908 + t4786 - 0.9e1 / 0.128e3 * t4788 - M_PI * t5118 * t79 / 0.8e1 - t5122 / 0.16e2 + t4772 - 0.9e1 / 0.64e2 * t4773 + 0.3e1 / 0.32e2 * t4945 - 0.3e1 / 0.16e2 * t4947 - 0.3e1 / 0.64e2 * t4601 + t4605;
  t5131 = my_piecewise3(t51, 0, t5028 + t5062 + t5090 + t5128);
  tv4rho43 = 0.3e1 * t1203 + 0.3e1 * t1253 + t1276 + t1411 + t3 * (t4994 + t5131);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t5136 = t379 * t379;
  t5141 = t384 * t384;
  t5148 = my_piecewise5(t7, 0, t11, 0, 0.24e2 * t920 + 0.24e2 * t4554);
  t5152 = my_piecewise3(t17, 0, 0.9e1 / 0.16e2 * t4540 * t5136 - 0.9e1 / 0.4e1 * t1177 * t384 + 0.9e1 / 0.4e1 * t227 * t5141 + 0.3e1 * t331 * t1265 + 0.3e1 / 0.2e1 * t20 * t5148);
  t5160 = my_piecewise3(t2, 0, -M_PI * t5152 * t47 / 0.8e1 - t4982 / 0.4e1 + 0.3e1 / 0.16e2 * t4858 - 0.3e1 / 0.16e2 * t4733 + t4537);
  t5161 = t1386 * t1629;
  t5164 = t1620 * t438;
  t5168 = t438 * t416;
  t5178 = t1318 * t418;
  t5194 = t1641 * t438;
  t5198 = -0.9e1 / 0.8e1 * t534 * t5161 + 0.9e1 / 0.16e2 * t519 * t1619 * t5164 + 0.9e1 / 0.8e1 * t534 * t5168 * t1369 - t534 * t1318 * t168 * t445 / 0.4e1 - 0.3e1 / 0.4e1 * t1667 * t1399 + t534 * t5178 * t541 / 0.4e1 + 0.3e1 / 0.4e1 * t1667 * t1387 - 0.3e1 / 0.8e1 * t534 * t5168 * t1337 - 0.9e1 / 0.8e1 * t534 * t438 * t1348 * t1651 + 0.3e1 / 0.2e1 * t534 * t5168 * t1357 + 0.9e1 / 0.16e2 * t519 * t1640 * t5194;
  t5216 = t1633 * t438;
  t5226 = -0.9e1 / 0.16e2 * t519 * t5161 + t534 * t1318 * t75 * t547 / 0.4e1 - t519 * t520 * t521 * t1318 / 0.8e1 + 0.3e1 / 0.4e1 * t1667 * t1395 - 0.3e1 / 0.8e1 * t1670 * t1391 - 0.5e1 / 0.32e2 * t1674 * t1391 - 0.3e1 / 0.4e1 * t534 * t416 * t75 * t5216 + 0.3e1 / 0.8e1 * t4995 - 0.3e1 / 0.8e1 * t4997 + 0.3e1 / 0.8e1 * t4999 - 0.3e1 / 0.16e2 * t5001 - 0.3e1 / 0.8e1 * t1323 * t446;
  t5230 = t416 * t416;
  t5231 = t157 * t5230;
  t5233 = t422 * t422;
  t5234 = 0.1e1 / t5233;
  t5235 = t75 * t1350 * t5234;
  t5239 = t1303 * t1332;
  t5254 = t418 * t1362 * t5234;
  t5262 = -t409 * t1338 / 0.4e1 - t156 * t5231 * t5235 / 0.16e2 - 0.5e1 / 0.32e2 * t156 * t5239 * t1344 + 0.5e1 / 0.32e2 * t156 * t5239 * t1352 + 0.3e1 / 0.8e1 * t1323 * t453 - 0.3e1 / 0.8e1 * t409 * t1345 + 0.3e1 / 0.8e1 * t409 * t1353 + t409 * t1358 + 0.11e2 / 0.16e2 * t156 * t5231 * t5254 - 0.3e1 / 0.4e1 * t409 * t1365 - t409 * t1305 / 0.8e1;
  t5270 = 0.1e1 / t1294 / t77 * t157;
  t5274 = t1295 * t415;
  t5281 = t1296 * t416;
  t5288 = t413 * t1303;
  t5295 = t1299 * t416;
  t5302 = t425 / 0.4e1 + t440 / 0.2e1 + t446 / 0.2e1 - t453 / 0.2e1 - t457 / 0.2e1 - t5270 * t416 * t424 / 0.2e1 + t5274 * t416 * t424 / 0.2e1 + t1296 * t438 * t173 / 0.2e1 + t5281 * t445 / 0.2e1 - t5281 * t452 / 0.2e1 - t5281 * t456 / 0.2e1 - t5288 * t168 * t173 / 0.2e1 - t1299 * t438 * t173 / 0.2e1 - t5295 * t445 / 0.2e1 + t5295 * t452 / 0.2e1 + t5295 * t456 / 0.2e1;
  t5319 = my_piecewise3(t72, (0.3e2 * lapl[1] * t1313 - 0.12e3 * tau[1] * t1313 + 0.45e2 * sigma[2] / t162 / t66) * t37, 0);
  t5324 = t1291 * t26;
  t5333 = t415 * t5230;
  t5334 = t421 * t5234;
  t5338 = t1363 * t5234;
  t5342 = t418 * t418;
  t5344 = 0.1e1 / t1349 / t419;
  t5346 = t5342 * t5344 * t5234;
  t5351 = t1348 * t5344 * t5234;
  t5356 = 0.1e1 / t1349 / t449;
  t5358 = t5342 * t5356 * t5234;
  t5362 = -t156 * t5302 * t416 * t424 / 0.32e2 - t409 * t1320 / 0.4e1 - t156 * t157 * t5319 * t173 / 0.16e2 - t5324 * t174 / 0.4e1 - 0.3e1 / 0.8e1 * t1323 * t440 - 0.3e1 / 0.16e2 * t1323 * t425 - t409 * t1377 / 0.2e1 - 0.11e2 / 0.32e2 * t156 * t5333 * t5334 + 0.11e2 / 0.16e2 * t156 * t5333 * t5338 - 0.15e2 / 0.32e2 * t156 * t5333 * t5346 - 0.25e2 / 0.16e2 * t156 * t5231 * t5351 + 0.15e2 / 0.16e2 * t156 * t5231 * t5358;
  t5365 = t438 * t438;
  t5366 = t157 * t5365;
  t5370 = t451 * t5234;
  t5374 = t171 * t5234;
  t5382 = t1356 * t5234;
  t5389 = t444 * t5234;
  t5398 = t1351 * t5234;
  t5405 = 0.3e1 / 0.16e2 * t156 * t5366 * t456 + 0.11e2 / 0.16e2 * t156 * t5231 * t5370 + 0.3e1 / 0.8e1 * t156 * t5231 * t5374 - 0.3e1 / 0.32e2 * t156 * t415 * t5365 * t424 - 0.3e1 / 0.2e1 * t156 * t5231 * t5382 + 0.9e1 / 0.8e1 * t156 * t5231 * t5338 - 0.11e2 / 0.16e2 * t156 * t5231 * t5389 - 0.3e1 / 0.4e1 * t409 * t1373 + 0.9e1 / 0.16e2 * t156 * t5333 * t5370 - 0.9e1 / 0.16e2 * t156 * t5333 * t5398 + 0.3e1 / 0.16e2 * t156 * t5366 * t452;
  t5411 = t1334 * t5234;
  t5430 = 0.3e1 / 0.4e1 * t409 * t1370 - 0.3e1 / 0.16e2 * t156 * t5366 * t445 + 0.3e1 / 0.8e1 * t156 * t5231 * t5411 + 0.3e1 / 0.8e1 * t1323 * t457 + 0.3e1 / 0.8e1 * t409 * t1383 + 0.5e1 / 0.32e2 * t156 * t5239 * t1382 - 0.7e1 / 0.32e2 * t156 * t5333 * t5382 + 0.3e1 / 0.16e2 * t5011 + t5013 / 0.2e1 - 0.3e1 / 0.8e1 * t5015 - t5017 / 0.8e1 + 0.3e1 / 0.8e1 * t5019;
  t5444 = -0.3e1 / 0.16e2 * t5021 - t5023 / 0.8e1 - 0.3e1 / 0.8e1 * t5026 - 0.3e1 / 0.8e1 * t5029 - 0.3e1 / 0.16e2 * t5031 - 0.3e1 / 0.8e1 * t5033 - t5035 / 0.16e2 + 0.3e1 / 0.16e2 * t5074 + 0.3e1 / 0.8e1 * t5076 - 0.3e1 / 0.8e1 * t5078 - t5080 / 0.4e1 + 0.3e1 / 0.8e1 * t5082;
  t5453 = t395 * t395;
  t5458 = t400 * t400;
  t5465 = my_piecewise5(t11, 0, t7, 0, -0.24e2 * t920 + 0.24e2 * t4586);
  t5469 = my_piecewise3(t56, 0, 0.9e1 / 0.16e2 * t4574 * t5453 - 0.9e1 / 0.4e1 * t1204 * t400 + 0.9e1 / 0.4e1 * t307 * t5458 + 0.3e1 * t352 * t1286 + 0.3e1 / 0.2e1 * t57 * t5465);
  t5475 = -0.3e1 / 0.32e2 * t4885 + 0.3e1 / 0.32e2 * t4887 + 0.3e1 / 0.32e2 * t4891 - 0.3e1 / 0.32e2 * t4895 + 0.3e1 / 0.64e2 * t4899 + 0.3e1 / 0.16e2 * t4908 - 0.3e1 / 0.32e2 * t4788 - t5122 / 0.4e1 - M_PI * t5469 * t79 / 0.8e1 - 0.3e1 / 0.16e2 * t4773 + 0.3e1 / 0.16e2 * t4945 + t4605;
  t5479 = my_piecewise3(t51, 0, t5198 + t5226 + t5262 + t5362 + t5405 + t5430 + t5444 + t5475);
  tv4rho44 = 0.4e1 * t1276 + 0.4e1 * t1411 + t3 * (t5160 + t5479);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t5483 = t470 * t265;
  t5484 = t2464 * t283;
  t5488 = t470 * t295;
  t5489 = t5488 * t5484;
  t5492 = t495 * t113;
  t5494 = t958 * t283 * t111;
  t5504 = t1449 * t1011;
  t5508 = t111 * t997;
  t5509 = t5508 * t999;
  t5513 = t485 * t43;
  t5524 = t1462 * t1490;
  t5526 = t1462 * t1494;
  t5528 = t1462 * t1478;
  t5530 = 0.9e1 / 0.32e2 * t469 * t5483 * t5484 - 0.9e1 / 0.32e2 * t469 * t5489 - 0.3e1 / 0.8e1 * t484 * t5492 * t5494 - 0.9e1 / 0.16e2 * t484 * t5489 + 0.3e1 / 0.4e1 * t484 * t1489 * t263 * t2256 - 0.9e1 / 0.16e2 * t484 * t5504 * t5494 + 0.9e1 / 0.32e2 * t469 * t5509 * t5484 + 0.9e1 / 0.16e2 * t484 * t5513 * t4267 - 0.3e1 / 0.16e2 * t484 * t1489 * t111 * t986 - 0.3e1 / 0.8e1 * t484 * t1485 * t1517 - 0.3e1 / 0.32e2 * t5524 + 0.3e1 / 0.32e2 * t5526 + 0.3e1 / 0.32e2 * t5528;
  t5531 = t241 * t483;
  t5536 = t1462 * t1502;
  t5542 = t1440 * t478;
  t5546 = t1507 * t1433;
  t5551 = t1462 * t1446;
  t5553 = t478 * t261;
  t5557 = t1462 * t1518;
  t5559 = t113 * t4280;
  t5560 = t5559 * t955;
  t5564 = t1466 * t1524;
  t5567 = t23 * t251 * t100;
  t5568 = t5567 * t492;
  t5570 = t1462 * t1434;
  t5572 = -0.3e1 / 0.16e2 * t5531 * t486 - 0.3e1 / 0.8e1 * t1455 * t1502 - 0.3e1 / 0.16e2 * t5536 - 0.3e1 / 0.16e2 * t484 * t1419 * t111 * t290 + 0.9e1 / 0.32e2 * t469 * t1439 * t5542 - 0.9e1 / 0.16e2 * t484 * t5546 + 0.3e1 / 0.4e1 * t1455 * t1446 + 0.3e1 / 0.8e1 * t5551 + 0.3e1 / 0.4e1 * t484 * t5553 * t1006 - 0.3e1 / 0.16e2 * t5557 + 0.3e1 / 0.8e1 * t484 * t495 * t5560 + 0.9e1 / 0.64e2 * t5564 - 0.3e1 / 0.64e2 * t5568 - 0.9e1 / 0.32e2 * t5570;
  t5574 = t183 * t955;
  t5580 = t91 * t1461;
  t5581 = t5580 * t486;
  t5585 = t5567 * t486;
  t5587 = t1462 * t1527;
  t5589 = t1466 * t1482;
  t5591 = t1522 * t478;
  t5595 = t1462 * t1486;
  t5600 = t496 * t1045;
  t5609 = t183 * t4275;
  t5610 = t4277 * t4280;
  t5611 = t5610 * t955;
  t5615 = 0.3e1 / 0.8e1 * t484 * t5574 * t4414 - 0.9e1 / 0.16e2 * t1455 * t1434 - 0.3e1 / 0.16e2 * t5581 + 0.9e1 / 0.16e2 * t1455 * t1527 + 0.3e1 / 0.64e2 * t5585 + 0.9e1 / 0.32e2 * t5587 - 0.3e1 / 0.32e2 * t5589 + 0.9e1 / 0.32e2 * t469 * t1521 * t5591 + 0.3e1 / 0.16e2 * t5595 + 0.3e1 / 0.16e2 * t484 * t1485 * t1477 + t484 * t495 * t5600 / 0.16e2 - 0.3e1 / 0.16e2 * t1458 * t1482 - 0.25e2 / 0.16e2 * t484 * t5574 * t4351 + 0.15e2 / 0.16e2 * t484 * t5609 * t5611;
  t5616 = t1462 * t1452;
  t5627 = t295 * t4280;
  t5628 = t5627 * t955;
  t5629 = t489 * t5628;
  t5634 = t955 * t997;
  t5635 = t999 * t4280;
  t5636 = t5635 * t183;
  t5640 = t5574 * t4296;
  t5643 = t1011 * t4280;
  t5644 = t5643 * t955;
  t5645 = t1449 * t5644;
  t5650 = t955 * t4275;
  t5651 = t4344 * t4280;
  t5652 = t5651 * t183;
  t5660 = t1466 * t1434;
  t5662 = -0.9e1 / 0.32e2 * t5616 - 0.9e1 / 0.16e2 * t484 * t478 * t997 * t1451 + 0.11e2 / 0.16e2 * t484 * t5574 * t4331 - 0.9e1 / 0.16e2 * t1455 * t1452 + 0.11e2 / 0.16e2 * t484 * t5629 + 0.9e1 / 0.16e2 * t469 * t5629 - 0.9e1 / 0.16e2 * t469 * t5634 * t5636 - 0.3e1 / 0.2e1 * t484 * t5640 + 0.9e1 / 0.8e1 * t484 * t5645 + 0.11e2 / 0.16e2 * t469 * t5645 - 0.15e2 / 0.32e2 * t469 * t5650 * t5652 - 0.9e1 / 0.32e2 * t469 * t5546 - 0.9e1 / 0.32e2 * t1458 * t1434 - 0.9e1 / 0.64e2 * t5660;
  t5667 = t241 * t468;
  t5675 = t471 * t1419;
  t5700 = t490 * t1045;
  t5704 = 0.3e1 / 0.16e2 * t5531 * t498 - 0.3e1 / 0.32e2 * t5667 * t473 - 0.3e1 / 0.32e2 * t1470 * t1482 - 0.3e1 / 0.32e2 * t469 * t940 * t1481 - 0.3e1 / 0.32e2 * t469 * t470 * t5675 + 0.3e1 / 0.8e1 * t1455 * t1486 + 0.3e1 / 0.16e2 * t484 * t1419 * t43 * t497 - 0.3e1 / 0.16e2 * t1455 * t1490 - 0.3e1 / 0.16e2 * t484 * t478 * t283 * t290 - t484 * t183 * t1045 * t290 / 0.16e2 + 0.3e1 / 0.16e2 * t1455 * t1494 + 0.3e1 / 0.16e2 * t484 * t1507 * t1493 + t484 * t489 * t5700 / 0.16e2;
  t5707 = t1419 * t263;
  t5717 = t1462 * t1511;
  t5732 = t955 * t263;
  t5733 = t265 * t4280;
  t5734 = t5733 * t183;
  t5742 = 0.3e1 / 0.16e2 * t1455 * t1478 + 0.3e1 / 0.16e2 * t484 * t5707 * t491 + 0.3e1 / 0.16e2 * t5531 * t492 + 0.3e1 / 0.8e1 * t1455 * t1508 - 0.3e1 / 0.16e2 * t1455 * t1511 - 0.3e1 / 0.32e2 * t5717 - 0.3e1 / 0.16e2 * t484 * t5553 * t986 - t484 * t5574 * t4319 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t5574 * t4309 + 0.9e1 / 0.32e2 * t1458 * t1442 - 0.3e1 / 0.8e1 * t1455 * t1518 - 0.11e2 / 0.32e2 * t469 * t5732 * t5734 + 0.9e1 / 0.32e2 * t1458 * t1524 + 0.5e1 / 0.32e2 * t1470 * t1524;
  t5744 = t5580 * t492;
  t5746 = t1466 * t1442;
  t5755 = t5567 * t498;
  t5758 = t23 * t251 * t260;
  t5759 = t5758 * t473;
  t5762 = t23 * t95 * t1030;
  t5763 = t5762 * t473;
  t5765 = t1466 * t1474;
  t5768 = t23 * t26 * t4484;
  t5771 = t5580 * t498;
  t5773 = t91 * t1465;
  t5774 = t5773 * t473;
  t5776 = t91 * t1469;
  t5781 = 0.3e1 / 0.16e2 * t5744 + 0.9e1 / 0.64e2 * t5746 - 0.7e1 / 0.32e2 * t469 * t5640 - t1470 * t1474 / 0.16e2 - t469 * t4219 * t472 / 0.32e2 - 0.3e1 / 0.64e2 * t5755 + 0.3e1 / 0.128e3 * t5759 - 0.3e1 / 0.64e2 * t5763 - 0.3e1 / 0.64e2 * t5765 - t5768 * t473 / 0.32e2 + 0.3e1 / 0.16e2 * t5771 - 0.3e1 / 0.32e2 * t5774 - 0.3e1 / 0.32e2 * t5776 * t473 - 0.3e1 / 0.32e2 * t1458 * t1474;
  t5789 = t1462 * t1508;
  t5795 = t952 * t480;
  t5797 = t4300 * t185;
  t5800 = 0.3e1 / 0.128e3 * t4306 * t185;
  t5801 = t4303 * t185;
  t5803 = t1053 * t480;
  t5805 = t255 * t1421;
  t5811 = my_piecewise3(t39, -0.15e2 / 0.2e1 * t1040 * t37, 0);
  t5816 = -0.5e1 / 0.32e2 * t1470 * t1434 + 0.5e1 / 0.32e2 * t1470 * t1442 + 0.9e1 / 0.16e2 * t484 * t5553 * t968 + 0.3e1 / 0.16e2 * t5789 - t4432 * t185 / 0.16e2 - 0.3e1 / 0.16e2 * t1050 * t480 + 0.3e1 / 0.64e2 * t5795 - 0.3e1 / 0.32e2 * t5797 - t5800 + 0.3e1 / 0.64e2 * t5801 - 0.3e1 / 0.16e2 * t5803 - 0.3e1 / 0.32e2 * t5805 - 0.3e1 / 0.16e2 * t246 * t1421 - t99 * t100 * t5811 * t116 / 0.16e2;
  t5820 = my_piecewise3(t2, 0, t5530 + t5572 + t5615 + t5662 + t5704 + t5742 + t5781 + t5816);
  tv4rho3sigma0 = t3 * t5820 + 0.3e1 * t1532;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t5825 = t4781 * t193;
  t5827 = t4784 * t193;
  t5830 = 0.3e1 / 0.128e3 * t4787 * t193;
  t5832 = my_piecewise3(t51, 0, -t4778 * t193 / 0.16e2 - 0.3e1 / 0.32e2 * t5825 + 0.3e1 / 0.64e2 * t5827 - t5830);
  tv4rho3sigma2 = t3 * t5832 + 0.3e1 * t1542;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5834 = 0.2e1 * t1567;
  t5835 = t340 * t483;
  t5838 = t143 * t1461;
  t5840 = t5838 * t486 / 0.16e2;
  t5854 = t5838 * t492 / 0.16e2;
  t5869 = -t5835 * t486 / 0.8e1 - t5840 + 0.3e1 / 0.32e2 * t1548 * t1524 + 0.3e1 / 0.16e2 * t1553 * t1527 - 0.3e1 / 0.16e2 * t1553 * t1434 - t1553 * t1518 / 0.8e1 - t1553 * t1502 / 0.8e1 + t5835 * t492 / 0.8e1 + t5854 + t1553 * t1508 / 0.8e1 - t1553 * t1511 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t1434 + 0.3e1 / 0.32e2 * t1548 * t1442 + t1553 * t1446 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t1452 - t1553 * t1490 / 0.16e2;
  t5874 = t340 * t468;
  t5878 = t5838 * t498 / 0.16e2;
  t5879 = t143 * t1465;
  t5881 = t5879 * t473 / 0.32e2;
  t5888 = t143 * t1469;
  t5899 = t1553 * t1494 / 0.16e2 + t5835 * t498 / 0.8e1 - t5874 * t473 / 0.16e2 + t5878 - t5881 - t5524 / 0.32e2 + t5526 / 0.32e2 + t5528 / 0.32e2 - t5536 / 0.16e2 + t1553 * t1478 / 0.16e2 - t5888 * t473 / 0.32e2 - t1548 * t1474 / 0.32e2 - t1548 * t1482 / 0.16e2 + t1553 * t1486 / 0.8e1 + t5551 / 0.8e1 - t5557 / 0.16e2;
  t5917 = 0.3e1 / 0.64e2 * t5564 - t5568 / 0.32e2 - 0.3e1 / 0.32e2 * t5570 - t5581 / 0.16e2 + t5585 / 0.32e2 + 0.3e1 / 0.32e2 * t5587 - t5589 / 0.32e2 + t5595 / 0.16e2 - 0.3e1 / 0.32e2 * t5616 - 0.3e1 / 0.64e2 * t5660 - t5717 / 0.32e2 + t5744 / 0.16e2 + 0.3e1 / 0.64e2 * t5746 - t5755 / 0.32e2 + t5759 / 0.64e2 - t5763 / 0.64e2;
  t5925 = t4645 * t185 / 0.16e2;
  t5926 = t4648 * t185;
  t5933 = t1124 * t480 / 0.16e2;
  t5939 = -t5765 / 0.64e2 + t5771 / 0.16e2 - t5774 / 0.32e2 + t5789 / 0.16e2 + t5795 / 0.32e2 - t5797 / 0.32e2 - t5925 + t5926 / 0.64e2 - t4659 * t185 / 0.16e2 - t1121 * t480 / 0.8e1 - t5933 - t345 * t1421 / 0.16e2 - t5800 + t5801 / 0.32e2 - t5803 / 0.16e2 - t5805 / 0.32e2;
  t5942 = my_piecewise3(t2, 0, t5869 + t5899 + t5917 + t5939);
  tv4rho3sigma3 = t3 * t5942 + t1532 + t5834;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5944 = 0.2e1 * t1601;
  t5945 = t128 * t1588;
  t5947 = t5945 * t542 / 0.16e2;
  t5949 = t60 * t251 * t157;
  t5950 = t5949 * t542;
  t5953 = t5945 * t548 / 0.16e2;
  t5954 = t5949 * t548;
  t5956 = t128 * t1577;
  t5958 = t5956 * t523 / 0.32e2;
  t5960 = t60 * t251 * t415;
  t5961 = t5960 * t523;
  t5964 = t5945 * t536 / 0.16e2;
  t5965 = t5949 * t536;
  t5967 = t319 * t533;
  t5973 = t319 * t518;
  t5977 = t1167 * t530 / 0.16e2;
  t5978 = t1170 * t530;
  t5983 = t4904 * t193 / 0.16e2;
  t5984 = t4907 * t193;
  t5992 = -t5973 * t523 / 0.32e2 - t5977 + t5978 / 0.64e2 - t5967 * t536 / 0.16e2 - t5983 + t5984 / 0.64e2 - t5825 / 0.32e2 + t5827 / 0.32e2 - t5830 - t1164 * t530 / 0.16e2 - t4880 * t193 / 0.16e2;
  t5994 = my_piecewise3(t51, 0, t5947 - t5950 / 0.64e2 + t5953 - t5954 / 0.64e2 - t5958 + t5961 / 0.128e3 - t5964 + t5965 / 0.64e2 + t5967 * t542 / 0.16e2 + t5967 * t548 / 0.16e2 + t5992);
  tv4rho3sigma5 = t3 * t5994 + t1542 + t5944;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5998 = t4805 * t185;
  t6000 = t389 * t468;
  t6005 = t389 * t483;
  t6020 = -t5933 - t5840 + t5854 + t5878 + t5801 / 0.64e2 - t5800 + t5759 / 0.128e3 + t5795 / 0.64e2 + t5585 / 0.64e2 - t5568 / 0.64e2 - t5755 / 0.64e2;
  t6022 = my_piecewise3(t2, 0, -t4802 * t185 / 0.16e2 - t5998 / 0.32e2 - t6000 * t473 / 0.32e2 - t1196 * t480 / 0.16e2 - t6005 * t486 / 0.16e2 + t6005 * t492 / 0.16e2 + t6005 * t498 / 0.16e2 - t5925 + t5926 / 0.32e2 - t5881 + t6020);
  tv4rho3sigma6 = t3 * t6022 + t1608 + t5834;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t6025 = t60 * t95 * t1303;
  t6026 = t6025 * t523;
  t6028 = t1578 * t1678;
  t6030 = t1589 * t1711;
  t6032 = t1589 * t1656;
  t6034 = t1589 * t1660;
  t6036 = t1589 * t1646;
  t6038 = t1589 * t1652;
  t6040 = t1578 * t1630;
  t6042 = t1578 * t1643;
  t6044 = t1589 * t1630;
  t6046 = t1589 * t1635;
  t6048 = t153 * t1588;
  t6049 = t6048 * t542;
  t6051 = t1589 * t1612;
  t6053 = t1589 * t1616;
  t6055 = t1578 * t1622;
  t6057 = t1589 * t1625;
  t6059 = -t6026 / 0.64e2 - t6028 / 0.64e2 + t6030 / 0.32e2 + t6032 / 0.16e2 - t6034 / 0.32e2 + t6036 / 0.8e1 - 0.3e1 / 0.32e2 * t6038 - 0.3e1 / 0.64e2 * t6040 + 0.3e1 / 0.64e2 * t6042 - 0.3e1 / 0.32e2 * t6044 - t6046 / 0.16e2 + t6049 / 0.16e2 + t6051 / 0.16e2 - t6053 / 0.32e2 + 0.3e1 / 0.64e2 * t6055 + 0.3e1 / 0.32e2 * t6057;
  t6060 = t1578 * t1682;
  t6062 = t6048 * t536;
  t6064 = t1589 * t1688;
  t6066 = t1589 * t1664;
  t6068 = t6048 * t548;
  t6070 = t153 * t1577;
  t6071 = t6070 * t523;
  t6085 = t361 * t533;
  t6092 = t128 * t1673;
  t6095 = -t6060 / 0.32e2 - t6062 / 0.16e2 - t6064 / 0.16e2 + t6066 / 0.32e2 + t6068 / 0.16e2 - t6071 / 0.32e2 - t1585 * t1616 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t1622 + 0.3e1 / 0.16e2 * t1585 * t1625 - 0.3e1 / 0.16e2 * t1585 * t1630 - t1585 * t1635 / 0.8e1 - t1585 * t1688 / 0.8e1 + t6085 * t542 / 0.8e1 + t1585 * t1612 / 0.8e1 - t6085 * t536 / 0.8e1 - t6092 * t523 / 0.32e2;
  t6107 = t361 * t518;
  t6124 = -t1574 * t1678 / 0.32e2 - t1574 * t1682 / 0.16e2 - t1585 * t1660 / 0.16e2 + t1585 * t1664 / 0.16e2 + t6085 * t548 / 0.8e1 - t6107 * t523 / 0.16e2 + t1585 * t1711 / 0.16e2 + t1585 * t1656 / 0.8e1 - 0.3e1 / 0.32e2 * t1574 * t1630 + 0.3e1 / 0.32e2 * t1574 * t1643 + t1585 * t1646 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t1652 + t5947 - t5950 / 0.32e2 + t5953 - t5954 / 0.32e2;
  t6133 = t5025 * t193;
  t6135 = t1227 * t530;
  t6137 = t370 * t1703;
  t6142 = -t5958 + t5961 / 0.64e2 - t5964 + t5965 / 0.32e2 - t1224 * t530 / 0.8e1 - t367 * t1703 / 0.16e2 - t5057 * t193 / 0.16e2 - t6133 / 0.32e2 - t6135 / 0.16e2 - t6137 / 0.32e2 + t5827 / 0.64e2 - t5830 - t5977 + t5978 / 0.32e2 - t5983 + t5984 / 0.32e2;
  t6145 = my_piecewise3(t51, 0, t6059 + t6095 + t6124 + t6142);
  tv4rho3sigma8 = t3 * t6145 + t1716 + t5944;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t6153 = my_piecewise3(t2, 0, -t4984 * t185 / 0.16e2 - 0.3e1 / 0.32e2 * t5998 + 0.3e1 / 0.64e2 * t5926 - t5800);
  tv4rho3sigma9 = t3 * t6153 + 0.3e1 * t1608;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t6157 = t1336 * t438 * t168;
  t6158 = t2572 * t6157;
  t6165 = t1649 * t1362;
  t6169 = t535 * t75;
  t6177 = t545 * t170;
  t6181 = t520 * t420;
  t6182 = t2567 * t438;
  t6188 = t168 * t1348;
  t6189 = t6188 * t1350;
  t6193 = t528 * t416;
  t6203 = t191 * t1332;
  t6207 = -0.9e1 / 0.16e2 * t534 * t6158 + 0.3e1 / 0.4e1 * t534 * t1659 * t418 * t2400 - 0.9e1 / 0.16e2 * t534 * t6165 * t6157 + 0.9e1 / 0.16e2 * t534 * t6169 * t5164 - 0.3e1 / 0.16e2 * t534 * t1659 * t168 * t1337 - 0.3e1 / 0.8e1 * t534 * t6177 * t6157 + 0.9e1 / 0.32e2 * t519 * t6181 * t6182 - 0.9e1 / 0.32e2 * t519 * t6158 + 0.9e1 / 0.32e2 * t519 * t6189 * t6182 + 0.3e1 / 0.4e1 * t534 * t6193 * t1357 - 0.9e1 / 0.16e2 * t1667 * t1652 - 0.9e1 / 0.16e2 * t534 * t528 * t1348 * t1651 + 0.11e2 / 0.16e2 * t534 * t6203 * t5254;
  t6208 = t1611 * t1629;
  t6227 = t5356 * t5234;
  t6228 = t6227 * t1332;
  t6232 = t1332 * t418;
  t6233 = t450 * t5234;
  t6234 = t6233 * t191;
  t6235 = t6232 * t6234;
  t6238 = t1332 * t1348;
  t6239 = t1350 * t5234;
  t6240 = t6239 * t191;
  t6244 = t6203 * t5382;
  t6247 = t1362 * t5234;
  t6248 = t6247 * t1332;
  t6249 = t1649 * t6248;
  t6254 = -0.9e1 / 0.16e2 * t534 * t6208 - 0.9e1 / 0.16e2 * t1667 * t1630 - 0.9e1 / 0.32e2 * t1670 * t1630 + 0.9e1 / 0.32e2 * t1670 * t1643 - 0.5e1 / 0.32e2 * t1674 * t1630 + 0.5e1 / 0.32e2 * t1674 * t1643 + 0.3e1 / 0.8e1 * t1667 * t1612 - 0.25e2 / 0.16e2 * t534 * t6203 * t5351 + 0.15e2 / 0.16e2 * t534 * t191 * t5342 * t6228 + 0.9e1 / 0.16e2 * t519 * t6235 - 0.9e1 / 0.16e2 * t519 * t6238 * t6240 - 0.3e1 / 0.2e1 * t534 * t6244 + 0.9e1 / 0.8e1 * t534 * t6249 + 0.11e2 / 0.16e2 * t519 * t6249;
  t6256 = t1332 * t5342;
  t6257 = t5344 * t5234;
  t6258 = t6257 * t191;
  t6264 = t1641 * t528;
  t6270 = t1701 * t418;
  t6287 = t405 * t533;
  t6298 = -0.15e2 / 0.32e2 * t519 * t6256 * t6258 - 0.9e1 / 0.32e2 * t519 * t6208 + 0.9e1 / 0.32e2 * t519 * t1640 * t6264 + 0.3e1 / 0.4e1 * t1667 * t1646 + 0.3e1 / 0.16e2 * t534 * t6270 * t541 - 0.3e1 / 0.16e2 * t1667 * t1616 - 0.3e1 / 0.16e2 * t534 * t6193 * t1337 - t534 * t6203 * t5235 / 0.16e2 + 0.9e1 / 0.16e2 * t534 * t6193 * t1369 + 0.9e1 / 0.16e2 * t1667 * t1625 + 0.3e1 / 0.16e2 * t6287 * t542 - 0.3e1 / 0.16e2 * t6287 * t536 - 0.3e1 / 0.8e1 * t1667 * t1688 - 0.3e1 / 0.16e2 * t534 * t1701 * t168 * t445;
  t6299 = t170 * t5234;
  t6300 = t6299 * t1332;
  t6307 = t420 * t5234;
  t6308 = t6307 * t191;
  t6329 = t540 * t1318;
  t6337 = t405 * t518;
  t6340 = 0.3e1 / 0.8e1 * t534 * t545 * t6300 + 0.3e1 / 0.8e1 * t534 * t6203 * t5411 - 0.11e2 / 0.32e2 * t519 * t6232 * t6308 - 0.11e2 / 0.16e2 * t534 * t6203 * t5389 + 0.11e2 / 0.16e2 * t534 * t6235 + 0.5e1 / 0.32e2 * t1674 * t1622 - 0.3e1 / 0.8e1 * t1667 * t1635 - 0.3e1 / 0.8e1 * t534 * t1655 * t1634 + 0.3e1 / 0.16e2 * t1667 * t1664 + 0.3e1 / 0.16e2 * t534 * t1611 * t1663 + t534 * t539 * t6329 / 0.16e2 + 0.3e1 / 0.16e2 * t6287 * t548 + 0.9e1 / 0.32e2 * t1670 * t1622 - 0.3e1 / 0.32e2 * t6337 * t523;
  t6343 = t153 * t1673;
  t6351 = t60 * t26 * t5302;
  t6359 = t546 * t1318;
  t6369 = t1620 * t528;
  t6383 = -0.3e1 / 0.32e2 * t6343 * t523 - 0.3e1 / 0.32e2 * t1670 * t1678 - 0.3e1 / 0.16e2 * t1670 * t1682 - t6351 * t523 / 0.32e2 + 0.3e1 / 0.16e2 * t1667 * t1711 + 0.3e1 / 0.16e2 * t534 * t1655 * t1710 + t534 * t545 * t6359 / 0.16e2 + 0.3e1 / 0.8e1 * t1667 * t1656 + 0.3e1 / 0.16e2 * t534 * t1701 * t75 * t547 + 0.9e1 / 0.32e2 * t519 * t1619 * t6369 - 0.3e1 / 0.16e2 * t1667 * t1660 - 0.3e1 / 0.16e2 * t534 * t528 * t438 * t445 - t534 * t191 * t1318 * t445 / 0.16e2;
  t6396 = t521 * t1701;
  t6408 = -0.7e1 / 0.32e2 * t519 * t6244 - t1674 * t1678 / 0.16e2 - 0.3e1 / 0.32e2 * t1674 * t1682 - t519 * t5178 * t522 / 0.32e2 - 0.3e1 / 0.32e2 * t519 * t1386 * t1681 - 0.3e1 / 0.32e2 * t519 * t520 * t6396 - 0.3e1 / 0.64e2 * t6026 - 0.3e1 / 0.64e2 * t6028 + 0.3e1 / 0.32e2 * t6030 + 0.3e1 / 0.16e2 * t6032 - 0.3e1 / 0.32e2 * t6034 + 0.3e1 / 0.8e1 * t6036 - 0.9e1 / 0.32e2 * t6038 - 0.9e1 / 0.64e2 * t6040;
  t6424 = 0.9e1 / 0.64e2 * t6042 - 0.9e1 / 0.32e2 * t6044 - 0.3e1 / 0.16e2 * t6046 + 0.3e1 / 0.16e2 * t6049 + 0.3e1 / 0.16e2 * t6051 - 0.3e1 / 0.32e2 * t6053 + 0.9e1 / 0.64e2 * t6055 + 0.9e1 / 0.32e2 * t6057 - 0.3e1 / 0.32e2 * t6060 - 0.3e1 / 0.16e2 * t6062 - 0.3e1 / 0.16e2 * t6064 + 0.3e1 / 0.32e2 * t6066 + 0.3e1 / 0.16e2 * t6068 - 0.3e1 / 0.32e2 * t6071;
  t6437 = my_piecewise3(t72, -0.15e2 / 0.2e1 * t1313 * t37, 0);
  t6447 = -0.3e1 / 0.64e2 * t5950 - 0.3e1 / 0.64e2 * t5954 + 0.3e1 / 0.128e3 * t5961 + 0.3e1 / 0.64e2 * t5965 - t5324 * t193 / 0.16e2 - 0.3e1 / 0.16e2 * t1323 * t530 - 0.3e1 / 0.16e2 * t409 * t1703 - t156 * t157 * t6437 * t173 / 0.16e2 - 0.3e1 / 0.32e2 * t6133 - 0.3e1 / 0.16e2 * t6135 - 0.3e1 / 0.32e2 * t6137 - t5830 + 0.3e1 / 0.64e2 * t5978 + 0.3e1 / 0.64e2 * t5984;
  t6451 = my_piecewise3(t51, 0, t6207 + t6254 + t6298 + t6340 + t6383 + t6408 + t6424 + t6447);
  tv4rho3sigma11 = t3 * t6451 + 0.3e1 * t1716;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t6454 = t572 * t999;
  t6462 = t940 * t295 * t2455;
  t6469 = t568 * t43;
  t6473 = t2454 * t283;
  t6485 = t199 * t955;
  t6489 = t1432 * t563;
  t6490 = t1521 * t6489;
  t6493 = t1440 * t563;
  t6499 = 0.3e1 / 0.4e1 * t484 * t6454 * t5494 - 0.9e1 / 0.16e2 * t484 * t2483 * t5494 - 0.9e1 / 0.32e2 * t469 * t6462 - 0.3e1 / 0.16e2 * t484 * t1756 * t111 * t986 + 0.9e1 / 0.16e2 * t484 * t6469 * t4267 + 0.9e1 / 0.32e2 * t469 * t5483 * t6473 - 0.9e1 / 0.16e2 * t484 * t6462 + 0.9e1 / 0.32e2 * t469 * t5509 * t6473 - 0.3e1 / 0.8e1 * t484 * t2469 * t5494 - 0.25e2 / 0.16e2 * t484 * t6485 * t4351 - 0.9e1 / 0.32e2 * t469 * t6490 + 0.9e1 / 0.32e2 * t469 * t1439 * t6493 - 0.9e1 / 0.16e2 * t484 * t6490;
  t6508 = t1462 * t1736;
  t6510 = t563 * t261;
  t6514 = t1462 * t1740;
  t6516 = t1462 * t1727;
  t6518 = t1466 * t1727;
  t6520 = t1466 * t1733;
  t6532 = -0.9e1 / 0.16e2 * t1455 * t1727 - 0.9e1 / 0.32e2 * t1458 * t1727 + 0.9e1 / 0.32e2 * t1458 * t1733 + 0.3e1 / 0.4e1 * t1455 * t1736 + 0.3e1 / 0.8e1 * t6508 + 0.3e1 / 0.4e1 * t484 * t6510 * t1006 - 0.9e1 / 0.32e2 * t6514 - 0.9e1 / 0.32e2 * t6516 - 0.9e1 / 0.64e2 * t6518 + 0.9e1 / 0.64e2 * t6520 - 0.5e1 / 0.32e2 * t1470 * t1727 + 0.5e1 / 0.32e2 * t1470 * t1733 - 0.3e1 / 0.16e2 * t484 * t6510 * t986 - t484 * t6485 * t4319 / 0.16e2;
  t6537 = t199 * t4275;
  t6541 = t563 * t997;
  t6550 = t572 * t5628;
  t6555 = t5635 * t199;
  t6559 = t6485 * t4296;
  t6562 = t1739 * t5644;
  t6567 = t5651 * t199;
  t6571 = t1462 * t1770;
  t6577 = -0.11e2 / 0.16e2 * t484 * t6485 * t4309 + 0.15e2 / 0.16e2 * t484 * t6537 * t5611 - 0.9e1 / 0.16e2 * t484 * t6541 * t1451 + 0.11e2 / 0.16e2 * t484 * t6485 * t4331 - 0.9e1 / 0.16e2 * t1455 * t1740 + 0.11e2 / 0.16e2 * t484 * t6550 + 0.9e1 / 0.16e2 * t469 * t6550 - 0.9e1 / 0.16e2 * t469 * t5634 * t6555 - 0.3e1 / 0.2e1 * t484 * t6559 + 0.9e1 / 0.8e1 * t484 * t6562 + 0.11e2 / 0.16e2 * t469 * t6562 - 0.15e2 / 0.32e2 * t469 * t5650 * t6567 - 0.3e1 / 0.16e2 * t6571 - 0.3e1 / 0.16e2 * t484 * t1808 * t111 * t290;
  t6578 = t5567 * t569;
  t6580 = t5567 * t573;
  t6582 = t1462 * t1724;
  t6587 = t5580 * t573;
  t6595 = t1462 * t1776;
  t6597 = t1808 * t263;
  t6603 = t1462 * t1779;
  t6611 = 0.3e1 / 0.64e2 * t6578 - 0.3e1 / 0.64e2 * t6580 + 0.9e1 / 0.32e2 * t6582 + 0.9e1 / 0.16e2 * t484 * t6510 * t968 + 0.3e1 / 0.16e2 * t6587 + 0.9e1 / 0.16e2 * t1455 * t1724 + 0.3e1 / 0.16e2 * t5531 * t573 + 0.3e1 / 0.8e1 * t1455 * t1776 + 0.3e1 / 0.16e2 * t6595 + 0.3e1 / 0.16e2 * t484 * t6597 * t491 - 0.3e1 / 0.16e2 * t1455 * t1779 - 0.3e1 / 0.32e2 * t6603 + 0.3e1 / 0.16e2 * t484 * t1775 * t1493 + t484 * t572 * t5700 / 0.16e2;
  t6622 = t5580 * t569;
  t6642 = t471 * t1808;
  t6646 = 0.3e1 / 0.16e2 * t1455 * t1790 + 0.3e1 / 0.16e2 * t484 * t1752 * t1477 + t484 * t576 * t5600 / 0.16e2 - 0.3e1 / 0.16e2 * t6622 - 0.3e1 / 0.16e2 * t5531 * t569 - 0.3e1 / 0.8e1 * t1455 * t1770 - t1470 * t1745 / 0.16e2 - 0.3e1 / 0.32e2 * t1470 * t1749 - 0.3e1 / 0.32e2 * t1458 * t1745 - t469 * t4219 * t558 / 0.32e2 - 0.3e1 / 0.32e2 * t469 * t940 * t1748 - 0.3e1 / 0.16e2 * t1458 * t1749 - 0.3e1 / 0.32e2 * t469 * t470 * t6642;
  t6649 = t1808 * t43;
  t6653 = t5567 * t577;
  t6655 = t5758 * t559;
  t6657 = t5580 * t577;
  t6659 = t1462 * t1753;
  t6661 = t1466 * t1720;
  t6663 = t5773 * t559;
  t6665 = t5762 * t559;
  t6667 = t1466 * t1745;
  t6669 = t1466 * t1749;
  t6677 = 0.3e1 / 0.8e1 * t1455 * t1753 + 0.3e1 / 0.16e2 * t484 * t6649 * t497 - 0.3e1 / 0.64e2 * t6653 + 0.3e1 / 0.128e3 * t6655 + 0.3e1 / 0.16e2 * t6657 + 0.3e1 / 0.16e2 * t6659 + 0.9e1 / 0.64e2 * t6661 - 0.3e1 / 0.32e2 * t6663 - 0.3e1 / 0.64e2 * t6665 - 0.3e1 / 0.64e2 * t6667 - 0.3e1 / 0.32e2 * t6669 - 0.3e1 / 0.32e2 * t5776 * t559 - t5768 * t559 / 0.32e2 + 0.3e1 / 0.16e2 * t1455 * t1787;
  t6679 = t1462 * t1757;
  t6681 = t1462 * t1790;
  t6683 = t1462 * t1784;
  t6685 = t1462 * t1787;
  t6687 = t5733 * t199;
  t6715 = -0.3e1 / 0.32e2 * t6679 + 0.3e1 / 0.32e2 * t6681 - 0.3e1 / 0.16e2 * t6683 + 0.3e1 / 0.32e2 * t6685 - 0.11e2 / 0.32e2 * t469 * t5732 * t6687 - 0.7e1 / 0.32e2 * t469 * t6559 - 0.3e1 / 0.16e2 * t1455 * t1757 - 0.3e1 / 0.16e2 * t484 * t563 * t283 * t290 - t484 * t199 * t1045 * t290 / 0.16e2 + 0.3e1 / 0.16e2 * t5531 * t577 + 0.9e1 / 0.32e2 * t1458 * t1720 - 0.3e1 / 0.32e2 * t5667 * t559 + 0.3e1 / 0.8e1 * t484 * t6485 * t4414 + 0.3e1 / 0.8e1 * t484 * t576 * t5560;
  t6720 = t1522 * t563;
  t6727 = t4300 * t201;
  t6729 = t1053 * t565;
  t6738 = 0.3e1 / 0.128e3 * t4306 * t201;
  t6739 = t255 * t1810;
  t6742 = my_piecewise3(t39, -0.6e1 * t1417, 0);
  t6747 = t4303 * t201;
  t6749 = t952 * t565;
  t6751 = -0.3e1 / 0.8e1 * t1455 * t1784 + 0.5e1 / 0.32e2 * t1470 * t1720 + 0.9e1 / 0.32e2 * t469 * t1521 * t6720 - 0.3e1 / 0.8e1 * t484 * t1752 * t1517 - 0.3e1 / 0.32e2 * t6727 - 0.3e1 / 0.16e2 * t6729 - t4432 * t201 / 0.16e2 - 0.3e1 / 0.16e2 * t1050 * t565 - 0.3e1 / 0.16e2 * t246 * t1810 - t6738 - 0.3e1 / 0.32e2 * t6739 - t99 * t100 * t6742 * t116 / 0.16e2 + 0.3e1 / 0.64e2 * t6747 + 0.3e1 / 0.64e2 * t6749;
  t6755 = my_piecewise3(t2, 0, t6499 + t6532 + t6577 + t6611 + t6646 + t6677 + t6715 + t6751);
  tv4rho3lapl0 = t3 * t6755 + 0.3e1 * t1815;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t6760 = t4781 * t209;
  t6762 = t4784 * t209;
  t6765 = 0.3e1 / 0.128e3 * t4787 * t209;
  t6767 = my_piecewise3(t51, 0, -t4778 * t209 / 0.16e2 - 0.3e1 / 0.32e2 * t6760 + 0.3e1 / 0.64e2 * t6762 - t6765);
  tv4rho3lapl1 = t3 * t6767 + 0.3e1 * t1825;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t6769 = 0.2e1 * t1848;
  t6773 = t5838 * t573 / 0.16e2;
  t6789 = t5838 * t569 / 0.16e2;
  t6802 = t5835 * t573 / 0.8e1 + t6773 + t1553 * t1776 / 0.8e1 - t1553 * t1779 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t1727 + 0.3e1 / 0.32e2 * t1548 * t1733 + t1553 * t1736 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t1740 - t5835 * t569 / 0.8e1 - t6789 - t1553 * t1770 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t1724 - 0.3e1 / 0.16e2 * t1553 * t1727 - t1553 * t1784 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t1720 + t1553 * t1790 / 0.16e2;
  t6814 = t5838 * t577 / 0.16e2;
  t6816 = t5879 * t559 / 0.32e2;
  t6829 = t1553 * t1753 / 0.8e1 - t1553 * t1757 / 0.16e2 + t1553 * t1787 / 0.16e2 + t5835 * t577 / 0.8e1 - t5874 * t559 / 0.16e2 + t6814 - t6816 - t5888 * t559 / 0.32e2 - t1548 * t1745 / 0.32e2 - t1548 * t1749 / 0.16e2 + t6508 / 0.8e1 - 0.3e1 / 0.32e2 * t6514 - 0.3e1 / 0.32e2 * t6516 - 0.3e1 / 0.64e2 * t6518 + 0.3e1 / 0.64e2 * t6520 - t6571 / 0.16e2;
  t6847 = t6578 / 0.32e2 - t6580 / 0.32e2 + 0.3e1 / 0.32e2 * t6582 + t6587 / 0.16e2 + t6595 / 0.16e2 - t6603 / 0.32e2 - t6622 / 0.16e2 - t6653 / 0.32e2 + t6655 / 0.64e2 + t6657 / 0.16e2 + t6659 / 0.16e2 + 0.3e1 / 0.64e2 * t6661 - t6663 / 0.32e2 - t6665 / 0.64e2 - t6667 / 0.64e2 - t6669 / 0.32e2;
  t6855 = t4645 * t201 / 0.16e2;
  t6856 = t4648 * t201;
  t6859 = t1124 * t565 / 0.16e2;
  t6869 = -t6679 / 0.32e2 + t6681 / 0.32e2 - t6683 / 0.16e2 + t6685 / 0.32e2 - t6727 / 0.32e2 - t6729 / 0.16e2 - t6855 + t6856 / 0.64e2 - t6859 - t345 * t1810 / 0.16e2 - t4659 * t201 / 0.16e2 - t1121 * t565 / 0.8e1 - t6738 - t6739 / 0.32e2 + t6747 / 0.32e2 + t6749 / 0.32e2;
  t6872 = my_piecewise3(t2, 0, t6802 + t6829 + t6847 + t6869);
  tv4rho3lapl2 = t3 * t6872 + t1815 + t6769;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t6874 = 0.2e1 * t1876;
  t6882 = t1167 * t604 / 0.16e2;
  t6883 = t1170 * t604;
  t6888 = t4904 * t209 / 0.16e2;
  t6889 = t4907 * t209;
  t6894 = t5945 * t612 / 0.16e2;
  t6896 = t5949 * t612;
  t6899 = t5945 * t616 / 0.16e2;
  t6900 = t5949 * t616;
  t6903 = t5956 * t598 / 0.32e2;
  t6904 = t5960 * t598;
  t6907 = t5945 * t608 / 0.16e2;
  t6908 = t5949 * t608;
  t6914 = -t6896 / 0.64e2 + t6899 - t6900 / 0.64e2 - t6903 + t6904 / 0.128e3 - t6907 + t6908 / 0.64e2 - t6760 / 0.32e2 + t6762 / 0.32e2 - t6765 - t4880 * t209 / 0.16e2;
  t6916 = my_piecewise3(t51, 0, -t1164 * t604 / 0.16e2 + t5967 * t612 / 0.16e2 + t5967 * t616 / 0.16e2 - t6882 + t6883 / 0.64e2 - t5967 * t608 / 0.16e2 - t6888 + t6889 / 0.64e2 - t5973 * t598 / 0.32e2 + t6894 + t6914);
  tv4rho3lapl3 = t3 * t6916 + t1825 + t6874;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t6920 = t4805 * t201;
  t6940 = -t6859 - t6789 + t6773 + t6814 + t6747 / 0.64e2 - t6738 + t6655 / 0.128e3 + t6749 / 0.64e2 + t6578 / 0.64e2 - t6580 / 0.64e2 - t6653 / 0.64e2;
  t6942 = my_piecewise3(t2, 0, -t4802 * t201 / 0.16e2 - t6920 / 0.32e2 - t6000 * t559 / 0.32e2 - t1196 * t565 / 0.16e2 - t6005 * t569 / 0.16e2 + t6005 * t573 / 0.16e2 + t6005 * t577 / 0.16e2 - t6855 + t6856 / 0.32e2 - t6816 + t6940);
  tv4rho3lapl4 = t3 * t6942 + t1883 + t6769;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t6944 = t6025 * t598;
  t6948 = t6070 * t598;
  t6950 = t6048 * t608;
  t6952 = t1589 * t1912;
  t6954 = t6048 * t612;
  t6956 = t1578 * t1944;
  t6958 = t1578 * t1948;
  t6960 = t1589 * t1952;
  t6962 = t1589 * t1956;
  t6964 = t6048 * t616;
  t6966 = t1589 * t1936;
  t6968 = t1589 * t1939;
  t6976 = -t6944 / 0.64e2 - t6092 * t598 / 0.32e2 - t6948 / 0.32e2 - t6950 / 0.16e2 - t6952 / 0.16e2 + t6954 / 0.16e2 - t6956 / 0.64e2 - t6958 / 0.32e2 + t6960 / 0.16e2 - t6962 / 0.32e2 + t6964 / 0.16e2 + t6966 / 0.32e2 + t6968 / 0.32e2 - t1585 * t1886 / 0.8e1 - t1585 * t1912 / 0.8e1 + t6085 * t612 / 0.8e1;
  t6999 = t1589 * t1902;
  t7001 = t1578 * t1890;
  t7003 = t1578 * t1894;
  t7005 = t1589 * t1898;
  t7007 = t1589 * t1890;
  t7009 = t1585 * t1918 / 0.8e1 - t1585 * t1921 / 0.16e2 - t6085 * t608 / 0.8e1 + t6085 * t616 / 0.8e1 - t6107 * t598 / 0.16e2 - t1574 * t1944 / 0.32e2 - t1574 * t1948 / 0.16e2 + t1585 * t1952 / 0.8e1 - t1585 * t1956 / 0.16e2 + t1585 * t1936 / 0.16e2 + t1585 * t1939 / 0.16e2 - 0.3e1 / 0.32e2 * t6999 - 0.3e1 / 0.64e2 * t7001 + 0.3e1 / 0.64e2 * t7003 + t7005 / 0.8e1 - 0.3e1 / 0.32e2 * t7007;
  t7011 = t1589 * t1886;
  t7013 = t1589 * t1918;
  t7015 = t1589 * t1921;
  t7017 = t1578 * t1925;
  t7019 = t1589 * t1928;
  t7037 = -t7011 / 0.16e2 + t7013 / 0.16e2 - t7015 / 0.32e2 + 0.3e1 / 0.64e2 * t7017 + 0.3e1 / 0.32e2 * t7019 - 0.3e1 / 0.32e2 * t1574 * t1890 + 0.3e1 / 0.32e2 * t1574 * t1894 + t1585 * t1898 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t1902 + 0.3e1 / 0.32e2 * t1574 * t1925 + 0.3e1 / 0.16e2 * t1585 * t1928 - 0.3e1 / 0.16e2 * t1585 * t1890 + t6894 - t6896 / 0.32e2 + t6899 - t6900 / 0.32e2;
  t7040 = t370 * t1968;
  t7042 = t5025 * t209;
  t7044 = t1227 * t604;
  t7055 = -t6903 + t6904 / 0.64e2 - t6907 + t6908 / 0.32e2 - t7040 / 0.32e2 - t7042 / 0.32e2 - t7044 / 0.16e2 - t1224 * t604 / 0.8e1 - t367 * t1968 / 0.16e2 - t5057 * t209 / 0.16e2 - t6882 + t6883 / 0.32e2 - t6888 + t6889 / 0.32e2 + t6762 / 0.64e2 - t6765;
  t7058 = my_piecewise3(t51, 0, t6976 + t7009 + t7037 + t7055);
  tv4rho3lapl5 = t3 * t7058 + t1975 + t6874;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t7066 = my_piecewise3(t2, 0, -t4984 * t201 / 0.16e2 - 0.3e1 / 0.32e2 * t6920 + 0.3e1 / 0.64e2 * t6856 - t6738);
  tv4rho3lapl6 = t3 * t7066 + 0.3e1 * t1883;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t7069 = t611 * t1350;
  t7077 = t1386 * t450 * t2574;
  t7080 = t607 * t75;
  t7090 = t2573 * t438;
  t7106 = t602 * t416;
  t7110 = 0.3e1 / 0.4e1 * t534 * t7069 * t6157 - 0.9e1 / 0.16e2 * t534 * t2566 * t6157 - 0.9e1 / 0.32e2 * t519 * t7077 + 0.9e1 / 0.16e2 * t534 * t7080 * t5164 - 0.3e1 / 0.16e2 * t534 * t1955 * t168 * t1337 - 0.9e1 / 0.16e2 * t534 * t7077 + 0.9e1 / 0.32e2 * t519 * t6189 * t7090 - 0.3e1 / 0.8e1 * t534 * t2600 * t6157 + 0.9e1 / 0.32e2 * t519 * t6181 * t7090 - 0.9e1 / 0.32e2 * t1670 * t1890 + 0.9e1 / 0.32e2 * t1670 * t1894 + 0.3e1 / 0.4e1 * t1667 * t1898 + 0.3e1 / 0.4e1 * t534 * t7106 * t1357;
  t7117 = t602 * t1348;
  t7121 = t207 * t1332;
  t7125 = t6233 * t207;
  t7126 = t6232 * t7125;
  t7129 = t6239 * t207;
  t7133 = t7121 * t5382;
  t7136 = t1901 * t6248;
  t7139 = t1628 * t602;
  t7140 = t1619 * t7139;
  t7143 = t1641 * t602;
  t7155 = -0.5e1 / 0.32e2 * t1674 * t1890 + 0.5e1 / 0.32e2 * t1674 * t1894 - 0.9e1 / 0.16e2 * t1667 * t1902 - 0.9e1 / 0.16e2 * t534 * t7117 * t1651 + 0.11e2 / 0.16e2 * t534 * t7121 * t5254 + 0.9e1 / 0.16e2 * t519 * t7126 - 0.9e1 / 0.16e2 * t519 * t6238 * t7129 - 0.3e1 / 0.2e1 * t534 * t7133 + 0.9e1 / 0.8e1 * t534 * t7136 - 0.9e1 / 0.32e2 * t519 * t7140 + 0.9e1 / 0.32e2 * t519 * t1640 * t7143 - 0.9e1 / 0.16e2 * t534 * t7140 - 0.9e1 / 0.16e2 * t1667 * t1890 - 0.3e1 / 0.16e2 * t534 * t1966 * t168 * t445;
  t7178 = t1966 * t418;
  t7184 = t6257 * t207;
  t7191 = t207 * t5342;
  t7195 = -0.3e1 / 0.16e2 * t6287 * t608 - 0.3e1 / 0.8e1 * t1667 * t1912 + 0.3e1 / 0.16e2 * t6287 * t612 + 0.3e1 / 0.8e1 * t1667 * t1918 - 0.3e1 / 0.16e2 * t1667 * t1921 - 0.3e1 / 0.16e2 * t534 * t7106 * t1337 - t534 * t7121 * t5235 / 0.16e2 + 0.9e1 / 0.16e2 * t534 * t7106 * t1369 + 0.9e1 / 0.16e2 * t1667 * t1928 + 0.3e1 / 0.16e2 * t534 * t7178 * t541 + 0.11e2 / 0.16e2 * t519 * t7136 - 0.15e2 / 0.32e2 * t519 * t6256 * t7184 - 0.25e2 / 0.16e2 * t534 * t7121 * t5351 + 0.15e2 / 0.16e2 * t534 * t7191 * t6228;
  t7231 = -t534 * t207 * t1318 * t445 / 0.16e2 + 0.3e1 / 0.16e2 * t6287 * t616 + t534 * t611 * t6329 / 0.16e2 + 0.3e1 / 0.16e2 * t1667 * t1939 + 0.3e1 / 0.16e2 * t534 * t1951 * t1710 + t534 * t615 * t6359 / 0.16e2 - 0.3e1 / 0.32e2 * t6343 * t598 - t6351 * t598 / 0.32e2 - t1674 * t1944 / 0.16e2 - 0.3e1 / 0.32e2 * t1674 * t1948 - 0.3e1 / 0.32e2 * t1670 * t1944 - t519 * t5178 * t597 / 0.32e2 - 0.3e1 / 0.32e2 * t519 * t1386 * t1947 + 0.3e1 / 0.16e2 * t1667 * t1936;
  t7245 = t521 * t1966;
  t7251 = t1966 * t75;
  t7268 = 0.3e1 / 0.16e2 * t534 * t1917 * t1663 - 0.7e1 / 0.32e2 * t519 * t7133 + 0.9e1 / 0.32e2 * t1670 * t1925 - 0.3e1 / 0.32e2 * t6337 * t598 - 0.3e1 / 0.16e2 * t1670 * t1948 - 0.3e1 / 0.32e2 * t519 * t520 * t7245 + 0.3e1 / 0.8e1 * t1667 * t1952 + 0.3e1 / 0.16e2 * t534 * t7251 * t547 - 0.3e1 / 0.16e2 * t1667 * t1956 - 0.3e1 / 0.16e2 * t534 * t602 * t438 * t445 + 0.11e2 / 0.16e2 * t534 * t7126 + 0.3e1 / 0.8e1 * t534 * t7121 * t5411 - 0.3e1 / 0.8e1 * t1667 * t1886;
  t7271 = t1620 * t602;
  t7282 = t6307 * t207;
  t7296 = 0.5e1 / 0.32e2 * t1674 * t1925 + 0.9e1 / 0.32e2 * t519 * t1619 * t7271 - 0.3e1 / 0.8e1 * t534 * t1951 * t1634 - 0.3e1 / 0.64e2 * t6944 + 0.3e1 / 0.8e1 * t534 * t615 * t6300 - 0.11e2 / 0.32e2 * t519 * t6232 * t7282 - 0.11e2 / 0.16e2 * t534 * t7121 * t5389 - 0.3e1 / 0.32e2 * t6948 - 0.3e1 / 0.16e2 * t6950 - 0.3e1 / 0.16e2 * t6952 + 0.3e1 / 0.16e2 * t6954 - 0.3e1 / 0.64e2 * t6956 - 0.3e1 / 0.32e2 * t6958 + 0.3e1 / 0.16e2 * t6960;
  t7312 = -0.3e1 / 0.32e2 * t6962 + 0.3e1 / 0.16e2 * t6964 + 0.3e1 / 0.32e2 * t6966 + 0.3e1 / 0.32e2 * t6968 - 0.9e1 / 0.32e2 * t6999 - 0.9e1 / 0.64e2 * t7001 + 0.9e1 / 0.64e2 * t7003 + 0.3e1 / 0.8e1 * t7005 - 0.9e1 / 0.32e2 * t7007 - 0.3e1 / 0.16e2 * t7011 + 0.3e1 / 0.16e2 * t7013 - 0.3e1 / 0.32e2 * t7015 + 0.9e1 / 0.64e2 * t7017 + 0.9e1 / 0.32e2 * t7019;
  t7318 = my_piecewise3(t72, -0.6e1 * t1699, 0);
  t7334 = -0.3e1 / 0.64e2 * t6896 - 0.3e1 / 0.64e2 * t6900 + 0.3e1 / 0.128e3 * t6904 + 0.3e1 / 0.64e2 * t6908 - t156 * t157 * t7318 * t173 / 0.16e2 - t5324 * t209 / 0.16e2 - 0.3e1 / 0.16e2 * t1323 * t604 - 0.3e1 / 0.32e2 * t7040 - 0.3e1 / 0.32e2 * t7042 - 0.3e1 / 0.16e2 * t7044 - 0.3e1 / 0.16e2 * t409 * t1968 + 0.3e1 / 0.64e2 * t6883 + 0.3e1 / 0.64e2 * t6889 - t6765;
  t7338 = my_piecewise3(t51, 0, t7110 + t7155 + t7195 + t7231 + t7268 + t7296 + t7312 + t7334);
  tv4rho3lapl7 = t3 * t7338 + 0.3e1 * t1975;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t7348 = t636 * t43;
  t7356 = t2666 * t5494;
  t7361 = t2657 * t283;
  t7373 = t1462 * t2014;
  t7375 = t631 * t261;
  t7379 = t5580 * t641;
  t7381 = 0.3e1 / 0.4e1 * t484 * t2045 * t263 * t2256 - 0.9e1 / 0.16e2 * t484 * t2645 * t5494 + 0.9e1 / 0.16e2 * t484 * t7348 * t4267 - 0.3e1 / 0.16e2 * t484 * t2045 * t111 * t986 - 0.9e1 / 0.16e2 * t484 * t7356 - 0.9e1 / 0.32e2 * t469 * t7356 + 0.9e1 / 0.32e2 * t469 * t5509 * t7361 - 0.3e1 / 0.8e1 * t484 * t2653 * t5494 + 0.9e1 / 0.32e2 * t469 * t5483 * t7361 - 0.9e1 / 0.16e2 * t1455 * t1978 - 0.3e1 / 0.16e2 * t7373 + 0.9e1 / 0.16e2 * t484 * t7375 * t968 + 0.3e1 / 0.16e2 * t7379;
  t7384 = t5567 * t641;
  t7386 = t1462 * t2035;
  t7388 = t2061 * t263;
  t7396 = t1462 * t2022;
  t7398 = t1462 * t2026;
  t7405 = t213 * t955;
  t7409 = t2021 * t1433;
  t7417 = 0.9e1 / 0.16e2 * t1455 * t2035 - 0.3e1 / 0.64e2 * t7384 + 0.9e1 / 0.32e2 * t7386 + 0.3e1 / 0.16e2 * t484 * t7388 * t491 + 0.3e1 / 0.16e2 * t5531 * t641 + 0.3e1 / 0.8e1 * t1455 * t2022 + 0.3e1 / 0.16e2 * t7396 - 0.3e1 / 0.32e2 * t7398 - 0.3e1 / 0.16e2 * t484 * t7375 * t986 - 0.3e1 / 0.16e2 * t1455 * t2026 - t484 * t7405 * t4319 / 0.16e2 - 0.9e1 / 0.16e2 * t484 * t7409 - 0.11e2 / 0.16e2 * t484 * t7405 * t4309 + 0.5e1 / 0.32e2 * t1470 * t2032;
  t7419 = t1462 * t1981;
  t7424 = t1462 * t2046;
  t7426 = t1462 * t2049;
  t7430 = t1462 * t2038;
  t7432 = t1462 * t2042;
  t7434 = t5580 * t637;
  t7436 = t5567 * t637;
  t7446 = t5580 * t645;
  t7448 = t5773 * t627;
  t7450 = -0.3e1 / 0.16e2 * t7419 - 0.3e1 / 0.8e1 * t484 * t2041 * t1517 - 0.3e1 / 0.32e2 * t7424 + 0.3e1 / 0.32e2 * t7426 - 0.3e1 / 0.8e1 * t1455 * t1981 + 0.3e1 / 0.32e2 * t7430 + 0.3e1 / 0.16e2 * t7432 - 0.3e1 / 0.16e2 * t7434 + 0.3e1 / 0.64e2 * t7436 - 0.3e1 / 0.16e2 * t484 * t2061 * t111 * t290 - 0.3e1 / 0.16e2 * t5531 * t637 - 0.3e1 / 0.8e1 * t1455 * t2014 + 0.3e1 / 0.16e2 * t7446 - 0.3e1 / 0.32e2 * t7448;
  t7469 = t2061 * t43;
  t7473 = t1522 * t631;
  t7487 = t640 * t5628;
  t7490 = 0.3e1 / 0.16e2 * t5531 * t645 + 0.9e1 / 0.32e2 * t1458 * t2032 - 0.3e1 / 0.32e2 * t5667 * t627 - 0.3e1 / 0.32e2 * t5776 * t627 + 0.3e1 / 0.16e2 * t1455 * t2038 + 0.3e1 / 0.16e2 * t484 * t2041 * t1477 + t484 * t644 * t5600 / 0.16e2 + 0.3e1 / 0.8e1 * t1455 * t2042 + 0.3e1 / 0.16e2 * t484 * t7469 * t497 + 0.9e1 / 0.32e2 * t469 * t1521 * t7473 - 0.3e1 / 0.16e2 * t1455 * t2046 - 0.3e1 / 0.16e2 * t484 * t631 * t283 * t290 - t484 * t213 * t1045 * t290 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t7487;
  t7499 = t5733 * t213;
  t7503 = t1462 * t1989;
  t7505 = t5635 * t213;
  t7506 = t5732 * t7505;
  t7521 = t471 * t2061;
  t7529 = 0.3e1 / 0.8e1 * t484 * t644 * t5560 + 0.3e1 / 0.8e1 * t484 * t7405 * t4414 - 0.11e2 / 0.32e2 * t469 * t5732 * t7499 + 0.3e1 / 0.8e1 * t7503 - 0.7e1 / 0.32e2 * t469 * t7506 - t5768 * t627 / 0.32e2 - t1470 * t2004 / 0.16e2 - 0.3e1 / 0.32e2 * t1470 * t2008 - t469 * t4219 * t626 / 0.32e2 - 0.3e1 / 0.32e2 * t469 * t940 * t2007 - 0.3e1 / 0.32e2 * t469 * t470 * t7521 - 0.3e1 / 0.32e2 * t1458 * t2004 - 0.3e1 / 0.16e2 * t1458 * t2008;
  t7530 = t5567 * t645;
  t7532 = t5758 * t627;
  t7534 = t1466 * t2032;
  t7536 = t5762 * t627;
  t7538 = t1466 * t2004;
  t7540 = t1466 * t2008;
  t7557 = t1992 * t5644;
  t7562 = -0.3e1 / 0.64e2 * t7530 + 0.3e1 / 0.128e3 * t7532 + 0.9e1 / 0.64e2 * t7534 - 0.3e1 / 0.64e2 * t7536 - 0.3e1 / 0.64e2 * t7538 - 0.3e1 / 0.32e2 * t7540 + 0.3e1 / 0.16e2 * t1455 * t2049 + 0.3e1 / 0.16e2 * t484 * t2021 * t1493 + t484 * t640 * t5700 / 0.16e2 + 0.9e1 / 0.16e2 * t469 * t7487 - 0.9e1 / 0.16e2 * t469 * t5634 * t7505 - 0.3e1 / 0.2e1 * t484 * t7506 + 0.9e1 / 0.8e1 * t484 * t7557 + 0.11e2 / 0.16e2 * t469 * t7557;
  t7564 = t5651 * t213;
  t7572 = t1462 * t1978;
  t7574 = t1466 * t1978;
  t7576 = t1466 * t1985;
  t7584 = t1440 * t631;
  t7591 = t213 * t4275;
  t7600 = -0.15e2 / 0.32e2 * t469 * t5650 * t7564 - 0.9e1 / 0.32e2 * t1458 * t1978 + 0.9e1 / 0.32e2 * t1458 * t1985 - 0.9e1 / 0.32e2 * t7572 - 0.9e1 / 0.64e2 * t7574 + 0.9e1 / 0.64e2 * t7576 - 0.5e1 / 0.32e2 * t1470 * t1978 + 0.5e1 / 0.32e2 * t1470 * t1985 - 0.9e1 / 0.32e2 * t469 * t7409 + 0.9e1 / 0.32e2 * t469 * t1439 * t7584 - 0.25e2 / 0.16e2 * t484 * t7405 * t4351 + 0.15e2 / 0.16e2 * t484 * t7591 * t5611 + 0.3e1 / 0.4e1 * t484 * t7375 * t1006 + 0.3e1 / 0.4e1 * t1455 * t1989;
  t7601 = t1462 * t1993;
  t7603 = t631 * t997;
  t7612 = t255 * t2063;
  t7615 = 0.3e1 / 0.128e3 * t4306 * t215;
  t7616 = t4303 * t215;
  t7621 = my_piecewise3(t39, 0.24e2 * t1417, 0);
  t7630 = t4300 * t215;
  t7632 = t1053 * t633;
  t7634 = t952 * t633;
  t7636 = -0.9e1 / 0.32e2 * t7601 - 0.9e1 / 0.16e2 * t484 * t7603 * t1451 + 0.11e2 / 0.16e2 * t484 * t7405 * t4331 - 0.9e1 / 0.16e2 * t1455 * t1993 - 0.3e1 / 0.32e2 * t7612 - t7615 + 0.3e1 / 0.64e2 * t7616 - 0.3e1 / 0.16e2 * t246 * t2063 - t99 * t100 * t7621 * t116 / 0.16e2 - t4432 * t215 / 0.16e2 - 0.3e1 / 0.16e2 * t1050 * t633 - 0.3e1 / 0.32e2 * t7630 - 0.3e1 / 0.16e2 * t7632 + 0.3e1 / 0.64e2 * t7634;
  t7640 = my_piecewise3(t2, 0, t7381 + t7417 + t7450 + t7490 + t7529 + t7562 + t7600 + t7636);
  tv4rho3tau0 = t3 * t7640 + 0.3e1 * t2074;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t7645 = t4781 * t221;
  t7647 = t4784 * t221;
  t7650 = 0.3e1 / 0.128e3 * t4787 * t221;
  t7652 = my_piecewise3(t51, 0, -t4778 * t221 / 0.16e2 - 0.3e1 / 0.32e2 * t7645 + 0.3e1 / 0.64e2 * t7647 - t7650);
  tv4rho3tau1 = t3 * t7652 + 0.3e1 * t2084;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t7654 = 0.2e1 * t2107;
  t7658 = t5838 * t637 / 0.16e2;
  t7664 = t5838 * t641 / 0.16e2;
  t7680 = t5838 * t645 / 0.16e2;
  t7682 = t5879 * t627 / 0.32e2;
  t7687 = -t5835 * t637 / 0.8e1 - t7658 - t1553 * t2014 / 0.8e1 + t5835 * t641 / 0.8e1 + t7664 + t1553 * t2022 / 0.8e1 - t1553 * t2026 / 0.16e2 - t1553 * t2046 / 0.16e2 + t1553 * t2049 / 0.16e2 + t1553 * t2038 / 0.16e2 + t5835 * t645 / 0.8e1 - t5874 * t627 / 0.16e2 + t7680 - t7682 - t5888 * t627 / 0.32e2 - t1548 * t2004 / 0.32e2;
  t7714 = -t1548 * t2008 / 0.16e2 + t1553 * t2042 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t2035 - 0.3e1 / 0.16e2 * t1553 * t1978 - t1553 * t1981 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t2032 - 0.3e1 / 0.32e2 * t1548 * t1978 + 0.3e1 / 0.32e2 * t1548 * t1985 + t1553 * t1989 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t1993 - t7373 / 0.16e2 + t7379 / 0.16e2 - t7384 / 0.32e2 + 0.3e1 / 0.32e2 * t7386 + t7396 / 0.16e2 - t7398 / 0.32e2;
  t7732 = -t7419 / 0.16e2 - t7424 / 0.32e2 + t7426 / 0.32e2 + t7430 / 0.32e2 + t7432 / 0.16e2 - t7434 / 0.16e2 + t7436 / 0.32e2 + t7446 / 0.16e2 - t7448 / 0.32e2 + t7503 / 0.8e1 - t7530 / 0.32e2 + t7532 / 0.64e2 + 0.3e1 / 0.64e2 * t7534 - t7536 / 0.64e2 - t7538 / 0.64e2 - t7540 / 0.32e2;
  t7737 = t4648 * t215;
  t7740 = t4645 * t215 / 0.16e2;
  t7751 = t1124 * t633 / 0.16e2;
  t7754 = -0.3e1 / 0.32e2 * t7572 - 0.3e1 / 0.64e2 * t7574 + 0.3e1 / 0.64e2 * t7576 - 0.3e1 / 0.32e2 * t7601 + t7737 / 0.64e2 - t7740 - t7612 / 0.32e2 - t7615 + t7616 / 0.32e2 - t7630 / 0.32e2 - t7632 / 0.16e2 + t7634 / 0.32e2 - t4659 * t215 / 0.16e2 - t1121 * t633 / 0.8e1 - t7751 - t345 * t2063 / 0.16e2;
  t7757 = my_piecewise3(t2, 0, t7687 + t7714 + t7732 + t7754);
  tv4rho3tau2 = t3 * t7757 + t2074 + t7654;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t7759 = 0.2e1 * t2135;
  t7762 = t1170 * t672;
  t7771 = t1167 * t672 / 0.16e2;
  t7773 = t4904 * t221 / 0.16e2;
  t7774 = t4907 * t221;
  t7781 = t5949 * t680;
  t7784 = t5945 * t684 / 0.16e2;
  t7785 = t5949 * t684;
  t7788 = t5956 * t666 / 0.32e2;
  t7789 = t5960 * t666;
  t7792 = t5945 * t676 / 0.16e2;
  t7793 = t5949 * t676;
  t7796 = t5945 * t680 / 0.16e2;
  t7799 = -t7781 / 0.64e2 + t7784 - t7785 / 0.64e2 - t7788 + t7789 / 0.128e3 - t7792 + t7793 / 0.64e2 + t7796 - t7645 / 0.32e2 + t7647 / 0.32e2 - t7650;
  t7801 = my_piecewise3(t51, 0, t5967 * t684 / 0.16e2 + t7762 / 0.64e2 - t5967 * t676 / 0.16e2 + t5967 * t680 / 0.16e2 - t5973 * t666 / 0.32e2 - t7771 - t7773 + t7774 / 0.64e2 - t1164 * t672 / 0.16e2 - t4880 * t221 / 0.16e2 + t7799);
  tv4rho3tau3 = t3 * t7801 + t2084 + t7759;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t7805 = t4805 * t215;
  t7825 = -t7751 - t7658 + t7664 + t7680 + t7616 / 0.64e2 - t7615 + t7532 / 0.128e3 + t7634 / 0.64e2 + t7436 / 0.64e2 - t7384 / 0.64e2 - t7530 / 0.64e2;
  t7827 = my_piecewise3(t2, 0, -t4802 * t215 / 0.16e2 - t7805 / 0.32e2 - t6000 * t627 / 0.32e2 - t1196 * t633 / 0.16e2 - t6005 * t637 / 0.16e2 + t6005 * t641 / 0.16e2 + t6005 * t645 / 0.16e2 - t7740 + t7737 / 0.32e2 - t7682 + t7825);
  tv4rho3tau4 = t3 * t7827 + t2142 + t7654;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t7829 = t6048 * t676;
  t7831 = t1589 * t2148;
  t7833 = t6048 * t680;
  t7835 = t6048 * t684;
  t7837 = t6070 * t666;
  t7839 = t6025 * t666;
  t7841 = t1578 * t2205;
  t7843 = t1578 * t2209;
  t7845 = t1589 * t2189;
  t7847 = t1589 * t2192;
  t7849 = t1589 * t2196;
  t7851 = t1578 * t2168;
  t7853 = t1578 * t2175;
  t7855 = t1589 * t2178;
  t7857 = t1589 * t2182;
  t7859 = t1589 * t2168;
  t7861 = -t7829 / 0.16e2 - t7831 / 0.16e2 + t7833 / 0.16e2 + t7835 / 0.16e2 - t7837 / 0.32e2 - t7839 / 0.64e2 - t7841 / 0.64e2 - t7843 / 0.32e2 - t7845 / 0.32e2 + t7847 / 0.32e2 + t7849 / 0.32e2 - 0.3e1 / 0.64e2 * t7851 + 0.3e1 / 0.64e2 * t7853 + t7855 / 0.8e1 - 0.3e1 / 0.32e2 * t7857 - 0.3e1 / 0.32e2 * t7859;
  t7862 = t1589 * t2171;
  t7864 = t1589 * t2154;
  t7866 = t1589 * t2158;
  t7868 = t1578 * t2162;
  t7870 = t1589 * t2165;
  t7872 = t1589 * t2213;
  t7894 = -t7862 / 0.16e2 + t7864 / 0.16e2 - t7866 / 0.32e2 + 0.3e1 / 0.64e2 * t7868 + 0.3e1 / 0.32e2 * t7870 + t7872 / 0.16e2 - 0.3e1 / 0.16e2 * t1585 * t2168 - t1585 * t2171 / 0.8e1 + t6085 * t680 / 0.8e1 + t1585 * t2154 / 0.8e1 - t1585 * t2158 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t2162 - t6085 * t676 / 0.8e1 - t1585 * t2148 / 0.8e1 - t1574 * t2205 / 0.32e2 - t1574 * t2209 / 0.16e2;
  t7922 = t1585 * t2213 / 0.8e1 + t1585 * t2196 / 0.16e2 + t6085 * t684 / 0.8e1 - t6107 * t666 / 0.16e2 - t6092 * t666 / 0.32e2 - t1585 * t2189 / 0.16e2 + t1585 * t2192 / 0.16e2 + t1585 * t2178 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2182 - 0.3e1 / 0.32e2 * t1574 * t2168 + 0.3e1 / 0.32e2 * t1574 * t2175 + 0.3e1 / 0.16e2 * t1585 * t2165 - t7792 + t7793 / 0.32e2 + t7796 - t7781 / 0.32e2;
  t7925 = t1227 * t672;
  t7927 = t370 * t2225;
  t7929 = t5025 * t221;
  t7940 = t7784 - t7785 / 0.32e2 - t7788 + t7789 / 0.64e2 - t7925 / 0.16e2 - t7927 / 0.32e2 - t7929 / 0.32e2 - t1224 * t672 / 0.8e1 - t367 * t2225 / 0.16e2 - t5057 * t221 / 0.16e2 + t7762 / 0.32e2 - t7771 - t7773 + t7774 / 0.32e2 + t7647 / 0.64e2 - t7650;
  t7943 = my_piecewise3(t51, 0, t7861 + t7894 + t7922 + t7940);
  tv4rho3tau5 = t3 * t7943 + t2233 + t7759;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t7951 = my_piecewise3(t2, 0, -t4984 * t215 / 0.16e2 - 0.3e1 / 0.32e2 * t7805 + 0.3e1 / 0.64e2 * t7737 - t7615);
  tv4rho3tau6 = t3 * t7951 + 0.3e1 * t2142;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t7968 = t2762 * t438;
  t7976 = t520 * t450;
  t7977 = t7976 * t7968;
  t7985 = t1628 * t670;
  t7986 = t1619 * t7985;
  t7989 = t1641 * t670;
  t7997 = -0.3e1 / 0.16e2 * t534 * t2188 * t168 * t1337 + 0.3e1 / 0.4e1 * t534 * t2188 * t418 * t2400 - 0.9e1 / 0.16e2 * t534 * t2758 * t6157 - 0.3e1 / 0.8e1 * t534 * t2778 * t6157 + 0.9e1 / 0.32e2 * t519 * t6181 * t7968 + 0.9e1 / 0.16e2 * t534 * t2188 * t75 * t2374 - 0.9e1 / 0.32e2 * t519 * t7977 - 0.9e1 / 0.16e2 * t534 * t7977 + 0.9e1 / 0.32e2 * t519 * t6189 * t7968 - 0.9e1 / 0.32e2 * t519 * t7986 + 0.9e1 / 0.32e2 * t519 * t1640 * t7989 - 0.9e1 / 0.16e2 * t534 * t7986 - 0.3e1 / 0.8e1 * t1667 * t2148;
  t8006 = t670 * t416;
  t8010 = t219 * t1332;
  t8016 = t2223 * t418;
  t8030 = t219 * t5342;
  t8039 = -0.3e1 / 0.16e2 * t534 * t2223 * t168 * t445 - 0.3e1 / 0.16e2 * t6287 * t676 - 0.3e1 / 0.16e2 * t1667 * t2158 - 0.3e1 / 0.16e2 * t534 * t8006 * t1337 - t534 * t8010 * t5235 / 0.16e2 + 0.3e1 / 0.8e1 * t1667 * t2154 + 0.3e1 / 0.16e2 * t534 * t8016 * t541 + 0.3e1 / 0.16e2 * t6287 * t680 + 0.9e1 / 0.16e2 * t1667 * t2165 + 0.9e1 / 0.16e2 * t534 * t8006 * t1369 - 0.25e2 / 0.16e2 * t534 * t8010 * t5351 + 0.15e2 / 0.16e2 * t534 * t8030 * t6228 + 0.3e1 / 0.4e1 * t1667 * t2178 + 0.3e1 / 0.4e1 * t534 * t8006 * t1357;
  t8043 = t670 * t1348;
  t8050 = t6233 * t219;
  t8051 = t6232 * t8050;
  t8054 = t6239 * t219;
  t8058 = t8010 * t5382;
  t8061 = t2181 * t6248;
  t8076 = t6257 * t219;
  t8080 = -0.9e1 / 0.16e2 * t1667 * t2182 - 0.9e1 / 0.16e2 * t534 * t8043 * t1651 + 0.11e2 / 0.16e2 * t534 * t8010 * t5254 + 0.9e1 / 0.16e2 * t519 * t8051 - 0.9e1 / 0.16e2 * t519 * t6238 * t8054 - 0.3e1 / 0.2e1 * t534 * t8058 + 0.9e1 / 0.8e1 * t534 * t8061 - 0.9e1 / 0.16e2 * t1667 * t2168 - 0.9e1 / 0.32e2 * t1670 * t2168 + 0.9e1 / 0.32e2 * t1670 * t2175 - 0.5e1 / 0.32e2 * t1674 * t2168 + 0.5e1 / 0.32e2 * t1674 * t2175 + 0.11e2 / 0.16e2 * t519 * t8061 - 0.15e2 / 0.32e2 * t519 * t6256 * t8076;
  t8083 = t2223 * t75;
  t8090 = t1620 * t670;
  t8110 = t521 * t2223;
  t8118 = 0.5e1 / 0.32e2 * t1674 * t2162 + 0.3e1 / 0.16e2 * t534 * t8083 * t547 + 0.3e1 / 0.8e1 * t534 * t8010 * t5411 + 0.9e1 / 0.32e2 * t519 * t1619 * t8090 - 0.3e1 / 0.8e1 * t534 * t2212 * t1634 - 0.3e1 / 0.8e1 * t1667 * t2171 + t534 * t683 * t6359 / 0.16e2 + 0.9e1 / 0.32e2 * t1670 * t2162 - 0.3e1 / 0.32e2 * t6343 * t666 - 0.3e1 / 0.32e2 * t1670 * t2205 - t6351 * t666 / 0.32e2 - 0.3e1 / 0.32e2 * t519 * t520 * t8110 + 0.3e1 / 0.16e2 * t6287 * t684 - 0.3e1 / 0.32e2 * t6337 * t666;
  t8145 = t6307 * t219;
  t8157 = -0.3e1 / 0.16e2 * t1667 * t2189 - 0.3e1 / 0.16e2 * t534 * t670 * t438 * t445 - t534 * t219 * t1318 * t445 / 0.16e2 + 0.3e1 / 0.16e2 * t1667 * t2192 + 0.3e1 / 0.16e2 * t534 * t2153 * t1663 + t534 * t679 * t6329 / 0.16e2 + 0.3e1 / 0.16e2 * t1667 * t2196 + 0.3e1 / 0.8e1 * t1667 * t2213 - 0.3e1 / 0.16e2 * t1670 * t2209 - 0.11e2 / 0.32e2 * t519 * t6232 * t8145 - 0.11e2 / 0.16e2 * t534 * t8010 * t5389 + 0.11e2 / 0.16e2 * t534 * t8051 + 0.3e1 / 0.8e1 * t534 * t683 * t6300;
  t8181 = -0.7e1 / 0.32e2 * t519 * t8058 - t1674 * t2205 / 0.16e2 - 0.3e1 / 0.32e2 * t1674 * t2209 - t519 * t5178 * t665 / 0.32e2 - 0.3e1 / 0.32e2 * t519 * t1386 * t2208 + 0.3e1 / 0.16e2 * t534 * t2212 * t1710 - 0.3e1 / 0.16e2 * t7829 - 0.3e1 / 0.16e2 * t7831 + 0.3e1 / 0.16e2 * t7833 + 0.3e1 / 0.16e2 * t7835 - 0.3e1 / 0.32e2 * t7837 - 0.3e1 / 0.64e2 * t7839 - 0.3e1 / 0.64e2 * t7841 - 0.3e1 / 0.32e2 * t7843;
  t8197 = -0.3e1 / 0.32e2 * t7845 + 0.3e1 / 0.32e2 * t7847 + 0.3e1 / 0.32e2 * t7849 - 0.9e1 / 0.64e2 * t7851 + 0.9e1 / 0.64e2 * t7853 + 0.3e1 / 0.8e1 * t7855 - 0.9e1 / 0.32e2 * t7857 - 0.9e1 / 0.32e2 * t7859 - 0.3e1 / 0.16e2 * t7862 + 0.3e1 / 0.16e2 * t7864 - 0.3e1 / 0.32e2 * t7866 + 0.9e1 / 0.64e2 * t7868 + 0.9e1 / 0.32e2 * t7870 + 0.3e1 / 0.16e2 * t7872;
  t8203 = my_piecewise3(t72, 0.24e2 * t1699, 0);
  t8219 = 0.3e1 / 0.64e2 * t7793 - 0.3e1 / 0.64e2 * t7781 - 0.3e1 / 0.64e2 * t7785 + 0.3e1 / 0.128e3 * t7789 - t156 * t157 * t8203 * t173 / 0.16e2 - t5324 * t221 / 0.16e2 - 0.3e1 / 0.16e2 * t1323 * t672 - 0.3e1 / 0.16e2 * t409 * t2225 - 0.3e1 / 0.16e2 * t7925 - 0.3e1 / 0.32e2 * t7927 - 0.3e1 / 0.32e2 * t7929 + 0.3e1 / 0.64e2 * t7762 + 0.3e1 / 0.64e2 * t7774 - t7650;
  t8223 = my_piecewise3(t51, 0, t7997 + t8039 + t8080 + t8118 + t8157 + t8181 + t8197 + t8219);
  tv4rho3tau7 = t3 * t8223 + 0.3e1 * t2233;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t8229 = t1432 * t478;
  t8233 = t489 * t999;
  t8235 = t958 * t478 * t111;
  t8241 = t489 * t295;
  t8242 = t8241 * t8235;
  t8248 = t2464 * t478;
  t8258 = t1455 * t2244 / 0.8e1;
  t8261 = t1462 * t2240;
  t8263 = t690 * t261;
  t8267 = t1466 * t2266;
  t8269 = 0.3e1 / 0.4e1 * t484 * t5513 * t5591 - t484 * t5513 * t8229 / 0.4e1 + t484 * t8233 * t8235 - 0.3e1 / 0.4e1 * t484 * t5504 * t8235 - 0.3e1 / 0.8e1 * t469 * t8242 - t484 * t5492 * t8235 / 0.2e1 + 0.3e1 / 0.8e1 * t469 * t5483 * t8248 - 0.3e1 / 0.4e1 * t484 * t8242 + 0.3e1 / 0.8e1 * t469 * t5509 * t8248 - t8258 - t1455 * t2248 / 0.8e1 + 0.3e1 / 0.16e2 * t8261 - 0.11e2 / 0.16e2 * t484 * t8263 * t4309 - 0.3e1 / 0.32e2 * t8267;
  t8270 = t1462 * t2252;
  t8271 = t8270 / 0.16e2;
  t8272 = t695 * t261;
  t8275 = 0.3e1 / 0.16e2 * t484 * t8272 * t968;
  t8281 = t484 * t8272 * t986 / 0.16e2;
  t8286 = t1455 * t2252 / 0.8e1;
  t8295 = t1462 * t2257;
  t8297 = t1462 * t2262;
  t8299 = t5627 * t261;
  t8300 = t2255 * t8299;
  t8303 = t2251 * t1433;
  t8305 = 0.3e1 / 0.16e2 * t484 * t8303;
  t8307 = 0.3e1 / 0.32e2 * t469 * t8303;
  t8308 = t8271 + t8275 + 0.3e1 / 0.8e1 * t484 * t8263 * t4414 - t8281 - t484 * t8263 * t4319 / 0.16e2 + t8286 + t1455 * t2257 / 0.2e1 - 0.3e1 / 0.8e1 * t1455 * t2262 - 0.5e1 / 0.32e2 * t1470 * t2266 + 0.5e1 / 0.32e2 * t1470 * t2269 + t8295 / 0.4e1 - 0.3e1 / 0.16e2 * t8297 + 0.9e1 / 0.16e2 * t469 * t8300 - t8305 - t8307;
  t8310 = t1440 * t695;
  t8313 = 0.3e1 / 0.32e2 * t469 * t1439 * t8310;
  t8316 = t484 * t8272 * t1006 / 0.4e1;
  t8320 = t695 * t997;
  t8323 = 0.3e1 / 0.16e2 * t484 * t8320 * t1451;
  t8324 = t5651 * t261;
  t8328 = t690 * t4275;
  t8329 = t5610 * t261;
  t8333 = t5635 * t261;
  t8334 = t2255 * t8333;
  t8337 = t5643 * t261;
  t8338 = t2260 * t8337;
  t8341 = t1462 * t2244;
  t8342 = t8341 / 0.16e2;
  t8343 = t1462 * t2248;
  t8355 = t8313 + t8316 + 0.11e2 / 0.16e2 * t484 * t8263 * t4331 - t8323 - 0.25e2 / 0.16e2 * t484 * t2260 * t8324 + 0.15e2 / 0.16e2 * t484 * t8328 * t8329 - 0.3e1 / 0.2e1 * t484 * t8334 + 0.9e1 / 0.8e1 * t484 * t8338 - t8342 - t8343 / 0.16e2 + 0.3e1 / 0.16e2 * t1458 * t2269 + t1455 * t2279 / 0.4e1 - t1455 * t2283 / 0.4e1 + 0.3e1 / 0.16e2 * t1458 * t2290 - t1458 * t2286 / 0.8e1;
  t8357 = t1455 * t2294 / 0.8e1;
  t8359 = t1458 * t2298 / 0.16e2;
  t8366 = t1462 * t2266;
  t8368 = t1466 * t2269;
  t8370 = t490 * t1419;
  t8376 = t484 * t2293 * t1517 / 0.8e1;
  t8377 = t5559 * t261;
  t8387 = t1462 * t2279;
  t8389 = t1462 * t2283;
  t8391 = t8357 - t8359 - t1455 * t2235 / 0.4e1 + 0.3e1 / 0.8e1 * t1455 * t2240 - 0.3e1 / 0.16e2 * t1458 * t2266 - 0.3e1 / 0.16e2 * t8366 + 0.3e1 / 0.32e2 * t8368 + t484 * t489 * t8370 / 0.8e1 - t8376 + 0.3e1 / 0.8e1 * t484 * t2238 * t8377 + 0.11e2 / 0.16e2 * t484 * t8300 + t1455 * t2273 / 0.4e1 - 0.3e1 / 0.8e1 * t1455 * t2266 + t8387 / 0.8e1 - t8389 / 0.8e1;
  t8394 = t1466 * t2290;
  t8396 = t496 * t1419;
  t8403 = t5733 * t690;
  t8411 = t1462 * t2273;
  t8422 = t484 * t695 * t283 * t290 / 0.16e2;
  t8431 = t484 * t2293 * t1477 / 0.16e2;
  t8432 = t1522 * t695;
  t8435 = 0.3e1 / 0.32e2 * t469 * t1521 * t8432;
  t8437 = t1470 * t2298 / 0.32e2;
  t8438 = 0.3e1 / 0.32e2 * t8394 + t484 * t495 * t8396 / 0.8e1 - t484 * t2238 * t4245 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t1521 * t8403 - t1470 * t2286 / 0.8e1 + 0.5e1 / 0.32e2 * t1470 * t2290 + t8411 / 0.8e1 - t484 * t495 * t5675 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2238 * t4267 - t8422 - t484 * t690 * t283 * t986 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t8334 + t8431 + t8435 - t8437;
  t8441 = t469 * t940 * t2297 / 0.32e2;
  t8442 = t1462 * t2235;
  t8444 = t1466 * t2286;
  t8452 = t1462 * t2294;
  t8453 = t8452 / 0.16e2;
  t8454 = t1466 * t2298;
  t8455 = t8454 / 0.32e2;
  t8456 = t2255 * t4237;
  t8459 = t5635 * t690;
  t8468 = t484 * t2251 * t1493 / 0.16e2;
  t8474 = t1450 * t283;
  t8479 = t5651 * t690;
  t8483 = -t8441 - t8442 / 0.8e1 - t8444 / 0.16e2 - t469 * t489 * t5675 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t2255 * t4267 + t8453 - t8455 - 0.3e1 / 0.16e2 * t484 * t8456 - 0.9e1 / 0.16e2 * t469 * t1439 * t8459 + 0.3e1 / 0.32e2 * t469 * t2260 * t4227 + t8468 + t484 * t2255 * t4227 / 0.4e1 + 0.11e2 / 0.16e2 * t469 * t8338 - 0.3e1 / 0.16e2 * t484 * t2260 * t8474 - 0.15e2 / 0.32e2 * t469 * t261 * t4275 * t8479;
  t8493 = t1053 * t704;
  t8495 = t1053 * t707;
  t8497 = t1053 * t692;
  t8499 = t255 * t2306;
  t8501 = t1053 * t697;
  t8502 = t8501 / 0.16e2;
  t8503 = t1053 * t701;
  t8506 = t1050 * t697 / 0.16e2;
  t8512 = t952 * t701 / 0.64e2;
  t8513 = t478 * t478;
  t8514 = t100 * t8513;
  t8519 = t952 * t692 / 0.128e3;
  t8520 = -0.3e1 / 0.32e2 * t469 * t8456 - t246 * t2306 / 0.16e2 - t99 * t4484 * t690 * t269 / 0.32e2 + t8493 / 0.16e2 + t8495 / 0.16e2 - t8497 / 0.32e2 - t8499 / 0.32e2 - t8502 - t8503 / 0.16e2 - t8506 - t1050 * t701 / 0.16e2 + t1050 * t704 / 0.16e2 + t8512 - t99 * t8514 * t290 / 0.8e1 + t8519;
  t8526 = t952 * t697 / 0.64e2;
  t8528 = t952 * t707 / 0.64e2;
  t8533 = t952 * t704 / 0.64e2;
  t8541 = t2245 / 0.8e1;
  t8542 = t2253 / 0.8e1;
  t8543 = t2295 / 0.8e1;
  t8544 = t2299 / 0.16e2;
  t8545 = t2315 / 0.16e2;
  t8546 = t2319 / 0.8e1;
  t8547 = -t99 * t260 * t8513 * t269 / 0.16e2 + t8526 - t8528 + t99 * t8514 * t301 / 0.8e1 - t8533 + t99 * t8514 * t297 / 0.8e1 + t1050 * t707 / 0.16e2 - t1050 * t692 / 0.32e2 - t8541 + t8542 + t8543 - t8544 - t8545 - t8546 - t699;
  t8551 = my_piecewise3(t2, 0, t8269 + t8308 + t8355 + t8391 + t8438 + t8483 + t8520 + t8547);
  tv4rho2sigma20 = t3 * t8551 + 0.2e1 * t2327;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t8556 = t1167 * t714;
  t8559 = t1170 * t714 / 0.128e3;
  t8561 = t1164 * t719 / 0.16e2;
  t8562 = t1167 * t719;
  t8563 = t8562 / 0.16e2;
  t8565 = t1170 * t719 / 0.64e2;
  t8568 = t1167 * t723;
  t8571 = t1170 * t723 / 0.64e2;
  t8574 = t1167 * t726;
  t8577 = t1170 * t726 / 0.64e2;
  t8580 = t1167 * t729;
  t8583 = t1170 * t729 / 0.64e2;
  t8584 = -t1164 * t714 / 0.32e2 - t8556 / 0.32e2 + t8559 - t8561 - t8563 + t8565 - t1164 * t723 / 0.16e2 - t8568 / 0.16e2 + t8571 + t1164 * t726 / 0.16e2 + t8574 / 0.16e2 - t8577 + t1164 * t729 / 0.16e2 + t8580 / 0.16e2 - t8583;
  t8585 = my_piecewise3(t51, 0, t8584);
  tv4rho2sigma25 = t3 * t8585 + 0.2e1 * t2350;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t8592 = t1553 * t2252 / 0.16e2;
  t8598 = t1553 * t2244 / 0.16e2;
  t8615 = -0.3e1 / 0.32e2 * t1548 * t2266 + 0.3e1 / 0.32e2 * t1548 * t2269 + t8592 + t1553 * t2257 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t2262 - t8598 - t1553 * t2248 / 0.16e2 + t1553 * t2279 / 0.8e1 - t1553 * t2283 / 0.8e1 - t1553 * t2235 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t2240 + t1553 * t2273 / 0.8e1 - 0.3e1 / 0.16e2 * t1553 * t2266 - t1548 * t2286 / 0.16e2;
  t8619 = t1553 * t2294 / 0.16e2;
  t8621 = t1548 * t2298 / 0.32e2;
  t8624 = t8270 / 0.32e2;
  t8627 = t8341 / 0.32e2;
  t8634 = 0.3e1 / 0.32e2 * t1548 * t2290 + t8619 - t8621 + 0.3e1 / 0.32e2 * t8261 - 0.3e1 / 0.64e2 * t8267 + t8624 + t8295 / 0.8e1 - 0.3e1 / 0.32e2 * t8297 - t8627 - t8343 / 0.32e2 - 0.3e1 / 0.32e2 * t8366 + 0.3e1 / 0.64e2 * t8368 + t8387 / 0.16e2 - t8389 / 0.16e2 + 0.3e1 / 0.64e2 * t8394;
  t8639 = t8452 / 0.32e2;
  t8640 = t8454 / 0.64e2;
  t8641 = t1124 * t707;
  t8643 = t1124 * t701;
  t8645 = t1124 * t704;
  t8647 = t1124 * t692;
  t8649 = t1124 * t697;
  t8650 = t8649 / 0.32e2;
  t8659 = t8411 / 0.16e2 - t8442 / 0.16e2 - t8444 / 0.32e2 + t8639 - t8640 + t8641 / 0.32e2 - t8643 / 0.32e2 + t8645 / 0.32e2 - t8647 / 0.64e2 - t8650 + t1121 * t704 / 0.16e2 + t1121 * t707 / 0.16e2 - t1121 * t692 / 0.32e2 - t345 * t2306 / 0.32e2;
  t8661 = t1121 * t697 / 0.16e2;
  t8668 = t8501 / 0.32e2;
  t8670 = -t8661 - t1121 * t701 / 0.16e2 + t8493 / 0.32e2 + t8495 / 0.32e2 - t8497 / 0.64e2 - t8499 / 0.64e2 - t8668 - t8503 / 0.32e2 + t8512 + t8519 + t8526 - t8528 - t8533 - t2355 - t2316;
  t8673 = my_piecewise3(t2, 0, t8615 + t8634 + t8659 + t8670);
  tv4rho2sigma26 = t3 * t8673 + t2327 + t2363;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t8675 = t1589 * t2367;
  t8677 = t1589 * t2391;
  t8678 = t8677 / 0.32e2;
  t8679 = t1589 * t2395;
  t8681 = t1578 * t2384;
  t8683 = t1578 * t2401;
  t8685 = t1589 * t2375;
  t8687 = t1589 * t2379;
  t8689 = t1589 * t2384;
  t8691 = t1578 * t2387;
  t8693 = t1578 * t2420;
  t8695 = t1589 * t2424;
  t8696 = t8695 / 0.32e2;
  t8697 = t1578 * t2428;
  t8698 = t8697 / 0.64e2;
  t8699 = t1589 * t2370;
  t8701 = t1589 * t2412;
  t8703 = -0.3e1 / 0.32e2 * t8675 - t8678 - t8679 / 0.32e2 - 0.3e1 / 0.64e2 * t8681 + 0.3e1 / 0.64e2 * t8683 + 0.3e1 / 0.32e2 * t8685 + t8687 / 0.16e2 - 0.3e1 / 0.32e2 * t8689 - t8691 / 0.32e2 + 0.3e1 / 0.64e2 * t8693 + t8696 - t8698 - t8699 / 0.16e2 + t8701 / 0.16e2;
  t8704 = t1589 * t2416;
  t8706 = t1589 * t2405;
  t8707 = t8706 / 0.32e2;
  t8708 = t1589 * t2408;
  t8721 = t1585 * t2405 / 0.16e2;
  t8723 = t1585 * t2391 / 0.16e2;
  t8731 = t1574 * t2428 / 0.32e2;
  t8734 = -t8704 / 0.16e2 + t8707 + t8708 / 0.8e1 + t1585 * t2408 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2367 - t1585 * t2395 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t2384 + 0.3e1 / 0.32e2 * t1574 * t2401 + t8721 - t8723 + t1585 * t2379 / 0.8e1 - 0.3e1 / 0.16e2 * t1585 * t2384 - t1574 * t2387 / 0.16e2 - t8731 - t1585 * t2370 / 0.8e1;
  t8745 = t1585 * t2424 / 0.16e2;
  t8756 = t1227 * t719;
  t8757 = t8756 / 0.32e2;
  t8758 = t1227 * t726;
  t8760 = t1227 * t729;
  t8762 = t1227 * t714;
  t8764 = 0.3e1 / 0.16e2 * t1585 * t2375 + t1585 * t2412 / 0.8e1 - t1585 * t2416 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t2420 + t8745 - t1224 * t723 / 0.16e2 + t1224 * t726 / 0.16e2 + t1224 * t729 / 0.16e2 - t1224 * t714 / 0.32e2 - t367 * t2440 / 0.32e2 - t8757 + t8758 / 0.32e2 + t8760 / 0.32e2 - t8762 / 0.64e2;
  t8765 = t370 * t2440;
  t8767 = t1227 * t723;
  t8770 = t1224 * t719 / 0.16e2;
  t8773 = t8562 / 0.32e2;
  t8776 = -t8765 / 0.64e2 - t8767 / 0.32e2 - t8770 - t8577 + t8580 / 0.32e2 - t8583 - t8556 / 0.64e2 + t8559 - t8773 + t8565 - t8568 / 0.32e2 + t8571 + t8574 / 0.32e2 - t2334 - t2336;
  t8779 = my_piecewise3(t51, 0, t8703 + t8734 + t8764 + t8776);
  tv4rho2sigma211 = t3 * t8779 + t2350 + t2447;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t8786 = t1196 * t697 / 0.16e2;
  t8787 = t8649 / 0.16e2;
  t8797 = -t1196 * t692 / 0.32e2 - t8647 / 0.32e2 + t8519 - t8786 - t8787 + t8526 - t1196 * t701 / 0.16e2 - t8643 / 0.16e2 + t8512 + t1196 * t704 / 0.16e2 + t8645 / 0.16e2 - t8533 + t1196 * t707 / 0.16e2 + t8641 / 0.16e2 - t8528;
  t8798 = my_piecewise3(t2, 0, t8797);
  tv4rho2sigma212 = t3 * t8798 + 0.2e1 * t2363;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t8805 = t1336 * t528 * t168;
  t8806 = t2572 * t8805;
  t8815 = t1628 * t528;
  t8821 = t2567 * t528;
  t8831 = t712 * t416;
  t8835 = t717 * t416;
  t8838 = 0.3e1 / 0.16e2 * t534 * t8835 * t1369;
  t8839 = t6257 * t416;
  t8843 = t6233 * t416;
  t8844 = t2382 * t8843;
  t8849 = 0.3e1 / 0.4e1 * t534 * t6169 * t6369 - 0.3e1 / 0.4e1 * t534 * t8806 + t534 * t539 * t1350 * t8805 - 0.3e1 / 0.4e1 * t534 * t6165 * t8805 - t534 * t6169 * t8815 / 0.4e1 - 0.3e1 / 0.8e1 * t519 * t8806 + 0.3e1 / 0.8e1 * t519 * t6189 * t8821 + 0.3e1 / 0.8e1 * t519 * t6181 * t8821 - t534 * t6177 * t8805 / 0.2e1 - 0.11e2 / 0.16e2 * t534 * t8831 * t5389 + t8838 - 0.25e2 / 0.16e2 * t534 * t2365 * t8839 + 0.11e2 / 0.16e2 * t534 * t8844 + 0.9e1 / 0.16e2 * t519 * t8844;
  t8850 = t6239 * t416;
  t8854 = t2404 * t1629;
  t8856 = 0.3e1 / 0.16e2 * t534 * t8854;
  t8858 = 0.3e1 / 0.32e2 * t519 * t8854;
  t8859 = t1641 * t717;
  t8862 = 0.3e1 / 0.32e2 * t519 * t1640 * t8859;
  t8863 = t2382 * t8850;
  t8866 = t6247 * t416;
  t8867 = t2365 * t8866;
  t8875 = t534 * t8835 * t1337 / 0.16e2;
  t8888 = t1667 * t2405 / 0.8e1;
  t8889 = t712 * t5342;
  t8890 = t6227 * t416;
  t8894 = -0.9e1 / 0.16e2 * t519 * t2365 * t8850 - t8856 - t8858 + t8862 - 0.3e1 / 0.2e1 * t534 * t8863 + 0.9e1 / 0.8e1 * t534 * t8867 + 0.3e1 / 0.8e1 * t534 * t8831 * t5411 - t8875 - t534 * t8831 * t5235 / 0.16e2 + t1667 * t2408 / 0.2e1 - 0.3e1 / 0.8e1 * t1667 * t2367 - 0.5e1 / 0.32e2 * t1674 * t2384 + 0.5e1 / 0.32e2 * t1674 * t2401 + t8888 + 0.15e2 / 0.16e2 * t534 * t8889 * t8890;
  t8898 = t534 * t8835 * t1357 / 0.4e1;
  t8907 = t717 * t1348;
  t8910 = 0.3e1 / 0.16e2 * t534 * t8907 * t1651;
  t8914 = t1667 * t2391 / 0.8e1;
  t8915 = t6299 * t416;
  t8921 = t534 * t2423 * t1634 / 0.8e1;
  t8923 = t1670 * t2428 / 0.16e2;
  t8924 = t546 * t1701;
  t8931 = t6307 * t712;
  t8940 = t8898 + 0.11e2 / 0.16e2 * t534 * t8831 * t5254 + 0.11e2 / 0.16e2 * t519 * t8867 - 0.15e2 / 0.32e2 * t519 * t8889 * t8839 - t8910 - t1667 * t2395 / 0.8e1 - t8914 + 0.3e1 / 0.8e1 * t534 * t2373 * t8915 - t8921 - t8923 + t534 * t545 * t8924 / 0.8e1 - t534 * t2373 * t5216 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t1619 * t8931 + 0.3e1 / 0.32e2 * t519 * t2382 * t5164 + 0.3e1 / 0.16e2 * t1670 * t2401;
  t8963 = t1628 * t438;
  t8964 = t2382 * t8963;
  t8972 = t534 * t2404 * t1663 / 0.16e2;
  t8976 = t1667 * t2412 / 0.4e1 - t1667 * t2416 / 0.4e1 + 0.3e1 / 0.16e2 * t1670 * t2420 - t1670 * t2387 / 0.8e1 - t1674 * t2387 / 0.8e1 + 0.5e1 / 0.32e2 * t1674 * t2420 - t1667 * t2370 / 0.4e1 + 0.3e1 / 0.8e1 * t1667 * t2375 - 0.3e1 / 0.16e2 * t1670 * t2384 + t1667 * t2379 / 0.4e1 - 0.3e1 / 0.8e1 * t1667 * t2384 - 0.3e1 / 0.32e2 * t519 * t8964 + 0.3e1 / 0.32e2 * t519 * t2365 * t5194 + t8972 + t534 * t2382 * t5194 / 0.4e1;
  t8982 = t534 * t717 * t438 * t445 / 0.16e2;
  t8992 = t540 * t1701;
  t9003 = t534 * t2423 * t1710 / 0.16e2;
  t9004 = t1620 * t717;
  t9007 = 0.3e1 / 0.32e2 * t519 * t1619 * t9004;
  t9009 = t1674 * t2428 / 0.32e2;
  t9012 = t519 * t1386 * t2427 / 0.32e2;
  t9017 = t1667 * t2424 / 0.8e1;
  t9018 = t1650 * t438;
  t9023 = -t8982 - t534 * t712 * t438 * t1337 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t8863 + 0.3e1 / 0.16e2 * t534 * t2373 * t5164 + t534 * t539 * t8992 / 0.8e1 - 0.3e1 / 0.16e2 * t534 * t8964 - t519 * t539 * t6396 / 0.16e2 + t9003 + t9007 - t9009 - t9012 - t534 * t545 * t6396 / 0.8e1 + t9017 - 0.3e1 / 0.16e2 * t534 * t2365 * t9018 - 0.3e1 / 0.16e2 * t8675;
  t9024 = t8677 / 0.16e2;
  t9033 = t8695 / 0.16e2;
  t9034 = t8697 / 0.32e2;
  t9038 = t8706 / 0.16e2;
  t9039 = -t9024 - t8679 / 0.16e2 - 0.3e1 / 0.32e2 * t8681 + 0.3e1 / 0.32e2 * t8683 + 0.3e1 / 0.16e2 * t8685 + t8687 / 0.8e1 - 0.3e1 / 0.16e2 * t8689 - t8691 / 0.16e2 + 0.3e1 / 0.32e2 * t8693 + t9033 - t9034 - t8699 / 0.8e1 + t8701 / 0.8e1 - t8704 / 0.8e1 + t9038;
  t9047 = t1323 * t719 / 0.16e2;
  t9054 = t528 * t528;
  t9055 = t157 * t9054;
  t9073 = t8756 / 0.16e2;
  t9076 = t8708 / 0.4e1 - t156 * t5302 * t712 * t424 / 0.32e2 - t9047 - t1323 * t723 / 0.16e2 + t1323 * t726 / 0.16e2 + t1323 * t729 / 0.16e2 + t156 * t9055 * t452 / 0.8e1 - t156 * t415 * t9054 * t424 / 0.16e2 - t156 * t9055 * t445 / 0.8e1 + t156 * t9055 * t456 / 0.8e1 - t1323 * t714 / 0.32e2 - t409 * t2440 / 0.16e2 - t9073 + t8758 / 0.16e2 + t8760 / 0.16e2;
  t9080 = t2392 / 0.8e1;
  t9081 = t2406 / 0.8e1;
  t9082 = t2425 / 0.8e1;
  t9083 = t2429 / 0.16e2;
  t9084 = t2443 / 0.8e1;
  t9085 = t2335 / 0.16e2;
  t9086 = -t8762 / 0.32e2 - t8765 / 0.32e2 - t8767 / 0.16e2 - t8577 - t8583 + t8559 + t8565 + t8571 - t9080 + t9081 + t9082 - t9083 - t9084 - t9085 - t721;
  t9090 = my_piecewise3(t51, 0, t8849 + t8894 + t8940 + t8976 + t9023 + t9039 + t9076 + t9086);
  tv4rho2sigma217 = t3 * t9090 + 0.2e1 * t2447;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t9093 = t4280 * t199;
  t9094 = t9093 * t261;
  t9095 = t8241 * t9094;
  t9101 = t2479 * t8333;
  t9104 = t4280 * t183;
  t9105 = t9104 * t261;
  t9106 = t2483 * t9105;
  t9111 = t5609 * t4344;
  t9129 = t6537 * t4277;
  t9133 = t737 * t261;
  t9141 = t1466 * t2476;
  t9143 = t1462 * t2480;
  t9147 = 0.9e1 / 0.16e2 * t469 * t9095 - 0.9e1 / 0.16e2 * t469 * t2475 * t9094 - 0.3e1 / 0.2e1 * t484 * t9101 + 0.9e1 / 0.8e1 * t484 * t9106 + 0.11e2 / 0.16e2 * t469 * t9106 - 0.15e2 / 0.32e2 * t469 * t9111 * t9094 - t1455 * t2450 / 0.8e1 - t484 * t2497 * t111 * t986 / 0.8e1 - t484 * t2501 * t111 * t986 / 0.8e1 - 0.25e2 / 0.16e2 * t484 * t737 * t997 * t8324 + 0.15e2 / 0.16e2 * t484 * t9129 * t9105 + 0.11e2 / 0.16e2 * t484 * t9133 * t4331 - 0.5e1 / 0.32e2 * t1470 * t2466 + 0.5e1 / 0.32e2 * t1470 * t2476 + 0.3e1 / 0.32e2 * t9141 + t9143 / 0.4e1 + t1455 * t2480 / 0.2e1;
  t9165 = t1462 * t2484;
  t9170 = t1466 * t2466;
  t9184 = t1462 * t2450;
  t9189 = t958 * t563;
  t9190 = t9189 * t183;
  t9191 = t5488 * t9190;
  t9198 = t2454 * t478;
  t9199 = t5488 * t9198;
  t9204 = t484 * t2497 * t263 * t2256 / 0.2e1 + t484 * t2501 * t263 * t2256 / 0.2e1 - 0.3e1 / 0.8e1 * t1455 * t2484 - 0.3e1 / 0.8e1 * t484 * t6541 * t1011 * t2465 - 0.3e1 / 0.8e1 * t484 * t2483 * t8235 - 0.3e1 / 0.16e2 * t9165 - t484 * t9133 * t4319 / 0.16e2 - 0.3e1 / 0.32e2 * t9170 - 0.11e2 / 0.32e2 * t469 * t2453 * t9094 - 0.11e2 / 0.16e2 * t484 * t2459 * t5733 * t261 + 0.11e2 / 0.16e2 * t484 * t9095 + 0.3e1 / 0.8e1 * t484 * t2469 * t9105 - t9184 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t9133 * t4414 - 0.3e1 / 0.16e2 * t469 * t9191 + 0.3e1 / 0.8e1 * t484 * t2501 * t43 * t2239 - 0.3e1 / 0.16e2 * t469 * t9199 - 0.3e1 / 0.8e1 * t1455 * t2466;
  t9226 = t2463 * t5484;
  t9235 = t1466 * t2456;
  t9240 = t1462 * t2460;
  t9248 = 0.3e1 / 0.16e2 * t1458 * t2476 - 0.3e1 / 0.8e1 * t484 * t9191 + 0.3e1 / 0.16e2 * t469 * t5509 * t9190 - 0.3e1 / 0.8e1 * t484 * t9199 + 0.3e1 / 0.16e2 * t469 * t5509 * t9198 + 0.3e1 / 0.8e1 * t1455 * t2460 - 0.3e1 / 0.16e2 * t1458 * t2466 + 0.3e1 / 0.8e1 * t484 * t2497 * t43 * t2239 - 0.3e1 / 0.16e2 * t484 * t9226 - t484 * t737 * t283 * t986 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t9101 + 0.3e1 / 0.32e2 * t9235 + 0.3e1 / 0.32e2 * t469 * t2453 * t6473 + 0.3e1 / 0.16e2 * t9240 + 0.5e1 / 0.32e2 * t1470 * t2456 - t1455 * t2470 / 0.4e1 + 0.3e1 / 0.16e2 * t1458 * t2456;
  t9273 = t1462 * t2470;
  t9281 = t1462 * t2466;
  t9297 = -t484 * t1752 * t113 * t2465 / 0.4e1 + 0.3e1 / 0.16e2 * t469 * t5483 * t9190 - t484 * t2469 * t8235 / 0.4e1 + 0.3e1 / 0.16e2 * t469 * t5483 * t9198 - 0.3e1 / 0.16e2 * t484 * t2483 * t5484 - 0.3e1 / 0.32e2 * t469 * t9226 + 0.3e1 / 0.32e2 * t469 * t2475 * t6473 + t484 * t2479 * t4227 / 0.4e1 - t9273 / 0.8e1 - t484 * t2469 * t5484 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t2459 * t4267 - 0.3e1 / 0.16e2 * t9281 - t1455 * t2502 / 0.8e1 + t5531 * t746 / 0.16e2 + t1455 * t2516 / 0.8e1 + t1455 * t2519 / 0.8e1 + t484 * t6649 * t745 / 0.16e2 + t484 * t1752 * t2278 / 0.8e1;
  t9328 = t1462 * t2511;
  t9330 = t5580 * t746;
  t9332 = t5580 * t738;
  t9334 = t1462 * t2498;
  t9336 = t1462 * t2502;
  t9338 = t5580 * t742;
  t9343 = -t484 * t1808 * t183 * t290 / 0.16e2 - t484 * t563 * t478 * t290 / 0.8e1 - t484 * t199 * t1419 * t290 / 0.16e2 + t5531 * t742 / 0.16e2 + t1455 * t2508 / 0.8e1 + t1455 * t2511 / 0.8e1 + t484 * t6597 * t741 / 0.16e2 + t484 * t1775 * t2272 / 0.8e1 - t5531 * t738 / 0.16e2 - t1455 * t2498 / 0.8e1 + t9328 / 0.16e2 + t9330 / 0.16e2 - t9332 / 0.16e2 - t9334 / 0.16e2 - t9336 / 0.16e2 + t9338 / 0.16e2 - t469 * t489 * t6642 / 0.32e2;
  t9371 = t5567 * t746 / 0.64e2;
  t9373 = t5567 * t742 / 0.64e2;
  t9375 = t5758 * t734 / 0.128e3;
  t9377 = t5567 * t738 / 0.64e2;
  t9378 = t1466 * t2526;
  t9380 = t1466 * t2529;
  t9382 = t1462 * t2516;
  t9384 = t484 * t576 * t8396 / 0.16e2 - t5667 * t734 / 0.32e2 - t5776 * t734 / 0.16e2 - t1458 * t2526 / 0.16e2 - t1458 * t2529 / 0.16e2 - t5768 * t734 / 0.32e2 - t1470 * t2526 / 0.16e2 - t1470 * t2529 / 0.16e2 - t469 * t5707 * t558 / 0.32e2 - t469 * t1507 * t1748 / 0.16e2 + t484 * t572 * t8370 / 0.16e2 - t9371 - t9373 + t9375 + t9377 - t9378 / 0.32e2 - t9380 / 0.32e2 + t9382 / 0.16e2;
  t9386 = t1462 * t2519;
  t9388 = t5773 * t734;
  t9390 = t5762 * t734;
  t9392 = t1462 * t2508;
  t9394 = t9386 / 0.16e2 - t9388 / 0.32e2 - t9390 / 0.32e2 + t9392 / 0.16e2 - t8258 + t8271 + t8275 - t8281 + t8286 - t8305 - t8307 + t8313 + t8316 - t8323 - t8342 + t8357 - t8359 - t8376;
  t9395 = -t8422 + t8431 + t8435 - t8437 - t8441 + t8453 - t8455 + t8468 - t8502 - t8506 + t8526 - t8541 + t8542 + t8543 - t8544 - t8545 - t8546 - t699;
  t9399 = my_piecewise3(t2, 0, t9147 + t9204 + t9248 + t9297 + t9343 + t9384 + t9394 + t9395);
  tv4rho2sigmalapl0 = t3 * t9399 + 0.2e1 * t2534;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t9404 = t5956 * t751;
  t9407 = t5960 * t751 / 0.128e3;
  t9410 = t5945 * t755;
  t9413 = t5949 * t755 / 0.64e2;
  t9416 = t5945 * t759;
  t9419 = t5949 * t759 / 0.64e2;
  t9422 = t5945 * t763;
  t9425 = t5949 * t763 / 0.64e2;
  t9426 = -t5973 * t751 / 0.32e2 - t9404 / 0.32e2 + t9407 - t8561 - t8563 + t8565 - t5967 * t755 / 0.16e2 - t9410 / 0.16e2 + t9413 + t5967 * t759 / 0.16e2 + t9416 / 0.16e2 - t9419 + t5967 * t763 / 0.16e2 + t9422 / 0.16e2 - t9425;
  t9427 = my_piecewise3(t51, 0, t9426);
  tv4rho2sigmalapl5 = t3 * t9427 + 0.2e1 * t2553;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t9454 = -t1553 * t2450 / 0.16e2 + t1553 * t2480 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t2484 - 0.3e1 / 0.32e2 * t1548 * t2466 + 0.3e1 / 0.32e2 * t1548 * t2476 - t1553 * t2470 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t2460 - 0.3e1 / 0.16e2 * t1553 * t2466 + 0.3e1 / 0.32e2 * t1548 * t2456 + 0.3e1 / 0.64e2 * t9141 + t9143 / 0.8e1 - 0.3e1 / 0.32e2 * t9165 - 0.3e1 / 0.64e2 * t9170 - t9184 / 0.32e2 + 0.3e1 / 0.64e2 * t9235 + 0.3e1 / 0.32e2 * t9240;
  t9483 = t5838 * t746;
  t9485 = t5838 * t738;
  t9487 = -t9273 / 0.16e2 - 0.3e1 / 0.32e2 * t9281 + t5835 * t742 / 0.16e2 + t1553 * t2508 / 0.16e2 + t1553 * t2511 / 0.16e2 + t5835 * t746 / 0.16e2 + t1553 * t2516 / 0.16e2 + t1553 * t2519 / 0.16e2 - t5835 * t738 / 0.16e2 - t1553 * t2498 / 0.16e2 - t1553 * t2502 / 0.16e2 - t5874 * t734 / 0.32e2 - t5888 * t734 / 0.32e2 - t1548 * t2526 / 0.32e2 - t1548 * t2529 / 0.32e2 + t9483 / 0.32e2 - t9485 / 0.32e2;
  t9489 = t5838 * t742;
  t9491 = t5879 * t734;
  t9503 = t9489 / 0.32e2 - t9491 / 0.64e2 + t9328 / 0.32e2 + t9330 / 0.32e2 - t9332 / 0.32e2 - t9334 / 0.32e2 - t9336 / 0.32e2 + t9338 / 0.32e2 - t9371 - t9373 + t9375 + t9377 - t9378 / 0.64e2 - t9380 / 0.64e2 + t9382 / 0.32e2 + t9386 / 0.32e2;
  t9507 = -t9388 / 0.64e2 - t9390 / 0.64e2 + t9392 / 0.32e2 + t8592 - t8598 + t8619 - t8621 + t8624 - t8627 + t8639 - t8640 - t8650 - t8661 - t8668 + t8526 - t2355 - t2316;
  t9510 = my_piecewise3(t2, 0, t9454 + t9487 + t9503 + t9507);
  tv4rho2sigmalapl6 = t3 * t9510 + t2534 + t2564;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t9512 = t1578 * t2575;
  t9514 = t1578 * t2579;
  t9516 = t1589 * t2583;
  t9518 = t1589 * t2575;
  t9520 = t1589 * t2601;
  t9522 = t1589 * t2569;
  t9524 = t1589 * t2587;
  t9526 = t1578 * t2591;
  t9528 = t1589 * t2595;
  t9544 = -0.3e1 / 0.64e2 * t9512 + 0.3e1 / 0.64e2 * t9514 + t9516 / 0.8e1 - 0.3e1 / 0.32e2 * t9518 - t9520 / 0.16e2 - 0.3e1 / 0.32e2 * t9522 - t9524 / 0.32e2 + 0.3e1 / 0.64e2 * t9526 + 0.3e1 / 0.32e2 * t9528 + t1585 * t2583 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2569 - 0.3e1 / 0.32e2 * t1574 * t2575 + 0.3e1 / 0.32e2 * t1574 * t2579 - t1585 * t2601 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t2591 + 0.3e1 / 0.16e2 * t1585 * t2595;
  t9553 = t1589 * t2626;
  t9555 = t6048 * t763;
  t9557 = t1589 * t2631;
  t9559 = t1589 * t2634;
  t9561 = t6070 * t751;
  t9563 = t6048 * t755;
  t9565 = t1589 * t2613;
  t9567 = t1589 * t2617;
  t9569 = t6048 * t759;
  t9571 = t1589 * t2622;
  t9573 = t6025 * t751;
  t9575 = t1578 * t2604;
  t9577 = t1578 * t2607;
  t9579 = -0.3e1 / 0.16e2 * t1585 * t2575 - t1585 * t2587 / 0.16e2 - t6085 * t755 / 0.16e2 - t1585 * t2613 / 0.16e2 + t9553 / 0.32e2 + t9555 / 0.32e2 + t9557 / 0.32e2 + t9559 / 0.32e2 - t9561 / 0.64e2 - t9563 / 0.32e2 - t9565 / 0.32e2 - t9567 / 0.32e2 + t9569 / 0.32e2 + t9571 / 0.32e2 - t9573 / 0.64e2 - t9575 / 0.64e2 - t9577 / 0.64e2;
  t9606 = -t6107 * t751 / 0.32e2 - t6092 * t751 / 0.32e2 - t1574 * t2604 / 0.32e2 - t1574 * t2607 / 0.32e2 + t6085 * t763 / 0.16e2 + t1585 * t2631 / 0.16e2 + t1585 * t2634 / 0.16e2 - t1585 * t2617 / 0.16e2 + t6085 * t759 / 0.16e2 + t1585 * t2622 / 0.16e2 + t1585 * t2626 / 0.16e2 - t9410 / 0.32e2 + t9413 + t9416 / 0.32e2 - t9419 + t9422 / 0.32e2;
  t9608 = -t9425 - t9404 / 0.64e2 + t9407 - t8678 + t8696 - t8698 + t8707 + t8721 - t8723 - t8731 + t8745 - t8757 - t8770 - t8773 + t8565 - t2334 - t2336;
  t9611 = my_piecewise3(t51, 0, t9544 + t9579 + t9606 + t9608);
  tv4rho2sigmalapl11 = t3 * t9611 + t2553 + t2643;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t9626 = -t6000 * t734 / 0.32e2 - t9491 / 0.32e2 + t9375 - t8786 - t8787 + t8526 - t6005 * t738 / 0.16e2 - t9485 / 0.16e2 + t9377 + t6005 * t742 / 0.16e2 + t9489 / 0.16e2 - t9373 + t6005 * t746 / 0.16e2 + t9483 / 0.16e2 - t9371;
  t9627 = my_piecewise3(t2, 0, t9626);
  tv4rho2sigmalapl12 = t3 * t9627 + 0.2e1 * t2564;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t9640 = t754 * t416;
  t9644 = t5234 * t207;
  t9645 = t9644 * t416;
  t9646 = t2572 * t9645;
  t9652 = t2582 * t8850;
  t9655 = t5234 * t191;
  t9656 = t9655 * t416;
  t9657 = t2566 * t9656;
  t9660 = t1901 * t5344;
  t9664 = t7191 * t5356;
  t9689 = -t1667 * t2587 / 0.8e1 - t534 * t2612 * t168 * t1337 / 0.8e1 - t534 * t2616 * t168 * t1337 / 0.8e1 + 0.11e2 / 0.16e2 * t534 * t9640 * t5254 + 0.9e1 / 0.16e2 * t519 * t9646 - 0.9e1 / 0.16e2 * t519 * t2578 * t9645 - 0.3e1 / 0.2e1 * t534 * t9652 + 0.9e1 / 0.8e1 * t534 * t9657 - 0.25e2 / 0.16e2 * t534 * t9660 * t9656 + 0.15e2 / 0.16e2 * t534 * t9664 * t9656 + 0.11e2 / 0.16e2 * t519 * t9657 - t534 * t9640 * t5235 / 0.16e2 + t1667 * t2583 / 0.2e1 + t534 * t2612 * t418 * t2400 / 0.2e1 + t534 * t2616 * t418 * t2400 / 0.2e1 - 0.3e1 / 0.8e1 * t1667 * t2569 - 0.3e1 / 0.8e1 * t534 * t7117 * t1362 * t2568;
  t9697 = t6307 * t416;
  t9714 = t1917 * t450;
  t9715 = t9714 * t2568;
  t9718 = t1336 * t602;
  t9719 = t9718 * t191;
  t9723 = t3109 * t8805;
  t9737 = t416 * t5342 * t5344;
  t9738 = t9644 * t191;
  t9742 = t2572 * t7090;
  t9745 = -0.3e1 / 0.8e1 * t534 * t2566 * t8805 - 0.5e1 / 0.32e2 * t1674 * t2575 + 0.5e1 / 0.32e2 * t1674 * t2579 - 0.11e2 / 0.16e2 * t534 * t2594 * t9697 + 0.11e2 / 0.16e2 * t534 * t9646 + 0.3e1 / 0.8e1 * t534 * t2600 * t9656 + 0.3e1 / 0.8e1 * t534 * t9640 * t5411 - 0.11e2 / 0.32e2 * t519 * t2590 * t9645 + 0.3e1 / 0.16e2 * t1670 * t2579 - 0.3e1 / 0.8e1 * t534 * t9715 + 0.3e1 / 0.16e2 * t519 * t6189 * t9719 - 0.3e1 / 0.8e1 * t534 * t9723 + 0.3e1 / 0.8e1 * t1667 * t2595 - 0.3e1 / 0.16e2 * t1670 * t2575 + 0.3e1 / 0.8e1 * t534 * t2612 * t75 * t2374 - 0.3e1 / 0.16e2 * t519 * t9715 - 0.15e2 / 0.32e2 * t519 * t9737 * t9738 - 0.3e1 / 0.32e2 * t519 * t9742;
  t9769 = t2573 * t528;
  t9796 = 0.3e1 / 0.32e2 * t519 * t2578 * t7090 + 0.3e1 / 0.16e2 * t534 * t2594 * t5164 - 0.3e1 / 0.16e2 * t534 * t9742 - t534 * t2600 * t6182 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t9652 + 0.3e1 / 0.32e2 * t519 * t2590 * t7090 - t534 * t754 * t438 * t1337 / 0.16e2 + 0.5e1 / 0.32e2 * t1674 * t2591 + 0.3e1 / 0.16e2 * t519 * t6189 * t9769 - t1667 * t2601 / 0.4e1 + 0.3e1 / 0.16e2 * t1670 * t2591 - t534 * t1951 * t170 * t2568 / 0.4e1 + 0.3e1 / 0.16e2 * t519 * t6181 * t9719 - t534 * t2600 * t8805 / 0.4e1 + 0.3e1 / 0.16e2 * t519 * t6181 * t9769 + 0.3e1 / 0.8e1 * t534 * t2616 * t75 * t2374 - 0.3e1 / 0.16e2 * t519 * t9723;
  t9830 = -0.3e1 / 0.8e1 * t1667 * t2575 + t534 * t2582 * t5194 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2566 * t6182 - 0.3e1 / 0.32e2 * t9512 + 0.3e1 / 0.32e2 * t9514 + t9516 / 0.4e1 - 0.3e1 / 0.16e2 * t9518 - t9520 / 0.8e1 - 0.3e1 / 0.16e2 * t9522 - t9524 / 0.16e2 + 0.3e1 / 0.32e2 * t9526 + 0.3e1 / 0.16e2 * t9528 - t1667 * t2613 / 0.8e1 - t1667 * t2617 / 0.8e1 - t534 * t1966 * t191 * t445 / 0.16e2 - t534 * t602 * t528 * t445 / 0.8e1 + t1667 * t2631 / 0.8e1 + t1667 * t2634 / 0.8e1;
  t9875 = t534 * t7251 * t762 / 0.16e2 + t534 * t1951 * t2411 / 0.8e1 + t534 * t615 * t8924 / 0.16e2 - t6337 * t751 / 0.32e2 - t6343 * t751 / 0.16e2 - t1670 * t2604 / 0.16e2 - t534 * t207 * t1701 * t445 / 0.16e2 + t6287 * t759 / 0.16e2 + t1667 * t2622 / 0.8e1 + t1667 * t2626 / 0.8e1 + t534 * t7178 * t758 / 0.16e2 + t534 * t1917 * t2378 / 0.8e1 + t534 * t611 * t8992 / 0.16e2 - t6287 * t755 / 0.16e2 - t1670 * t2607 / 0.16e2 - t6351 * t751 / 0.32e2 - t1674 * t2604 / 0.16e2;
  t9902 = -t1674 * t2607 / 0.16e2 - t519 * t6270 * t597 / 0.32e2 - t519 * t1611 * t1947 / 0.16e2 - t519 * t539 * t7245 / 0.32e2 + t6287 * t763 / 0.16e2 + t9553 / 0.16e2 + t9555 / 0.16e2 + t9557 / 0.16e2 + t9559 / 0.16e2 - t9561 / 0.32e2 - t9563 / 0.16e2 - t9565 / 0.16e2 - t9567 / 0.16e2 + t9569 / 0.16e2 + t9571 / 0.16e2 - t9573 / 0.32e2 - t9575 / 0.32e2 - t9577 / 0.32e2;
  t9904 = t9413 - t9419 - t9425 + t9407 + t8838 - t8856 - t8858 + t8862 - t8875 + t8888 + t8898 - t8910 - t8914 - t8921 - t8923 + t8972 - t8982 + t9003;
  t9905 = t9007 - t9009 - t9012 + t9017 - t9024 + t9033 - t9034 + t9038 - t9047 - t9073 + t8565 - t9080 + t9081 + t9082 - t9083 - t9084 - t9085 - t721;
  t9909 = my_piecewise3(t51, 0, t9689 + t9745 + t9796 + t9830 + t9875 + t9902 + t9904 + t9905);
  tv4rho2sigmalapl17 = t3 * t9909 + 0.2e1 * t2643;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t9912 = t7591 * t4277;
  t9916 = t771 * t261;
  t9920 = t2666 * t9105;
  t9925 = t4280 * t213;
  t9926 = t9925 * t261;
  t9930 = t2675 * t8333;
  t9933 = t2645 * t9105;
  t9949 = t2021 * t999;
  t9953 = t7603 * t1011;
  t9964 = 0.15e2 / 0.16e2 * t484 * t9912 * t9105 + 0.11e2 / 0.16e2 * t484 * t9916 * t4331 + 0.11e2 / 0.16e2 * t484 * t9920 + 0.9e1 / 0.16e2 * t469 * t9920 - 0.9e1 / 0.16e2 * t469 * t2475 * t9926 - 0.3e1 / 0.2e1 * t484 * t9930 + 0.9e1 / 0.8e1 * t484 * t9933 + 0.11e2 / 0.16e2 * t469 * t9933 - 0.15e2 / 0.32e2 * t469 * t9111 * t9926 - 0.25e2 / 0.16e2 * t484 * t771 * t997 * t8324 + t1455 * t2676 / 0.2e1 - 0.3e1 / 0.8e1 * t1455 * t2646 + t484 * t9949 * t2465 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t9953 * t2465 - 0.3e1 / 0.8e1 * t484 * t2645 * t8235 - 0.3e1 / 0.16e2 * t1458 * t2667 - 0.5e1 / 0.32e2 * t1470 * t2667;
  t9967 = t1466 * t2672;
  t9969 = t1462 * t2676;
  t9971 = t1462 * t2646;
  t9973 = t958 * t631;
  t9974 = t9973 * t111;
  t9975 = t8241 * t9974;
  t9981 = t1462 * t2667;
  t9983 = t1988 * t43;
  t9987 = t1466 * t2667;
  t9997 = t2657 * t478;
  t9998 = t5488 * t9997;
  t10001 = t1462 * t2650;
  t10016 = 0.5e1 / 0.32e2 * t1470 * t2672 + 0.3e1 / 0.32e2 * t9967 + t9969 / 0.4e1 - 0.3e1 / 0.16e2 * t9971 - 0.3e1 / 0.16e2 * t469 * t9975 - t484 * t9916 * t4319 / 0.16e2 - 0.3e1 / 0.16e2 * t9981 - 0.11e2 / 0.16e2 * t484 * t9983 * t5734 - 0.3e1 / 0.32e2 * t9987 + t484 * t2704 * t263 * t2256 / 0.2e1 + 0.3e1 / 0.8e1 * t484 * t2704 * t43 * t2239 - 0.3e1 / 0.16e2 * t469 * t9998 - t10001 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t9916 * t4414 + 0.3e1 / 0.8e1 * t484 * t2653 * t9105 - t1455 * t2650 / 0.8e1 - 0.3e1 / 0.8e1 * t484 * t9998 + 0.3e1 / 0.16e2 * t469 * t5509 * t9997;
  t10022 = t1462 * t2663;
  t10038 = t2041 * t113;
  t10042 = t9973 * t183;
  t10064 = t2666 * t5484;
  t10067 = -t484 * t2691 * t111 * t986 / 0.8e1 + 0.3e1 / 0.16e2 * t10022 - t484 * t2704 * t111 * t986 / 0.8e1 + 0.3e1 / 0.8e1 * t1455 * t2663 + 0.3e1 / 0.8e1 * t484 * t2013 * t43 * t1523 - t1455 * t2654 / 0.4e1 + 0.3e1 / 0.16e2 * t1458 * t2659 - t484 * t10038 * t2465 / 0.4e1 + 0.3e1 / 0.16e2 * t469 * t5483 * t10042 - t484 * t2653 * t8235 / 0.4e1 + 0.3e1 / 0.16e2 * t469 * t5483 * t9997 - 0.3e1 / 0.8e1 * t1455 * t2667 + 0.3e1 / 0.16e2 * t1458 * t2672 - 0.3e1 / 0.8e1 * t484 * t9975 + 0.3e1 / 0.16e2 * t469 * t5509 * t10042 - 0.3e1 / 0.16e2 * t484 * t2645 * t5484 - 0.3e1 / 0.16e2 * t484 * t10064;
  t10076 = t1466 * t2659;
  t10081 = t1521 * t265;
  t10082 = t9925 * t183;
  t10095 = t1462 * t2654;
  t10117 = -0.3e1 / 0.32e2 * t469 * t10064 + 0.3e1 / 0.32e2 * t469 * t2475 * t7361 + 0.3e1 / 0.16e2 * t484 * t2662 * t4267 + 0.3e1 / 0.32e2 * t10076 - t484 * t2653 * t5484 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t10081 * t10082 + 0.3e1 / 0.32e2 * t469 * t2453 * t7361 - t484 * t771 * t283 * t986 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t9930 - t10095 / 0.8e1 + 0.5e1 / 0.32e2 * t1470 * t2659 + t484 * t2675 * t4227 / 0.4e1 - t469 * t489 * t7521 / 0.32e2 + t5531 * t778 / 0.16e2 + t1455 * t2718 / 0.8e1 + t1455 * t2721 / 0.8e1 + t484 * t7469 * t745 / 0.16e2 + t484 * t2041 * t2278 / 0.8e1;
  t10152 = t1462 * t2705;
  t10155 = t5567 * t778 / 0.64e2;
  t10156 = t1462 * t2692;
  t10158 = t5762 * t768;
  t10160 = t1466 * t2683;
  t10162 = t484 * t644 * t8396 / 0.16e2 - t5667 * t768 / 0.32e2 - t5776 * t768 / 0.16e2 - t1455 * t2705 / 0.8e1 - t484 * t631 * t478 * t290 / 0.8e1 - t484 * t213 * t1419 * t290 / 0.16e2 + t5531 * t775 / 0.16e2 + t1455 * t2710 / 0.8e1 + t1455 * t2713 / 0.8e1 + t484 * t7388 * t741 / 0.16e2 + t484 * t2021 * t2272 / 0.8e1 + t484 * t640 * t8370 / 0.16e2 - t10152 / 0.16e2 - t10155 - t10156 / 0.16e2 - t10158 / 0.32e2 - t10160 / 0.32e2;
  t10163 = t1466 * t2686;
  t10165 = t5580 * t772;
  t10167 = t5580 * t778;
  t10169 = t1462 * t2718;
  t10171 = t1462 * t2721;
  t10173 = t5773 * t768;
  t10175 = t5580 * t775;
  t10177 = t1462 * t2710;
  t10179 = t1462 * t2713;
  t10202 = -t10163 / 0.32e2 - t10165 / 0.16e2 + t10167 / 0.16e2 + t10169 / 0.16e2 + t10171 / 0.16e2 - t10173 / 0.32e2 + t10175 / 0.16e2 + t10177 / 0.16e2 + t10179 / 0.16e2 - t5531 * t772 / 0.16e2 - t1455 * t2692 / 0.8e1 - t484 * t2061 * t183 * t290 / 0.16e2 - t1458 * t2683 / 0.16e2 - t1458 * t2686 / 0.16e2 - t5768 * t768 / 0.32e2 - t1470 * t2683 / 0.16e2 - t1470 * t2686 / 0.16e2 - t469 * t5707 * t626 / 0.32e2;
  t10208 = t5567 * t772 / 0.64e2;
  t10210 = t5567 * t775 / 0.64e2;
  t10212 = t5758 * t768 / 0.128e3;
  t10213 = -t469 * t1507 * t2007 / 0.16e2 + t10208 - t10210 + t10212 - t8258 + t8271 + t8275 - t8281 + t8286 - t8305 - t8307 + t8313 + t8316 - t8323 - t8342 + t8357 - t8359 - t8376;
  t10217 = my_piecewise3(t2, 0, t9964 + t10016 + t10067 + t10117 + t10162 + t10202 + t10213 + t9395);
  tv4rho2sigmatau0 = t10217 * t3 + 0.2e1 * t2726;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t10222 = t5956 * t783;
  t10225 = t5960 * t783 / 0.128e3;
  t10228 = t5945 * t787;
  t10231 = t5949 * t787 / 0.64e2;
  t10234 = t5945 * t790;
  t10237 = t5949 * t790 / 0.64e2;
  t10240 = t5945 * t793;
  t10243 = t5949 * t793 / 0.64e2;
  t10244 = -t5973 * t783 / 0.32e2 - t10222 / 0.32e2 + t10225 - t8561 - t8563 + t8565 - t5967 * t787 / 0.16e2 - t10228 / 0.16e2 + t10231 + t5967 * t790 / 0.16e2 + t10234 / 0.16e2 - t10237 + t5967 * t793 / 0.16e2 + t10240 / 0.16e2 - t10243;
  t10245 = my_piecewise3(t51, 0, t10244);
  tv4rho2sigmatau5 = t10245 * t3 + 0.2e1 * t2745;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t10272 = -0.3e1 / 0.32e2 * t1548 * t2667 + 0.3e1 / 0.32e2 * t1548 * t2672 - t1553 * t2650 / 0.16e2 + t1553 * t2676 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t2646 - t1553 * t2654 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t2663 - 0.3e1 / 0.16e2 * t1553 * t2667 + 0.3e1 / 0.32e2 * t1548 * t2659 + 0.3e1 / 0.64e2 * t9967 + t9969 / 0.8e1 - 0.3e1 / 0.32e2 * t9971 - 0.3e1 / 0.32e2 * t9981 - 0.3e1 / 0.64e2 * t9987 - t10001 / 0.32e2 + 0.3e1 / 0.32e2 * t10022;
  t10275 = t5838 * t775;
  t10277 = t5879 * t768;
  t10279 = t5838 * t772;
  t10305 = 0.3e1 / 0.64e2 * t10076 - t10095 / 0.16e2 + t10275 / 0.32e2 - t10277 / 0.64e2 - t10279 / 0.32e2 + t5835 * t778 / 0.16e2 + t1553 * t2718 / 0.16e2 + t1553 * t2721 / 0.16e2 - t1553 * t2692 / 0.16e2 - t1553 * t2705 / 0.16e2 + t5835 * t775 / 0.16e2 + t1553 * t2710 / 0.16e2 + t1553 * t2713 / 0.16e2 - t5888 * t768 / 0.32e2 - t1548 * t2683 / 0.32e2 - t1548 * t2686 / 0.32e2 - t5835 * t772 / 0.16e2;
  t10309 = t5838 * t778;
  t10324 = -t5874 * t768 / 0.32e2 + t10309 / 0.32e2 - t10152 / 0.32e2 - t10155 - t10156 / 0.32e2 - t10158 / 0.64e2 - t10160 / 0.64e2 - t10163 / 0.64e2 - t10165 / 0.32e2 + t10167 / 0.32e2 + t10169 / 0.32e2 + t10171 / 0.32e2 - t10173 / 0.64e2 + t10175 / 0.32e2 + t10177 / 0.32e2 + t10179 / 0.32e2;
  t10325 = t10208 - t10210 + t10212 + t8592 - t8598 + t8619 - t8621 + t8624 - t8627 + t8639 - t8640 - t8650 - t8661 - t8668 + t8526 - t2355 - t2316;
  t10328 = my_piecewise3(t2, 0, t10272 + t10305 + t10324 + t10325);
  tv4rho2sigmatau6 = t10328 * t3 + t2726 + t2756;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t10334 = t1589 * t2779;
  t10336 = t1578 * t2782;
  t10338 = t1589 * t2786;
  t10340 = t1589 * t2764;
  t10356 = t1589 * t2771;
  t10358 = t1589 * t2775;
  t10360 = t1589 * t2759;
  t10362 = -0.3e1 / 0.16e2 * t1585 * t2764 - t1585 * t2779 / 0.8e1 - t10334 / 0.16e2 + 0.3e1 / 0.64e2 * t10336 + 0.3e1 / 0.32e2 * t10338 - 0.3e1 / 0.32e2 * t10340 + 0.3e1 / 0.32e2 * t1574 * t2782 + 0.3e1 / 0.16e2 * t1585 * t2786 - 0.3e1 / 0.32e2 * t1574 * t2764 + 0.3e1 / 0.32e2 * t1574 * t2767 + t1585 * t2771 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2759 - t1585 * t2775 / 0.16e2 + t10356 / 0.8e1 - t10358 / 0.32e2 - 0.3e1 / 0.32e2 * t10360;
  t10363 = t1578 * t2764;
  t10365 = t1578 * t2767;
  t10385 = t6070 * t783;
  t10387 = t6025 * t783;
  t10389 = t1578 * t2822;
  t10391 = t1578 * t2825;
  t10393 = t1589 * t2803;
  t10395 = t1589 * t2806;
  t10397 = -0.3e1 / 0.64e2 * t10363 + 0.3e1 / 0.64e2 * t10365 - t6092 * t783 / 0.32e2 + t1585 * t2803 / 0.16e2 + t1585 * t2806 / 0.16e2 + t6085 * t793 / 0.16e2 + t1585 * t2812 / 0.16e2 - t6085 * t787 / 0.16e2 - t1585 * t2794 / 0.16e2 - t1585 * t2798 / 0.16e2 + t6085 * t790 / 0.16e2 - t10385 / 0.64e2 - t10387 / 0.64e2 - t10389 / 0.64e2 - t10391 / 0.64e2 + t10393 / 0.32e2 + t10395 / 0.32e2;
  t10399 = t6048 * t793;
  t10401 = t1589 * t2812;
  t10403 = t1589 * t2815;
  t10405 = t6048 * t787;
  t10407 = t1589 * t2794;
  t10409 = t1589 * t2798;
  t10411 = t6048 * t790;
  t10423 = t10399 / 0.32e2 + t10401 / 0.32e2 + t10403 / 0.32e2 - t10405 / 0.32e2 - t10407 / 0.32e2 - t10409 / 0.32e2 + t10411 / 0.32e2 - t1574 * t2822 / 0.32e2 - t1574 * t2825 / 0.32e2 + t1585 * t2815 / 0.16e2 - t6107 * t783 / 0.32e2 - t10237 + t10240 / 0.32e2 - t10243 - t10222 / 0.64e2 + t10225;
  t10426 = -t10228 / 0.32e2 + t10231 + t10234 / 0.32e2 - t8678 + t8696 - t8698 + t8707 + t8721 - t8723 - t8731 + t8745 - t8757 - t8770 - t8773 + t8565 - t2334 - t2336;
  t10429 = my_piecewise3(t51, 0, t10362 + t10397 + t10423 + t10426);
  tv4rho2sigmatau11 = t10429 * t3 + t2745 + t2830;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t10444 = -t6000 * t768 / 0.32e2 - t10277 / 0.32e2 + t10212 - t8786 - t8787 + t8526 - t6005 * t772 / 0.16e2 - t10279 / 0.16e2 + t10208 + t6005 * t775 / 0.16e2 + t10275 / 0.16e2 - t10210 + t6005 * t778 / 0.16e2 + t10309 / 0.16e2 - t10155;
  t10445 = my_piecewise3(t2, 0, t10444);
  tv4rho2sigmatau12 = t10445 * t3 + 0.2e1 * t2756;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t10448 = t2572 * t7968;
  t10460 = t5234 * t219;
  t10461 = t10460 * t191;
  t10469 = t1619 * t1350;
  t10470 = t10469 * t10461;
  t10473 = t1336 * t670;
  t10474 = t10473 * t191;
  t10478 = t2762 * t528;
  t10482 = t7976 * t10474;
  t10485 = t7976 * t10478;
  t10500 = -0.3e1 / 0.32e2 * t519 * t10448 + 0.3e1 / 0.32e2 * t519 * t2578 * t7968 + t534 * t2770 * t5194 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2758 * t6182 - 0.15e2 / 0.32e2 * t519 * t9737 * t10461 - t534 * t786 * t438 * t1337 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t10470 + 0.3e1 / 0.16e2 * t519 * t6189 * t10474 + 0.3e1 / 0.16e2 * t519 * t6189 * t10478 - 0.3e1 / 0.16e2 * t519 * t10482 - 0.3e1 / 0.16e2 * t519 * t10485 + 0.3e1 / 0.16e2 * t1670 * t2767 - 0.3e1 / 0.8e1 * t1667 * t2764 - 0.3e1 / 0.8e1 * t534 * t10482 - 0.3e1 / 0.8e1 * t534 * t10485 - 0.3e1 / 0.16e2 * t534 * t10448 - 0.3e1 / 0.16e2 * t1670 * t2764;
  t10529 = -t1667 * t2779 / 0.4e1 - t10334 / 0.8e1 + 0.3e1 / 0.32e2 * t10336 + 0.3e1 / 0.16e2 * t10338 - 0.3e1 / 0.16e2 * t10340 + t10356 / 0.4e1 - t10358 / 0.16e2 - 0.3e1 / 0.16e2 * t10360 - 0.3e1 / 0.32e2 * t10363 + 0.3e1 / 0.32e2 * t10365 + t534 * t2153 * t2378 / 0.8e1 - t6287 * t787 / 0.16e2 - t1667 * t2794 / 0.8e1 - t1667 * t2798 / 0.8e1 - t6343 * t783 / 0.16e2 - t1670 * t2822 / 0.16e2 - t1670 * t2825 / 0.16e2 - t6351 * t783 / 0.32e2;
  t10577 = -t1674 * t2822 / 0.16e2 - t1674 * t2825 / 0.16e2 - t519 * t6270 * t665 / 0.32e2 - t519 * t1611 * t2208 / 0.16e2 + t534 * t679 * t8992 / 0.16e2 + t6287 * t793 / 0.16e2 + t1667 * t2812 / 0.8e1 + t1667 * t2815 / 0.8e1 + t534 * t8083 * t762 / 0.16e2 + t534 * t2212 * t2411 / 0.8e1 - t534 * t2223 * t191 * t445 / 0.16e2 - t534 * t670 * t528 * t445 / 0.8e1 - t534 * t219 * t1701 * t445 / 0.16e2 + t6287 * t790 / 0.16e2 + t1667 * t2803 / 0.8e1 + t1667 * t2806 / 0.8e1 + t534 * t8016 * t758 / 0.16e2;
  t10586 = t10460 * t416;
  t10587 = t6165 * t10586;
  t10590 = t786 * t416;
  t10594 = t3772 * t9656;
  t10614 = -t519 * t539 * t8110 / 0.32e2 + t534 * t683 * t8924 / 0.16e2 - t6337 * t783 / 0.32e2 + 0.11e2 / 0.16e2 * t519 * t10587 + 0.11e2 / 0.16e2 * t534 * t10590 * t5254 + 0.11e2 / 0.16e2 * t534 * t10594 + 0.9e1 / 0.16e2 * t519 * t10594 - 0.9e1 / 0.16e2 * t519 * t2578 * t10586 - 0.3e1 / 0.2e1 * t534 * t10470 + 0.9e1 / 0.8e1 * t534 * t10587 - t10385 / 0.32e2 - t10387 / 0.32e2 - t10389 / 0.32e2 - t10391 / 0.32e2 + t10393 / 0.16e2 + t10395 / 0.16e2 + t10399 / 0.16e2 + t10401 / 0.16e2;
  t10622 = t10403 / 0.16e2 - t10405 / 0.16e2 - t10407 / 0.16e2 - t10409 / 0.16e2 + t10411 / 0.16e2 - t10237 - t10243 + t10225 + t10231 + t8838 - t8856 - t8858 + t8862 - t8875 + t8888 + t8898 - t8910;
  t10627 = t8030 * t5356;
  t10639 = -t8914 - t8921 - t8923 + t8972 - t8982 + t9003 + t9007 - t9009 - t9012 + t9017 - t9024 + t9033 - t9034 + t9038 - 0.25e2 / 0.16e2 * t534 * t2181 * t5344 * t9656 + 0.15e2 / 0.16e2 * t534 * t10627 * t9656 - t534 * t2793 * t168 * t1337 / 0.8e1 - t534 * t2797 * t168 * t1337 / 0.8e1;
  t10648 = t2157 * t75;
  t10667 = t8043 * t1362;
  t10674 = t2212 * t170;
  t10684 = t1619 * t420;
  t10696 = -t1667 * t2775 / 0.8e1 + 0.5e1 / 0.32e2 * t1674 * t2767 - t534 * t10590 * t5235 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t10648 * t6308 + 0.3e1 / 0.8e1 * t534 * t10590 * t5411 + t1667 * t2771 / 0.2e1 + t534 * t2793 * t418 * t2400 / 0.2e1 + t534 * t2797 * t418 * t2400 / 0.2e1 - 0.3e1 / 0.8e1 * t1667 * t2759 - 0.3e1 / 0.8e1 * t534 * t10667 * t2568 - 0.3e1 / 0.8e1 * t534 * t2758 * t8805 - t534 * t10674 * t2568 / 0.4e1 - t534 * t2778 * t8805 / 0.4e1 - t534 * t2778 * t6182 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t10684 * t10461 + 0.3e1 / 0.16e2 * t1670 * t2782 + 0.5e1 / 0.32e2 * t1674 * t2782 + 0.3e1 / 0.16e2 * t519 * t1611 * t420 * t2763;
  t10697 = t10473 * t168;
  t10722 = 0.3e1 / 0.16e2 * t519 * t2590 * t10697 + 0.3e1 / 0.32e2 * t519 * t2590 * t7968 + 0.3e1 / 0.8e1 * t1667 * t2786 + 0.3e1 / 0.8e1 * t534 * t2793 * t75 * t2374 + 0.3e1 / 0.8e1 * t534 * t2797 * t75 * t2374 + 0.3e1 / 0.16e2 * t534 * t2785 * t5164 + 0.3e1 / 0.8e1 * t534 * t2778 * t9656 - 0.5e1 / 0.32e2 * t1674 * t2764 - t9047 - t9073 + t8565 - t9080 + t9081 + t9082 - t9083 - t9084 - t9085 - t721;
  t10726 = my_piecewise3(t51, 0, t10500 + t10529 + t10577 + t10614 + t10622 + t10639 + t10696 + t10722);
  tv4rho2sigmatau17 = t10726 * t3 + 0.2e1 * t2830;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t10729 = t2836 * t8333;
  t10732 = t2840 * t8337;
  t10735 = t1462 * t2844;
  t10737 = t798 * t261;
  t10741 = t1462 * t2847;
  t10757 = t1466 * t2837;
  t10759 = t1466 * t2841;
  t10764 = -0.3e1 / 0.2e1 * t484 * t10729 + 0.9e1 / 0.8e1 * t484 * t10732 + t10735 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t10737 * t4414 - 0.3e1 / 0.16e2 * t10741 + t1455 * t2844 / 0.2e1 - 0.3e1 / 0.8e1 * t1455 * t2847 - 0.5e1 / 0.32e2 * t1470 * t2837 + 0.5e1 / 0.32e2 * t1470 * t2841 - t484 * t10737 * t4319 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t10737 * t4309 - 0.3e1 / 0.32e2 * t10757 + 0.3e1 / 0.32e2 * t10759 + 0.3e1 / 0.8e1 * t484 * t2856 * t8377;
  t10765 = t1462 * t2837;
  t10767 = t2836 * t8299;
  t10770 = t1462 * t2833;
  t10774 = t1462 * t2869;
  t10781 = t798 * t4275;
  t10800 = t2836 * t4237;
  t10803 = -0.3e1 / 0.16e2 * t10765 + 0.11e2 / 0.16e2 * t484 * t10767 - t10770 / 0.16e2 - t1455 * t2833 / 0.8e1 + 0.3e1 / 0.16e2 * t10774 + 0.11e2 / 0.16e2 * t484 * t10737 * t4331 + 0.11e2 / 0.16e2 * t469 * t10732 - 0.15e2 / 0.32e2 * t469 * t10781 * t8324 - 0.25e2 / 0.16e2 * t484 * t2840 * t8324 + 0.15e2 / 0.16e2 * t484 * t10781 * t8329 + 0.9e1 / 0.16e2 * t469 * t10767 + 0.5e1 / 0.32e2 * t1470 * t2863 + 0.3e1 / 0.32e2 * t469 * t2836 * t4267 - 0.3e1 / 0.8e1 * t1455 * t2837 - 0.3e1 / 0.16e2 * t484 * t10800;
  t10805 = t5635 * t798;
  t10809 = t1462 * t2853;
  t10811 = t1462 * t2857;
  t10813 = t1466 * t2863;
  t10817 = t496 * t1808;
  t10821 = t490 * t1808;
  t10829 = t1462 * t2866;
  t10841 = t1462 * t2873;
  t10843 = -0.9e1 / 0.16e2 * t469 * t1439 * t10805 + t10809 / 0.8e1 - t10811 / 0.8e1 + 0.3e1 / 0.32e2 * t10813 + t1455 * t2853 / 0.4e1 + t484 * t576 * t10817 / 0.8e1 + t484 * t572 * t10821 / 0.8e1 - 0.3e1 / 0.16e2 * t1458 * t2837 + 0.3e1 / 0.16e2 * t1458 * t2841 - t10829 / 0.8e1 - t1455 * t2866 / 0.4e1 - t484 * t576 * t6642 / 0.8e1 + 0.3e1 / 0.8e1 * t1455 * t2869 + 0.3e1 / 0.16e2 * t484 * t2856 * t4267 + t10841 / 0.8e1;
  t10849 = t5733 * t798;
  t10853 = t1466 * t2860;
  t10883 = -t1455 * t2857 / 0.4e1 - t484 * t2856 * t4245 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t1521 * t10849 - t10853 / 0.16e2 - t1458 * t2860 / 0.8e1 - t1470 * t2860 / 0.8e1 - t469 * t572 * t6642 / 0.16e2 + 0.3e1 / 0.16e2 * t1458 * t2863 + 0.3e1 / 0.32e2 * t469 * t2840 * t4227 + t484 * t2836 * t4227 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t2840 * t8474 - t484 * t798 * t283 * t986 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t10729 - 0.3e1 / 0.32e2 * t469 * t10800 + t1455 * t2873 / 0.4e1;
  t10886 = t9189 * t111;
  t10887 = t2463 * t10886;
  t10907 = t2454 * t563;
  t10913 = -0.3e1 / 0.8e1 * t469 * t10887 + 0.3e1 / 0.8e1 * t469 * t3006 * t10886 + t484 * t6454 * t10886 - 0.3e1 / 0.4e1 * t484 * t2483 * t10886 - t484 * t6469 * t6489 / 0.4e1 + 0.3e1 / 0.4e1 * t484 * t6469 * t6720 - t484 * t2469 * t10886 / 0.2e1 + 0.3e1 / 0.8e1 * t469 * t5483 * t10907 - 0.3e1 / 0.4e1 * t484 * t10887 - t8258 + t8271 + t8275 - t8281 + t8286 - t8305;
  t10914 = -t8307 + t8313 + t8316 - t8323 - t8342 + t8357 - t8359 - t8376 - t8422 + t8431 + t8435 - t8437 - t8441 + t8453 - t8455;
  t10928 = t1053 * t810;
  t10930 = t1053 * t800;
  t10932 = t255 * t2894;
  t10934 = t1053 * t804;
  t10936 = t1053 * t807;
  t10940 = t563 * t563;
  t10941 = t100 * t10940;
  t10949 = t952 * t807 / 0.64e2;
  t10950 = t8468 + t1050 * t807 / 0.16e2 + t1050 * t810 / 0.16e2 - t1050 * t800 / 0.32e2 - t246 * t2894 / 0.16e2 - t99 * t4484 * t798 * t269 / 0.32e2 + t10928 / 0.16e2 - t10930 / 0.32e2 - t10932 / 0.32e2 - t10934 / 0.16e2 + t10936 / 0.16e2 - t1050 * t804 / 0.16e2 + t99 * t10941 * t297 / 0.8e1 - t99 * t10941 * t290 / 0.8e1 - t10949;
  t10952 = t952 * t800 / 0.128e3;
  t10958 = t952 * t804 / 0.64e2;
  t10960 = t952 * t810 / 0.64e2;
  t10964 = t10952 - t99 * t260 * t10940 * t269 / 0.16e2 + t10958 - t10960 + t99 * t10941 * t301 / 0.8e1 - t8502 - t8506 + t8526 - t8541 + t8542 + t8543 - t8544 - t8545 - t8546 - t699;
  t10968 = my_piecewise3(t2, 0, t10764 + t10803 + t10843 + t10883 + t10913 + t10914 + t10950 + t10964);
  tv4rho2lapl20 = t10968 * t3 + 0.2e1 * t2899;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t10973 = t1167 * t817;
  t10976 = t1170 * t817 / 0.128e3;
  t10979 = t1167 * t821;
  t10982 = t1170 * t821 / 0.64e2;
  t10985 = t1167 * t824;
  t10988 = t1170 * t824 / 0.64e2;
  t10991 = t1167 * t827;
  t10994 = t1170 * t827 / 0.64e2;
  t10995 = -t1164 * t817 / 0.32e2 - t10973 / 0.32e2 + t10976 - t8561 - t8563 + t8565 - t1164 * t821 / 0.16e2 - t10979 / 0.16e2 + t10982 + t1164 * t824 / 0.16e2 + t10985 / 0.16e2 - t10988 + t1164 * t827 / 0.16e2 + t10991 / 0.16e2 - t10994;
  t10996 = my_piecewise3(t51, 0, t10995);
  tv4rho2lapl22 = t10996 * t3 + 0.2e1 * t2918;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t11025 = -t1553 * t2833 / 0.16e2 - 0.3e1 / 0.16e2 * t1553 * t2847 - 0.3e1 / 0.32e2 * t1548 * t2837 + 0.3e1 / 0.32e2 * t1548 * t2841 + t1553 * t2844 / 0.4e1 - t1553 * t2866 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t2869 - t1548 * t2860 / 0.16e2 + 0.3e1 / 0.32e2 * t1548 * t2863 + t1553 * t2853 / 0.8e1 - t1553 * t2857 / 0.8e1 + t1553 * t2873 / 0.8e1 - 0.3e1 / 0.16e2 * t1553 * t2837 + t10735 / 0.8e1;
  t11038 = -0.3e1 / 0.32e2 * t10741 - 0.3e1 / 0.64e2 * t10757 + 0.3e1 / 0.64e2 * t10759 - 0.3e1 / 0.32e2 * t10765 - t10770 / 0.32e2 + 0.3e1 / 0.32e2 * t10774 + t10809 / 0.16e2 - t10811 / 0.16e2 + 0.3e1 / 0.64e2 * t10813 - t10829 / 0.16e2 + t10841 / 0.16e2 - t10853 / 0.32e2 + t8592 - t8598 + t8619;
  t11048 = t1124 * t807;
  t11050 = t1124 * t810;
  t11052 = t1124 * t804;
  t11054 = t1124 * t800;
  t11058 = -t8621 + t8624 - t8627 + t8639 - t8640 - t1121 * t804 / 0.16e2 + t1121 * t807 / 0.16e2 - t1121 * t800 / 0.32e2 - t345 * t2894 / 0.32e2 + t11048 / 0.32e2 + t11050 / 0.32e2 - t11052 / 0.32e2 - t11054 / 0.64e2 + t1121 * t810 / 0.16e2;
  t11064 = t10928 / 0.32e2 - t10930 / 0.64e2 - t10932 / 0.64e2 - t10934 / 0.32e2 + t10936 / 0.32e2 - t10949 + t10952 + t10958 - t10960 - t8650 - t8661 - t8668 + t8526 - t2355 - t2316;
  t11067 = my_piecewise3(t2, 0, t11025 + t11038 + t11058 + t11064);
  tv4rho2lapl23 = t11067 * t3 + t2899 + t2929;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t11069 = t1589 * t2966;
  t11071 = t1578 * t2969;
  t11073 = t1578 * t2972;
  t11075 = t1589 * t2949;
  t11077 = t1589 * t2953;
  t11079 = t1589 * t2957;
  t11081 = t1589 * t2936;
  t11093 = t1589 * t2946;
  t11095 = t1589 * t2932;
  t11097 = -t11069 / 0.16e2 - t11071 / 0.32e2 + 0.3e1 / 0.64e2 * t11073 - t11075 / 0.16e2 + 0.3e1 / 0.32e2 * t11077 + t11079 / 0.16e2 - 0.3e1 / 0.32e2 * t11081 - t1585 * t2966 / 0.8e1 - t1574 * t2969 / 0.16e2 - t1585 * t2949 / 0.8e1 + 0.3e1 / 0.16e2 * t1585 * t2953 + t1585 * t2957 / 0.8e1 - 0.3e1 / 0.32e2 * t11093 - t11095 / 0.32e2;
  t11098 = t1578 * t2936;
  t11100 = t1578 * t2940;
  t11102 = t1589 * t2943;
  t11104 = t1589 * t2963;
  t11122 = -0.3e1 / 0.64e2 * t11098 + 0.3e1 / 0.64e2 * t11100 + t11102 / 0.8e1 + t11104 / 0.16e2 + 0.3e1 / 0.32e2 * t1574 * t2972 - 0.3e1 / 0.16e2 * t1585 * t2936 + t1585 * t2963 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t2940 + t1585 * t2943 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t2946 - t1585 * t2932 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t2936 - t8678 + t8696 - t8698;
  t11134 = t1227 * t821;
  t11136 = t1227 * t824;
  t11138 = t1227 * t827;
  t11140 = t1227 * t817;
  t11142 = t8707 + t8721 - t8723 - t8731 + t8745 + t1224 * t824 / 0.16e2 + t1224 * t827 / 0.16e2 - t1224 * t817 / 0.32e2 - t367 * t2981 / 0.32e2 - t1224 * t821 / 0.16e2 - t11134 / 0.32e2 + t11136 / 0.32e2 + t11138 / 0.32e2 - t11140 / 0.64e2;
  t11143 = t370 * t2981;
  t11149 = -t11143 / 0.64e2 + t10985 / 0.32e2 - t10988 + t10991 / 0.32e2 - t10994 - t10973 / 0.64e2 + t10976 - t10979 / 0.32e2 + t10982 - t8757 - t8770 - t8773 + t8565 - t2334 - t2336;
  t11152 = my_piecewise3(t51, 0, t11097 + t11122 + t11142 + t11149);
  tv4rho2lapl25 = t11152 * t3 + t2918 + t2990;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t11167 = -t1196 * t800 / 0.32e2 - t11054 / 0.32e2 + t10952 - t8786 - t8787 + t8526 - t1196 * t804 / 0.16e2 - t11052 / 0.16e2 + t10958 + t1196 * t807 / 0.16e2 + t11048 / 0.16e2 - t10949 + t1196 * t810 / 0.16e2 + t11050 / 0.16e2 - t10960;
  t11168 = my_piecewise3(t2, 0, t11167);
  tv4rho2lapl26 = t11168 * t3 + 0.2e1 * t2929;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t11171 = t9718 * t168;
  t11180 = t615 * t420;
  t11184 = t2573 * t602;
  t11185 = t7976 * t11184;
  t11190 = t815 * t416;
  t11199 = t2939 * t8866;
  t11202 = t815 * t5342;
  t11214 = t534 * t7069 * t11171 - 0.3e1 / 0.4e1 * t534 * t2566 * t11171 - t534 * t7080 * t7139 / 0.4e1 + 0.3e1 / 0.4e1 * t534 * t11180 * t11171 - 0.3e1 / 0.8e1 * t519 * t11185 - 0.3e1 / 0.4e1 * t534 * t11185 + 0.3e1 / 0.8e1 * t534 * t11190 * t5411 - t1667 * t2932 / 0.8e1 + 0.11e2 / 0.16e2 * t534 * t11190 * t5254 + 0.11e2 / 0.16e2 * t519 * t11199 - 0.15e2 / 0.32e2 * t519 * t11202 * t8839 - 0.25e2 / 0.16e2 * t534 * t2939 * t8839 + 0.15e2 / 0.16e2 * t534 * t11202 * t8890 + 0.9e1 / 0.8e1 * t534 * t11199;
  t11215 = t2935 * t8850;
  t11233 = t2935 * t8843;
  t11251 = -0.3e1 / 0.2e1 * t534 * t11215 - 0.3e1 / 0.16e2 * t1670 * t2936 + 0.3e1 / 0.16e2 * t1670 * t2940 - 0.5e1 / 0.32e2 * t1674 * t2936 + 0.5e1 / 0.32e2 * t1674 * t2940 + t1667 * t2943 / 0.2e1 - 0.3e1 / 0.8e1 * t1667 * t2946 - t534 * t11190 * t5235 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t11233 + 0.3e1 / 0.8e1 * t534 * t2952 * t8915 - 0.11e2 / 0.16e2 * t534 * t2952 * t9697 + 0.3e1 / 0.16e2 * t1670 * t2972 + 0.5e1 / 0.32e2 * t1674 * t2972 - t1667 * t2949 / 0.4e1 - t534 * t615 * t7245 / 0.8e1;
  t11262 = t540 * t1966;
  t11268 = t2935 * t8963;
  t11271 = t6239 * t815;
  t11295 = 0.3e1 / 0.8e1 * t1667 * t2953 + 0.3e1 / 0.16e2 * t534 * t2952 * t5164 + 0.9e1 / 0.16e2 * t519 * t11233 + t1667 * t2957 / 0.4e1 + t534 * t611 * t11262 / 0.8e1 - 0.3e1 / 0.8e1 * t1667 * t2936 - 0.3e1 / 0.16e2 * t534 * t11268 - 0.9e1 / 0.16e2 * t519 * t1640 * t11271 + t534 * t2935 * t5194 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2939 * t9018 - t534 * t815 * t438 * t1337 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t11215 - 0.3e1 / 0.32e2 * t519 * t11268 + 0.3e1 / 0.32e2 * t519 * t2939 * t5194 + 0.3e1 / 0.32e2 * t519 * t2935 * t5164;
  t11298 = t546 * t1966;
  t11307 = t6307 * t815;
  t11325 = t1667 * t2963 / 0.4e1 + t534 * t615 * t11298 / 0.8e1 - t1667 * t2966 / 0.4e1 - t534 * t2952 * t5216 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t1619 * t11307 - t1670 * t2969 / 0.8e1 - t1674 * t2969 / 0.8e1 - t519 * t611 * t7245 / 0.16e2 - t11069 / 0.8e1 - t11071 / 0.16e2 + 0.3e1 / 0.32e2 * t11073 - t11075 / 0.8e1 + 0.3e1 / 0.16e2 * t11077 + t11079 / 0.8e1 - 0.3e1 / 0.16e2 * t11081;
  t11343 = -0.3e1 / 0.16e2 * t11093 - t11095 / 0.16e2 - 0.3e1 / 0.32e2 * t11098 + 0.3e1 / 0.32e2 * t11100 + t11102 / 0.4e1 + t11104 / 0.8e1 + 0.3e1 / 0.8e1 * t519 * t6189 * t11184 - t534 * t2600 * t11171 / 0.2e1 + 0.3e1 / 0.8e1 * t519 * t6181 * t11184 + t8838 - t8856 - t8858 + t8862 - t8875 + t8888;
  t11344 = t8898 - t8910 - t8914 - t8921 - t8923 + t8972 - t8982 + t9003 + t9007 - t9009 - t9012 + t9017 - t9024 + t9033 - t9034;
  t11352 = t602 * t602;
  t11353 = t157 * t11352;
  t11379 = t9038 - t1323 * t821 / 0.16e2 + t1323 * t824 / 0.16e2 + t1323 * t827 / 0.16e2 + t156 * t11353 * t456 / 0.8e1 - t156 * t415 * t11352 * t424 / 0.16e2 - t156 * t11353 * t445 / 0.8e1 + t156 * t11353 * t452 / 0.8e1 - t1323 * t817 / 0.32e2 - t409 * t2981 / 0.16e2 - t156 * t5302 * t815 * t424 / 0.32e2 - t11134 / 0.16e2 + t11136 / 0.16e2 + t11138 / 0.16e2 - t11140 / 0.32e2;
  t11381 = -t11143 / 0.32e2 - t10988 - t10994 + t10976 + t10982 - t9047 - t9073 + t8565 - t9080 + t9081 + t9082 - t9083 - t9084 - t9085 - t721;
  t11385 = my_piecewise3(t51, 0, t11214 + t11251 + t11295 + t11325 + t11343 + t11344 + t11379 + t11381);
  tv4rho2lapl28 = t11385 * t3 + 0.2e1 * t2990;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  t11389 = t5567 * t844 / 0.64e2;
  t11391 = t5567 * t840 / 0.64e2;
  t11404 = t1462 * t3023;
  t11406 = t1462 * t3026;
  t11408 = t5580 * t844;
  t11410 = t1462 * t3031;
  t11412 = t1462 * t3034;
  t11414 = t5773 * t832;
  t11416 = t5762 * t832;
  t11418 = t1466 * t3042;
  t11420 = t1466 * t3045;
  t11422 = t5580 * t836;
  t11424 = -t11389 - t11391 + t484 * t2021 * t2872 / 0.8e1 + t484 * t640 * t10821 / 0.16e2 + t5531 * t844 / 0.16e2 + t1455 * t3031 / 0.8e1 + t1455 * t3034 / 0.8e1 + t11404 / 0.16e2 + t11406 / 0.16e2 + t11408 / 0.16e2 + t11410 / 0.16e2 + t11412 / 0.16e2 - t11414 / 0.32e2 - t11416 / 0.32e2 - t11418 / 0.32e2 - t11420 / 0.32e2 - t11422 / 0.16e2;
  t11425 = t1462 * t3051;
  t11427 = t1462 * t3055;
  t11429 = t5580 * t840;
  t11432 = t5758 * t832 / 0.128e3;
  t11434 = t5567 * t836 / 0.64e2;
  t11471 = -t11425 / 0.16e2 - t11427 / 0.16e2 + t11429 / 0.16e2 + t11432 + t11434 - t484 * t631 * t563 * t290 / 0.8e1 - t484 * t213 * t1808 * t290 / 0.16e2 - t1470 * t3042 / 0.16e2 - t1470 * t3045 / 0.16e2 - t469 * t6597 * t626 / 0.32e2 - t469 * t1775 * t2007 / 0.16e2 - t469 * t572 * t7521 / 0.32e2 - t5531 * t836 / 0.16e2 - t1455 * t3051 / 0.8e1 - t1455 * t3055 / 0.8e1 + t484 * t7469 * t843 / 0.16e2 + t484 * t2041 * t2852 / 0.8e1 + t484 * t644 * t10817 / 0.16e2;
  t11496 = -t5667 * t832 / 0.32e2 - t5776 * t832 / 0.16e2 - t1458 * t3042 / 0.16e2 - t1458 * t3045 / 0.16e2 - t5768 * t832 / 0.32e2 + t5531 * t840 / 0.16e2 + t1455 * t3023 / 0.8e1 + t1455 * t3026 / 0.8e1 + t484 * t7388 * t839 / 0.16e2 - t484 * t2061 * t199 * t290 / 0.16e2 - t8258 + t8271 + t8275 - t8281 + t8286 - t8305 - t8307;
  t11500 = t835 * t261;
  t11504 = t2483 * t9926;
  t11507 = t8313 + t8316 - t8323 - t8342 + t8357 - t8359 - t8376 - t8422 + t8431 + t8435 - t8437 - t8441 + t8453 - t8455 + t8468 + 0.15e2 / 0.16e2 * t484 * t9912 * t9094 + 0.11e2 / 0.16e2 * t484 * t11500 * t4331 + 0.11e2 / 0.16e2 * t469 * t11504;
  t11510 = t6537 * t4344;
  t11514 = t835 * t997;
  t11518 = t640 * t999;
  t11519 = t11518 * t9094;
  t11524 = t2463 * t9926;
  t11530 = t2463 * t7361;
  t11545 = -0.15e2 / 0.32e2 * t469 * t11510 * t9926 - 0.25e2 / 0.16e2 * t484 * t11514 * t8324 - 0.3e1 / 0.2e1 * t484 * t11519 + 0.9e1 / 0.8e1 * t484 * t11504 + 0.9e1 / 0.16e2 * t469 * t11524 - 0.3e1 / 0.16e2 * t484 * t2645 * t6473 - 0.3e1 / 0.32e2 * t469 * t11530 + 0.3e1 / 0.32e2 * t469 * t3006 * t7361 + t484 * t2992 * t4227 / 0.4e1 - t484 * t835 * t283 * t986 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t11519 - t8502 - t8506 + t8526 - t8541 + t8542 + t8543;
  t11546 = t9973 * t199;
  t11550 = t2657 * t563;
  t11556 = t3050 * t43;
  t11560 = t3054 * t43;
  t11575 = t9925 * t199;
  t11583 = t1775 * t265;
  t11590 = -t8544 - t8545 - t8546 - t699 + 0.3e1 / 0.16e2 * t469 * t5509 * t11546 + 0.3e1 / 0.16e2 * t469 * t5509 * t11550 + 0.3e1 / 0.8e1 * t1455 * t3020 + 0.3e1 / 0.8e1 * t484 * t11556 * t2239 + 0.3e1 / 0.8e1 * t484 * t11560 * t2239 + 0.3e1 / 0.16e2 * t484 * t3019 * t4267 + 0.3e1 / 0.16e2 * t1458 * t3007 - t484 * t2653 * t10886 / 0.4e1 - t484 * t2653 * t6473 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t10081 * t11575 + 0.3e1 / 0.16e2 * t1458 * t3016 + 0.5e1 / 0.32e2 * t1470 * t3016 + 0.3e1 / 0.16e2 * t469 * t11583 * t2658 + 0.3e1 / 0.16e2 * t469 * t3015 * t9974;
  t11595 = t1462 * t2999;
  t11597 = t1466 * t3007;
  t11601 = t2021 * t295;
  t11602 = t11601 * t2455;
  t11605 = t2666 * t10886;
  t11614 = t1462 * t3012;
  t11616 = t1466 * t3016;
  t11638 = 0.3e1 / 0.32e2 * t469 * t3015 * t7361 - 0.3e1 / 0.16e2 * t11595 + 0.3e1 / 0.32e2 * t11597 - 0.3e1 / 0.8e1 * t1455 * t2999 - 0.3e1 / 0.8e1 * t484 * t11602 - 0.3e1 / 0.8e1 * t484 * t11605 - 0.3e1 / 0.16e2 * t484 * t11530 - 0.9e1 / 0.16e2 * t469 * t1439 * t999 * t11575 - t11614 / 0.8e1 + 0.3e1 / 0.32e2 * t11616 - t1455 * t3012 / 0.4e1 - t484 * t10038 * t2455 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t2653 * t9094 + 0.11e2 / 0.16e2 * t484 * t11524 - 0.3e1 / 0.16e2 * t469 * t11602 - t484 * t11500 * t4319 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t11500 * t4414 + t1455 * t2993 / 0.2e1;
  t11661 = t1462 * t2993;
  t11663 = t1462 * t2996;
  t11668 = t1466 * t2999;
  t11674 = t1462 * t3020;
  t11676 = t1462 * t3003;
  t11684 = -0.3e1 / 0.8e1 * t1455 * t2996 + t484 * t9949 * t2455 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t9953 * t2455 + t484 * t11518 * t10886 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t2645 * t10886 - 0.3e1 / 0.16e2 * t1458 * t2999 - 0.5e1 / 0.32e2 * t1470 * t2999 + 0.5e1 / 0.32e2 * t1470 * t3007 - 0.3e1 / 0.16e2 * t469 * t11605 + t11661 / 0.4e1 - 0.3e1 / 0.16e2 * t11663 - 0.11e2 / 0.16e2 * t484 * t9983 * t6687 - 0.3e1 / 0.32e2 * t11668 - t484 * t3054 * t111 * t986 / 0.8e1 + 0.3e1 / 0.16e2 * t11674 - t11676 / 0.16e2 - t1455 * t3003 / 0.8e1 - t484 * t3050 * t111 * t986 / 0.8e1;
  t11688 = my_piecewise3(t2, 0, t11424 + t11471 + t11496 + t11507 + t11545 + t11590 + t11638 + t11684);
  tv4rho2lapltau0 = t11688 * t3 + 0.2e1 * t3070;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  t11693 = t5956 * t849;
  t11696 = t5960 * t849 / 0.128e3;
  t11699 = t5945 * t853;
  t11702 = t5949 * t853 / 0.64e2;
  t11705 = t5945 * t857;
  t11708 = t5949 * t857 / 0.64e2;
  t11711 = t5945 * t861;
  t11714 = t5949 * t861 / 0.64e2;
  t11715 = -t5973 * t849 / 0.32e2 - t11693 / 0.32e2 + t11696 - t8561 - t8563 + t8565 - t5967 * t853 / 0.16e2 - t11699 / 0.16e2 + t11702 + t5967 * t857 / 0.16e2 + t11705 / 0.16e2 - t11708 + t5967 * t861 / 0.16e2 + t11711 / 0.16e2 - t11714;
  t11716 = my_piecewise3(t51, 0, t11715);
  tv4rho2lapltau3 = t11716 * t3 + 0.2e1 * t3089;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  t11718 = t5838 * t840;
  t11720 = t5879 * t832;
  t11722 = t5838 * t836;
  t11750 = t11718 / 0.32e2 - t11720 / 0.64e2 - t11722 / 0.32e2 + t5835 * t840 / 0.16e2 + t1553 * t3023 / 0.16e2 + t1553 * t3026 / 0.16e2 + t5835 * t844 / 0.16e2 + t1553 * t3031 / 0.16e2 + t1553 * t3034 / 0.16e2 - t5835 * t836 / 0.16e2 - t1553 * t3051 / 0.16e2 - t1553 * t3055 / 0.16e2 - t5874 * t832 / 0.32e2 - t5888 * t832 / 0.32e2 - t1548 * t3042 / 0.32e2 - t1548 * t3045 / 0.32e2;
  t11751 = t5838 * t844;
  t11766 = t11751 / 0.32e2 - t11389 - t11391 + t11404 / 0.32e2 + t11406 / 0.32e2 + t11408 / 0.32e2 + t11410 / 0.32e2 + t11412 / 0.32e2 - t11414 / 0.64e2 - t11416 / 0.64e2 - t11418 / 0.64e2 - t11420 / 0.64e2 - t11422 / 0.32e2 - t11425 / 0.32e2 - t11427 / 0.32e2 + t11429 / 0.32e2 + t11432;
  t11782 = t11434 + t8592 - t8598 + t8619 - t8621 + t8624 - t8627 + t8639 - t8640 + 0.3e1 / 0.16e2 * t1553 * t3020 - t1553 * t3003 / 0.16e2 - t1553 * t3012 / 0.8e1 - 0.3e1 / 0.16e2 * t1553 * t2999 + 0.3e1 / 0.32e2 * t1548 * t3016 - 0.3e1 / 0.16e2 * t1553 * t2996 - 0.3e1 / 0.32e2 * t1548 * t2999;
  t11796 = 0.3e1 / 0.32e2 * t1548 * t3007 + t1553 * t2993 / 0.4e1 - t8650 - t8661 - t8668 + t8526 - t2355 - t2316 - 0.3e1 / 0.32e2 * t11595 + 0.3e1 / 0.64e2 * t11597 - t11614 / 0.16e2 + 0.3e1 / 0.64e2 * t11616 + t11661 / 0.8e1 - 0.3e1 / 0.32e2 * t11663 - 0.3e1 / 0.64e2 * t11668 + 0.3e1 / 0.32e2 * t11674 - t11676 / 0.32e2;
  t11799 = my_piecewise3(t2, 0, t11750 + t11766 + t11782 + t11796);
  tv4rho2lapltau4 = t11799 * t3 + t3070 + t3100;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  t11815 = t1589 * t3136;
  t11817 = t1589 * t3139;
  t11819 = t6048 * t861;
  t11833 = t1585 * t3144 / 0.16e2 + t1585 * t3147 / 0.16e2 - t6107 * t849 / 0.32e2 + t1585 * t3136 / 0.16e2 + t1585 * t3139 / 0.16e2 + t6085 * t861 / 0.16e2 + t6085 * t857 / 0.16e2 + t11815 / 0.32e2 + t11817 / 0.32e2 + t11819 / 0.32e2 - t6085 * t853 / 0.16e2 - t1585 * t3164 / 0.16e2 - t1585 * t3168 / 0.16e2 - t6092 * t849 / 0.32e2 - t1574 * t3155 / 0.32e2 - t1574 * t3158 / 0.32e2;
  t11834 = t1578 * t3155;
  t11836 = t1578 * t3158;
  t11838 = t6048 * t853;
  t11840 = t1589 * t3164;
  t11842 = t1589 * t3168;
  t11844 = t1589 * t3144;
  t11846 = t1589 * t3147;
  t11848 = t6070 * t849;
  t11850 = t6025 * t849;
  t11852 = t6048 * t857;
  t11858 = -t11834 / 0.64e2 - t11836 / 0.64e2 - t11838 / 0.32e2 - t11840 / 0.32e2 - t11842 / 0.32e2 + t11844 / 0.32e2 + t11846 / 0.32e2 - t11848 / 0.64e2 - t11850 / 0.64e2 + t11852 / 0.32e2 - t11699 / 0.32e2 + t11702 + t11705 / 0.32e2 - t11708 + t11711 / 0.32e2 - t11714 - t11693 / 0.64e2;
  t11868 = t1589 * t3131;
  t11870 = t1589 * t3110;
  t11872 = t1589 * t3123;
  t11874 = t11696 - t8678 + t8696 - t8698 + t8707 + t8721 - t8723 - t8731 + t8745 + 0.3e1 / 0.32e2 * t1574 * t3127 + 0.3e1 / 0.16e2 * t1585 * t3131 - 0.3e1 / 0.16e2 * t1585 * t3110 - t1585 * t3123 / 0.8e1 + 0.3e1 / 0.32e2 * t11868 - 0.3e1 / 0.32e2 * t11870 - t11872 / 0.16e2;
  t11885 = t1578 * t3114;
  t11887 = t1589 * t3118;
  t11889 = t1589 * t3102;
  t11891 = t1589 * t3106;
  t11893 = t1578 * t3110;
  t11895 = t1578 * t3127;
  t11897 = 0.3e1 / 0.32e2 * t1574 * t3114 + t1585 * t3118 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3102 - t1585 * t3106 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t3110 + 0.3e1 / 0.64e2 * t11885 + t11887 / 0.8e1 - 0.3e1 / 0.32e2 * t11889 - t11891 / 0.32e2 - 0.3e1 / 0.64e2 * t11893 + 0.3e1 / 0.64e2 * t11895 - t8757 - t8770 - t8773 + t8565 - t2334 - t2336;
  t11900 = my_piecewise3(t51, 0, t11833 + t11858 + t11874 + t11897);
  tv4rho2lapltau7 = t11900 * t3 + t3089 + t3173;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  t11915 = -t6000 * t832 / 0.32e2 - t11720 / 0.32e2 + t11432 - t8786 - t8787 + t8526 - t6005 * t836 / 0.16e2 - t11722 / 0.16e2 + t11434 + t6005 * t840 / 0.16e2 + t11718 / 0.16e2 - t11391 + t6005 * t844 / 0.16e2 + t11751 / 0.16e2 - t11389;
  t11916 = my_piecewise3(t2, 0, t11915);
  tv4rho2lapltau8 = t11916 * t3 + 0.2e1 * t3100;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  t11961 = t1667 * t3136 / 0.8e1 + t1667 * t3139 / 0.8e1 + t534 * t8016 * t856 / 0.16e2 + t534 * t2153 * t2956 / 0.8e1 + t534 * t679 * t11262 / 0.16e2 - t534 * t219 * t1966 * t445 / 0.16e2 - t519 * t7178 * t665 / 0.32e2 - t519 * t1917 * t2208 / 0.16e2 - t519 * t611 * t8110 / 0.32e2 - t6287 * t853 / 0.16e2 - t1667 * t3164 / 0.8e1 - t1667 * t3168 / 0.8e1 - t6337 * t849 / 0.32e2 - t6343 * t849 / 0.16e2 - t1670 * t3155 / 0.16e2 - t1670 * t3158 / 0.16e2 - t6351 * t849 / 0.32e2;
  t11998 = -t1674 * t3155 / 0.16e2 - t1674 * t3158 / 0.16e2 + t6287 * t861 / 0.16e2 + t1667 * t3144 / 0.8e1 + t1667 * t3147 / 0.8e1 + t534 * t8083 * t860 / 0.16e2 + t534 * t2212 * t2962 / 0.8e1 + t534 * t683 * t11298 / 0.16e2 + t6287 * t857 / 0.16e2 - t534 * t2223 * t207 * t445 / 0.16e2 - t534 * t670 * t602 * t445 / 0.8e1 + t11815 / 0.16e2 + t11817 / 0.16e2 + t11819 / 0.16e2 - t11834 / 0.32e2 - t11836 / 0.32e2 - t11838 / 0.16e2 - t11840 / 0.16e2;
  t12006 = -t11842 / 0.16e2 + t11844 / 0.16e2 + t11846 / 0.16e2 - t11848 / 0.32e2 - t11850 / 0.32e2 + t11852 / 0.16e2 + t11702 - t11708 - t11714 + t11696 + t8838 - t8856 - t8858 + t8862 - t8875 + t8888 + t8898;
  t12016 = -t8910 - t8914 - t8921 - t8923 + t8972 - t8982 + t9003 + t9007 - t9009 - t9012 + t9017 - t9024 + t9033 - t9034 + t9038 + 0.3e1 / 0.32e2 * t519 * t3113 * t7968 + t534 * t3117 * t5194 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t2758 * t7090;
  t12023 = t10460 * t207;
  t12024 = t10469 * t12023;
  t12027 = t3109 * t7968;
  t12032 = t10473 * t207;
  t12036 = t2762 * t602;
  t12048 = t3163 * t75;
  t12052 = t3167 * t75;
  t12061 = t2153 * t450;
  t12062 = t12061 * t2574;
  t12067 = t852 * t416;
  t12073 = -t534 * t852 * t438 * t1337 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t12024 - 0.3e1 / 0.32e2 * t519 * t12027 + 0.3e1 / 0.16e2 * t1670 * t3114 + 0.3e1 / 0.16e2 * t519 * t6189 * t12032 + 0.3e1 / 0.16e2 * t519 * t6189 * t12036 + 0.3e1 / 0.16e2 * t519 * t3126 * t10697 + 0.3e1 / 0.32e2 * t519 * t3126 * t7968 + 0.3e1 / 0.8e1 * t1667 * t3131 + 0.3e1 / 0.8e1 * t534 * t12048 * t2374 + 0.3e1 / 0.8e1 * t534 * t12052 * t2374 + 0.3e1 / 0.16e2 * t534 * t3130 * t5164 - 0.3e1 / 0.8e1 * t1667 * t3110 - 0.3e1 / 0.8e1 * t534 * t12062 - 0.3e1 / 0.16e2 * t519 * t12062 - t534 * t12067 * t5235 / 0.16e2 + t1667 * t3118 / 0.2e1;
  t12083 = t679 * t1350;
  t12096 = t9714 * t2763;
  t12115 = t3772 * t9645;
  t12123 = -0.3e1 / 0.8e1 * t1667 * t3102 + t534 * t2153 * t1350 * t2574 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t10667 * t2574 + t534 * t12083 * t11171 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2758 * t11171 - 0.3e1 / 0.16e2 * t1670 * t3110 - 0.5e1 / 0.32e2 * t1674 * t3110 + 0.5e1 / 0.32e2 * t1674 * t3114 - 0.3e1 / 0.16e2 * t519 * t12096 - 0.11e2 / 0.16e2 * t534 * t10648 * t7282 + 0.3e1 / 0.8e1 * t534 * t12067 * t5411 - t534 * t3167 * t168 * t1337 / 0.8e1 - t1667 * t3106 / 0.8e1 - t534 * t3163 * t168 * t1337 / 0.8e1 + 0.11e2 / 0.16e2 * t534 * t12115 + 0.3e1 / 0.8e1 * t534 * t2778 * t9645 + 0.3e1 / 0.16e2 * t11868 - 0.3e1 / 0.16e2 * t11870;
  t12134 = -t11872 / 0.8e1 + 0.3e1 / 0.32e2 * t11885 + t11887 / 0.4e1 - 0.3e1 / 0.16e2 * t11889 - t11891 / 0.16e2 - 0.3e1 / 0.32e2 * t11893 + 0.3e1 / 0.32e2 * t11895 - t9047 - t9073 + t8565 - t9080 + t9081 + t9082 - t9083 - t9084 - t9085 - t721 - 0.3e1 / 0.8e1 * t534 * t12096;
  t12159 = t1917 * t420;
  t12163 = t7191 * t5344;
  t12167 = t852 * t1348;
  t12177 = t2566 * t10586;
  t12186 = -0.3e1 / 0.16e2 * t534 * t12027 - 0.9e1 / 0.16e2 * t519 * t1640 * t1350 * t12023 - t1667 * t3123 / 0.4e1 - t534 * t10674 * t2574 / 0.4e1 - t534 * t2778 * t11171 / 0.4e1 - t534 * t2778 * t7090 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t10684 * t12023 + 0.3e1 / 0.16e2 * t1670 * t3127 + 0.5e1 / 0.32e2 * t1674 * t3127 + 0.3e1 / 0.16e2 * t519 * t12159 * t2763 - 0.15e2 / 0.32e2 * t519 * t12163 * t10586 - 0.25e2 / 0.16e2 * t534 * t12167 * t8839 + 0.15e2 / 0.16e2 * t534 * t10627 * t9645 + 0.11e2 / 0.16e2 * t534 * t12067 * t5254 + 0.11e2 / 0.16e2 * t519 * t12177 + 0.9e1 / 0.16e2 * t519 * t12115 - 0.3e1 / 0.2e1 * t534 * t12024 + 0.9e1 / 0.8e1 * t534 * t12177;
  t12190 = my_piecewise3(t51, 0, t11961 + t11998 + t12006 + t12016 + t12073 + t12123 + t12134 + t12186);
  tv4rho2lapltau11 = t12190 * t3 + 0.2e1 * t3173;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t12205 = t1462 * t3176;
  t12214 = t5733 * t866;
  t12224 = 0.3e1 / 0.16e2 * t1458 * t3216 - t1458 * t3213 / 0.8e1 - t1455 * t3197 / 0.4e1 + 0.3e1 / 0.8e1 * t1455 * t3200 - 0.3e1 / 0.16e2 * t1458 * t3180 - t1455 * t3176 / 0.8e1 - t12205 / 0.16e2 - t1470 * t3213 / 0.8e1 + 0.5e1 / 0.32e2 * t1470 * t3216 - t484 * t3193 * t4245 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t1521 * t12214 + t1455 * t3204 / 0.4e1 - 0.3e1 / 0.8e1 * t1455 * t3180 + 0.3e1 / 0.16e2 * t1458 * t3184;
  t12229 = t1462 * t3210;
  t12231 = t1462 * t3197;
  t12233 = t1462 * t3200;
  t12235 = t1466 * t3180;
  t12243 = t5627 * t866;
  t12244 = t1521 * t12243;
  t12247 = t3179 * t4237;
  t12263 = t5635 * t866;
  t12264 = t1521 * t12263;
  t12267 = t1455 * t3210 / 0.4e1 - t1455 * t3194 / 0.4e1 + t12229 / 0.8e1 - t12231 / 0.8e1 + 0.3e1 / 0.16e2 * t12233 - 0.3e1 / 0.32e2 * t12235 - t484 * t644 * t7521 / 0.8e1 + 0.3e1 / 0.16e2 * t484 * t3193 * t4267 + 0.9e1 / 0.16e2 * t469 * t12244 - 0.3e1 / 0.32e2 * t469 * t12247 + 0.3e1 / 0.32e2 * t469 * t3183 * t4227 + t484 * t3179 * t4227 / 0.4e1 - 0.3e1 / 0.16e2 * t484 * t3183 * t8474 - t484 * t866 * t283 * t986 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t12264;
  t12275 = t1466 * t3216;
  t12281 = t1466 * t3213;
  t12283 = t1462 * t3204;
  t12285 = t1462 * t3180;
  t12287 = t1466 * t3184;
  t12301 = t1462 * t3194;
  t12303 = t1462 * t3190;
  t12305 = t866 * t261;
  t12309 = -t469 * t640 * t7521 / 0.16e2 + 0.3e1 / 0.32e2 * t469 * t3179 * t4267 + 0.3e1 / 0.32e2 * t12275 + t484 * t644 * t496 * t2061 / 0.8e1 - t12281 / 0.16e2 + t12283 / 0.8e1 - 0.3e1 / 0.16e2 * t12285 + 0.3e1 / 0.32e2 * t12287 + t484 * t640 * t490 * t2061 / 0.8e1 - 0.3e1 / 0.16e2 * t484 * t12247 - 0.9e1 / 0.16e2 * t469 * t1439 * t12263 + 0.3e1 / 0.8e1 * t484 * t3193 * t8377 - t12301 / 0.8e1 - 0.3e1 / 0.16e2 * t12303 - t484 * t12305 * t4319 / 0.16e2;
  t12321 = t1462 * t3187;
  t12323 = t3183 * t8337;
  t12326 = t866 * t4275;
  t12348 = t1455 * t3187 / 0.2e1 - 0.3e1 / 0.8e1 * t1455 * t3190 - 0.5e1 / 0.32e2 * t1470 * t3180 + 0.5e1 / 0.32e2 * t1470 * t3184 - 0.11e2 / 0.16e2 * t484 * t12305 * t4309 + t12321 / 0.4e1 + 0.11e2 / 0.16e2 * t469 * t12323 - 0.15e2 / 0.32e2 * t469 * t12326 * t8324 - 0.25e2 / 0.16e2 * t484 * t3183 * t8324 + 0.15e2 / 0.16e2 * t484 * t12326 * t8329 + 0.9e1 / 0.8e1 * t484 * t12323 + 0.11e2 / 0.16e2 * t484 * t12305 * t4331 + 0.11e2 / 0.16e2 * t484 * t12244 - 0.3e1 / 0.2e1 * t484 * t12264 + 0.3e1 / 0.8e1 * t484 * t12305 * t4414;
  t12351 = -t8258 + t8271 + t8275 - t8281 + t8286 - t8305 - t8307 + t8313 + t8316 - t8323 - t8342 + t8357 - t8359 - t8376 - t8422;
  t12366 = t631 * t631;
  t12371 = t100 * t12366;
  t12375 = t8431 + t8435 - t8437 - t8441 + t8453 - t8455 + t8468 - t1050 * t872 / 0.16e2 + t1050 * t875 / 0.16e2 + t1050 * t878 / 0.16e2 - t1050 * t868 / 0.32e2 - t246 * t3229 / 0.16e2 - t99 * t4484 * t866 * t269 / 0.32e2 - t99 * t260 * t12366 * t269 / 0.16e2 + t99 * t12371 * t301 / 0.8e1;
  t12378 = t952 * t868 / 0.128e3;
  t12383 = t952 * t878 / 0.64e2;
  t12385 = t952 * t872 / 0.64e2;
  t12390 = t952 * t875 / 0.64e2;
  t12391 = t255 * t3229;
  t12393 = t1053 * t875;
  t12395 = t1053 * t878;
  t12397 = t1053 * t868;
  t12399 = t1053 * t872;
  t12401 = t12378 + t99 * t12371 * t297 / 0.8e1 - t12383 + t12385 - t99 * t12371 * t290 / 0.8e1 - t12390 - t12391 / 0.32e2 + t12393 / 0.16e2 + t12395 / 0.16e2 - t12397 / 0.32e2 - t12399 / 0.16e2 - t8502 - t8506 + t8526 - t8541;
  t12407 = t1432 * t631;
  t12411 = t2666 * t9974;
  t12414 = t2657 * t631;
  t12421 = t644 * t265;
  t12430 = t8542 + t8543 - t8544 - t8545 - t8546 - t699 - 0.3e1 / 0.4e1 * t484 * t2645 * t9974 + t484 * t11518 * t9974 - t484 * t7348 * t12407 / 0.4e1 - 0.3e1 / 0.4e1 * t484 * t12411 + 0.3e1 / 0.8e1 * t469 * t5509 * t12414 + 0.3e1 / 0.8e1 * t469 * t5483 * t12414 + 0.3e1 / 0.4e1 * t484 * t12421 * t9974 - 0.3e1 / 0.8e1 * t469 * t12411 - t484 * t2653 * t9974 / 0.2e1;
  t12434 = my_piecewise3(t2, 0, t12224 + t12267 + t12309 + t12348 + t12351 + t12375 + t12401 + t12430);
  tv4rho2tau20 = t12434 * t3 + 0.2e1 * t3242;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t12439 = t1167 * t885;
  t12442 = t1170 * t885 / 0.128e3;
  t12445 = t1167 * t889;
  t12448 = t1170 * t889 / 0.64e2;
  t12451 = t1167 * t892;
  t12454 = t1170 * t892 / 0.64e2;
  t12457 = t1167 * t895;
  t12460 = t1170 * t895 / 0.64e2;
  t12461 = -t1164 * t885 / 0.32e2 - t12439 / 0.32e2 + t12442 - t8561 - t8563 + t8565 - t1164 * t889 / 0.16e2 - t12445 / 0.16e2 + t12448 + t1164 * t892 / 0.16e2 + t12451 / 0.16e2 - t12454 + t1164 * t895 / 0.16e2 + t12457 / 0.16e2 - t12460;
  t12462 = my_piecewise3(t51, 0, t12461);
  tv4rho2tau22 = t12462 * t3 + 0.2e1 * t3261;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t12491 = -t1553 * t3176 / 0.16e2 + t1553 * t3210 / 0.8e1 - t1553 * t3194 / 0.8e1 + t1553 * t3204 / 0.8e1 - 0.3e1 / 0.16e2 * t1553 * t3180 - t1553 * t3197 / 0.8e1 + 0.3e1 / 0.16e2 * t1553 * t3200 - t1548 * t3213 / 0.16e2 + 0.3e1 / 0.32e2 * t1548 * t3216 - 0.3e1 / 0.32e2 * t1548 * t3180 + 0.3e1 / 0.32e2 * t1548 * t3184 + t1553 * t3187 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3190 - t12205 / 0.32e2;
  t12504 = t12229 / 0.16e2 - t12231 / 0.16e2 + 0.3e1 / 0.32e2 * t12233 - 0.3e1 / 0.64e2 * t12235 + 0.3e1 / 0.64e2 * t12275 - t12281 / 0.32e2 + t12283 / 0.16e2 - 0.3e1 / 0.32e2 * t12285 + 0.3e1 / 0.64e2 * t12287 - t12301 / 0.16e2 - 0.3e1 / 0.32e2 * t12303 + t12321 / 0.8e1 + t8592 - t8598 + t8619;
  t12514 = t1124 * t878;
  t12516 = t1124 * t875;
  t12518 = t1124 * t872;
  t12520 = t1124 * t868;
  t12524 = -t8621 + t8624 - t8627 + t8639 - t8640 - t1121 * t872 / 0.16e2 + t1121 * t875 / 0.16e2 - t1121 * t868 / 0.32e2 - t345 * t3229 / 0.32e2 + t12514 / 0.32e2 + t12516 / 0.32e2 - t12518 / 0.32e2 - t12520 / 0.64e2 + t1121 * t878 / 0.16e2;
  t12530 = t12378 - t12383 + t12385 - t12390 - t12391 / 0.64e2 + t12393 / 0.32e2 + t12395 / 0.32e2 - t12397 / 0.64e2 - t12399 / 0.32e2 - t8650 - t8661 - t8668 + t8526 - t2355 - t2316;
  t12533 = my_piecewise3(t2, 0, t12491 + t12504 + t12524 + t12530);
  tv4rho2tau23 = t12533 * t3 + t3242 + t3272;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t12541 = t1589 * t3299;
  t12543 = t1589 * t3303;
  t12545 = t1578 * t3306;
  t12547 = t1578 * t3309;
  t12549 = t1589 * t3293;
  t12551 = t1589 * t3279;
  t12563 = -t1585 * t3303 / 0.8e1 - t1574 * t3306 / 0.16e2 + t1585 * t3293 / 0.8e1 + t12541 / 0.16e2 - t12543 / 0.16e2 - t12545 / 0.32e2 + 0.3e1 / 0.64e2 * t12547 + t12549 / 0.16e2 - 0.3e1 / 0.32e2 * t12551 + 0.3e1 / 0.32e2 * t1574 * t3283 + t1585 * t3286 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3289 - t1585 * t3275 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t3279;
  t12574 = t1589 * t3289;
  t12576 = t1578 * t3279;
  t12578 = t1578 * t3283;
  t12580 = t1589 * t3286;
  t12582 = t1589 * t3275;
  t12584 = t1589 * t3312;
  t12586 = t1589 * t3315;
  t12588 = 0.3e1 / 0.32e2 * t1574 * t3309 - t1585 * t3312 / 0.8e1 + 0.3e1 / 0.16e2 * t1585 * t3315 - 0.3e1 / 0.16e2 * t1585 * t3279 + t1585 * t3299 / 0.8e1 - 0.3e1 / 0.32e2 * t12574 - 0.3e1 / 0.64e2 * t12576 + 0.3e1 / 0.64e2 * t12578 + t12580 / 0.8e1 - t12582 / 0.32e2 - t12584 / 0.16e2 + 0.3e1 / 0.32e2 * t12586 - t8678 + t8696 - t8698;
  t12596 = t370 * t3320;
  t12598 = t1227 * t889;
  t12600 = t1227 * t892;
  t12602 = t1227 * t895;
  t12604 = t1227 * t885;
  t12608 = t8707 + t8721 - t8723 - t8731 + t8745 - t1224 * t885 / 0.32e2 - t367 * t3320 / 0.32e2 - t1224 * t889 / 0.16e2 - t12596 / 0.64e2 - t12598 / 0.32e2 + t12600 / 0.32e2 + t12602 / 0.32e2 - t12604 / 0.64e2 + t1224 * t892 / 0.16e2;
  t12615 = t1224 * t895 / 0.16e2 - t12454 + t12457 / 0.32e2 - t12460 - t12439 / 0.64e2 + t12442 - t12445 / 0.32e2 + t12448 + t12451 / 0.32e2 - t8757 - t8770 - t8773 + t8565 - t2334 - t2336;
  t12618 = my_piecewise3(t51, 0, t12563 + t12588 + t12608 + t12615);
  tv4rho2tau25 = t12618 * t3 + t3261 + t3333;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t12633 = -t1196 * t868 / 0.32e2 - t12520 / 0.32e2 + t12378 - t8786 - t8787 + t8526 - t1196 * t872 / 0.16e2 - t12518 / 0.16e2 + t12385 + t1196 * t875 / 0.16e2 + t12516 / 0.16e2 - t12390 + t1196 * t878 / 0.16e2 + t12514 / 0.16e2 - t12383;
  t12634 = my_piecewise3(t2, 0, t12633);
  tv4rho2tau26 = t12634 * t3 + 0.2e1 * t3272;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t12647 = t3278 * t8963;
  t12650 = t6239 * t883;
  t12677 = -t1667 * t3275 / 0.8e1 + t1667 * t3293 / 0.4e1 + t534 * t679 * t540 * t2223 / 0.8e1 - 0.3e1 / 0.8e1 * t1667 * t3279 - 0.3e1 / 0.16e2 * t534 * t12647 - 0.9e1 / 0.16e2 * t519 * t1640 * t12650 + t1667 * t3299 / 0.4e1 + t534 * t683 * t546 * t2223 / 0.8e1 - t1667 * t3303 / 0.4e1 - 0.3e1 / 0.16e2 * t534 * t3282 * t9018 - 0.3e1 / 0.32e2 * t519 * t12647 + 0.3e1 / 0.32e2 * t519 * t3282 * t5194 + t534 * t3278 * t5194 / 0.4e1 - t534 * t883 * t438 * t1337 / 0.16e2;
  t12678 = t1619 * t12650;
  t12694 = t6307 * t883;
  t12717 = -0.7e1 / 0.32e2 * t519 * t12678 - t534 * t683 * t8110 / 0.8e1 + 0.3e1 / 0.8e1 * t1667 * t3315 + 0.3e1 / 0.16e2 * t534 * t3302 * t5164 + 0.3e1 / 0.16e2 * t1670 * t3283 - t534 * t3302 * t5216 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t1619 * t12694 - t1670 * t3306 / 0.8e1 - t1674 * t3306 / 0.8e1 - t519 * t679 * t8110 / 0.16e2 + 0.3e1 / 0.16e2 * t1670 * t3309 + 0.5e1 / 0.32e2 * t1674 * t3309 + 0.3e1 / 0.32e2 * t519 * t3278 * t5164 - t1667 * t3312 / 0.4e1 + 0.3e1 / 0.8e1 * t534 * t3302 * t8915;
  t12719 = t3278 * t8843;
  t12724 = t3282 * t8866;
  t12729 = t883 * t416;
  t12752 = t883 * t5342;
  t12759 = 0.11e2 / 0.16e2 * t534 * t12719 - 0.3e1 / 0.2e1 * t534 * t12678 + 0.9e1 / 0.8e1 * t534 * t12724 + 0.9e1 / 0.16e2 * t519 * t12719 - t534 * t12729 * t5235 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t12729 * t5389 + 0.3e1 / 0.8e1 * t534 * t12729 * t5411 + t1667 * t3286 / 0.2e1 - 0.3e1 / 0.8e1 * t1667 * t3289 - 0.3e1 / 0.16e2 * t1670 * t3279 - 0.5e1 / 0.32e2 * t1674 * t3279 + 0.5e1 / 0.32e2 * t1674 * t3283 - 0.25e2 / 0.16e2 * t534 * t3282 * t8839 + 0.15e2 / 0.16e2 * t534 * t12752 * t8890 + 0.11e2 / 0.16e2 * t534 * t12729 * t5254;
  t12778 = 0.11e2 / 0.16e2 * t519 * t12724 - 0.15e2 / 0.32e2 * t519 * t12752 * t8839 + t12541 / 0.8e1 - t12543 / 0.8e1 - t12545 / 0.16e2 + 0.3e1 / 0.32e2 * t12547 + t12549 / 0.8e1 - 0.3e1 / 0.16e2 * t12551 - 0.3e1 / 0.16e2 * t12574 - 0.3e1 / 0.32e2 * t12576 + 0.3e1 / 0.32e2 * t12578 + t12580 / 0.4e1 - t12582 / 0.16e2 - t12584 / 0.8e1 + 0.3e1 / 0.16e2 * t12586;
  t12781 = t8838 - t8856 - t8858 + t8862 - t8875 + t8888 + t8898 - t8910 - t8914 - t8921 - t8923 + t8972 - t8982 + t9003 + t9007;
  t12796 = t670 * t670;
  t12801 = t157 * t12796;
  t12805 = -t9009 - t9012 + t9017 - t9024 + t9033 - t9034 + t9038 - t156 * t5302 * t883 * t424 / 0.32e2 - t1323 * t889 / 0.16e2 + t1323 * t892 / 0.16e2 + t1323 * t895 / 0.16e2 - t1323 * t885 / 0.32e2 - t409 * t3320 / 0.16e2 - t156 * t415 * t12796 * t424 / 0.16e2 - t156 * t12801 * t445 / 0.8e1;
  t12821 = t156 * t12801 * t452 / 0.8e1 + t156 * t12801 * t456 / 0.8e1 - t12596 / 0.32e2 - t12598 / 0.16e2 + t12600 / 0.16e2 + t12602 / 0.16e2 - t12604 / 0.32e2 - t12454 - t12460 + t12442 + t12448 - t9047 - t9073 + t8565 - t534 * t2778 * t10697 / 0.2e1;
  t12822 = t2762 * t670;
  t12826 = t3772 * t10697;
  t12834 = t675 * t75;
  t12846 = 0.3e1 / 0.8e1 * t519 * t6181 * t12822 - 0.3e1 / 0.4e1 * t534 * t12826 + 0.3e1 / 0.8e1 * t519 * t6189 * t12822 - 0.3e1 / 0.8e1 * t519 * t12826 + 0.3e1 / 0.4e1 * t534 * t12834 * t8090 - t534 * t12834 * t7985 / 0.4e1 + t534 * t12083 * t10697 - 0.3e1 / 0.4e1 * t534 * t2758 * t10697 - t9080 + t9081 + t9082 - t9083 - t9084 - t9085 - t721;
  t12850 = my_piecewise3(t51, 0, t12677 + t12717 + t12759 + t12778 + t12781 + t12805 + t12821 + t12846);
  tv4rho2tau28 = t12850 * t3 + 0.2e1 * t3333;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t12852 = t3335 * t111;
  t12862 = t1470 * t3340;
  t12865 = t469 * t1507 * t2297;
  t12870 = t1455 * t3379;
  t12876 = t1455 * t3367;
  t12881 = t484 * t695 * t478 * t290;
  t12886 = t1455 * t3347;
  t12889 = t484 * t2293 * t2278;
  t12894 = t2255 * t8229;
  t12897 = t1516 * t478;
  t12902 = t5559 * t111;
  t12910 = t1458 * t3340;
  t12914 = -0.3e1 / 0.16e2 * t12881 + 0.9e1 / 0.32e2 * t469 * t2255 * t5591 + 0.3e1 / 0.16e2 * t12886 + 0.3e1 / 0.16e2 * t12889 + 0.9e1 / 0.16e2 * t484 * t2238 * t5591 - 0.9e1 / 0.16e2 * t484 * t12894 - 0.3e1 / 0.8e1 * t484 * t2238 * t12897 + 0.3e1 / 0.8e1 * t484 * t3335 * t43 * t12902 - 0.11e2 / 0.32e2 * t469 * t470 * t5733 * t3335 - 0.3e1 / 0.32e2 * t12910 - t3458 * t2266 / 0.16e2;
  t12918 = t3335 * t263;
  t12919 = t5643 * t111;
  t12923 = t3335 * t997;
  t12924 = t12923 * t12919;
  t12927 = t3335 * t4275;
  t12928 = t5651 * t111;
  t12932 = t1462 * t3379;
  t12933 = 0.3e1 / 0.32e2 * t12932;
  t12934 = t1466 * t3340;
  t12935 = 0.3e1 / 0.64e2 * t12934;
  t12936 = t1462 * t3347;
  t12937 = 0.3e1 / 0.32e2 * t12936;
  t12938 = t1462 * t3367;
  t12939 = 0.3e1 / 0.32e2 * t12938;
  t12941 = t484 * t2251 * t2272;
  t12946 = t1450 * t478;
  t12950 = t3458 * t2269 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t12918 * t12919 + 0.11e2 / 0.16e2 * t469 * t12924 - 0.15e2 / 0.32e2 * t469 * t12927 * t12928 + t12933 - t12935 + t12937 - t12939 + 0.3e1 / 0.16e2 * t12941 + 0.3e1 / 0.4e1 * t484 * t2255 * t5542 - 0.9e1 / 0.16e2 * t484 * t2260 * t12946;
  t12954 = t5635 * t3335;
  t12955 = t470 * t12954;
  t12963 = t5610 * t111;
  t12967 = t5627 * t111;
  t12968 = t12918 * t12967;
  t12973 = t5635 * t111;
  t12983 = -0.3e1 / 0.16e2 * t484 * t2238 * t8229 - 0.7e1 / 0.32e2 * t469 * t12955 - 0.9e1 / 0.32e2 * t469 * t12894 - 0.25e2 / 0.16e2 * t484 * t12923 * t12928 + 0.15e2 / 0.16e2 * t484 * t12927 * t12963 + 0.11e2 / 0.16e2 * t484 * t12968 + 0.9e1 / 0.16e2 * t469 * t12968 - 0.9e1 / 0.16e2 * t469 * t12923 * t12973 - 0.3e1 / 0.2e1 * t484 * t12955 + 0.9e1 / 0.8e1 * t484 * t12924 + t246 * t3382 / 0.4e1;
  t12993 = t260 * t111 * t263;
  t13007 = t268 * t111;
  t13008 = t266 * t13007;
  t13011 = t4456 * t111;
  t13012 = t268 * t183;
  t13013 = t266 * t13012;
  t13019 = t111 * t43;
  t13020 = t13019 * t471;
  t13023 = t296 * t13007;
  t13026 = t114 * t13007;
  t13041 = t12993 * t472 / 0.4e1 + t480 / 0.2e1 + t184 * t111 * t290 / 0.2e1 - t184 * t263 * t491 / 0.2e1 - t184 * t43 * t497 / 0.2e1 - t4452 * t183 * t13008 / 0.2e1 + t13011 * t13013 / 0.2e1 + t1023 * t478 * t116 / 0.2e1 + t3356 * t13020 / 0.2e1 - t3356 * t13023 / 0.2e1 - t3356 * t13026 / 0.2e1 - t4470 * t183 * t116 / 0.2e1 - t1026 * t478 * t116 / 0.2e1 - t3358 * t13020 / 0.2e1 + t3358 * t13023 / 0.2e1 + t3358 * t13026 / 0.2e1;
  t13050 = t1030 * t3335;
  t13070 = t255 * t3382 / 0.8e1;
  t13072 = 0.3e1 / 0.32e2 * t255 * t3385;
  t13074 = t255 * t3370 / 0.32e2;
  t13076 = 0.3e1 / 0.64e2 * t255 * t3373;
  t13078 = 0.3e1 / 0.64e2 * t255 * t3376;
  t13080 = t255 * t3363 / 0.64e2;
  t13082 = 0.3e1 / 0.64e2 * t255 * t3344;
  t13084 = 0.3e1 / 0.32e2 * t255 * t3350;
  t13085 = 0.3e1 / 0.32e2 * t246 * t3344 + 0.3e1 / 0.32e2 * t99 * t13050 * t964 + 0.3e1 / 0.16e2 * t246 * t3350 + t13070 - t13072 - t13074 - t13076 + t13078 - t13080 + t13082 + t13084;
  t13088 = 0.3e1 / 0.32e2 * t255 * t3353;
  t13090 = t255 * t3337 / 0.16e2;
  t13093 = t484 * t3366 * t263 * t2256;
  t13097 = t484 * t8320 * t1011 * t2465;
  t13099 = t958 * t695;
  t13100 = t13099 * t111;
  t13101 = t8241 * t13100;
  t13102 = t469 * t13101;
  t13105 = t469 * t2475 * t13100;
  t13107 = t484 * t13101;
  t13111 = t484 * t2243 * t43 * t1523;
  t13113 = -t13088 - t13090 + 0.3e1 / 0.4e1 * t13093 - 0.9e1 / 0.16e2 * t13097 - 0.9e1 / 0.32e2 * t13102 + 0.9e1 / 0.32e2 * t13105 - 0.9e1 / 0.16e2 * t13107 + 0.9e1 / 0.16e2 * t13111 - t3342 + t3349 - t3369;
  t13116 = t484 * t3366 * t111 * t986;
  t13119 = t469 * t2453 * t13100;
  t13123 = t484 * t2293 * t113 * t2465;
  t13125 = t3381 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - 0.3e1 / 0.16e2 * t13116 + 0.9e1 / 0.32e2 * t13119 - 0.3e1 / 0.8e1 * t13123;
  t13129 = my_piecewise3(t2, 0, t13125 + t13113 + t13085 + t12983 + t12950 + t12914 - 0.3e1 / 0.16e2 * t12876 + 0.3e1 / 0.16e2 * t12870 - 0.3e1 / 0.32e2 * t12865 - 0.3e1 / 0.32e2 * t12862 - t99 * t13041 * t690 * t269 / 0.32e2 - 0.11e2 / 0.16e2 * t484 * t12852 * t4309 + 0.3e1 / 0.8e1 * t484 * t12852 * t4414 - t484 * t12852 * t4319 / 0.16e2 + 0.9e1 / 0.32e2 * t469 * t2260 * t5542 - 0.3e1 / 0.32e2 * t99 * t13050 * t972 + 0.3e1 / 0.32e2 * t99 * t13050 * t1001 - t246 * t3370 / 0.16e2 - 0.3e1 / 0.32e2 * t246 * t3373 + 0.3e1 / 0.32e2 * t246 * t3376 - t246 * t3337 / 0.8e1 - 0.3e1 / 0.16e2 * t246 * t3385 - 0.3e1 / 0.16e2 * t246 * t3353 - t246 * t3363 / 0.32e2 - t3458 * t2286 / 0.16e2 + t3458 * t2290 / 0.16e2);
  tv4rhosigma30 = t13129 * t3 + t3389;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t13131 = t1585 * t3434;
  t13133 = t1585 * t3422;
  t13135 = t1574 * t3398;
  t13137 = t1585 * t3405;
  t13139 = t1589 * t3422;
  t13140 = 0.3e1 / 0.32e2 * t13139;
  t13141 = t1589 * t3434;
  t13142 = 0.3e1 / 0.32e2 * t13141;
  t13143 = t1578 * t3398;
  t13144 = 0.3e1 / 0.64e2 * t13143;
  t13145 = t1589 * t3405;
  t13146 = 0.3e1 / 0.32e2 * t13145;
  t13148 = t370 * t3418 / 0.64e2;
  t13150 = t370 * t3425 / 0.32e2;
  t13152 = 0.3e1 / 0.64e2 * t370 * t3428;
  t13154 = 0.3e1 / 0.64e2 * t370 * t3402;
  t13156 = 0.3e1 / 0.32e2 * t370 * t3408;
  t13158 = 0.3e1 / 0.32e2 * t370 * t3392;
  t13160 = t370 * t3395 / 0.16e2;
  t13161 = 0.3e1 / 0.16e2 * t13131 - 0.3e1 / 0.16e2 * t13133 - 0.3e1 / 0.32e2 * t13135 + 0.3e1 / 0.16e2 * t13137 - t13140 + t13142 - t13144 + t13146 - t13148 - t13150 - t13152 + t13154 + t13156 - t13158 - t13160;
  t13183 = 0.3e1 / 0.32e2 * t370 * t3440;
  t13185 = 0.3e1 / 0.64e2 * t370 * t3431;
  t13187 = t370 * t3437 / 0.8e1;
  t13188 = -0.3e1 / 0.32e2 * t367 * t3428 + 0.3e1 / 0.32e2 * t367 * t3431 + t367 * t3437 / 0.4e1 - 0.3e1 / 0.16e2 * t367 * t3440 - t367 * t3395 / 0.8e1 + 0.3e1 / 0.32e2 * t367 * t3402 + 0.3e1 / 0.16e2 * t367 * t3408 - t367 * t3418 / 0.32e2 - t367 * t3425 / 0.16e2 - 0.3e1 / 0.16e2 * t367 * t3392 - t13183 + t13185 + t13187 - t2334 - t2336;
  t13190 = my_piecewise3(t51, 0, t13161 + t13188);
  tv4rhosigma39 = t13190 * t3 + t3444;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t13192 = t1553 * t3379;
  t13194 = t1553 * t3367;
  t13196 = t1553 * t3347;
  t13198 = t1548 * t3340;
  t13214 = 0.3e1 / 0.16e2 * t13192 - 0.3e1 / 0.16e2 * t13194 + 0.3e1 / 0.16e2 * t13196 - 0.3e1 / 0.32e2 * t13198 + t12933 - t12935 + t12937 - t12939 - 0.3e1 / 0.16e2 * t345 * t3385 - 0.3e1 / 0.16e2 * t345 * t3353 - t345 * t3363 / 0.32e2 - t345 * t3370 / 0.16e2 - 0.3e1 / 0.32e2 * t345 * t3373 + 0.3e1 / 0.32e2 * t345 * t3376 + t345 * t3382 / 0.4e1;
  t13221 = -t345 * t3337 / 0.8e1 + 0.3e1 / 0.32e2 * t345 * t3344 + 0.3e1 / 0.16e2 * t345 * t3350 + t13070 - t13072 - t13074 - t13076 + t13078 - t13080 + t13082 + t13084 - t13088 - t13090 - t2355 - t2316;
  t13223 = my_piecewise3(t2, 0, t13214 + t13221);
  tv4rhosigma310 = t13223 * t3 + t3389;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t13225 = t3390 * t168;
  t13242 = t1667 * t3422;
  t13246 = t534 * t717 * t528 * t445;
  t13251 = t1667 * t3405;
  t13255 = t534 * t2423 * t2411;
  t13260 = t6239 * t3390;
  t13264 = t1633 * t528;
  t13269 = t6299 * t168;
  t13277 = t1670 * t3398;
  t13279 = t1674 * t3398;
  t13282 = t519 * t1611 * t2427;
  t13284 = t2382 * t8815;
  t13287 = t3390 * t418;
  t13288 = t6233 * t168;
  t13289 = t13287 * t13288;
  t13292 = 0.3e1 / 0.16e2 * t13255 + 0.9e1 / 0.16e2 * t534 * t2373 * t6369 - 0.9e1 / 0.16e2 * t519 * t6188 * t13260 - 0.3e1 / 0.8e1 * t534 * t2373 * t13264 + 0.3e1 / 0.8e1 * t534 * t3390 * t75 * t13269 - 0.11e2 / 0.32e2 * t519 * t520 * t6307 * t3390 - 0.3e1 / 0.32e2 * t13277 - 0.3e1 / 0.32e2 * t13279 - 0.3e1 / 0.32e2 * t13282 - 0.9e1 / 0.16e2 * t534 * t13284 + 0.11e2 / 0.16e2 * t534 * t13289;
  t13298 = t6247 * t168;
  t13302 = t3390 * t1348;
  t13303 = t13302 * t13298;
  t13306 = t3390 * t5342;
  t13307 = t6257 * t168;
  t13314 = t6227 * t168;
  t13318 = t6239 * t168;
  t13319 = t13287 * t13318;
  t13324 = t1650 * t528;
  t13328 = t1667 * t3434;
  t13330 = -t3513 * t2384 / 0.16e2 + t3513 * t2401 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t13287 * t13298 + 0.11e2 / 0.16e2 * t519 * t13303 - 0.15e2 / 0.32e2 * t519 * t13306 * t13307 - 0.25e2 / 0.16e2 * t534 * t13302 * t13307 + 0.15e2 / 0.16e2 * t534 * t13306 * t13314 - 0.3e1 / 0.2e1 * t534 * t13319 + 0.9e1 / 0.8e1 * t534 * t13303 - 0.9e1 / 0.16e2 * t534 * t2365 * t13324 + 0.3e1 / 0.16e2 * t13328;
  t13332 = t534 * t2404 * t2378;
  t13348 = 0.3e1 / 0.16e2 * t13332 + 0.3e1 / 0.4e1 * t534 * t2382 * t6264 - 0.3e1 / 0.16e2 * t534 * t2373 * t8815 - 0.7e1 / 0.32e2 * t519 * t13319 - 0.9e1 / 0.32e2 * t519 * t13284 + 0.9e1 / 0.16e2 * t519 * t13289 - t13140 + t13142 - t13144 + t13146 - t409 * t3425 / 0.16e2;
  t13353 = t1303 * t3390;
  t13379 = t415 * t168 * t418;
  t13393 = t423 * t168;
  t13394 = t421 * t13393;
  t13397 = t5274 * t168;
  t13398 = t423 * t191;
  t13399 = t421 * t13398;
  t13406 = t168 * t75 * t521;
  t13409 = t451 * t13393;
  t13412 = t171 * t13393;
  t13427 = t13379 * t522 / 0.4e1 + t530 / 0.2e1 + t192 * t168 * t445 / 0.2e1 - t192 * t418 * t541 / 0.2e1 - t192 * t75 * t547 / 0.2e1 - t5270 * t191 * t13394 / 0.2e1 + t13397 * t13399 / 0.2e1 + t1296 * t528 * t173 / 0.2e1 + t3411 * t13406 / 0.2e1 - t3411 * t13409 / 0.2e1 - t3411 * t13412 / 0.2e1 - t5288 * t191 * t173 / 0.2e1 - t1299 * t528 * t173 / 0.2e1 - t3413 * t13406 / 0.2e1 + t3413 * t13409 / 0.2e1 + t3413 * t13412 / 0.2e1;
  t13434 = -t409 * t3418 / 0.32e2 - t156 * t13427 * t712 * t424 / 0.32e2 - 0.3e1 / 0.16e2 * t409 * t3392 - t13148 - t13150 - t13152 + t13154 + t13156 - t13158 - t13160 - t13183;
  t13436 = t13185 + t13187 - t3424 + t3436 - t3400 + t3407 - t2393 + t2407 + t2426 - t2430 - t2444;
  t13437 = t1336 * t717;
  t13438 = t13437 * t168;
  t13440 = t519 * t2590 * t13438;
  t13444 = t534 * t2423 * t170 * t2568;
  t13448 = t534 * t8907 * t1362 * t2568;
  t13450 = t2572 * t13438;
  t13451 = t519 * t13450;
  t13454 = t519 * t2578 * t13438;
  t13456 = t534 * t13450;
  t13460 = t534 * t3421 * t418 * t2400;
  t13464 = t534 * t2390 * t75 * t1621;
  t13468 = t534 * t3421 * t168 * t1337;
  t13470 = -t2336 - t721 + 0.9e1 / 0.32e2 * t13440 - 0.3e1 / 0.8e1 * t13444 - 0.9e1 / 0.16e2 * t13448 - 0.9e1 / 0.32e2 * t13451 + 0.9e1 / 0.32e2 * t13454 - 0.9e1 / 0.16e2 * t13456 + 0.3e1 / 0.4e1 * t13460 + 0.9e1 / 0.16e2 * t13464 - 0.3e1 / 0.16e2 * t13468;
  t13474 = my_piecewise3(t51, 0, t13348 + t13330 + t13292 + 0.3e1 / 0.16e2 * t13251 - 0.3e1 / 0.16e2 * t13246 - 0.3e1 / 0.16e2 * t13242 + t13434 - 0.3e1 / 0.32e2 * t409 * t3428 + 0.3e1 / 0.32e2 * t409 * t3431 + t409 * t3437 / 0.4e1 - 0.3e1 / 0.16e2 * t409 * t3440 - t409 * t3395 / 0.8e1 + 0.3e1 / 0.32e2 * t409 * t3402 + 0.3e1 / 0.16e2 * t409 * t3408 - t3513 * t2387 / 0.16e2 + t3513 * t2420 / 0.16e2 + t13470 - 0.11e2 / 0.16e2 * t534 * t13225 * t5389 + 0.3e1 / 0.8e1 * t534 * t13225 * t5411 - t534 * t13225 * t5235 / 0.16e2 + 0.9e1 / 0.32e2 * t519 * t2365 * t6264 + 0.9e1 / 0.32e2 * t519 * t2382 * t6369 - 0.3e1 / 0.32e2 * t156 * t13353 * t1344 + 0.3e1 / 0.32e2 * t156 * t13353 * t1352 + 0.3e1 / 0.32e2 * t156 * t13353 * t1382 + t13436);
  tv4rhosigma319 = t13474 * t3 + t3444;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t13476 = t1455 * t3454;
  t13477 = t13476 / 0.16e2;
  t13479 = t484 * t1775 * t3453;
  t13480 = t13479 / 0.16e2;
  t13481 = t91 * t3457;
  t13485 = t23 * t26 * t13041;
  t13492 = t1455 * t3446;
  t13493 = t13492 / 0.16e2;
  t13495 = t484 * t1752 * t3445;
  t13496 = t13495 / 0.16e2;
  t13504 = t563 * t690;
  t13512 = t2255 * t6489;
  t13515 = t13477 + t13480 - t13481 * t734 / 0.32e2 - t13485 * t734 / 0.32e2 - t3458 * t2526 / 0.32e2 - t3458 * t2529 / 0.32e2 + t13493 + t13496 - 0.3e1 / 0.16e2 * t1455 * t3495 - 0.3e1 / 0.16e2 * t484 * t6541 * t3494 - t1455 * t3482 / 0.16e2 - t484 * t13504 * t986 / 0.16e2 - 0.3e1 / 0.32e2 * t1458 * t3467 - 0.3e1 / 0.32e2 * t1470 * t3467 - 0.3e1 / 0.32e2 * t469 * t13512;
  t13535 = t1458 * t3461;
  t13536 = t13535 / 0.32e2;
  t13537 = t1470 * t3461;
  t13538 = t13537 / 0.32e2;
  t13540 = t469 * t2251 * t1748;
  t13541 = t13540 / 0.32e2;
  t13544 = t1455 * t3450;
  t13545 = t13544 / 0.16e2;
  t13548 = t484 * t563 * t695 * t290;
  t13549 = t13548 / 0.16e2;
  t13551 = t1462 * t3491 / 0.8e1;
  t13552 = -0.3e1 / 0.16e2 * t484 * t13512 - t1455 * t3471 / 0.8e1 - t484 * t1752 * t3470 / 0.8e1 + 0.3e1 / 0.32e2 * t1458 * t3474 + 0.3e1 / 0.32e2 * t1470 * t3474 + 0.3e1 / 0.32e2 * t469 * t2255 * t6720 + 0.3e1 / 0.16e2 * t1455 * t3478 + 0.3e1 / 0.16e2 * t484 * t13504 * t968 - t13536 - t13538 - t13541 - 0.3e1 / 0.16e2 * t1455 * t3467 - t13545 - t13549 + t13551;
  t13555 = t1462 * t3482 / 0.32e2;
  t13557 = 0.3e1 / 0.64e2 * t1466 * t3474;
  t13559 = 0.3e1 / 0.32e2 * t1462 * t3478;
  t13561 = 0.3e1 / 0.32e2 * t1462 * t3467;
  t13563 = t1462 * t3471 / 0.16e2;
  t13565 = t23 * t95 * t3361;
  t13567 = t13565 * t734 / 0.64e2;
  t13568 = t1466 * t3461;
  t13569 = t13568 / 0.64e2;
  t13570 = t1462 * t3446;
  t13571 = t13570 / 0.32e2;
  t13572 = t1462 * t3450;
  t13573 = t13572 / 0.32e2;
  t13574 = t1462 * t3454;
  t13575 = t13574 / 0.32e2;
  t13588 = -t13555 + t13557 + t13559 - t13561 - t13563 - t13567 - t13569 + t13571 - t13573 + t13575 + 0.3e1 / 0.32e2 * t1458 * t3488 + 0.3e1 / 0.32e2 * t1470 * t3488 + 0.3e1 / 0.32e2 * t469 * t2260 * t6493 + t1455 * t3491 / 0.4e1 + t484 * t13504 * t1006 / 0.4e1;
  t13590 = 0.3e1 / 0.32e2 * t1462 * t3495;
  t13592 = 0.3e1 / 0.64e2 * t1466 * t3467;
  t13594 = 0.3e1 / 0.64e2 * t1466 * t3488;
  t13595 = t12862 / 0.16e2;
  t13596 = t12865 / 0.16e2;
  t13597 = t12870 / 0.8e1;
  t13598 = t12876 / 0.8e1;
  t13599 = t12881 / 0.8e1;
  t13600 = t12886 / 0.8e1;
  t13601 = t12889 / 0.8e1;
  t13602 = t12910 / 0.16e2;
  t13603 = t12932 / 0.16e2;
  t13604 = t12934 / 0.32e2;
  t13605 = t12936 / 0.16e2;
  t13606 = t12938 / 0.16e2;
  t13607 = t12941 / 0.8e1;
  t13608 = -t13590 - t13592 + t13594 - t13595 - t13596 + t13597 - t13598 - t13599 + t13600 + t13601 - t13602 + t13603 - t13604 + t13605 - t13606 + t13607;
  t13611 = t2260 * t1011;
  t13612 = t9093 * t111;
  t13613 = t13611 * t13612;
  t13616 = t8328 * t4344;
  t13625 = t4280 * t690 * t111;
  t13629 = t13093 / 0.2e1;
  t13630 = 0.3e1 / 0.8e1 * t13097;
  t13631 = 0.3e1 / 0.16e2 * t13102;
  t13632 = 0.3e1 / 0.16e2 * t13105;
  t13633 = 0.3e1 / 0.8e1 * t13107;
  t13634 = 0.3e1 / 0.8e1 * t13111;
  t13635 = 0.11e2 / 0.16e2 * t469 * t13613 - 0.15e2 / 0.32e2 * t469 * t13616 * t13612 - 0.25e2 / 0.16e2 * t484 * t3477 * t997 * t12928 + 0.15e2 / 0.16e2 * t484 * t9129 * t13625 + t13629 - t13630 - t13631 + t13632 - t13633 + t13634 + t3448 - t3452 + t3456 - t3463 - t3464;
  t13636 = t2454 * t695;
  t13637 = t5488 * t13636;
  t13638 = t469 * t13637;
  t13639 = 0.3e1 / 0.32e2 * t13638;
  t13646 = t9093 * t690;
  t13653 = t3465 - t3481 + t3485 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - t13639 + 0.3e1 / 0.8e1 * t484 * t2469 * t13625 - t484 * t2469 * t8248 / 0.4e1 - 0.11e2 / 0.32e2 * t469 * t5483 * t13646 + 0.3e1 / 0.16e2 * t469 * t2453 * t9198;
  t13658 = t2463 * t13625;
  t13661 = t2463 * t8248;
  t13668 = t469 * t5509 * t13636;
  t13669 = 0.3e1 / 0.32e2 * t13668;
  t13673 = t484 * t2469 * t13100;
  t13674 = t13673 / 0.8e1;
  t13676 = t469 * t5483 * t13636;
  t13677 = 0.3e1 / 0.32e2 * t13676;
  t13679 = t484 * t6469 * t8432;
  t13680 = 0.3e1 / 0.16e2 * t13679;
  t13683 = t484 * t3449 * t111 * t986;
  t13684 = t13683 / 0.16e2;
  t13688 = t3477 * t111;
  t13700 = 0.3e1 / 0.8e1 * t484 * t2459 * t5591 + 0.11e2 / 0.16e2 * t484 * t13658 - 0.3e1 / 0.8e1 * t484 * t13661 - 0.9e1 / 0.16e2 * t469 * t5509 * t13646 + t13669 + t3458 * t2456 / 0.16e2 - t13674 + t13677 + t13680 - t13684 - 0.11e2 / 0.16e2 * t484 * t6469 * t8403 + 0.3e1 / 0.8e1 * t484 * t13688 * t4414 - t484 * t13688 * t4319 / 0.16e2 - 0.3e1 / 0.8e1 * t484 * t2483 * t8248 - 0.3e1 / 0.16e2 * t469 * t13661;
  t13711 = t470 * t999 * t13646;
  t13715 = t484 * t2483 * t13100;
  t13716 = 0.3e1 / 0.16e2 * t13715;
  t13731 = t484 * t13637;
  t13732 = 0.3e1 / 0.16e2 * t13731;
  t13733 = t3449 * t263;
  t13735 = t484 * t13733 * t2256;
  t13736 = t13735 / 0.4e1;
  t13737 = t13116 / 0.8e1;
  t13738 = 0.3e1 / 0.16e2 * t13119;
  t13739 = t13123 / 0.4e1;
  t13740 = 0.3e1 / 0.16e2 * t469 * t2475 * t9198 + t484 * t2479 * t5542 / 0.2e1 - t484 * t2459 * t8229 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t13711 - t13716 - t3458 * t2466 / 0.16e2 + t3458 * t2476 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t13711 + 0.9e1 / 0.8e1 * t484 * t13613 + 0.9e1 / 0.16e2 * t469 * t13658 + 0.11e2 / 0.16e2 * t484 * t3477 * t263 * t12919 - t13732 + t13736 - t13737 + t13738 - t13739;
  t13744 = my_piecewise3(t2, 0, t13515 + t13552 + t13588 + t13608 + t13635 + t13653 + t13700 + t13740);
  tv4rhosigma2lapl0 = t13744 * t3 + t3499;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t13764 = t128 * t3512;
  t13767 = t1574 * t3516;
  t13768 = t13767 / 0.32e2;
  t13769 = t1585 * t3501;
  t13770 = t13769 / 0.16e2;
  t13771 = t1585 * t3505;
  t13772 = t13771 / 0.16e2;
  t13773 = t1585 * t3509;
  t13774 = t13773 / 0.16e2;
  t13776 = t1589 * t3546 / 0.8e1;
  t13778 = 0.3e1 / 0.32e2 * t1589 * t3550;
  t13780 = t1589 * t3538 / 0.32e2;
  t13782 = 0.3e1 / 0.64e2 * t1578 * t3522;
  t13784 = 0.3e1 / 0.64e2 * t1578 * t3543;
  t13785 = -0.3e1 / 0.16e2 * t1585 * t3550 - t1585 * t3538 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t3522 + 0.3e1 / 0.32e2 * t1574 * t3543 + t1585 * t3546 / 0.4e1 + 0.3e1 / 0.16e2 * t1585 * t3533 - 0.3e1 / 0.16e2 * t1585 * t3522 - t1585 * t3526 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t3529 - t13764 * t751 / 0.32e2 - t13768 - t13770 + t13772 + t13774 + t13776 - t13778 - t13780 - t13782 + t13784;
  t13787 = 0.3e1 / 0.64e2 * t1578 * t3529;
  t13789 = 0.3e1 / 0.32e2 * t1589 * t3533;
  t13791 = 0.3e1 / 0.32e2 * t1589 * t3522;
  t13793 = t1589 * t3526 / 0.16e2;
  t13794 = t1589 * t3501;
  t13795 = t13794 / 0.32e2;
  t13796 = t1589 * t3505;
  t13797 = t13796 / 0.32e2;
  t13798 = t1589 * t3509;
  t13799 = t13798 / 0.32e2;
  t13801 = t60 * t95 * t3416;
  t13803 = t13801 * t751 / 0.64e2;
  t13804 = t1578 * t3516;
  t13805 = t13804 / 0.64e2;
  t13806 = t13131 / 0.8e1;
  t13807 = t13133 / 0.8e1;
  t13808 = t13135 / 0.16e2;
  t13809 = t13137 / 0.8e1;
  t13810 = t13139 / 0.16e2;
  t13811 = t13141 / 0.16e2;
  t13812 = t13143 / 0.32e2;
  t13813 = t13145 / 0.16e2;
  t13814 = t13787 + t13789 - t13791 - t13793 - t13795 + t13797 + t13799 - t13803 - t13805 + t13806 - t13807 - t13808 + t13809 - t13810 + t13811 - t13812 + t13813 - t2334 - t2336;
  t13816 = my_piecewise3(t51, 0, t13785 + t13814);
  tv4rhosigma2lapl11 = t13816 * t3 + t3554;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t13832 = t1548 * t3461;
  t13833 = t13832 / 0.32e2;
  t13834 = t1553 * t3450;
  t13835 = t13834 / 0.16e2;
  t13836 = t1553 * t3454;
  t13837 = t13836 / 0.16e2;
  t13838 = t143 * t3457;
  t13841 = t1553 * t3446;
  t13842 = t13841 / 0.16e2;
  t13847 = -0.3e1 / 0.16e2 * t1553 * t3495 - t1553 * t3482 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t3467 - 0.3e1 / 0.16e2 * t1553 * t3467 - t1553 * t3471 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t3474 + 0.3e1 / 0.16e2 * t1553 * t3478 - t13833 - t13835 + t13837 - t13838 * t734 / 0.32e2 + t13842 + 0.3e1 / 0.32e2 * t1548 * t3488 + t1553 * t3491 / 0.4e1 + t13551 - t13555 + t13557 + t13559 - t13561;
  t13848 = t13192 / 0.8e1;
  t13849 = t13194 / 0.8e1;
  t13850 = t13196 / 0.8e1;
  t13851 = t13198 / 0.16e2;
  t13852 = -t13563 - t13567 - t13569 + t13571 - t13573 + t13575 - t13590 - t13592 + t13594 + t13848 - t13849 + t13850 - t13851 + t13603 - t13604 + t13605 - t13606 - t2355 - t2316;
  t13854 = my_piecewise3(t2, 0, t13847 + t13852);
  tv4rhosigma2lapl12 = t13854 * t3 + t3499;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t13856 = t1667 * t3505;
  t13857 = t13856 / 0.16e2;
  t13859 = t534 * t1917 * t3504;
  t13860 = t13859 / 0.16e2;
  t13861 = t602 * t712;
  t13882 = t1670 * t3516;
  t13883 = t13882 / 0.32e2;
  t13884 = t1674 * t3516;
  t13885 = t13884 / 0.32e2;
  t13887 = t519 * t2404 * t1947;
  t13888 = t13887 / 0.32e2;
  t13891 = t1917 * t3521;
  t13894 = t13857 + t13860 - t534 * t13861 * t1337 / 0.16e2 - t1667 * t3526 / 0.8e1 - t534 * t1951 * t3525 / 0.8e1 + 0.3e1 / 0.32e2 * t1670 * t3529 + 0.3e1 / 0.32e2 * t1674 * t3529 + 0.3e1 / 0.32e2 * t519 * t2382 * t7271 + 0.3e1 / 0.16e2 * t1667 * t3533 + 0.3e1 / 0.16e2 * t534 * t13861 * t1369 - t13883 - t13885 - t13888 - 0.3e1 / 0.16e2 * t1667 * t3522 - 0.3e1 / 0.16e2 * t534 * t13891;
  t13895 = t1667 * t3509;
  t13896 = t13895 / 0.16e2;
  t13898 = t534 * t1951 * t3508;
  t13899 = t13898 / 0.16e2;
  t13900 = t153 * t3512;
  t13904 = t60 * t26 * t13427;
  t13911 = t1667 * t3501;
  t13912 = t13911 / 0.16e2;
  t13915 = t534 * t602 * t717 * t445;
  t13916 = t13915 / 0.16e2;
  t13932 = t13896 + t13899 - t13900 * t751 / 0.32e2 - t13904 * t751 / 0.32e2 - t3513 * t2604 / 0.32e2 - t3513 * t2607 / 0.32e2 - t13912 - t13916 - 0.3e1 / 0.32e2 * t1670 * t3522 - 0.3e1 / 0.32e2 * t1674 * t3522 - 0.3e1 / 0.32e2 * t519 * t13891 + 0.3e1 / 0.32e2 * t1670 * t3543 + 0.3e1 / 0.32e2 * t1674 * t3543 + 0.3e1 / 0.32e2 * t519 * t2365 * t7143 + t1667 * t3546 / 0.4e1;
  t13944 = t534 * t13861 * t1357 / 0.4e1 - 0.3e1 / 0.16e2 * t1667 * t3550 - 0.3e1 / 0.16e2 * t534 * t7117 * t3549 - t1667 * t3538 / 0.16e2 + t13776 - t13778 - t13780 - t13782 + t13784 + t13787 + t13789 - t13791 - t13793 - t13795 + t13797;
  t13945 = t13242 / 0.8e1;
  t13946 = t13246 / 0.8e1;
  t13947 = t13251 / 0.8e1;
  t13948 = t13255 / 0.8e1;
  t13949 = t13277 / 0.16e2;
  t13950 = t13279 / 0.16e2;
  t13951 = t13282 / 0.16e2;
  t13952 = t13328 / 0.8e1;
  t13953 = t13332 / 0.8e1;
  t13954 = t13799 - t13803 - t13805 - t13945 - t13946 + t13947 + t13948 - t13949 - t13950 - t13951 + t13952 + t13953 - t13810 + t13811 - t13812 + t13813;
  t13957 = t2573 * t717;
  t13959 = t519 * t6189 * t13957;
  t13960 = 0.3e1 / 0.32e2 * t13959;
  t13962 = t534 * t2600 * t13438;
  t13963 = t13962 / 0.8e1;
  t13965 = t519 * t6181 * t13957;
  t13966 = 0.3e1 / 0.32e2 * t13965;
  t13979 = t520 * t1350;
  t13980 = t9644 * t712;
  t13981 = t13979 * t13980;
  t13984 = t2572 * t9769;
  t13991 = t5234 * t712 * t168;
  t13992 = t3109 * t13991;
  t14006 = t13960 - t13963 + t13966 + 0.3e1 / 0.16e2 * t519 * t2578 * t9769 + t534 * t2582 * t6264 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2566 * t8821 - t534 * t2594 * t8815 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t13981 - 0.3e1 / 0.16e2 * t519 * t13984 + 0.3e1 / 0.8e1 * t534 * t2594 * t6369 + 0.11e2 / 0.16e2 * t534 * t13992 - 0.3e1 / 0.8e1 * t534 * t13984 - 0.9e1 / 0.16e2 * t519 * t6189 * t13980 + 0.3e1 / 0.8e1 * t534 * t2600 * t13991 - t534 * t2600 * t8821 / 0.4e1;
  t14015 = t3500 * t75;
  t14017 = t534 * t14015 * t2374;
  t14018 = 0.3e1 / 0.16e2 * t14017;
  t14019 = t7976 * t13957;
  t14020 = t519 * t14019;
  t14021 = 0.3e1 / 0.32e2 * t14020;
  t14022 = t534 * t14019;
  t14023 = 0.3e1 / 0.16e2 * t14022;
  t14027 = t8889 * t5344;
  t14028 = t9644 * t168;
  t14032 = t2365 * t1362;
  t14033 = t14032 * t14028;
  t14044 = t534 * t3500 * t168 * t1337;
  t14045 = t14044 / 0.16e2;
  t14046 = t3500 * t418;
  t14048 = t534 * t14046 * t2400;
  t14049 = t14048 / 0.4e1;
  t14051 = t534 * t2566 * t13438;
  t14052 = 0.3e1 / 0.16e2 * t14051;
  t14055 = -0.11e2 / 0.32e2 * t519 * t6181 * t13980 + 0.3e1 / 0.16e2 * t519 * t2590 * t9769 + t3513 * t2591 / 0.16e2 + t14018 - t14021 - t14023 + 0.15e2 / 0.16e2 * t534 * t9664 * t13991 - 0.15e2 / 0.32e2 * t519 * t14027 * t14028 + 0.11e2 / 0.16e2 * t519 * t14033 + 0.9e1 / 0.16e2 * t519 * t13992 + 0.11e2 / 0.16e2 * t534 * t3532 * t418 * t13298 - t14045 + t14049 - t14052 - t3513 * t2575 / 0.16e2;
  t14066 = t3532 * t168;
  t14077 = t3513 * t2579 / 0.16e2 - 0.3e1 / 0.2e1 * t534 * t13981 + 0.9e1 / 0.8e1 * t534 * t14033 - 0.11e2 / 0.16e2 * t534 * t7080 * t8931 + 0.3e1 / 0.8e1 * t534 * t14066 * t5411 - t534 * t14066 * t5235 / 0.16e2 - 0.25e2 / 0.16e2 * t534 * t3532 * t1348 * t13307 - t3503 + t3507 + t3511 - t3518 - t3536 + t3537 - t3519 + t3520;
  t14078 = 0.3e1 / 0.16e2 * t13440;
  t14079 = t13444 / 0.4e1;
  t14080 = 0.3e1 / 0.8e1 * t13448;
  t14081 = 0.3e1 / 0.16e2 * t13451;
  t14082 = 0.3e1 / 0.16e2 * t13454;
  t14083 = 0.3e1 / 0.8e1 * t13456;
  t14084 = t13460 / 0.2e1;
  t14085 = 0.3e1 / 0.8e1 * t13464;
  t14086 = t13468 / 0.8e1;
  t14087 = -t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721 + t14078 - t14079 - t14080 - t14081 + t14082 - t14083 + t14084 + t14085 - t14086;
  t14091 = my_piecewise3(t51, 0, t13894 + t13932 + t13944 + t13954 + t14006 + t14055 + t14077 + t14087);
  tv4rhosigma2lapl23 = t14091 * t3 + t3554;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t14094 = t484 * t2021 * t3453;
  t14095 = t14094 / 0.16e2;
  t14096 = t1455 * t3558;
  t14097 = t14096 / 0.16e2;
  t14099 = t484 * t2041 * t3445;
  t14100 = t14099 / 0.16e2;
  t14101 = t2021 * t3466;
  t14114 = t1458 * t3563;
  t14115 = t14114 / 0.32e2;
  t14116 = t1470 * t3563;
  t14117 = t14116 / 0.32e2;
  t14119 = t469 * t2251 * t2007;
  t14120 = t14119 / 0.32e2;
  t14121 = t1455 * t3567;
  t14122 = t14121 / 0.16e2;
  t14125 = t484 * t631 * t695 * t290;
  t14126 = t14125 / 0.16e2;
  t14127 = t1455 * t3555;
  t14128 = t14127 / 0.16e2;
  t14129 = t14095 + t14097 + t14100 - 0.3e1 / 0.16e2 * t484 * t14101 - t1455 * t3573 / 0.8e1 - t13481 * t768 / 0.32e2 - t13485 * t768 / 0.32e2 - t3458 * t2683 / 0.32e2 - t3458 * t2686 / 0.32e2 - t14115 - t14117 - t14120 - t14122 - t14126 + t14128;
  t14132 = t631 * t690;
  t14166 = t1455 * t3591 / 0.4e1 + t484 * t14132 * t1006 / 0.4e1 - 0.3e1 / 0.16e2 * t1455 * t3594 - 0.3e1 / 0.16e2 * t484 * t7603 * t3494 - t1455 * t3583 / 0.16e2 - t484 * t14132 * t986 / 0.16e2 - 0.3e1 / 0.32e2 * t1458 * t3570 - 0.3e1 / 0.32e2 * t1470 * t3570 - 0.3e1 / 0.32e2 * t469 * t14101 + 0.3e1 / 0.32e2 * t1458 * t3588 + 0.3e1 / 0.32e2 * t1470 * t3588 + 0.3e1 / 0.32e2 * t469 * t2260 * t7584 - t484 * t2041 * t3470 / 0.8e1 + 0.3e1 / 0.32e2 * t1458 * t3576 + 0.3e1 / 0.32e2 * t1470 * t3576;
  t14179 = 0.3e1 / 0.32e2 * t1462 * t3594;
  t14181 = 0.3e1 / 0.64e2 * t1466 * t3570;
  t14183 = 0.3e1 / 0.64e2 * t1466 * t3588;
  t14185 = t1462 * t3591 / 0.8e1;
  t14187 = t1462 * t3583 / 0.32e2;
  t14189 = t1462 * t3573 / 0.16e2;
  t14191 = 0.3e1 / 0.64e2 * t1466 * t3576;
  t14193 = 0.3e1 / 0.32e2 * t1462 * t3580;
  t14195 = 0.3e1 / 0.32e2 * t1462 * t3570;
  t14197 = t13565 * t768 / 0.64e2;
  t14198 = t1466 * t3563;
  t14199 = t14198 / 0.64e2;
  t14200 = 0.3e1 / 0.32e2 * t469 * t2255 * t7473 + 0.3e1 / 0.16e2 * t1455 * t3580 + 0.3e1 / 0.16e2 * t484 * t14132 * t968 - 0.3e1 / 0.16e2 * t1455 * t3570 - t14179 - t14181 + t14183 + t14185 - t14187 - t14189 + t14191 + t14193 - t14195 - t14197 - t14199;
  t14201 = t1462 * t3567;
  t14202 = t14201 / 0.32e2;
  t14203 = t1462 * t3555;
  t14204 = t14203 / 0.32e2;
  t14205 = t1462 * t3558;
  t14206 = t14205 / 0.32e2;
  t14207 = -t14202 + t14204 + t14206 - t13595 - t13596 + t13597 - t13598 - t13599 + t13600 + t13601 - t13602 + t13603 - t13604 + t13605 - t13606 + t13607;
  t14210 = t3579 * t111;
  t14224 = t9925 * t111;
  t14225 = t13611 * t14224;
  t14238 = t2251 * t295 * t2658;
  t14239 = t469 * t14238;
  t14240 = 0.3e1 / 0.32e2 * t14239;
  t14241 = t11518 * t13625;
  t14247 = t2255 * t295 * t14224;
  t14251 = t484 * t11518 * t13100;
  t14252 = t14251 / 0.4e1;
  t14254 = t484 * t2645 * t13100;
  t14255 = 0.3e1 / 0.16e2 * t14254;
  t14258 = 0.3e1 / 0.8e1 * t484 * t14210 * t4414 - t484 * t14210 * t4319 / 0.16e2 + 0.15e2 / 0.16e2 * t484 * t9912 * t13625 + 0.11e2 / 0.16e2 * t484 * t3579 * t263 * t12919 + 0.11e2 / 0.16e2 * t469 * t14225 - 0.15e2 / 0.32e2 * t469 * t13616 * t14224 - 0.25e2 / 0.16e2 * t484 * t3579 * t997 * t12928 + t3458 * t2672 / 0.16e2 - t14240 - 0.3e1 / 0.2e1 * t484 * t14241 + 0.9e1 / 0.8e1 * t484 * t14225 + 0.9e1 / 0.16e2 * t469 * t14247 + t14252 - t14255 - t3458 * t2667 / 0.16e2;
  t14260 = t484 * t7348 * t8432;
  t14261 = 0.3e1 / 0.16e2 * t14260;
  t14264 = t484 * t3566 * t111 * t986;
  t14265 = t14264 / 0.16e2;
  t14269 = t9925 * t690;
  t14277 = t484 * t2653 * t13100;
  t14278 = t14277 / 0.8e1;
  t14279 = t2657 * t695;
  t14281 = t469 * t5483 * t14279;
  t14282 = 0.3e1 / 0.32e2 * t14281;
  t14285 = t484 * t14238;
  t14286 = 0.3e1 / 0.16e2 * t14285;
  t14288 = t469 * t5509 * t14279;
  t14289 = 0.3e1 / 0.32e2 * t14288;
  t14290 = t8241 * t9997;
  t14305 = t14261 - t14265 - 0.11e2 / 0.16e2 * t484 * t7348 * t8403 - 0.11e2 / 0.32e2 * t469 * t5483 * t14269 + 0.3e1 / 0.16e2 * t469 * t2453 * t9997 - t14278 + t14282 + t3458 * t2659 / 0.16e2 - t14286 + t14289 - 0.3e1 / 0.16e2 * t469 * t14290 + 0.3e1 / 0.16e2 * t469 * t2475 * t9997 + t484 * t2675 * t5542 / 0.2e1 + 0.3e1 / 0.8e1 * t484 * t2662 * t5591 - t484 * t2662 * t8229 / 0.8e1;
  t14325 = -0.7e1 / 0.32e2 * t469 * t14241 + 0.11e2 / 0.16e2 * t484 * t14247 - 0.3e1 / 0.8e1 * t484 * t14290 - 0.9e1 / 0.16e2 * t469 * t5509 * t14269 + 0.3e1 / 0.8e1 * t484 * t2653 * t13625 - t484 * t2653 * t8248 / 0.4e1 - 0.3e1 / 0.8e1 * t484 * t2645 * t8248 + t3557 + t3560 - t3565 - t3569 + t13629 - t13630 - t13631 + t13632;
  t14326 = -t13633 + t13634 - t3464 + t3465 - t3481 + t3485 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - t13737 + t13738 - t13739;
  t14330 = my_piecewise3(t2, 0, t14129 + t14166 + t14200 + t14207 + t14258 + t14305 + t14325 + t14326);
  tv4rhosigma2tau0 = t14330 * t3 + t3598;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t14342 = t1574 * t3611;
  t14343 = t14342 / 0.32e2;
  t14344 = t1585 * t3603;
  t14345 = t14344 / 0.16e2;
  t14346 = t1585 * t3606;
  t14347 = t14346 / 0.16e2;
  t14350 = t1585 * t3599;
  t14351 = t14350 / 0.16e2;
  t14353 = 0.3e1 / 0.64e2 * t1578 * t3618;
  t14355 = 0.3e1 / 0.32e2 * t1589 * t3618;
  t14357 = t1589 * t3621 / 0.16e2;
  t14359 = 0.3e1 / 0.64e2 * t1578 * t3624;
  t14360 = t1578 * t3611;
  t14361 = t14360 / 0.64e2;
  t14363 = 0.3e1 / 0.32e2 * t1589 * t3615;
  t14364 = t1589 * t3599;
  t14365 = t14364 / 0.32e2;
  t14366 = t1589 * t3603;
  t14367 = t14366 / 0.32e2;
  t14368 = t1589 * t3606;
  t14369 = t14368 / 0.32e2;
  t14370 = 0.3e1 / 0.32e2 * t1574 * t3624 - t1585 * t3627 / 0.16e2 + 0.3e1 / 0.16e2 * t1585 * t3615 - 0.3e1 / 0.16e2 * t1585 * t3618 - t1585 * t3621 / 0.8e1 - t14343 - t14345 + t14347 - t13764 * t783 / 0.32e2 + t14351 - t14353 - t14355 - t14357 + t14359 - t14361 + t14363 + t14365 - t14367 + t14369;
  t14372 = t13801 * t783 / 0.64e2;
  t14382 = 0.3e1 / 0.64e2 * t1578 * t3632;
  t14384 = t1589 * t3635 / 0.8e1;
  t14386 = 0.3e1 / 0.32e2 * t1589 * t3638;
  t14388 = t1589 * t3627 / 0.32e2;
  t14389 = -t14372 - 0.3e1 / 0.16e2 * t1585 * t3638 - 0.3e1 / 0.32e2 * t1574 * t3618 + 0.3e1 / 0.32e2 * t1574 * t3632 + t1585 * t3635 / 0.4e1 + t14382 + t14384 - t14386 - t14388 + t13806 - t13807 - t13808 + t13809 - t13810 + t13811 - t13812 + t13813 - t2334 - t2336;
  t14391 = my_piecewise3(t51, 0, t14370 + t14389);
  tv4rhosigma2tau11 = t14391 * t3 + t3642;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t14393 = -t14179 - t14181 + t14183 + t14185 - t14187 - t14189 + t14191 + t14193 - t14195 - t14197 - t14199 - t14202 + t14204 + t14206 + t13848 - t13849 + t13850 - t13851 + t13603;
  t14394 = t1548 * t3563;
  t14395 = t14394 / 0.32e2;
  t14396 = t1553 * t3567;
  t14397 = t14396 / 0.16e2;
  t14398 = t1553 * t3558;
  t14399 = t14398 / 0.16e2;
  t14402 = t1553 * t3555;
  t14403 = t14402 / 0.16e2;
  t14422 = -t13604 + t13605 - t13606 - t14395 - t14397 + t14399 - t13838 * t768 / 0.32e2 + t14403 + 0.3e1 / 0.32e2 * t1548 * t3588 + t1553 * t3591 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3594 - t1553 * t3583 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t3570 - t1553 * t3573 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t3576 + 0.3e1 / 0.16e2 * t1553 * t3580 - 0.3e1 / 0.16e2 * t1553 * t3570 - t2355 - t2316;
  t14424 = my_piecewise3(t2, 0, t14393 + t14422);
  tv4rhosigma2tau12 = t14424 * t3 + t3598;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t14426 = -t14353 - t14355 - t14357 + t14359 - t14361 + t14363 + t14365 - t14367 + t14369 - t14372 + t14382 + t14384 - t14386 - t14388 - t13945;
  t14429 = t670 * t712;
  t14435 = -t13946 + t13947 + t13948 - t13949 - t13950 - t13951 + t13952 + t13953 - t13810 + t13811 - t13812 + t13813 - t1667 * t3627 / 0.16e2 - t534 * t14429 * t1337 / 0.16e2 + 0.3e1 / 0.16e2 * t1667 * t3615;
  t14442 = t2153 * t3521;
  t14446 = t534 * t2153 * t3504;
  t14447 = t14446 / 0.16e2;
  t14456 = t1670 * t3611;
  t14457 = t14456 / 0.32e2;
  t14458 = t1674 * t3611;
  t14459 = t14458 / 0.32e2;
  t14461 = t519 * t2404 * t2208;
  t14462 = t14461 / 0.32e2;
  t14463 = t1667 * t3599;
  t14464 = t14463 / 0.16e2;
  t14466 = t534 * t2212 * t3508;
  t14467 = t14466 / 0.16e2;
  t14468 = t1667 * t3603;
  t14469 = t14468 / 0.16e2;
  t14472 = t534 * t670 * t717 * t445;
  t14473 = t14472 / 0.16e2;
  t14474 = 0.3e1 / 0.16e2 * t534 * t14429 * t1369 - 0.3e1 / 0.16e2 * t1667 * t3618 - 0.3e1 / 0.16e2 * t534 * t14442 + t14447 - t13900 * t783 / 0.32e2 - t13904 * t783 / 0.32e2 - t3513 * t2822 / 0.32e2 - t3513 * t2825 / 0.32e2 - t14457 - t14459 - t14462 + t14464 + t14467 - t14469 - t14473;
  t14475 = t1667 * t3606;
  t14476 = t14475 / 0.16e2;
  t14493 = t14476 + t3601 - t3605 + t3608 - t3613 - t3536 + t3537 - t3519 + t3520 + t534 * t14429 * t1357 / 0.4e1 - 0.3e1 / 0.16e2 * t1667 * t3638 - 0.3e1 / 0.16e2 * t534 * t8043 * t3549 - 0.3e1 / 0.32e2 * t1670 * t3618 - 0.3e1 / 0.32e2 * t1674 * t3618 - 0.3e1 / 0.32e2 * t519 * t14442 + 0.3e1 / 0.32e2 * t1670 * t3632;
  t14515 = 0.3e1 / 0.32e2 * t1674 * t3632 + 0.3e1 / 0.32e2 * t519 * t2365 * t7989 + t1667 * t3635 / 0.4e1 - t1667 * t3621 / 0.8e1 - t534 * t2212 * t3525 / 0.8e1 + 0.3e1 / 0.32e2 * t1670 * t3624 + 0.3e1 / 0.32e2 * t1674 * t3624 + 0.3e1 / 0.32e2 * t519 * t2382 * t8090 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t14517 = t534 * t2758 * t13438;
  t14518 = 0.3e1 / 0.16e2 * t14517;
  t14520 = t534 * t12834 * t9004;
  t14521 = 0.3e1 / 0.16e2 * t14520;
  t14524 = t534 * t3602 * t168 * t1337;
  t14525 = t14524 / 0.16e2;
  t14526 = t3614 * t168;
  t14536 = t14078 - t14079 - t14080 - t14081 + t14082 - t14083 + t14084 + t14085 - t14086 - t14518 + t14521 - t14525 + 0.3e1 / 0.8e1 * t534 * t14526 * t5411 - t534 * t14526 * t5235 / 0.16e2 + 0.15e2 / 0.16e2 * t534 * t10627 * t13991;
  t14538 = t3614 * t418;
  t14542 = t10460 * t168;
  t14543 = t14032 * t14542;
  t14557 = t14538 * t13318;
  t14562 = t3772 * t13438;
  t14563 = t534 * t14562;
  t14564 = 0.3e1 / 0.16e2 * t14563;
  t14565 = t3602 * t418;
  t14567 = t534 * t14565 * t2400;
  t14568 = t14567 / 0.4e1;
  t14569 = t10460 * t712;
  t14570 = t7976 * t14569;
  t14575 = t3772 * t8821;
  t14584 = 0.11e2 / 0.16e2 * t534 * t14538 * t13298 + 0.11e2 / 0.16e2 * t519 * t14543 - 0.15e2 / 0.32e2 * t519 * t14027 * t14542 - 0.25e2 / 0.16e2 * t534 * t3614 * t1348 * t13307 - t3513 * t2764 / 0.16e2 + t3513 * t2767 / 0.16e2 - 0.3e1 / 0.2e1 * t534 * t14557 + 0.9e1 / 0.8e1 * t534 * t14543 - t14564 + t14568 + 0.9e1 / 0.16e2 * t519 * t14570 + 0.11e2 / 0.16e2 * t534 * t14570 - 0.3e1 / 0.8e1 * t534 * t14575 - 0.9e1 / 0.16e2 * t519 * t6189 * t14569 + 0.3e1 / 0.8e1 * t534 * t2785 * t6369;
  t14585 = t2762 * t717;
  t14587 = t519 * t6189 * t14585;
  t14588 = 0.3e1 / 0.32e2 * t14587;
  t14592 = t534 * t2778 * t13438;
  t14593 = t14592 / 0.8e1;
  t14595 = t519 * t6181 * t14585;
  t14596 = 0.3e1 / 0.32e2 * t14595;
  t14597 = t519 * t14562;
  t14598 = 0.3e1 / 0.32e2 * t14597;
  t14632 = t14588 + t3513 * t2782 / 0.16e2 - t14593 + t14596 - t14598 + t534 * t2770 * t6264 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2758 * t8821 - 0.3e1 / 0.16e2 * t519 * t14575 + 0.3e1 / 0.16e2 * t519 * t2578 * t10478 - t534 * t2785 * t8815 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t14557 + 0.3e1 / 0.8e1 * t534 * t2778 * t13991 - t534 * t2778 * t8821 / 0.4e1 - 0.11e2 / 0.32e2 * t519 * t6181 * t14569 + 0.3e1 / 0.16e2 * t519 * t2590 * t10478 - 0.11e2 / 0.16e2 * t534 * t3614 * t75 * t6307 * t168;
  t14636 = my_piecewise3(t51, 0, t14426 + t14435 + t14474 + t14493 + t14515 + t14536 + t14584 + t14632);
  tv4rhosigma2tau23 = t14636 * t3 + t3642;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t14638 = t13476 / 0.8e1;
  t14639 = t13479 / 0.8e1;
  t14640 = t13492 / 0.8e1;
  t14641 = t13495 / 0.8e1;
  t14642 = t13535 / 0.16e2;
  t14643 = t13537 / 0.16e2;
  t14644 = t13540 / 0.16e2;
  t14645 = t13544 / 0.8e1;
  t14646 = t13548 / 0.8e1;
  t14647 = t13568 / 0.32e2;
  t14648 = t13570 / 0.16e2;
  t14649 = t13572 / 0.16e2;
  t14650 = t13574 / 0.16e2;
  t14651 = t12862 / 0.32e2;
  t14652 = t12865 / 0.32e2;
  t14653 = t14638 + t14639 + t14640 + t14641 - t14642 - t14643 - t14644 - t14645 - t14646 - t14647 + t14648 - t14649 + t14650 - t14651 - t14652;
  t14654 = t12870 / 0.16e2;
  t14655 = t12876 / 0.16e2;
  t14656 = t12881 / 0.16e2;
  t14657 = t12886 / 0.16e2;
  t14658 = t12889 / 0.16e2;
  t14659 = t12910 / 0.32e2;
  t14660 = t12932 / 0.32e2;
  t14661 = t12934 / 0.64e2;
  t14662 = t12936 / 0.32e2;
  t14663 = t12938 / 0.32e2;
  t14664 = t12941 / 0.16e2;
  t14666 = t255 * t3664 / 0.64e2;
  t14675 = t14654 - t14655 - t14656 + t14657 + t14658 - t14659 + t14660 - t14661 + t14662 - t14663 + t14664 - t14666 - t246 * t3664 / 0.32e2 - t99 * t13041 * t798 * t269 / 0.32e2 - t3458 * t2837 / 0.16e2;
  t14684 = t2836 * t8229;
  t14712 = t3458 * t2841 / 0.16e2 + 0.3e1 / 0.16e2 * t484 * t2856 * t5591 - 0.3e1 / 0.16e2 * t1455 * t3647 - 0.3e1 / 0.16e2 * t484 * t14684 - t1455 * t3668 / 0.16e2 - t484 * t798 * t478 * t986 / 0.16e2 - 0.3e1 / 0.32e2 * t1458 * t3647 - 0.3e1 / 0.32e2 * t1470 * t3647 - 0.3e1 / 0.32e2 * t469 * t14684 + 0.3e1 / 0.32e2 * t1458 * t3674 - t3458 * t2860 / 0.16e2 + t3458 * t2863 / 0.16e2 - t1455 * t3651 / 0.8e1 - t484 * t2856 * t12897 / 0.8e1 + 0.3e1 / 0.32e2 * t1458 * t3654;
  t14721 = 0.3e1 / 0.32e2 * t1462 * t3681;
  t14723 = 0.3e1 / 0.64e2 * t1466 * t3647;
  t14725 = 0.3e1 / 0.64e2 * t1466 * t3674;
  t14727 = t1462 * t3677 / 0.8e1;
  t14729 = t1462 * t3668 / 0.32e2;
  t14731 = t1462 * t3651 / 0.16e2;
  t14733 = 0.3e1 / 0.64e2 * t1466 * t3654;
  t14735 = 0.3e1 / 0.32e2 * t1462 * t3643;
  t14737 = 0.3e1 / 0.32e2 * t1462 * t3647;
  t14745 = 0.3e1 / 0.32e2 * t1470 * t3654 + 0.3e1 / 0.32e2 * t469 * t2836 * t5591 + 0.3e1 / 0.16e2 * t1455 * t3643 - t14721 - t14723 + t14725 + t14727 - t14729 - t14731 + t14733 + t14735 - t14737 + 0.3e1 / 0.32e2 * t1470 * t3674 + 0.3e1 / 0.32e2 * t469 * t2840 * t5542 + t1455 * t3677 / 0.4e1;
  t14756 = t13093 / 0.4e1;
  t14757 = 0.3e1 / 0.16e2 * t13097;
  t14758 = 0.3e1 / 0.32e2 * t13102;
  t14759 = 0.3e1 / 0.32e2 * t13105;
  t14760 = 0.3e1 / 0.16e2 * t13107;
  t14761 = 0.3e1 / 0.16e2 * t13111;
  t14762 = t484 * t2836 * t5542 / 0.4e1 - 0.3e1 / 0.16e2 * t1455 * t3681 - 0.3e1 / 0.16e2 * t484 * t2840 * t12946 + t14756 - t14757 - t14758 + t14759 - t14760 + t14761 + t3657 - t3658 + t3659 - t3660 - t3661 + t3662;
  t14763 = 0.3e1 / 0.16e2 * t13638;
  t14764 = 0.3e1 / 0.16e2 * t13668;
  t14765 = t13673 / 0.4e1;
  t14766 = 0.3e1 / 0.16e2 * t13676;
  t14767 = 0.3e1 / 0.8e1 * t13679;
  t14768 = t13683 / 0.8e1;
  t14769 = -t3671 + t3684 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - t14763 + t14764 - t14765 + t14766 + t14767 - t14768;
  t14771 = 0.3e1 / 0.8e1 * t13715;
  t14772 = 0.3e1 / 0.8e1 * t13731;
  t14773 = t13735 / 0.2e1;
  t14774 = t13116 / 0.16e2;
  t14775 = 0.3e1 / 0.32e2 * t13119;
  t14776 = t13123 / 0.8e1;
  t14778 = t5627 * t183;
  t14787 = t9104 * t111;
  t14788 = t2840 * t1011 * t14787;
  t14791 = t10781 * t4344;
  t14810 = t2836 * t999 * t14787;
  t14813 = -t14771 - t14772 + t14773 - t14774 + t14775 - t14776 + 0.3e1 / 0.8e1 * t484 * t2832 * t43 * t14778 - t484 * t3667 * t111 * t4319 / 0.16e2 + 0.11e2 / 0.16e2 * t469 * t14788 - 0.15e2 / 0.32e2 * t469 * t14791 * t14787 - 0.25e2 / 0.16e2 * t484 * t2840 * t4344 * t14787 + 0.15e2 / 0.16e2 * t484 * t10781 * t4277 * t14787 + 0.9e1 / 0.8e1 * t484 * t14788 + 0.11e2 / 0.16e2 * t484 * t3667 * t263 * t12919 - 0.3e1 / 0.2e1 * t484 * t14810;
  t14815 = t2836 * t295 * t14787;
  t14818 = t4280 * t798;
  t14819 = t14818 * t183;
  t14857 = t2463 * t9190;
  t14865 = 0.11e2 / 0.16e2 * t484 * t14815 - 0.9e1 / 0.16e2 * t469 * t5509 * t14819 + 0.3e1 / 0.16e2 * t469 * t3006 * t9190 + t484 * t6454 * t9190 / 0.2e1 - t484 * t2459 * t6489 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t14810 - t484 * t2469 * t9190 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t2856 * t113 * t14787 - 0.11e2 / 0.32e2 * t469 * t5483 * t14819 + 0.3e1 / 0.16e2 * t469 * t3015 * t9190 + 0.3e1 / 0.8e1 * t484 * t576 * t265 * t9190 - 0.11e2 / 0.16e2 * t484 * t2856 * t265 * t14787 + 0.9e1 / 0.16e2 * t469 * t14815 - 0.3e1 / 0.8e1 * t484 * t14857 - 0.3e1 / 0.8e1 * t484 * t2483 * t9190 - 0.3e1 / 0.16e2 * t469 * t14857;
  t14869 = my_piecewise3(t2, 0, t14653 + t14675 + t14712 + t14745 + t14762 + t14769 + t14813 + t14865);
  tv4rhosigmalapl20 = t14869 * t3 + t3686;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t14871 = t13767 / 0.16e2;
  t14872 = t13769 / 0.8e1;
  t14873 = t13771 / 0.8e1;
  t14874 = t13773 / 0.8e1;
  t14875 = t13794 / 0.16e2;
  t14876 = t13796 / 0.16e2;
  t14877 = t13798 / 0.16e2;
  t14878 = t13804 / 0.32e2;
  t14879 = t13131 / 0.16e2;
  t14880 = t13133 / 0.16e2;
  t14881 = t13135 / 0.32e2;
  t14882 = t13137 / 0.16e2;
  t14883 = t13139 / 0.32e2;
  t14884 = t13141 / 0.32e2;
  t14885 = t13143 / 0.64e2;
  t14886 = t13145 / 0.32e2;
  t14888 = t370 * t3708 / 0.64e2;
  t14892 = 0.3e1 / 0.64e2 * t1578 * t3688;
  t14893 = -t14871 - t14872 + t14873 + t14874 - t14875 + t14876 + t14877 - t14878 + t14879 - t14880 - t14881 + t14882 - t14883 + t14884 - t14885 + t14886 - t14888 - t367 * t3708 / 0.32e2 - t14892;
  t14895 = 0.3e1 / 0.64e2 * t1578 * t3695;
  t14897 = 0.3e1 / 0.32e2 * t1589 * t3698;
  t14899 = 0.3e1 / 0.32e2 * t1589 * t3688;
  t14901 = t1589 * t3692 / 0.16e2;
  t14921 = 0.3e1 / 0.64e2 * t1578 * t3718;
  t14923 = t1589 * t3721 / 0.8e1;
  t14925 = 0.3e1 / 0.32e2 * t1589 * t3725;
  t14927 = t1589 * t3712 / 0.32e2;
  t14928 = t14895 + t14897 - t14899 - t14901 + t1585 * t3721 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3725 - t1585 * t3712 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t3688 + 0.3e1 / 0.32e2 * t1574 * t3718 - t1585 * t3692 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t3695 + 0.3e1 / 0.16e2 * t1585 * t3698 - 0.3e1 / 0.16e2 * t1585 * t3688 + t14921 + t14923 - t14925 - t14927 - t2334 - t2336;
  t14930 = my_piecewise3(t51, 0, t14893 + t14928);
  tv4rhosigmalapl28 = t14930 * t3 + t3730;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t14932 = t13832 / 0.16e2;
  t14933 = t13834 / 0.8e1;
  t14934 = t13836 / 0.8e1;
  t14935 = t13841 / 0.8e1;
  t14936 = t13192 / 0.16e2;
  t14937 = t13194 / 0.16e2;
  t14938 = t13196 / 0.16e2;
  t14939 = t13198 / 0.32e2;
  t14944 = -t14932 - t14933 + t14934 + t14935 - t14647 + t14648 - t14649 + t14650 + t14936 - t14937 + t14938 - t14939 + t14660 - t14661 + t14662 - t14663 - t345 * t3664 / 0.32e2 - t14666 + 0.3e1 / 0.32e2 * t1548 * t3674;
  t14961 = t1553 * t3677 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3681 - t1553 * t3668 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t3647 + 0.3e1 / 0.32e2 * t1548 * t3654 + 0.3e1 / 0.16e2 * t1553 * t3643 - 0.3e1 / 0.16e2 * t1553 * t3647 - t1553 * t3651 / 0.8e1 - t14721 - t14723 + t14725 + t14727 - t14729 - t14731 + t14733 + t14735 - t14737 - t2355 - t2316;
  t14963 = my_piecewise3(t2, 0, t14944 + t14961);
  tv4rhosigmalapl29 = t14963 * t3 + t3686;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t14965 = t13856 / 0.8e1;
  t14966 = t13859 / 0.8e1;
  t14967 = t13882 / 0.16e2;
  t14968 = t13884 / 0.16e2;
  t14969 = t13887 / 0.16e2;
  t14970 = t13895 / 0.8e1;
  t14971 = t13898 / 0.8e1;
  t14972 = t13911 / 0.8e1;
  t14973 = t13915 / 0.8e1;
  t14974 = t13242 / 0.16e2;
  t14975 = t13246 / 0.16e2;
  t14976 = t14965 + t14966 - t14967 - t14968 - t14969 + t14970 + t14971 - t14972 - t14973 - t14875 + t14876 + t14877 - t14878 - t14974 - t14975;
  t14977 = t13251 / 0.16e2;
  t14978 = t13255 / 0.16e2;
  t14979 = t13277 / 0.32e2;
  t14980 = t13279 / 0.32e2;
  t14981 = t13282 / 0.32e2;
  t14982 = t13328 / 0.16e2;
  t14983 = t13332 / 0.16e2;
  t14993 = t14977 + t14978 - t14979 - t14980 - t14981 + t14982 + t14983 - t14883 + t14884 - t14885 + t14886 - t3513 * t2936 / 0.16e2 + t3513 * t2940 / 0.16e2 + 0.3e1 / 0.16e2 * t534 * t2952 * t6369 - 0.3e1 / 0.16e2 * t1667 * t3688;
  t14995 = t2935 * t8815;
  t15032 = -0.3e1 / 0.16e2 * t534 * t14995 - t1667 * t3692 / 0.8e1 - t534 * t2952 * t13264 / 0.8e1 + t534 * t2935 * t6264 / 0.4e1 - 0.3e1 / 0.16e2 * t1667 * t3725 - 0.3e1 / 0.16e2 * t534 * t2939 * t13324 - t534 * t815 * t528 * t1337 / 0.16e2 - 0.3e1 / 0.32e2 * t1670 * t3688 - 0.3e1 / 0.32e2 * t1674 * t3688 - 0.3e1 / 0.32e2 * t519 * t14995 + 0.3e1 / 0.32e2 * t1670 * t3718 + 0.3e1 / 0.32e2 * t1674 * t3718 + 0.3e1 / 0.32e2 * t519 * t2939 * t6264 + t1667 * t3721 / 0.4e1 - t3513 * t2969 / 0.16e2;
  t15046 = 0.3e1 / 0.16e2 * t13959;
  t15047 = t13962 / 0.4e1;
  t15048 = 0.3e1 / 0.16e2 * t13965;
  t15049 = 0.3e1 / 0.8e1 * t14017;
  t15050 = 0.3e1 / 0.16e2 * t14020;
  t15051 = 0.3e1 / 0.8e1 * t14022;
  t15058 = t3513 * t2972 / 0.16e2 - t1667 * t3712 / 0.16e2 + 0.3e1 / 0.32e2 * t1670 * t3695 + 0.3e1 / 0.32e2 * t1674 * t3695 + 0.3e1 / 0.32e2 * t519 * t2935 * t6369 + 0.3e1 / 0.16e2 * t1667 * t3698 + t15046 - t15047 + t15048 + t15049 - t15050 - t15051 - t409 * t3708 / 0.32e2 - t156 * t13427 * t815 * t424 / 0.32e2 - t14888;
  t15061 = t14044 / 0.8e1;
  t15062 = t14048 / 0.2e1;
  t15063 = 0.3e1 / 0.8e1 * t14051;
  t15064 = -t14892 + t14895 + t14897 - t14899 - t14901 + t14921 + t14923 - t14925 - t14927 - t15061 + t15062 - t15063 - t3701 + t3702 + t3703;
  t15069 = t2931 * t75;
  t15077 = t9655 * t168;
  t15085 = t2939 * t1362;
  t15086 = t15085 * t15077;
  t15089 = t11202 * t5344;
  t15098 = t2935 * t1350 * t15077;
  t15103 = -t3704 - t3715 + t3728 - t3705 + t3706 - t534 * t3711 * t168 * t5235 / 0.16e2 - 0.11e2 / 0.16e2 * t534 * t15069 * t6308 + 0.3e1 / 0.8e1 * t534 * t15069 * t6234 + 0.15e2 / 0.16e2 * t534 * t11202 * t5356 * t15077 + 0.11e2 / 0.16e2 * t534 * t3711 * t418 * t13298 + 0.11e2 / 0.16e2 * t519 * t15086 - 0.15e2 / 0.32e2 * t519 * t15089 * t15077 - 0.25e2 / 0.16e2 * t534 * t2939 * t5344 * t15077 - 0.3e1 / 0.2e1 * t534 * t15098 + 0.9e1 / 0.8e1 * t534 * t15086;
  t15106 = t2935 * t450 * t15077;
  t15109 = t5234 * t815;
  t15110 = t15109 * t191;
  t15130 = t3109 * t9719;
  t15151 = 0.9e1 / 0.16e2 * t519 * t15106 - 0.9e1 / 0.16e2 * t519 * t6189 * t15110 - t534 * t2600 * t9719 / 0.4e1 + 0.3e1 / 0.8e1 * t534 * t2952 * t170 * t15077 - 0.11e2 / 0.32e2 * t519 * t6181 * t15110 + 0.3e1 / 0.16e2 * t519 * t3126 * t9719 + 0.3e1 / 0.8e1 * t534 * t11180 * t9719 - 0.3e1 / 0.8e1 * t534 * t15130 + 0.11e2 / 0.16e2 * t534 * t15106 - 0.3e1 / 0.8e1 * t534 * t2566 * t9719 - 0.3e1 / 0.16e2 * t519 * t15130 + 0.3e1 / 0.16e2 * t519 * t3113 * t9719 + t534 * t7069 * t9719 / 0.2e1 - t534 * t2594 * t7139 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t15098;
  t15152 = 0.3e1 / 0.32e2 * t13440;
  t15153 = t13444 / 0.8e1;
  t15154 = 0.3e1 / 0.16e2 * t13448;
  t15155 = 0.3e1 / 0.32e2 * t13451;
  t15156 = 0.3e1 / 0.32e2 * t13454;
  t15157 = 0.3e1 / 0.16e2 * t13456;
  t15158 = t13460 / 0.4e1;
  t15159 = 0.3e1 / 0.16e2 * t13464;
  t15160 = t13468 / 0.16e2;
  t15161 = -t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721 + t15152 - t15153 - t15154 - t15155 + t15156 - t15157 + t15158 + t15159 - t15160;
  t15165 = my_piecewise3(t51, 0, t14976 + t14993 + t15032 + t15058 + t15064 + t15103 + t15151 + t15161);
  tv4rhosigmalapl217 = t15165 * t3 + t3730;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  t15167 = t14095 + t14097 + t14100 - t14115 - t14117 - t14120 - t14122 - t14126 + t14128 - t14199 - t14202 + t14204 + t14206 + t13477 + t13480 + t13493 + t13496 - t13536 - t13538;
  t15168 = -t13541 - t13545 - t13549 - t13569 + t13571 - t13573 + t13575 - t14651 - t14652 + t14654 - t14655 - t14656 + t14657 + t14658 - t14659 + t14660 - t14661 + t14662 - t14663 + t14664;
  t15171 = t13565 * t832 / 0.64e2;
  t15180 = -t14240 + t14252 - t14255 + t14261 - t14265 - t15171 - t13481 * t832 / 0.32e2 - t13485 * t832 / 0.32e2 - t3458 * t3042 / 0.32e2 - t3458 * t3045 / 0.32e2 - t14278 + t14282 - t14286 + t14289 + t3557 + t3560 - t3565 - t3569 + t14756;
  t15186 = 0.3e1 / 0.64e2 * t1466 * t3735;
  t15188 = 0.3e1 / 0.64e2 * t1466 * t3754;
  t15190 = t1462 * t3757 / 0.8e1;
  t15192 = t1462 * t3738 / 0.16e2;
  t15194 = 0.3e1 / 0.64e2 * t1466 * t3742;
  t15195 = -t14757 - t14758 + t14759 - t14760 + t14761 + t3448 - t3452 + t3456 - t3463 - t3661 + t3662 - t3671 + t3684 + t3458 * t3007 / 0.16e2 - t3458 * t2999 / 0.16e2 - t15186 + t15188 + t15190 - t15192 + t15194;
  t15199 = 0.3e1 / 0.32e2 * t1462 * t3745;
  t15201 = t1462 * t3749 / 0.32e2;
  t15203 = 0.3e1 / 0.32e2 * t1462 * t3735;
  t15205 = 0.3e1 / 0.32e2 * t1462 * t3760;
  t15223 = t11601 * t3734;
  t15226 = t2666 * t9190;
  t15229 = t2666 * t9198;
  t15242 = t15199 - t15201 - t15203 - t15205 + 0.3e1 / 0.32e2 * t1458 * t3742 + 0.3e1 / 0.32e2 * t1470 * t3742 + 0.3e1 / 0.32e2 * t469 * t11583 * t3741 + 0.3e1 / 0.32e2 * t469 * t3015 * t10042 + 0.3e1 / 0.32e2 * t469 * t3015 * t9997 + 0.3e1 / 0.16e2 * t1455 * t3745 - 0.3e1 / 0.16e2 * t1455 * t3735 - 0.3e1 / 0.16e2 * t484 * t15223 - 0.3e1 / 0.16e2 * t484 * t15226 - 0.3e1 / 0.16e2 * t484 * t15229 + t3458 * t3016 / 0.16e2 - 0.3e1 / 0.32e2 * t469 * t15223 - 0.3e1 / 0.32e2 * t469 * t15229 + 0.3e1 / 0.32e2 * t1458 * t3754 + 0.3e1 / 0.32e2 * t1470 * t3754;
  t15305 = 0.3e1 / 0.32e2 * t469 * t6541 * t999 * t3741 + 0.3e1 / 0.32e2 * t469 * t3006 * t10042 + 0.3e1 / 0.32e2 * t469 * t3006 * t9997 + 0.3e1 / 0.16e2 * t484 * t11556 * t1523 + 0.3e1 / 0.16e2 * t484 * t11560 * t1523 + 0.3e1 / 0.16e2 * t484 * t3019 * t5591 - t1455 * t3749 / 0.16e2 - t484 * t3050 * t183 * t986 / 0.16e2 - t484 * t3054 * t183 * t986 / 0.16e2 - t484 * t835 * t478 * t986 / 0.16e2 - t1455 * t3738 / 0.8e1 - t484 * t10038 * t3734 / 0.8e1 - t484 * t2653 * t9190 / 0.8e1 - t484 * t2653 * t9198 / 0.8e1 + t1455 * t3757 / 0.4e1 + t484 * t3050 * t263 * t1441 / 0.4e1 + t484 * t3054 * t263 * t1441 / 0.4e1 + t484 * t2992 * t5542 / 0.4e1 - 0.3e1 / 0.16e2 * t1455 * t3760 - 0.3e1 / 0.16e2 * t484 * t9953 * t3734;
  t15319 = -0.3e1 / 0.16e2 * t484 * t2645 * t9190 - 0.3e1 / 0.16e2 * t484 * t2645 * t9198 - 0.3e1 / 0.32e2 * t1458 * t3735 - 0.3e1 / 0.32e2 * t1470 * t3735 - 0.3e1 / 0.32e2 * t469 * t15226 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - t13639 + t13669 - t13674 + t13677 + t13680 - t13684 - t13716 - t13732;
  t15320 = t23 * t24;
  t15323 = t15320 * t25 * t100 * t213;
  t15325 = t9093 * t183;
  t15341 = t25 * t260;
  t15343 = t15320 * t15341 * t199;
  t15364 = t15320 * t15341 * t111;
  t15380 = t13736 - t14774 + t14775 - t14776 - 0.11e2 / 0.16e2 * t15323 * t13019 * t265 * t15325 + 0.3e1 / 0.8e1 * t15323 * t6469 * t14778 - t15323 * t2449 * t4319 / 0.16e2 - 0.3e1 / 0.2e1 * t15323 * t4296 * t2449 + 0.9e1 / 0.8e1 * t15323 * t4339 * t2449 + 0.9e1 / 0.16e2 * t15343 * t4323 * t2649 + 0.11e2 / 0.16e2 * t15323 * t2479 * t12919 + 0.11e2 / 0.16e2 * t15343 * t4339 * t2649 - 0.15e2 / 0.32e2 * t15343 * t4346 * t2649 - 0.25e2 / 0.16e2 * t15323 * t1739 * t4344 * t14787 + 0.15e2 / 0.16e2 * t15323 * t4281 * t2449 - 0.7e1 / 0.32e2 * t15364 * t4296 * t3748 + 0.3e1 / 0.8e1 * t15323 * t4355 * t2449 - 0.11e2 / 0.32e2 * t15364 * t4422 * t3748 + 0.11e2 / 0.16e2 * t15323 * t4323 * t2449 - 0.9e1 / 0.16e2 * t15364 * t4381 * t3748;
  t15384 = my_piecewise3(t2, 0, t15167 + t15168 + t15180 + t15195 + t15242 + t15305 + t15319 + t15380);
  tv4rhosigmalapltau0 = t15384 * t3 + t3765;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  t15386 = -t14343 - t14345 + t14347 + t14351 - t14361 + t14365 - t14367 + t14369 - t13768 - t13770 + t13772;
  t15387 = t13774 - t13795 + t13797 + t13799 - t13805 + t14879 - t14880 - t14881 + t14882 - t14883 + t14884 - t14885;
  t15390 = t13801 * t849 / 0.64e2;
  t15394 = 0.3e1 / 0.64e2 * t1578 * t3790;
  t15396 = 0.3e1 / 0.32e2 * t1589 * t3769;
  t15398 = 0.3e1 / 0.32e2 * t1589 * t3774;
  t15400 = t1589 * t3777 / 0.16e2;
  t15402 = 0.3e1 / 0.64e2 * t1578 * t3781;
  t15404 = t1589 * t3793 / 0.8e1;
  t15406 = 0.3e1 / 0.32e2 * t1589 * t3796;
  t15408 = t1589 * t3785 / 0.32e2;
  t15409 = t14886 - t15390 - t13764 * t849 / 0.32e2 + t15394 + t15396 - t15398 - t15400 + t15402 + t15404 - t15406 - t15408;
  t15411 = 0.3e1 / 0.64e2 * t1578 * t3774;
  t15430 = -t15411 + t1585 * t3793 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3796 - 0.3e1 / 0.32e2 * t1574 * t3774 + 0.3e1 / 0.32e2 * t1574 * t3790 - t1585 * t3777 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t3781 - t1585 * t3785 / 0.16e2 + 0.3e1 / 0.16e2 * t1585 * t3769 - 0.3e1 / 0.16e2 * t1585 * t3774 - t2334 - t2336;
  t15433 = my_piecewise3(t51, 0, t15386 + t15387 + t15409 + t15430);
  tv4rhosigmalapltau11 = t15433 * t3 + t3801;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  t15435 = -t14199 - t14202 + t14204 + t14206 - t13833 - t13835 + t13837 + t13842 - t13569 + t13571 - t13573;
  t15438 = t13575 + t14936 - t14937 + t14938 - t14939 + t14660 - t14661 + t14662 - t14663 - t13838 * t832 / 0.32e2 - t15171 - t14395;
  t15456 = -t14397 + t14399 + t14403 - t1553 * t3749 / 0.16e2 - 0.3e1 / 0.16e2 * t1553 * t3735 - t1553 * t3738 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t3742 + t1553 * t3757 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3760 - 0.3e1 / 0.32e2 * t1548 * t3735 + 0.3e1 / 0.32e2 * t1548 * t3754;
  t15459 = 0.3e1 / 0.16e2 * t1553 * t3745 - t15186 + t15188 + t15190 - t15192 + t15194 + t15199 - t15201 - t15203 - t15205 - t2355 - t2316;
  t15462 = my_piecewise3(t2, 0, t15435 + t15438 + t15456 + t15459);
  tv4rhosigmalapltau12 = t15462 * t3 + t3765;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  t15464 = -t14361 + t14365 - t14367 + t14369 + t13857 + t13860 - t13883 - t13885 - t13888 + t13896 + t13899 - t13912 - t13916 - t13795 + t13797 + t13799 - t13805 - t14974 - t14975;
  t15473 = t14977 + t14978 - t14979 - t14980 - t14981 + t14982 + t14983 - t14883 + t14884 - t14885 + t14886 - t3513 * t3155 / 0.32e2 - t3513 * t3158 / 0.32e2 - t13900 * t849 / 0.32e2 - t13904 * t849 / 0.32e2 - t15390 + t13960 - t13963 + t13966 + t14018;
  t15475 = t60 * t24;
  t15476 = t25 * t415;
  t15478 = t15475 * t15476 * t207;
  t15487 = t15475 * t25 * t157 * t219;
  t15513 = t15475 * t15476 * t168;
  t15534 = -t14021 - t14023 + 0.11e2 / 0.16e2 * t15478 * t5338 * t2774 - 0.15e2 / 0.32e2 * t15478 * t5346 * t2774 - 0.25e2 / 0.16e2 * t15487 * t9660 * t15077 + 0.15e2 / 0.16e2 * t15487 * t5358 * t2586 + 0.3e1 / 0.8e1 * t15487 * t7080 * t6234 - t15487 * t2586 * t5235 / 0.16e2 - 0.3e1 / 0.2e1 * t15487 * t7069 * t15077 + 0.9e1 / 0.8e1 * t15487 * t5338 * t2586 + 0.11e2 / 0.16e2 * t15487 * t2582 * t13298 + 0.11e2 / 0.16e2 * t15487 * t5370 * t2586 - 0.7e1 / 0.32e2 * t15513 * t5382 * t3784 - 0.9e1 / 0.16e2 * t15513 * t5398 * t3784 + 0.3e1 / 0.8e1 * t15487 * t5374 * t2586 - 0.11e2 / 0.32e2 * t15513 * t5334 * t3784 - 0.11e2 / 0.16e2 * t15487 * t11180 * t15077 + 0.9e1 / 0.16e2 * t15513 * t5370 * t3784 + t3513 * t3114 / 0.16e2;
  t15573 = t12061 * t3773;
  t15576 = t3772 * t9719;
  t15579 = t3772 * t9769;
  t15590 = -t3513 * t3110 / 0.16e2 - t534 * t2778 * t9769 / 0.8e1 + 0.3e1 / 0.32e2 * t1670 * t3781 + 0.3e1 / 0.32e2 * t1674 * t3781 + 0.3e1 / 0.32e2 * t519 * t12159 * t3780 + 0.3e1 / 0.32e2 * t519 * t3126 * t10474 + 0.3e1 / 0.16e2 * t1667 * t3769 + 0.3e1 / 0.16e2 * t534 * t12048 * t1621 + 0.3e1 / 0.16e2 * t534 * t12052 * t1621 + 0.3e1 / 0.16e2 * t534 * t3130 * t6369 + t3513 * t3127 / 0.16e2 - t534 * t3167 * t191 * t1337 / 0.16e2 - t534 * t852 * t528 * t1337 / 0.16e2 - 0.3e1 / 0.16e2 * t1667 * t3774 - 0.3e1 / 0.16e2 * t534 * t15573 - 0.3e1 / 0.16e2 * t534 * t15576 - 0.3e1 / 0.16e2 * t534 * t15579 - t1667 * t3777 / 0.8e1 - t534 * t10674 * t3773 / 0.8e1 - t534 * t2778 * t9719 / 0.8e1;
  t15642 = t534 * t3117 * t6264 / 0.4e1 - 0.3e1 / 0.16e2 * t1667 * t3796 - 0.3e1 / 0.16e2 * t534 * t10667 * t3773 - 0.3e1 / 0.16e2 * t534 * t2758 * t9719 - 0.3e1 / 0.16e2 * t534 * t2758 * t9769 - 0.3e1 / 0.32e2 * t1670 * t3774 - 0.3e1 / 0.32e2 * t1674 * t3774 - 0.3e1 / 0.32e2 * t519 * t15576 - 0.3e1 / 0.32e2 * t519 * t15573 - 0.3e1 / 0.32e2 * t519 * t15579 + 0.3e1 / 0.32e2 * t1670 * t3790 + 0.3e1 / 0.32e2 * t1674 * t3790 + 0.3e1 / 0.32e2 * t519 * t7117 * t1350 * t3780 + 0.3e1 / 0.32e2 * t519 * t3113 * t10474 + 0.3e1 / 0.32e2 * t519 * t3113 * t10478 + 0.3e1 / 0.32e2 * t519 * t3126 * t10478 - t1667 * t3785 / 0.16e2 - t534 * t3163 * t191 * t1337 / 0.16e2 + t1667 * t3793 / 0.4e1;
  t15651 = t534 * t3163 * t418 * t1642 / 0.4e1 + t534 * t3167 * t418 * t1642 / 0.4e1 - t14045 + t14049 - t14052 + t14447 - t14457 - t14459 - t14462 + t14464 + t14467 - t14469 - t14473 + t14476 + t3601 - t3605 + t3608 - t3613 - t3503 + t3507;
  t15653 = t3511 - t3518 - t3715 + t3728 - t3705 + t3706 + t15394 + t15396 - t15398 - t15400 + t15402 + t15404 - t15406 - t15408 - t15411 - t2393 + t2407 + t2426 - t2430 - t2444;
  t15654 = -t2336 - t721 + t15152 - t15153 - t15154 - t15155 + t15156 - t15157 + t15158 + t15159 - t15160 - t14518 + t14521 - t14525 - t14564 + t14568 + t14588 - t14593 + t14596 - t14598;
  t15658 = my_piecewise3(t51, 0, t15464 + t15473 + t15534 + t15590 + t15642 + t15651 + t15653 + t15654);
  tv4rhosigmalapltau23 = t15658 * t3 + t3801;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t15660 = t14094 / 0.8e1;
  t15661 = t14096 / 0.8e1;
  t15662 = t14099 / 0.8e1;
  t15663 = t14114 / 0.16e2;
  t15664 = t14116 / 0.16e2;
  t15665 = t14119 / 0.16e2;
  t15666 = t14121 / 0.8e1;
  t15667 = t14125 / 0.8e1;
  t15668 = t14127 / 0.8e1;
  t15669 = t14198 / 0.32e2;
  t15670 = t14201 / 0.16e2;
  t15671 = t14203 / 0.16e2;
  t15672 = t14205 / 0.16e2;
  t15673 = t15660 + t15661 + t15662 - t15663 - t15664 - t15665 - t15666 - t15667 + t15668 - t15669 - t15670 + t15671 + t15672 - t14651 - t14652;
  t15674 = 0.3e1 / 0.16e2 * t14239;
  t15675 = t14251 / 0.2e1;
  t15676 = 0.3e1 / 0.8e1 * t14254;
  t15677 = 0.3e1 / 0.8e1 * t14260;
  t15678 = t14654 - t14655 - t14656 + t14657 + t14658 - t14659 + t14660 - t14661 + t14662 - t14663 + t14664 - t15674 + t15675 - t15676 + t15677;
  t15680 = t14264 / 0.8e1;
  t15714 = -t15680 - t3458 * t3180 / 0.16e2 + t3458 * t3184 / 0.16e2 + t1455 * t3831 / 0.4e1 + t484 * t3179 * t5542 / 0.4e1 - 0.3e1 / 0.16e2 * t1455 * t3834 - t1455 * t3823 / 0.16e2 - t484 * t866 * t478 * t986 / 0.16e2 - t1455 * t3812 / 0.8e1 - t484 * t3193 * t12897 / 0.8e1 + 0.3e1 / 0.32e2 * t1458 * t3815 + 0.3e1 / 0.32e2 * t1470 * t3815 + 0.3e1 / 0.32e2 * t469 * t3179 * t5591 - t3458 * t3213 / 0.16e2 + t3458 * t3216 / 0.16e2;
  t15722 = t3179 * t8229;
  t15726 = 0.3e1 / 0.32e2 * t1462 * t3834;
  t15728 = 0.3e1 / 0.64e2 * t1466 * t3809;
  t15730 = 0.3e1 / 0.64e2 * t1466 * t3828;
  t15732 = t1462 * t3823 / 0.32e2;
  t15734 = t1462 * t3812 / 0.16e2;
  t15736 = 0.3e1 / 0.64e2 * t1466 * t3815;
  t15738 = 0.3e1 / 0.32e2 * t1462 * t3806;
  t15740 = 0.3e1 / 0.32e2 * t1462 * t3809;
  t15748 = 0.3e1 / 0.16e2 * t1455 * t3806 + 0.3e1 / 0.16e2 * t484 * t3193 * t5591 - 0.3e1 / 0.16e2 * t1455 * t3809 - 0.3e1 / 0.16e2 * t484 * t15722 - t15726 - t15728 + t15730 - t15732 - t15734 + t15736 + t15738 - t15740 - 0.3e1 / 0.16e2 * t484 * t3183 * t12946 - 0.3e1 / 0.32e2 * t1458 * t3809 - 0.3e1 / 0.32e2 * t1470 * t3809;
  t15761 = t1462 * t3831 / 0.8e1;
  t15767 = t255 * t3803 / 0.64e2;
  t15770 = t3175 * t43;
  t15778 = t3183 * t4344;
  t15782 = t12326 * t4277;
  t15790 = t3183 * t1011;
  t15791 = t15790 * t14787;
  t15794 = t12326 * t4344;
  t15798 = -0.3e1 / 0.32e2 * t469 * t15722 + 0.3e1 / 0.32e2 * t1458 * t3828 + 0.3e1 / 0.32e2 * t1470 * t3828 + 0.3e1 / 0.32e2 * t469 * t3183 * t5542 + t15761 - t99 * t13041 * t866 * t269 / 0.32e2 - t15767 - t246 * t3803 / 0.32e2 + 0.3e1 / 0.8e1 * t484 * t15770 * t14778 - t484 * t3822 * t111 * t4319 / 0.16e2 - 0.25e2 / 0.16e2 * t484 * t15778 * t14787 + 0.15e2 / 0.16e2 * t484 * t15782 * t14787 + 0.11e2 / 0.16e2 * t484 * t3822 * t263 * t12919 + 0.11e2 / 0.16e2 * t469 * t15791 - 0.15e2 / 0.32e2 * t469 * t15794 * t14787;
  t15801 = t3179 * t999;
  t15802 = t15801 * t14787;
  t15808 = t3193 * t113;
  t15812 = t4280 * t866;
  t15813 = t15812 * t183;
  t15817 = t640 * t265;
  t15824 = t3193 * t265;
  t15828 = t5488 * t15813;
  t15831 = t2666 * t10042;
  t15844 = t1992 * t999;
  t15848 = 0.9e1 / 0.8e1 * t484 * t15791 - 0.3e1 / 0.2e1 * t484 * t15802 - t484 * t2653 * t10042 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t15808 * t14787 - 0.11e2 / 0.32e2 * t469 * t5483 * t15813 + 0.3e1 / 0.16e2 * t469 * t15817 * t10042 + 0.3e1 / 0.8e1 * t484 * t12421 * t10042 - 0.11e2 / 0.16e2 * t484 * t15824 * t14787 + 0.9e1 / 0.16e2 * t469 * t15828 - 0.3e1 / 0.8e1 * t484 * t15831 + 0.11e2 / 0.16e2 * t484 * t15828 + t484 * t11518 * t10042 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t2645 * t10042 - 0.3e1 / 0.16e2 * t469 * t15831 + 0.3e1 / 0.16e2 * t469 * t15844 * t10042;
  t15858 = t14277 / 0.4e1;
  t15859 = 0.3e1 / 0.16e2 * t14281;
  t15860 = 0.3e1 / 0.8e1 * t14285;
  t15861 = 0.3e1 / 0.16e2 * t14288;
  t15862 = -t484 * t2662 * t12407 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t15802 - 0.9e1 / 0.16e2 * t469 * t5509 * t15813 - t15858 + t15859 - t15860 + t15861 + t3818 + t3819 - t3820 - t3821 + t14756 - t14757 - t14758 + t14759;
  t15863 = -t14760 + t14761 - t3661 + t3662 - t3671 + t3684 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - t14774 + t14775 - t14776;
  t15867 = my_piecewise3(t2, 0, t15673 + t15678 + t15714 + t15748 + t15798 + t15848 + t15862 + t15863);
  tv4rhosigmatau20 = t15867 * t3 + t3838;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t15869 = t14342 / 0.16e2;
  t15870 = t14344 / 0.8e1;
  t15871 = t14346 / 0.8e1;
  t15872 = t14350 / 0.8e1;
  t15873 = t14360 / 0.32e2;
  t15874 = t14364 / 0.16e2;
  t15875 = t14366 / 0.16e2;
  t15876 = t14368 / 0.16e2;
  t15878 = 0.3e1 / 0.64e2 * t1578 * t3852;
  t15880 = 0.3e1 / 0.32e2 * t1589 * t3843;
  t15882 = 0.3e1 / 0.32e2 * t1589 * t3846;
  t15883 = -t15869 - t15870 + t15871 + t15872 - t15873 + t15874 - t15875 + t15876 + t14879 - t14880 - t14881 + t14882 - t14883 + t14884 - t14885 + t14886 + t15878 + t15880 - t15882;
  t15897 = 0.3e1 / 0.32e2 * t1589 * t3871;
  t15899 = 0.3e1 / 0.64e2 * t1578 * t3846;
  t15901 = 0.3e1 / 0.64e2 * t1578 * t3865;
  t15903 = t1589 * t3868 / 0.8e1;
  t15905 = t1589 * t3860 / 0.32e2;
  t15907 = t1589 * t3849 / 0.16e2;
  t15915 = t370 * t3840 / 0.64e2;
  t15918 = -t1585 * t3860 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t3846 - t1585 * t3849 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t3852 + 0.3e1 / 0.16e2 * t1585 * t3843 - 0.3e1 / 0.16e2 * t1585 * t3846 - t15897 - t15899 + t15901 + t15903 - t15905 - t15907 + 0.3e1 / 0.32e2 * t1574 * t3865 + t1585 * t3868 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t3871 - t15915 - t367 * t3840 / 0.32e2 - t2334 - t2336;
  t15920 = my_piecewise3(t51, 0, t15883 + t15918);
  tv4rhosigmatau28 = t15920 * t3 + t3875;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t15936 = -t15669 - t15670 + t15671 + t15672 + t14936 - t14937 + t14938 - t14939 + t14660 - t14661 + t14662 - t14663 - 0.3e1 / 0.32e2 * t1548 * t3809 + 0.3e1 / 0.32e2 * t1548 * t3828 + t1553 * t3831 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t3834 - t1553 * t3823 / 0.16e2 - 0.3e1 / 0.16e2 * t1553 * t3809 - t1553 * t3812 / 0.8e1;
  t15943 = t14394 / 0.16e2;
  t15944 = t14396 / 0.8e1;
  t15945 = t14398 / 0.8e1;
  t15946 = t14402 / 0.8e1;
  t15947 = 0.3e1 / 0.32e2 * t1548 * t3815 + 0.3e1 / 0.16e2 * t1553 * t3806 - t15726 - t15728 + t15730 - t15732 - t15734 + t15736 + t15738 - t15740 + t15761 - t345 * t3803 / 0.32e2 - t15767 - t15943 - t15944 + t15945 + t15946 - t2355 - t2316;
  t15949 = my_piecewise3(t2, 0, t15936 + t15947);
  tv4rhosigmatau29 = t15949 * t3 + t3838;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t15951 = -t15873 + t15874 - t15875 + t15876 - t14974 - t14975 + t14977 + t14978 - t14979 - t14980 - t14981 + t14982 + t14983 - t14883 + t14884;
  t15952 = t3772 * t10474;
  t15955 = t2181 * t1350;
  t15968 = t5234 * t883;
  t15969 = t15968 * t191;
  t15970 = t13979 * t15969;
  t15974 = t3278 * t450 * t15077;
  t15983 = t3302 * t170;
  t15990 = t679 * t420;
  t15994 = t683 * t420;
  t15998 = -t14885 + t14886 - 0.3e1 / 0.16e2 * t519 * t15952 + 0.3e1 / 0.16e2 * t519 * t15955 * t10474 + t534 * t12083 * t10474 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2758 * t10474 - t534 * t2785 * t7985 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t15970 + 0.11e2 / 0.16e2 * t534 * t15974 - 0.9e1 / 0.16e2 * t519 * t6189 * t15969 - t534 * t2778 * t10474 / 0.4e1 + 0.3e1 / 0.8e1 * t534 * t15983 * t15077 - 0.11e2 / 0.32e2 * t519 * t6181 * t15969 + 0.3e1 / 0.16e2 * t519 * t15990 * t10474 + 0.3e1 / 0.8e1 * t534 * t15994 * t10474;
  t16000 = t3302 * t420;
  t16038 = -0.11e2 / 0.16e2 * t534 * t16000 * t15077 + 0.9e1 / 0.16e2 * t519 * t15974 - 0.3e1 / 0.8e1 * t534 * t15952 + t1667 * t3868 / 0.4e1 + t534 * t3278 * t6264 / 0.4e1 - 0.3e1 / 0.16e2 * t1667 * t3871 - 0.3e1 / 0.16e2 * t534 * t3282 * t13324 - t1667 * t3860 / 0.16e2 - t534 * t883 * t528 * t1337 / 0.16e2 - t534 * t3302 * t13264 / 0.8e1 + 0.3e1 / 0.32e2 * t1670 * t3852 + 0.3e1 / 0.32e2 * t1674 * t3852 + 0.3e1 / 0.32e2 * t519 * t3278 * t6369 + t3513 * t3309 / 0.16e2 + 0.3e1 / 0.16e2 * t1667 * t3843;
  t16044 = t3278 * t8815;
  t16064 = 0.3e1 / 0.16e2 * t534 * t3302 * t6369 - 0.3e1 / 0.16e2 * t1667 * t3846 - 0.3e1 / 0.16e2 * t534 * t16044 - t1667 * t3849 / 0.8e1 - t3513 * t3306 / 0.16e2 - 0.3e1 / 0.32e2 * t1670 * t3846 - 0.3e1 / 0.32e2 * t1674 * t3846 - 0.3e1 / 0.32e2 * t519 * t16044 + 0.3e1 / 0.32e2 * t1670 * t3865 + 0.3e1 / 0.32e2 * t1674 * t3865 + 0.3e1 / 0.32e2 * t519 * t3282 * t6264 + t15878 + t15880 - t15882 - t15897;
  t16073 = t3274 * t75;
  t16081 = t12752 * t5356;
  t16085 = t3282 * t1362;
  t16086 = t16085 * t15077;
  t16089 = t12752 * t5344;
  t16093 = t3282 * t5344;
  t16101 = -t15899 + t15901 + t15903 - t15905 - t15907 - t15915 - t156 * t13427 * t883 * t424 / 0.32e2 - t409 * t3840 / 0.32e2 + 0.3e1 / 0.8e1 * t534 * t16073 * t6234 - t534 * t3859 * t168 * t5235 / 0.16e2 + 0.15e2 / 0.16e2 * t534 * t16081 * t15077 + 0.11e2 / 0.16e2 * t519 * t16086 - 0.15e2 / 0.32e2 * t519 * t16089 * t15077 - 0.25e2 / 0.16e2 * t534 * t16093 * t15077 + 0.11e2 / 0.16e2 * t534 * t3859 * t418 * t13298;
  t16110 = t14446 / 0.8e1;
  t16111 = t14456 / 0.16e2;
  t16112 = t14458 / 0.16e2;
  t16113 = t14461 / 0.16e2;
  t16114 = t14463 / 0.8e1;
  t16115 = t14466 / 0.8e1;
  t16116 = t14468 / 0.8e1;
  t16117 = t14472 / 0.8e1;
  t16118 = t14475 / 0.8e1;
  t16119 = -0.3e1 / 0.2e1 * t534 * t15970 + 0.9e1 / 0.8e1 * t534 * t16086 - t3513 * t3279 / 0.16e2 + t3513 * t3283 / 0.16e2 + t16110 - t16111 - t16112 - t16113 + t16114 + t16115 - t16116 - t16117 + t16118 + t3855 - t3856;
  t16121 = t3857 - t3858 - t3715 + t3728 - t3705 + t3706 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721 + t15152 - t15153;
  t16122 = 0.3e1 / 0.8e1 * t14517;
  t16123 = 0.3e1 / 0.8e1 * t14520;
  t16124 = t14524 / 0.8e1;
  t16125 = 0.3e1 / 0.8e1 * t14563;
  t16126 = t14567 / 0.2e1;
  t16127 = 0.3e1 / 0.16e2 * t14587;
  t16128 = t14592 / 0.4e1;
  t16129 = 0.3e1 / 0.16e2 * t14595;
  t16130 = 0.3e1 / 0.16e2 * t14597;
  t16131 = -t15154 - t15155 + t15156 - t15157 + t15158 + t15159 - t15160 - t16122 + t16123 - t16124 - t16125 + t16126 + t16127 - t16128 + t16129 - t16130;
  t16135 = my_piecewise3(t51, 0, t15951 + t15998 + t16038 + t16064 + t16101 + t16119 + t16121 + t16131);
  tv4rhosigmatau217 = t16135 * t3 + t3875;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t16146 = 0.3e1 / 0.64e2 * t13568;
  t16148 = 0.3e1 / 0.32e2 * t13570;
  t16149 = 0.3e1 / 0.32e2 * t13572;
  t16150 = 0.3e1 / 0.32e2 * t13574;
  t16152 = t255 * t3883 / 0.64e2;
  t16154 = 0.3e1 / 0.32e2 * t255 * t3888;
  t16156 = t255 * t3891 / 0.16e2;
  t16159 = t1030 * t3886;
  t16169 = t16148 - t16149 + t16150 - t16152 - t16154 - t16156 - 0.3e1 / 0.16e2 * t246 * t3917 + 0.3e1 / 0.32e2 * t99 * t16159 * t964 + 0.3e1 / 0.16e2 * t246 * t3898 - t246 * t3905 / 0.16e2 - 0.3e1 / 0.32e2 * t246 * t3908;
  t16189 = t200 * t263;
  t16192 = t200 * t43;
  t16195 = t4452 * t199;
  t16198 = t268 * t199;
  t16199 = t266 * t16198;
  t16223 = t12993 * t558 / 0.4e1 + t565 / 0.2e1 + t200 * t111 * t290 / 0.2e1 - t16189 * t491 / 0.2e1 - t16192 * t497 / 0.2e1 - t16195 * t13008 / 0.2e1 + t13011 * t16199 / 0.2e1 + t1023 * t563 * t116 / 0.2e1 + t3876 * t13020 / 0.2e1 - t3876 * t13023 / 0.2e1 - t3876 * t13026 / 0.2e1 - t4470 * t199 * t116 / 0.2e1 - t1026 * t563 * t116 / 0.2e1 - t3878 * t13020 / 0.2e1 + t3878 * t13023 / 0.2e1 + t3878 * t13026 / 0.2e1;
  t16235 = t255 * t3914 / 0.8e1;
  t16237 = 0.3e1 / 0.32e2 * t255 * t3917;
  t16238 = -0.3e1 / 0.32e2 * t99 * t16159 * t972 + 0.3e1 / 0.32e2 * t246 * t3911 + 0.3e1 / 0.32e2 * t99 * t16159 * t1001 + t246 * t3914 / 0.4e1 - t246 * t3883 / 0.32e2 - t99 * t16223 * t798 * t269 / 0.32e2 - 0.3e1 / 0.16e2 * t246 * t3888 - t246 * t3891 / 0.8e1 + 0.3e1 / 0.32e2 * t246 * t3895 + t16235 - t16237;
  t16240 = t255 * t3905 / 0.32e2;
  t16242 = 0.3e1 / 0.64e2 * t255 * t3908;
  t16244 = 0.3e1 / 0.64e2 * t255 * t3911;
  t16246 = 0.3e1 / 0.64e2 * t255 * t3895;
  t16248 = 0.3e1 / 0.32e2 * t255 * t3898;
  t16249 = t3886 * t263;
  t16253 = t3886 * t997;
  t16254 = t16253 * t12919;
  t16257 = t3886 * t4275;
  t16268 = -t16240 - t16242 + t16244 + t16246 + t16248 + 0.11e2 / 0.16e2 * t484 * t16249 * t12919 + 0.11e2 / 0.16e2 * t469 * t16254 - 0.15e2 / 0.32e2 * t469 * t16257 * t12928 - 0.25e2 / 0.16e2 * t484 * t16253 * t12928 - t3969 * t2837 / 0.16e2 + t3969 * t2841 / 0.16e2;
  t16271 = t16249 * t12973;
  t16276 = t16249 * t12967;
  t16279 = t3886 * t43;
  t16283 = t5733 * t3886;
  t16297 = t2836 * t6489;
  t16303 = t5635 * t3886;
  t16307 = t1516 * t563;
  t16314 = t3886 * t111;
  t16327 = t1450 * t563;
  t16336 = 0.11e2 / 0.16e2 * t484 * t16276 - 0.9e1 / 0.16e2 * t469 * t5508 * t16303 - 0.3e1 / 0.8e1 * t484 * t2856 * t16307 + 0.15e2 / 0.16e2 * t484 * t16257 * t12963 - 0.11e2 / 0.16e2 * t484 * t16314 * t4309 + 0.3e1 / 0.8e1 * t484 * t16314 * t4414 - t484 * t16314 * t4319 / 0.16e2 + 0.3e1 / 0.4e1 * t484 * t2836 * t6493 - 0.9e1 / 0.16e2 * t484 * t2840 * t16327 - 0.3e1 / 0.16e2 * t484 * t2856 * t6489 - 0.7e1 / 0.32e2 * t469 * t16271;
  t16343 = -0.9e1 / 0.32e2 * t469 * t16297 + 0.9e1 / 0.32e2 * t469 * t2840 * t6493 + t3901 - t3902 + t3903 - t3904 - t2246 + t2254 + t2296 - t2300 - t2316;
  t16353 = -t2320 - t699 - 0.9e1 / 0.32e2 * t13638 + 0.9e1 / 0.32e2 * t13668 - 0.3e1 / 0.8e1 * t13673 + 0.9e1 / 0.32e2 * t13676 + 0.9e1 / 0.16e2 * t13679 - 0.3e1 / 0.16e2 * t13683 - 0.9e1 / 0.16e2 * t13715 - 0.9e1 / 0.16e2 * t13731 + 0.3e1 / 0.4e1 * t13735;
  t16357 = my_piecewise3(t2, 0, -t3969 * t2860 / 0.16e2 + t3969 * t2863 / 0.16e2 - 0.9e1 / 0.16e2 * t484 * t16297 - 0.3e1 / 0.2e1 * t484 * t16271 + 0.9e1 / 0.8e1 * t484 * t16254 + 0.9e1 / 0.16e2 * t469 * t16276 + 0.3e1 / 0.8e1 * t484 * t16279 * t12902 - 0.11e2 / 0.32e2 * t469 * t470 * t16283 + 0.9e1 / 0.32e2 * t469 * t2836 * t6720 + 0.9e1 / 0.16e2 * t484 * t2856 * t6720 - 0.3e1 / 0.16e2 * t13548 - 0.3e1 / 0.16e2 * t13544 - 0.3e1 / 0.32e2 * t13540 - 0.3e1 / 0.32e2 * t13535 - 0.3e1 / 0.32e2 * t13537 + 0.3e1 / 0.16e2 * t13495 + 0.3e1 / 0.16e2 * t13492 + 0.3e1 / 0.16e2 * t13479 - t16146 + 0.3e1 / 0.16e2 * t13476 + t16169 + t16353 + t16343 + t16336 + t16268 + t16238);
  tv4rholapl30 = t16357 * t3 + t3921;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t16363 = 0.3e1 / 0.32e2 * t13794;
  t16364 = 0.3e1 / 0.32e2 * t13796;
  t16365 = 0.3e1 / 0.32e2 * t13798;
  t16366 = 0.3e1 / 0.64e2 * t13804;
  t16368 = t370 * t3951 / 0.32e2;
  t16370 = 0.3e1 / 0.64e2 * t370 * t3954;
  t16372 = 0.3e1 / 0.32e2 * t370 * t3941;
  t16374 = 0.3e1 / 0.32e2 * t370 * t3944;
  t16376 = t370 * t3929 / 0.64e2;
  t16378 = t370 * t3934 / 0.16e2;
  t16380 = 0.3e1 / 0.64e2 * t370 * t3938;
  t16381 = -0.3e1 / 0.32e2 * t13767 - 0.3e1 / 0.16e2 * t13769 + 0.3e1 / 0.16e2 * t13771 + 0.3e1 / 0.16e2 * t13773 - t16363 + t16364 + t16365 - t16366 - t16368 - t16370 + t16372 - t16374 - t16376 - t16378 + t16380;
  t16403 = 0.3e1 / 0.64e2 * t370 * t3957;
  t16405 = t370 * t3960 / 0.8e1;
  t16407 = 0.3e1 / 0.32e2 * t370 * t3963;
  t16408 = 0.3e1 / 0.32e2 * t367 * t3957 + t367 * t3960 / 0.4e1 - 0.3e1 / 0.16e2 * t367 * t3963 + 0.3e1 / 0.32e2 * t367 * t3938 + 0.3e1 / 0.16e2 * t367 * t3941 - 0.3e1 / 0.16e2 * t367 * t3944 - t367 * t3951 / 0.16e2 - 0.3e1 / 0.32e2 * t367 * t3954 - t367 * t3929 / 0.32e2 - t367 * t3934 / 0.8e1 + t16403 + t16405 - t16407 - t2334 - t2336;
  t16410 = my_piecewise3(t51, 0, t16381 + t16408);
  tv4rholapl33 = t16410 * t3 + t3967;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t16430 = -0.3e1 / 0.32e2 * t13832 - 0.3e1 / 0.16e2 * t13834 + 0.3e1 / 0.16e2 * t13836 + 0.3e1 / 0.16e2 * t13841 - t16146 + t16148 - t16149 + t16150 + 0.3e1 / 0.16e2 * t345 * t3898 - t345 * t3905 / 0.16e2 - 0.3e1 / 0.32e2 * t345 * t3908 + 0.3e1 / 0.32e2 * t345 * t3911 + t345 * t3914 / 0.4e1 - 0.3e1 / 0.16e2 * t345 * t3917 - t345 * t3883 / 0.32e2;
  t16437 = -0.3e1 / 0.16e2 * t345 * t3888 - t345 * t3891 / 0.8e1 + 0.3e1 / 0.32e2 * t345 * t3895 - t16152 - t16154 - t16156 + t16235 - t16237 - t16240 - t16242 + t16244 + t16246 + t16248 - t2355 - t2316;
  t16439 = my_piecewise3(t2, 0, t16430 + t16437);
  tv4rholapl34 = t16439 * t3 + t3921;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t16461 = t16364 + t16365 - t16366 + 0.9e1 / 0.32e2 * t13959 - 0.3e1 / 0.8e1 * t13962 + 0.9e1 / 0.32e2 * t13965 + 0.9e1 / 0.16e2 * t14017 - 0.9e1 / 0.32e2 * t14020 - 0.9e1 / 0.16e2 * t14022 - 0.3e1 / 0.16e2 * t409 * t3944 - t409 * t3951 / 0.16e2;
  t16465 = t1303 * t3932;
  t16486 = t208 * t418;
  t16489 = t208 * t75;
  t16492 = t5270 * t207;
  t16495 = t423 * t207;
  t16496 = t421 * t16495;
  t16520 = t13379 * t597 / 0.4e1 + t604 / 0.2e1 + t208 * t168 * t445 / 0.2e1 - t16486 * t541 / 0.2e1 - t16489 * t547 / 0.2e1 - t16492 * t13394 / 0.2e1 + t13397 * t16496 / 0.2e1 + t1296 * t602 * t173 / 0.2e1 + t3922 * t13406 / 0.2e1 - t3922 * t13409 / 0.2e1 - t3922 * t13412 / 0.2e1 - t5288 * t207 * t173 / 0.2e1 - t1299 * t602 * t173 / 0.2e1 - t3924 * t13406 / 0.2e1 + t3924 * t13409 / 0.2e1 + t3924 * t13412 / 0.2e1;
  t16532 = -0.3e1 / 0.32e2 * t409 * t3954 - 0.3e1 / 0.32e2 * t156 * t16465 * t1344 + 0.3e1 / 0.32e2 * t409 * t3957 + 0.3e1 / 0.32e2 * t156 * t16465 * t1352 + t409 * t3960 / 0.4e1 - 0.3e1 / 0.16e2 * t409 * t3963 - t409 * t3929 / 0.32e2 - t156 * t16520 * t815 * t424 / 0.32e2 - t409 * t3934 / 0.8e1 + 0.3e1 / 0.32e2 * t409 * t3938 + 0.3e1 / 0.32e2 * t156 * t16465 * t1382;
  t16535 = 0.3e1 / 0.16e2 * t409 * t3941 - t16368 - t16370 + t16372 - t16374 - t16376 - t16378 + t16380 + t16403 + t16405 - t16407;
  t16538 = t3932 * t1348;
  t16542 = t3932 * t5342;
  t16550 = t3932 * t418;
  t16551 = t16550 * t13288;
  t16559 = t16550 * t13318;
  t16562 = t16538 * t13298;
  t16574 = t2935 * t7139;
  t16581 = t1633 * t602;
  t16585 = t3932 * t75;
  t16589 = t6307 * t3932;
  t16596 = t3932 * t168;
  t16603 = 0.11e2 / 0.16e2 * t519 * t16562 - 0.15e2 / 0.32e2 * t519 * t16542 * t13307 - 0.9e1 / 0.16e2 * t534 * t16574 - t4005 * t2969 / 0.16e2 + t4005 * t2972 / 0.16e2 - 0.3e1 / 0.8e1 * t534 * t2952 * t16581 + 0.3e1 / 0.8e1 * t534 * t16585 * t13269 - 0.11e2 / 0.32e2 * t519 * t520 * t16589 + 0.9e1 / 0.32e2 * t519 * t2935 * t7271 - 0.11e2 / 0.16e2 * t534 * t16596 * t5389 + 0.3e1 / 0.8e1 * t534 * t16596 * t5411;
  t16608 = t1650 * t602;
  t16631 = -t534 * t16596 * t5235 / 0.16e2 - 0.9e1 / 0.16e2 * t534 * t2939 * t16608 - 0.7e1 / 0.32e2 * t519 * t16559 - 0.9e1 / 0.32e2 * t519 * t16574 + 0.9e1 / 0.32e2 * t519 * t2939 * t7143 + 0.3e1 / 0.4e1 * t534 * t2935 * t7143 - 0.3e1 / 0.16e2 * t534 * t2952 * t7139 + 0.9e1 / 0.16e2 * t534 * t2952 * t7271 - 0.3e1 / 0.16e2 * t14044 + 0.3e1 / 0.4e1 * t14048 - 0.9e1 / 0.16e2 * t14051;
  t16632 = -t3947 + t3948 + t3949 - t3950 - t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721;
  t16636 = my_piecewise3(t51, 0, -t4005 * t2936 / 0.16e2 + t4005 * t2940 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t16551 + 0.9e1 / 0.16e2 * t519 * t16551 - 0.3e1 / 0.2e1 * t534 * t16559 + 0.9e1 / 0.8e1 * t534 * t16562 - 0.3e1 / 0.16e2 * t13915 - 0.3e1 / 0.16e2 * t13911 + 0.3e1 / 0.16e2 * t13898 + 0.3e1 / 0.16e2 * t13895 - 0.3e1 / 0.32e2 * t13884 - 0.3e1 / 0.32e2 * t13887 - 0.3e1 / 0.32e2 * t13882 + 0.3e1 / 0.16e2 * t13859 + 0.3e1 / 0.16e2 * t13856 - 0.25e2 / 0.16e2 * t534 * t16538 * t13307 + 0.15e2 / 0.16e2 * t534 * t16542 * t13314 - 0.9e1 / 0.16e2 * t519 * t16538 * t13318 + 0.11e2 / 0.16e2 * t534 * t16550 * t13298 + t16632 + t16631 + t16603 + t16535 + t16532 + t16461 - t16363);
  tv4rholapl37 = t16636 * t3 + t3967;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  t16638 = t14095 + t14097 + t14100 - t14115 - t14117 - t14120 - t14122 - t14126 + t14128 - t14199 - t14202 + t14204 + t14206 + t14638 + t14639;
  t16639 = t14640 + t14641 - t14642 - t14643 - t14644 - t14645 - t14646 - t14647 + t14648 - t14649 + t14650 - t14240 + t14252 - t14255 + t14261;
  t16641 = t14818 * t111;
  t16642 = t2645 * t16641;
  t16645 = t3979 * t263;
  t16654 = t3979 * t997;
  t16661 = t2666 * t16641;
  t16666 = t2840 * t999;
  t16670 = t16645 * t12973;
  t16680 = t3979 * t111;
  t16684 = -t14265 + 0.9e1 / 0.8e1 * t484 * t16642 + 0.11e2 / 0.16e2 * t484 * t16645 * t12919 + 0.11e2 / 0.16e2 * t469 * t16642 - 0.15e2 / 0.32e2 * t469 * t14791 * t14224 - 0.25e2 / 0.16e2 * t484 * t16654 * t12928 + 0.15e2 / 0.16e2 * t484 * t9912 * t16641 + 0.11e2 / 0.16e2 * t484 * t16661 + 0.9e1 / 0.16e2 * t469 * t16661 - 0.9e1 / 0.16e2 * t469 * t16666 * t14224 - 0.3e1 / 0.2e1 * t484 * t16670 - t3969 * t2999 / 0.16e2 + t3969 * t3007 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t7348 * t10849 + 0.3e1 / 0.8e1 * t484 * t16680 * t4414;
  t16691 = t2666 * t10907;
  t16705 = t9925 * t798;
  t16730 = -t484 * t16680 * t4319 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t3019 * t6720 - 0.3e1 / 0.8e1 * t484 * t16691 - t484 * t3019 * t6489 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t16670 + 0.3e1 / 0.8e1 * t484 * t2653 * t16641 - t484 * t2653 * t10907 / 0.4e1 - 0.11e2 / 0.32e2 * t469 * t5483 * t16705 + 0.3e1 / 0.16e2 * t469 * t3015 * t11550 + t3969 * t3016 / 0.16e2 - 0.3e1 / 0.8e1 * t484 * t2645 * t10907 - 0.3e1 / 0.16e2 * t469 * t16691 + 0.3e1 / 0.16e2 * t469 * t3006 * t11550 + t484 * t2992 * t6493 / 0.2e1 - t484 * t2041 * t3972 / 0.8e1 - t3969 * t3042 / 0.32e2;
  t16745 = t23 * t95 * t3881 * t832 / 0.64e2;
  t16747 = 0.3e1 / 0.64e2 * t1466 * t3984;
  t16749 = 0.3e1 / 0.64e2 * t1466 * t3992;
  t16751 = t1462 * t3995 / 0.8e1;
  t16753 = 0.3e1 / 0.32e2 * t1462 * t3999;
  t16755 = 0.3e1 / 0.32e2 * t1462 * t3980;
  t16757 = 0.3e1 / 0.32e2 * t1462 * t3984;
  t16759 = t1462 * t3987 / 0.32e2;
  t16761 = t1462 * t3973 / 0.16e2;
  t16763 = 0.3e1 / 0.64e2 * t1466 * t3976;
  t16768 = -t3969 * t3045 / 0.32e2 - t91 * t3968 * t832 / 0.32e2 - t23 * t26 * t16223 * t832 / 0.32e2 - t16745 - t16747 + t16749 + t16751 - t16753 + t16755 - t16757 - t16759 - t16761 + t16763 - 0.3e1 / 0.32e2 * t1458 * t3984 - 0.3e1 / 0.32e2 * t1470 * t3984;
  t16769 = t2836 * t12407;
  t16781 = t631 * t798;
  t16806 = -0.3e1 / 0.32e2 * t469 * t16769 + 0.3e1 / 0.32e2 * t1458 * t3992 + 0.3e1 / 0.32e2 * t1470 * t3992 + 0.3e1 / 0.32e2 * t469 * t2840 * t7584 + t1455 * t3995 / 0.4e1 + t484 * t16781 * t1006 / 0.4e1 - 0.3e1 / 0.16e2 * t1455 * t3999 - 0.3e1 / 0.16e2 * t484 * t7603 * t3998 + 0.3e1 / 0.32e2 * t1458 * t3976 + 0.3e1 / 0.32e2 * t1470 * t3976 + 0.3e1 / 0.32e2 * t469 * t2836 * t7473 + 0.3e1 / 0.16e2 * t1455 * t3980 + 0.3e1 / 0.16e2 * t484 * t16781 * t968 - 0.3e1 / 0.16e2 * t1455 * t3984 - 0.3e1 / 0.16e2 * t484 * t16769;
  t16815 = -t1455 * t3987 / 0.16e2 - t484 * t16781 * t986 / 0.16e2 - t1455 * t3973 / 0.8e1 - t14278 + t14282 - t14286 + t14289 + t3557 + t3560 - t3565 - t3569 + t3657 - t3658 + t3659 - t3660;
  t16816 = -t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - t14763 + t14764 - t14765 + t14766 + t14767 - t14768 - t14771 - t14772 + t14773;
  t16820 = my_piecewise3(t2, 0, t16638 + t16639 + t16684 + t16730 + t16768 + t16806 + t16815 + t16816);
  tv4rholapl2tau0 = t16820 * t3 + t4003;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  t16825 = 0.3e1 / 0.32e2 * t1589 * t4009;
  t16827 = t1589 * t4013 / 0.16e2;
  t16828 = -t14343 - t14345 + t14347 + t14351 - t14361 + t14365 - t14367 + t14369 - t14871 - t14872 + t14873 + t14874 - t14875 + t14876 + t14877 - t14878 - 0.3e1 / 0.16e2 * t1585 * t4035 - t16825 - t16827;
  t16830 = 0.3e1 / 0.64e2 * t1578 * t4016;
  t16834 = t60 * t95 * t3927 * t849 / 0.64e2;
  t16855 = t1589 * t4031 / 0.8e1;
  t16857 = 0.3e1 / 0.32e2 * t1589 * t4035;
  t16859 = 0.3e1 / 0.32e2 * t1589 * t4020;
  t16861 = t1589 * t4023 / 0.32e2;
  t16863 = 0.3e1 / 0.64e2 * t1578 * t4009;
  t16865 = 0.3e1 / 0.64e2 * t1578 * t4028;
  t16866 = t16830 - t16834 - 0.3e1 / 0.32e2 * t1574 * t4009 + 0.3e1 / 0.32e2 * t1574 * t4028 + t1585 * t4031 / 0.4e1 + 0.3e1 / 0.16e2 * t1585 * t4020 - t1585 * t4023 / 0.16e2 - 0.3e1 / 0.16e2 * t1585 * t4009 - t1585 * t4013 / 0.8e1 + 0.3e1 / 0.32e2 * t1574 * t4016 - t128 * t4004 * t849 / 0.32e2 + t16855 - t16857 + t16859 - t16861 - t16863 + t16865 - t2334 - t2336;
  t16868 = my_piecewise3(t51, 0, t16828 + t16866);
  tv4rholapl2tau5 = t16868 * t3 + t4039;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  t16884 = -t14199 - t14202 + t14204 + t14206 - t14932 - t14933 + t14934 + t14935 - t14647 + t14648 - t14649 + t14650 - 0.3e1 / 0.16e2 * t1553 * t3999 - 0.3e1 / 0.16e2 * t1553 * t3984 - t1553 * t3987 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t3984 + 0.3e1 / 0.32e2 * t1548 * t3992 + t1553 * t3995 / 0.4e1 - t1553 * t3973 / 0.8e1;
  t16892 = 0.3e1 / 0.32e2 * t1548 * t3976 + 0.3e1 / 0.16e2 * t1553 * t3980 - t143 * t3968 * t832 / 0.32e2 - t16745 - t16747 + t16749 + t16751 - t16753 + t16755 - t16757 - t16759 - t16761 + t16763 - t14395 - t14397 + t14399 + t14403 - t2355 - t2316;
  t16894 = my_piecewise3(t2, 0, t16884 + t16892);
  tv4rholapl2tau6 = t16894 * t3 + t4003;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  t16896 = -t14361 + t14365 - t14367 + t14369 + t14965 + t14966 - t14967 - t14968 - t14969 + t14970 + t14971 - t14972 - t14973 - t14875 + t14876;
  t16911 = t670 * t815;
  t16931 = t14877 - t14878 - t1667 * t4013 / 0.8e1 - t534 * t2212 * t4012 / 0.8e1 + 0.3e1 / 0.32e2 * t1670 * t4016 + 0.3e1 / 0.32e2 * t1674 * t4016 + 0.3e1 / 0.32e2 * t519 * t2935 * t8090 + 0.3e1 / 0.16e2 * t1667 * t4020 + 0.3e1 / 0.16e2 * t534 * t16911 * t1369 - t153 * t4004 * t849 / 0.32e2 - t60 * t26 * t16520 * t849 / 0.32e2 - t4005 * t3155 / 0.32e2 - t4005 * t3158 / 0.32e2 - 0.3e1 / 0.16e2 * t534 * t8043 * t4034 - t1667 * t4023 / 0.16e2;
  t16940 = t2935 * t7985;
  t16961 = t15109 * t168;
  t16962 = t3772 * t16961;
  t16965 = t3772 * t11184;
  t16968 = t10460 * t815;
  t16972 = -t534 * t16911 * t1337 / 0.16e2 - 0.3e1 / 0.32e2 * t1670 * t4009 - 0.3e1 / 0.32e2 * t1674 * t4009 - 0.3e1 / 0.32e2 * t519 * t16940 + 0.3e1 / 0.32e2 * t1670 * t4028 + 0.3e1 / 0.32e2 * t1674 * t4028 + 0.3e1 / 0.32e2 * t519 * t2939 * t7989 + t1667 * t4031 / 0.4e1 + t534 * t16911 * t1357 / 0.4e1 - 0.3e1 / 0.16e2 * t1667 * t4035 - 0.3e1 / 0.16e2 * t1667 * t4009 - 0.3e1 / 0.16e2 * t534 * t16940 + 0.11e2 / 0.16e2 * t534 * t16962 - 0.3e1 / 0.8e1 * t534 * t16965 - 0.9e1 / 0.16e2 * t519 * t6189 * t16968;
  t16991 = t13979 * t16968;
  t16997 = t4019 * t168;
  t17006 = t4019 * t418;
  t17014 = t15085 * t14542;
  t17020 = 0.3e1 / 0.8e1 * t534 * t2778 * t16961 - t534 * t2778 * t11184 / 0.4e1 - 0.11e2 / 0.32e2 * t519 * t6181 * t16968 + 0.3e1 / 0.16e2 * t519 * t3126 * t12036 + 0.3e1 / 0.8e1 * t534 * t3130 * t7271 - t534 * t3130 * t7139 / 0.8e1 - 0.7e1 / 0.32e2 * t519 * t16991 - 0.11e2 / 0.16e2 * t534 * t12834 * t11307 + 0.3e1 / 0.8e1 * t534 * t16997 * t5411 - t534 * t16997 * t5235 / 0.16e2 + 0.9e1 / 0.16e2 * t519 * t16962 + 0.11e2 / 0.16e2 * t534 * t17006 * t13298 + t4005 * t3114 / 0.16e2 - t4005 * t3110 / 0.16e2 + 0.11e2 / 0.16e2 * t519 * t17014 - 0.15e2 / 0.32e2 * t519 * t15089 * t14542;
  t17023 = t4019 * t1348;
  t17036 = -0.25e2 / 0.16e2 * t534 * t17023 * t13307 + 0.15e2 / 0.16e2 * t534 * t10627 * t16961 - 0.3e1 / 0.2e1 * t534 * t16991 + 0.9e1 / 0.8e1 * t534 * t17014 + t4005 * t3127 / 0.16e2 - t16825 - t16827 + t16830 - t16834 + t16855 - t16857 + t16859 - t16861 - t16863 + t16865;
  t17048 = t15046 - t15047 + t15048 + t15049 - t15050 - t15051 - 0.3e1 / 0.16e2 * t519 * t16965 + 0.3e1 / 0.16e2 * t519 * t3113 * t12036 + t534 * t3117 * t7143 / 0.2e1 - 0.3e1 / 0.8e1 * t534 * t2758 * t11184 - t15061 + t15062 - t15063 + t14447 - t14457;
  t17050 = -t14459 - t14462 + t14464 + t14467 - t14469 - t14473 + t14476 + t3601 - t3605 + t3608 - t3613 - t3701 + t3702 + t3703 - t3704;
  t17051 = -t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721 - t14518 + t14521 - t14525 - t14564 + t14568 + t14588 - t14593 + t14596 - t14598;
  t17055 = my_piecewise3(t51, 0, t16896 + t16931 + t16972 + t17020 + t17036 + t17048 + t17050 + t17051);
  tv4rholapl2tau11 = t17055 * t3 + t4039;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  t17057 = t15660 + t15661 + t15662 - t15663 - t15664 - t15665 - t15666 - t15667 + t15668 - t15669 - t15670 + t15671 + t15672 + t13477 + t13480;
  t17058 = t13493 + t13496 - t13536 - t13538 - t13541 - t13545 - t13549 - t13569 + t13571 - t13573 + t13575 - t15674 + t15675 - t15676 + t15677;
  t17067 = t255 * t4041 / 0.64e2;
  t17068 = t15790 * t13612;
  t17080 = t4058 * t263;
  t17084 = t15801 * t13612;
  t17101 = -t15680 - t246 * t4041 / 0.32e2 - t99 * t16223 * t866 * t269 / 0.32e2 - t17067 + 0.11e2 / 0.16e2 * t469 * t17068 - 0.15e2 / 0.32e2 * t469 * t15794 * t13612 - 0.25e2 / 0.16e2 * t484 * t15778 * t13612 + 0.15e2 / 0.16e2 * t484 * t15782 * t13612 + 0.11e2 / 0.16e2 * t484 * t17080 * t12919 - 0.3e1 / 0.2e1 * t484 * t17084 + 0.9e1 / 0.8e1 * t484 * t17068 + 0.3e1 / 0.16e2 * t469 * t15844 * t11546 + t484 * t11518 * t11546 / 0.2e1 - 0.3e1 / 0.8e1 * t484 * t2645 * t11546 - t484 * t3019 * t12407 / 0.8e1;
  t17104 = t2666 * t11546;
  t17116 = t15812 * t199;
  t17117 = t5488 * t17116;
  t17136 = t5627 * t199;
  t17145 = 0.3e1 / 0.32e2 * t1462 * t4044;
  t17146 = -0.7e1 / 0.32e2 * t469 * t17084 - 0.3e1 / 0.16e2 * t469 * t17104 + 0.3e1 / 0.16e2 * t469 * t15817 * t11546 + 0.3e1 / 0.8e1 * t484 * t12421 * t11546 - 0.11e2 / 0.16e2 * t484 * t15824 * t13612 + 0.9e1 / 0.16e2 * t469 * t17117 - 0.3e1 / 0.8e1 * t484 * t17104 + 0.11e2 / 0.16e2 * t484 * t17117 - 0.9e1 / 0.16e2 * t469 * t5509 * t17116 - t484 * t2653 * t11546 / 0.4e1 + 0.3e1 / 0.8e1 * t484 * t15808 * t13612 - 0.11e2 / 0.32e2 * t469 * t5483 * t17116 + 0.3e1 / 0.8e1 * t484 * t15770 * t17136 - t484 * t4058 * t111 * t4319 / 0.16e2 + t17145;
  t17150 = 0.3e1 / 0.64e2 * t1466 * t4064;
  t17152 = t1462 * t4067 / 0.8e1;
  t17154 = 0.3e1 / 0.32e2 * t1462 * t4071;
  t17156 = t1462 * t4059 / 0.32e2;
  t17158 = 0.3e1 / 0.64e2 * t1466 * t4048;
  t17160 = 0.3e1 / 0.32e2 * t1462 * t4048;
  t17162 = t1462 * t4052 / 0.16e2;
  t17164 = 0.3e1 / 0.64e2 * t1466 * t4055;
  t17173 = t3179 * t6489;
  t17181 = t17150 + t17152 - t17154 - t17156 - t17158 - t17160 - t17162 + t17164 - t3969 * t3180 / 0.16e2 + t3969 * t3184 / 0.16e2 - 0.3e1 / 0.32e2 * t1458 * t4048 - 0.3e1 / 0.32e2 * t1470 * t4048 - 0.3e1 / 0.32e2 * t469 * t17173 - t484 * t3193 * t16307 / 0.8e1 + 0.3e1 / 0.32e2 * t1458 * t4055;
  t17216 = 0.3e1 / 0.32e2 * t1470 * t4055 + 0.3e1 / 0.32e2 * t469 * t3179 * t6720 - t3969 * t3213 / 0.16e2 + t3969 * t3216 / 0.16e2 + 0.3e1 / 0.16e2 * t1455 * t4044 + 0.3e1 / 0.16e2 * t484 * t3193 * t6720 - 0.3e1 / 0.16e2 * t1455 * t4048 - 0.3e1 / 0.16e2 * t484 * t17173 - t1455 * t4052 / 0.8e1 + 0.3e1 / 0.32e2 * t1458 * t4064 + 0.3e1 / 0.32e2 * t1470 * t4064 + 0.3e1 / 0.32e2 * t469 * t3183 * t6493 + t1455 * t4067 / 0.4e1 + t484 * t3179 * t6493 / 0.4e1 - 0.3e1 / 0.16e2 * t1455 * t4071;
  t17227 = -0.3e1 / 0.16e2 * t484 * t3183 * t16327 - t1455 * t4059 / 0.16e2 - t484 * t866 * t563 * t986 / 0.16e2 - t15858 + t15859 - t15860 + t15861 + t3818 + t3819 - t3820 - t3821 + t3448 - t3452 + t3456 - t3463;
  t17228 = -t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699 - t13639 + t13669 - t13674 + t13677 + t13680 - t13684 - t13716 - t13732 + t13736;
  t17232 = my_piecewise3(t2, 0, t17057 + t17058 + t17101 + t17146 + t17181 + t17216 + t17227 + t17228);
  tv4rholapltau20 = t17232 * t3 + t4075;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  t17235 = t370 * t4077 / 0.64e2;
  t17239 = 0.3e1 / 0.32e2 * t1589 * t4080;
  t17240 = -t15869 - t15870 + t15871 + t15872 - t15873 + t15874 - t15875 + t15876 - t13768 - t13770 + t13772 + t13774 - t13795 + t13797 + t13799 - t13805 - t17235 - t367 * t4077 / 0.32e2 + t17239;
  t17242 = 0.3e1 / 0.32e2 * t1589 * t4083;
  t17244 = t1589 * t4087 / 0.16e2;
  t17248 = 0.3e1 / 0.32e2 * t1589 * t4106;
  t17250 = t1589 * t4094 / 0.32e2;
  t17252 = 0.3e1 / 0.64e2 * t1578 * t4083;
  t17254 = 0.3e1 / 0.64e2 * t1578 * t4099;
  t17256 = t1589 * t4102 / 0.8e1;
  t17258 = 0.3e1 / 0.64e2 * t1578 * t4090;
  t17275 = -t17242 - t17244 - t1585 * t4087 / 0.8e1 - t17248 - t17250 - t17252 + t17254 + t17256 + t17258 + t1585 * t4102 / 0.4e1 - 0.3e1 / 0.16e2 * t1585 * t4106 - t1585 * t4094 / 0.16e2 - 0.3e1 / 0.32e2 * t1574 * t4083 + 0.3e1 / 0.32e2 * t1574 * t4099 + 0.3e1 / 0.32e2 * t1574 * t4090 + 0.3e1 / 0.16e2 * t1585 * t4080 - 0.3e1 / 0.16e2 * t1585 * t4083 - t2334 - t2336;
  t17277 = my_piecewise3(t51, 0, t17240 + t17275);
  tv4rholapltau25 = t17277 * t3 + t4110;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  t17291 = -t15669 - t15670 + t15671 + t15672 - t13833 - t13835 + t13837 + t13842 - t13569 + t13571 - t13573 + t13575 - t17067 - t345 * t4041 / 0.32e2 + 0.3e1 / 0.32e2 * t1548 * t4064 + t1553 * t4067 / 0.4e1 - 0.3e1 / 0.16e2 * t1553 * t4071 - t1553 * t4059 / 0.16e2 - 0.3e1 / 0.32e2 * t1548 * t4048;
  t17300 = -t1553 * t4052 / 0.8e1 + 0.3e1 / 0.32e2 * t1548 * t4055 + 0.3e1 / 0.16e2 * t1553 * t4044 - 0.3e1 / 0.16e2 * t1553 * t4048 + t17145 + t17150 + t17152 - t17154 - t17156 - t17158 - t17160 - t17162 + t17164 - t15943 - t15944 + t15945 + t15946 - t2355 - t2316;
  t17302 = my_piecewise3(t2, 0, t17291 + t17300);
  tv4rholapltau26 = t17302 * t3 + t4075;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  t17304 = -t15873 + t15874 - t15875 + t15876 + t13857 + t13860 - t13883 - t13885 - t13888 + t13896 + t13899 - t13912 - t13916 - t13795 + t13797;
  t17325 = t3278 * t7139;
  t17328 = t13799 - t13805 + t4005 * t3283 / 0.16e2 - t4005 * t3279 / 0.16e2 + 0.3e1 / 0.32e2 * t1674 * t4090 + 0.3e1 / 0.32e2 * t519 * t3278 * t7271 - t4005 * t3306 / 0.16e2 + t4005 * t3309 / 0.16e2 + 0.3e1 / 0.16e2 * t1667 * t4080 + 0.3e1 / 0.16e2 * t534 * t3302 * t7271 - 0.3e1 / 0.16e2 * t1667 * t4083 - 0.3e1 / 0.16e2 * t534 * t17325 + t13960 - t13963 + t13966;
  t17345 = t4093 * t418;
  t17349 = t16085 * t14028;
  t17352 = t3278 * t1350;
  t17353 = t17352 * t14028;
  t17363 = t14018 - t14021 - t14023 - t409 * t4077 / 0.32e2 - t156 * t16520 * t883 * t424 / 0.32e2 - t17235 - 0.15e2 / 0.32e2 * t519 * t16089 * t14028 - 0.25e2 / 0.16e2 * t534 * t16093 * t14028 + 0.15e2 / 0.16e2 * t534 * t16081 * t14028 + 0.11e2 / 0.16e2 * t534 * t17345 * t13298 + 0.11e2 / 0.16e2 * t519 * t17349 - 0.3e1 / 0.2e1 * t534 * t17353 + 0.9e1 / 0.8e1 * t534 * t17349 - 0.3e1 / 0.8e1 * t534 * t2758 * t12032 - 0.7e1 / 0.32e2 * t519 * t17353;
  t17364 = t3772 * t12032;
  t17382 = t15968 * t207;
  t17395 = t7976 * t17382;
  t17409 = -0.3e1 / 0.16e2 * t519 * t17364 + 0.3e1 / 0.16e2 * t519 * t15955 * t12032 + t534 * t12083 * t12032 / 0.2e1 - t534 * t3130 * t7985 / 0.8e1 - t534 * t2778 * t12032 / 0.4e1 + 0.3e1 / 0.8e1 * t534 * t15983 * t14028 - 0.11e2 / 0.32e2 * t519 * t6181 * t17382 + 0.3e1 / 0.16e2 * t519 * t15990 * t12032 + 0.3e1 / 0.8e1 * t534 * t15994 * t12032 - 0.11e2 / 0.16e2 * t534 * t16000 * t14028 + 0.9e1 / 0.16e2 * t519 * t17395 - 0.3e1 / 0.8e1 * t534 * t17364 + 0.11e2 / 0.16e2 * t534 * t17395 - 0.9e1 / 0.16e2 * t519 * t6189 * t17382 - t534 * t4093 * t168 * t5235 / 0.16e2;
  t17449 = 0.3e1 / 0.8e1 * t534 * t16073 * t7125 - 0.3e1 / 0.32e2 * t519 * t17325 + 0.3e1 / 0.32e2 * t1670 * t4099 + 0.3e1 / 0.32e2 * t1674 * t4099 + 0.3e1 / 0.32e2 * t519 * t3282 * t7143 + t1667 * t4102 / 0.4e1 + t534 * t3278 * t7143 / 0.4e1 - 0.3e1 / 0.16e2 * t1667 * t4106 - 0.3e1 / 0.16e2 * t534 * t3282 * t16608 - t1667 * t4094 / 0.16e2 - t534 * t883 * t602 * t1337 / 0.16e2 - 0.3e1 / 0.32e2 * t1670 * t4083 - 0.3e1 / 0.32e2 * t1674 * t4083 - t1667 * t4087 / 0.8e1 - t534 * t3302 * t16581 / 0.8e1;
  t17452 = 0.3e1 / 0.32e2 * t1670 * t4090 + t17239 - t17242 - t17244 - t17248 - t17250 - t17252 + t17254 + t17256 + t17258 - t14045 + t14049 - t14052 + t16110 - t16111;
  t17454 = -t16112 - t16113 + t16114 + t16115 - t16116 - t16117 + t16118 + t3855 - t3856 + t3857 - t3858 - t3503 + t3507 + t3511 - t3518;
  t17455 = -t2393 + t2407 + t2426 - t2430 - t2444 - t2336 - t721 - t16122 + t16123 - t16124 - t16125 + t16126 + t16127 - t16128 + t16129 - t16130;
  t17459 = my_piecewise3(t51, 0, t17304 + t17328 + t17363 + t17409 + t17449 + t17452 + t17454 + t17455);
  tv4rholapltau211 = t17459 * t3 + t4110;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t17470 = 0.3e1 / 0.64e2 * t14198;
  t17472 = 0.3e1 / 0.32e2 * t14201;
  t17473 = 0.3e1 / 0.32e2 * t14203;
  t17474 = 0.3e1 / 0.32e2 * t14205;
  t17475 = t4121 * t263;
  t17479 = t4121 * t997;
  t17480 = t17479 * t12919;
  t17483 = t4121 * t4275;
  t17494 = t23 * t26 * t4116;
  t17499 = t17475 * t12973;
  t17502 = -t17472 + t17473 + t17474 + 0.11e2 / 0.16e2 * t484 * t17475 * t12919 + 0.11e2 / 0.16e2 * t469 * t17480 - 0.15e2 / 0.32e2 * t469 * t17483 * t12928 - 0.25e2 / 0.16e2 * t484 * t17479 * t12928 + 0.15e2 / 0.16e2 * t484 * t17483 * t12963 - t17494 * t3180 / 0.16e2 + t17494 * t3184 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t17499;
  t17506 = t17475 * t12967;
  t17511 = t5635 * t4121;
  t17519 = t4121 * t43;
  t17523 = t5733 * t4121;
  t17537 = 0.9e1 / 0.8e1 * t484 * t17480 + 0.9e1 / 0.16e2 * t469 * t17506 + 0.11e2 / 0.16e2 * t484 * t17506 - 0.9e1 / 0.16e2 * t469 * t5508 * t17511 - 0.3e1 / 0.8e1 * t484 * t3193 * t1516 * t631 + 0.3e1 / 0.8e1 * t484 * t17519 * t12902 - 0.11e2 / 0.32e2 * t469 * t470 * t17523 + 0.9e1 / 0.32e2 * t469 * t3179 * t7473 + 0.9e1 / 0.16e2 * t484 * t3193 * t7473 - t17494 * t3213 / 0.16e2 + t17494 * t3216 / 0.16e2;
  t17538 = t3179 * t12407;
  t17541 = t4121 * t111;
  t17569 = -0.9e1 / 0.16e2 * t484 * t17538 + 0.3e1 / 0.8e1 * t484 * t17541 * t4414 - t484 * t17541 * t4319 / 0.16e2 - 0.9e1 / 0.16e2 * t484 * t3183 * t1450 * t631 - 0.3e1 / 0.16e2 * t484 * t3193 * t12407 - 0.7e1 / 0.32e2 * t469 * t17499 - 0.9e1 / 0.32e2 * t469 * t17538 + 0.9e1 / 0.32e2 * t469 * t3183 * t7584 + 0.3e1 / 0.4e1 * t484 * t3179 * t7584 - 0.11e2 / 0.16e2 * t484 * t17541 * t4309 - 0.9e1 / 0.32e2 * t14239;
  t17582 = t214 * t263;
  t17585 = t214 * t43;
  t17588 = t4452 * t213;
  t17592 = t266 * t268 * t213;
  t17616 = t12993 * t626 / 0.4e1 + t633 / 0.2e1 + t214 * t111 * t290 / 0.2e1 - t17582 * t491 / 0.2e1 - t17585 * t497 / 0.2e1 - t17588 * t13008 / 0.2e1 + t13011 * t17592 / 0.2e1 + t1023 * t631 * t116 / 0.2e1 + t4111 * t13020 / 0.2e1 - t4111 * t13023 / 0.2e1 - t4111 * t13026 / 0.2e1 - t4470 * t213 * t116 / 0.2e1 - t1026 * t631 * t116 / 0.2e1 - t4113 * t13020 / 0.2e1 + t4113 * t13023 / 0.2e1 + t4113 * t13026 / 0.2e1;
  t17627 = t1030 * t4121;
  t17651 = 0.3e1 / 0.32e2 * t255 * t4152;
  t17653 = t255 * t4140 / 0.32e2;
  t17655 = 0.3e1 / 0.64e2 * t255 * t4143;
  t17657 = 0.3e1 / 0.64e2 * t255 * t4146;
  t17658 = -t246 * t4140 / 0.16e2 - 0.3e1 / 0.32e2 * t246 * t4143 - 0.3e1 / 0.32e2 * t99 * t17627 * t972 + 0.3e1 / 0.32e2 * t246 * t4146 + 0.3e1 / 0.32e2 * t99 * t17627 * t1001 + t246 * t4149 / 0.4e1 - 0.3e1 / 0.16e2 * t246 * t4152 - t17651 - t17653 - t17655 + t17657;
  t17661 = t255 * t4149 / 0.8e1;
  t17663 = t255 * t4126 / 0.16e2;
  t17665 = 0.3e1 / 0.64e2 * t255 * t4130;
  t17667 = 0.3e1 / 0.32e2 * t255 * t4133;
  t17669 = t255 * t4118 / 0.64e2;
  t17671 = 0.3e1 / 0.32e2 * t255 * t4123;
  t17678 = t17661 - t17663 + t17665 + t17667 - t17669 - t17671 - t246 * t4118 / 0.32e2 - 0.3e1 / 0.8e1 * t14277 + 0.9e1 / 0.32e2 * t14281 - 0.9e1 / 0.16e2 * t14285 + 0.9e1 / 0.32e2 * t14288;
  t17679 = t4136 + t4137 - t4138 - t4139 - t2246 + t2254 + t2296 - t2300 - t2316 - t2320 - t699;
  t17683 = my_piecewise3(t2, 0, -0.3e1 / 0.16e2 * t246 * t4123 - t246 * t4126 / 0.8e1 + 0.3e1 / 0.32e2 * t246 * t4130 + 0.3e1 / 0.16e2 * t246 * t4133 - 0.3e1 / 0.16e2 * t14264 + 0.9e1 / 0.16e2 * t14260 - 0.9e1 / 0.16e2 * t14254 + 0.3e1 / 0.4e1 * t14251 - 0.3e1 / 0.16e2 * t14125 + 0.3e1 / 0.16e2 * t14127 - 0.3e1 / 0.16e2 * t14121 - 0.3e1 / 0.32e2 * t14116 - 0.3e1 / 0.32e2 * t14119 - 0.3e1 / 0.32e2 * t14114 + 0.3e1 / 0.16e2 * t14099 + 0.3e1 / 0.16e2 * t14096 + 0.3e1 / 0.16e2 * t14094 - t17470 + t17658 + t17569 + t17678 + t17679 + t17502 + t17537 - t99 * t17616 * t866 * t269 / 0.32e2 + 0.3e1 / 0.32e2 * t99 * t17627 * t964);
  tv4rhotau30 = t17683 * t3 + t4156;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t17689 = 0.3e1 / 0.64e2 * t14360;
  t17690 = 0.3e1 / 0.32e2 * t14364;
  t17691 = 0.3e1 / 0.32e2 * t14366;
  t17692 = 0.3e1 / 0.32e2 * t14368;
  t17698 = 0.3e1 / 0.64e2 * t370 * t4166;
  t17700 = 0.3e1 / 0.32e2 * t370 * t4169;
  t17702 = t370 * t4179 / 0.64e2;
  t17704 = 0.3e1 / 0.32e2 * t370 * t4159;
  t17706 = t370 * t4162 / 0.16e2;
  t17707 = -0.3e1 / 0.32e2 * t14342 - 0.3e1 / 0.16e2 * t14344 + 0.3e1 / 0.16e2 * t14346 + 0.3e1 / 0.16e2 * t14350 - t17689 + t17690 - t17691 + t17692 - t367 * t4186 / 0.16e2 - 0.3e1 / 0.16e2 * t367 * t4159 + t17698 + t17700 - t17702 - t17704 - t17706;
  t17709 = 0.3e1 / 0.64e2 * t370 * t4189;
  t17711 = 0.3e1 / 0.64e2 * t370 * t4192;
  t17713 = t370 * t4195 / 0.8e1;
  t17715 = 0.3e1 / 0.32e2 * t370 * t4198;
  t17717 = t370 * t4186 / 0.32e2;
  t17734 = -t17709 + t17711 + t17713 - t17715 - t17717 - 0.3e1 / 0.32e2 * t367 * t4189 + 0.3e1 / 0.32e2 * t367 * t4192 + t367 * t4195 / 0.4e1 - 0.3e1 / 0.16e2 * t367 * t4198 - t367 * t4162 / 0.8e1 + 0.3e1 / 0.32e2 * t367 * t4166 + 0.3e1 / 0.16e2 * t367 * t4169 - t367 * t4179 / 0.32e2 - t2334 - t2336;
  t17736 = my_piecewise3(t51, 0, t17707 + t17734);
  tv4rhotau33 = t17736 * t3 + t4202;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t17758 = -t17470 - t17472 + t17473 + t17474 + t345 * t4149 / 0.4e1 - t345 * t4118 / 0.32e2 - 0.3e1 / 0.16e2 * t345 * t4123 - t345 * t4126 / 0.8e1 - 0.3e1 / 0.16e2 * t345 * t4152 + 0.3e1 / 0.32e2 * t345 * t4130 + 0.3e1 / 0.16e2 * t345 * t4133 - t345 * t4140 / 0.16e2 - 0.3e1 / 0.32e2 * t345 * t4143 + 0.3e1 / 0.32e2 * t345 * t4146 - t17651;
  t17763 = -t17653 - t17655 + t17657 + t17661 - t17663 + t17665 + t17667 - t17669 - t17671 - 0.3e1 / 0.32e2 * t14394 - 0.3e1 / 0.16e2 * t14396 + 0.3e1 / 0.16e2 * t14398 + 0.3e1 / 0.16e2 * t14402 - t2355 - t2316;
  t17765 = my_piecewise3(t2, 0, t17758 + t17763);
  tv4rhotau34 = t17765 * t3 + t4156;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t17767 = t4157 * t168;
  t17771 = t4157 * t418;
  t17775 = t4157 * t1348;
  t17776 = t17775 * t13298;
  t17779 = t4157 * t5342;
  t17783 = t17771 * t13318;
  t17789 = t17771 * t13288;
  t17816 = t220 * t418;
  t17819 = t220 * t75;
  t17822 = t5270 * t219;
  t17826 = t421 * t423 * t219;
  t17850 = t13379 * t665 / 0.4e1 + t672 / 0.2e1 + t220 * t168 * t445 / 0.2e1 - t17816 * t541 / 0.2e1 - t17819 * t547 / 0.2e1 - t17822 * t13394 / 0.2e1 + t13397 * t17826 / 0.2e1 + t1296 * t670 * t173 / 0.2e1 + t4172 * t13406 / 0.2e1 - t4172 * t13409 / 0.2e1 - t4172 * t13412 / 0.2e1 - t5288 * t219 * t173 / 0.2e1 - t1299 * t670 * t173 / 0.2e1 - t4174 * t13406 / 0.2e1 + t4174 * t13409 / 0.2e1 + t4174 * t13412 / 0.2e1;
  t17859 = 0.9e1 / 0.16e2 * t519 * t17789 - 0.9e1 / 0.16e2 * t534 * t3282 * t1650 * t670 - 0.11e2 / 0.16e2 * t534 * t17767 * t5389 + 0.3e1 / 0.8e1 * t534 * t17767 * t5411 + t409 * t4195 / 0.4e1 - 0.3e1 / 0.16e2 * t409 * t4198 + 0.3e1 / 0.16e2 * t409 * t4169 - t409 * t4179 / 0.32e2 - t156 * t17850 * t883 * t424 / 0.32e2 - t409 * t4186 / 0.16e2 - 0.3e1 / 0.32e2 * t409 * t4189;
  t17861 = t1303 * t4157;
  t17879 = -0.3e1 / 0.32e2 * t156 * t17861 * t1344 + 0.3e1 / 0.32e2 * t409 * t4192 + 0.3e1 / 0.32e2 * t156 * t17861 * t1352 - 0.3e1 / 0.16e2 * t409 * t4159 - t409 * t4162 / 0.8e1 + 0.3e1 / 0.32e2 * t409 * t4166 + 0.3e1 / 0.32e2 * t156 * t17861 * t1382 + t17698 + t17700 - t17702 - t17704;
  t17887 = t60 * t26 * t4177;
  t17892 = t6307 * t4157;
  t17896 = -t17706 - t17709 + t17711 + t17713 - t17715 - t17717 - 0.25e2 / 0.16e2 * t534 * t17775 * t13307 + 0.15e2 / 0.16e2 * t534 * t17779 * t13314 - t17887 * t3279 / 0.16e2 + t17887 * t3283 / 0.16e2 - 0.11e2 / 0.32e2 * t519 * t520 * t17892;
  t17904 = t3278 * t7985;
  t17928 = t6239 * t4157;
  t17936 = t4157 * t75;
  t17947 = 0.11e2 / 0.16e2 * t534 * t17789 - 0.9e1 / 0.16e2 * t519 * t6188 * t17928 - 0.3e1 / 0.8e1 * t534 * t3302 * t1633 * t670 + 0.3e1 / 0.8e1 * t534 * t17936 * t13269 + 0.3e1 / 0.16e2 * t14446 - 0.3e1 / 0.32e2 * t14456 - 0.3e1 / 0.32e2 * t14458 - 0.3e1 / 0.32e2 * t14461 + 0.3e1 / 0.16e2 * t14463 + 0.3e1 / 0.16e2 * t14466 - 0.3e1 / 0.16e2 * t14468;
  t17951 = -0.3e1 / 0.16e2 * t14472 + 0.3e1 / 0.16e2 * t14475 + t4182 - t4183 + t4184 - t4185 - t2393 + t2407 + t2426 - t2430 - t2444;
  t17961 = -t2336 - t721 - 0.9e1 / 0.16e2 * t14517 + 0.9e1 / 0.16e2 * t14520 - 0.3e1 / 0.16e2 * t14524 - 0.9e1 / 0.16e2 * t14563 + 0.3e1 / 0.4e1 * t14567 + 0.9e1 / 0.32e2 * t14587 - 0.3e1 / 0.8e1 * t14592 + 0.9e1 / 0.32e2 * t14595 - 0.9e1 / 0.32e2 * t14597;
  t17965 = my_piecewise3(t51, 0, t17961 + t17951 + t17947 - 0.9e1 / 0.16e2 * t534 * t17904 - 0.7e1 / 0.32e2 * t519 * t17783 + 0.9e1 / 0.8e1 * t534 * t17776 + 0.11e2 / 0.16e2 * t519 * t17776 - 0.3e1 / 0.2e1 * t534 * t17783 - 0.9e1 / 0.32e2 * t519 * t17904 - t17887 * t3306 / 0.16e2 + t17887 * t3309 / 0.16e2 + t17896 + t17879 + t17859 + t17690 - t17691 + t17692 - t17689 + 0.3e1 / 0.4e1 * t534 * t3278 * t7989 - 0.3e1 / 0.16e2 * t534 * t3302 * t7985 + 0.9e1 / 0.16e2 * t534 * t3302 * t8090 - t534 * t17767 * t5235 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t17771 * t13298 - 0.15e2 / 0.32e2 * t519 * t17779 * t13307 + 0.9e1 / 0.32e2 * t519 * t3278 * t8090 + 0.9e1 / 0.32e2 * t519 * t3282 * t7989);
  tv4rhotau37 = t17965 * t3 + t4202;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t17967 = t1516 * t695;
  t17969 = t484 * t2238 * t17967;
  t17971 = t3458 * t3340;
  t17974 = t469 * t2255 * t8432;
  t17977 = t484 * t8320 * t3494;
  t17979 = t1432 * t695;
  t17980 = t2255 * t17979;
  t17981 = t469 * t17980;
  t17984 = t469 * t2260 * t8310;
  t17986 = t484 * t17980;
  t17988 = t695 * t690;
  t17990 = t484 * t17988 * t1006;
  t17993 = t484 * t17988 * t986;
  t17996 = t484 * t17988 * t968;
  t17998 = t690 * t690;
  t17999 = t100 * t17998;
  t18010 = t697 / 0.2e1;
  t18022 = t1023 * t695 * t116 / 0.2e1;
  t18023 = t1023 * t690;
  t18030 = t258 * t3361;
  t18036 = t1026 * t695 * t116 / 0.2e1;
  t18037 = t1026 * t690;
  t18044 = t692 / 0.4e1 + t18010 + t701 / 0.2e1 - t704 / 0.2e1 - t707 / 0.2e1 - t4452 * t690 * t269 / 0.2e1 + t4456 * t690 * t269 / 0.2e1 + t18022 + t18023 * t290 / 0.2e1 - t18023 * t297 / 0.2e1 - t18023 * t301 / 0.2e1 - t18030 * t183 * t116 / 0.2e1 - t18036 - t18037 * t290 / 0.2e1 + t18037 * t297 / 0.2e1 + t18037 * t301 / 0.2e1;
  t18049 = t260 * t17998;
  t18056 = t3361 * t3335;
  t18066 = -0.3e1 / 0.4e1 * t17969 - 0.5e1 / 0.32e2 * t17971 + 0.9e1 / 0.16e2 * t17974 - 0.9e1 / 0.8e1 * t17977 - 0.9e1 / 0.16e2 * t17981 + 0.9e1 / 0.16e2 * t17984 - 0.9e1 / 0.8e1 * t17986 + 0.3e1 / 0.2e1 * t17990 - 0.3e1 / 0.8e1 * t17993 + 0.9e1 / 0.8e1 * t17996 - 0.11e2 / 0.16e2 * t99 * t17999 * t4309 + 0.3e1 / 0.8e1 * t99 * t17999 * t4414 - t99 * t17999 * t4319 / 0.16e2 - t99 * t18044 * t690 * t269 / 0.32e2 - 0.7e1 / 0.32e2 * t99 * t18049 * t4296 - 0.11e2 / 0.32e2 * t99 * t18049 * t4422 + 0.5e1 / 0.32e2 * t99 * t18056 * t964 + 0.11e2 / 0.16e2 * t99 * t17999 * t4331 + 0.11e2 / 0.16e2 * t99 * t18049 * t4339;
  t18097 = t695 * t695;
  t18098 = t100 * t18097;
  t18101 = 0.3e1 / 0.16e2 * t99 * t18098 * t297;
  t18104 = 0.3e1 / 0.16e2 * t99 * t18098 * t290;
  t18107 = 0.3e1 / 0.16e2 * t99 * t18098 * t301;
  t18114 = 0.3e1 / 0.32e2 * t99 * t260 * t18097 * t269;
  t18119 = -0.15e2 / 0.32e2 * t99 * t18049 * t4346 - 0.25e2 / 0.16e2 * t99 * t17999 * t4351 + 0.15e2 / 0.16e2 * t99 * t17999 * t4281 + 0.11e2 / 0.16e2 * t99 * t17999 * t4323 + 0.9e1 / 0.16e2 * t99 * t18049 * t4323 - 0.9e1 / 0.16e2 * t99 * t18049 * t4381 - 0.3e1 / 0.2e1 * t99 * t17999 * t4296 + 0.9e1 / 0.8e1 * t99 * t17999 * t4339 - 0.5e1 / 0.32e2 * t99 * t18056 * t972 + 0.5e1 / 0.32e2 * t99 * t18056 * t1001 + t18101 - t18104 + t18107 + 0.3e1 / 0.8e1 * t99 * t17999 * t4355 - t18114 - t3341 / 0.8e1 + t3348 / 0.4e1 - t3368 / 0.4e1 + t3380 / 0.4e1 - t699;
  t18121 = my_piecewise3(t2, 0, t18066 + t18119);
  tv4sigma40 = t3 * t18121;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t18122 = t1628 * t717;
  t18123 = t2382 * t18122;
  t18124 = t534 * t18123;
  t18126 = t717 * t712;
  t18128 = t534 * t18126 * t1369;
  t18131 = t534 * t18126 * t1337;
  t18134 = t519 * t2382 * t9004;
  t18137 = t534 * t8907 * t3549;
  t18139 = t519 * t18123;
  t18142 = t519 * t2365 * t8859;
  t18145 = t534 * t18126 * t1357;
  t18147 = t1633 * t717;
  t18149 = t534 * t2373 * t18147;
  t18151 = t3513 * t3398;
  t18153 = t3416 * t3390;
  t18157 = t712 * t712;
  t18158 = t157 * t18157;
  t18162 = t415 * t18157;
  t18184 = -0.9e1 / 0.8e1 * t18124 + 0.9e1 / 0.8e1 * t18128 - 0.3e1 / 0.8e1 * t18131 + 0.9e1 / 0.16e2 * t18134 - 0.9e1 / 0.8e1 * t18137 - 0.9e1 / 0.16e2 * t18139 + 0.9e1 / 0.16e2 * t18142 + 0.3e1 / 0.2e1 * t18145 - 0.3e1 / 0.4e1 * t18149 - 0.5e1 / 0.32e2 * t18151 + 0.5e1 / 0.32e2 * t156 * t18153 * t1352 + 0.11e2 / 0.16e2 * t156 * t18158 * t5254 + 0.11e2 / 0.16e2 * t156 * t18162 * t5338 - 0.15e2 / 0.32e2 * t156 * t18162 * t5346 - 0.25e2 / 0.16e2 * t156 * t18158 * t5351 - 0.3e1 / 0.2e1 * t156 * t18158 * t5382 - t156 * t18158 * t5235 / 0.16e2 - 0.11e2 / 0.16e2 * t156 * t18158 * t5389 + 0.3e1 / 0.8e1 * t156 * t18158 * t5411;
  t18192 = t719 / 0.2e1;
  t18204 = t1296 * t717 * t173 / 0.2e1;
  t18205 = t1296 * t712;
  t18212 = t413 * t3416;
  t18218 = t1299 * t717 * t173 / 0.2e1;
  t18219 = t1299 * t712;
  t18226 = t714 / 0.4e1 + t18192 + t723 / 0.2e1 - t726 / 0.2e1 - t729 / 0.2e1 - t5270 * t712 * t424 / 0.2e1 + t5274 * t712 * t424 / 0.2e1 + t18204 + t18205 * t445 / 0.2e1 - t18205 * t452 / 0.2e1 - t18205 * t456 / 0.2e1 - t18212 * t191 * t173 / 0.2e1 - t18218 - t18219 * t445 / 0.2e1 + t18219 * t452 / 0.2e1 + t18219 * t456 / 0.2e1;
  t18237 = t717 * t717;
  t18238 = t157 * t18237;
  t18241 = 0.3e1 / 0.16e2 * t156 * t18238 * t452;
  t18244 = 0.3e1 / 0.16e2 * t156 * t18238 * t445;
  t18247 = 0.3e1 / 0.16e2 * t156 * t18238 * t456;
  t18257 = 0.3e1 / 0.32e2 * t156 * t415 * t18237 * t424;
  t18274 = -0.11e2 / 0.32e2 * t156 * t18162 * t5334 + 0.5e1 / 0.32e2 * t156 * t18153 * t1382 - t156 * t18226 * t712 * t424 / 0.32e2 - 0.7e1 / 0.32e2 * t156 * t18162 * t5382 - 0.9e1 / 0.16e2 * t156 * t18162 * t5398 + t18241 - t18244 + t18247 + 0.11e2 / 0.16e2 * t156 * t18158 * t5370 + 0.3e1 / 0.8e1 * t156 * t18158 * t5374 - t18257 + 0.15e2 / 0.16e2 * t156 * t18158 * t5358 + 0.9e1 / 0.8e1 * t156 * t18158 * t5338 + 0.9e1 / 0.16e2 * t156 * t18162 * t5370 - 0.5e1 / 0.32e2 * t156 * t18153 * t1344 - t3423 / 0.4e1 + t3435 / 0.4e1 - t3399 / 0.8e1 + t3406 / 0.4e1 - t721;
  t18276 = my_piecewise3(t51, 0, t18184 + t18274);
  tv4sigma414 = t3 * t18276;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t18277 = t13099 * t183;
  t18279 = t484 * t2483 * t18277;
  t18280 = 0.9e1 / 0.16e2 * t18279;
  t18281 = t2463 * t18277;
  t18282 = t484 * t18281;
  t18283 = 0.9e1 / 0.16e2 * t18282;
  t18285 = t484 * t13733 * t1441;
  t18286 = 0.3e1 / 0.4e1 * t18285;
  t18288 = t484 * t2459 * t8432;
  t18289 = 0.9e1 / 0.16e2 * t18288;
  t18292 = t484 * t3449 * t183 * t986;
  t18293 = 0.3e1 / 0.16e2 * t18292;
  t18294 = t5610 * t3335;
  t18298 = t5643 * t3335;
  t18299 = t1739 * t18298;
  t18302 = t12918 * t17136;
  t18305 = t199 * t3335;
  t18318 = -t18280 - t18283 + t18286 + t18289 - t18293 + 0.15e2 / 0.16e2 * t484 * t6537 * t18294 + 0.9e1 / 0.8e1 * t484 * t18299 + 0.9e1 / 0.16e2 * t469 * t18302 + 0.11e2 / 0.16e2 * t484 * t18305 * t4331 + 0.11e2 / 0.16e2 * t469 * t18299 - 0.15e2 / 0.32e2 * t469 * t12927 * t6567 - 0.5e1 / 0.32e2 * t3458 * t3467 + 0.5e1 / 0.32e2 * t3458 * t3488;
  t18319 = t572 * t12954;
  t18331 = t23 * t26 * t18044;
  t18337 = 0.3e1 / 0.8e1 * t17969;
  t18338 = 0.3e1 / 0.32e2 * t17971;
  t18339 = 0.9e1 / 0.32e2 * t17974;
  t18340 = 0.9e1 / 0.16e2 * t17977;
  t18341 = 0.9e1 / 0.32e2 * t17981;
  t18342 = 0.9e1 / 0.32e2 * t17984;
  t18343 = 0.9e1 / 0.16e2 * t17986;
  t18344 = -0.3e1 / 0.2e1 * t484 * t18319 - 0.7e1 / 0.32e2 * t469 * t18319 - 0.9e1 / 0.16e2 * t469 * t12923 * t6555 - 0.11e2 / 0.32e2 * t469 * t12918 * t6687 - t18331 * t734 / 0.32e2 - 0.25e2 / 0.16e2 * t484 * t18305 * t4351 - t18337 - t18338 + t18339 - t18340 - t18341 + t18342 - t18343;
  t18346 = 0.3e1 / 0.4e1 * t17990;
  t18347 = 0.3e1 / 0.16e2 * t17993;
  t18348 = 0.9e1 / 0.16e2 * t17996;
  t18349 = t18346 - t18347 + t18348 + t18101 - t18104 + t18107 - t18114 + t3448 - t3452 + t3456 - t3463 - t3342 + t3349;
  t18352 = t5559 * t3335;
  t18356 = t3458 * t3461;
  t18357 = t18356 / 0.16e2;
  t18370 = t484 * t2469 * t18277;
  t18371 = 0.3e1 / 0.8e1 * t18370;
  t18373 = t469 * t2453 * t13636;
  t18374 = 0.9e1 / 0.32e2 * t18373;
  t18375 = t469 * t18281;
  t18376 = 0.9e1 / 0.32e2 * t18375;
  t18378 = t469 * t2475 * t13636;
  t18379 = 0.9e1 / 0.32e2 * t18378;
  t18380 = -t3369 + t3381 + 0.11e2 / 0.16e2 * t484 * t18302 + 0.3e1 / 0.8e1 * t484 * t576 * t18352 - t18357 - 0.11e2 / 0.16e2 * t484 * t18305 * t4309 + 0.3e1 / 0.8e1 * t484 * t18305 * t4414 - t484 * t18305 * t4319 / 0.16e2 + 0.5e1 / 0.32e2 * t3458 * t3474 - t699 - t18371 + t18374 - t18376 + t18379;
  t18383 = my_piecewise3(t2, 0, t18318 + t18344 + t18349 + t18380);
  tv4sigma3lapl0 = t3 * t18383;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t18394 = -0.9e1 / 0.16e2 * t18124 + 0.9e1 / 0.16e2 * t18128 - 0.3e1 / 0.16e2 * t18131 + 0.9e1 / 0.32e2 * t18134 - 0.9e1 / 0.16e2 * t18137 - 0.9e1 / 0.32e2 * t18139 + 0.9e1 / 0.32e2 * t18142 + 0.3e1 / 0.4e1 * t18145 - 0.3e1 / 0.8e1 * t18149 - 0.3e1 / 0.32e2 * t18151 + t18241 - t18244 + t18247;
  t18395 = t6299 * t3390;
  t18401 = t6233 * t3390;
  t18402 = t611 * t18401;
  t18405 = t6247 * t207;
  t18406 = t13302 * t18405;
  t18409 = -t18257 - t3503 + t3507 + t3511 - t3518 - t3424 + t3436 - t3400 + t3407 + 0.3e1 / 0.8e1 * t534 * t615 * t18395 + 0.5e1 / 0.32e2 * t3513 * t3529 + 0.11e2 / 0.16e2 * t534 * t18402 + 0.11e2 / 0.16e2 * t519 * t18406;
  t18414 = t207 * t3390;
  t18418 = t6227 * t3390;
  t18422 = t611 * t13260;
  t18447 = -0.15e2 / 0.32e2 * t519 * t13306 * t7184 - 0.25e2 / 0.16e2 * t534 * t18414 * t5351 + 0.15e2 / 0.16e2 * t534 * t7191 * t18418 - 0.3e1 / 0.2e1 * t534 * t18422 + 0.9e1 / 0.8e1 * t534 * t18406 + 0.9e1 / 0.16e2 * t519 * t18402 + 0.11e2 / 0.16e2 * t534 * t18414 * t5254 - 0.5e1 / 0.32e2 * t3513 * t3522 + 0.5e1 / 0.32e2 * t3513 * t3543 - 0.11e2 / 0.16e2 * t534 * t18414 * t5389 + 0.3e1 / 0.8e1 * t534 * t18414 * t5411 - t534 * t18414 * t5235 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t18422;
  t18455 = t60 * t26 * t18226;
  t18458 = t3513 * t3516;
  t18459 = t18458 / 0.16e2;
  t18461 = t534 * t14015 * t1621;
  t18462 = 0.9e1 / 0.16e2 * t18461;
  t18463 = t2572 * t13957;
  t18464 = t519 * t18463;
  t18465 = 0.9e1 / 0.32e2 * t18464;
  t18466 = t534 * t18463;
  t18467 = 0.9e1 / 0.16e2 * t18466;
  t18469 = t519 * t2578 * t13957;
  t18470 = 0.9e1 / 0.32e2 * t18469;
  t18471 = t13437 * t191;
  t18473 = t534 * t2600 * t18471;
  t18474 = 0.3e1 / 0.8e1 * t18473;
  t18476 = t519 * t2590 * t13957;
  t18477 = 0.9e1 / 0.32e2 * t18476;
  t18479 = t534 * t14046 * t1642;
  t18480 = 0.3e1 / 0.4e1 * t18479;
  t18482 = t534 * t2566 * t18471;
  t18483 = 0.9e1 / 0.16e2 * t18482;
  t18486 = t534 * t3500 * t191 * t1337;
  t18487 = 0.3e1 / 0.16e2 * t18486;
  t18488 = -0.11e2 / 0.32e2 * t519 * t13287 * t7282 - 0.9e1 / 0.16e2 * t519 * t13302 * t7129 - t18455 * t751 / 0.32e2 - t18459 - t721 + t18462 - t18465 - t18467 + t18470 - t18474 + t18477 + t18480 - t18483 - t18487;
  t18491 = my_piecewise3(t51, 0, t18394 + t18409 + t18447 + t18488);
  tv4sigma3lapl19 = t3 * t18491;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t18492 = -t18337 - t18338 + t18339 - t18340 - t18341 + t18342 - t18343 + t18346 - t18347 + t18348 + t18101 - t18104 + t18107;
  t18496 = t213 * t3335;
  t18505 = -t18114 + t3557 + t3560 - t3565 - t3569 - t3342 + t3349 - t3369 + t3381 - 0.15e2 / 0.32e2 * t469 * t12927 * t7564 - 0.25e2 / 0.16e2 * t484 * t18496 * t4351 + 0.15e2 / 0.16e2 * t484 * t7591 * t18294 - 0.5e1 / 0.32e2 * t3458 * t3570;
  t18509 = t640 * t12954;
  t18512 = t1992 * t18298;
  t18516 = t12918 * t5627 * t213;
  t18543 = 0.5e1 / 0.32e2 * t3458 * t3588 - 0.3e1 / 0.2e1 * t484 * t18509 + 0.9e1 / 0.8e1 * t484 * t18512 + 0.9e1 / 0.16e2 * t469 * t18516 + 0.11e2 / 0.16e2 * t484 * t18496 * t4331 + 0.11e2 / 0.16e2 * t484 * t18516 + 0.3e1 / 0.8e1 * t484 * t644 * t18352 + 0.5e1 / 0.32e2 * t3458 * t3576 + 0.3e1 / 0.8e1 * t484 * t18496 * t4414 - t484 * t18496 * t4319 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t18496 * t4309 - 0.7e1 / 0.32e2 * t469 * t18509 - 0.11e2 / 0.32e2 * t469 * t12918 * t7499;
  t18549 = t3458 * t3563;
  t18550 = t18549 / 0.16e2;
  t18554 = t469 * t2453 * t14279;
  t18555 = 0.9e1 / 0.32e2 * t18554;
  t18556 = t2666 * t18277;
  t18557 = t484 * t18556;
  t18558 = 0.9e1 / 0.16e2 * t18557;
  t18560 = t469 * t2475 * t14279;
  t18561 = 0.9e1 / 0.32e2 * t18560;
  t18563 = t484 * t2653 * t18277;
  t18564 = 0.3e1 / 0.8e1 * t18563;
  t18565 = t469 * t18556;
  t18566 = 0.9e1 / 0.32e2 * t18565;
  t18568 = t484 * t11518 * t18277;
  t18569 = 0.3e1 / 0.4e1 * t18568;
  t18571 = t484 * t2645 * t18277;
  t18572 = 0.9e1 / 0.16e2 * t18571;
  t18574 = t484 * t2662 * t8432;
  t18575 = 0.9e1 / 0.16e2 * t18574;
  t18578 = t484 * t3566 * t183 * t986;
  t18579 = 0.3e1 / 0.16e2 * t18578;
  t18580 = -0.9e1 / 0.16e2 * t469 * t12923 * t7505 - t18331 * t768 / 0.32e2 - t18550 + 0.11e2 / 0.16e2 * t469 * t18512 - t699 + t18555 - t18558 + t18561 - t18564 - t18566 + t18569 - t18572 + t18575 - t18579;
  t18583 = my_piecewise3(t2, 0, t18492 + t18505 + t18543 + t18580);
  tv4sigma3tau0 = t3 * t18583;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t18584 = t219 * t3390;
  t18595 = -t18257 + t3601 - t3605 + t3608 - t3613 - t3424 + t3436 - t3400 + t3407 - 0.25e2 / 0.16e2 * t534 * t18584 * t5351 + 0.15e2 / 0.16e2 * t534 * t8030 * t18418 - 0.5e1 / 0.32e2 * t3513 * t3618 + 0.5e1 / 0.32e2 * t3513 * t3632;
  t18597 = t18584 * t5382;
  t18601 = t2181 * t6247 * t3390;
  t18604 = t679 * t18401;
  t18630 = t3513 * t3611;
  t18631 = t18630 / 0.16e2;
  t18632 = -0.3e1 / 0.2e1 * t534 * t18597 + 0.9e1 / 0.8e1 * t534 * t18601 + 0.11e2 / 0.16e2 * t534 * t18604 + 0.3e1 / 0.8e1 * t534 * t683 * t18395 + 0.5e1 / 0.32e2 * t3513 * t3624 - 0.11e2 / 0.16e2 * t534 * t18584 * t5389 - t534 * t18584 * t5235 / 0.16e2 - 0.7e1 / 0.32e2 * t519 * t18597 - 0.11e2 / 0.32e2 * t519 * t13287 * t8145 + 0.9e1 / 0.16e2 * t519 * t18604 - 0.9e1 / 0.16e2 * t519 * t13302 * t8054 - t18455 * t783 / 0.32e2 - t18631;
  t18645 = t519 * t2590 * t14585;
  t18646 = 0.9e1 / 0.32e2 * t18645;
  t18647 = t2572 * t14585;
  t18648 = t519 * t18647;
  t18649 = 0.9e1 / 0.32e2 * t18648;
  t18651 = t519 * t2578 * t14585;
  t18652 = 0.9e1 / 0.32e2 * t18651;
  t18654 = t534 * t2778 * t18471;
  t18655 = 0.3e1 / 0.8e1 * t18654;
  t18656 = t534 * t18647;
  t18657 = 0.9e1 / 0.16e2 * t18656;
  t18659 = t534 * t14565 * t1642;
  t18660 = 0.3e1 / 0.4e1 * t18659;
  t18662 = t534 * t2758 * t18471;
  t18663 = 0.9e1 / 0.16e2 * t18662;
  t18665 = t534 * t2785 * t9004;
  t18666 = 0.9e1 / 0.16e2 * t18665;
  t18669 = t534 * t3602 * t191 * t1337;
  t18670 = 0.3e1 / 0.16e2 * t18669;
  t18671 = 0.11e2 / 0.16e2 * t534 * t18584 * t5254 + 0.11e2 / 0.16e2 * t519 * t18601 - 0.15e2 / 0.32e2 * t519 * t13306 * t8076 + 0.3e1 / 0.8e1 * t534 * t18584 * t5411 - t721 + t18646 - t18649 + t18652 - t18655 - t18657 + t18660 - t18663 + t18666 - t18670;
  t18674 = my_piecewise3(t51, 0, t18394 + t18595 + t18632 + t18671);
  tv4sigma3tau19 = t3 * t18674;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t18679 = t17969 / 0.8e1;
  t18680 = t17971 / 0.32e2;
  t18681 = 0.3e1 / 0.32e2 * t17974;
  t18682 = 0.3e1 / 0.16e2 * t17977;
  t18683 = 0.3e1 / 0.32e2 * t17981;
  t18684 = 0.3e1 / 0.32e2 * t17984;
  t18685 = 0.3e1 / 0.16e2 * t17986;
  t18686 = t17990 / 0.4e1;
  t18687 = t17993 / 0.16e2;
  t18688 = 0.3e1 / 0.16e2 * t17996;
  t18689 = -0.3e1 / 0.4e1 * t18279 - 0.3e1 / 0.4e1 * t18282 + t18285 + 0.3e1 / 0.4e1 * t18288 - t18292 / 0.4e1 - t18679 - t18680 + t18681 - t18682 - t18683 + t18684 - t18685 + t18686 - t18687 + t18688;
  t18697 = t798 * t690;
  t18701 = t5643 * t690;
  t18702 = t2840 * t18701;
  t18711 = t5610 * t690;
  t18715 = t2836 * t8459;
  t18723 = t5627 * t690;
  t18724 = t2836 * t18723;
  t18727 = t5559 * t690;
  t18731 = -t99 * t18044 * t798 * t269 / 0.32e2 + t18101 - t18104 + t18107 - t18114 - 0.9e1 / 0.16e2 * t469 * t2260 * t10805 + 0.11e2 / 0.16e2 * t484 * t18697 * t4331 + 0.11e2 / 0.16e2 * t469 * t18702 - 0.15e2 / 0.32e2 * t469 * t10781 * t8479 - 0.25e2 / 0.16e2 * t484 * t2840 * t8479 + 0.15e2 / 0.16e2 * t484 * t10781 * t18711 - 0.3e1 / 0.2e1 * t484 * t18715 + 0.9e1 / 0.8e1 * t484 * t18702 - 0.11e2 / 0.16e2 * t484 * t2856 * t8403 + 0.11e2 / 0.16e2 * t484 * t18724 + 0.3e1 / 0.8e1 * t484 * t2856 * t18727;
  t18736 = t2836 * t17979;
  t18737 = t469 * t18736;
  t18738 = 0.3e1 / 0.32e2 * t18737;
  t18740 = t469 * t2840 * t8310;
  t18741 = 0.3e1 / 0.32e2 * t18740;
  t18743 = t484 * t2836 * t8310;
  t18744 = t18743 / 0.4e1;
  t18745 = t1450 * t695;
  t18747 = t484 * t2840 * t18745;
  t18748 = 0.3e1 / 0.16e2 * t18747;
  t18751 = t484 * t798 * t695 * t986;
  t18752 = t18751 / 0.16e2;
  t18756 = t484 * t2856 * t17967;
  t18757 = t18756 / 0.8e1;
  t18764 = t469 * t2836 * t8432;
  t18765 = 0.3e1 / 0.32e2 * t18764;
  t18767 = t484 * t2856 * t8432;
  t18768 = 0.3e1 / 0.16e2 * t18767;
  t18771 = t484 * t18736;
  t18772 = 0.3e1 / 0.16e2 * t18771;
  t18773 = -t484 * t18697 * t4319 / 0.16e2 - t18738 + t18741 + t18744 - t18748 - t18752 - 0.7e1 / 0.32e2 * t469 * t18715 - t18757 - 0.11e2 / 0.32e2 * t469 * t2255 * t10849 + 0.5e1 / 0.32e2 * t3458 * t3654 + t18765 + t18768 + 0.9e1 / 0.16e2 * t469 * t18724 - t18772 + t3657;
  t18786 = -t3658 + t3659 - t3660 - t3464 + t3465 - t3481 + t3485 + 0.3e1 / 0.8e1 * t484 * t18697 * t4414 - 0.5e1 / 0.32e2 * t3458 * t3647 + 0.5e1 / 0.32e2 * t3458 * t3674 - t18356 / 0.8e1 - t699 - t18370 / 0.2e1 + 0.3e1 / 0.8e1 * t18373 - 0.3e1 / 0.8e1 * t18375 + 0.3e1 / 0.8e1 * t18378;
  t18789 = my_piecewise3(t2, 0, t18689 + t18731 + t18773 + t18786);
  tv4sigma2lapl20 = t3 * t18789;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t18790 = 0.3e1 / 0.16e2 * t18124;
  t18791 = 0.3e1 / 0.16e2 * t18128;
  t18792 = t18131 / 0.16e2;
  t18793 = 0.3e1 / 0.32e2 * t18134;
  t18794 = 0.3e1 / 0.16e2 * t18137;
  t18795 = 0.3e1 / 0.32e2 * t18139;
  t18796 = 0.3e1 / 0.32e2 * t18142;
  t18797 = t18145 / 0.4e1;
  t18798 = t18149 / 0.8e1;
  t18799 = t18151 / 0.32e2;
  t18804 = -t18790 + t18791 - t18792 + t18793 - t18794 - t18795 + t18796 + t18797 - t18798 - t18799 - t156 * t18226 * t815 * t424 / 0.32e2 + t18241 - t18244 + t18247 - t18257;
  t18806 = t2935 * t6233 * t712;
  t18809 = t6299 * t712;
  t18813 = t815 * t712;
  t18817 = t6247 * t712;
  t18818 = t2939 * t18817;
  t18821 = t6257 * t712;
  t18828 = t6227 * t712;
  t18832 = t6239 * t712;
  t18833 = t2935 * t18832;
  t18840 = t1650 * t717;
  t18842 = t534 * t2939 * t18840;
  t18843 = 0.3e1 / 0.16e2 * t18842;
  t18846 = t2935 * t18122;
  t18847 = t519 * t18846;
  t18848 = 0.3e1 / 0.32e2 * t18847;
  t18850 = t519 * t2939 * t8859;
  t18851 = 0.3e1 / 0.32e2 * t18850;
  t18853 = t534 * t2935 * t8859;
  t18854 = t18853 / 0.4e1;
  t18857 = t534 * t815 * t717 * t1337;
  t18858 = t18857 / 0.16e2;
  t18859 = 0.11e2 / 0.16e2 * t534 * t18806 + 0.3e1 / 0.8e1 * t534 * t2952 * t18809 + 0.11e2 / 0.16e2 * t534 * t18813 * t5254 + 0.11e2 / 0.16e2 * t519 * t18818 - 0.15e2 / 0.32e2 * t519 * t11202 * t18821 - 0.25e2 / 0.16e2 * t534 * t2939 * t18821 + 0.15e2 / 0.16e2 * t534 * t11202 * t18828 - 0.3e1 / 0.2e1 * t534 * t18833 + 0.9e1 / 0.8e1 * t534 * t18818 + 0.9e1 / 0.16e2 * t519 * t18806 - t18843 - 0.7e1 / 0.32e2 * t519 * t18833 - t18848 + t18851 + t18854 - t18858;
  t18862 = t534 * t2952 * t18147;
  t18863 = t18862 / 0.8e1;
  t18870 = t519 * t2935 * t9004;
  t18871 = 0.3e1 / 0.32e2 * t18870;
  t18873 = t534 * t2952 * t9004;
  t18874 = 0.3e1 / 0.16e2 * t18873;
  t18875 = t534 * t18846;
  t18876 = 0.3e1 / 0.16e2 * t18875;
  t18893 = -t18863 - 0.11e2 / 0.32e2 * t519 * t2382 * t11307 + 0.5e1 / 0.32e2 * t3513 * t3695 + t18871 + t18874 - t18876 - 0.9e1 / 0.16e2 * t519 * t2365 * t11271 - 0.11e2 / 0.16e2 * t534 * t18813 * t5389 + 0.3e1 / 0.8e1 * t534 * t18813 * t5411 - 0.5e1 / 0.32e2 * t3513 * t3688 + 0.5e1 / 0.32e2 * t3513 * t3718 - t534 * t18813 * t5235 / 0.16e2 - t3701 + t3702 + t3703;
  t18903 = -t3704 - t3536 + t3537 - t3519 + t3520 - t18458 / 0.8e1 - t721 + 0.3e1 / 0.4e1 * t18461 - 0.3e1 / 0.8e1 * t18464 - 0.3e1 / 0.4e1 * t18466 + 0.3e1 / 0.8e1 * t18469 - t18473 / 0.2e1 + 0.3e1 / 0.8e1 * t18476 + t18479 - 0.3e1 / 0.4e1 * t18482 - t18486 / 0.4e1;
  t18906 = my_piecewise3(t51, 0, t18804 + t18859 + t18893 + t18903);
  tv4sigma2lapl217 = t3 * t18906;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  t18907 = 0.3e1 / 0.8e1 * t18279;
  t18908 = 0.3e1 / 0.8e1 * t18282;
  t18909 = t18285 / 0.2e1;
  t18910 = 0.3e1 / 0.8e1 * t18288;
  t18911 = t18292 / 0.8e1;
  t18912 = -t18907 - t18908 + t18909 + t18910 - t18911 - t18679 - t18680 + t18681 - t18682 - t18683 + t18684 - t18685 + t18686 - t18687 + t18688 + t18101 - t18104 + t18107 - t18114;
  t18918 = t2463 * t14279;
  t18919 = t469 * t18918;
  t18922 = t469 * t3015 * t14279;
  t18925 = t484 * t3019 * t8432;
  t18927 = t484 * t18918;
  t18933 = -t18331 * t832 / 0.32e2 + t3557 + t3560 - t3565 - t3569 + t3448 - t3452 + t3456 - t3463 - t3464 + t3465 - t3481 + t3485 + 0.15e2 / 0.16e2 * t484 * t9912 * t13646 - 0.3e1 / 0.32e2 * t18919 + 0.3e1 / 0.32e2 * t18922 + 0.3e1 / 0.16e2 * t18925 - 0.3e1 / 0.16e2 * t18927 - 0.9e1 / 0.16e2 * t469 * t2260 * t999 * t11575;
  t18936 = t484 * t2653 * t13636;
  t18944 = t11518 * t13646;
  t18947 = t2645 * t13646;
  t18950 = t2463 * t14269;
  t18953 = t835 * t690;
  t18971 = t469 * t3006 * t14279;
  t18974 = t484 * t2992 * t8310;
  t18977 = t484 * t2645 * t13636;
  t18981 = t484 * t835 * t695 * t986;
  t18990 = -t18936 / 0.8e1 - 0.11e2 / 0.32e2 * t469 * t2255 * t265 * t11575 + 0.5e1 / 0.32e2 * t3458 * t3742 - 0.3e1 / 0.2e1 * t484 * t18944 + 0.9e1 / 0.8e1 * t484 * t18947 + 0.9e1 / 0.16e2 * t469 * t18950 + 0.11e2 / 0.16e2 * t484 * t18953 * t4331 + 0.11e2 / 0.16e2 * t469 * t18947 - 0.15e2 / 0.32e2 * t469 * t11510 * t14269 - 0.25e2 / 0.16e2 * t484 * t11514 * t8479 + 0.11e2 / 0.16e2 * t484 * t18950 + 0.3e1 / 0.8e1 * t484 * t2653 * t13646 + 0.3e1 / 0.32e2 * t18971 + t18974 / 0.4e1 - 0.3e1 / 0.16e2 * t18977 - t18981 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t18944 - t484 * t18953 * t4319 / 0.16e2 - 0.5e1 / 0.32e2 * t3458 * t3735;
  t19000 = 0.3e1 / 0.16e2 * t18554;
  t19001 = 0.3e1 / 0.8e1 * t18557;
  t19002 = 0.3e1 / 0.16e2 * t18560;
  t19003 = t18563 / 0.4e1;
  t19004 = 0.3e1 / 0.16e2 * t18565;
  t19005 = t18568 / 0.2e1;
  t19006 = 0.3e1 / 0.8e1 * t18571;
  t19007 = 0.3e1 / 0.8e1 * t18574;
  t19008 = t18578 / 0.8e1;
  t19009 = t18370 / 0.4e1;
  t19010 = 0.3e1 / 0.16e2 * t18373;
  t19011 = 0.3e1 / 0.16e2 * t18375;
  t19012 = 0.3e1 / 0.16e2 * t18378;
  t19013 = 0.5e1 / 0.32e2 * t3458 * t3754 - 0.11e2 / 0.16e2 * t484 * t3579 * t43 * t6687 + 0.3e1 / 0.8e1 * t484 * t18953 * t4414 - t18550 - t18357 - t699 + t19000 - t19001 + t19002 - t19003 - t19004 + t19005 - t19006 + t19007 - t19008 - t19009 + t19010 - t19011 + t19012;
  t19016 = my_piecewise3(t2, 0, t18912 + t18933 + t18990 + t19013);
  tv4sigma2lapltau0 = t3 * t19016;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  t19019 = -t18790 + t18791 - t18792 + t18793 - t18794 - t18795 + t18796 + t18797 - t18798 - t18799 + t18241 - t18244 + t18247 - t18257 - t18455 * t849 / 0.32e2 + t3601 - t3605 + t3608 - t3613;
  t19020 = t3117 * t18832;
  t19023 = t2758 * t13980;
  t19026 = t852 * t712;
  t19042 = t2382 * t450 * t12023;
  t19045 = t3772 * t13957;
  t19046 = t534 * t19045;
  t19054 = -t3503 + t3507 + t3511 - t3518 - t3536 + t3537 - t3519 + t3520 - 0.3e1 / 0.2e1 * t534 * t19020 + 0.9e1 / 0.8e1 * t534 * t19023 + 0.11e2 / 0.16e2 * t534 * t19026 * t5254 + 0.11e2 / 0.16e2 * t519 * t19023 - 0.15e2 / 0.32e2 * t519 * t12163 * t14569 - 0.25e2 / 0.16e2 * t534 * t12167 * t18821 + 0.15e2 / 0.16e2 * t534 * t10627 * t13980 + 0.9e1 / 0.16e2 * t519 * t19042 - 0.3e1 / 0.16e2 * t19046 - 0.9e1 / 0.16e2 * t519 * t2365 * t1350 * t12023 + 0.5e1 / 0.32e2 * t3513 * t3781;
  t19057 = t534 * t3117 * t8859;
  t19060 = t534 * t2758 * t13957;
  t19064 = t519 * t19045;
  t19067 = t519 * t3113 * t14585;
  t19070 = t534 * t2778 * t13957;
  t19077 = t519 * t3126 * t14585;
  t19081 = t534 * t852 * t717 * t1337;
  t19084 = t534 * t3130 * t9004;
  t19104 = t19057 / 0.4e1 - 0.3e1 / 0.16e2 * t19060 - 0.7e1 / 0.32e2 * t519 * t19020 - 0.3e1 / 0.32e2 * t19064 + 0.3e1 / 0.32e2 * t19067 - t19070 / 0.8e1 - 0.11e2 / 0.32e2 * t519 * t2382 * t420 * t12023 + 0.3e1 / 0.32e2 * t19077 - t19081 / 0.16e2 + 0.3e1 / 0.16e2 * t19084 + 0.3e1 / 0.8e1 * t534 * t19026 * t5411 - t534 * t19026 * t5235 / 0.16e2 - 0.5e1 / 0.32e2 * t3513 * t3774 + 0.5e1 / 0.32e2 * t3513 * t3790 - 0.11e2 / 0.16e2 * t534 * t3130 * t8931 + 0.11e2 / 0.16e2 * t534 * t19042 + 0.3e1 / 0.8e1 * t534 * t2778 * t13980 - t18631 - t18459;
  t19105 = 0.3e1 / 0.16e2 * t18645;
  t19106 = 0.3e1 / 0.16e2 * t18648;
  t19107 = 0.3e1 / 0.16e2 * t18651;
  t19108 = t18654 / 0.4e1;
  t19109 = 0.3e1 / 0.8e1 * t18656;
  t19110 = t18659 / 0.2e1;
  t19111 = 0.3e1 / 0.8e1 * t18662;
  t19112 = 0.3e1 / 0.8e1 * t18665;
  t19113 = t18669 / 0.8e1;
  t19114 = 0.3e1 / 0.8e1 * t18461;
  t19115 = 0.3e1 / 0.16e2 * t18464;
  t19116 = 0.3e1 / 0.8e1 * t18466;
  t19117 = 0.3e1 / 0.16e2 * t18469;
  t19118 = t18473 / 0.4e1;
  t19119 = 0.3e1 / 0.16e2 * t18476;
  t19120 = t18479 / 0.2e1;
  t19121 = 0.3e1 / 0.8e1 * t18482;
  t19122 = t18486 / 0.8e1;
  t19123 = -t721 + t19105 - t19106 + t19107 - t19108 - t19109 + t19110 - t19111 + t19112 - t19113 + t19114 - t19115 - t19116 + t19117 - t19118 + t19119 + t19120 - t19121 - t19122;
  t19126 = my_piecewise3(t51, 0, t19019 + t19054 + t19104 + t19123);
  tv4sigma2lapltau23 = t3 * t19126;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t19133 = t3179 * t18723;
  t19140 = t469 * t3179 * t8432;
  t19141 = 0.3e1 / 0.32e2 * t19140;
  t19142 = -t18679 - t18680 + t18681 - t18682 - t18683 + t18684 - t18685 + t18686 - t18687 + t18688 + 0.3e1 / 0.8e1 * t484 * t3193 * t18727 - 0.11e2 / 0.16e2 * t484 * t3193 * t8403 + 0.11e2 / 0.16e2 * t484 * t19133 - 0.11e2 / 0.32e2 * t469 * t2255 * t12214 + t19141;
  t19146 = t484 * t3193 * t8432;
  t19147 = 0.3e1 / 0.16e2 * t19146;
  t19150 = t3179 * t17979;
  t19151 = t484 * t19150;
  t19152 = 0.3e1 / 0.16e2 * t19151;
  t19157 = t484 * t3193 * t17967;
  t19158 = t19157 / 0.8e1;
  t19159 = t866 * t690;
  t19163 = t3183 * t18701;
  t19175 = t3179 * t8459;
  t19187 = 0.5e1 / 0.32e2 * t3458 * t3815 + t19147 + 0.9e1 / 0.16e2 * t469 * t19133 - t19152 - 0.9e1 / 0.16e2 * t469 * t2260 * t12263 - t19158 + 0.11e2 / 0.16e2 * t484 * t19159 * t4331 + 0.11e2 / 0.16e2 * t469 * t19163 - 0.15e2 / 0.32e2 * t469 * t12326 * t8479 - 0.25e2 / 0.16e2 * t484 * t3183 * t8479 + 0.15e2 / 0.16e2 * t484 * t12326 * t18711 - 0.3e1 / 0.2e1 * t484 * t19175 + 0.9e1 / 0.8e1 * t484 * t19163 - 0.5e1 / 0.32e2 * t3458 * t3809 + 0.5e1 / 0.32e2 * t3458 * t3828 + 0.3e1 / 0.8e1 * t484 * t19159 * t4414;
  t19193 = t484 * t3179 * t8310;
  t19194 = t19193 / 0.4e1;
  t19196 = t484 * t3183 * t18745;
  t19197 = 0.3e1 / 0.16e2 * t19196;
  t19200 = t484 * t866 * t695 * t986;
  t19201 = t19200 / 0.16e2;
  t19204 = t469 * t19150;
  t19205 = 0.3e1 / 0.32e2 * t19204;
  t19207 = t469 * t3183 * t8310;
  t19208 = 0.3e1 / 0.32e2 * t19207;
  t19213 = -t484 * t19159 * t4319 / 0.16e2 + t19194 - t19197 - t19201 - 0.7e1 / 0.32e2 * t469 * t19175 - t19205 + t19208 - t99 * t18044 * t866 * t269 / 0.32e2 + t18101 - t18104 + t18107 - t18114 + t3818 + t3819 - t3820;
  t19223 = -t3821 - t3464 + t3465 - t3481 + t3485 - t18549 / 0.8e1 - t699 + 0.3e1 / 0.8e1 * t18554 - 0.3e1 / 0.4e1 * t18557 + 0.3e1 / 0.8e1 * t18560 - t18563 / 0.2e1 - 0.3e1 / 0.8e1 * t18565 + t18568 - 0.3e1 / 0.4e1 * t18571 + 0.3e1 / 0.4e1 * t18574 - t18578 / 0.4e1;
  t19226 = my_piecewise3(t2, 0, t19142 + t19187 + t19213 + t19223);
  tv4sigma2tau20 = t3 * t19226;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t19230 = t534 * t3302 * t9004;
  t19231 = 0.3e1 / 0.16e2 * t19230;
  t19233 = t2382 * t6233 * t883;
  t19236 = t883 * t712;
  t19240 = t3282 * t18817;
  t19243 = -t18790 + t18791 - t18792 + t18793 - t18794 - t18795 + t18796 + t18797 - t18798 - t18799 + 0.5e1 / 0.32e2 * t3513 * t3852 + t19231 + 0.9e1 / 0.16e2 * t519 * t19233 + 0.11e2 / 0.16e2 * t534 * t19236 * t5254 + 0.11e2 / 0.16e2 * t519 * t19240;
  t19253 = t3278 * t18832;
  t19262 = t519 * t3278 * t9004;
  t19263 = 0.3e1 / 0.32e2 * t19262;
  t19282 = t3278 * t18122;
  t19283 = t519 * t19282;
  t19284 = 0.3e1 / 0.32e2 * t19283;
  t19286 = t519 * t3282 * t8859;
  t19287 = 0.3e1 / 0.32e2 * t19286;
  t19288 = -0.15e2 / 0.32e2 * t519 * t12752 * t18821 - 0.25e2 / 0.16e2 * t534 * t3282 * t18821 + 0.15e2 / 0.16e2 * t534 * t12752 * t18828 - 0.3e1 / 0.2e1 * t534 * t19253 + 0.9e1 / 0.8e1 * t534 * t19240 - 0.11e2 / 0.32e2 * t519 * t2382 * t12694 + t19263 + 0.3e1 / 0.8e1 * t534 * t3302 * t18809 - 0.11e2 / 0.16e2 * t534 * t3302 * t8931 + 0.11e2 / 0.16e2 * t534 * t19233 - 0.5e1 / 0.32e2 * t3513 * t3846 + 0.5e1 / 0.32e2 * t3513 * t3865 + 0.3e1 / 0.8e1 * t534 * t19236 * t5411 - t534 * t19236 * t5235 / 0.16e2 - t19284 + t19287;
  t19291 = t534 * t3278 * t8859;
  t19292 = t19291 / 0.4e1;
  t19294 = t534 * t3282 * t18840;
  t19295 = 0.3e1 / 0.16e2 * t19294;
  t19298 = t534 * t883 * t717 * t1337;
  t19299 = t19298 / 0.16e2;
  t19302 = t534 * t19282;
  t19303 = 0.3e1 / 0.16e2 * t19302;
  t19308 = t534 * t3302 * t18147;
  t19309 = t19308 / 0.8e1;
  t19314 = t19292 - t19295 - t19299 - 0.7e1 / 0.32e2 * t519 * t19253 - t19303 - 0.9e1 / 0.16e2 * t519 * t2365 * t12650 - t19309 - t156 * t18226 * t883 * t424 / 0.32e2 + t18241 - t18244 + t18247 - t18257 + t3855 - t3856 + t3857;
  t19324 = -t3858 - t3536 + t3537 - t3519 + t3520 - t18630 / 0.8e1 - t721 + 0.3e1 / 0.8e1 * t18645 - 0.3e1 / 0.8e1 * t18648 + 0.3e1 / 0.8e1 * t18651 - t18654 / 0.2e1 - 0.3e1 / 0.4e1 * t18656 + t18659 - 0.3e1 / 0.4e1 * t18662 + 0.3e1 / 0.4e1 * t18665 - t18669 / 0.4e1;
  t19327 = my_piecewise3(t51, 0, t19243 + t19288 + t19314 + t19324);
  tv4sigma2tau217 = t3 * t19327;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t19332 = t16249 * t5636;
  t19335 = t5643 * t183;
  t19336 = t16253 * t19335;
  t19339 = t16249 * t14778;
  t19344 = t3969 * t3461;
  t19350 = -t18280 - t18283 + t18286 + t18289 - t18293 - t3969 * t3647 / 0.16e2 + t3969 * t3674 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t19332 + 0.9e1 / 0.8e1 * t484 * t19336 + 0.9e1 / 0.16e2 * t469 * t19339 - 0.7e1 / 0.32e2 * t469 * t19332 - t19344 / 0.16e2 + t3969 * t3654 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t19339;
  t19354 = t5559 * t183;
  t19361 = t3886 * t183;
  t19382 = t5610 * t183;
  t19386 = t3361 * t3886;
  t19394 = t260 * t183 * t263;
  t19406 = t4456 * t183;
  t19409 = t495 * t471;
  t19412 = t296 * t13012;
  t19415 = t114 * t13012;
  t19427 = t19394 * t558 / 0.4e1 + t18010 + t200 * t183 * t290 / 0.2e1 - t16189 * t741 / 0.2e1 - t16192 * t745 / 0.2e1 - t16195 * t13013 / 0.2e1 + t19406 * t16199 / 0.2e1 + t18022 + t3876 * t19409 / 0.2e1 - t3876 * t19412 / 0.2e1 - t3876 * t19415 / 0.2e1 - t18030 * t199 * t116 / 0.2e1 - t18036 - t3878 * t19409 / 0.2e1 + t3878 * t19412 / 0.2e1 + t3878 * t19415 / 0.2e1;
  t19432 = -0.9e1 / 0.16e2 * t469 * t1449 * t16303 + 0.3e1 / 0.8e1 * t484 * t16279 * t19354 - 0.11e2 / 0.32e2 * t469 * t489 * t16283 - 0.11e2 / 0.16e2 * t484 * t19361 * t4309 + 0.3e1 / 0.8e1 * t484 * t19361 * t4414 - t484 * t19361 * t4319 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t16249 * t19335 + 0.11e2 / 0.16e2 * t469 * t19336 - 0.15e2 / 0.32e2 * t469 * t16257 * t5652 - 0.25e2 / 0.16e2 * t484 * t16253 * t5652 + 0.15e2 / 0.16e2 * t484 * t16257 * t19382 + 0.3e1 / 0.32e2 * t99 * t19386 * t1001 + 0.3e1 / 0.32e2 * t99 * t19386 * t964 - t99 * t19427 * t798 * t269 / 0.32e2;
  t19437 = 0.9e1 / 0.32e2 * t18737;
  t19438 = 0.9e1 / 0.32e2 * t18740;
  t19439 = 0.3e1 / 0.4e1 * t18743;
  t19440 = 0.9e1 / 0.16e2 * t18747;
  t19441 = 0.3e1 / 0.16e2 * t18751;
  t19442 = 0.3e1 / 0.8e1 * t18756;
  t19443 = 0.9e1 / 0.32e2 * t18764;
  t19444 = 0.9e1 / 0.16e2 * t18767;
  t19445 = 0.9e1 / 0.16e2 * t18771;
  t19446 = -0.3e1 / 0.32e2 * t99 * t19386 * t972 + t18101 - t18104 + t18107 - t18114 - t19437 + t19438 + t19439 - t19440 - t19441 - t19442 + t19443 + t19444 - t19445;
  t19448 = t3901 - t3902 + t3903 - t3904 - t3661 + t3662 - t3671 + t3684 - 0.3e1 / 0.32e2 * t18356 - t699 - t18371 + t18374 - t18376 + t18379;
  t19451 = my_piecewise3(t2, 0, t19350 + t19432 + t19446 + t19448);
  tv4sigmalapl30 = t3 * t19451;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t19452 = t4005 * t3516;
  t19456 = t6299 * t191;
  t19463 = t3416 * t3932;
  t19474 = t415 * t191 * t418;
  t19486 = t5274 * t191;
  t19489 = t545 * t521;
  t19492 = t451 * t13398;
  t19495 = t171 * t13398;
  t19507 = t19474 * t597 / 0.4e1 + t18192 + t208 * t191 * t445 / 0.2e1 - t16486 * t758 / 0.2e1 - t16489 * t762 / 0.2e1 - t16492 * t13399 / 0.2e1 + t19486 * t16496 / 0.2e1 + t18204 + t3922 * t19489 / 0.2e1 - t3922 * t19492 / 0.2e1 - t3922 * t19495 / 0.2e1 - t18212 * t207 * t173 / 0.2e1 - t18218 - t3924 * t19489 / 0.2e1 + t3924 * t19492 / 0.2e1 + t3924 * t19495 / 0.2e1;
  t19512 = 0.9e1 / 0.16e2 * t18842;
  t19513 = 0.9e1 / 0.32e2 * t18847;
  t19514 = -t19452 / 0.16e2 + t4005 * t3695 / 0.16e2 + 0.3e1 / 0.8e1 * t534 * t16585 * t19456 - 0.11e2 / 0.32e2 * t519 * t539 * t16589 + 0.3e1 / 0.32e2 * t156 * t19463 * t1352 + 0.3e1 / 0.32e2 * t156 * t19463 * t1382 - 0.3e1 / 0.32e2 * t156 * t19463 * t1344 - t156 * t19507 * t815 * t424 / 0.32e2 + t18241 - t18244 + t18247 - t18257 - t19512 - t19513;
  t19515 = 0.9e1 / 0.32e2 * t18850;
  t19516 = 0.3e1 / 0.4e1 * t18853;
  t19517 = 0.3e1 / 0.16e2 * t18857;
  t19518 = 0.3e1 / 0.8e1 * t18862;
  t19519 = 0.9e1 / 0.32e2 * t18870;
  t19520 = 0.9e1 / 0.16e2 * t18873;
  t19521 = 0.9e1 / 0.16e2 * t18875;
  t19522 = t19515 + t19516 - t19517 - t19518 + t19519 + t19520 - t19521 - t3947 + t3948 + t3949 - t3950 - t3715 + t3728 - t3705;
  t19526 = t539 * t6239 * t3932;
  t19529 = t3932 * t191;
  t19541 = t16550 * t6234;
  t19551 = t6247 * t191;
  t19552 = t16538 * t19551;
  t19558 = t3706 - 0.3e1 / 0.32e2 * t18458 - t721 - 0.7e1 / 0.32e2 * t519 * t19526 - 0.11e2 / 0.16e2 * t534 * t19529 * t5389 + 0.3e1 / 0.8e1 * t534 * t19529 * t5411 - t534 * t19529 * t5235 / 0.16e2 + t4005 * t3718 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t19541 + 0.9e1 / 0.16e2 * t519 * t19541 - 0.9e1 / 0.16e2 * t519 * t16538 * t6240 - 0.3e1 / 0.2e1 * t534 * t19526 + 0.9e1 / 0.8e1 * t534 * t19552 + 0.11e2 / 0.16e2 * t534 * t16550 * t19551;
  t19567 = t6227 * t191;
  t19573 = 0.11e2 / 0.16e2 * t519 * t19552 - 0.15e2 / 0.32e2 * t519 * t16542 * t6258 - 0.25e2 / 0.16e2 * t534 * t16538 * t6258 + 0.15e2 / 0.16e2 * t534 * t16542 * t19567 - t4005 * t3688 / 0.16e2 + t18462 - t18465 - t18467 + t18470 - t18474 + t18477 + t18480 - t18483 - t18487;
  t19576 = my_piecewise3(t51, 0, t19514 + t19522 + t19558 + t19573);
  tv4sigmalapl311 = t3 * t19576;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  t19577 = t19344 / 0.32e2;
  t19581 = t16645 * t5636;
  t19586 = t2645 * t14819;
  t19605 = -t18907 - t18908 + t18909 + t18910 - t18911 - t19577 + t18101 - t18104 + t18107 - t18114 - 0.9e1 / 0.16e2 * t469 * t16666 * t10082 - 0.3e1 / 0.2e1 * t484 * t19581 - t3969 * t3735 / 0.16e2 + 0.9e1 / 0.8e1 * t484 * t19586 + 0.11e2 / 0.16e2 * t484 * t16645 * t19335 + 0.11e2 / 0.16e2 * t469 * t19586 - 0.15e2 / 0.32e2 * t469 * t14791 * t10082 - 0.25e2 / 0.16e2 * t484 * t16654 * t5652 + 0.15e2 / 0.16e2 * t484 * t9912 * t14819 + t3969 * t3754 / 0.16e2;
  t19606 = t2666 * t14819;
  t19614 = t3979 * t183;
  t19631 = 0.11e2 / 0.16e2 * t484 * t19606 + 0.9e1 / 0.16e2 * t469 * t19606 - t18738 + t18741 + t18744 - t18748 - t18752 - t18757 + t18765 + t18768 - t18772 - 0.11e2 / 0.16e2 * t484 * t2662 * t10849 + 0.3e1 / 0.8e1 * t484 * t19614 * t4414 - t484 * t19614 * t4319 / 0.16e2 - 0.7e1 / 0.32e2 * t469 * t19581 - 0.11e2 / 0.32e2 * t469 * t2453 * t16705 + 0.3e1 / 0.8e1 * t484 * t2653 * t14819 + t3969 * t3742 / 0.16e2 + t3557 + t3560;
  t19633 = 0.3e1 / 0.16e2 * t18919;
  t19634 = 0.3e1 / 0.16e2 * t18922;
  t19635 = 0.3e1 / 0.8e1 * t18925;
  t19636 = 0.3e1 / 0.8e1 * t18927;
  t19637 = t18936 / 0.4e1;
  t19638 = 0.3e1 / 0.16e2 * t18971;
  t19639 = t18974 / 0.2e1;
  t19640 = 0.3e1 / 0.8e1 * t18977;
  t19641 = t18981 / 0.8e1;
  t19643 = -t3565 - t3569 + t3657 - t3658 + t3659 - t3660 - t3661 + t3662 - t3671 + t3684 - t19633 + t19634 + t19635 - t19636 - t19637 + t19638 + t19639 - t19640 - t19641 - t18549 / 0.32e2;
  t19654 = t3969 * t3563;
  t19665 = -t18357 - t699 + 0.3e1 / 0.32e2 * t3458 * t3992 - 0.3e1 / 0.32e2 * t3458 * t3984 + 0.3e1 / 0.32e2 * t3458 * t3976 - t23 * t26 * t19427 * t832 / 0.32e2 - t19654 / 0.32e2 + 0.3e1 / 0.32e2 * t18554 - 0.3e1 / 0.16e2 * t18557 + 0.3e1 / 0.32e2 * t18560 - t18563 / 0.8e1 - 0.3e1 / 0.32e2 * t18565 + t18568 / 0.4e1 - 0.3e1 / 0.16e2 * t18571 + 0.3e1 / 0.16e2 * t18574 - t18578 / 0.16e2 - t19009 + t19010 - t19011 + t19012;
  t19668 = my_piecewise3(t2, 0, t19605 + t19631 + t19643 + t19665);
  tv4sigmalapl2tau0 = t3 * t19668;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  t19669 = t19452 / 0.32e2;
  t19676 = t3772 * t15110;
  t19688 = t12083 * t15110;
  t19691 = t2758 * t15110;
  t19710 = -t19669 + t18241 - t18244 + t18247 - t18257 + 0.3e1 / 0.8e1 * t534 * t2778 * t15110 - 0.11e2 / 0.32e2 * t519 * t2590 * t16968 + 0.11e2 / 0.16e2 * t534 * t19676 - 0.9e1 / 0.16e2 * t519 * t2578 * t16968 + t4005 * t3781 / 0.16e2 - t4005 * t3774 / 0.16e2 + t4005 * t3790 / 0.16e2 - 0.3e1 / 0.2e1 * t534 * t19688 + 0.9e1 / 0.8e1 * t534 * t19691 + 0.9e1 / 0.16e2 * t519 * t19676 + 0.11e2 / 0.16e2 * t534 * t17006 * t19551 + 0.11e2 / 0.16e2 * t519 * t19691 - 0.15e2 / 0.32e2 * t519 * t15089 * t10461 - 0.25e2 / 0.16e2 * t534 * t17023 * t6258 + 0.15e2 / 0.16e2 * t534 * t10627 * t15110;
  t19716 = t4019 * t191;
  t19723 = -0.7e1 / 0.32e2 * t519 * t19688 - 0.11e2 / 0.16e2 * t534 * t2785 * t11307 + 0.3e1 / 0.8e1 * t534 * t19716 * t5411 - t534 * t19716 * t5235 / 0.16e2 - t18843 - t18848 + t18851 + t18854 - t18858 - t18863 + t18871 + t18874 - t18876 + t3601 - t3605 + t3608 - t3613 - t3701 + t3702 + t3703;
  t19725 = 0.3e1 / 0.8e1 * t19046;
  t19726 = t19057 / 0.2e1;
  t19727 = 0.3e1 / 0.8e1 * t19060;
  t19728 = 0.3e1 / 0.16e2 * t19064;
  t19729 = 0.3e1 / 0.16e2 * t19067;
  t19730 = t19070 / 0.4e1;
  t19731 = 0.3e1 / 0.16e2 * t19077;
  t19732 = t19081 / 0.8e1;
  t19733 = 0.3e1 / 0.8e1 * t19084;
  t19735 = t4005 * t3611;
  t19743 = -t3704 - t3715 + t3728 - t3705 + t3706 - t19725 + t19726 - t19727 - t19728 + t19729 - t19730 + t19731 - t19732 + t19733 - t18630 / 0.32e2 - t18459 - t721 - t19735 / 0.32e2 - t60 * t26 * t19507 * t849 / 0.32e2 - 0.3e1 / 0.32e2 * t3513 * t4009;
  t19757 = 0.3e1 / 0.32e2 * t3513 * t4028 + 0.3e1 / 0.32e2 * t3513 * t4016 + 0.3e1 / 0.32e2 * t18645 - 0.3e1 / 0.32e2 * t18648 + 0.3e1 / 0.32e2 * t18651 - t18654 / 0.8e1 - 0.3e1 / 0.16e2 * t18656 + t18659 / 0.4e1 - 0.3e1 / 0.16e2 * t18662 + 0.3e1 / 0.16e2 * t18665 - t18669 / 0.16e2 + t19114 - t19115 - t19116 + t19117 - t19118 + t19119 + t19120 - t19121 - t19122;
  t19760 = my_piecewise3(t51, 0, t19710 + t19723 + t19743 + t19757);
  tv4sigmalapl2tau17 = t3 * t19760;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  t19770 = -0.3e1 / 0.16e2 * t18279 - 0.3e1 / 0.16e2 * t18282 + t18285 / 0.4e1 + 0.3e1 / 0.16e2 * t18288 - t18292 / 0.16e2 + t19141 + t19147 - t19152 - t19158 + t19194 - t19197 - t19201 - t19205 + t19208 - t99 * t19427 * t866 * t269 / 0.32e2 + t18101 - t18104 + t18107 - t18114;
  t19771 = t8233 * t17116;
  t19777 = t8241 * t17116;
  t19793 = t15790 * t15325;
  t19818 = -0.7e1 / 0.32e2 * t469 * t19771 - 0.11e2 / 0.16e2 * t484 * t15824 * t15325 + 0.9e1 / 0.16e2 * t469 * t19777 + 0.11e2 / 0.16e2 * t484 * t19777 - 0.9e1 / 0.16e2 * t469 * t2475 * t17116 + 0.3e1 / 0.8e1 * t484 * t15808 * t15325 - 0.11e2 / 0.32e2 * t469 * t2453 * t17116 - 0.3e1 / 0.2e1 * t484 * t19771 + 0.9e1 / 0.8e1 * t484 * t19793 + 0.3e1 / 0.8e1 * t484 * t3822 * t43 * t17136 - t484 * t4058 * t183 * t4319 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t17080 * t19335 + 0.11e2 / 0.16e2 * t469 * t19793 - 0.15e2 / 0.32e2 * t469 * t15794 * t15325 - 0.25e2 / 0.16e2 * t484 * t15778 * t15325 + 0.15e2 / 0.16e2 * t484 * t15782 * t15325 + t3818 + t3819 - t3820 - t3821;
  t19821 = t3448 - t3452 + t3456 - t3463 - t3661 + t3662 - t3671 + t3684 - t19633 + t19634 + t19635 - t19636 - t19637 + t19638 + t19639 - t19640 - t19641 - t18550 - t18356 / 0.32e2 - t699;
  t19834 = t19654 / 0.16e2;
  t19839 = -t3969 * t3809 / 0.16e2 + t3969 * t3828 / 0.16e2 - 0.3e1 / 0.32e2 * t3458 * t4048 + 0.3e1 / 0.32e2 * t3458 * t4064 + 0.3e1 / 0.32e2 * t3458 * t4055 + t3969 * t3815 / 0.16e2 - t19834 + t19000 - t19001 + t19002 - t19003 - t19004 + t19005 - t19006 + t19007 - t19008 - t18370 / 0.8e1 + 0.3e1 / 0.32e2 * t18373 - 0.3e1 / 0.32e2 * t18375 + 0.3e1 / 0.32e2 * t18378;
  t19842 = my_piecewise3(t2, 0, t19770 + t19818 + t19821 + t19839);
  tv4sigmalapltau20 = t3 * t19842;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  t19847 = t2572 * t17382;
  t19861 = t19231 + t19263 - t19284 + t19287 + t19292 - t19295 - t19299 - t19303 - t19309 - t156 * t19507 * t883 * t424 / 0.32e2 + t18241 - t18244 + t18247 - t18257 + 0.9e1 / 0.16e2 * t519 * t19847 + 0.11e2 / 0.16e2 * t534 * t19847 - 0.9e1 / 0.16e2 * t519 * t2578 * t17382 + 0.3e1 / 0.8e1 * t534 * t15983 * t9738 - 0.11e2 / 0.32e2 * t519 * t2590 * t17382;
  t19882 = t16085 * t9738;
  t19885 = t17352 * t9738;
  t19895 = 0.3e1 / 0.8e1 * t534 * t3859 * t75 * t7125 - t534 * t4093 * t191 * t5235 / 0.16e2 - 0.15e2 / 0.32e2 * t519 * t16089 * t9738 - 0.25e2 / 0.16e2 * t534 * t16093 * t9738 + 0.15e2 / 0.16e2 * t534 * t16081 * t9738 + 0.11e2 / 0.16e2 * t534 * t17345 * t19551 + 0.11e2 / 0.16e2 * t519 * t19882 - 0.3e1 / 0.2e1 * t534 * t19885 + 0.9e1 / 0.8e1 * t534 * t19882 - 0.7e1 / 0.32e2 * t519 * t19885 - 0.11e2 / 0.16e2 * t534 * t16000 * t9738 + t3855 - t3856 + t3857 - t3858 - t3503 + t3507 + t3511 - t3518 - t3715;
  t19908 = t3728 - t3705 + t3706 - t19725 + t19726 - t19727 - t19728 + t19729 - t19730 + t19731 - t19732 + t19733 - t18631 - t18458 / 0.32e2 - t721 + 0.3e1 / 0.32e2 * t3513 * t4099 - 0.3e1 / 0.32e2 * t3513 * t4083 - t4005 * t3846 / 0.16e2 + t4005 * t3865 / 0.16e2 + 0.3e1 / 0.32e2 * t3513 * t4090;
  t19911 = t19735 / 0.16e2;
  t19921 = t4005 * t3852 / 0.16e2 - t19911 + t19105 - t19106 + t19107 - t19108 - t19109 + t19110 - t19111 + t19112 - t19113 + 0.3e1 / 0.16e2 * t18461 - 0.3e1 / 0.32e2 * t18464 - 0.3e1 / 0.16e2 * t18466 + 0.3e1 / 0.32e2 * t18469 - t18473 / 0.8e1 + 0.3e1 / 0.32e2 * t18476 + t18479 / 0.4e1 - 0.3e1 / 0.16e2 * t18482 - t18486 / 0.16e2;
  t19924 = my_piecewise3(t51, 0, t19861 + t19895 + t19908 + t19921);
  tv4sigmalapltau217 = t3 * t19924;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t19925 = 0.9e1 / 0.32e2 * t19140;
  t19926 = 0.9e1 / 0.16e2 * t19146;
  t19927 = 0.9e1 / 0.16e2 * t19151;
  t19928 = 0.3e1 / 0.8e1 * t19157;
  t19929 = 0.3e1 / 0.4e1 * t19193;
  t19930 = 0.9e1 / 0.16e2 * t19196;
  t19931 = 0.3e1 / 0.16e2 * t19200;
  t19932 = 0.9e1 / 0.32e2 * t19204;
  t19933 = 0.9e1 / 0.32e2 * t19207;
  t19934 = t3361 * t4121;
  t19966 = t19394 * t626 / 0.4e1 + t18010 + t214 * t183 * t290 / 0.2e1 - t17582 * t741 / 0.2e1 - t17585 * t745 / 0.2e1 - t17588 * t13013 / 0.2e1 + t19406 * t17592 / 0.2e1 + t18022 + t4111 * t19409 / 0.2e1 - t4111 * t19412 / 0.2e1 - t4111 * t19415 / 0.2e1 - t18030 * t213 * t116 / 0.2e1 - t18036 - t4113 * t19409 / 0.2e1 + t4113 * t19412 / 0.2e1 + t4113 * t19415 / 0.2e1;
  t19977 = t19925 + t19926 - t19927 - t19928 + t19929 - t19930 - t19931 - t19932 + t19933 + 0.3e1 / 0.32e2 * t99 * t19934 * t1001 - t99 * t19966 * t866 * t269 / 0.32e2 + 0.3e1 / 0.32e2 * t99 * t19934 * t964 - 0.3e1 / 0.32e2 * t99 * t19934 * t972 + t18101;
  t19979 = t17494 * t3563;
  t19980 = t19979 / 0.16e2;
  t19981 = -t18104 + t18107 - t18114 + t4136 + t4137 - t4138 - t4139 - t3661 + t3662 - t3671 + t3684 - 0.3e1 / 0.32e2 * t18549 - t699 - t19980;
  t19985 = t4121 * t183;
  t20002 = t17475 * t5636;
  t20005 = t17479 * t19335;
  t20008 = t17475 * t14778;
  t20022 = t17494 * t3815 / 0.16e2 + 0.3e1 / 0.8e1 * t484 * t19985 * t4414 - t484 * t19985 * t4319 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t19985 * t4309 + 0.15e2 / 0.16e2 * t484 * t17483 * t19382 - t17494 * t3809 / 0.16e2 + t17494 * t3828 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t20002 + 0.9e1 / 0.8e1 * t484 * t20005 + 0.9e1 / 0.16e2 * t469 * t20008 + 0.11e2 / 0.16e2 * t484 * t17475 * t19335 + 0.11e2 / 0.16e2 * t469 * t20005 - 0.15e2 / 0.32e2 * t469 * t17483 * t5652 - 0.25e2 / 0.16e2 * t484 * t17479 * t5652;
  t20036 = -0.7e1 / 0.32e2 * t469 * t20002 + 0.11e2 / 0.16e2 * t484 * t20008 - 0.9e1 / 0.16e2 * t469 * t1449 * t17511 + 0.3e1 / 0.8e1 * t484 * t17519 * t19354 - 0.11e2 / 0.32e2 * t469 * t489 * t17523 + t18555 - t18558 + t18561 - t18564 - t18566 + t18569 - t18572 + t18575 - t18579;
  t20039 = my_piecewise3(t2, 0, t19977 + t19981 + t20022 + t20036);
  tv4sigmatau30 = t3 * t20039;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t20040 = 0.9e1 / 0.16e2 * t19230;
  t20041 = 0.9e1 / 0.32e2 * t19262;
  t20042 = 0.9e1 / 0.32e2 * t19283;
  t20043 = 0.9e1 / 0.32e2 * t19286;
  t20044 = 0.3e1 / 0.4e1 * t19291;
  t20045 = 0.9e1 / 0.16e2 * t19294;
  t20046 = 0.3e1 / 0.16e2 * t19298;
  t20047 = 0.9e1 / 0.16e2 * t19302;
  t20048 = 0.3e1 / 0.8e1 * t19308;
  t20049 = t3416 * t4157;
  t20087 = t19474 * t665 / 0.4e1 + t18192 + t220 * t191 * t445 / 0.2e1 - t17816 * t758 / 0.2e1 - t17819 * t762 / 0.2e1 - t17822 * t13399 / 0.2e1 + t19486 * t17826 / 0.2e1 + t18204 + t4172 * t19489 / 0.2e1 - t4172 * t19492 / 0.2e1 - t4172 * t19495 / 0.2e1 - t18212 * t219 * t173 / 0.2e1 - t18218 - t4174 * t19489 / 0.2e1 + t4174 * t19492 / 0.2e1 + t4174 * t19495 / 0.2e1;
  t20092 = t20040 + t20041 - t20042 + t20043 + t20044 - t20045 - t20046 - t20047 - t20048 - 0.3e1 / 0.32e2 * t156 * t20049 * t1344 + 0.3e1 / 0.32e2 * t156 * t20049 * t1352 + 0.3e1 / 0.32e2 * t156 * t20049 * t1382 - t156 * t20087 * t883 * t424 / 0.32e2 + t18241;
  t20094 = -t18244 + t18247 - t18257 + t4182 - t4183 + t4184 - t4185 - t3715 + t3728 - t3705 + t3706 - 0.3e1 / 0.32e2 * t18630 - t721 + t18646;
  t20096 = t539 * t17928;
  t20099 = t17887 * t3611;
  t20100 = t20099 / 0.16e2;
  t20103 = t17771 * t6234;
  t20112 = -t18649 + t18652 - t18655 - t18657 + t18660 - t18663 + t18666 - t18670 - 0.7e1 / 0.32e2 * t519 * t20096 - t20100 + t17887 * t3852 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t20103 - 0.9e1 / 0.16e2 * t519 * t1649 * t17928 + 0.3e1 / 0.8e1 * t534 * t17936 * t19456;
  t20116 = t4157 * t191;
  t20129 = t17775 * t19551;
  t20151 = -0.11e2 / 0.32e2 * t519 * t539 * t17892 - 0.11e2 / 0.16e2 * t534 * t20116 * t5389 + 0.3e1 / 0.8e1 * t534 * t20116 * t5411 - t534 * t20116 * t5235 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t17771 * t19551 + 0.11e2 / 0.16e2 * t519 * t20129 - 0.15e2 / 0.32e2 * t519 * t17779 * t6258 - 0.25e2 / 0.16e2 * t534 * t17775 * t6258 + 0.15e2 / 0.16e2 * t534 * t17779 * t19567 - 0.3e1 / 0.2e1 * t534 * t20096 + 0.9e1 / 0.8e1 * t534 * t20129 + 0.9e1 / 0.16e2 * t519 * t20103 - t17887 * t3846 / 0.16e2 + t17887 * t3865 / 0.16e2;
  t20154 = my_piecewise3(t51, 0, t20092 + t20094 + t20112 + t20151);
  tv4sigmatau311 = t3 * t20154;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t20156 = t798 * t798;
  t20157 = t100 * t20156;
  t20167 = t3881 * t3886;
  t20180 = t260 * t20156;
  t20221 = t1023 * t798;
  t20228 = t258 * t3881;
  t20232 = t1026 * t798;
  t20239 = t800 / 0.4e1 + t18010 + t804 / 0.2e1 - t807 / 0.2e1 - t810 / 0.2e1 - t4452 * t798 * t269 / 0.2e1 + t4456 * t798 * t269 / 0.2e1 + t18022 + t20221 * t290 / 0.2e1 - t20221 * t297 / 0.2e1 - t20221 * t301 / 0.2e1 - t20228 * t199 * t116 / 0.2e1 - t18036 - t20232 * t290 / 0.2e1 + t20232 * t297 / 0.2e1 + t20232 * t301 / 0.2e1;
  t20244 = -0.5e1 / 0.32e2 * t19344 + 0.3e1 / 0.8e1 * t99 * t20157 * t4414 - t99 * t20157 * t4319 / 0.16e2 + 0.15e2 / 0.16e2 * t99 * t20157 * t4281 - 0.5e1 / 0.32e2 * t99 * t20167 * t972 + 0.5e1 / 0.32e2 * t99 * t20167 * t1001 - 0.3e1 / 0.2e1 * t99 * t20157 * t4296 + 0.9e1 / 0.8e1 * t99 * t20157 * t4339 + 0.9e1 / 0.16e2 * t99 * t20180 * t4323 + 0.11e2 / 0.16e2 * t99 * t20157 * t4331 + 0.11e2 / 0.16e2 * t99 * t20180 * t4339 - 0.15e2 / 0.32e2 * t99 * t20180 * t4346 - 0.25e2 / 0.16e2 * t99 * t20157 * t4351 + 0.3e1 / 0.8e1 * t99 * t20157 * t4355 + 0.5e1 / 0.32e2 * t99 * t20167 * t964 + 0.11e2 / 0.16e2 * t99 * t20157 * t4323 - 0.11e2 / 0.32e2 * t99 * t20180 * t4422 - 0.7e1 / 0.32e2 * t99 * t20180 * t4296 - t99 * t20239 * t798 * t269 / 0.32e2;
  t20264 = -0.9e1 / 0.16e2 * t99 * t20180 * t4381 - 0.11e2 / 0.16e2 * t99 * t20157 * t4309 + t18101 - t18104 + t18107 - t18114 - 0.9e1 / 0.16e2 * t18737 + 0.9e1 / 0.16e2 * t18740 + 0.3e1 / 0.2e1 * t18743 - 0.9e1 / 0.8e1 * t18747 - 0.3e1 / 0.8e1 * t18751 - 0.3e1 / 0.4e1 * t18756 + 0.9e1 / 0.16e2 * t18764 + 0.9e1 / 0.8e1 * t18767 - 0.9e1 / 0.8e1 * t18771 + t3447 / 0.4e1 - t3451 / 0.4e1 + t3455 / 0.4e1 - t3462 / 0.8e1 - t699;
  t20266 = my_piecewise3(t2, 0, t20244 + t20264);
  tv4lapl40 = t3 * t20266;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t20268 = t815 * t815;
  t20269 = t415 * t20268;
  t20273 = t157 * t20268;
  t20289 = t3927 * t3932;
  t20312 = t1296 * t815;
  t20319 = t413 * t3927;
  t20323 = t1299 * t815;
  t20330 = t817 / 0.4e1 + t18192 + t821 / 0.2e1 - t824 / 0.2e1 - t827 / 0.2e1 - t5270 * t815 * t424 / 0.2e1 + t5274 * t815 * t424 / 0.2e1 + t18204 + t20312 * t445 / 0.2e1 - t20312 * t452 / 0.2e1 - t20312 * t456 / 0.2e1 - t20319 * t207 * t173 / 0.2e1 - t18218 - t20323 * t445 / 0.2e1 + t20323 * t452 / 0.2e1 + t20323 * t456 / 0.2e1;
  t20356 = -0.5e1 / 0.32e2 * t19452 - 0.9e1 / 0.16e2 * t156 * t20269 * t5398 - 0.3e1 / 0.2e1 * t156 * t20273 * t5382 + 0.9e1 / 0.8e1 * t156 * t20273 * t5338 + 0.11e2 / 0.16e2 * t156 * t20273 * t5254 + 0.11e2 / 0.16e2 * t156 * t20269 * t5338 - 0.15e2 / 0.32e2 * t156 * t20269 * t5346 + 0.5e1 / 0.32e2 * t156 * t20289 * t1382 + 0.3e1 / 0.8e1 * t156 * t20273 * t5374 - 0.11e2 / 0.32e2 * t156 * t20269 * t5334 - 0.7e1 / 0.32e2 * t156 * t20269 * t5382 - t156 * t20330 * t815 * t424 / 0.32e2 + 0.3e1 / 0.8e1 * t156 * t20273 * t5411 - t156 * t20273 * t5235 / 0.16e2 - 0.11e2 / 0.16e2 * t156 * t20273 * t5389 - 0.25e2 / 0.16e2 * t156 * t20273 * t5351 + 0.15e2 / 0.16e2 * t156 * t20273 * t5358 - 0.5e1 / 0.32e2 * t156 * t20289 * t1344 + 0.5e1 / 0.32e2 * t156 * t20289 * t1352;
  t20376 = 0.11e2 / 0.16e2 * t156 * t20273 * t5370 + 0.9e1 / 0.16e2 * t156 * t20269 * t5370 + t18241 - t18244 + t18247 - t18257 - 0.9e1 / 0.8e1 * t18842 - 0.9e1 / 0.16e2 * t18847 + 0.9e1 / 0.16e2 * t18850 + 0.3e1 / 0.2e1 * t18853 - 0.3e1 / 0.8e1 * t18857 - 0.3e1 / 0.4e1 * t18862 + 0.9e1 / 0.16e2 * t18870 + 0.9e1 / 0.8e1 * t18873 - 0.9e1 / 0.8e1 * t18875 - t3502 / 0.4e1 + t3506 / 0.4e1 + t3510 / 0.4e1 - t3517 / 0.8e1 - t721;
  t20378 = my_piecewise3(t51, 0, t20356 + t20376);
  tv4lapl44 = t3 * t20378;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  t20380 = -0.3e1 / 0.32e2 * t19344 + t18101 - t18104 + t18107 - t18114 - t19437 + t19438 + t19439 - t19440 - t19441 - t19442 + t19443 + t19444;
  t20381 = 0.9e1 / 0.32e2 * t18919;
  t20382 = 0.9e1 / 0.32e2 * t18922;
  t20383 = 0.9e1 / 0.16e2 * t18925;
  t20384 = 0.9e1 / 0.16e2 * t18927;
  t20385 = -t19445 + t3557 + t3560 - t3565 - t3569 + t3901 - t3902 + t3903 - t3904 - t20381 + t20382 + t20383 - t20384;
  t20387 = 0.3e1 / 0.8e1 * t18936;
  t20388 = 0.9e1 / 0.32e2 * t18971;
  t20389 = 0.3e1 / 0.4e1 * t18974;
  t20390 = 0.9e1 / 0.16e2 * t18977;
  t20391 = 0.3e1 / 0.16e2 * t18981;
  t20392 = t16249 * t7505;
  t20408 = t213 * t3886;
  t20412 = -t20387 + t20388 + t20389 - t20390 - t20391 - t699 - t19834 - 0.7e1 / 0.32e2 * t469 * t20392 - 0.11e2 / 0.32e2 * t469 * t16249 * t7499 - t23 * t26 * t20239 * t832 / 0.32e2 + 0.3e1 / 0.8e1 * t484 * t644 * t5559 * t3886 + 0.5e1 / 0.32e2 * t3969 * t3976 - 0.11e2 / 0.16e2 * t484 * t20408 * t4309;
  t20423 = t16253 * t5643 * t213;
  t20437 = t640 * t5627 * t3886;
  t20453 = 0.3e1 / 0.8e1 * t484 * t20408 * t4414 - t484 * t20408 * t4319 / 0.16e2 + 0.11e2 / 0.16e2 * t484 * t20408 * t4331 + 0.11e2 / 0.16e2 * t469 * t20423 - 0.15e2 / 0.32e2 * t469 * t16257 * t7564 - 0.25e2 / 0.16e2 * t484 * t20408 * t4351 + 0.15e2 / 0.16e2 * t484 * t7591 * t5610 * t3886 + 0.11e2 / 0.16e2 * t484 * t20437 + 0.9e1 / 0.16e2 * t469 * t20437 - 0.9e1 / 0.16e2 * t469 * t16253 * t7505 - 0.3e1 / 0.2e1 * t484 * t20392 + 0.9e1 / 0.8e1 * t484 * t20423 - 0.5e1 / 0.32e2 * t3969 * t3984 + 0.5e1 / 0.32e2 * t3969 * t3992;
  t20456 = my_piecewise3(t2, 0, t20380 + t20385 + t20412 + t20453);
  tv4lapl3tau0 = t3 * t20456;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  t20458 = -0.3e1 / 0.32e2 * t19452 + t18241 - t18244 + t18247 - t18257 - t19512 - t19513 + t19515 + t19516 - t19517 - t19518 + t19519 + t19520;
  t20459 = 0.9e1 / 0.16e2 * t19046;
  t20460 = 0.3e1 / 0.4e1 * t19057;
  t20461 = 0.9e1 / 0.16e2 * t19060;
  t20462 = 0.9e1 / 0.32e2 * t19064;
  t20463 = -t19521 + t3601 - t3605 + t3608 - t3613 - t3947 + t3948 + t3949 - t3950 - t20459 + t20460 - t20461 - t20462;
  t20465 = 0.9e1 / 0.32e2 * t19067;
  t20466 = 0.3e1 / 0.8e1 * t19070;
  t20467 = 0.9e1 / 0.32e2 * t19077;
  t20468 = 0.3e1 / 0.16e2 * t19081;
  t20469 = 0.9e1 / 0.16e2 * t19084;
  t20480 = t16550 * t8054;
  t20483 = t219 * t3932;
  t20490 = t20465 - t20466 + t20467 - t20468 + t20469 - t721 - t19911 - t60 * t26 * t20330 * t849 / 0.32e2 - 0.9e1 / 0.16e2 * t519 * t16538 * t8054 - 0.11e2 / 0.32e2 * t519 * t16550 * t8145 - 0.7e1 / 0.32e2 * t519 * t20480 - t534 * t20483 * t5235 / 0.16e2 - 0.15e2 / 0.32e2 * t519 * t16542 * t8076;
  t20501 = t2181 * t6247 * t3932;
  t20504 = t16550 * t8050;
  t20530 = -0.25e2 / 0.16e2 * t534 * t20483 * t5351 + 0.15e2 / 0.16e2 * t534 * t8030 * t6227 * t3932 - 0.3e1 / 0.2e1 * t534 * t20480 + 0.9e1 / 0.8e1 * t534 * t20501 + 0.9e1 / 0.16e2 * t519 * t20504 + 0.11e2 / 0.16e2 * t534 * t20483 * t5254 + 0.11e2 / 0.16e2 * t519 * t20501 - 0.5e1 / 0.32e2 * t4005 * t4009 + 0.5e1 / 0.32e2 * t4005 * t4028 + 0.11e2 / 0.16e2 * t534 * t20504 + 0.3e1 / 0.8e1 * t534 * t683 * t6299 * t3932 + 0.5e1 / 0.32e2 * t4005 * t4016 - 0.11e2 / 0.16e2 * t534 * t20483 * t5389 + 0.3e1 / 0.8e1 * t534 * t20483 * t5411;
  t20533 = my_piecewise3(t51, 0, t20458 + t20463 + t20490 + t20530);
  tv4lapl3tau7 = t3 * t20533;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  t20538 = -t19577 + t19141 + t19147 - t19152 - t19158 + t19194 - t19197 - t19201 - t19205 + t19208 - t99 * t20239 * t866 * t269 / 0.32e2 + t18101 - t18104 + t18107 - t18114;
  t20539 = -t18738 + t18741 + t18744 - t18748 - t18752 - t18757 + t18765 + t18768 - t18772 + t3818 + t3819 - t3820 - t3821 + t3657 - t3658 + t3659;
  t20550 = t2836 * t12263;
  t20555 = t2836 * t12243;
  t20558 = -t3660 - 0.3e1 / 0.8e1 * t18919 + 0.3e1 / 0.8e1 * t18922 + 0.3e1 / 0.4e1 * t18925 - 0.3e1 / 0.4e1 * t18927 - t18936 / 0.2e1 + 0.3e1 / 0.8e1 * t18971 + t18974 - 0.3e1 / 0.4e1 * t18977 - t18981 / 0.4e1 - t699 - t19654 / 0.8e1 - 0.7e1 / 0.32e2 * t469 * t20550 + 0.5e1 / 0.32e2 * t3969 * t4055 + 0.9e1 / 0.16e2 * t469 * t20555;
  t20569 = t866 * t798;
  t20576 = t5651 * t798;
  t20588 = t3183 * t5643 * t798;
  t20607 = -0.9e1 / 0.16e2 * t469 * t2840 * t12263 - 0.11e2 / 0.32e2 * t469 * t2836 * t12214 - 0.5e1 / 0.32e2 * t3969 * t4048 + 0.5e1 / 0.32e2 * t3969 * t4064 + 0.3e1 / 0.8e1 * t484 * t20569 * t4414 - t484 * t20569 * t4319 / 0.16e2 - 0.25e2 / 0.16e2 * t484 * t3183 * t20576 + 0.15e2 / 0.16e2 * t484 * t12326 * t5610 * t798 + 0.11e2 / 0.16e2 * t484 * t20569 * t4331 + 0.11e2 / 0.16e2 * t469 * t20588 - 0.15e2 / 0.32e2 * t469 * t12326 * t20576 - 0.3e1 / 0.2e1 * t484 * t20550 + 0.9e1 / 0.8e1 * t484 * t20588 - 0.11e2 / 0.16e2 * t484 * t3193 * t10849 + 0.11e2 / 0.16e2 * t484 * t20555 + 0.3e1 / 0.8e1 * t484 * t3193 * t5559 * t798;
  t20610 = my_piecewise3(t2, 0, t20538 + t20539 + t20558 + t20607);
  tv4lapl2tau20 = t3 * t20610;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  t20615 = -t19669 + t19231 + t19263 - t19284 + t19287 + t19292 - t19295 - t19299 - t19303 - t19309 - t156 * t20330 * t883 * t424 / 0.32e2 + t18241 - t18244 + t18247 - t18257;
  t20616 = -t18843 - t18848 + t18851 + t18854 - t18858 - t18863 + t18871 + t18874 - t18876 + t3855 - t3856 + t3857 - t3858 - t3701 + t3702 + t3703;
  t20627 = t883 * t815;
  t20636 = -t3704 - 0.3e1 / 0.4e1 * t19046 + t19057 - 0.3e1 / 0.4e1 * t19060 - 0.3e1 / 0.8e1 * t19064 + 0.3e1 / 0.8e1 * t19067 - t19070 / 0.2e1 + 0.3e1 / 0.8e1 * t19077 - t19081 / 0.4e1 + 0.3e1 / 0.4e1 * t19084 - t721 - t19735 / 0.8e1 - t534 * t20627 * t5235 / 0.16e2 + 0.5e1 / 0.32e2 * t4005 * t4099 + 0.3e1 / 0.8e1 * t534 * t20627 * t5411;
  t20640 = t3278 * t6233 * t815;
  t20650 = t2935 * t12650;
  t20656 = t6257 * t815;
  t20670 = t3282 * t6247 * t815;
  t20685 = -0.5e1 / 0.32e2 * t4005 * t4083 + 0.11e2 / 0.16e2 * t534 * t20640 + 0.3e1 / 0.8e1 * t534 * t3302 * t6299 * t815 - 0.11e2 / 0.16e2 * t534 * t3302 * t11307 - 0.7e1 / 0.32e2 * t519 * t20650 - 0.11e2 / 0.32e2 * t519 * t2935 * t12694 - 0.15e2 / 0.32e2 * t519 * t12752 * t20656 - 0.25e2 / 0.16e2 * t534 * t3282 * t20656 + 0.15e2 / 0.16e2 * t534 * t12752 * t6227 * t815 - 0.3e1 / 0.2e1 * t534 * t20650 + 0.9e1 / 0.8e1 * t534 * t20670 + 0.5e1 / 0.32e2 * t4005 * t4090 + 0.9e1 / 0.16e2 * t519 * t20640 - 0.9e1 / 0.16e2 * t519 * t2939 * t12650 + 0.11e2 / 0.16e2 * t534 * t20627 * t5254 + 0.11e2 / 0.16e2 * t519 * t20670;
  t20688 = my_piecewise3(t51, 0, t20615 + t20616 + t20636 + t20685);
  tv4lapl2tau28 = t3 * t20688;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  t20689 = t3881 * t4121;
  t20715 = t576 * t471;
  t20718 = t296 * t16198;
  t20721 = t114 * t16198;
  t20733 = t260 * t199 * t263 * t626 / 0.4e1 + t18010 + t214 * t199 * t290 / 0.2e1 - t17582 * t839 / 0.2e1 - t17585 * t843 / 0.2e1 - t17588 * t16199 / 0.2e1 + t4456 * t199 * t17592 / 0.2e1 + t18022 + t4111 * t20715 / 0.2e1 - t4111 * t20718 / 0.2e1 - t4111 * t20721 / 0.2e1 - t20228 * t213 * t116 / 0.2e1 - t18036 - t4113 * t20715 / 0.2e1 + t4113 * t20718 / 0.2e1 + t4113 * t20721 / 0.2e1;
  t20738 = t19925 + t19926 - t19927 - t19928 + t19929 - t19930 - t19931 - t19932 + t19933 - 0.3e1 / 0.32e2 * t99 * t20689 * t972 + 0.3e1 / 0.32e2 * t99 * t20689 * t1001 + 0.3e1 / 0.32e2 * t99 * t20689 * t964 - t99 * t20733 * t866 * t269 / 0.32e2 + t18101;
  t20739 = -t18104 + t18107 - t18114 + t4136 + t4137 - t4138 - t4139 + t3448 - t3452 + t3456 - t3463 - t20381 + t20382 + t20383;
  t20742 = t572 * t17511;
  t20745 = t17475 * t17136;
  t20758 = -t20384 - t20387 + t20388 + t20389 - t20390 - t20391 - t699 - t19980 - 0.3e1 / 0.32e2 * t19654 - 0.7e1 / 0.32e2 * t469 * t20742 + 0.11e2 / 0.16e2 * t484 * t20745 - 0.9e1 / 0.16e2 * t469 * t1739 * t17511 + 0.3e1 / 0.8e1 * t484 * t17519 * t5559 * t199 - 0.11e2 / 0.32e2 * t469 * t572 * t17523;
  t20773 = t5643 * t199;
  t20777 = t17479 * t20773;
  t20788 = t4121 * t199;
  t20798 = t17494 * t4055 / 0.16e2 - 0.15e2 / 0.32e2 * t469 * t17483 * t6567 - 0.25e2 / 0.16e2 * t484 * t17479 * t6567 + 0.15e2 / 0.16e2 * t484 * t17483 * t5610 * t199 + 0.9e1 / 0.16e2 * t469 * t20745 + 0.11e2 / 0.16e2 * t484 * t17475 * t20773 + 0.11e2 / 0.16e2 * t469 * t20777 - t17494 * t4048 / 0.16e2 + t17494 * t4064 / 0.16e2 - 0.3e1 / 0.2e1 * t484 * t20742 + 0.9e1 / 0.8e1 * t484 * t20777 + 0.3e1 / 0.8e1 * t484 * t20788 * t4414 - t484 * t20788 * t4319 / 0.16e2 - 0.11e2 / 0.16e2 * t484 * t20788 * t4309;
  t20801 = my_piecewise3(t2, 0, t20738 + t20739 + t20758 + t20798);
  tv4lapltau30 = t3 * t20801;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  t20802 = t3927 * t4157;
  t20828 = t615 * t521;
  t20831 = t451 * t16495;
  t20834 = t171 * t16495;
  t20846 = t415 * t207 * t418 * t665 / 0.4e1 + t18192 + t220 * t207 * t445 / 0.2e1 - t17816 * t856 / 0.2e1 - t17819 * t860 / 0.2e1 - t17822 * t16496 / 0.2e1 + t5274 * t207 * t17826 / 0.2e1 + t18204 + t4172 * t20828 / 0.2e1 - t4172 * t20831 / 0.2e1 - t4172 * t20834 / 0.2e1 - t20319 * t219 * t173 / 0.2e1 - t18218 - t4174 * t20828 / 0.2e1 + t4174 * t20831 / 0.2e1 + t4174 * t20834 / 0.2e1;
  t20851 = t20040 + t20041 - t20042 + t20043 + t20044 - t20045 - t20046 - t20047 - t20048 - 0.3e1 / 0.32e2 * t156 * t20802 * t1344 + 0.3e1 / 0.32e2 * t156 * t20802 * t1352 + 0.3e1 / 0.32e2 * t156 * t20802 * t1382 - t156 * t20846 * t883 * t424 / 0.32e2 + t18241;
  t20852 = -t18244 + t18247 - t18257 + t4182 - t4183 + t4184 - t4185 - t3503 + t3507 + t3511 - t3518 - t20459 + t20460 - t20461;
  t20855 = t17775 * t18405;
  t20858 = t17771 * t7125;
  t20870 = -t20462 + t20465 - t20466 + t20467 - t20468 + t20469 - t721 - 0.3e1 / 0.32e2 * t19735 + 0.9e1 / 0.8e1 * t534 * t20855 + 0.9e1 / 0.16e2 * t519 * t20858 - t17887 * t4083 / 0.16e2 + t17887 * t4099 / 0.16e2 + 0.11e2 / 0.16e2 * t534 * t20858 - 0.9e1 / 0.16e2 * t519 * t1901 * t17928;
  t20878 = t4157 * t207;
  t20885 = t611 * t17928;
  t20910 = 0.3e1 / 0.8e1 * t534 * t17936 * t6299 * t207 - 0.11e2 / 0.32e2 * t519 * t611 * t17892 - 0.11e2 / 0.16e2 * t534 * t20878 * t5389 + 0.3e1 / 0.8e1 * t534 * t20878 * t5411 - 0.7e1 / 0.32e2 * t519 * t20885 + t17887 * t4090 / 0.16e2 - t534 * t20878 * t5235 / 0.16e2 - 0.15e2 / 0.32e2 * t519 * t17779 * t7184 - 0.25e2 / 0.16e2 * t534 * t17775 * t7184 + 0.15e2 / 0.16e2 * t534 * t17779 * t6227 * t207 + 0.11e2 / 0.16e2 * t534 * t17771 * t18405 + 0.11e2 / 0.16e2 * t519 * t20855 - 0.3e1 / 0.2e1 * t534 * t20885 - t20100;
  t20913 = my_piecewise3(t51, 0, t20851 + t20852 + t20870 + t20910);
  tv4lapltau37 = t3 * t20913;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t20923 = t866 * t866;
  t20924 = t260 * t20923;
  t20928 = t100 * t20923;
  t20953 = t4116 * t4121;
  t20957 = 0.9e1 / 0.16e2 * t19140 + 0.9e1 / 0.8e1 * t19146 - 0.9e1 / 0.8e1 * t19151 - 0.3e1 / 0.4e1 * t19157 + 0.3e1 / 0.2e1 * t19193 - 0.9e1 / 0.8e1 * t19196 - 0.3e1 / 0.8e1 * t19200 - 0.9e1 / 0.16e2 * t19204 + 0.9e1 / 0.16e2 * t19207 - 0.9e1 / 0.16e2 * t99 * t20924 * t4381 - 0.11e2 / 0.16e2 * t99 * t20928 * t4309 + 0.3e1 / 0.8e1 * t99 * t20928 * t4414 - t99 * t20928 * t4319 / 0.16e2 + 0.11e2 / 0.16e2 * t99 * t20928 * t4331 + 0.11e2 / 0.16e2 * t99 * t20924 * t4339 - 0.15e2 / 0.32e2 * t99 * t20924 * t4346 - 0.25e2 / 0.16e2 * t99 * t20928 * t4351 + 0.15e2 / 0.16e2 * t99 * t20928 * t4281 - 0.5e1 / 0.32e2 * t99 * t20953 * t972;
  t20995 = t1023 * t866;
  t21006 = t1026 * t866;
  t21013 = t868 / 0.4e1 + t18010 + t872 / 0.2e1 - t875 / 0.2e1 - t878 / 0.2e1 - t4452 * t866 * t269 / 0.2e1 + t4456 * t866 * t269 / 0.2e1 + t18022 + t20995 * t290 / 0.2e1 - t20995 * t297 / 0.2e1 - t20995 * t301 / 0.2e1 - t258 * t4116 * t213 * t116 / 0.2e1 - t18036 - t21006 * t290 / 0.2e1 + t21006 * t297 / 0.2e1 + t21006 * t301 / 0.2e1;
  t21023 = 0.5e1 / 0.32e2 * t99 * t20953 * t1001 - 0.3e1 / 0.2e1 * t99 * t20928 * t4296 + 0.9e1 / 0.8e1 * t99 * t20928 * t4339 + 0.9e1 / 0.16e2 * t99 * t20924 * t4323 + 0.5e1 / 0.32e2 * t99 * t20953 * t964 + 0.11e2 / 0.16e2 * t99 * t20928 * t4323 + 0.3e1 / 0.8e1 * t99 * t20928 * t4355 - 0.11e2 / 0.32e2 * t99 * t20924 * t4422 - 0.7e1 / 0.32e2 * t99 * t20924 * t4296 - t99 * t21013 * t866 * t269 / 0.32e2 + t18101 - t18104 + t18107 - t18114 + t3556 / 0.4e1 + t3559 / 0.4e1 - t3564 / 0.8e1 - t3568 / 0.4e1 - t699 - 0.5e1 / 0.32e2 * t19979;
  t21025 = my_piecewise3(t2, 0, t20957 + t21023);
  tv4tau40 = t3 * t21025;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t21035 = t883 * t883;
  t21036 = t157 * t21035;
  t21040 = t415 * t21035;
  t21047 = t4177 * t4157;
  t21061 = t1296 * t883;
  t21072 = t1299 * t883;
  t21079 = t885 / 0.4e1 + t18192 + t889 / 0.2e1 - t892 / 0.2e1 - t895 / 0.2e1 - t5270 * t883 * t424 / 0.2e1 + t5274 * t883 * t424 / 0.2e1 + t18204 + t21061 * t445 / 0.2e1 - t21061 * t452 / 0.2e1 - t21061 * t456 / 0.2e1 - t413 * t4177 * t219 * t173 / 0.2e1 - t18218 - t21072 * t445 / 0.2e1 + t21072 * t452 / 0.2e1 + t21072 * t456 / 0.2e1;
  t21099 = 0.9e1 / 0.8e1 * t19230 + 0.9e1 / 0.16e2 * t19262 - 0.9e1 / 0.16e2 * t19283 + 0.9e1 / 0.16e2 * t19286 + 0.3e1 / 0.2e1 * t19291 - 0.9e1 / 0.8e1 * t19294 - 0.3e1 / 0.8e1 * t19298 - 0.9e1 / 0.8e1 * t19302 - 0.3e1 / 0.4e1 * t19308 + 0.3e1 / 0.8e1 * t156 * t21036 * t5374 - 0.7e1 / 0.32e2 * t156 * t21040 * t5382 - 0.11e2 / 0.32e2 * t156 * t21040 * t5334 + 0.5e1 / 0.32e2 * t156 * t21047 * t1382 - t156 * t21079 * t883 * t424 / 0.32e2 - 0.9e1 / 0.16e2 * t156 * t21040 * t5398 - 0.11e2 / 0.16e2 * t156 * t21036 * t5389 + 0.3e1 / 0.8e1 * t156 * t21036 * t5411 - t156 * t21036 * t5235 / 0.16e2 + 0.11e2 / 0.16e2 * t156 * t21036 * t5254;
  t21135 = 0.11e2 / 0.16e2 * t156 * t21040 * t5338 - 0.15e2 / 0.32e2 * t156 * t21040 * t5346 - 0.25e2 / 0.16e2 * t156 * t21036 * t5351 + 0.15e2 / 0.16e2 * t156 * t21036 * t5358 - 0.3e1 / 0.2e1 * t156 * t21036 * t5382 + 0.9e1 / 0.8e1 * t156 * t21036 * t5338 + 0.9e1 / 0.16e2 * t156 * t21040 * t5370 - 0.5e1 / 0.32e2 * t156 * t21047 * t1344 + 0.5e1 / 0.32e2 * t156 * t21047 * t1352 + 0.11e2 / 0.16e2 * t156 * t21036 * t5370 + t18241 - t18244 + t18247 - t18257 + t3600 / 0.4e1 - t3604 / 0.4e1 + t3607 / 0.4e1 - t3612 / 0.8e1 - t721 - 0.5e1 / 0.32e2 * t20099;
  t21137 = my_piecewise3(t51, 0, t21099 + t21135);
  tv4tau44 = t3 * t21137;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

