# @file    TestGetMultipleObjects.rb
# @brief   GetMultipleObjects unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestGetMultipleObjects.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestGetMultipleObjects < Test::Unit::TestCase

  def test_GetMultipleObjects_allElements
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == nil)
    end
    list = d.getListOfAllElements()
    assert( list.getSize() == 37 )
    d = nil
  end

  def test_GetMultipleObjects_getId
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == nil)
    end
    obj = d.getElementBySId("no_id")
    assert( obj == nil )
    obj = d.getElementBySId("")
    assert( obj == nil )
    obj = d.getElementBySId("find_id")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_MODEL )
    obj = d.getElementBySId("func1")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_FUNCTION_DEFINITION )
    obj = d.getElementBySId("comp")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_COMPARTMENT )
    obj = d.getElementBySId("b")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_SPECIES )
    obj = d.getElementBySId("x")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_PARAMETER )
    obj = d.getElementBySId("J0")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_REACTION )
    obj = d.getElementBySId("E0")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_EVENT )
    d = nil
  end

  def test_GetMultipleObjects_getMetaId
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == nil)
    end
    obj = d.getElementByMetaId("no_id")
    assert( obj == nil )
    obj = d.getElementByMetaId("")
    assert( obj == nil )
    obj = d.getElementByMetaId("meta1")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_DOCUMENT )
    obj = d.getElementByMetaId("meta2")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_MODEL )
    obj = d.getElementByMetaId("meta3")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_COMPARTMENT )
    obj = d.getElementByMetaId("meta4")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_COMPARTMENT )
    obj = d.getElementByMetaId("meta5")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_SPECIES )
    obj = d.getElementByMetaId("meta6")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_SPECIES )
    obj = d.getElementByMetaId("meta7")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_REACTION )
    obj = d.getElementByMetaId("meta8")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_REACTION )
    obj = d.getElementByMetaId("meta9")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta10")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta11")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_KINETIC_LAW )
    obj = d.getElementByMetaId("meta12")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_EVENT )
    obj = d.getElementByMetaId("meta13")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_EVENT )
    obj = d.getElementByMetaId("meta14")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_TRIGGER )
    obj = d.getElementByMetaId("meta15")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_EVENT_ASSIGNMENT )
    obj = d.getElementByMetaId("meta16")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_EVENT_ASSIGNMENT )
    obj = d.getElementByMetaId("meta17")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_DELAY )
    obj = d.getElementByMetaId("meta18")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_PARAMETER )
    obj = d.getElementByMetaId("meta19")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_PRIORITY )
    obj = d.getElementByMetaId("meta20")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_FUNCTION_DEFINITION )
    obj = d.getElementByMetaId("meta21")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_FUNCTION_DEFINITION )
    obj = d.getElementByMetaId("meta22")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementByMetaId("meta23")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementByMetaId("meta24")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_RULE )
    obj = d.getElementByMetaId("meta25")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_RATE_RULE )
    obj = d.getElementByMetaId("meta26")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_ASSIGNMENT_RULE )
    obj = d.getElementByMetaId("meta27")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_LOCAL_PARAMETER )
    obj = d.getElementByMetaId("meta28")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LOCAL_PARAMETER )
    obj = d.getElementByMetaId("meta29")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_UNIT_DEFINITION )
    obj = d.getElementByMetaId("meta30")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_UNIT_DEFINITION )
    obj = d.getElementByMetaId("meta31")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_UNIT )
    obj = d.getElementByMetaId("meta32")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_UNIT )
    obj = d.getElementByMetaId("meta33")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_PARAMETER )
    obj = d.getElementByMetaId("meta34")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LIST_OF )
    assert( obj.getItemTypeCode() == LibSBML::SBML_MODIFIER_SPECIES_REFERENCE )
    obj = d.getElementByMetaId("meta35")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_MODIFIER_SPECIES_REFERENCE )
    d = nil
  end

  def test_GetMultipleObjects_noAssignments
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "assignments-invalid.xml"
    d = reader.readSBML(filename)
    if (d.getModel() == nil)
    end
    obj = d.getElementBySId("ia")
    assert( obj == nil )
    obj = d.getElementByMetaId("ia_meta")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_INITIAL_ASSIGNMENT )
    obj = d.getElementBySId("ar")
    assert( obj == nil )
    obj = d.getElementByMetaId("ar_meta")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_ASSIGNMENT_RULE )
    obj = d.getElementBySId("rr")
    assert( obj == nil )
    obj = d.getElementByMetaId("rr_meta")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_RATE_RULE )
    obj = d.getElementBySId("ea")
    assert( obj == nil )
    obj = d.getElementByMetaId("ea_meta")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_EVENT_ASSIGNMENT )
    d = nil
  end

  def test_GetMultipleObjects_noLocalParameters
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == nil)
    end
    rxn = d.getElementBySId("J0")
    assert( rxn != nil )
    obj = rxn.getElementBySId("x")
    assert( obj == nil )
    obj = rxn.getElementByMetaId("meta28")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_LOCAL_PARAMETER )
    d = nil
  end

  def test_GetMultipleObjects_noUnits
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "multiple-ids.xml"
    d = reader.readSBML(filename)
    if (d == nil)
    end
    obj = d.getElementBySId("volume")
    assert( obj == nil )
    obj = d.getElementByMetaId("meta30")
    assert( obj != nil )
    assert( obj.getTypeCode() == LibSBML::SBML_UNIT_DEFINITION )
    d = nil
  end

end
