/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.2
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Base class for extending {@link SBMLDocument} in packages.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * The {@link SBMLDocumentPlugin} class is a specialization of {@link SBasePlugin}
 * designed specifically for extending {@link SBMLDocument}.  All package
 * extensions must extend {@link SBMLDocument} to implement support for SBML
 * Level&nbsp;3 packages; these extensions can be subclasses of this
 * class or from a derived class of this class.
 <p>
 * All packages must additionally define a
 * required flag named <code>required</code>, which indicates whether 
 * that package's constructs can be used to change the core mathematics of the
 * <code>&lt;model&gt;</code> child of the <code>&lt;sbml&gt;</code> element.
 * If they can, this attribute must be set <code>true</code>, and if they cannot, this 
 * attribute must be set <code>false.</code>
 <p>
 * <p>
 * <h2>Basic principles of SBML package extensions in libSBML</h2>
 <p>
 * SBML Level&nbsp;3's package structure permits modular extensions to the
 * core SBML format.  In libSBML, support for SBML Level&nbsp;3 packages is
 * provided through optional <em>package extensions</em> that can be plugged
 * into libSBML at the time it is built/compiled.  Users of libSBML can thus
 * choose which extensions are enabled in their software applications.
 <p>
 * LibSBML defines a number of classes that developers of package extensions
 * can use to implement support for an SBML Level&nbsp;3 package.  These
 * classes make it easier to extend libSBML objects with new attributes
 * and/or subobjects as needed by a particular Level&nbsp;3 package.
 * Three overall categories of classes make up libSBML's facilities for
 * implementing package extensions.  There are (1) classes that serve as base
 * classes meant to be subclassed, (2) template classes meant to be
 * instantiated rather than subclassed, and (3) support classes that provide
 * utility features. A given package implementation for libSBML will take
 * the form of code using these and other libSBML classes, placed in a
 * subdirectory of <code>src/sbml/packages/</code>.
 <p>
 * The basic libSBML distribution includes a number of package extensions
 * implementing support for officially-endorsed SBML Level&nbsp;3 packages;
 * among these are <em>Flux Balance Constraints</em> ('fbc'),
 * <em>Hierarchical Model Composition</em> ('comp'), <em>Layout</em>
 * ('layout'), and <em>Qualitative Models</em> ('qual').  They can serve as
 * working examples for developers working to implement other packages.
 <p>
 * Extensions in libSBML can currently only be implemented in C++ or C;
 * there is no mechanism to implement them first in languages such as
 * Java or Python.  However, once implemented in C++ or C, language
 * interfaces can be generated semi-automatically using the framework in
 * place in libSBML.  (The approach is based on using <a target='_blank'
 * href='http://www.swig.org'>SWIG</a> and facilities in libSBML's build
 * system.)
 */

public class SBMLDocumentPlugin extends SBasePlugin {
   private long swigCPtr;

   protected SBMLDocumentPlugin(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SBMLDocumentPlugin_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SBMLDocumentPlugin obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SBMLDocumentPlugin obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SBMLDocumentPlugin(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link SBMLDocumentPlugin} object using the given parameters.
   <p>
   * <p>
 * In the XML representation of an SBML document, XML namespaces are used to
 * identify the origin of each XML construct used.  XML namespaces are
 * identified by their unique resource identifiers (URIs).  The core SBML
 * specifications stipulate the namespaces that must be used for core SBML
 * constructs; for example, all XML elements that belong to SBML Level&nbsp;3
 * Version&nbsp;1 Core must be placed in the XML namespace identified by the URI
 * <code>'http://www.sbml.org/sbml/level3/version1/core'</code>.  Individual
 * SBML Level&nbsp;3 packages define their own XML namespaces; for example,
 * all elements belonging to the SBML Level&nbsp;3 Layout Version&nbsp;1
 * package must be placed in the XML namespace
 * <code>'http://www.sbml.org/sbml/level3/version1/layout/version1/'</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments.
   <p>
   * @param uri the URI of the SBML Level&nbsp;3 package implemented by
   * this libSBML package extension.
   <p>
   * @param prefix the XML namespace prefix being used for the package.
   <p>
   * @param sbmlns the {@link SBMLNamespaces} object for the package.
   */ public
 SBMLDocumentPlugin(String uri, String prefix, SBMLNamespaces sbmlns) {
    this(libsbmlJNI.new_SBMLDocumentPlugin__SWIG_0(uri, prefix, SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor.
   <p>
   * This creates a copy of this object.
   <p>
   * @param orig the {@link SBMLDocumentPlugin} instance to copy.
   */ public
 SBMLDocumentPlugin(SBMLDocumentPlugin orig) {
    this(libsbmlJNI.new_SBMLDocumentPlugin__SWIG_1(SBMLDocumentPlugin.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link SBMLDocumentPlugin} object.
   <p>
   * @return the (deep) copy of this {@link SBMLDocumentPlugin} object.
   */ public
 SBasePlugin cloneObject() {
    long cPtr = libsbmlJNI.SBMLDocumentPlugin_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SBMLDocumentPlugin(cPtr, true);
  }

  
/**
   * Sets the SBML 'required' attribute value.
   <p>
   * <p>
 * SBML Level&nbsp;3 requires that every package defines an attribute named
 * 'required' on the root <code>&lt;sbml&gt;</code> element in an SBML file
 * or data stream.  The attribute, being in the namespace of the Level&nbsp;3
 * package in question, must be prefixed by the XML namespace prefix
 * associated with the package.  The value of the 'required' attribute
 * indicates whether constructs in that package may change the mathematical
 * interpretation of constructs defined in SBML Level&nbsp;3 Core.  A
 * 'required' value of <code>true</code> indicates that the package may do so.  The
 * value of the attribute is set by the Level&nbsp;3 package specification,
 * and does <em>not</em> depend on the actual presence or absence of particular
 * package constructs in a given SBML document: in other words, if the
 * package specification defines any construct that can change the model's
 * meaning, the value of the 'required' attribute must always be set to
 * <code>true</code> in any SBML document that uses the package.
 <p>
 * The XML namespace declaration for an SBML Level&nbsp;3 package is an
 * indication that a model makes use of features defined by that package,
 * while the 'required' attribute indicates whether the features may be
 * ignored without compromising the mathematical meaning of the model.  Both
 * are necessary for a complete reference to an SBML Level&nbsp;3 package.
   <p>
   * @param value the value to be assigned to the 'required' attribute.
   * The 'required' attribute takes a Boolean value, either <code>true</code> or
   * <code>false.</code>
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE}
   *
   * </ul> <p>
   * @see #getRequired()
   * @see #isSetRequired()
   * @see #unsetRequired()
   */ public
 int setRequired(boolean value) {
    return libsbmlJNI.SBMLDocumentPlugin_setRequired(swigCPtr, this, value);
  }

  
/**
   * Returns the value of the 'required' attribute.
   <p>
   * <p>
 * SBML Level&nbsp;3 requires that every package defines an attribute named
 * 'required' on the root <code>&lt;sbml&gt;</code> element in an SBML file
 * or data stream.  The attribute, being in the namespace of the Level&nbsp;3
 * package in question, must be prefixed by the XML namespace prefix
 * associated with the package.  The value of the 'required' attribute
 * indicates whether constructs in that package may change the mathematical
 * interpretation of constructs defined in SBML Level&nbsp;3 Core.  A
 * 'required' value of <code>true</code> indicates that the package may do so.  The
 * value of the attribute is set by the Level&nbsp;3 package specification,
 * and does <em>not</em> depend on the actual presence or absence of particular
 * package constructs in a given SBML document: in other words, if the
 * package specification defines any construct that can change the model's
 * meaning, the value of the 'required' attribute must always be set to
 * <code>true</code> in any SBML document that uses the package.
 <p>
 * The XML namespace declaration for an SBML Level&nbsp;3 package is an
 * indication that a model makes use of features defined by that package,
 * while the 'required' attribute indicates whether the features may be
 * ignored without compromising the mathematical meaning of the model.  Both
 * are necessary for a complete reference to an SBML Level&nbsp;3 package.
   <p>
   * @return the boolean value of 'required' attribute for the SBML package.
   <p>
   * @see #setRequired(boolean value)
   * @see #isSetRequired()
   * @see #unsetRequired()
   */ public
 boolean getRequired() {
    return libsbmlJNI.SBMLDocumentPlugin_getRequired(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'required' attribute.
   <p>
   * <p>
 * SBML Level&nbsp;3 requires that every package defines an attribute named
 * 'required' on the root <code>&lt;sbml&gt;</code> element in an SBML file
 * or data stream.  The attribute, being in the namespace of the Level&nbsp;3
 * package in question, must be prefixed by the XML namespace prefix
 * associated with the package.  The value of the 'required' attribute
 * indicates whether constructs in that package may change the mathematical
 * interpretation of constructs defined in SBML Level&nbsp;3 Core.  A
 * 'required' value of <code>true</code> indicates that the package may do so.  The
 * value of the attribute is set by the Level&nbsp;3 package specification,
 * and does <em>not</em> depend on the actual presence or absence of particular
 * package constructs in a given SBML document: in other words, if the
 * package specification defines any construct that can change the model's
 * meaning, the value of the 'required' attribute must always be set to
 * <code>true</code> in any SBML document that uses the package.
 <p>
 * The XML namespace declaration for an SBML Level&nbsp;3 package is an
 * indication that a model makes use of features defined by that package,
 * while the 'required' attribute indicates whether the features may be
 * ignored without compromising the mathematical meaning of the model.  Both
 * are necessary for a complete reference to an SBML Level&nbsp;3 package.
   <p>
   * @return <code>true</code> if the 'required' attribute of this {@link SBMLDocument}
   * has been set to <code>true</code>, <code>false</code> otherwise.
   */ public
 boolean isSetRequired() {
    return libsbmlJNI.SBMLDocumentPlugin_isSetRequired(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'required' attribute of this {@link SBMLDocumentPlugin}.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * </ul>
   */ public
 int unsetRequired() {
    return libsbmlJNI.SBMLDocumentPlugin_unsetRequired(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean isCompFlatteningImplemented() {
    return libsbmlJNI.SBMLDocumentPlugin_isCompFlatteningImplemented(swigCPtr, this);
  }

  
/** * @internal */ public
 long checkConsistency() {
    return libsbmlJNI.SBMLDocumentPlugin_checkConsistency(swigCPtr, this);
  }

}
